/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import joblib.NDArrayWrapperConstructor;
import joblib.NumpyArrayWrapper;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.Unpickler;
import numpy.core.NDArray;
import org.jpmml.python.CustomPythonObject;
import org.jpmml.python.CustomPythonObjectConstructor;
import org.jpmml.python.CustomUnpickler;
import org.jpmml.python.NamedTuple;
import org.jpmml.python.NamedTupleConstructor;
import org.jpmml.python.NullConstructor;
import org.jpmml.python.PythonObject;
import org.jpmml.python.PythonObjectConstructor;
import org.jpmml.python.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pandas.NDArrayBacked;
import pandas.NDArrayBackedConstructor;

public class PickleUtil {
    private static final Logger logger = LoggerFactory.getLogger(PickleUtil.class);

    private PickleUtil() {
    }

    public static Object unpickle(Storage storage) throws IOException {
        PythonObjectConstructor[] constructors;
        for (PythonObjectConstructor constructor : constructors = new PythonObjectConstructor[]{new NDArrayWrapperConstructor("joblib.numpy_pickle", "NDArrayWrapper", storage), new NDArrayWrapperConstructor("sklearn.externals.joblib.numpy_pickle", "NDArrayWrapper", storage)}) {
            Unpickler.registerConstructor((String)constructor.getModule(), (String)constructor.getName(), (IObjectConstructor)constructor);
        }
        try (final InputStream is = storage.getObject();){
            CustomUnpickler unpickler = new CustomUnpickler(){

                @Override
                protected Object dispatch(short key) throws IOException {
                    Object head;
                    Object result = super.dispatch(key);
                    if (key == 98 && (head = this.stack.peek()) instanceof NumpyArrayWrapper) {
                        NumpyArrayWrapper arrayWrapper = (NumpyArrayWrapper)((Object)head);
                        this.stack.pop();
                        NDArray array = arrayWrapper.toArray(is);
                        this.stack.add((Object)array);
                    }
                    return result;
                }
            };
            Object object = unpickler.load(is);
            return object;
        }
    }

    public static void init(ClassLoader classLoader, String name) {
        Enumeration<URL> urls;
        try {
            urls = classLoader.getResources("META-INF/" + name);
        }
        catch (IOException ioe) {
            logger.warn("Failed to find resources", (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            logger.debug("Loading resource {}", (Object)url);
            try {
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    PickleUtil.init(classLoader, properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Failed to load resource", (Throwable)ioe);
            }
        }
    }

    private static void init(ClassLoader classLoader, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            String value = properties.getProperty(key);
            Collection<String> simpleKeys = PickleUtil.expandComplexKey(key);
            for (String simpleKey : simpleKeys) {
                PickleUtil.init(classLoader, simpleKey, value);
            }
        }
    }

    private static void init(ClassLoader classLoader, String key, String value) {
        if ("null".equals(value)) {
            PickleUtil.registerNullConstructor(key);
        } else {
            PickleUtil.registerClassDictConstructor(classLoader, key, value);
        }
    }

    private static void registerNullConstructor(String key) {
        logger.debug("Mapping Python class {} to null");
        int dot = key.lastIndexOf(46);
        if (dot < 0) {
            logger.warn("Failed to identify the module and name parts of Python class {}", (Object)key);
            return;
        }
        String module = key.substring(0, dot);
        String name = key.substring(dot + 1);
        Unpickler.registerConstructor((String)module, (String)name, (IObjectConstructor)NullConstructor.INSTANCE);
    }

    private static void registerClassDictConstructor(ClassLoader classLoader, String key, String value) {
        PythonObjectConstructor dictConstructor;
        Class<?> clazz;
        if (value == null || "".equals(value)) {
            value = key;
        }
        logger.debug("Mapping Python class {} to Java class {}", (Object)key, (Object)value);
        int dot = key.lastIndexOf(46);
        if (dot < 0) {
            logger.warn("Failed to identify the module and name parts of Python class {}", (Object)key);
            return;
        }
        String module = key.substring(0, dot);
        String name = key.substring(dot + 1);
        try {
            clazz = classLoader.loadClass(value);
        }
        catch (ClassNotFoundException cnfe) {
            logger.warn("Failed to load Java class {}", (Object)value);
            return;
        }
        if (PythonObject.class.isAssignableFrom(clazz)) {
            dictConstructor = CustomPythonObject.class.isAssignableFrom(clazz) ? (NDArrayBacked.class.isAssignableFrom(clazz) ? new NDArrayBackedConstructor(module, name, (Class<? extends NDArrayBacked>)clazz.asSubclass(NDArrayBacked.class)) : new CustomPythonObjectConstructor(module, name, (Class<? extends CustomPythonObject>)clazz.asSubclass(CustomPythonObject.class))) : (NamedTuple.class.isAssignableFrom(clazz) ? new NamedTupleConstructor(module, name, (Class<? extends NamedTuple>)clazz.asSubclass(NamedTuple.class)) : new PythonObjectConstructor(module, name, clazz.asSubclass(PythonObject.class)));
        } else if (PythonObjectConstructor.class.isAssignableFrom(clazz)) {
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class);
                dictConstructor = (PythonObjectConstructor)((Object)constructor.newInstance(module, name));
            }
            catch (ReflectiveOperationException roe) {
                logger.warn("Failed to instantiate Java constructor", (Throwable)roe);
                return;
            }
        } else {
            logger.warn("Failed to identify the type of Java class {}", (Object)value);
            return;
        }
        Unpickler.registerConstructor((String)dictConstructor.getModule(), (String)dictConstructor.getName(), (IObjectConstructor)dictConstructor);
    }

    private static Collection<String> expandComplexKey(String key) {
        String[] strings;
        int begin = key.indexOf(40);
        int end = key.indexOf(41, begin + 1);
        if (begin < 0 || end < 0) {
            return Collections.singletonList(key);
        }
        String prefix = key.substring(0, begin);
        String body = key.substring(begin + 1, end);
        String suffix = key.substring(end + 1);
        ArrayList<String> result = new ArrayList<String>();
        for (String string : strings = body.split("\\|")) {
            result.addAll(PickleUtil.expandComplexKey(prefix + string + suffix));
        }
        return result;
    }
}

