# -*- coding: utf-8 -*-

"""
multipleresponsestestapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from multipleresponsestestapi.api_helper import APIHelper
from multipleresponsestestapi.controllers.send_messages_controller import SendMessagesController


class SendMessagesControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(SendMessagesControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = SendMessagesController(cls.config, cls.response_catcher)

    # You are able to send both the single and multiple messages with this endpoint. Notice for the multiple endpoint use an array in the `to` parameter
    def test_send_both_multiple_and_single_messages(self):

        # Perform the API call through the SDK function
        result = self.controller.multiple_responses_without_range()

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['testheader'] = None

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('[{"from":"Littlecab","to":["+254700000001","+254700000002","+25470'
            '0000003"],"text":"Welcome to our Little world."}]')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))


    # You are able to send both the single and multiple messages with this endpoint. Notice for the multiple endpoint use an array in the `to` parameter
    def test_send_both_multiple_and_single_messages_1(self):

        # Perform the API call through the SDK function
        result = self.controller.multiple_responses_without_range()

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 201)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'
        expected_headers['testheader'] = None

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # You are able to send both the single and multiple messages with this endpoint. Notice for the multiple endpoint use an array in the `to` parameter
    def test_send_both_multiple_and_single_messages_2(self):

        # Perform the API call through the SDK function
        result = self.controller.multiple_responses_without_range()

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 202)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'
        expected_headers['testheader'] = None

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # You are able to send both the single and multiple messages with this endpoint. Notice for the multiple endpoint use an array in the `to` parameter
    def test_send_both_multiple_and_single_messages_1(self):

        # Perform the API call through the SDK function
        result = self.controller.multiple_responses_with_range()

        # Test response code
        self.assertTrue(self.response_catcher.response.status_code in list(range(200, 227)))

        # Test headers
        expected_headers = {}
        expected_headers['testheader'] = None

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('[{"from":"Littlecab","to":["+254700000001","+254700000002","+25470'
            '0000003"],"text":"Welcome to our Little world."}]')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))


