# -*- coding: utf-8 -*-

"""
multipleresponsestestapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from multipleresponsestestapi.api_helper import APIHelper
from multipleresponsestestapi.configuration import Server
from multipleresponsestestapi.controllers.base_controller import BaseController
from multipleresponsestestapi.models.multiple_message_model import MultipleMessageModel
from multipleresponsestestapi.exceptions.failure_response_model_exception import FailureResponseModelException
from multipleresponsestestapi.exceptions.success_response_model_exception import SuccessResponseModelException


class SendMessagesController(BaseController):

    """A Controller to access Endpoints in the multipleresponsestestapi API."""

    def __init__(self, config, call_back=None):
        super(SendMessagesController, self).__init__(config, call_back)

    def multiple_responses_without_range(self):
        """Does a POST request to /message.

        TODO: type endpoint description here.

        Returns:
            list of MultipleMessageModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/message'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 404:
            raise FailureResponseModelException('Not found', _response)
        elif _response.status_code == 500:
            raise FailureResponseModelException('Internal server error', _response)
        elif (_response.status_code < 200) or (_response.status_code > 208):
            raise SuccessResponseModelException('Continue', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, MultipleMessageModel.from_dictionary)

        return decoded

    def multiple_responses_with_range(self):
        """Does a POST request to /message/range.

        TODO: type endpoint description here.

        Returns:
            list of MultipleMessageModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/message/range'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 404:
            raise FailureResponseModelException('Not found', _response)
        elif _response.status_code == 500:
            raise FailureResponseModelException('Internal server error', _response)
        elif (_response.status_code < 200) or (_response.status_code > 208):
            raise SuccessResponseModelException('Continue', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, MultipleMessageModel.from_dictionary)

        return decoded
