//Anime4K v3.0 GLSL

// MIT License

// Copyright (c) 2019-2020 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!SAVE LUMAN0

vec4 hook() {
    vec2 dp = HOOKED_pt;
    float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
    float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
    float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
    float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
    float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
    float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
    float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
    float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
    float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;
    float s = 0.10397486*a + 0.6959855*b + 0.3576091*c + -0.048129864*d + -1.0134345*e + -0.02346323*f + 0.018850459*g + -0.106389955*h + 0.028658116*i + 0.04803684;
    float t = 0.354869*a + -0.39392647*b + 0.003622437*c + -0.18034431*d + 0.88706636*e + -0.31342724*f + -0.022048054*g + -0.3557178*h + 0.0018092435*i + -0.037158098;
    float u = 0.32695425*a + -0.32558918*b + 0.00059630745*c + -0.018950976*d + 0.01774775*e + -0.004043651*f + 0.0027214154*g + -0.0034390602*h + 0.0025048833*i + 0.0007407871;
    float v = -0.071759045*a + -0.42592436*b + -0.14482588*c + 1.5960604*d + -0.63252157*e + -0.36544406*f + -0.15239236*g + 0.12528165*h + 0.08432576*i + -0.08232925;
    return vec4(s, t, u, v);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN0
//!SAVE LUMAN1

#define L_tex LUMAN0_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = 0.06639665*a0.x + 0.28223944*b0.x + 0.004304705*c0.x + -0.32451394*d0.x + 0.43342906*e0.x + -0.024424514*f0.x + -0.49240196*g0.x + -0.88034385*h0.x + -0.12338143*i0.x;
    float j = -0.6820241*a0.y + 0.25317526*b0.y + -0.09791629*c0.y + 0.3271639*d0.y + -0.6224342*e0.y + -0.154204*f0.y + -0.029958222*g0.y + 0.32977268*h0.y + -0.031524904*i0.y;
    float k = 0.6709632*a0.z + -0.24324693*b0.z + -0.049306735*c0.z + -0.8970901*d0.z + 0.56715167*e0.z + -0.14102495*f0.z + -1.0995007*g0.z + 0.5427549*h0.z + 0.36576506*i0.z;
    float l = 0.13722713*a0.w + 0.41282004*b0.w + 0.19782153*c0.w + 0.28570884*d0.w + -0.6406399*e0.w + -0.18080634*f0.w + -0.03796595*g0.w + -0.019462103*h0.w + 0.19691238*i0.w;
    float m = 0.022774132*na0.x + -0.4075716*nb0.x + -0.0019649733*nc0.x + 0.5934201*nd0.x + -0.31279135*ne0.x + -0.009237561*nf0.x + 0.4158437*ng0.x + 0.8021286*nh0.x + 0.11572698*ni0.x;
    float n = 0.6584185*na0.y + -0.43536583*nb0.y + 0.112234406*nc0.y + -0.11827302*nd0.y + 0.47007844*ne0.y + 0.2900137*nf0.y + 0.12348495*ng0.y + -0.6027396*nh0.y + 0.08154192*ni0.y;
    float o = -0.7349083*na0.z + 0.24339297*nb0.z + 0.012427026*nc0.z + 0.9602159*nd0.z + -0.8431948*ne0.z + -0.17023432*nf0.z + 0.7244754*ng0.z + 0.13925964*nh0.z + -0.38444963*ni0.z;
    float p = -0.14070114*na0.w + -0.42214736*nb0.w + -0.0472595*nc0.w + -0.2583746*nd0.w + 0.49701452*ne0.w + 0.072298154*nf0.w + 0.027000604*ng0.w + 0.077047*nh0.w + -0.11605896*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+0.053626187;
    i = 0.06845743*a0.x + 0.7203445*b0.x + -0.009160133*c0.x + -0.47423828*d0.x + 0.0040186336*e0.x + -0.13636078*f0.x + -0.16735902*g0.x + -0.095058076*h0.x + -0.1748559*i0.x;
    j = 0.95788497*a0.y + 0.5390323*b0.y + -0.23857942*c0.y + -0.015868062*d0.y + 0.065215364*e0.y + 0.35074416*f0.y + 0.14792109*g0.y + 0.012528532*h0.y + -0.08329774*i0.y;
    k = -0.8304687*a0.z + -0.2803149*b0.z + 0.8455862*c0.z + -0.31274366*d0.z + 0.49027762*e0.z + -2.568119*f0.z + -0.5816856*g0.z + -0.24438478*h0.z + -1.576034*i0.z;
    l = 0.33903894*a0.w + 0.18856564*b0.w + -0.085718796*c0.w + 0.14994945*d0.w + 0.4343596*e0.w + -0.10266155*f0.w + 0.09709637*g0.w + -0.2009859*h0.w + 0.011091642*i0.w;
    m = 0.11521898*na0.x + -0.3218118*nb0.x + -0.003314331*nc0.x + 0.38280985*nd0.x + -0.9900221*ne0.x + 0.2372697*nf0.x + 0.17255092*ng0.x + 0.20525312*nh0.x + 0.39674228*ni0.x;
    n = -0.47868168*na0.y + -0.8024517*nb0.y + 0.10802533*nc0.y + 0.003150858*nd0.y + 0.17614411*ne0.y + 0.09025896*nf0.y + -0.19619498*ng0.y + 0.06488243*nh0.y + 0.26845673*ni0.y;
    o = 0.8002209*na0.z + 0.73399717*nb0.z + -0.35711604*nc0.z + 0.35695946*nd0.z + -0.87510985*ne0.z + -2.083351*nf0.z + 0.30222148*ng0.z + 0.47206184*nh0.z + -0.4826941*ni0.z;
    p = -0.2594144*na0.w + -0.23693322*nb0.w + 0.09217326*nc0.w + -0.0690688*nd0.w + -0.01309805*ne0.w + 0.06419221*nf0.w + 0.018290445*ng0.w + 0.27774101*nh0.w + 0.108097576*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+0.102133505;
    i = 0.0643423*a0.x + 0.018541882*b0.x + 0.08350226*c0.x + -0.004340104*d0.x + -0.03433379*e0.x + 0.01880579*f0.x + 0.03353465*g0.x + -0.3056104*h0.x + -0.19704679*i0.x;
    j = -0.15946428*a0.y + 0.21165088*b0.y + 0.12410154*c0.y + 0.27272165*d0.y + -0.65606165*e0.y + 0.12557049*f0.y + -0.17287672*g0.y + -0.04488873*h0.y + 0.03603188*i0.y;
    k = 0.062299795*a0.z + -0.14047587*b0.z + 0.024050632*c0.z + 0.31575218*d0.z + 1.8625292*e0.z + -0.43774956*f0.z + 1.5006273*g0.z + 3.9281907*h0.z + -0.13422425*i0.z;
    l = -0.04318438*a0.w + 0.08911396*b0.w + 0.05187426*c0.w + -0.028754652*d0.w + -0.50872475*e0.w + -0.30725425*f0.w + -0.043555077*g0.w + 0.11037375*h0.w + -0.12379002*i0.w;
    m = 0.005490416*na0.x + -0.009724751*nb0.x + -0.06905491*nc0.x + 0.35613546*nd0.x + 0.2776101*ne0.x + -0.13444975*nf0.x + -0.12958236*ng0.x + 0.27827492*nh0.x + 0.19111122*ni0.x;
    n = 0.08052509*na0.y + -0.16101089*nb0.y + -0.11118997*nc0.y + -0.17190972*nd0.y + 0.28470594*ne0.y + -0.02071287*nf0.y + 0.0063910377*ng0.y + 0.13593876*nh0.y + 0.046352968*ni0.y;
    o = -0.13271736*na0.z + -0.010725217*nb0.z + -0.26716524*nc0.z + -0.39615706*nd0.z + -0.7941645*ne0.z + -0.046327833*nf0.z + -0.8656559*ng0.z + 3.0924113*nh0.z + 1.2674434*ni0.z;
    p = 0.1013534*na0.w + -0.06801255*nb0.w + 0.03251423*nc0.w + 0.18332215*nd0.w + 0.12801744*ne0.w + 0.28137314*nf0.w + 0.007990733*ng0.w + -0.2692326*nh0.w + -0.062365714*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.060032938;
    i = 0.117412865*a0.x + -0.22560671*b0.x + -0.14794402*c0.x + 0.34914464*d0.x + 0.45673132*e0.x + -0.35118288*f0.x + 0.33961612*g0.x + 0.11392481*h0.x + -0.13414447*i0.x;
    j = -0.11333446*a0.y + 0.2393889*b0.y + 0.0027701098*c0.y + 0.60629034*d0.y + -0.75975823*e0.y + -0.16403528*f0.y + -0.019105319*g0.y + 0.061169848*h0.y + -0.101013266*i0.y;
    k = 0.076263286*a0.z + -0.553907*b0.z + -0.4970874*c0.z + -1.5819451*d0.z + 0.64838296*e0.z + 1.7086831*f0.z + 0.09729768*g0.z + -1.2366847*h0.z + -0.24660581*i0.z;
    l = 0.08548202*a0.w + -0.17481433*b0.w + -0.34403273*c0.w + 0.012375519*d0.w + 0.08745941*e0.w + -0.070196316*f0.w + 0.00729971*g0.w + 0.29530787*h0.w + -0.21760395*i0.w;
    m = -0.24691077*na0.x + 0.2311278*nb0.x + 0.19753166*nc0.x + -0.404209*nd0.x + 0.18452622*ne0.x + 0.29987976*nf0.x + -0.27267244*ng0.x + -0.14402863*nh0.x + 0.073582985*ni0.x;
    n = -0.083637685*na0.y + 0.019198107*nb0.y + -0.0853492*nc0.y + -0.7212835*nd0.y + 0.742372*ne0.y + -0.32987705*nf0.y + -0.0026051754*ng0.y + 0.015593551*nh0.y + -0.050979447*ni0.y;
    o = -0.02741548*na0.z + 0.2884727*nb0.z + 0.38504106*nc0.z + 1.6370418*nd0.z + -0.31865364*ne0.z + 0.6172546*nf0.z + -0.30839926*ng0.z + -0.37191314*nh0.z + 0.9595531*ni0.z;
    p = -0.12116755*na0.w + 0.18340635*nb0.w + 0.24062845*nc0.w + 0.00054277224*nd0.w + -0.040880762*ne0.w + 0.17774053*nf0.w + -0.044756617*ng0.w + -0.29897058*nh0.w + 0.11243821*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.0830924;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN1
//!SAVE LUMAN2

#define L_tex LUMAN1_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = 0.1296995*a0.x + 0.58585095*b0.x + 0.32923958*c0.x + -0.029538905*d0.x + 0.12424867*e0.x + 0.06688472*f0.x + -0.024876455*g0.x + 0.081395976*h0.x + 0.07730565*i0.x;
    float j = 0.0835473*a0.y + -0.0692147*b0.y + -0.07067511*c0.y + 0.019754365*d0.y + -0.24134408*e0.y + -0.23151338*f0.y + -0.019295152*g0.y + 0.100035846*h0.y + -0.016351536*i0.y;
    float k = -0.050630216*a0.z + -0.033612493*b0.z + -0.19357617*c0.z + -0.07101453*d0.z + 0.17056477*e0.z + 0.060211252*f0.z + 0.0033124269*g0.z + 0.09456133*h0.z + -0.037142575*i0.z;
    float l = 0.051075853*a0.w + 0.2913882*b0.w + 0.058661155*c0.w + 0.22263865*d0.w + -0.23906778*e0.w + -0.14503716*f0.w + 0.082726575*g0.w + 0.11113719*h0.w + 0.14532568*i0.w;
    float m = -0.100905254*na0.x + -0.26352566*nb0.x + -0.24404018*nc0.x + 0.11224881*nd0.x + 0.51329523*ne0.x + -0.053486858*nf0.x + 0.09148782*ng0.x + 0.0037240295*nh0.x + -0.088871725*ni0.x;
    float n = -0.050803714*na0.y + -0.0416797*nb0.y + -0.07453628*nc0.y + -0.23378085*nd0.y + 0.137114*ne0.y + -0.020378582*nf0.y + -0.013943721*ng0.y + -0.12330325*nh0.y + -0.1303406*ni0.y;
    float o = -0.081222475*na0.z + 0.02552934*nb0.z + 0.29423392*nc0.z + -0.010700949*nd0.z + 0.44353056*ne0.z + -0.025496874*nf0.z + -0.0717391*ng0.z + 0.009533622*nh0.z + 0.12127055*ni0.z;
    float p = -0.015820552*na0.w + -0.17862697*nb0.w + -0.02356494*nc0.w + -0.10123709*nd0.w + 0.39525294*ne0.w + 0.15487084*nf0.w + -0.01085165*ng0.w + -0.24515375*nh0.w + -0.06711949*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+-0.030414568;
    i = -0.17145431*a0.x + -0.20274077*b0.x + -0.13539806*c0.x + -0.15229994*d0.x + 0.21967621*e0.x + -0.14581895*f0.x + 0.011627536*g0.x + 0.054711625*h0.x + -0.10415255*i0.x;
    j = -0.032065842*a0.y + 0.01507945*b0.y + 0.014360462*c0.y + -0.07954877*d0.y + 0.4554514*e0.y + -0.02500351*f0.y + 0.09280885*g0.y + 0.08076883*h0.y + 0.012532978*i0.y;
    k = -0.040672652*a0.z + -0.011551944*b0.z + 0.017042167*c0.z + -0.034443982*d0.z + 0.017515173*e0.z + -0.012364212*f0.z + 0.012219225*g0.z + -0.033760473*h0.z + -0.026314916*i0.z;
    l = -0.1833554*a0.w + -0.20858614*b0.w + -0.04312281*c0.w + -0.4133038*d0.w + 0.7893293*e0.w + 0.039180417*f0.w + 0.08793949*g0.w + 0.21557106*h0.w + 0.026690673*i0.w;
    m = -0.05162859*na0.x + -0.058755793*nb0.x + 0.048020624*nc0.x + 0.019536454*nd0.x + -0.4237037*ne0.x + -0.031836376*nf0.x + -0.008829477*ng0.x + -0.11413442*nh0.x + 0.1083338*ni0.x;
    n = 0.13001607*na0.y + 0.14846794*nb0.y + 0.03834157*nc0.y + 0.06404169*nd0.y + -0.5548147*ne0.y + -0.002337565*nf0.y + 0.07660518*ng0.y + 0.2561992*nh0.y + 0.11988241*ni0.y;
    o = 0.039745063*na0.z + -0.08055183*nb0.z + -0.1303704*nc0.z + 0.022918316*nd0.z + -0.056718633*ne0.z + 0.06251301*nf0.z + -0.024526184*ng0.z + -0.15459415*nh0.z + -0.002799402*ni0.z;
    p = 0.21387257*na0.w + 0.29624957*nb0.w + 0.023706648*nc0.w + 0.3816746*nd0.w + -0.6914615*ne0.w + 0.074115634*nf0.w + -0.0032766939*ng0.w + -0.1846047*nh0.w + 0.006624912*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+-0.03056522;
    i = -0.11029118*a0.x + 0.3337483*b0.x + 0.077408336*c0.x + -0.42610714*d0.x + -1.2206199*e0.x + 0.19516373*f0.x + -0.15404113*g0.x + -0.20634995*h0.x + 0.06588952*i0.x;
    j = -0.04082908*a0.y + -0.12006161*b0.y + -0.05597222*c0.y + -0.3542818*d0.y + -0.35644907*e0.y + -0.14614798*f0.y + -0.20449866*g0.y + -0.09893636*h0.y + -0.092030644*i0.y;
    k = 0.1502402*a0.z + 0.1726779*b0.z + 0.062496457*c0.z + 0.28070614*d0.z + 0.016571306*e0.z + 0.12977904*f0.z + 0.037328202*g0.z + 0.06063515*h0.z + 0.22138344*i0.z;
    l = 0.2236037*a0.w + 0.0039381385*b0.w + -0.12040037*c0.w + -0.13418862*d0.w + -0.034812238*e0.w + -0.05243254*f0.w + -0.34639022*g0.w + -0.18946312*h0.w + 0.045312986*i0.w;
    m = -0.30953258*na0.x + -0.8356361*nb0.x + -0.1887177*nc0.x + 0.014400998*nd0.x + -0.3064453*ne0.x + -0.11070782*nf0.x + 0.041681726*ng0.x + -0.11717862*nh0.x + -0.07595453*ni0.x;
    n = -0.01094574*na0.y + -0.0011181692*nb0.y + -0.14214927*nc0.y + 0.27722216*nd0.y + 0.3271789*ne0.y + 0.049340714*nf0.y + -0.030088885*ng0.y + 0.06712784*nh0.y + -0.06951951*ni0.y;
    o = 0.19824019*na0.z + 0.37815058*nb0.z + 0.28591436*nc0.z + 0.13495544*nd0.z + 0.33094874*ne0.z + 0.35384452*nf0.z + 0.30736896*ng0.z + 0.0750831*nh0.z + 0.26549867*ni0.z;
    p = -0.11226634*na0.w + -0.27737*nb0.w + -0.014325423*nc0.w + 0.19669802*nd0.w + 0.1702417*ne0.w + -0.18681495*nf0.w + 0.6464465*ng0.w + 0.51191556*nh0.w + -0.11019807*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.0062645413;
    i = -0.7524125*a0.x + 0.15982255*b0.x + -0.38003713*c0.x + -0.18294491*d0.x + -0.011609704*e0.x + 0.1644678*f0.x + -0.080624536*g0.x + 0.03851575*h0.x + -0.018073043*i0.x;
    j = -0.20548582*a0.y + -0.087626405*b0.y + -0.24111056*c0.y + -0.20929506*d0.y + -0.05862193*e0.y + 0.21097149*f0.y + 0.37784964*g0.y + -0.3371335*h0.y + 0.21661137*i0.y;
    k = -0.056834865*a0.z + 0.07880648*b0.z + 0.24440387*c0.z + 0.035857998*d0.z + -0.05498326*e0.z + -0.016055869*f0.z + -0.24461745*g0.z + -0.04416979*h0.z + -0.008112517*i0.z;
    l = -0.32616344*a0.w + -0.024567882*b0.w + -0.35107398*c0.w + -1.1010243*d0.w + -0.3698656*e0.w + 0.32266977*f0.w + -0.24221507*g0.w + -0.6740687*h0.w + -0.14333092*i0.w;
    m = 0.39440885*na0.x + -0.6442062*nb0.x + 0.13425396*nc0.x + 0.51738626*nd0.x + -0.67044*ne0.x + 0.15458697*nf0.x + -0.09434363*ng0.x + 0.11851308*nh0.x + -0.023352176*ni0.x;
    n = 0.29104593*na0.y + 0.041593533*nb0.y + 0.11439773*nc0.y + -0.003218177*nd0.y + 0.42421842*ne0.y + 0.08495443*nf0.y + -0.3131501*ng0.y + -0.16917372*nh0.y + 0.1289088*ni0.y;
    o = 0.09410875*na0.z + -0.11588178*nb0.z + 0.13947532*nc0.z + 0.23592931*nd0.z + -0.72784305*ne0.z + -0.23903714*nf0.z + 0.08198044*ng0.z + -0.25076246*nh0.z + -0.11394936*ni0.z;
    p = 0.669559*na0.w + -0.025986305*nb0.w + 0.44193423*nc0.w + 1.2048185*nd0.w + 0.7560385*ne0.w + -0.4745804*nf0.w + -0.095279634*ng0.w + 0.7421271*nh0.w + -0.056005523*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.06872939;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN2
//!SAVE LUMAN3

#define L_tex LUMAN2_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = -0.06717315*a0.x + -0.18625546*b0.x + -0.18535699*c0.x + -0.25209853*d0.x + 0.04015934*e0.x + 0.26530865*f0.x + -0.04327326*g0.x + 0.086863905*h0.x + -0.10865201*i0.x;
    float j = 0.31827033*a0.y + 0.22865397*b0.y + 0.028610421*c0.y + 0.6276318*d0.y + 0.22509193*e0.y + 0.1573462*f0.y + 0.10111941*g0.y + 0.1917281*h0.y + -0.14345117*i0.y;
    float k = -0.22344574*a0.z + -0.22601207*b0.z + -0.011553535*c0.z + -0.181191*d0.z + -0.2725799*e0.z + 0.06439458*f0.z + 0.048038308*g0.z + 0.12983559*h0.z + -0.079764694*i0.z;
    float l = -0.016861046*a0.w + -0.019494308*b0.w + -0.017669018*c0.w + -0.06530767*d0.w + 0.09395054*e0.w + 0.061136525*f0.w + -0.04735494*g0.w + 0.18924968*h0.w + -0.023836756*i0.w;
    float m = -0.3547175*na0.x + 0.1358826*nb0.x + 0.07858271*nc0.x + -0.23430872*nd0.x + 0.43895817*ne0.x + -0.22928667*nf0.x + 0.032354854*ng0.x + 0.006439356*nh0.x + 0.062181197*ni0.x;
    float n = -0.2425591*na0.y + 0.08514424*nb0.y + 0.22871092*nc0.y + -0.46338332*nd0.y + 0.5336361*ne0.y + -0.40562704*nf0.y + 0.01311291*ng0.y + -0.06778306*nh0.y + 0.17169508*ni0.y;
    float o = 0.10230756*na0.z + -0.20127158*nb0.z + -0.07916379*nc0.z + -0.07754846*nd0.z + -0.116193995*ne0.z + 0.06341818*nf0.z + -0.00801396*ng0.z + -0.09713724*nh0.z + 0.072695844*ni0.z;
    float p = 0.14998771*na0.w + 0.13864347*nb0.w + 0.068318844*nc0.w + 0.045116886*nd0.w + -0.042385302*ne0.w + -0.12741679*nf0.w + 0.12546733*ng0.w + -0.061053857*nh0.w + 0.013063541*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+-0.025009213;
    i = 0.19007389*a0.x + -0.1583994*b0.x + 0.032637432*c0.x + -0.028661437*d0.x + 0.048821084*e0.x + 0.10179253*f0.x + -0.06565897*g0.x + 0.5590187*h0.x + 0.037958134*i0.x;
    j = 0.12815921*a0.y + 0.17668153*b0.y + -0.12790684*c0.y + 0.1956624*d0.y + 0.97611785*e0.y + 0.060223907*f0.y + 0.14199442*g0.y + 0.102231756*h0.y + 0.117724344*i0.y;
    k = -0.18413326*a0.z + -0.17708266*b0.z + -0.20034097*c0.z + -0.3124793*d0.z + 0.026309077*e0.z + -0.0925308*f0.z + -0.016788289*g0.z + -0.16716176*h0.z + 0.004230467*i0.z;
    l = -0.038007755*a0.w + -0.008115078*b0.w + 0.07480802*c0.w + 0.04666423*d0.w + -0.10847974*e0.w + 0.12687379*f0.w + -0.07406638*g0.w + 0.15683106*h0.w + 0.071306415*i0.w;
    m = -0.3524179*na0.x + -0.08746631*nb0.x + -0.055358827*nc0.x + -0.005121702*nd0.x + 0.2238154*ne0.x + 0.04734714*nf0.x + 0.38855964*ng0.x + -0.61724895*nh0.x + 0.06885853*ni0.x;
    n = -0.14331289*na0.y + -0.2050787*nb0.y + 0.1991135*nc0.y + -0.46040756*nd0.y + -0.6366871*ne0.y + -0.41664663*nf0.y + -0.16958122*ng0.y + -0.3761652*nh0.y + -0.18120718*ni0.y;
    o = 0.11750789*na0.z + -0.013673033*nb0.z + 0.14197573*nc0.z + 0.10468691*nd0.z + 0.0014566277*ne0.z + 0.09031144*nf0.z + 0.0037937157*ng0.z + -0.02874946*nh0.z + -0.026509108*ni0.z;
    p = 0.100215666*na0.w + 0.040169634*nb0.w + 0.013164925*nc0.w + -0.118727714*nd0.w + -0.03184685*ne0.w + -0.14043786*nf0.w + 0.024457283*ng0.w + -0.15660675*nh0.w + -0.05200356*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+0.071153864;
    i = 0.23885481*a0.x + 0.009627908*b0.x + -0.07391904*c0.x + -0.028175073*d0.x + 0.30320242*e0.x + 0.10949589*f0.x + -0.21194275*g0.x + 0.091189414*h0.x + 0.11207269*i0.x;
    j = 0.02364771*a0.y + 0.24171546*b0.y + -0.085548185*c0.y + -0.13059966*d0.y + 0.7769793*e0.y + 0.1368896*f0.y + 0.019515332*g0.y + -0.2813097*h0.y + 0.12159547*i0.y;
    k = 0.31217164*a0.z + 0.41959077*b0.z + 0.1990368*c0.z + 0.17852639*d0.z + 1.0253936*e0.z + 0.12014064*f0.z + 0.030470015*g0.z + 0.116894834*h0.z + 0.12033049*i0.z;
    l = -0.14778642*a0.w + -0.12812881*b0.w + -0.027680345*c0.w + -0.14777774*d0.w + -0.1661101*e0.w + 0.012757367*f0.w + -0.0023989049*g0.w + -0.15380865*h0.w + 0.033649914*i0.w;
    m = 0.332305*na0.x + 0.117145285*nb0.x + 0.31137946*nc0.x + 0.284246*nd0.x + 0.24726851*ne0.x + 0.17240214*nf0.x + 0.15286899*ng0.x + -0.31956202*nh0.x + 0.027743679*ni0.x;
    n = -0.096838504*na0.y + -0.23554324*nb0.y + 0.05768958*nc0.y + 0.25250152*nd0.y + -0.26971808*ne0.y + -0.41672847*nf0.y + 0.1148402*ng0.y + 0.18528111*nh0.y + -0.08624775*ni0.y;
    o = -0.12979779*na0.z + -0.04953356*nb0.z + 0.03002859*nc0.z + 0.06834822*nd0.z + -0.32774958*ne0.z + 0.045808665*nf0.z + -0.050698712*ng0.z + 0.044419024*nh0.z + 0.046608027*ni0.z;
    p = -0.06442882*na0.w + -0.04786282*nb0.w + 0.017273132*nc0.w + 0.18142362*nd0.w + 0.07271175*ne0.w + -0.11233566*nf0.w + -0.06878901*ng0.w + -0.048930436*nh0.w + -0.1138723*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.0014894;
    i = -0.19751294*a0.x + 0.25861272*b0.x + -0.0066198874*c0.x + 0.112890586*d0.x + -0.26875597*e0.x + -0.26113203*f0.x + 0.24095851*g0.x + -0.18970534*h0.x + -0.025890965*i0.x;
    j = 0.019675067*a0.y + -0.07642529*b0.y + 0.159886*c0.y + -0.06923781*d0.y + -0.38018093*e0.y + -0.48206782*f0.y + -0.118144274*g0.y + 0.28994203*h0.y + -0.051686626*i0.y;
    k = 0.034843404*a0.z + -0.21872765*b0.z + 0.01100473*c0.z + 0.11592991*d0.z + -0.7518377*e0.z + -0.42115083*f0.z + -0.0321754*g0.z + 0.20926285*h0.z + -0.17526312*i0.z;
    l = -0.015074366*a0.w + -0.083057426*b0.w + -0.15830547*c0.w + -0.0009947944*d0.w + 0.31531596*e0.w + -0.17569509*f0.w + 0.14843346*g0.w + -0.0026129466*h0.w + 0.05092144*i0.w;
    m = 0.41312754*na0.x + -0.096808426*nb0.x + 0.120561026*nc0.x + -0.003183892*nd0.x + 0.046201833*ne0.x + 0.32055348*nf0.x + -0.53987944*ng0.x + 0.43310902*nh0.x + 0.002572001*ni0.x;
    n = 0.020376818*na0.y + 0.032837477*nb0.y + -0.2895329*nc0.y + 0.19988254*nd0.y + -0.28621992*ne0.y + 0.82064044*nf0.y + 0.073460415*ng0.y + -0.029826678*nh0.y + 0.07131397*ni0.y;
    o = -0.039654482*na0.z + 0.10681176*nb0.z + -0.22279368*nc0.z + -0.037715416*nd0.z + 0.1909092*ne0.z + 0.030304825*nf0.z + -0.02703714*ng0.z + -0.046335116*nh0.z + 0.05017316*ni0.z;
    p = -0.041754566*na0.w + 0.06949629*nb0.w + 0.082980104*nc0.w + 0.056356948*nd0.w + -0.17428519*ne0.w + 0.21060298*nf0.w + -0.07780234*ng0.w + 0.07410131*nh0.w + -0.025585834*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.0040146387;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN3
//!SAVE LUMAN4

#define L_tex LUMAN3_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = -0.13935597*a0.x + -0.11091113*b0.x + -0.03688676*c0.x + 0.28064582*d0.x + 0.19852728*e0.x + 0.0315579*f0.x + -0.17065585*g0.x + -0.2283964*h0.x + 0.14495629*i0.x;
    float j = -0.16179775*a0.y + 0.16048649*b0.y + -0.370548*c0.y + -0.35172173*d0.y + 0.48003772*e0.y + -0.105164304*f0.y + 0.093682155*g0.y + -0.3915796*h0.y + -0.26049125*i0.y;
    float k = -0.19633873*a0.z + -0.21336922*b0.z + 0.013648553*c0.z + 0.39576057*d0.z + -0.29565853*e0.z + -0.011219808*f0.z + -0.0716942*g0.z + -0.19690439*h0.z + -0.09431168*i0.z;
    float l = -0.05934762*a0.w + 0.08727595*b0.w + 0.12611376*c0.w + 0.14969496*d0.w + 0.72159785*e0.w + 0.122124545*f0.w + 0.21124533*g0.w + -0.12930311*h0.w + 0.253542*i0.w;
    float m = 0.12843879*na0.x + -0.020566197*nb0.x + -0.0660588*nc0.x + -0.66884834*nd0.x + 0.06484056*ne0.x + 0.023970712*nf0.x + 0.23006171*ng0.x + 0.33466932*nh0.x + -0.29759154*ni0.x;
    float n = 0.059693146*na0.y + -0.045831673*nb0.y + 0.05568022*nc0.y + 0.084064946*nd0.y + -0.97029793*ne0.y + -0.013524799*nf0.y + -0.18485625*ng0.y + -0.12563172*nh0.y + -0.047100443*ni0.y;
    float o = 0.13252054*na0.z + 0.25632593*nb0.z + -0.20554997*nc0.z + 0.13906007*nd0.z + 0.3876675*ne0.z + 0.05157098*nf0.z + 0.01824493*ng0.z + 0.3791039*nh0.z + -0.24203013*ni0.z;
    float p = 0.42681953*na0.w + 0.37215272*nb0.w + 0.14401126*nc0.w + 0.22729643*nd0.w + -0.4240743*ne0.w + 0.01858027*nf0.w + 0.05341485*ng0.w + 0.27715722*nh0.w + -0.05586885*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+-0.101345845;
    i = 0.06435059*a0.x + -0.05780327*b0.x + -0.13576104*c0.x + 0.10006792*d0.x + 0.06577253*e0.x + 0.2616236*f0.x + -0.116230436*g0.x + -0.12689975*h0.x + 0.13806346*i0.x;
    j = 0.047965724*a0.y + 0.46820837*b0.y + 0.27155674*c0.y + 0.02126596*d0.y + -0.67418236*e0.y + 0.04438237*f0.y + 0.027345048*g0.y + -0.07970538*h0.y + -0.078592815*i0.y;
    k = 0.13051371*a0.z + 0.039749797*b0.z + 0.080169655*c0.z + 0.117129445*d0.z + 0.066928*e0.z + -0.09933843*f0.z + -0.10919095*g0.z + -0.019560996*h0.z + -0.112840146*i0.z;
    l = 0.08679252*a0.w + 0.21411163*b0.w + -0.028519686*c0.w + 0.18093598*d0.w + -0.7020097*e0.w + 0.023516914*f0.w + -0.020827917*g0.w + 0.015421594*h0.w + 0.009241537*i0.w;
    m = -0.077041484*na0.x + 0.059386946*nb0.x + 0.13958155*nc0.x + -0.19068196*nd0.x + -0.28006217*ne0.x + -0.41987765*nf0.x + 0.12358269*ng0.x + -0.014031638*nh0.x + 0.006307132*ni0.x;
    n = -0.035933975*na0.y + -0.3855368*nb0.y + -0.18497427*nc0.y + -0.040697515*nd0.y + 0.7990711*ne0.y + -0.08418051*nf0.y + 0.034800954*ng0.y + 0.012859377*nh0.y + 0.076540396*ni0.y;
    o = -0.09628029*na0.z + -0.0017863213*nb0.z + -0.016388003*nc0.z + 0.13073064*nd0.z + 0.35412386*ne0.z + 0.33087295*nf0.z + -0.002519779*ng0.z + -0.050436858*nh0.z + 0.06708438*ni0.z;
    p = -0.047076955*na0.w + -0.1717576*nb0.w + 0.06098623*nc0.w + -0.04829171*nd0.w + 0.97778696*ne0.w + 0.0683018*nf0.w + 0.0480603*ng0.w + -0.115571074*nh0.w + -0.0324209*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+0.03690847;
    i = -0.04003973*a0.x + 0.08684451*b0.x + 0.056973178*c0.x + 0.12580861*d0.x + -0.70770407*e0.x + -0.26232213*f0.x + -0.14605756*g0.x + 0.2185047*h0.x + 0.16081442*i0.x;
    j = 0.22752708*a0.y + 0.14125547*b0.y + 0.21185426*c0.y + 0.20745178*d0.y + 1.6950947*e0.y + 0.32192886*f0.y + -0.010275441*g0.y + 0.20508891*h0.y + 0.23286316*i0.y;
    k = 0.026558029*a0.z + 0.27036312*b0.z + 0.06793841*c0.z + 0.021423433*d0.z + 0.1314685*e0.z + 0.046734232*f0.z + -0.11433229*g0.z + 0.21536611*h0.z + -0.0028018088*i0.z;
    l = 0.19790274*a0.w + 0.08455251*b0.w + -0.042842302*c0.w + 0.06765321*d0.w + 0.80784225*e0.w + 0.17140552*f0.w + -0.036292873*g0.w + 0.1945151*h0.w + 0.029864661*i0.w;
    m = 0.019306317*na0.x + -0.08108237*nb0.x + -0.060932275*nc0.x + -0.07590298*nd0.x + 0.36097065*ne0.x + -0.49187797*nf0.x + 0.042565785*ng0.x + -0.18200454*nh0.x + -0.042538855*ni0.x;
    n = -0.1909921*na0.y + -0.24054891*nb0.y + -0.2331106*nc0.y + 0.06388691*nd0.y + -1.3733596*ne0.y + -0.3168477*nf0.y + -0.018475877*ng0.y + -0.27689803*nh0.y + -0.17154175*ni0.y;
    o = 0.03147376*na0.z + -0.07079819*nb0.z + 0.037092578*nc0.z + 0.059319854*nd0.z + 0.058872327*ne0.z + -0.2145504*nf0.z + 0.16398452*ng0.z + 0.0017471232*nh0.z + 0.26451096*ni0.z;
    p = -0.19085382*na0.w + -0.18272428*nb0.w + -0.02961356*nc0.w + 0.07483331*nd0.w + -0.53736925*ne0.w + -0.031511623*nf0.w + 0.09394558*ng0.w + -0.38817772*nh0.w + -0.17405929*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.19037424;
    i = 0.080417514*a0.x + 0.014180711*b0.x + 0.11582896*c0.x + -0.016692005*d0.x + -0.17195204*e0.x + -0.011422261*f0.x + 0.03137781*g0.x + 0.3729293*h0.x + -0.09650351*i0.x;
    j = 0.43793023*a0.y + -0.5691589*b0.y + 0.25009406*c0.y + 0.36788806*d0.y + 1.1486416*e0.y + -0.11426902*f0.y + -0.10744571*g0.y + 0.5247666*h0.y + 0.26761994*i0.y;
    k = 0.19873822*a0.z + 0.3752259*b0.z + -0.13712035*c0.z + -0.24905545*d0.z + 0.6611504*e0.z + 0.10681574*f0.z + -0.04248269*g0.z + 0.34954542*h0.z + 0.00978403*i0.z;
    l = 0.34088975*a0.w + -0.3931476*b0.w + -0.1533515*c0.w + -0.10607013*d0.w + 0.06654374*e0.w + -0.07201185*f0.w + -0.29845902*g0.w + 0.25622308*h0.w + -0.31139874*i0.w;
    m = -0.078585304*na0.x + 0.036581147*nb0.x + -0.13068384*nc0.x + 0.3932218*nd0.x + 0.0708958*ne0.x + -0.12966925*nf0.x + -0.109731354*ng0.x + -0.31248894*nh0.x + 0.37464958*ni0.x;
    n = -0.41372105*na0.y + 0.32846758*nb0.y + -0.060158603*nc0.y + -0.128198*nd0.y + -0.18438801*ne0.y + 0.18057844*nf0.y + 0.16595858*ng0.y + -0.16415259*nh0.y + 0.0032799111*ni0.y;
    o = -0.06727605*na0.z + -0.24573149*nb0.z + 0.230882*nc0.z + -0.1278132*nd0.z + -0.8236421*ne0.z + -0.05967563*nf0.z + 0.14988032*ng0.z + -0.2628639*nh0.z + 0.22783533*ni0.z;
    p = -0.7405207*na0.w + 0.008293306*nb0.w + -0.044343967*nc0.w + -0.30809087*nd0.w + -0.5533927*ne0.w + -0.062474877*nf0.w + 0.11649958*ng0.w + -0.5585487*nh0.w + 0.07918267*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+0.03127807;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN4
//!SAVE LUMAN5

#define L_tex LUMAN4_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = -0.09597852*a0.x + 0.3242088*b0.x + -0.124179676*c0.x + 0.226565*d0.x + -0.31539622*e0.x + 0.10865023*f0.x + 0.012854597*g0.x + 0.18704954*h0.x + 0.019613743*i0.x;
    float j = -0.2956743*a0.y + 0.45493945*b0.y + -0.07076282*c0.y + -0.30141243*d0.y + 0.174262*e0.y + -0.02470263*f0.y + 0.08572248*g0.y + -0.019336598*h0.y + 0.09933937*i0.y;
    float k = 0.07753791*a0.z + -0.3395634*b0.z + 0.19251195*c0.z + -0.10877227*d0.z + -0.014677417*e0.z + -0.110752806*f0.z + -0.022234734*g0.z + 0.0043019606*h0.z + -0.00083276356*i0.z;
    float l = -0.037600517*a0.w + 0.124577194*b0.w + -0.28245094*c0.w + 0.09897185*d0.w + -0.56897277*e0.w + 0.016489267*f0.w + 0.07564196*g0.w + 0.14769527*h0.w + 0.044005074*i0.w;
    float m = 0.00643241*na0.x + -0.32315695*nb0.x + 0.11598279*nc0.x + -0.20983832*nd0.x + 0.258951*ne0.x + -0.025683874*nf0.x + -0.0635544*ng0.x + -0.2206535*nh0.x + -0.10333466*ni0.x;
    float n = 0.21132493*na0.y + -0.3065043*nb0.y + 0.17681308*nc0.y + 0.2733732*nd0.y + -0.08235636*ne0.y + -0.10921411*nf0.y + -0.11584987*ng0.y + -0.024039356*nh0.y + -0.062137943*ni0.y;
    float o = -0.059854202*na0.z + 0.18879688*nb0.z + -0.123816796*nc0.z + 0.25184757*nd0.z + -0.32263234*ne0.z + 0.15706868*nf0.z + 0.02998877*ng0.z + 0.053161293*nh0.z + -0.0017673605*ni0.z;
    float p = 0.05801878*na0.w + -0.042743735*nb0.w + 0.026558312*nc0.w + -0.04256158*nd0.w + 0.4289233*ne0.w + -0.0007625228*nf0.w + -0.038216792*ng0.w + -0.116650924*nh0.w + 0.06503088*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+-0.0019418459;
    i = 0.054116286*a0.x + 0.010684147*b0.x + 0.082293995*c0.x + -0.032138538*d0.x + 0.36239687*e0.x + -0.012221512*f0.x + 0.044298165*g0.x + -0.014412877*h0.x + -0.0063282046*i0.x;
    j = 0.11786986*a0.y + -0.011583431*b0.y + 0.12155917*c0.y + 0.12135634*d0.y + -0.3782435*e0.y + 0.104112595*f0.y + 0.1437231*g0.y + -0.011320157*h0.y + 0.060530275*i0.y;
    k = -0.003993353*a0.z + 0.022192514*b0.z + -0.0034327002*c0.z + 0.002901846*d0.z + 0.42262754*e0.z + -0.0020970134*f0.z + 0.022101413*g0.z + -0.031948846*h0.z + 0.1050437*i0.z;
    l = 0.015842827*a0.w + 0.0798861*b0.w + 0.08568371*c0.w + 0.04673564*d0.w + 0.094226986*e0.w + 0.06733949*f0.w + -0.0060305153*g0.w + 0.15045756*h0.w + -0.03379621*i0.w;
    m = -0.06038104*na0.x + -0.034142923*nb0.x + -0.05546382*nc0.x + -0.018901724*nd0.x + -0.18012096*ne0.x + -0.00062798214*nf0.x + 0.009348149*ng0.x + -0.014474368*nh0.x + 0.04329652*ni0.x;
    n = -0.059717417*na0.y + 0.119962394*nb0.y + -0.064958826*nc0.y + -0.11596286*nd0.y + 0.39725938*ne0.y + -0.114478305*nf0.y + -0.018322872*ng0.y + -0.006377172*nh0.y + 0.06362352*ni0.y;
    o = 0.0054720687*na0.z + -0.030189699*nb0.z + -0.015235566*nc0.z + -0.03068064*nd0.z + -0.11610397*ne0.z + -0.03191193*nf0.z + -0.0356475*ng0.z + 0.030068565*nh0.z + -0.050685633*ni0.z;
    p = -0.046274967*na0.w + -0.099142164*nb0.w + -0.085632615*nc0.w + -0.038272157*nd0.w + -0.19368412*ne0.w + 0.0003223275*nf0.w + -0.085437156*ng0.w + -0.12736909*nh0.w + -0.05320479*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+0.078778625;
    i = 0.08257098*a0.x + -0.0022579352*b0.x + -0.012156828*c0.x + 0.072632305*d0.x + -0.6072154*e0.x + -0.17004661*f0.x + 0.016802631*g0.x + -0.22717783*h0.x + -0.061564326*i0.x;
    j = 0.045760617*a0.y + 0.061521515*b0.y + -0.029007988*c0.y + 0.015811957*d0.y + 0.11330114*e0.y + 0.009119976*f0.y + -0.16409592*g0.y + 0.029125696*h0.y + -0.35173532*i0.y;
    k = -0.045531336*a0.z + -0.017925687*b0.z + -0.104570106*c0.z + 0.103260145*d0.z + 0.085039206*e0.z + 0.06908408*f0.z + -0.07742414*g0.z + 0.33436036*h0.z + -0.078238*i0.z;
    l = 0.012518328*a0.w + -0.043969885*b0.w + 0.0506132*c0.w + -0.17977312*d0.w + -0.1145595*e0.w + -0.1745484*f0.w + 0.20776495*g0.w + -0.56244034*h0.w + -0.07415478*i0.w;
    m = -0.0675551*na0.x + 0.05070468*nb0.x + 0.08408123*nc0.x + 0.10902953*nd0.x + 0.26186886*ne0.x + 0.16379848*nf0.x + -0.005975606*ng0.x + 0.40121752*nh0.x + 0.1860966*ni0.x;
    n = -0.034864623*na0.y + -0.015901396*nb0.y + -0.056751534*nc0.y + 0.224934*nd0.y + -0.06753463*ne0.y + 0.051636614*nf0.y + 0.18318632*ng0.y + 0.53643245*nh0.y + 0.6492825*ni0.y;
    o = -0.03634967*na0.z + -0.0062806685*nb0.z + 0.06752919*nc0.z + -0.04426068*nd0.z + -0.25008643*ne0.z + -0.08242178*nf0.z + 0.06756477*ng0.z + -0.2764806*nh0.z + 0.03919717*ni0.z;
    p = 0.10824321*na0.w + 0.0719615*nb0.w + 0.022836633*nc0.w + 0.032870874*nd0.w + 0.07953821*ne0.w + 0.20360455*nf0.w + -0.09071379*ng0.w + 0.15641631*nh0.w + 0.108754955*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.0703419;
    i = 0.054530073*a0.x + -0.35720757*b0.x + 0.09167906*c0.x + 0.39694676*d0.x + 0.26749727*e0.x + 0.28771624*f0.x + 0.5681281*g0.x + -0.23950431*h0.x + -0.102100216*i0.x;
    j = -0.5799231*a0.y + -0.90738946*b0.y + 0.4949409*c0.y + -0.04932236*d0.y + 0.7942325*e0.y + 0.35240924*f0.y + 0.2044775*g0.y + 0.6994759*h0.y + 0.019353973*i0.y;
    k = 0.3347879*a0.z + 0.5091003*b0.z + -0.17031951*c0.z + 0.123048164*d0.z + 0.64878803*e0.z + -0.36329588*f0.z + -0.46817833*g0.z + 0.2079882*h0.z + -0.05412046*i0.z;
    l = -0.6893422*a0.w + -0.2170392*b0.w + 0.027153356*c0.w + 0.7168854*d0.w + -0.26940683*e0.w + -0.58671874*f0.w + 0.23477685*g0.w + -0.26849586*h0.w + 0.30201417*i0.w;
    m = 0.78675926*na0.x + 0.29757124*nb0.x + -0.20282929*nc0.x + -1.0505095*nd0.x + 0.58935297*ne0.x + -0.10334289*nf0.x + -0.2843835*ng0.x + 0.059788395*nh0.x + 0.011678273*ni0.x;
    n = 0.34996793*na0.y + 0.24947307*nb0.y + -0.29364213*nc0.y + 0.20136362*nd0.y + -0.2727407*ne0.y + -0.43054128*nf0.y + -0.32888436*ng0.y + -0.7454652*nh0.y + 0.4059068*ni0.y;
    o = -0.07356504*na0.z + -0.35029906*nb0.z + 0.09862612*nc0.z + 0.06451627*nd0.z + 0.15965298*ne0.z + 0.043233983*nf0.z + 0.29421222*ng0.z + -0.38419172*nh0.z + -0.05866892*ni0.z;
    p = 0.3664988*na0.w + 0.3596013*nb0.w + -0.12897122*nc0.w + 0.14208052*nd0.w + 0.089192405*ne0.w + 0.27535722*nf0.w + -0.3438804*ng0.w + -0.079981126*nh0.w + 0.045426715*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+0.1524787;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN5
//!SAVE LUMAN6

#define L_tex LUMAN5_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = 0.04046324*a0.x + 0.014735389*b0.x + -0.0002682781*c0.x + -0.039319854*d0.x + 0.22058657*e0.x + 0.07695267*f0.x + 0.077418946*g0.x + 0.13325845*h0.x + 0.038691103*i0.x;
    float j = 0.040963832*a0.y + 0.105689086*b0.y + 0.033340584*c0.y + 0.1200134*d0.y + 1.2192141*e0.y + 0.18370426*f0.y + 0.03399801*g0.y + 0.13453613*h0.y + -0.009928808*i0.y;
    float k = 0.08902621*a0.z + -0.085483715*b0.z + 0.052993882*c0.z + -0.10525024*d0.z + 0.0610996*e0.z + -0.026467444*f0.z + 0.018025948*g0.z + -0.00589767*h0.z + 0.024196783*i0.z;
    float l = 0.009467872*a0.w + -0.015330612*b0.w + 0.0030996029*c0.w + -0.0076471744*d0.w + -0.020749047*e0.w + 0.022791933*f0.w + -0.016549883*g0.w + 0.019890876*h0.w + -0.0010098215*i0.w;
    float m = -0.02717888*na0.x + 0.0036335315*nb0.x + -0.019823067*nc0.x + 0.004060834*nd0.x + 0.022675946*ne0.x + -0.03507232*nf0.x + -0.0029503133*ng0.x + -0.025005482*nh0.x + -0.01091259*ni0.x;
    float n = -0.030934187*na0.y + -0.03229802*nb0.y + -0.0065935743*nc0.y + 0.025710566*nd0.y + -0.8996815*ne0.y + -0.1178852*nf0.y + 0.0017351187*ng0.y + -0.013789157*nh0.y + -0.019477608*ni0.y;
    float o = 0.013771308*na0.z + 0.06256136*nb0.z + -0.027475204*nc0.z + -0.0023379435*nd0.z + -0.0824879*ne0.z + -0.013148455*nf0.z + -0.013476471*ng0.z + 0.036603387*nh0.z + 0.04276819*ni0.z;
    float p = -0.0052243336*na0.w + 0.0011435063*nb0.w + -0.010922929*nc0.w + 0.012664938*nd0.w + -0.13092975*ne0.w + -0.03561616*nf0.w + 0.012207904*ng0.w + -0.007603144*nh0.w + -0.055635393*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+0.0048964093;
    i = -0.39574856*a0.x + -0.1648057*b0.x + 0.048852682*c0.x + -0.8832539*d0.x + -1.3857893*e0.x + 0.10910333*f0.x + 0.24659039*g0.x + -0.83078027*h0.x + -0.20966282*i0.x;
    j = -0.4591745*a0.y + -0.29594332*b0.y + 0.11969786*c0.y + 0.55155253*d0.y + -0.6095633*e0.y + -0.01989395*f0.y + -0.087100305*g0.y + 0.21315934*h0.y + -0.24447405*i0.y;
    k = -0.18299514*a0.z + 0.09148732*b0.z + 0.074729174*c0.z + 0.01451769*d0.z + -0.16411151*e0.z + -0.046350308*f0.z + -0.08558227*g0.z + 0.26311517*h0.z + -0.13392153*i0.z;
    l = -0.0327498*a0.w + 0.07924664*b0.w + 0.020369893*c0.w + 0.00036012995*d0.w + 0.18644504*e0.w + 0.021062836*f0.w + -0.0047752066*g0.w + -0.019535767*h0.w + 0.009709619*i0.w;
    m = 0.13288204*na0.x + 0.029656962*nb0.x + 0.07311512*nc0.x + 0.14313999*nd0.x + 0.56644523*ne0.x + 0.14797804*nf0.x + 0.12596226*ng0.x + 0.22742471*nh0.x + 0.089742064*ni0.x;
    n = 0.1892585*na0.y + 0.023231648*nb0.y + -0.18776754*nc0.y + -0.7594511*nd0.y + 0.8324623*ne0.y + 0.015639866*nf0.y + 0.13374005*ng0.y + -0.32821357*nh0.y + 0.11980797*ni0.y;
    o = 0.50891566*na0.z + -0.061541505*nb0.z + -0.22972333*nc0.z + 0.21540114*nd0.z + -0.18484059*ne0.z + -0.025804685*nf0.z + 0.0028910888*ng0.z + -0.1935325*nh0.z + 0.31634408*ni0.z;
    p = 0.0014322877*na0.w + -0.015277725*nb0.w + 0.0017917431*nc0.w + 0.1006944*nd0.w + 0.18176948*ne0.w + 0.014831943*nf0.w + 0.1483141*ng0.w + 0.081011966*nh0.w + 0.09606741*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+-0.07033543;
    i = 0.46537486*a0.x + 0.35346523*b0.x + -0.034309685*c0.x + -0.43613064*d0.x + -0.8117452*e0.x + -0.14820647*f0.x + -0.36851904*g0.x + 0.36691928*h0.x + 0.09633467*i0.x;
    j = 0.03274515*a0.y + 0.12292336*b0.y + -0.1621055*c0.y + -0.37666368*d0.y + 0.9280238*e0.y + 0.03958912*f0.y + 0.17052563*g0.y + 0.09307256*h0.y + -0.11879444*i0.y;
    k = 0.011698497*a0.z + -0.19269797*b0.z + -0.16302618*c0.z + 0.037150856*d0.z + -0.16392735*e0.z + -0.12373209*f0.z + -0.18614432*g0.z + -0.12011694*h0.z + 0.09273491*i0.z;
    l = -0.046311308*a0.w + 0.04476493*b0.w + -0.041215967*c0.w + 0.018216522*d0.w + 0.11473393*e0.w + -0.10053504*f0.w + -0.060967118*g0.w + -0.03618437*h0.w + 0.001688976*i0.w;
    m = -0.24747224*na0.x + -0.0076296516*nb0.x + 0.1111047*nc0.x + 0.3819905*nd0.x + 0.3970804*ne0.x + 0.3104748*nf0.x + -0.051673863*ng0.x + -0.049815454*nh0.x + -0.12487531*ni0.x;
    n = -0.13329297*na0.y + -0.06950387*nb0.y + -0.1768481*nc0.y + 0.21811922*nd0.y + 0.378857*ne0.y + -0.21782632*nf0.y + -0.116539694*ng0.y + 0.17979085*nh0.y + 0.18095481*ni0.y;
    o = 0.43092886*na0.z + 0.4126806*nb0.z + 0.40301523*nc0.z + 0.4705472*nd0.z + 0.57200426*ne0.z + 0.60878164*nf0.z + -0.06799496*ng0.z + 0.10386602*nh0.z + -0.18540111*ni0.z;
    p = 0.041190043*na0.w + 0.14185017*nb0.w + 0.09648255*nc0.w + 0.09766787*nd0.w + -0.37151045*ne0.w + -0.03486635*nf0.w + 0.14197278*ng0.w + 0.29088745*nh0.w + 0.16969803*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.16171035;
    i = 0.4303196*a0.x + 0.064631134*b0.x + -0.039682325*c0.x + 0.25032383*d0.x + -0.7347892*e0.x + 0.26412666*f0.x + -0.08636694*g0.x + -0.40137205*h0.x + 0.052083053*i0.x;
    j = 0.2614006*a0.y + 0.14647369*b0.y + -0.014280629*c0.y + -0.6632378*d0.y + -1.3091056*e0.y + 0.00048285414*f0.y + 0.33573303*g0.y + 0.9322179*h0.y + 0.25560188*i0.y;
    k = 0.30360696*a0.z + 0.21467467*b0.z + -0.044186305*c0.z + -0.3108944*d0.z + -0.7687483*e0.z + -0.053097602*f0.z + 0.073559746*g0.z + -0.05820314*h0.z + -0.06039339*i0.z;
    l = 0.012419113*a0.w + -0.041542303*b0.w + -0.0030724593*c0.w + 0.10136853*d0.w + -0.059104513*e0.w + -0.029450646*f0.w + 0.0037148865*g0.w + 0.026545389*h0.w + 0.023753045*i0.w;
    m = -0.27366745*na0.x + 0.026242163*nb0.x + 0.10695166*nc0.x + 0.024651896*nd0.x + -0.067803666*ne0.x + 0.21709773*nf0.x + 0.17141151*ng0.x + 0.39313924*nh0.x + 0.05491188*ni0.x;
    n = -0.24999681*na0.y + -0.0149813965*nb0.y + -0.11390382*nc0.y + 0.38644975*nd0.y + 1.091798*ne0.y + 0.049615655*nf0.y + -0.3450869*ng0.y + -0.66309226*nh0.y + -0.18472806*ni0.y;
    o = 0.22231762*na0.z + 0.17065015*nb0.z + 0.15852334*nc0.z + 0.2802539*nd0.z + 1.3999426*ne0.z + -0.07246133*nf0.z + 0.20702864*ng0.z + 0.39279854*nh0.z + 0.2664954*ni0.z;
    p = 0.004953836*na0.w + 0.13166036*nb0.w + 0.039747827*nc0.w + -0.092738666*nd0.w + -0.16943815*ne0.w + -0.07694382*nf0.w + -0.15704772*ng0.w + 0.00020125543*nh0.w + -0.0033851033*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.19337739;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN6
//!SAVE LUMAN7

#define L_tex LUMAN6_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = -0.027537398*a0.x + -0.03832216*b0.x + -0.1591863*c0.x + -0.26930097*d0.x + 1.496357*e0.x + -0.732409*f0.x + -0.08807835*g0.x + -0.3267168*h0.x + -0.027697973*i0.x;
    float j = 0.045650784*a0.y + 0.07423937*b0.y + -0.28104565*c0.y + -0.16404267*d0.y + -0.27688447*e0.y + 0.1753845*f0.y + 0.08667494*g0.y + -0.24310407*h0.y + -0.2387649*i0.y;
    float k = 0.011307029*a0.z + -0.15920246*b0.z + 0.1749019*c0.z + 0.0864728*d0.z + 0.32644588*e0.z + -0.021537697*f0.z + 0.052467912*g0.z + 0.04679955*h0.z + 0.047825363*i0.z;
    float l = -0.022269413*a0.w + 0.33980212*b0.w + 0.16864336*c0.w + 0.082288966*d0.w + -0.06350156*e0.w + 0.13752197*f0.w + 0.042304493*g0.w + 0.15443622*h0.w + 0.046571467*i0.w;
    float m = 0.0038585584*na0.x + -0.036202244*nb0.x + -0.29005575*nc0.x + -0.06418919*nd0.x + -1.419668*ne0.x + 0.14456362*nf0.x + -0.005725012*ng0.x + 0.5045954*nh0.x + 0.11732795*ni0.x;
    float n = -0.16101104*na0.y + -0.02420836*nb0.y + 0.13611177*nc0.y + 0.029370116*nd0.y + 1.1994928*ne0.y + -0.15178941*nf0.y + 0.0090092765*ng0.y + -0.20478143*nh0.y + -0.17148101*ni0.y;
    float o = -0.053002063*na0.z + -0.035893742*nb0.z + -0.110651344*nc0.z + -0.37151214*nd0.z + -0.9576195*ne0.z + -0.46538743*nf0.z + 0.17428482*ng0.z + 0.25815699*nh0.z + 0.14889659*ni0.z;
    float p = -0.2277235*na0.w + -0.6884181*nb0.w + -0.63734025*nc0.w + -0.13596478*nd0.w + -0.55789053*ne0.w + -0.3439862*nf0.w + -0.059143618*ng0.w + 0.030058485*nh0.w + 0.10810205*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+0.39991605;
    i = -0.28546834*a0.x + 0.06982972*b0.x + 0.36571932*c0.x + 0.025255322*d0.x + 0.4913122*e0.x + -0.54014283*f0.x + -0.04262618*g0.x + -0.014767507*h0.x + 0.1157787*i0.x;
    j = -0.033387233*a0.y + 0.1438295*b0.y + 0.043908857*c0.y + 0.23875113*d0.y + 0.23944983*e0.y + 0.38140768*f0.y + 0.10405573*g0.y + -0.28033695*h0.y + 0.19296218*i0.y;
    k = 0.0795919*a0.z + -0.009298124*b0.z + -0.1966298*c0.z + -0.10623091*d0.z + -0.13389623*e0.z + -0.20906673*f0.z + 0.012903121*g0.z + 0.13463002*h0.z + 0.0069053117*i0.z;
    l = 0.07620989*a0.w + 0.444145*b0.w + 0.21698916*c0.w + -0.059253845*d0.w + 0.33355483*e0.w + 0.25932938*f0.w + -0.13568759*g0.w + -0.12767054*h0.w + -0.051579196*i0.w;
    m = 0.10081049*na0.x + -0.34150627*nb0.x + -0.035512667*nc0.x + -0.29685998*nd0.x + 1.7315077*ne0.x + 0.28415534*nf0.x + 0.0022732737*ng0.x + -0.61264104*nh0.x + -0.16202453*ni0.x;
    n = 0.062643774*na0.y + 0.2885083*nb0.y + -0.027835878*nc0.y + -0.029790701*nd0.y + -0.5481254*ne0.y + -0.2478993*nf0.y + -0.033092864*ng0.y + 0.33226776*nh0.y + 0.22110416*ni0.y;
    o = -0.26636478*na0.z + -0.10020174*nb0.z + 0.24355102*nc0.z + -0.15196387*nd0.z + 0.25725785*ne0.z + -0.105960734*nf0.z + -0.053724907*ng0.z + -0.61655164*nh0.z + -0.3888296*ni0.z;
    p = 0.05319454*na0.w + -0.3448596*nb0.w + 0.02398366*nc0.w + 0.17685084*nd0.w + 0.088528976*ne0.w + -0.006480539*nf0.w + 0.22043355*ng0.w + -0.11913634*nh0.w + -0.24229069*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+0.0698082;
    i = -0.29397583*a0.x + 0.1783425*b0.x + -0.016915536*c0.x + 0.18143447*d0.x + 0.050463*e0.x + -0.5750633*f0.x + -0.09805144*g0.x + -0.23439899*h0.x + 0.014174429*i0.x;
    j = 0.030622737*a0.y + 0.09131598*b0.y + -0.27484027*c0.y + -0.042807933*d0.y + -0.49584112*e0.y + 0.47780067*f0.y + 0.07179059*g0.y + -0.21984039*h0.y + -0.25448912*i0.y;
    k = 0.064491056*a0.z + -0.04929943*b0.z + 0.03411262*c0.z + 0.02332043*d0.z + 0.259224*e0.z + -0.16006759*f0.z + 0.052105837*g0.z + 0.15662266*h0.z + 0.05741607*i0.z;
    l = 0.03419898*a0.w + 0.27976283*b0.w + 0.19813572*c0.w + -0.03766979*d0.w + -0.0044533233*e0.w + 0.2983032*f0.w + -0.07778916*g0.w + 0.10094576*h0.w + 0.060812432*i0.w;
    m = 0.12805411*na0.x + -0.51367366*nb0.x + 0.008197258*nc0.x + -0.56395197*nd0.x + -1.243085*ne0.x + 0.116005324*nf0.x + 0.03238612*ng0.x + 0.26990584*nh0.x + 0.06575366*ni0.x;
    n = -0.19594547*na0.y + 0.22430868*nb0.y + 0.057090167*nc0.y + 0.122728884*nd0.y + 0.5113698*ne0.y + -0.25419077*nf0.y + -0.009283693*ng0.y + -0.12308158*nh0.y + -0.11459907*ni0.y;
    o = -0.2136807*na0.z + -0.1401248*nb0.z + 0.06467563*nc0.z + -0.31790277*nd0.z + -0.92976284*ne0.z + -0.44703412*nf0.z + 0.08179573*ng0.z + 0.007016923*nh0.z + 0.06663411*ni0.z;
    p = -0.18492955*na0.w + -0.6510635*nb0.w + -0.50176597*nc0.w + 0.070071384*nd0.w + -0.33312446*ne0.w + -0.40393078*nf0.w + 0.025449356*ng0.w + 0.0062464178*nh0.w + -0.0042728786*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.14438835;
    i = -0.084957816*a0.x + 0.21759176*b0.x + -0.12676741*c0.x + -0.17032051*d0.x + 0.21418823*e0.x + 0.0516223*f0.x + -0.05529637*g0.x + 0.17844404*h0.x + -0.04393412*i0.x;
    j = -0.09776986*a0.y + 0.29587868*b0.y + -0.17895019*c0.y + 0.23705244*d0.y + -0.23508924*e0.y + 0.23233664*f0.y + 0.11280542*g0.y + -0.10736791*h0.y + -7.6242926e-05*i0.y;
    k = 0.008180588*a0.z + -0.21015471*b0.z + 0.08178927*c0.z + -0.051615402*d0.z + -0.18805277*e0.z + 0.07897466*f0.z + -0.054359443*g0.z + -0.011516885*h0.z + -0.0064640474*i0.z;
    l = -0.120380774*a0.w + 0.6387797*b0.w + -0.18016112*c0.w + 0.040899348*d0.w + 0.1949798*e0.w + -0.082700744*f0.w + -0.018996445*g0.w + -0.109704494*h0.w + -0.00053294667*i0.w;
    m = 0.08493739*na0.x + 0.023677751*nb0.x + -0.050535593*nc0.x + 0.36929327*nd0.x + 0.21340472*ne0.x + -0.32169485*nf0.x + 0.11782148*ng0.x + -0.09112837*nh0.x + -0.018984098*ni0.x;
    n = -0.023597453*na0.y + 0.024977108*nb0.y + -0.027003283*nc0.y + -0.1414026*nd0.y + 0.099894576*ne0.y + 0.03973678*nf0.y + 0.0010171765*ng0.y + 0.051153578*nh0.y + -0.0027343174*ni0.y;
    o = -0.13675037*na0.z + 0.2364966*nb0.z + -0.08819653*nc0.z + 0.17875879*nd0.z + 0.18237808*ne0.z + -0.14008285*nf0.z + 0.092474155*ng0.z + -0.07054796*nh0.z + -0.08649826*ni0.z;
    p = 0.09751934*na0.w + -0.28854543*nb0.w + 0.081181064*nc0.w + -0.016613048*nd0.w + -0.0985543*ne0.w + 0.13922796*nf0.w + 0.009947558*ng0.w + -0.050309543*nh0.w + 0.0055232816*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.005724964;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN7
//!SAVE LUMAN8

#define L_tex LUMAN7_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = 0.023095222*a0.x + 0.088675804*b0.x + 0.019515652*c0.x + 0.03876863*d0.x + 0.28370586*e0.x + 0.052443158*f0.x + 0.012073562*g0.x + 0.054533053*h0.x + 0.009309134*i0.x;
    float j = -0.010418687*a0.y + -0.031180434*b0.y + -0.027810663*c0.y + -0.031218817*d0.y + 0.08831375*e0.y + 0.048364963*f0.y + -0.013520621*g0.y + -0.024290506*h0.y + -0.0071420255*i0.y;
    float k = 0.06729409*a0.z + -0.18290426*b0.z + -0.04015622*c0.z + -0.06585363*d0.z + -0.04277582*e0.z + -0.0031648334*f0.z + -0.036526777*g0.z + 0.019262873*h0.z + -0.06440996*i0.z;
    float l = -0.024598632*a0.w + 0.06775653*b0.w + -0.027943304*c0.w + -0.060332987*d0.w + -0.06108914*e0.w + -0.38447067*f0.w + -0.028799307*g0.w + -0.32565302*h0.w + -0.0820627*i0.w;
    float m = -0.036973793*na0.x + -0.004178863*nb0.x + -0.013591895*nc0.x + -0.028666824*nd0.x + -0.20259032*ne0.x + -0.047049534*nf0.x + 0.03513545*ng0.x + 0.031252332*nh0.x + -0.00072113174*ni0.x;
    float n = -0.023275118*na0.y + 0.12866385*nb0.y + -0.0047646784*nc0.y + 0.09065336*nd0.y + 0.19106166*ne0.y + 0.07720742*nf0.y + 0.07348565*ng0.y + -0.010560173*nh0.y + -0.0021694326*ni0.y;
    float o = -0.0074641155*na0.z + 0.11848335*nb0.z + 0.033949424*nc0.z + 0.102563836*nd0.z + 0.11375473*ne0.z + 0.09258311*nf0.z + -0.033664387*ng0.z + 0.0197137*nh0.z + 0.032966334*ni0.z;
    float p = 0.024047868*na0.w + -0.24709022*nb0.w + -0.2601394*nc0.w + 0.027225772*nd0.w + -0.23746225*ne0.w + -0.012594051*nf0.w + -0.07349794*ng0.w + -0.15158227*nh0.w + -0.2104957*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+-0.25017452;
    i = -0.076065876*a0.x + 0.02043564*b0.x + 0.036401585*c0.x + 0.043759227*d0.x + 0.371543*e0.x + 0.0017194746*f0.x + 0.07603999*g0.x + -0.018234106*h0.x + 0.09166208*i0.x;
    j = 0.10994385*a0.y + -0.036372717*b0.y + -0.007901915*c0.y + -0.13689917*d0.y + 0.31160897*e0.y + -0.099066*f0.y + -0.008666954*g0.y + -0.058747575*h0.y + 0.051024612*i0.y;
    k = -0.23377013*a0.z + 0.07197715*b0.z + 0.032386325*c0.z + 0.25607866*d0.z + -0.57679576*e0.z + -0.17958632*f0.z + -0.09288573*g0.z + 0.032775987*h0.z + -0.032033086*i0.z;
    l = -0.06958261*a0.w + -0.38490036*b0.w + -0.16421184*c0.w + 0.03861677*d0.w + 1.0647631*e0.w + 0.17515695*f0.w + -0.08448393*g0.w + -0.39466596*h0.w + -0.27870917*i0.w;
    m = 0.05919463*na0.x + -0.055675797*nb0.x + -0.018722864*nc0.x + -0.12993331*nd0.x + -0.40171558*ne0.x + -0.07768799*nf0.x + -0.06001731*ng0.x + 0.14385901*nh0.x + -0.12873684*ni0.x;
    n = 0.093186125*na0.y + 0.112590514*nb0.y + 0.13324285*nc0.y + -0.0469093*nd0.y + 0.032717*ne0.y + -0.061363228*nf0.y + 0.14042394*ng0.y + 0.13547798*nh0.y + 0.015560506*ni0.y;
    o = 0.03303404*na0.z + -0.1882256*nb0.z + 0.093654186*nc0.z + 0.05690944*nd0.z + 0.869429*ne0.z + -0.07732642*nf0.z + 0.029356474*ng0.z + -0.14269826*nh0.z + 0.08325262*ni0.z;
    p = 1.3574028e-05*na0.w + 0.16500515*nb0.w + -0.22035407*nc0.w + 0.12756291*nd0.w + -1.2695918*ne0.w + -0.06583852*nf0.w + -0.02346539*ng0.w + -0.29050758*nh0.w + -0.00058551447*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+-0.32460514;
    i = -0.028411858*a0.x + -0.06502476*b0.x + 0.005506057*c0.x + -0.02065754*d0.x + -0.27725258*e0.x + -0.16733906*f0.x + -0.03028571*g0.x + -0.025893265*h0.x + 0.11180306*i0.x;
    j = 0.044810914*a0.y + 0.0014952115*b0.y + 0.007166974*c0.y + 0.0030764928*d0.y + -0.48590574*e0.y + -0.0049648457*f0.y + -0.003955563*g0.y + -0.030718582*h0.y + 0.045998596*i0.y;
    k = -0.033717085*a0.z + 0.17641076*b0.z + 0.0064347754*c0.z + 0.19182369*d0.z + 0.24730518*e0.z + 0.058232464*f0.z + 0.04889152*g0.z + 0.22933209*h0.z + -0.07484277*i0.z;
    l = 0.008050995*a0.w + -0.041974865*b0.w + 0.03150534*c0.w + 0.15421486*d0.w + 1.0763092*e0.w + 0.33450183*f0.w + 0.007857187*g0.w + 0.17052104*h0.w + -0.17598473*i0.w;
    m = 0.05216849*na0.x + -0.02699838*nb0.x + -0.0016451366*nc0.x + 0.026851216*nd0.x + 0.27528808*ne0.x + 0.17918247*nf0.x + 0.00075830554*ng0.x + 0.041555487*nh0.x + -0.08034286*ni0.x;
    n = -0.030616183*na0.y + 0.030711962*nb0.y + 0.0100233685*nc0.y + -0.06026578*nd0.y + 0.32679543*ne0.y + -0.20025784*nf0.y + -0.030410208*ng0.y + 0.09807905*nh0.y + 0.051524427*ni0.y;
    o = 0.008445165*na0.z + -0.13049273*nb0.z + 0.015668884*nc0.z + -0.13367654*nd0.z + -0.133823*ne0.z + -0.17434305*nf0.z + 0.07695557*ng0.z + -0.21806277*nh0.z + 0.10826007*ni0.z;
    p = 0.09218729*na0.w + 0.3068162*nb0.w + 0.16703202*nc0.w + -0.08007084*nd0.w + -0.7652071*ne0.w + -0.054645624*nf0.w + 0.08314212*ng0.w + 0.11377628*nh0.w + 0.2098345*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+0.29825854;
    i = 0.008392284*a0.x + -0.011715544*b0.x + 0.023170955*c0.x + 0.093332864*d0.x + 0.4111941*e0.x + 0.040952653*f0.x + 0.027631473*g0.x + 0.159317*h0.x + -0.063353576*i0.x;
    j = -0.017223362*a0.y + 0.09427027*b0.y + 0.02895971*c0.y + 0.033313658*d0.y + 0.15276653*e0.y + -0.081052944*f0.y + -0.052108422*g0.y + 0.0800538*h0.y + -0.019928783*i0.y;
    k = 0.0131623475*a0.z + 0.10337944*b0.z + -0.023866715*c0.z + -0.08219934*d0.z + -0.41991413*e0.z + 0.1393256*f0.z + 0.08876665*g0.z + -0.008065249*h0.z + 0.06677936*i0.z;
    l = -0.084787*a0.w + -0.21261129*b0.w + -0.12980078*c0.w + -0.03659002*d0.w + 0.37194324*e0.w + 0.40455315*f0.w + 0.0060305526*g0.w + -0.10518265*h0.w + -0.010430722*i0.w;
    m = -0.012547314*na0.x + -0.08181393*nb0.x + -0.04246661*nc0.x + 0.0040180096*nd0.x + -0.40135285*ne0.x + -0.036973383*nf0.x + -0.0069499887*ng0.x + -0.066302136*nh0.x + 0.02571455*ni0.x;
    n = 0.21166039*na0.y + 0.17538953*nb0.y + 0.031203225*nc0.y + 0.025797121*nd0.y + -0.5401104*ne0.y + 0.065669365*nf0.y + 0.053330794*ng0.y + 0.18131651*nh0.y + 0.19454113*ni0.y;
    o = 0.08176905*na0.z + -0.06013371*nb0.z + 0.0018070769*nc0.z + 0.0034025863*nd0.z + 0.49186924*ne0.z + -0.03564626*nf0.z + -0.15229581*ng0.z + 0.107180454*nh0.z + -0.011461588*ni0.z;
    p = -0.012074635*na0.w + 0.2919535*nb0.w + 0.42858946*nc0.w + -0.11339507*nd0.w + -0.51076794*ne0.w + -0.44883406*nf0.w + -0.016805425*ng0.w + 0.316627*nh0.w + -0.106291555*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+-0.30891928;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!COMPONENTS 4
//!BIND LUMAN8
//!SAVE LUMAN9

#define L_tex LUMAN8_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);
    float i = 0.011191786*a0.x + 0.23951381*b0.x + -0.10570748*c0.x + -0.0015254265*d0.x + -0.3949229*e0.x + 0.15096109*f0.x + 0.13656913*g0.x + -0.3877109*h0.x + 0.18022504*i0.x;
    float j = 0.024491772*a0.y + 0.035906848*b0.y + -0.0005005115*c0.y + -0.007313129*d0.y + 0.55162466*e0.y + -0.08579296*f0.y + -0.018405797*g0.y + 0.12538382*h0.y + -0.08658713*i0.y;
    float k = 0.028113367*a0.z + 0.2766013*b0.z + -0.13962306*c0.z + -0.3118571*d0.z + -0.19919883*e0.z + -0.3087286*f0.z + -0.02967599*g0.z + -0.021850891*h0.z + 0.043625243*i0.z;
    float l = -0.082083434*a0.w + 0.038183037*b0.w + -0.04495785*c0.w + 0.05067031*d0.w + -0.12048432*e0.w + 0.008085282*f0.w + -0.033083208*g0.w + -0.032013528*h0.w + -0.018831285*i0.w;
    float m = -0.071037754*na0.x + -0.0583042*nb0.x + 0.0033310892*nc0.x + 0.011530962*nd0.x + 0.4835722*ne0.x + 0.116438776*nf0.x + 0.07681682*ng0.x + 0.028977543*nh0.x + -0.102326706*ni0.x;
    float n = 0.011561477*na0.y + -0.06370286*nb0.y + 0.09494302*nc0.y + 0.15852202*nd0.y + -0.6013122*ne0.y + 0.31835455*nf0.y + 0.07656031*ng0.y + -0.15250978*nh0.y + 0.0660804*ni0.y;
    float o = -0.012869594*na0.z + -0.1694734*nb0.z + 0.007840592*nc0.z + 0.13365789*nd0.z + 0.5910324*ne0.z + 0.023994336*nf0.z + -0.1231746*ng0.z + 0.1182651*nh0.z + -0.073815055*ni0.z;
    float p = -0.015364551*na0.w + 0.032263234*nb0.w + -0.16016856*nc0.w + 0.08521244*nd0.w + 0.36012435*ne0.w + 0.15904869*nf0.w + -0.12220308*ng0.w + 0.12974344*nh0.w + -0.040795863*ni0.w;
    float o0 = i+j+k+l+m+n+o+p+0.053871352;
    i = -0.1588499*a0.x + -0.21851647*b0.x + 0.25986034*c0.x + -0.24344647*d0.x + -1.6035624*e0.x + -0.5991394*f0.x + 0.07953742*g0.x + -0.8776652*h0.x + 0.3819521*i0.x;
    j = -0.043418065*a0.y + -0.12881063*b0.y + -0.024456538*c0.y + -0.1573027*d0.y + 0.06311247*e0.y + 0.06984885*f0.y + 0.025448142*g0.y + 0.19670363*h0.y + 0.081706375*i0.y;
    k = -0.11016761*a0.z + -0.8923534*b0.z + 0.06994402*c0.z + -0.22224432*d0.z + -1.7209625*e0.z + 0.13240254*f0.z + -0.34291184*g0.z + 0.098353565*h0.z + -0.008249665*i0.z;
    l = 0.123915665*a0.w + 0.039321687*b0.w + 0.024920449*c0.w + 0.041610703*d0.w + -0.13273434*e0.w + -0.012516724*f0.w + 0.010549669*g0.w + 0.029736295*h0.w + -0.009006617*i0.w;
    m = 0.1347265*na0.x + 0.12257134*nb0.x + -0.03426787*nc0.x + -0.29054257*nd0.x + 1.5492249*ne0.x + -0.15956564*nf0.x + 0.30979466*ng0.x + -0.22267725*nh0.x + 0.2648195*ni0.x;
    n = -0.04218395*na0.y + 0.25030056*nb0.y + -0.13068442*nc0.y + 0.07904602*nd0.y + -1.0424439*ne0.y + -0.41004273*nf0.y + -0.09722738*ng0.y + -0.24588263*nh0.y + 0.060979873*ni0.y;
    o = -0.03040991*na0.z + 0.2839475*nb0.z + 0.039652344*nc0.z + -0.02847107*nd0.z + -0.04163423*ne0.z + 0.024968851*nf0.z + 0.07027608*ng0.z + 0.11467834*nh0.z + 0.10754681*ni0.z;
    p = 0.06490522*na0.w + 0.18249801*nb0.w + 0.689666*nc0.w + 0.08065804*nd0.w + -1.0966055*ne0.w + -0.9221953*nf0.w + 0.04199578*ng0.w + 0.28271073*nh0.w + 0.061096374*ni0.w;
    float p0 = i+j+k+l+m+n+o+p+-0.09490294;
    i = 0.22382683*a0.x + -0.23359734*b0.x + -0.010614761*c0.x + 0.12763542*d0.x + 0.07141207*e0.x + -0.070608266*f0.x + -0.37325507*g0.x + 0.48005813*h0.x + -0.25752664*i0.x;
    j = -0.023048563*a0.y + 0.10949794*b0.y + -0.022621715*c0.y + 0.12152201*d0.y + -0.27487656*e0.y + 0.06214247*f0.y + 0.10162017*g0.y + -0.020285988*h0.y + -0.005366798*i0.y;
    k = 0.11171756*a0.z + -0.012062316*b0.z + 0.124257565*c0.z + 0.37239715*d0.z + 0.14933206*e0.z + 0.08563614*f0.z + 0.15544249*g0.z + -0.3293271*h0.z + -0.07382031*i0.z;
    l = -0.038293127*a0.w + -0.123794444*b0.w + 0.06780399*c0.w + -0.13198623*d0.w + -0.18499732*e0.w + -0.06403023*f0.w + -0.01241917*g0.w + -0.052804*h0.w + -0.06691653*i0.w;
    m = -0.06774789*na0.x + 0.023599042*nb0.x + -0.020330759*nc0.x + 0.22454411*nd0.x + 1.1471069*ne0.x + 0.117351554*nf0.x + -0.15335907*ng0.x + 0.338719*nh0.x + -0.042319488*ni0.x;
    n = 0.03664181*na0.y + -0.0138222305*nb0.y + 0.048081644*nc0.y + -0.049309026*nd0.y + -0.62234706*ne0.y + 0.10059077*nf0.y + -0.15487589*ng0.y + 0.25435567*nh0.y + -0.057935156*ni0.y;
    o = 0.018089186*na0.z + 0.020494046*nb0.z + -0.066466086*nc0.z + -0.041628707*nd0.z + -0.082925685*ne0.z + -0.040409505*nf0.z + 0.09522753*ng0.z + -0.072019234*nh0.z + 0.026274689*ni0.z;
    p = -0.008643523*na0.w + 0.2802247*nb0.w + 0.09669575*nc0.w + -0.19446205*nd0.w + -1.3981148*ne0.w + 0.3947671*nf0.w + 0.3277589*ng0.w + 0.1827564*nh0.w + -0.037608545*ni0.w;
    float q0 = i+j+k+l+m+n+o+p+-0.33811548;
    i = 0.508959*a0.x + -1.1897582*b0.x + 0.27264822*c0.x + -0.08196677*d0.x + 1.0336326*e0.x + -0.9140986*f0.x + -0.8927567*g0.x + 0.92622685*h0.x + -0.83850926*i0.x;
    j = -0.09935804*a0.y + 0.1434052*b0.y + -0.03832266*c0.y + 0.33068126*d0.y + 0.69079924*e0.y + 0.37703332*f0.y + 0.26853803*g0.y + 0.051550016*h0.y + 0.1365815*i0.y;
    k = 0.50282323*a0.z + -0.8693461*b0.z + 0.68779755*c0.z + 1.2486949*d0.z + -3.4707944*e0.z + 0.91403955*f0.z + 0.380638*g0.z + -0.5875639*h0.z + -0.2996781*i0.z;
    l = 0.089513*a0.w + -0.49879786*b0.w + 0.27097106*c0.w + -0.54017377*d0.w + 0.7231357*e0.w + -0.12225226*f0.w + -0.061104745*g0.w + -0.12059939*h0.w + -0.22460648*i0.w;
    m = 0.111952856*na0.x + -0.06090702*nb0.x + -0.14363275*nc0.x + 0.07970135*nd0.x + 1.2029066*ne0.x + -0.06887455*nf0.x + -0.2361067*ng0.x + 0.22621937*nh0.x + 0.34217682*ni0.x;
    n = 0.057109337*na0.y + 0.25379825*nb0.y + -0.03310617*nc0.y + -0.51321745*nd0.y + 0.27301365*ne0.y + -0.2702349*nf0.y + -0.40828884*ng0.y + 0.48985386*nh0.y + -0.2279193*ni0.y;
    o = 0.01117149*na0.z + 0.34376913*nb0.z + -0.18173458*nc0.z + -0.013281286*nd0.z + 1.6062312*ne0.z + -0.3641134*nf0.z + 0.40594944*ng0.z + -0.14061864*nh0.z + 0.1831309*ni0.z;
    p = 0.0046956087*na0.w + 0.24169385*nb0.w + 1.0654216*nc0.w + 0.2112037*nd0.w + 1.1477715*ne0.w + 0.16534662*nf0.w + 0.6379531*ng0.w + 0.68865937*nh0.w + 0.038767826*ni0.w;
    float r0 = i+j+k+l+m+n+o+p+0.11570526;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Deblur-CNN-(L)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WIDTH LUMA.w
//!HEIGHT LUMA.h
//!COMPONENTS 4
//!BIND LUMAN1
//!BIND LUMAN2
//!BIND LUMAN3
//!BIND LUMAN4
//!BIND LUMAN5
//!BIND LUMAN6
//!BIND LUMAN7
//!BIND LUMAN8
//!BIND LUMAN9
//!SAVE LUMAN0

vec4 hook() {
    vec4 a = LUMAN1_tex(HOOKED_pos);
    vec4 b = LUMAN2_tex(HOOKED_pos);
    vec4 c = LUMAN3_tex(HOOKED_pos);
    vec4 d = LUMAN4_tex(HOOKED_pos);
    vec4 e = LUMAN5_tex(HOOKED_pos);
    vec4 f = LUMAN6_tex(HOOKED_pos);
    vec4 g = LUMAN7_tex(HOOKED_pos);
    vec4 h = LUMAN8_tex(HOOKED_pos);
    vec4 i = LUMAN9_tex(HOOKED_pos);
    vec4 na = -min(a, 0);
    vec4 nb = -min(b, 0);
    vec4 nc = -min(c, 0);
    vec4 nd = -min(d, 0);
    vec4 ne = -min(e, 0);
    vec4 nf = -min(f, 0);
    vec4 ng = -min(g, 0);
    vec4 nh = -min(h, 0);
    vec4 ni = -min(i, 0);
    a = max(a, 0);
    b = max(b, 0);
    c = max(c, 0);
    d = max(d, 0);
    e = max(e, 0);
    f = max(f, 0);
    g = max(g, 0);
    h = max(h, 0);
    i = max(i, 0);
    float o = -0.047081478*a.x + -0.032881256*a.y + -0.043644037*a.z + -0.036561083*a.w + 0.021485493*na.x + 0.018438356*na.y + -0.03554129*na.z + 0.043506186*na.w + 0.014266481*b.x + -0.035737853*b.y + -0.012823628*b.z + 0.0009264891*b.w + -0.05006617*nb.x + -4.4093795e-05*nb.y + 0.0135566415*nb.z + 0.0045723473*nb.w + 0.021764634*c.x + 0.026693553*c.y + 0.0032707953*c.z + 0.013746871*c.w + 0.007973638*nc.x + -0.025660595*nc.y + -0.017825818*nc.z + -0.010194548*nc.w + -0.017283116*d.x + 0.029000388*d.y + -0.025827635*d.z + 0.0014580291*d.w + 0.009698671*nd.x + -0.07251702*nd.y + 0.025386544*nd.z + 0.0102123*nd.w + -0.029390823*e.x + 0.1449412*e.y + -0.004747693*e.z + 0.0015781911*e.w + -0.012161642*ne.x + 0.020992773*ne.y + 0.0025863629*ne.z + 0.020216871*ne.w + -0.014964326*f.x + 0.0057226857*f.y + 0.004602058*f.z + -0.0017072024*f.w + 0.00014010703*nf.x + 0.027396023*nf.y + 0.053284008*nf.z + -0.00054560095*nf.w + -0.08465135*g.x + -0.025449844*g.y + 0.07974024*g.z + -0.026081605*g.w + 0.08998345*ng.x + -0.020028451*ng.y + -0.088179365*ng.z + 0.017214278*ng.w + 0.13374187*h.x + 0.0687001*h.y + 0.07197837*h.z + 0.10976076*h.w + -0.32598913*nh.x + 0.114709705*nh.y + 0.025096709*nh.z + 0.15262882*nh.w + 0.039497968*i.x + 0.081186056*i.y + 0.1575838*i.z + -0.040441483*i.w + -0.12779029*ni.x + -0.053493083*ni.y + -0.1554511*ni.z + 0.06450098*ni.w + 0.10196622;
    float p = -0.05084896*a.x + -0.025864055*a.y + -0.0423675*a.z + -4.0772065e-06*a.w + 0.02803127*na.x + 0.035999373*na.y + 0.007870865*na.z + 0.05825513*na.w + 0.035351537*b.x + -0.07360655*b.y + -0.031453885*b.z + 0.0008590724*b.w + -0.007686636*nb.x + 0.03919155*nb.y + -0.0066824555*nb.z + 0.010864427*nb.w + 0.01694384*c.x + 0.002156429*c.y + -0.01584152*c.z + -0.022033762*c.w + -0.0027367529*nc.x + 0.04000485*nc.y + -0.050542578*nc.z + 0.030587258*nc.w + 0.029927408*d.x + 0.0050946497*d.y + -0.015805498*d.z + 0.023864375*d.w + -0.022649534*nd.x + 0.0028476734*nd.y + 0.012264402*nd.z + 0.031465337*nd.w + -0.10100293*e.x + -0.108228765*e.y + -0.005136694*e.z + -0.00098771*e.w + 0.009984722*ne.x + -0.11651231*ne.y + -0.004329168*ne.z + -0.0034827406*ne.w + 0.05612544*f.x + -0.004895536*f.y + 0.011656533*f.z + 0.011320819*f.w + 0.070911035*nf.x + 0.03044718*nf.y + -0.10531979*nf.z + -0.015752617*nf.w + 0.027381636*g.x + 0.013853647*g.y + -0.013681497*g.z + -0.034121756*g.w + -0.035334572*ng.x + 0.041340206*ng.y + 0.030327082*ng.z + 0.025534922*ng.w + -0.03690772*h.x + -0.08182541*h.y + 0.09829379*h.z + -0.07628125*h.w + 0.15156227*nh.x + -0.07646339*nh.y + -0.12581073*nh.z + -0.14322214*nh.w + 0.07712991*i.x + -0.043189485*i.y + -0.101967454*i.z + 0.031779*i.w + -0.21496733*ni.x + 0.028987886*ni.y + 0.12496805*ni.z + 0.001070264*ni.w + -0.07167466;
    float q = -0.036076654*a.x + -0.023033194*a.y + -0.013268468*a.z + -0.10439581*a.w + 0.02900405*na.x + 0.06569822*na.y + 0.0015899669*na.z + 0.06309523*na.w + 0.01696686*b.x + 0.0018624541*b.y + 0.003093909*b.z + -0.0066021513*b.w + -0.032570347*nb.x + 0.016426489*nb.y + 0.008362462*nb.z + 0.0018623052*nb.w + 0.037616305*c.x + -0.019541427*c.y + 0.030132027*c.z + -0.029543463*c.w + -0.019351475*nc.x + 0.035037447*nc.y + -0.021529585*nc.z + 0.004689821*nc.w + -0.061487217*d.x + -0.017658396*d.y + 0.05177372*d.z + -0.06273585*d.w + 0.05520659*nd.x + -0.014126777*nd.y + -0.04915284*nd.z + 0.026295919*nd.w + 0.17304975*e.x + 0.01705942*e.y + -0.022067694*e.z + -0.0010175292*e.w + -0.011640876*ne.x + -0.07899215*ne.y + 0.02021127*ne.z + -0.022522984*ne.w + -0.014083511*f.x + 0.0072853453*f.y + -0.012230998*f.z + -0.0054261815*f.w + 0.08040602*nf.x + -0.024123095*nf.y + 0.09503648*nf.z + 0.021111265*nf.w + -0.0058723064*g.x + 0.014009066*g.y + -0.0199055*g.z + -0.048992727*g.w + 0.0146807665*ng.x + -0.07463385*ng.y + -0.0023119887*ng.z + 0.0733726*ng.w + 0.16678292*h.x + -0.038813323*h.y + 0.2020253*h.z + 0.0286461*h.w + -0.09631731*nh.x + 0.05879235*nh.y + -0.089875296*nh.z + -0.110792235*nh.w + 0.021833958*i.x + 0.011621068*i.y + -0.002211656*i.z + 0.01791743*i.w + 0.095421486*ni.x + -0.04211359*ni.y + -0.0024988165*ni.z + -0.055464126*ni.w + 0.0059085004;
    float r = -0.061712302*a.x + -0.04130629*a.y + -0.019526359*a.z + -0.12467788*a.w + 0.029681372*na.x + 0.061640427*na.y + -0.0011297357*na.z + 0.09371664*na.w + 0.035102453*b.x + -0.004270386*b.y + 0.008078298*b.z + -0.026749663*b.w + -0.032711815*nb.x + 0.0110498015*nb.y + -0.008478087*nb.z + 0.025791116*nb.w + 0.01243721*c.x + -0.03316*c.y + 0.030688679*c.z + -0.019696997*c.w + -0.022907877*nc.x + 0.013164236*nc.y + -0.008400274*nc.z + -0.014558874*nc.w + -0.010408095*d.x + -0.017213805*d.y + 0.018412916*d.z + -0.023305846*d.w + 0.0009747286*nd.x + 0.04383806*nd.y + -0.019491175*nd.z + 0.014150079*nd.w + -0.003928558*e.x + 0.053480823*e.y + 0.032579094*e.z + 0.006049208*e.w + -0.0025383723*ne.x + 0.079490945*ne.y + -0.03156533*ne.z + -0.019017974*ne.w + -0.024016002*f.x + 0.0016876411*f.y + 0.01778236*f.z + -0.007140162*f.w + -0.047252163*nf.x + 0.0031894948*nf.y + -0.07527481*nf.z + -0.01373366*nf.w + -0.01434254*g.x + -0.026031932*g.y + 0.02796686*g.z + 0.09758574*g.w + 0.007164799*ng.x + 0.065844*ng.y + -0.01628951*ng.z + -0.09932834*ng.w + -0.2192365*h.x + 0.045124453*h.y + -0.31844327*h.z + -0.052317273*h.w + 0.2420633*nh.x + -0.085638754*nh.y + 0.14658552*nh.z + 0.068354204*nh.w + -0.11164648*i.x + -0.030088436*i.y + -0.08107349*i.z + -0.004874011*i.w + 0.2173053*ni.x + 0.059565175*ni.y + 0.045205507*ni.z + -0.015653528*ni.w + 0.0017200519;
    return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Deblur-CNN(L)-Kernel(X)
//!HOOK NATIVE
//!BIND HOOKED
//!SAVE MMKERNEL
//!COMPONENTS 2

#define L_tex HOOKED_tex

float max3v(float a, float b, float c) {
	return max(max(a, b), c);
}
float min3v(float a, float b, float c) {
	return min(min(a, b), c);
}

vec2 minmax3(vec2 pos, vec2 d) {
	float a = L_tex(pos - d).x;
	float b = L_tex(pos).x;
	float c = L_tex(pos + d).x;
	
	return vec2(min3v(a, b, c), max3v(a, b, c));
}

vec4 hook() {
    return vec4(minmax3(HOOKED_pos, vec2(HOOKED_pt.x, 0)), 0, 0);
}

//!DESC Anime4K-v3.0-Deblur-CNN(L)-Kernel(Y)
//!HOOK NATIVE
//!BIND HOOKED
//!BIND MMKERNEL
//!SAVE MMKERNEL
//!COMPONENTS 2

#define L_tex MMKERNEL_tex

float max3v(float a, float b, float c) {
	return max(max(a, b), c);
}
float min3v(float a, float b, float c) {
	return min(min(a, b), c);
}

vec2 minmax3(vec2 pos, vec2 d) {
	float a0 = L_tex(pos - d).x;
	float b0 = L_tex(pos).x;
	float c0 = L_tex(pos + d).x;
	
	float a1 = L_tex(pos - d).y;
	float b1 = L_tex(pos).y;
	float c1 = L_tex(pos + d).y;
	
	return vec2(min3v(a0, b0, c0), max3v(a1, b1, c1));
}

vec4 hook() {
    return vec4(minmax3(HOOKED_pos, vec2(HOOKED_pt.x, 0)), 0, 0);
}

//!HOOK NATIVE
//!BIND HOOKED
//!BIND MMKERNEL
//!BIND LUMAN0
//!DESC Anime4K-v3.0-Deblur-CNN(L)

#define STRENGTH 1 //De-blur proportional strength, higher is sharper. However, it is better to tweak BLUR_CURVE instead to avoid ringing.
#define BLUR_CURVE 0.6 //De-blur power curve, lower is sharper. Good values are between 0.3 - 1. Values greater than 1 softens the image;
#define BLUR_THRESHOLD 0.1 //Value where curve kicks in, used to not de-blur already sharp edges. Only de-blur values that fall below this threshold.
#define NOISE_THRESHOLD 0.001 //Value where curve stops, used to not sharpen noise. Only de-blur values that fall above this threshold.

#define L_tex HOOKED_tex

vec4 hook() {
	vec4 r = LUMAN0_tex(LUMAN0_pos);
	float c = (r.x + r.y + r.z + r.w) / 4 * STRENGTH;
	
	float t_range = BLUR_THRESHOLD - NOISE_THRESHOLD;
	
	float c_t = abs(c);
	if (c_t > NOISE_THRESHOLD) {
		c_t = (c_t - NOISE_THRESHOLD) / t_range;
		c_t = pow(c_t, BLUR_CURVE);
		c_t = c_t * t_range + NOISE_THRESHOLD;
		c_t = c_t * sign(c);
	} else {
		c_t = c;
	}
	
	return vec4(clamp(c_t + L_tex(HOOKED_pos).x, MMKERNEL_tex(HOOKED_pos).x, MMKERNEL_tex(HOOKED_pos).y), HOOKED_tex(HOOKED_pos).yz, 0);
}