# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetMigratingVmResult',
    'AwaitableGetMigratingVmResult',
    'get_migrating_vm',
    'get_migrating_vm_output',
]

@pulumi.output_type
class GetMigratingVmResult:
    def __init__(__self__, compute_engine_target_defaults=None, compute_engine_vm_defaults=None, create_time=None, current_sync_info=None, description=None, display_name=None, error=None, group=None, labels=None, last_sync=None, name=None, policy=None, recent_clone_jobs=None, recent_cutover_jobs=None, source_vm_id=None, state=None, state_time=None, target_defaults=None, update_time=None):
        if compute_engine_target_defaults and not isinstance(compute_engine_target_defaults, dict):
            raise TypeError("Expected argument 'compute_engine_target_defaults' to be a dict")
        pulumi.set(__self__, "compute_engine_target_defaults", compute_engine_target_defaults)
        if compute_engine_vm_defaults and not isinstance(compute_engine_vm_defaults, dict):
            raise TypeError("Expected argument 'compute_engine_vm_defaults' to be a dict")
        if compute_engine_vm_defaults is not None:
            warnings.warn("""Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
            pulumi.log.warn("""compute_engine_vm_defaults is deprecated: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""")

        pulumi.set(__self__, "compute_engine_vm_defaults", compute_engine_vm_defaults)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if current_sync_info and not isinstance(current_sync_info, dict):
            raise TypeError("Expected argument 'current_sync_info' to be a dict")
        pulumi.set(__self__, "current_sync_info", current_sync_info)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if error and not isinstance(error, dict):
            raise TypeError("Expected argument 'error' to be a dict")
        pulumi.set(__self__, "error", error)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if last_sync and not isinstance(last_sync, dict):
            raise TypeError("Expected argument 'last_sync' to be a dict")
        pulumi.set(__self__, "last_sync", last_sync)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if recent_clone_jobs and not isinstance(recent_clone_jobs, list):
            raise TypeError("Expected argument 'recent_clone_jobs' to be a list")
        pulumi.set(__self__, "recent_clone_jobs", recent_clone_jobs)
        if recent_cutover_jobs and not isinstance(recent_cutover_jobs, list):
            raise TypeError("Expected argument 'recent_cutover_jobs' to be a list")
        pulumi.set(__self__, "recent_cutover_jobs", recent_cutover_jobs)
        if source_vm_id and not isinstance(source_vm_id, str):
            raise TypeError("Expected argument 'source_vm_id' to be a str")
        pulumi.set(__self__, "source_vm_id", source_vm_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_time and not isinstance(state_time, str):
            raise TypeError("Expected argument 'state_time' to be a str")
        pulumi.set(__self__, "state_time", state_time)
        if target_defaults and not isinstance(target_defaults, dict):
            raise TypeError("Expected argument 'target_defaults' to be a dict")
        if target_defaults is not None:
            warnings.warn("""The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
            pulumi.log.warn("""target_defaults is deprecated: The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""")

        pulumi.set(__self__, "target_defaults", target_defaults)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="computeEngineTargetDefaults")
    def compute_engine_target_defaults(self) -> 'outputs.ComputeEngineTargetDefaultsResponse':
        """
        Details of the target VM in Compute Engine.
        """
        return pulumi.get(self, "compute_engine_target_defaults")

    @property
    @pulumi.getter(name="computeEngineVmDefaults")
    def compute_engine_vm_defaults(self) -> 'outputs.TargetVMDetailsResponse':
        """
        Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "compute_engine_vm_defaults")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time the migrating VM was created (this refers to this resource and not to the time it was installed in the source).
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentSyncInfo")
    def current_sync_info(self) -> 'outputs.ReplicationCycleResponse':
        """
        The percentage progress of the current running replication cycle.
        """
        return pulumi.get(self, "current_sync_info")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description attached to the migrating VM by the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name attached to the MigratingVm by the user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        Provides details on the state of the Migrating VM in case of an error in replication.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The group this migrating vm is included in, if any. The group is represented by the full path of the appropriate Group resource.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels of the migrating VM.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastSync")
    def last_sync(self) -> 'outputs.ReplicationSyncResponse':
        """
        The most updated snapshot created time in the source that finished replication.
        """
        return pulumi.get(self, "last_sync")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The identifier of the MigratingVm.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> 'outputs.SchedulePolicyResponse':
        """
        The replication schedule policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="recentCloneJobs")
    def recent_clone_jobs(self) -> Sequence['outputs.CloneJobResponse']:
        """
        The recent clone jobs performed on the migrating VM. This field holds the vm's last completed clone job and the vm's running clone job, if one exists. Note: To have this field populated you need to explicitly request it via the "view" parameter of the Get/List request.
        """
        return pulumi.get(self, "recent_clone_jobs")

    @property
    @pulumi.getter(name="recentCutoverJobs")
    def recent_cutover_jobs(self) -> Sequence['outputs.CutoverJobResponse']:
        """
        The recent cutover jobs performed on the migrating VM. This field holds the vm's last completed cutover job and the vm's running cutover job, if one exists. Note: To have this field populated you need to explicitly request it via the "view" parameter of the Get/List request.
        """
        return pulumi.get(self, "recent_cutover_jobs")

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> str:
        """
        The unique ID of the VM in the source. The VM's name in vSphere can be changed, so this is not the VM's name but rather its moRef id. This id is of the form vm-.
        """
        return pulumi.get(self, "source_vm_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the MigratingVm.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> str:
        """
        The last time the migrating VM state was updated.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter(name="targetDefaults")
    def target_defaults(self) -> 'outputs.TargetVMDetailsResponse':
        """
        The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "target_defaults")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last time the migrating VM resource was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetMigratingVmResult(GetMigratingVmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigratingVmResult(
            compute_engine_target_defaults=self.compute_engine_target_defaults,
            compute_engine_vm_defaults=self.compute_engine_vm_defaults,
            create_time=self.create_time,
            current_sync_info=self.current_sync_info,
            description=self.description,
            display_name=self.display_name,
            error=self.error,
            group=self.group,
            labels=self.labels,
            last_sync=self.last_sync,
            name=self.name,
            policy=self.policy,
            recent_clone_jobs=self.recent_clone_jobs,
            recent_cutover_jobs=self.recent_cutover_jobs,
            source_vm_id=self.source_vm_id,
            state=self.state,
            state_time=self.state_time,
            target_defaults=self.target_defaults,
            update_time=self.update_time)


def get_migrating_vm(location: Optional[str] = None,
                     migrating_vm_id: Optional[str] = None,
                     project: Optional[str] = None,
                     source_id: Optional[str] = None,
                     view: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigratingVmResult:
    """
    Gets details of a single MigratingVm.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['migratingVmId'] = migrating_vm_id
    __args__['project'] = project
    __args__['sourceId'] = source_id
    __args__['view'] = view
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:vmmigration/v1alpha1:getMigratingVm', __args__, opts=opts, typ=GetMigratingVmResult).value

    return AwaitableGetMigratingVmResult(
        compute_engine_target_defaults=__ret__.compute_engine_target_defaults,
        compute_engine_vm_defaults=__ret__.compute_engine_vm_defaults,
        create_time=__ret__.create_time,
        current_sync_info=__ret__.current_sync_info,
        description=__ret__.description,
        display_name=__ret__.display_name,
        error=__ret__.error,
        group=__ret__.group,
        labels=__ret__.labels,
        last_sync=__ret__.last_sync,
        name=__ret__.name,
        policy=__ret__.policy,
        recent_clone_jobs=__ret__.recent_clone_jobs,
        recent_cutover_jobs=__ret__.recent_cutover_jobs,
        source_vm_id=__ret__.source_vm_id,
        state=__ret__.state,
        state_time=__ret__.state_time,
        target_defaults=__ret__.target_defaults,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_migrating_vm)
def get_migrating_vm_output(location: Optional[pulumi.Input[str]] = None,
                            migrating_vm_id: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            source_id: Optional[pulumi.Input[str]] = None,
                            view: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMigratingVmResult]:
    """
    Gets details of a single MigratingVm.
    """
    ...
