# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'BoundingPolyResponse',
    'KeyValueResponse',
    'NormalizedVertexResponse',
    'StatusResponse',
    'VertexResponse',
]

@pulumi.output_type
class BoundingPolyResponse(dict):
    """
    A bounding polygon for the detected image annotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "normalizedVertices":
            suggest = "normalized_vertices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoundingPolyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoundingPolyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoundingPolyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 normalized_vertices: Sequence['outputs.NormalizedVertexResponse'],
                 vertices: Sequence['outputs.VertexResponse']):
        """
        A bounding polygon for the detected image annotation.
        :param Sequence['NormalizedVertexResponse'] normalized_vertices: The bounding polygon normalized vertices.
        :param Sequence['VertexResponse'] vertices: The bounding polygon vertices.
        """
        pulumi.set(__self__, "normalized_vertices", normalized_vertices)
        pulumi.set(__self__, "vertices", vertices)

    @property
    @pulumi.getter(name="normalizedVertices")
    def normalized_vertices(self) -> Sequence['outputs.NormalizedVertexResponse']:
        """
        The bounding polygon normalized vertices.
        """
        return pulumi.get(self, "normalized_vertices")

    @property
    @pulumi.getter
    def vertices(self) -> Sequence['outputs.VertexResponse']:
        """
        The bounding polygon vertices.
        """
        return pulumi.get(self, "vertices")


@pulumi.output_type
class KeyValueResponse(dict):
    """
    A product label represented as a key-value pair.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A product label represented as a key-value pair.
        :param str key: The key of the label attached to the product. Cannot be empty and cannot exceed 128 bytes.
        :param str value: The value of the label attached to the product. Cannot be empty and cannot exceed 128 bytes.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the label attached to the product. Cannot be empty and cannot exceed 128 bytes.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the label attached to the product. Cannot be empty and cannot exceed 128 bytes.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NormalizedVertexResponse(dict):
    """
    A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
    """
    def __init__(__self__, *,
                 x: float,
                 y: float):
        """
        A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
        :param float x: X coordinate.
        :param float y: Y coordinate.
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> float:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> float:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class VertexResponse(dict):
    """
    A vertex represents a 2D point in the image. NOTE: the vertex coordinates are in the same scale as the original image.
    """
    def __init__(__self__, *,
                 x: int,
                 y: int):
        """
        A vertex represents a 2D point in the image. NOTE: the vertex coordinates are in the same scale as the original image.
        :param int x: X coordinate.
        :param int y: Y coordinate.
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> int:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> int:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")


