# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetReferenceImageResult',
    'AwaitableGetReferenceImageResult',
    'get_reference_image',
    'get_reference_image_output',
]

@pulumi.output_type
class GetReferenceImageResult:
    def __init__(__self__, bounding_polys=None, name=None, uri=None):
        if bounding_polys and not isinstance(bounding_polys, list):
            raise TypeError("Expected argument 'bounding_polys' to be a list")
        pulumi.set(__self__, "bounding_polys", bounding_polys)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="boundingPolys")
    def bounding_polys(self) -> Sequence['outputs.BoundingPolyResponse']:
        """
        Optional. Bounding polygons around the areas of interest in the reference image. If this field is empty, the system will try to detect regions of interest. At most 10 bounding polygons will be used. The provided shape is converted into a non-rotated rectangle. Once converted, the small edge of the rectangle must be greater than or equal to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5 is not).
        """
        return pulumi.get(self, "bounding_polys")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the reference image. Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`. This field is ignored when creating a reference image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The Google Cloud Storage URI of the reference image. The URI must start with `gs://`.
        """
        return pulumi.get(self, "uri")


class AwaitableGetReferenceImageResult(GetReferenceImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReferenceImageResult(
            bounding_polys=self.bounding_polys,
            name=self.name,
            uri=self.uri)


def get_reference_image(location: Optional[str] = None,
                        product_id: Optional[str] = None,
                        project: Optional[str] = None,
                        reference_image_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReferenceImageResult:
    """
    Gets information associated with a ReferenceImage. Possible errors: * Returns NOT_FOUND if the specified image does not exist.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['productId'] = product_id
    __args__['project'] = project
    __args__['referenceImageId'] = reference_image_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:vision/v1:getReferenceImage', __args__, opts=opts, typ=GetReferenceImageResult).value

    return AwaitableGetReferenceImageResult(
        bounding_polys=__ret__.bounding_polys,
        name=__ret__.name,
        uri=__ret__.uri)


@_utilities.lift_output_func(get_reference_image)
def get_reference_image_output(location: Optional[pulumi.Input[str]] = None,
                               product_id: Optional[pulumi.Input[str]] = None,
                               project: Optional[pulumi.Input[Optional[str]]] = None,
                               reference_image_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReferenceImageResult]:
    """
    Gets information associated with a ReferenceImage. Possible errors: * Returns NOT_FOUND if the specified image does not exist.
    """
    ...
