# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'MaintenancePolicyResponse',
    'MaintenanceScheduleResponse',
    'NodeInfoResponse',
    'PersistenceConfigResponse',
    'TimeOfDayResponse',
    'TlsCertificateResponse',
    'WeeklyMaintenanceWindowResponse',
]

@pulumi.output_type
class MaintenancePolicyResponse(dict):
    """
    Maintenance policy for an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "weeklyMaintenanceWindow":
            suggest = "weekly_maintenance_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenancePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenancePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenancePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 update_time: str,
                 weekly_maintenance_window: Sequence['outputs.WeeklyMaintenanceWindowResponse']):
        """
        Maintenance policy for an instance.
        :param str create_time: The time when the policy was created.
        :param str description: Optional. Description of what this policy is for. Create/Update methods return INVALID_ARGUMENT if the length is greater than 512.
        :param str update_time: The time when the policy was last updated.
        :param Sequence['WeeklyMaintenanceWindowResponse'] weekly_maintenance_window: Optional. Maintenance window that is applied to resources covered by this policy. Minimum 1. For the current version, the maximum number of weekly_window is expected to be one.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "weekly_maintenance_window", weekly_maintenance_window)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the policy was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of what this policy is for. Create/Update methods return INVALID_ARGUMENT if the length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the policy was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindow")
    def weekly_maintenance_window(self) -> Sequence['outputs.WeeklyMaintenanceWindowResponse']:
        """
        Optional. Maintenance window that is applied to resources covered by this policy. Minimum 1. For the current version, the maximum number of weekly_window is expected to be one.
        """
        return pulumi.get(self, "weekly_maintenance_window")


@pulumi.output_type
class MaintenanceScheduleResponse(dict):
    """
    Upcoming maintenance schedule. If no maintenance is scheduled, fields are not populated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canReschedule":
            suggest = "can_reschedule"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_reschedule: bool,
                 end_time: str,
                 schedule_deadline_time: str,
                 start_time: str):
        """
        Upcoming maintenance schedule. If no maintenance is scheduled, fields are not populated.
        :param bool can_reschedule: If the scheduled maintenance can be rescheduled, default is true.
        :param str end_time: The end time of any upcoming scheduled maintenance for this instance.
        :param str schedule_deadline_time: The deadline that the maintenance schedule start time can not go beyond, including reschedule.
        :param str start_time: The start time of any upcoming scheduled maintenance for this instance.
        """
        pulumi.set(__self__, "can_reschedule", can_reschedule)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> bool:
        """
        If the scheduled maintenance can be rescheduled, default is true.
        """
        return pulumi.get(self, "can_reschedule")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> str:
        """
        The deadline that the maintenance schedule start time can not go beyond, including reschedule.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class NodeInfoResponse(dict):
    """
    Node specific properties.
    """
    def __init__(__self__, *,
                 zone: str):
        """
        Node specific properties.
        :param str zone: Location of the node.
        """
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Location of the node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class PersistenceConfigResponse(dict):
    """
    Configuration of the persistence functionality.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "persistenceMode":
            suggest = "persistence_mode"
        elif key == "rdbNextSnapshotTime":
            suggest = "rdb_next_snapshot_time"
        elif key == "rdbSnapshotPeriod":
            suggest = "rdb_snapshot_period"
        elif key == "rdbSnapshotStartTime":
            suggest = "rdb_snapshot_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistenceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistenceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistenceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 persistence_mode: str,
                 rdb_next_snapshot_time: str,
                 rdb_snapshot_period: str,
                 rdb_snapshot_start_time: str):
        """
        Configuration of the persistence functionality.
        :param str persistence_mode: Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        :param str rdb_next_snapshot_time: The next time that a snapshot attempt is scheduled to occur.
        :param str rdb_snapshot_period: Optional. Period between RDB snapshots. Snapshots will be attempted every period starting from the provided snapshot start time. For example, a start time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45, 18:45, and 00:45 the next day, and so on. If not provided, TWENTY_FOUR_HOURS will be used as default.
        :param str rdb_snapshot_start_time: Optional. Date and time that the first snapshot was/will be attempted, and to which future snapshots will be aligned. If not provided, the current time will be used.
        """
        pulumi.set(__self__, "persistence_mode", persistence_mode)
        pulumi.set(__self__, "rdb_next_snapshot_time", rdb_next_snapshot_time)
        pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> str:
        """
        Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
        """
        return pulumi.get(self, "persistence_mode")

    @property
    @pulumi.getter(name="rdbNextSnapshotTime")
    def rdb_next_snapshot_time(self) -> str:
        """
        The next time that a snapshot attempt is scheduled to occur.
        """
        return pulumi.get(self, "rdb_next_snapshot_time")

    @property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> str:
        """
        Optional. Period between RDB snapshots. Snapshots will be attempted every period starting from the provided snapshot start time. For example, a start time of 01/01/2033 06:45 and SIX_HOURS snapshot period will do nothing until 01/01/2033, and then trigger snapshots every day at 06:45, 12:45, 18:45, and 00:45 the next day, and so on. If not provided, TWENTY_FOUR_HOURS will be used as default.
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> str:
        """
        Optional. Date and time that the first snapshot was/will be attempted, and to which future snapshots will be aligned. If not provided, the current time will be used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TlsCertificateResponse(dict):
    """
    TlsCertificate Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "expireTime":
            suggest = "expire_time"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: str,
                 create_time: str,
                 expire_time: str,
                 serial_number: str,
                 sha1_fingerprint: str):
        """
        TlsCertificate Resource
        :param str cert: PEM representation.
        :param str create_time: The time when the certificate was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2020-05-18T00:00:00.094Z`.
        :param str expire_time: The time when the certificate expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2020-05-18T00:00:00.094Z`.
        :param str serial_number: Serial number, as extracted from the certificate.
        :param str sha1_fingerprint: Sha1 Fingerprint of the certificate.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        PEM representation.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the certificate was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2020-05-18T00:00:00.094Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time when the certificate expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2020-05-18T00:00:00.094Z`.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        """
        Sha1 Fingerprint of the certificate.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class WeeklyMaintenanceWindowResponse(dict):
    """
    Time window in which disruptive maintenance updates occur. Non-disruptive updates can occur inside or outside this window.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyMaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyMaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyMaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 duration: str,
                 start_time: 'outputs.TimeOfDayResponse'):
        """
        Time window in which disruptive maintenance updates occur. Non-disruptive updates can occur inside or outside this window.
        :param str day: The day of week that maintenance updates occur.
        :param str duration: Duration of the maintenance window. The current window is fixed at 1 hour.
        :param 'TimeOfDayResponse' start_time: Start time of the window in UTC time.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day of week that maintenance updates occur.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration of the maintenance window. The current window is fixed at 1 hour.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.TimeOfDayResponse':
        """
        Start time of the window in UTC time.
        """
        return pulumi.get(self, "start_time")


