# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyResponse',
    'GoogleCloudRecommendationengineV1beta1FeatureMapResponse',
    'GoogleCloudRecommendationengineV1beta1ImageResponse',
    'GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse',
    'GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRangeResponse',
    'GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse',
]

@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyResponse(dict):
    """
    Category represents catalog item category hierarchy.
    """
    def __init__(__self__, *,
                 categories: Sequence[str]):
        """
        Category represents catalog item category hierarchy.
        :param Sequence[str] categories: Catalog item categories. Each category should be a UTF-8 encoded string with a length limit of 2 KiB. Note that the order in the list denotes the specificity (from least to most specific).
        """
        pulumi.set(__self__, "categories", categories)

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Catalog item categories. Each category should be a UTF-8 encoded string with a length limit of 2 KiB. Note that the order in the list denotes the specificity (from least to most specific).
        """
        return pulumi.get(self, "categories")


@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1FeatureMapResponse(dict):
    """
    FeatureMap represents extra features that customers want to include in the recommendation model for catalogs/user events as categorical/numerical features.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalFeatures":
            suggest = "categorical_features"
        elif key == "numericalFeatures":
            suggest = "numerical_features"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRecommendationengineV1beta1FeatureMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRecommendationengineV1beta1FeatureMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRecommendationengineV1beta1FeatureMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_features: Mapping[str, str],
                 numerical_features: Mapping[str, str]):
        """
        FeatureMap represents extra features that customers want to include in the recommendation model for catalogs/user events as categorical/numerical features.
        :param Mapping[str, str] categorical_features: Categorical features that can take on one of a limited number of possible values. Some examples would be the brand/maker of a product, or country of a customer. Feature names and values must be UTF-8 encoded strings. For example: `{ "colors": {"value": ["yellow", "green"]}, "sizes": {"value":["S", "M"]}`
        :param Mapping[str, str] numerical_features: Numerical features. Some examples would be the height/weight of a product, or age of a customer. Feature names must be UTF-8 encoded strings. For example: `{ "lengths_cm": {"value":[2.3, 15.4]}, "heights_cm": {"value":[8.1, 6.4]} }`
        """
        pulumi.set(__self__, "categorical_features", categorical_features)
        pulumi.set(__self__, "numerical_features", numerical_features)

    @property
    @pulumi.getter(name="categoricalFeatures")
    def categorical_features(self) -> Mapping[str, str]:
        """
        Categorical features that can take on one of a limited number of possible values. Some examples would be the brand/maker of a product, or country of a customer. Feature names and values must be UTF-8 encoded strings. For example: `{ "colors": {"value": ["yellow", "green"]}, "sizes": {"value":["S", "M"]}`
        """
        return pulumi.get(self, "categorical_features")

    @property
    @pulumi.getter(name="numericalFeatures")
    def numerical_features(self) -> Mapping[str, str]:
        """
        Numerical features. Some examples would be the height/weight of a product, or age of a customer. Feature names must be UTF-8 encoded strings. For example: `{ "lengths_cm": {"value":[2.3, 15.4]}, "heights_cm": {"value":[8.1, 6.4]} }`
        """
        return pulumi.get(self, "numerical_features")


@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1ImageResponse(dict):
    """
    Catalog item thumbnail/detail image.
    """
    def __init__(__self__, *,
                 height: int,
                 uri: str,
                 width: int):
        """
        Catalog item thumbnail/detail image.
        :param int height: Optional. Height of the image in number of pixels.
        :param str uri: URL of the image with a length limit of 5 KiB.
        :param int width: Optional. Width of the image in number of pixels.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        Optional. Height of the image in number of pixels.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URL of the image with a length limit of 5 KiB.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        Optional. Width of the image in number of pixels.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse(dict):
    """
    Exact product price.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayPrice":
            suggest = "display_price"
        elif key == "originalPrice":
            suggest = "original_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_price: float,
                 original_price: float):
        """
        Exact product price.
        :param float display_price: Optional. Display price of the product.
        :param float original_price: Optional. Price of the product without any discount. If zero, by default set to be the 'displayPrice'.
        """
        pulumi.set(__self__, "display_price", display_price)
        pulumi.set(__self__, "original_price", original_price)

    @property
    @pulumi.getter(name="displayPrice")
    def display_price(self) -> float:
        """
        Optional. Display price of the product.
        """
        return pulumi.get(self, "display_price")

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> float:
        """
        Optional. Price of the product without any discount. If zero, by default set to be the 'displayPrice'.
        """
        return pulumi.get(self, "original_price")


@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRangeResponse(dict):
    """
    Product price range when there are a range of prices for different variations of the same product.
    """
    def __init__(__self__, *,
                 max: float,
                 min: float):
        """
        Product price range when there are a range of prices for different variations of the same product.
        :param float max: The maximum product price.
        :param float min: The minimum product price.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        The maximum product price.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        The minimum product price.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse(dict):
    """
    ProductCatalogItem captures item metadata specific to retail products.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableQuantity":
            suggest = "available_quantity"
        elif key == "canonicalProductUri":
            suggest = "canonical_product_uri"
        elif key == "currencyCode":
            suggest = "currency_code"
        elif key == "exactPrice":
            suggest = "exact_price"
        elif key == "priceRange":
            suggest = "price_range"
        elif key == "stockState":
            suggest = "stock_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_quantity: str,
                 canonical_product_uri: str,
                 costs: Mapping[str, str],
                 currency_code: str,
                 exact_price: 'outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse',
                 images: Sequence['outputs.GoogleCloudRecommendationengineV1beta1ImageResponse'],
                 price_range: 'outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRangeResponse',
                 stock_state: str):
        """
        ProductCatalogItem captures item metadata specific to retail products.
        :param str available_quantity: Optional. The available quantity of the item.
        :param str canonical_product_uri: Optional. Canonical URL directly linking to the item detail page with a length limit of 5 KiB..
        :param Mapping[str, str] costs: Optional. A map to pass the costs associated with the product. For example: {"manufacturing": 45.5} The profit of selling this item is computed like so: * If 'exactPrice' is provided, profit = displayPrice - sum(costs) * If 'priceRange' is provided, profit = minPrice - sum(costs)
        :param str currency_code: Optional. Only required if the price is set. Currency code for price/costs. Use three-character ISO-4217 code.
        :param 'GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse' exact_price: Optional. The exact product price.
        :param Sequence['GoogleCloudRecommendationengineV1beta1ImageResponse'] images: Optional. Product images for the catalog item.
        :param 'GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRangeResponse' price_range: Optional. The product price range.
        :param str stock_state: Optional. Online stock state of the catalog item. Default is `IN_STOCK`.
        """
        pulumi.set(__self__, "available_quantity", available_quantity)
        pulumi.set(__self__, "canonical_product_uri", canonical_product_uri)
        pulumi.set(__self__, "costs", costs)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "exact_price", exact_price)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "price_range", price_range)
        pulumi.set(__self__, "stock_state", stock_state)

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> str:
        """
        Optional. The available quantity of the item.
        """
        return pulumi.get(self, "available_quantity")

    @property
    @pulumi.getter(name="canonicalProductUri")
    def canonical_product_uri(self) -> str:
        """
        Optional. Canonical URL directly linking to the item detail page with a length limit of 5 KiB..
        """
        return pulumi.get(self, "canonical_product_uri")

    @property
    @pulumi.getter
    def costs(self) -> Mapping[str, str]:
        """
        Optional. A map to pass the costs associated with the product. For example: {"manufacturing": 45.5} The profit of selling this item is computed like so: * If 'exactPrice' is provided, profit = displayPrice - sum(costs) * If 'priceRange' is provided, profit = minPrice - sum(costs)
        """
        return pulumi.get(self, "costs")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Optional. Only required if the price is set. Currency code for price/costs. Use three-character ISO-4217 code.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="exactPrice")
    def exact_price(self) -> 'outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemExactPriceResponse':
        """
        Optional. The exact product price.
        """
        return pulumi.get(self, "exact_price")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GoogleCloudRecommendationengineV1beta1ImageResponse']:
        """
        Optional. Product images for the catalog item.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="priceRange")
    def price_range(self) -> 'outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRangeResponse':
        """
        Optional. The product price range.
        """
        return pulumi.get(self, "price_range")

    @property
    @pulumi.getter(name="stockState")
    def stock_state(self) -> str:
        """
        Optional. Online stock state of the catalog item. Default is `IN_STOCK`.
        """
        return pulumi.get(self, "stock_state")


