# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplicationInfoArgs',
    'CompensationEntryArgs',
    'CompensationInfoArgs',
    'CompensationRangeArgs',
    'MoneyArgs',
    'ProcessingOptionsArgs',
]

@pulumi.input_type
class ApplicationInfoArgs:
    def __init__(__self__, *,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instruction: Optional[pulumi.Input[str]] = None,
                 uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Application related details of a job posting.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] emails: Use this field to specify email address(es) to which resumes or applications can be sent. The maximum number of allowed characters for each entry is 255.
        :param pulumi.Input[str] instruction: Use this field to provide instructions, such as "Mail your application to ...", that a candidate can follow to apply for the job. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 3,000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uris: Use this URI field to direct an applicant to a website, for example to link to an online application form. The maximum number of allowed characters for each entry is 2,000.
        """
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Use this field to specify email address(es) to which resumes or applications can be sent. The maximum number of allowed characters for each entry is 255.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[str]]:
        """
        Use this field to provide instructions, such as "Mail your application to ...", that a candidate can follow to apply for the job. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 3,000.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instruction", value)

    @property
    @pulumi.getter
    def uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Use this URI field to direct an applicant to a website, for example to link to an online application form. The maximum number of allowed characters for each entry is 2,000.
        """
        return pulumi.get(self, "uris")

    @uris.setter
    def uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uris", value)


@pulumi.input_type
class CompensationEntryArgs:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input['MoneyArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_units_per_year: Optional[pulumi.Input[float]] = None,
                 range: Optional[pulumi.Input['CompensationRangeArgs']] = None,
                 type: Optional[pulumi.Input['CompensationEntryType']] = None,
                 unit: Optional[pulumi.Input['CompensationEntryUnit']] = None):
        """
        A compensation entry that represents one component of compensation, such as base pay, bonus, or other compensation type. Annualization: One compensation entry can be annualized if - it contains valid amount or range. - and its expected_units_per_year is set or can be derived. Its annualized range is determined as (amount or range) times expected_units_per_year.
        :param pulumi.Input['MoneyArgs'] amount: Compensation amount.
        :param pulumi.Input[str] description: Compensation description. For example, could indicate equity terms or provide additional context to an estimated bonus.
        :param pulumi.Input[float] expected_units_per_year: Expected number of units paid each year. If not specified, when Job.employment_types is FULLTIME, a default value is inferred based on unit. Default values: - HOURLY: 2080 - DAILY: 260 - WEEKLY: 52 - MONTHLY: 12 - ANNUAL: 1
        :param pulumi.Input['CompensationRangeArgs'] range: Compensation range.
        :param pulumi.Input['CompensationEntryType'] type: Compensation type. Default is CompensationType.COMPENSATION_TYPE_UNSPECIFIED.
        :param pulumi.Input['CompensationEntryUnit'] unit: Frequency of the specified amount. Default is CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_units_per_year is not None:
            pulumi.set(__self__, "expected_units_per_year", expected_units_per_year)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input['MoneyArgs']]:
        """
        Compensation amount.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input['MoneyArgs']]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Compensation description. For example, could indicate equity terms or provide additional context to an estimated bonus.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedUnitsPerYear")
    def expected_units_per_year(self) -> Optional[pulumi.Input[float]]:
        """
        Expected number of units paid each year. If not specified, when Job.employment_types is FULLTIME, a default value is inferred based on unit. Default values: - HOURLY: 2080 - DAILY: 260 - WEEKLY: 52 - MONTHLY: 12 - ANNUAL: 1
        """
        return pulumi.get(self, "expected_units_per_year")

    @expected_units_per_year.setter
    def expected_units_per_year(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "expected_units_per_year", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input['CompensationRangeArgs']]:
        """
        Compensation range.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input['CompensationRangeArgs']]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['CompensationEntryType']]:
        """
        Compensation type. Default is CompensationType.COMPENSATION_TYPE_UNSPECIFIED.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['CompensationEntryType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input['CompensationEntryUnit']]:
        """
        Frequency of the specified amount. Default is CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input['CompensationEntryUnit']]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class CompensationInfoArgs:
    def __init__(__self__, *,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['CompensationEntryArgs']]]] = None):
        """
        Job compensation details.
        :param pulumi.Input[Sequence[pulumi.Input['CompensationEntryArgs']]] entries: Job compensation information. At most one entry can be of type CompensationInfo.CompensationType.BASE, which is referred as **base compensation entry** for the job.
        """
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CompensationEntryArgs']]]]:
        """
        Job compensation information. At most one entry can be of type CompensationInfo.CompensationType.BASE, which is referred as **base compensation entry** for the job.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CompensationEntryArgs']]]]):
        pulumi.set(self, "entries", value)


@pulumi.input_type
class CompensationRangeArgs:
    def __init__(__self__, *,
                 max_compensation: Optional[pulumi.Input['MoneyArgs']] = None,
                 min_compensation: Optional[pulumi.Input['MoneyArgs']] = None):
        """
        Compensation range.
        :param pulumi.Input['MoneyArgs'] max_compensation: The maximum amount of compensation. If left empty, the value is set to a maximal compensation value and the currency code is set to match the currency code of min_compensation.
        :param pulumi.Input['MoneyArgs'] min_compensation: The minimum amount of compensation. If left empty, the value is set to zero and the currency code is set to match the currency code of max_compensation.
        """
        if max_compensation is not None:
            pulumi.set(__self__, "max_compensation", max_compensation)
        if min_compensation is not None:
            pulumi.set(__self__, "min_compensation", min_compensation)

    @property
    @pulumi.getter(name="maxCompensation")
    def max_compensation(self) -> Optional[pulumi.Input['MoneyArgs']]:
        """
        The maximum amount of compensation. If left empty, the value is set to a maximal compensation value and the currency code is set to match the currency code of min_compensation.
        """
        return pulumi.get(self, "max_compensation")

    @max_compensation.setter
    def max_compensation(self, value: Optional[pulumi.Input['MoneyArgs']]):
        pulumi.set(self, "max_compensation", value)

    @property
    @pulumi.getter(name="minCompensation")
    def min_compensation(self) -> Optional[pulumi.Input['MoneyArgs']]:
        """
        The minimum amount of compensation. If left empty, the value is set to zero and the currency code is set to match the currency code of max_compensation.
        """
        return pulumi.get(self, "min_compensation")

    @min_compensation.setter
    def min_compensation(self, value: Optional[pulumi.Input['MoneyArgs']]):
        pulumi.set(self, "min_compensation", value)


@pulumi.input_type
class MoneyArgs:
    def __init__(__self__, *,
                 currency_code: Optional[pulumi.Input[str]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 units: Optional[pulumi.Input[str]] = None):
        """
        Represents an amount of money with its currency type.
        :param pulumi.Input[str] currency_code: The three-letter currency code defined in ISO 4217.
        :param pulumi.Input[int] nanos: Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        :param pulumi.Input[str] units: The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @currency_code.setter
    def currency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency_code", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        """
        The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)


@pulumi.input_type
class ProcessingOptionsArgs:
    def __init__(__self__, *,
                 disable_street_address_resolution: Optional[pulumi.Input[bool]] = None,
                 html_sanitization: Optional[pulumi.Input['ProcessingOptionsHtmlSanitization']] = None):
        """
        Options for job processing.
        :param pulumi.Input[bool] disable_street_address_resolution: If set to `true`, the service does not attempt to resolve a more precise address for the job.
        :param pulumi.Input['ProcessingOptionsHtmlSanitization'] html_sanitization: Option for job HTML content sanitization. Applied fields are: * description * applicationInfo.instruction * incentives * qualifications * responsibilities HTML tags in these fields may be stripped if sanitiazation isn't disabled. Defaults to HtmlSanitization.SIMPLE_FORMATTING_ONLY.
        """
        if disable_street_address_resolution is not None:
            pulumi.set(__self__, "disable_street_address_resolution", disable_street_address_resolution)
        if html_sanitization is not None:
            pulumi.set(__self__, "html_sanitization", html_sanitization)

    @property
    @pulumi.getter(name="disableStreetAddressResolution")
    def disable_street_address_resolution(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the service does not attempt to resolve a more precise address for the job.
        """
        return pulumi.get(self, "disable_street_address_resolution")

    @disable_street_address_resolution.setter
    def disable_street_address_resolution(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_street_address_resolution", value)

    @property
    @pulumi.getter(name="htmlSanitization")
    def html_sanitization(self) -> Optional[pulumi.Input['ProcessingOptionsHtmlSanitization']]:
        """
        Option for job HTML content sanitization. Applied fields are: * description * applicationInfo.instruction * incentives * qualifications * responsibilities HTML tags in these fields may be stripped if sanitiazation isn't disabled. Defaults to HtmlSanitization.SIMPLE_FORMATTING_ONLY.
        """
        return pulumi.get(self, "html_sanitization")

    @html_sanitization.setter
    def html_sanitization(self, value: Optional[pulumi.Input['ProcessingOptionsHtmlSanitization']]):
        pulumi.set(self, "html_sanitization", value)


