# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'FeatureConfigRefResponse',
    'FeatureConfigStateResponse',
    'FeatureSpecResponse',
    'FeatureStateResponse',
    'ResourceStateResponse',
    'StateResponse',
]

@pulumi.output_type
class FeatureConfigRefResponse(dict):
    """
    Information of the FeatureConfig applied on the MembershipFeature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configUpdateTime":
            suggest = "config_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureConfigRefResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureConfigRefResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureConfigRefResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: str,
                 config_update_time: str,
                 uuid: str):
        """
        Information of the FeatureConfig applied on the MembershipFeature.
        :param str config: Input only. Resource name of FeatureConfig, in the format: `projects/{project}/locations/global/featureConfigs/{feature_config}`.
        :param str config_update_time: When the FeatureConfig was last applied and copied to FeatureSpec.
        :param str uuid: An id that uniquely identify a FeatureConfig object.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "config_update_time", config_update_time)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        Input only. Resource name of FeatureConfig, in the format: `projects/{project}/locations/global/featureConfigs/{feature_config}`.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configUpdateTime")
    def config_update_time(self) -> str:
        """
        When the FeatureConfig was last applied and copied to FeatureSpec.
        """
        return pulumi.get(self, "config_update_time")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        An id that uniquely identify a FeatureConfig object.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class FeatureConfigStateResponse(dict):
    """
    FeatureConfigState describes the state of a FeatureConfig resource.
    """
    def __init__(__self__, *,
                 state: str):
        """
        FeatureConfigState describes the state of a FeatureConfig resource.
        :param str state: The current state of the FeatureConfig resource.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the FeatureConfig resource.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class FeatureSpecResponse(dict):
    """
    FeatureSpec contains user input per-feature spec information.
    """
    def __init__(__self__):
        """
        FeatureSpec contains user input per-feature spec information.
        """
        pass


@pulumi.output_type
class FeatureStateResponse(dict):
    """
    FeatureState contains high-level state information and per-feature state information for this MembershipFeature.
    """
    def __init__(__self__, *,
                 state: 'outputs.StateResponse'):
        """
        FeatureState contains high-level state information and per-feature state information for this MembershipFeature.
        :param 'StateResponse' state: The high-level state of this MembershipFeature.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> 'outputs.StateResponse':
        """
        The high-level state of this MembershipFeature.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ResourceStateResponse(dict):
    """
    ResourceState describes the state of a MembershipFeature *resource* in the GkeHub API. See `FeatureState` for the "running state" of the MembershipFeature.
    """
    def __init__(__self__, *,
                 state: str):
        """
        ResourceState describes the state of a MembershipFeature *resource* in the GkeHub API. See `FeatureState` for the "running state" of the MembershipFeature.
        :param str state: The current state of the Feature resource in the Hub API.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Feature resource in the Hub API.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class StateResponse(dict):
    """
    High-level state of a MembershipFeature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 description: str,
                 update_time: str):
        """
        High-level state of a MembershipFeature.
        :param str code: The high-level, machine-readable status of this MembershipFeature.
        :param str description: A human-readable description of the current status.
        :param str update_time: The time this status and any related Feature-specific details were updated.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The high-level, machine-readable status of this MembershipFeature.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human-readable description of the current status.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time this status and any related Feature-specific details were updated.
        """
        return pulumi.get(self, "update_time")


