# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetFeatureResult',
    'AwaitableGetFeatureResult',
    'get_feature',
    'get_feature_output',
]

@pulumi.output_type
class GetFeatureResult:
    def __init__(__self__, create_time=None, delete_time=None, feature_config_ref=None, labels=None, name=None, resource_state=None, spec=None, state=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if feature_config_ref and not isinstance(feature_config_ref, dict):
            raise TypeError("Expected argument 'feature_config_ref' to be a dict")
        pulumi.set(__self__, "feature_config_ref", feature_config_ref)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_state and not isinstance(resource_state, dict):
            raise TypeError("Expected argument 'resource_state' to be a dict")
        pulumi.set(__self__, "resource_state", resource_state)
        if spec and not isinstance(spec, dict):
            raise TypeError("Expected argument 'spec' to be a dict")
        pulumi.set(__self__, "spec", spec)
        if state and not isinstance(state, dict):
            raise TypeError("Expected argument 'state' to be a dict")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        When the MembershipFeature resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        When the MembershipFeature resource was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="featureConfigRef")
    def feature_config_ref(self) -> 'outputs.FeatureConfigRefResponse':
        """
        Reference information for a FeatureConfig applied on the MembershipFeature.
        """
        return pulumi.get(self, "feature_config_ref")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        GCP labels for this MembershipFeature.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the membershipFeature, in the format: `projects/{project}/locations/{location}/memberships/{membership}/features/{feature}`. Note that `membershipFeatures` is shortened to `features` in the resource name. (see http://go/aip/122#collection-identifiers)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> 'outputs.ResourceStateResponse':
        """
        Lifecycle information of the resource itself.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.FeatureSpecResponse':
        """
        Spec of this membershipFeature.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def state(self) -> 'outputs.FeatureStateResponse':
        """
        State of the this membershipFeature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        When the MembershipFeature resource was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetFeatureResult(GetFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureResult(
            create_time=self.create_time,
            delete_time=self.delete_time,
            feature_config_ref=self.feature_config_ref,
            labels=self.labels,
            name=self.name,
            resource_state=self.resource_state,
            spec=self.spec,
            state=self.state,
            update_time=self.update_time)


def get_feature(feature_id: Optional[str] = None,
                location: Optional[str] = None,
                membership_id: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureResult:
    """
    ========= MembershipFeature Services ========= Gets details of a membershipFeature.
    """
    __args__ = dict()
    __args__['featureId'] = feature_id
    __args__['location'] = location
    __args__['membershipId'] = membership_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:gkehub/v2alpha:getFeature', __args__, opts=opts, typ=GetFeatureResult).value

    return AwaitableGetFeatureResult(
        create_time=__ret__.create_time,
        delete_time=__ret__.delete_time,
        feature_config_ref=__ret__.feature_config_ref,
        labels=__ret__.labels,
        name=__ret__.name,
        resource_state=__ret__.resource_state,
        spec=__ret__.spec,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_feature)
def get_feature_output(feature_id: Optional[pulumi.Input[str]] = None,
                       location: Optional[pulumi.Input[str]] = None,
                       membership_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeatureResult]:
    """
    ========= MembershipFeature Services ========= Gets details of a membershipFeature.
    """
    ...
