# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudDialogflowV2beta1AutomatedAgentConfigArgs',
    'GoogleCloudDialogflowV2beta1ContextArgs',
    'GoogleCloudDialogflowV2beta1EntityTypeEntityArgs',
    'GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs',
    'GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs',
    'GoogleCloudDialogflowV2beta1FulfillmentArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs',
    'GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageImageArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageTextArgs',
    'GoogleCloudDialogflowV2beta1IntentMessageArgs',
    'GoogleCloudDialogflowV2beta1IntentParameterArgs',
    'GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs',
    'GoogleCloudDialogflowV2beta1IntentTrainingPhraseArgs',
    'GoogleCloudDialogflowV2beta1LoggingConfigArgs',
    'GoogleCloudDialogflowV2beta1NotificationConfigArgs',
    'GoogleCloudDialogflowV2beta1SpeechToTextConfigArgs',
    'GoogleCloudDialogflowV2beta1SuggestionFeatureArgs',
    'GoogleCloudDialogflowV2beta1TextToSpeechSettingsArgs',
]

@pulumi.input_type
class GoogleCloudDialogflowV2beta1AutomatedAgentConfigArgs:
    def __init__(__self__, *,
                 agent: pulumi.Input[str]):
        """
        Defines the Automated Agent to connect to a conversation.
        :param pulumi.Input[str] agent: ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. - For ES agents, use format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.dialogflow.v2beta1.DetectIntentRequest) for more details. - For CX agents, use format `projects//locations//agents//environments/`. If environment is not specified, the default `draft` environment is used.
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> pulumi.Input[str]:
        """
        ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. - For ES agents, use format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.dialogflow.v2beta1.DetectIntentRequest) for more details. - For CX agents, use format `projects//locations//agents//environments/`. If environment is not specified, the default `draft` environment is used.
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1ContextArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 lifespan_count: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Dialogflow contexts are similar to natural language context. If a person says to you "they are orange", you need context in order to understand what "they" is referring to. Similarly, for Dialogflow to handle an end-user expression like that, it needs to be provided with context in order to correctly match an intent. Using contexts, you can control the flow of a conversation. You can configure contexts for an intent by setting input and output contexts, which are identified by string names. When an intent is matched, any configured output contexts for that intent become active. While any contexts are active, Dialogflow is more likely to match intents that are configured with input contexts that correspond to the currently active contexts. For more information about context, see the [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
        :param pulumi.Input[str] name: The unique identifier of the context. Supported formats: - `projects//agent/sessions//contexts/`, - `projects//locations//agent/sessions//contexts/`, - `projects//agent/environments//users//sessions//contexts/`, - `projects//locations//agent/environments//users//sessions//contexts/`, The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        :param pulumi.Input[int] lifespan_count: Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        pulumi.set(__self__, "name", name)
        if lifespan_count is not None:
            pulumi.set(__self__, "lifespan_count", lifespan_count)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique identifier of the context. Supported formats: - `projects//agent/sessions//contexts/`, - `projects//locations//agent/sessions//contexts/`, - `projects//agent/environments//users//sessions//contexts/`, - `projects//locations//agent/environments//users//sessions//contexts/`, The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="lifespanCount")
    def lifespan_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        """
        return pulumi.get(self, "lifespan_count")

    @lifespan_count.setter
    def lifespan_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lifespan_count", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1EntityTypeEntityArgs:
    def __init__(__self__, *,
                 synonyms: pulumi.Input[Sequence[pulumi.Input[str]]],
                 value: pulumi.Input[str]):
        """
        An **entity entry** for an associated entity type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        :param pulumi.Input[str] value: The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureType']] = None):
        """
        Whether fulfillment is enabled for the specific feature.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureType'] type: The type of the feature that enabled for fulfillment.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureType']]:
        """
        The type of the feature that enabled for fulfillment.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 is_cloud_function: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Represents configuration for a generic web service. Dialogflow supports two mechanisms for authentications: - Basic authentication with username and password. - Authentication with additional authentication headers. More information could be found at: https://cloud.google.com/dialogflow/docs/fulfillment-configure.
        :param pulumi.Input[str] uri: The fulfillment URI for receiving POST requests. It must use https protocol.
        :param pulumi.Input[bool] is_cloud_function: Optional. Indicates if generic web service is created through Cloud Functions integration. Defaults to false. is_cloud_function is deprecated. Cloud functions can be configured by its uri as a regular web service now.
        :param pulumi.Input[str] password: The password for HTTP Basic authentication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] request_headers: The HTTP request headers to send together with fulfillment requests.
        :param pulumi.Input[str] username: The user name for HTTP Basic authentication.
        """
        pulumi.set(__self__, "uri", uri)
        if is_cloud_function is not None:
            pulumi.set(__self__, "is_cloud_function", is_cloud_function)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The fulfillment URI for receiving POST requests. It must use https protocol.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="isCloudFunction")
    def is_cloud_function(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates if generic web service is created through Cloud Functions integration. Defaults to false. is_cloud_function is deprecated. Cloud functions can be configured by its uri as a regular web service now.
        """
        return pulumi.get(self, "is_cloud_function")

    @is_cloud_function.setter
    def is_cloud_function(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloud_function", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for HTTP Basic authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The HTTP request headers to send together with fulfillment requests.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for HTTP Basic authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1FulfillmentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs']]]] = None,
                 generic_web_service: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs']] = None):
        """
        By default, your agent responds to a matched intent with a static response. As an alternative, you can provide a more dynamic response by using fulfillment. When you enable fulfillment for an intent, Dialogflow responds to that intent by calling a service that you define. For example, if an end-user wants to schedule a haircut on Friday, your service can check your database and respond to the end-user with availability information for Friday. For more information, see the [fulfillment guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
        :param pulumi.Input[str] name: The unique identifier of the fulfillment. Supported formats: - `projects//agent/fulfillment` - `projects//locations//agent/fulfillment` This field is not used for Fulfillment in an Environment.
        :param pulumi.Input[str] display_name: The human-readable name of the fulfillment, unique within the agent. This field is not used for Fulfillment in an Environment.
        :param pulumi.Input[bool] enabled: Whether fulfillment is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs']]] features: The field defines whether the fulfillment is enabled for certain features.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs'] generic_web_service: Configuration for a generic web service.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if generic_web_service is not None:
            pulumi.set(__self__, "generic_web_service", generic_web_service)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique identifier of the fulfillment. Supported formats: - `projects//agent/fulfillment` - `projects//locations//agent/fulfillment` This field is not used for Fulfillment in an Environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the fulfillment, unique within the agent. This field is not used for Fulfillment in an Environment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether fulfillment is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs']]]]:
        """
        The field defines whether the fulfillment is enabled for certain features.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs']]:
        """
        Configuration for a generic web service.
        """
        return pulumi.get(self, "generic_web_service")

    @generic_web_service.setter
    def generic_web_service(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1FulfillmentGenericWebServiceArgs']]):
        pulumi.set(self, "generic_web_service", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs:
    def __init__(__self__, *,
                 model: Optional[pulumi.Input[str]] = None):
        """
        Custom conversation models used in agent assist feature. Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY.
        :param pulumi.Input[str] model: Conversation model resource name. Format: `projects//conversationModels/`.
        """
        if model is not None:
            pulumi.set(__self__, "model", model)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        Conversation model resource name. Format: `projects//conversationModels/`.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs:
    def __init__(__self__, *,
                 recent_sentences_count: Optional[pulumi.Input[int]] = None):
        """
        Config to process conversation.
        :param pulumi.Input[int] recent_sentences_count: Number of recent non-small-talk sentences to use as context for article and FAQ suggestion
        """
        if recent_sentences_count is not None:
            pulumi.set(__self__, "recent_sentences_count", recent_sentences_count)

    @property
    @pulumi.getter(name="recentSentencesCount")
    def recent_sentences_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of recent non-small-talk sentences to use as context for article and FAQ suggestion
        """
        return pulumi.get(self, "recent_sentences_count")

    @recent_sentences_count.setter
    def recent_sentences_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recent_sentences_count", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs:
    def __init__(__self__, *,
                 enable_entity_extraction: Optional[pulumi.Input[bool]] = None,
                 enable_sentiment_analysis: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for analyses to run on each conversation message.
        :param pulumi.Input[bool] enable_entity_extraction: Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input[bool] enable_sentiment_analysis: Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        if enable_entity_extraction is not None:
            pulumi.set(__self__, "enable_entity_extraction", enable_entity_extraction)
        if enable_sentiment_analysis is not None:
            pulumi.set(__self__, "enable_sentiment_analysis", enable_sentiment_analysis)

    @property
    @pulumi.getter(name="enableEntityExtraction")
    def enable_entity_extraction(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "enable_entity_extraction")

    @enable_entity_extraction.setter
    def enable_entity_extraction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_entity_extraction", value)

    @property
    @pulumi.getter(name="enableSentimentAnalysis")
    def enable_sentiment_analysis(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        return pulumi.get(self, "enable_sentiment_analysis")

    @enable_sentiment_analysis.setter
    def enable_sentiment_analysis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sentiment_analysis", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs:
    def __init__(__self__, *,
                 feature_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]] = None,
                 group_suggestion_responses: Optional[pulumi.Input[bool]] = None):
        """
        Detail human agent assistant config.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]] feature_configs: Configuration of different suggestion features. One feature can have only one config.
        :param pulumi.Input[bool] group_suggestion_responses: If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        if feature_configs is not None:
            pulumi.set(__self__, "feature_configs", feature_configs)
        if group_suggestion_responses is not None:
            pulumi.set(__self__, "group_suggestion_responses", group_suggestion_responses)

    @property
    @pulumi.getter(name="featureConfigs")
    def feature_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]]:
        """
        Configuration of different suggestion features. One feature can have only one config.
        """
        return pulumi.get(self, "feature_configs")

    @feature_configs.setter
    def feature_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]]):
        pulumi.set(self, "feature_configs", value)

    @property
    @pulumi.getter(name="groupSuggestionResponses")
    def group_suggestion_responses(self) -> Optional[pulumi.Input[bool]]:
        """
        If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        return pulumi.get(self, "group_suggestion_responses")

    @group_suggestion_responses.setter
    def group_suggestion_responses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_suggestion_responses", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfigArgs:
    def __init__(__self__, *,
                 conversation_model_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs']] = None,
                 conversation_process_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs']] = None,
                 enable_event_based_suggestion: Optional[pulumi.Input[bool]] = None,
                 query_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs']] = None,
                 suggestion_feature: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureArgs']] = None,
                 suggestion_trigger_settings: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']] = None):
        """
        Config for suggestion features.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs'] conversation_model_config: Configs of custom conversation model.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs'] conversation_process_config: Configs for processing conversation.
        :param pulumi.Input[bool] enable_event_based_suggestion: Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs'] query_config: Configs of query.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureArgs'] suggestion_feature: The suggestion feature.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs'] suggestion_trigger_settings: Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use this field.
        """
        if conversation_model_config is not None:
            pulumi.set(__self__, "conversation_model_config", conversation_model_config)
        if conversation_process_config is not None:
            pulumi.set(__self__, "conversation_process_config", conversation_process_config)
        if enable_event_based_suggestion is not None:
            pulumi.set(__self__, "enable_event_based_suggestion", enable_event_based_suggestion)
        if query_config is not None:
            pulumi.set(__self__, "query_config", query_config)
        if suggestion_feature is not None:
            pulumi.set(__self__, "suggestion_feature", suggestion_feature)
        if suggestion_trigger_settings is not None:
            pulumi.set(__self__, "suggestion_trigger_settings", suggestion_trigger_settings)

    @property
    @pulumi.getter(name="conversationModelConfig")
    def conversation_model_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs']]:
        """
        Configs of custom conversation model.
        """
        return pulumi.get(self, "conversation_model_config")

    @conversation_model_config.setter
    def conversation_model_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfigArgs']]):
        pulumi.set(self, "conversation_model_config", value)

    @property
    @pulumi.getter(name="conversationProcessConfig")
    def conversation_process_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs']]:
        """
        Configs for processing conversation.
        """
        return pulumi.get(self, "conversation_process_config")

    @conversation_process_config.setter
    def conversation_process_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfigArgs']]):
        pulumi.set(self, "conversation_process_config", value)

    @property
    @pulumi.getter(name="enableEventBasedSuggestion")
    def enable_event_based_suggestion(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "enable_event_based_suggestion")

    @enable_event_based_suggestion.setter
    def enable_event_based_suggestion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_based_suggestion", value)

    @property
    @pulumi.getter(name="queryConfig")
    def query_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs']]:
        """
        Configs of query.
        """
        return pulumi.get(self, "query_config")

    @query_config.setter
    def query_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs']]):
        pulumi.set(self, "query_config", value)

    @property
    @pulumi.getter(name="suggestionFeature")
    def suggestion_feature(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureArgs']]:
        """
        The suggestion feature.
        """
        return pulumi.get(self, "suggestion_feature")

    @suggestion_feature.setter
    def suggestion_feature(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureArgs']]):
        pulumi.set(self, "suggestion_feature", value)

    @property
    @pulumi.getter(name="suggestionTriggerSettings")
    def suggestion_trigger_settings(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']]:
        """
        Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use this field.
        """
        return pulumi.get(self, "suggestion_trigger_settings")

    @suggestion_trigger_settings.setter
    def suggestion_trigger_settings(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']]):
        pulumi.set(self, "suggestion_trigger_settings", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs:
    def __init__(__self__, *,
                 drop_handoff_messages: Optional[pulumi.Input[bool]] = None,
                 drop_ivr_messages: Optional[pulumi.Input[bool]] = None,
                 drop_virtual_agent_messages: Optional[pulumi.Input[bool]] = None):
        """
        Settings that determine how to filter recent conversation context when generating suggestions.
        :param pulumi.Input[bool] drop_handoff_messages: If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        :param pulumi.Input[bool] drop_ivr_messages: If set to true, all messages from ivr stage are dropped.
        :param pulumi.Input[bool] drop_virtual_agent_messages: If set to true, all messages from virtual agent are dropped.
        """
        if drop_handoff_messages is not None:
            pulumi.set(__self__, "drop_handoff_messages", drop_handoff_messages)
        if drop_ivr_messages is not None:
            pulumi.set(__self__, "drop_ivr_messages", drop_ivr_messages)
        if drop_virtual_agent_messages is not None:
            pulumi.set(__self__, "drop_virtual_agent_messages", drop_virtual_agent_messages)

    @property
    @pulumi.getter(name="dropHandoffMessages")
    def drop_handoff_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        """
        return pulumi.get(self, "drop_handoff_messages")

    @drop_handoff_messages.setter
    def drop_handoff_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_handoff_messages", value)

    @property
    @pulumi.getter(name="dropIvrMessages")
    def drop_ivr_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, all messages from ivr stage are dropped.
        """
        return pulumi.get(self, "drop_ivr_messages")

    @drop_ivr_messages.setter
    def drop_ivr_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_ivr_messages", value)

    @property
    @pulumi.getter(name="dropVirtualAgentMessages")
    def drop_virtual_agent_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, all messages from virtual agent are dropped.
        """
        return pulumi.get(self, "drop_virtual_agent_messages")

    @drop_virtual_agent_messages.setter
    def drop_virtual_agent_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_virtual_agent_messages", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs:
    def __init__(__self__, *,
                 agent: pulumi.Input[str]):
        """
        Dialogflow source setting. Supported feature: DIALOGFLOW_ASSIST.
        :param pulumi.Input[str] agent: The name of a dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> pulumi.Input[str]:
        """
        The name of a dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs:
    def __init__(__self__, *,
                 documents: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Document source settings. Supported features: SMART_REPLY, SMART_COMPOSE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] documents: Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, only one document is supported.
        """
        pulumi.set(__self__, "documents", documents)

    @property
    @pulumi.getter
    def documents(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, only one document is supported.
        """
        return pulumi.get(self, "documents")

    @documents.setter
    def documents(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "documents", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs:
    def __init__(__self__, *,
                 knowledge_bases: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Knowledge base source settings. Supported features: ARTICLE_SUGGESTION, FAQ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] knowledge_bases: Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, only one knowledge base is supported.
        """
        pulumi.set(__self__, "knowledge_bases", knowledge_bases)

    @property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, only one knowledge base is supported.
        """
        return pulumi.get(self, "knowledge_bases")

    @knowledge_bases.setter
    def knowledge_bases(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "knowledge_bases", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigArgs:
    def __init__(__self__, *,
                 confidence_threshold: Optional[pulumi.Input[float]] = None,
                 context_filter_settings: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']] = None,
                 dialogflow_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']] = None,
                 document_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']] = None,
                 knowledge_base_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']] = None,
                 max_results: Optional[pulumi.Input[int]] = None):
        """
        Config for suggestion query.
        :param pulumi.Input[float] confidence_threshold: Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it is default to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs'] context_filter_settings: Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs'] dialogflow_query_source: Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs'] document_query_source: Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs'] knowledge_base_query_source: Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        :param pulumi.Input[int] max_results: Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_filter_settings is not None:
            pulumi.set(__self__, "context_filter_settings", context_filter_settings)
        if dialogflow_query_source is not None:
            pulumi.set(__self__, "dialogflow_query_source", dialogflow_query_source)
        if document_query_source is not None:
            pulumi.set(__self__, "document_query_source", document_query_source)
        if knowledge_base_query_source is not None:
            pulumi.set(__self__, "knowledge_base_query_source", knowledge_base_query_source)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it is default to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE.
        """
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "confidence_threshold", value)

    @property
    @pulumi.getter(name="contextFilterSettings")
    def context_filter_settings(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']]:
        """
        Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        """
        return pulumi.get(self, "context_filter_settings")

    @context_filter_settings.setter
    def context_filter_settings(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']]):
        pulumi.set(self, "context_filter_settings", value)

    @property
    @pulumi.getter(name="dialogflowQuerySource")
    def dialogflow_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']]:
        """
        Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "dialogflow_query_source")

    @dialogflow_query_source.setter
    def dialogflow_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']]):
        pulumi.set(self, "dialogflow_query_source", value)

    @property
    @pulumi.getter(name="documentQuerySource")
    def document_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']]:
        """
        Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        """
        return pulumi.get(self, "document_query_source")

    @document_query_source.setter
    def document_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']]):
        pulumi.set(self, "document_query_source", value)

    @property
    @pulumi.getter(name="knowledgeBaseQuerySource")
    def knowledge_base_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']]:
        """
        Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        """
        return pulumi.get(self, "knowledge_base_query_source")

    @knowledge_base_query_source.setter
    def knowledge_base_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']]):
        pulumi.set(self, "knowledge_base_query_source", value)

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        return pulumi.get(self, "max_results")

    @max_results.setter
    def max_results(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_results", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettingsArgs:
    def __init__(__self__, *,
                 no_small_talk: Optional[pulumi.Input[bool]] = None,
                 only_end_user: Optional[pulumi.Input[bool]] = None):
        """
        Settings of suggestion trigger.
        :param pulumi.Input[bool] no_small_talk: Do not trigger if last utterance is small talk.
        :param pulumi.Input[bool] only_end_user: Only trigger suggestion if participant role of last utterance is END_USER.
        """
        if no_small_talk is not None:
            pulumi.set(__self__, "no_small_talk", no_small_talk)
        if only_end_user is not None:
            pulumi.set(__self__, "only_end_user", only_end_user)

    @property
    @pulumi.getter(name="noSmallTalk")
    def no_small_talk(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not trigger if last utterance is small talk.
        """
        return pulumi.get(self, "no_small_talk")

    @no_small_talk.setter
    def no_small_talk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_small_talk", value)

    @property
    @pulumi.getter(name="onlyEndUser")
    def only_end_user(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger suggestion if participant role of last utterance is END_USER.
        """
        return pulumi.get(self, "only_end_user")

    @only_end_user.setter
    def only_end_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_end_user", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigArgs:
    def __init__(__self__, *,
                 end_user_suggestion_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']] = None,
                 human_agent_suggestion_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']] = None,
                 message_analysis_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs']] = None,
                 notification_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigArgs']] = None):
        """
        Defines the Human Agent Assistant to connect to a conversation.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs'] end_user_suggestion_config: Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs'] human_agent_suggestion_config: Configuration for agent assistance of human agent participant.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs'] message_analysis_config: Configuration for message analysis.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigArgs'] notification_config: Pub/Sub topic on which to publish new agent assistant events.
        """
        if end_user_suggestion_config is not None:
            pulumi.set(__self__, "end_user_suggestion_config", end_user_suggestion_config)
        if human_agent_suggestion_config is not None:
            pulumi.set(__self__, "human_agent_suggestion_config", human_agent_suggestion_config)
        if message_analysis_config is not None:
            pulumi.set(__self__, "message_analysis_config", message_analysis_config)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)

    @property
    @pulumi.getter(name="endUserSuggestionConfig")
    def end_user_suggestion_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']]:
        """
        Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "end_user_suggestion_config")

    @end_user_suggestion_config.setter
    def end_user_suggestion_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']]):
        pulumi.set(self, "end_user_suggestion_config", value)

    @property
    @pulumi.getter(name="humanAgentSuggestionConfig")
    def human_agent_suggestion_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']]:
        """
        Configuration for agent assistance of human agent participant.
        """
        return pulumi.get(self, "human_agent_suggestion_config")

    @human_agent_suggestion_config.setter
    def human_agent_suggestion_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfigArgs']]):
        pulumi.set(self, "human_agent_suggestion_config", value)

    @property
    @pulumi.getter(name="messageAnalysisConfig")
    def message_analysis_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs']]:
        """
        Configuration for message analysis.
        """
        return pulumi.get(self, "message_analysis_config")

    @message_analysis_config.setter
    def message_analysis_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfigArgs']]):
        pulumi.set(self, "message_analysis_config", value)

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs:
    def __init__(__self__, *,
                 account_number: pulumi.Input[str]):
        """
        Configuration specific to LivePerson (https://www.liveperson.com).
        :param pulumi.Input[str] account_number: Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        pulumi.set(__self__, "account_number", account_number)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Input[str]:
        """
        Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_number", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs:
    def __init__(__self__, *,
                 button_id: pulumi.Input[str],
                 deployment_id: pulumi.Input[str],
                 endpoint_domain: pulumi.Input[str],
                 organization_id: pulumi.Input[str]):
        """
        Configuration specific to Salesforce Live Agent.
        :param pulumi.Input[str] button_id: Live Agent chat button ID.
        :param pulumi.Input[str] deployment_id: Live Agent deployment ID.
        :param pulumi.Input[str] endpoint_domain: Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        :param pulumi.Input[str] organization_id: The organization ID of the Salesforce account.
        """
        pulumi.set(__self__, "button_id", button_id)
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="buttonId")
    def button_id(self) -> pulumi.Input[str]:
        """
        Live Agent chat button ID.
        """
        return pulumi.get(self, "button_id")

    @button_id.setter
    def button_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_id", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        Live Agent deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> pulumi.Input[str]:
        """
        Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        """
        return pulumi.get(self, "endpoint_domain")

    @endpoint_domain.setter
    def endpoint_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_domain", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        The organization ID of the Salesforce account.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigArgs:
    def __init__(__self__, *,
                 live_person_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs']] = None,
                 salesforce_live_agent_config: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']] = None):
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs'] live_person_config: Uses LivePerson (https://www.liveperson.com).
        :param pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs'] salesforce_live_agent_config: Uses Salesforce Live Agent.
        """
        if live_person_config is not None:
            pulumi.set(__self__, "live_person_config", live_person_config)
        if salesforce_live_agent_config is not None:
            pulumi.set(__self__, "salesforce_live_agent_config", salesforce_live_agent_config)

    @property
    @pulumi.getter(name="livePersonConfig")
    def live_person_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs']]:
        """
        Uses LivePerson (https://www.liveperson.com).
        """
        return pulumi.get(self, "live_person_config")

    @live_person_config.setter
    def live_person_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfigArgs']]):
        pulumi.set(self, "live_person_config", value)

    @property
    @pulumi.getter(name="salesforceLiveAgentConfig")
    def salesforce_live_agent_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']]:
        """
        Uses Salesforce Live Agent.
        """
        return pulumi.get(self, "salesforce_live_agent_config")

    @salesforce_live_agent_config.setter
    def salesforce_live_agent_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']]):
        pulumi.set(self, "salesforce_live_agent_config", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str]):
        """
        Opens the given URI.
        :param pulumi.Input[str] uri: The HTTP or HTTPS scheme URI.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The HTTP or HTTPS scheme URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs:
    def __init__(__self__, *,
                 open_uri_action: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs'],
                 title: pulumi.Input[str]):
        """
        The button object that appears at the bottom of a card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs'] open_uri_action: Action to take when a user taps on the button.
        :param pulumi.Input[str] title: The title of the button.
        """
        pulumi.set(__self__, "open_uri_action", open_uri_action)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs']:
        """
        Action to take when a user taps on the button.
        """
        return pulumi.get(self, "open_uri_action")

    @open_uri_action.setter
    def open_uri_action(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriActionArgs']):
        pulumi.set(self, "open_uri_action", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title of the button.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs:
    def __init__(__self__, *,
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]] = None,
                 formatted_text: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The basic card message. Useful for displaying information.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]] buttons: Optional. The collection of card buttons.
        :param pulumi.Input[str] formatted_text: Required, unless image is present. The body text of the card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Optional. The image for the card.
        :param pulumi.Input[str] subtitle: Optional. The subtitle of the card.
        :param pulumi.Input[str] title: Optional. The title of the card.
        """
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if formatted_text is not None:
            pulumi.set(__self__, "formatted_text", formatted_text)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]]:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="formattedText")
    def formatted_text(self) -> Optional[pulumi.Input[str]]:
        """
        Required, unless image is present. The body text of the card.
        """
        return pulumi.get(self, "formatted_text")

    @formatted_text.setter
    def formatted_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "formatted_text", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. The image for the card.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 url_type_hint: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionUrlTypeHint']] = None):
        """
        Actions on Google action to open a given url.
        :param pulumi.Input[str] url: URL
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionUrlTypeHint'] url_type_hint: Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        pulumi.set(__self__, "url", url)
        if url_type_hint is not None:
            pulumi.set(__self__, "url_type_hint", url_type_hint)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="urlTypeHint")
    def url_type_hint(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionUrlTypeHint']]:
        """
        Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        return pulumi.get(self, "url_type_hint")

    @url_type_hint.setter
    def url_type_hint(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionUrlTypeHint']]):
        pulumi.set(self, "url_type_hint", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs:
    def __init__(__self__, *,
                 open_uri_action: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs'],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 footer: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None):
        """
        Browsing carousel tile
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs'] open_uri_action: Action to present to the user.
        :param pulumi.Input[str] title: Title of the carousel item. Maximum of two lines of text.
        :param pulumi.Input[str] description: Optional. Description of the carousel item. Maximum of four lines of text.
        :param pulumi.Input[str] footer: Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Optional. Hero image for the carousel item.
        """
        pulumi.set(__self__, "open_uri_action", open_uri_action)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if footer is not None:
            pulumi.set(__self__, "footer", footer)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs']:
        """
        Action to present to the user.
        """
        return pulumi.get(self, "open_uri_action")

    @open_uri_action.setter
    def open_uri_action(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs']):
        pulumi.set(self, "open_uri_action", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the carousel item. Maximum of two lines of text.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the carousel item. Maximum of four lines of text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def footer(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        """
        return pulumi.get(self, "footer")

    @footer.setter
    def footer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "footer", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. Hero image for the carousel item.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]],
                 image_display_options: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardImageDisplayOptions']] = None):
        """
        Browse Carousel Card for Actions on Google. https://developers.google.com/actions/assistant/responses#browsing_carousel
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]] items: List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardImageDisplayOptions'] image_display_options: Optional. Settings for displaying the image. Applies to every image in items.
        """
        pulumi.set(__self__, "items", items)
        if image_display_options is not None:
            pulumi.set(__self__, "image_display_options", image_display_options)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]]:
        """
        List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="imageDisplayOptions")
    def image_display_options(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardImageDisplayOptions']]:
        """
        Optional. Settings for displaying the image. Applies to every image in items.
        """
        return pulumi.get(self, "image_display_options")

    @image_display_options.setter
    def image_display_options(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardImageDisplayOptions']]):
        pulumi.set(self, "image_display_options", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs:
    def __init__(__self__, *,
                 postback: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Optional. Contains information about a button.
        :param pulumi.Input[str] postback: Optional. The text to send back to the Dialogflow API or a URI to open.
        :param pulumi.Input[str] text: Optional. The text to show on the button.
        """
        if postback is not None:
            pulumi.set(__self__, "postback", postback)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def postback(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to send back to the Dialogflow API or a URI to open.
        """
        return pulumi.get(self, "postback")

    @postback.setter
    def postback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postback", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to show on the button.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageCardArgs:
    def __init__(__self__, *,
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs']]]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The card response message.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs']]] buttons: Optional. The collection of card buttons.
        :param pulumi.Input[str] image_uri: Optional. The public URI to an image file for the card.
        :param pulumi.Input[str] subtitle: Optional. The subtitle of the card.
        :param pulumi.Input[str] title: Optional. The title of the card.
        """
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs']]]]:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The public URI to an image file for the card.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs:
    def __init__(__self__, *,
                 info: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs'],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None):
        """
        An item in the carousel.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs'] info: Additional info about the option item.
        :param pulumi.Input[str] title: Title of the carousel item.
        :param pulumi.Input[str] description: Optional. The body text of the card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Optional. The image to display.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def info(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs']:
        """
        Additional info about the option item.
        """
        return pulumi.get(self, "info")

    @info.setter
    def info(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs']):
        pulumi.set(self, "info", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the carousel item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The body text of the card.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs']]]):
        """
        The card for presenting a carousel of options to select from.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs']]] items: Carousel items.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs']]]:
        """
        Carousel items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItemArgs']]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[str],
                 horizontal_alignment: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesHorizontalAlignment']] = None):
        """
        Column properties for TableCard.
        :param pulumi.Input[str] header: Column heading.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesHorizontalAlignment'] horizontal_alignment: Optional. Defines text alignment for all cells in this column.
        """
        pulumi.set(__self__, "header", header)
        if horizontal_alignment is not None:
            pulumi.set(__self__, "horizontal_alignment", horizontal_alignment)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[str]:
        """
        Column heading.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter(name="horizontalAlignment")
    def horizontal_alignment(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesHorizontalAlignment']]:
        """
        Optional. Defines text alignment for all cells in this column.
        """
        return pulumi.get(self, "horizontal_alignment")

    @horizontal_alignment.setter
    def horizontal_alignment(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesHorizontalAlignment']]):
        pulumi.set(self, "horizontal_alignment", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageImageArgs:
    def __init__(__self__, *,
                 accessibility_text: Optional[pulumi.Input[str]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None):
        """
        The image response message.
        :param pulumi.Input[str] accessibility_text: A text description of the image to be used for accessibility, e.g., screen readers. Required if image_uri is set for CarouselSelect.
        :param pulumi.Input[str] image_uri: Optional. The public URI to an image file.
        """
        if accessibility_text is not None:
            pulumi.set(__self__, "accessibility_text", accessibility_text)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)

    @property
    @pulumi.getter(name="accessibilityText")
    def accessibility_text(self) -> Optional[pulumi.Input[str]]:
        """
        A text description of the image to be used for accessibility, e.g., screen readers. Required if image_uri is set for CarouselSelect.
        """
        return pulumi.get(self, "accessibility_text")

    @accessibility_text.setter
    def accessibility_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_text", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The public URI to an image file.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs:
    def __init__(__self__, *,
                 destination_name: pulumi.Input[str],
                 uri: pulumi.Input[str]):
        """
        The suggestion chip message that allows the user to jump out to the app or website associated with this agent.
        :param pulumi.Input[str] destination_name: The name of the app or site this chip is linking to.
        :param pulumi.Input[str] uri: The URI of the app or site to open when the user taps the suggestion chip.
        """
        pulumi.set(__self__, "destination_name", destination_name)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Input[str]:
        """
        The name of the app or site this chip is linking to.
        """
        return pulumi.get(self, "destination_name")

    @destination_name.setter
    def destination_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_name", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI of the app or site to open when the user taps the suggestion chip.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs:
    def __init__(__self__, *,
                 info: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs'],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None):
        """
        An item in the list.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs'] info: Additional information about this option.
        :param pulumi.Input[str] title: The title of the list item.
        :param pulumi.Input[str] description: Optional. The main text describing the item.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Optional. The image to display.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def info(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs']:
        """
        Additional information about this option.
        """
        return pulumi.get(self, "info")

    @info.setter
    def info(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs']):
        pulumi.set(self, "info", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title of the list item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The main text describing the item.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs']]],
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The card for presenting a list of options to select from.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs']]] items: List items.
        :param pulumi.Input[str] subtitle: Optional. Subtitle of the list.
        :param pulumi.Input[str] title: Optional. The overall title of the list.
        """
        pulumi.set(__self__, "items", items)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs']]]:
        """
        List items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectItemArgs']]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Subtitle of the list.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The overall title of the list.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs:
    def __init__(__self__, *,
                 content_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None,
                 large_image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None):
        """
        Response media object for media content card.
        :param pulumi.Input[str] content_url: Url where the media is stored.
        :param pulumi.Input[str] name: Name of media card.
        :param pulumi.Input[str] description: Optional. Description of media card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] icon: Optional. Icon to display above media content.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] large_image: Optional. Image to display above media content.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if large_image is not None:
            pulumi.set(__self__, "large_image", large_image)

    @property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> pulumi.Input[str]:
        """
        Url where the media is stored.
        """
        return pulumi.get(self, "content_url")

    @content_url.setter
    def content_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of media card.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of media card.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. Icon to display above media content.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="largeImage")
    def large_image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. Image to display above media content.
        """
        return pulumi.get(self, "large_image")

    @large_image.setter
    def large_image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "large_image", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs:
    def __init__(__self__, *,
                 media_objects: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs']]],
                 media_type: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentMediaType']] = None):
        """
        The media content card for Actions on Google.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs']]] media_objects: List of media objects.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentMediaType'] media_type: Optional. What type of media is the content (ie "audio").
        """
        pulumi.set(__self__, "media_objects", media_objects)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter(name="mediaObjects")
    def media_objects(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs']]]:
        """
        List of media objects.
        """
        return pulumi.get(self, "media_objects")

    @media_objects.setter
    def media_objects(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObjectArgs']]]):
        pulumi.set(self, "media_objects", value)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentMediaType']]:
        """
        Optional. What type of media is the content (ie "audio").
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentMediaType']]):
        pulumi.set(self, "media_type", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs:
    def __init__(__self__, *,
                 quick_replies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The quick replies response message.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] quick_replies: Optional. The collection of quick replies.
        :param pulumi.Input[str] title: Optional. The title of the collection of quick replies.
        """
        if quick_replies is not None:
            pulumi.set(__self__, "quick_replies", quick_replies)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of quick replies.
        """
        return pulumi.get(self, "quick_replies")

    @quick_replies.setter
    def quick_replies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "quick_replies", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the collection of quick replies.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs:
    def __init__(__self__, *,
                 file_uri: pulumi.Input[str],
                 height: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaHeight']] = None,
                 thumbnail_uri: Optional[pulumi.Input[str]] = None):
        """
        Rich Business Messaging (RBM) Media displayed in Cards The following media-types are currently supported: Image Types * image/jpeg * image/jpg' * image/gif * image/png Video Types * video/h263 * video/m4v * video/mp4 * video/mpeg * video/mpeg4 * video/webm
        :param pulumi.Input[str] file_uri: Publicly reachable URI of the file. The RBM platform determines the MIME type of the file from the content-type field in the HTTP headers when the platform fetches the file. The content-type field must be present and accurate in the HTTP response from the URL.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaHeight'] height: Required for cards with vertical orientation. The height of the media within a rich card with a vertical layout. For a standalone card with horizontal layout, height is not customizable, and this field is ignored.
        :param pulumi.Input[str] thumbnail_uri: Optional. Publicly reachable URI of the thumbnail.If you don't provide a thumbnail URI, the RBM platform displays a blank placeholder thumbnail until the user's device downloads the file. Depending on the user's setting, the file may not download automatically and may require the user to tap a download button.
        """
        pulumi.set(__self__, "file_uri", file_uri)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if thumbnail_uri is not None:
            pulumi.set(__self__, "thumbnail_uri", thumbnail_uri)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> pulumi.Input[str]:
        """
        Publicly reachable URI of the file. The RBM platform determines the MIME type of the file from the content-type field in the HTTP headers when the platform fetches the file. The content-type field must be present and accurate in the HTTP response from the URL.
        """
        return pulumi.get(self, "file_uri")

    @file_uri.setter
    def file_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_uri", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaHeight']]:
        """
        Required for cards with vertical orientation. The height of the media within a rich card with a vertical layout. For a standalone card with horizontal layout, height is not customizable, and this field is ignored.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaHeight']]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="thumbnailUri")
    def thumbnail_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Publicly reachable URI of the thumbnail.If you don't provide a thumbnail URI, the RBM platform displays a blank placeholder thumbnail until the user's device downloads the file. Depending on the user's setting, the file may not download automatically and may require the user to tap a download button.
        """
        return pulumi.get(self, "thumbnail_uri")

    @thumbnail_uri.setter
    def thumbnail_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbnail_uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 media: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs']] = None,
                 suggestions: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Rich Business Messaging (RBM) Card content
        :param pulumi.Input[str] description: Optional. Description of the card (at most 2000 bytes). At least one of the title, description or media must be set.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs'] media: Optional. However at least one of the title, description or media must be set. Media (image, GIF or a video) to include in the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]] suggestions: Optional. List of suggestions to include in the card.
        :param pulumi.Input[str] title: Optional. Title of the card (at most 200 bytes). At least one of the title, description or media must be set.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if media is not None:
            pulumi.set(__self__, "media", media)
        if suggestions is not None:
            pulumi.set(__self__, "suggestions", suggestions)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the card (at most 2000 bytes). At least one of the title, description or media must be set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def media(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs']]:
        """
        Optional. However at least one of the title, description or media must be set. Media (image, GIF or a video) to include in the card.
        """
        return pulumi.get(self, "media")

    @media.setter
    def media(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMediaArgs']]):
        pulumi.set(self, "media", value)

    @property
    @pulumi.getter
    def suggestions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]]:
        """
        Optional. List of suggestions to include in the card.
        """
        return pulumi.get(self, "suggestions")

    @suggestions.setter
    def suggestions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]]):
        pulumi.set(self, "suggestions", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title of the card (at most 200 bytes). At least one of the title, description or media must be set.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs:
    def __init__(__self__, *,
                 card_contents: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']]],
                 card_width: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardCardWidth']):
        """
        Carousel Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. If you want to show a single card with more control over the layout, please use RbmStandaloneCard instead.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']]] card_contents: The cards in the carousel. A carousel must have at least 2 cards and at most 10.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardCardWidth'] card_width: The width of the cards in the carousel.
        """
        pulumi.set(__self__, "card_contents", card_contents)
        pulumi.set(__self__, "card_width", card_width)

    @property
    @pulumi.getter(name="cardContents")
    def card_contents(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']]]:
        """
        The cards in the carousel. A carousel must have at least 2 cards and at most 10.
        """
        return pulumi.get(self, "card_contents")

    @card_contents.setter
    def card_contents(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']]]):
        pulumi.set(self, "card_contents", value)

    @property
    @pulumi.getter(name="cardWidth")
    def card_width(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardCardWidth']:
        """
        The width of the cards in the carousel.
        """
        return pulumi.get(self, "card_width")

    @card_width.setter
    def card_width(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardCardWidth']):
        pulumi.set(self, "card_width", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs:
    def __init__(__self__, *,
                 card_content: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs'],
                 card_orientation: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardCardOrientation'],
                 thumbnail_image_alignment: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardThumbnailImageAlignment']] = None):
        """
        Standalone Rich Business Messaging (RBM) rich card. Rich cards allow you to respond to users with more vivid content, e.g. with media and suggestions. You can group multiple rich cards into one using RbmCarouselCard but carousel cards will give you less control over the card layout.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs'] card_content: Card content.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardCardOrientation'] card_orientation: Orientation of the card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardThumbnailImageAlignment'] thumbnail_image_alignment: Required if orientation is horizontal. Image preview alignment for standalone cards with horizontal layout.
        """
        pulumi.set(__self__, "card_content", card_content)
        pulumi.set(__self__, "card_orientation", card_orientation)
        if thumbnail_image_alignment is not None:
            pulumi.set(__self__, "thumbnail_image_alignment", thumbnail_image_alignment)

    @property
    @pulumi.getter(name="cardContent")
    def card_content(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']:
        """
        Card content.
        """
        return pulumi.get(self, "card_content")

    @card_content.setter
    def card_content(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentArgs']):
        pulumi.set(self, "card_content", value)

    @property
    @pulumi.getter(name="cardOrientation")
    def card_orientation(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardCardOrientation']:
        """
        Orientation of the card.
        """
        return pulumi.get(self, "card_orientation")

    @card_orientation.setter
    def card_orientation(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardCardOrientation']):
        pulumi.set(self, "card_orientation", value)

    @property
    @pulumi.getter(name="thumbnailImageAlignment")
    def thumbnail_image_alignment(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardThumbnailImageAlignment']]:
        """
        Required if orientation is horizontal. Image preview alignment for standalone cards with horizontal layout.
        """
        return pulumi.get(self, "thumbnail_image_alignment")

    @thumbnail_image_alignment.setter
    def thumbnail_image_alignment(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardThumbnailImageAlignment']]):
        pulumi.set(self, "thumbnail_image_alignment", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs:
    def __init__(__self__, *,
                 phone_number: pulumi.Input[str]):
        """
        Opens the user's default dialer app with the specified phone number but does not dial automatically.
        :param pulumi.Input[str] phone_number: The phone number to fill in the default dialer app. This field should be in [E.164](https://en.wikipedia.org/wiki/E.164) format. An example of a correctly formatted phone number: +15556767888.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number to fill in the default dialer app. This field should be in [E.164](https://en.wikipedia.org/wiki/E.164) format. An example of a correctly formatted phone number: +15556767888.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str]):
        """
        Opens the user's default web browser app to the specified uri If the user has an app installed that is registered as the default handler for the URL, then this app will be opened instead, and its icon will be used in the suggested action UI.
        :param pulumi.Input[str] uri: The uri to open on the user device
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The uri to open on the user device
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs:
    def __init__(__self__):
        """
        Opens the device's location chooser so the user can pick a location to send back to the agent.
        """
        pass


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs:
    def __init__(__self__, *,
                 dial: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs']] = None,
                 open_url: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs']] = None,
                 postback_data: Optional[pulumi.Input[str]] = None,
                 share_location: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs']] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Rich Business Messaging (RBM) suggested client-side action that the user can choose from the card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs'] dial: Suggested client side action: Dial a phone number
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs'] open_url: Suggested client side action: Open a URI on device
        :param pulumi.Input[str] postback_data: Opaque payload that the Dialogflow receives in a user event when the user taps the suggested action. This data will be also forwarded to webhook to allow performing custom business logic.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs'] share_location: Suggested client side action: Share user location
        :param pulumi.Input[str] text: Text to display alongside the action.
        """
        if dial is not None:
            pulumi.set(__self__, "dial", dial)
        if open_url is not None:
            pulumi.set(__self__, "open_url", open_url)
        if postback_data is not None:
            pulumi.set(__self__, "postback_data", postback_data)
        if share_location is not None:
            pulumi.set(__self__, "share_location", share_location)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def dial(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs']]:
        """
        Suggested client side action: Dial a phone number
        """
        return pulumi.get(self, "dial")

    @dial.setter
    def dial(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDialArgs']]):
        pulumi.set(self, "dial", value)

    @property
    @pulumi.getter(name="openUrl")
    def open_url(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs']]:
        """
        Suggested client side action: Open a URI on device
        """
        return pulumi.get(self, "open_url")

    @open_url.setter
    def open_url(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUriArgs']]):
        pulumi.set(self, "open_url", value)

    @property
    @pulumi.getter(name="postbackData")
    def postback_data(self) -> Optional[pulumi.Input[str]]:
        """
        Opaque payload that the Dialogflow receives in a user event when the user taps the suggested action. This data will be also forwarded to webhook to allow performing custom business logic.
        """
        return pulumi.get(self, "postback_data")

    @postback_data.setter
    def postback_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postback_data", value)

    @property
    @pulumi.getter(name="shareLocation")
    def share_location(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs']]:
        """
        Suggested client side action: Share user location
        """
        return pulumi.get(self, "share_location")

    @share_location.setter
    def share_location(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocationArgs']]):
        pulumi.set(self, "share_location", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Text to display alongside the action.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs:
    def __init__(__self__, *,
                 postback_data: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Rich Business Messaging (RBM) suggested reply that the user can click instead of typing in their own response.
        :param pulumi.Input[str] postback_data: Opaque payload that the Dialogflow receives in a user event when the user taps the suggested reply. This data will be also forwarded to webhook to allow performing custom business logic.
        :param pulumi.Input[str] text: Suggested reply text.
        """
        if postback_data is not None:
            pulumi.set(__self__, "postback_data", postback_data)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="postbackData")
    def postback_data(self) -> Optional[pulumi.Input[str]]:
        """
        Opaque payload that the Dialogflow receives in a user event when the user taps the suggested reply. This data will be also forwarded to webhook to allow performing custom business logic.
        """
        return pulumi.get(self, "postback_data")

    @postback_data.setter
    def postback_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postback_data", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Suggested reply text.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs']] = None,
                 reply: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs']] = None):
        """
        Rich Business Messaging (RBM) suggestion. Suggestions allow user to easily select/click a predefined response or perform an action (like opening a web uri).
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs'] action: Predefined client side actions that user can choose
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs'] reply: Predefined replies for user to select instead of typing
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if reply is not None:
            pulumi.set(__self__, "reply", reply)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs']]:
        """
        Predefined client side actions that user can choose
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def reply(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs']]:
        """
        Predefined replies for user to select instead of typing
        """
        return pulumi.get(self, "reply")

    @reply.setter
    def reply(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReplyArgs']]):
        pulumi.set(self, "reply", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str],
                 rbm_suggestion: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]] = None):
        """
        Rich Business Messaging (RBM) text response with suggestions.
        :param pulumi.Input[str] text: Text sent and displayed to the user.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]] rbm_suggestion: Optional. One or more suggestions to show to the user.
        """
        pulumi.set(__self__, "text", text)
        if rbm_suggestion is not None:
            pulumi.set(__self__, "rbm_suggestion", rbm_suggestion)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        Text sent and displayed to the user.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter(name="rbmSuggestion")
    def rbm_suggestion(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]]:
        """
        Optional. One or more suggestions to show to the user.
        """
        return pulumi.get(self, "rbm_suggestion")

    @rbm_suggestion.setter
    def rbm_suggestion(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestionArgs']]]]):
        pulumi.set(self, "rbm_suggestion", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfoArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Additional info about the select item for when it is triggered in a dialog.
        :param pulumi.Input[str] key: A unique key that will be sent back to the agent if this response is given.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        pulumi.set(__self__, "key", key)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A unique key that will be sent back to the agent if this response is given.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "synonyms", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs:
    def __init__(__self__, *,
                 simple_responses: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs']]]):
        """
        The collection of simple response candidates. This message in `QueryResult.fulfillment_messages` and `WebhookResponse.fulfillment_messages` should contain only one `SimpleResponse`.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs']]] simple_responses: The list of simple responses.
        """
        pulumi.set(__self__, "simple_responses", simple_responses)

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs']]]:
        """
        The list of simple responses.
        """
        return pulumi.get(self, "simple_responses")

    @simple_responses.setter
    def simple_responses(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs']]]):
        pulumi.set(self, "simple_responses", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponseArgs:
    def __init__(__self__, *,
                 display_text: Optional[pulumi.Input[str]] = None,
                 ssml: Optional[pulumi.Input[str]] = None,
                 text_to_speech: Optional[pulumi.Input[str]] = None):
        """
        The simple response message containing speech or text.
        :param pulumi.Input[str] display_text: Optional. The text to display.
        :param pulumi.Input[str] ssml: One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        :param pulumi.Input[str] text_to_speech: One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        if display_text is not None:
            pulumi.set(__self__, "display_text", display_text)
        if ssml is not None:
            pulumi.set(__self__, "ssml", ssml)
        if text_to_speech is not None:
            pulumi.set(__self__, "text_to_speech", text_to_speech)

    @property
    @pulumi.getter(name="displayText")
    def display_text(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to display.
        """
        return pulumi.get(self, "display_text")

    @display_text.setter
    def display_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_text", value)

    @property
    @pulumi.getter
    def ssml(self) -> Optional[pulumi.Input[str]]:
        """
        One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        """
        return pulumi.get(self, "ssml")

    @ssml.setter
    def ssml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssml", value)

    @property
    @pulumi.getter(name="textToSpeech")
    def text_to_speech(self) -> Optional[pulumi.Input[str]]:
        """
        One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        return pulumi.get(self, "text_to_speech")

    @text_to_speech.setter
    def text_to_speech(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text_to_speech", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs:
    def __init__(__self__, *,
                 suggestions: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs']]]):
        """
        The collection of suggestions.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs']]] suggestions: The list of suggested replies.
        """
        pulumi.set(__self__, "suggestions", suggestions)

    @property
    @pulumi.getter
    def suggestions(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs']]]:
        """
        The list of suggested replies.
        """
        return pulumi.get(self, "suggestions")

    @suggestions.setter
    def suggestions(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs']]]):
        pulumi.set(self, "suggestions", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageSuggestionArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[str]):
        """
        The suggestion chip message that the user can tap to quickly post a reply to the conversation.
        :param pulumi.Input[str] title: The text shown the in the suggestion chip.
        """
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The text shown the in the suggestion chip.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str]):
        """
        Cell of TableCardRow.
        :param pulumi.Input[str] text: Text in this cell.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        Text in this cell.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs:
    def __init__(__self__, *,
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs']]]] = None,
                 divider_after: Optional[pulumi.Input[bool]] = None):
        """
        Row of TableCard.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs']]] cells: Optional. List of cells that make up this row.
        :param pulumi.Input[bool] divider_after: Optional. Whether to add a visual divider after this row.
        """
        if cells is not None:
            pulumi.set(__self__, "cells", cells)
        if divider_after is not None:
            pulumi.set(__self__, "divider_after", divider_after)

    @property
    @pulumi.getter
    def cells(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs']]]]:
        """
        Optional. List of cells that make up this row.
        """
        return pulumi.get(self, "cells")

    @cells.setter
    def cells(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardCellArgs']]]]):
        pulumi.set(self, "cells", value)

    @property
    @pulumi.getter(name="dividerAfter")
    def divider_after(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to add a visual divider after this row.
        """
        return pulumi.get(self, "divider_after")

    @divider_after.setter
    def divider_after(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "divider_after", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[str],
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]] = None,
                 column_properties: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs']]]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None,
                 rows: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs']]]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None):
        """
        Table card for Actions on Google.
        :param pulumi.Input[str] title: Title of the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]] buttons: Optional. List of buttons for the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs']]] column_properties: Optional. Display properties for the columns in this table.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Optional. Image which should be displayed on the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs']]] rows: Optional. Rows in this table of data.
        :param pulumi.Input[str] subtitle: Optional. Subtitle to the title.
        """
        pulumi.set(__self__, "title", title)
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if column_properties is not None:
            pulumi.set(__self__, "column_properties", column_properties)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]]:
        """
        Optional. List of buttons for the card.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="columnProperties")
    def column_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs']]]]:
        """
        Optional. Display properties for the columns in this table.
        """
        return pulumi.get(self, "column_properties")

    @column_properties.setter
    def column_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageColumnPropertiesArgs']]]]):
        pulumi.set(self, "column_properties", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Optional. Image which should be displayed on the card.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def rows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs']]]]:
        """
        Optional. Rows in this table of data.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardRowArgs']]]]):
        pulumi.set(self, "rows", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Subtitle to the title.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs:
    def __init__(__self__, *,
                 audio_uri: pulumi.Input[str]):
        """
        Plays audio from a file in Telephony Gateway.
        :param pulumi.Input[str] audio_uri: URI to a Google Cloud Storage object containing the audio to play, e.g., "gs://bucket/object". The object must contain a single channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz. This object must be readable by the `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` service account where is the number of the Telephony Gateway project (usually the same as the Dialogflow agent project). If the Google Cloud Storage bucket is in the Telephony Gateway project, this permission is added by default when enabling the Dialogflow V2 API. For audio from other sources, consider using the `TelephonySynthesizeSpeech` message with SSML.
        """
        pulumi.set(__self__, "audio_uri", audio_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> pulumi.Input[str]:
        """
        URI to a Google Cloud Storage object containing the audio to play, e.g., "gs://bucket/object". The object must contain a single channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz. This object must be readable by the `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` service account where is the number of the Telephony Gateway project (usually the same as the Dialogflow agent project). If the Google Cloud Storage bucket is in the Telephony Gateway project, this permission is added by default when enabling the Dialogflow V2 API. For audio from other sources, consider using the `TelephonySynthesizeSpeech` message with SSML.
        """
        return pulumi.get(self, "audio_uri")

    @audio_uri.setter
    def audio_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "audio_uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs:
    def __init__(__self__, *,
                 ssml: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Synthesizes speech and plays back the synthesized audio to the caller in Telephony Gateway. Telephony Gateway takes the synthesizer settings from `DetectIntentResponse.output_audio_config` which can either be set at request-level or can come from the agent-level synthesizer config.
        :param pulumi.Input[str] ssml: The SSML to be synthesized. For more information, see [SSML](https://developers.google.com/actions/reference/ssml).
        :param pulumi.Input[str] text: The raw text to be synthesized.
        """
        if ssml is not None:
            pulumi.set(__self__, "ssml", ssml)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def ssml(self) -> Optional[pulumi.Input[str]]:
        """
        The SSML to be synthesized. For more information, see [SSML](https://developers.google.com/actions/reference/ssml).
        """
        return pulumi.get(self, "ssml")

    @ssml.setter
    def ssml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssml", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        The raw text to be synthesized.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs:
    def __init__(__self__, *,
                 phone_number: pulumi.Input[str]):
        """
        Transfers the call in Telephony Gateway.
        :param pulumi.Input[str] phone_number: The phone number to transfer the call to in [E.164 format](https://en.wikipedia.org/wiki/E.164). We currently only allow transferring to US numbers (+1xxxyyyzzzz).
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number to transfer the call to in [E.164 format](https://en.wikipedia.org/wiki/E.164). We currently only allow transferring to US numbers (+1xxxyyyzzzz).
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageTextArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The text response message.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text: Optional. The collection of the agent's responses.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of the agent's responses.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentMessageArgs:
    def __init__(__self__, *,
                 basic_card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs']] = None,
                 browse_carousel_card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs']] = None,
                 card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardArgs']] = None,
                 carousel_select: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs']] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']] = None,
                 link_out_suggestion: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs']] = None,
                 list_select: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs']] = None,
                 media_content: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs']] = None,
                 payload: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessagePlatform']] = None,
                 quick_replies: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs']] = None,
                 rbm_carousel_rich_card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs']] = None,
                 rbm_standalone_rich_card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs']] = None,
                 rbm_text: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs']] = None,
                 simple_responses: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs']] = None,
                 suggestions: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs']] = None,
                 table_card: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs']] = None,
                 telephony_play_audio: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs']] = None,
                 telephony_synthesize_speech: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs']] = None,
                 telephony_transfer_call: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs']] = None,
                 text: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTextArgs']] = None):
        """
        Corresponds to the `Response` field in the Dialogflow console.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs'] basic_card: Displays a basic card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs'] browse_carousel_card: Browse carousel card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardArgs'] card: Displays a card.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs'] carousel_select: Displays a carousel card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs'] image: Displays an image.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs'] link_out_suggestion: Displays a link out suggestion chip for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs'] list_select: Displays a list card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs'] media_content: The media content card for Actions on Google.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] payload: A custom platform-specific response.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessagePlatform'] platform: Optional. The platform that this message is intended for.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs'] quick_replies: Displays quick replies.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs'] rbm_carousel_rich_card: Rich Business Messaging (RBM) carousel rich card response.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs'] rbm_standalone_rich_card: Standalone Rich Business Messaging (RBM) rich card response.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs'] rbm_text: Rich Business Messaging (RBM) text response. RBM allows businesses to send enriched and branded versions of SMS. See https://jibe.google.com/business-messaging.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs'] simple_responses: Returns a voice or text-only response for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs'] suggestions: Displays suggestion chips for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs'] table_card: Table card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs'] telephony_play_audio: Plays audio from a file in Telephony Gateway.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs'] telephony_synthesize_speech: Synthesizes speech in Telephony Gateway.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs'] telephony_transfer_call: Transfers the call in Telephony Gateway.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTextArgs'] text: Returns a text response.
        """
        if basic_card is not None:
            pulumi.set(__self__, "basic_card", basic_card)
        if browse_carousel_card is not None:
            pulumi.set(__self__, "browse_carousel_card", browse_carousel_card)
        if card is not None:
            pulumi.set(__self__, "card", card)
        if carousel_select is not None:
            pulumi.set(__self__, "carousel_select", carousel_select)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if link_out_suggestion is not None:
            pulumi.set(__self__, "link_out_suggestion", link_out_suggestion)
        if list_select is not None:
            pulumi.set(__self__, "list_select", list_select)
        if media_content is not None:
            pulumi.set(__self__, "media_content", media_content)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if quick_replies is not None:
            pulumi.set(__self__, "quick_replies", quick_replies)
        if rbm_carousel_rich_card is not None:
            pulumi.set(__self__, "rbm_carousel_rich_card", rbm_carousel_rich_card)
        if rbm_standalone_rich_card is not None:
            pulumi.set(__self__, "rbm_standalone_rich_card", rbm_standalone_rich_card)
        if rbm_text is not None:
            pulumi.set(__self__, "rbm_text", rbm_text)
        if simple_responses is not None:
            pulumi.set(__self__, "simple_responses", simple_responses)
        if suggestions is not None:
            pulumi.set(__self__, "suggestions", suggestions)
        if table_card is not None:
            pulumi.set(__self__, "table_card", table_card)
        if telephony_play_audio is not None:
            pulumi.set(__self__, "telephony_play_audio", telephony_play_audio)
        if telephony_synthesize_speech is not None:
            pulumi.set(__self__, "telephony_synthesize_speech", telephony_synthesize_speech)
        if telephony_transfer_call is not None:
            pulumi.set(__self__, "telephony_transfer_call", telephony_transfer_call)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="basicCard")
    def basic_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs']]:
        """
        Displays a basic card for Actions on Google.
        """
        return pulumi.get(self, "basic_card")

    @basic_card.setter
    def basic_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBasicCardArgs']]):
        pulumi.set(self, "basic_card", value)

    @property
    @pulumi.getter(name="browseCarouselCard")
    def browse_carousel_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs']]:
        """
        Browse carousel card for Actions on Google.
        """
        return pulumi.get(self, "browse_carousel_card")

    @browse_carousel_card.setter
    def browse_carousel_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardArgs']]):
        pulumi.set(self, "browse_carousel_card", value)

    @property
    @pulumi.getter
    def card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardArgs']]:
        """
        Displays a card.
        """
        return pulumi.get(self, "card")

    @card.setter
    def card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCardArgs']]):
        pulumi.set(self, "card", value)

    @property
    @pulumi.getter(name="carouselSelect")
    def carousel_select(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs']]:
        """
        Displays a carousel card for Actions on Google.
        """
        return pulumi.get(self, "carousel_select")

    @carousel_select.setter
    def carousel_select(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectArgs']]):
        pulumi.set(self, "carousel_select", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]:
        """
        Displays an image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="linkOutSuggestion")
    def link_out_suggestion(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs']]:
        """
        Displays a link out suggestion chip for Actions on Google.
        """
        return pulumi.get(self, "link_out_suggestion")

    @link_out_suggestion.setter
    def link_out_suggestion(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestionArgs']]):
        pulumi.set(self, "link_out_suggestion", value)

    @property
    @pulumi.getter(name="listSelect")
    def list_select(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs']]:
        """
        Displays a list card for Actions on Google.
        """
        return pulumi.get(self, "list_select")

    @list_select.setter
    def list_select(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageListSelectArgs']]):
        pulumi.set(self, "list_select", value)

    @property
    @pulumi.getter(name="mediaContent")
    def media_content(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs']]:
        """
        The media content card for Actions on Google.
        """
        return pulumi.get(self, "media_content")

    @media_content.setter
    def media_content(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageMediaContentArgs']]):
        pulumi.set(self, "media_content", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A custom platform-specific response.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessagePlatform']]:
        """
        Optional. The platform that this message is intended for.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessagePlatform']]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs']]:
        """
        Displays quick replies.
        """
        return pulumi.get(self, "quick_replies")

    @quick_replies.setter
    def quick_replies(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageQuickRepliesArgs']]):
        pulumi.set(self, "quick_replies", value)

    @property
    @pulumi.getter(name="rbmCarouselRichCard")
    def rbm_carousel_rich_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs']]:
        """
        Rich Business Messaging (RBM) carousel rich card response.
        """
        return pulumi.get(self, "rbm_carousel_rich_card")

    @rbm_carousel_rich_card.setter
    def rbm_carousel_rich_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCardArgs']]):
        pulumi.set(self, "rbm_carousel_rich_card", value)

    @property
    @pulumi.getter(name="rbmStandaloneRichCard")
    def rbm_standalone_rich_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs']]:
        """
        Standalone Rich Business Messaging (RBM) rich card response.
        """
        return pulumi.get(self, "rbm_standalone_rich_card")

    @rbm_standalone_rich_card.setter
    def rbm_standalone_rich_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCardArgs']]):
        pulumi.set(self, "rbm_standalone_rich_card", value)

    @property
    @pulumi.getter(name="rbmText")
    def rbm_text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs']]:
        """
        Rich Business Messaging (RBM) text response. RBM allows businesses to send enriched and branded versions of SMS. See https://jibe.google.com/business-messaging.
        """
        return pulumi.get(self, "rbm_text")

    @rbm_text.setter
    def rbm_text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageRbmTextArgs']]):
        pulumi.set(self, "rbm_text", value)

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs']]:
        """
        Returns a voice or text-only response for Actions on Google.
        """
        return pulumi.get(self, "simple_responses")

    @simple_responses.setter
    def simple_responses(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSimpleResponsesArgs']]):
        pulumi.set(self, "simple_responses", value)

    @property
    @pulumi.getter
    def suggestions(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs']]:
        """
        Displays suggestion chips for Actions on Google.
        """
        return pulumi.get(self, "suggestions")

    @suggestions.setter
    def suggestions(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageSuggestionsArgs']]):
        pulumi.set(self, "suggestions", value)

    @property
    @pulumi.getter(name="tableCard")
    def table_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs']]:
        """
        Table card for Actions on Google.
        """
        return pulumi.get(self, "table_card")

    @table_card.setter
    def table_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTableCardArgs']]):
        pulumi.set(self, "table_card", value)

    @property
    @pulumi.getter(name="telephonyPlayAudio")
    def telephony_play_audio(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs']]:
        """
        Plays audio from a file in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_play_audio")

    @telephony_play_audio.setter
    def telephony_play_audio(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudioArgs']]):
        pulumi.set(self, "telephony_play_audio", value)

    @property
    @pulumi.getter(name="telephonySynthesizeSpeech")
    def telephony_synthesize_speech(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs']]:
        """
        Synthesizes speech in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_synthesize_speech")

    @telephony_synthesize_speech.setter
    def telephony_synthesize_speech(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeechArgs']]):
        pulumi.set(self, "telephony_synthesize_speech", value)

    @property
    @pulumi.getter(name="telephonyTransferCall")
    def telephony_transfer_call(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs']]:
        """
        Transfers the call in Telephony Gateway.
        """
        return pulumi.get(self, "telephony_transfer_call")

    @telephony_transfer_call.setter
    def telephony_transfer_call(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCallArgs']]):
        pulumi.set(self, "telephony_transfer_call", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTextArgs']]:
        """
        Returns a text response.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1IntentMessageTextArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentParameterArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 entity_type_display_name: Optional[pulumi.Input[str]] = None,
                 is_list: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prompts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Represents intent parameters.
        :param pulumi.Input[str] display_name: The name of the parameter.
        :param pulumi.Input[str] default_value: Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        :param pulumi.Input[str] entity_type_display_name: Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        :param pulumi.Input[bool] is_list: Optional. Indicates whether the parameter represents a list of values.
        :param pulumi.Input[bool] mandatory: Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        :param pulumi.Input[str] name: The unique identifier of this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prompts: Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        :param pulumi.Input[str] value: Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        pulumi.set(__self__, "display_name", display_name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if entity_type_display_name is not None:
            pulumi.set(__self__, "entity_type_display_name", entity_type_display_name)
        if is_list is not None:
            pulumi.set(__self__, "is_list", is_list)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="entityTypeDisplayName")
    def entity_type_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        """
        return pulumi.get(self, "entity_type_display_name")

    @entity_type_display_name.setter
    def entity_type_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_display_name", value)

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @is_list.setter
    def is_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_list", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of this parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prompts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        """
        return pulumi.get(self, "prompts")

    @prompts.setter
    def prompts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prompts", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input[str]] = None,
                 user_defined: Optional[pulumi.Input[bool]] = None):
        """
        Represents a part of a training phrase.
        :param pulumi.Input[str] text: The text for this part.
        :param pulumi.Input[str] alias: Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        :param pulumi.Input[str] entity_type: Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        :param pulumi.Input[bool] user_defined: Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        pulumi.set(__self__, "text", text)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if user_defined is not None:
            pulumi.set(__self__, "user_defined", user_defined)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        The text for this part.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="userDefined")
    def user_defined(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        return pulumi.get(self, "user_defined")

    @user_defined.setter
    def user_defined(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_defined", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1IntentTrainingPhraseArgs:
    def __init__(__self__, *,
                 parts: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs']]],
                 type: pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhraseType'],
                 times_added_count: Optional[pulumi.Input[int]] = None):
        """
        Represents an example that the agent is trained on.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs']]] parts: The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhraseType'] type: The type of the training phrase.
        :param pulumi.Input[int] times_added_count: Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        """
        pulumi.set(__self__, "parts", parts)
        pulumi.set(__self__, "type", type)
        if times_added_count is not None:
            pulumi.set(__self__, "times_added_count", times_added_count)

    @property
    @pulumi.getter
    def parts(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs']]]:
        """
        The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        """
        return pulumi.get(self, "parts")

    @parts.setter
    def parts(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhrasePartArgs']]]):
        pulumi.set(self, "parts", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhraseType']:
        """
        The type of the training phrase.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1IntentTrainingPhraseType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="timesAddedCount")
    def times_added_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        """
        return pulumi.get(self, "times_added_count")

    @times_added_count.setter
    def times_added_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "times_added_count", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1LoggingConfigArgs:
    def __init__(__self__, *,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None):
        """
        Defines logging behavior for conversation lifecycle events.
        :param pulumi.Input[bool] enable_stackdriver_logging: Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1NotificationConfigArgs:
    def __init__(__self__, *,
                 message_format: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigMessageFormat']] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Defines notification behavior.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigMessageFormat'] message_format: Format of message.
        :param pulumi.Input[str] topic: Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. For telephony integration to receive notification, make sure either this topic is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. For chat integration to receive notification, make sure API caller has been granted the `Dialogflow Service Agent` role for the topic. Format: `projects//locations//topics/`.
        """
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigMessageFormat']]:
        """
        Format of message.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1NotificationConfigMessageFormat']]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. For telephony integration to receive notification, make sure either this topic is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. For chat integration to receive notification, make sure API caller has been granted the `Dialogflow Service Agent` role for the topic. Format: `projects//locations//topics/`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1SpeechToTextConfigArgs:
    def __init__(__self__, *,
                 speech_model_variant: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SpeechToTextConfigSpeechModelVariant']] = None):
        """
        Configures speech transcription for ConversationProfile.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1SpeechToTextConfigSpeechModelVariant'] speech_model_variant: The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request. If enhanced model variant is specified and an enhanced version of the specified model for the language does not exist, then it would emit an error.
        """
        if speech_model_variant is not None:
            pulumi.set(__self__, "speech_model_variant", speech_model_variant)

    @property
    @pulumi.getter(name="speechModelVariant")
    def speech_model_variant(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SpeechToTextConfigSpeechModelVariant']]:
        """
        The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request. If enhanced model variant is specified and an enhanced version of the specified model for the language does not exist, then it would emit an error.
        """
        return pulumi.get(self, "speech_model_variant")

    @speech_model_variant.setter
    def speech_model_variant(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SpeechToTextConfigSpeechModelVariant']]):
        pulumi.set(self, "speech_model_variant", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1SuggestionFeatureArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureType']] = None):
        """
        The type of Human Agent Assistant API suggestion to perform, and the maximum number of results to return for that type. Multiple `Feature` objects can be specified in the `features` list.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureType'] type: Type of Human Agent Assistant API feature to request.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureType']]:
        """
        Type of Human Agent Assistant API feature to request.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2beta1SuggestionFeatureType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDialogflowV2beta1TextToSpeechSettingsArgs:
    def __init__(__self__, *,
                 output_audio_encoding: pulumi.Input['GoogleCloudDialogflowV2beta1TextToSpeechSettingsOutputAudioEncoding'],
                 enable_text_to_speech: Optional[pulumi.Input[bool]] = None,
                 sample_rate_hertz: Optional[pulumi.Input[int]] = None,
                 synthesize_speech_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Instructs the speech synthesizer on how to generate the output audio content.
        :param pulumi.Input['GoogleCloudDialogflowV2beta1TextToSpeechSettingsOutputAudioEncoding'] output_audio_encoding: Audio encoding of the synthesized audio content.
        :param pulumi.Input[bool] enable_text_to_speech: Optional. Indicates whether text to speech is enabled. Even when this field is false, other settings in this proto are still retained.
        :param pulumi.Input[int] sample_rate_hertz: Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then the synthesizer will use the default sample rate based on the audio encoding. If this is different from the voice's natural sample rate, then the synthesizer will honor this request by converting to the desired sample rate (which might result in worse audio quality).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] synthesize_speech_configs: Optional. Configuration of how speech should be synthesized, mapping from language (https://cloud.google.com/dialogflow/docs/reference/language) to SynthesizeSpeechConfig.
        """
        pulumi.set(__self__, "output_audio_encoding", output_audio_encoding)
        if enable_text_to_speech is not None:
            pulumi.set(__self__, "enable_text_to_speech", enable_text_to_speech)
        if sample_rate_hertz is not None:
            pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)
        if synthesize_speech_configs is not None:
            pulumi.set(__self__, "synthesize_speech_configs", synthesize_speech_configs)

    @property
    @pulumi.getter(name="outputAudioEncoding")
    def output_audio_encoding(self) -> pulumi.Input['GoogleCloudDialogflowV2beta1TextToSpeechSettingsOutputAudioEncoding']:
        """
        Audio encoding of the synthesized audio content.
        """
        return pulumi.get(self, "output_audio_encoding")

    @output_audio_encoding.setter
    def output_audio_encoding(self, value: pulumi.Input['GoogleCloudDialogflowV2beta1TextToSpeechSettingsOutputAudioEncoding']):
        pulumi.set(self, "output_audio_encoding", value)

    @property
    @pulumi.getter(name="enableTextToSpeech")
    def enable_text_to_speech(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether text to speech is enabled. Even when this field is false, other settings in this proto are still retained.
        """
        return pulumi.get(self, "enable_text_to_speech")

    @enable_text_to_speech.setter
    def enable_text_to_speech(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_text_to_speech", value)

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then the synthesizer will use the default sample rate based on the audio encoding. If this is different from the voice's natural sample rate, then the synthesizer will honor this request by converting to the desired sample rate (which might result in worse audio quality).
        """
        return pulumi.get(self, "sample_rate_hertz")

    @sample_rate_hertz.setter
    def sample_rate_hertz(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_rate_hertz", value)

    @property
    @pulumi.getter(name="synthesizeSpeechConfigs")
    def synthesize_speech_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Configuration of how speech should be synthesized, mapping from language (https://cloud.google.com/dialogflow/docs/reference/language) to SynthesizeSpeechConfig.
        """
        return pulumi.get(self, "synthesize_speech_configs")

    @synthesize_speech_configs.setter
    def synthesize_speech_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "synthesize_speech_configs", value)


