# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs',
    'GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs',
    'GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs',
    'GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs',
    'GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs',
    'GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs',
    'GoogleCloudDatapipelinesV1ScheduleSpecArgs',
    'GoogleCloudDatapipelinesV1WorkloadArgs',
]

@pulumi.input_type
class GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[bool]] = None,
                 flexrs_goal: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentFlexrsGoal']] = None,
                 ip_configuration: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentIpConfiguration']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 temp_location: Optional[pulumi.Input[str]] = None,
                 worker_region: Optional[pulumi.Input[str]] = None,
                 worker_zone: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The environment values to be set at runtime for a Flex Template.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_experiments: Additional experiment flags for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_user_labels: Additional user labels to be specified for the job. Keys and values must follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions). An object containing a list of key/value pairs. Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
        :param pulumi.Input[bool] enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentFlexrsGoal'] flexrs_goal: Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        :param pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentIpConfiguration'] ip_configuration: Configuration for VM IPs.
        :param pulumi.Input[str] kms_key_name: Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        :param pulumi.Input[str] machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param pulumi.Input[int] max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[int] num_workers: The initial number of Compute Engine instances for the job.
        :param pulumi.Input[str] service_account_email: The email address of the service account to run the job as.
        :param pulumi.Input[str] subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param pulumi.Input[str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        :param pulumi.Input[str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, defaults to the control plane region.
        :param pulumi.Input[str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        :param pulumi.Input[str] zone: The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if flexrs_goal is not None:
            pulumi.set(__self__, "flexrs_goal", flexrs_goal)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional user labels to be specified for the job. Keys and values must follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions). An object containing a list of key/value pairs. Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
        """
        return pulumi.get(self, "additional_user_labels")

    @additional_user_labels.setter
    def additional_user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_user_labels", value)

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @property
    @pulumi.getter(name="flexrsGoal")
    def flexrs_goal(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentFlexrsGoal']]:
        """
        Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        """
        return pulumi.get(self, "flexrs_goal")

    @flexrs_goal.setter
    def flexrs_goal(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentFlexrsGoal']]):
        pulumi.set(self, "flexrs_goal", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentIpConfiguration']]:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentIpConfiguration']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_location", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, defaults to the control plane region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs:
    def __init__(__self__, *,
                 job_name: pulumi.Input[str],
                 container_spec_gcs_path: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs']] = None,
                 launch_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transform_name_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 update: Optional[pulumi.Input[bool]] = None):
        """
        Launch Flex Template parameter.
        :param pulumi.Input[str] job_name: The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        :param pulumi.Input[str] container_spec_gcs_path: Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        :param pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs'] environment: The runtime environment for the Flex Template job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] launch_options: Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The parameters for the Flex Template. Example: `{"num_workers":"5"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] transform_name_mappings: Use this to pass transform name mappings for streaming update jobs. Example: `{"oldTransformName":"newTransformName",...}`
        :param pulumi.Input[bool] update: Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        pulumi.set(__self__, "job_name", job_name)
        if container_spec_gcs_path is not None:
            pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mappings is not None:
            pulumi.set(__self__, "transform_name_mappings", transform_name_mappings)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @container_spec_gcs_path.setter
    def container_spec_gcs_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_spec_gcs_path", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs']]:
        """
        The runtime environment for the Flex Template job.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        """
        return pulumi.get(self, "launch_options")

    @launch_options.setter
    def launch_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "launch_options", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The parameters for the Flex Template. Example: `{"num_workers":"5"}`
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="transformNameMappings")
    def transform_name_mappings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Use this to pass transform name mappings for streaming update jobs. Example: `{"oldTransformName":"newTransformName",...}`
        """
        return pulumi.get(self, "transform_name_mappings")

    @transform_name_mappings.setter
    def transform_name_mappings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "transform_name_mappings", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs:
    def __init__(__self__, *,
                 launch_parameter: pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs'],
                 location: pulumi.Input[str],
                 project: pulumi.Input[str],
                 validate_only: Optional[pulumi.Input[bool]] = None):
        """
        A request to launch a Dataflow job from a Flex Template.
        :param pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs'] launch_parameter: Parameter to launch a job from a Flex Template.
        :param pulumi.Input[str] location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request. For example, `us-central1`, `us-west1`.
        :param pulumi.Input[str] project: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[bool] validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "launch_parameter", launch_parameter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="launchParameter")
    def launch_parameter(self) -> pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs']:
        """
        Parameter to launch a job from a Flex Template.
        """
        return pulumi.get(self, "launch_parameter")

    @launch_parameter.setter
    def launch_parameter(self, value: pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterArgs']):
        pulumi.set(self, "launch_parameter", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request. For example, `us-central1`, `us-west1`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_only", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs:
    def __init__(__self__, *,
                 job_name: pulumi.Input[str],
                 environment: Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 update: Optional[pulumi.Input[bool]] = None):
        """
        Parameters to provide to the template being launched.
        :param pulumi.Input[str] job_name: The job name to use for the created job.
        :param pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs'] environment: The runtime environment for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The runtime parameters to pass to the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] transform_name_mapping: Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        :param pulumi.Input[bool] update: If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        pulumi.set(__self__, "job_name", job_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        The job name to use for the created job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs']]:
        """
        The runtime environment for the job.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The runtime parameters to pass to the job.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        """
        return pulumi.get(self, "transform_name_mapping")

    @transform_name_mapping.setter
    def transform_name_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "transform_name_mapping", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 gcs_path: Optional[pulumi.Input[str]] = None,
                 launch_parameters: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None):
        """
        A request to launch a template.
        :param pulumi.Input[str] project: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[str] gcs_path: A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        :param pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs'] launch_parameters: The parameters of the template to launch. This should be part of the body of the POST request.
        :param pulumi.Input[str] location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request.
        :param pulumi.Input[bool] validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "project", project)
        if gcs_path is not None:
            pulumi.set(__self__, "gcs_path", gcs_path)
        if launch_parameters is not None:
            pulumi.set(__self__, "launch_parameters", launch_parameters)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> Optional[pulumi.Input[str]]:
        """
        A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        """
        return pulumi.get(self, "gcs_path")

    @gcs_path.setter
    def gcs_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcs_path", value)

    @property
    @pulumi.getter(name="launchParameters")
    def launch_parameters(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs']]:
        """
        The parameters of the template to launch. This should be part of the body of the POST request.
        """
        return pulumi.get(self, "launch_parameters")

    @launch_parameters.setter
    def launch_parameters(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateParametersArgs']]):
        pulumi.set(self, "launch_parameters", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_only", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1RuntimeEnvironmentArgs:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bypass_temp_dir_validation: Optional[pulumi.Input[bool]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[bool]] = None,
                 ip_configuration: Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentIpConfiguration']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 temp_location: Optional[pulumi.Input[str]] = None,
                 worker_region: Optional[pulumi.Input[str]] = None,
                 worker_zone: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The environment values to set at runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_experiments: Additional experiment flags for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of key/value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        :param pulumi.Input[bool] bypass_temp_dir_validation: Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        :param pulumi.Input[bool] enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentIpConfiguration'] ip_configuration: Configuration for VM IPs.
        :param pulumi.Input[str] kms_key_name: Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/
        :param pulumi.Input[str] machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param pulumi.Input[int] max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[int] num_workers: The initial number of Compute Engine instances for the job.
        :param pulumi.Input[str] service_account_email: The email address of the service account to run the job as.
        :param pulumi.Input[str] subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param pulumi.Input[str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        :param pulumi.Input[str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        :param pulumi.Input[str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        :param pulumi.Input[str] zone: The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if bypass_temp_dir_validation is not None:
            pulumi.set(__self__, "bypass_temp_dir_validation", bypass_temp_dir_validation)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of key/value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        """
        return pulumi.get(self, "additional_user_labels")

    @additional_user_labels.setter
    def additional_user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_user_labels", value)

    @property
    @pulumi.getter(name="bypassTempDirValidation")
    def bypass_temp_dir_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        return pulumi.get(self, "bypass_temp_dir_validation")

    @bypass_temp_dir_validation.setter
    def bypass_temp_dir_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_temp_dir_validation", value)

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentIpConfiguration']]:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1RuntimeEnvironmentIpConfiguration']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_location", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1ScheduleSpecArgs:
    def __init__(__self__, *,
                 schedule: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Details of the schedule the pipeline runs on.
        :param pulumi.Input[str] schedule: Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        :param pulumi.Input[str] time_zone: Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class GoogleCloudDatapipelinesV1WorkloadArgs:
    def __init__(__self__, *,
                 dataflow_flex_template_request: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs']] = None,
                 dataflow_launch_template_request: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs']] = None):
        """
        Workload details for creating the pipeline jobs.
        :param pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs'] dataflow_flex_template_request: Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        :param pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs'] dataflow_launch_template_request: Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        """
        if dataflow_flex_template_request is not None:
            pulumi.set(__self__, "dataflow_flex_template_request", dataflow_flex_template_request)
        if dataflow_launch_template_request is not None:
            pulumi.set(__self__, "dataflow_launch_template_request", dataflow_launch_template_request)

    @property
    @pulumi.getter(name="dataflowFlexTemplateRequest")
    def dataflow_flex_template_request(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs']]:
        """
        Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        """
        return pulumi.get(self, "dataflow_flex_template_request")

    @dataflow_flex_template_request.setter
    def dataflow_flex_template_request(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestArgs']]):
        pulumi.set(self, "dataflow_flex_template_request", value)

    @property
    @pulumi.getter(name="dataflowLaunchTemplateRequest")
    def dataflow_launch_template_request(self) -> Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs']]:
        """
        Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        """
        return pulumi.get(self, "dataflow_launch_template_request")

    @dataflow_launch_template_request.setter
    def dataflow_launch_template_request(self, value: Optional[pulumi.Input['GoogleCloudDatapipelinesV1LaunchTemplateRequestArgs']]):
        pulumi.set(self, "dataflow_launch_template_request", value)


