# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AllowedIpRangeArgs',
    'DatabaseConfigArgs',
    'EncryptionConfigArgs',
    'EnvironmentConfigArgs',
    'IPAllocationPolicyArgs',
    'MaintenanceWindowArgs',
    'NodeConfigArgs',
    'PrivateClusterConfigArgs',
    'PrivateEnvironmentConfigArgs',
    'SchedulerResourceArgs',
    'SoftwareConfigArgs',
    'WebServerConfigArgs',
    'WebServerNetworkAccessControlArgs',
    'WebServerResourceArgs',
    'WorkerResourceArgs',
    'WorkloadsConfigArgs',
]

@pulumi.input_type
class AllowedIpRangeArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Allowed IP range with user-provided description.
        :param pulumi.Input[str] description: Optional. User-provided description. It must contain at most 300 characters.
        :param pulumi.Input[str] value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-provided description. It must contain at most 300 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DatabaseConfigArgs:
    def __init__(__self__, *,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


@pulumi.input_type
class EncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        The encryption options for the Cloud Composer environment and its dependencies.Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class EnvironmentConfigArgs:
    def __init__(__self__, *,
                 database_config: Optional[pulumi.Input['DatabaseConfigArgs']] = None,
                 encryption_config: Optional[pulumi.Input['EncryptionConfigArgs']] = None,
                 environment_size: Optional[pulumi.Input['EnvironmentConfigEnvironmentSize']] = None,
                 maintenance_window: Optional[pulumi.Input['MaintenanceWindowArgs']] = None,
                 node_config: Optional[pulumi.Input['NodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 private_environment_config: Optional[pulumi.Input['PrivateEnvironmentConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['SoftwareConfigArgs']] = None,
                 web_server_config: Optional[pulumi.Input['WebServerConfigArgs']] = None,
                 web_server_network_access_control: Optional[pulumi.Input['WebServerNetworkAccessControlArgs']] = None,
                 workloads_config: Optional[pulumi.Input['WorkloadsConfigArgs']] = None):
        """
        Configuration information for an environment.
        :param pulumi.Input['DatabaseConfigArgs'] database_config: Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['EncryptionConfigArgs'] encryption_config: Optional. The encryption options for the Cloud Composer environment and its dependencies. Cannot be updated.
        :param pulumi.Input['EnvironmentConfigEnvironmentSize'] environment_size: Optional. The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input['MaintenanceWindowArgs'] maintenance_window: Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, the default value for maintenance window will be applied. The default value is Saturday and Sunday 00-06 GMT.
        :param pulumi.Input['NodeConfigArgs'] node_config: The configuration used for the Kubernetes Engine cluster.
        :param pulumi.Input[int] node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['PrivateEnvironmentConfigArgs'] private_environment_config: The configuration used for the Private IP Cloud Composer environment.
        :param pulumi.Input['SoftwareConfigArgs'] software_config: The configuration settings for software inside the environment.
        :param pulumi.Input['WebServerConfigArgs'] web_server_config: Optional. The configuration settings for the Airflow web server App Engine instance.
        :param pulumi.Input['WebServerNetworkAccessControlArgs'] web_server_network_access_control: Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        :param pulumi.Input['WorkloadsConfigArgs'] workloads_config: Optional. The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. The GKE cluster runs Airflow scheduler, web server and workers workloads. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        if database_config is not None:
            pulumi.set(__self__, "database_config", database_config)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if environment_size is not None:
            pulumi.set(__self__, "environment_size", environment_size)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if private_environment_config is not None:
            pulumi.set(__self__, "private_environment_config", private_environment_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if web_server_config is not None:
            pulumi.set(__self__, "web_server_config", web_server_config)
        if web_server_network_access_control is not None:
            pulumi.set(__self__, "web_server_network_access_control", web_server_network_access_control)
        if workloads_config is not None:
            pulumi.set(__self__, "workloads_config", workloads_config)

    @property
    @pulumi.getter(name="databaseConfig")
    def database_config(self) -> Optional[pulumi.Input['DatabaseConfigArgs']]:
        """
        Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "database_config")

    @database_config.setter
    def database_config(self, value: Optional[pulumi.Input['DatabaseConfigArgs']]):
        pulumi.set(self, "database_config", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['EncryptionConfigArgs']]:
        """
        Optional. The encryption options for the Cloud Composer environment and its dependencies. Cannot be updated.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['EncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="environmentSize")
    def environment_size(self) -> Optional[pulumi.Input['EnvironmentConfigEnvironmentSize']]:
        """
        Optional. The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "environment_size")

    @environment_size.setter
    def environment_size(self, value: Optional[pulumi.Input['EnvironmentConfigEnvironmentSize']]):
        pulumi.set(self, "environment_size", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MaintenanceWindowArgs']]:
        """
        Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, the default value for maintenance window will be applied. The default value is Saturday and Sunday 00-06 GMT.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodeConfigArgs']]:
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="privateEnvironmentConfig")
    def private_environment_config(self) -> Optional[pulumi.Input['PrivateEnvironmentConfigArgs']]:
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_config")

    @private_environment_config.setter
    def private_environment_config(self, value: Optional[pulumi.Input['PrivateEnvironmentConfigArgs']]):
        pulumi.set(self, "private_environment_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['SoftwareConfigArgs']]:
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['SoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="webServerConfig")
    def web_server_config(self) -> Optional[pulumi.Input['WebServerConfigArgs']]:
        """
        Optional. The configuration settings for the Airflow web server App Engine instance.
        """
        return pulumi.get(self, "web_server_config")

    @web_server_config.setter
    def web_server_config(self, value: Optional[pulumi.Input['WebServerConfigArgs']]):
        pulumi.set(self, "web_server_config", value)

    @property
    @pulumi.getter(name="webServerNetworkAccessControl")
    def web_server_network_access_control(self) -> Optional[pulumi.Input['WebServerNetworkAccessControlArgs']]:
        """
        Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        """
        return pulumi.get(self, "web_server_network_access_control")

    @web_server_network_access_control.setter
    def web_server_network_access_control(self, value: Optional[pulumi.Input['WebServerNetworkAccessControlArgs']]):
        pulumi.set(self, "web_server_network_access_control", value)

    @property
    @pulumi.getter(name="workloadsConfig")
    def workloads_config(self) -> Optional[pulumi.Input['WorkloadsConfigArgs']]:
        """
        Optional. The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. The GKE cluster runs Airflow scheduler, web server and workers workloads. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "workloads_config")

    @workloads_config.setter
    def workloads_config(self, value: Optional[pulumi.Input['WorkloadsConfigArgs']]):
        pulumi.set(self, "workloads_config", value)


@pulumi.input_type
class IPAllocationPolicyArgs:
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cluster_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 services_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 services_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 use_ip_aliases: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for controlling how IPs are allocated in the GKE cluster running the Apache Airflow software.
        :param pulumi.Input[str] cluster_ipv4_cidr_block: Optional. The IP address range used to allocate IP addresses to pods in the GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param pulumi.Input[str] cluster_secondary_range_name: Optional. The name of the GKE cluster's secondary range used to allocate IP addresses to pods. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true.
        :param pulumi.Input[str] services_ipv4_cidr_block: Optional. The IP address range of the services IP addresses in this GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param pulumi.Input[str] services_secondary_range_name: Optional. The name of the services' secondary range used to allocate IP addresses to the GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true.
        :param pulumi.Input[bool] use_ip_aliases: Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        if use_ip_aliases is not None:
            pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The IP address range used to allocate IP addresses to pods in the GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @cluster_ipv4_cidr_block.setter
    def cluster_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the GKE cluster's secondary range used to allocate IP addresses to pods. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @cluster_secondary_range_name.setter
    def cluster_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_secondary_range_name", value)

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The IP address range of the services IP addresses in this GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @services_ipv4_cidr_block.setter
    def services_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the services' secondary range used to allocate IP addresses to the GKE cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @services_secondary_range_name.setter
    def services_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_secondary_range_name", value)

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        return pulumi.get(self, "use_ip_aliases")

    @use_ip_aliases.setter
    def use_ip_aliases(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ip_aliases", value)


@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[str],
                 recurrence: pulumi.Input[str],
                 start_time: pulumi.Input[str]):
        """
        The configuration settings for Cloud Composer maintenance window. The following example: ``` { "startTime":"2019-08-01T01:00:00Z" "endTime":"2019-08-01T07:00:00Z" "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE" } ``` would define a maintenance window between 01 and 07 hours UTC during each Tuesday and Wednesday.
        :param pulumi.Input[str] end_time: Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to `start_time`.
        :param pulumi.Input[str] recurrence: Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        :param pulumi.Input[str] start_time: Start time of the first recurrence of the maintenance window.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to `start_time`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def recurrence(self) -> pulumi.Input[str]:
        """
        Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: pulumi.Input[str]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class NodeConfigArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 ip_allocation_policy: Optional[pulumi.Input['IPAllocationPolicyArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration information for the Kubernetes Engine nodes running the Apache Airflow software.
        :param pulumi.Input[int] disk_size_gb: Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['IPAllocationPolicyArgs'] ip_allocation_policy: Optional. The configuration for controlling how IPs are allocated in the GKE cluster.
        :param pulumi.Input[str] location: Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] machine_type: Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1". This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] network: Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the "default" network ID in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] service_account: Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        :param pulumi.Input[str] subnetwork: Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional[pulumi.Input['IPAllocationPolicyArgs']]:
        """
        Optional. The configuration for controlling how IPs are allocated in the GKE cluster.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @ip_allocation_policy.setter
    def ip_allocation_policy(self, value: Optional[pulumi.Input['IPAllocationPolicyArgs']]):
        pulumi.set(self, "ip_allocation_policy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1". This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the "default" network ID in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PrivateClusterConfigArgs:
    def __init__(__self__, *,
                 enable_private_endpoint: Optional[pulumi.Input[bool]] = None,
                 master_ipv4_cidr_block: Optional[pulumi.Input[str]] = None):
        """
        Configuration options for the private GKE cluster in a Cloud Composer environment.
        :param pulumi.Input[bool] enable_private_endpoint: Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        :param pulumi.Input[str] master_ipv4_cidr_block: Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        """
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @enable_private_endpoint.setter
    def enable_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_endpoint", value)

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @master_ipv4_cidr_block.setter
    def master_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_ipv4_cidr_block", value)


@pulumi.input_type
class PrivateEnvironmentConfigArgs:
    def __init__(__self__, *,
                 cloud_composer_connection_subnetwork: Optional[pulumi.Input[str]] = None,
                 cloud_composer_network_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cloud_sql_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 enable_private_environment: Optional[pulumi.Input[bool]] = None,
                 private_cluster_config: Optional[pulumi.Input['PrivateClusterConfigArgs']] = None,
                 web_server_ipv4_cidr_block: Optional[pulumi.Input[str]] = None):
        """
        The configuration information for configuring a Private IP Cloud Composer environment.
        :param pulumi.Input[str] cloud_composer_connection_subnetwork: Optional. When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork.
        :param pulumi.Input[str] cloud_composer_network_ipv4_cidr_block: Optional. The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input[str] cloud_sql_ipv4_cidr_block: Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from `web_server_ipv4_cidr_block`.
        :param pulumi.Input[bool] enable_private_environment: Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['PrivateClusterConfigArgs'] private_cluster_config: Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        :param pulumi.Input[str] web_server_ipv4_cidr_block: Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from `private_cluster_config.master_ipv4_cidr_block` and `cloud_sql_ipv4_cidr_block`. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if cloud_composer_connection_subnetwork is not None:
            pulumi.set(__self__, "cloud_composer_connection_subnetwork", cloud_composer_connection_subnetwork)
        if cloud_composer_network_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_composer_network_ipv4_cidr_block", cloud_composer_network_ipv4_cidr_block)
        if cloud_sql_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        if enable_private_environment is not None:
            pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        if private_cluster_config is not None:
            pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if web_server_ipv4_cidr_block is not None:
            pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)

    @property
    @pulumi.getter(name="cloudComposerConnectionSubnetwork")
    def cloud_composer_connection_subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork.
        """
        return pulumi.get(self, "cloud_composer_connection_subnetwork")

    @cloud_composer_connection_subnetwork.setter
    def cloud_composer_connection_subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_composer_connection_subnetwork", value)

    @property
    @pulumi.getter(name="cloudComposerNetworkIpv4CidrBlock")
    def cloud_composer_network_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_network_ipv4_cidr_block")

    @cloud_composer_network_ipv4_cidr_block.setter
    def cloud_composer_network_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_composer_network_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from `web_server_ipv4_cidr_block`.
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @cloud_sql_ipv4_cidr_block.setter
    def cloud_sql_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "enable_private_environment")

    @enable_private_environment.setter
    def enable_private_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_environment", value)

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> Optional[pulumi.Input['PrivateClusterConfigArgs']]:
        """
        Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_cluster_config")

    @private_cluster_config.setter
    def private_cluster_config(self, value: Optional[pulumi.Input['PrivateClusterConfigArgs']]):
        pulumi.set(self, "private_cluster_config", value)

    @property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from `private_cluster_config.master_ipv4_cidr_block` and `cloud_sql_ipv4_cidr_block`. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")

    @web_server_ipv4_cidr_block.setter
    def web_server_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_ipv4_cidr_block", value)


@pulumi.input_type
class SchedulerResourceArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        Configuration for resources used by Airflow schedulers.
        :param pulumi.Input[int] count: Optional. The number of schedulers.
        :param pulumi.Input[float] cpu: Optional. CPU request and limit for a single Airflow scheduler replica.
        :param pulumi.Input[float] memory_gb: Optional. Memory (GB) request and limit for a single Airflow scheduler replica.
        :param pulumi.Input[float] storage_gb: Optional. Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of schedulers.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. CPU request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Memory (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


@pulumi.input_type
class SoftwareConfigArgs:
    def __init__(__self__, *,
                 airflow_config_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 pypi_packages: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_version: Optional[pulumi.Input[str]] = None,
                 scheduler_count: Optional[pulumi.Input[int]] = None):
        """
        Specifies the selection and configuration of software inside the environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_config_overrides: Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        :param pulumi.Input[str] image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pypi_packages: Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param pulumi.Input[str] python_version: Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be updated. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        :param pulumi.Input[int] scheduler_count: Optional. The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        if airflow_config_overrides is not None:
            pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if pypi_packages is not None:
            pulumi.set(__self__, "pypi_packages", pypi_packages)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if scheduler_count is not None:
            pulumi.set(__self__, "scheduler_count", scheduler_count)

    @property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @airflow_config_overrides.setter
    def airflow_config_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "airflow_config_overrides", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @pypi_packages.setter
    def pypi_packages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pypi_packages", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be updated. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)

    @property
    @pulumi.getter(name="schedulerCount")
    def scheduler_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        return pulumi.get(self, "scheduler_count")

    @scheduler_count.setter
    def scheduler_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scheduler_count", value)


@pulumi.input_type
class WebServerConfigArgs:
    def __init__(__self__, *,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings for the Airflow web server App Engine instance. Supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*
        :param pulumi.Input[str] machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


@pulumi.input_type
class WebServerNetworkAccessControlArgs:
    def __init__(__self__, *,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]] = None):
        """
        Network-level access control policy for the Airflow web server.
        :param pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]]:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]]):
        pulumi.set(self, "allowed_ip_ranges", value)


@pulumi.input_type
class WebServerResourceArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        Configuration for resources used by Airflow web server.
        :param pulumi.Input[float] cpu: Optional. CPU request and limit for Airflow web server.
        :param pulumi.Input[float] memory_gb: Optional. Memory (GB) request and limit for Airflow web server.
        :param pulumi.Input[float] storage_gb: Optional. Storage (GB) request and limit for Airflow web server.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. CPU request and limit for Airflow web server.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Memory (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Storage (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


@pulumi.input_type
class WorkerResourceArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        Configuration for resources used by Airflow workers.
        :param pulumi.Input[float] cpu: Optional. CPU request and limit for a single Airflow worker replica.
        :param pulumi.Input[int] max_count: Optional. Maximum number of workers for autoscaling.
        :param pulumi.Input[float] memory_gb: Optional. Memory (GB) request and limit for a single Airflow worker replica.
        :param pulumi.Input[int] min_count: Optional. Minimum number of workers for autoscaling.
        :param pulumi.Input[float] storage_gb: Optional. Storage (GB) request and limit for a single Airflow worker replica.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. CPU request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of workers for autoscaling.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Memory (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Minimum number of workers for autoscaling.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Storage (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


@pulumi.input_type
class WorkloadsConfigArgs:
    def __init__(__self__, *,
                 scheduler: Optional[pulumi.Input['SchedulerResourceArgs']] = None,
                 web_server: Optional[pulumi.Input['WebServerResourceArgs']] = None,
                 worker: Optional[pulumi.Input['WorkerResourceArgs']] = None):
        """
        The Kubernetes workloads configuration for GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input['SchedulerResourceArgs'] scheduler: Optional. Resources used by Airflow schedulers.
        :param pulumi.Input['WebServerResourceArgs'] web_server: Optional. Resources used by Airflow web server.
        :param pulumi.Input['WorkerResourceArgs'] worker: Optional. Resources used by Airflow workers.
        """
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if web_server is not None:
            pulumi.set(__self__, "web_server", web_server)
        if worker is not None:
            pulumi.set(__self__, "worker", worker)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input['SchedulerResourceArgs']]:
        """
        Optional. Resources used by Airflow schedulers.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input['SchedulerResourceArgs']]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="webServer")
    def web_server(self) -> Optional[pulumi.Input['WebServerResourceArgs']]:
        """
        Optional. Resources used by Airflow web server.
        """
        return pulumi.get(self, "web_server")

    @web_server.setter
    def web_server(self, value: Optional[pulumi.Input['WebServerResourceArgs']]):
        pulumi.set(self, "web_server", value)

    @property
    @pulumi.getter
    def worker(self) -> Optional[pulumi.Input['WorkerResourceArgs']]:
        """
        Optional. Resources used by Airflow workers.
        """
        return pulumi.get(self, "worker")

    @worker.setter
    def worker(self, value: Optional[pulumi.Input['WorkerResourceArgs']]):
        pulumi.set(self, "worker", value)


