# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppEngineHttpTargetResponse',
    'AppEngineRoutingResponse',
    'HttpTargetResponse',
    'OAuthTokenResponse',
    'OidcTokenResponse',
    'PubsubTargetResponse',
    'RetryConfigResponse',
    'StatusResponse',
]

@pulumi.output_type
class AppEngineHttpTargetResponse(dict):
    """
    App Engine target. The job will be pushed to a job handler by means of an HTTP request via an http_method such as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an HTTP response code in the range [200 - 299]. Error 503 is considered an App Engine system error instead of an application error. Requests returning error 503 will be retried regardless of retry configuration and not counted against retry counts. Any other response code, or a failure to receive a response before the deadline, constitutes a failed attempt.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appEngineRouting":
            suggest = "app_engine_routing"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "relativeUri":
            suggest = "relative_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEngineHttpTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEngineHttpTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEngineHttpTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_engine_routing: 'outputs.AppEngineRoutingResponse',
                 body: str,
                 headers: Mapping[str, str],
                 http_method: str,
                 relative_uri: str):
        """
        App Engine target. The job will be pushed to a job handler by means of an HTTP request via an http_method such as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an HTTP response code in the range [200 - 299]. Error 503 is considered an App Engine system error instead of an application error. Requests returning error 503 will be retried regardless of retry configuration and not counted against retry counts. Any other response code, or a failure to receive a response before the deadline, constitutes a failed attempt.
        :param 'AppEngineRoutingResponse' app_engine_routing: App Engine Routing setting for the job.
        :param str body: Body. HTTP request body. A request body is allowed only if the HTTP method is POST or PUT. It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
        :param Mapping[str, str] headers: HTTP request headers. This map contains the header field names and values. Headers can be set when the job is created. Cloud Scheduler sets some headers to default values: * `User-Agent`: By default, this header is `"AppEngine-Google; (+http://code.google.com/appengine)"`. This header can be modified, but Cloud Scheduler will append `"AppEngine-Google; (+http://code.google.com/appengine)"` to the modified `User-Agent`. * `X-CloudScheduler`: This header will be set to true. * `X-CloudScheduler-JobName`: This header will contain the job name. * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in the unix-cron format, this header will contain the job schedule time in RFC3339 UTC "Zulu" format. If the job has an body, Cloud Scheduler sets the following headers: * `Content-Type`: By default, the `Content-Type` header is set to `"application/octet-stream"`. The default can be overridden by explictly setting `Content-Type` to a particular media type when the job is created. For example, `Content-Type` can be set to `"application/json"`. * `Content-Length`: This is computed by Cloud Scheduler. This value is output only. It cannot be changed. The headers below are output only. They cannot be set or overridden: * `X-Google-*`: For Google internal use only. * `X-AppEngine-*`: For Google internal use only. In addition, some App Engine headers, which contain job-specific information, are also be sent to the job handler.
        :param str http_method: The HTTP method to use for the request. PATCH and OPTIONS are not permitted.
        :param str relative_uri: The relative URI. The relative URL must begin with "/" and must be a valid HTTP relative URL. It can contain a path, query string arguments, and `#` fragments. If the relative URL is empty, then the root path "/" will be used. No spaces are allowed, and the maximum length allowed is 2083 characters.
        """
        pulumi.set(__self__, "app_engine_routing", app_engine_routing)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "relative_uri", relative_uri)

    @property
    @pulumi.getter(name="appEngineRouting")
    def app_engine_routing(self) -> 'outputs.AppEngineRoutingResponse':
        """
        App Engine Routing setting for the job.
        """
        return pulumi.get(self, "app_engine_routing")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        Body. HTTP request body. A request body is allowed only if the HTTP method is POST or PUT. It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        """
        HTTP request headers. This map contains the header field names and values. Headers can be set when the job is created. Cloud Scheduler sets some headers to default values: * `User-Agent`: By default, this header is `"AppEngine-Google; (+http://code.google.com/appengine)"`. This header can be modified, but Cloud Scheduler will append `"AppEngine-Google; (+http://code.google.com/appengine)"` to the modified `User-Agent`. * `X-CloudScheduler`: This header will be set to true. * `X-CloudScheduler-JobName`: This header will contain the job name. * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in the unix-cron format, this header will contain the job schedule time in RFC3339 UTC "Zulu" format. If the job has an body, Cloud Scheduler sets the following headers: * `Content-Type`: By default, the `Content-Type` header is set to `"application/octet-stream"`. The default can be overridden by explictly setting `Content-Type` to a particular media type when the job is created. For example, `Content-Type` can be set to `"application/json"`. * `Content-Length`: This is computed by Cloud Scheduler. This value is output only. It cannot be changed. The headers below are output only. They cannot be set or overridden: * `X-Google-*`: For Google internal use only. * `X-AppEngine-*`: For Google internal use only. In addition, some App Engine headers, which contain job-specific information, are also be sent to the job handler.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> str:
        """
        The HTTP method to use for the request. PATCH and OPTIONS are not permitted.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="relativeUri")
    def relative_uri(self) -> str:
        """
        The relative URI. The relative URL must begin with "/" and must be a valid HTTP relative URL. It can contain a path, query string arguments, and `#` fragments. If the relative URL is empty, then the root path "/" will be used. No spaces are allowed, and the maximum length allowed is 2083 characters.
        """
        return pulumi.get(self, "relative_uri")


@pulumi.output_type
class AppEngineRoutingResponse(dict):
    """
    App Engine Routing. For more information about services, versions, and instances see [An Overview of App Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine), [Microservices Architecture on Google App Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine), [App Engine Standard request routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed), and [App Engine Flex request routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
    """
    def __init__(__self__, *,
                 host: str,
                 instance: str,
                 service: str,
                 version: str):
        """
        App Engine Routing. For more information about services, versions, and instances see [An Overview of App Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine), [Microservices Architecture on Google App Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine), [App Engine Standard request routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed), and [App Engine Flex request routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
        :param str host: The host that the job is sent to. For more information about how App Engine requests are routed, see [here](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed). The host is constructed as: * `host = [application_domain_name]` `| [service] + '.' + [application_domain_name]` `| [version] + '.' + [application_domain_name]` `| [version_dot_service]+ '.' + [application_domain_name]` `| [instance] + '.' + [application_domain_name]` `| [instance_dot_service] + '.' + [application_domain_name]` `| [instance_dot_version] + '.' + [application_domain_name]` `| [instance_dot_version_dot_service] + '.' + [application_domain_name]` * `application_domain_name` = The domain name of the app, for example .appspot.com, which is associated with the job's project ID. * `service =` service * `version =` version * `version_dot_service =` version `+ '.' +` service * `instance =` instance * `instance_dot_service =` instance `+ '.' +` service * `instance_dot_version =` instance `+ '.' +` version * `instance_dot_version_dot_service =` instance `+ '.' +` version `+ '.' +` service If service is empty, then the job will be sent to the service which is the default service when the job is attempted. If version is empty, then the job will be sent to the version which is the default version when the job is attempted. If instance is empty, then the job will be sent to an instance which is available when the job is attempted. If service, version, or instance is invalid, then the job will be sent to the default version of the default service when the job is attempted.
        :param str instance: App instance. By default, the job is sent to an instance which is available when the job is attempted. Requests can only be sent to a specific instance if [manual scaling is used in App Engine Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?#scaling_types_and_instance_classes). App Engine Flex does not support instances. For more information, see [App Engine Standard request routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed) and [App Engine Flex request routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
        :param str service: App service. By default, the job is sent to the service which is the default service when the job is attempted.
        :param str version: App version. By default, the job is sent to the version which is the default version when the job is attempted.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The host that the job is sent to. For more information about how App Engine requests are routed, see [here](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed). The host is constructed as: * `host = [application_domain_name]` `| [service] + '.' + [application_domain_name]` `| [version] + '.' + [application_domain_name]` `| [version_dot_service]+ '.' + [application_domain_name]` `| [instance] + '.' + [application_domain_name]` `| [instance_dot_service] + '.' + [application_domain_name]` `| [instance_dot_version] + '.' + [application_domain_name]` `| [instance_dot_version_dot_service] + '.' + [application_domain_name]` * `application_domain_name` = The domain name of the app, for example .appspot.com, which is associated with the job's project ID. * `service =` service * `version =` version * `version_dot_service =` version `+ '.' +` service * `instance =` instance * `instance_dot_service =` instance `+ '.' +` service * `instance_dot_version =` instance `+ '.' +` version * `instance_dot_version_dot_service =` instance `+ '.' +` version `+ '.' +` service If service is empty, then the job will be sent to the service which is the default service when the job is attempted. If version is empty, then the job will be sent to the version which is the default version when the job is attempted. If instance is empty, then the job will be sent to an instance which is available when the job is attempted. If service, version, or instance is invalid, then the job will be sent to the default version of the default service when the job is attempted.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def instance(self) -> str:
        """
        App instance. By default, the job is sent to an instance which is available when the job is attempted. Requests can only be sent to a specific instance if [manual scaling is used in App Engine Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?#scaling_types_and_instance_classes). App Engine Flex does not support instances. For more information, see [App Engine Standard request routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed) and [App Engine Flex request routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        App service. By default, the job is sent to the service which is the default service when the job is attempted.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        App version. By default, the job is sent to the version which is the default version when the job is attempted.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class HttpTargetResponse(dict):
    """
    Http target. The job will be pushed to the job handler by means of an HTTP request via an http_method such as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an HTTP response code in the range [200 - 299]. A failure to receive a response constitutes a failed execution. For a redirected request, the response returned by the redirected request is considered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpMethod":
            suggest = "http_method"
        elif key == "oauthToken":
            suggest = "oauth_token"
        elif key == "oidcToken":
            suggest = "oidc_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: str,
                 headers: Mapping[str, str],
                 http_method: str,
                 oauth_token: 'outputs.OAuthTokenResponse',
                 oidc_token: 'outputs.OidcTokenResponse',
                 uri: str):
        """
        Http target. The job will be pushed to the job handler by means of an HTTP request via an http_method such as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an HTTP response code in the range [200 - 299]. A failure to receive a response constitutes a failed execution. For a redirected request, the response returned by the redirected request is considered.
        :param str body: HTTP request body. A request body is allowed only if the HTTP method is POST, PUT, or PATCH. It is an error to set body on a job with an incompatible HttpMethod.
        :param Mapping[str, str] headers: The user can specify HTTP request headers to send with the job's HTTP request. This map contains the header field names and values. Repeated headers are not supported, but a header value can contain commas. These headers represent a subset of the headers that will accompany the job's HTTP request. Some HTTP request headers will be ignored or replaced. A partial list of headers that will be ignored or replaced is below: - Host: This will be computed by Cloud Scheduler and derived from uri. * `Content-Length`: This will be computed by Cloud Scheduler. * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`. * `X-Google-*`: Google internal use only. * `X-AppEngine-*`: Google internal use only. * `X-CloudScheduler`: This header will be set to true. * `X-CloudScheduler-JobName`: This header will contain the job name. * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in the unix-cron format, this header will contain the job schedule time in RFC3339 UTC "Zulu" format. The total size of headers must be less than 80KB.
        :param str http_method: Which HTTP method to use for the request.
        :param 'OAuthTokenResponse' oauth_token: If specified, an [OAuth token](https://developers.google.com/identity/protocols/OAuth2) will be generated and attached as an `Authorization` header in the HTTP request. This type of authorization should generally only be used when calling Google APIs hosted on *.googleapis.com.
        :param 'OidcTokenResponse' oidc_token: If specified, an [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect) token will be generated and attached as an `Authorization` header in the HTTP request. This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
        :param str uri: The full URI path that the request will be sent to. This string must begin with either "http://" or "https://". Some examples of valid values for uri are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will encode some characters for safety and compatibility. The maximum allowed URL length is 2083 characters after encoding.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "oauth_token", oauth_token)
        pulumi.set(__self__, "oidc_token", oidc_token)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        HTTP request body. A request body is allowed only if the HTTP method is POST, PUT, or PATCH. It is an error to set body on a job with an incompatible HttpMethod.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        """
        The user can specify HTTP request headers to send with the job's HTTP request. This map contains the header field names and values. Repeated headers are not supported, but a header value can contain commas. These headers represent a subset of the headers that will accompany the job's HTTP request. Some HTTP request headers will be ignored or replaced. A partial list of headers that will be ignored or replaced is below: - Host: This will be computed by Cloud Scheduler and derived from uri. * `Content-Length`: This will be computed by Cloud Scheduler. * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`. * `X-Google-*`: Google internal use only. * `X-AppEngine-*`: Google internal use only. * `X-CloudScheduler`: This header will be set to true. * `X-CloudScheduler-JobName`: This header will contain the job name. * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in the unix-cron format, this header will contain the job schedule time in RFC3339 UTC "Zulu" format. The total size of headers must be less than 80KB.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> str:
        """
        Which HTTP method to use for the request.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> 'outputs.OAuthTokenResponse':
        """
        If specified, an [OAuth token](https://developers.google.com/identity/protocols/OAuth2) will be generated and attached as an `Authorization` header in the HTTP request. This type of authorization should generally only be used when calling Google APIs hosted on *.googleapis.com.
        """
        return pulumi.get(self, "oauth_token")

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> 'outputs.OidcTokenResponse':
        """
        If specified, an [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect) token will be generated and attached as an `Authorization` header in the HTTP request. This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
        """
        return pulumi.get(self, "oidc_token")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The full URI path that the request will be sent to. This string must begin with either "http://" or "https://". Some examples of valid values for uri are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will encode some characters for safety and compatibility. The maximum allowed URL length is 2083 characters after encoding.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class OAuthTokenResponse(dict):
    """
    Contains information needed for generating an [OAuth token](https://developers.google.com/identity/protocols/OAuth2). This type of authorization should generally only be used when calling Google APIs hosted on *.googleapis.com.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuthTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuthTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuthTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scope: str,
                 service_account_email: str):
        """
        Contains information needed for generating an [OAuth token](https://developers.google.com/identity/protocols/OAuth2). This type of authorization should generally only be used when calling Google APIs hosted on *.googleapis.com.
        :param str scope: OAuth scope to be used for generating OAuth access token. If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        :param str service_account_email: [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for generating OAuth token. The service account must be within the same project as the job. The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "service_account_email", service_account_email)

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        OAuth scope to be used for generating OAuth access token. If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for generating OAuth token. The service account must be within the same project as the job. The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")


@pulumi.output_type
class OidcTokenResponse(dict):
    """
    Contains information needed for generating an [OpenID Connect token](https://developers.google.com/identity/protocols/OpenIDConnect). This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OidcTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OidcTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OidcTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: str,
                 service_account_email: str):
        """
        Contains information needed for generating an [OpenID Connect token](https://developers.google.com/identity/protocols/OpenIDConnect). This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
        :param str audience: Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        :param str service_account_email: [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for generating OIDC token. The service account must be within the same project as the job. The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "service_account_email", service_account_email)

    @property
    @pulumi.getter
    def audience(self) -> str:
        """
        Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for generating OIDC token. The service account must be within the same project as the job. The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")


@pulumi.output_type
class PubsubTargetResponse(dict):
    """
    Pub/Sub target. The job will be delivered by publishing a message to the given Pub/Sub topic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicName":
            suggest = "topic_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PubsubTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PubsubTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PubsubTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Mapping[str, str],
                 data: str,
                 topic_name: str):
        """
        Pub/Sub target. The job will be delivered by publishing a message to the given Pub/Sub topic.
        :param Mapping[str, str] attributes: Attributes for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        :param str data: The message payload for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        :param str topic_name: The name of the Cloud Pub/Sub topic to which messages will be published when a job is delivered. The topic name must be in the same format as required by Pub/Sub's [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest), for example `projects/PROJECT_ID/topics/TOPIC_ID`. The topic must be in the same project as the Cloud Scheduler job.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, str]:
        """
        Attributes for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The message payload for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The name of the Cloud Pub/Sub topic to which messages will be published when a job is delivered. The topic name must be in the same format as required by Pub/Sub's [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest), for example `projects/PROJECT_ID/topics/TOPIC_ID`. The topic must be in the same project as the Cloud Scheduler job.
        """
        return pulumi.get(self, "topic_name")


@pulumi.output_type
class RetryConfigResponse(dict):
    """
    Settings that determine the retry behavior. By default, if a job does not complete successfully (meaning that an acknowledgement is not received from the handler, then it will be retried with exponential backoff according to the settings in RetryConfig.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBackoffDuration":
            suggest = "max_backoff_duration"
        elif key == "maxDoublings":
            suggest = "max_doublings"
        elif key == "maxRetryDuration":
            suggest = "max_retry_duration"
        elif key == "minBackoffDuration":
            suggest = "min_backoff_duration"
        elif key == "retryCount":
            suggest = "retry_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetryConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetryConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetryConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_backoff_duration: str,
                 max_doublings: int,
                 max_retry_duration: str,
                 min_backoff_duration: str,
                 retry_count: int):
        """
        Settings that determine the retry behavior. By default, if a job does not complete successfully (meaning that an acknowledgement is not received from the handler, then it will be retried with exponential backoff according to the settings in RetryConfig.
        :param str max_backoff_duration: The maximum amount of time to wait before retrying a job after it fails. The default value of this field is 1 hour.
        :param int max_doublings: The time between retries will double `max_doublings` times. A job's retry interval starts at min_backoff_duration, then doubles `max_doublings` times, then increases linearly, and finally retries at intervals of max_backoff_duration up to retry_count times. For example, if min_backoff_duration is 10s, max_backoff_duration is 300s, and `max_doublings` is 3, then the a job will first be retried in 10s. The retry interval will double three times, and then increase linearly by 2^3 * 10s. Finally, the job will retry at intervals of max_backoff_duration until the job has been attempted retry_count times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, .... The default value of this field is 5.
        :param str max_retry_duration: The time limit for retrying a failed job, measured from time when an execution was first attempted. If specified with retry_count, the job will be retried until both limits are reached. The default value for max_retry_duration is zero, which means retry duration is unlimited.
        :param str min_backoff_duration: The minimum amount of time to wait before retrying a job after it fails. The default value of this field is 5 seconds.
        :param int retry_count: The number of attempts that the system will make to run a job using the exponential backoff procedure described by max_doublings. The default value of retry_count is zero. If retry_count is zero, a job attempt will *not* be retried if it fails. Instead the Cloud Scheduler system will wait for the next scheduled execution time. If retry_count is set to a non-zero number then Cloud Scheduler will retry failed attempts, using exponential backoff, retry_count times, or until the next scheduled execution time, whichever comes first. Values greater than 5 and negative values are not allowed.
        """
        pulumi.set(__self__, "max_backoff_duration", max_backoff_duration)
        pulumi.set(__self__, "max_doublings", max_doublings)
        pulumi.set(__self__, "max_retry_duration", max_retry_duration)
        pulumi.set(__self__, "min_backoff_duration", min_backoff_duration)
        pulumi.set(__self__, "retry_count", retry_count)

    @property
    @pulumi.getter(name="maxBackoffDuration")
    def max_backoff_duration(self) -> str:
        """
        The maximum amount of time to wait before retrying a job after it fails. The default value of this field is 1 hour.
        """
        return pulumi.get(self, "max_backoff_duration")

    @property
    @pulumi.getter(name="maxDoublings")
    def max_doublings(self) -> int:
        """
        The time between retries will double `max_doublings` times. A job's retry interval starts at min_backoff_duration, then doubles `max_doublings` times, then increases linearly, and finally retries at intervals of max_backoff_duration up to retry_count times. For example, if min_backoff_duration is 10s, max_backoff_duration is 300s, and `max_doublings` is 3, then the a job will first be retried in 10s. The retry interval will double three times, and then increase linearly by 2^3 * 10s. Finally, the job will retry at intervals of max_backoff_duration until the job has been attempted retry_count times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, .... The default value of this field is 5.
        """
        return pulumi.get(self, "max_doublings")

    @property
    @pulumi.getter(name="maxRetryDuration")
    def max_retry_duration(self) -> str:
        """
        The time limit for retrying a failed job, measured from time when an execution was first attempted. If specified with retry_count, the job will be retried until both limits are reached. The default value for max_retry_duration is zero, which means retry duration is unlimited.
        """
        return pulumi.get(self, "max_retry_duration")

    @property
    @pulumi.getter(name="minBackoffDuration")
    def min_backoff_duration(self) -> str:
        """
        The minimum amount of time to wait before retrying a job after it fails. The default value of this field is 5 seconds.
        """
        return pulumi.get(self, "min_backoff_duration")

    @property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> int:
        """
        The number of attempts that the system will make to run a job using the exponential backoff procedure described by max_doublings. The default value of retry_count is zero. If retry_count is zero, a job attempt will *not* be retried if it fails. Instead the Cloud Scheduler system will wait for the next scheduled execution time. If retry_count is set to a non-zero number then Cloud Scheduler will retry failed attempts, using exponential backoff, retry_count times, or until the next scheduled execution time, whichever comes first. Values greater than 5 and negative values are not allowed.
        """
        return pulumi.get(self, "retry_count")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


