# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BindingArgs',
    'DeviceConfigArgs',
    'DeviceCredentialArgs',
    'EventNotificationConfigArgs',
    'ExprArgs',
    'GatewayConfigArgs',
    'HttpConfigArgs',
    'MqttConfigArgs',
    'PublicKeyCertificateArgs',
    'PublicKeyCredentialArgs',
    'RegistryCredentialArgs',
    'StateNotificationConfigArgs',
]

@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class DeviceConfigArgs:
    def __init__(__self__, *,
                 binary_data: Optional[pulumi.Input[str]] = None):
        """
        The device configuration. Eventually delivered to devices.
        :param pulumi.Input[str] binary_data: The device configuration data.
        """
        if binary_data is not None:
            pulumi.set(__self__, "binary_data", binary_data)

    @property
    @pulumi.getter(name="binaryData")
    def binary_data(self) -> Optional[pulumi.Input[str]]:
        """
        The device configuration data.
        """
        return pulumi.get(self, "binary_data")

    @binary_data.setter
    def binary_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_data", value)


@pulumi.input_type
class DeviceCredentialArgs:
    def __init__(__self__, *,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input['PublicKeyCredentialArgs']] = None):
        """
        A server-stored device credential used for authentication.
        :param pulumi.Input[str] expiration_time: [Optional] The time at which this credential becomes invalid. This credential will be ignored for new client authentication requests after this timestamp; however, it will not be automatically deleted.
        :param pulumi.Input['PublicKeyCredentialArgs'] public_key: A public key used to verify the signature of JSON Web Tokens (JWTs). When adding a new device credential, either via device creation or via modifications, this public key credential may be required to be signed by one of the registry level certificates. More specifically, if the registry contains at least one certificate, any new device credential must be signed by one of the registry certificates. As a result, when the registry contains certificates, only X.509 certificates are accepted as device credentials. However, if the registry does not contain a certificate, self-signed certificates and public keys will be accepted. New device credentials must be different from every registry-level certificate.
        """
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The time at which this credential becomes invalid. This credential will be ignored for new client authentication requests after this timestamp; however, it will not be automatically deleted.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input['PublicKeyCredentialArgs']]:
        """
        A public key used to verify the signature of JSON Web Tokens (JWTs). When adding a new device credential, either via device creation or via modifications, this public key credential may be required to be signed by one of the registry level certificates. More specifically, if the registry contains at least one certificate, any new device credential must be signed by one of the registry certificates. As a result, when the registry contains certificates, only X.509 certificates are accepted as device credentials. However, if the registry does not contain a certificate, self-signed certificates and public keys will be accepted. New device credentials must be different from every registry-level certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input['PublicKeyCredentialArgs']]):
        pulumi.set(self, "public_key", value)


@pulumi.input_type
class EventNotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub_topic_name: Optional[pulumi.Input[str]] = None,
                 subfolder_matches: Optional[pulumi.Input[str]] = None):
        """
        The configuration for forwarding telemetry events.
        :param pulumi.Input[str] pubsub_topic_name: A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        :param pulumi.Input[str] subfolder_matches: If the subfolder name matches this string exactly, this configuration will be used. The string must not include the leading '/' character. If empty, all strings are matched. This field is used only for telemetry events; subfolders are not supported for state changes.
        """
        if pubsub_topic_name is not None:
            pulumi.set(__self__, "pubsub_topic_name", pubsub_topic_name)
        if subfolder_matches is not None:
            pulumi.set(__self__, "subfolder_matches", subfolder_matches)

    @property
    @pulumi.getter(name="pubsubTopicName")
    def pubsub_topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        return pulumi.get(self, "pubsub_topic_name")

    @pubsub_topic_name.setter
    def pubsub_topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic_name", value)

    @property
    @pulumi.getter(name="subfolderMatches")
    def subfolder_matches(self) -> Optional[pulumi.Input[str]]:
        """
        If the subfolder name matches this string exactly, this configuration will be used. The string must not include the leading '/' character. If empty, all strings are matched. This field is used only for telemetry events; subfolders are not supported for state changes.
        """
        return pulumi.get(self, "subfolder_matches")

    @subfolder_matches.setter
    def subfolder_matches(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subfolder_matches", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GatewayConfigArgs:
    def __init__(__self__, *,
                 gateway_auth_method: Optional[pulumi.Input['GatewayConfigGatewayAuthMethod']] = None,
                 gateway_type: Optional[pulumi.Input['GatewayConfigGatewayType']] = None):
        """
        Gateway-related configuration and state.
        :param pulumi.Input['GatewayConfigGatewayAuthMethod'] gateway_auth_method: Indicates how to authorize and/or authenticate devices to access the gateway.
        :param pulumi.Input['GatewayConfigGatewayType'] gateway_type: Indicates whether the device is a gateway.
        """
        if gateway_auth_method is not None:
            pulumi.set(__self__, "gateway_auth_method", gateway_auth_method)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)

    @property
    @pulumi.getter(name="gatewayAuthMethod")
    def gateway_auth_method(self) -> Optional[pulumi.Input['GatewayConfigGatewayAuthMethod']]:
        """
        Indicates how to authorize and/or authenticate devices to access the gateway.
        """
        return pulumi.get(self, "gateway_auth_method")

    @gateway_auth_method.setter
    def gateway_auth_method(self, value: Optional[pulumi.Input['GatewayConfigGatewayAuthMethod']]):
        pulumi.set(self, "gateway_auth_method", value)

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input['GatewayConfigGatewayType']]:
        """
        Indicates whether the device is a gateway.
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input['GatewayConfigGatewayType']]):
        pulumi.set(self, "gateway_type", value)


@pulumi.input_type
class HttpConfigArgs:
    def __init__(__self__, *,
                 http_enabled_state: Optional[pulumi.Input['HttpConfigHttpEnabledState']] = None):
        """
        The configuration of the HTTP bridge for a device registry.
        :param pulumi.Input['HttpConfigHttpEnabledState'] http_enabled_state: If enabled, allows devices to use DeviceService via the HTTP protocol. Otherwise, any requests to DeviceService will fail for this registry.
        """
        if http_enabled_state is not None:
            pulumi.set(__self__, "http_enabled_state", http_enabled_state)

    @property
    @pulumi.getter(name="httpEnabledState")
    def http_enabled_state(self) -> Optional[pulumi.Input['HttpConfigHttpEnabledState']]:
        """
        If enabled, allows devices to use DeviceService via the HTTP protocol. Otherwise, any requests to DeviceService will fail for this registry.
        """
        return pulumi.get(self, "http_enabled_state")

    @http_enabled_state.setter
    def http_enabled_state(self, value: Optional[pulumi.Input['HttpConfigHttpEnabledState']]):
        pulumi.set(self, "http_enabled_state", value)


@pulumi.input_type
class MqttConfigArgs:
    def __init__(__self__, *,
                 mqtt_enabled_state: Optional[pulumi.Input['MqttConfigMqttEnabledState']] = None):
        """
        The configuration of MQTT for a device registry.
        :param pulumi.Input['MqttConfigMqttEnabledState'] mqtt_enabled_state: If enabled, allows connections using the MQTT protocol. Otherwise, MQTT connections to this registry will fail.
        """
        if mqtt_enabled_state is not None:
            pulumi.set(__self__, "mqtt_enabled_state", mqtt_enabled_state)

    @property
    @pulumi.getter(name="mqttEnabledState")
    def mqtt_enabled_state(self) -> Optional[pulumi.Input['MqttConfigMqttEnabledState']]:
        """
        If enabled, allows connections using the MQTT protocol. Otherwise, MQTT connections to this registry will fail.
        """
        return pulumi.get(self, "mqtt_enabled_state")

    @mqtt_enabled_state.setter
    def mqtt_enabled_state(self, value: Optional[pulumi.Input['MqttConfigMqttEnabledState']]):
        pulumi.set(self, "mqtt_enabled_state", value)


@pulumi.input_type
class PublicKeyCertificateArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input['PublicKeyCertificateFormat']] = None):
        """
        A public key certificate format and data.
        :param pulumi.Input[str] certificate: The certificate data.
        :param pulumi.Input['PublicKeyCertificateFormat'] format: The certificate format.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate data.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['PublicKeyCertificateFormat']]:
        """
        The certificate format.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['PublicKeyCertificateFormat']]):
        pulumi.set(self, "format", value)


@pulumi.input_type
class PublicKeyCredentialArgs:
    def __init__(__self__, *,
                 format: Optional[pulumi.Input['PublicKeyCredentialFormat']] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        A public key format and data.
        :param pulumi.Input['PublicKeyCredentialFormat'] format: The format of the key.
        :param pulumi.Input[str] key: The key data.
        """
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['PublicKeyCredentialFormat']]:
        """
        The format of the key.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['PublicKeyCredentialFormat']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key data.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class RegistryCredentialArgs:
    def __init__(__self__, *,
                 public_key_certificate: Optional[pulumi.Input['PublicKeyCertificateArgs']] = None):
        """
        A server-stored registry credential used to validate device credentials.
        :param pulumi.Input['PublicKeyCertificateArgs'] public_key_certificate: A public key certificate used to verify the device credentials.
        """
        if public_key_certificate is not None:
            pulumi.set(__self__, "public_key_certificate", public_key_certificate)

    @property
    @pulumi.getter(name="publicKeyCertificate")
    def public_key_certificate(self) -> Optional[pulumi.Input['PublicKeyCertificateArgs']]:
        """
        A public key certificate used to verify the device credentials.
        """
        return pulumi.get(self, "public_key_certificate")

    @public_key_certificate.setter
    def public_key_certificate(self, value: Optional[pulumi.Input['PublicKeyCertificateArgs']]):
        pulumi.set(self, "public_key_certificate", value)


@pulumi.input_type
class StateNotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub_topic_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration for notification of new states received from the device.
        :param pulumi.Input[str] pubsub_topic_name: A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        if pubsub_topic_name is not None:
            pulumi.set(__self__, "pubsub_topic_name", pubsub_topic_name)

    @property
    @pulumi.getter(name="pubsubTopicName")
    def pubsub_topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        return pulumi.get(self, "pubsub_topic_name")

    @pubsub_topic_name.setter
    def pubsub_topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic_name", value)


