# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'BuildConfigArgs',
    'EventFilterArgs',
    'EventTriggerArgs',
    'ExprArgs',
    'RepoSourceArgs',
    'ServiceConfigArgs',
    'SourceArgs',
    'StorageSourceArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BuildConfigArgs:
    def __init__(__self__, *,
                 docker_repository: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['SourceArgs']] = None,
                 worker_pool: Optional[pulumi.Input[str]] = None):
        """
        Describes the Build step of the function that builds a container from the given source.
        :param pulumi.Input[str] docker_repository: Optional. User managed repository created in Artifact Registry optionally with a customer managed encryption key. This is the repository to which the function docker image will be pushed after it is built by Cloud Build. If unspecified, GCF will create and use a repository named 'gcf-artifacts' for every deployed region. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`. Cross-project repositories are not supported. Cross-location repositories are not supported. Repository format must be 'DOCKER'.
        :param pulumi.Input[str] entry_point: The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: User-provided build-time environment variables for the function
        :param pulumi.Input[str] runtime: The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
        :param pulumi.Input['SourceArgs'] source: The location of the function source code.
        :param pulumi.Input[str] worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        """
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User managed repository created in Artifact Registry optionally with a customer managed encryption key. This is the repository to which the function docker image will be pushed after it is built by Cloud Build. If unspecified, GCF will create and use a repository named 'gcf-artifacts' for every deployed region. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`. Cross-project repositories are not supported. Cross-location repositories are not supported. Repository format must be 'DOCKER'.
        """
        return pulumi.get(self, "docker_repository")

    @docker_repository.setter
    def docker_repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_repository", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided build-time environment variables for the function
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        The location of the function source code.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        """
        return pulumi.get(self, "worker_pool")

    @worker_pool.setter
    def worker_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_pool", value)


@pulumi.input_type
class EventFilterArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Filters events based on exact matches on the CloudEvents attributes.
        :param pulumi.Input[str] attribute: The name of a CloudEvents attribute.
        :param pulumi.Input[str] value: The value for the attribute.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[str]:
        """
        The name of a CloudEvents attribute.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventTriggerArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[str],
                 event_filters: Optional[pulumi.Input[Sequence[pulumi.Input['EventFilterArgs']]]] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None,
                 retry_policy: Optional[pulumi.Input['EventTriggerRetryPolicy']] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 trigger_region: Optional[pulumi.Input[str]] = None):
        """
        Describes EventTrigger, used to request events to be sent from another service.
        :param pulumi.Input[str] event_type: The type of event to observe. For example: `google.cloud.audit.log.v1.written` or `google.cloud.pubsub.topic.v1.messagePublished`.
        :param pulumi.Input[Sequence[pulumi.Input['EventFilterArgs']]] event_filters: Criteria used to filter events.
        :param pulumi.Input[str] pubsub_topic: Optional. The name of a Pub/Sub topic in the same project that will be used as the transport topic for the event delivery. Format: `projects/{project}/topics/{topic}`. This is only valid for events of type `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here will not be deleted at function deletion.
        :param pulumi.Input['EventTriggerRetryPolicy'] retry_policy: Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
        :param pulumi.Input[str] service_account_email: Optional. The email of the trigger's service account. The service account must have permission to invoke Cloud Run services, the permission is `run.routes.invoke`. If empty, defaults to the Compute Engine default service account: `{project_number}-compute@developer.gserviceaccount.com`.
        :param pulumi.Input[str] trigger_region: The region that the trigger will be in. The trigger will only receive events originating in this region. It can be the same region as the function, a different region or multi-region, or the global region. If not provided, defaults to the same region as the function.
        """
        pulumi.set(__self__, "event_type", event_type)
        if event_filters is not None:
            pulumi.set(__self__, "event_filters", event_filters)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if trigger_region is not None:
            pulumi.set(__self__, "trigger_region", trigger_region)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[str]:
        """
        The type of event to observe. For example: `google.cloud.audit.log.v1.written` or `google.cloud.pubsub.topic.v1.messagePublished`.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventFilterArgs']]]]:
        """
        Criteria used to filter events.
        """
        return pulumi.get(self, "event_filters")

    @event_filters.setter
    def event_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventFilterArgs']]]]):
        pulumi.set(self, "event_filters", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of a Pub/Sub topic in the same project that will be used as the transport topic for the event delivery. Format: `projects/{project}/topics/{topic}`. This is only valid for events of type `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here will not be deleted at function deletion.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['EventTriggerRetryPolicy']]:
        """
        Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['EventTriggerRetryPolicy']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The email of the trigger's service account. The service account must have permission to invoke Cloud Run services, the permission is `run.routes.invoke`. If empty, defaults to the Compute Engine default service account: `{project_number}-compute@developer.gserviceaccount.com`.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that the trigger will be in. The trigger will only receive events originating in this region. It can be the same region as the function, a different region or multi-region, or the global region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")

    @trigger_region.setter
    def trigger_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_region", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class RepoSourceArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        Location of the source in a Google Cloud Source Repository.
        :param pulumi.Input[str] branch_name: Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[str] commit_sha: Explicit commit SHA to build.
        :param pulumi.Input[str] dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution. eg. helloworld (no leading slash allowed)
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[str] project: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[str] tag_name: Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution. eg. helloworld (no leading slash allowed)
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class ServiceConfigArgs:
    def __init__(__self__, *,
                 all_traffic_on_latest_revision: Optional[pulumi.Input[bool]] = None,
                 available_memory: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_settings: Optional[pulumi.Input['ServiceConfigIngressSettings']] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input['ServiceConfigVpcConnectorEgressSettings']] = None):
        """
        Describes the Service being deployed. Currently Supported : Cloud Run (fully managed).
        :param pulumi.Input[bool] all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. On CreateFunction and UpdateFunction, when set to true, the revision being deployed will serve 100% of traffic, ignoring any traffic split settings, if any. On GetFunction, true will be returned if the latest revision is serving 100% of traffic.
        :param pulumi.Input[str] available_memory: The amount of memory available for a function. Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is supplied the value is interpreted as bytes. See https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go a full description.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables that shall be available during function execution.
        :param pulumi.Input['ServiceConfigIngressSettings'] ingress_settings: The ingress settings for the function, controlling what traffic can reach it.
        :param pulumi.Input[int] max_instance_count: The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        :param pulumi.Input[int] min_instance_count: The limit on the minimum number of function instances that may coexist at a given time. Function instances are kept in idle state for a short period after they finished executing the request to reduce cold start time for subsequent requests. Setting a minimum instance count will ensure that the given number of instances are kept running in idle state always. This can help with cold start times when jump in incoming request count occurs after the idle instance would have been stopped in the default case.
        :param pulumi.Input[str] service_account_email: The email of the service's service account. If empty, defaults to `{project_number}-compute@developer.gserviceaccount.com`.
        :param pulumi.Input[int] timeout_seconds: The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] vpc_connector: The Serverless VPC Access connector that this cloud function can connect to. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input['ServiceConfigVpcConnectorEgressSettings'] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it.
        """
        if all_traffic_on_latest_revision is not None:
            pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        if available_memory is not None:
            pulumi.set(__self__, "available_memory", available_memory)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether 100% of traffic is routed to the latest revision. On CreateFunction and UpdateFunction, when set to true, the revision being deployed will serve 100% of traffic, ignoring any traffic split settings, if any. On GetFunction, true will be returned if the latest revision is serving 100% of traffic.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @all_traffic_on_latest_revision.setter
    def all_traffic_on_latest_revision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_traffic_on_latest_revision", value)

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of memory available for a function. Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is supplied the value is interpreted as bytes. See https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go a full description.
        """
        return pulumi.get(self, "available_memory")

    @available_memory.setter
    def available_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "available_memory", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input['ServiceConfigIngressSettings']]:
        """
        The ingress settings for the function, controlling what traffic can reach it.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input['ServiceConfigIngressSettings']]):
        pulumi.set(self, "ingress_settings", value)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time. Function instances are kept in idle state for a short period after they finished executing the request to reduce cold start time for subsequent requests. Setting a minimum instance count will ensure that the given number of instances are kept running in idle state always. This can help with cold start times when jump in incoming request count occurs after the idle instance would have been stopped in the default case.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the service's service account. If empty, defaults to `{project_number}-compute@developer.gserviceaccount.com`.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[str]]:
        """
        The Serverless VPC Access connector that this cloud function can connect to. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector", value)

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input['ServiceConfigVpcConnectorEgressSettings']]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input['ServiceConfigVpcConnectorEgressSettings']]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 repo_source: Optional[pulumi.Input['RepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['StorageSourceArgs']] = None):
        """
        The location of the function source code.
        :param pulumi.Input['RepoSourceArgs'] repo_source: If provided, get the source from this location in a Cloud Source Repository.
        :param pulumi.Input['StorageSourceArgs'] storage_source: If provided, get the source from this location in Google Cloud Storage.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['RepoSourceArgs']]:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['RepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['StorageSourceArgs']]:
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['StorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)


@pulumi.input_type
class StorageSourceArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        Location of the source in an archive file in Google Cloud Storage.
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param pulumi.Input[str] generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param pulumi.Input[str] object: Google Cloud Storage object containing the source. This object must be a gzipped archive file (`.tar.gz`) containing source to build.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage object containing the source. This object must be a gzipped archive file (`.tar.gz`) containing source to build.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


