# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ScheduleResponse',
]

@pulumi.output_type
class ScheduleResponse(dict):
    """
    A snapshot schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crontabSpec":
            suggest = "crontab_spec"
        elif key == "retentionCount":
            suggest = "retention_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crontab_spec: str,
                 prefix: str,
                 retention_count: int):
        """
        A snapshot schedule.
        :param str crontab_spec: A crontab-like specification that the schedule uses to take snapshots.
        :param str prefix: A list of snapshot names created in this schedule.
        :param int retention_count: The maximum number of snapshots to retain in this schedule.
        """
        pulumi.set(__self__, "crontab_spec", crontab_spec)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention_count", retention_count)

    @property
    @pulumi.getter(name="crontabSpec")
    def crontab_spec(self) -> str:
        """
        A crontab-like specification that the schedule uses to take snapshots.
        """
        return pulumi.get(self, "crontab_spec")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        A list of snapshot names created in this schedule.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="retentionCount")
    def retention_count(self) -> int:
        """
        The maximum number of snapshots to retain in this schedule.
        """
        return pulumi.get(self, "retention_count")


