# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSharedflowResult',
    'AwaitableGetSharedflowResult',
    'get_sharedflow',
    'get_sharedflow_output',
]

@pulumi.output_type
class GetSharedflowResult:
    def __init__(__self__, latest_revision_id=None, meta_data=None, name=None, revision=None):
        if latest_revision_id and not isinstance(latest_revision_id, str):
            raise TypeError("Expected argument 'latest_revision_id' to be a str")
        pulumi.set(__self__, "latest_revision_id", latest_revision_id)
        if meta_data and not isinstance(meta_data, dict):
            raise TypeError("Expected argument 'meta_data' to be a dict")
        pulumi.set(__self__, "meta_data", meta_data)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if revision and not isinstance(revision, list):
            raise TypeError("Expected argument 'revision' to be a list")
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="latestRevisionId")
    def latest_revision_id(self) -> str:
        """
        The id of the most recently created revision for this shared flow.
        """
        return pulumi.get(self, "latest_revision_id")

    @property
    @pulumi.getter(name="metaData")
    def meta_data(self) -> 'outputs.GoogleCloudApigeeV1EntityMetadataResponse':
        """
        Metadata describing the shared flow.
        """
        return pulumi.get(self, "meta_data")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ID of the shared flow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revision(self) -> Sequence[str]:
        """
        A list of revisions of this shared flow.
        """
        return pulumi.get(self, "revision")


class AwaitableGetSharedflowResult(GetSharedflowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharedflowResult(
            latest_revision_id=self.latest_revision_id,
            meta_data=self.meta_data,
            name=self.name,
            revision=self.revision)


def get_sharedflow(organization_id: Optional[str] = None,
                   sharedflow_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharedflowResult:
    """
    Gets a shared flow by name, including a list of its revisions.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['sharedflowId'] = sharedflow_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getSharedflow', __args__, opts=opts, typ=GetSharedflowResult).value

    return AwaitableGetSharedflowResult(
        latest_revision_id=__ret__.latest_revision_id,
        meta_data=__ret__.meta_data,
        name=__ret__.name,
        revision=__ret__.revision)


@_utilities.lift_output_func(get_sharedflow)
def get_sharedflow_output(organization_id: Optional[pulumi.Input[str]] = None,
                          sharedflow_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSharedflowResult]:
    """
    Gets a shared flow by name, including a list of its revisions.
    """
    ...
