# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetNatAddressResult',
    'AwaitableGetNatAddressResult',
    'get_nat_address',
    'get_nat_address_output',
]

@pulumi.output_type
class GetNatAddressResult:
    def __init__(__self__, ip_address=None, name=None, state=None):
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The static IPV4 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource ID of the NAT address.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the nat address.
        """
        return pulumi.get(self, "state")


class AwaitableGetNatAddressResult(GetNatAddressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNatAddressResult(
            ip_address=self.ip_address,
            name=self.name,
            state=self.state)


def get_nat_address(instance_id: Optional[str] = None,
                    nat_address_id: Optional[str] = None,
                    organization_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNatAddressResult:
    """
    Gets the details of a NAT address. **Note:** Not supported for Apigee hybrid.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['natAddressId'] = nat_address_id
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getNatAddress', __args__, opts=opts, typ=GetNatAddressResult).value

    return AwaitableGetNatAddressResult(
        ip_address=__ret__.ip_address,
        name=__ret__.name,
        state=__ret__.state)


@_utilities.lift_output_func(get_nat_address)
def get_nat_address_output(instance_id: Optional[pulumi.Input[str]] = None,
                           nat_address_id: Optional[pulumi.Input[str]] = None,
                           organization_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNatAddressResult]:
    """
    Gets the details of a NAT address. **Note:** Not supported for Apigee hybrid.
    """
    ...
