# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiProductArgs', 'ApiProduct']

@pulumi.input_type
class ApiProductArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 approval_type: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationGroupArgs']] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_group: Optional[pulumi.Input['GoogleCloudApigeeV1OperationGroupArgs']] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 quota: Optional[pulumi.Input[str]] = None,
                 quota_interval: Optional[pulumi.Input[str]] = None,
                 quota_time_unit: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ApiProduct resource.
        :param pulumi.Input[str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product. If set to `manual`, the consumer key is generated and returned in "pending" state. In this case, the API keys won't work until they have been explicitly approved. If set to `auto`, the consumer key is generated and returned in "approved" state and can be used immediately. **Note:** Typically, `auto` is used to provide access to free or trial API products that provide limited quota or capabilities.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes. Use this property to specify the access level of the API product as either `public`, `private`, or `internal`. Only products marked `public` are available to developers in the Apigee developer portal. For example, you can set a product to `internal` while it is in development and then change access to `public` when it is ready to release on the portal. API products marked as `private` do not appear on the portal, but can be accessed by external developers.
        :param pulumi.Input[str] created_at: Response only. Creation time of this environment as milliseconds since epoch.
        :param pulumi.Input[str] description: Description of the API product. Include key information about the API product that is not captured by other fields. Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the `proxy.pathsuffix` variable. The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the `apiResources` element is defined to be `/forecastrss` and the base path defined for the API proxy is `/weather`, then only requests to `/weather/forecastrss` are permitted by the API product. You can select a specific path, or you can select all subpaths with the following wildcard: - `/**`: Indicates that all sub-URIs are included. - `/*` : Indicates that only URIs one level down are included. By default, / supports the same resources as /** as well as the base path defined by the API proxy. For example, if the base path of the API proxy is `/v1/weatherapikey`, then the API product supports requests to `/v1/weatherapikey` and to any sub-URIs, such as `/v1/weatherapikey/forecastrss`, `/v1/weatherapikey/region/CA`, and so on. For more information, see Managing API products.
        :param pulumi.Input[str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected. By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment. This setting is used, for example, to prevent resources associated with API proxies in `prod` from being accessed by API proxies deployed in `test`.
        :param pulumi.Input['GoogleCloudApigeeV1GraphQLOperationGroupArgs'] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        :param pulumi.Input[str] last_modified_at: Response only. Modified time of this environment as milliseconds since epoch.
        :param pulumi.Input[str] name: Internal name of the API product. Characters you can use in the name are restricted to: `A-Z0-9._\-$ %`. **Note:** The internal name cannot be edited when updating the API product.
        :param pulumi.Input['GoogleCloudApigeeV1OperationGroupArgs'] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the `quota` setting). **Note:** The `api_resources` setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies. Apigee rejects requests to API proxies that are not listed. **Note:** The API proxy names must already exist in the specified environment as they will be validated upon creation.
        :param pulumi.Input[str] quota: Number of request messages permitted per app by this API product for the specified `quotaInterval` and `quotaTimeUnit`. For example, a `quota` of 50, for a `quotaInterval` of 12 and a `quotaTimeUnit` of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[str] quota_time_unit: Time unit defined for the `quotaInterval`. Valid values include `minute`, `hour`, `day`, or `month`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if api_resources is not None:
            pulumi.set(__self__, "api_resources", api_resources)
        if approval_type is not None:
            pulumi.set(__self__, "approval_type", approval_type)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if graphql_operation_group is not None:
            pulumi.set(__self__, "graphql_operation_group", graphql_operation_group)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation_group is not None:
            pulumi.set(__self__, "operation_group", operation_group)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if quota_interval is not None:
            pulumi.set(__self__, "quota_interval", quota_interval)
        if quota_time_unit is not None:
            pulumi.set(__self__, "quota_time_unit", quota_time_unit)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="apiResources")
    def api_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "api_resources")

    @api_resources.setter
    def api_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_resources", value)

    @property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flag that specifies how API keys are approved to access the APIs defined by the API product. If set to `manual`, the consumer key is generated and returned in "pending" state. In this case, the API keys won't work until they have been explicitly approved. If set to `auto`, the consumer key is generated and returned in "approved" state and can be used immediately. **Note:** Typically, `auto` is used to provide access to free or trial API products that provide limited quota or capabilities.
        """
        return pulumi.get(self, "approval_type")

    @approval_type.setter
    def approval_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "approval_type", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes. Use this property to specify the access level of the API product as either `public`, `private`, or `internal`. Only products marked `public` are available to developers in the Apigee developer portal. For example, you can set a product to `internal` while it is in development and then change access to `public` when it is ready to release on the portal. API products marked as `private` do not appear on the portal, but can be accessed by external developers.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Response only. Creation time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the API product. Include key information about the API product that is not captured by other fields. Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the `proxy.pathsuffix` variable. The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the `apiResources` element is defined to be `/forecastrss` and the base path defined for the API proxy is `/weather`, then only requests to `/weather/forecastrss` are permitted by the API product. You can select a specific path, or you can select all subpaths with the following wildcard: - `/**`: Indicates that all sub-URIs are included. - `/*` : Indicates that only URIs one level down are included. By default, / supports the same resources as /** as well as the base path defined by the API proxy. For example, if the base path of the API proxy is `/v1/weatherapikey`, then the API product supports requests to `/v1/weatherapikey` and to any sub-URIs, such as `/v1/weatherapikey/forecastrss`, `/v1/weatherapikey/region/CA`, and so on. For more information, see Managing API products.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name displayed in the UI or developer portal to developers registering for API access.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected. By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment. This setting is used, for example, to prevent resources associated with API proxies in `prod` from being accessed by API proxies deployed in `test`.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="graphqlOperationGroup")
    def graphql_operation_group(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        """
        return pulumi.get(self, "graphql_operation_group")

    @graphql_operation_group.setter
    def graphql_operation_group(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationGroupArgs']]):
        pulumi.set(self, "graphql_operation_group", value)

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[str]]:
        """
        Response only. Modified time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Internal name of the API product. Characters you can use in the name are restricted to: `A-Z0-9._\-$ %`. **Note:** The internal name cannot be edited when updating the API product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operationGroup")
    def operation_group(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1OperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the `quota` setting). **Note:** The `api_resources` setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        """
        return pulumi.get(self, "operation_group")

    @operation_group.setter
    def operation_group(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1OperationGroupArgs']]):
        pulumi.set(self, "operation_group", value)

    @property
    @pulumi.getter
    def proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies. Apigee rejects requests to API proxies that are not listed. **Note:** The API proxy names must already exist in the specified environment as they will be validated upon creation.
        """
        return pulumi.get(self, "proxies")

    @proxies.setter
    def proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "proxies", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[str]]:
        """
        Number of request messages permitted per app by this API product for the specified `quotaInterval` and `quotaTimeUnit`. For example, a `quota` of 50, for a `quotaInterval` of 12 and a `quotaTimeUnit` of hours means 50 requests are allowed every 12 hours.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="quotaInterval")
    def quota_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "quota_interval")

    @quota_interval.setter
    def quota_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_interval", value)

    @property
    @pulumi.getter(name="quotaTimeUnit")
    def quota_time_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit defined for the `quotaInterval`. Valid values include `minute`, `hour`, `day`, or `month`.
        """
        return pulumi.get(self, "quota_time_unit")

    @quota_time_unit.setter
    def quota_time_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_time_unit", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


class ApiProduct(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 approval_type: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1GraphQLOperationGroupArgs']]] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_group: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1OperationGroupArgs']]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 quota: Optional[pulumi.Input[str]] = None,
                 quota_interval: Optional[pulumi.Input[str]] = None,
                 quota_time_unit: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates an API product in an organization. You create API products after you have proxied backend services using API proxies. An API product is a collection of API resources combined with quota settings and metadata that you can use to deliver customized and productized API bundles to your developer community. This metadata can include: - Scope - Environments - API proxies - Extensible profile API products enable you repackage APIs on the fly, without having to do any additional coding or configuration. Apigee recommends that you start with a simple API product including only required elements. You then provision credentials to apps to enable them to start testing your APIs. After you have authentication and authorization working against a simple API product, you can iterate to create finer-grained API products, defining different sets of API resources for each API product. **WARNING:** - If you don't specify an API proxy in the request body, *any* app associated with the product can make calls to *any* API in your entire organization. - If you don't specify an environment in the request body, the product allows access to all environments. For more information, see What is an API product?

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product. If set to `manual`, the consumer key is generated and returned in "pending" state. In this case, the API keys won't work until they have been explicitly approved. If set to `auto`, the consumer key is generated and returned in "approved" state and can be used immediately. **Note:** Typically, `auto` is used to provide access to free or trial API products that provide limited quota or capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes. Use this property to specify the access level of the API product as either `public`, `private`, or `internal`. Only products marked `public` are available to developers in the Apigee developer portal. For example, you can set a product to `internal` while it is in development and then change access to `public` when it is ready to release on the portal. API products marked as `private` do not appear on the portal, but can be accessed by external developers.
        :param pulumi.Input[str] created_at: Response only. Creation time of this environment as milliseconds since epoch.
        :param pulumi.Input[str] description: Description of the API product. Include key information about the API product that is not captured by other fields. Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the `proxy.pathsuffix` variable. The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the `apiResources` element is defined to be `/forecastrss` and the base path defined for the API proxy is `/weather`, then only requests to `/weather/forecastrss` are permitted by the API product. You can select a specific path, or you can select all subpaths with the following wildcard: - `/**`: Indicates that all sub-URIs are included. - `/*` : Indicates that only URIs one level down are included. By default, / supports the same resources as /** as well as the base path defined by the API proxy. For example, if the base path of the API proxy is `/v1/weatherapikey`, then the API product supports requests to `/v1/weatherapikey` and to any sub-URIs, such as `/v1/weatherapikey/forecastrss`, `/v1/weatherapikey/region/CA`, and so on. For more information, see Managing API products.
        :param pulumi.Input[str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected. By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment. This setting is used, for example, to prevent resources associated with API proxies in `prod` from being accessed by API proxies deployed in `test`.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1GraphQLOperationGroupArgs']] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        :param pulumi.Input[str] last_modified_at: Response only. Modified time of this environment as milliseconds since epoch.
        :param pulumi.Input[str] name: Internal name of the API product. Characters you can use in the name are restricted to: `A-Z0-9._\-$ %`. **Note:** The internal name cannot be edited when updating the API product.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1OperationGroupArgs']] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the `quota` setting). **Note:** The `api_resources` setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies. Apigee rejects requests to API proxies that are not listed. **Note:** The API proxy names must already exist in the specified environment as they will be validated upon creation.
        :param pulumi.Input[str] quota: Number of request messages permitted per app by this API product for the specified `quotaInterval` and `quotaTimeUnit`. For example, a `quota` of 50, for a `quotaInterval` of 12 and a `quotaTimeUnit` of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[str] quota_time_unit: Time unit defined for the `quotaInterval`. Valid values include `minute`, `hour`, `day`, or `month`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiProductArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an API product in an organization. You create API products after you have proxied backend services using API proxies. An API product is a collection of API resources combined with quota settings and metadata that you can use to deliver customized and productized API bundles to your developer community. This metadata can include: - Scope - Environments - API proxies - Extensible profile API products enable you repackage APIs on the fly, without having to do any additional coding or configuration. Apigee recommends that you start with a simple API product including only required elements. You then provision credentials to apps to enable them to start testing your APIs. After you have authentication and authorization working against a simple API product, you can iterate to create finer-grained API products, defining different sets of API resources for each API product. **WARNING:** - If you don't specify an API proxy in the request body, *any* app associated with the product can make calls to *any* API in your entire organization. - If you don't specify an environment in the request body, the product allows access to all environments. For more information, see What is an API product?

        :param str resource_name: The name of the resource.
        :param ApiProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 approval_type: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1GraphQLOperationGroupArgs']]] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_group: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1OperationGroupArgs']]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 quota: Optional[pulumi.Input[str]] = None,
                 quota_interval: Optional[pulumi.Input[str]] = None,
                 quota_time_unit: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiProductArgs.__new__(ApiProductArgs)

            __props__.__dict__["api_resources"] = api_resources
            __props__.__dict__["approval_type"] = approval_type
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["environments"] = environments
            __props__.__dict__["graphql_operation_group"] = graphql_operation_group
            __props__.__dict__["last_modified_at"] = last_modified_at
            __props__.__dict__["name"] = name
            __props__.__dict__["operation_group"] = operation_group
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["proxies"] = proxies
            __props__.__dict__["quota"] = quota
            __props__.__dict__["quota_interval"] = quota_interval
            __props__.__dict__["quota_time_unit"] = quota_time_unit
            __props__.__dict__["scopes"] = scopes
        super(ApiProduct, __self__).__init__(
            'google-native:apigee/v1:ApiProduct',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ApiProduct':
        """
        Get an existing ApiProduct resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApiProductArgs.__new__(ApiProductArgs)

        __props__.__dict__["api_resources"] = None
        __props__.__dict__["approval_type"] = None
        __props__.__dict__["attributes"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["environments"] = None
        __props__.__dict__["graphql_operation_group"] = None
        __props__.__dict__["last_modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["operation_group"] = None
        __props__.__dict__["proxies"] = None
        __props__.__dict__["quota"] = None
        __props__.__dict__["quota_interval"] = None
        __props__.__dict__["quota_time_unit"] = None
        __props__.__dict__["scopes"] = None
        return ApiProduct(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiResources")
    def api_resources(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "api_resources")

    @property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> pulumi.Output[str]:
        """
        Flag that specifies how API keys are approved to access the APIs defined by the API product. If set to `manual`, the consumer key is generated and returned in "pending" state. In this case, the API keys won't work until they have been explicitly approved. If set to `auto`, the consumer key is generated and returned in "approved" state and can be used immediately. **Note:** Typically, `auto` is used to provide access to free or trial API products that provide limited quota or capabilities.
        """
        return pulumi.get(self, "approval_type")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']]:
        """
        Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes. Use this property to specify the access level of the API product as either `public`, `private`, or `internal`. Only products marked `public` are available to developers in the Apigee developer portal. For example, you can set a product to `internal` while it is in development and then change access to `public` when it is ready to release on the portal. API products marked as `private` do not appear on the portal, but can be accessed by external developers.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Response only. Creation time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the API product. Include key information about the API product that is not captured by other fields. Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the `proxy.pathsuffix` variable. The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the `apiResources` element is defined to be `/forecastrss` and the base path defined for the API proxy is `/weather`, then only requests to `/weather/forecastrss` are permitted by the API product. You can select a specific path, or you can select all subpaths with the following wildcard: - `/**`: Indicates that all sub-URIs are included. - `/*` : Indicates that only URIs one level down are included. By default, / supports the same resources as /** as well as the base path defined by the API proxy. For example, if the base path of the API proxy is `/v1/weatherapikey`, then the API product supports requests to `/v1/weatherapikey` and to any sub-URIs, such as `/v1/weatherapikey/forecastrss`, `/v1/weatherapikey/region/CA`, and so on. For more information, see Managing API products.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name displayed in the UI or developer portal to developers registering for API access.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Sequence[str]]:
        """
        Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected. By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment. This setting is used, for example, to prevent resources associated with API proxies in `prod` from being accessed by API proxies deployed in `test`.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="graphqlOperationGroup")
    def graphql_operation_group(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1GraphQLOperationGroupResponse']:
        """
        Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        """
        return pulumi.get(self, "graphql_operation_group")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[str]:
        """
        Response only. Modified time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Internal name of the API product. Characters you can use in the name are restricted to: `A-Z0-9._\-$ %`. **Note:** The internal name cannot be edited when updating the API product.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationGroup")
    def operation_group(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1OperationGroupResponse']:
        """
        Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the `quota` setting). **Note:** The `api_resources` setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        """
        return pulumi.get(self, "operation_group")

    @property
    @pulumi.getter
    def proxies(self) -> pulumi.Output[Sequence[str]]:
        """
        Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies. Apigee rejects requests to API proxies that are not listed. **Note:** The API proxy names must already exist in the specified environment as they will be validated upon creation.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output[str]:
        """
        Number of request messages permitted per app by this API product for the specified `quotaInterval` and `quotaTimeUnit`. For example, a `quota` of 50, for a `quotaInterval` of 12 and a `quotaTimeUnit` of hours means 50 requests are allowed every 12 hours.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="quotaInterval")
    def quota_interval(self) -> pulumi.Output[str]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "quota_interval")

    @property
    @pulumi.getter(name="quotaTimeUnit")
    def quota_time_unit(self) -> pulumi.Output[str]:
        """
        Time unit defined for the `quotaInterval`. Valid values include `minute`, `hour`, `day`, or `month`.
        """
        return pulumi.get(self, "quota_time_unit")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        return pulumi.get(self, "scopes")

