# ​

<div align="center">
<img src="https://raw.githubusercontent.com/FlorianWilhelm/pytanis/main/docs/assets/images/logo.svg" alt="Pytanis logo" width="500" role="img">
</div>
All the tooling you need for conferences using [Pretalx] to handle the call for papers and creating a program.

**Trivia**: The name *Pytanis* is a reference to [Prytanis] using the typical *py* prefix of [Python] tools. [Prytanis]
was the name given  to the leading members of the government of a city (polis) in ancient Greece.  Offices that used this
title usually had responsibility for presiding over councils of some kind, which met in the [Prytaneion]. Romani ite domum!


## Features

- [x] simple configuration management with a config folder in your home directory, just like many other tools do
- [x] easily access [Google Sheets], potentially filled by some [Google Forms], and download it as DataFrame
- [x] easy to use [Pretalx] client that returns proper Python objects thanks to the power of [pydantic]
- [x] simple [HelpDesk] client for batch mails, e.g. to your reviewers
- [x] awesome [documentation] with best practices for the program committee of any community conference
- [x] tools to assign proposals to reviewers based on constraints like preferences
- [x] tools to support the final selection process of proposals
- [x] tools to support the creation of the final program schedule


## License

Pytanis is distributed under the terms of the [MIT] license.

## Navigation

Documentation for specific `MAJOR.MINOR` versions can be chosen by using the dropdown on the top of every page. The `dev` version reflects changes that have not yet been released.

Also, desktop readers can use special keyboard shortcuts:

| Keys                                                         | Action                          |
|--------------------------------------------------------------|---------------------------------|
| <ul><li><kbd>,</kbd> (comma)</li><li><kbd>p</kbd></li></ul>  | Navigate to the "previous" page |
| <ul><li><kbd>.</kbd> (period)</li><li><kbd>n</kbd></li></ul> | Navigate to the "next" page     |
| <ul><li><kbd>/</kbd></li><li><kbd>s</kbd></li></ul>          | Display the search modal        |
