"""tssc.StepImplementers for the 'unit-test' TSSC step.

Step Configuration
------------------
All tssc.StepImplementers for this step should
accept minimally the following configuration options.

| Parameter          | Description
|--------------------|------------
| `fail-on-no-tests` | Value to specify whether unit-test
                                                 step can succeed when no tests are defined

Results
-------
All tssc.StepImplementers for this step should
minimally produce the following step results.

| Result Key         | Description
|--------------------|------------
| `result`           | A dictionary describing the unit test step results
| `options`          | A dictionary of non-standard options used by this step implementer
| `report-artifacts` | An array of dictionaries describing artifacts \
                       generated by this step implementer

**result**
Keys in the `result` dictionary element in the `unit-test` dictionary of the step results.

| `result` Key | Description
|--------------|------------
| `success`    | Boolean value describing success/failure of this step
| `message`    | Human readable message describing results of this step

**options**
Keys in the `options` dictionary element in the `unit-test` dictionary of the step results.
These keys are to be minimally displayed only when a non-default value is used.

| `options` Key       | Description
|---------------------|------------
| `fail-on-no-tests`  | Boolean value describing whether or not step should fail \
                        when unit tests are missing

**report-artifacts**
Keys in the `report-artifacts` array in the `unit-test` dictionary of the step results.
Elements in this array are minimally shown when reports are generated. When no reports are \
generated, this array remains empty.

| `report-artifacts` Key | Description
|------------------------|------------
| `name`                 | Human readable name for report artifact generated by this step
| `path`                 | Absolute path (including transport protocol) to the step report artifact
"""

from .maven import Maven

__all__ = [
    'maven'
]
