// Autogenerated file.

// Transaction hash prefixes.
const DECLARE_HASH_PREFIX = 'declare';
const DEPLOY_HASH_PREFIX = 'deploy';
const DEPLOY_ACCOUNT_HASH_PREFIX = 'deploy_account';
const INVOKE_HASH_PREFIX = 'invoke';
const L1_HANDLER_HASH_PREFIX = 'l1_handler';

// An entry point offset that indicates that nothing needs to be done.
// Used to implement an empty constructor.
const NOP_ENTRY_POINT_OFFSET = -1;

const ENTRY_POINT_TYPE_EXTERNAL = 0;
const ENTRY_POINT_TYPE_L1_HANDLER = 1;
const ENTRY_POINT_TYPE_CONSTRUCTOR = 2;

const L1_HANDLER_VERSION = 0;
const L1_HANDLER_L2_GAS_MAX_AMOUNT = 100000000;

// Upper bound on the number of elements in a Sierra array.
const SIERRA_ARRAY_LEN_BOUND = 4294967296;  // 2^32

// get_selector_from_name('constructor').
const CONSTRUCTOR_ENTRY_POINT_SELECTOR = (
    0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194
);

// get_selector_from_name('__execute__').
const EXECUTE_ENTRY_POINT_SELECTOR = (
    0x15d40a3d6ca2ac30f4031e42be28da9b056fef9bb7357ac5e85627ee876e5ad
);

// get_selector_from_name('__validate__').
const VALIDATE_ENTRY_POINT_SELECTOR = (
    0x162da33a4585851fe8d3af3c2a9c60b557814e221e0d4f30ff0b2189d9c7775
);

// get_selector_from_name('__validate_declare__').
const VALIDATE_DECLARE_ENTRY_POINT_SELECTOR = (
    0x289da278a8dc833409cabfdad1581e8e7d40e42dcaed693fa4008dcdb4963b3
);

// get_selector_from_name('__validate_deploy__').
const VALIDATE_DEPLOY_ENTRY_POINT_SELECTOR = (
    0x36fcbf06cd96843058359e1a75928beacfac10727dab22a3972f0af8aa92895
);

// get_selector_from_name('transfer').
const TRANSFER_ENTRY_POINT_SELECTOR = (
    0x83afd3f4caedc6eebf44246fe54e38c95e3179a5ec9ea81740eca5b482d12e
);

const DEFAULT_ENTRY_POINT_SELECTOR = 0x0;

// OS reserved contract addresses.

// This contract stores the block number -> block hash mapping.
const BLOCK_HASH_CONTRACT_ADDRESS = 0x1;
// This contract stores the aliases mapping used for stateful compression.
const ALIAS_CONTRACT_ADDRESS = 0x2;
// Future reserved contract address.
const RESERVED_CONTRACT_ADDRESS = 0x3;
// The block number -> block hash mapping is written for the current block number minus this number.
const STORED_BLOCK_HASH_BUFFER = 10;

// Gas constants.

const STEP_GAS_COST = 100;
const RANGE_CHECK_GAS_COST = 70;
const RANGE_CHECK96_GAS_COST = 56;
const KECCAK_BUILTIN_GAS_COST = 136189;
const PEDERSEN_GAS_COST = 4050;
const BITWISE_BUILTIN_GAS_COST = 583;
const ECOP_GAS_COST = 4085;
const POSEIDON_GAS_COST = 491;
const ADD_MOD_GAS_COST = 230;
const MUL_MOD_GAS_COST = 604;
const ECDSA_GAS_COST = 10561;
const MEMORY_HOLE_GAS_COST = 10;

const DEFAULT_INITIAL_GAS_COST = 10000000000;
const VALIDATE_MAX_SIERRA_GAS = 100000000;
const EXECUTE_MAX_SIERRA_GAS = 1000000000;
const DEFAULT_INITIAL_GAS_COST_NO_L2 = VALIDATE_MAX_SIERRA_GAS + EXECUTE_MAX_SIERRA_GAS;

// Compiler gas costs.

// The initial budget at an entry point. This needs to be high enough to cover the initial get_gas.
// The entry point may refund whatever remains from the initial budget.
const ENTRY_POINT_INITIAL_BUDGET = 10000;
// The gas cost of each syscall libfunc (this value is hard-coded by the compiler).
// This needs to be high enough to cover OS costs in the case of failure due to out of gas.
const SYSCALL_BASE_GAS_COST = 10000;

// Syscall gas costs.
const CALL_CONTRACT_GAS_COST = 91560;
const DEPLOY_GAS_COST = 147120;
const DEPLOY_CALLDATA_FACTOR_GAS_COST = 4850;
const GET_BLOCK_HASH_GAS_COST = 10840;
const GET_CLASS_HASH_AT_GAS_COST = 10000;
const GET_EXECUTION_INFO_GAS_COST = 12640;
const LIBRARY_CALL_GAS_COST = 89160;
const REPLACE_CLASS_GAS_COST = 10670;
const STORAGE_READ_GAS_COST = 10000;
const STORAGE_WRITE_GAS_COST = 10000;
const EMIT_EVENT_GAS_COST = 10000;
const SEND_MESSAGE_TO_L1_GAS_COST = 14470;
const META_TX_V0_GAS_COST = 167950;
const META_TX_V0_CALLDATA_FACTOR_GAS_COST = 4850;

// Note the the following costs include `SYSCALL_BASE_GAS_COST` implicitly.
const SECP256K1_ADD_GAS_COST = 43230;
const SECP256K1_GET_POINT_FROM_X_GAS_COST = 41800;
const SECP256K1_GET_XY_GAS_COST = 21670;
const SECP256K1_MUL_GAS_COST = 8143850;
const SECP256K1_NEW_GAS_COST = 48750;
const SECP256R1_ADD_GAS_COST = 63490;
const SECP256R1_GET_POINT_FROM_X_GAS_COST = 54680;
const SECP256R1_GET_XY_GAS_COST = 21870;
const SECP256R1_MUL_GAS_COST = 13511870;
const SECP256R1_NEW_GAS_COST = 61630;

const KECCAK_GAS_COST = 10000;
const KECCAK_ROUND_COST_GAS_COST = 171707;
const SHA256_PROCESS_BLOCK_GAS_COST = 841295;

// Cairo 1.0 error codes.
const ERROR_BLOCK_NUMBER_OUT_OF_RANGE = 'Block number out of range';
const ERROR_OUT_OF_GAS = 'Out of gas';
const ERROR_ENTRY_POINT_FAILED = 'ENTRYPOINT_FAILED';
const ERROR_ENTRY_POINT_NOT_FOUND = 'ENTRYPOINT_NOT_FOUND';
const ERROR_INVALID_INPUT_LEN = 'Invalid input length';
const ERROR_INVALID_ARGUMENT = 'Invalid argument';

// The expected return value of the `__validate*__` functions of a Cairo 1.0 account contract.
const VALIDATED = 'VALID';

// Resources
const L1_GAS = 'L1_GAS';
const L2_GAS = 'L2_GAS';
const L1_DATA_GAS = 'L1_DATA';
const L1_GAS_INDEX = 0;
const L2_GAS_INDEX = 1;
const L1_DATA_GAS_INDEX = 2;

// Round down the block number and timestamp when queried inside `__validate__`.
const VALIDATE_BLOCK_NUMBER_ROUNDING = 100;
const VALIDATE_TIMESTAMP_ROUNDING = 3600;

// List of CairoZero account contracts that require the transaction version to be 1.
const V1_BOUND_ACCOUNTS_CAIRO0_0 = (
    0x06d706cfbac9b8262d601c38251c5fbe0497c3a96cc91a92b08d91b61d9e70c4
);
const V1_BOUND_ACCOUNTS_CAIRO0_1 = (
    0x0309c042d3729173c7f2f91a34f04d8c509c1b292d334679ef1aabf8da0899cc
);
const V1_BOUND_ACCOUNTS_CAIRO0_2 = (
    0x01a7820094feaf82d53f53f214b81292d717e7bb9a92bb2488092cd306f3993f
);
const V1_BOUND_ACCOUNTS_CAIRO0_3 = (
    0x033434ad846cdd5f23eb73ff09fe6fddd568284a0fb7d1be20ee482f044dabe2
);
const V1_BOUND_ACCOUNTS_CAIRO0_4 = (
    0x041cb0280ebadaa75f996d8d92c6f265f6d040bb3ba442e5f86a554f1765244e
);
const V1_BOUND_ACCOUNTS_CAIRO0_LEN = 5;

// List of Cairo1 account contracts that require the transaction version to be 1.
const V1_BOUND_ACCOUNTS_CAIRO1_0 = (
    0x01a736d6ed154502257f02b1ccdf4d9d1089f80811cd6acad48e6b6a9d1f2003
);
const V1_BOUND_ACCOUNTS_CAIRO1_1 = (
    0x0737ee2f87ce571a58c6c8da558ec18a07ceb64a6172d5ec46171fbc80077a48
);
const V1_BOUND_ACCOUNTS_CAIRO1_2 = (
    0x05400e90f7e0ae78bd02c77cd75527280470e2fe19c54970dd79dc37a9d3645c
);
const V1_BOUND_ACCOUNTS_CAIRO1_3 = (
    0x04c6d6cf894f8bc96bb9c525e6853e5483177841f7388f74a46cfda6f028c755
);
const V1_BOUND_ACCOUNTS_CAIRO1_4 = (
    0x01c0bb51e2ce73dc007601a1e7725453627254016c28f118251a71bbb0507fcb
);
const V1_BOUND_ACCOUNTS_CAIRO1_5 = (
    0x0251830adc3d8b4d818c2c309d71f1958308e8c745212480c26e01120c69ee49
);
const V1_BOUND_ACCOUNTS_CAIRO1_6 = (
    0x0251cac7b2f45d255b83b7a06dcdef70c8a8752f00ea776517c1c2243c7a06e5
);
const V1_BOUND_ACCOUNTS_CAIRO1_LEN = 7;

// Max transaction tip for which a v3 transaction can be replaced with a v1 transaction.
const V1_BOUND_ACCOUNTS_MAX_TIP = 0x746a5288000;

// List of Cairo1 account contracts that require the resource bounds to exclude data gas.
const DATA_GAS_ACCOUNTS_0 = 0x02c8c7e6fbcfb3e8e15a46648e8914c6aa1fc506fc1e7fb3d1e19630716174bc;
const DATA_GAS_ACCOUNTS_1 = 0x00816dd0297efc55dc1e7559020a3a825e81ef734b558f03c83325d4da7e6253;
const DATA_GAS_ACCOUNTS_2 = 0x041bf1e71792aecb9df3e9d04e1540091c5e13122a731e02bec588f71dc1a5c3;
const DATA_GAS_ACCOUNTS_3 = 0x06d612cac7690e6620055c617a83a5a0b43b9758d9d30f281ddbc77be1651a70;
const DATA_GAS_ACCOUNTS_LEN = 4;
