# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class LoanServicingEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'loan_amount': 'Currency',
        'source_business_event_type': 'str'
    }

    attribute_map = {
        'loan_amount': 'LoanAmount',
        'source_business_event_type': 'SourceBusinessEventType'
    }

    def __init__(self, loan_amount=None, source_business_event_type=None):  # noqa: E501
        """LoanServicingEvent - a model defined in Swagger"""  # noqa: E501
        self._loan_amount = None
        self._source_business_event_type = None
        self.discriminator = None
        if loan_amount is not None:
            self.loan_amount = loan_amount
        if source_business_event_type is not None:
            self.source_business_event_type = source_business_event_type

    @property
    def loan_amount(self):
        """Gets the loan_amount of this LoanServicingEvent.  # noqa: E501


        :return: The loan_amount of this LoanServicingEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._loan_amount

    @loan_amount.setter
    def loan_amount(self, loan_amount):
        """Sets the loan_amount of this LoanServicingEvent.


        :param loan_amount: The loan_amount of this LoanServicingEvent.  # noqa: E501
        :type: Currency
        """

        self._loan_amount = loan_amount

    @property
    def source_business_event_type(self):
        """Gets the source_business_event_type of this LoanServicingEvent.  # noqa: E501

        The type of event.  Possible values:  * LoanAdvance  * LoanPayment  * LoanRefund  # noqa: E501

        :return: The source_business_event_type of this LoanServicingEvent.  # noqa: E501
        :rtype: str
        """
        return self._source_business_event_type

    @source_business_event_type.setter
    def source_business_event_type(self, source_business_event_type):
        """Sets the source_business_event_type of this LoanServicingEvent.

        The type of event.  Possible values:  * LoanAdvance  * LoanPayment  * LoanRefund  # noqa: E501

        :param source_business_event_type: The source_business_event_type of this LoanServicingEvent.  # noqa: E501
        :type: str
        """

        self._source_business_event_type = source_business_event_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LoanServicingEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoanServicingEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
