#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from sqlalchemy import Column
from sqlalchemy import Integer
from sqlalchemy import MetaData
from sqlalchemy import Table
from sqlalchemy import text


def upgrade(migrate_engine):
    meta = MetaData()
    meta.bind = migrate_engine

    consumers = Table("consumers", meta, autoload=True)
    if not hasattr(consumers.c, "generation"):
        # This is adding a column to an existing table, so the server_default
        # bit will make existing rows 0 for that column.
        consumers.create_column(Column("generation", Integer, default=0,
                server_default=text("0"), nullable=False))
