# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class UsersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_corporation_permission(self, user_id, **kwargs):  # noqa: E501
        """add_corporation_permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_corporation_permission(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: (required)
        :param CorporationPermissionCreateRequest body:
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_corporation_permission_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_corporation_permission_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def add_corporation_permission_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """add_corporation_permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_corporation_permission_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: (required)
        :param CorporationPermissionCreateRequest body:
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_corporation_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `add_corporation_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/corporations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_location_permission(self, user_id, **kwargs):  # noqa: E501
        """Adds a location permission for the specified user  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_location_permission(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param LocationPermissionCreateRequest body: A request to add a location permission to the given user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_location_permission_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_location_permission_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def add_location_permission_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Adds a location permission for the specified user  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_location_permission_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param LocationPermissionCreateRequest body: A request to add a location permission to the given user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_location_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `add_location_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/locations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def check_email_exists(self, email, **kwargs):  # noqa: E501
        """Checks if the given email exists  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_email_exists(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: The email to check (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.check_email_exists_with_http_info(email, **kwargs)  # noqa: E501
        else:
            (data) = self.check_email_exists_with_http_info(email, **kwargs)  # noqa: E501
            return data

    def check_email_exists_with_http_info(self, email, **kwargs):  # noqa: E501
        """Checks if the given email exists  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_email_exists_with_http_info(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: The email to check (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_email_exists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `check_email_exists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{email}/exists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def confirm_password_sd4(self, **kwargs):  # noqa: E501
        """Confirms a user's new password when user resets their password.  # noqa: E501

        Required Permissions: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_password_sd4(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserConfirmPasswordRequest body: The confirm password request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.confirm_password_sd4_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.confirm_password_sd4_with_http_info(**kwargs)  # noqa: E501
            return data

    def confirm_password_sd4_with_http_info(self, **kwargs):  # noqa: E501
        """Confirms a user's new password when user resets their password.  # noqa: E501

        Required Permissions: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_password_sd4_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserConfirmPasswordRequest body: The confirm password request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method confirm_password_sd4" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/password/confirm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_user(self, **kwargs):  # noqa: E501
        """Create a new user  # noqa: E501

        Required Permissions:  - System admin can create any type of user  - Sentry can create sentry and below  - Corporation admins can create corporation admins and below  - Location admins can create location admins and below  - Users without admin rights cannot create users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreateRequest body: Request to create a new user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_user_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new user  # noqa: E501

        Required Permissions:  - System admin can create any type of user  - Sentry can create sentry and below  - Corporation admins can create corporation admins and below  - Location admins can create location admins and below  - Users without admin rights cannot create users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreateRequest body: Request to create a new user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_corporation_permission(self, user_id, corporation_id, **kwargs):  # noqa: E501
        """Deletes a specific corporation permission  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_corporation_permission(user_id, corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user associated with the permission (required)
        :param str corporation_id: Id of the permission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_corporation_permission_with_http_info(user_id, corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_corporation_permission_with_http_info(user_id, corporation_id, **kwargs)  # noqa: E501
            return data

    def delete_corporation_permission_with_http_info(self, user_id, corporation_id, **kwargs):  # noqa: E501
        """Deletes a specific corporation permission  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_corporation_permission_with_http_info(user_id, corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user associated with the permission (required)
        :param str corporation_id: Id of the permission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'corporation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_corporation_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_corporation_permission`")  # noqa: E501
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `delete_corporation_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/corporations/{corporationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_location_permission(self, user_id, location_id, **kwargs):  # noqa: E501
        """Deletes a specific location permission  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_location_permission(user_id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user associated with the permission (required)
        :param str location_id: Id of the permission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_location_permission_with_http_info(user_id, location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_location_permission_with_http_info(user_id, location_id, **kwargs)  # noqa: E501
            return data

    def delete_location_permission_with_http_info(self, user_id, location_id, **kwargs):  # noqa: E501
        """Deletes a specific location permission  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_location_permission_with_http_info(user_id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user associated with the permission (required)
        :param str location_id: Id of the permission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_location_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_location_permission`")  # noqa: E501
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `delete_location_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/locations/{locationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_personal_access_token(self, token_id, **kwargs):  # noqa: E501
        """Revokes one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_personal_access_token(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
            return data

    def delete_personal_access_token_with_http_info(self, token_id, **kwargs):  # noqa: E501
        """Revokes one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_personal_access_token_with_http_info(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_personal_access_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_id' is set
        if ('token_id' not in params or
                params['token_id'] is None):
            raise ValueError("Missing the required parameter `token_id` when calling `delete_personal_access_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser/tokens/{tokenId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_personal_access_tokens(self, **kwargs):  # noqa: E501
        """Generate a new access token for the current user.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_personal_access_tokens(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonalAccessTokenCreateRequest body:
        :return: PersonalAccessTokenCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_personal_access_tokens_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.generate_personal_access_tokens_with_http_info(**kwargs)  # noqa: E501
            return data

    def generate_personal_access_tokens_with_http_info(self, **kwargs):  # noqa: E501
        """Generate a new access token for the current user.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_personal_access_tokens_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonalAccessTokenCreateRequest body:
        :return: PersonalAccessTokenCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_personal_access_tokens" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser/tokens', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonalAccessTokenCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_current_user(self, **kwargs):  # noqa: E501
        """Gets the Current user  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CurrentUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_current_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_current_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_current_user_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the Current user  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CurrentUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CurrentUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_personal_access_token(self, token_id, **kwargs):  # noqa: E501
        """Get one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_personal_access_token(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :return: PersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
            return data

    def get_personal_access_token_with_http_info(self, token_id, **kwargs):  # noqa: E501
        """Get one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_personal_access_token_with_http_info(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :return: PersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_personal_access_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_id' is set
        if ('token_id' not in params or
                params['token_id'] is None):
            raise ValueError("Missing the required parameter `token_id` when calling `get_personal_access_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser/tokens/{tokenId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonalAccessTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_personal_access_tokens(self, **kwargs):  # noqa: E501
        """Lists the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_personal_access_tokens(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Description` | String | `eq, neq, like, in` | | `LastUsed` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `Updated` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `Description` | String | | `LastUsed` | DateTime? | | `Updated` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`.
        :return: PagedResultsModelPersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_personal_access_tokens_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_personal_access_tokens_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_personal_access_tokens_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_personal_access_tokens_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Description` | String | `eq, neq, like, in` | | `LastUsed` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `Updated` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `Created` | DateTime | | `Description` | String | | `LastUsed` | DateTime? | | `Updated` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`.
        :return: PagedResultsModelPersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_personal_access_tokens" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser/tokens', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPersonalAccessTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_profile_options(self, **kwargs):  # noqa: E501
        """Gets all possible options for user profile properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profile_options(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProfileOptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_profile_options_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_profile_options_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_profile_options_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all possible options for user profile properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profile_options_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProfileOptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_profile_options" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/profiles/options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProfileOptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, user_id, **kwargs):  # noqa: E501
        """Returns a specified user  # noqa: E501

        Required Permissions:  - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The Id of the User to return (required)
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_user_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Returns a specified user  # noqa: E501

        Required Permissions:  - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The Id of the User to return (required)
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_locations(self, user_id, **kwargs):  # noqa: E501
        """Returns a paged list of all locations that the selected user and accessing user both have access to  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_locations(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: UserId of user to return locations for. (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Id` | Guid | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `Active` | Boolean | | `CorporationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `CorporationName`, `Name`.
        :return: PagedResultsModelLocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_locations_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_locations_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_user_locations_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Returns a paged list of all locations that the selected user and accessing user both have access to  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_locations_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: UserId of user to return locations for. (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Id` | Guid | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `Active` | Boolean | | `CorporationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `CorporationName`, `Name`.
        :return: PagedResultsModelLocationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_locations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_locations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/Locations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelLocationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_profile(self, user_id, **kwargs):  # noqa: E501
        """Gets a user's profile  # noqa: E501

        Required Permissions:  - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_profile(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user's ID (required)
        :return: UserProfileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_profile_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_profile_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_user_profile_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Gets a user's profile  # noqa: E501

        Required Permissions:  - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_profile_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user's ID (required)
        :return: UserProfileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/profile', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserProfileResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_users(self, **kwargs):  # noqa: E501
        """Returns a paged list of all users  # noqa: E501

        - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] corporation_ids: A list of corporation IDs to filter the result
        :param list[str] location_ids: A list of location IDs to filter the result
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `AcceptedEula` | Boolean | `eq, neq` | | `ApplicationRoleCode` | ApplicationRoleCode | `eq, neq, in` | | `Email` | String | `eq, neq, like, in` | | `FirstName` | String | `eq, neq, like, in` | | `IsApproved` | Boolean | `eq, neq` | | `LastLogin` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `LastName` | String | `eq, neq, like, in` | | `LockedOut` | Boolean | `eq, neq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AcceptedEula` | Boolean | | `ApplicationRoleCode` | ApplicationRoleCode | | `Email` | String | | `FirstName` | String | | `IsApproved` | Boolean | | `LastLogin` | DateTime? | | `LastName` | String | | `LockedOut` | Boolean |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Email`, `FirstName`, `FullName`, `LastName`, `PhoneNumber`.
        :return: PagedResultsModelUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a paged list of all users  # noqa: E501

        - System admin and Sentry can get any user  - Corporation admins can get other corporation admins and users in their corporation as    well as location admins and users in the locations under their corporation  - Corporation users can get other corporation users in their corporation  - Location admins can get other location admins and location users in their location  - Location users can get other location users in their location  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] corporation_ids: A list of corporation IDs to filter the result
        :param list[str] location_ids: A list of location IDs to filter the result
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `AcceptedEula` | Boolean | `eq, neq` | | `ApplicationRoleCode` | ApplicationRoleCode | `eq, neq, in` | | `Email` | String | `eq, neq, like, in` | | `FirstName` | String | `eq, neq, like, in` | | `IsApproved` | Boolean | `eq, neq` | | `LastLogin` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `LastName` | String | `eq, neq, like, in` | | `LockedOut` | Boolean | `eq, neq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AcceptedEula` | Boolean | | `ApplicationRoleCode` | ApplicationRoleCode | | `Email` | String | | `FirstName` | String | | `IsApproved` | Boolean | | `LastLogin` | DateTime? | | `LastName` | String | | `LockedOut` | Boolean |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Email`, `FirstName`, `FullName`, `LastName`, `PhoneNumber`.
        :return: PagedResultsModelUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_ids', 'location_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'corporation_ids' in params:
            query_params.append(('corporationIds', params['corporation_ids']))  # noqa: E501
            collection_formats['corporationIds'] = 'multi'  # noqa: E501
        if 'location_ids' in params:
            query_params.append(('locationIds', params['location_ids']))  # noqa: E501
            collection_formats['locationIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_password_sd4(self, **kwargs):  # noqa: E501
        """Requests that a users password be reset. The users will receive an email with  instructions on how to reset their password.  # noqa: E501

        Required Permissions: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password_sd4(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The User's email
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_password_sd4_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_password_sd4_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_password_sd4_with_http_info(self, **kwargs):  # noqa: E501
        """Requests that a users password be reset. The users will receive an email with  instructions on how to reset their password.  # noqa: E501

        Required Permissions: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password_sd4_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The User's email
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_password_sd4" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/password/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_confirmation_code(self, **kwargs):  # noqa: E501
        """Sends a confirmation code to the supplied phone number  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_confirmation_code(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserPhoneNumberConfirmRequest body: The request object containing the phone number to send the confirmation code to
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_confirmation_code_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.send_confirmation_code_with_http_info(**kwargs)  # noqa: E501
            return data

    def send_confirmation_code_with_http_info(self, **kwargs):  # noqa: E501
        """Sends a confirmation code to the supplied phone number  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_confirmation_code_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserPhoneNumberConfirmRequest body: The request object containing the phone number to send the confirmation code to
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_confirmation_code" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/phoneNumber/confirm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unlock_user(self, user_id, **kwargs):  # noqa: E501
        """Unlocks the user with the specified id (Sets LockedOut to false)  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock_user(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: ID of user whose lock value will be updated (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unlock_user_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unlock_user_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def unlock_user_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Unlocks the user with the specified id (Sets LockedOut to false)  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock_user_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: ID of user whose lock value will be updated (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlock_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `unlock_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/unlock', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_corporation_permission(self, user_id, corporation_id, **kwargs):  # noqa: E501
        """Updates an existing user's corporation permission  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_corporation_permission(user_id, corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param str corporation_id: Id of the corporation (required)
        :param CorporationPermissionUpdateRequest body: Request to modify the permission
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_corporation_permission_with_http_info(user_id, corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_corporation_permission_with_http_info(user_id, corporation_id, **kwargs)  # noqa: E501
            return data

    def update_corporation_permission_with_http_info(self, user_id, corporation_id, **kwargs):  # noqa: E501
        """Updates an existing user's corporation permission  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_corporation_permission_with_http_info(user_id, corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param str corporation_id: Id of the corporation (required)
        :param CorporationPermissionUpdateRequest body: Request to modify the permission
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'corporation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_corporation_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_corporation_permission`")  # noqa: E501
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `update_corporation_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/corporations/{corporationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_current_user(self, **kwargs):  # noqa: E501
        """Updates the current user's information.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_current_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrentUserUpdateRequest body:
        :return: CurrentUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_current_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.update_current_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def update_current_user_with_http_info(self, **kwargs):  # noqa: E501
        """Updates the current user's information.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_current_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrentUserUpdateRequest body:
        :return: CurrentUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_current_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CurrentUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_location_permission(self, user_id, location_id, **kwargs):  # noqa: E501
        """Updates an existing user location permission  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location_permission(user_id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param str location_id: Id of the corporation (required)
        :param LocationPermissionUpdateRequest body: Request to modify the permission
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_location_permission_with_http_info(user_id, location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_location_permission_with_http_info(user_id, location_id, **kwargs)  # noqa: E501
            return data

    def update_location_permission_with_http_info(self, user_id, location_id, **kwargs):  # noqa: E501
        """Updates an existing user location permission  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_location_permission_with_http_info(user_id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: Id of the user (required)
        :param str location_id: Id of the corporation (required)
        :param LocationPermissionUpdateRequest body: Request to modify the permission
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'location_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_location_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_location_permission`")  # noqa: E501
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `update_location_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/permissions/locations/{locationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_personal_access_token(self, token_id, **kwargs):  # noqa: E501
        """Update one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_personal_access_token(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :param PersonalAccessTokenUpdateRequest body:
        :return: PersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_personal_access_token_with_http_info(token_id, **kwargs)  # noqa: E501
            return data

    def update_personal_access_token_with_http_info(self, token_id, **kwargs):  # noqa: E501
        """Update one of the current user's access tokens.  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_personal_access_token_with_http_info(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str token_id: (required)
        :param PersonalAccessTokenUpdateRequest body:
        :return: PersonalAccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_personal_access_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_id' is set
        if ('token_id' not in params or
                params['token_id'] is None):
            raise ValueError("Missing the required parameter `token_id` when calling `update_personal_access_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/currentUser/tokens/{tokenId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonalAccessTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user(self, user_id, **kwargs):  # noqa: E501
        """Updates a user  # noqa: E501

        Required Permissions:  - System Admins can update any type of user  - Sentry can update sentry and below  - Corporation admins can update corporation admins and below  - Location admins can update location admins and below  - Users without admin rights cannot update users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: ID of the user to update (required)
        :param UserUpdateRequest body: Request to update the user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def update_user_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Updates a user  # noqa: E501

        Required Permissions:  - System Admins can update any type of user  - Sentry can update sentry and below  - Corporation admins can update corporation admins and below  - Location admins can update location admins and below  - Users without admin rights cannot update users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: ID of the user to update (required)
        :param UserUpdateRequest body: Request to update the user
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_profile(self, user_id, **kwargs):  # noqa: E501
        """Updates a user's profile  # noqa: E501

        Required Permissions: User. A user may only update their own profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_profile(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user's ID (required)
        :param UserProfileUpdateRequest body: Request object used to update the profile
        :return: UserProfileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_profile_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_profile_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def update_user_profile_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Updates a user's profile  # noqa: E501

        Required Permissions: User. A user may only update their own profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_profile_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user's ID (required)
        :param UserProfileUpdateRequest body: Request object used to update the profile
        :return: UserProfileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_user_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Users/{userId}/profile', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserProfileResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
