# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class TreeItemsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_tree_item(self, tree_item_id, **kwargs):  # noqa: E501
        """Deletes a treeItem  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tree_item(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
            return data

    def delete_tree_item_with_http_info(self, tree_item_id, **kwargs):  # noqa: E501
        """Deletes a treeItem  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tree_item_with_http_info(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tree_item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tree_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tree_item_id' is set
        if ('tree_item_id' not in params or
                params['tree_item_id'] is None):
            raise ValueError("Missing the required parameter `tree_item_id` when calling `delete_tree_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tree_item_id' in params:
            path_params['treeItemId'] = params['tree_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/TreeItems/{treeItemId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tree_item(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets a treeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :return: TreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
            return data

    def get_tree_item_with_http_info(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets a treeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item_with_http_info(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :return: TreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tree_item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tree_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tree_item_id' is set
        if ('tree_item_id' not in params or
                params['tree_item_id'] is None):
            raise ValueError("Missing the required parameter `tree_item_id` when calling `get_tree_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tree_item_id' in params:
            path_params['treeItemId'] = params['tree_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/TreeItems/{treeItemId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TreeItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tree_item_available_asset_classes(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets available asset classes in the subtree rooted at treeItemId  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item_available_asset_classes(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelTreeItemAvailableAssetClassResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tree_item_available_asset_classes_with_http_info(tree_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tree_item_available_asset_classes_with_http_info(tree_item_id, **kwargs)  # noqa: E501
            return data

    def get_tree_item_available_asset_classes_with_http_info(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets available asset classes in the subtree rooted at treeItemId  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item_available_asset_classes_with_http_info(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelTreeItemAvailableAssetClassResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tree_item_id', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tree_item_available_asset_classes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tree_item_id' is set
        if ('tree_item_id' not in params or
                params['tree_item_id'] is None):
            raise ValueError("Missing the required parameter `tree_item_id` when calling `get_tree_item_available_asset_classes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tree_item_id' in params:
            path_params['treeItemId'] = params['tree_item_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/TreeItems/{treeItemId}/AvailableAssetClasses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelTreeItemAvailableAssetClassResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tree_item_children(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets the child groups under a TreeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item_children(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `IsCollectorDependentSystem` | Boolean | `eq, neq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `TreeItemType` | GroupTypeCodes | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelTreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tree_item_children_with_http_info(tree_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tree_item_children_with_http_info(tree_item_id, **kwargs)  # noqa: E501
            return data

    def get_tree_item_children_with_http_info(self, tree_item_id, **kwargs):  # noqa: E501
        """Gets the child groups under a TreeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tree_item_children_with_http_info(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, like, in` | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `IsCollectorDependentSystem` | Boolean | `eq, neq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `TreeItemType` | GroupTypeCodes | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelTreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tree_item_id', 'filter', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tree_item_children" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tree_item_id' is set
        if ('tree_item_id' not in params or
                params['tree_item_id'] is None):
            raise ValueError("Missing the required parameter `tree_item_id` when calling `get_tree_item_children`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tree_item_id' in params:
            path_params['treeItemId'] = params['tree_item_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/TreeItems/{treeItemId}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelTreeItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_tree_item(self, tree_item_id, **kwargs):  # noqa: E501
        """Moves a treeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_tree_item(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param GroupMoveRequest body:
        :return: TreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.move_tree_item_with_http_info(tree_item_id, **kwargs)  # noqa: E501
            return data

    def move_tree_item_with_http_info(self, tree_item_id, **kwargs):  # noqa: E501
        """Moves a treeItem  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_tree_item_with_http_info(tree_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tree_item_id: (required)
        :param GroupMoveRequest body:
        :return: TreeItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tree_item_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_tree_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tree_item_id' is set
        if ('tree_item_id' not in params or
                params['tree_item_id'] is None):
            raise ValueError("Missing the required parameter `tree_item_id` when calling `move_tree_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tree_item_id' in params:
            path_params['treeItemId'] = params['tree_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/TreeItems/{treeItemId}/Move', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TreeItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
