# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class NodesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def export_nodes(self, **kwargs):  # noqa: E501
        """Requests Node export.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, like, in` | | `BaseStationReceiverSerialNumber` | String | `eq, neq, like, in` | | `BaseStationSerialNumber` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Nickname` | String | `eq, neq, like, in` | | `NodeTypeCode` | NodeTypeCodes | `eq, neq, in` | | `RepeaterId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `RepeaterName` | String | `eq, neq, like, in` | | `RepeaterSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `BaseStationName` | String | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `LocationName` | String | | `Nickname` | String | | `NodeTypeCode` | NodeTypeCodes | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Nickname`, `SerialNumber`.
        :return: PagedResultsModelNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """Requests Node export.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, like, in` | | `BaseStationReceiverSerialNumber` | String | `eq, neq, like, in` | | `BaseStationSerialNumber` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Nickname` | String | `eq, neq, like, in` | | `NodeTypeCode` | NodeTypeCodes | `eq, neq, in` | | `RepeaterId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `RepeaterName` | String | `eq, neq, like, in` | | `RepeaterSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `BaseStationName` | String | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `LocationName` | String | | `Nickname` | String | | `NodeTypeCode` | NodeTypeCodes | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Nickname`, `SerialNumber`.
        :return: PagedResultsModelNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Nodes/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node(self, node_id, **kwargs):  # noqa: E501
        """Gets the requested node  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The ID of the node (required)
        :param bool include_state: Query parameter used to specify if the returned NodeResponse             should include certain properties
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Gets the requested node  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The ID of the node (required)
        :param bool include_state: Query parameter used to specify if the returned NodeResponse             should include certain properties
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'include_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['nodeId'] = params['node_id']  # noqa: E501

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Nodes/{nodeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nodes(self, **kwargs):  # noqa: E501
        """Gets a paginated list of the nodes to which a user has access  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state: If set to true node state information will be included in the response
        :param list[str] group_ids: If specified, only nodes assigned to monitoring points under these groupIds will be retrieved
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, like, in` | | `BaseStationReceiverSerialNumber` | String | `eq, neq, like, in` | | `BaseStationSerialNumber` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Nickname` | String | `eq, neq, like, in` | | `NodeTypeCode` | NodeTypeCodes | `eq, neq, in` | | `RepeaterId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `RepeaterName` | String | `eq, neq, like, in` | | `RepeaterSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `BaseStationName` | String | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `LocationName` | String | | `Nickname` | String | | `NodeTypeCode` | NodeTypeCodes | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Nickname`, `SerialNumber`.
        :return: PagedResultsModelNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a paginated list of the nodes to which a user has access  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state: If set to true node state information will be included in the response
        :param list[str] group_ids: If specified, only nodes assigned to monitoring points under these groupIds will be retrieved
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, like, in` | | `BaseStationReceiverSerialNumber` | String | `eq, neq, like, in` | | `BaseStationSerialNumber` | String | `eq, neq, like, in` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Nickname` | String | `eq, neq, like, in` | | `NodeTypeCode` | NodeTypeCodes | `eq, neq, in` | | `RepeaterId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `RepeaterName` | String | `eq, neq, like, in` | | `RepeaterSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `BaseStationName` | String | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `LocationName` | String | | `Nickname` | String | | `NodeTypeCode` | NodeTypeCodes | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Nickname`, `SerialNumber`.
        :return: PagedResultsModelNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_state', 'group_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
