# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class InstallsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_users_to_install(self, id, **kwargs):  # noqa: E501
        """Adds one or more users to an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_install(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of an install (required)
        :param InstallModifyUsersRequest body:
        :return: InstallAddUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_users_to_install_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_users_to_install_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def add_users_to_install_with_http_info(self, id, **kwargs):  # noqa: E501
        """Adds one or more users to an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_install_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of an install (required)
        :param InstallModifyUsersRequest body:
        :return: InstallAddUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_users_to_install" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_users_to_install`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{id}/users', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstallAddUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_install_report(self, install_id, **kwargs):  # noqa: E501
        """Triggers a Hangfire job that will email an install's status report to the user  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_install_report(install_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_install_report_with_http_info(install_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_install_report_with_http_info(install_id, **kwargs)  # noqa: E501
            return data

    def export_install_report_with_http_info(self, install_id, **kwargs):  # noqa: E501
        """Triggers a Hangfire job that will email an install's status report to the user  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_install_report_with_http_info(install_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['install_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_install_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'install_id' is set
        if ('install_id' not in params or
                params['install_id'] is None):
            raise ValueError("Missing the required parameter `install_id` when calling `export_install_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'install_id' in params:
            path_params['installId'] = params['install_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{installId}/exportReport', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_install(self, id, **kwargs):  # noqa: E501
        """Gets a single Install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_install(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of install (required)
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_install_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_install_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_install_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets a single Install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_install_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of install (required)
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_install" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_install`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_installs(self, **kwargs):  # noqa: E501
        """Gets a list of installs for the current user  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_installs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `UserEmail` | String | `eq, neq, like, in` | | `UserFirstName` | String | `eq, neq, like, in` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `EndDate` | DateTime? | | `Name` | String | | `StartDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelInstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_installs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_installs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_installs_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of installs for the current user  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_installs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `UserEmail` | String | `eq, neq, like, in` | | `UserFirstName` | String | `eq, neq, like, in` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `EndDate` | DateTime? | | `Name` | String | | `StartDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelInstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_installs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelInstallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_install_status(self, install_id, **kwargs):  # noqa: E501
        """Gets a list of nodes per install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_install_status(install_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: Id of an install (required)
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelInstallNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_install_status_with_http_info(install_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_install_status_with_http_info(install_id, **kwargs)  # noqa: E501
            return data

    def get_node_install_status_with_http_info(self, install_id, **kwargs):  # noqa: E501
        """Gets a list of nodes per install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_install_status_with_http_info(install_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: Id of an install (required)
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelInstallNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['install_id', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_install_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'install_id' is set
        if ('install_id' not in params or
                params['install_id'] is None):
            raise ValueError("Missing the required parameter `install_id` when calling `get_node_install_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'install_id' in params:
            path_params['installId'] = params['install_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{installId}/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelInstallNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_users_from_install(self, id, **kwargs):  # noqa: E501
        """Removes one or more users from an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_users_from_install(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of an install (required)
        :param InstallModifyUsersRequest body:
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_users_from_install_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_users_from_install_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def remove_users_from_install_with_http_info(self, id, **kwargs):  # noqa: E501
        """Removes one or more users from an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_users_from_install_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of an install (required)
        :param InstallModifyUsersRequest body:
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_users_from_install" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_users_from_install`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{id}/users', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_install(self, id, **kwargs):  # noqa: E501
        """Updates properties related to an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_install(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the Guid for the install (required)
        :param InstallUpdateRequest body: the model containing the properties to update
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_install_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_install_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_install_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates properties related to an install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_install_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: the Guid for the install (required)
        :param InstallUpdateRequest body: the model containing the properties to update
        :return: InstallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_install" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_install`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstallResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_install_status(self, install_id, node_id, **kwargs):  # noqa: E501
        """Updates a node's status for the install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_install_status(install_id, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: Id of install (required)
        :param int node_id: Id of node (required)
        :param InstallNodeUpdateRequest body: Status to change node to and accompanying note
        :return: InstallNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_install_status_with_http_info(install_id, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_install_status_with_http_info(install_id, node_id, **kwargs)  # noqa: E501
            return data

    def update_node_install_status_with_http_info(self, install_id, node_id, **kwargs):  # noqa: E501
        """Updates a node's status for the install  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_install_status_with_http_info(install_id, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str install_id: Id of install (required)
        :param int node_id: Id of node (required)
        :param InstallNodeUpdateRequest body: Status to change node to and accompanying note
        :return: InstallNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['install_id', 'node_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_install_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'install_id' is set
        if ('install_id' not in params or
                params['install_id'] is None):
            raise ValueError("Missing the required parameter `install_id` when calling `update_node_install_status`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_node_install_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'install_id' in params:
            path_params['installId'] = params['install_id']  # noqa: E501
        if 'node_id' in params:
            path_params['nodeId'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Installs/{installId}/nodes/{nodeId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstallNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
