# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class IndicatorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_burst_data_audio(self, indicator_id, utc_timestamp, **kwargs):  # noqa: E501
        """Generates audio from Indicator burst data.  Only vibration Indicators are supported.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_burst_data_audio(indicator_id, utc_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: The indicator to generate audio for (required)
        :param int utc_timestamp: The UTC timestamp used to locate the burst data used to generate the audio (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_burst_data_audio_with_http_info(indicator_id, utc_timestamp, **kwargs)  # noqa: E501
        else:
            (data) = self.get_burst_data_audio_with_http_info(indicator_id, utc_timestamp, **kwargs)  # noqa: E501
            return data

    def get_burst_data_audio_with_http_info(self, indicator_id, utc_timestamp, **kwargs):  # noqa: E501
        """Generates audio from Indicator burst data.  Only vibration Indicators are supported.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_burst_data_audio_with_http_info(indicator_id, utc_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: The indicator to generate audio for (required)
        :param int utc_timestamp: The UTC timestamp used to locate the burst data used to generate the audio (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_id', 'utc_timestamp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_burst_data_audio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'indicator_id' is set
        if ('indicator_id' not in params or
                params['indicator_id'] is None):
            raise ValueError("Missing the required parameter `indicator_id` when calling `get_burst_data_audio`")  # noqa: E501
        # verify the required parameter 'utc_timestamp' is set
        if ('utc_timestamp' not in params or
                params['utc_timestamp'] is None):
            raise ValueError("Missing the required parameter `utc_timestamp` when calling `get_burst_data_audio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'indicator_id' in params:
            path_params['indicatorId'] = params['indicator_id']  # noqa: E501
        if 'utc_timestamp' in params:
            path_params['utcTimestamp'] = params['utc_timestamp']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/{indicatorId}/burstDataAudio/{utcTimestamp}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicator(self, indicator_id, **kwargs):  # noqa: E501
        """Gets an indicator response  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: (required)
        :return: IndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicator_with_http_info(indicator_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_indicator_with_http_info(indicator_id, **kwargs)  # noqa: E501
            return data

    def get_indicator_with_http_info(self, indicator_id, **kwargs):  # noqa: E501
        """Gets an indicator response  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_with_http_info(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: (required)
        :return: IndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicator" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'indicator_id' is set
        if ('indicator_id' not in params or
                params['indicator_id'] is None):
            raise ValueError("Missing the required parameter `indicator_id` when calling `get_indicator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'indicator_id' in params:
            path_params['indicatorId'] = params['indicator_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/{indicatorId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicator_alarm_state(self, indicator_id, **kwargs):  # noqa: E501
        """Get the alarm state for a specific indicator  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_alarm_state(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: Id of specific indicator (required)
        :return: IndicatorAlarmStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicator_alarm_state_with_http_info(indicator_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_indicator_alarm_state_with_http_info(indicator_id, **kwargs)  # noqa: E501
            return data

    def get_indicator_alarm_state_with_http_info(self, indicator_id, **kwargs):  # noqa: E501
        """Get the alarm state for a specific indicator  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_alarm_state_with_http_info(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: Id of specific indicator (required)
        :return: IndicatorAlarmStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicator_alarm_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'indicator_id' is set
        if ('indicator_id' not in params or
                params['indicator_id'] is None):
            raise ValueError("Missing the required parameter `indicator_id` when calling `get_indicator_alarm_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'indicator_id' in params:
            path_params['indicatorId'] = params['indicator_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/{indicatorId}/alarmState', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorAlarmStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicator_statistics(self, **kwargs):  # noqa: E501
        """Gets indicator statistics  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_statistics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: A list of groupIds to filter the result
        :param list[str] filter_ids: A list of filterIds to filter the result
        :param datetime start_date: Start of the time duration used to calculate the statistics. Defaults to one day.
        :param datetime end_date: End of the time duration used to calculate the statistics. Defaults to one day.
        :param bool is_export: If true, this route will email an excel workbook instead of returning the json response
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `IndicatorType` | MetricTypeCodes | `eq, neq, in` | | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AverageValue` | Double? | | `MaxValue` | Double? | | `MeasureOf` | SensorRoleTypeCodes | | `OnTime` | Double? | | `SystemSortOrder` | Int32 | | `TimeInAlarm` | Double? | | `TimeInWarning` | Double? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyAbbreviation`, `HierarchyName`.
        :return: PagedResultsModelIndicatorStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicator_statistics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_indicator_statistics_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_indicator_statistics_with_http_info(self, **kwargs):  # noqa: E501
        """Gets indicator statistics  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_statistics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: A list of groupIds to filter the result
        :param list[str] filter_ids: A list of filterIds to filter the result
        :param datetime start_date: Start of the time duration used to calculate the statistics. Defaults to one day.
        :param datetime end_date: End of the time duration used to calculate the statistics. Defaults to one day.
        :param bool is_export: If true, this route will email an excel workbook instead of returning the json response
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` | | `IndicatorType` | MetricTypeCodes | `eq, neq, in` | | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `AverageValue` | Double? | | `MaxValue` | Double? | | `MeasureOf` | SensorRoleTypeCodes | | `OnTime` | Double? | | `SystemSortOrder` | Int32 | | `TimeInAlarm` | Double? | | `TimeInWarning` | Double? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyAbbreviation`, `HierarchyName`.
        :return: PagedResultsModelIndicatorStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter_ids', 'start_date', 'end_date', 'is_export', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicator_statistics" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter_ids' in params:
            query_params.append(('filterIds', params['filter_ids']))  # noqa: E501
            collection_formats['filterIds'] = 'multi'  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'is_export' in params:
            query_params.append(('isExport', params['is_export']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelIndicatorStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicator_types(self, **kwargs):  # noqa: E501
        """Gets indicator types  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_types(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Int32 | | `IndicatorType` | MetricTypeCodes | | `Name` | String |
        :return: list[IndicatorTypesResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicator_types_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_indicator_types_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_indicator_types_with_http_info(self, **kwargs):  # noqa: E501
        """Gets indicator types  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicator_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Id` | Int32 | | `IndicatorType` | MetricTypeCodes | | `Name` | String |
        :return: list[IndicatorTypesResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicator_types" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/Types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IndicatorTypesResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicators(self, **kwargs):  # noqa: E501
        """Gets indicator responses  # noqa: E501

        NOTE: 'OR' filtering is not supported by this endpoint.  Required Permissions: Location User.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: A list of groupIds to filter the result
        :param list[str] filter_ids: A list of filterIds to filter the result
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Classification` | MetricClassificationSourceEnum | `eq, neq, in` | | `ClassificationIndicatorSourceId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `CorporationId` | Guid | `eq, neq, in` | | `Id` | Guid | `eq, neq, in` | | `IndicatorType` | MetricTypeCodes | `eq, neq, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationId` | Guid | | `Id` | Guid | | `MeasureOf` | SensorRoleTypeCodes | | `Name` | String | | `SystemSortOrder` | Int32 |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchySearch`, `Name`.
        :return: PagedResultsModelIndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicators_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_indicators_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_indicators_with_http_info(self, **kwargs):  # noqa: E501
        """Gets indicator responses  # noqa: E501

        NOTE: 'OR' filtering is not supported by this endpoint.  Required Permissions: Location User.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: A list of groupIds to filter the result
        :param list[str] filter_ids: A list of filterIds to filter the result
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Classification` | MetricClassificationSourceEnum | `eq, neq, in` | | `ClassificationIndicatorSourceId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `CorporationId` | Guid | `eq, neq, in` | | `Id` | Guid | `eq, neq, in` | | `IndicatorType` | MetricTypeCodes | `eq, neq, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationId` | Guid | | `Id` | Guid | | `MeasureOf` | SensorRoleTypeCodes | | `Name` | String | | `SystemSortOrder` | Int32 |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchySearch`, `Name`.
        :return: PagedResultsModelIndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicators" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter_ids' in params:
            query_params.append(('filterIds', params['filter_ids']))  # noqa: E501
            collection_formats['filterIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelIndicatorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_indicators_alarm_state(self, **kwargs):  # noqa: E501
        """Get the alarm state for a list of indicators  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_alarm_state(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` |
        :return: list[IndicatorAlarmStateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_indicators_alarm_state_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_indicators_alarm_state_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_indicators_alarm_state_with_http_info(self, **kwargs):  # noqa: E501
        """Get the alarm state for a list of indicators  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_indicators_alarm_state_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Id` | Guid | `eq, neq, in` |
        :return: list[IndicatorAlarmStateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_indicators_alarm_state" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/alarmState', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IndicatorAlarmStateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_measure_ofs_for_indicator(self, **kwargs):  # noqa: E501
        """Returns a list of measureOf values and their UI-friendly format  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_measure_ofs_for_indicator(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IndicatorOptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_measure_ofs_for_indicator_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_measure_ofs_for_indicator_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_measure_ofs_for_indicator_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of measureOf values and their UI-friendly format  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_measure_ofs_for_indicator_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: IndicatorOptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_measure_ofs_for_indicator" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/measureOfs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorOptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_for_indicator(self, indicator_id, **kwargs):  # noqa: E501
        """Gets statistics for a specific indicator  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_for_indicator(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: Id of requested indicator (required)
        :param datetime start_date: Start of the time duration used to calculate the statistics. Defaults to one day.
        :param datetime end_date: End of the time duration used to calculate the statistics. Defaults to one day.
        :return: IndicatorStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_for_indicator_with_http_info(indicator_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_for_indicator_with_http_info(indicator_id, **kwargs)  # noqa: E501
            return data

    def get_statistics_for_indicator_with_http_info(self, indicator_id, **kwargs):  # noqa: E501
        """Gets statistics for a specific indicator  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_for_indicator_with_http_info(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: Id of requested indicator (required)
        :param datetime start_date: Start of the time duration used to calculate the statistics. Defaults to one day.
        :param datetime end_date: End of the time duration used to calculate the statistics. Defaults to one day.
        :return: IndicatorStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_for_indicator" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'indicator_id' is set
        if ('indicator_id' not in params or
                params['indicator_id'] is None):
            raise ValueError("Missing the required parameter `indicator_id` when calling `get_statistics_for_indicator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'indicator_id' in params:
            path_params['indicatorId'] = params['indicator_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/{indicatorId}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_smart_alarms(self, indicator_id, **kwargs):  # noqa: E501
        """Calculates and sets smart alarms for the given indicator.  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_smart_alarms(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: The indicator to calculate the thresholds for (required)
        :param SmartAlarmsRequest body:
        :return: IndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_smart_alarms_with_http_info(indicator_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_smart_alarms_with_http_info(indicator_id, **kwargs)  # noqa: E501
            return data

    def set_smart_alarms_with_http_info(self, indicator_id, **kwargs):  # noqa: E501
        """Calculates and sets smart alarms for the given indicator.  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_smart_alarms_with_http_info(indicator_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str indicator_id: The indicator to calculate the thresholds for (required)
        :param SmartAlarmsRequest body:
        :return: IndicatorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['indicator_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_smart_alarms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'indicator_id' is set
        if ('indicator_id' not in params or
                params['indicator_id'] is None):
            raise ValueError("Missing the required parameter `indicator_id` when calling `set_smart_alarms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'indicator_id' in params:
            path_params['indicatorId'] = params['indicator_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Indicators/{indicatorId}/smartAlarms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndicatorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
