# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class BoardTicketStatusesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_status(self, **kwargs):  # noqa: E501
        """Creates a status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BoardTicketStatusCreateRequest body:
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_status_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BoardTicketStatusCreateRequest body:
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BoardTicketStatuses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_status(self, status_id, **kwargs):  # noqa: E501
        """Deletes the Status with the specified id.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_status(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_status_with_http_info(status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_status_with_http_info(status_id, **kwargs)  # noqa: E501
            return data

    def delete_status_with_http_info(self, status_id, **kwargs):  # noqa: E501
        """Deletes the Status with the specified id.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_status_with_http_info(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params or
                params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `delete_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BoardTicketStatuses/{statusId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_default_statuses(self, **kwargs):  # noqa: E501
        """Gets a list of the default statuses in arbitrary,  static order.    The ids specified on these StatusChildren are to allow easy differentiation on  the frontend. They do not represent anything stored in the db.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_statuses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[StatusChild]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_default_statuses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_default_statuses_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_default_statuses_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of the default statuses in arbitrary,  static order.    The ids specified on these StatusChildren are to allow easy differentiation on  the frontend. They do not represent anything stored in the db.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_statuses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[StatusChild]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_default_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BoardTicketStatuses/defaultStatuses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StatusChild]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, status_id, **kwargs):  # noqa: E501
        """Gets a Status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_with_http_info(status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(status_id, **kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, status_id, **kwargs):  # noqa: E501
        """Gets a Status  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_with_http_info(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params or
                params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `get_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BoardTicketStatuses/{statusId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_status(self, status_id, **kwargs):  # noqa: E501
        """Updates the status with the specified id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_status(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :param BoardTicketStatusUpdateRequest body:
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_status_with_http_info(status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_status_with_http_info(status_id, **kwargs)  # noqa: E501
            return data

    def update_status_with_http_info(self, status_id, **kwargs):  # noqa: E501
        """Updates the status with the specified id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_status_with_http_info(status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status_id: (required)
        :param BoardTicketStatusUpdateRequest body:
        :return: StatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params or
                params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `update_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BoardTicketStatuses/{statusId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
