# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class BaseStationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_base_station(self, **kwargs):  # noqa: E501
        """Creates a Base Station  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_base_station(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BaseStationCreateRequest body: Specifies the properties for the new Base Station
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_base_station_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_base_station_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_base_station_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a Base Station  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_base_station_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BaseStationCreateRequest body: Specifies the properties for the new Base Station
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_base_station" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_base_station(self, base_station_id, **kwargs):  # noqa: E501
        """Edits a Base Station  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_base_station(base_station_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int base_station_id: Id of the Base Station (required)
        :param BaseStationUpdateRequest body: Contains the properties to update
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_base_station_with_http_info(base_station_id, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_base_station_with_http_info(base_station_id, **kwargs)  # noqa: E501
            return data

    def edit_base_station_with_http_info(self, base_station_id, **kwargs):  # noqa: E501
        """Edits a Base Station  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_base_station_with_http_info(base_station_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int base_station_id: Id of the Base Station (required)
        :param BaseStationUpdateRequest body: Contains the properties to update
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['base_station_id', 'body', 'include_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_base_station" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'base_station_id' is set
        if ('base_station_id' not in params or
                params['base_station_id'] is None):
            raise ValueError("Missing the required parameter `base_station_id` when calling `edit_base_station`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'base_station_id' in params:
            path_params['baseStationId'] = params['base_station_id']  # noqa: E501

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations/{baseStationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_base_stations(self, **kwargs):  # noqa: E501
        """Requests a Base Station export.  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_base_stations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `CurrentSoftwareReleaseId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CurrentSoftwareReleaseName` | String | `eq, neq, like, in` | | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `HardwareRevisionName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `ReleaseRingId` | Guid | `eq, neq, in` | | `ReleaseRingName` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TargetedSoftwareReleaseName` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `CurrentSoftwareReleaseName` | String | | `HardwareRevisionId` | Int32 | | `HardwareRevisionName` | String | | `LocationName` | String | | `Name` | String | | `NodeCount` | Int32 | | `PushToStage` | Boolean | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `ReleaseRingId` | Guid | | `ReleaseRingName` | String | | `SerialNumber` | String | | `TargetedSoftwareReleaseName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `CurrentSoftwareReleaseName`, `HardwareRevisionName`, `LocationName`, `Name`, `ReleaseRingName`, `SerialNumber`.
        :return: PagedResultsModelBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_base_stations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_base_stations_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_base_stations_with_http_info(self, **kwargs):  # noqa: E501
        """Requests a Base Station export.  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_base_stations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `CurrentSoftwareReleaseId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CurrentSoftwareReleaseName` | String | `eq, neq, like, in` | | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `HardwareRevisionName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `ReleaseRingId` | Guid | `eq, neq, in` | | `ReleaseRingName` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TargetedSoftwareReleaseName` | String | `eq, neq, like, in` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `CurrentSoftwareReleaseName` | String | | `HardwareRevisionId` | Int32 | | `HardwareRevisionName` | String | | `LocationName` | String | | `Name` | String | | `NodeCount` | Int32 | | `PushToStage` | Boolean | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `ReleaseRingId` | Guid | | `ReleaseRingName` | String | | `SerialNumber` | String | | `TargetedSoftwareReleaseName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `CurrentSoftwareReleaseName`, `HardwareRevisionName`, `LocationName`, `Name`, `ReleaseRingName`, `SerialNumber`.
        :return: PagedResultsModelBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_base_stations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelBaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base_station(self, base_station_id, **kwargs):  # noqa: E501
        """Gets a Base Station by Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_station(base_station_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int base_station_id: Id of the Base Station (required)
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_station_with_http_info(base_station_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_base_station_with_http_info(base_station_id, **kwargs)  # noqa: E501
            return data

    def get_base_station_with_http_info(self, base_station_id, **kwargs):  # noqa: E501
        """Gets a Base Station by Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_station_with_http_info(base_station_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int base_station_id: Id of the Base Station (required)
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['base_station_id', 'include_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base_station" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'base_station_id' is set
        if ('base_station_id' not in params or
                params['base_station_id'] is None):
            raise ValueError("Missing the required parameter `base_station_id` when calling `get_base_station`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'base_station_id' in params:
            path_params['baseStationId'] = params['base_station_id']  # noqa: E501

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations/{baseStationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base_station_default_receiver_frequencies(self, **kwargs):  # noqa: E501
        """Returns a list of default Receiver Frequencies for a Base Station  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_station_default_receiver_frequencies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[OptionModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_station_default_receiver_frequencies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_base_station_default_receiver_frequencies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_base_station_default_receiver_frequencies_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of default Receiver Frequencies for a Base Station  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_station_default_receiver_frequencies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[OptionModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base_station_default_receiver_frequencies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations/DefaultReceiverFrequencies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OptionModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base_stations(self, **kwargs):  # noqa: E501
        """Gets a paged list of Base Stations  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_stations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `CurrentSoftwareReleaseId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CurrentSoftwareReleaseName` | String | `eq, neq, like, in` | | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `HardwareRevisionName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `ReleaseRingId` | Guid | `eq, neq, in` | | `ReleaseRingName` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TargetedSoftwareReleaseName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `CurrentSoftwareReleaseName` | String | | `HardwareRevisionId` | Int32 | | `HardwareRevisionName` | String | | `LocationName` | String | | `Name` | String | | `NodeCount` | Int32 | | `PushToStage` | Boolean | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `ReleaseRingId` | Guid | | `ReleaseRingName` | String | | `SerialNumber` | String | | `TargetedSoftwareReleaseName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `CurrentSoftwareReleaseName`, `HardwareRevisionName`, `LocationName`, `Name`, `ReleaseRingName`, `SerialNumber`.
        :return: PagedResultsModelBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_stations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_base_stations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_base_stations_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a paged list of Base Stations  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_stations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state: Determines whether to include the states for              the LastDataUpdate, LastStatusUpdate, and IsOnline
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `CurrentSoftwareReleaseId` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `CurrentSoftwareReleaseName` | String | `eq, neq, like, in` | | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `HardwareRevisionName` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `ReleaseRingId` | Guid | `eq, neq, in` | | `ReleaseRingName` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `TargetedSoftwareReleaseName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `CurrentSoftwareReleaseName` | String | | `HardwareRevisionId` | Int32 | | `HardwareRevisionName` | String | | `LocationName` | String | | `Name` | String | | `NodeCount` | Int32 | | `PushToStage` | Boolean | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `ReleaseRingId` | Guid | | `ReleaseRingName` | String | | `SerialNumber` | String | | `TargetedSoftwareReleaseName` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `CurrentSoftwareReleaseName`, `HardwareRevisionName`, `LocationName`, `Name`, `ReleaseRingName`, `SerialNumber`.
        :return: PagedResultsModelBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_state', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base_stations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelBaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reboot_base_station(self, basestation_id, **kwargs):  # noqa: E501
        """Reboots a given Base station  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reboot_base_station(basestation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int basestation_id: The base station to trigger the reboot for (required)
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reboot_base_station_with_http_info(basestation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reboot_base_station_with_http_info(basestation_id, **kwargs)  # noqa: E501
            return data

    def reboot_base_station_with_http_info(self, basestation_id, **kwargs):  # noqa: E501
        """Reboots a given Base station  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reboot_base_station_with_http_info(basestation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int basestation_id: The base station to trigger the reboot for (required)
        :return: BaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['basestation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reboot_base_station" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'basestation_id' is set
        if ('basestation_id' not in params or
                params['basestation_id'] is None):
            raise ValueError("Missing the required parameter `basestation_id` when calling `reboot_base_station`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'basestation_id' in params:
            path_params['basestationId'] = params['basestation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/BaseStations/{basestationId}/reboot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
