# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class AlertsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def acknowledge_alerts_by_group_ids(self, **kwargs):  # noqa: E501
        """Acknowledges all alerts for the supplied groups  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_alerts_by_group_ids(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupAlertsAcknowledgementRequest body: Supplied groups for which alerts will be acknowledged
        :return: AcknowledgedAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.acknowledge_alerts_by_group_ids_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.acknowledge_alerts_by_group_ids_with_http_info(**kwargs)  # noqa: E501
            return data

    def acknowledge_alerts_by_group_ids_with_http_info(self, **kwargs):  # noqa: E501
        """Acknowledges all alerts for the supplied groups  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_alerts_by_group_ids_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupAlertsAcknowledgementRequest body: Supplied groups for which alerts will be acknowledged
        :return: AcknowledgedAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acknowledge_alerts_by_group_ids" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Alerts/acknowledgeGroupAlerts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcknowledgedAlertsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def acknowledge_alerts_by_ids(self, **kwargs):  # noqa: E501
        """Acknowledges alerts  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_alerts_by_ids(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertsAcknowledgementRequest body: Supplied alerts for acknowledgement
        :return: AcknowledgedAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.acknowledge_alerts_by_ids_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.acknowledge_alerts_by_ids_with_http_info(**kwargs)  # noqa: E501
            return data

    def acknowledge_alerts_by_ids_with_http_info(self, **kwargs):  # noqa: E501
        """Acknowledges alerts  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_alerts_by_ids_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertsAcknowledgementRequest body: Supplied alerts for acknowledgement
        :return: AcknowledgedAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acknowledge_alerts_by_ids" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Alerts/acknowledgeAlerts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcknowledgedAlertsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert(self, alert_id, **kwargs):  # noqa: E501
        """Gets a single alert by Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert(alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alert_id: The Id for the alert to retrieve for the response (required)
        :return: AlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_with_http_info(alert_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_with_http_info(alert_id, **kwargs)  # noqa: E501
            return data

    def get_alert_with_http_info(self, alert_id, **kwargs):  # noqa: E501
        """Gets a single alert by Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_with_http_info(alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alert_id: The Id for the alert to retrieve for the response (required)
        :return: AlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params or
                params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `get_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Alerts/{alertId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlertResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alerts(self, **kwargs):  # noqa: E501
        """Gets alerts  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alerts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: Filters result to Alerts under provided list groups
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `IndicatorId` | Guid | `eq, neq, in` | | `IsAcknowledged` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `UserEmail` | String | `eq, neq, like, in` | | `UserFirstName` | String | `eq, neq, like, in` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `TimeAcknowledged` | DateTime? | | `TimeOfAlert` | DateTime |
        :return: PagedResultsModelAlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alerts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_alerts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_alerts_with_http_info(self, **kwargs):  # noqa: E501
        """Gets alerts  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alerts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids: Filters result to Alerts under provided list groups
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `IndicatorId` | Guid | `eq, neq, in` | | `IsAcknowledged` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `UserEmail` | String | `eq, neq, like, in` | | `UserFirstName` | String | `eq, neq, like, in` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `TimeAcknowledged` | DateTime? | | `TimeOfAlert` | DateTime |
        :return: PagedResultsModelAlertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alerts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelAlertResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
