# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineArgs', 'VirtualMachine']

@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 node_name: pulumi.Input[str],
                 acpi: Optional[pulumi.Input[bool]] = None,
                 agent: Optional[pulumi.Input['VirtualMachineAgentArgs']] = None,
                 audio_device: Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']] = None,
                 bios: Optional[pulumi.Input[str]] = None,
                 cdrom: Optional[pulumi.Input['VirtualMachineCdromArgs']] = None,
                 clone: Optional[pulumi.Input['VirtualMachineCloneArgs']] = None,
                 cpu: Optional[pulumi.Input['VirtualMachineCpuArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]] = None,
                 hostpcis: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]] = None,
                 initialization: Optional[pulumi.Input['VirtualMachineInitializationArgs']] = None,
                 keyboard_layout: Optional[pulumi.Input[str]] = None,
                 kvm_arguments: Optional[pulumi.Input[str]] = None,
                 machine: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input['VirtualMachineMemoryArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]] = None,
                 on_boot: Optional[pulumi.Input[bool]] = None,
                 operating_system: Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 reboot: Optional[pulumi.Input[bool]] = None,
                 serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 tablet_device: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 timeout_clone: Optional[pulumi.Input[int]] = None,
                 timeout_move_disk: Optional[pulumi.Input[int]] = None,
                 timeout_reboot: Optional[pulumi.Input[int]] = None,
                 timeout_shutdown_vm: Optional[pulumi.Input[int]] = None,
                 timeout_start_vm: Optional[pulumi.Input[int]] = None,
                 timeout_stop_vm: Optional[pulumi.Input[int]] = None,
                 vga: Optional[pulumi.Input['VirtualMachineVgaArgs']] = None,
                 vm_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a VirtualMachine resource.
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input['VirtualMachineAgentArgs'] agent: The QEMU agent configuration
        :param pulumi.Input['VirtualMachineAudioDeviceArgs'] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input['VirtualMachineCdromArgs'] cdrom: The CDROM drive
        :param pulumi.Input['VirtualMachineCloneArgs'] clone: The cloning configuration
        :param pulumi.Input['VirtualMachineCpuArgs'] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]] disks: The disk devices
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]] hostpcis: The Host PCI devices mapped to the VM
        :param pulumi.Input['VirtualMachineInitializationArgs'] initialization: The cloud-init configuration
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[str] kvm_arguments: The args implementation
        :param pulumi.Input[str] machine: The VM machine type, either default i440fx or q35
        :param pulumi.Input['VirtualMachineMemoryArgs'] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]] network_devices: The network devices
        :param pulumi.Input[bool] on_boot: Start VM on Node boot
        :param pulumi.Input['VirtualMachineOperatingSystemArgs'] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[bool] reboot: Whether to reboot vm after creation
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags of the virtual machine. This is only meta information.
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] timeout_clone: Clone VM timeout
        :param pulumi.Input[int] timeout_move_disk: MoveDisk timeout
        :param pulumi.Input[int] timeout_reboot: Reboot timeout
        :param pulumi.Input[int] timeout_shutdown_vm: Shutdown timeout
        :param pulumi.Input[int] timeout_start_vm: Start VM timeout
        :param pulumi.Input[int] timeout_stop_vm: Stop VM timeout
        :param pulumi.Input['VirtualMachineVgaArgs'] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        pulumi.set(__self__, "node_name", node_name)
        if acpi is not None:
            pulumi.set(__self__, "acpi", acpi)
        if agent is not None:
            pulumi.set(__self__, "agent", agent)
        if audio_device is not None:
            pulumi.set(__self__, "audio_device", audio_device)
        if bios is not None:
            pulumi.set(__self__, "bios", bios)
        if cdrom is not None:
            pulumi.set(__self__, "cdrom", cdrom)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if hostpcis is not None:
            pulumi.set(__self__, "hostpcis", hostpcis)
        if initialization is not None:
            pulumi.set(__self__, "initialization", initialization)
        if keyboard_layout is not None:
            pulumi.set(__self__, "keyboard_layout", keyboard_layout)
        if kvm_arguments is not None:
            pulumi.set(__self__, "kvm_arguments", kvm_arguments)
        if machine is not None:
            pulumi.set(__self__, "machine", machine)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_devices is not None:
            pulumi.set(__self__, "network_devices", network_devices)
        if on_boot is not None:
            pulumi.set(__self__, "on_boot", on_boot)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)
        if serial_devices is not None:
            pulumi.set(__self__, "serial_devices", serial_devices)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if tablet_device is not None:
            pulumi.set(__self__, "tablet_device", tablet_device)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timeout_clone is not None:
            pulumi.set(__self__, "timeout_clone", timeout_clone)
        if timeout_move_disk is not None:
            pulumi.set(__self__, "timeout_move_disk", timeout_move_disk)
        if timeout_reboot is not None:
            pulumi.set(__self__, "timeout_reboot", timeout_reboot)
        if timeout_shutdown_vm is not None:
            pulumi.set(__self__, "timeout_shutdown_vm", timeout_shutdown_vm)
        if timeout_start_vm is not None:
            pulumi.set(__self__, "timeout_start_vm", timeout_start_vm)
        if timeout_stop_vm is not None:
            pulumi.set(__self__, "timeout_stop_vm", timeout_stop_vm)
        if vga is not None:
            pulumi.set(__self__, "vga", vga)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Input[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter
    def acpi(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable ACPI
        """
        return pulumi.get(self, "acpi")

    @acpi.setter
    def acpi(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acpi", value)

    @property
    @pulumi.getter
    def agent(self) -> Optional[pulumi.Input['VirtualMachineAgentArgs']]:
        """
        The QEMU agent configuration
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: Optional[pulumi.Input['VirtualMachineAgentArgs']]):
        pulumi.set(self, "agent", value)

    @property
    @pulumi.getter(name="audioDevice")
    def audio_device(self) -> Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']]:
        """
        The audio devices
        """
        return pulumi.get(self, "audio_device")

    @audio_device.setter
    def audio_device(self, value: Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']]):
        pulumi.set(self, "audio_device", value)

    @property
    @pulumi.getter
    def bios(self) -> Optional[pulumi.Input[str]]:
        """
        The BIOS implementation
        """
        return pulumi.get(self, "bios")

    @bios.setter
    def bios(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bios", value)

    @property
    @pulumi.getter
    def cdrom(self) -> Optional[pulumi.Input['VirtualMachineCdromArgs']]:
        """
        The CDROM drive
        """
        return pulumi.get(self, "cdrom")

    @cdrom.setter
    def cdrom(self, value: Optional[pulumi.Input['VirtualMachineCdromArgs']]):
        pulumi.set(self, "cdrom", value)

    @property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['VirtualMachineCloneArgs']]:
        """
        The cloning configuration
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['VirtualMachineCloneArgs']]):
        pulumi.set(self, "clone", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input['VirtualMachineCpuArgs']]:
        """
        The CPU allocation
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input['VirtualMachineCpuArgs']]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]:
        """
        The disk devices
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter
    def hostpcis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]]:
        """
        The Host PCI devices mapped to the VM
        """
        return pulumi.get(self, "hostpcis")

    @hostpcis.setter
    def hostpcis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]]):
        pulumi.set(self, "hostpcis", value)

    @property
    @pulumi.getter
    def initialization(self) -> Optional[pulumi.Input['VirtualMachineInitializationArgs']]:
        """
        The cloud-init configuration
        """
        return pulumi.get(self, "initialization")

    @initialization.setter
    def initialization(self, value: Optional[pulumi.Input['VirtualMachineInitializationArgs']]):
        pulumi.set(self, "initialization", value)

    @property
    @pulumi.getter(name="keyboardLayout")
    def keyboard_layout(self) -> Optional[pulumi.Input[str]]:
        """
        The keyboard layout
        """
        return pulumi.get(self, "keyboard_layout")

    @keyboard_layout.setter
    def keyboard_layout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyboard_layout", value)

    @property
    @pulumi.getter(name="kvmArguments")
    def kvm_arguments(self) -> Optional[pulumi.Input[str]]:
        """
        The args implementation
        """
        return pulumi.get(self, "kvm_arguments")

    @kvm_arguments.setter
    def kvm_arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kvm_arguments", value)

    @property
    @pulumi.getter
    def machine(self) -> Optional[pulumi.Input[str]]:
        """
        The VM machine type, either default i440fx or q35
        """
        return pulumi.get(self, "machine")

    @machine.setter
    def machine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input['VirtualMachineMemoryArgs']]:
        """
        The memory allocation
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input['VirtualMachineMemoryArgs']]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkDevices")
    def network_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]]:
        """
        The network devices
        """
        return pulumi.get(self, "network_devices")

    @network_devices.setter
    def network_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]]):
        pulumi.set(self, "network_devices", value)

    @property
    @pulumi.getter(name="onBoot")
    def on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Start VM on Node boot
        """
        return pulumi.get(self, "on_boot")

    @on_boot.setter
    def on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_boot", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']]:
        """
        The operating system configuration
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the pool to assign the virtual machine to
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter
    def reboot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reboot vm after creation
        """
        return pulumi.get(self, "reboot")

    @reboot.setter
    def reboot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reboot", value)

    @property
    @pulumi.getter(name="serialDevices")
    def serial_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]]:
        """
        The serial devices
        """
        return pulumi.get(self, "serial_devices")

    @serial_devices.setter
    def serial_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]]):
        pulumi.set(self, "serial_devices", value)

    @property
    @pulumi.getter
    def started(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to start the virtual machine
        """
        return pulumi.get(self, "started")

    @started.setter
    def started(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "started", value)

    @property
    @pulumi.getter(name="tabletDevice")
    def tablet_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the USB tablet device
        """
        return pulumi.get(self, "tablet_device")

    @tablet_device.setter
    def tablet_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tablet_device", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags of the virtual machine. This is only meta information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="timeoutClone")
    def timeout_clone(self) -> Optional[pulumi.Input[int]]:
        """
        Clone VM timeout
        """
        return pulumi.get(self, "timeout_clone")

    @timeout_clone.setter
    def timeout_clone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_clone", value)

    @property
    @pulumi.getter(name="timeoutMoveDisk")
    def timeout_move_disk(self) -> Optional[pulumi.Input[int]]:
        """
        MoveDisk timeout
        """
        return pulumi.get(self, "timeout_move_disk")

    @timeout_move_disk.setter
    def timeout_move_disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_move_disk", value)

    @property
    @pulumi.getter(name="timeoutReboot")
    def timeout_reboot(self) -> Optional[pulumi.Input[int]]:
        """
        Reboot timeout
        """
        return pulumi.get(self, "timeout_reboot")

    @timeout_reboot.setter
    def timeout_reboot(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_reboot", value)

    @property
    @pulumi.getter(name="timeoutShutdownVm")
    def timeout_shutdown_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Shutdown timeout
        """
        return pulumi.get(self, "timeout_shutdown_vm")

    @timeout_shutdown_vm.setter
    def timeout_shutdown_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_shutdown_vm", value)

    @property
    @pulumi.getter(name="timeoutStartVm")
    def timeout_start_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Start VM timeout
        """
        return pulumi.get(self, "timeout_start_vm")

    @timeout_start_vm.setter
    def timeout_start_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_start_vm", value)

    @property
    @pulumi.getter(name="timeoutStopVm")
    def timeout_stop_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Stop VM timeout
        """
        return pulumi.get(self, "timeout_stop_vm")

    @timeout_stop_vm.setter
    def timeout_stop_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_stop_vm", value)

    @property
    @pulumi.getter
    def vga(self) -> Optional[pulumi.Input['VirtualMachineVgaArgs']]:
        """
        The VGA configuration
        """
        return pulumi.get(self, "vga")

    @vga.setter
    def vga(self, value: Optional[pulumi.Input['VirtualMachineVgaArgs']]):
        pulumi.set(self, "vga", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VM identifier
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_id", value)


@pulumi.input_type
class _VirtualMachineState:
    def __init__(__self__, *,
                 acpi: Optional[pulumi.Input[bool]] = None,
                 agent: Optional[pulumi.Input['VirtualMachineAgentArgs']] = None,
                 audio_device: Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']] = None,
                 bios: Optional[pulumi.Input[str]] = None,
                 cdrom: Optional[pulumi.Input['VirtualMachineCdromArgs']] = None,
                 clone: Optional[pulumi.Input['VirtualMachineCloneArgs']] = None,
                 cpu: Optional[pulumi.Input['VirtualMachineCpuArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]] = None,
                 hostpcis: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]] = None,
                 initialization: Optional[pulumi.Input['VirtualMachineInitializationArgs']] = None,
                 ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 keyboard_layout: Optional[pulumi.Input[str]] = None,
                 kvm_arguments: Optional[pulumi.Input[str]] = None,
                 mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 machine: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input['VirtualMachineMemoryArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]] = None,
                 network_interface_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 on_boot: Optional[pulumi.Input[bool]] = None,
                 operating_system: Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 reboot: Optional[pulumi.Input[bool]] = None,
                 serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 tablet_device: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 timeout_clone: Optional[pulumi.Input[int]] = None,
                 timeout_move_disk: Optional[pulumi.Input[int]] = None,
                 timeout_reboot: Optional[pulumi.Input[int]] = None,
                 timeout_shutdown_vm: Optional[pulumi.Input[int]] = None,
                 timeout_start_vm: Optional[pulumi.Input[int]] = None,
                 timeout_stop_vm: Optional[pulumi.Input[int]] = None,
                 vga: Optional[pulumi.Input['VirtualMachineVgaArgs']] = None,
                 vm_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering VirtualMachine resources.
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input['VirtualMachineAgentArgs'] agent: The QEMU agent configuration
        :param pulumi.Input['VirtualMachineAudioDeviceArgs'] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input['VirtualMachineCdromArgs'] cdrom: The CDROM drive
        :param pulumi.Input['VirtualMachineCloneArgs'] clone: The cloning configuration
        :param pulumi.Input['VirtualMachineCpuArgs'] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]] disks: The disk devices
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]] hostpcis: The Host PCI devices mapped to the VM
        :param pulumi.Input['VirtualMachineInitializationArgs'] initialization: The cloud-init configuration
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv4_addresses: The IPv4 addresses published by the QEMU agent
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv6_addresses: The IPv6 addresses published by the QEMU agent
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[str] kvm_arguments: The args implementation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_addresses: The MAC addresses for the network interfaces
        :param pulumi.Input[str] machine: The VM machine type, either default i440fx or q35
        :param pulumi.Input['VirtualMachineMemoryArgs'] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]] network_devices: The network devices
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_names: The network interface names published by the QEMU agent
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] on_boot: Start VM on Node boot
        :param pulumi.Input['VirtualMachineOperatingSystemArgs'] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[bool] reboot: Whether to reboot vm after creation
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags of the virtual machine. This is only meta information.
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] timeout_clone: Clone VM timeout
        :param pulumi.Input[int] timeout_move_disk: MoveDisk timeout
        :param pulumi.Input[int] timeout_reboot: Reboot timeout
        :param pulumi.Input[int] timeout_shutdown_vm: Shutdown timeout
        :param pulumi.Input[int] timeout_start_vm: Start VM timeout
        :param pulumi.Input[int] timeout_stop_vm: Stop VM timeout
        :param pulumi.Input['VirtualMachineVgaArgs'] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        if acpi is not None:
            pulumi.set(__self__, "acpi", acpi)
        if agent is not None:
            pulumi.set(__self__, "agent", agent)
        if audio_device is not None:
            pulumi.set(__self__, "audio_device", audio_device)
        if bios is not None:
            pulumi.set(__self__, "bios", bios)
        if cdrom is not None:
            pulumi.set(__self__, "cdrom", cdrom)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if hostpcis is not None:
            pulumi.set(__self__, "hostpcis", hostpcis)
        if initialization is not None:
            pulumi.set(__self__, "initialization", initialization)
        if ipv4_addresses is not None:
            pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if keyboard_layout is not None:
            pulumi.set(__self__, "keyboard_layout", keyboard_layout)
        if kvm_arguments is not None:
            pulumi.set(__self__, "kvm_arguments", kvm_arguments)
        if mac_addresses is not None:
            pulumi.set(__self__, "mac_addresses", mac_addresses)
        if machine is not None:
            pulumi.set(__self__, "machine", machine)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_devices is not None:
            pulumi.set(__self__, "network_devices", network_devices)
        if network_interface_names is not None:
            pulumi.set(__self__, "network_interface_names", network_interface_names)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if on_boot is not None:
            pulumi.set(__self__, "on_boot", on_boot)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)
        if serial_devices is not None:
            pulumi.set(__self__, "serial_devices", serial_devices)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if tablet_device is not None:
            pulumi.set(__self__, "tablet_device", tablet_device)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timeout_clone is not None:
            pulumi.set(__self__, "timeout_clone", timeout_clone)
        if timeout_move_disk is not None:
            pulumi.set(__self__, "timeout_move_disk", timeout_move_disk)
        if timeout_reboot is not None:
            pulumi.set(__self__, "timeout_reboot", timeout_reboot)
        if timeout_shutdown_vm is not None:
            pulumi.set(__self__, "timeout_shutdown_vm", timeout_shutdown_vm)
        if timeout_start_vm is not None:
            pulumi.set(__self__, "timeout_start_vm", timeout_start_vm)
        if timeout_stop_vm is not None:
            pulumi.set(__self__, "timeout_stop_vm", timeout_stop_vm)
        if vga is not None:
            pulumi.set(__self__, "vga", vga)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter
    def acpi(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable ACPI
        """
        return pulumi.get(self, "acpi")

    @acpi.setter
    def acpi(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acpi", value)

    @property
    @pulumi.getter
    def agent(self) -> Optional[pulumi.Input['VirtualMachineAgentArgs']]:
        """
        The QEMU agent configuration
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: Optional[pulumi.Input['VirtualMachineAgentArgs']]):
        pulumi.set(self, "agent", value)

    @property
    @pulumi.getter(name="audioDevice")
    def audio_device(self) -> Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']]:
        """
        The audio devices
        """
        return pulumi.get(self, "audio_device")

    @audio_device.setter
    def audio_device(self, value: Optional[pulumi.Input['VirtualMachineAudioDeviceArgs']]):
        pulumi.set(self, "audio_device", value)

    @property
    @pulumi.getter
    def bios(self) -> Optional[pulumi.Input[str]]:
        """
        The BIOS implementation
        """
        return pulumi.get(self, "bios")

    @bios.setter
    def bios(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bios", value)

    @property
    @pulumi.getter
    def cdrom(self) -> Optional[pulumi.Input['VirtualMachineCdromArgs']]:
        """
        The CDROM drive
        """
        return pulumi.get(self, "cdrom")

    @cdrom.setter
    def cdrom(self, value: Optional[pulumi.Input['VirtualMachineCdromArgs']]):
        pulumi.set(self, "cdrom", value)

    @property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['VirtualMachineCloneArgs']]:
        """
        The cloning configuration
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['VirtualMachineCloneArgs']]):
        pulumi.set(self, "clone", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input['VirtualMachineCpuArgs']]:
        """
        The CPU allocation
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input['VirtualMachineCpuArgs']]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]:
        """
        The disk devices
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter
    def hostpcis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]]:
        """
        The Host PCI devices mapped to the VM
        """
        return pulumi.get(self, "hostpcis")

    @hostpcis.setter
    def hostpcis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineHostpciArgs']]]]):
        pulumi.set(self, "hostpcis", value)

    @property
    @pulumi.getter
    def initialization(self) -> Optional[pulumi.Input['VirtualMachineInitializationArgs']]:
        """
        The cloud-init configuration
        """
        return pulumi.get(self, "initialization")

    @initialization.setter
    def initialization(self, value: Optional[pulumi.Input['VirtualMachineInitializationArgs']]):
        pulumi.set(self, "initialization", value)

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        The IPv4 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv4_addresses")

    @ipv4_addresses.setter
    def ipv4_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "ipv4_addresses", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        The IPv6 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keyboardLayout")
    def keyboard_layout(self) -> Optional[pulumi.Input[str]]:
        """
        The keyboard layout
        """
        return pulumi.get(self, "keyboard_layout")

    @keyboard_layout.setter
    def keyboard_layout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyboard_layout", value)

    @property
    @pulumi.getter(name="kvmArguments")
    def kvm_arguments(self) -> Optional[pulumi.Input[str]]:
        """
        The args implementation
        """
        return pulumi.get(self, "kvm_arguments")

    @kvm_arguments.setter
    def kvm_arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kvm_arguments", value)

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The MAC addresses for the network interfaces
        """
        return pulumi.get(self, "mac_addresses")

    @mac_addresses.setter
    def mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mac_addresses", value)

    @property
    @pulumi.getter
    def machine(self) -> Optional[pulumi.Input[str]]:
        """
        The VM machine type, either default i440fx or q35
        """
        return pulumi.get(self, "machine")

    @machine.setter
    def machine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input['VirtualMachineMemoryArgs']]:
        """
        The memory allocation
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input['VirtualMachineMemoryArgs']]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkDevices")
    def network_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]]:
        """
        The network devices
        """
        return pulumi.get(self, "network_devices")

    @network_devices.setter
    def network_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkDeviceArgs']]]]):
        pulumi.set(self, "network_devices", value)

    @property
    @pulumi.getter(name="networkInterfaceNames")
    def network_interface_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network interface names published by the QEMU agent
        """
        return pulumi.get(self, "network_interface_names")

    @network_interface_names.setter
    def network_interface_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_names", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="onBoot")
    def on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Start VM on Node boot
        """
        return pulumi.get(self, "on_boot")

    @on_boot.setter
    def on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_boot", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']]:
        """
        The operating system configuration
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['VirtualMachineOperatingSystemArgs']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the pool to assign the virtual machine to
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter
    def reboot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reboot vm after creation
        """
        return pulumi.get(self, "reboot")

    @reboot.setter
    def reboot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reboot", value)

    @property
    @pulumi.getter(name="serialDevices")
    def serial_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]]:
        """
        The serial devices
        """
        return pulumi.get(self, "serial_devices")

    @serial_devices.setter
    def serial_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineSerialDeviceArgs']]]]):
        pulumi.set(self, "serial_devices", value)

    @property
    @pulumi.getter
    def started(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to start the virtual machine
        """
        return pulumi.get(self, "started")

    @started.setter
    def started(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "started", value)

    @property
    @pulumi.getter(name="tabletDevice")
    def tablet_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the USB tablet device
        """
        return pulumi.get(self, "tablet_device")

    @tablet_device.setter
    def tablet_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tablet_device", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags of the virtual machine. This is only meta information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="timeoutClone")
    def timeout_clone(self) -> Optional[pulumi.Input[int]]:
        """
        Clone VM timeout
        """
        return pulumi.get(self, "timeout_clone")

    @timeout_clone.setter
    def timeout_clone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_clone", value)

    @property
    @pulumi.getter(name="timeoutMoveDisk")
    def timeout_move_disk(self) -> Optional[pulumi.Input[int]]:
        """
        MoveDisk timeout
        """
        return pulumi.get(self, "timeout_move_disk")

    @timeout_move_disk.setter
    def timeout_move_disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_move_disk", value)

    @property
    @pulumi.getter(name="timeoutReboot")
    def timeout_reboot(self) -> Optional[pulumi.Input[int]]:
        """
        Reboot timeout
        """
        return pulumi.get(self, "timeout_reboot")

    @timeout_reboot.setter
    def timeout_reboot(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_reboot", value)

    @property
    @pulumi.getter(name="timeoutShutdownVm")
    def timeout_shutdown_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Shutdown timeout
        """
        return pulumi.get(self, "timeout_shutdown_vm")

    @timeout_shutdown_vm.setter
    def timeout_shutdown_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_shutdown_vm", value)

    @property
    @pulumi.getter(name="timeoutStartVm")
    def timeout_start_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Start VM timeout
        """
        return pulumi.get(self, "timeout_start_vm")

    @timeout_start_vm.setter
    def timeout_start_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_start_vm", value)

    @property
    @pulumi.getter(name="timeoutStopVm")
    def timeout_stop_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Stop VM timeout
        """
        return pulumi.get(self, "timeout_stop_vm")

    @timeout_stop_vm.setter
    def timeout_stop_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_stop_vm", value)

    @property
    @pulumi.getter
    def vga(self) -> Optional[pulumi.Input['VirtualMachineVgaArgs']]:
        """
        The VGA configuration
        """
        return pulumi.get(self, "vga")

    @vga.setter
    def vga(self, value: Optional[pulumi.Input['VirtualMachineVgaArgs']]):
        pulumi.set(self, "vga", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VM identifier
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_id", value)


class VirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acpi: Optional[pulumi.Input[bool]] = None,
                 agent: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']]] = None,
                 audio_device: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']]] = None,
                 bios: Optional[pulumi.Input[str]] = None,
                 cdrom: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']]] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']]] = None,
                 cpu: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]]] = None,
                 hostpcis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineHostpciArgs']]]]] = None,
                 initialization: Optional[pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']]] = None,
                 keyboard_layout: Optional[pulumi.Input[str]] = None,
                 kvm_arguments: Optional[pulumi.Input[str]] = None,
                 machine: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 on_boot: Optional[pulumi.Input[bool]] = None,
                 operating_system: Optional[pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 reboot: Optional[pulumi.Input[bool]] = None,
                 serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 tablet_device: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 timeout_clone: Optional[pulumi.Input[int]] = None,
                 timeout_move_disk: Optional[pulumi.Input[int]] = None,
                 timeout_reboot: Optional[pulumi.Input[int]] = None,
                 timeout_shutdown_vm: Optional[pulumi.Input[int]] = None,
                 timeout_start_vm: Optional[pulumi.Input[int]] = None,
                 timeout_stop_vm: Optional[pulumi.Input[int]] = None,
                 vga: Optional[pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']]] = None,
                 vm_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']] agent: The QEMU agent configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']] cdrom: The CDROM drive
        :param pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]] disks: The disk devices
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineHostpciArgs']]]] hostpcis: The Host PCI devices mapped to the VM
        :param pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']] initialization: The cloud-init configuration
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[str] kvm_arguments: The args implementation
        :param pulumi.Input[str] machine: The VM machine type, either default i440fx or q35
        :param pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]] network_devices: The network devices
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] on_boot: Start VM on Node boot
        :param pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[bool] reboot: Whether to reboot vm after creation
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags of the virtual machine. This is only meta information.
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] timeout_clone: Clone VM timeout
        :param pulumi.Input[int] timeout_move_disk: MoveDisk timeout
        :param pulumi.Input[int] timeout_reboot: Reboot timeout
        :param pulumi.Input[int] timeout_shutdown_vm: Shutdown timeout
        :param pulumi.Input[int] timeout_start_vm: Start VM timeout
        :param pulumi.Input[int] timeout_stop_vm: Stop VM timeout
        :param pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acpi: Optional[pulumi.Input[bool]] = None,
                 agent: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']]] = None,
                 audio_device: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']]] = None,
                 bios: Optional[pulumi.Input[str]] = None,
                 cdrom: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']]] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']]] = None,
                 cpu: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]]] = None,
                 hostpcis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineHostpciArgs']]]]] = None,
                 initialization: Optional[pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']]] = None,
                 keyboard_layout: Optional[pulumi.Input[str]] = None,
                 kvm_arguments: Optional[pulumi.Input[str]] = None,
                 machine: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 on_boot: Optional[pulumi.Input[bool]] = None,
                 operating_system: Optional[pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 reboot: Optional[pulumi.Input[bool]] = None,
                 serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 tablet_device: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 timeout_clone: Optional[pulumi.Input[int]] = None,
                 timeout_move_disk: Optional[pulumi.Input[int]] = None,
                 timeout_reboot: Optional[pulumi.Input[int]] = None,
                 timeout_shutdown_vm: Optional[pulumi.Input[int]] = None,
                 timeout_start_vm: Optional[pulumi.Input[int]] = None,
                 timeout_stop_vm: Optional[pulumi.Input[int]] = None,
                 vga: Optional[pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']]] = None,
                 vm_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

            __props__.__dict__["acpi"] = acpi
            __props__.__dict__["agent"] = agent
            __props__.__dict__["audio_device"] = audio_device
            __props__.__dict__["bios"] = bios
            __props__.__dict__["cdrom"] = cdrom
            __props__.__dict__["clone"] = clone
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["description"] = description
            __props__.__dict__["disks"] = disks
            __props__.__dict__["hostpcis"] = hostpcis
            __props__.__dict__["initialization"] = initialization
            __props__.__dict__["keyboard_layout"] = keyboard_layout
            __props__.__dict__["kvm_arguments"] = kvm_arguments
            __props__.__dict__["machine"] = machine
            __props__.__dict__["memory"] = memory
            __props__.__dict__["name"] = name
            __props__.__dict__["network_devices"] = network_devices
            if node_name is None and not opts.urn:
                raise TypeError("Missing required property 'node_name'")
            __props__.__dict__["node_name"] = node_name
            __props__.__dict__["on_boot"] = on_boot
            __props__.__dict__["operating_system"] = operating_system
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["reboot"] = reboot
            __props__.__dict__["serial_devices"] = serial_devices
            __props__.__dict__["started"] = started
            __props__.__dict__["tablet_device"] = tablet_device
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template"] = template
            __props__.__dict__["timeout_clone"] = timeout_clone
            __props__.__dict__["timeout_move_disk"] = timeout_move_disk
            __props__.__dict__["timeout_reboot"] = timeout_reboot
            __props__.__dict__["timeout_shutdown_vm"] = timeout_shutdown_vm
            __props__.__dict__["timeout_start_vm"] = timeout_start_vm
            __props__.__dict__["timeout_stop_vm"] = timeout_stop_vm
            __props__.__dict__["vga"] = vga
            __props__.__dict__["vm_id"] = vm_id
            __props__.__dict__["ipv4_addresses"] = None
            __props__.__dict__["ipv6_addresses"] = None
            __props__.__dict__["mac_addresses"] = None
            __props__.__dict__["network_interface_names"] = None
        super(VirtualMachine, __self__).__init__(
            'proxmoxve:VM/virtualMachine:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acpi: Optional[pulumi.Input[bool]] = None,
            agent: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']]] = None,
            audio_device: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']]] = None,
            bios: Optional[pulumi.Input[str]] = None,
            cdrom: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']]] = None,
            clone: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']]] = None,
            cpu: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]]] = None,
            hostpcis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineHostpciArgs']]]]] = None,
            initialization: Optional[pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']]] = None,
            ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
            keyboard_layout: Optional[pulumi.Input[str]] = None,
            kvm_arguments: Optional[pulumi.Input[str]] = None,
            mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            machine: Optional[pulumi.Input[str]] = None,
            memory: Optional[pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]]] = None,
            network_interface_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            node_name: Optional[pulumi.Input[str]] = None,
            on_boot: Optional[pulumi.Input[bool]] = None,
            operating_system: Optional[pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            reboot: Optional[pulumi.Input[bool]] = None,
            serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]]] = None,
            started: Optional[pulumi.Input[bool]] = None,
            tablet_device: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            template: Optional[pulumi.Input[bool]] = None,
            timeout_clone: Optional[pulumi.Input[int]] = None,
            timeout_move_disk: Optional[pulumi.Input[int]] = None,
            timeout_reboot: Optional[pulumi.Input[int]] = None,
            timeout_shutdown_vm: Optional[pulumi.Input[int]] = None,
            timeout_start_vm: Optional[pulumi.Input[int]] = None,
            timeout_stop_vm: Optional[pulumi.Input[int]] = None,
            vga: Optional[pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']]] = None,
            vm_id: Optional[pulumi.Input[int]] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']] agent: The QEMU agent configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']] cdrom: The CDROM drive
        :param pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]] disks: The disk devices
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineHostpciArgs']]]] hostpcis: The Host PCI devices mapped to the VM
        :param pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']] initialization: The cloud-init configuration
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv4_addresses: The IPv4 addresses published by the QEMU agent
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv6_addresses: The IPv6 addresses published by the QEMU agent
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[str] kvm_arguments: The args implementation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_addresses: The MAC addresses for the network interfaces
        :param pulumi.Input[str] machine: The VM machine type, either default i440fx or q35
        :param pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]] network_devices: The network devices
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_names: The network interface names published by the QEMU agent
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[bool] on_boot: Start VM on Node boot
        :param pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[bool] reboot: Whether to reboot vm after creation
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags of the virtual machine. This is only meta information.
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[int] timeout_clone: Clone VM timeout
        :param pulumi.Input[int] timeout_move_disk: MoveDisk timeout
        :param pulumi.Input[int] timeout_reboot: Reboot timeout
        :param pulumi.Input[int] timeout_shutdown_vm: Shutdown timeout
        :param pulumi.Input[int] timeout_start_vm: Start VM timeout
        :param pulumi.Input[int] timeout_stop_vm: Stop VM timeout
        :param pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineState.__new__(_VirtualMachineState)

        __props__.__dict__["acpi"] = acpi
        __props__.__dict__["agent"] = agent
        __props__.__dict__["audio_device"] = audio_device
        __props__.__dict__["bios"] = bios
        __props__.__dict__["cdrom"] = cdrom
        __props__.__dict__["clone"] = clone
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["description"] = description
        __props__.__dict__["disks"] = disks
        __props__.__dict__["hostpcis"] = hostpcis
        __props__.__dict__["initialization"] = initialization
        __props__.__dict__["ipv4_addresses"] = ipv4_addresses
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["keyboard_layout"] = keyboard_layout
        __props__.__dict__["kvm_arguments"] = kvm_arguments
        __props__.__dict__["mac_addresses"] = mac_addresses
        __props__.__dict__["machine"] = machine
        __props__.__dict__["memory"] = memory
        __props__.__dict__["name"] = name
        __props__.__dict__["network_devices"] = network_devices
        __props__.__dict__["network_interface_names"] = network_interface_names
        __props__.__dict__["node_name"] = node_name
        __props__.__dict__["on_boot"] = on_boot
        __props__.__dict__["operating_system"] = operating_system
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["reboot"] = reboot
        __props__.__dict__["serial_devices"] = serial_devices
        __props__.__dict__["started"] = started
        __props__.__dict__["tablet_device"] = tablet_device
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template"] = template
        __props__.__dict__["timeout_clone"] = timeout_clone
        __props__.__dict__["timeout_move_disk"] = timeout_move_disk
        __props__.__dict__["timeout_reboot"] = timeout_reboot
        __props__.__dict__["timeout_shutdown_vm"] = timeout_shutdown_vm
        __props__.__dict__["timeout_start_vm"] = timeout_start_vm
        __props__.__dict__["timeout_stop_vm"] = timeout_stop_vm
        __props__.__dict__["vga"] = vga
        __props__.__dict__["vm_id"] = vm_id
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acpi(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable ACPI
        """
        return pulumi.get(self, "acpi")

    @property
    @pulumi.getter
    def agent(self) -> pulumi.Output[Optional['outputs.VirtualMachineAgent']]:
        """
        The QEMU agent configuration
        """
        return pulumi.get(self, "agent")

    @property
    @pulumi.getter(name="audioDevice")
    def audio_device(self) -> pulumi.Output[Optional['outputs.VirtualMachineAudioDevice']]:
        """
        The audio devices
        """
        return pulumi.get(self, "audio_device")

    @property
    @pulumi.getter
    def bios(self) -> pulumi.Output[Optional[str]]:
        """
        The BIOS implementation
        """
        return pulumi.get(self, "bios")

    @property
    @pulumi.getter
    def cdrom(self) -> pulumi.Output[Optional['outputs.VirtualMachineCdrom']]:
        """
        The CDROM drive
        """
        return pulumi.get(self, "cdrom")

    @property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.VirtualMachineClone']]:
        """
        The cloning configuration
        """
        return pulumi.get(self, "clone")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional['outputs.VirtualMachineCpu']]:
        """
        The CPU allocation
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineDisk']]]:
        """
        The disk devices
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def hostpcis(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineHostpci']]]:
        """
        The Host PCI devices mapped to the VM
        """
        return pulumi.get(self, "hostpcis")

    @property
    @pulumi.getter
    def initialization(self) -> pulumi.Output[Optional['outputs.VirtualMachineInitialization']]:
        """
        The cloud-init configuration
        """
        return pulumi.get(self, "initialization")

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        The IPv4 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv4_addresses")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        The IPv6 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="keyboardLayout")
    def keyboard_layout(self) -> pulumi.Output[Optional[str]]:
        """
        The keyboard layout
        """
        return pulumi.get(self, "keyboard_layout")

    @property
    @pulumi.getter(name="kvmArguments")
    def kvm_arguments(self) -> pulumi.Output[Optional[str]]:
        """
        The args implementation
        """
        return pulumi.get(self, "kvm_arguments")

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The MAC addresses for the network interfaces
        """
        return pulumi.get(self, "mac_addresses")

    @property
    @pulumi.getter
    def machine(self) -> pulumi.Output[Optional[str]]:
        """
        The VM machine type, either default i440fx or q35
        """
        return pulumi.get(self, "machine")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional['outputs.VirtualMachineMemory']]:
        """
        The memory allocation
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDevices")
    def network_devices(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineNetworkDevice']]]:
        """
        The network devices
        """
        return pulumi.get(self, "network_devices")

    @property
    @pulumi.getter(name="networkInterfaceNames")
    def network_interface_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The network interface names published by the QEMU agent
        """
        return pulumi.get(self, "network_interface_names")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Output[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="onBoot")
    def on_boot(self) -> pulumi.Output[Optional[bool]]:
        """
        Start VM on Node boot
        """
        return pulumi.get(self, "on_boot")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[Optional['outputs.VirtualMachineOperatingSystem']]:
        """
        The operating system configuration
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the pool to assign the virtual machine to
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def reboot(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to reboot vm after creation
        """
        return pulumi.get(self, "reboot")

    @property
    @pulumi.getter(name="serialDevices")
    def serial_devices(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineSerialDevice']]]:
        """
        The serial devices
        """
        return pulumi.get(self, "serial_devices")

    @property
    @pulumi.getter
    def started(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to start the virtual machine
        """
        return pulumi.get(self, "started")

    @property
    @pulumi.getter(name="tabletDevice")
    def tablet_device(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the USB tablet device
        """
        return pulumi.get(self, "tablet_device")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags of the virtual machine. This is only meta information.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timeoutClone")
    def timeout_clone(self) -> pulumi.Output[Optional[int]]:
        """
        Clone VM timeout
        """
        return pulumi.get(self, "timeout_clone")

    @property
    @pulumi.getter(name="timeoutMoveDisk")
    def timeout_move_disk(self) -> pulumi.Output[Optional[int]]:
        """
        MoveDisk timeout
        """
        return pulumi.get(self, "timeout_move_disk")

    @property
    @pulumi.getter(name="timeoutReboot")
    def timeout_reboot(self) -> pulumi.Output[Optional[int]]:
        """
        Reboot timeout
        """
        return pulumi.get(self, "timeout_reboot")

    @property
    @pulumi.getter(name="timeoutShutdownVm")
    def timeout_shutdown_vm(self) -> pulumi.Output[Optional[int]]:
        """
        Shutdown timeout
        """
        return pulumi.get(self, "timeout_shutdown_vm")

    @property
    @pulumi.getter(name="timeoutStartVm")
    def timeout_start_vm(self) -> pulumi.Output[Optional[int]]:
        """
        Start VM timeout
        """
        return pulumi.get(self, "timeout_start_vm")

    @property
    @pulumi.getter(name="timeoutStopVm")
    def timeout_stop_vm(self) -> pulumi.Output[Optional[int]]:
        """
        Stop VM timeout
        """
        return pulumi.get(self, "timeout_stop_vm")

    @property
    @pulumi.getter
    def vga(self) -> pulumi.Output[Optional['outputs.VirtualMachineVga']]:
        """
        The VGA configuration
        """
        return pulumi.get(self, "vga")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> pulumi.Output[Optional[int]]:
        """
        The VM identifier
        """
        return pulumi.get(self, "vm_id")

