
--------- ReadMe:

1. About ----

* Python Runtime and Package Installation
First of it, it is assumed that python3 and pip3 are installed. And
cvdast package is installed by pip3. The python3 command can sometimes
just be "python" if your default python installation is version 3 or above.
Please run "python --version" to find out. If you are running python 3 or above
by default, please simply substitute the "python3" commands in examples provided
in the remainder of this document.

To ensure cvdast is up-to-date, please run:
   pip3 install -U cvdast

* Test Directory
This self-contained package, when decompressed/unzipped, should be the
test directory from which you can generate fuzz data based on the specs
and then run. Please feel free to rename the test directory. The
subdirectory structure is important for the test run. All files generated
will be put under the test directory.

* Config: 
There will be information such as the URL of your test application (API endpoint),
the list of the fuzz attacks to try etc. The runconfig.py file contains
all of the custom variables one needs to change. Current values are provided
as examples. 

After a complete runall.py run(details in sections below), the summary.html
file will contain pointers to all the test results. In addition, a file called
fordev-apis.csv is generated. This is a highlevel summary for consumption of a
dev team. It highlight just the API endpoints that seem to "fail" the test, ie.
responding positively instead of rejecting the fuzz calls. Please feel free to
import such CSV report to a spreadsheet. 

The test results are stored in
    results
    results/perapi
    results/perattack

Test can run for a long time, so one can adjust the spec and the
collection of attacks in runall.py to stage each run. Test results
of different test will not over-write each other. You can regenerate
test report after the test run.

auth.py must be in this directory
cv_config_oc.yaml is hardcoded in fuzzallspecs. Must be present

2. Generate fuzzing test for all the specs ----

With a given cvdast version and a set of specs, you need to only run
this once.

python3 fuzzallspecs.py 

will fuzz all specs, run it with "--help" will let you know an optional input
which is the spec directory, default is "specs".

A successfully run fuzzallspecs will generate as output a list of spec
title names (taken from the spec's title) that can be used to update runall.py
list for test control (later 4. Control test)

A specs directory containing all .json app spec is used to store the
specs for testing. 

3. Running Tests -----------

One can run this script: 

 python3 runall.py

After fuzzallspecs.py, it will run both runperattack and runperapi to generate
two sets of results. It takes a "regen" argument. Regen will tells it not to
run the long test, but just run the cloudVectorDAST.generate_fuzz_report to
again generate the report (it copies the saved report.json from results
directory)

It creates a summary.html in the test. It contains tables allowing convenient
access to all the reports

Results are saved in a directory called results

  results
    results/perapi
    results/perattack

After the runall call, you can find subdirectories with the Spec names under
each of these results directories.
There are .html files that are the report html pointed to by the summary.

Under the perapi directory there are files that are named after the API
name (chopped from the test directory long "for_fuzzing.py" name). The
report.json of the test run is saved with <apiname>-report.json

Same naming convention goes for perattack reports.


python3 runperapi.py
python3 runperattack.py

Can be run seperately to test. They will update the test results but they won't
update summary.html. 


4 Controlling Spec and Attack for testing -------

In runall.py, there are two lists
(and two corresponding full list for reference).

The test can take multiple hours, or even a day if the full list is used.


apispeclist=["CpmGateway",
          "TelemetryGateway"]

fuzzattacklist = ['sql-injection/detect']

fuzzattacklist = ['control-chars', 'string-expansion', 'server-side-include',
                  'xpath', 'unicode', 'html_js_fuzz', 'disclosure-directory',
                  'xss', 'os-cmd-execution', 'disclosure-source',
                  'format-strings', 'xml', 'integer-overflow',
                  'path-traversal', 'json', 'mimetypes', 'redirect',
                  'os-dir-indexing', 'no-sql-injection', 'authentication',
                  'http-protocol', 'business-logic',
                  'disclosure-localpaths/unix',
                  'file-upload/malicious-images',
                  'sql-injection/detect',
                  'sql-injection/exploit',
                  'sql-injection/payloads-sql-blind']
'''
