(function(){suite("djblets/gravy/backboneUtils",function(){var model;beforeEach(function(){model=new Backbone.Model});describe("$.fn.bindClass",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});describe("Initial class value",function(){it("Adds class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(true)});it("No class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(false)});describe("With inverse",function(){it("No class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(true)})})});describe("Model property changes",function(){it("Removes class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");model.set("mybool",false);expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");model.set("mybool",true);expect($el.hasClass("myclass")).toBe(true)});describe("With inverse",function(){it("Adds class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",false);expect($el.hasClass("myclass")).toBe(true)});it("Removes class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",true);expect($el.hasClass("myclass")).toBe(false)})})})});describe("$.fn.bindProperty",function(){var $el,$radio1,$radio2;beforeEach(function(){$el=$("<input type='checkbox'/>").appendTo(document.body);$radio1=$('<input type="radio" name="my-radio" value="one" />').appendTo(document.body);$radio2=$('<input type="radio" name="my-radio" value="two" />').appendTo(document.body)});afterEach(function(){$el.remove();$radio1.remove();$radio2.remove()});describe("Initial property values",function(){it("Setting element's property from model property's",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(true)});it("Setting element's property from model property's with "+"inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting element's property from model property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);expect(model.get("myvalue")).toBe("one")});it("No element changes with modelToElement=false",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool",{modelToElement:false});expect($el.prop("checked")).toBe(false)})});describe("Model property changes",function(){it("Setting element's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(false);model.set("mybool",true);expect($el.prop("checked")).toBe(true)});it("Setting element's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);model.set("mybool",true);expect($el.prop("checked")).toBe(false);expect(model.get("mybool")).toBe(true)});it("Setting element's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);model.set("myvalue","two");expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No element changes with modelToElement=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{modelToElement:false});model.set("mybool",true);expect($el.prop("checked")).toBe(false)})});describe("Element property changes",function(){it("Setting model's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(true)});it("Setting model's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});$el.prop("checked",false);$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting model's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});$radio2.click();expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No model changes with elementToModel=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{elementToModel:false});$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)})});describe("Special properties",function(){it("text",function(){var $el=$("<p/>");$el.bindProperty("text",model,"text",{elementToModel:false});model.set("text","hello world!");expect($el.text()).toBe("hello world!")});it("html",function(){var $el=$("<p/>");$el.bindProperty("html",model,"html",{elementToModel:false});model.set("html","<b>hello world!</b>");expect($el.html()).toBe("<b>hello world!</b>")})})});describe("$.fn.bindVisibility",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});afterEach(function(){$el.remove()});describe("Showing elements",function(){it("When property is initially true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(true)});it("When property is initially false with inverse=true",function(){$el.hide();model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(true)});it("When property is changed to true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");model.set("mybool",true);expect($el.is(":visible")).toBe(true)});it("When property is changed to false with inverse=true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",false);expect($el.is(":visible")).toBe(true)})});describe("Hiding elements",function(){it("When property is initially false",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(false)});it("When property is initially true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(false)});it("When property is changed to false",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");model.set("mybool",false);expect($el.is(":visible")).toBe(false)});it("When property is changed to true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",true);expect($el.is(":visible")).toBe(false)})})})});"use strict";suite("djblets/configForms/models/ListItem",function(){describe("Default actions",function(){describe("showRemove",function(){it("true",function(){var listItem=new Djblets.Config.ListItem({showRemove:true});expect(listItem.actions.length).toBe(1);expect(listItem.actions[0].id).toBe("delete")});it("false",function(){var listItem=new Djblets.Config.ListItem({showRemove:false});expect(listItem.actions.length).toBe(0)})})})});"use strict";suite("djblets/configForms/views/ListItemView",function(){describe("Rendering",function(){describe("General item display",function(){it("With editURL",function(){var item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n",'<a href="http://example.com/">Label</a>'].join(""))});it("Without editURL",function(){var item=new Djblets.Config.ListItem({text:"Label"});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n","Label"].join(""))})});describe("Item states",function(){var CustomItemView=Djblets.Config.ListItemView.extend({template:_.template('<div><%- text %></div>\n<div class="djblets-c-config-forms-list__item-state">\n</div>')});it("Initial render",function(){var item=new Djblets.Config.ListItem({itemState:"enabled"});var itemView=new CustomItemView({model:item});itemView.render();expect(itemView.el).toHaveClass("-is-enabled");var $stateText=itemView.$(".djblets-c-config-forms-list__item-state");expect($stateText.text()).toBe("Enabled")});it("When changed",function(){var item=new Djblets.Config.ListItem({itemState:"enabled"});var itemView=new CustomItemView({model:item});itemView.render();item.set("itemState","disabled");expect(itemView.el).toHaveClass("-is-disabled");expect(itemView.el).not.toHaveClass("-is-enabled");var $stateText=itemView.$(".djblets-c-config-forms-list__item-state");expect($stateText.text()).toBe("Disabled")})});describe("Actions",function(){it("Checkboxes",function(){var item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$("input[type=checkbox]").length).toBe(1);expect(itemView.$("label").length).toBe(1)});describe("Buttons",function(){it("Simple",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);var buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).not.toHaveClass("-is-primary")});it("Danger",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:true}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);var buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-primary");expect(buttonEl).toHaveClass("-is-danger")});it("Primary",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",primary:true}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);var buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).toHaveClass("-is-primary")});it("Icon names",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:false,iconName:"foo"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);var buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).not.toHaveClass("-is-primary");var $span=$button.find("span");expect($span.length).toBe(1);expect($span.hasClass("djblets-icon")).toBe(true);expect($span.hasClass("djblets-icon-foo")).toBe(true)})});describe("Menus",function(){var item;var itemView;beforeEach(function(){item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mymenu",label:"Menu",children:[{id:"mymenuitem",label:"My menu item"}]}]});itemView=new Djblets.Config.ListItemView({model:item});itemView.render()});it("Initial display",function(){var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Menu ▾")});it("Opening",function(){spyOn(_,"defer").and.callFake(function(cb){cb()});spyOn(itemView,"trigger");var $action=itemView.$(".config-forms-list-action-mymenu");$action.click();var $menu=itemView.$(".djblets-c-config-forms-popup-menu");expect($menu.length).toBe(1);expect(itemView.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopUp")});it("Closing",function(){spyOn(_,"defer").and.callFake(function(cb){return cb()});var $action=itemView.$(".config-forms-list-action-mymenu");$action.click();spyOn(itemView,"trigger");$(document.body).click();expect(itemView.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopDown");var $menu=itemView.$(".action-menu");expect($menu.length).toBe(0)})})});describe("Action properties",function(){describe("enabledPropName",function(){it("value == undefined",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == true",function(){var item=new Djblets.Config.ListItem({text:"Label",isEnabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == false",function(){var item=new Djblets.Config.ListItem({text:"Label",isEnabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});describe("with enabledPropInverse == true",function(){it("value == undefined",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == true",function(){var item=new Djblets.Config.ListItem({text:"Label",isDisabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.render();var $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == false",function(){var item=new Djblets.Config.ListItem({text:"Label",isDisabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)})})})})});describe("Action handlers",function(){it("Buttons",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=function(){};spyOn(itemView,"_onMyButtonClick");itemView.render();var $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);$button.click();expect(itemView._onMyButtonClick).toHaveBeenCalled()});it("Checkboxes",function(){var item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]});var itemView=new Djblets.Config.ListItemView({model:item});itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=function(){};spyOn(itemView,"_onMyButtonClick");itemView.render();var $checkbox=itemView.$("input[type=checkbox]");expect($checkbox.length).toBe(1);expect($checkbox.prop("checked")).toBe(false);$checkbox.prop("checked",true).triggerHandler("change");expect(item.get("checkboxAttr")).toBe(true)})})});"use strict";suite("djblets/configForms/views/ListView",function(){describe("Manages items",function(){var collection;var list;var listView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});listView=new Djblets.Config.ListView({model:list});listView.render()});it("On render",function(){var $items=listView.$("li");expect($items.length).toBe(3);expect($items.eq(0).text().strip()).toBe("Item 1");expect($items.eq(1).text().strip()).toBe("Item 2");expect($items.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){collection.add({text:"Item 4"});var $items=listView.$("li");expect($items.length).toBe(4);expect($items.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){collection.remove(collection.at(0));var $items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){collection.reset([{text:"Foo"},{text:"Bar"}]);var $items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Foo");expect($items.eq(1).text().strip()).toBe("Bar")})})});"use strict";suite("djblets/configForms/views/TableItemView",function(){describe("Rendering",function(){describe("Item display",function(){it("With editURL",function(){var item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"});var itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n",'<a href="http://example.com/">Label</a>\n\n',"</td>"].join(""))});it("Without editURL",function(){var item=new Djblets.Config.ListItem({text:"Label"});var itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n","Label\n\n","</td>"].join(""))})});describe("Action placement",function(){it("Default template",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});var itemView=new Djblets.Config.TableItemView({model:item});itemView.render();var $button=itemView.$("td:last button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Button")});it("Custom template",function(){var CustomTableItemView=Djblets.Config.TableItemView.extend({template:_.template("<td></td>\n<td></td>")});var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});var itemView=new CustomTableItemView({model:item});itemView.render();var $button=itemView.$("td:last button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Button")})})})});"use strict";suite("djblets/configForms/views/TableView",function(){describe("Manages rows",function(){var collection;var list;var tableView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});tableView=new Djblets.Config.TableView({model:list});tableView.render()});it("On render",function(){var $rows=tableView.$("tr");expect($rows.length).toBe(3);expect($rows.eq(0).text().strip()).toBe("Item 1");expect($rows.eq(1).text().strip()).toBe("Item 2");expect($rows.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){collection.add({text:"Item 4"});var $rows=tableView.$("tr");expect($rows.length).toBe(4);expect($rows.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){collection.remove(collection.at(0));var $rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){collection.reset([{text:"Foo"},{text:"Bar"}]);var $rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Foo");expect($rows.eq(1).text().strip()).toBe("Bar")})})});"use strict";suite("djblets/forms/models/ConditionChoice",function(){describe("Initialization",function(){it("With parse and data",function(){var choice=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}},operators:[{id:"my-op",name:"My Op",useValue:false}]},{parse:true});expect(choice.id).toBe("my-choice");expect(choice.get("name")).toBe("My Choice");expect(choice.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}});expect(choice.operators.length).toBe(1);var op=choice.operators.at(0);expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Op");expect(op.get("useValue")).toBe(false)})});describe("Methods",function(){it("createValueField",function(){var choice=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}});var valueField=choice.createValueField("my-field");expect(valueField.model.get("fieldName")).toBe("my-field")})})});"use strict";suite("djblets/forms/models/Condition",function(){describe("Events",function(){describe("choice changes",function(){var choice1,choice2,condition;beforeEach(function(){choice1=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"});choice1.operators.add({id:"my-op-1",name:"My Op 1"});choice2=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"});choice2.operators.add([{id:"my-op-2",name:"My Op 2"},{id:"my-op-3",name:"My Op 3"}]);condition=new Djblets.Forms.Condition({choice:choice1,operator:choice1.operators.first(),value:"abc123"});condition.set("choice",choice2)});it("Operator resets to first",function(){expect(condition.get("operator")).toBe(choice2.operators.first())});it("Value resets",function(){expect(condition.get("value")).toBe(undefined)})})})});"use strict";suite("djblets/forms/models/ConditionOperator",function(){describe("Initialization",function(){it("With parse and data",function(){var op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:true,valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}}},{parse:true});expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Operator");expect(op.get("useValue")).toBe(true);expect(op.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}})});it("With parse and data, but no valueField",function(){var op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:true},{parse:true});expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Operator");expect(op.get("valueField")).toBe(null);expect(op.get("useValue")).toBe(true)})});describe("createValueField",function(){it("With custom valueField",function(){var op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}});var valueField=op.createValueField("my-field");expect(valueField.model.get("fieldName")).toBe("my-field")});it("Without custom valueField",function(){var op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator"});expect(function(){return op.createValueField("my-field")}).toThrowError("This operator does not have a custom valueField.")})})});"use strict";suite("djblets/forms/models/ConditionSet",function(){describe("Initialization",function(){it("choicesData parsed",function(){var conditionSet=new Djblets.Forms.ConditionSet({fieldName:"my-conditions",choicesData:[{id:"my-choice",name:"My Choice"}]});expect(conditionSet.choices.length).toBe(1);expect(conditionSet.choices.at(0).id).toBe("my-choice");expect(conditionSet.get("lastID")).toBe(null)});it("conditionsData parsed",function(){var conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"my-choice",operatorID:"my-op-1",value:"abc123",valid:false,error:"My error"},{choiceID:"my-choice",operatorID:"my-op-2",value:42,valid:true}]});var conditions=conditionSet.conditions;expect(conditions.length).toBe(2);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op-1");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");condition=conditions.at(1);expect(condition.id).toBe(1);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op-2");expect(condition.get("value")).toBe(42);expect(condition.get("valid")).toBe(true);expect(condition.get("error")).toBe(null);expect(conditionSet.get("lastID")).toBe(1)});it("conditionsData parsed with bad choiceID",function(){var conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"invalid-choice",operatorID:"my-op-1",value:"abc123",valid:false,error:"My error"}]});var conditions=conditionSet.conditions;expect(conditions.length).toBe(1);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice")).toBe(null);expect(condition.get("operator")).toBe(null);expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)})});describe("Adding to conditions collection",function(){var conditionSet;beforeEach(function(){conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}]});expect(conditionSet.get("lastID")).toBe(null)});it("Using choice and operator IDs",function(){conditionSet.conditions.add({choiceID:"my-choice",operatorID:"my-op",value:"abc123",valid:false,error:"My error"});var conditions=conditionSet.conditions;expect(conditions.length).toBe(1);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)});it("Using choice instance",function(){conditionSet.conditions.add({choiceID:conditionSet.choices.at(0),operatorID:"my-op",value:"abc123",valid:false,error:"My error"});var conditions=conditionSet.conditions;expect(conditions.length).toBe(1);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)});it("Using operator instance",function(){conditionSet.conditions.add({choiceID:"my-choice",operatorID:conditionSet.choices.at(0).operators.at(0),value:"abc123",valid:false,error:"My error"});var conditions=conditionSet.conditions;expect(conditions.length).toBe(1);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)})});describe("Methods",function(){it("addNewCondition",function(){var conditionSet=new Djblets.Forms.ConditionSet({fieldName:"my-conditions",choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}]});var conditions=conditionSet.conditions;expect(conditions.length).toBe(0);expect(conditionSet.get("lastID")).toBe(null);conditionSet.addNewCondition();expect(conditions.length).toBe(1);expect(conditionSet.get("lastID")).toBe(0);var condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op")})})});"use strict";suite("djblets/forms/views/ConditionValueFormFieldView",function(){function makeValueField(html){return{model:{className:"Djblets.Forms.ConditionValueField",data:{fieldHTML:html}},view:{className:"Djblets.Forms.ConditionValueFormFieldView"}}}function setupConditionSetView(conditionsData){var conditionsTemplate=_.template(['<div class="conditions-field">\n',' <input type="hidden" name="my_conditions_last_id" />\n',' <div class="conditions-field-mode"></div>\n',' <div class="conditions-field-rows-container">\n','  <ul class="conditions-field-rows"></ul>\n','  <a href="#" class="conditions-field-add-condition"></a>\n'," </div>\n","</div>"].join(""));var conditionSetView=new Djblets.Forms.ConditionSetView({el:$(conditionsTemplate()),model:new Djblets.Forms.ConditionSet({fieldName:"my_conditions",choicesData:[{id:"my-choice-1",name:"My Choice 1",valueField:makeValueField('<input type="text" />'),operators:[{id:"my-op-1",name:"My Op 1",useValue:true},{id:"my-op-2",name:"My Op 2",useValue:true,valueField:makeValueField('<input type="number" />')}]},{id:"my-choice-2",name:"My Choice 2",valueField:makeValueField('<input type="email" />'),operators:[{id:"my-op-3",name:"My Op 3",useValue:true},{id:"my-op-4",name:"My Op 4",useValue:true}]}],conditionsData:conditionsData},{parse:true})});conditionSetView.render();return conditionSetView}describe("Rendering",function(){it("Loaded rows",function(){var conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true},{choiceID:"my-choice-2",operatorID:"my-op-4",value:42,valid:true}]);var $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(2);var $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("1");var $row=$rows.eq(0);var $choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-1");var $operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-1");var $value=$row.find(".conditions-field-value");var $input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("text");expect($input.attr("name")).toBe("my_conditions_value[0]");expect($input.val()).toBe("<test>");$row=$rows.eq(1);$choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[1]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-2");$operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[1]">','<option value="my-op-3">My Op 3</option>','<option value="my-op-4">My Op 4</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-4");$value=$row.find(".conditions-field-value");$input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("email");expect($input.attr("name")).toBe("my_conditions_value[1]");expect($input.val()).toBe("42")});it("Loaded rows with errors",function(){var conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",error:"This is an <error>.",valid:true}]);var $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(1);var $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("0");var $row=$rows.eq(0);var $error=$row.find(".error-list li");expect($error.length).toBe(1);expect($error.html()).toBe("This is an &lt;error&gt;.")})});describe("Actions",function(){it("Add a new condition",function(){var conditionSetView=setupConditionSetView();var $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(0);var $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("");spyOn(conditionSetView.model,"addNewCondition").and.callThrough();conditionSetView.$(".conditions-field-add-condition").click();expect(conditionSetView.model.addNewCondition).toHaveBeenCalled();$rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(1);expect($lastID.val()).toBe("0");var $row=$rows.eq(0);var $choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-1");var $operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-1");var $value=$row.find(".conditions-field-value");var $input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("text");expect($input.attr("name")).toBe("my_conditions_value[0]");expect($input.val()).toBe("")});it("Delete a condition",function(){var conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);var $rows=conditionSetView.$(".conditions-field-row");expect(conditionSetView.model.conditions.length).toBe(1);expect($rows.length).toBe(1);var $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("0");var condition=conditionSetView.model.conditions.at(0);spyOn(condition,"destroy").and.callThrough();$rows.eq(0).find(".conditions-field-row-delete").click();expect(condition.destroy).toHaveBeenCalled();$rows=conditionSetView.$(".conditions-field-row");expect(conditionSetView.model.conditions.length).toBe(0);expect($rows.length).toBe(0);expect($lastID.val()).toBe("0")});it("Changing a choice updates model",function(){var conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);var $rows=conditionSetView.$(".conditions-field-row");var condition=conditionSetView.model.conditions.at(0);$rows.eq(0).find(".conditions-field-choice select").val("my-choice-2").trigger("change");expect(condition.get("choice").id).toBe("my-choice-2")});it("Changing an operator updates model",function(){var conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);var $rows=conditionSetView.$(".conditions-field-row");var condition=conditionSetView.model.conditions.at(0);$rows.eq(0).find(".conditions-field-operator select").val("my-op-2").trigger("change");expect(condition.get("operator").id).toBe("my-op-2")})});describe("Model events",function(){var conditionSetView,conditionSet,condition,$row,$choice,$operator,$valueWrapper;beforeEach(function(){conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);conditionSet=conditionSetView.model;condition=conditionSet.conditions.at(0);$row=conditionSetView.$(".conditions-field-row").eq(0);$choice=$row.find(".conditions-field-choice select");$operator=$row.find(".conditions-field-operator select");$valueWrapper=$row.find(".conditions-field-value");var $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("text");expect($input.val()).toBe("<test>")});describe("Choice changed",function(){it("Updates UI state",function(){condition.set("choice",conditionSet.choices.get("my-choice-2"));expect($choice.val()).toBe("my-choice-2");expect($operator.val()).toBe("my-op-3");var $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("email");expect($input.val()).toBe("")})});describe("Operator changed",function(){it("Updates UI state",function(){var choice=conditionSet.choices.get("my-choice-1");condition.set("operator",choice.operators.get("my-op-2"));expect($choice.val()).toBe("my-choice-1");expect($operator.val()).toBe("my-op-2");var $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("number");expect($input.val()).toBe("")});it("Retains value if valueField remains",function(){var choice=conditionSet.choices.get("my-choice-2");condition.set("choice",choice);$valueWrapper.find("input").val("42");expect($operator.val()).toBe("my-op-3");condition.set("operator",choice.operators.get("my-op-4"));expect($valueWrapper.find("input").val()).toBe("42")})});describe("Value changed",function(){it("Updated UI state",function(){condition.set("value","new-value");expect($valueWrapper.find("input").val()).toBe("new-value")})})})});"use strict";suite("djblets/forms/views/ConditionValueFormFieldView",function(){function createValueField(html){var view=new Djblets.Forms.ConditionValueFormFieldView({model:new Djblets.Forms.ConditionValueField({fieldName:"my-field",fieldHTML:html})});view.render();return view}it("Rendering",function(){var view=createValueField('<input type="text" />');expect(view.$input[0].tagName).toBe("INPUT");expect(view.$input.attr("type")).toBe("text");expect(view.$input.attr("name")).toBe("my-field")});describe("Methods",function(){describe("getValue",function(){it("<input>",function(){var view=createValueField('<input type="text" value="abc123" />');expect(view.getValue()).toBe("abc123")});it("<select>",function(){var view=createValueField(["<select>",'<option value="1">One</option>','<option value="2" selected="selected">Two</option>',"</select>"].join(""));expect(view.getValue()).toBe("2")});it("<textarea>",function(){var view=createValueField("<textarea></textarea>");view.setValue("abc123");expect(view.$input.val()).toBe("abc123")})});describe("setValue",function(){it("<input>",function(){var view=createValueField('<input type="text" />');view.setValue("abc123");expect(view.$input.val()).toBe("abc123")});it("<select>",function(){var view=createValueField(["<select>",'<option value="1">One</option>','<option value="2">Two</option>',"</select>"].join(""));view.setValue("2");expect(view.$input.val()).toBe("2")});it("<textarea>",function(){var view=createValueField("<textarea></textarea>");view.setValue("abc123");expect(view.$input.val()).toBe("abc123")})})})});"use strict";function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest()}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++){arr2[i]=arr[i]}return arr2}function _iterableToArrayLimit(arr,i){var _i=arr==null?null:typeof Symbol!=="undefined"&&arr[Symbol.iterator]||arr["@@iterator"];if(_i==null)return;var _arr=[];var _n=true;var _d=false;var _s,_e;try{for(_i=_i.call(arr);!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"]!=null)_i["return"]()}finally{if(_d)throw _e}}return _arr}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr}suite("djblets/forms/views/ListEditView",function(){var formTemplate=_.template('<div class="djblets-c-list-edit-widget">\n <ul class="djblets-c-list-edit-widget__entries">\n  <% if (items.length > 0) { %>\n   <% items.forEach(function(item, i) { %>\n    <li class="djblets-c-list-edit-widget__entry"\n        data-list-index="<%- i %>">\n     <input value="<%- item %>" type="text"<%= attrs %>>\n     <a href="#" class="djblets-c-list-edit-widget__remove-item"></a>\n    </li>\n   <% }); %>\n  <% } else { %>\n   <li class="djblets-c-list-edit-widget__entry" data-list-index="0">\n    <input type="text">\n    <a href="#" class="djblets-c-list-edit-widget__remove-item"></a>\n   </li>\n  <% } %>\n </ul>\n <button class="djblets-c-list-edit-widget__add-item"></button>\n <input class="djblets-c-list-edit-widget__value"\n        type="hidden" value="<%- nonZeroItems.join(\',\') %>">\n</div>');var makeView=function makeView(){var items=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];var attrs=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"";attrs=attrs.length?" ".concat(attrs):"";attrs="".concat(attrs,' class="djblets-c-list-edit-widget__input"');var $el=$(formTemplate({items:items,nonZeroItems:items.filter(function(i){return i.length>0}),attrs:attrs})).appendTo($testsScratch);var view=new Djblets.Forms.ListEditView({el:$el,inputAttrs:attrs,sep:","});view.render();return[view,view.$(".djblets-c-list-edit-widget__value")]};describe("Updating fields",function(){it("With no values",function(){var _makeView=makeView([]),_makeView2=_slicedToArray(_makeView,2),$valueField=_makeView2[1];expect($valueField.val()).toEqual("")});it("With one value",function(){var _makeView3=makeView(["One"]),_makeView4=_slicedToArray(_makeView3,2),view=_makeView4[0],$valueField=_makeView4[1];expect($valueField.val()).toEqual("One");view.$(".djblets-c-list-edit-widget__input").val("Foo").blur();expect($valueField.val()).toEqual("Foo")});it("With multiple values",function(){var _makeView5=makeView(["one","two","three"]),_makeView6=_slicedToArray(_makeView5,2),view=_makeView6[0],$valueField=_makeView6[1];var $inputs=view.$(".djblets-c-list-edit-widget__input");expect($valueField.val()).toEqual("one,two,three");$inputs.eq(2).val("baz").blur();expect($valueField.val()).toEqual("one,two,baz");$inputs.eq(0).val("").blur();expect($valueField.val()).toEqual("two,baz");$inputs.eq(1).val("").blur();expect($valueField.val()).toEqual("baz");$inputs.eq(2).val("").blur();expect($valueField.val()).toEqual("")})});describe("Removal",function(){it("With no values",function(){var _makeView7=makeView([]),_makeView8=_slicedToArray(_makeView7,2),view=_makeView8[0],$valueField=_makeView8[1];expect($valueField.val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);view.$(".djblets-c-list-edit-widget__remove-item").click();expect($valueField.val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1)});it("With one value",function(){var _makeView9=makeView(["One"]),_makeView10=_slicedToArray(_makeView9,2),view=_makeView10[0],$valueField=_makeView10[1];expect($valueField.val()).toEqual("One");view.$(".djblets-c-list-edit-widget__remove-item").click();expect($valueField.val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1)});it("With multiple values",function(){var _makeView11=makeView(["One","Two","Three"]),_makeView12=_slicedToArray(_makeView11,2),view=_makeView12[0],$valueField=_makeView12[1];expect($valueField.val()).toEqual("One,Two,Three");expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(3);view.$(".djblets-c-list-edit-widget__remove-item").eq(1).click();expect($valueField.val()).toEqual("One,Three");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(2);expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(2);view.$(".djblets-c-list-edit-widget__remove-item").eq(1).click();expect($valueField.val()).toEqual("One");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(1);view.$(".djblets-c-list-edit-widget__remove-item").click();expect($valueField.val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1)})});describe("Addition",function(){it("With values",function(){var _makeView13=makeView(["one","two","three"]),_makeView14=_slicedToArray(_makeView13,2),view=_makeView14[0],$valueField=_makeView14[1];expect($valueField.val()).toEqual("one,two,three");view.$(".djblets-c-list-edit-widget__add-item").click();expect($valueField.val()).toEqual("one,two,three");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(4);view.$(".djblets-c-list-edit-widget__input").eq(3).val("four").blur();expect($valueField.val()).toEqual("one,two,three,four")});it("With blank values",function(){var _makeView15=makeView(["","",""]),_makeView16=_slicedToArray(_makeView15,2),view=_makeView16[0],$valueField=_makeView16[1];expect($valueField.val()).toEqual("");view.$(".djblets-c-list-edit-widget__add-item").click();expect($valueField.val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(4);view.$(".djblets-c-list-edit-widget__input").eq(3).val("four").blur();expect($valueField.val()).toEqual("four")});it("With correct attributes",function(){var _makeView17=makeView([],'size="100" readonly'),_makeView18=_slicedToArray(_makeView17,1),view=_makeView18[0];view.$(".djblets-c-list-edit-widget__add-item").click();var $input=view.$("input").eq(1);expect($input.attr("size")).toEqual("100");expect($input.prop("readonly")).toBe(true)})})});"use strict";suite("djblets/integrations/views/AddIntegrationPopupView",function(){describe("Rendering",function(){it("With integrations",function(){var view=new Djblets.AddIntegrationPopupView({integrations:[{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"}]});view.render();expect(view.$el.hasClass("-is-empty")).toBe(false);var $items=view.$el.find(".djblets-c-integration");expect($items.length).toBe(2);var $item=$items.eq(0);expect($item.children("a").attr("href")).toBe("int1/add/");expect($item.find(".djblets-c-integration__name").text()).toBe("Int1");expect($item.find(".djblets-c-integration__description").text().trim()).toBe("Int1 Description");var $icon=$item.find(".djblets-c-integration__icon");expect($icon.attr("src")).toBe("data:test,int1");expect($icon.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x");$item=$items.eq(1);expect($item.children("a").attr("href")).toBe("int2/add/");expect($item.find(".djblets-c-integration__name").text()).toBe("Int2");expect($item.find(".djblets-c-integration__description").text().trim()).toBe("Int2 Description");$icon=$item.find(".djblets-c-integration__icon");expect($icon.attr("src")).toBe("data:test,int2");expect($icon.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x")});it("Without integrations",function(){var view=new Djblets.AddIntegrationPopupView({integrations:[]});view.render();expect(view.$el.hasClass("-is-empty")).toBe(true);var $empty=view.$(".djblets-c-integrations-popup__empty");expect($empty.length).toBe(1);expect($empty.text().trim()).toBe("There are no integrations currently installed.")})})});"use strict";suite("djblets/integrations/views/IntegrationConfigListView",function(){var template=_.template('<div class="djblets-c-integration-configs">\n <div class="djblets-l-config-forms-container">\n  <table class="djblets-c-config-forms-list"></table>\n </div>\n</div>');var collection;var view;beforeEach(function(){var $el=$(template()).appendTo($testsScratch);view=new Djblets.IntegrationConfigListView({el:$el,configs:[{editURL:"configs/1/",enabled:true,id:1,integrationID:"int1",name:"Config 1"},{editURL:"configs/2/",enabled:true,id:2,integrationID:"int2",name:"Config 2"},{editURL:"configs/3/",enabled:false,id:3,integrationID:"int3",name:"Config 3"},{editURL:"configs/4/",enabled:true,id:4,integrationID:"int1",name:"Config 4"}],integrationIDs:["int1","int2","int3"],integrationsMap:{int1:{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},int2:{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"},int3:{addURL:"int3/add/",description:"Int3 Description",iconSrc:"data:test,int3",iconSrcSet:"data:test,int3 1x, data:test,int3@2x 2x",id:"int3",name:"Int3"}}});view.render();collection=view.list.collection});describe("Configurations",function(){var $row1;var $row2;var $row3;var $row4;beforeEach(function(){var $rows=view.listView.$("tr");expect($rows.length).toBe(4);$row1=$rows.eq(0);$row2=$rows.eq(1);$row3=$rows.eq(2);$row4=$rows.eq(3)});describe("Rendering",function(){it("Icon",function(){var $icon1=$row1.find(".djblets-c-integration-config__name img");var $icon2=$row2.find(".djblets-c-integration-config__name img");var $icon3=$row3.find(".djblets-c-integration-config__name img");var $icon4=$row4.find(".djblets-c-integration-config__name img");expect($icon1.attr("src")).toBe("data:test,int1");expect($icon2.attr("src")).toBe("data:test,int2");expect($icon3.attr("src")).toBe("data:test,int3");expect($icon4.attr("src")).toBe("data:test,int1");expect($icon1.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x");expect($icon2.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x");expect($icon3.attr("srcset")).toBe("data:test,int3 1x, data:test,int3@2x 2x");expect($icon4.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x")});it("Name",function(){var $name1=$row1.find(".djblets-c-integration-config__name a");var $name2=$row2.find(".djblets-c-integration-config__name a");var $name3=$row3.find(".djblets-c-integration-config__name a");var $name4=$row4.find(".djblets-c-integration-config__name a");expect($name1.text()).toBe("Config 1");expect($name2.text()).toBe("Config 2");expect($name3.text()).toBe("Config 3");expect($name4.text()).toBe("Config 4");expect($name1.attr("href")).toBe("configs/1/");expect($name2.attr("href")).toBe("configs/2/");expect($name3.attr("href")).toBe("configs/3/");expect($name4.attr("href")).toBe("configs/4/")});it("Integration name",function(){var $intName1=$row1.find(".djblets-c-integration-config__integration-name");var $intName2=$row2.find(".djblets-c-integration-config__integration-name");var $intName3=$row3.find(".djblets-c-integration-config__integration-name");var $intName4=$row4.find(".djblets-c-integration-config__integration-name");expect($intName1.text().trim()).toBe("Int1");expect($intName2.text().trim()).toBe("Int2");expect($intName3.text().trim()).toBe("Int3");expect($intName4.text().trim()).toBe("Int1")});it("Status",function(){expect($row1.hasClass("-is-enabled")).toBe(true);expect($row2.hasClass("-is-enabled")).toBe(true);expect($row3.hasClass("-is-enabled")).toBe(false);expect($row4.hasClass("-is-enabled")).toBe(true);expect($row1.hasClass("-is-disabled")).toBe(false);expect($row2.hasClass("-is-disabled")).toBe(false);expect($row3.hasClass("-is-disabled")).toBe(true);expect($row4.hasClass("-is-disabled")).toBe(false);expect($row1.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled");expect($row2.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled");expect($row3.find(".djblets-c-config-forms-list__item-state").text()).toBe("Disabled");expect($row4.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled")})});describe("Actions",function(){it("Delete",function(){var config=collection.at(0);spyOn(config,"destroy").and.callThrough();spyOn(config,"sync");spyOn($.fn,"modalBox").and.callFake(function(options){return options.buttons[1].click()});$row1.find(".config-forms-list-action-delete").click();expect($.fn.modalBox).toHaveBeenCalled();expect(config.destroy).toHaveBeenCalled();expect(collection.length).toBe(3);expect(view.listView.$("tr").length).toBe(3)})})})});"use strict";suite("djblets/utils/urls",function(){describe("buildURL",function(){it("With just baseURL",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/"});expect(url).toBe("https://example.com/abc123/")});describe("With anchor",function(){it('With leading "#"',function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",anchor:"#my-anchor"});expect(url).toBe("https://example.com/abc123/#my-anchor")});it('Without leading "#"',function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",anchor:"my-anchor"});expect(url).toBe("https://example.com/abc123/#my-anchor")})});describe("With queryData",function(){describe("As string",function(){it('With leading "?"',function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"?a=b&c=d"});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it('Without leading "?"',function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"a=b&c=d"});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it("Empty",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:""});expect(url).toBe("https://example.com/abc123/")})});describe("As object",function(){it("With value",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{a:"b"}});expect(url).toBe("https://example.com/abc123/?a=b")});it("Empty",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{}});expect(url).toBe("https://example.com/abc123/")})});describe("As array",function(){it("With value",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[{name:"a",value:"b"},{name:"c",value:"d"}]});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it("Empty",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[]});expect(url).toBe("https://example.com/abc123/")})})});it("With all options",function(){var url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"a=b&c=d",anchor:"my-anchor"});expect(url).toBe("https://example.com/abc123/?a=b&c=d#my-anchor")})});describe("parseQueryString",function(){it("Empty query string",function(){expect(Djblets.parseQueryString("")).toEqual({})});it("Basic query strings",function(){expect(Djblets.parseQueryString("?a=b&c=d&e=f")).toEqual({a:"b",c:"d",e:"f"})});it("Keys without values",function(){expect(Djblets.parseQueryString("?abc=def&ghi")).toEqual({abc:"def",ghi:null})});describe("Multiple values for keys",function(){it("With allowMultiValue=true",function(){var queryString=Djblets.parseQueryString("?a=1&a=2&a=3&b=4",{allowMultiValue:true});expect(queryString).toEqual({a:["1","2","3"],b:"4"})});it("Without allowMultiValue=true",function(){expect(Djblets.parseQueryString("?a=1&a=2&a=3&b=4")).toEqual({a:"3",b:"4"})})})})})}).call(this);
