# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/utils.ipynb (unless otherwise specified).

__all__ = []

# Internal Cell
from math import sqrt
from typing import Optional

import numpy as np
from numba import njit

# Internal Cell
@njit
def _expanding_std(x: np.ndarray) -> np.ndarray:
    n_samples = x.size
    out = np.empty(n_samples, dtype=np.float32)
    out[0] = np.nan
    accum_x = x[0]
    accum_xsq = x[0]**2
    for i in range(1, n_samples):
        accum_x += x[i]
        accum_xsq += x[i]**2
        out[i] = sqrt((accum_xsq - accum_x**2 / (i+1)) / i)
    return out, accum_xsq, accum_x

@njit
def _rolling_std(x: np.ndarray,
                window_size: int,
                min_samples: Optional[int] = None) -> np.ndarray:
    if min_samples is None:
        min_samples = window_size
    if min_samples < 2:
        raise ValueError('min_samples must be greater than 1')
    n_samples = x.size
    out = np.full(n_samples, np.nan, dtype=np.float32)
    accum_x = 0.
    accum_xsq = 0.
    for i in range(min_samples - 1):
        accum_x += x[i]
        accum_xsq += x[i]**2
    for i in range(min_samples - 1, window_size):
        accum_x += x[i]
        accum_xsq += x[i]**2
        if i > 0:
            out[i] = sqrt((accum_xsq - accum_x**2 / (i+1)) / i)
    out[0] = np.nan
    for i in range(window_size, n_samples):
        accum_xsq += x[i]**2 - x[i-window_size]**2
        accum_x += x[i] - x[i-window_size]
        out[i] = sqrt((accum_xsq - accum_x**2 / window_size) / (window_size-1))
    return out, accum_xsq, accum_x