# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/online.ipynb (unless otherwise specified).

__all__ = ['ExpandingMean', 'ExpandingMax', 'ExpandingMin', 'ExpandingStd', 'RollingMean', 'RollingStd', 'RollingMax',
           'RollingMin', 'EWMMean']

# Cell
from math import sqrt

import numpy as np

from .expanding import *
from .ewm import *
from .rolling import *
from .utils import _expanding_std, _rolling_std

# Cell
class ExpandingMean:

    def fit_transform(self, x: np.ndarray) -> np.ndarray:
        exp_mean = expanding_mean(x)
        self.n = x.size
        self.cumsum = exp_mean[-1] * self.n
        return exp_mean

    def update(self, x: float) -> float:
        self.cumsum += x
        self.n += 1
        return self.cumsum / self.n

# Cell
class ExpandingMax:

    def fit_transform(self, x: np.ndarray) -> np.ndarray:
        exp_max = expanding_max(x)
        self.max = exp_max[-1]
        return exp_max

    def update(self, x: float) -> float:
        if x > self.max:
            self.max = x
        return self.max

# Cell
class ExpandingMin:

    def fit_transform(self, x: np.ndarray) -> np.ndarray:
        exp_min = expanding_min(x)
        self.min = exp_min[-1]
        return exp_min

    def update(self, x: float) -> float:
        if x < self.min:
            self.min = x
        return self.min

# Cell
class ExpandingStd:

    def fit_transform(self, x):
        self.n = x.size
        exp_std, self.accum_xsq, self.accum_x = _expanding_std(x)
        return exp_std

    def update(self, x):
        self.accum_x += x
        self.accum_xsq += x**2
        self.n += 1
        exp_var = (self.accum_xsq - self.accum_x**2 / self.n) / (self.n - 1)
        return sqrt(exp_var)

# Cell
class RollingMean:

    def __init__(self, window_size, min_samples=None):
        self.window_size = window_size
        self.min_samples = min_samples

    def fit_transform(self, x: np.ndarray) -> np.ndarray:
        rm = rolling_mean(x, self.window_size, self.min_samples)
        self.x = x[-self.window_size:].tolist()
        return rm

    def update(self, x: float) -> float:
        self.x = self.x[1:] + [x]
        return sum(self.x) / self.window_size

# Cell
class RollingStd:

    def __init__(self, window_size, min_samples):
        self.window_size = window_size
        self.min_samples = min_samples

    def fit_transform(self, x):
        self.x = x[-self.window_size:].tolist()
        self.n = x.size
        self.cumsum = sum(self.x)
        rs, self.accum_xsq, self.accum_x = _rolling_std(x, self.window_size, self.min_samples)
        return rs

    def update(self, x):
        self.accum_xsq += x**2 - self.x[0]**2
        self.accum_x += x - self.x[0]
        self.x = self.x[1:] + [x]
        return sqrt((self.accum_xsq - self.accum_x**2 / self.window_size) / (self.window_size-1))

# Cell
class RollingMax:

    def __init__(self, window_size, min_samples):
        self.window_size = window_size
        self.min_samples = min_samples

    def fit_transform(self, x):
        rm = rolling_max(x, self.window_size, self.min_samples)
        self.x = x[-self.window_size:].tolist()
        return rm

    def update(self, x):
        self.x = self.x[1:] + [x]
        return max(self.x)

# Cell
class RollingMin:

    def __init__(self, window_size, min_samples):
        self.window_size = window_size
        self.min_samples = min_samples

    def fit_transform(self, x):
        rm = rolling_min(x, self.window_size, self.min_samples)
        self.x = x[-self.window_size:].tolist()
        return rm

    def update(self, x):
        self.x = self.x[1:] + [x]
        return min(self.x)

# Cell
class EWMMean:

    def __init__(self, alpha):
        self.alpha = alpha

    def fit_transform(self, x):
        mn = ewm_mean(x, self.alpha)
        self.smoothed = mn[-1]
        return mn

    def update(self, x):
        self.smoothed = self.alpha * x + (1 - self.alpha) * self.smoothed
        return self.smoothed