/*
 * Copyright (C) 2015 Holmes Team at HUAWEI Noah's Ark Lab.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef READER_H_
#define READER_H_
#include <string>
#include "../core/Instance.h"
#include "../utils/Configurable.h"
#include "../API.h"

using namespace std;

class STREAMDM_API Reader : public Configurable {
public:
	Reader();
	virtual ~Reader();
	virtual int input(string&) = 0;
	virtual bool hasNextInstance();
	virtual Instance* nextInstance();
	virtual bool setFile(const string&) = 0;
protected:
	bool mHasNextInstance;
	Instance* mNextInstance;
};

#endif /* READER_H_ */
