"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RDSMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class RDSMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'ReadLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static databaseConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'DatabaseConnections',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static freeStorageSpaceAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'FreeStorageSpace',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static freeableMemoryAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'FreeableMemory',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readThroughputAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'ReadThroughput',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readIopsAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'ReadIOPS',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'WriteLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeThroughputAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'WriteThroughput',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeIopsAverage(dimensions) {
        return {
            namespace: 'AWS/RDS',
            metricName: 'WriteIOPS',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.RDSMetrics = RDSMetrics;
//# sourceMappingURL=data:application/json;base64,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