# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This is an auto-generated module containing ManagedObject Meta information.
"""

from .ucscoremeta import UcsVersion
from .ucscoremeta import MoMeta


def version():
    return '4.2(1a)'

class VersionMeta:
    """ This class contains all the UcsVersion supported by this package."""
    Version101e = UcsVersion("1.0(1e)")
    Version102d = UcsVersion("1.0(2d)")
    Version102e = UcsVersion("1.0(2e)")
    Version102h = UcsVersion("1.0(2h)")
    Version102j = UcsVersion("1.0(2j)")
    Version102k = UcsVersion("1.0(2k)")
    Version102l = UcsVersion("1.0(2l)")
    Version111j = UcsVersion("1.1(1j)")
    Version111l = UcsVersion("1.1(1l)")
    Version111m = UcsVersion("1.1(1m)")
    Version121b = UcsVersion("1.2(1b)")
    Version121d = UcsVersion("1.2(1d)")
    Version131c = UcsVersion("1.3(1c)")
    Version131i = UcsVersion("1.3(1i)")
    Version131m = UcsVersion("1.3(1m)")
    Version131n = UcsVersion("1.3(1n)")
    Version131o = UcsVersion("1.3(1o)")
    Version131p = UcsVersion("1.3(1p)")
    Version131q = UcsVersion("1.3(1q)")
    Version131t = UcsVersion("1.3(1t)")
    Version131w = UcsVersion("1.3(1w)")
    Version131y = UcsVersion("1.3(1y)")
    Version141i = UcsVersion("1.4(1i)")
    Version141j = UcsVersion("1.4(1j)")
    Version141k = UcsVersion("1.4(1k)")
    Version141m = UcsVersion("1.4(1m)")
    Version142b = UcsVersion("1.4(2b)")
    Version143i = UcsVersion("1.4(3i)")
    Version143l = UcsVersion("1.4(3l)")
    Version143m = UcsVersion("1.4(3m)")
    Version143q = UcsVersion("1.4(3q)")
    Version143s = UcsVersion("1.4(3s)")
    Version143u = UcsVersion("1.4(3u)")
    Version143y = UcsVersion("1.4(3y)")
    Version144f = UcsVersion("1.4(4f)")
    Version144g = UcsVersion("1.4(4g)")
    Version144i = UcsVersion("1.4(4i)")
    Version144j = UcsVersion("1.4(4j)")
    Version144k = UcsVersion("1.4(4k)")
    Version201m = UcsVersion("2.0(1m)")
    Version201q = UcsVersion("2.0(1q)")
    Version201s = UcsVersion("2.0(1s)")
    Version201t = UcsVersion("2.0(1t)")
    Version201w = UcsVersion("2.0(1w)")
    Version201x = UcsVersion("2.0(1x)")
    Version202m = UcsVersion("2.0(2m)")
    Version202q = UcsVersion("2.0(2q)")
    Version202r = UcsVersion("2.0(2r)")
    Version203a = UcsVersion("2.0(3a)")
    Version203b = UcsVersion("2.0(3b)")
    Version203c = UcsVersion("2.0(3c)")
    Version204a = UcsVersion("2.0(4a)")
    Version204b = UcsVersion("2.0(4b)")
    Version204d = UcsVersion("2.0(4d)")
    Version205a = UcsVersion("2.0(5a)")
    Version205b = UcsVersion("2.0(5b)")
    Version211a = UcsVersion("2.1(1a)")
    Version211b = UcsVersion("2.1(1b)")
    Version211d = UcsVersion("2.1(1d)")
    Version211e = UcsVersion("2.1(1e)")
    Version212a = UcsVersion("2.1(2a)")
    Version213a = UcsVersion("2.1(3a)")
    Version221b = UcsVersion("2.2(1b)")
    Version222c = UcsVersion("2.2(2c)")
    Version223a = UcsVersion("2.2(3a)")
    Version224b = UcsVersion("2.2(4b)")
    Version225a = UcsVersion("2.2(5a)")
    Version226c = UcsVersion("2.2(6c)")
    Version227b = UcsVersion("2.2(7b)")
    Version251a = UcsVersion("2.5(1a)")
    Version252a = UcsVersion("2.5(2a)")
    Version302c = UcsVersion("3.0(2c)")
    Version311e = UcsVersion("3.1(1e)")
    Version312b = UcsVersion("3.1(2b)")
    Version321d = UcsVersion("3.2(1d)")
    Version323a = UcsVersion("3.2(3a)")
    Version401a = UcsVersion("4.0(1a)")
    Version402a = UcsVersion("4.0(2a)")
    Version404a = UcsVersion("4.0(4a)")
    Version411a = UcsVersion("4.1(1a)")
    Version411b = UcsVersion("4.1(1b)")
    Version411c = UcsVersion("4.1(1c)")
    Version411d = UcsVersion("4.1(1d)")
    Version411e = UcsVersion("4.1(1e)")
    Version412a = UcsVersion("4.1(2a)")
    Version412b = UcsVersion("4.1(2b)")
    Version412c = UcsVersion("4.1(2c)")
    Version413a = UcsVersion("4.1(3a)")
    Version413b = UcsVersion("4.1(3b)")
    Version413c = UcsVersion("4.1(3c)")
    Version413d = UcsVersion("4.1(3d)")
    Version421a = UcsVersion("4.2(1a)")

MO_CLASS_ID = frozenset([
    "AaaAuthRealm",
    "AaaAuthRealmFsm",
    "AaaAuthRealmFsmStage",
    "AaaCimcSession",
    "AaaConsoleAuth",
    "AaaDefaultAuth",
    "AaaDomain",
    "AaaDomainAuth",
    "AaaEpAuthProfile",
    "AaaEpFsm",
    "AaaEpFsmStage",
    "AaaEpFsmTask",
    "AaaEpLogin",
    "AaaEpUser",
    "AaaExtMgmtCutThruTkn",
    "AaaLdapEp",
    "AaaLdapEpFsm",
    "AaaLdapEpFsmStage",
    "AaaLdapGroup",
    "AaaLdapGroupRule",
    "AaaLdapProvider",
    "AaaLocalMgmtCmdLog",
    "AaaLocale",
    "AaaLog",
    "AaaLoginProfile",
    "AaaModLR",
    "AaaOrg",
    "AaaPreLoginBanner",
    "AaaProviderGroup",
    "AaaProviderRef",
    "AaaPwdProfile",
    "AaaRadiusEp",
    "AaaRadiusEpFsm",
    "AaaRadiusEpFsmStage",
    "AaaRadiusProvider",
    "AaaRealmFsm",
    "AaaRealmFsmStage",
    "AaaRealmFsmTask",
    "AaaRemoteUser",
    "AaaRole",
    "AaaSession",
    "AaaSessionInfo",
    "AaaSessionInfoTable",
    "AaaSessionLR",
    "AaaShellLogin",
    "AaaSshAuth",
    "AaaTacacsPlusEp",
    "AaaTacacsPlusEpFsm",
    "AaaTacacsPlusEpFsmStage",
    "AaaTacacsPlusProvider",
    "AaaUser",
    "AaaUserData",
    "AaaUserEp",
    "AaaUserEpFsm",
    "AaaUserEpFsmStage",
    "AaaUserEpFsmTask",
    "AaaUserLocale",
    "AaaUserRole",
    "AaaWebLogin",
    "AdaptorAzureQosProfile",
    "AdaptorCapQual",
    "AdaptorCapSpec",
    "AdaptorDiagCap",
    "AdaptorDynamicConfigCap",
    "AdaptorEthAdvFilterProfile",
    "AdaptorEthArfsProfile",
    "AdaptorEthCompQueueProfile",
    "AdaptorEthFailoverProfile",
    "AdaptorEthGENEVEProfile",
    "AdaptorEthInterruptProfile",
    "AdaptorEthInterruptScalingProfile",
    "AdaptorEthNVGREProfile",
    "AdaptorEthOffloadProfile",
    "AdaptorEthPortBySizeLargeStats",
    "AdaptorEthPortBySizeLargeStatsHist",
    "AdaptorEthPortBySizeSmallStats",
    "AdaptorEthPortBySizeSmallStatsHist",
    "AdaptorEthPortErrStats",
    "AdaptorEthPortErrStatsHist",
    "AdaptorEthPortMcastStats",
    "AdaptorEthPortMcastStatsHist",
    "AdaptorEthPortOutsizedStats",
    "AdaptorEthPortOutsizedStatsHist",
    "AdaptorEthPortStats",
    "AdaptorEthPortStatsHist",
    "AdaptorEthRecvQueueProfile",
    "AdaptorEthRoCEProfile",
    "AdaptorEthVxLANProfile",
    "AdaptorEthWorkQueueProfile",
    "AdaptorEtherIfStats",
    "AdaptorEtherIfStatsHist",
    "AdaptorExtEthIf",
    "AdaptorExtEthIfFsm",
    "AdaptorExtEthIfFsmStage",
    "AdaptorExtEthIfFsmTask",
    "AdaptorExtEthIfPc",
    "AdaptorExtEthIfPcEp",
    "AdaptorExtIpV6RssHashProfile",
    "AdaptorFamilyTypeDef",
    "AdaptorFcCdbWorkQueueProfile",
    "AdaptorFcErrorRecoveryProfile",
    "AdaptorFcFnicProfile",
    "AdaptorFcIfEventStats",
    "AdaptorFcIfEventStatsHist",
    "AdaptorFcIfFC4Stats",
    "AdaptorFcIfFC4StatsHist",
    "AdaptorFcIfFrameStats",
    "AdaptorFcIfFrameStatsHist",
    "AdaptorFcInterruptProfile",
    "AdaptorFcOEIf",
    "AdaptorFcPortFLogiProfile",
    "AdaptorFcPortPLogiProfile",
    "AdaptorFcPortProfile",
    "AdaptorFcPortStats",
    "AdaptorFcPortStatsHist",
    "AdaptorFcRecvQueueProfile",
    "AdaptorFcVhbaTypeProfile",
    "AdaptorFcWorkQueueProfile",
    "AdaptorFruCapProvider",
    "AdaptorFruCapRef",
    "AdaptorFwCapProvider",
    "AdaptorHostEthIf",
    "AdaptorHostEthIfFsm",
    "AdaptorHostEthIfFsmStage",
    "AdaptorHostEthIfFsmTask",
    "AdaptorHostEthIfProfile",
    "AdaptorHostFcIf",
    "AdaptorHostFcIfFsm",
    "AdaptorHostFcIfFsmStage",
    "AdaptorHostFcIfFsmTask",
    "AdaptorHostFcIfProfile",
    "AdaptorHostIfConfig",
    "AdaptorHostIscsiIf",
    "AdaptorHostIscsiIfProfile",
    "AdaptorHostMgmtCap",
    "AdaptorHostPort",
    "AdaptorHostPortCap",
    "AdaptorHostScsiIf",
    "AdaptorHostScsiLunRef",
    "AdaptorHostServiceEthIf",
    "AdaptorHostVnicHwAddrCap",
    "AdaptorHostethHwAddrCap",
    "AdaptorHostfcHwAddrCap",
    "AdaptorIScsiCap",
    "AdaptorIpV4RssHashProfile",
    "AdaptorIpV6RssHashProfile",
    "AdaptorIscsiAuth",
    "AdaptorIscsiProt",
    "AdaptorIscsiTargetIf",
    "AdaptorLanCap",
    "AdaptorLldpCap",
    "AdaptorMenloBaseErrorStats",
    "AdaptorMenloBaseErrorStatsHist",
    "AdaptorMenloDcePortStats",
    "AdaptorMenloDcePortStatsHist",
    "AdaptorMenloEthErrorStats",
    "AdaptorMenloEthErrorStatsHist",
    "AdaptorMenloEthStats",
    "AdaptorMenloEthStatsHist",
    "AdaptorMenloFcErrorStats",
    "AdaptorMenloFcErrorStatsHist",
    "AdaptorMenloFcStats",
    "AdaptorMenloFcStatsHist",
    "AdaptorMenloHostPortStats",
    "AdaptorMenloHostPortStatsHist",
    "AdaptorMenloMcpuErrorStats",
    "AdaptorMenloMcpuErrorStatsHist",
    "AdaptorMenloMcpuStats",
    "AdaptorMenloMcpuStatsHist",
    "AdaptorMenloNetEgStats",
    "AdaptorMenloNetEgStatsHist",
    "AdaptorMenloNetInStats",
    "AdaptorMenloNetInStatsHist",
    "AdaptorMenloQErrorStats",
    "AdaptorMenloQErrorStatsHist",
    "AdaptorMenloQStats",
    "AdaptorMenloQStatsHist",
    "AdaptorMgmtVnicEthConfig",
    "AdaptorNwMgmtCap",
    "AdaptorNwStatsMgmtCap",
    "AdaptorProtocolProfile",
    "AdaptorQual",
    "AdaptorRnicCapSpec",
    "AdaptorRssProfile",
    "AdaptorSanCap",
    "AdaptorUnit",
    "AdaptorUnitAssocCtx",
    "AdaptorUnitExtn",
    "AdaptorUplinkHwAddrCap",
    "AdaptorUplinkPortStats",
    "AdaptorUsnicConnDef",
    "AdaptorVlan",
    "AdaptorVmmqConnDef",
    "AdaptorVnicStats",
    "AdaptorVnicStatsHist",
    "AdaptorVsan",
    "ApeAttribute",
    "ApeControllerChassis",
    "ApeControllerEeprom",
    "ApeControllerManager",
    "ApeDcosAgManager",
    "ApeFru",
    "ApeHostAgent",
    "ApeLANBoot",
    "ApeLocalDiskBoot",
    "ApeManager",
    "ApeMc",
    "ApeMcStats",
    "ApeMcTable",
    "ApeMenlo",
    "ApeMenloVnic",
    "ApeMenloVnicStats",
    "ApeNicAgManager",
    "ApePalo",
    "ApePaloVnic",
    "ApePaloVnicStats",
    "ApeParam",
    "ApeReading",
    "ApeSANBoot",
    "ApeSdr",
    "ApeSwitchFirmwareInv",
    "ApeVirtualMediaBoot",
    "BiosBOT",
    "BiosBootDev",
    "BiosBootDevGrp",
    "BiosFeatureRef",
    "BiosParameterRef",
    "BiosRef",
    "BiosSettingRef",
    "BiosSettings",
    "BiosTokenFeatureGroup",
    "BiosTokenParam",
    "BiosTokenSettings",
    "BiosUnit",
    "BiosVIdentityParams",
    "BiosVProfile",
    "BiosVfACPI10Support",
    "BiosVfASPMSupport",
    "BiosVfAllUSBDevices",
    "BiosVfAltitude",
    "BiosVfAssertNMIOnPERR",
    "BiosVfAssertNMIOnSERR",
    "BiosVfBMEDMAMitigation",
    "BiosVfBootOptionRetry",
    "BiosVfCPUHardwarePowerManagement",
    "BiosVfCPUPerformance",
    "BiosVfConsistentDeviceNameControl",
    "BiosVfConsoleRedirection",
    "BiosVfCoreMultiProcessing",
    "BiosVfDDR3VoltageSelection",
    "BiosVfDRAMClockThrottling",
    "BiosVfDirectCacheAccess",
    "BiosVfDramRefreshRate",
    "BiosVfEnergyPerformanceTuning",
    "BiosVfEnhancedIntelSpeedStepTech",
    "BiosVfEnhancedPowerCappingSupport",
    "BiosVfExecuteDisableBit",
    "BiosVfFRB2Timer",
    "BiosVfFrequencyFloorOverride",
    "BiosVfFrontPanelLockout",
    "BiosVfIOEMezz1OptionROM",
    "BiosVfIOENVMe1OptionROM",
    "BiosVfIOENVMe2OptionROM",
    "BiosVfIOESlot1OptionROM",
    "BiosVfIOESlot2OptionROM",
    "BiosVfIntegratedGraphics",
    "BiosVfIntegratedGraphicsApertureSize",
    "BiosVfIntelEntrySASRAIDModule",
    "BiosVfIntelHyperThreadingTech",
    "BiosVfIntelTrustedExecutionTechnology",
    "BiosVfIntelTurboBoostTech",
    "BiosVfIntelVTForDirectedIO",
    "BiosVfIntelVirtualizationTechnology",
    "BiosVfInterleaveConfiguration",
    "BiosVfLocalX2Apic",
    "BiosVfLvDIMMSupport",
    "BiosVfMaxVariableMTRRSetting",
    "BiosVfMaximumMemoryBelow4GB",
    "BiosVfMemoryMappedIOAbove4GB",
    "BiosVfMirroringMode",
    "BiosVfNUMAOptimized",
    "BiosVfOSBootWatchdogTimer",
    "BiosVfOSBootWatchdogTimerPolicy",
    "BiosVfOSBootWatchdogTimerTimeout",
    "BiosVfOnboardGraphics",
    "BiosVfOnboardSATAController",
    "BiosVfOnboardStorage",
    "BiosVfOptionROMEnable",
    "BiosVfOptionROMLoad",
    "BiosVfOutOfBandManagement",
    "BiosVfPCHSATAMode",
    "BiosVfPCILOMPortsConfiguration",
    "BiosVfPCIROMCLP",
    "BiosVfPCISlotLinkSpeed",
    "BiosVfPCISlotOptionROMEnable",
    "BiosVfPOSTErrorPause",
    "BiosVfPSTATECoordination",
    "BiosVfPackageCStateLimit",
    "BiosVfPanicAndHighWatermark",
    "BiosVfProcessorC1E",
    "BiosVfProcessorC3Report",
    "BiosVfProcessorC6Report",
    "BiosVfProcessorC7Report",
    "BiosVfProcessorCMCI",
    "BiosVfProcessorCState",
    "BiosVfProcessorEnergyConfiguration",
    "BiosVfProcessorPrefetchConfig",
    "BiosVfQPILinkFrequencySelect",
    "BiosVfQPISnoopMode",
    "BiosVfQuietBoot",
    "BiosVfRedirectionAfterBIOSPOST",
    "BiosVfResumeOnACPowerLoss",
    "BiosVfSBMezz1OptionROM",
    "BiosVfSBNVMe1OptionROM",
    "BiosVfSIOC1OptionROM",
    "BiosVfSIOC2OptionROM",
    "BiosVfScrubPolicies",
    "BiosVfSelectMemoryRASConfiguration",
    "BiosVfSerialPortAEnable",
    "BiosVfSparingMode",
    "BiosVfSriovConfig",
    "BiosVfTPMPendingOperation",
    "BiosVfTPMSupport",
    "BiosVfTrustedPlatformModule",
    "BiosVfUCSMBootModeControl",
    "BiosVfUCSMBootOrderRuleControl",
    "BiosVfUEFIOSUseLegacyVideo",
    "BiosVfUSBBootConfig",
    "BiosVfUSBConfiguration",
    "BiosVfUSBFrontPanelAccessLock",
    "BiosVfUSBPortConfiguration",
    "BiosVfUSBSystemIdlePowerOptimizingSetting",
    "BiosVfVGAPriority",
    "BiosVfWorkloadConfiguration",
    "BmcSELCounter",
    "CallhomeAnonymousReporting",
    "CallhomeDest",
    "CallhomeEp",
    "CallhomeEpFsm",
    "CallhomeEpFsmStage",
    "CallhomeEpFsmTask",
    "CallhomePeriodicSystemInventory",
    "CallhomePolicy",
    "CallhomeProfile",
    "CallhomeSmtp",
    "CallhomeSource",
    "CallhomeTestAlert",
    "CapabilityCatalogue",
    "CapabilityCatalogueFsm",
    "CapabilityCatalogueFsmStage",
    "CapabilityCatalogueFsmTask",
    "CapabilityEp",
    "CapabilityFeatureLimits",
    "CapabilityMgmtExtension",
    "CapabilityMgmtExtensionFsm",
    "CapabilityMgmtExtensionFsmStage",
    "CapabilityMgmtExtensionFsmTask",
    "CapabilityNetworkLimits",
    "CapabilityStorageLimits",
    "CapabilitySystemLimits",
    "CapabilityUpdate",
    "CapabilityUpdater",
    "CapabilityUpdaterFsm",
    "CapabilityUpdaterFsmStage",
    "CapabilityUpdaterFsmTask",
    "ChangeChangedObjectRef",
    "CimcvmediaActualMountEntry",
    "CimcvmediaActualMountList",
    "CimcvmediaConfigMountEntry",
    "CimcvmediaExtMgmtRuleEntry",
    "CimcvmediaMountConfigDef",
    "CimcvmediaMountConfigPolicy",
    "ClitestTypeTest",
    "ClitestTypeTest2",
    "ClitestTypeTestChild",
    "CloudDeviceConnectorEp",
    "CloudMgmtSvc",
    "CommCimcWebService",
    "CommCimxml",
    "CommDateTime",
    "CommDns",
    "CommDnsProvider",
    "CommEvtChannel",
    "CommHttp",
    "CommHttps",
    "CommLocale",
    "CommNtpProvider",
    "CommShellSvcLimits",
    "CommSmashCLP",
    "CommSnmp",
    "CommSnmpTrap",
    "CommSnmpUser",
    "CommSsh",
    "CommSvcEp",
    "CommSvcEpFsm",
    "CommSvcEpFsmStage",
    "CommSvcEpFsmTask",
    "CommSvcPolicy",
    "CommSyslog",
    "CommSyslogClient",
    "CommSyslogConsole",
    "CommSyslogFile",
    "CommSyslogMonitor",
    "CommSyslogSource",
    "CommTelnet",
    "CommWebChannel",
    "CommWebSvcLimits",
    "CommWsman",
    "CommXmlClConnPolicy",
    "ComputeAdminAck",
    "ComputeAutoconfigPolicy",
    "ComputeBlade",
    "ComputeBladeDiscPolicy",
    "ComputeBladeEp",
    "ComputeBladeFsm",
    "ComputeBladeFsmStage",
    "ComputeBladeFsmTask",
    "ComputeBladeInheritPolicy",
    "ComputeBoard",
    "ComputeBoardConnector",
    "ComputeBoardController",
    "ComputeCartridge",
    "ComputeChassisConnPolicy",
    "ComputeChassisDiscPolicy",
    "ComputeChassisQual",
    "ComputeConstraintDef",
    "ComputeDefaults",
    "ComputeExtBoard",
    "ComputeFactoryResetOperation",
    "ComputeFanPolicy",
    "ComputeFwSyncAck",
    "ComputeGraphicsCardPolicy",
    "ComputeHealthLedSensorAlarm",
    "ComputeHostUtilityOs",
    "ComputeHwChangeDiscPolicy",
    "ComputeIOHub",
    "ComputeIOHubEnvStats",
    "ComputeIOHubEnvStatsHist",
    "ComputeInstanceIdQual",
    "ComputeKvmMgmtPolicy",
    "ComputeMbPowerStats",
    "ComputeMbPowerStatsHist",
    "ComputeMbTempStats",
    "ComputeMbTempStatsHist",
    "ComputeMemoryConfigPolicy",
    "ComputeMemoryConfiguration",
    "ComputeMemoryUnitConstraintDef",
    "ComputePCIeFatalCompletionStats",
    "ComputePCIeFatalProtocolStats",
    "ComputePCIeFatalReceiveStats",
    "ComputePCIeFatalStats",
    "ComputePciCap",
    "ComputePciSlotScanDef",
    "ComputePersonality",
    "ComputePhysicalAssocCtx",
    "ComputePhysicalExtension",
    "ComputePhysicalFsm",
    "ComputePhysicalFsmStage",
    "ComputePhysicalFsmTask",
    "ComputePhysicalQual",
    "ComputePlatform",
    "ComputePnuOSImage",
    "ComputePool",
    "ComputePoolPolicyRef",
    "ComputePoolable",
    "ComputePooledEnclosureComputeSlot",
    "ComputePooledRackUnit",
    "ComputePooledSlot",
    "ComputePoolingPolicy",
    "ComputePortDiscPolicy",
    "ComputePowerSavePolicy",
    "ComputePowerSyncDef",
    "ComputePowerSyncPolicy",
    "ComputePsuControl",
    "ComputePsuPolicy",
    "ComputeQual",
    "ComputeRackConnLinkPolicy",
    "ComputeRackQual",
    "ComputeRackUnit",
    "ComputeRackUnitFsm",
    "ComputeRackUnitFsmStage",
    "ComputeRackUnitFsmTask",
    "ComputeRackUnitMbTempStats",
    "ComputeRackUnitMbTempStatsHist",
    "ComputeRebootLog",
    "ComputeRtcBattery",
    "ComputeScrubPolicy",
    "ComputeServerDiscPolicy",
    "ComputeServerDiscPolicyFsm",
    "ComputeServerDiscPolicyFsmStage",
    "ComputeServerDiscPolicyFsmTask",
    "ComputeServerMgmtPolicy",
    "ComputeServerTypeCap",
    "ComputeServerUnit",
    "ComputeServerUnitFsm",
    "ComputeServerUnitFsmStage",
    "ComputeServerUnitFsmTask",
    "ComputeSlotQual",
    "ConfigImpact",
    "ConfigManagedEpImpactResponse",
    "ConfigSorter",
    "ControllerHaController",
    "ControllerMgmtDbCheckPol",
    "ControllerOperationalVersionHolder",
    "ControllerPreferedVersionHolder",
    "CoprocessorCard",
    "CpmaintAck",
    "CpmaintMaintPolicy",
    "DcxFcoeVifEp",
    "DcxNs",
    "DcxUniverse",
    "DcxVIf",
    "DcxVc",
    "DcxVifEp",
    "DhcpAcquired",
    "DhcpInst",
    "DhcpLease",
    "DiagLogEp",
    "DiagMemoryTest",
    "DiagRslt",
    "DiagRunPolicy",
    "DiagSrvCapProvider",
    "DiagSrvCtrl",
    "DomainChassisFeature",
    "DomainChassisFeatureCont",
    "DomainChassisParam",
    "DomainEnvironmentFeature",
    "DomainEnvironmentFeatureCont",
    "DomainEnvironmentParam",
    "DomainNetworkFeature",
    "DomainNetworkFeatureCont",
    "DomainNetworkParam",
    "DomainServerFeature",
    "DomainServerFeatureCont",
    "DomainServerParam",
    "DomainStorageFeature",
    "DomainStorageFeatureCont",
    "DomainStorageParam",
    "DpsecMac",
    "DupeScope",
    "DupeScopeResult",
    "EpqosDefinition",
    "EpqosDefinitionDelTask",
    "EpqosDefinitionDelTaskFsm",
    "EpqosDefinitionDelTaskFsmStage",
    "EpqosDefinitionDelTaskFsmTask",
    "EpqosDefinitionFsm",
    "EpqosDefinitionFsmStage",
    "EpqosDefinitionFsmTask",
    "EpqosEgress",
    "EquipmentAdaptorConnDef",
    "EquipmentAdaptorDef",
    "EquipmentAdvancedBootOrder",
    "EquipmentAutoConfigMode",
    "EquipmentAutoconfigPolicy",
    "EquipmentBaseBoardCapProvider",
    "EquipmentBeaconCapProvider",
    "EquipmentBeaconLed",
    "EquipmentBeaconLedFsm",
    "EquipmentBeaconLedFsmStage",
    "EquipmentBeaconLedFsmTask",
    "EquipmentBinding",
    "EquipmentBiosDef",
    "EquipmentBiosTokenOverride",
    "EquipmentBladeAGLibrary",
    "EquipmentBladeAggregationCapRef",
    "EquipmentBladeBiosCapProvider",
    "EquipmentBladeCapProvider",
    "EquipmentBladeCapProviderTypeDef",
    "EquipmentBladeConnDef",
    "EquipmentBladeIOMConnDef",
    "EquipmentBladeSwitchConnDef",
    "EquipmentBoardControllerDef",
    "EquipmentBootDeviceConstraints",
    "EquipmentBreakoutCap",
    "EquipmentCapModSpec",
    "EquipmentCatalogCapProvider",
    "EquipmentChassis",
    "EquipmentChassisAssocCtx",
    "EquipmentChassisCapProvider",
    "EquipmentChassisFsm",
    "EquipmentChassisFsmStage",
    "EquipmentChassisFsmTask",
    "EquipmentChassisInheritPolicy",
    "EquipmentChassisIssues",
    "EquipmentChassisProfile",
    "EquipmentChassisProfileAssocCtx",
    "EquipmentChassisProfileFsm",
    "EquipmentChassisProfileFsmStage",
    "EquipmentChassisProfileFsmTask",
    "EquipmentChassisQual",
    "EquipmentChassisStats",
    "EquipmentChassisStatsHist",
    "EquipmentCimcVmedia",
    "EquipmentCiscoOsOpenGate",
    "EquipmentComputeConn",
    "EquipmentComputeConnPolicy",
    "EquipmentCoprocessorUnitCapProvider",
    "EquipmentDbgPluginCapProvider",
    "EquipmentDiagFeatureSupport",
    "EquipmentDimmEntry",
    "EquipmentDimmMapping",
    "EquipmentDiscoveryCap",
    "EquipmentDowngradeConstraint",
    "EquipmentDriveSecCap",
    "EquipmentEmbeddedControllerConfig",
    "EquipmentEmbeddedStorageDef",
    "EquipmentFan",
    "EquipmentFanAggressiveCoolingCap",
    "EquipmentFanModule",
    "EquipmentFanModuleCapProvider",
    "EquipmentFanModuleDef",
    "EquipmentFanModuleStats",
    "EquipmentFanModuleStatsHist",
    "EquipmentFanPresenceDef",
    "EquipmentFanStats",
    "EquipmentFanStatsHist",
    "EquipmentFex",
    "EquipmentFexCapProvider",
    "EquipmentFexEnvStats",
    "EquipmentFexEnvStatsHist",
    "EquipmentFexFsm",
    "EquipmentFexFsmStage",
    "EquipmentFexFsmTask",
    "EquipmentFexPowerSummary",
    "EquipmentFexPowerSummaryHist",
    "EquipmentFexPsuInputStats",
    "EquipmentFexPsuInputStatsHist",
    "EquipmentFexSystemStats",
    "EquipmentFexSystemStatsHist",
    "EquipmentFirmwareConstraint",
    "EquipmentFlashLife",
    "EquipmentFlexFlashNonRemovable",
    "EquipmentFruVariant",
    "EquipmentGemCapProvider",
    "EquipmentGemPortCap",
    "EquipmentGraphicsCardCapProvider",
    "EquipmentGraphicsCardCapRef",
    "EquipmentHDDFaultMonDef",
    "EquipmentHealthLed",
    "EquipmentHostIfCapProvider",
    "EquipmentHostMgmtControllerCap",
    "EquipmentHwCapDerivativeProvider",
    "EquipmentHwRevisionModifier",
    "EquipmentHxCap",
    "EquipmentIOCard",
    "EquipmentIOCardBaseFsm",
    "EquipmentIOCardBaseFsmStage",
    "EquipmentIOCardBaseFsmTask",
    "EquipmentIOCardCapProvider",
    "EquipmentIOCardFsm",
    "EquipmentIOCardFsmStage",
    "EquipmentIOCardFsmTask",
    "EquipmentIOCardStats",
    "EquipmentIOCardStatsHist",
    "EquipmentIOCardTypeDef",
    "EquipmentIOExpander",
    "EquipmentIOExpanderCapProvider",
    "EquipmentInbandMgmtCap",
    "EquipmentIndicatorLed",
    "EquipmentInventoryStatus",
    "EquipmentKvmMgmtCap",
    "EquipmentLocalDiskCapProvider",
    "EquipmentLocalDiskControllerCapProvider",
    "EquipmentLocalDiskControllerCapRef",
    "EquipmentLocalDiskControllerDef",
    "EquipmentLocalDiskControllerTypeDef",
    "EquipmentLocalDiskDef",
    "EquipmentLocatorLed",
    "EquipmentLocatorLedFsm",
    "EquipmentLocatorLedFsmStage",
    "EquipmentLocatorLedFsmTask",
    "EquipmentManufacturingDef",
    "EquipmentMemoryUnitCapProvider",
    "EquipmentMemoryUnitDiscoveryModifierDef",
    "EquipmentMgmtCapProvider",
    "EquipmentMgmtExtCapProvider",
    "EquipmentMiniStorageCapProvider",
    "EquipmentNetworkElementFanStats",
    "EquipmentNetworkElementFanStatsHist",
    "EquipmentNonCopperPassiveCap",
    "EquipmentNvmeDef",
    "EquipmentNvmeSwitchConfig",
    "EquipmentOnboardDeviceDef",
    "EquipmentPOST",
    "EquipmentPOSTCode",
    "EquipmentPOSTCodeReporter",
    "EquipmentPOSTCodeTemplate",
    "EquipmentPciDef",
    "EquipmentPciSlotIdEntry",
    "EquipmentPciSlotIdMapping",
    "EquipmentPciSlotSubOEMIdEntry",
    "EquipmentPciSwitchCapProvider",
    "EquipmentPcieSlotOrientation",
    "EquipmentPersistentMemoryUnitCapProvider",
    "EquipmentPersonality",
    "EquipmentPfcMmuCap",
    "EquipmentPhysDevicesPerBoard",
    "EquipmentPhysicalDef",
    "EquipmentPhysicalQual",
    "EquipmentPicture",
    "EquipmentPnuosBootMode",
    "EquipmentPool",
    "EquipmentPoolPolicyRef",
    "EquipmentPoolable",
    "EquipmentPooledChassis",
    "EquipmentPoolingPolicy",
    "EquipmentPortCap",
    "EquipmentPortGroupAggregationDef",
    "EquipmentPortGroupDef",
    "EquipmentPortGroupSwComplexDef",
    "EquipmentPortSwComplexRef",
    "EquipmentPowerCapDef",
    "EquipmentProcessorUnitCapProvider",
    "EquipmentProcessorUnitDef",
    "EquipmentPsu",
    "EquipmentPsuCapProvider",
    "EquipmentPsuDef",
    "EquipmentPsuFsm",
    "EquipmentPsuFsmStage",
    "EquipmentPsuFsmTask",
    "EquipmentPsuInputStats",
    "EquipmentPsuInputStatsHist",
    "EquipmentPsuOutputStats",
    "EquipmentPsuOutputStatsHist",
    "EquipmentPsuStats",
    "EquipmentPsuStatsHist",
    "EquipmentQual",
    "EquipmentRackEnclosure",
    "EquipmentRackEnclosureCapProvider",
    "EquipmentRackFanModuleDef",
    "EquipmentRackUnitCapProvider",
    "EquipmentRackUnitFanStats",
    "EquipmentRackUnitFanStatsHist",
    "EquipmentRackUnitPsuStats",
    "EquipmentRackUnitPsuStatsHist",
    "EquipmentRaidDef",
    "EquipmentRequirement",
    "EquipmentSecureBoot",
    "EquipmentSecurityUnitCapProvider",
    "EquipmentServerCorrectUuidBehavior",
    "EquipmentServerFeatureCap",
    "EquipmentServerPortCapProvider",
    "EquipmentServerUnitCapProvider",
    "EquipmentServiceDef",
    "EquipmentSharedIOModule",
    "EquipmentSiocCapProvider",
    "EquipmentSiocTempStats",
    "EquipmentSiocTempStatsHist",
    "EquipmentSlotArray",
    "EquipmentSlotArrayRef",
    "EquipmentSlotEp",
    "EquipmentSpdmCertificateCap",
    "EquipmentSpeedCompatibility",
    "EquipmentStorageControllerConfig",
    "EquipmentStorageControllerSlotDef",
    "EquipmentStorageEncCapProvider",
    "EquipmentStorageLimitCap",
    "EquipmentStorageNvmeSwitchCapProvider",
    "EquipmentStorageNvmeSwitchDef",
    "EquipmentStorageSasExpanderCapProvider",
    "EquipmentStorageSasExpanderCapRef",
    "EquipmentStorageSasExpanderDef",
    "EquipmentSwitchCap",
    "EquipmentSwitchCapProvider",
    "EquipmentSwitchCard",
    "EquipmentSwitchIOCard",
    "EquipmentSwitchIOCardCapProvider",
    "EquipmentSwitchIOCardFsm",
    "EquipmentSwitchIOCardFsmStage",
    "EquipmentSwitchIOCardFsmTask",
    "EquipmentSwitchTypeDef",
    "EquipmentSystemIOController",
    "EquipmentSystemIOControllerFsm",
    "EquipmentSystemIOControllerFsmStage",
    "EquipmentSystemIOControllerFsmTask",
    "EquipmentTier",
    "EquipmentTpm",
    "EquipmentTpmCapProvider",
    "EquipmentUnifiedPortCapProvider",
    "EquipmentUuidFeatureCap",
    "EquipmentVersionConstraint",
    "EquipmentXcvr",
    "EtherErrStats",
    "EtherErrStatsHist",
    "EtherFcoeInterfaceStats",
    "EtherFcoeInterfaceStatsHist",
    "EtherLossStats",
    "EtherLossStatsHist",
    "EtherNiErrStats",
    "EtherNiErrStatsHist",
    "EtherNicIfConfig",
    "EtherPIo",
    "EtherPIoEndPoint",
    "EtherPIoFsm",
    "EtherPIoFsmStage",
    "EtherPauseStats",
    "EtherPauseStatsHist",
    "EtherPortChanIdElem",
    "EtherPortChanIdUniverse",
    "EtherRxStats",
    "EtherRxStatsHist",
    "EtherServerIntFIo",
    "EtherServerIntFIoFsm",
    "EtherServerIntFIoFsmStage",
    "EtherServerIntFIoFsmTask",
    "EtherServerIntFIoPc",
    "EtherServerIntFIoPcEp",
    "EtherSwIfConfig",
    "EtherSwitchIntFIo",
    "EtherSwitchIntFIoPc",
    "EtherSwitchIntFIoPcEp",
    "EtherTxStats",
    "EtherTxStatsHist",
    "EventEpCtrl",
    "EventHolder",
    "EventInst",
    "EventLog",
    "EventPolicy",
    "EventRecord",
    "ExtmgmtArpTargets",
    "ExtmgmtGatewayPing",
    "ExtmgmtIf",
    "ExtmgmtIfMonPolicy",
    "ExtmgmtMiiStatus",
    "ExtmgmtNdiscTargets",
    "ExtpolClient",
    "ExtpolClientCont",
    "ExtpolController",
    "ExtpolControllerCont",
    "ExtpolEp",
    "ExtpolEpFsm",
    "ExtpolEpFsmStage",
    "ExtpolEpFsmTask",
    "ExtpolProvider",
    "ExtpolProviderCont",
    "ExtpolProviderFsm",
    "ExtpolProviderFsmStage",
    "ExtpolProviderFsmTask",
    "ExtpolRegistry",
    "ExtpolRegistryFsm",
    "ExtpolRegistryFsmStage",
    "ExtpolRegistryFsmTask",
    "ExtpolSystemContext",
    "ExtvmmEp",
    "ExtvmmEpFsm",
    "ExtvmmEpFsmStage",
    "ExtvmmEpFsmTask",
    "ExtvmmFNDReference",
    "ExtvmmFabricNetwork",
    "ExtvmmFabricNetworkDefinition",
    "ExtvmmKeyInst",
    "ExtvmmKeyRing",
    "ExtvmmKeyStore",
    "ExtvmmKeyStoreFsm",
    "ExtvmmKeyStoreFsmStage",
    "ExtvmmKeyStoreFsmTask",
    "ExtvmmMasterExtKey",
    "ExtvmmMasterExtKeyFsm",
    "ExtvmmMasterExtKeyFsmStage",
    "ExtvmmMasterExtKeyFsmTask",
    "ExtvmmNetworkSets",
    "ExtvmmNetworkSetsFsm",
    "ExtvmmNetworkSetsFsmStage",
    "ExtvmmNetworkSetsFsmTask",
    "ExtvmmProvider",
    "ExtvmmProviderFsm",
    "ExtvmmProviderFsmStage",
    "ExtvmmProviderFsmTask",
    "ExtvmmSwitchDelTask",
    "ExtvmmSwitchDelTaskFsm",
    "ExtvmmSwitchDelTaskFsmStage",
    "ExtvmmSwitchDelTaskFsmTask",
    "ExtvmmSwitchSet",
    "ExtvmmUpLinkPP",
    "ExtvmmVMNDRef",
    "ExtvmmVMNetwork",
    "ExtvmmVMNetworkDefinition",
    "ExtvmmVMNetworkSets",
    "FabricBHVlan",
    "FabricBreakout",
    "FabricCabling",
    "FabricCablingSw",
    "FabricCartridgePhEp",
    "FabricCartridgeSlotEp",
    "FabricCartridgeSlotEpFsm",
    "FabricCartridgeSlotEpFsmStage",
    "FabricCartridgeSlotEpFsmTask",
    "FabricCdpLinkPolicy",
    "FabricChangedObjectRef",
    "FabricChassisEp",
    "FabricComputeMSlotEp",
    "FabricComputeMSlotEpFsm",
    "FabricComputeMSlotEpFsmStage",
    "FabricComputeMSlotEpFsmTask",
    "FabricComputePhEp",
    "FabricComputeSlotEp",
    "FabricComputeSlotEpFsm",
    "FabricComputeSlotEpFsmStage",
    "FabricComputeSlotEpFsmTask",
    "FabricDceSrv",
    "FabricDceSwSrv",
    "FabricDceSwSrvEp",
    "FabricDceSwSrvPc",
    "FabricDceSwSrvPcEp",
    "FabricEp",
    "FabricEpMgr",
    "FabricEpMgrFsm",
    "FabricEpMgrFsmStage",
    "FabricEpMgrFsmTask",
    "FabricEthEstc",
    "FabricEthEstcCloud",
    "FabricEthEstcEp",
    "FabricEthEstcPc",
    "FabricEthEstcPcEp",
    "FabricEthFlowMonLan",
    "FabricEthLan",
    "FabricEthLanEp",
    "FabricEthLanFlowMonitoring",
    "FabricEthLanPc",
    "FabricEthLanPcEp",
    "FabricEthLinkProfile",
    "FabricEthMon",
    "FabricEthMonDestEp",
    "FabricEthMonFiltEp",
    "FabricEthMonFiltRef",
    "FabricEthMonLan",
    "FabricEthMonSrcEp",
    "FabricEthMonSrcRef",
    "FabricEthTargetEp",
    "FabricEthVlanPc",
    "FabricEthVlanPortEp",
    "FabricFcEndpoint",
    "FabricFcEstc",
    "FabricFcEstcCloud",
    "FabricFcEstcEp",
    "FabricFcMon",
    "FabricFcMonDestEp",
    "FabricFcMonFiltEp",
    "FabricFcMonFiltRef",
    "FabricFcMonSan",
    "FabricFcMonSrcEp",
    "FabricFcMonSrcRef",
    "FabricFcSan",
    "FabricFcSanEp",
    "FabricFcSanPc",
    "FabricFcSanPcEp",
    "FabricFcUserZone",
    "FabricFcVsanPc",
    "FabricFcVsanPortEp",
    "FabricFcZoneProfile",
    "FabricFcoeEstcEp",
    "FabricFcoeSanEp",
    "FabricFcoeSanPc",
    "FabricFcoeSanPcEp",
    "FabricFcoeVsanPc",
    "FabricFcoeVsanPortEp",
    "FabricFlowMonDefinition",
    "FabricFlowMonExporterProfile",
    "FabricIf",
    "FabricLacpPolicy",
    "FabricLanAccessMgr",
    "FabricLanCloud",
    "FabricLanCloudFsm",
    "FabricLanCloudFsmStage",
    "FabricLanCloudFsmTask",
    "FabricLanCloudPolicy",
    "FabricLanMonCloud",
    "FabricLanPinGroup",
    "FabricLanPinTarget",
    "FabricLastAckedSlot",
    "FabricLocale",
    "FabricMulticastPolicy",
    "FabricNetGroup",
    "FabricNetGroupRef",
    "FabricNetflowCollector",
    "FabricNetflowIPv4Addr",
    "FabricNetflowMonExporter",
    "FabricNetflowMonExporterRef",
    "FabricNetflowMonSession",
    "FabricNetflowMonSrcEp",
    "FabricNetflowMonSrcRef",
    "FabricNetflowMonitor",
    "FabricNetflowMonitorRef",
    "FabricNetflowTimeoutPolicy",
    "FabricOrgVlanPolicy",
    "FabricPath",
    "FabricPathConn",
    "FabricPathEp",
    "FabricPoolableVlan",
    "FabricPooledVlan",
    "FabricReservedVlan",
    "FabricReservedVlanFsm",
    "FabricReservedVlanFsmStage",
    "FabricReservedVlanFsmTask",
    "FabricSanCloud",
    "FabricSanCloudFsm",
    "FabricSanCloudFsmStage",
    "FabricSanCloudFsmTask",
    "FabricSanGroup",
    "FabricSanGroupRef",
    "FabricSanMonCloud",
    "FabricSanPinGroup",
    "FabricSanPinTarget",
    "FabricSubGroup",
    "FabricSwChPhEp",
    "FabricSwSubGroup",
    "FabricUdldLinkPolicy",
    "FabricUdldPolicy",
    "FabricVCon",
    "FabricVConProfile",
    "FabricVlan",
    "FabricVlanEp",
    "FabricVlanGroupPermit",
    "FabricVlanGroupReq",
    "FabricVlanPermit",
    "FabricVlanReq",
    "FabricVnetEpSyncEp",
    "FabricVnetEpSyncEpFsm",
    "FabricVnetEpSyncEpFsmStage",
    "FabricVnetEpSyncEpFsmTask",
    "FabricVsan",
    "FabricVsanEp",
    "FabricVsanMembership",
    "FabricZoneIdUniverse",
    "FaultAffectedClass",
    "FaultHolder",
    "FaultInst",
    "FaultLocalTypedHolder",
    "FaultPolicy",
    "FaultSuppressPolicy",
    "FaultSuppressPolicyItem",
    "FaultSuppressTask",
    "FcErrStats",
    "FcErrStatsHist",
    "FcNicIfConfig",
    "FcPIo",
    "FcPIoFsm",
    "FcPIoFsmStage",
    "FcStats",
    "FcStatsHist",
    "FcSwIfConfig",
    "FcpoolAddr",
    "FcpoolBlock",
    "FcpoolBootTarget",
    "FcpoolFormat",
    "FcpoolInitiator",
    "FcpoolInitiatorEp",
    "FcpoolInitiators",
    "FcpoolOui",
    "FcpoolOuis",
    "FcpoolOuisFsm",
    "FcpoolOuisFsmStage",
    "FcpoolOuisFsmTask",
    "FcpoolPoolable",
    "FcpoolUniverse",
    "FeatureContextEp",
    "FeatureDefinition",
    "FeatureDefinitionInstance",
    "FeatureDefinitionRef",
    "FeatureFruCapProviderInstance",
    "FeatureFruCapProviderRef",
    "FeatureProvider",
    "FeatureProviderInstance",
    "FirmwareAck",
    "FirmwareActivity",
    "FirmwareActivityTrigger",
    "FirmwareAutoSyncPolicy",
    "FirmwareBackupVersionHolder",
    "FirmwareBlade",
    "FirmwareBootDefinition",
    "FirmwareBootUnit",
    "FirmwareBundleInfo",
    "FirmwareBundleInfoDigest",
    "FirmwareBundleType",
    "FirmwareBundleTypeCapProvider",
    "FirmwareCatalogPack",
    "FirmwareCatalogue",
    "FirmwareChassisComponentSpec",
    "FirmwareChassisPack",
    "FirmwareChassisPackModImpact",
    "FirmwareCompSource",
    "FirmwareCompTarget",
    "FirmwareComponentSpec",
    "FirmwareComputeHostPack",
    "FirmwareComputeMgmtPack",
    "FirmwareConnectionManagementChassisConstraint",
    "FirmwareConstraints",
    "FirmwareDependency",
    "FirmwareDistImage",
    "FirmwareDistributable",
    "FirmwareDistributableFsm",
    "FirmwareDistributableFsmStage",
    "FirmwareDistributableFsmTask",
    "FirmwareDownloader",
    "FirmwareDownloaderFsm",
    "FirmwareDownloaderFsmStage",
    "FirmwareDownloaderFsmTask",
    "FirmwareDriveSecurityConstraint",
    "FirmwareDualVicChassisConstraint",
    "FirmwareDualVicServerConstraint",
    "FirmwareExcludeChassisComponent",
    "FirmwareExcludeServerComponent",
    "FirmwareFileUnit",
    "FirmwareHost",
    "FirmwareHostPackModImpact",
    "FirmwareImage",
    "FirmwareImageFsm",
    "FirmwareImageFsmStage",
    "FirmwareImageFsmTask",
    "FirmwareImageLock",
    "FirmwareInfra",
    "FirmwareInfraPack",
    "FirmwareInstallImpact",
    "FirmwareInstallable",
    "FirmwareModule",
    "FirmwarePCHStorageConfigConstraint",
    "FirmwarePackItem",
    "FirmwarePlatformBundleTypeCapProvider",
    "FirmwareProcessorTypeConstraint",
    "FirmwareRack",
    "FirmwareRackPowerCapConstraint",
    "FirmwareRunning",
    "FirmwareSecondControllerChassisConstraint",
    "FirmwareSecondControllerServerConstraint",
    "FirmwareSecureFPGA",
    "FirmwareServerChassisConstraint",
    "FirmwareServerTypeConstraint",
    "FirmwareServicePack",
    "FirmwareSinglePathChassisConstraint",
    "FirmwareSpec",
    "FirmwareStatus",
    "FirmwareSystem",
    "FirmwareSystemCompCheckResult",
    "FirmwareSystemFsm",
    "FirmwareSystemFsmStage",
    "FirmwareSystemFsmTask",
    "FirmwareTPMConstraint",
    "FirmwareType",
    "FirmwareUcscInfo",
    "FirmwareUpdatable",
    "FirmwareUpgradeConstraint",
    "FirmwareUpgradeDetail",
    "FirmwareUpgradeInfo",
    "FirmwareVicSlotConstraint",
    "FirmwareVnicCdnConstraint",
    "FirmwareWaterbaySiocServerConstraint",
    "FlowctrlDefinition",
    "FlowctrlItem",
    "FsmStatus",
    "GmetaClass",
    "GmetaEp",
    "GmetaHolder",
    "GmetaHolderFsm",
    "GmetaHolderFsmStage",
    "GmetaHolderFsmTask",
    "GmetaPolicyMapElement",
    "GmetaPolicyMapHolder",
    "GmetaProp",
    "GraphicsCard",
    "GraphicsController",
    "HostimgPolicy",
    "HostimgTarget",
    "IdentIdentCtx",
    "IdentIdentRequest",
    "IdentIdentRequestFsm",
    "IdentIdentRequestFsmStage",
    "IdentIdentRequestFsmTask",
    "IdentMetaSystem",
    "IdentMetaSystemFsm",
    "IdentMetaSystemFsmStage",
    "IdentMetaSystemFsmTask",
    "IdentMetaVerse",
    "IdentRequestEp",
    "IdentSysInfo",
    "ImgprovPolicy",
    "ImgprovTarget",
    "ImgsecKey",
    "ImgsecPolicy",
    "InitiatorFcInitiatorEp",
    "InitiatorGroupEp",
    "InitiatorIScsiInitiatorEp",
    "InitiatorLunEp",
    "InitiatorMemberEp",
    "InitiatorRequestorEp",
    "InitiatorRequestorGrpEp",
    "InitiatorStoreEp",
    "InitiatorUnitEp",
    "IpDnsSuffix",
    "IpIPv4Dns",
    "IpIPv4WinsServer",
    "IpIpV4StaticAddr",
    "IpIpV4StaticTargetAddr",
    "IpServiceIf",
    "IppoolAddr",
    "IppoolBlock",
    "IppoolIpV6Addr",
    "IppoolIpV6Block",
    "IppoolIpV6Pooled",
    "IppoolPool",
    "IppoolPoolable",
    "IppoolPooled",
    "IppoolUniverse",
    "IqnpoolAddr",
    "IqnpoolBlock",
    "IqnpoolFormat",
    "IqnpoolPool",
    "IqnpoolPoolable",
    "IqnpoolPooled",
    "IqnpoolTransportBlock",
    "IqnpoolUniverse",
    "IscsiAuthProfile",
    "LicenseContents",
    "LicenseDownloader",
    "LicenseDownloaderFsm",
    "LicenseDownloaderFsmStage",
    "LicenseDownloaderFsmTask",
    "LicenseEp",
    "LicenseFeature",
    "LicenseFeatureCapProvider",
    "LicenseFeatureLine",
    "LicenseFile",
    "LicenseFileFsm",
    "LicenseFileFsmStage",
    "LicenseFileFsmTask",
    "LicenseInstance",
    "LicenseInstanceFsm",
    "LicenseInstanceFsmStage",
    "LicenseInstanceFsmTask",
    "LicenseProp",
    "LicenseServerHostId",
    "LicenseSource",
    "LicenseSourceFile",
    "LicenseTarget",
    "LldpAcquired",
    "LsAgentPolicy",
    "LsBinding",
    "LsFcLocale",
    "LsFcZone",
    "LsFcZoneGroup",
    "LsIdentityInfo",
    "LsIssues",
    "LsPower",
    "LsRequirement",
    "LsServer",
    "LsServerAssocCtx",
    "LsServerExtension",
    "LsServerFsm",
    "LsServerFsmStage",
    "LsServerFsmTask",
    "LsTier",
    "LsUuidHistory",
    "LsVConAssign",
    "LsVersionBeh",
    "LsZoneInitiatorMember",
    "LsZoneTargetMember",
    "LsbootBootSecurity",
    "LsbootDef",
    "LsbootDefaultLocalImage",
    "LsbootEFIShell",
    "LsbootEmbeddedLocalDiskImage",
    "LsbootEmbeddedLocalDiskImagePath",
    "LsbootEmbeddedLocalLunImage",
    "LsbootIScsi",
    "LsbootIScsiImagePath",
    "LsbootLan",
    "LsbootLanImagePath",
    "LsbootLocalDiskImage",
    "LsbootLocalDiskImagePath",
    "LsbootLocalHddImage",
    "LsbootLocalLunImagePath",
    "LsbootLocalStorage",
    "LsbootNvme",
    "LsbootNvmeDiskSsd",
    "LsbootNvmePciSsd",
    "LsbootPolicy",
    "LsbootSan",
    "LsbootSanCatSanImage",
    "LsbootSanCatSanImagePath",
    "LsbootSanImage",
    "LsbootSanImagePath",
    "LsbootStorage",
    "LsbootUEFIBootParam",
    "LsbootUsbExternalImage",
    "LsbootUsbFlashStorageImage",
    "LsbootUsbInternalImage",
    "LsbootVirtualMedia",
    "LsmaintAck",
    "LsmaintMaintPolicy",
    "LstorageControllerDef",
    "LstorageControllerModeConfig",
    "LstorageControllerQualifier",
    "LstorageControllerRef",
    "LstorageDasScsiLun",
    "LstorageDiskGroupConfigDef",
    "LstorageDiskGroupConfigPolicy",
    "LstorageDiskGroupQualifier",
    "LstorageDiskSlot",
    "LstorageDiskZoningConfigDef",
    "LstorageDiskZoningPolicy",
    "LstorageDriveSecurity",
    "LstorageLocal",
    "LstorageLocalDef",
    "LstorageLocalDiskConfigRef",
    "LstorageLocalDiskRef",
    "LstorageLogin",
    "LstorageLunSetConfig",
    "LstorageLunSetDiskSlot",
    "LstorageProfile",
    "LstorageProfileBinding",
    "LstorageProfileDef",
    "LstorageRemote",
    "LstorageRemoteDef",
    "LstorageSasExpanderConfigPolicy",
    "LstorageSecurity",
    "LstorageVirtualDriveDef",
    "MacpoolAddr",
    "MacpoolBlock",
    "MacpoolFormat",
    "MacpoolPool",
    "MacpoolPoolable",
    "MacpoolPooled",
    "MacpoolUniverse",
    "MemoryArray",
    "MemoryArrayEnvStats",
    "MemoryArrayEnvStatsHist",
    "MemoryBufferUnit",
    "MemoryBufferUnitEnvStats",
    "MemoryBufferUnitEnvStatsHist",
    "MemoryErrorStats",
    "MemoryPersistentMemoryConfigResult",
    "MemoryPersistentMemoryConfiguration",
    "MemoryPersistentMemoryGoal",
    "MemoryPersistentMemoryLocalSecurity",
    "MemoryPersistentMemoryLogicalNamespace",
    "MemoryPersistentMemoryNamespace",
    "MemoryPersistentMemoryNamespaceConfigResult",
    "MemoryPersistentMemoryPolicy",
    "MemoryPersistentMemoryRegion",
    "MemoryPersistentMemorySecurity",
    "MemoryPersistentMemoryUnit",
    "MemoryQual",
    "MemoryRuntime",
    "MemoryRuntimeHist",
    "MemoryUnit",
    "MemoryUnitEnvStats",
    "MemoryUnitEnvStatsHist",
    "MgmtAccessPolicy",
    "MgmtAccessPolicyItem",
    "MgmtAccessPort",
    "MgmtBackup",
    "MgmtBackupExportExtPolicy",
    "MgmtBackupFsm",
    "MgmtBackupFsmStage",
    "MgmtBackupFsmTask",
    "MgmtBackupPolicy",
    "MgmtBackupPolicyConfig",
    "MgmtBackupPolicyFsm",
    "MgmtBackupPolicyFsmStage",
    "MgmtCfgExportPolicy",
    "MgmtCfgExportPolicyFsm",
    "MgmtCfgExportPolicyFsmStage",
    "MgmtCimcSecureBoot",
    "MgmtCmcSecureBoot",
    "MgmtConnection",
    "MgmtController",
    "MgmtControllerFsm",
    "MgmtControllerFsmStage",
    "MgmtControllerFsmTask",
    "MgmtDbState",
    "MgmtEntity",
    "MgmtExportPolicyFsm",
    "MgmtExportPolicyFsmStage",
    "MgmtExportPolicyFsmTask",
    "MgmtHealthAttr",
    "MgmtHealthStatus",
    "MgmtIPv6IfAddr",
    "MgmtIPv6IfAddrFsm",
    "MgmtIPv6IfAddrFsmStage",
    "MgmtIPv6IfAddrFsmTask",
    "MgmtIPv6IfConfig",
    "MgmtIf",
    "MgmtIfFsm",
    "MgmtIfFsmStage",
    "MgmtIfFsmTask",
    "MgmtImporter",
    "MgmtImporterFsm",
    "MgmtImporterFsmStage",
    "MgmtImporterFsmTask",
    "MgmtInbandProfile",
    "MgmtIntAuthPolicy",
    "MgmtInterface",
    "MgmtKmip",
    "MgmtKmipCertPolicy",
    "MgmtKvmCertificate",
    "MgmtLeaderEntity",
    "MgmtPmonEntry",
    "MgmtProfDerivedInterface",
    "MgmtSecurity",
    "MgmtSpdmCertificate",
    "MgmtSpdmCertificateData",
    "MgmtSpdmCertificateInventory",
    "MgmtSpdmCertificatePolicy",
    "MgmtSwPersonalities",
    "MgmtSwPersonalitiesInventory",
    "MgmtSwPersonality",
    "MgmtUsbNicMgmtIf",
    "MgmtVnet",
    "MoInvKv",
    "MoIpV4AddrKv",
    "MoIpV6AddrKv",
    "MoKv",
    "MoKvCfgHolder",
    "MoKvInvHolder",
    "MoVnicKv",
    "MorefFruRef",
    "MorefImportRoot",
    "MorefImportRootFsm",
    "MorefImportRootFsmStage",
    "MorefImportRootFsmTask",
    "MorefProp",
    "MorefRef",
    "NetworkElement",
    "NetworkIfStats",
    "NetworkLanNeighborEntry",
    "NetworkLanNeighbors",
    "NetworkLimit",
    "NetworkLldpNeighborEntry",
    "NetworkLldpNeighbors",
    "NetworkOperLevel",
    "NetworkSanNeighborEntry",
    "NetworkSanNeighbors",
    "NfsEp",
    "NfsMountDef",
    "NfsMountDefFsm",
    "NfsMountDefFsmStage",
    "NfsMountDefFsmTask",
    "NfsMountInst",
    "NfsMountInstFsm",
    "NfsMountInstFsmStage",
    "NfsMountInstFsmTask",
    "NwctrlDefinition",
    "ObserveFilter",
    "ObserveObserved",
    "ObserveObservedCont",
    "ObserveObservedFsm",
    "ObserveObservedFsmStage",
    "ObserveObservedFsmTask",
    "OrgOrg",
    "OrgSourceMask",
    "OsARPLinkMonitoringPolicy",
    "OsARPTarget",
    "OsAgent",
    "OsEthBondIntf",
    "OsEthBondModeActiveBackup",
    "OsEthBondModeBalancedALB",
    "OsEthBondModeBalancedRR",
    "OsEthBondModeBalancedTLB",
    "OsEthBondModeBalancedXOR",
    "OsEthBondModeBroadcast",
    "OsEthIntf",
    "OsInstance",
    "OsMiiLinkMonitoringPolicy",
    "OsPrimarySlave",
    "PciEquipSlot",
    "PciLink",
    "PciSwitch",
    "PciUnit",
    "PfcWatchDog",
    "PfcWatchDogFsm",
    "PfcWatchDogFsmStage",
    "PfcWatchDogFsmTask",
    "PkiCertReq",
    "PkiEp",
    "PkiEpFsm",
    "PkiEpFsmStage",
    "PkiEpFsmTask",
    "PkiKeyRing",
    "PkiTP",
    "PolicyCentraleSync",
    "PolicyChildClass",
    "PolicyCommunication",
    "PolicyConfigBackup",
    "PolicyConfigError",
    "PolicyContext",
    "PolicyControlEp",
    "PolicyControlEpFsm",
    "PolicyControlEpFsmStage",
    "PolicyControlEpFsmTask",
    "PolicyControlledInstance",
    "PolicyControlledType",
    "PolicyControlledTypeFsm",
    "PolicyControlledTypeFsmStage",
    "PolicyControlledTypeFsmTask",
    "PolicyDateTime",
    "PolicyDestClass",
    "PolicyDestEp",
    "PolicyDigest",
    "PolicyDiscovery",
    "PolicyDns",
    "PolicyElement",
    "PolicyEquipment",
    "PolicyFault",
    "PolicyIdResolvePolicy",
    "PolicyInfraFirmware",
    "PolicyLocalMap",
    "PolicyMEp",
    "PolicyMonitoring",
    "PolicyPolicyDestClass",
    "PolicyPolicyEp",
    "PolicyPolicyRequestor",
    "PolicyPolicyScope",
    "PolicyPolicyScopeCont",
    "PolicyPolicyScopeContFsm",
    "PolicyPolicyScopeContFsmStage",
    "PolicyPolicyScopeContFsmTask",
    "PolicyPolicyScopeContext",
    "PolicyPolicyScopeFsm",
    "PolicyPolicyScopeFsmStage",
    "PolicyPolicyScopeFsmTask",
    "PolicyPortConfig",
    "PolicyPowerMgmt",
    "PolicyPsu",
    "PolicyRefReq",
    "PolicyRequestor",
    "PolicyRequestorFsm",
    "PolicyRequestorFsmStage",
    "PolicyRequestorFsmTask",
    "PolicyScope",
    "PolicySecurity",
    "PolicySourceApp",
    "PolicyStorageAutoConfig",
    "PolicySystemEp",
    "PortDomainEp",
    "PortGroup",
    "PortPIoFsm",
    "PortPIoFsmStage",
    "PortPIoFsmTask",
    "PortSubGroup",
    "PortTrustMode",
    "PowerBudget",
    "PowerChassisMember",
    "PowerEp",
    "PowerFIMember",
    "PowerFexMember",
    "PowerGroup",
    "PowerGroupAdditionPolicy",
    "PowerGroupQual",
    "PowerGroupStats",
    "PowerGroupStatsHist",
    "PowerMgmtPolicy",
    "PowerPlacement",
    "PowerPolicy",
    "PowerPrioWght",
    "PowerProfiledPower",
    "PowerRackUnitMember",
    "ProcDoer",
    "ProcManager",
    "ProcPrt",
    "ProcPrtCounts",
    "ProcStimulusCounts",
    "ProcSvc",
    "ProcTxCounts",
    "ProcessorCacheMemStats",
    "ProcessorCore",
    "ProcessorEnvStats",
    "ProcessorEnvStatsHist",
    "ProcessorErrorStats",
    "ProcessorExecStats",
    "ProcessorIOStats",
    "ProcessorMiscStats",
    "ProcessorPCIBusStats",
    "ProcessorPMUStats",
    "ProcessorQual",
    "ProcessorRuntime",
    "ProcessorRuntimeHist",
    "ProcessorSecurityStats",
    "ProcessorThread",
    "ProcessorUnit",
    "ProcessorUnitAssocCtx",
    "QosclassDefinition",
    "QosclassDefinitionFsm",
    "QosclassDefinitionFsmStage",
    "QosclassDefinitionFsmTask",
    "QosclassEthBE",
    "QosclassEthClassified",
    "QosclassFc",
    "QosclassSlowDrain",
    "QosclassSlowDrainFsm",
    "QosclassSlowDrainFsmStage",
    "QosclassSlowDrainFsmTask",
    "QueryresultDependency",
    "QueryresultUsage",
    "SecurityUnit",
    "SesDiskSlotEp",
    "SesEnclosure",
    "SolConfig",
    "SolIf",
    "SolPolicy",
    "StatsCollectionPolicy",
    "StatsCollectionPolicyFsm",
    "StatsCollectionPolicyFsmStage",
    "StatsCollectionPolicyFsmTask",
    "StatsHolder",
    "StatsThr32Definition",
    "StatsThr32Value",
    "StatsThr64Definition",
    "StatsThr64Value",
    "StatsThrFloatDefinition",
    "StatsThrFloatValue",
    "StatsThresholdClass",
    "StatsThresholdPolicy",
    "StorageAuthKey",
    "StorageConnectionDef",
    "StorageConnectionPolicy",
    "StorageController",
    "StorageControllerEp",
    "StorageControllerRef",
    "StorageControllerReference",
    "StorageDiskEnvStats",
    "StorageDiskEnvStatsHist",
    "StorageDomainEp",
    "StorageDrive",
    "StorageEmbeddedStorage",
    "StorageEnclosure",
    "StorageEnclosureCap",
    "StorageEnclosureDiskSlotEp",
    "StorageEnclosureFsm",
    "StorageEnclosureFsmStage",
    "StorageEnclosureFsmTask",
    "StorageEnclosureLocalDiskConfig",
    "StorageEpUser",
    "StorageEtherIf",
    "StorageFcIf",
    "StorageFcTargetEp",
    "StorageFcTargetIf",
    "StorageFlexFlashCard",
    "StorageFlexFlashController",
    "StorageFlexFlashControllerFsm",
    "StorageFlexFlashControllerFsmStage",
    "StorageFlexFlashControllerFsmTask",
    "StorageFlexFlashDrive",
    "StorageFlexFlashVirtualDrive",
    "StorageHddMotherBoardTempStats",
    "StorageHddMotherBoardTempStatsHist",
    "StorageIScsiTargetIf",
    "StorageIniGroup",
    "StorageInitiator",
    "StorageItem",
    "StorageLocalDisk",
    "StorageLocalDiskConfigDef",
    "StorageLocalDiskConfigPolicy",
    "StorageLocalDiskEp",
    "StorageLocalDiskFsm",
    "StorageLocalDiskFsmStage",
    "StorageLocalDiskFsmTask",
    "StorageLocalDiskPartition",
    "StorageLocalDiskSlotEp",
    "StorageLocalLun",
    "StorageLunDisk",
    "StorageLunResourceSelectionLog",
    "StorageMezzFlashLife",
    "StorageMiniStorage",
    "StorageNodeEp",
    "StorageNvmeStats",
    "StorageNvmeStatsHist",
    "StorageNvmeStorage",
    "StorageNvmeSwitch",
    "StorageOnboardDevice",
    "StorageOperation",
    "StorageQual",
    "StorageRaidBattery",
    "StorageSasExpander",
    "StorageSasLinkDescriptor",
    "StorageSasPort",
    "StorageSasPortDescriptor",
    "StorageSasUpLink",
    "StorageScsiLunRef",
    "StorageSsdHealthStats",
    "StorageSsdHealthStatsHist",
    "StorageSystem",
    "StorageSystemFsm",
    "StorageSystemFsmStage",
    "StorageSystemFsmTask",
    "StorageTransportableFlashModule",
    "StorageVDMemberEp",
    "StorageVirtualDrive",
    "StorageVirtualDriveContainer",
    "StorageVirtualDriveEp",
    "StorageVirtualDriveRef",
    "StorageVsanRef",
    "SwAccessDomain",
    "SwAccessDomainFsm",
    "SwAccessDomainFsmStage",
    "SwAccessDomainFsmTask",
    "SwAccessEp",
    "SwCardEnvStats",
    "SwCardEnvStatsHist",
    "SwCmclan",
    "SwEnvStats",
    "SwEnvStatsHist",
    "SwEthEstcEp",
    "SwEthEstcPc",
    "SwEthLanBorder",
    "SwEthLanBorderFsm",
    "SwEthLanBorderFsmStage",
    "SwEthLanBorderFsmTask",
    "SwEthLanEp",
    "SwEthLanFlowMon",
    "SwEthLanFlowMonFsm",
    "SwEthLanFlowMonFsmStage",
    "SwEthLanFlowMonFsmTask",
    "SwEthLanMon",
    "SwEthLanPc",
    "SwEthMon",
    "SwEthMonDestEp",
    "SwEthMonFsm",
    "SwEthMonFsmStage",
    "SwEthMonFsmTask",
    "SwEthMonSrcEp",
    "SwEthTargetEp",
    "SwEtherPort",
    "SwExtUtility",
    "SwExtUtilityFsm",
    "SwExtUtilityFsmStage",
    "SwExtUtilityFsmTask",
    "SwFabricZoneNs",
    "SwFabricZoneNsOverride",
    "SwFcEndpoint",
    "SwFcEstcEp",
    "SwFcMon",
    "SwFcMonDestEp",
    "SwFcMonFsm",
    "SwFcMonFsmStage",
    "SwFcMonFsmTask",
    "SwFcMonSrcEp",
    "SwFcSanBorder",
    "SwFcSanBorderFsm",
    "SwFcSanBorderFsmStage",
    "SwFcSanBorderFsmTask",
    "SwFcSanEp",
    "SwFcSanMon",
    "SwFcSanPc",
    "SwFcServerZoneGroup",
    "SwFcUserZone",
    "SwFcUserZoneGroup",
    "SwFcZone",
    "SwFcZoneSet",
    "SwFcoeEstcEp",
    "SwFcoeSanEp",
    "SwFcoeSanPc",
    "SwIpRoute",
    "SwNFExporterRef",
    "SwNetflowExporter",
    "SwNetflowMonSession",
    "SwNetflowMonitor",
    "SwNetflowMonitorRef",
    "SwNetflowRecordDef",
    "SwPhys",
    "SwPhysEtherEp",
    "SwPhysFcEp",
    "SwPhysFsm",
    "SwPhysFsmStage",
    "SwPhysFsmTask",
    "SwPortBreakout",
    "SwPortDiscover",
    "SwPortDiscoverFsm",
    "SwPortDiscoverFsmStage",
    "SwPortDiscoverFsmTask",
    "SwSubGroup",
    "SwSystemStats",
    "SwSystemStatsHist",
    "SwUlan",
    "SwUtilityDomain",
    "SwUtilityDomainFsm",
    "SwUtilityDomainFsmStage",
    "SwUtilityDomainFsmTask",
    "SwVIFRef",
    "SwVirtL3Intf",
    "SwVlan",
    "SwVlanGroup",
    "SwVlanPortNs",
    "SwVlanPortNsOverride",
    "SwVlanRef",
    "SwVsan",
    "SwZoneInitiatorMember",
    "SwZoneTargetMember",
    "SwatAction",
    "SwatCondition",
    "SwatInjection",
    "SwatResultstats",
    "SwatTarget",
    "SwatTrigger",
    "SyntheticDirectory",
    "SyntheticFile",
    "SyntheticFileSystem",
    "SyntheticFsObj",
    "SyntheticFsObjFsm",
    "SyntheticFsObjFsmStage",
    "SyntheticFsObjFsmTask",
    "SyntheticTime",
    "SysdebugAutoCoreFileExportTarget",
    "SysdebugAutoCoreFileExportTargetFsm",
    "SysdebugAutoCoreFileExportTargetFsmStage",
    "SysdebugAutoCoreFileExportTargetFsmTask",
    "SysdebugBackupBehavior",
    "SysdebugCore",
    "SysdebugCoreFileRepository",
    "SysdebugCoreFsm",
    "SysdebugCoreFsmStage",
    "SysdebugCoreFsmTask",
    "SysdebugDiagnosticLog",
    "SysdebugDiagnosticLogRepository",
    "SysdebugEp",
    "SysdebugLogControlDestinationFile",
    "SysdebugLogControlDestinationSyslog",
    "SysdebugLogControlDomain",
    "SysdebugLogControlEp",
    "SysdebugLogControlEpFsm",
    "SysdebugLogControlEpFsmStage",
    "SysdebugLogControlEpFsmTask",
    "SysdebugLogControlModule",
    "SysdebugLogExportPolicy",
    "SysdebugLogExportPolicyFsm",
    "SysdebugLogExportPolicyFsmStage",
    "SysdebugLogExportPolicyFsmTask",
    "SysdebugLogExportStatus",
    "SysdebugMEpLog",
    "SysdebugMEpLogPolicy",
    "SysdebugManualCoreFileExportTarget",
    "SysdebugManualCoreFileExportTargetFsm",
    "SysdebugManualCoreFileExportTargetFsmStage",
    "SysdebugManualCoreFileExportTargetFsmTask",
    "SysdebugTechSupFileRepository",
    "SysdebugTechSupport",
    "SysdebugTechSupportCmdOpt",
    "SysdebugTechSupportFsm",
    "SysdebugTechSupportFsmStage",
    "SysdebugTechSupportFsmTask",
    "SysfileDigest",
    "SysfileMutation",
    "SysfileMutationFsm",
    "SysfileMutationFsmStage",
    "SysfileMutationFsmTask",
    "TopInfoPolicy",
    "TopInfoSyncPolicy",
    "TopMetaInf",
    "TopRoot",
    "TopSysDefaults",
    "TopSystem",
    "TrigAbsWindow",
    "TrigClientToken",
    "TrigLocalAbsWindow",
    "TrigLocalSched",
    "TrigMeta",
    "TrigRecurrWindow",
    "TrigSched",
    "TrigTest",
    "TrigTriggered",
    "UuidpoolAddr",
    "UuidpoolBlock",
    "UuidpoolFormat",
    "UuidpoolPool",
    "UuidpoolPoolable",
    "UuidpoolPooled",
    "UuidpoolUniverse",
    "VersionApplication",
    "VersionEp",
    "VmComputeEp",
    "VmDC",
    "VmDCOrg",
    "VmEp",
    "VmHba",
    "VmHv",
    "VmInstance",
    "VmLifeCyclePolicy",
    "VmLifeCyclePolicyFsm",
    "VmLifeCyclePolicyFsmStage",
    "VmLifeCyclePolicyFsmTask",
    "VmNic",
    "VmOrg",
    "VmSwitch",
    "VmVif",
    "VmVlan",
    "VmVnicProfCl",
    "VmVnicProfInst",
    "VmVsan",
    "VnicBootIpPolicy",
    "VnicBootTarget",
    "VnicConnDef",
    "VnicDefBeh",
    "VnicDynamicCon",
    "VnicDynamicConPolicy",
    "VnicDynamicConPolicyRef",
    "VnicDynamicIdUniverse",
    "VnicDynamicProvider",
    "VnicDynamicProviderEp",
    "VnicEthConfig",
    "VnicEthLif",
    "VnicEther",
    "VnicEtherIf",
    "VnicFc",
    "VnicFcGroupDef",
    "VnicFcGroupTempl",
    "VnicFcIf",
    "VnicFcLif",
    "VnicFcNode",
    "VnicFcOEIf",
    "VnicIPv4Dhcp",
    "VnicIPv4Dns",
    "VnicIPv4If",
    "VnicIPv4IscsiAddr",
    "VnicIPv4PooledIscsiAddr",
    "VnicIPv4StaticRoute",
    "VnicIPv6If",
    "VnicIScsi",
    "VnicIScsiAutoTargetIf",
    "VnicIScsiBootParams",
    "VnicIScsiBootVnic",
    "VnicIScsiConfig",
    "VnicIScsiInitAutoConfigPolicy",
    "VnicIScsiLCP",
    "VnicIScsiNode",
    "VnicIScsiStaticTargetIf",
    "VnicInternalProfile",
    "VnicIpV4History",
    "VnicIpV4MgmtPooledAddr",
    "VnicIpV4PooledAddr",
    "VnicIpV4ProfDerivedAddr",
    "VnicIpV4StaticAddr",
    "VnicIpV6History",
    "VnicIpV6MgmtPooledAddr",
    "VnicIpV6StaticAddr",
    "VnicIpc",
    "VnicIpcIf",
    "VnicIqnHistory",
    "VnicLanConnPolicy",
    "VnicLanConnTempl",
    "VnicLifVlan",
    "VnicLifVsan",
    "VnicLun",
    "VnicMacHistory",
    "VnicOProfileAlias",
    "VnicProfile",
    "VnicProfileAlias",
    "VnicProfileRef",
    "VnicProfileSet",
    "VnicProfileSetFsm",
    "VnicProfileSetFsmStage",
    "VnicProfileSetFsmTask",
    "VnicRackServerDiscoveryProfile",
    "VnicSanConnPolicy",
    "VnicSanConnTempl",
    "VnicScsi",
    "VnicScsiIf",
    "VnicUsnicConPolicy",
    "VnicUsnicConPolicyRef",
    "VnicVhbaBehPolicy",
    "VnicVlan",
    "VnicVmqConPolicy",
    "VnicVmqConPolicyRef",
    "VnicVnicBehPolicy",
    "VnicWwnnHistory",
    "VnicWwpnHistory",
    ])

MO_CLASS_META = {
    "AaaAuthRealm": MoMeta("AaaAuthRealm", "aaaAuthRealm", "auth-realm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaAuthRealmFsm', 'aaaConsoleAuth', 'aaaDefaultAuth', 'aaaDomain', 'aaaRealmFsm', 'aaaRealmFsmTask', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaAuthRealmFsm": MoMeta("AaaAuthRealmFsm", "aaaAuthRealmFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], ['aaaAuthRealmFsmStage'], [None]),
    "AaaAuthRealmFsmStage": MoMeta("AaaAuthRealmFsmStage", "aaaAuthRealmFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealmFsm'], [], [None]),
    "AaaCimcSession": MoMeta("AaaCimcSession", "aaaCimcSession", "cimc-term-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['aaaEpUser', 'aaaRemoteUser', 'aaaUser', 'commSnmpUser', 'storageEpUser'], [], ["Get", "Set"]),
    "AaaConsoleAuth": MoMeta("AaaConsoleAuth", "aaaConsoleAuth", "console-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaAuthRealm'], ['faultInst'], ["Get", "Set"]),
    "AaaDefaultAuth": MoMeta("AaaDefaultAuth", "aaaDefaultAuth", "default-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaAuthRealm'], ['faultInst'], ["Get", "Set"]),
    "AaaDomain": MoMeta("AaaDomain", "aaaDomain", "domain-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaAuthRealm'], ['aaaDomainAuth', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainAuth": MoMeta("AaaDomainAuth", "aaaDomainAuth", "domain-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaDomain'], ['faultInst'], ["Get", "Set"]),
    "AaaEpAuthProfile": MoMeta("AaaEpAuthProfile", "aaaEpAuthProfile", "auth-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'orgOrg'], ['aaaEpUser'], ["Add", "Get", "Remove", "Set"]),
    "AaaEpFsm": MoMeta("AaaEpFsm", "aaaEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], ['aaaEpFsmStage'], [None]),
    "AaaEpFsmStage": MoMeta("AaaEpFsmStage", "aaaEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaEpFsm'], [], [None]),
    "AaaEpFsmTask": MoMeta("AaaEpFsmTask", "aaaEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], [], [None]),
    "AaaEpLogin": MoMeta("AaaEpLogin", "aaaEpLogin", "ep-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], ["Get"]),
    "AaaEpUser": MoMeta("AaaEpUser", "aaaEpUser", "user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], ['aaaEpAuthProfile', 'computeServerUnit'], ['aaaCimcSession'], ["Add", "Get", "Remove", "Set"]),
    "AaaExtMgmtCutThruTkn": MoMeta("AaaExtMgmtCutThruTkn", "aaaExtMgmtCutThruTkn", "-[token]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], [], ["Get"]),
    "AaaLdapEp": MoMeta("AaaLdapEp", "aaaLdapEp", "ldap-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaLdapEpFsm', 'aaaLdapGroup', 'aaaLdapGroupRule', 'aaaLdapProvider', 'aaaProviderGroup', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaLdapEpFsm": MoMeta("AaaLdapEpFsm", "aaaLdapEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaLdapEp'], ['aaaLdapEpFsmStage'], [None]),
    "AaaLdapEpFsmStage": MoMeta("AaaLdapEpFsmStage", "aaaLdapEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaLdapEpFsm'], [], [None]),
    "AaaLdapGroup": MoMeta("AaaLdapGroup", "aaaLdapGroup", "ldapgroup-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapEp'], ['aaaUserLocale', 'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapGroupRule": MoMeta("AaaLdapGroupRule", "aaaLdapGroupRule", "ldapgroup-rule", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapEp', 'aaaLdapProvider'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapProvider": MoMeta("AaaLdapProvider", "aaaLdapProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapEp'], ['aaaLdapGroupRule'], ["Add", "Get", "Remove", "Set"]),
    "AaaLocalMgmtCmdLog": MoMeta("AaaLocalMgmtCmdLog", "aaaLocalMgmtCmdLog", "", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "AaaLocale": MoMeta("AaaLocale", "aaaLocale", "locale-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], ['aaaOrg', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaLog": MoMeta("AaaLog", "aaaLog", "aaa-log", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "operations"], ['topRoot'], ['aaaModLR', 'aaaSessionLR'], ["Get"]),
    "AaaLoginProfile": MoMeta("AaaLoginProfile", "aaaLoginProfile", "login-profile", VersionMeta.Version401a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], [], [None]),
    "AaaModLR": MoMeta("AaaModLR", "aaaModLR", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['aaaLog'], [], ["Get"]),
    "AaaOrg": MoMeta("AaaOrg", "aaaOrg", "org-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLocale'], ['faultInst'], ["Add", "Get", "Remove"]),
    "AaaPreLoginBanner": MoMeta("AaaPreLoginBanner", "aaaPreLoginBanner", "pre-login-banner", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderGroup": MoMeta("AaaProviderGroup", "aaaProviderGroup", "providergroup-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], ['aaaProviderRef', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderRef": MoMeta("AaaProviderRef", "aaaProviderRef", "provider-ref-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaProviderGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaPwdProfile": MoMeta("AaaPwdProfile", "aaaPwdProfile", "pwd-profile", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], [], ["Get", "Set"]),
    "AaaRadiusEp": MoMeta("AaaRadiusEp", "aaaRadiusEp", "radius-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaProviderGroup', 'aaaRadiusEpFsm', 'aaaRadiusProvider', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaRadiusEpFsm": MoMeta("AaaRadiusEpFsm", "aaaRadiusEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaRadiusEp'], ['aaaRadiusEpFsmStage'], [None]),
    "AaaRadiusEpFsmStage": MoMeta("AaaRadiusEpFsmStage", "aaaRadiusEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaRadiusEpFsm'], [], [None]),
    "AaaRadiusProvider": MoMeta("AaaRadiusProvider", "aaaRadiusProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaRadiusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaRealmFsm": MoMeta("AaaRealmFsm", "aaaRealmFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], ['aaaRealmFsmStage'], [None]),
    "AaaRealmFsmStage": MoMeta("AaaRealmFsmStage", "aaaRealmFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaRealmFsm'], [], [None]),
    "AaaRealmFsmTask": MoMeta("AaaRealmFsmTask", "aaaRealmFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], [], [None]),
    "AaaRemoteUser": MoMeta("AaaRemoteUser", "aaaRemoteUser", "remoteuser-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], ['aaaCimcSession', 'aaaSession', 'aaaUserLocale', 'aaaUserRole'], ["Get", "Remove"]),
    "AaaRole": MoMeta("AaaRole", "aaaRole", "role-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaRemoteUser', 'aaaUser'], [], ["Get", "Remove"]),
    "AaaSessionInfo": MoMeta("AaaSessionInfo", "aaaSessionInfo", "term-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaSessionInfoTable'], [], [None]),
    "AaaSessionInfoTable": MoMeta("AaaSessionInfoTable", "aaaSessionInfoTable", "session-table", VersionMeta.Version212a, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaSessionInfo'], [None]),
    "AaaSessionLR": MoMeta("AaaSessionLR", "aaaSessionLR", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['aaaLog'], [], [None]),
    "AaaShellLogin": MoMeta("AaaShellLogin", "aaaShellLogin", "sh-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], [None]),
    "AaaSshAuth": MoMeta("AaaSshAuth", "aaaSshAuth", "sshauth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUser'], [], ["Get", "Set"]),
    "AaaTacacsPlusEp": MoMeta("AaaTacacsPlusEp", "aaaTacacsPlusEp", "tacacs-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaProviderGroup', 'aaaTacacsPlusEpFsm', 'aaaTacacsPlusProvider', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaTacacsPlusEpFsm": MoMeta("AaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaTacacsPlusEp'], ['aaaTacacsPlusEpFsmStage'], [None]),
    "AaaTacacsPlusEpFsmStage": MoMeta("AaaTacacsPlusEpFsmStage", "aaaTacacsPlusEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaTacacsPlusEpFsm'], [], [None]),
    "AaaTacacsPlusProvider": MoMeta("AaaTacacsPlusProvider", "aaaTacacsPlusProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaTacacsPlusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], ['aaaCimcSession', 'aaaSession', 'aaaSshAuth', 'aaaUserData', 'aaaUserLocale', 'aaaUserRole', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserData": MoMeta("AaaUserData", "aaaUserData", "user-data", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUser'], [], ["Get"]),
    "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaEpLogin', 'aaaExtMgmtCutThruTkn', 'aaaLocale', 'aaaLoginProfile', 'aaaPreLoginBanner', 'aaaPwdProfile', 'aaaRemoteUser', 'aaaRole', 'aaaShellLogin', 'aaaUser', 'aaaUserEpFsm', 'aaaUserEpFsmTask', 'aaaWebLogin', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaUserEpFsm": MoMeta("AaaUserEpFsm", "aaaUserEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaUserEp'], ['aaaUserEpFsmStage'], [None]),
    "AaaUserEpFsmStage": MoMeta("AaaUserEpFsmStage", "aaaUserEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['aaaUserEpFsm'], [], [None]),
    "AaaUserEpFsmTask": MoMeta("AaaUserEpFsmTask", "aaaUserEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['aaaUserEp'], [], [None]),
    "AaaUserLocale": MoMeta("AaaUserLocale", "aaaUserLocale", "locale-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapGroup', 'aaaRemoteUser', 'aaaUser'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserRole": MoMeta("AaaUserRole", "aaaUserRole", "role-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapGroup', 'aaaRemoteUser', 'aaaUser'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaWebLogin": MoMeta("AaaWebLogin", "aaaWebLogin", "web-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], ["Get"]),
    "AdaptorAzureQosProfile": MoMeta("AdaptorAzureQosProfile", "adaptorAzureQosProfile", "azure-qos", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], [None]),
    "AdaptorCapQual": MoMeta("AdaptorCapQual", "adaptorCapQual", "cap-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['adaptorQual'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorCapSpec": MoMeta("AdaptorCapSpec", "adaptorCapSpec", "cap-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorDiagCap": MoMeta("AdaptorDiagCap", "adaptorDiagCap", "diag", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorDynamicConfigCap": MoMeta("AdaptorDynamicConfigCap", "adaptorDynamicConfigCap", "cap-dynamic-config", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['adaptorFruCapProvider'], [], [None]),
    "AdaptorEthAdvFilterProfile": MoMeta("AdaptorEthAdvFilterProfile", "adaptorEthAdvFilterProfile", "eth-adv-filter", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorEthArfsProfile": MoMeta("AdaptorEthArfsProfile", "adaptorEthArfsProfile", "eth-arfs", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthFailoverProfile": MoMeta("AdaptorEthFailoverProfile", "adaptorEthFailoverProfile", "eth-failover", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthGENEVEProfile": MoMeta("AdaptorEthGENEVEProfile", "adaptorEthGENEVEProfile", "eth-geneve", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], [None]),
    "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthInterruptScalingProfile": MoMeta("AdaptorEthInterruptScalingProfile", "adaptorEthInterruptScalingProfile", "eth-interrupt-scaling", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorEthNVGREProfile": MoMeta("AdaptorEthNVGREProfile", "adaptorEthNVGREProfile", "eth-nvgre", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthPortBySizeLargeStats": MoMeta("AdaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStats", "eth-port-by-size-large-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortBySizeLargeStatsHist'], ["Get"]),
    "AdaptorEthPortBySizeLargeStatsHist": MoMeta("AdaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeLargeStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortBySizeLargeStats'], [], ["Get"]),
    "AdaptorEthPortBySizeSmallStats": MoMeta("AdaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStats", "eth-port-by-size-small-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortBySizeSmallStatsHist'], ["Get"]),
    "AdaptorEthPortBySizeSmallStatsHist": MoMeta("AdaptorEthPortBySizeSmallStatsHist", "adaptorEthPortBySizeSmallStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortBySizeSmallStats'], [], ["Get"]),
    "AdaptorEthPortErrStats": MoMeta("AdaptorEthPortErrStats", "adaptorEthPortErrStats", "eth-port-err-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortErrStatsHist'], ["Get"]),
    "AdaptorEthPortErrStatsHist": MoMeta("AdaptorEthPortErrStatsHist", "adaptorEthPortErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortErrStats'], [], ["Get"]),
    "AdaptorEthPortMcastStats": MoMeta("AdaptorEthPortMcastStats", "adaptorEthPortMcastStats", "eth-port-mcast-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortMcastStatsHist'], ["Get"]),
    "AdaptorEthPortMcastStatsHist": MoMeta("AdaptorEthPortMcastStatsHist", "adaptorEthPortMcastStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortMcastStats'], [], ["Get"]),
    "AdaptorEthPortOutsizedStats": MoMeta("AdaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStats", "eth-port-outsized-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortOutsizedStatsHist'], ["Get"]),
    "AdaptorEthPortOutsizedStatsHist": MoMeta("AdaptorEthPortOutsizedStatsHist", "adaptorEthPortOutsizedStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortOutsizedStats'], [], ["Get"]),
    "AdaptorEthPortStats": MoMeta("AdaptorEthPortStats", "adaptorEthPortStats", "eth-port-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'vmNic'], ['adaptorEthPortStatsHist'], ["Get"]),
    "AdaptorEthPortStatsHist": MoMeta("AdaptorEthPortStatsHist", "adaptorEthPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortStats'], [], ["Get"]),
    "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthRoCEProfile": MoMeta("AdaptorEthRoCEProfile", "adaptorEthRoCEProfile", "eth-roce", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthVxLANProfile": MoMeta("AdaptorEthVxLANProfile", "adaptorEthVxLANProfile", "eth-vxlan", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEtherIfStats": MoMeta("AdaptorEtherIfStats", "adaptorEtherIfStats", "ether-if-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorVlan'], ['adaptorEtherIfStatsHist'], ["Get"]),
    "AdaptorEtherIfStatsHist": MoMeta("AdaptorEtherIfStatsHist", "adaptorEtherIfStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEtherIfStats'], [], ["Get"]),
    "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorEthPortBySizeLargeStats', 'adaptorEthPortBySizeSmallStats', 'adaptorEthPortErrStats', 'adaptorEthPortMcastStats', 'adaptorEthPortOutsizedStats', 'adaptorEthPortStats', 'adaptorExtEthIfFsm', 'adaptorExtEthIfFsmTask', 'dcxVIf', 'eventInst', 'fabricEthMonSrcEp', 'faultInst'], ["Get", "Set"]),
    "AdaptorExtEthIfFsm": MoMeta("AdaptorExtEthIfFsm", "adaptorExtEthIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorExtEthIf'], ['adaptorExtEthIfFsmStage'], [None]),
    "AdaptorExtEthIfFsmStage": MoMeta("AdaptorExtEthIfFsmStage", "adaptorExtEthIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorExtEthIfFsm'], [], [None]),
    "AdaptorExtEthIfFsmTask": MoMeta("AdaptorExtEthIfFsmTask", "adaptorExtEthIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['adaptorExtEthIf'], [], [None]),
    "AdaptorExtEthIfPc": MoMeta("AdaptorExtEthIfPc", "adaptorExtEthIfPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorUnit', 'fabricLocale'], ['adaptorExtEthIfPcEp', 'dcxVIf'], ["Get"]),
    "AdaptorExtEthIfPcEp": MoMeta("AdaptorExtEthIfPcEp", "adaptorExtEthIfPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorExtEthIfPc'], [], ["Get"]),
    "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorFamilyTypeDef": MoMeta("AdaptorFamilyTypeDef", "adaptorFamilyTypeDef", "family-type", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider', 'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcFnicProfile": MoMeta("AdaptorFcFnicProfile", "adaptorFcFnicProfile", "fc-fnic", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorFcIfEventStats": MoMeta("AdaptorFcIfEventStats", "adaptorFcIfEventStats", "fc-if-event-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfEventStatsHist'], ["Get"]),
    "AdaptorFcIfEventStatsHist": MoMeta("AdaptorFcIfEventStatsHist", "adaptorFcIfEventStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfEventStats'], [], ["Get"]),
    "AdaptorFcIfFC4Stats": MoMeta("AdaptorFcIfFC4Stats", "adaptorFcIfFC4Stats", "fc-if-fc4-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfFC4StatsHist'], ["Get"]),
    "AdaptorFcIfFC4StatsHist": MoMeta("AdaptorFcIfFC4StatsHist", "adaptorFcIfFC4StatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfFC4Stats'], [], ["Get"]),
    "AdaptorFcIfFrameStats": MoMeta("AdaptorFcIfFrameStats", "adaptorFcIfFrameStats", "fc-if-frame-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfFrameStatsHist'], ["Get"]),
    "AdaptorFcIfFrameStatsHist": MoMeta("AdaptorFcIfFrameStatsHist", "adaptorFcIfFrameStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfFrameStats'], [], ["Get"]),
    "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcOEIf": MoMeta("AdaptorFcOEIf", "adaptorFcOEIf", "fcoe", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'adaptorHostFcIf'], ['dcxVIf'], ["Get"]),
    "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortStats": MoMeta("AdaptorFcPortStats", "adaptorFcPortStats", "fc-port-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf', 'vmNic'], ['adaptorFcPortStatsHist'], ["Get"]),
    "AdaptorFcPortStatsHist": MoMeta("AdaptorFcPortStatsHist", "adaptorFcPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcPortStats'], [], ["Get"]),
    "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcVhbaTypeProfile": MoMeta("AdaptorFcVhbaTypeProfile", "adaptorFcVhbaTypeProfile", "fc-vhbatype", VersionMeta.Version402a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], [None]),
    "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIf', 'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFruCapProvider": MoMeta("AdaptorFruCapProvider", "adaptorFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['adaptorCapSpec', 'adaptorDiagCap', 'adaptorDynamicConfigCap', 'adaptorFamilyTypeDef', 'adaptorFwCapProvider', 'adaptorHostMgmtCap', 'adaptorHostPortCap', 'adaptorHostVnicHwAddrCap', 'adaptorHostethHwAddrCap', 'adaptorHostfcHwAddrCap', 'adaptorIScsiCap', 'adaptorLanCap', 'adaptorLldpCap', 'adaptorMgmtVnicEthConfig', 'adaptorNwMgmtCap', 'adaptorNwStatsMgmtCap', 'adaptorRnicCapSpec', 'adaptorSanCap', 'adaptorUplinkHwAddrCap', 'equipmentAdaptorDef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPortGroupAggregationDef', 'equipmentPortGroupDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareSpec', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "AdaptorFruCapRef": MoMeta("AdaptorFruCapRef", "adaptorFruCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "AdaptorFwCapProvider": MoMeta("AdaptorFwCapProvider", "adaptorFwCapProvider", "fw-vendor-[vendor]-model-[model]-version-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorAzureQosProfile', 'adaptorEthAdvFilterProfile', 'adaptorEthArfsProfile', 'adaptorEthCompQueueProfile', 'adaptorEthFailoverProfile', 'adaptorEthGENEVEProfile', 'adaptorEthInterruptProfile', 'adaptorEthInterruptScalingProfile', 'adaptorEthNVGREProfile', 'adaptorEthOffloadProfile', 'adaptorEthPortBySizeLargeStats', 'adaptorEthPortBySizeSmallStats', 'adaptorEthPortErrStats', 'adaptorEthPortMcastStats', 'adaptorEthPortOutsizedStats', 'adaptorEthPortStats', 'adaptorEthRecvQueueProfile', 'adaptorEthRoCEProfile', 'adaptorEthVxLANProfile', 'adaptorEthWorkQueueProfile', 'adaptorExtIpV6RssHashProfile', 'adaptorFcOEIf', 'adaptorHostEthIfFsm', 'adaptorHostEthIfFsmTask', 'adaptorIpV4RssHashProfile', 'adaptorIpV6RssHashProfile', 'adaptorRssProfile', 'adaptorUsnicConnDef', 'adaptorVlan', 'adaptorVmmqConnDef', 'adaptorVnicStats', 'dcxVIf', 'dhcpAcquired', 'eventInst', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'mgmtIf', 'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostEthIfFsm": MoMeta("AdaptorHostEthIfFsm", "adaptorHostEthIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorHostEthIf'], ['adaptorHostEthIfFsmStage'], [None]),
    "AdaptorHostEthIfFsmStage": MoMeta("AdaptorHostEthIfFsmStage", "adaptorHostEthIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorHostEthIfFsm'], [], [None]),
    "AdaptorHostEthIfFsmTask": MoMeta("AdaptorHostEthIfFsmTask", "adaptorHostEthIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['adaptorHostEthIf'], [], [None]),
    "AdaptorHostEthIfProfile": MoMeta("AdaptorHostEthIfProfile", "adaptorHostEthIfProfile", "eth-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['orgOrg', 'policySystemEp'], ['adaptorAzureQosProfile', 'adaptorEthAdvFilterProfile', 'adaptorEthArfsProfile', 'adaptorEthCompQueueProfile', 'adaptorEthFailoverProfile', 'adaptorEthGENEVEProfile', 'adaptorEthInterruptProfile', 'adaptorEthInterruptScalingProfile', 'adaptorEthNVGREProfile', 'adaptorEthOffloadProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthRoCEProfile', 'adaptorEthVxLANProfile', 'adaptorEthWorkQueueProfile', 'adaptorExtIpV6RssHashProfile', 'adaptorIpV4RssHashProfile', 'adaptorIpV6RssHashProfile', 'adaptorRssProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorFcCdbWorkQueueProfile', 'adaptorFcErrorRecoveryProfile', 'adaptorFcFnicProfile', 'adaptorFcIfEventStats', 'adaptorFcIfFC4Stats', 'adaptorFcIfFrameStats', 'adaptorFcInterruptProfile', 'adaptorFcOEIf', 'adaptorFcPortFLogiProfile', 'adaptorFcPortPLogiProfile', 'adaptorFcPortProfile', 'adaptorFcPortStats', 'adaptorFcRecvQueueProfile', 'adaptorFcVhbaTypeProfile', 'adaptorFcWorkQueueProfile', 'adaptorHostFcIfFsm', 'adaptorHostFcIfFsmTask', 'adaptorVnicStats', 'adaptorVsan', 'dcxVIf', 'eventInst', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostFcIfFsm": MoMeta("AdaptorHostFcIfFsm", "adaptorHostFcIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorHostFcIf'], ['adaptorHostFcIfFsmStage'], [None]),
    "AdaptorHostFcIfFsmStage": MoMeta("AdaptorHostFcIfFsmStage", "adaptorHostFcIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['adaptorHostFcIfFsm'], [], [None]),
    "AdaptorHostFcIfFsmTask": MoMeta("AdaptorHostFcIfFsmTask", "adaptorHostFcIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['adaptorHostFcIf'], [], [None]),
    "AdaptorHostFcIfProfile": MoMeta("AdaptorHostFcIfProfile", "adaptorHostFcIfProfile", "fc-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['orgOrg'], ['adaptorFcCdbWorkQueueProfile', 'adaptorFcErrorRecoveryProfile', 'adaptorFcFnicProfile', 'adaptorFcInterruptProfile', 'adaptorFcPortFLogiProfile', 'adaptorFcPortPLogiProfile', 'adaptorFcPortProfile', 'adaptorFcRecvQueueProfile', 'adaptorFcVhbaTypeProfile', 'adaptorFcWorkQueueProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostIfConfig": MoMeta("AdaptorHostIfConfig", "adaptorHostIfConfig", "host-if-config-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "AdaptorHostIscsiIf": MoMeta("AdaptorHostIscsiIf", "adaptorHostIscsiIf", "host-iscsi-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorIscsiProt', 'adaptorIscsiTargetIf', 'adaptorProtocolProfile', 'adaptorVlan', 'adaptorVnicStats', 'fabricNetflowIPv4Addr', 'faultInst', 'networkIfStats', 'vnicIPv4Dhcp', 'vnicIPv4Dns', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr', 'vnicIPv4StaticRoute', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Get"]),
    "AdaptorHostIscsiIfProfile": MoMeta("AdaptorHostIscsiIfProfile", "adaptorHostIscsiIfProfile", "iscsi-profile-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['orgOrg'], ['adaptorProtocolProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostMgmtCap": MoMeta("AdaptorHostMgmtCap", "adaptorHostMgmtCap", "host-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostPort": MoMeta("AdaptorHostPort", "adaptorHostPort", "host-port-[id]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['adaptorUnit'], [], ["Get"]),
    "AdaptorHostPortCap": MoMeta("AdaptorHostPortCap", "adaptorHostPortCap", "max-host-port", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostScsiIf": MoMeta("AdaptorHostScsiIf", "adaptorHostScsiIf", "host-scsi-[id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorHostScsiLunRef', 'adaptorVnicStats', 'faultInst', 'networkIfStats'], ["Get"]),
    "AdaptorHostScsiLunRef": MoMeta("AdaptorHostScsiLunRef", "adaptorHostScsiLunRef", "host-scsi-lun-[lun_order]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin"], ['adaptorHostScsiIf'], [], ["Get"]),
    "AdaptorHostServiceEthIf": MoMeta("AdaptorHostServiceEthIf", "adaptorHostServiceEthIf", "host-service-eth-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorVlan', 'adaptorVnicStats', 'dcxVIf', 'faultInst', 'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostVnicHwAddrCap": MoMeta("AdaptorHostVnicHwAddrCap", "adaptorHostVnicHwAddrCap", "hwaddr-hostvnic", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], [None]),
    "AdaptorHostethHwAddrCap": MoMeta("AdaptorHostethHwAddrCap", "adaptorHostethHwAddrCap", "hwaddr-hosteth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostfcHwAddrCap": MoMeta("AdaptorHostfcHwAddrCap", "adaptorHostfcHwAddrCap", "hwaddr-hostfc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIScsiCap": MoMeta("AdaptorIScsiCap", "adaptorIScsiCap", "iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIscsiAuth": MoMeta("AdaptorIscsiAuth", "adaptorIscsiAuth", "iscsi-auth", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "AdaptorIscsiProt": MoMeta("AdaptorIscsiProt", "adaptorIscsiProt", "iscsi-prot", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostIscsiIf'], [], [None]),
    "AdaptorIscsiTargetIf": MoMeta("AdaptorIscsiTargetIf", "adaptorIscsiTargetIf", "iscsi-target[priority]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostIscsiIf'], [], [None]),
    "AdaptorLanCap": MoMeta("AdaptorLanCap", "adaptorLanCap", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorLldpCap": MoMeta("AdaptorLldpCap", "adaptorLldpCap", "lldp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorMenloBaseErrorStats": MoMeta("AdaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStats", "menlo-base-error-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['adaptorMenloBaseErrorStatsHist'], ["Get"]),
    "AdaptorMenloBaseErrorStatsHist": MoMeta("AdaptorMenloBaseErrorStatsHist", "adaptorMenloBaseErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloBaseErrorStats'], [], ["Get"]),
    "AdaptorMenloDcePortStats": MoMeta("AdaptorMenloDcePortStats", "adaptorMenloDcePortStats", "menlo-dce-port-stats-[menlo_port_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloDcePortStatsHist'], ["Get"]),
    "AdaptorMenloDcePortStatsHist": MoMeta("AdaptorMenloDcePortStatsHist", "adaptorMenloDcePortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloDcePortStats'], [], ["Get"]),
    "AdaptorMenloEthErrorStats": MoMeta("AdaptorMenloEthErrorStats", "adaptorMenloEthErrorStats", "menlo-eth-error-stats-[menlo_eth_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloEthErrorStatsHist'], ["Get"]),
    "AdaptorMenloEthErrorStatsHist": MoMeta("AdaptorMenloEthErrorStatsHist", "adaptorMenloEthErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloEthErrorStats'], [], ["Get"]),
    "AdaptorMenloEthStats": MoMeta("AdaptorMenloEthStats", "adaptorMenloEthStats", "menlo-eth-stats-[menlo_eth_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloEthStatsHist'], ["Get"]),
    "AdaptorMenloEthStatsHist": MoMeta("AdaptorMenloEthStatsHist", "adaptorMenloEthStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloEthStats'], [], ["Get"]),
    "AdaptorMenloFcErrorStats": MoMeta("AdaptorMenloFcErrorStats", "adaptorMenloFcErrorStats", "menlo-fc-error-stats-[menlo_fc_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloFcErrorStatsHist'], ["Get"]),
    "AdaptorMenloFcErrorStatsHist": MoMeta("AdaptorMenloFcErrorStatsHist", "adaptorMenloFcErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloFcErrorStats'], [], ["Get"]),
    "AdaptorMenloFcStats": MoMeta("AdaptorMenloFcStats", "adaptorMenloFcStats", "menlo-fc-stats-[menlo_fc_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloFcStatsHist'], ["Get"]),
    "AdaptorMenloFcStatsHist": MoMeta("AdaptorMenloFcStatsHist", "adaptorMenloFcStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloFcStats'], [], ["Get"]),
    "AdaptorMenloHostPortStats": MoMeta("AdaptorMenloHostPortStats", "adaptorMenloHostPortStats", "menlo-host-port-stats-[menlo_port_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloHostPortStatsHist'], ["Get"]),
    "AdaptorMenloHostPortStatsHist": MoMeta("AdaptorMenloHostPortStatsHist", "adaptorMenloHostPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloHostPortStats'], [], ["Get"]),
    "AdaptorMenloMcpuErrorStats": MoMeta("AdaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStats", "menlo-mcpu-error-stats-[menlo_mcpu_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloMcpuErrorStatsHist'], ["Get"]),
    "AdaptorMenloMcpuErrorStatsHist": MoMeta("AdaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloMcpuErrorStats'], [], ["Get"]),
    "AdaptorMenloMcpuStats": MoMeta("AdaptorMenloMcpuStats", "adaptorMenloMcpuStats", "menlo-mcpu-stats-[menlo_mcpu_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloMcpuStatsHist'], ["Get"]),
    "AdaptorMenloMcpuStatsHist": MoMeta("AdaptorMenloMcpuStatsHist", "adaptorMenloMcpuStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloMcpuStats'], [], ["Get"]),
    "AdaptorMenloNetEgStats": MoMeta("AdaptorMenloNetEgStats", "adaptorMenloNetEgStats", "menlo-net-eg-stats-[menlo_net_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloNetEgStatsHist'], ["Get"]),
    "AdaptorMenloNetEgStatsHist": MoMeta("AdaptorMenloNetEgStatsHist", "adaptorMenloNetEgStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloNetEgStats'], [], ["Get"]),
    "AdaptorMenloNetInStats": MoMeta("AdaptorMenloNetInStats", "adaptorMenloNetInStats", "menlo-net-in-stats-[menlo_net_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloNetInStatsHist'], ["Get"]),
    "AdaptorMenloNetInStatsHist": MoMeta("AdaptorMenloNetInStatsHist", "adaptorMenloNetInStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloNetInStats'], [], ["Get"]),
    "AdaptorMenloQErrorStats": MoMeta("AdaptorMenloQErrorStats", "adaptorMenloQErrorStats", "menlo-q-error-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloQErrorStatsHist'], ["Get"]),
    "AdaptorMenloQErrorStatsHist": MoMeta("AdaptorMenloQErrorStatsHist", "adaptorMenloQErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloQErrorStats'], [], ["Get"]),
    "AdaptorMenloQStats": MoMeta("AdaptorMenloQStats", "adaptorMenloQStats", "menlo-q-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloQStatsHist'], ["Get"]),
    "AdaptorMenloQStatsHist": MoMeta("AdaptorMenloQStatsHist", "adaptorMenloQStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloQStats'], [], ["Get"]),
    "AdaptorMgmtVnicEthConfig": MoMeta("AdaptorMgmtVnicEthConfig", "adaptorMgmtVnicEthConfig", "mgmt-vnic", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], [None]),
    "AdaptorNwMgmtCap": MoMeta("AdaptorNwMgmtCap", "adaptorNwMgmtCap", "nw-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorNwStatsMgmtCap": MoMeta("AdaptorNwStatsMgmtCap", "adaptorNwStatsMgmtCap", "nw-stats-mgmt", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], [None]),
    "AdaptorProtocolProfile": MoMeta("AdaptorProtocolProfile", "adaptorProtocolProfile", "iscsi-prot-profile", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostIscsiIf', 'adaptorHostIscsiIfProfile'], [], ["Add", "Get", "Set"]),
    "AdaptorQual": MoMeta("AdaptorQual", "adaptorQual", "adaptor", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], ['adaptorCapQual'], ["Add", "Get", "Remove"]),
    "AdaptorRnicCapSpec": MoMeta("AdaptorRnicCapSpec", "adaptorRnicCapSpec", "cap-[type]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIf', 'adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorSanCap": MoMeta("AdaptorSanCap", "adaptorSanCap", "san", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['adaptorExtEthIf', 'adaptorExtEthIfPc', 'adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostPort', 'adaptorHostScsiIf', 'adaptorHostServiceEthIf', 'adaptorMenloDcePortStats', 'adaptorMenloEthErrorStats', 'adaptorMenloEthStats', 'adaptorMenloFcErrorStats', 'adaptorMenloFcStats', 'adaptorMenloHostPortStats', 'adaptorMenloMcpuErrorStats', 'adaptorMenloMcpuStats', 'adaptorMenloNetEgStats', 'adaptorMenloNetInStats', 'adaptorMenloQErrorStats', 'adaptorMenloQStats', 'adaptorUnitExtn', 'dcxNs', 'equipmentInventoryStatus', 'equipmentPOST', 'equipmentPciDef', 'faultInst', 'mgmtController'], ["Get"]),
    "AdaptorUnitAssocCtx": MoMeta("AdaptorUnitAssocCtx", "adaptorUnitAssocCtx", "adaptorunit-assoc-ctx-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "AdaptorUnitExtn": MoMeta("AdaptorUnitExtn", "adaptorUnitExtn", "adaptor-extn-[id]", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], ['adaptorUnit'], ['equipmentInventoryStatus', 'faultInst'], ["Get"]),
    "AdaptorUplinkHwAddrCap": MoMeta("AdaptorUplinkHwAddrCap", "adaptorUplinkHwAddrCap", "hwaddr-uplink", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorUplinkPortStats": MoMeta("AdaptorUplinkPortStats", "adaptorUplinkPortStats", "", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "AdaptorUsnicConnDef": MoMeta("AdaptorUsnicConnDef", "adaptorUsnicConnDef", "usnic-conn-def-[con_policy_name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], ['adaptorHostEthIf'], ['adaptorEthCompQueueProfile', 'adaptorEthFailoverProfile', 'adaptorEthInterruptProfile', 'adaptorEthInterruptScalingProfile', 'adaptorEthOffloadProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthWorkQueueProfile', 'adaptorExtIpV6RssHashProfile', 'adaptorIpV4RssHashProfile', 'adaptorIpV6RssHashProfile', 'adaptorRssProfile'], [None]),
    "AdaptorVlan": MoMeta("AdaptorVlan", "adaptorVlan", "vlan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'adaptorHostIscsiIf', 'adaptorHostServiceEthIf'], ['adaptorEtherIfStats', 'fabricNetflowIPv4Addr', 'faultInst', 'vnicIPv4Dhcp', 'vnicIPv4Dns', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr', 'vnicIPv4StaticRoute', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Get"]),
    "AdaptorVmmqConnDef": MoMeta("AdaptorVmmqConnDef", "adaptorVmmqConnDef", "vmmq-conn-def-[con_policy_name]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], ['adaptorHostEthIf'], ['adaptorEthCompQueueProfile', 'adaptorEthInterruptProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthRoCEProfile', 'adaptorEthWorkQueueProfile', 'adaptorRssProfile'], [None]),
    "AdaptorVnicStats": MoMeta("AdaptorVnicStats", "adaptorVnicStats", "vnic-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostScsiIf', 'adaptorHostServiceEthIf', 'vmNic'], ['adaptorVnicStatsHist'], ["Get"]),
    "AdaptorVnicStatsHist": MoMeta("AdaptorVnicStatsHist", "adaptorVnicStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorVnicStats'], [], ["Get"]),
    "AdaptorVsan": MoMeta("AdaptorVsan", "adaptorVsan", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostFcIf'], [], ["Get"]),
    "ApeAttribute": MoMeta("ApeAttribute", "apeAttribute", "attribute-[id]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['apeMcTable'], [], [None]),
    "ApeControllerChassis": MoMeta("ApeControllerChassis", "apeControllerChassis", "Chassis-[index]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeControllerManager'], ['apeControllerEeprom'], [None]),
    "ApeControllerEeprom": MoMeta("ApeControllerEeprom", "apeControllerEeprom", "Eeprom-[side]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeControllerChassis'], [], [None]),
    "ApeControllerManager": MoMeta("ApeControllerManager", "apeControllerManager", "Controller", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeManager'], ['apeControllerChassis'], [None]),
    "ApeDcosAgManager": MoMeta("ApeDcosAgManager", "apeDcosAgManager", "DcosAgManager", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['apeManager'], ['apeSwitchFirmwareInv'], [None]),
    "ApeFru": MoMeta("ApeFru", "apeFru", "fru-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMcTable'], [], [None]),
    "ApeHostAgent": MoMeta("ApeHostAgent", "apeHostAgent", "hostagent-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['apeManager'], [], [None]),
    "ApeLANBoot": MoMeta("ApeLANBoot", "apeLANBoot", "lanboot-[vnic_name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['apeManager'], [], [None]),
    "ApeLocalDiskBoot": MoMeta("ApeLocalDiskBoot", "apeLocalDiskBoot", "localdiskboot-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['apeManager'], [], [None]),
    "ApeManager": MoMeta("ApeManager", "apeManager", "ape", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['apeControllerManager', 'apeDcosAgManager', 'apeHostAgent', 'apeLANBoot', 'apeLocalDiskBoot', 'apeMc', 'apeNicAgManager', 'apeSANBoot', 'apeVirtualMediaBoot'], [None]),
    "ApeMc": MoMeta("ApeMc", "apeMc", "mc-[ip]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeManager'], ['apeMcTable'], [None]),
    "ApeMcStats": MoMeta("ApeMcStats", "apeMcStats", "", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ApeMcTable": MoMeta("ApeMcTable", "apeMcTable", "mctable-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMc'], ['apeAttribute', 'apeFru', 'apeParam', 'apeReading', 'apeSdr'], [None]),
    "ApeMenlo": MoMeta("ApeMenlo", "apeMenlo", "Menlo-[mac1]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeNicAgManager'], ['apeMenloVnic', 'apePaloVnic'], [None]),
    "ApeMenloVnic": MoMeta("ApeMenloVnic", "apeMenloVnic", "AdapterVnic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMenlo', 'apePalo'], ['apeMenloVnicStats', 'apePaloVnicStats'], [None]),
    "ApeMenloVnicStats": MoMeta("ApeMenloVnicStats", "apeMenloVnicStats", "menlostats", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMenloVnic', 'apePaloVnic'], [], [None]),
    "ApeNicAgManager": MoMeta("ApeNicAgManager", "apeNicAgManager", "NicAgManager", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeManager'], ['apeMenlo', 'apePalo'], [None]),
    "ApePalo": MoMeta("ApePalo", "apePalo", "Palo-[mac1]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeNicAgManager'], ['apeMenloVnic', 'apePaloVnic'], [None]),
    "ApePaloVnic": MoMeta("ApePaloVnic", "apePaloVnic", "AdapterVnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['apeMenlo', 'apePalo'], ['apeMenloVnicStats', 'apePaloVnicStats'], [None]),
    "ApePaloVnicStats": MoMeta("ApePaloVnicStats", "apePaloVnicStats", "palostats", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['apeMenloVnic', 'apePaloVnic'], [], [None]),
    "ApeParam": MoMeta("ApeParam", "apeParam", "param-[key]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMcTable'], [], [None]),
    "ApeReading": MoMeta("ApeReading", "apeReading", "reading-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMcTable'], [], [None]),
    "ApeSANBoot": MoMeta("ApeSANBoot", "apeSANBoot", "sanboot-[target_wwn]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['apeManager'], [], [None]),
    "ApeSdr": MoMeta("ApeSdr", "apeSdr", "sdr-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['apeMcTable'], [], [None]),
    "ApeSwitchFirmwareInv": MoMeta("ApeSwitchFirmwareInv", "apeSwitchFirmwareInv", "SwitchFirmwareInv-[fabric]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['apeDcosAgManager'], [], [None]),
    "ApeVirtualMediaBoot": MoMeta("ApeVirtualMediaBoot", "apeVirtualMediaBoot", "virtualmediaboot-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['apeManager'], [], [None]),
    "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['biosUnit'], ['biosBootDevGrp'], ["Get"]),
    "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "[order]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['biosBootDevGrp'], [], ["Get"]),
    "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['biosBOT'], ['biosBootDev'], ["Get"]),
    "BiosFeatureRef": MoMeta("BiosFeatureRef", "biosFeatureRef", "feature-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['biosRef'], ['biosParameterRef'], ["Get"]),
    "BiosParameterRef": MoMeta("BiosParameterRef", "biosParameterRef", "parameter-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['biosFeatureRef'], ['biosSettingRef'], ["Get"]),
    "BiosRef": MoMeta("BiosRef", "biosRef", "bios-ref", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['equipmentBladeBiosCapProvider'], ['biosFeatureRef', 'biosTokenParam'], ["Get"]),
    "BiosSettingRef": MoMeta("BiosSettingRef", "biosSettingRef", "setting-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['biosParameterRef'], [], ["Get"]),
    "BiosSettings": MoMeta("BiosSettings", "biosSettings", "bios-settings", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['biosUnit', 'capabilityCatalogue', 'computeDefaults', 'computePlatform'], ['biosTokenFeatureGroup', 'biosTokenParam', 'biosVfACPI10Support', 'biosVfASPMSupport', 'biosVfAllUSBDevices', 'biosVfAltitude', 'biosVfAssertNMIOnPERR', 'biosVfAssertNMIOnSERR', 'biosVfBMEDMAMitigation', 'biosVfBootOptionRetry', 'biosVfCPUHardwarePowerManagement', 'biosVfCPUPerformance', 'biosVfConsistentDeviceNameControl', 'biosVfConsoleRedirection', 'biosVfCoreMultiProcessing', 'biosVfDDR3VoltageSelection', 'biosVfDRAMClockThrottling', 'biosVfDirectCacheAccess', 'biosVfDramRefreshRate', 'biosVfEnergyPerformanceTuning', 'biosVfEnhancedIntelSpeedStepTech', 'biosVfEnhancedPowerCappingSupport', 'biosVfExecuteDisableBit', 'biosVfFRB2Timer', 'biosVfFrequencyFloorOverride', 'biosVfFrontPanelLockout', 'biosVfIOEMezz1OptionROM', 'biosVfIOENVMe1OptionROM', 'biosVfIOENVMe2OptionROM', 'biosVfIOESlot1OptionROM', 'biosVfIOESlot2OptionROM', 'biosVfIntegratedGraphics', 'biosVfIntegratedGraphicsApertureSize', 'biosVfIntelEntrySASRAIDModule', 'biosVfIntelHyperThreadingTech', 'biosVfIntelTrustedExecutionTechnology', 'biosVfIntelTurboBoostTech', 'biosVfIntelVTForDirectedIO', 'biosVfIntelVirtualizationTechnology', 'biosVfInterleaveConfiguration', 'biosVfLocalX2Apic', 'biosVfLvDIMMSupport', 'biosVfMaxVariableMTRRSetting', 'biosVfMaximumMemoryBelow4GB', 'biosVfMemoryMappedIOAbove4GB', 'biosVfMirroringMode', 'biosVfNUMAOptimized', 'biosVfOSBootWatchdogTimer', 'biosVfOSBootWatchdogTimerPolicy', 'biosVfOSBootWatchdogTimerTimeout', 'biosVfOnboardGraphics', 'biosVfOnboardSATAController', 'biosVfOnboardStorage', 'biosVfOptionROMEnable', 'biosVfOptionROMLoad', 'biosVfOutOfBandManagement', 'biosVfPCHSATAMode', 'biosVfPCILOMPortsConfiguration', 'biosVfPCIROMCLP', 'biosVfPCISlotLinkSpeed', 'biosVfPCISlotOptionROMEnable', 'biosVfPOSTErrorPause', 'biosVfPSTATECoordination', 'biosVfPackageCStateLimit', 'biosVfPanicAndHighWatermark', 'biosVfProcessorC1E', 'biosVfProcessorC3Report', 'biosVfProcessorC6Report', 'biosVfProcessorC7Report', 'biosVfProcessorCMCI', 'biosVfProcessorCState', 'biosVfProcessorEnergyConfiguration', 'biosVfProcessorPrefetchConfig', 'biosVfQPILinkFrequencySelect', 'biosVfQPISnoopMode', 'biosVfQuietBoot', 'biosVfRedirectionAfterBIOSPOST', 'biosVfResumeOnACPowerLoss', 'biosVfSBMezz1OptionROM', 'biosVfSBNVMe1OptionROM', 'biosVfSIOC1OptionROM', 'biosVfSIOC2OptionROM', 'biosVfScrubPolicies', 'biosVfSelectMemoryRASConfiguration', 'biosVfSerialPortAEnable', 'biosVfSparingMode', 'biosVfSriovConfig', 'biosVfTPMPendingOperation', 'biosVfTPMSupport', 'biosVfTrustedPlatformModule', 'biosVfUCSMBootModeControl', 'biosVfUCSMBootOrderRuleControl', 'biosVfUEFIOSUseLegacyVideo', 'biosVfUSBBootConfig', 'biosVfUSBConfiguration', 'biosVfUSBFrontPanelAccessLock', 'biosVfUSBPortConfiguration', 'biosVfUSBSystemIdlePowerOptimizingSetting', 'biosVfVGAPriority', 'biosVfWorkloadConfiguration'], ["Get"]),
    "BiosTokenFeatureGroup": MoMeta("BiosTokenFeatureGroup", "biosTokenFeatureGroup", "tokn-featr-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], ['biosTokenParam'], ["Get"]),
    "BiosTokenParam": MoMeta("BiosTokenParam", "biosTokenParam", "tokn-param-[target_token_name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosRef', 'biosSettings', 'biosTokenFeatureGroup'], ['biosTokenSettings'], ["Get"]),
    "BiosTokenSettings": MoMeta("BiosTokenSettings", "biosTokenSettings", "tokn-setng-[settings_mo_rn]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosTokenParam'], [], ["Get", "Set"]),
    "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit'], ['biosBOT', 'biosSettings', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], ["Get"]),
    "BiosVIdentityParams": MoMeta("BiosVIdentityParams", "biosVIdentityParams", "bios-videntity-params", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "BiosVProfile": MoMeta("BiosVProfile", "biosVProfile", "bios-prof-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['orgOrg'], ['biosTokenFeatureGroup', 'biosVfACPI10Support', 'biosVfASPMSupport', 'biosVfAllUSBDevices', 'biosVfAltitude', 'biosVfAssertNMIOnPERR', 'biosVfAssertNMIOnSERR', 'biosVfBMEDMAMitigation', 'biosVfBootOptionRetry', 'biosVfCPUHardwarePowerManagement', 'biosVfCPUPerformance', 'biosVfConsistentDeviceNameControl', 'biosVfConsoleRedirection', 'biosVfCoreMultiProcessing', 'biosVfDDR3VoltageSelection', 'biosVfDRAMClockThrottling', 'biosVfDirectCacheAccess', 'biosVfDramRefreshRate', 'biosVfEnergyPerformanceTuning', 'biosVfEnhancedIntelSpeedStepTech', 'biosVfEnhancedPowerCappingSupport', 'biosVfExecuteDisableBit', 'biosVfFRB2Timer', 'biosVfFrequencyFloorOverride', 'biosVfFrontPanelLockout', 'biosVfIOEMezz1OptionROM', 'biosVfIOENVMe1OptionROM', 'biosVfIOENVMe2OptionROM', 'biosVfIOESlot1OptionROM', 'biosVfIOESlot2OptionROM', 'biosVfIntegratedGraphics', 'biosVfIntegratedGraphicsApertureSize', 'biosVfIntelEntrySASRAIDModule', 'biosVfIntelHyperThreadingTech', 'biosVfIntelTrustedExecutionTechnology', 'biosVfIntelTurboBoostTech', 'biosVfIntelVTForDirectedIO', 'biosVfIntelVirtualizationTechnology', 'biosVfInterleaveConfiguration', 'biosVfLocalX2Apic', 'biosVfLvDIMMSupport', 'biosVfMaxVariableMTRRSetting', 'biosVfMaximumMemoryBelow4GB', 'biosVfMemoryMappedIOAbove4GB', 'biosVfMirroringMode', 'biosVfNUMAOptimized', 'biosVfOSBootWatchdogTimer', 'biosVfOSBootWatchdogTimerPolicy', 'biosVfOSBootWatchdogTimerTimeout', 'biosVfOnboardGraphics', 'biosVfOnboardSATAController', 'biosVfOnboardStorage', 'biosVfOptionROMEnable', 'biosVfOptionROMLoad', 'biosVfOutOfBandManagement', 'biosVfPCHSATAMode', 'biosVfPCILOMPortsConfiguration', 'biosVfPCIROMCLP', 'biosVfPCISlotLinkSpeed', 'biosVfPCISlotOptionROMEnable', 'biosVfPOSTErrorPause', 'biosVfPSTATECoordination', 'biosVfPackageCStateLimit', 'biosVfPanicAndHighWatermark', 'biosVfProcessorC1E', 'biosVfProcessorC3Report', 'biosVfProcessorC6Report', 'biosVfProcessorC7Report', 'biosVfProcessorCMCI', 'biosVfProcessorCState', 'biosVfProcessorEnergyConfiguration', 'biosVfProcessorPrefetchConfig', 'biosVfQPILinkFrequencySelect', 'biosVfQPISnoopMode', 'biosVfQuietBoot', 'biosVfRedirectionAfterBIOSPOST', 'biosVfResumeOnACPowerLoss', 'biosVfSBMezz1OptionROM', 'biosVfSBNVMe1OptionROM', 'biosVfSIOC1OptionROM', 'biosVfSIOC2OptionROM', 'biosVfScrubPolicies', 'biosVfSelectMemoryRASConfiguration', 'biosVfSerialPortAEnable', 'biosVfSparingMode', 'biosVfSriovConfig', 'biosVfTPMPendingOperation', 'biosVfTPMSupport', 'biosVfTrustedPlatformModule', 'biosVfUCSMBootModeControl', 'biosVfUCSMBootOrderRuleControl', 'biosVfUEFIOSUseLegacyVideo', 'biosVfUSBBootConfig', 'biosVfUSBConfiguration', 'biosVfUSBFrontPanelAccessLock', 'biosVfUSBPortConfiguration', 'biosVfUSBSystemIdlePowerOptimizingSetting', 'biosVfVGAPriority', 'biosVfWorkloadConfiguration'], ["Add", "Get", "Remove", "Set"]),
    "BiosVfACPI10Support": MoMeta("BiosVfACPI10Support", "biosVfACPI10Support", "ACPI10-Support", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAllUSBDevices": MoMeta("BiosVfAllUSBDevices", "biosVfAllUSBDevices", "All-USB-Devices", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfBMEDMAMitigation": MoMeta("BiosVfBMEDMAMitigation", "biosVfBMEDMAMitigation", "BME-DMA-Mitigation", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], [None]),
    "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUHardwarePowerManagement": MoMeta("BiosVfCPUHardwarePowerManagement", "biosVfCPUHardwarePowerManagement", "CPU-Hardware-Power-Management", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsistentDeviceNameControl": MoMeta("BiosVfConsistentDeviceNameControl", "biosVfConsistentDeviceNameControl", "Consistent-Device-Name-Control", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDDR3VoltageSelection": MoMeta("BiosVfDDR3VoltageSelection", "biosVfDDR3VoltageSelection", "DDR3-Voltage-Selection", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "Dram-Refresh-Rate", VersionMeta.Version205a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnergyPerformanceTuning": MoMeta("BiosVfEnergyPerformanceTuning", "biosVfEnergyPerformanceTuning", "Energy-Performance-Tuning", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnhancedPowerCappingSupport": MoMeta("BiosVfEnhancedPowerCappingSupport", "biosVfEnhancedPowerCappingSupport", "Enhanced-PowerCapping-Support", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFRB2Timer": MoMeta("BiosVfFRB2Timer", "biosVfFRB2Timer", "FRB-2-Timer", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrequencyFloorOverride": MoMeta("BiosVfFrequencyFloorOverride", "biosVfFrequencyFloorOverride", "Frequency-Floor-Override", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrontPanelLockout": MoMeta("BiosVfFrontPanelLockout", "biosVfFrontPanelLockout", "Front-panel-lockout", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOEMezz1OptionROM": MoMeta("BiosVfIOEMezz1OptionROM", "biosVfIOEMezz1OptionROM", "IOEMezz1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOENVMe1OptionROM": MoMeta("BiosVfIOENVMe1OptionROM", "biosVfIOENVMe1OptionROM", "IOENVMe1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOENVMe2OptionROM": MoMeta("BiosVfIOENVMe2OptionROM", "biosVfIOENVMe2OptionROM", "IOENVMe2-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOESlot1OptionROM": MoMeta("BiosVfIOESlot1OptionROM", "biosVfIOESlot1OptionROM", "IOESlot1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOESlot2OptionROM": MoMeta("BiosVfIOESlot2OptionROM", "biosVfIOESlot2OptionROM", "IOESlot2-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntegratedGraphics": MoMeta("BiosVfIntegratedGraphics", "biosVfIntegratedGraphics", "Integrated-Graphics", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntegratedGraphicsApertureSize": MoMeta("BiosVfIntegratedGraphicsApertureSize", "biosVfIntegratedGraphicsApertureSize", "Integrated-Graphics-Aperture-Size", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelEntrySASRAIDModule": MoMeta("BiosVfIntelEntrySASRAIDModule", "biosVfIntelEntrySASRAIDModule", "Intel-entry-SAS-RAID-module", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTrustedExecutionTechnology": MoMeta("BiosVfIntelTrustedExecutionTechnology", "biosVfIntelTrustedExecutionTechnology", "Intel-Trusted-Execution-Technology", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfInterleaveConfiguration": MoMeta("BiosVfInterleaveConfiguration", "biosVfInterleaveConfiguration", "Interleave-Configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLocalX2Apic": MoMeta("BiosVfLocalX2Apic", "biosVfLocalX2Apic", "Local-X2-Apic", VersionMeta.Version213a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaxVariableMTRRSetting": MoMeta("BiosVfMaxVariableMTRRSetting", "biosVfMaxVariableMTRRSetting", "Max-Variable-MTRR-Setting", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaximumMemoryBelow4GB": MoMeta("BiosVfMaximumMemoryBelow4GB", "biosVfMaximumMemoryBelow4GB", "Maximum-memory-below-4GB", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Timeout", VersionMeta.Version203a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardGraphics": MoMeta("BiosVfOnboardGraphics", "biosVfOnboardGraphics", "Onboard-Graphics", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardSATAController": MoMeta("BiosVfOnboardSATAController", "biosVfOnboardSATAController", "Onboard-SATA-controller", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version203a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMEnable": MoMeta("BiosVfOptionROMEnable", "biosVfOptionROMEnable", "OptionROM-Enable", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfOptionROMLoad": MoMeta("BiosVfOptionROMLoad", "biosVfOptionROMLoad", "OptionROM-load", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfOutOfBandManagement": MoMeta("BiosVfOutOfBandManagement", "biosVfOutOfBandManagement", "Out-of-Band-Management", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCHSATAMode": MoMeta("BiosVfPCHSATAMode", "biosVfPCHSATAMode", "PCH-SATA-Mode", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfPCILOMPortsConfiguration": MoMeta("BiosVfPCILOMPortsConfiguration", "biosVfPCILOMPortsConfiguration", "PCI-LOM-Ports-Configuration", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCIROMCLP": MoMeta("BiosVfPCIROMCLP", "biosVfPCIROMCLP", "PCI-ROM-CLP", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCISlotLinkSpeed": MoMeta("BiosVfPCISlotLinkSpeed", "biosVfPCISlotLinkSpeed", "PCI-Slot-Link-Speed", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPSTATECoordination": MoMeta("BiosVfPSTATECoordination", "biosVfPSTATECoordination", "P-STATE-Coordination", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-C-State-Limit", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPanicAndHighWatermark": MoMeta("BiosVfPanicAndHighWatermark", "biosVfPanicAndHighWatermark", "Panic-and-High-Watermark", VersionMeta.Version412c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], [None]),
    "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC7Report": MoMeta("BiosVfProcessorC7Report", "biosVfProcessorC7Report", "Processor-C7-Report", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorCMCI": MoMeta("BiosVfProcessorCMCI", "biosVfProcessorCMCI", "Processor-CMCI", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorEnergyConfiguration": MoMeta("BiosVfProcessorEnergyConfiguration", "biosVfProcessorEnergyConfiguration", "Processor-Energy-Configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorPrefetchConfig": MoMeta("BiosVfProcessorPrefetchConfig", "biosVfProcessorPrefetchConfig", "Processor-Prefetch-Config", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPILinkFrequencySelect": MoMeta("BiosVfQPILinkFrequencySelect", "biosVfQPILinkFrequencySelect", "QPI-Link-Frequency-Select", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPISnoopMode": MoMeta("BiosVfQPISnoopMode", "biosVfQPISnoopMode", "QPI-Snoop-Mode", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQuietBoot": MoMeta("BiosVfQuietBoot", "biosVfQuietBoot", "Quiet-Boot", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfRedirectionAfterBIOSPOST": MoMeta("BiosVfRedirectionAfterBIOSPOST", "biosVfRedirectionAfterBIOSPOST", "Redirection-After-BIOS-POST", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSBMezz1OptionROM": MoMeta("BiosVfSBMezz1OptionROM", "biosVfSBMezz1OptionROM", "SBMezz1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSBNVMe1OptionROM": MoMeta("BiosVfSBNVMe1OptionROM", "biosVfSBNVMe1OptionROM", "SBNVMe1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSIOC1OptionROM": MoMeta("BiosVfSIOC1OptionROM", "biosVfSIOC1OptionROM", "SIOC1-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSIOC2OptionROM": MoMeta("BiosVfSIOC2OptionROM", "biosVfSIOC2OptionROM", "SIOC2-OptionROM", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfScrubPolicies": MoMeta("BiosVfScrubPolicies", "biosVfScrubPolicies", "Scrub-Policies", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSriovConfig": MoMeta("BiosVfSriovConfig", "biosVfSriovConfig", "Sriov-Config", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], [None]),
    "BiosVfTPMPendingOperation": MoMeta("BiosVfTPMPendingOperation", "biosVfTPMPendingOperation", "TPM-Pending-Operation", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfTrustedPlatformModule": MoMeta("BiosVfTrustedPlatformModule", "biosVfTrustedPlatformModule", "Trusted-Platform-Module", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootModeControl": MoMeta("BiosVfUCSMBootModeControl", "biosVfUCSMBootModeControl", "UCSM-Boot-Mode-Control", VersionMeta.Version213a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "UCSM-Boot-Order-Rule-Control", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get"]),
    "BiosVfUEFIOSUseLegacyVideo": MoMeta("BiosVfUEFIOSUseLegacyVideo", "biosVfUEFIOSUseLegacyVideo", "UEFI-OS-use-legacy-video", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBConfiguration": MoMeta("BiosVfUSBConfiguration", "biosVfUSBConfiguration", "USB-Configuration", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBFrontPanelAccessLock": MoMeta("BiosVfUSBFrontPanelAccessLock", "biosVfUSBFrontPanelAccessLock", "USB-Front-Panel-Access-Lock", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBPortConfiguration": MoMeta("BiosVfUSBPortConfiguration", "biosVfUSBPortConfiguration", "USB-port-configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBSystemIdlePowerOptimizingSetting": MoMeta("BiosVfUSBSystemIdlePowerOptimizingSetting", "biosVfUSBSystemIdlePowerOptimizingSetting", "USB-System-Idle-Power-Optimizing-Setting", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfVGAPriority": MoMeta("BiosVfVGAPriority", "biosVfVGAPriority", "VGA-Priority", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfWorkloadConfiguration": MoMeta("BiosVfWorkloadConfiguration", "biosVfWorkloadConfiguration", "Workload-Configuration", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosSettings', 'biosVProfile'], [], ["Get", "Set"]),
    "BmcSELCounter": MoMeta("BmcSELCounter", "bmcSELCounter", "Counter-[local_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], ['equipmentPOSTCodeReporter'], [], ["Get"]),
    "CallhomeAnonymousReporting": MoMeta("CallhomeAnonymousReporting", "callhomeAnonymousReporting", "anonymousreporting", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin"], ['callhomeEp'], [], ["Get", "Set"]),
    "CallhomeDest": MoMeta("CallhomeDest", "callhomeDest", "email-[email]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeProfile'], [], ["Add", "Get", "Remove"]),
    "CallhomeEp": MoMeta("CallhomeEp", "callhomeEp", "call-home", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['topRoot'], ['callhomeAnonymousReporting', 'callhomeEpFsm', 'callhomeEpFsmTask', 'callhomePeriodicSystemInventory', 'callhomePolicy', 'callhomeProfile', 'callhomeSmtp', 'callhomeSource', 'callhomeTestAlert', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "CallhomeEpFsm": MoMeta("CallhomeEpFsm", "callhomeEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['callhomeEp'], ['callhomeEpFsmStage'], [None]),
    "CallhomeEpFsmStage": MoMeta("CallhomeEpFsmStage", "callhomeEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['callhomeEpFsm'], [], [None]),
    "CallhomeEpFsmTask": MoMeta("CallhomeEpFsmTask", "callhomeEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['callhomeEp'], [], [None]),
    "CallhomePeriodicSystemInventory": MoMeta("CallhomePeriodicSystemInventory", "callhomePeriodicSystemInventory", "periodicsysteminventory", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "CallhomePolicy": MoMeta("CallhomePolicy", "callhomePolicy", "policy-[cause]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeProfile": MoMeta("CallhomeProfile", "callhomeProfile", "profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], ['callhomeDest'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSmtp": MoMeta("CallhomeSmtp", "callhomeSmtp", "smtp", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "CallhomeSource": MoMeta("CallhomeSource", "callhomeSource", "source", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "CallhomeTestAlert": MoMeta("CallhomeTestAlert", "callhomeTestAlert", "testalert", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "CapabilityCatalogue": MoMeta("CapabilityCatalogue", "capabilityCatalogue", "capabilities", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['topRoot'], ['adaptorFruCapProvider', 'biosSettings', 'capabilityCatalogueFsm', 'capabilityCatalogueFsmTask', 'capabilityEp', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentHwCapDerivativeProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPOSTCodeReporter', 'equipmentPOSTCodeTemplate', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider', 'eventInst', 'faultInst', 'featureDefinition', 'featureProvider', 'firmwareBootDefinition', 'firmwareBundleTypeCapProvider', 'firmwarePlatformBundleTypeCapProvider', 'firmwareRunning', 'licenseFeatureCapProvider'], ["Get"]),
    "CapabilityCatalogueFsm": MoMeta("CapabilityCatalogueFsm", "capabilityCatalogueFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityCatalogue'], ['capabilityCatalogueFsmStage'], [None]),
    "CapabilityCatalogueFsmStage": MoMeta("CapabilityCatalogueFsmStage", "capabilityCatalogueFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityCatalogueFsm'], [], [None]),
    "CapabilityCatalogueFsmTask": MoMeta("CapabilityCatalogueFsmTask", "capabilityCatalogueFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], ['capabilityCatalogue'], [], [None]),
    "CapabilityEp": MoMeta("CapabilityEp", "capabilityEp", "ep", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['capabilityCatalogue'], ['capabilityMgmtExtension', 'capabilityUpdate', 'capabilityUpdater'], ["Get"]),
    "CapabilityFeatureLimits": MoMeta("CapabilityFeatureLimits", "capabilityFeatureLimits", "feature-[platform]-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['capabilityNetworkLimits', 'capabilityStorageLimits', 'capabilitySystemLimits'], [], [None]),
    "CapabilityMgmtExtension": MoMeta("CapabilityMgmtExtension", "capabilityMgmtExtension", "mgmt-ext", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['capabilityEp'], ['capabilityMgmtExtensionFsm', 'capabilityMgmtExtensionFsmTask', 'eventInst', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning'], ["Get"]),
    "CapabilityMgmtExtensionFsm": MoMeta("CapabilityMgmtExtensionFsm", "capabilityMgmtExtensionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityMgmtExtension'], ['capabilityMgmtExtensionFsmStage'], [None]),
    "CapabilityMgmtExtensionFsmStage": MoMeta("CapabilityMgmtExtensionFsmStage", "capabilityMgmtExtensionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityMgmtExtensionFsm'], [], [None]),
    "CapabilityMgmtExtensionFsmTask": MoMeta("CapabilityMgmtExtensionFsmTask", "capabilityMgmtExtensionFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['capabilityMgmtExtension'], [], [None]),
    "CapabilityNetworkLimits": MoMeta("CapabilityNetworkLimits", "capabilityNetworkLimits", "network-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSysDefaults'], ['capabilityFeatureLimits'], [None]),
    "CapabilityStorageLimits": MoMeta("CapabilityStorageLimits", "capabilityStorageLimits", "storage-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSysDefaults'], ['capabilityFeatureLimits'], [None]),
    "CapabilitySystemLimits": MoMeta("CapabilitySystemLimits", "capabilitySystemLimits", "system-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSysDefaults'], ['capabilityFeatureLimits'], [None]),
    "CapabilityUpdate": MoMeta("CapabilityUpdate", "capabilityUpdate", "update-[version]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin"], ['capabilityEp'], [], ["Get"]),
    "CapabilityUpdater": MoMeta("CapabilityUpdater", "capabilityUpdater", "updater-[file_name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin"], ['capabilityEp'], ['capabilityUpdaterFsm', 'capabilityUpdaterFsmTask', 'eventInst', 'faultInst'], ["Get"]),
    "CapabilityUpdaterFsm": MoMeta("CapabilityUpdaterFsm", "capabilityUpdaterFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityUpdater'], ['capabilityUpdaterFsmStage'], [None]),
    "CapabilityUpdaterFsmStage": MoMeta("CapabilityUpdaterFsmStage", "capabilityUpdaterFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['capabilityUpdaterFsm'], [], [None]),
    "CapabilityUpdaterFsmTask": MoMeta("CapabilityUpdaterFsmTask", "capabilityUpdaterFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], ['capabilityUpdater'], [], [None]),
    "ChangeChangedObjectRef": MoMeta("ChangeChangedObjectRef", "changeChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "CimcvmediaActualMountEntry": MoMeta("CimcvmediaActualMountEntry", "cimcvmediaActualMountEntry", "actual-mount-entry-[virtual_disk_id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['cimcvmediaActualMountList'], ['faultInst'], ["Get"]),
    "CimcvmediaActualMountList": MoMeta("CimcvmediaActualMountList", "cimcvmediaActualMountList", "actual-mount-list", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['mgmtController'], ['cimcvmediaActualMountEntry', 'cimcvmediaExtMgmtRuleEntry'], ["Get"]),
    "CimcvmediaConfigMountEntry": MoMeta("CimcvmediaConfigMountEntry", "cimcvmediaConfigMountEntry", "cfg-mnt-entry-[mapping_name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['cimcvmediaMountConfigDef', 'cimcvmediaMountConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaExtMgmtRuleEntry": MoMeta("CimcvmediaExtMgmtRuleEntry", "cimcvmediaExtMgmtRuleEntry", "ext-mgmt-rule-[mapping_name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaMountConfigDef": MoMeta("CimcvmediaMountConfigDef", "cimcvmediaMountConfigDef", "mnt-cfg-def", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer'], ['cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaMountConfigPolicy": MoMeta("CimcvmediaMountConfigPolicy", "cimcvmediaMountConfigPolicy", "mnt-cfg-policy-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "ClitestTypeTest": MoMeta("ClitestTypeTest", "clitestTypeTest", "tt-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topRoot'], [], ["Get"]),
    "ClitestTypeTest2": MoMeta("ClitestTypeTest2", "clitestTypeTest2", "tt2-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topRoot'], [], ["Get"]),
    "ClitestTypeTestChild": MoMeta("ClitestTypeTestChild", "clitestTypeTestChild", "tt-child", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "CloudDeviceConnectorEp": MoMeta("CloudDeviceConnectorEp", "cloudDeviceConnectorEp", "device-connector", VersionMeta.Version402a, "InputOutput", 0x1, [], ["aaa", "admin"], ['cloudMgmtSvc'], ['faultInst'], [None]),
    "CloudMgmtSvc": MoMeta("CloudMgmtSvc", "cloudMgmtSvc", "cloud-mgmt", VersionMeta.Version402a, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['cloudDeviceConnectorEp'], [None]),
    "CommCimcWebService": MoMeta("CommCimcWebService", "commCimcWebService", "cimc-web-svc", VersionMeta.Version221b, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommCimxml": MoMeta("CommCimxml", "commCimxml", "cimxml-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommDateTime": MoMeta("CommDateTime", "commDateTime", "datetime-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['commLocale', 'commSvcEp', 'commSvcPolicy'], ['commNtpProvider', 'faultInst'], ["Get", "Set"]),
    "CommDns": MoMeta("CommDns", "commDns", "dns-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['commLocale', 'commSvcEp', 'commSvcPolicy'], ['commDnsProvider'], ["Get", "Set"]),
    "CommDnsProvider": MoMeta("CommDnsProvider", "commDnsProvider", "dns-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['commDns'], [], ["Add", "Get", "Remove"]),
    "CommEvtChannel": MoMeta("CommEvtChannel", "commEvtChannel", "svc-evt-channel", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommLocale": MoMeta("CommLocale", "commLocale", "locale-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], [], ['commDateTime', 'commDns', 'commSyslog'], [None]),
    "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['commDateTime'], [], ["Add", "Get", "Remove"]),
    "CommShellSvcLimits": MoMeta("CommShellSvcLimits", "commShellSvcLimits", "shell-svc-limits", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "CommSmashCLP": MoMeta("CommSmashCLP", "commSmashCLP", "smashclp-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], ['commSnmpTrap', 'commSnmpUser', 'faultInst'], ["Get", "Set"]),
    "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSnmp'], ['aaaCimcSession', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['commCimcWebService', 'commCimxml', 'commDateTime', 'commDns', 'commEvtChannel', 'commHttp', 'commHttps', 'commShellSvcLimits', 'commSmashCLP', 'commSnmp', 'commSsh', 'commSvcEpFsm', 'commSvcEpFsmTask', 'commSyslog', 'commTelnet', 'commWebChannel', 'commWebSvcLimits', 'commWsman', 'commXmlClConnPolicy', 'eventInst', 'faultInst'], ["Get"]),
    "CommSvcEpFsm": MoMeta("CommSvcEpFsm", "commSvcEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['commSvcEp'], ['commSvcEpFsmStage'], [None]),
    "CommSvcEpFsmStage": MoMeta("CommSvcEpFsmStage", "commSvcEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['commSvcEpFsm'], [], [None]),
    "CommSvcEpFsmTask": MoMeta("CommSvcEpFsmTask", "commSvcEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['commSvcEp'], [], [None]),
    "CommSvcPolicy": MoMeta("CommSvcPolicy", "commSvcPolicy", "comm-pol-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['commDateTime', 'commDns', 'commSyslog'], [None]),
    "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['commLocale', 'commSvcEp', 'commSvcPolicy'], ['commSyslogClient', 'commSyslogConsole', 'commSyslogFile', 'commSyslogMonitor', 'commSyslogSource'], ["Get", "Set"]),
    "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Get", "Set"]),
    "CommSyslogConsole": MoMeta("CommSyslogConsole", "commSyslogConsole", "console", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Get", "Set"]),
    "CommSyslogFile": MoMeta("CommSyslogFile", "commSyslogFile", "file", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Get", "Set"]),
    "CommSyslogMonitor": MoMeta("CommSyslogMonitor", "commSyslogMonitor", "monitor", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Get", "Set"]),
    "CommSyslogSource": MoMeta("CommSyslogSource", "commSyslogSource", "source", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Get", "Set"]),
    "CommTelnet": MoMeta("CommTelnet", "commTelnet", "telnet-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommWebChannel": MoMeta("CommWebChannel", "commWebChannel", "svc-web-channel", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "CommWebSvcLimits": MoMeta("CommWebSvcLimits", "commWebSvcLimits", "web-svc-limits", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get", "Set"]),
    "CommWsman": MoMeta("CommWsman", "commWsman", "wsman-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "CommXmlClConnPolicy": MoMeta("CommXmlClConnPolicy", "commXmlClConnPolicy", "xmlclconnpolicy-[client_type]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp'], [], ["Get"]),
    "ComputeAdminAck": MoMeta("ComputeAdminAck", "computeAdminAck", "admin-ack", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst', 'trigLocalSched'], [None]),
    "ComputeAutoconfigPolicy": MoMeta("ComputeAutoconfigPolicy", "computeAutoconfigPolicy", "autoconfig-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeBlade": MoMeta("ComputeBlade", "computeBlade", "blade-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['aaaEpAuthProfile', 'aaaEpUser', 'adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'biosVIdentityParams', 'cimcvmediaMountConfigDef', 'computeAdminAck', 'computeBladeFsm', 'computeBladeFsmTask', 'computeBoard', 'computeBoardConnector', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOperation', 'computeFwSyncAck', 'computeHostUtilityOs', 'computeKvmMgmtPolicy', 'computeMemoryConfiguration', 'computePersonality', 'computePhysicalExtension', 'computePhysicalFsm', 'computePhysicalFsmTask', 'computePnuOSImage', 'computePoolable', 'computeRebootLog', 'computeScrubPolicy', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentHealthLed', 'equipmentIOExpander', 'equipmentIndicatorLed', 'equipmentInventoryStatus', 'equipmentLocatorLed', 'equipmentPOST', 'eventInst', 'fabricLocale', 'faultInst', 'faultSuppressTask', 'firmwareImageLock', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'lstorageProfile', 'memoryRuntime', 'mgmtController', 'mgmtKmipCertPolicy', 'mgmtSecurity', 'mgmtSpdmCertificatePolicy', 'moKvCfgHolder', 'moKvInvHolder', 'osAgent', 'osInstance', 'pciEquipSlot', 'pciUnit', 'powerBudget', 'processorRuntime', 'solIf', 'storageEnclosure', 'storageVirtualDriveContainer', 'swUlan', 'sysdebugDiagnosticLog'], ["Get", "Set"]),
    "ComputeBladeDiscPolicy": MoMeta("ComputeBladeDiscPolicy", "computeBladeDiscPolicy", "blade-discovery[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeBladeEp": MoMeta("ComputeBladeEp", "computeBladeEp", "blade-ep-[id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ComputeBladeFsm": MoMeta("ComputeBladeFsm", "computeBladeFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeBlade'], ['computeBladeFsmStage'], [None]),
    "ComputeBladeFsmStage": MoMeta("ComputeBladeFsmStage", "computeBladeFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeBladeFsm'], [], [None]),
    "ComputeBladeFsmTask": MoMeta("ComputeBladeFsmTask", "computeBladeFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['computeBlade'], [], [None]),
    "ComputeBladeInheritPolicy": MoMeta("ComputeBladeInheritPolicy", "computeBladeInheritPolicy", "blade-inherit-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computeIOHub', 'computeMbPowerStats', 'computeMbTempStats', 'computePCIeFatalCompletionStats', 'computePCIeFatalProtocolStats', 'computePCIeFatalReceiveStats', 'computePCIeFatalStats', 'computeRackUnitMbTempStats', 'computeRtcBattery', 'coprocessorCard', 'equipmentTpm', 'faultInst', 'graphicsCard', 'lstorageLocal', 'lstorageLocalDef', 'lstorageRemote', 'lstorageRemoteDef', 'memoryArray', 'memoryBufferUnit', 'memoryPersistentMemoryConfiguration', 'pciSwitch', 'processorUnit', 'securityUnit', 'storageController', 'storageFlexFlashController', 'storageLocalDiskSlotEp', 'storageMiniStorage', 'storageNvmeSwitch', 'storageSasExpander'], ["Get"]),
    "ComputeBoardConnector": MoMeta("ComputeBoardConnector", "computeBoardConnector", "board-conn", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['computeBlade'], [], ["Get"]),
    "ComputeBoardController": MoMeta("ComputeBoardController", "computeBoardController", "boardController", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentSystemIOController'], ['mgmtController'], ["Get"]),
    "ComputeCartridge": MoMeta("ComputeCartridge", "computeCartridge", "cartridge-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['computeServerUnit'], ["Get", "Set"]),
    "ComputeChassisConnPolicy": MoMeta("ComputeChassisConnPolicy", "computeChassisConnPolicy", "chassis-conn-policy-chassis-[chassis_id]-fabric-[switch_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisDiscPolicy": MoMeta("ComputeChassisDiscPolicy", "computeChassisDiscPolicy", "chassis-discovery", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisQual": MoMeta("ComputeChassisQual", "computeChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], ['computeSlotQual'], ["Add", "Get", "Remove"]),
    "ComputeConstraintDef": MoMeta("ComputeConstraintDef", "computeConstraintDef", "cons-def-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "ComputeDefaults": MoMeta("ComputeDefaults", "computeDefaults", "compute-defaults", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['topRoot'], ['biosSettings', 'computePlatform'], ["Get"]),
    "ComputeExtBoard": MoMeta("ComputeExtBoard", "computeExtBoard", "ext-board-[id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['biosUnit', 'computeBoardController', 'computeMbPowerStats', 'computeMbTempStats', 'equipmentHealthLed', 'equipmentLocatorLed', 'faultInst', 'mgmtController', 'powerBudget'], ["Get"]),
    "ComputeFactoryResetOperation": MoMeta("ComputeFactoryResetOperation", "computeFactoryResetOperation", "factory-reset", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeFanPolicy": MoMeta("ComputeFanPolicy", "computeFanPolicy", "fan-policy", VersionMeta.Version411a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['orgOrg'], [], [None]),
    "ComputeFwSyncAck": MoMeta("ComputeFwSyncAck", "computeFwSyncAck", "fwsyncack", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst', 'trigLocalSched'], ["Get", "Set"]),
    "ComputeGraphicsCardPolicy": MoMeta("ComputeGraphicsCardPolicy", "computeGraphicsCardPolicy", "graphics-card-policy-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeHealthLedSensorAlarm": MoMeta("ComputeHealthLedSensorAlarm", "computeHealthLedSensorAlarm", "sensor-alarm-[sensor_id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentHealthLed'], [], ["Get"]),
    "ComputeHostUtilityOs": MoMeta("ComputeHostUtilityOs", "computeHostUtilityOs", "host-util-os-", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['mgmtUsbNicMgmtIf'], ["Get"]),
    "ComputeHwChangeDiscPolicy": MoMeta("ComputeHwChangeDiscPolicy", "computeHwChangeDiscPolicy", "hw-change-disc-policy", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeIOHub": MoMeta("ComputeIOHub", "computeIOHub", "iohub", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['computeIOHubEnvStats', 'faultInst'], ["Get"]),
    "ComputeIOHubEnvStats": MoMeta("ComputeIOHubEnvStats", "computeIOHubEnvStats", "iohub-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeIOHub'], ['computeIOHubEnvStatsHist'], ["Get"]),
    "ComputeIOHubEnvStatsHist": MoMeta("ComputeIOHubEnvStatsHist", "computeIOHubEnvStatsHist", "[id]", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["read-only"], ['computeIOHubEnvStats'], [], ["Get"]),
    "ComputeInstanceIdQual": MoMeta("ComputeInstanceIdQual", "computeInstanceIdQual", "inst-from-[min_id]-to-[max_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeSlotQual'], [], ["Add", "Get", "Remove"]),
    "ComputeKvmMgmtPolicy": MoMeta("ComputeKvmMgmtPolicy", "computeKvmMgmtPolicy", "kvm-mgmt-policy-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-server", "ls-server-oper", "ls-server-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'orgOrg'], ['mgmtKvmCertificate'], ["Add", "Get", "Remove", "Set"]),
    "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard', 'computeExtBoard'], ['computeMbPowerStatsHist'], ["Get"]),
    "ComputeMbPowerStatsHist": MoMeta("ComputeMbPowerStatsHist", "computeMbPowerStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['computeMbPowerStats'], [], ["Get"]),
    "ComputeMbTempStats": MoMeta("ComputeMbTempStats", "computeMbTempStats", "temp-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard', 'computeExtBoard'], ['computeMbTempStatsHist'], ["Get"]),
    "ComputeMbTempStatsHist": MoMeta("ComputeMbTempStatsHist", "computeMbTempStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['computeMbTempStats'], [], ["Get"]),
    "ComputeMemoryConfigPolicy": MoMeta("ComputeMemoryConfigPolicy", "computeMemoryConfigPolicy", "memory-config-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-server-policy", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeMemoryConfiguration": MoMeta("ComputeMemoryConfiguration", "computeMemoryConfiguration", "memmory-config", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get", "Set"]),
    "ComputeMemoryUnitConstraintDef": MoMeta("ComputeMemoryUnitConstraintDef", "computeMemoryUnitConstraintDef", "dc-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "ComputePCIeFatalCompletionStats": MoMeta("ComputePCIeFatalCompletionStats", "computePCIeFatalCompletionStats", "pciefat-completion-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], [], ["Get"]),
    "ComputePCIeFatalProtocolStats": MoMeta("ComputePCIeFatalProtocolStats", "computePCIeFatalProtocolStats", "pciefat-protocol-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], [], ["Get"]),
    "ComputePCIeFatalReceiveStats": MoMeta("ComputePCIeFatalReceiveStats", "computePCIeFatalReceiveStats", "pciefat-receive-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], [], ["Get"]),
    "ComputePCIeFatalStats": MoMeta("ComputePCIeFatalStats", "computePCIeFatalStats", "pciefat-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], [], ["Get"]),
    "ComputePciCap": MoMeta("ComputePciCap", "computePciCap", "pci", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], ['computePciSlotScanDef'], ["Get"]),
    "ComputePciSlotScanDef": MoMeta("ComputePciSlotScanDef", "computePciSlotScanDef", "slot-[slot_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['computePciCap'], [], [None]),
    "ComputePersonality": MoMeta("ComputePersonality", "computePersonality", "personality-[id]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit'], [], [None]),
    "ComputePhysicalAssocCtx": MoMeta("ComputePhysicalAssocCtx", "computePhysicalAssocCtx", "pn-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "ComputePhysicalExtension": MoMeta("ComputePhysicalExtension", "computePhysicalExtension", "phys-extension", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst'], [None]),
    "ComputePhysicalFsm": MoMeta("ComputePhysicalFsm", "computePhysicalFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computePhysicalFsmStage'], [None]),
    "ComputePhysicalFsmStage": MoMeta("ComputePhysicalFsmStage", "computePhysicalFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computePhysicalFsm'], [], [None]),
    "ComputePhysicalFsmTask": MoMeta("ComputePhysicalFsmTask", "computePhysicalFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], [None]),
    "ComputePhysicalQual": MoMeta("ComputePhysicalQual", "computePhysicalQual", "physical", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePlatform": MoMeta("ComputePlatform", "computePlatform", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['computeDefaults'], ['biosSettings'], ["Get"]),
    "ComputePnuOSImage": MoMeta("ComputePnuOSImage", "computePnuOSImage", "pnuos", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "ComputePool": MoMeta("ComputePool", "computePool", "compute-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['computePooledEnclosureComputeSlot', 'computePooledRackUnit', 'computePooledSlot', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputePoolPolicyRef": MoMeta("ComputePoolPolicyRef", "computePoolPolicyRef", "poolref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['computePoolable'], [], ["Get"]),
    "ComputePoolable": MoMeta("ComputePoolable", "computePoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computePoolPolicyRef'], ["Get"]),
    "ComputePooledEnclosureComputeSlot": MoMeta("ComputePooledEnclosureComputeSlot", "computePooledEnclosureComputeSlot", "server-[chassis_id]-[slot_id]-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledRackUnit": MoMeta("ComputePooledRackUnit", "computePooledRackUnit", "rack-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledSlot": MoMeta("ComputePooledSlot", "computePooledSlot", "blade-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePoolingPolicy": MoMeta("ComputePoolingPolicy", "computePoolingPolicy", "pooling-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePortDiscPolicy": MoMeta("ComputePortDiscPolicy", "computePortDiscPolicy", "port-discovery", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputePowerSavePolicy": MoMeta("ComputePowerSavePolicy", "computePowerSavePolicy", "power-save-policy", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['orgOrg'], [], [None]),
    "ComputePowerSyncDef": MoMeta("ComputePowerSyncDef", "computePowerSyncDef", "power-sync-def", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], ['lsServer'], [], ["Get", "Set"]),
    "ComputePowerSyncPolicy": MoMeta("ComputePowerSyncPolicy", "computePowerSyncPolicy", "power-sync-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePsuControl": MoMeta("ComputePsuControl", "computePsuControl", "psu-contr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], [], ["Get"]),
    "ComputePsuPolicy": MoMeta("ComputePsuPolicy", "computePsuPolicy", "psu-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeQual": MoMeta("ComputeQual", "computeQual", "blade-qualifier-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['adaptorQual', 'computeChassisQual', 'computePhysicalQual', 'computeRackQual', 'memoryQual', 'powerGroupQual', 'processorQual', 'storageQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeRackConnLinkPolicy": MoMeta("ComputeRackConnLinkPolicy", "computeRackConnLinkPolicy", "rack-conn-link-policy-rack-unit-[rack_id]-fabric-[switch_id]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], [None]),
    "ComputeRackQual": MoMeta("ComputeRackQual", "computeRackQual", "rack-from-[min_id]-to-[max_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove"]),
    "ComputeRackUnit": MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['topSystem'], ['aaaEpAuthProfile', 'aaaEpUser', 'adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'biosVIdentityParams', 'cimcvmediaMountConfigDef', 'computeAdminAck', 'computeBoard', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOperation', 'computeFwSyncAck', 'computeHostUtilityOs', 'computeKvmMgmtPolicy', 'computeMemoryConfiguration', 'computePersonality', 'computePhysicalExtension', 'computePhysicalFsm', 'computePhysicalFsmTask', 'computePnuOSImage', 'computePoolable', 'computeRackUnitFsm', 'computeRackUnitFsmTask', 'computeRebootLog', 'computeScrubPolicy', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentFanModule', 'equipmentHealthLed', 'equipmentIOExpander', 'equipmentIndicatorLed', 'equipmentInventoryStatus', 'equipmentLocatorLed', 'equipmentPOST', 'equipmentPsu', 'eventInst', 'fabricLocale', 'faultInst', 'faultSuppressTask', 'firmwareImageLock', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'lstorageProfile', 'mgmtController', 'mgmtKmipCertPolicy', 'mgmtSecurity', 'mgmtSpdmCertificatePolicy', 'moKvCfgHolder', 'moKvInvHolder', 'osAgent', 'osInstance', 'pciEquipSlot', 'pciUnit', 'powerBudget', 'solIf', 'storageEnclosure', 'storageVirtualDriveContainer', 'swUlan', 'sysdebugDiagnosticLog'], ["Get", "Set"]),
    "ComputeRackUnitFsm": MoMeta("ComputeRackUnitFsm", "computeRackUnitFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeRackUnit'], ['computeRackUnitFsmStage'], [None]),
    "ComputeRackUnitFsmStage": MoMeta("ComputeRackUnitFsmStage", "computeRackUnitFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeRackUnitFsm'], [], [None]),
    "ComputeRackUnitFsmTask": MoMeta("ComputeRackUnitFsmTask", "computeRackUnitFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['computeRackUnit'], [], [None]),
    "ComputeRackUnitMbTempStats": MoMeta("ComputeRackUnitMbTempStats", "computeRackUnitMbTempStats", "temp-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computeRackUnitMbTempStatsHist'], ["Get"]),
    "ComputeRackUnitMbTempStatsHist": MoMeta("ComputeRackUnitMbTempStatsHist", "computeRackUnitMbTempStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['computeRackUnitMbTempStats'], [], ["Get"]),
    "ComputeRebootLog": MoMeta("ComputeRebootLog", "computeRebootLog", "reboot-log-[id]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], [None]),
    "ComputeRtcBattery": MoMeta("ComputeRtcBattery", "computeRtcBattery", "rtc-battery", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst'], ["Get"]),
    "ComputeScrubPolicy": MoMeta("ComputeScrubPolicy", "computeScrubPolicy", "scrub-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeServerDiscPolicy": MoMeta("ComputeServerDiscPolicy", "computeServerDiscPolicy", "server-discovery", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['computeServerDiscPolicyFsm', 'computeServerDiscPolicyFsmTask', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "ComputeServerDiscPolicyFsm": MoMeta("ComputeServerDiscPolicyFsm", "computeServerDiscPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeServerDiscPolicy'], ['computeServerDiscPolicyFsmStage'], [None]),
    "ComputeServerDiscPolicyFsmStage": MoMeta("ComputeServerDiscPolicyFsmStage", "computeServerDiscPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeServerDiscPolicyFsm'], [], [None]),
    "ComputeServerDiscPolicyFsmTask": MoMeta("ComputeServerDiscPolicyFsmTask", "computeServerDiscPolicyFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['computeServerDiscPolicy'], [], [None]),
    "ComputeServerMgmtPolicy": MoMeta("ComputeServerMgmtPolicy", "computeServerMgmtPolicy", "server-mgmt-policy", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "ComputeServerTypeCap": MoMeta("ComputeServerTypeCap", "computeServerTypeCap", "server-type", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "ComputeServerUnit": MoMeta("ComputeServerUnit", "computeServerUnit", "server-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeCartridge'], ['aaaEpAuthProfile', 'aaaEpUser', 'adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'biosVIdentityParams', 'cimcvmediaMountConfigDef', 'computeAdminAck', 'computeBoard', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOperation', 'computeFwSyncAck', 'computeHostUtilityOs', 'computeKvmMgmtPolicy', 'computeMemoryConfiguration', 'computePhysicalExtension', 'computePhysicalFsm', 'computePhysicalFsmTask', 'computePnuOSImage', 'computePoolable', 'computeRebootLog', 'computeScrubPolicy', 'computeServerUnitFsm', 'computeServerUnitFsmTask', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentHealthLed', 'equipmentIOExpander', 'equipmentIndicatorLed', 'equipmentInventoryStatus', 'equipmentLocatorLed', 'equipmentPOST', 'eventInst', 'fabricLocale', 'faultInst', 'faultSuppressTask', 'firmwareImageLock', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'lstorageProfile', 'mgmtController', 'mgmtKmipCertPolicy', 'mgmtSecurity', 'mgmtSpdmCertificatePolicy', 'moKvCfgHolder', 'moKvInvHolder', 'osAgent', 'osInstance', 'pciEquipSlot', 'pciUnit', 'powerBudget', 'solIf', 'storageEnclosure', 'storageVirtualDriveContainer', 'swUlan', 'sysdebugDiagnosticLog'], ["Get", "Set"]),
    "ComputeServerUnitFsm": MoMeta("ComputeServerUnitFsm", "computeServerUnitFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['computeServerUnit'], ['computeServerUnitFsmStage'], [None]),
    "ComputeServerUnitFsmStage": MoMeta("ComputeServerUnitFsmStage", "computeServerUnitFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['computeServerUnitFsm'], [], [None]),
    "ComputeServerUnitFsmTask": MoMeta("ComputeServerUnitFsmTask", "computeServerUnitFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['computeServerUnit'], [], [None]),
    "ComputeSlotQual": MoMeta("ComputeSlotQual", "computeSlotQual", "slot-from-[min_id]-to-[max_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeChassisQual'], ['computeInstanceIdQual'], ["Add", "Get", "Remove"]),
    "ConfigImpact": MoMeta("ConfigImpact", "configImpact", "impact-[name]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['configManagedEpImpactResponse'], [], [None]),
    "ConfigManagedEpImpactResponse": MoMeta("ConfigManagedEpImpactResponse", "configManagedEpImpactResponse", "ManagedEpapp-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [], ['configImpact'], [None]),
    "ConfigSorter": MoMeta("ConfigSorter", "configSorter", "class-[sort_class]prop-[sort_prop]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ControllerHaController": MoMeta("ControllerHaController", "controllerHaController", "HaController", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['controllerOperationalVersionHolder', 'controllerPreferedVersionHolder'], ["Get", "Set"]),
    "ControllerMgmtDbCheckPol": MoMeta("ControllerMgmtDbCheckPol", "controllerMgmtDbCheckPol", "MgmtDbCheckPol", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['topSystem'], [], ["Get", "Set"]),
    "ControllerOperationalVersionHolder": MoMeta("ControllerOperationalVersionHolder", "controllerOperationalVersionHolder", "OpVersHolder-[serial]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['controllerHaController'], [], ["Get"]),
    "ControllerPreferedVersionHolder": MoMeta("ControllerPreferedVersionHolder", "controllerPreferedVersionHolder", "PrefVersHolder-[serial]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin"], ['controllerHaController'], [], ["Get"]),
    "CoprocessorCard": MoMeta("CoprocessorCard", "coprocessorCard", "coprocessor-card-[id]", VersionMeta.Version401a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], [], [None]),
    "CpmaintAck": MoMeta("CpmaintAck", "cpmaintAck", "ack", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile'], ['faultInst', 'trigLocalSched'], ["Get", "Set"]),
    "CpmaintMaintPolicy": MoMeta("CpmaintMaintPolicy", "cpmaintMaintPolicy", "chassis-profile-maint-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "DcxFcoeVifEp": MoMeta("DcxFcoeVifEp", "dcxFcoeVifEp", "fcoevif-[id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['swFcoeEstcEp', 'swFcoeSanEp', 'swFcoeSanPc'], ['swVsan'], ["Get"]),
    "DcxNs": MoMeta("DcxNs", "dcxNs", "dcxns-[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorUnit'], ['faultInst'], ["Get"]),
    "DcxUniverse": MoMeta("DcxUniverse", "dcxUniverse", "dcxns", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricEp'], ['dcxVifEp'], ["Get"]),
    "DcxVIf": MoMeta("DcxVIf", "dcxVIf", "vif-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorExtEthIf', 'adaptorExtEthIfPc', 'adaptorFcOEIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostServiceEthIf'], ['faultInst'], ["Get"]),
    "DcxVc": MoMeta("DcxVc", "dcxVc", "vc-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricLocale', 'fabricPath', 'swEthLanFlowMon', 'swEthMon', 'swFcMon'], ['fabricNetGroupRef', 'fabricSanGroupRef', 'faultInst', 'swCmclan', 'swNetflowMonitorRef', 'swUlan', 'swVlan', 'swVsan'], ["Get"]),
    "DcxVifEp": MoMeta("DcxVifEp", "dcxVifEp", "vif-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['dcxUniverse', 'swFcoeEstcEp', 'swFcoeSanEp', 'swFcoeSanPc'], ['swVsan'], ["Get"]),
    "DhcpAcquired": MoMeta("DhcpAcquired", "dhcpAcquired", "lease", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'mgmtIf'], [], ["Get"]),
    "DhcpInst": MoMeta("DhcpInst", "dhcpInst", "dhcp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['dhcpLease'], ["Get"]),
    "DhcpLease": MoMeta("DhcpLease", "dhcpLease", "lease-[ip]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['dhcpInst'], [], ["Get"]),
    "DiagLogEp": MoMeta("DiagLogEp", "diagLogEp", "logep-[switch_id]", VersionMeta.Version321d, "InputOutput", 0x1, [], [""], ['diagRslt'], [], [None]),
    "DiagMemoryTest": MoMeta("DiagMemoryTest", "diagMemoryTest", "test-[order]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['diagRunPolicy'], [], ["Get", "Set"]),
    "DiagRslt": MoMeta("DiagRslt", "diagRslt", "rslt-[id]", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], ['diagSrvCtrl'], ['diagLogEp'], ["Get"]),
    "DiagRunPolicy": MoMeta("DiagRunPolicy", "diagRunPolicy", "diag-policy-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['diagSrvCtrl', 'orgOrg'], ['diagMemoryTest'], ["Get"]),
    "DiagSrvCapProvider": MoMeta("DiagSrvCapProvider", "diagSrvCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "DiagSrvCtrl": MoMeta("DiagSrvCtrl", "diagSrvCtrl", "diag", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['diagRslt', 'diagRunPolicy', 'etherServerIntFIo'], ["Get"]),
    "DomainChassisFeature": MoMeta("DomainChassisFeature", "domainChassisFeature", "chassis-feature-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get", "Set"]),
    "DomainChassisFeatureCont": MoMeta("DomainChassisFeatureCont", "domainChassisFeatureCont", "chassis-feature-cont", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [None]),
    "DomainChassisParam": MoMeta("DomainChassisParam", "domainChassisParam", "chassis-param-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [], ["Get", "Set"]),
    "DomainEnvironmentFeature": MoMeta("DomainEnvironmentFeature", "domainEnvironmentFeature", "env-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], [None]),
    "DomainEnvironmentFeatureCont": MoMeta("DomainEnvironmentFeatureCont", "domainEnvironmentFeatureCont", "env-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [None]),
    "DomainEnvironmentParam": MoMeta("DomainEnvironmentParam", "domainEnvironmentParam", "env-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [], [None]),
    "DomainNetworkFeature": MoMeta("DomainNetworkFeature", "domainNetworkFeature", "network-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], [None]),
    "DomainNetworkFeatureCont": MoMeta("DomainNetworkFeatureCont", "domainNetworkFeatureCont", "network-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [None]),
    "DomainNetworkParam": MoMeta("DomainNetworkParam", "domainNetworkParam", "network-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [], [None]),
    "DomainServerFeature": MoMeta("DomainServerFeature", "domainServerFeature", "server-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], [None]),
    "DomainServerFeatureCont": MoMeta("DomainServerFeatureCont", "domainServerFeatureCont", "server-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [None]),
    "DomainServerParam": MoMeta("DomainServerParam", "domainServerParam", "server-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [], [None]),
    "DomainStorageFeature": MoMeta("DomainStorageFeature", "domainStorageFeature", "storage-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], [None]),
    "DomainStorageFeatureCont": MoMeta("DomainStorageFeatureCont", "domainStorageFeatureCont", "storage-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [None]),
    "DomainStorageParam": MoMeta("DomainStorageParam", "domainStorageParam", "storage-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature'], [], [None]),
    "DpsecMac": MoMeta("DpsecMac", "dpsecMac", "mac-sec", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['nwctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "DupeScope": MoMeta("DupeScope", "dupeScope", "scope-[id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "DupeScopeResult": MoMeta("DupeScopeResult", "dupeScopeResult", "result", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "EpqosDefinition": MoMeta("EpqosDefinition", "epqosDefinition", "ep-qos-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], ['orgOrg'], ['epqosDefinitionFsm', 'epqosDefinitionFsmTask', 'epqosEgress', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "EpqosDefinitionDelTask": MoMeta("EpqosDefinitionDelTask", "epqosDefinitionDelTask", "ep-qos-deletion-[def_int_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], ['orgOrg'], ['epqosDefinitionDelTaskFsm', 'epqosDefinitionDelTaskFsmTask', 'eventInst', 'faultInst'], [None]),
    "EpqosDefinitionDelTaskFsm": MoMeta("EpqosDefinitionDelTaskFsm", "epqosDefinitionDelTaskFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['epqosDefinitionDelTask'], ['epqosDefinitionDelTaskFsmStage'], [None]),
    "EpqosDefinitionDelTaskFsmStage": MoMeta("EpqosDefinitionDelTaskFsmStage", "epqosDefinitionDelTaskFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['epqosDefinitionDelTaskFsm'], [], [None]),
    "EpqosDefinitionDelTaskFsmTask": MoMeta("EpqosDefinitionDelTaskFsmTask", "epqosDefinitionDelTaskFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['epqosDefinitionDelTask'], [], [None]),
    "EpqosDefinitionFsm": MoMeta("EpqosDefinitionFsm", "epqosDefinitionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['epqosDefinition'], ['epqosDefinitionFsmStage'], [None]),
    "EpqosDefinitionFsmStage": MoMeta("EpqosDefinitionFsmStage", "epqosDefinitionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['epqosDefinitionFsm'], [], [None]),
    "EpqosDefinitionFsmTask": MoMeta("EpqosDefinitionFsmTask", "epqosDefinitionFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['epqosDefinition'], [], [None]),
    "EpqosEgress": MoMeta("EpqosEgress", "epqosEgress", "egress", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], ['epqosDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentAdaptorConnDef": MoMeta("EquipmentAdaptorConnDef", "equipmentAdaptorConnDef", "adaptor-port-[adaptor_ep]-iom-port-[iom_ep]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentBladeIOMConnDef', 'equipmentBladeSwitchConnDef'], [], ["Get"]),
    "EquipmentAdaptorDef": MoMeta("EquipmentAdaptorDef", "equipmentAdaptorDef", "adaptor", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider'], [], ["Get"]),
    "EquipmentAdvancedBootOrder": MoMeta("EquipmentAdvancedBootOrder", "equipmentAdvancedBootOrder", "advbootordsupp-[is_supported]", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentAutoConfigMode": MoMeta("EquipmentAutoConfigMode", "equipmentAutoConfigMode", "auto-config-mode", VersionMeta.Version421a, "InputOutput", 0x1, [], ["read-only"], ['equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentAutoconfigPolicy": MoMeta("EquipmentAutoconfigPolicy", "equipmentAutoconfigPolicy", "chassis-autoconfig-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['faultInst'], [None]),
    "EquipmentBaseBoardCapProvider": MoMeta("EquipmentBaseBoardCapProvider", "equipmentBaseBoardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentBeaconCapProvider": MoMeta("EquipmentBeaconCapProvider", "equipmentBeaconCapProvider", "beacon-cap", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentGemCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentBeaconLed": MoMeta("EquipmentBeaconLed", "equipmentBeaconLed", "beacon", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu', 'equipmentSwitchCard'], ['equipmentBeaconLedFsm', 'equipmentBeaconLedFsmTask', 'eventInst', 'faultInst'], ["Get"]),
    "EquipmentBeaconLedFsm": MoMeta("EquipmentBeaconLedFsm", "equipmentBeaconLedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentBeaconLed'], ['equipmentBeaconLedFsmStage'], [None]),
    "EquipmentBeaconLedFsmStage": MoMeta("EquipmentBeaconLedFsmStage", "equipmentBeaconLedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentBeaconLedFsm'], [], [None]),
    "EquipmentBeaconLedFsmTask": MoMeta("EquipmentBeaconLedFsmTask", "equipmentBeaconLedFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], ['equipmentBeaconLed'], [], [None]),
    "EquipmentBinding": MoMeta("EquipmentBinding", "equipmentBinding", "chassis", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['equipmentChassisProfile'], [], ["Get", "Set"]),
    "EquipmentBiosDef": MoMeta("EquipmentBiosDef", "equipmentBiosDef", "bios-def", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBiosTokenOverride": MoMeta("EquipmentBiosTokenOverride", "equipmentBiosTokenOverride", "bios-token-override-[bios_token_id]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get", "Set"]),
    "EquipmentBladeAGLibrary": MoMeta("EquipmentBladeAGLibrary", "equipmentBladeAGLibrary", "library-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBladeAggregationCapRef": MoMeta("EquipmentBladeAggregationCapRef", "equipmentBladeAggregationCapRef", "blade-aggr", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider'], ['equipmentPhysDevicesPerBoard'], ["Get"]),
    "EquipmentBladeBiosCapProvider": MoMeta("EquipmentBladeBiosCapProvider", "equipmentBladeBiosCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['biosRef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentBladeCapProvider": MoMeta("EquipmentBladeCapProvider", "equipmentBladeCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['adaptorFruCapRef', 'computeConstraintDef', 'computeMemoryUnitConstraintDef', 'computePciCap', 'computeServerTypeCap', 'equipmentAdvancedBootOrder', 'equipmentBiosDef', 'equipmentBiosTokenOverride', 'equipmentBladeAGLibrary', 'equipmentBladeAggregationCapRef', 'equipmentBladeCapProviderTypeDef', 'equipmentBladeConnDef', 'equipmentBoardControllerDef', 'equipmentBootDeviceConstraints', 'equipmentCimcVmedia', 'equipmentCiscoOsOpenGate', 'equipmentDimmMapping', 'equipmentDiscoveryCap', 'equipmentDriveSecCap', 'equipmentEmbeddedControllerConfig', 'equipmentFlexFlashNonRemovable', 'equipmentFruVariant', 'equipmentGraphicsCardCapRef', 'equipmentHDDFaultMonDef', 'equipmentHostMgmtControllerCap', 'equipmentHwRevisionModifier', 'equipmentInbandMgmtCap', 'equipmentKvmMgmtCap', 'equipmentLocalDiskControllerCapRef', 'equipmentManufacturingDef', 'equipmentNvmeDef', 'equipmentPciSlotIdMapping', 'equipmentPersonality', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPnuosBootMode', 'equipmentPowerCapDef', 'equipmentSecureBoot', 'equipmentServerCorrectUuidBehavior', 'equipmentServerFeatureCap', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'equipmentStorageControllerSlotDef', 'equipmentUuidFeatureCap', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint', 'storageEnclosureCap'], ["Get"]),
    "EquipmentBladeCapProviderTypeDef": MoMeta("EquipmentBladeCapProviderTypeDef", "equipmentBladeCapProviderTypeDef", "blade-provider-type", VersionMeta.Version224b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider'], [], ["Get"]),
    "EquipmentBladeConnDef": MoMeta("EquipmentBladeConnDef", "equipmentBladeConnDef", "adaptor-type-[adaptor_type]-family-[adaptor_family]-slot-[adaptor_slot_number]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentServerUnitCapProvider'], ['equipmentBladeIOMConnDef', 'equipmentBladeSwitchConnDef'], ["Get"]),
    "EquipmentBladeIOMConnDef": MoMeta("EquipmentBladeIOMConnDef", "equipmentBladeIOMConnDef", "-iom-type-[iocard_type]", VersionMeta.Version203a, "InputOutput", 0x1, [], [""], ['equipmentBladeConnDef'], ['equipmentAdaptorConnDef'], ["Get"]),
    "EquipmentBladeSwitchConnDef": MoMeta("EquipmentBladeSwitchConnDef", "equipmentBladeSwitchConnDef", "-switch-type-[switch_type]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['equipmentBladeConnDef'], ['equipmentAdaptorConnDef'], [None]),
    "EquipmentBoardControllerDef": MoMeta("EquipmentBoardControllerDef", "equipmentBoardControllerDef", "board-controller", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], ['equipmentDowngradeConstraint', 'equipmentFirmwareConstraint', 'equipmentVersionConstraint'], ["Get"]),
    "EquipmentBootDeviceConstraints": MoMeta("EquipmentBootDeviceConstraints", "equipmentBootDeviceConstraints", "bootdevconstr-[boot_dev_type]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentBreakoutCap": MoMeta("EquipmentBreakoutCap", "equipmentBreakoutCap", "breakout-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider'], [], [None]),
    "EquipmentCapModSpec": MoMeta("EquipmentCapModSpec", "equipmentCapModSpec", "modspec-[path]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['equipmentHwCapDerivativeProvider'], [], ["Get"]),
    "EquipmentCatalogCapProvider": MoMeta("EquipmentCatalogCapProvider", "equipmentCatalogCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentChassis": MoMeta("EquipmentChassis", "equipmentChassis", "chassis-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['topSystem'], ['computeBlade', 'computeBoardController', 'computeCartridge', 'computePsuControl', 'equipmentBeaconLed', 'equipmentChassisFsm', 'equipmentChassisFsmTask', 'equipmentChassisStats', 'equipmentComputeConn', 'equipmentFanModule', 'equipmentHealthLed', 'equipmentIOCard', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPoolable', 'equipmentPsu', 'equipmentSharedIOModule', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'eventInst', 'fabricLocale', 'faultInst', 'faultSuppressTask', 'firmwareActivity', 'firmwareActivityTrigger', 'firmwareImageLock', 'firmwareStatus', 'mgmtController', 'powerBudget', 'sesEnclosure', 'storageController', 'storageEnclosure', 'storageSasExpander', 'storageVirtualDriveContainer', 'vnicRackServerDiscoveryProfile'], ["Get", "Set"]),
    "EquipmentChassisAssocCtx": MoMeta("EquipmentChassisAssocCtx", "equipmentChassisAssocCtx", "cp-assoc-ctx", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassisProfileAssocCtx'], [], [None]),
    "EquipmentChassisCapProvider": MoMeta("EquipmentChassisCapProvider", "equipmentChassisCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPowerCapDef', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint', 'storageEnclosureCap', 'storageSasLinkDescriptor', 'storageSasPortDescriptor'], ["Get"]),
    "EquipmentChassisFsm": MoMeta("EquipmentChassisFsm", "equipmentChassisFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentChassis'], ['equipmentChassisFsmStage'], [None]),
    "EquipmentChassisFsmStage": MoMeta("EquipmentChassisFsmStage", "equipmentChassisFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentChassisFsm'], [], [None]),
    "EquipmentChassisFsmTask": MoMeta("EquipmentChassisFsmTask", "equipmentChassisFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['equipmentChassis'], [], [None]),
    "EquipmentChassisInheritPolicy": MoMeta("EquipmentChassisInheritPolicy", "equipmentChassisInheritPolicy", "chassis-inherit-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['faultInst'], [None]),
    "EquipmentChassisIssues": MoMeta("EquipmentChassisIssues", "equipmentChassisIssues", "config-issue", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile'], ['faultInst'], ["Get"]),
    "EquipmentChassisProfile": MoMeta("EquipmentChassisProfile", "equipmentChassisProfile", "cp-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentTier', 'orgOrg'], ['cpmaintAck', 'equipmentBinding', 'equipmentChassisIssues', 'equipmentChassisProfileAssocCtx', 'equipmentChassisProfileFsm', 'equipmentChassisProfileFsmTask', 'equipmentRequirement', 'eventInst', 'faultInst', 'lstorageDiskZoningConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "EquipmentChassisProfileAssocCtx": MoMeta("EquipmentChassisProfileAssocCtx", "equipmentChassisProfileAssocCtx", "cp-assoc-ctx", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassisProfile'], ['equipmentChassisAssocCtx'], ["Get"]),
    "EquipmentChassisProfileFsm": MoMeta("EquipmentChassisProfileFsm", "equipmentChassisProfileFsm", "fsm", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfile'], ['equipmentChassisProfileFsmStage'], [None]),
    "EquipmentChassisProfileFsmStage": MoMeta("EquipmentChassisProfileFsmStage", "equipmentChassisProfileFsmStage", "stage-[name]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfileFsm'], [], [None]),
    "EquipmentChassisProfileFsmTask": MoMeta("EquipmentChassisProfileFsmTask", "equipmentChassisProfileFsmTask", "task-[item]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfile'], [], [None]),
    "EquipmentChassisQual": MoMeta("EquipmentChassisQual", "equipmentChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['equipmentQual'], [], [None]),
    "EquipmentChassisStats": MoMeta("EquipmentChassisStats", "equipmentChassisStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentChassis'], ['equipmentChassisStatsHist'], ["Get"]),
    "EquipmentChassisStatsHist": MoMeta("EquipmentChassisStatsHist", "equipmentChassisStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentChassisStats'], [], ["Get"]),
    "EquipmentCimcVmedia": MoMeta("EquipmentCimcVmedia", "equipmentCimcVmedia", "cimcvmediasupp-[is_supported]", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentCiscoOsOpenGate": MoMeta("EquipmentCiscoOsOpenGate", "equipmentCiscoOsOpenGate", "ciscoosopengate-[is_supported]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentComputeConn": MoMeta("EquipmentComputeConn", "equipmentComputeConn", "compute-conn", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], ['faultInst'], [None]),
    "EquipmentComputeConnPolicy": MoMeta("EquipmentComputeConnPolicy", "equipmentComputeConnPolicy", "compute-conn-policy-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "EquipmentCoprocessorUnitCapProvider": MoMeta("EquipmentCoprocessorUnitCapProvider", "equipmentCoprocessorUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version401a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentDbgPluginCapProvider": MoMeta("EquipmentDbgPluginCapProvider", "equipmentDbgPluginCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentDiagFeatureSupport": MoMeta("EquipmentDiagFeatureSupport", "equipmentDiagFeatureSupport", "diag-feature-support", VersionMeta.Version323a, "InputOutput", 0x1, [], ["read-only"], ['equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentDimmEntry": MoMeta("EquipmentDimmEntry", "equipmentDimmEntry", "dimm-entry[id]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentDimmMapping'], [], ["Get"]),
    "EquipmentDimmMapping": MoMeta("EquipmentDimmMapping", "equipmentDimmMapping", "dimm-mapping", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], ['equipmentDimmEntry'], ["Get"]),
    "EquipmentDiscoveryCap": MoMeta("EquipmentDiscoveryCap", "equipmentDiscoveryCap", "disccap", VersionMeta.Version142b, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentDowngradeConstraint": MoMeta("EquipmentDowngradeConstraint", "equipmentDowngradeConstraint", "fw-dngrd-constr", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], ['equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentDriveSecCap": MoMeta("EquipmentDriveSecCap", "equipmentDriveSecCap", "drive-sec-cap", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentEmbeddedControllerConfig": MoMeta("EquipmentEmbeddedControllerConfig", "equipmentEmbeddedControllerConfig", "embedded-ctrl-cfg", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentSwitchCapProvider'], [], [None]),
    "EquipmentEmbeddedStorageDef": MoMeta("EquipmentEmbeddedStorageDef", "equipmentEmbeddedStorageDef", "embedded-storage", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider'], [], [None]),
    "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['equipmentFanModule', 'equipmentFex', 'networkElement'], ['equipmentFanStats', 'equipmentNetworkElementFanStats', 'equipmentRackUnitFanStats', 'faultInst'], ["Get"]),
    "EquipmentFanAggressiveCoolingCap": MoMeta("EquipmentFanAggressiveCoolingCap", "equipmentFanAggressiveCoolingCap", "fan-aggressive-cooling-cap", VersionMeta.Version421a, "InputOutput", 0x1, [], ["read-only"], ['equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeRackUnit', 'equipmentChassis', 'equipmentRackEnclosure', 'networkElement'], ['equipmentBeaconLed', 'equipmentFan', 'equipmentFanModuleStats', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'faultInst'], ["Get"]),
    "EquipmentFanModuleCapProvider": MoMeta("EquipmentFanModuleCapProvider", "equipmentFanModuleCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFanModuleDef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentFanModuleDef": MoMeta("EquipmentFanModuleDef", "equipmentFanModuleDef", "fanmod", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentFanModuleCapProvider'], [], ["Get"]),
    "EquipmentFanModuleStats": MoMeta("EquipmentFanModuleStats", "equipmentFanModuleStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFanModule'], ['equipmentFanModuleStatsHist'], ["Get"]),
    "EquipmentFanModuleStatsHist": MoMeta("EquipmentFanModuleStatsHist", "equipmentFanModuleStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFanModuleStats'], [], ["Get"]),
    "EquipmentFanPresenceDef": MoMeta("EquipmentFanPresenceDef", "equipmentFanPresenceDef", "fan-presence-[fan_module_number]", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentRackFanModuleDef'], [], [None]),
    "EquipmentFanStats": MoMeta("EquipmentFanStats", "equipmentFanStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentFanStatsHist'], ["Get"]),
    "EquipmentFanStatsHist": MoMeta("EquipmentFanStatsHist", "equipmentFanStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFanStats'], [], ["Get"]),
    "EquipmentFex": MoMeta("EquipmentFex", "equipmentFex", "fex-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['topSystem'], ['equipmentBeaconLed', 'equipmentFan', 'equipmentFexEnvStats', 'equipmentFexFsm', 'equipmentFexFsmTask', 'equipmentFexPowerSummary', 'equipmentFexPsuInputStats', 'equipmentFexSystemStats', 'equipmentHealthLed', 'equipmentIOCard', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPOST', 'equipmentPsu', 'eventInst', 'fabricLocale', 'faultInst', 'faultSuppressTask', 'mgmtController', 'powerBudget'], ["Get", "Set"]),
    "EquipmentFexCapProvider": MoMeta("EquipmentFexCapProvider", "equipmentFexCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPortGroupAggregationDef', 'equipmentPortGroupDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentFexEnvStats": MoMeta("EquipmentFexEnvStats", "equipmentFexEnvStats", "env-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex'], ['equipmentFexEnvStatsHist'], ["Get"]),
    "EquipmentFexEnvStatsHist": MoMeta("EquipmentFexEnvStatsHist", "equipmentFexEnvStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexEnvStats'], [], ["Get"]),
    "EquipmentFexFsm": MoMeta("EquipmentFexFsm", "equipmentFexFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentFex'], ['equipmentFexFsmStage'], [None]),
    "EquipmentFexFsmStage": MoMeta("EquipmentFexFsmStage", "equipmentFexFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentFexFsm'], [], [None]),
    "EquipmentFexFsmTask": MoMeta("EquipmentFexFsmTask", "equipmentFexFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['equipmentFex'], [], [None]),
    "EquipmentFexPowerSummary": MoMeta("EquipmentFexPowerSummary", "equipmentFexPowerSummary", "power-summary", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex'], ['equipmentFexPowerSummaryHist'], ["Get"]),
    "EquipmentFexPowerSummaryHist": MoMeta("EquipmentFexPowerSummaryHist", "equipmentFexPowerSummaryHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexPowerSummary'], [], ["Get"]),
    "EquipmentFexPsuInputStats": MoMeta("EquipmentFexPsuInputStats", "equipmentFexPsuInputStats", "fex-psu-input-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex', 'equipmentPsu'], ['equipmentFexPsuInputStatsHist'], ["Get"]),
    "EquipmentFexPsuInputStatsHist": MoMeta("EquipmentFexPsuInputStatsHist", "equipmentFexPsuInputStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexPsuInputStats'], [], ["Get"]),
    "EquipmentFexSystemStats": MoMeta("EquipmentFexSystemStats", "equipmentFexSystemStats", "sys-stats", VersionMeta.Version311e, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex'], ['equipmentFexSystemStatsHist'], [None]),
    "EquipmentFexSystemStatsHist": MoMeta("EquipmentFexSystemStatsHist", "equipmentFexSystemStatsHist", "[id]", VersionMeta.Version311e, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexSystemStats'], [], [None]),
    "EquipmentFirmwareConstraint": MoMeta("EquipmentFirmwareConstraint", "equipmentFirmwareConstraint", "fw-constr", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], ['equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentFlashLife": MoMeta("EquipmentFlashLife", "equipmentFlashLife", "[suport_type][card_param_type]", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentFlexFlashNonRemovable": MoMeta("EquipmentFlexFlashNonRemovable", "equipmentFlexFlashNonRemovable", "ff-non-removable", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentFruVariant": MoMeta("EquipmentFruVariant", "equipmentFruVariant", "fruVariant-[type]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentGemCapProvider": MoMeta("EquipmentGemCapProvider", "equipmentGemCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentBeaconCapProvider', 'equipmentFruVariant', 'equipmentGemPortCap', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServerPortCapProvider', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'equipmentUnifiedPortCapProvider', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentGemPortCap": MoMeta("EquipmentGemPortCap", "equipmentGemPortCap", "gem-port-cap-[port_number]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['equipmentGemCapProvider'], [], ["Get"]),
    "EquipmentGraphicsCardCapProvider": MoMeta("EquipmentGraphicsCardCapProvider", "equipmentGraphicsCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentGraphicsCardCapRef": MoMeta("EquipmentGraphicsCardCapRef", "equipmentGraphicsCardCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentHDDFaultMonDef": MoMeta("EquipmentHDDFaultMonDef", "equipmentHDDFaultMonDef", "[controller_fw_version][hdd_mon_support]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentHealthLed": MoMeta("EquipmentHealthLed", "equipmentHealthLed", "health-led", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu'], ['computeHealthLedSensorAlarm', 'faultInst'], ["Get"]),
    "EquipmentHostIfCapProvider": MoMeta("EquipmentHostIfCapProvider", "equipmentHostIfCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentHostMgmtControllerCap": MoMeta("EquipmentHostMgmtControllerCap", "equipmentHostMgmtControllerCap", "host-mgmt-controller-cap", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentHwCapDerivativeProvider": MoMeta("EquipmentHwCapDerivativeProvider", "equipmentHwCapDerivativeProvider", "derivative-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCapModSpec', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], ["Get"]),
    "EquipmentHwRevisionModifier": MoMeta("EquipmentHwRevisionModifier", "equipmentHwRevisionModifier", "hw-rev-modifier-[hw_type]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentHxCap": MoMeta("EquipmentHxCap", "equipmentHxCap", "hx-cap", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentIOCard": MoMeta("EquipmentIOCard", "equipmentIOCard", "slot-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis', 'equipmentFex'], ['equipmentBeaconLed', 'equipmentHealthLed', 'equipmentIOCardBaseFsm', 'equipmentIOCardBaseFsmTask', 'equipmentIOCardFsm', 'equipmentIOCardFsmTask', 'equipmentIOCardStats', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPOST', 'eventInst', 'faultInst', 'faultSuppressTask', 'firmwareStatus', 'mgmtController', 'portGroup'], ["Get", "Set"]),
    "EquipmentIOCardBaseFsm": MoMeta("EquipmentIOCardBaseFsm", "equipmentIOCardBaseFsm", "fsm", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentIOCard', 'equipmentSwitchIOCard'], ['equipmentIOCardBaseFsmStage'], [None]),
    "EquipmentIOCardBaseFsmStage": MoMeta("EquipmentIOCardBaseFsmStage", "equipmentIOCardBaseFsmStage", "stage-[name]", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentIOCardBaseFsm'], [], [None]),
    "EquipmentIOCardBaseFsmTask": MoMeta("EquipmentIOCardBaseFsmTask", "equipmentIOCardBaseFsmTask", "task-[item]", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentIOCard', 'equipmentSwitchIOCard'], [], [None]),
    "EquipmentIOCardCapProvider": MoMeta("EquipmentIOCardCapProvider", "equipmentIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentIOCardTypeDef', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPortGroupAggregationDef', 'equipmentPortGroupDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentIOCardFsm": MoMeta("EquipmentIOCardFsm", "equipmentIOCardFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentIOCard'], ['equipmentIOCardFsmStage'], [None]),
    "EquipmentIOCardFsmStage": MoMeta("EquipmentIOCardFsmStage", "equipmentIOCardFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentIOCardFsm'], [], [None]),
    "EquipmentIOCardFsmTask": MoMeta("EquipmentIOCardFsmTask", "equipmentIOCardFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['equipmentIOCard'], [], [None]),
    "EquipmentIOCardStats": MoMeta("EquipmentIOCardStats", "equipmentIOCardStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentIOCard', 'equipmentSwitchIOCard'], ['equipmentIOCardStatsHist'], ["Get"]),
    "EquipmentIOCardStatsHist": MoMeta("EquipmentIOCardStatsHist", "equipmentIOCardStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentIOCardStats'], [], ["Get"]),
    "EquipmentIOCardTypeDef": MoMeta("EquipmentIOCardTypeDef", "equipmentIOCardTypeDef", "type", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['equipmentIOCardCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentIOExpander": MoMeta("EquipmentIOExpander", "equipmentIOExpander", "io-expander-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "EquipmentIOExpanderCapProvider": MoMeta("EquipmentIOExpanderCapProvider", "equipmentIOExpanderCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentInbandMgmtCap": MoMeta("EquipmentInbandMgmtCap", "equipmentInbandMgmtCap", "ib-mgmt-cap", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu'], [], ["Get"]),
    "EquipmentInventoryStatus": MoMeta("EquipmentInventoryStatus", "equipmentInventoryStatus", "inv-status", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['adaptorUnit', 'adaptorUnitExtn', 'computeBlade', 'computeRackUnit', 'computeServerUnit', 'graphicsCard', 'memoryUnit', 'processorUnit', 'securityUnit', 'storageController', 'storageMiniStorage'], ['faultInst'], ["Get", "Set"]),
    "EquipmentKvmMgmtCap": MoMeta("EquipmentKvmMgmtCap", "equipmentKvmMgmtCap", "kvm-mgmt-cap", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskCapProvider": MoMeta("EquipmentLocalDiskCapProvider", "equipmentLocalDiskCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentDriveSecCap', 'equipmentFruVariant', 'equipmentLocalDiskDef', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentLocalDiskControllerCapProvider": MoMeta("EquipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['adaptorFamilyTypeDef', 'equipmentDriveSecCap', 'equipmentEmbeddedStorageDef', 'equipmentFlashLife', 'equipmentFruVariant', 'equipmentLocalDiskControllerDef', 'equipmentLocalDiskControllerTypeDef', 'equipmentManufacturingDef', 'equipmentOnboardDeviceDef', 'equipmentPciDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentRaidDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'equipmentStorageLimitCap', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentLocalDiskControllerCapRef": MoMeta("EquipmentLocalDiskControllerCapRef", "equipmentLocalDiskControllerCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version142b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskControllerDef": MoMeta("EquipmentLocalDiskControllerDef", "equipmentLocalDiskControllerDef", "disk-controller", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskControllerTypeDef": MoMeta("EquipmentLocalDiskControllerTypeDef", "equipmentLocalDiskControllerTypeDef", "controller-type", VersionMeta.Version224b, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskDef": MoMeta("EquipmentLocalDiskDef", "equipmentLocalDiskDef", "disk", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskCapProvider'], [], ["Get"]),
    "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu', 'networkElement', 'storageLocalDisk'], ['equipmentLocatorLedFsm', 'equipmentLocatorLedFsmTask', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "EquipmentLocatorLedFsm": MoMeta("EquipmentLocatorLedFsm", "equipmentLocatorLedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentLocatorLed'], ['equipmentLocatorLedFsmStage'], [None]),
    "EquipmentLocatorLedFsmStage": MoMeta("EquipmentLocatorLedFsmStage", "equipmentLocatorLedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['equipmentLocatorLedFsm'], [], [None]),
    "EquipmentLocatorLedFsmTask": MoMeta("EquipmentLocatorLedFsmTask", "equipmentLocatorLedFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['equipmentLocatorLed'], [], [None]),
    "EquipmentManufacturingDef": MoMeta("EquipmentManufacturingDef", "equipmentManufacturingDef", "manufacturing", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentMemoryUnitCapProvider": MoMeta("EquipmentMemoryUnitCapProvider", "equipmentMemoryUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentMemoryUnitDiscoveryModifierDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentMemoryUnitDiscoveryModifierDef": MoMeta("EquipmentMemoryUnitDiscoveryModifierDef", "equipmentMemoryUnitDiscoveryModifierDef", "discmod-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], [""], ['equipmentMemoryUnitCapProvider'], [], ["Get"]),
    "EquipmentMgmtCapProvider": MoMeta("EquipmentMgmtCapProvider", "equipmentMgmtCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentMgmtExtCapProvider": MoMeta("EquipmentMgmtExtCapProvider", "equipmentMgmtExtCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentMiniStorageCapProvider": MoMeta("EquipmentMiniStorageCapProvider", "equipmentMiniStorageCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version321d, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get", "Set"]),
    "EquipmentNetworkElementFanStats": MoMeta("EquipmentNetworkElementFanStats", "equipmentNetworkElementFanStats", "stats", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentNetworkElementFanStatsHist'], ["Get"]),
    "EquipmentNetworkElementFanStatsHist": MoMeta("EquipmentNetworkElementFanStatsHist", "equipmentNetworkElementFanStatsHist", "[id]", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["read-only"], ['equipmentNetworkElementFanStats'], [], ["Get"]),
    "EquipmentNonCopperPassiveCap": MoMeta("EquipmentNonCopperPassiveCap", "equipmentNonCopperPassiveCap", "non-copper-passive-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider'], [], [None]),
    "EquipmentNvmeDef": MoMeta("EquipmentNvmeDef", "equipmentNvmeDef", "nvme-def", VersionMeta.Version321d, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentNvmeSwitchConfig": MoMeta("EquipmentNvmeSwitchConfig", "equipmentNvmeSwitchConfig", "nvme-switch-config", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentStorageNvmeSwitchCapProvider'], [], [None]),
    "EquipmentOnboardDeviceDef": MoMeta("EquipmentOnboardDeviceDef", "equipmentOnboardDeviceDef", "onboard-device-[device]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider', 'equipmentStorageSasExpanderCapProvider'], ['firmwareType'], [None]),
    "EquipmentPOST": MoMeta("EquipmentPOST", "equipmentPOST", "code-[global_id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['adaptorUnit', 'computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentFex', 'equipmentIOCard'], [], ["Get"]),
    "EquipmentPOSTCode": MoMeta("EquipmentPOSTCode", "equipmentPOSTCode", "code-[local_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['equipmentPOSTCodeReporter', 'equipmentPOSTCodeTemplate'], [], ["Get"]),
    "EquipmentPOSTCodeReporter": MoMeta("EquipmentPOSTCodeReporter", "equipmentPOSTCodeReporter", "POST-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['capabilityCatalogue'], ['bmcSELCounter', 'equipmentPOSTCode'], ["Get"]),
    "EquipmentPOSTCodeTemplate": MoMeta("EquipmentPOSTCodeTemplate", "equipmentPOSTCodeTemplate", "POST-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['capabilityCatalogue'], ['equipmentPOSTCode'], ["Get"]),
    "EquipmentPciDef": MoMeta("EquipmentPciDef", "equipmentPciDef", "pci-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'adaptorUnit', 'equipmentCoprocessorUnitCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentPciSwitchCapProvider'], [], ["Get"]),
    "EquipmentPciSlotIdEntry": MoMeta("EquipmentPciSlotIdEntry", "equipmentPciSlotIdEntry", "pci-slotid-entry-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentPciSlotIdMapping'], [], ["Get"]),
    "EquipmentPciSlotIdMapping": MoMeta("EquipmentPciSlotIdMapping", "equipmentPciSlotIdMapping", "pci-slotid-mapping", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], ['equipmentPciSlotIdEntry'], ["Get"]),
    "EquipmentPciSlotSubOEMIdEntry": MoMeta("EquipmentPciSlotSubOEMIdEntry", "equipmentPciSlotSubOEMIdEntry", "pci-slot-suboemid-entry-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentStorageControllerConfig'], [], ["Get"]),
    "EquipmentPciSwitchCapProvider": MoMeta("EquipmentPciSwitchCapProvider", "equipmentPciSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version402a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentPcieSlotOrientation": MoMeta("EquipmentPcieSlotOrientation", "equipmentPcieSlotOrientation", "pcie-slot-orientation-[slot_number]", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentPersistentMemoryUnitCapProvider": MoMeta("EquipmentPersistentMemoryUnitCapProvider", "equipmentPersistentMemoryUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version404a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentPersonality": MoMeta("EquipmentPersonality", "equipmentPersonality", "personality", VersionMeta.Version421a, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentPfcMmuCap": MoMeta("EquipmentPfcMmuCap", "equipmentPfcMmuCap", "pfc-mmu-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider'], [], [None]),
    "EquipmentPhysDevicesPerBoard": MoMeta("EquipmentPhysDevicesPerBoard", "equipmentPhysDevicesPerBoard", "phys-dev-per-board", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], ['equipmentBladeAggregationCapRef'], [], ["Get"]),
    "EquipmentPhysicalDef": MoMeta("EquipmentPhysicalDef", "equipmentPhysicalDef", "physical", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentPhysicalQual": MoMeta("EquipmentPhysicalQual", "equipmentPhysicalQual", "physicalqual", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['equipmentQual'], [], [None]),
    "EquipmentPicture": MoMeta("EquipmentPicture", "equipmentPicture", "picture-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentPnuosBootMode": MoMeta("EquipmentPnuosBootMode", "equipmentPnuosBootMode", "pnuosBootMode", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentPool": MoMeta("EquipmentPool", "equipmentPool", "equipment-pool-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['equipmentPooledChassis'], [None]),
    "EquipmentPoolPolicyRef": MoMeta("EquipmentPoolPolicyRef", "equipmentPoolPolicyRef", "chassis-poolref-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['equipmentPoolable'], [], [None]),
    "EquipmentPoolable": MoMeta("EquipmentPoolable", "equipmentPoolable", "chassis-pool-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], ['equipmentPoolPolicyRef'], [None]),
    "EquipmentPooledChassis": MoMeta("EquipmentPooledChassis", "equipmentPooledChassis", "chassis-[chassis_id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['equipmentPool'], [], [None]),
    "EquipmentPoolingPolicy": MoMeta("EquipmentPoolingPolicy", "equipmentPoolingPolicy", "chassis-pooling-policy-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], [None]),
    "EquipmentPortCap": MoMeta("EquipmentPortCap", "equipmentPortCap", "port-cap-start-[start_port_id]-end-[end_port_id]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['equipmentSwitchCap', 'equipmentSwitchIOCardCapProvider'], [], [None]),
    "EquipmentPortGroupAggregationDef": MoMeta("EquipmentPortGroupAggregationDef", "equipmentPortGroupAggregationDef", "port-group-aggr-def-[type]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'equipmentFexCapProvider', 'equipmentIOCardCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentPortGroupDef": MoMeta("EquipmentPortGroupDef", "equipmentPortGroupDef", "port-group-def[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'equipmentFexCapProvider', 'equipmentIOCardCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentPortGroupSwComplexDef": MoMeta("EquipmentPortGroupSwComplexDef", "equipmentPortGroupSwComplexDef", "port-group-sw-complex-def[asic]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider'], ['equipmentPortSwComplexRef'], ["Get"]),
    "EquipmentPortSwComplexRef": MoMeta("EquipmentPortSwComplexRef", "equipmentPortSwComplexRef", "port-sw-complex-ref-[sw_complex_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentPortGroupSwComplexDef'], [], ["Get"]),
    "EquipmentPowerCapDef": MoMeta("EquipmentPowerCapDef", "equipmentPowerCapDef", "powercap", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentProcessorUnitCapProvider": MoMeta("EquipmentProcessorUnitCapProvider", "equipmentProcessorUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentProcessorUnitDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentProcessorUnitDef": MoMeta("EquipmentProcessorUnitDef", "equipmentProcessorUnitDef", "cpu", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['equipmentProcessorUnitCapProvider'], [], ["Get"]),
    "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeRackUnit', 'equipmentChassis', 'equipmentFex', 'equipmentRackEnclosure', 'networkElement'], ['equipmentBeaconLed', 'equipmentFexPsuInputStats', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsuFsm', 'equipmentPsuFsmTask', 'equipmentPsuInputStats', 'equipmentPsuOutputStats', 'equipmentPsuStats', 'equipmentRackUnitPsuStats', 'eventInst', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareStatus', 'firmwareUpdatable'], ["Get"]),
    "EquipmentPsuCapProvider": MoMeta("EquipmentPsuCapProvider", "equipmentPsuCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPsuDef', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentPsuDef": MoMeta("EquipmentPsuDef", "equipmentPsuDef", "[psu_type]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentPsuCapProvider'], [], ["Get"]),
    "EquipmentPsuFsm": MoMeta("EquipmentPsuFsm", "equipmentPsuFsm", "fsm", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentPsu'], ['equipmentPsuFsmStage'], [None]),
    "EquipmentPsuFsmStage": MoMeta("EquipmentPsuFsmStage", "equipmentPsuFsmStage", "stage-[name]", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentPsuFsm'], [], [None]),
    "EquipmentPsuFsmTask": MoMeta("EquipmentPsuFsmTask", "equipmentPsuFsmTask", "task-[item]", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentPsu'], [], [None]),
    "EquipmentPsuInputStats": MoMeta("EquipmentPsuInputStats", "equipmentPsuInputStats", "input-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuInputStatsHist'], ["Get"]),
    "EquipmentPsuInputStatsHist": MoMeta("EquipmentPsuInputStatsHist", "equipmentPsuInputStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuInputStats'], [], ["Get"]),
    "EquipmentPsuOutputStats": MoMeta("EquipmentPsuOutputStats", "equipmentPsuOutputStats", "output-stats", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuOutputStatsHist'], ["Get"]),
    "EquipmentPsuOutputStatsHist": MoMeta("EquipmentPsuOutputStatsHist", "equipmentPsuOutputStatsHist", "[id]", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuOutputStats'], [], ["Get"]),
    "EquipmentPsuStats": MoMeta("EquipmentPsuStats", "equipmentPsuStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuStatsHist'], ["Get"]),
    "EquipmentPsuStatsHist": MoMeta("EquipmentPsuStatsHist", "equipmentPsuStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuStats'], [], ["Get"]),
    "EquipmentQual": MoMeta("EquipmentQual", "equipmentQual", "chassis-qualifier-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['equipmentChassisQual', 'equipmentPhysicalQual'], [None]),
    "EquipmentRackEnclosure": MoMeta("EquipmentRackEnclosure", "equipmentRackEnclosure", "rack-enclosure-[id]", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['topSystem'], ['equipmentFanModule', 'equipmentPsu', 'equipmentSlotEp'], [None]),
    "EquipmentRackEnclosureCapProvider": MoMeta("EquipmentRackEnclosureCapProvider", "equipmentRackEnclosureCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version401a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentRackFanModuleDef": MoMeta("EquipmentRackFanModuleDef", "equipmentRackFanModuleDef", "rack-fan-module", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], ['equipmentRackUnitCapProvider'], ['equipmentFanPresenceDef'], [None]),
    "EquipmentRackUnitCapProvider": MoMeta("EquipmentRackUnitCapProvider", "equipmentRackUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['adaptorFruCapRef', 'computeConstraintDef', 'computeMemoryUnitConstraintDef', 'computePciCap', 'computeServerTypeCap', 'equipmentAdvancedBootOrder', 'equipmentAutoConfigMode', 'equipmentBiosDef', 'equipmentBiosTokenOverride', 'equipmentBladeAGLibrary', 'equipmentBoardControllerDef', 'equipmentBootDeviceConstraints', 'equipmentCimcVmedia', 'equipmentCiscoOsOpenGate', 'equipmentDiagFeatureSupport', 'equipmentDimmMapping', 'equipmentDiscoveryCap', 'equipmentDriveSecCap', 'equipmentEmbeddedControllerConfig', 'equipmentFanAggressiveCoolingCap', 'equipmentFlexFlashNonRemovable', 'equipmentFruVariant', 'equipmentGraphicsCardCapRef', 'equipmentHostMgmtControllerCap', 'equipmentHwRevisionModifier', 'equipmentHxCap', 'equipmentInbandMgmtCap', 'equipmentKvmMgmtCap', 'equipmentLocalDiskControllerCapRef', 'equipmentManufacturingDef', 'equipmentNvmeDef', 'equipmentPciSlotIdMapping', 'equipmentPcieSlotOrientation', 'equipmentPersonality', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPnuosBootMode', 'equipmentPowerCapDef', 'equipmentRackFanModuleDef', 'equipmentSecureBoot', 'equipmentServerCorrectUuidBehavior', 'equipmentServerFeatureCap', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentSpdmCertificateCap', 'equipmentStorageControllerConfig', 'equipmentStorageControllerSlotDef', 'equipmentStorageSasExpanderCapRef', 'equipmentUuidFeatureCap', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint', 'storageEnclosureCap'], ["Get"]),
    "EquipmentRackUnitFanStats": MoMeta("EquipmentRackUnitFanStats", "equipmentRackUnitFanStats", "stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentRackUnitFanStatsHist'], ["Get"]),
    "EquipmentRackUnitFanStatsHist": MoMeta("EquipmentRackUnitFanStatsHist", "equipmentRackUnitFanStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['equipmentRackUnitFanStats'], [], ["Get"]),
    "EquipmentRackUnitPsuStats": MoMeta("EquipmentRackUnitPsuStats", "equipmentRackUnitPsuStats", "rackunit-power-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentRackUnitPsuStatsHist'], ["Get"]),
    "EquipmentRackUnitPsuStatsHist": MoMeta("EquipmentRackUnitPsuStatsHist", "equipmentRackUnitPsuStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['equipmentRackUnitPsuStats'], [], ["Get"]),
    "EquipmentRaidDef": MoMeta("EquipmentRaidDef", "equipmentRaidDef", "[level]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentRequirement": MoMeta("EquipmentRequirement", "equipmentRequirement", "chassis-req", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['equipmentChassisProfile'], ['faultInst'], [None]),
    "EquipmentSecureBoot": MoMeta("EquipmentSecureBoot", "equipmentSecureBoot", "secBoot", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentSecurityUnitCapProvider": MoMeta("EquipmentSecurityUnitCapProvider", "equipmentSecurityUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentServerCorrectUuidBehavior": MoMeta("EquipmentServerCorrectUuidBehavior", "equipmentServerCorrectUuidBehavior", "server-correct-uuid", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentServerFeatureCap": MoMeta("EquipmentServerFeatureCap", "equipmentServerFeatureCap", "server-feature-cap", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerPortCapProvider": MoMeta("EquipmentServerPortCapProvider", "equipmentServerPortCapProvider", "server-port-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], ['equipmentGemCapProvider', 'equipmentSwitchIOCardCapProvider'], [], [None]),
    "EquipmentServerUnitCapProvider": MoMeta("EquipmentServerUnitCapProvider", "equipmentServerUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version251a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['computePciCap', 'equipmentBiosDef', 'equipmentBladeAGLibrary', 'equipmentBladeConnDef', 'equipmentBoardControllerDef', 'equipmentDimmMapping', 'equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentHDDFaultMonDef', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServerFeatureCap', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentServiceDef": MoMeta("EquipmentServiceDef", "equipmentServiceDef", "service", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentSharedIOModule": MoMeta("EquipmentSharedIOModule", "equipmentSharedIOModule", "shared-io-module", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis', 'equipmentSystemIOController'], ['faultInst', 'mgmtController', 'portGroup'], ["Get", "Set"]),
    "EquipmentSiocCapProvider": MoMeta("EquipmentSiocCapProvider", "equipmentSiocCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version401a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentSiocTempStats": MoMeta("EquipmentSiocTempStats", "equipmentSiocTempStats", "temp-stats", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentSystemIOController'], ['equipmentSiocTempStatsHist'], ["Get"]),
    "EquipmentSiocTempStatsHist": MoMeta("EquipmentSiocTempStatsHist", "equipmentSiocTempStatsHist", "[id]", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["read-only"], ['equipmentSiocTempStats'], [], ["Get"]),
    "EquipmentSlotArray": MoMeta("EquipmentSlotArray", "equipmentSlotArray", "[selector]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentSwitchCapProvider'], [], ["Get"]),
    "EquipmentSlotArrayRef": MoMeta("EquipmentSlotArrayRef", "equipmentSlotArrayRef", "ref-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentSlotEp": MoMeta("EquipmentSlotEp", "equipmentSlotEp", "slot-ep-[id]", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentRackEnclosure'], [], [None]),
    "EquipmentSpdmCertificateCap": MoMeta("EquipmentSpdmCertificateCap", "equipmentSpdmCertificateCap", "spdm-certificate-cap", VersionMeta.Version421a, "InputOutput", 0x1, [], ["read-only"], ['equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentSpeedCompatibility": MoMeta("EquipmentSpeedCompatibility", "equipmentSpeedCompatibility", "speed-cap", VersionMeta.Version401a, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider'], [], [None]),
    "EquipmentStorageControllerConfig": MoMeta("EquipmentStorageControllerConfig", "equipmentStorageControllerConfig", "ven-[vendor]-dev-[device]-subven-[subvendor]-subdev-[subdevice]", VersionMeta.Version225a, "InputOutput", 0x1, [], [""], ['diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentSwitchCapProvider'], ['equipmentPciSlotSubOEMIdEntry'], ["Get"]),
    "EquipmentStorageControllerSlotDef": MoMeta("EquipmentStorageControllerSlotDef", "equipmentStorageControllerSlotDef", "controller-slot-def-[slot_num]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentStorageEncCapProvider": MoMeta("EquipmentStorageEncCapProvider", "equipmentStorageEncCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentStorageControllerConfig', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentStorageLimitCap": MoMeta("EquipmentStorageLimitCap", "equipmentStorageLimitCap", "storage-limit", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], ['equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentStorageNvmeSwitchCapProvider": MoMeta("EquipmentStorageNvmeSwitchCapProvider", "equipmentStorageNvmeSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentNvmeSwitchConfig', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'equipmentStorageNvmeSwitchDef', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentStorageNvmeSwitchDef": MoMeta("EquipmentStorageNvmeSwitchDef", "equipmentStorageNvmeSwitchDef", "mswitch-def", VersionMeta.Version323a, "InputOutput", 0x1, [], [""], ['equipmentStorageNvmeSwitchCapProvider'], [], [None]),
    "EquipmentStorageSasExpanderCapProvider": MoMeta("EquipmentStorageSasExpanderCapProvider", "equipmentStorageSasExpanderCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version226c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentOnboardDeviceDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'equipmentStorageSasExpanderDef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentStorageSasExpanderCapRef": MoMeta("EquipmentStorageSasExpanderCapRef", "equipmentStorageSasExpanderCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version226c, "InputOutput", 0x1, [], [""], ['equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentStorageSasExpanderDef": MoMeta("EquipmentStorageSasExpanderDef", "equipmentStorageSasExpanderDef", "sas-expander-def", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentStorageSasExpanderCapProvider'], [], ["Get"]),
    "EquipmentSwitchCap": MoMeta("EquipmentSwitchCap", "equipmentSwitchCap", "switch-cap", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], ['equipmentPortCap'], ["Get"]),
    "EquipmentSwitchCapProvider": MoMeta("EquipmentSwitchCapProvider", "equipmentSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentBeaconCapProvider', 'equipmentBreakoutCap', 'equipmentEmbeddedControllerConfig', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentNonCopperPassiveCap', 'equipmentPfcMmuCap', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPortGroupAggregationDef', 'equipmentPortGroupSwComplexDef', 'equipmentServiceDef', 'equipmentSlotArray', 'equipmentSlotArrayRef', 'equipmentSpeedCompatibility', 'equipmentStorageControllerConfig', 'equipmentSwitchCap', 'equipmentUnifiedPortCapProvider', 'firmwareConstraints', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentSwitchCard": MoMeta("EquipmentSwitchCard", "equipmentSwitchCard", "slot-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['equipmentBeaconLed', 'faultInst', 'portGroup'], ["Get"]),
    "EquipmentSwitchIOCard": MoMeta("EquipmentSwitchIOCard", "equipmentSwitchIOCard", "sw-slot-[id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['equipmentIOCardBaseFsm', 'equipmentIOCardBaseFsmTask', 'equipmentIOCardStats', 'equipmentSwitchIOCardFsm', 'equipmentSwitchIOCardFsmTask', 'eventInst', 'faultInst', 'mgmtController', 'portGroup'], [None]),
    "EquipmentSwitchIOCardCapProvider": MoMeta("EquipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentBeaconCapProvider', 'equipmentFruVariant', 'equipmentIOCardTypeDef', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentPortCap', 'equipmentPortGroupAggregationDef', 'equipmentPortGroupDef', 'equipmentServerPortCapProvider', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'equipmentSwitchCap', 'equipmentUnifiedPortCapProvider', 'firmwareType', 'firmwareUpgradeConstraint'], [None]),
    "EquipmentSwitchIOCardFsm": MoMeta("EquipmentSwitchIOCardFsm", "equipmentSwitchIOCardFsm", "fsm", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentSwitchIOCard'], ['equipmentSwitchIOCardFsmStage'], [None]),
    "EquipmentSwitchIOCardFsmStage": MoMeta("EquipmentSwitchIOCardFsmStage", "equipmentSwitchIOCardFsmStage", "stage-[name]", VersionMeta.Version302c, "OutputOnly", 0x1, [], [""], ['equipmentSwitchIOCardFsm'], [], [None]),
    "EquipmentSwitchIOCardFsmTask": MoMeta("EquipmentSwitchIOCardFsmTask", "equipmentSwitchIOCardFsmTask", "task-[item]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], ['equipmentSwitchIOCard'], [], [None]),
    "EquipmentSwitchTypeDef": MoMeta("EquipmentSwitchTypeDef", "equipmentSwitchTypeDef", "type", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], [], [], [None]),
    "EquipmentSystemIOController": MoMeta("EquipmentSystemIOController", "equipmentSystemIOController", "slot-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['computeBoardController', 'equipmentSharedIOModule', 'equipmentSiocTempStats', 'equipmentSystemIOControllerFsm', 'equipmentSystemIOControllerFsmTask', 'eventInst', 'faultInst', 'mgmtController'], ["Get", "Set"]),
    "EquipmentSystemIOControllerFsm": MoMeta("EquipmentSystemIOControllerFsm", "equipmentSystemIOControllerFsm", "fsm", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentSystemIOController'], ['equipmentSystemIOControllerFsmStage'], [None]),
    "EquipmentSystemIOControllerFsmStage": MoMeta("EquipmentSystemIOControllerFsmStage", "equipmentSystemIOControllerFsmStage", "stage-[name]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentSystemIOControllerFsm'], [], [None]),
    "EquipmentSystemIOControllerFsmTask": MoMeta("EquipmentSystemIOControllerFsmTask", "equipmentSystemIOControllerFsmTask", "task-[item]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['equipmentSystemIOController'], [], [None]),
    "EquipmentTier": MoMeta("EquipmentTier", "equipmentTier", "cp-tier-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], ['equipmentChassisProfile'], [None]),
    "EquipmentTpm": MoMeta("EquipmentTpm", "equipmentTpm", "Tpm-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBoard'], ['faultInst'], ["Get"]),
    "EquipmentTpmCapProvider": MoMeta("EquipmentTpmCapProvider", "equipmentTpmCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], ['capabilityCatalogue', 'equipmentHwCapDerivativeProvider'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPhysicalDef', 'equipmentPicture', 'equipmentServiceDef', 'equipmentSlotArrayRef', 'firmwareType', 'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentUnifiedPortCapProvider": MoMeta("EquipmentUnifiedPortCapProvider", "equipmentUnifiedPortCapProvider", "unified-port-cap", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], ['equipmentGemCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentUuidFeatureCap": MoMeta("EquipmentUuidFeatureCap", "equipmentUuidFeatureCap", "uuid-feature-cap", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentVersionConstraint": MoMeta("EquipmentVersionConstraint", "equipmentVersionConstraint", "ver-constr", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], ['equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentXcvr": MoMeta("EquipmentXcvr", "equipmentXcvr", "transceiver", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['etherPIo', 'etherServerIntFIo', 'etherSwitchIntFIo', 'fcPIo'], [], ["Get"]),
    "EtherErrStats": MoMeta("EtherErrStats", "etherErrStats", "err-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherServerIntFIo', 'fabricEthEstcPc', 'fabricEthLanPc'], ['etherErrStatsHist'], ["Get"]),
    "EtherErrStatsHist": MoMeta("EtherErrStatsHist", "etherErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['etherErrStats'], [], ["Get"]),
    "EtherFcoeInterfaceStats": MoMeta("EtherFcoeInterfaceStats", "etherFcoeInterfaceStats", "fcoe-interface-stats", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc'], ['etherFcoeInterfaceStatsHist'], ["Get"]),
    "EtherFcoeInterfaceStatsHist": MoMeta("EtherFcoeInterfaceStatsHist", "etherFcoeInterfaceStatsHist", "[id]", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["read-only"], ['etherFcoeInterfaceStats'], [], ["Get"]),
    "EtherLossStats": MoMeta("EtherLossStats", "etherLossStats", "loss-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherServerIntFIo', 'fabricEthEstcPc', 'fabricEthLanPc'], ['etherLossStatsHist'], ["Get"]),
    "EtherLossStatsHist": MoMeta("EtherLossStatsHist", "etherLossStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['etherLossStats'], [], ["Get"]),
    "EtherNiErrStats": MoMeta("EtherNiErrStats", "etherNiErrStats", "ni-err-stats", VersionMeta.Version223a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherSwitchIntFIo', 'etherSwitchIntFIoPc'], ['etherNiErrStatsHist'], ["Get"]),
    "EtherNiErrStatsHist": MoMeta("EtherNiErrStatsHist", "etherNiErrStatsHist", "[id]", VersionMeta.Version223a, "OutputOnly", 0x1, [], ["read-only"], ['etherNiErrStats'], [], ["Get"]),
    "EtherNicIfConfig": MoMeta("EtherNicIfConfig", "etherNicIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "EtherPIo": MoMeta("EtherPIo", "etherPIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['portGroup', 'portSubGroup'], ['equipmentXcvr', 'etherErrStats', 'etherLossStats', 'etherNiErrStats', 'etherPIoEndPoint', 'etherPIoFsm', 'etherPauseStats', 'etherRxStats', 'etherTxStats', 'eventInst', 'faultInst', 'lldpAcquired', 'networkIfStats', 'portDomainEp', 'portPIoFsm', 'portPIoFsmTask'], ["Get"]),
    "EtherPIoEndPoint": MoMeta("EtherPIoEndPoint", "etherPIoEndPoint", "EndPointDn-cloud-[ep_cloud_type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['etherPIo'], [], [None]),
    "EtherPIoFsm": MoMeta("EtherPIoFsm", "etherPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['etherPIo'], ['etherPIoFsmStage'], [None]),
    "EtherPIoFsmStage": MoMeta("EtherPIoFsmStage", "etherPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['etherPIoFsm'], [], [None]),
    "EtherPauseStats": MoMeta("EtherPauseStats", "etherPauseStats", "pause-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherServerIntFIo', 'fabricEthEstcPc', 'fabricEthLanPc'], ['etherPauseStatsHist'], ["Get"]),
    "EtherPauseStatsHist": MoMeta("EtherPauseStatsHist", "etherPauseStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['etherPauseStats'], [], ["Get"]),
    "EtherPortChanIdElem": MoMeta("EtherPortChanIdElem", "etherPortChanIdElem", "pchanid-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['etherPortChanIdUniverse'], [], ["Get"]),
    "EtherPortChanIdUniverse": MoMeta("EtherPortChanIdUniverse", "etherPortChanIdUniverse", "pchanid-universe", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['fabricEp'], ['etherPortChanIdElem'], ["Get"]),
    "EtherRxStats": MoMeta("EtherRxStats", "etherRxStats", "rx-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherServerIntFIo', 'fabricEthEstcPc', 'fabricEthLanPc'], ['etherRxStatsHist'], ["Get"]),
    "EtherRxStatsHist": MoMeta("EtherRxStatsHist", "etherRxStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['etherRxStats'], [], ["Get"]),
    "EtherServerIntFIo": MoMeta("EtherServerIntFIo", "etherServerIntFIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['diagSrvCtrl', 'portGroup'], ['equipmentXcvr', 'etherErrStats', 'etherLossStats', 'etherPauseStats', 'etherRxStats', 'etherServerIntFIoFsm', 'etherServerIntFIoFsmTask', 'etherTxStats', 'eventInst', 'faultInst', 'lldpAcquired', 'portDomainEp', 'portTrustMode', 'swUlan'], ["Get"]),
    "EtherServerIntFIoFsm": MoMeta("EtherServerIntFIoFsm", "etherServerIntFIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['etherServerIntFIo'], ['etherServerIntFIoFsmStage'], [None]),
    "EtherServerIntFIoFsmStage": MoMeta("EtherServerIntFIoFsmStage", "etherServerIntFIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['etherServerIntFIoFsm'], [], [None]),
    "EtherServerIntFIoFsmTask": MoMeta("EtherServerIntFIoFsmTask", "etherServerIntFIoFsmTask", "task-[item]", VersionMeta.Version202m, "OutputOnly", 0x1, [], [""], ['etherServerIntFIo'], [], [None]),
    "EtherServerIntFIoPc": MoMeta("EtherServerIntFIoPc", "etherServerIntFIoPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['portGroup'], ['etherServerIntFIoPcEp'], ["Get"]),
    "EtherServerIntFIoPcEp": MoMeta("EtherServerIntFIoPcEp", "etherServerIntFIoPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['etherServerIntFIoPc'], [], ["Get"]),
    "EtherSwIfConfig": MoMeta("EtherSwIfConfig", "etherSwIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricDceSrv', 'fabricEthLan'], [], ["Get"]),
    "EtherSwitchIntFIo": MoMeta("EtherSwitchIntFIo", "etherSwitchIntFIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['portGroup'], ['equipmentXcvr', 'etherNiErrStats', 'faultInst', 'portDomainEp'], ["Get"]),
    "EtherSwitchIntFIoPc": MoMeta("EtherSwitchIntFIoPc", "etherSwitchIntFIoPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['portGroup'], ['etherNiErrStats', 'etherSwitchIntFIoPcEp', 'faultInst'], ["Get"]),
    "EtherSwitchIntFIoPcEp": MoMeta("EtherSwitchIntFIoPcEp", "etherSwitchIntFIoPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['etherSwitchIntFIoPc'], [], ["Get"]),
    "EtherTxStats": MoMeta("EtherTxStats", "etherTxStats", "tx-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherPIo', 'etherServerIntFIo', 'fabricEthEstcPc', 'fabricEthLanPc'], ['etherTxStatsHist'], ["Get"]),
    "EtherTxStatsHist": MoMeta("EtherTxStatsHist", "etherTxStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['etherTxStats'], [], ["Get"]),
    "EventEpCtrl": MoMeta("EventEpCtrl", "eventEpCtrl", "evctrl", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [], [], ["Get"]),
    "EventHolder": MoMeta("EventHolder", "eventHolder", "event", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['eventPolicy'], ["Get"]),
    "EventInst": MoMeta("EventInst", "eventInst", "event-[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['aaaAuthRealm', 'aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp', 'aaaUserEp', 'adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'callhomeEp', 'capabilityCatalogue', 'capabilityMgmtExtension', 'capabilityUpdater', 'commSvcEp', 'computeBlade', 'computeRackUnit', 'computeServerDiscPolicy', 'computeServerUnit', 'epqosDefinition', 'epqosDefinitionDelTask', 'equipmentBeaconLed', 'equipmentChassis', 'equipmentChassisProfile', 'equipmentFex', 'equipmentIOCard', 'equipmentLocatorLed', 'equipmentPsu', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'etherPIo', 'etherServerIntFIo', 'extpolEp', 'extpolProvider', 'extpolRegistry', 'extvmmEp', 'extvmmKeyStore', 'extvmmMasterExtKey', 'extvmmNetworkSets', 'extvmmProvider', 'extvmmSwitchDelTask', 'fabricCartridgeSlotEp', 'fabricComputeMSlotEp', 'fabricComputeSlotEp', 'fabricEpMgr', 'fabricLanCloud', 'fabricReservedVlan', 'fabricSanCloud', 'fabricVnetEpSyncEp', 'fcPIo', 'fcpoolOuis', 'firmwareDistributable', 'firmwareDownloader', 'firmwareImage', 'firmwareSystem', 'gmetaHolder', 'identIdentRequest', 'identMetaSystem', 'licenseDownloader', 'licenseFile', 'licenseInstance', 'lsServer', 'mgmtBackup', 'mgmtBackupPolicy', 'mgmtCfgExportPolicy', 'mgmtController', 'mgmtIPv6IfAddr', 'mgmtIf', 'mgmtImporter', 'morefImportRoot', 'nfsMountDef', 'nfsMountInst', 'observeObserved', 'pfcWatchDog', 'pkiEp', 'policyControlEp', 'policyControlledType', 'policyPolicyScope', 'policyPolicyScopeCont', 'policyRequestor', 'qosclassDefinition', 'qosclassSlowDrain', 'statsCollectionPolicy', 'storageEnclosure', 'storageFlexFlashController', 'storageLocalDisk', 'storageSystem', 'swAccessDomain', 'swEthLanBorder', 'swEthLanFlowMon', 'swEthMon', 'swExtUtility', 'swFcMon', 'swFcSanBorder', 'swPhys', 'swPortDiscover', 'swUtilityDomain', 'syntheticFsObj', 'sysdebugAutoCoreFileExportTarget', 'sysdebugCore', 'sysdebugLogControlEp', 'sysdebugLogExportPolicy', 'sysdebugManualCoreFileExportTarget', 'sysdebugTechSupport', 'sysfileMutation', 'vmLifeCyclePolicy', 'vnicProfileSet'], [], ["Get"]),
    "EventLog": MoMeta("EventLog", "eventLog", "event-log", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['topRoot'], ['eventRecord'], ["Get"]),
    "EventPolicy": MoMeta("EventPolicy", "eventPolicy", "event-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['eventHolder'], [], ["Get"]),
    "EventRecord": MoMeta("EventRecord", "eventRecord", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['eventLog'], [], ["Get"]),
    "ExtmgmtArpTargets": MoMeta("ExtmgmtArpTargets", "extmgmtArpTargets", "arp-target-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['extmgmtIfMonPolicy'], ['faultInst'], ["Get", "Set"]),
    "ExtmgmtGatewayPing": MoMeta("ExtmgmtGatewayPing", "extmgmtGatewayPing", "gw-ping-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Get"]),
    "ExtmgmtIf": MoMeta("ExtmgmtIf", "extmgmtIf", "extmgmt-intf", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['networkElement'], ['faultInst'], ["Get"]),
    "ExtmgmtIfMonPolicy": MoMeta("ExtmgmtIfMonPolicy", "extmgmtIfMonPolicy", "extmgmt-intf-monitor-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['topSystem'], ['extmgmtArpTargets', 'extmgmtGatewayPing', 'extmgmtMiiStatus', 'extmgmtNdiscTargets'], ["Get", "Set"]),
    "ExtmgmtMiiStatus": MoMeta("ExtmgmtMiiStatus", "extmgmtMiiStatus", "mii-status-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Get", "Set"]),
    "ExtmgmtNdiscTargets": MoMeta("ExtmgmtNdiscTargets", "extmgmtNdiscTargets", "ndisc-target-policy", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['extmgmtIfMonPolicy'], ['faultInst'], ["Get", "Set"]),
    "ExtpolClient": MoMeta("ExtpolClient", "extpolClient", "client-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolClientCont'], ['faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolClientCont": MoMeta("ExtpolClientCont", "extpolClientCont", "clients", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolClient'], ["Get"]),
    "ExtpolController": MoMeta("ExtpolController", "extpolController", "contro-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolControllerCont'], ['observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolControllerCont": MoMeta("ExtpolControllerCont", "extpolControllerCont", "controllers", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolController'], ["Get"]),
    "ExtpolEp": MoMeta("ExtpolEp", "extpolEp", "extpol", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['eventInst', 'extpolEpFsm', 'extpolEpFsmTask', 'extpolRegistry', 'faultInst'], ["Get"]),
    "ExtpolEpFsm": MoMeta("ExtpolEpFsm", "extpolEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolEp'], ['extpolEpFsmStage'], [None]),
    "ExtpolEpFsmStage": MoMeta("ExtpolEpFsmStage", "extpolEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolEpFsm'], [], [None]),
    "ExtpolEpFsmTask": MoMeta("ExtpolEpFsmTask", "extpolEpFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolEp'], [], [None]),
    "ExtpolProvider": MoMeta("ExtpolProvider", "extpolProvider", "prov-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolProviderCont'], ['eventInst', 'extpolProviderFsm', 'extpolProviderFsmTask', 'fabricVnetEpSyncEp', 'faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolProviderCont": MoMeta("ExtpolProviderCont", "extpolProviderCont", "providers", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolProvider'], ["Get"]),
    "ExtpolProviderFsm": MoMeta("ExtpolProviderFsm", "extpolProviderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolProvider'], ['extpolProviderFsmStage'], [None]),
    "ExtpolProviderFsmStage": MoMeta("ExtpolProviderFsmStage", "extpolProviderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolProviderFsm'], [], [None]),
    "ExtpolProviderFsmTask": MoMeta("ExtpolProviderFsmTask", "extpolProviderFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolProvider'], [], [None]),
    "ExtpolRegistry": MoMeta("ExtpolRegistry", "extpolRegistry", "reg", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolEp'], ['eventInst', 'extpolClientCont', 'extpolControllerCont', 'extpolProviderCont', 'extpolRegistryFsm', 'extpolRegistryFsmTask', 'faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolRegistryFsm": MoMeta("ExtpolRegistryFsm", "extpolRegistryFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolRegistry'], ['extpolRegistryFsmStage'], [None]),
    "ExtpolRegistryFsmStage": MoMeta("ExtpolRegistryFsmStage", "extpolRegistryFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolRegistryFsm'], [], [None]),
    "ExtpolRegistryFsmTask": MoMeta("ExtpolRegistryFsmTask", "extpolRegistryFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extpolRegistry'], [], [None]),
    "ExtpolSystemContext": MoMeta("ExtpolSystemContext", "extpolSystemContext", "sysctx", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtvmmEp": MoMeta("ExtvmmEp", "extvmmEp", "extvm-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], ['topSystem'], ['eventInst', 'extvmmEpFsm', 'extvmmEpFsmTask', 'extvmmKeyStore', 'extvmmMasterExtKey', 'extvmmProvider', 'extvmmSwitchDelTask', 'extvmmSwitchSet', 'faultInst'], ["Get"]),
    "ExtvmmEpFsm": MoMeta("ExtvmmEpFsm", "extvmmEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmEp'], ['extvmmEpFsmStage'], [None]),
    "ExtvmmEpFsmStage": MoMeta("ExtvmmEpFsmStage", "extvmmEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmEpFsm'], [], [None]),
    "ExtvmmEpFsmTask": MoMeta("ExtvmmEpFsmTask", "extvmmEpFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], ['extvmmEp'], [], [None]),
    "ExtvmmFNDReference": MoMeta("ExtvmmFNDReference", "extvmmFNDReference", "fnd-ref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmUpLinkPP'], ['faultInst'], ["Add", "Get", "Remove"]),
    "ExtvmmFabricNetwork": MoMeta("ExtvmmFabricNetwork", "extvmmFabricNetwork", "fabric-network-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmNetworkSets'], ['extvmmFabricNetworkDefinition'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmFabricNetworkDefinition": MoMeta("ExtvmmFabricNetworkDefinition", "extvmmFabricNetworkDefinition", "fabric-network-def-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmFabricNetwork'], ['extvmmVMNetworkDefinition'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmKeyInst": MoMeta("ExtvmmKeyInst", "extvmmKeyInst", "key-[inst]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], ['extvmmProvider'], [], ["Get"]),
    "ExtvmmKeyRing": MoMeta("ExtvmmKeyRing", "extvmmKeyRing", "keyring-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], ['extvmmKeyStore'], [], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmKeyStore": MoMeta("ExtvmmKeyStore", "extvmmKeyStore", "key-store", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], ['extvmmEp'], ['eventInst', 'extvmmKeyRing', 'extvmmKeyStoreFsm', 'extvmmKeyStoreFsmTask', 'faultInst'], ["Get"]),
    "ExtvmmKeyStoreFsm": MoMeta("ExtvmmKeyStoreFsm", "extvmmKeyStoreFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmKeyStore'], ['extvmmKeyStoreFsmStage'], [None]),
    "ExtvmmKeyStoreFsmStage": MoMeta("ExtvmmKeyStoreFsmStage", "extvmmKeyStoreFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmKeyStoreFsm'], [], [None]),
    "ExtvmmKeyStoreFsmTask": MoMeta("ExtvmmKeyStoreFsmTask", "extvmmKeyStoreFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['extvmmKeyStore'], [], [None]),
    "ExtvmmMasterExtKey": MoMeta("ExtvmmMasterExtKey", "extvmmMasterExtKey", "ext-key", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], ['extvmmEp'], ['eventInst', 'extvmmMasterExtKeyFsm', 'extvmmMasterExtKeyFsmTask', 'faultInst'], ["Get", "Set"]),
    "ExtvmmMasterExtKeyFsm": MoMeta("ExtvmmMasterExtKeyFsm", "extvmmMasterExtKeyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmMasterExtKey'], ['extvmmMasterExtKeyFsmStage'], [None]),
    "ExtvmmMasterExtKeyFsmStage": MoMeta("ExtvmmMasterExtKeyFsmStage", "extvmmMasterExtKeyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmMasterExtKeyFsm'], [], [None]),
    "ExtvmmMasterExtKeyFsmTask": MoMeta("ExtvmmMasterExtKeyFsmTask", "extvmmMasterExtKeyFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['extvmmMasterExtKey'], [], [None]),
    "ExtvmmNetworkSets": MoMeta("ExtvmmNetworkSets", "extvmmNetworkSets", "network-sets", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], ['eventInst', 'extvmmFabricNetwork', 'extvmmNetworkSetsFsm', 'extvmmNetworkSetsFsmTask', 'faultInst', 'ippoolPool'], ["Get"]),
    "ExtvmmNetworkSetsFsm": MoMeta("ExtvmmNetworkSetsFsm", "extvmmNetworkSetsFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['extvmmNetworkSets'], ['extvmmNetworkSetsFsmStage'], [None]),
    "ExtvmmNetworkSetsFsmStage": MoMeta("ExtvmmNetworkSetsFsmStage", "extvmmNetworkSetsFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['extvmmNetworkSetsFsm'], [], [None]),
    "ExtvmmNetworkSetsFsmTask": MoMeta("ExtvmmNetworkSetsFsmTask", "extvmmNetworkSetsFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['extvmmNetworkSets'], [], [None]),
    "ExtvmmProvider": MoMeta("ExtvmmProvider", "extvmmProvider", "vm-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmEp'], ['eventInst', 'extvmmKeyInst', 'extvmmProviderFsm', 'extvmmProviderFsmTask', 'faultInst', 'vmDC', 'vmDCOrg', 'vmSwitch'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmProviderFsm": MoMeta("ExtvmmProviderFsm", "extvmmProviderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmProvider'], ['extvmmProviderFsmStage'], [None]),
    "ExtvmmProviderFsmStage": MoMeta("ExtvmmProviderFsmStage", "extvmmProviderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmProviderFsm'], [], [None]),
    "ExtvmmProviderFsmTask": MoMeta("ExtvmmProviderFsmTask", "extvmmProviderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['extvmmProvider'], [], [None]),
    "ExtvmmSwitchDelTask": MoMeta("ExtvmmSwitchDelTask", "extvmmSwitchDelTask", "vsw-deltask-[sw_int_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmEp'], ['eventInst', 'extvmmSwitchDelTaskFsm', 'extvmmSwitchDelTaskFsmTask', 'faultInst'], ["Get", "Remove"]),
    "ExtvmmSwitchDelTaskFsm": MoMeta("ExtvmmSwitchDelTaskFsm", "extvmmSwitchDelTaskFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmSwitchDelTask'], ['extvmmSwitchDelTaskFsmStage'], [None]),
    "ExtvmmSwitchDelTaskFsmStage": MoMeta("ExtvmmSwitchDelTaskFsmStage", "extvmmSwitchDelTaskFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['extvmmSwitchDelTaskFsm'], [], [None]),
    "ExtvmmSwitchDelTaskFsmTask": MoMeta("ExtvmmSwitchDelTaskFsmTask", "extvmmSwitchDelTaskFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['extvmmSwitchDelTask'], [], ["Get"]),
    "ExtvmmSwitchSet": MoMeta("ExtvmmSwitchSet", "extvmmSwitchSet", "virtual-switches", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmEp'], ['vmSwitch'], ["Get"]),
    "ExtvmmUpLinkPP": MoMeta("ExtvmmUpLinkPP", "extvmmUpLinkPP", "uplinkpp-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['vmSwitch'], ['extvmmFNDReference'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNDRef": MoMeta("ExtvmmVMNDRef", "extvmmVMNDRef", "vm-network-def-ref[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmVMNetwork'], ['faultInst'], ["Add", "Get", "Remove"]),
    "ExtvmmVMNetwork": MoMeta("ExtvmmVMNetwork", "extvmmVMNetwork", "vm-network-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmVMNetworkSets'], ['extvmmVMNDRef', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNetworkDefinition": MoMeta("ExtvmmVMNetworkDefinition", "extvmmVMNetworkDefinition", "vm-network-def-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['extvmmFabricNetworkDefinition'], ['faultInst', 'vnicEtherIf'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNetworkSets": MoMeta("ExtvmmVMNetworkSets", "extvmmVMNetworkSets", "vm-network-sets", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], ['extvmmVMNetwork'], ["Get"]),
    "FabricBHVlan": MoMeta("FabricBHVlan", "fabricBHVlan", "bhnet", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], [], ["Get"]),
    "FabricBreakout": MoMeta("FabricBreakout", "fabricBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricCablingSw'], [], ["Add", "Get", "Remove"]),
    "FabricCabling": MoMeta("FabricCabling", "fabricCabling", "Cabling", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricCablingSw', 'statsThresholdPolicy'], [None]),
    "FabricCablingSw": MoMeta("FabricCablingSw", "fabricCablingSw", "[id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricCabling'], ['fabricBreakout'], ["Get"]),
    "FabricCartridgePhEp": MoMeta("FabricCartridgePhEp", "fabricCartridgePhEp", "cart-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['fabricLastAckedSlot', 'faultInst'], ["Get", "Set"]),
    "FabricCartridgeSlotEp": MoMeta("FabricCartridgeSlotEp", "fabricCartridgeSlotEp", "cart-slot-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricChassisEp'], ['eventInst', 'fabricCartridgeSlotEpFsm', 'fabricCartridgeSlotEpFsmTask', 'fabricComputeMSlotEp', 'fabricIf', 'faultInst'], ["Get", "Set"]),
    "FabricCartridgeSlotEpFsm": MoMeta("FabricCartridgeSlotEpFsm", "fabricCartridgeSlotEpFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricCartridgeSlotEp'], ['fabricCartridgeSlotEpFsmStage'], [None]),
    "FabricCartridgeSlotEpFsmStage": MoMeta("FabricCartridgeSlotEpFsmStage", "fabricCartridgeSlotEpFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricCartridgeSlotEpFsm'], [], [None]),
    "FabricCartridgeSlotEpFsmTask": MoMeta("FabricCartridgeSlotEpFsmTask", "fabricCartridgeSlotEpFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricCartridgeSlotEp'], [], [None]),
    "FabricCdpLinkPolicy": MoMeta("FabricCdpLinkPolicy", "fabricCdpLinkPolicy", "", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [], [], [None]),
    "FabricChangedObjectRef": MoMeta("FabricChangedObjectRef", "fabricChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['fabricVnetEpSyncEp'], [], [None]),
    "FabricChassisEp": MoMeta("FabricChassisEp", "fabricChassisEp", "chassis-[chassis_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricDceSrv'], ['fabricCartridgeSlotEp', 'fabricComputeSlotEp', 'faultInst'], ["Get"]),
    "FabricComputeMSlotEp": MoMeta("FabricComputeMSlotEp", "fabricComputeMSlotEp", "ins-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricCartridgeSlotEp'], ['eventInst', 'fabricComputeMSlotEpFsm', 'fabricComputeMSlotEpFsmTask', 'fabricIf', 'faultInst'], ["Get", "Set"]),
    "FabricComputeMSlotEpFsm": MoMeta("FabricComputeMSlotEpFsm", "fabricComputeMSlotEpFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricComputeMSlotEp'], ['fabricComputeMSlotEpFsmStage'], [None]),
    "FabricComputeMSlotEpFsmStage": MoMeta("FabricComputeMSlotEpFsmStage", "fabricComputeMSlotEpFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricComputeMSlotEpFsm'], [], [None]),
    "FabricComputeMSlotEpFsmTask": MoMeta("FabricComputeMSlotEpFsmTask", "fabricComputeMSlotEpFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], ['fabricComputeMSlotEp'], [], [None]),
    "FabricComputePhEp": MoMeta("FabricComputePhEp", "fabricComputePhEp", "compute-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['fabricLastAckedSlot', 'faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEp": MoMeta("FabricComputeSlotEp", "fabricComputeSlotEp", "slot-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricChassisEp'], ['eventInst', 'fabricComputeSlotEpFsm', 'fabricComputeSlotEpFsmTask', 'fabricIf', 'faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEpFsm": MoMeta("FabricComputeSlotEpFsm", "fabricComputeSlotEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricComputeSlotEp'], ['fabricComputeSlotEpFsmStage'], [None]),
    "FabricComputeSlotEpFsmStage": MoMeta("FabricComputeSlotEpFsmStage", "fabricComputeSlotEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricComputeSlotEpFsm'], [], [None]),
    "FabricComputeSlotEpFsmTask": MoMeta("FabricComputeSlotEpFsmTask", "fabricComputeSlotEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['fabricComputeSlotEp'], [], [None]),
    "FabricDceSrv": MoMeta("FabricDceSrv", "fabricDceSrv", "server", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['fabricEp'], ['etherSwIfConfig', 'fabricCartridgePhEp', 'fabricChassisEp', 'fabricComputePhEp', 'fabricDceSwSrv', 'fabricSwChPhEp', 'statsThresholdPolicy'], ["Get"]),
    "FabricDceSwSrv": MoMeta("FabricDceSwSrv", "fabricDceSwSrv", "sw-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['fabricDceSrv'], ['fabricDceSwSrvEp', 'fabricDceSwSrvPc', 'fabricSubGroup'], ["Add", "Get", "Remove"]),
    "FabricDceSwSrvEp": MoMeta("FabricDceSwSrvEp", "fabricDceSwSrvEp", "slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPc": MoMeta("FabricDceSwSrvPc", "fabricDceSwSrvPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv'], ['fabricDceSwSrvPcEp', 'fabricSubGroup', 'faultInst'], ["Get"]),
    "FabricDceSwSrvPcEp": MoMeta("FabricDceSwSrvPcEp", "fabricDceSwSrvPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrvPc', 'fabricSubGroup'], ['faultInst'], ["Get", "Set"]),
    "FabricEp": MoMeta("FabricEp", "fabricEp", "fabric", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['dcxUniverse', 'etherPortChanIdUniverse', 'fabricCabling', 'fabricDceSrv', 'fabricEpMgr', 'fabricEthEstcCloud', 'fabricFcEstcCloud', 'fabricLanAccessMgr', 'fabricLanCloud', 'fabricLanMonCloud', 'fabricSanCloud', 'fabricSanMonCloud', 'fabricZoneIdUniverse'], ["Get"]),
    "FabricEpMgr": MoMeta("FabricEpMgr", "fabricEpMgr", "[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin"], ['fabricEp'], ['eventInst', 'fabricEpMgrFsm', 'fabricEpMgrFsmTask', 'faultInst'], ["Get"]),
    "FabricEpMgrFsm": MoMeta("FabricEpMgrFsm", "fabricEpMgrFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricEpMgr'], ['fabricEpMgrFsmStage'], [None]),
    "FabricEpMgrFsmStage": MoMeta("FabricEpMgrFsmStage", "fabricEpMgrFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricEpMgrFsm'], [], [None]),
    "FabricEpMgrFsmTask": MoMeta("FabricEpMgrFsmTask", "fabricEpMgrFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], ['fabricEpMgr'], [], [None]),
    "FabricEthEstc": MoMeta("FabricEthEstc", "fabricEthEstc", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEthEstcCloud'], ['fabricEthEstcEp', 'fabricEthEstcPc', 'fabricSubGroup', 'fabricVlan'], ["Get"]),
    "FabricEthEstcCloud": MoMeta("FabricEthEstcCloud", "fabricEthEstcCloud", "eth-estc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['fabricEthEstc', 'fabricVlan', 'nwctrlDefinition', 'statsThresholdPolicy'], ["Get"]),
    "FabricEthEstcEp": MoMeta("FabricEthEstcEp", "fabricEthEstcEp", "phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricEthTargetEp', 'fabricVlanEp', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPc": MoMeta("FabricEthEstcPc", "fabricEthEstcPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc'], ['etherErrStats', 'etherLossStats', 'etherPauseStats', 'etherRxStats', 'etherTxStats', 'fabricEthEstcPcEp', 'fabricEthMonSrcEp', 'fabricEthTargetEp', 'fabricSubGroup', 'fabricVlanEp', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcEp": MoMeta("FabricEthEstcPcEp", "fabricEthEstcPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcPc', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthFlowMonLan": MoMeta("FabricEthFlowMonLan", "fabricEthFlowMonLan", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], [], [None]),
    "FabricEthLan": MoMeta("FabricEthLan", "fabricEthLan", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['etherSwIfConfig', 'fabricEthLanEp', 'fabricEthLanPc', 'fabricNetGroup', 'fabricSubGroup', 'fabricVlan', 'faultInst'], ["Get"]),
    "FabricEthLanEp": MoMeta("FabricEthLanEp", "fabricEthLanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricVlanEp', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanFlowMonitoring": MoMeta("FabricEthLanFlowMonitoring", "fabricEthLanFlowMonitoring", "eth-flow-monitoring", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanMonCloud'], ['fabricEthFlowMonLan', 'fabricFlowMonDefinition', 'fabricFlowMonExporterProfile', 'fabricNetflowCollector', 'fabricNetflowMonExporter', 'fabricNetflowMonSession', 'fabricNetflowMonitor', 'fabricNetflowTimeoutPolicy'], [None]),
    "FabricEthLanPc": MoMeta("FabricEthLanPc", "fabricEthLanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan'], ['etherErrStats', 'etherLossStats', 'etherPauseStats', 'etherRxStats', 'etherTxStats', 'fabricEthLanPcEp', 'fabricEthMonSrcEp', 'fabricSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcEp": MoMeta("FabricEthLanPcEp", "fabricEthLanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanPc', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLinkProfile": MoMeta("FabricEthLinkProfile", "fabricEthLinkProfile", "eth-link-prof-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMon": MoMeta("FabricEthMon", "fabricEthMon", "eth-mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMonLan'], ['fabricEthMonDestEp', 'fabricEthMonFiltRef', 'fabricEthMonSrcRef', 'fabricSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonDestEp": MoMeta("FabricEthMonDestEp", "fabricEthMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricEthMon', 'fabricFcMon', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonFiltEp": MoMeta("FabricEthMonFiltEp", "fabricEthMonFiltEp", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricVlan'], [], ["Get"]),
    "FabricEthMonFiltRef": MoMeta("FabricEthMonFiltRef", "fabricEthMonFiltRef", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['fabricEthMon'], [], ["Get"]),
    "FabricEthMonLan": MoMeta("FabricEthMonLan", "fabricEthMonLan", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanMonCloud'], ['fabricEthMon'], ["Get"]),
    "FabricEthMonSrcEp": MoMeta("FabricEthMonSrcEp", "fabricEthMonSrcEp", "mon-src-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['adaptorExtEthIf', 'fabricDceSwSrvEp', 'fabricEthEstcEp', 'fabricEthEstcPc', 'fabricEthLanEp', 'fabricEthLanPc', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc', 'fabricVlan', 'vmNic', 'vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIScsiLCP', 'vnicIpc', 'vnicScsi'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonSrcRef": MoMeta("FabricEthMonSrcRef", "fabricEthMonSrcRef", "src-ref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMon'], [], ["Get"]),
    "FabricEthTargetEp": MoMeta("FabricEthTargetEp", "fabricEthTargetEp", "eth-target-ep-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcEp', 'fabricEthEstcPc'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPc": MoMeta("FabricEthVlanPc", "fabricEthVlanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup', 'fabricVlan'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPortEp": MoMeta("FabricEthVlanPortEp", "fabricEthVlanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup', 'fabricSwSubGroup', 'fabricVlan'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcEndpoint": MoMeta("FabricFcEndpoint", "fabricFcEndpoint", "endpoint-[wwpn]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcUserZone'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcEstc": MoMeta("FabricFcEstc", "fabricFcEstc", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], ['fabricFcEstcEp', 'fabricFcoeEstcEp', 'fabricSubGroup', 'fabricVsan'], ["Get"]),
    "FabricFcEstcCloud": MoMeta("FabricFcEstcCloud", "fabricFcEstcCloud", "fc-estc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricBHVlan', 'fabricFcEstc', 'fabricFcZoneProfile', 'fabricVsan', 'statsThresholdPolicy'], ["Get"]),
    "FabricFcEstcEp": MoMeta("FabricFcEstcEp", "fabricFcEstcEp", "phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc'], ['fabricFcMonSrcEp', 'fabricVsanEp', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMon": MoMeta("FabricFcMon", "fabricFcMon", "fc-mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcMonSan'], ['fabricEthMonDestEp', 'fabricFcMonDestEp', 'fabricFcMonFiltRef', 'fabricFcMonSrcRef', 'fabricSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonDestEp": MoMeta("FabricFcMonDestEp", "fabricFcMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcMon'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonFiltEp": MoMeta("FabricFcMonFiltEp", "fabricFcMonFiltEp", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], [], ["Get"]),
    "FabricFcMonFiltRef": MoMeta("FabricFcMonFiltRef", "fabricFcMonFiltRef", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['fabricFcMon'], [], ["Get"]),
    "FabricFcMonSan": MoMeta("FabricFcMonSan", "fabricFcMonSan", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanMonCloud'], ['fabricFcMon'], ["Get"]),
    "FabricFcMonSrcEp": MoMeta("FabricFcMonSrcEp", "fabricFcMonSrcEp", "mon-src-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcEp', 'fabricFcSanEp', 'fabricFcSanPc', 'fabricVsan', 'vmNic', 'vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIScsiLCP', 'vnicIpc', 'vnicScsi'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonSrcRef": MoMeta("FabricFcMonSrcRef", "fabricFcMonSrcRef", "src-ref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricFcMon'], [], ["Get"]),
    "FabricFcSan": MoMeta("FabricFcSan", "fabricFcSan", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['fabricFcSanEp', 'fabricFcSanPc', 'fabricFcoeSanEp', 'fabricFcoeSanPc', 'fabricSubGroup', 'fabricVsan', 'faultInst'], ["Get", "Set"]),
    "FabricFcSanEp": MoMeta("FabricFcSanEp", "fabricFcSanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['fabricFcMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Add", "Get", "Set"]),
    "FabricFcSanPc": MoMeta("FabricFcSanPc", "fabricFcSanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['fabricFcMonSrcEp', 'fabricFcSanPcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst', 'fcErrStats', 'fcStats'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcEp": MoMeta("FabricFcSanPcEp", "fabricFcSanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSanPc'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcUserZone": MoMeta("FabricFcUserZone", "fabricFcUserZone", "zone-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcZoneProfile'], ['fabricFcEndpoint', 'faultInst', 'storageVsanRef'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcVsanPc": MoMeta("FabricFcVsanPc", "fabricFcVsanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcVsanPortEp": MoMeta("FabricFcVsanPortEp", "fabricFcVsanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcZoneProfile": MoMeta("FabricFcZoneProfile", "fabricFcZoneProfile", "zone-profile-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], ['fabricFcUserZone', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeEstcEp": MoMeta("FabricFcoeEstcEp", "fabricFcoeEstcEp", "phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc', 'fabricSubGroup'], ['etherFcoeInterfaceStats', 'fabricEthMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanEp": MoMeta("FabricFcoeSanEp", "fabricFcoeSanEp", "phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan', 'fabricSubGroup'], ['etherFcoeInterfaceStats', 'fabricEthMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPc": MoMeta("FabricFcoeSanPc", "fabricFcoeSanPc", "fcoesanpc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['etherFcoeInterfaceStats', 'fabricEthMonSrcEp', 'fabricFcoeSanPcEp', 'fabricSubGroup', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcEp": MoMeta("FabricFcoeSanPcEp", "fabricFcoeSanPcEp", "fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcoeSanPc', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeVsanPc": MoMeta("FabricFcoeVsanPc", "fabricFcoeVsanPc", "fcoepc-switch-[switch_id]-fcoepc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], ['faultInst'], ["Add", "Get", "Set"]),
    "FabricFcoeVsanPortEp": MoMeta("FabricFcoeVsanPortEp", "fabricFcoeVsanPortEp", "phys-fcoe-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSwSubGroup', 'fabricVsan'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFlowMonDefinition": MoMeta("FabricFlowMonDefinition", "fabricFlowMonDefinition", "flow-record-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], [], ["Get"]),
    "FabricFlowMonExporterProfile": MoMeta("FabricFlowMonExporterProfile", "fabricFlowMonExporterProfile", "flow-exporter-profile-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], ['vnicEtherIf'], [None]),
    "FabricIf": MoMeta("FabricIf", "fabricIf", "mgmt-if-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricCartridgeSlotEp', 'fabricComputeMSlotEp', 'fabricComputeSlotEp'], [], ["Get"]),
    "FabricLacpPolicy": MoMeta("FabricLacpPolicy", "fabricLacpPolicy", "lacp-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricLanAccessMgr": MoMeta("FabricLanAccessMgr", "fabricLanAccessMgr", "lan-access", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], [], [None]),
    "FabricLanCloud": MoMeta("FabricLanCloud", "fabricLanCloud", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['eventInst', 'extvmmNetworkSets', 'extvmmVMNetworkSets', 'fabricEthLan', 'fabricEthLinkProfile', 'fabricLanCloudFsm', 'fabricLanCloudFsmTask', 'fabricLanPinGroup', 'fabricNetGroup', 'fabricReservedVlan', 'fabricUdldLinkPolicy', 'fabricVlan', 'faultInst', 'firmwareAck', 'flowctrlDefinition', 'mgmtInbandProfile', 'mgmtLeaderEntity', 'pfcWatchDog', 'qosclassDefinition', 'statsThresholdPolicy', 'vnicProfileSet'], ["Get", "Set"]),
    "FabricLanCloudFsm": MoMeta("FabricLanCloudFsm", "fabricLanCloudFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricLanCloud'], ['fabricLanCloudFsmStage'], [None]),
    "FabricLanCloudFsmStage": MoMeta("FabricLanCloudFsmStage", "fabricLanCloudFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricLanCloudFsm'], [], [None]),
    "FabricLanCloudFsmTask": MoMeta("FabricLanCloudFsmTask", "fabricLanCloudFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['fabricLanCloud'], [], [None]),
    "FabricLanCloudPolicy": MoMeta("FabricLanCloudPolicy", "fabricLanCloudPolicy", "lan-policy", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgOrg'], [], ["Get"]),
    "FabricLanMonCloud": MoMeta("FabricLanMonCloud", "fabricLanMonCloud", "lanmon", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['fabricEthLanFlowMonitoring', 'fabricEthMonLan', 'statsThresholdPolicy'], ["Get"]),
    "FabricLanPinGroup": MoMeta("FabricLanPinGroup", "fabricLanPinGroup", "lan-pin-group-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['fabricLanPinTarget', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLanPinTarget": MoMeta("FabricLanPinTarget", "fabricLanPinTarget", "target-[fabric_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanPinGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLastAckedSlot": MoMeta("FabricLastAckedSlot", "fabricLastAckedSlot", "last-acked-slot", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricCartridgePhEp', 'fabricComputePhEp'], [], ["Get"]),
    "FabricLocale": MoMeta("FabricLocale", "fabricLocale", "fabric-[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFex', 'mgmtController'], ['adaptorExtEthIfPc', 'dcxVc', 'fabricPath'], ["Get"]),
    "FabricMulticastPolicy": MoMeta("FabricMulticastPolicy", "fabricMulticastPolicy", "mc-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroup": MoMeta("FabricNetGroup", "fabricNetGroup", "net-group-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan', 'fabricLanCloud'], ['fabricEthVlanPc', 'fabricEthVlanPortEp', 'fabricPooledVlan', 'fabricSwSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroupRef": MoMeta("FabricNetGroupRef", "fabricNetGroupRef", "net-group-ref-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['dcxVc', 'swCmclan', 'vnicEther', 'vnicLanConnTempl', 'vnicProfile', 'vnicSanConnTempl'], ['faultInst'], [None]),
    "FabricNetflowCollector": MoMeta("FabricNetflowCollector", "fabricNetflowCollector", "flow-collector-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], ['ipIpV4StaticTargetAddr'], [None]),
    "FabricNetflowIPv4Addr": MoMeta("FabricNetflowIPv4Addr", "fabricNetflowIPv4Addr", "ipv4-addr-[fabric_id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['adaptorHostIscsiIf', 'adaptorVlan', 'swVlan', 'vnicEtherIf', 'vnicIPv4If'], [], [None]),
    "FabricNetflowMonExporter": MoMeta("FabricNetflowMonExporter", "fabricNetflowMonExporter", "lanFlowMonExporter-eth-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], ['faultInst'], [None]),
    "FabricNetflowMonExporterRef": MoMeta("FabricNetflowMonExporterRef", "fabricNetflowMonExporterRef", "flow-exporter-[nf_mon_exporter_name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetflowMonitor'], ['faultInst'], [None]),
    "FabricNetflowMonSession": MoMeta("FabricNetflowMonSession", "fabricNetflowMonSession", "netflow-mon-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], ['fabricNetflowMonSrcRef', 'fabricNetflowMonitorRef', 'faultInst'], [None]),
    "FabricNetflowMonSrcEp": MoMeta("FabricNetflowMonSrcEp", "fabricNetflowMonSrcEp", "flow-mon-src-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIScsiLCP', 'vnicIpc', 'vnicProfile', 'vnicScsi'], [], [None]),
    "FabricNetflowMonSrcRef": MoMeta("FabricNetflowMonSrcRef", "fabricNetflowMonSrcRef", "flow-mon-src-ref-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetflowMonSession'], [], [None]),
    "FabricNetflowMonitor": MoMeta("FabricNetflowMonitor", "fabricNetflowMonitor", "lanflowmon-eth-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], ['fabricNetflowMonExporterRef', 'faultInst'], ["Get"]),
    "FabricNetflowMonitorRef": MoMeta("FabricNetflowMonitorRef", "fabricNetflowMonitorRef", "flow-monitor-[nf_monitor_name]-dir-[direction]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetflowMonSession'], ['faultInst'], [None]),
    "FabricNetflowTimeoutPolicy": MoMeta("FabricNetflowTimeoutPolicy", "fabricNetflowTimeoutPolicy", "flow-timeout-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanFlowMonitoring'], [], [None]),
    "FabricOrgVlanPolicy": MoMeta("FabricOrgVlanPolicy", "fabricOrgVlanPolicy", "org-vlan-policy", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], ['orgOrg'], [], ["Get", "Set"]),
    "FabricPath": MoMeta("FabricPath", "fabricPath", "path-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricLocale'], ['dcxVc', 'fabricPathConn', 'fabricPathEp'], ["Get"]),
    "FabricPathConn": MoMeta("FabricPathConn", "fabricPathConn", "xc-[c_type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricPath'], ['fabricPathEp'], ["Get"]),
    "FabricPathEp": MoMeta("FabricPathEp", "fabricPathEp", "ep-[c_type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricPath', 'fabricPathConn'], ['portTrustMode'], ["Get"]),
    "FabricPoolableVlan": MoMeta("FabricPoolableVlan", "fabricPoolableVlan", "pool-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['fabricVlan'], [], [None]),
    "FabricPooledVlan": MoMeta("FabricPooledVlan", "fabricPooledVlan", "net-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup'], ['faultInst'], ["Add", "Get", "Remove"]),
    "FabricReservedVlan": MoMeta("FabricReservedVlan", "fabricReservedVlan", "fab-reserved-vlans", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['fabricLanCloud'], ['eventInst', 'fabricReservedVlanFsm', 'fabricReservedVlanFsmTask', 'faultInst', 'firmwareAck'], [None]),
    "FabricReservedVlanFsm": MoMeta("FabricReservedVlanFsm", "fabricReservedVlanFsm", "fsm", VersionMeta.Version401a, "OutputOnly", 0x1, [], [""], ['fabricReservedVlan'], ['fabricReservedVlanFsmStage'], [None]),
    "FabricReservedVlanFsmStage": MoMeta("FabricReservedVlanFsmStage", "fabricReservedVlanFsmStage", "stage-[name]", VersionMeta.Version401a, "OutputOnly", 0x1, [], [""], ['fabricReservedVlanFsm'], [], [None]),
    "FabricReservedVlanFsmTask": MoMeta("FabricReservedVlanFsmTask", "fabricReservedVlanFsmTask", "task-[item]", VersionMeta.Version401a, "OutputOnly", 0x1, [], [""], ['fabricReservedVlan'], [], [None]),
    "FabricSanCloud": MoMeta("FabricSanCloud", "fabricSanCloud", "san", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['eventInst', 'fabricFcSan', 'fabricSanCloudFsm', 'fabricSanCloudFsmTask', 'fabricSanPinGroup', 'fabricVsan', 'faultInst', 'firmwareAck', 'mgmtLeaderEntity', 'statsThresholdPolicy'], ["Get", "Set"]),
    "FabricSanCloudFsm": MoMeta("FabricSanCloudFsm", "fabricSanCloudFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricSanCloud'], ['fabricSanCloudFsmStage'], [None]),
    "FabricSanCloudFsmStage": MoMeta("FabricSanCloudFsmStage", "fabricSanCloudFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fabricSanCloudFsm'], [], [None]),
    "FabricSanCloudFsmTask": MoMeta("FabricSanCloudFsmTask", "fabricSanCloudFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['fabricSanCloud'], [], [None]),
    "FabricSanGroup": MoMeta("FabricSanGroup", "fabricSanGroup", "san-group-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get", "Set"]),
    "FabricSanGroupRef": MoMeta("FabricSanGroupRef", "fabricSanGroupRef", "san-group-ref-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['dcxVc', 'vnicFc', 'vnicLanConnTempl', 'vnicSanConnTempl'], ['faultInst'], [None]),
    "FabricSanMonCloud": MoMeta("FabricSanMonCloud", "fabricSanMonCloud", "sanmon", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricFcMonSan', 'statsThresholdPolicy'], ["Get"]),
    "FabricSanPinGroup": MoMeta("FabricSanPinGroup", "fabricSanPinGroup", "san-pin-group-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['fabricSanPinTarget', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSanPinTarget": MoMeta("FabricSanPinTarget", "fabricSanPinTarget", "target-[fabric_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanPinGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSubGroup": MoMeta("FabricSubGroup", "fabricSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-network", "ls-network-policy"], ['fabricDceSwSrv', 'fabricDceSwSrvPc', 'fabricEthEstc', 'fabricEthEstcPc', 'fabricEthLan', 'fabricEthLanPc', 'fabricEthMon', 'fabricFcEstc', 'fabricFcMon', 'fabricFcSan', 'fabricFcoeSanPc'], ['fabricDceSwSrvEp', 'fabricDceSwSrvPcEp', 'fabricEthEstcEp', 'fabricEthEstcPcEp', 'fabricEthLanEp', 'fabricEthLanPcEp', 'fabricEthMonDestEp', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPcEp'], ["Add", "Get"]),
    "FabricSwChPhEp": MoMeta("FabricSwChPhEp", "fabricSwChPhEp", "chassis-ep-ven-[vendor]-mod[model]-ser-[serial]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['faultInst'], ["Get", "Set"]),
    "FabricSwSubGroup": MoMeta("FabricSwSubGroup", "fabricSwSubGroup", "sw-[switch_id]-slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricNetGroup', 'fabricVlan', 'fabricVsan'], ['fabricEthVlanPortEp', 'fabricFcoeVsanPortEp'], [None]),
    "FabricUdldLinkPolicy": MoMeta("FabricUdldLinkPolicy", "fabricUdldLinkPolicy", "udld-link-pol-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], ['fabricLanCloud'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricUdldPolicy": MoMeta("FabricUdldPolicy", "fabricUdldPolicy", "udld-policy", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "FabricVCon": MoMeta("FabricVCon", "fabricVCon", "vcon-[id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-config-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], ['fabricVConProfile', 'lsServer'], [], ["Add", "Get", "Set"]),
    "FabricVConProfile": MoMeta("FabricVConProfile", "fabricVConProfile", "vcon-profile-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], ['orgOrg'], ['fabricVCon'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlan": MoMeta("FabricVlan", "fabricVlan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc', 'fabricEthEstcCloud', 'fabricEthLan', 'fabricLanCloud'], ['fabricEthMonFiltEp', 'fabricEthMonSrcEp', 'fabricEthVlanPc', 'fabricEthVlanPortEp', 'fabricPoolableVlan', 'fabricSwSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlanEp": MoMeta("FabricVlanEp", "fabricVlanEp", "vlan-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['fabricEthEstcEp', 'fabricEthEstcPc', 'fabricEthLanEp'], [], ["Get"]),
    "FabricVlanGroupPermit": MoMeta("FabricVlanGroupPermit", "fabricVlanGroupPermit", "vgperm-[cloud]sw-[switch_id]net-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], [""], ['orgOrg'], [], [None]),
    "FabricVlanGroupReq": MoMeta("FabricVlanGroupReq", "fabricVlanGroupReq", "vlan-group-req-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove"]),
    "FabricVlanPermit": MoMeta("FabricVlanPermit", "fabricVlanPermit", "perm-[cloud]sw-[switch_id]net-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], [""], ['orgOrg'], [], [None]),
    "FabricVlanReq": MoMeta("FabricVlanReq", "fabricVlanReq", "vlan-req-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove"]),
    "FabricVnetEpSyncEp": MoMeta("FabricVnetEpSyncEp", "fabricVnetEpSyncEp", "syncEp", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['extpolProvider'], ['eventInst', 'fabricChangedObjectRef', 'fabricVnetEpSyncEpFsm', 'fabricVnetEpSyncEpFsmTask', 'faultInst'], [None]),
    "FabricVnetEpSyncEpFsm": MoMeta("FabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEp'], ['fabricVnetEpSyncEpFsmStage'], [None]),
    "FabricVnetEpSyncEpFsmStage": MoMeta("FabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEpFsm'], [], [None]),
    "FabricVnetEpSyncEpFsmTask": MoMeta("FabricVnetEpSyncEpFsmTask", "fabricVnetEpSyncEpFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEp'], [], [None]),
    "FabricVsan": MoMeta("FabricVsan", "fabricVsan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc', 'fabricFcEstcCloud', 'fabricFcSan', 'fabricSanCloud'], ['fabricFcMonFiltEp', 'fabricFcMonSrcEp', 'fabricFcVsanPc', 'fabricFcVsanPortEp', 'fabricFcoeVsanPc', 'fabricFcoeVsanPortEp', 'fabricSwSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVsanEp": MoMeta("FabricVsanEp", "fabricVsanEp", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fabricFcEstcEp', 'fabricFcSanEp', 'fabricFcSanPc', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc'], ['faultInst'], ["Get"]),
    "FabricVsanMembership": MoMeta("FabricVsanMembership", "fabricVsanMembership", "vsanmember-[vsan_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['fabricFcSanEp', 'fabricFcSanPc', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc'], ['faultInst'], [None]),
    "FabricZoneIdUniverse": MoMeta("FabricZoneIdUniverse", "fabricZoneIdUniverse", "zone-id-universe", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['fabricEp'], [], [None]),
    "FaultAffectedClass": MoMeta("FaultAffectedClass", "faultAffectedClass", "fault-[mo_class_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], ['faultSuppressPolicy'], [], [None]),
    "FaultHolder": MoMeta("FaultHolder", "faultHolder", "fault", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], ['topRoot'], ['faultLocalTypedHolder', 'faultPolicy', 'faultSuppressPolicy', 'faultSuppressTask'], ["Get"]),
    "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "fault", "operations"], ['aaaAuthRealm', 'aaaConsoleAuth', 'aaaDefaultAuth', 'aaaDomain', 'aaaDomainAuth', 'aaaLdapEp', 'aaaLocale', 'aaaOrg', 'aaaProviderGroup', 'aaaRadiusEp', 'aaaRole', 'aaaTacacsPlusEp', 'aaaUser', 'aaaUserEp', 'aaaUserLocale', 'aaaUserRole', 'adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostScsiIf', 'adaptorHostServiceEthIf', 'adaptorUnit', 'adaptorUnitExtn', 'adaptorVlan', 'biosUnit', 'callhomeEp', 'capabilityCatalogue', 'capabilityMgmtExtension', 'capabilityUpdater', 'cimcvmediaActualMountEntry', 'cloudDeviceConnectorEp', 'commDateTime', 'commSnmp', 'commSnmpUser', 'commSvcEp', 'computeAdminAck', 'computeAutoconfigPolicy', 'computeBlade', 'computeBladeInheritPolicy', 'computeBoard', 'computeExtBoard', 'computeFwSyncAck', 'computeIOHub', 'computePhysicalExtension', 'computePool', 'computeRackUnit', 'computeRtcBattery', 'computeServerDiscPolicy', 'computeServerUnit', 'cpmaintAck', 'dcxNs', 'dcxVIf', 'dcxVc', 'epqosDefinition', 'epqosDefinitionDelTask', 'equipmentAutoconfigPolicy', 'equipmentBeaconLed', 'equipmentChassis', 'equipmentChassisInheritPolicy', 'equipmentChassisIssues', 'equipmentChassisProfile', 'equipmentComputeConn', 'equipmentFan', 'equipmentFanModule', 'equipmentFex', 'equipmentHealthLed', 'equipmentIOCard', 'equipmentInventoryStatus', 'equipmentLocatorLed', 'equipmentPsu', 'equipmentRequirement', 'equipmentSharedIOModule', 'equipmentSwitchCard', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'equipmentTpm', 'etherPIo', 'etherServerIntFIo', 'etherSwitchIntFIo', 'etherSwitchIntFIoPc', 'extmgmtArpTargets', 'extmgmtIf', 'extmgmtNdiscTargets', 'extpolClient', 'extpolEp', 'extpolProvider', 'extpolRegistry', 'extvmmEp', 'extvmmFNDReference', 'extvmmKeyStore', 'extvmmMasterExtKey', 'extvmmNetworkSets', 'extvmmProvider', 'extvmmSwitchDelTask', 'extvmmVMNDRef', 'extvmmVMNetwork', 'extvmmVMNetworkDefinition', 'fabricCartridgePhEp', 'fabricCartridgeSlotEp', 'fabricChassisEp', 'fabricComputeMSlotEp', 'fabricComputePhEp', 'fabricComputeSlotEp', 'fabricDceSwSrvEp', 'fabricDceSwSrvPc', 'fabricDceSwSrvPcEp', 'fabricEpMgr', 'fabricEthEstcEp', 'fabricEthEstcPc', 'fabricEthEstcPcEp', 'fabricEthLan', 'fabricEthLanEp', 'fabricEthLanPc', 'fabricEthLanPcEp', 'fabricEthLinkProfile', 'fabricEthMon', 'fabricEthMonDestEp', 'fabricEthTargetEp', 'fabricEthVlanPc', 'fabricEthVlanPortEp', 'fabricFcEstcEp', 'fabricFcMon', 'fabricFcMonDestEp', 'fabricFcSan', 'fabricFcSanEp', 'fabricFcSanPc', 'fabricFcSanPcEp', 'fabricFcUserZone', 'fabricFcVsanPc', 'fabricFcVsanPortEp', 'fabricFcZoneProfile', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc', 'fabricFcoeSanPcEp', 'fabricFcoeVsanPc', 'fabricFcoeVsanPortEp', 'fabricLanCloud', 'fabricLanPinGroup', 'fabricLanPinTarget', 'fabricMulticastPolicy', 'fabricNetGroup', 'fabricNetGroupRef', 'fabricNetflowMonExporter', 'fabricNetflowMonExporterRef', 'fabricNetflowMonSession', 'fabricNetflowMonitor', 'fabricNetflowMonitorRef', 'fabricPooledVlan', 'fabricReservedVlan', 'fabricSanCloud', 'fabricSanGroupRef', 'fabricSanPinGroup', 'fabricSanPinTarget', 'fabricSwChPhEp', 'fabricVlan', 'fabricVlanGroupReq', 'fabricVlanReq', 'fabricVnetEpSyncEp', 'fabricVsan', 'fabricVsanEp', 'fabricVsanMembership', 'faultSuppressTask', 'fcPIo', 'fcpoolAddr', 'fcpoolInitiators', 'fcpoolOuis', 'firmwareAck', 'firmwareAutoSyncPolicy', 'firmwareBootUnit', 'firmwareDistributable', 'firmwareDownloader', 'firmwareImage', 'firmwareInfra', 'firmwarePackItem', 'firmwareSecureFPGA', 'firmwareStatus', 'firmwareSystem', 'firmwareUpdatable', 'flowctrlItem', 'gmetaHolder', 'identIdentRequest', 'identMetaSystem', 'ippoolAddr', 'ippoolIpV6Addr', 'ippoolPool', 'iqnpoolAddr', 'iqnpoolPool', 'licenseDownloader', 'licenseFile', 'licenseInstance', 'lsBinding', 'lsIdentityInfo', 'lsIssues', 'lsRequirement', 'lsServer', 'lsmaintAck', 'lsmaintMaintPolicy', 'lstorageDasScsiLun', 'lstorageProfileBinding', 'macpoolAddr', 'macpoolPool', 'memoryArray', 'memoryBufferUnit', 'memoryPersistentMemoryConfigResult', 'memoryPersistentMemoryConfiguration', 'memoryPersistentMemoryNamespace', 'memoryPersistentMemoryNamespaceConfigResult', 'memoryPersistentMemoryUnit', 'memoryUnit', 'mgmtBackup', 'mgmtBackupPolicy', 'mgmtBackupPolicyConfig', 'mgmtCfgExportPolicy', 'mgmtConnection', 'mgmtController', 'mgmtDbState', 'mgmtEntity', 'mgmtHealthStatus', 'mgmtIPv6IfAddr', 'mgmtIf', 'mgmtImporter', 'mgmtInterface', 'mgmtKvmCertificate', 'mgmtPmonEntry', 'moIpV4AddrKv', 'moIpV6AddrKv', 'morefImportRoot', 'networkElement', 'networkLimit', 'networkOperLevel', 'nfsMountDef', 'nfsMountInst', 'observeObserved', 'pciEquipSlot', 'pciSwitch', 'pfcWatchDog', 'pkiEp', 'pkiKeyRing', 'pkiTP', 'policyControlEp', 'policyControlledType', 'policyPolicyScope', 'policyPolicyScopeCont', 'policyRequestor', 'powerBudget', 'powerChassisMember', 'powerGroup', 'powerPolicy', 'processorUnit', 'qosclassDefinition', 'qosclassSlowDrain', 'statsCollectionPolicy', 'storageConnectionDef', 'storageConnectionPolicy', 'storageController', 'storageEnclosure', 'storageEnclosureDiskSlotEp', 'storageFlexFlashCard', 'storageFlexFlashController', 'storageFlexFlashDrive', 'storageFlexFlashVirtualDrive', 'storageIniGroup', 'storageInitiator', 'storageItem', 'storageLocalDisk', 'storageLocalDiskSlotEp', 'storageMezzFlashLife', 'storageNvmeSwitch', 'storageRaidBattery', 'storageSasExpander', 'storageSystem', 'storageVDMemberEp', 'storageVirtualDrive', 'storageVsanRef', 'swAccessDomain', 'swEthLanBorder', 'swEthLanFlowMon', 'swEthMon', 'swEthTargetEp', 'swExtUtility', 'swFcMon', 'swFcSanBorder', 'swPhys', 'swPortDiscover', 'swSystemStats', 'swUtilityDomain', 'swVlan', 'swVlanPortNs', 'syntheticFsObj', 'sysdebugAutoCoreFileExportTarget', 'sysdebugCore', 'sysdebugLogControlEp', 'sysdebugLogExportPolicy', 'sysdebugLogExportStatus', 'sysdebugMEpLog', 'sysdebugManualCoreFileExportTarget', 'sysdebugTechSupport', 'sysfileMutation', 'trigTest', 'uuidpoolAddr', 'uuidpoolPool', 'vmLifeCyclePolicy', 'vmNic', 'vmVif', 'vnicConnDef', 'vnicDynamicConPolicyRef', 'vnicEthConfig', 'vnicEther', 'vnicEtherIf', 'vnicFc', 'vnicFcGroupDef', 'vnicFcGroupTempl', 'vnicFcIf', 'vnicFcNode', 'vnicIPv4PooledIscsiAddr', 'vnicIScsi', 'vnicIScsiBootVnic', 'vnicIScsiConfig', 'vnicIScsiLCP', 'vnicIScsiNode', 'vnicIScsiStaticTargetIf', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV6MgmtPooledAddr', 'vnicIpc', 'vnicLanConnTempl', 'vnicProfile', 'vnicProfileSet', 'vnicSanConnTempl', 'vnicScsi', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], [], ["Get"]),
    "FaultLocalTypedHolder": MoMeta("FaultLocalTypedHolder", "faultLocalTypedHolder", "type-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], ['faultHolder'], [], [None]),
    "FaultPolicy": MoMeta("FaultPolicy", "faultPolicy", "fault-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], ['faultHolder'], [], ["Get", "Set"]),
    "FaultSuppressPolicy": MoMeta("FaultSuppressPolicy", "faultSuppressPolicy", "fault-suppress-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['faultHolder'], ['faultAffectedClass', 'faultSuppressPolicyItem'], [None]),
    "FaultSuppressPolicyItem": MoMeta("FaultSuppressPolicyItem", "faultSuppressPolicyItem", "item-[type]-[cause]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['faultSuppressPolicy'], [], [None]),
    "FaultSuppressTask": MoMeta("FaultSuppressTask", "faultSuppressTask", "fault-suppress-task-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFex', 'equipmentIOCard', 'faultHolder', 'lsServer', 'orgOrg'], ['faultInst', 'trigLocalSched'], ["Add", "Get", "Remove", "Set"]),
    "FcErrStats": MoMeta("FcErrStats", "fcErrStats", "err-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['fabricFcSanPc', 'fcPIo'], ['fcErrStatsHist'], ["Get"]),
    "FcErrStatsHist": MoMeta("FcErrStatsHist", "fcErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['fcErrStats'], [], ["Get"]),
    "FcNicIfConfig": MoMeta("FcNicIfConfig", "fcNicIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FcPIo": MoMeta("FcPIo", "fcPIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['portGroup', 'portSubGroup'], ['equipmentXcvr', 'eventInst', 'faultInst', 'fcErrStats', 'fcPIoFsm', 'fcStats', 'lldpAcquired', 'networkIfStats', 'portDomainEp', 'portPIoFsm', 'portPIoFsmTask'], ["Get"]),
    "FcPIoFsm": MoMeta("FcPIoFsm", "fcPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fcPIo'], ['fcPIoFsmStage'], [None]),
    "FcPIoFsmStage": MoMeta("FcPIoFsmStage", "fcPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['fcPIoFsm'], [], [None]),
    "FcStats": MoMeta("FcStats", "fcStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['fabricFcSanPc', 'fcPIo'], ['fcStatsHist'], ["Get"]),
    "FcStatsHist": MoMeta("FcStatsHist", "fcStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['fcStats'], [], ["Get"]),
    "FcSwIfConfig": MoMeta("FcSwIfConfig", "fcSwIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FcpoolAddr": MoMeta("FcpoolAddr", "fcpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fcpoolUniverse'], ['faultInst', 'fcpoolPoolable'], ["Get"]),
    "FcpoolBlock": MoMeta("FcpoolBlock", "fcpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['fcpoolInitiators'], ['fcpoolBootTarget'], ["Add", "Get", "Remove"]),
    "FcpoolBootTarget": MoMeta("FcpoolBootTarget", "fcpoolBootTarget", "target-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['fcpoolBlock', 'fcpoolInitiator'], [], ["Get"]),
    "FcpoolFormat": MoMeta("FcpoolFormat", "fcpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['fcpoolUniverse'], [], ["Get"]),
    "FcpoolInitiator": MoMeta("FcpoolInitiator", "fcpoolInitiator", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['fcpoolInitiators'], ['fcpoolBootTarget', 'fcpoolInitiatorEp'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolInitiatorEp": MoMeta("FcpoolInitiatorEp", "fcpoolInitiatorEp", "[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolInitiator'], [], [None]),
    "FcpoolInitiators": MoMeta("FcpoolInitiators", "fcpoolInitiators", "wwn-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['orgOrg'], ['faultInst', 'fcpoolBlock', 'fcpoolInitiator'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolOui": MoMeta("FcpoolOui", "fcpoolOui", "oui-[oui]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['fcpoolOuis'], [], [None]),
    "FcpoolOuis": MoMeta("FcpoolOuis", "fcpoolOuis", "oui-pool-[name]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['networkElement'], ['eventInst', 'faultInst', 'fcpoolOui', 'fcpoolOuisFsm', 'fcpoolOuisFsmTask'], [None]),
    "FcpoolOuisFsm": MoMeta("FcpoolOuisFsm", "fcpoolOuisFsm", "fsm", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['fcpoolOuis'], ['fcpoolOuisFsmStage'], [None]),
    "FcpoolOuisFsmStage": MoMeta("FcpoolOuisFsmStage", "fcpoolOuisFsmStage", "stage-[name]", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['fcpoolOuisFsm'], [], [None]),
    "FcpoolOuisFsmTask": MoMeta("FcpoolOuisFsmTask", "fcpoolOuisFsmTask", "task-[item]", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['fcpoolOuis'], [], [None]),
    "FcpoolPoolable": MoMeta("FcpoolPoolable", "fcpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['fcpoolAddr'], [], ["Get"]),
    "FcpoolUniverse": MoMeta("FcpoolUniverse", "fcpoolUniverse", "wwn", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['fcpoolAddr', 'fcpoolFormat'], ["Get"]),
    "FeatureContextEp": MoMeta("FeatureContextEp", "featureContextEp", "contexts", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['topSystem'], ['featureDefinitionInstance', 'featureFruCapProviderInstance', 'featureProviderInstance'], [None]),
    "FeatureDefinition": MoMeta("FeatureDefinition", "featureDefinition", "feature-[name]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], [], [None]),
    "FeatureDefinitionInstance": MoMeta("FeatureDefinitionInstance", "featureDefinitionInstance", "feature-[name]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['featureContextEp'], [], [None]),
    "FeatureDefinitionRef": MoMeta("FeatureDefinitionRef", "featureDefinitionRef", "feature-[name]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['featureProvider'], [], [None]),
    "FeatureFruCapProviderInstance": MoMeta("FeatureFruCapProviderInstance", "featureFruCapProviderInstance", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['featureContextEp'], [], [None]),
    "FeatureFruCapProviderRef": MoMeta("FeatureFruCapProviderRef", "featureFruCapProviderRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['featureProvider'], [], [None]),
    "FeatureProvider": MoMeta("FeatureProvider", "featureProvider", "prov-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], ['featureDefinitionRef', 'featureFruCapProviderRef'], [None]),
    "FeatureProviderInstance": MoMeta("FeatureProviderInstance", "featureProviderInstance", "inst-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['featureContextEp'], [], [None]),
    "FirmwareAck": MoMeta("FirmwareAck", "firmwareAck", "ack", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['fabricLanCloud', 'fabricReservedVlan', 'fabricSanCloud', 'firmwareSystem', 'qosclassDefinition'], ['faultInst', 'trigLocalSched'], ["Get", "Set"]),
    "FirmwareActivity": MoMeta("FirmwareActivity", "firmwareActivity", "fw-activity", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin"], ['equipmentChassis'], [], [None]),
    "FirmwareActivityTrigger": MoMeta("FirmwareActivityTrigger", "firmwareActivityTrigger", "fw-activity-trigger", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin"], ['equipmentChassis'], [], ["Get"]),
    "FirmwareAutoSyncPolicy": MoMeta("FirmwareAutoSyncPolicy", "firmwareAutoSyncPolicy", "fw-auto-sync", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], ['faultInst'], ["Get", "Set"]),
    "FirmwareBackupVersionHolder": MoMeta("FirmwareBackupVersionHolder", "firmwareBackupVersionHolder", "update-backup-version-holder-[bundle_type]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogPack', 'firmwareChassisPack', 'firmwareComputeHostPack', 'firmwareComputeMgmtPack', 'firmwareInfraPack'], ['firmwarePackItem'], ["Get", "Set"]),
    "FirmwareBlade": MoMeta("FirmwareBlade", "firmwareBlade", "fw-blade", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareHost'], [], ["Get"]),
    "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['adaptorHostEthIf', 'adaptorHostFcIf', 'biosUnit', 'capabilityCatalogue', 'capabilityMgmtExtension', 'equipmentPsu', 'graphicsCard', 'memoryPersistentMemoryUnit', 'mgmtController', 'pciSwitch', 'storageController', 'storageLocalDisk', 'storageNvmeSwitch', 'storageOnboardDevice', 'storageSasExpander'], ['firmwareBootUnit', 'firmwareUcscInfo'], ["Get"]),
    "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareBootDefinition'], ['faultInst', 'firmwareInstallable', 'firmwareServicePack'], ["Get", "Set"]),
    "FirmwareBundleInfo": MoMeta("FirmwareBundleInfo", "firmwareBundleInfo", "bundle-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareBundleInfoDigest": MoMeta("FirmwareBundleInfoDigest", "firmwareBundleInfoDigest", "bundleinfo-[type]-version-[version]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareBundleType": MoMeta("FirmwareBundleType", "firmwareBundleType", "-type-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider', 'firmwarePlatformBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareBundleTypeCapProvider": MoMeta("FirmwareBundleTypeCapProvider", "firmwareBundleTypeCapProvider", "bundle-type-cap", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], ['firmwareBundleType', 'firmwareChassisComponentSpec', 'firmwareComponentSpec'], ["Get"]),
    "FirmwareCatalogPack": MoMeta("FirmwareCatalogPack", "firmwareCatalogPack", "fw-catalog-pack-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgOrg'], ['firmwareBackupVersionHolder', 'firmwarePackItem'], ["Get", "Set"]),
    "FirmwareCatalogue": MoMeta("FirmwareCatalogue", "firmwareCatalogue", "fw-catalogue", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['firmwareCompSource', 'firmwareDistributable', 'firmwareDownloader', 'firmwareImage', 'firmwareUcscInfo'], [None]),
    "FirmwareChassisComponentSpec": MoMeta("FirmwareChassisComponentSpec", "firmwareChassisComponentSpec", "chassis-component-spec-[type]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareChassisPack": MoMeta("FirmwareChassisPack", "firmwareChassisPack", "fw-chassis-pack-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], ['firmwareBackupVersionHolder', 'firmwareExcludeChassisComponent', 'firmwarePackItem'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareChassisPackModImpact": MoMeta("FirmwareChassisPackModImpact", "firmwareChassisPackModImpact", "fw-sys-ChassisPackModImpact-[key_dn]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareCompSource": MoMeta("FirmwareCompSource", "firmwareCompSource", "source-[inv_tag]-ver-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['firmwareCatalogue'], ['firmwareCompTarget'], [None]),
    "FirmwareCompTarget": MoMeta("FirmwareCompTarget", "firmwareCompTarget", "target-[inv_tag]-ver-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['firmwareCompSource'], [], [None]),
    "FirmwareComponentSpec": MoMeta("FirmwareComponentSpec", "firmwareComponentSpec", "component-spec-[type]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider'], [], [None]),
    "FirmwareComputeHostPack": MoMeta("FirmwareComputeHostPack", "firmwareComputeHostPack", "fw-host-pack-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], ['orgOrg'], ['firmwareBackupVersionHolder', 'firmwareExcludeServerComponent', 'firmwarePackItem'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeMgmtPack": MoMeta("FirmwareComputeMgmtPack", "firmwareComputeMgmtPack", "fw-mgmt-pack-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], ['orgOrg'], ['firmwareBackupVersionHolder', 'firmwarePackItem'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareConnectionManagementChassisConstraint": MoMeta("FirmwareConnectionManagementChassisConstraint", "firmwareConnectionManagementChassisConstraint", "connection-management-chassis-constraint", VersionMeta.Version323a, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareConstraints": MoMeta("FirmwareConstraints", "firmwareConstraints", "fw-constraints", VersionMeta.Version223a, "InputOutput", 0x1, [], [""], ['diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentSwitchCapProvider'], ['firmwareConnectionManagementChassisConstraint', 'firmwareDriveSecurityConstraint', 'firmwareDualVicChassisConstraint', 'firmwareDualVicServerConstraint', 'firmwarePCHStorageConfigConstraint', 'firmwareProcessorTypeConstraint', 'firmwareRackPowerCapConstraint', 'firmwareSecondControllerChassisConstraint', 'firmwareSecondControllerServerConstraint', 'firmwareServerChassisConstraint', 'firmwareServerTypeConstraint', 'firmwareSinglePathChassisConstraint', 'firmwareTPMConstraint', 'firmwareVicSlotConstraint', 'firmwareVnicCdnConstraint', 'firmwareWaterbaySiocServerConstraint'], [None]),
    "FirmwareDependency": MoMeta("FirmwareDependency", "firmwareDependency", "dep-[ep]-[inv_tag]-[hw_vendor]|[hw_model]|[hw_revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['firmwareType'], [], ["Get"]),
    "FirmwareDistImage": MoMeta("FirmwareDistImage", "firmwareDistImage", "distimage-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['firmwareDistributable'], [], ["Get"]),
    "FirmwareDistributable": MoMeta("FirmwareDistributable", "firmwareDistributable", "distrib-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue'], ['eventInst', 'faultInst', 'firmwareDistImage', 'firmwareDistributableFsm', 'firmwareDistributableFsmTask'], ["Get", "Set"]),
    "FirmwareDistributableFsm": MoMeta("FirmwareDistributableFsm", "firmwareDistributableFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareDistributable'], ['firmwareDistributableFsmStage'], [None]),
    "FirmwareDistributableFsmStage": MoMeta("FirmwareDistributableFsmStage", "firmwareDistributableFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareDistributableFsm'], [], [None]),
    "FirmwareDistributableFsmTask": MoMeta("FirmwareDistributableFsmTask", "firmwareDistributableFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], ['firmwareDistributable'], [], [None]),
    "FirmwareDownloader": MoMeta("FirmwareDownloader", "firmwareDownloader", "dnld-[file_name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue'], ['eventInst', 'faultInst', 'firmwareDownloaderFsm', 'firmwareDownloaderFsmTask'], ["Add", "Get", "Remove"]),
    "FirmwareDownloaderFsm": MoMeta("FirmwareDownloaderFsm", "firmwareDownloaderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareDownloader'], ['firmwareDownloaderFsmStage'], [None]),
    "FirmwareDownloaderFsmStage": MoMeta("FirmwareDownloaderFsmStage", "firmwareDownloaderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareDownloaderFsm'], [], [None]),
    "FirmwareDownloaderFsmTask": MoMeta("FirmwareDownloaderFsmTask", "firmwareDownloaderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['firmwareDownloader'], [], [None]),
    "FirmwareDriveSecurityConstraint": MoMeta("FirmwareDriveSecurityConstraint", "firmwareDriveSecurityConstraint", "drive-security-constraint", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareDualVicChassisConstraint": MoMeta("FirmwareDualVicChassisConstraint", "firmwareDualVicChassisConstraint", "dual-vic-chassis-constraint", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareDualVicServerConstraint": MoMeta("FirmwareDualVicServerConstraint", "firmwareDualVicServerConstraint", "dual-vic-server-constraint", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareExcludeChassisComponent": MoMeta("FirmwareExcludeChassisComponent", "firmwareExcludeChassisComponent", "exclude-chassis-component-[chassis_component]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['firmwareChassisPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareExcludeServerComponent": MoMeta("FirmwareExcludeServerComponent", "firmwareExcludeServerComponent", "exclude-server-component-[server_component]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], ['firmwareComputeHostPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareFileUnit": MoMeta("FirmwareFileUnit", "firmwareFileUnit", "fileunit-[type]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareHost": MoMeta("FirmwareHost", "firmwareHost", "fw-host", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareSystem'], ['firmwareBlade', 'firmwareRack'], ["Get"]),
    "FirmwareHostPackModImpact": MoMeta("FirmwareHostPackModImpact", "firmwareHostPackModImpact", "fw-sys-HostPackModImpact-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareImage": MoMeta("FirmwareImage", "firmwareImage", "image-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue'], ['eventInst', 'faultInst', 'firmwareImageFsm', 'firmwareImageFsmTask', 'firmwareInstallable', 'firmwareModule'], ["Get", "Set"]),
    "FirmwareImageFsm": MoMeta("FirmwareImageFsm", "firmwareImageFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareImage'], ['firmwareImageFsmStage'], [None]),
    "FirmwareImageFsmStage": MoMeta("FirmwareImageFsmStage", "firmwareImageFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareImageFsm'], [], [None]),
    "FirmwareImageFsmTask": MoMeta("FirmwareImageFsmTask", "firmwareImageFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['firmwareImage'], [], [None]),
    "FirmwareImageLock": MoMeta("FirmwareImageLock", "firmwareImageLock", "fw-imagelock[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis'], [], ["Get"]),
    "FirmwareInfra": MoMeta("FirmwareInfra", "firmwareInfra", "fw-infra", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareSystem'], ['faultInst', 'trigLocalSched'], ["Get"]),
    "FirmwareInfraPack": MoMeta("FirmwareInfraPack", "firmwareInfraPack", "fw-infra-pack-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], ['firmwareBackupVersionHolder', 'firmwarePackItem'], ["Get", "Set"]),
    "FirmwareInstallImpact": MoMeta("FirmwareInstallImpact", "firmwareInstallImpact", "fw-sys-InstallImpact-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], ["Get"]),
    "FirmwareInstallable": MoMeta("FirmwareInstallable", "firmwareInstallable", "installable-[vendor]|[model]|[type]|[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareBootUnit', 'firmwareImage', 'firmwareUpdatable'], ['firmwareUcscInfo'], ["Get"]),
    "FirmwareModule": MoMeta("FirmwareModule", "firmwareModule", "module-[name]|[type]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['firmwareImage'], [], [None]),
    "FirmwarePCHStorageConfigConstraint": MoMeta("FirmwarePCHStorageConfigConstraint", "firmwarePCHStorageConfigConstraint", "constraint-pch-storage-config", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], ["Get"]),
    "FirmwarePackItem": MoMeta("FirmwarePackItem", "firmwarePackItem", "pack-image-[hw_vendor]|[hw_model]|[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['firmwareBackupVersionHolder', 'firmwareCatalogPack', 'firmwareChassisPack', 'firmwareComputeHostPack', 'firmwareComputeMgmtPack', 'firmwareInfraPack'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FirmwarePlatformBundleTypeCapProvider": MoMeta("FirmwarePlatformBundleTypeCapProvider", "firmwarePlatformBundleTypeCapProvider", "plat-bundle-type-cap-[platform_type]", VersionMeta.Version302c, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], ['firmwareBundleType'], [None]),
    "FirmwareProcessorTypeConstraint": MoMeta("FirmwareProcessorTypeConstraint", "firmwareProcessorTypeConstraint", "constraint-processor-type-[type]", VersionMeta.Version224b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], [None]),
    "FirmwareRack": MoMeta("FirmwareRack", "firmwareRack", "fw-rack", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareHost'], [], ["Get"]),
    "FirmwareRackPowerCapConstraint": MoMeta("FirmwareRackPowerCapConstraint", "firmwareRackPowerCapConstraint", "constraint-rack-powercap-config", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], [None]),
    "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'adaptorHostFcIf', 'biosUnit', 'capabilityCatalogue', 'capabilityMgmtExtension', 'equipmentPsu', 'graphicsCard', 'memoryPersistentMemoryUnit', 'mgmtController', 'pciSwitch', 'storageController', 'storageFlexFlashController', 'storageLocalDisk', 'storageNvmeSwitch', 'storageOnboardDevice', 'storageSasExpander'], ['firmwareServicePack'], ["Get"]),
    "FirmwareSecondControllerChassisConstraint": MoMeta("FirmwareSecondControllerChassisConstraint", "firmwareSecondControllerChassisConstraint", "second-controller-chassis-constraint", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareSecondControllerServerConstraint": MoMeta("FirmwareSecondControllerServerConstraint", "firmwareSecondControllerServerConstraint", "second-controller-server-constraint", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareSecureFPGA": MoMeta("FirmwareSecureFPGA", "firmwareSecureFPGA", "fw-secure-fpga", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['networkElement'], ['faultInst'], [None]),
    "FirmwareServerChassisConstraint": MoMeta("FirmwareServerChassisConstraint", "firmwareServerChassisConstraint", "server-chassis-constraint-[server_model]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareServerTypeConstraint": MoMeta("FirmwareServerTypeConstraint", "firmwareServerTypeConstraint", "constraint-server-type", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], ["Get"]),
    "FirmwareServicePack": MoMeta("FirmwareServicePack", "firmwareServicePack", "servicepack", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['firmwareBootUnit', 'firmwareRunning'], [], ["Get", "Set"]),
    "FirmwareSinglePathChassisConstraint": MoMeta("FirmwareSinglePathChassisConstraint", "firmwareSinglePathChassisConstraint", "single-path-chassis-constraint", VersionMeta.Version323a, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FirmwareSpec": MoMeta("FirmwareSpec", "firmwareSpec", "fw-spec-bundle-version-[bundle_version]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider'], [], ["Get"]),
    "FirmwareStatus": MoMeta("FirmwareStatus", "firmwareStatus", "fw-status", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentIOCard', 'equipmentPsu', 'networkElement', 'topSystem'], ['faultInst'], ["Get"]),
    "FirmwareSystem": MoMeta("FirmwareSystem", "firmwareSystem", "fw-system", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], ['topSystem'], ['eventInst', 'faultInst', 'firmwareAck', 'firmwareHost', 'firmwareInfra', 'firmwareSystemCompCheckResult', 'firmwareSystemFsm', 'firmwareSystemFsmTask'], ["Get"]),
    "FirmwareSystemCompCheckResult": MoMeta("FirmwareSystemCompCheckResult", "firmwareSystemCompCheckResult", "fw-sys-CompCheckRes-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareSystem'], [], ["Get"]),
    "FirmwareSystemFsm": MoMeta("FirmwareSystemFsm", "firmwareSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareSystem'], ['firmwareSystemFsmStage'], [None]),
    "FirmwareSystemFsmStage": MoMeta("FirmwareSystemFsmStage", "firmwareSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareSystemFsm'], [], [None]),
    "FirmwareSystemFsmTask": MoMeta("FirmwareSystemFsmTask", "firmwareSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['firmwareSystem'], [], [None]),
    "FirmwareTPMConstraint": MoMeta("FirmwareTPMConstraint", "firmwareTPMConstraint", "constraint-tpm-revision-[tpm_revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], [None]),
    "FirmwareType": MoMeta("FirmwareType", "firmwareType", "fw-type-[inv_tag]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentOnboardDeviceDef', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], ['firmwareDependency'], ["Get"]),
    "FirmwareUcscInfo": MoMeta("FirmwareUcscInfo", "firmwareUcscInfo", "ucsc-info", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], ['firmwareBootDefinition', 'firmwareCatalogue', 'firmwareInstallable'], [], ["Get"]),
    "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['biosUnit', 'equipmentPsu', 'mgmtController', 'storageOnboardDevice'], ['faultInst', 'firmwareInstallable'], ["Get", "Set"]),
    "FirmwareUpgradeConstraint": MoMeta("FirmwareUpgradeConstraint", "firmwareUpgradeConstraint", "fw-upgrd-constr", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBaseBoardCapProvider', 'equipmentBladeBiosCapProvider', 'equipmentBladeCapProvider', 'equipmentCatalogCapProvider', 'equipmentChassisCapProvider', 'equipmentCoprocessorUnitCapProvider', 'equipmentDbgPluginCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentIOExpanderCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentMgmtCapProvider', 'equipmentMgmtExtCapProvider', 'equipmentMiniStorageCapProvider', 'equipmentPciSwitchCapProvider', 'equipmentPersistentMemoryUnitCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackEnclosureCapProvider', 'equipmentRackUnitCapProvider', 'equipmentSecurityUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSiocCapProvider', 'equipmentStorageEncCapProvider', 'equipmentStorageNvmeSwitchCapProvider', 'equipmentStorageSasExpanderCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentTpmCapProvider'], [], ["Get"]),
    "FirmwareUpgradeDetail": MoMeta("FirmwareUpgradeDetail", "firmwareUpgradeDetail", "id-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['firmwareUpgradeInfo'], [], ["Get"]),
    "FirmwareUpgradeInfo": MoMeta("FirmwareUpgradeInfo", "firmwareUpgradeInfo", "validate-upgrade", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['firmwareUpgradeDetail'], ["Get"]),
    "FirmwareVicSlotConstraint": MoMeta("FirmwareVicSlotConstraint", "firmwareVicSlotConstraint", "constraint-vic-slot-[vic_slot]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], [None]),
    "FirmwareVnicCdnConstraint": MoMeta("FirmwareVnicCdnConstraint", "firmwareVnicCdnConstraint", "constraint-vnic-cdn-[type]", VersionMeta.Version224b, "InputOutput", 0x1, [], [""], ['firmwareConstraints'], [], [None]),
    "FirmwareWaterbaySiocServerConstraint": MoMeta("FirmwareWaterbaySiocServerConstraint", "firmwareWaterbaySiocServerConstraint", "waterbay-sioc-server-constraint", VersionMeta.Version401a, "InputOutput", 0x1, [], ["read-only"], ['firmwareConstraints'], [], [None]),
    "FlowctrlDefinition": MoMeta("FlowctrlDefinition", "flowctrlDefinition", "flowctrl", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], ['fabricLanCloud'], ['flowctrlItem'], ["Get", "Set"]),
    "FlowctrlItem": MoMeta("FlowctrlItem", "flowctrlItem", "policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], ['flowctrlDefinition'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FsmStatus": MoMeta("FsmStatus", "fsmStatus", "status-[converted_ep_ref]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], [], [None]),
    "GmetaClass": MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['gmetaHolder'], ['gmetaProp'], [None]),
    "GmetaEp": MoMeta("GmetaEp", "gmetaEp", "gmeta", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['gmetaHolder', 'gmetaPolicyMapHolder'], [None]),
    "GmetaHolder": MoMeta("GmetaHolder", "gmetaHolder", "category-[category]-provider-[provider]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['gmetaEp'], ['eventInst', 'faultInst', 'gmetaClass', 'gmetaHolderFsm', 'gmetaHolderFsmTask'], [None]),
    "GmetaHolderFsm": MoMeta("GmetaHolderFsm", "gmetaHolderFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['gmetaHolder'], ['gmetaHolderFsmStage'], [None]),
    "GmetaHolderFsmStage": MoMeta("GmetaHolderFsmStage", "gmetaHolderFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['gmetaHolderFsm'], [], [None]),
    "GmetaHolderFsmTask": MoMeta("GmetaHolderFsmTask", "gmetaHolderFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['gmetaHolder'], [], [None]),
    "GmetaPolicyMapElement": MoMeta("GmetaPolicyMapElement", "gmetaPolicyMapElement", "policymapelem-[name]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['gmetaPolicyMapHolder'], [], [None]),
    "GmetaPolicyMapHolder": MoMeta("GmetaPolicyMapHolder", "gmetaPolicyMapHolder", "policymapholder", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['gmetaEp'], ['gmetaPolicyMapElement'], [None]),
    "GmetaProp": MoMeta("GmetaProp", "gmetaProp", "prop-[order]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['gmetaClass'], [], [None]),
    "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version213a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['equipmentInventoryStatus', 'firmwareBootDefinition', 'firmwareRunning', 'graphicsController'], ["Get"]),
    "GraphicsController": MoMeta("GraphicsController", "graphicsController", "graphics-controller-[id]", VersionMeta.Version213a, "InputOutput", 0x1, [], ["read-only"], ['graphicsCard'], [], ["Get"]),
    "HostimgPolicy": MoMeta("HostimgPolicy", "hostimgPolicy", "img-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['orgOrg'], ['hostimgTarget'], ["Get"]),
    "HostimgTarget": MoMeta("HostimgTarget", "hostimgTarget", "target-[type]-comp-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['hostimgPolicy'], [], ["Get"]),
    "IdentIdentCtx": MoMeta("IdentIdentCtx", "identIdentCtx", "IdCtx-[seq_num]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['identIdentRequest'], [], [None]),
    "IdentIdentRequest": MoMeta("IdentIdentRequest", "identIdentRequest", "IdentQ-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['identMetaSystem'], ['eventInst', 'faultInst', 'identIdentCtx', 'identIdentRequestFsm', 'identIdentRequestFsmTask'], [None]),
    "IdentIdentRequestFsm": MoMeta("IdentIdentRequestFsm", "identIdentRequestFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identIdentRequest'], ['identIdentRequestFsmStage'], [None]),
    "IdentIdentRequestFsmStage": MoMeta("IdentIdentRequestFsmStage", "identIdentRequestFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identIdentRequestFsm'], [], [None]),
    "IdentIdentRequestFsmTask": MoMeta("IdentIdentRequestFsmTask", "identIdentRequestFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identIdentRequest'], [], [None]),
    "IdentMetaSystem": MoMeta("IdentMetaSystem", "identMetaSystem", "metasys", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['identMetaVerse'], ['eventInst', 'faultInst', 'identIdentRequest', 'identMetaSystemFsm', 'identMetaSystemFsmTask'], [None]),
    "IdentMetaSystemFsm": MoMeta("IdentMetaSystemFsm", "identMetaSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identMetaSystem'], ['identMetaSystemFsmStage'], [None]),
    "IdentMetaSystemFsmStage": MoMeta("IdentMetaSystemFsmStage", "identMetaSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identMetaSystemFsm'], [], [None]),
    "IdentMetaSystemFsmTask": MoMeta("IdentMetaSystemFsmTask", "identMetaSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['identMetaSystem'], [], [None]),
    "IdentMetaVerse": MoMeta("IdentMetaVerse", "identMetaVerse", "metaverse", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['identMetaSystem'], [None]),
    "IdentRequestEp": MoMeta("IdentRequestEp", "identRequestEp", "IdentQ", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['lsServer'], [], [None]),
    "IdentSysInfo": MoMeta("IdentSysInfo", "identSysInfo", "", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ImgprovPolicy": MoMeta("ImgprovPolicy", "imgprovPolicy", "img-prov-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['orgOrg'], ['imgprovTarget'], ["Get"]),
    "ImgprovTarget": MoMeta("ImgprovTarget", "imgprovTarget", "target-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['imgprovPolicy'], ['imgsecKey'], ["Get"]),
    "ImgsecKey": MoMeta("ImgsecKey", "imgsecKey", "key-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['imgprovTarget', 'imgsecPolicy'], [], ["Get"]),
    "ImgsecPolicy": MoMeta("ImgsecPolicy", "imgsecPolicy", "img-sec-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['orgOrg'], ['imgsecKey'], ["Get"]),
    "InitiatorFcInitiatorEp": MoMeta("InitiatorFcInitiatorEp", "initiatorFcInitiatorEp", "fc-ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageEpUser'], [None]),
    "InitiatorGroupEp": MoMeta("InitiatorGroupEp", "initiatorGroupEp", "grp-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorEp'], ['initiatorFcInitiatorEp', 'initiatorIScsiInitiatorEp', 'initiatorStoreEp', 'storageNodeEp'], [None]),
    "InitiatorIScsiInitiatorEp": MoMeta("InitiatorIScsiInitiatorEp", "initiatorIScsiInitiatorEp", "scsi-ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageEpUser'], [None]),
    "InitiatorLunEp": MoMeta("InitiatorLunEp", "initiatorLunEp", "lun-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['storageIScsiTargetIf'], [], [None]),
    "InitiatorMemberEp": MoMeta("InitiatorMemberEp", "initiatorMemberEp", "member-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorGrpEp'], [], [None]),
    "InitiatorRequestorEp": MoMeta("InitiatorRequestorEp", "initiatorRequestorEp", "req-sysid-[sys_id]-id-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['lsServer', 'storageSystem', 'topSystem'], ['initiatorGroupEp'], [None]),
    "InitiatorRequestorGrpEp": MoMeta("InitiatorRequestorGrpEp", "initiatorRequestorGrpEp", "req-grp-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['initiatorMemberEp', 'initiatorUnitEp'], [None]),
    "InitiatorStoreEp": MoMeta("InitiatorStoreEp", "initiatorStoreEp", "store-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], [], [None]),
    "InitiatorUnitEp": MoMeta("InitiatorUnitEp", "initiatorUnitEp", "unit-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorGrpEp'], [], [None]),
    "IpDnsSuffix": MoMeta("IpDnsSuffix", "ipDnsSuffix", "dns-suffix-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IpIPv4Dns": MoMeta("IpIPv4Dns", "ipIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IpIPv4WinsServer": MoMeta("IpIPv4WinsServer", "ipIPv4WinsServer", "wins-server-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IpIpV4StaticAddr": MoMeta("IpIpV4StaticAddr", "ipIpV4StaticAddr", "addr-[addr]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [], [], ["Add", "Get", "Remove", "Set"]),
    "IpIpV4StaticTargetAddr": MoMeta("IpIpV4StaticTargetAddr", "ipIpV4StaticTargetAddr", "ipv4-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetflowCollector'], [], [None]),
    "IpServiceIf": MoMeta("IpServiceIf", "ipServiceIf", "serv-ip-[addr]-port-[port]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['storageEtherIf'], [], [None]),
    "IppoolAddr": MoMeta("IppoolAddr", "ippoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['ippoolUniverse'], ['faultInst', 'ippoolPoolable'], ["Get"]),
    "IppoolBlock": MoMeta("IppoolBlock", "ippoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove"]),
    "IppoolIpV6Addr": MoMeta("IppoolIpV6Addr", "ippoolIpV6Addr", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['ippoolUniverse'], ['faultInst', 'ippoolPoolable'], [None]),
    "IppoolIpV6Block": MoMeta("IppoolIpV6Block", "ippoolIpV6Block", "v6block-[r_from]-[to]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove"]),
    "IppoolIpV6Pooled": MoMeta("IppoolIpV6Pooled", "ippoolIpV6Pooled", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['ippoolPool'], [], [None]),
    "IppoolPool": MoMeta("IppoolPool", "ippoolPool", "ip-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['extvmmNetworkSets', 'orgOrg'], ['faultInst', 'ipDnsSuffix', 'ipIPv4WinsServer', 'ippoolBlock', 'ippoolIpV6Block', 'ippoolIpV6Pooled', 'ippoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IppoolPoolable": MoMeta("IppoolPoolable", "ippoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['ippoolAddr', 'ippoolIpV6Addr'], [], ["Get"]),
    "IppoolPooled": MoMeta("IppoolPooled", "ippoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['ippoolPool'], [], ["Get"]),
    "IppoolUniverse": MoMeta("IppoolUniverse", "ippoolUniverse", "ip", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['ippoolAddr', 'ippoolIpV6Addr'], ["Get"]),
    "IqnpoolAddr": MoMeta("IqnpoolAddr", "iqnpoolAddr", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['iqnpoolUniverse'], ['faultInst', 'iqnpoolPoolable'], ["Get"]),
    "IqnpoolBlock": MoMeta("IqnpoolBlock", "iqnpoolBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['iqnpoolPool'], [], ["Add", "Get", "Remove"]),
    "IqnpoolFormat": MoMeta("IqnpoolFormat", "iqnpoolFormat", "format-[format]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin"], ['iqnpoolUniverse'], [], ["Get"]),
    "IqnpoolPool": MoMeta("IqnpoolPool", "iqnpoolPool", "iqn-pool-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['orgOrg'], ['faultInst', 'iqnpoolBlock', 'iqnpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IqnpoolPoolable": MoMeta("IqnpoolPoolable", "iqnpoolPoolable", "pool-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['iqnpoolAddr'], [], ["Get"]),
    "IqnpoolPooled": MoMeta("IqnpoolPooled", "iqnpoolPooled", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['iqnpoolPool'], [], ["Get"]),
    "IqnpoolTransportBlock": MoMeta("IqnpoolTransportBlock", "iqnpoolTransportBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [], [], [None]),
    "IqnpoolUniverse": MoMeta("IqnpoolUniverse", "iqnpoolUniverse", "iqn", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['iqnpoolAddr', 'iqnpoolFormat'], ["Get"]),
    "IscsiAuthProfile": MoMeta("IscsiAuthProfile", "iscsiAuthProfile", "iscsi-auth-profile-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], ['orgOrg'], [], ["Get"]),
    "LicenseContents": MoMeta("LicenseContents", "licenseContents", "contents-[feature_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseFile'], ['licenseFeatureLine'], ["Get"]),
    "LicenseDownloader": MoMeta("LicenseDownloader", "licenseDownloader", "dnld-[file_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['eventInst', 'faultInst', 'licenseDownloaderFsm', 'licenseDownloaderFsmTask', 'licenseProp'], ["Get"]),
    "LicenseDownloaderFsm": MoMeta("LicenseDownloaderFsm", "licenseDownloaderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseDownloader'], ['licenseDownloaderFsmStage'], [None]),
    "LicenseDownloaderFsmStage": MoMeta("LicenseDownloaderFsmStage", "licenseDownloaderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseDownloaderFsm'], [], [None]),
    "LicenseDownloaderFsmTask": MoMeta("LicenseDownloaderFsmTask", "licenseDownloaderFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['licenseDownloader'], [], [None]),
    "LicenseEp": MoMeta("LicenseEp", "licenseEp", "license", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['licenseDownloader', 'licenseFeature', 'licenseFile', 'licenseServerHostId'], ["Get"]),
    "LicenseFeature": MoMeta("LicenseFeature", "licenseFeature", "feature-[name]-[vendor]-[version]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['licenseInstance'], ["Get"]),
    "LicenseFeatureCapProvider": MoMeta("LicenseFeatureCapProvider", "licenseFeatureCapProvider", "feature-[feature_name]-[lic_vendor]|[lic_version]manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], [], ["Get"]),
    "LicenseFeatureLine": MoMeta("LicenseFeatureLine", "licenseFeatureLine", "FeatureLine-[id]:[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseContents'], [], ["Get"]),
    "LicenseFile": MoMeta("LicenseFile", "licenseFile", "file-[scope]:[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['eventInst', 'faultInst', 'licenseContents', 'licenseFileFsm', 'licenseFileFsmTask', 'licenseSource'], ["Get"]),
    "LicenseFileFsm": MoMeta("LicenseFileFsm", "licenseFileFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseFile'], ['licenseFileFsmStage'], [None]),
    "LicenseFileFsmStage": MoMeta("LicenseFileFsmStage", "licenseFileFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseFileFsm'], [], [None]),
    "LicenseFileFsmTask": MoMeta("LicenseFileFsmTask", "licenseFileFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['licenseFile'], [], [None]),
    "LicenseInstance": MoMeta("LicenseInstance", "licenseInstance", "inst-[scope]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['licenseFeature'], ['eventInst', 'faultInst', 'licenseInstanceFsm', 'licenseInstanceFsmTask', 'licenseProp', 'licenseSourceFile', 'licenseTarget'], ["Get"]),
    "LicenseInstanceFsm": MoMeta("LicenseInstanceFsm", "licenseInstanceFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseInstance'], ['licenseInstanceFsmStage'], [None]),
    "LicenseInstanceFsmStage": MoMeta("LicenseInstanceFsmStage", "licenseInstanceFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['licenseInstanceFsm'], [], [None]),
    "LicenseInstanceFsmTask": MoMeta("LicenseInstanceFsmTask", "licenseInstanceFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['licenseInstance'], [], [None]),
    "LicenseProp": MoMeta("LicenseProp", "licenseProp", "prop-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseDownloader', 'licenseInstance'], [], ["Get"]),
    "LicenseServerHostId": MoMeta("LicenseServerHostId", "licenseServerHostId", "server-host-id-[scope]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseEp'], [], ["Get"]),
    "LicenseSource": MoMeta("LicenseSource", "licenseSource", "source", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseFile'], [], ["Get"]),
    "LicenseSourceFile": MoMeta("LicenseSourceFile", "licenseSourceFile", "src-[id]:[line]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['licenseInstance'], [], ["Get"]),
    "LicenseTarget": MoMeta("LicenseTarget", "licenseTarget", "slot-[slot_id]-aggr-port-[aggr_port_id]-port-[port_id]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin"], ['licenseInstance'], [], [None]),
    "LldpAcquired": MoMeta("LldpAcquired", "lldpAcquired", "lldp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['etherPIo', 'etherServerIntFIo', 'fcPIo'], [], ["Get"]),
    "LsAgentPolicy": MoMeta("LsAgentPolicy", "lsAgentPolicy", "agent-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], ['orgOrg'], [], [None]),
    "LsBinding": MoMeta("LsBinding", "lsBinding", "pn", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsFcLocale": MoMeta("LsFcLocale", "lsFcLocale", "fc-local-[switch_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsServer'], ['lsFcZoneGroup'], [None]),
    "LsFcZone": MoMeta("LsFcZone", "lsFcZone", "zone-[identity]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsZoneInitiatorMember'], ['lsZoneTargetMember'], [None]),
    "LsFcZoneGroup": MoMeta("LsFcZoneGroup", "lsFcZoneGroup", "zone-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcLocale'], ['lsZoneInitiatorMember'], [None]),
    "LsIdentityInfo": MoMeta("LsIdentityInfo", "lsIdentityInfo", "ls-identity-info", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer'], ['faultInst'], ["Get"]),
    "LsIssues": MoMeta("LsIssues", "lsIssues", "config-issue", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], ['faultInst'], ["Get"]),
    "LsPower": MoMeta("LsPower", "lsPower", "power", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['lsServer'], [], ["Get", "Set"]),
    "LsRequirement": MoMeta("LsRequirement", "lsRequirement", "pn-req", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsServer": MoMeta("LsServer", "lsServer", "ls-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['orgOrg'], ['cimcvmediaMountConfigDef', 'computePowerSyncDef', 'eventInst', 'fabricVCon', 'faultInst', 'faultSuppressTask', 'identRequestEp', 'initiatorRequestorEp', 'lsBinding', 'lsFcLocale', 'lsIdentityInfo', 'lsIssues', 'lsPower', 'lsRequirement', 'lsServerAssocCtx', 'lsServerExtension', 'lsServerFsm', 'lsServerFsmTask', 'lsUuidHistory', 'lsVConAssign', 'lsVersionBeh', 'lsbootDef', 'lsmaintAck', 'lstorageProfileBinding', 'lstorageProfileDef', 'memoryPersistentMemoryConfiguration', 'mgmtInterface', 'moKvCfgHolder', 'solConfig', 'storageIniGroup', 'storageLocalDiskConfigDef', 'storageVirtualDriveRef', 'vnicConnDef', 'vnicDefBeh', 'vnicDynamicCon', 'vnicEther', 'vnicFc', 'vnicFcNode', 'vnicIScsi', 'vnicIScsiBootParams', 'vnicIScsiLCP', 'vnicIScsiNode', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicIpc', 'vnicScsi'], ["Add", "Get", "Remove", "Set"]),
    "LsServerAssocCtx": MoMeta("LsServerAssocCtx", "lsServerAssocCtx", "ls-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['lsServer'], ['adaptorUnitAssocCtx', 'computePhysicalAssocCtx', 'processorUnitAssocCtx'], ["Get"]),
    "LsServerExtension": MoMeta("LsServerExtension", "lsServerExtension", "extension", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], [], ["Get", "Set"]),
    "LsServerFsm": MoMeta("LsServerFsm", "lsServerFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['lsServer'], ['lsServerFsmStage'], [None]),
    "LsServerFsmStage": MoMeta("LsServerFsmStage", "lsServerFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['lsServerFsm'], [], [None]),
    "LsServerFsmTask": MoMeta("LsServerFsmTask", "lsServerFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['lsServer'], [], [None]),
    "LsTier": MoMeta("LsTier", "lsTier", "tier-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], ['lsServer'], [None]),
    "LsUuidHistory": MoMeta("LsUuidHistory", "lsUuidHistory", "uuid-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['lsServer'], [], [None]),
    "LsVConAssign": MoMeta("LsVConAssign", "lsVConAssign", "assign-[transport]-vnic-[vnic_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], [], ["Get", "Set"]),
    "LsVersionBeh": MoMeta("LsVersionBeh", "lsVersionBeh", "ls-vers-beh", VersionMeta.Version201q, "InputOutput", 0x1, [], ["admin"], ['lsServer'], [], ["Get", "Set"]),
    "LsZoneInitiatorMember": MoMeta("LsZoneInitiatorMember", "lsZoneInitiatorMember", "initiator-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcZoneGroup'], ['lsFcZone'], [None]),
    "LsZoneTargetMember": MoMeta("LsZoneTargetMember", "lsZoneTargetMember", "target-[wwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcZone'], [], [None]),
    "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer'], ['lsbootBootSecurity', 'lsbootEFIShell', 'lsbootIScsi', 'lsbootLan', 'lsbootSan', 'lsbootStorage', 'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootDefaultLocalImage": MoMeta("LsbootDefaultLocalImage", "lsbootDefaultLocalImage", "local-any", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEFIShell": MoMeta("LsbootEFIShell", "lsbootEFIShell", "efi-shell", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImage": MoMeta("LsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImage", "embedded-local-jbod", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootEmbeddedLocalDiskImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImagePath": MoMeta("LsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootEmbeddedLocalDiskImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalLunImage": MoMeta("LsbootEmbeddedLocalLunImage", "lsbootEmbeddedLocalLunImage", "embedded-local-lun", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsi": MoMeta("LsbootIScsi", "lsbootIScsi", "iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootIScsiImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsiImagePath": MoMeta("LsbootIScsiImagePath", "lsbootIScsiImagePath", "path-[type]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootIScsi'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootLanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLanImagePath": MoMeta("LsbootLanImagePath", "lsbootLanImagePath", "path-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLan'], ['lsbootUEFIBootParam', 'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImage": MoMeta("LsbootLocalDiskImage", "lsbootLocalDiskImage", "local-jbod", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootLocalDiskImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImagePath": MoMeta("LsbootLocalDiskImagePath", "lsbootLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalDiskImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalHddImage": MoMeta("LsbootLocalHddImage", "lsbootLocalHddImage", "local-hdd", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootLocalLunImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalLunImagePath": MoMeta("LsbootLocalLunImagePath", "lsbootLocalLunImagePath", "lunimgpath-[type]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalHddImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootStorage'], ['lsbootDefaultLocalImage', 'lsbootEmbeddedLocalDiskImage', 'lsbootEmbeddedLocalLunImage', 'lsbootLocalDiskImage', 'lsbootLocalHddImage', 'lsbootNvme', 'lsbootUsbExternalImage', 'lsbootUsbFlashStorageImage', 'lsbootUsbInternalImage'], ["Add", "Get", "Remove"]),
    "LsbootNvme": MoMeta("LsbootNvme", "lsbootNvme", "nvme", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootNvmeDiskSsd', 'lsbootNvmePciSsd', 'lsbootUEFIBootParam'], ["Get", "Set"]),
    "LsbootNvmeDiskSsd": MoMeta("LsbootNvmeDiskSsd", "lsbootNvmeDiskSsd", "nvme-disk-ssd", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootNvme'], [], ["Get", "Set"]),
    "LsbootNvmePciSsd": MoMeta("LsbootNvmePciSsd", "lsbootNvmePciSsd", "nvme-pci-ssd", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootNvme'], [], ["Get", "Set"]),
    "LsbootPolicy": MoMeta("LsbootPolicy", "lsbootPolicy", "boot-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], ['orgOrg', 'policySystemEp'], ['lsbootBootSecurity', 'lsbootEFIShell', 'lsbootIScsi', 'lsbootLan', 'lsbootSan', 'lsbootStorage', 'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootSanCatSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImage": MoMeta("LsbootSanCatSanImage", "lsbootSanCatSanImage", "sanimg-[type]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSan'], ['lsbootSanCatSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImagePath": MoMeta("LsbootSanCatSanImagePath", "lsbootSanCatSanImagePath", "sanimgpath-[type]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSanCatSanImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImage": MoMeta("LsbootSanImage", "lsbootSanImage", "san-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootStorage'], ['lsbootSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImagePath": MoMeta("LsbootSanImagePath", "lsbootSanImagePath", "path-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSanImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootLocalStorage', 'lsbootSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUEFIBootParam": MoMeta("LsbootUEFIBootParam", "lsbootUEFIBootParam", "uefi-boot-param", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], ['lsbootDefaultLocalImage', 'lsbootEmbeddedLocalDiskImage', 'lsbootEmbeddedLocalDiskImagePath', 'lsbootEmbeddedLocalLunImage', 'lsbootIScsiImagePath', 'lsbootLanImagePath', 'lsbootLocalDiskImage', 'lsbootLocalDiskImagePath', 'lsbootLocalHddImage', 'lsbootLocalLunImagePath', 'lsbootNvme', 'lsbootSanCatSanImagePath', 'lsbootSanImagePath', 'lsbootUsbExternalImage', 'lsbootUsbFlashStorageImage', 'lsbootUsbInternalImage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbExternalImage": MoMeta("LsbootUsbExternalImage", "lsbootUsbExternalImage", "usb-extern", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbFlashStorageImage": MoMeta("LsbootUsbFlashStorageImage", "lsbootUsbFlashStorageImage", "sd-card", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbInternalImage": MoMeta("LsbootUsbInternalImage", "lsbootUsbInternalImage", "usb-intern", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "[access]-vm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsmaintAck": MoMeta("LsmaintAck", "lsmaintAck", "ack", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper"], ['lsServer'], ['faultInst', 'trigLocalSched'], ["Get", "Set"]),
    "LsmaintMaintPolicy": MoMeta("LsmaintMaintPolicy", "lsmaintMaintPolicy", "maint-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageControllerDef": MoMeta("LstorageControllerDef", "lstorageControllerDef", "controller-def-[name]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef', 'storageController'], ['lstorageControllerModeConfig', 'lstorageControllerQualifier'], ["Add", "Get", "Remove"]),
    "LstorageControllerModeConfig": MoMeta("LstorageControllerModeConfig", "lstorageControllerModeConfig", "controller-mode-config", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageControllerDef'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageControllerQualifier": MoMeta("LstorageControllerQualifier", "lstorageControllerQualifier", "controller-qual", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageControllerDef'], [], [None]),
    "LstorageControllerRef": MoMeta("LstorageControllerRef", "lstorageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['lstorageDiskSlot'], [], ["Add", "Get", "Remove"]),
    "LstorageDasScsiLun": MoMeta("LstorageDasScsiLun", "lstorageDasScsiLun", "das-scsi-lun-[name]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef'], ['faultInst', 'storageLocalDiskConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupConfigDef": MoMeta("LstorageDiskGroupConfigDef", "lstorageDiskGroupConfigDef", "disk-group-config", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['storageVirtualDriveRef'], ['lstorageDiskGroupQualifier', 'lstorageLocalDiskConfigRef', 'lstorageVirtualDriveDef'], ["Get"]),
    "LstorageDiskGroupConfigPolicy": MoMeta("LstorageDiskGroupConfigPolicy", "lstorageDiskGroupConfigPolicy", "disk-group-config-[name]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['lstorageDiskGroupQualifier', 'lstorageLocalDiskConfigRef', 'lstorageVirtualDriveDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupQualifier": MoMeta("LstorageDiskGroupQualifier", "lstorageDiskGroupQualifier", "disk-group-qual", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskSlot": MoMeta("LstorageDiskSlot", "lstorageDiskSlot", "disk-slot-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['lstorageDiskZoningConfigDef', 'lstorageDiskZoningPolicy'], ['lstorageControllerRef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskZoningConfigDef": MoMeta("LstorageDiskZoningConfigDef", "lstorageDiskZoningConfigDef", "disk-zoning-def", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile'], ['lstorageDiskSlot'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskZoningPolicy": MoMeta("LstorageDiskZoningPolicy", "lstorageDiskZoningPolicy", "disk-zoning-policy-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], ['lstorageDiskSlot'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDriveSecurity": MoMeta("LstorageDriveSecurity", "lstorageDriveSecurity", "drive", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageSecurity'], ['lstorageLocal', 'lstorageRemote'], ["Get"]),
    "LstorageLocal": MoMeta("LstorageLocal", "lstorageLocal", "local", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard', 'lstorageDriveSecurity'], [], ["Get", "Set"]),
    "LstorageLocalDef": MoMeta("LstorageLocalDef", "lstorageLocalDef", "local-def", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard'], [], ["Get"]),
    "LstorageLocalDiskConfigRef": MoMeta("LstorageLocalDiskConfigRef", "lstorageLocalDiskConfigRef", "slot-[slot_num]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageLocalDiskRef": MoMeta("LstorageLocalDiskRef", "lstorageLocalDiskRef", "diskref-[enclosure_id]-slot-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "LstorageLogin": MoMeta("LstorageLogin", "lstorageLogin", "login", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageRemote', 'lstorageRemoteDef'], [], ["Get", "Set"]),
    "LstorageLunSetConfig": MoMeta("LstorageLunSetConfig", "lstorageLunSetConfig", "lun-set-config-[name]", VersionMeta.Version402a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef'], ['lstorageLunSetDiskSlot', 'lstorageVirtualDriveDef'], [None]),
    "LstorageLunSetDiskSlot": MoMeta("LstorageLunSetDiskSlot", "lstorageLunSetDiskSlot", "lun-set-disk-slot-[id]", VersionMeta.Version402a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageLunSetConfig'], [], [None]),
    "LstorageProfile": MoMeta("LstorageProfile", "lstorageProfile", "profile-[name]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'orgOrg'], ['lstorageControllerDef', 'lstorageDasScsiLun', 'lstorageLunSetConfig', 'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileBinding": MoMeta("LstorageProfileBinding", "lstorageProfileBinding", "profile-binding", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileDef": MoMeta("LstorageProfileDef", "lstorageProfileDef", "profile-def", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer'], ['lstorageControllerDef', 'lstorageDasScsiLun', 'lstorageLunSetConfig', 'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageRemote": MoMeta("LstorageRemote", "lstorageRemote", "remote", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard', 'lstorageDriveSecurity'], ['lstorageLogin'], ["Get", "Set"]),
    "LstorageRemoteDef": MoMeta("LstorageRemoteDef", "lstorageRemoteDef", "remote-def", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard'], ['lstorageLogin'], ["Get"]),
    "LstorageSasExpanderConfigPolicy": MoMeta("LstorageSasExpanderConfigPolicy", "lstorageSasExpanderConfigPolicy", "sas-expander-config-policy-[name]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], [], [None]),
    "LstorageSecurity": MoMeta("LstorageSecurity", "lstorageSecurity", "security", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef', 'storageLocalDiskConfigDef', 'storageLocalDiskConfigPolicy'], ['lstorageDriveSecurity'], ["Get", "Set"]),
    "LstorageVirtualDriveDef": MoMeta("LstorageVirtualDriveDef", "lstorageVirtualDriveDef", "virtual-drive-def", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy', 'lstorageLunSetConfig'], [], ["Get", "Set"]),
    "MacpoolAddr": MoMeta("MacpoolAddr", "macpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['macpoolUniverse'], ['faultInst', 'macpoolPoolable'], ["Get"]),
    "MacpoolBlock": MoMeta("MacpoolBlock", "macpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['macpoolPool'], [], ["Add", "Get", "Remove"]),
    "MacpoolFormat": MoMeta("MacpoolFormat", "macpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network", "ls-network-policy"], ['macpoolUniverse'], [], ["Get"]),
    "MacpoolPool": MoMeta("MacpoolPool", "macpoolPool", "mac-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['orgOrg'], ['faultInst', 'macpoolBlock', 'macpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "MacpoolPoolable": MoMeta("MacpoolPoolable", "macpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['macpoolAddr'], [], ["Get"]),
    "MacpoolPooled": MoMeta("MacpoolPooled", "macpoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['macpoolPool'], [], ["Get"]),
    "MacpoolUniverse": MoMeta("MacpoolUniverse", "macpoolUniverse", "mac", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['macpoolAddr', 'macpoolFormat'], [None]),
    "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBoard'], ['faultInst', 'memoryArrayEnvStats', 'memoryPersistentMemoryUnit', 'memoryUnit'], ["Get"]),
    "MemoryArrayEnvStats": MoMeta("MemoryArrayEnvStats", "memoryArrayEnvStats", "array-env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryArray'], ['memoryArrayEnvStatsHist'], ["Get"]),
    "MemoryArrayEnvStatsHist": MoMeta("MemoryArrayEnvStatsHist", "memoryArrayEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['memoryArrayEnvStats'], [], ["Get"]),
    "MemoryBufferUnit": MoMeta("MemoryBufferUnit", "memoryBufferUnit", "sensor-unit-[id]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'memoryBufferUnitEnvStats'], ["Get"]),
    "MemoryBufferUnitEnvStats": MoMeta("MemoryBufferUnitEnvStats", "memoryBufferUnitEnvStats", "buffer-unit-env-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryBufferUnit'], ['memoryBufferUnitEnvStatsHist'], ["Get"]),
    "MemoryBufferUnitEnvStatsHist": MoMeta("MemoryBufferUnitEnvStatsHist", "memoryBufferUnitEnvStatsHist", "[id]", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["read-only"], ['memoryBufferUnitEnvStats'], [], ["Get"]),
    "MemoryErrorStats": MoMeta("MemoryErrorStats", "memoryErrorStats", "error-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryPersistentMemoryUnit', 'memoryUnit'], [], ["Get"]),
    "MemoryPersistentMemoryConfigResult": MoMeta("MemoryPersistentMemoryConfigResult", "memoryPersistentMemoryConfigResult", "cfg-result", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryPersistentMemoryConfiguration'], ['faultInst', 'memoryPersistentMemoryNamespaceConfigResult'], [None]),
    "MemoryPersistentMemoryConfiguration": MoMeta("MemoryPersistentMemoryConfiguration", "memoryPersistentMemoryConfiguration", "pmemory-config", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBoard', 'lsServer'], ['faultInst', 'memoryPersistentMemoryConfigResult', 'memoryPersistentMemoryRegion'], [None]),
    "MemoryPersistentMemoryGoal": MoMeta("MemoryPersistentMemoryGoal", "memoryPersistentMemoryGoal", "goal-[socket_id]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['memoryPersistentMemoryPolicy'], [], [None]),
    "MemoryPersistentMemoryLocalSecurity": MoMeta("MemoryPersistentMemoryLocalSecurity", "memoryPersistentMemoryLocalSecurity", "local", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['memoryPersistentMemorySecurity'], [], [None]),
    "MemoryPersistentMemoryLogicalNamespace": MoMeta("MemoryPersistentMemoryLogicalNamespace", "memoryPersistentMemoryLogicalNamespace", "lns-[name]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['memoryPersistentMemoryPolicy'], [], [None]),
    "MemoryPersistentMemoryNamespace": MoMeta("MemoryPersistentMemoryNamespace", "memoryPersistentMemoryNamespace", "ns-[uuid]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryPersistentMemoryRegion'], ['faultInst'], [None]),
    "MemoryPersistentMemoryNamespaceConfigResult": MoMeta("MemoryPersistentMemoryNamespaceConfigResult", "memoryPersistentMemoryNamespaceConfigResult", "nscr-[name]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryPersistentMemoryConfigResult'], ['faultInst'], [None]),
    "MemoryPersistentMemoryPolicy": MoMeta("MemoryPersistentMemoryPolicy", "memoryPersistentMemoryPolicy", "pmemory-policy-[name]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['orgOrg'], ['memoryPersistentMemoryGoal', 'memoryPersistentMemoryLogicalNamespace', 'memoryPersistentMemorySecurity'], [None]),
    "MemoryPersistentMemoryRegion": MoMeta("MemoryPersistentMemoryRegion", "memoryPersistentMemoryRegion", "region-[id]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryPersistentMemoryConfiguration'], ['memoryPersistentMemoryNamespace'], [None]),
    "MemoryPersistentMemorySecurity": MoMeta("MemoryPersistentMemorySecurity", "memoryPersistentMemorySecurity", "security", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['memoryPersistentMemoryPolicy'], ['memoryPersistentMemoryLocalSecurity'], [None]),
    "MemoryPersistentMemoryUnit": MoMeta("MemoryPersistentMemoryUnit", "memoryPersistentMemoryUnit", "pmemory-[id]", VersionMeta.Version404a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryArray'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'memoryErrorStats', 'memoryUnitEnvStats'], [None]),
    "MemoryQual": MoMeta("MemoryQual", "memoryQual", "memory", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "MemoryRuntime": MoMeta("MemoryRuntime", "memoryRuntime", "[type]-mem-rt", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBlade'], ['memoryRuntimeHist'], ["Get"]),
    "MemoryRuntimeHist": MoMeta("MemoryRuntimeHist", "memoryRuntimeHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['memoryRuntime'], [], ["Get"]),
    "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['memoryArray'], ['equipmentInventoryStatus', 'faultInst', 'memoryErrorStats', 'memoryUnitEnvStats'], ["Get"]),
    "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryPersistentMemoryUnit', 'memoryUnit'], ['memoryUnitEnvStatsHist'], ["Get"]),
    "MemoryUnitEnvStatsHist": MoMeta("MemoryUnitEnvStatsHist", "memoryUnitEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['memoryUnitEnvStats'], [], ["Get"]),
    "MgmtAccessPolicy": MoMeta("MgmtAccessPolicy", "mgmtAccessPolicy", "ext-access-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['mgmtAccessPolicyItem'], ["Get"]),
    "MgmtAccessPolicyItem": MoMeta("MgmtAccessPolicyItem", "mgmtAccessPolicyItem", "item-[subject]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['mgmtAccessPolicy'], ['mgmtAccessPort'], ["Get"]),
    "MgmtAccessPort": MoMeta("MgmtAccessPort", "mgmtAccessPort", "[protocol]-port-[port]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['mgmtAccessPolicyItem'], [], ["Get"]),
    "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "backup-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtBackupFsm', 'mgmtBackupFsmTask'], ["Add", "Get", "Remove"]),
    "MgmtBackupExportExtPolicy": MoMeta("MgmtBackupExportExtPolicy", "mgmtBackupExportExtPolicy", "backup-exp-policy", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], [], ["Get", "Set"]),
    "MgmtBackupFsm": MoMeta("MgmtBackupFsm", "mgmtBackupFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackup'], ['mgmtBackupFsmStage'], [None]),
    "MgmtBackupFsmStage": MoMeta("MgmtBackupFsmStage", "mgmtBackupFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackupFsm'], [], [None]),
    "MgmtBackupFsmTask": MoMeta("MgmtBackupFsmTask", "mgmtBackupFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['mgmtBackup'], [], [None]),
    "MgmtBackupPolicy": MoMeta("MgmtBackupPolicy", "mgmtBackupPolicy", "db-backup-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], ['eventInst', 'faultInst', 'mgmtBackupPolicyFsm', 'mgmtExportPolicyFsm', 'mgmtExportPolicyFsmTask'], ["Get", "Set"]),
    "MgmtBackupPolicyConfig": MoMeta("MgmtBackupPolicyConfig", "mgmtBackupPolicyConfig", "bkup-policy-cfg", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['faultInst', 'trigLocalSched'], ["Get"]),
    "MgmtBackupPolicyFsm": MoMeta("MgmtBackupPolicyFsm", "mgmtBackupPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackupPolicy'], ['mgmtBackupPolicyFsmStage'], [None]),
    "MgmtBackupPolicyFsmStage": MoMeta("MgmtBackupPolicyFsmStage", "mgmtBackupPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackupPolicyFsm'], [], [None]),
    "MgmtCfgExportPolicy": MoMeta("MgmtCfgExportPolicy", "mgmtCfgExportPolicy", "cfg-exp-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], ['eventInst', 'faultInst', 'mgmtCfgExportPolicyFsm', 'mgmtExportPolicyFsm', 'mgmtExportPolicyFsmTask'], ["Get", "Set"]),
    "MgmtCfgExportPolicyFsm": MoMeta("MgmtCfgExportPolicyFsm", "mgmtCfgExportPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtCfgExportPolicy'], ['mgmtCfgExportPolicyFsmStage'], [None]),
    "MgmtCfgExportPolicyFsmStage": MoMeta("MgmtCfgExportPolicyFsmStage", "mgmtCfgExportPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtCfgExportPolicyFsm'], [], [None]),
    "MgmtCimcSecureBoot": MoMeta("MgmtCimcSecureBoot", "mgmtCimcSecureBoot", "mgmt-secure-boot", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute"], ['mgmtController'], [], ["Get", "Set"]),
    "MgmtCmcSecureBoot": MoMeta("MgmtCmcSecureBoot", "mgmtCmcSecureBoot", "mgmt-cmc-secure-boot", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute"], ['mgmtController'], [], ["Get", "Set"]),
    "MgmtConnection": MoMeta("MgmtConnection", "mgmtConnection", "mgmt-connection-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], ['faultInst'], ["Get", "Set"]),
    "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorUnit', 'computeBlade', 'computeBoardController', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFex', 'equipmentIOCard', 'equipmentSharedIOModule', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'networkElement', 'storageController', 'storageLocalDisk', 'storageSasExpander', 'topSystem'], ['cimcvmediaActualMountList', 'eventInst', 'fabricLocale', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable', 'mgmtCimcSecureBoot', 'mgmtCmcSecureBoot', 'mgmtConnection', 'mgmtControllerFsm', 'mgmtControllerFsmTask', 'mgmtHealthStatus', 'mgmtIf', 'mgmtInterface', 'mgmtKvmCertificate', 'mgmtProfDerivedInterface', 'mgmtSpdmCertificateInventory', 'mgmtSwPersonalities', 'mgmtSwPersonalitiesInventory', 'mgmtUsbNicMgmtIf', 'sysdebugMEpLog', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Get"]),
    "MgmtControllerFsm": MoMeta("MgmtControllerFsm", "mgmtControllerFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtController'], ['mgmtControllerFsmStage'], [None]),
    "MgmtControllerFsmStage": MoMeta("MgmtControllerFsmStage", "mgmtControllerFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtControllerFsm'], [], [None]),
    "MgmtControllerFsmTask": MoMeta("MgmtControllerFsmTask", "mgmtControllerFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['mgmtController'], [], [None]),
    "MgmtDbState": MoMeta("MgmtDbState", "mgmtDbState", "mgmt-db-state", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['faultInst'], ["Get", "Set"]),
    "MgmtEntity": MoMeta("MgmtEntity", "mgmtEntity", "mgmt-entity-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['faultInst', 'mgmtPmonEntry'], ["Get"]),
    "MgmtExportPolicyFsm": MoMeta("MgmtExportPolicyFsm", "mgmtExportPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackupPolicy', 'mgmtCfgExportPolicy'], ['mgmtExportPolicyFsmStage'], [None]),
    "MgmtExportPolicyFsmStage": MoMeta("MgmtExportPolicyFsmStage", "mgmtExportPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtExportPolicyFsm'], [], [None]),
    "MgmtExportPolicyFsmTask": MoMeta("MgmtExportPolicyFsmTask", "mgmtExportPolicyFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtBackupPolicy', 'mgmtCfgExportPolicy'], [], [None]),
    "MgmtHealthAttr": MoMeta("MgmtHealthAttr", "mgmtHealthAttr", "[name]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], ['mgmtHealthStatus'], [], ["Get"]),
    "MgmtHealthStatus": MoMeta("MgmtHealthStatus", "mgmtHealthStatus", "health", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], ['mgmtController', 'networkElement'], ['faultInst', 'mgmtHealthAttr'], ["Get"]),
    "MgmtIPv6IfAddr": MoMeta("MgmtIPv6IfAddr", "mgmtIPv6IfAddr", "if-ipv6", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['mgmtIPv6IfConfig'], ['eventInst', 'faultInst', 'mgmtIPv6IfAddrFsm', 'mgmtIPv6IfAddrFsmTask'], ["Get", "Set"]),
    "MgmtIPv6IfAddrFsm": MoMeta("MgmtIPv6IfAddrFsm", "mgmtIPv6IfAddrFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['mgmtIPv6IfAddr'], ['mgmtIPv6IfAddrFsmStage'], [None]),
    "MgmtIPv6IfAddrFsmStage": MoMeta("MgmtIPv6IfAddrFsmStage", "mgmtIPv6IfAddrFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['mgmtIPv6IfAddrFsm'], [], [None]),
    "MgmtIPv6IfAddrFsmTask": MoMeta("MgmtIPv6IfAddrFsmTask", "mgmtIPv6IfAddrFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['mgmtIPv6IfAddr'], [], [None]),
    "MgmtIPv6IfConfig": MoMeta("MgmtIPv6IfConfig", "mgmtIPv6IfConfig", "ifConfig-ipv6", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['mgmtIf', 'networkElement'], ['mgmtIPv6IfAddr'], ["Get"]),
    "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['adaptorHostEthIf', 'mgmtController'], ['dhcpAcquired', 'eventInst', 'faultInst', 'mgmtIPv6IfConfig', 'mgmtIfFsm', 'mgmtIfFsmTask'], ["Get"]),
    "MgmtIfFsm": MoMeta("MgmtIfFsm", "mgmtIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtIf'], ['mgmtIfFsmStage'], [None]),
    "MgmtIfFsmStage": MoMeta("MgmtIfFsmStage", "mgmtIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtIfFsm'], [], [None]),
    "MgmtIfFsmTask": MoMeta("MgmtIfFsmTask", "mgmtIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['mgmtIf'], [], [None]),
    "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtImporterFsm', 'mgmtImporterFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtImporterFsm": MoMeta("MgmtImporterFsm", "mgmtImporterFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtImporter'], ['mgmtImporterFsmStage'], [None]),
    "MgmtImporterFsmStage": MoMeta("MgmtImporterFsmStage", "mgmtImporterFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['mgmtImporterFsm'], [], [None]),
    "MgmtImporterFsmTask": MoMeta("MgmtImporterFsmTask", "mgmtImporterFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['mgmtImporter'], [], [None]),
    "MgmtInbandProfile": MoMeta("MgmtInbandProfile", "mgmtInbandProfile", "ib-profile", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], [], ["Get", "Set"]),
    "MgmtIntAuthPolicy": MoMeta("MgmtIntAuthPolicy", "mgmtIntAuthPolicy", "int-mgmt-auth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-security"], ['topSystem'], [], ["Get"]),
    "MgmtInterface": MoMeta("MgmtInterface", "mgmtInterface", "iface-[mode]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['lsServer', 'mgmtController'], ['faultInst', 'mgmtVnet'], ["Add", "Get", "Remove", "Set"]),
    "MgmtKmip": MoMeta("MgmtKmip", "mgmtKmip", "kmip", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['mgmtSecurity'], [], ["Get", "Set"]),
    "MgmtKmipCertPolicy": MoMeta("MgmtKmipCertPolicy", "mgmtKmipCertPolicy", "kmip-cert", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-oper", "ls-server-policy", "read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'pkiEp'], [], ["Get", "Set"]),
    "MgmtKvmCertificate": MoMeta("MgmtKvmCertificate", "mgmtKvmCertificate", "cert", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-server-oper"], ['computeKvmMgmtPolicy', 'mgmtController'], ['faultInst'], [None]),
    "MgmtLeaderEntity": MoMeta("MgmtLeaderEntity", "mgmtLeaderEntity", "leader-entity", VersionMeta.Version401a, "InputOutput", 0x1, [], ["read-only"], ['fabricLanCloud', 'fabricSanCloud'], [], [None]),
    "MgmtPmonEntry": MoMeta("MgmtPmonEntry", "mgmtPmonEntry", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['mgmtEntity'], ['faultInst'], ["Get"]),
    "MgmtProfDerivedInterface": MoMeta("MgmtProfDerivedInterface", "mgmtProfDerivedInterface", "spiface-[mode]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtController'], ['mgmtVnet'], ["Get"]),
    "MgmtSecurity": MoMeta("MgmtSecurity", "mgmtSecurity", "sec", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['mgmtKmip'], ["Get"]),
    "MgmtSpdmCertificate": MoMeta("MgmtSpdmCertificate", "mgmtSpdmCertificate", "spdm-cert-[name]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtSpdmCertificatePolicy'], [], [None]),
    "MgmtSpdmCertificateData": MoMeta("MgmtSpdmCertificateData", "mgmtSpdmCertificateData", "spdm-cert-[cert_id]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtSpdmCertificateInventory'], [], [None]),
    "MgmtSpdmCertificateInventory": MoMeta("MgmtSpdmCertificateInventory", "mgmtSpdmCertificateInventory", "spdm-cert-inventory", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], ['mgmtSpdmCertificateData'], [None]),
    "MgmtSpdmCertificatePolicy": MoMeta("MgmtSpdmCertificatePolicy", "mgmtSpdmCertificatePolicy", "spdm-cert-policy-[name]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-server", "ls-server-oper", "ls-server-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'orgOrg'], ['mgmtSpdmCertificate'], [None]),
    "MgmtSwPersonalities": MoMeta("MgmtSwPersonalities", "mgmtSwPersonalities", "sw-personalities", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], ['mgmtSwPersonality'], [None]),
    "MgmtSwPersonalitiesInventory": MoMeta("MgmtSwPersonalitiesInventory", "mgmtSwPersonalitiesInventory", "sw-personalities-inventory", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], ['mgmtSwPersonality'], [None]),
    "MgmtSwPersonality": MoMeta("MgmtSwPersonality", "mgmtSwPersonality", "sw-personality-[id]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['mgmtSwPersonalities', 'mgmtSwPersonalitiesInventory'], [], [None]),
    "MgmtUsbNicMgmtIf": MoMeta("MgmtUsbNicMgmtIf", "mgmtUsbNicMgmtIf", "usbnic-if-[usbnic_conn_side]-[switch_id]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin"], ['computeHostUtilityOs', 'mgmtController'], [], ["Get"]),
    "MgmtVnet": MoMeta("MgmtVnet", "mgmtVnet", "network", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtInterface', 'mgmtProfDerivedInterface'], ['vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicIpV6MgmtPooledAddr', 'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "MoInvKv": MoMeta("MoInvKv", "moInvKv", "kv-[key]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "read-only"], ['moKvInvHolder'], [], ["Get", "Set"]),
    "MoIpV4AddrKv": MoMeta("MoIpV4AddrKv", "moIpV4AddrKv", "kv-[key]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "read-only"], ['moKvCfgHolder'], ['faultInst'], ["Get", "Set"]),
    "MoIpV6AddrKv": MoMeta("MoIpV6AddrKv", "moIpV6AddrKv", "kv-[key]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "read-only"], ['moKvCfgHolder'], ['faultInst'], ["Get", "Set"]),
    "MoKv": MoMeta("MoKv", "moKv", "kv-[key]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "read-only"], ['moKvCfgHolder'], [], ["Get", "Set"]),
    "MoKvCfgHolder": MoMeta("MoKvCfgHolder", "moKvCfgHolder", "cfg-kv", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer', 'orgOrg'], ['moIpV4AddrKv', 'moIpV6AddrKv', 'moKv', 'moVnicKv'], ["Get", "Set"]),
    "MoKvInvHolder": MoMeta("MoKvInvHolder", "moKvInvHolder", "inv-kv-[endpoint]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['moInvKv'], [None]),
    "MoVnicKv": MoMeta("MoVnicKv", "moVnicKv", "kv-[key]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "read-only"], ['moKvCfgHolder'], [], ["Get", "Set"]),
    "MorefFruRef": MoMeta("MorefFruRef", "morefFruRef", "[class_name]-vendor-[vendor]-model-[model]-serial-[serial]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], ['morefImportRoot'], ['morefProp', 'morefRef'], ["Add", "Get", "Remove"]),
    "MorefImportRoot": MoMeta("MorefImportRoot", "morefImportRoot", "import-ref-root", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['eventInst', 'faultInst', 'morefFruRef', 'morefImportRootFsm', 'morefImportRootFsmTask', 'morefRef'], ["Add", "Get", "Remove"]),
    "MorefImportRootFsm": MoMeta("MorefImportRootFsm", "morefImportRootFsm", "fsm", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], ['morefImportRoot'], ['morefImportRootFsmStage'], [None]),
    "MorefImportRootFsmStage": MoMeta("MorefImportRootFsmStage", "morefImportRootFsmStage", "stage-[name]", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], ['morefImportRootFsm'], [], [None]),
    "MorefImportRootFsmTask": MoMeta("MorefImportRootFsmTask", "morefImportRootFsmTask", "task-[item]", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], ['morefImportRoot'], [], [None]),
    "MorefProp": MoMeta("MorefProp", "morefProp", "[name]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], ['morefFruRef', 'morefRef'], [], ["Add", "Get", "Remove", "Set"]),
    "MorefRef": MoMeta("MorefRef", "morefRef", "[mo_rn]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], ['morefFruRef', 'morefImportRoot', 'morefRef'], ['morefProp', 'morefRef'], ["Add", "Get", "Remove"]),
    "NetworkElement": MoMeta("NetworkElement", "networkElement", "switch-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['topSystem'], ['equipmentFan', 'equipmentFanModule', 'equipmentLocatorLed', 'equipmentPsu', 'equipmentSwitchCard', 'extmgmtIf', 'faultInst', 'fcpoolOuis', 'firmwareSecureFPGA', 'firmwareStatus', 'mgmtController', 'mgmtDbState', 'mgmtHealthStatus', 'mgmtIPv6IfConfig', 'networkLanNeighbors', 'networkLimit', 'networkLldpNeighbors', 'networkOperLevel', 'networkSanNeighbors', 'nfsMountInst', 'powerBudget', 'storageItem', 'swAccessDomain', 'swCardEnvStats', 'swEnvStats', 'swEthLanBorder', 'swEthLanFlowMon', 'swEthLanMon', 'swExtUtility', 'swFabricZoneNs', 'swFcSanBorder', 'swFcSanMon', 'swPhys', 'swPortDiscover', 'swSystemStats', 'swUtilityDomain', 'swVlanPortNs'], ["Get", "Set"]),
    "NetworkIfStats": MoMeta("NetworkIfStats", "networkIfStats", "if-stat-[type]-[units]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostScsiIf', 'adaptorHostServiceEthIf', 'etherPIo', 'fcPIo'], [], ["Get"]),
    "NetworkLanNeighborEntry": MoMeta("NetworkLanNeighborEntry", "networkLanNeighborEntry", "if-[local_interface]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['networkLanNeighbors'], [], ["Get"]),
    "NetworkLanNeighbors": MoMeta("NetworkLanNeighbors", "networkLanNeighbors", "lan-neighbors", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['networkLanNeighborEntry'], ["Get"]),
    "NetworkLimit": MoMeta("NetworkLimit", "networkLimit", "limit-type-[type]-asic-[asic_number]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['networkElement'], ['faultInst'], [None]),
    "NetworkLldpNeighborEntry": MoMeta("NetworkLldpNeighborEntry", "networkLldpNeighborEntry", "if-[local_interface]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['networkLldpNeighbors'], [], ["Get"]),
    "NetworkLldpNeighbors": MoMeta("NetworkLldpNeighbors", "networkLldpNeighbors", "lldp-neighbors", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['networkLldpNeighborEntry'], ["Get"]),
    "NetworkOperLevel": MoMeta("NetworkOperLevel", "networkOperLevel", "oper-level", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['networkElement'], ['faultInst'], [None]),
    "NetworkSanNeighborEntry": MoMeta("NetworkSanNeighborEntry", "networkSanNeighborEntry", "if-[local_interface]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['networkSanNeighbors'], [], ["Get"]),
    "NetworkSanNeighbors": MoMeta("NetworkSanNeighbors", "networkSanNeighbors", "san-neighbors", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['networkSanNeighborEntry'], ["Get"]),
    "NfsEp": MoMeta("NfsEp", "nfsEp", "nfs-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['nfsMountDef'], [None]),
    "NfsMountDef": MoMeta("NfsMountDef", "nfsMountDef", "nfs-mount-def-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['nfsEp'], ['eventInst', 'faultInst', 'nfsMountDefFsm', 'nfsMountDefFsmTask'], ["Get"]),
    "NfsMountDefFsm": MoMeta("NfsMountDefFsm", "nfsMountDefFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountDef'], ['nfsMountDefFsmStage'], [None]),
    "NfsMountDefFsmStage": MoMeta("NfsMountDefFsmStage", "nfsMountDefFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountDefFsm'], [], [None]),
    "NfsMountDefFsmTask": MoMeta("NfsMountDefFsmTask", "nfsMountDefFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountDef'], [], [None]),
    "NfsMountInst": MoMeta("NfsMountInst", "nfsMountInst", "nfs-mount-inst-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['networkElement'], ['eventInst', 'faultInst', 'nfsMountInstFsm', 'nfsMountInstFsmTask'], ["Get"]),
    "NfsMountInstFsm": MoMeta("NfsMountInstFsm", "nfsMountInstFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountInst'], ['nfsMountInstFsmStage'], [None]),
    "NfsMountInstFsmStage": MoMeta("NfsMountInstFsmStage", "nfsMountInstFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountInstFsm'], [], [None]),
    "NfsMountInstFsmTask": MoMeta("NfsMountInstFsmTask", "nfsMountInstFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['nfsMountInst'], [], [None]),
    "NwctrlDefinition": MoMeta("NwctrlDefinition", "nwctrlDefinition", "nwctrl-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricEthEstcCloud', 'orgOrg', 'policySystemEp'], ['dpsecMac'], ["Add", "Get", "Remove", "Set"]),
    "ObserveFilter": MoMeta("ObserveFilter", "observeFilter", "filter-[filter_class_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['observeObserved'], [], [None]),
    "ObserveObserved": MoMeta("ObserveObserved", "observeObserved", "observed-[data_src_sys_id]-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolClient', 'extpolController', 'extpolProvider', 'extpolRegistry', 'observeObservedCont'], ['eventInst', 'faultInst', 'observeFilter', 'observeObservedFsm', 'observeObservedFsmTask'], [None]),
    "ObserveObservedCont": MoMeta("ObserveObservedCont", "observeObservedCont", "observe", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['observeObserved'], [None]),
    "ObserveObservedFsm": MoMeta("ObserveObservedFsm", "observeObservedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['observeObserved'], ['observeObservedFsmStage'], [None]),
    "ObserveObservedFsmStage": MoMeta("ObserveObservedFsmStage", "observeObservedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['observeObservedFsm'], [], [None]),
    "ObserveObservedFsmTask": MoMeta("ObserveObservedFsmTask", "observeObservedFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['observeObserved'], [], [None]),
    "OrgOrg": MoMeta("OrgOrg", "orgOrg", "org-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "org-management"], ['orgOrg'], ['aaaEpAuthProfile', 'adaptorHostEthIfProfile', 'adaptorHostFcIfProfile', 'adaptorHostIscsiIfProfile', 'biosVProfile', 'cimcvmediaMountConfigPolicy', 'commSvcPolicy', 'computeAutoconfigPolicy', 'computeBladeDiscPolicy', 'computeBladeInheritPolicy', 'computeChassisConnPolicy', 'computeChassisDiscPolicy', 'computeFanPolicy', 'computeGraphicsCardPolicy', 'computeHwChangeDiscPolicy', 'computeKvmMgmtPolicy', 'computeMemoryConfigPolicy', 'computePool', 'computePoolingPolicy', 'computePortDiscPolicy', 'computePowerSavePolicy', 'computePowerSyncPolicy', 'computePsuPolicy', 'computeQual', 'computeRackConnLinkPolicy', 'computeScrubPolicy', 'computeServerDiscPolicy', 'computeServerMgmtPolicy', 'cpmaintMaintPolicy', 'diagRunPolicy', 'epqosDefinition', 'epqosDefinitionDelTask', 'equipmentAutoconfigPolicy', 'equipmentChassisInheritPolicy', 'equipmentChassisProfile', 'equipmentComputeConnPolicy', 'equipmentPool', 'equipmentPoolingPolicy', 'equipmentQual', 'equipmentTier', 'fabricLacpPolicy', 'fabricLanCloudPolicy', 'fabricMulticastPolicy', 'fabricOrgVlanPolicy', 'fabricUdldPolicy', 'fabricVConProfile', 'fabricVlanGroupPermit', 'fabricVlanGroupReq', 'fabricVlanPermit', 'fabricVlanReq', 'faultSuppressTask', 'fcpoolInitiators', 'firmwareAutoSyncPolicy', 'firmwareCatalogPack', 'firmwareChassisPack', 'firmwareComputeHostPack', 'firmwareComputeMgmtPack', 'firmwareInfraPack', 'hostimgPolicy', 'imgprovPolicy', 'imgsecPolicy', 'ippoolPool', 'iqnpoolPool', 'iscsiAuthProfile', 'lsAgentPolicy', 'lsServer', 'lsTier', 'lsbootPolicy', 'lsmaintMaintPolicy', 'lstorageDiskGroupConfigPolicy', 'lstorageDiskZoningPolicy', 'lstorageProfile', 'lstorageSasExpanderConfigPolicy', 'macpoolPool', 'memoryPersistentMemoryPolicy', 'mgmtBackupExportExtPolicy', 'mgmtBackupPolicy', 'mgmtCfgExportPolicy', 'mgmtSpdmCertificatePolicy', 'moKvCfgHolder', 'nwctrlDefinition', 'orgOrg', 'orgSourceMask', 'powerGroupAdditionPolicy', 'powerMgmtPolicy', 'powerPlacement', 'powerPolicy', 'solPolicy', 'statsThresholdPolicy', 'storageConnectionPolicy', 'storageLocalDiskConfigPolicy', 'sysdebugMEpLogPolicy', 'topInfoSyncPolicy', 'trigTest', 'uuidpoolPool', 'vmLifeCyclePolicy', 'vnicDynamicConPolicy', 'vnicFcGroupTempl', 'vnicIScsiInitAutoConfigPolicy', 'vnicLanConnPolicy', 'vnicLanConnTempl', 'vnicSanConnPolicy', 'vnicSanConnTempl', 'vnicUsnicConPolicy', 'vnicVhbaBehPolicy', 'vnicVmqConPolicy', 'vnicVnicBehPolicy'], ["Add", "Get", "Remove", "Set"]),
    "OrgSourceMask": MoMeta("OrgSourceMask", "orgSourceMask", "src-mask", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], [None]),
    "OsARPLinkMonitoringPolicy": MoMeta("OsARPLinkMonitoringPolicy", "osARPLinkMonitoringPolicy", "link-mon-pol", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osARPTarget'], [None]),
    "OsARPTarget": MoMeta("OsARPTarget", "osARPTarget", "arp-target-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osARPLinkMonitoringPolicy'], [], [None]),
    "OsAgent": MoMeta("OsAgent", "osAgent", "agent", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "OsEthBondIntf": MoMeta("OsEthBondIntf", "osEthBondIntf", "bond-intf-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osInstance'], ['osARPLinkMonitoringPolicy', 'osEthBondModeActiveBackup', 'osEthBondModeBalancedALB', 'osEthBondModeBalancedRR', 'osEthBondModeBalancedTLB', 'osEthBondModeBalancedXOR', 'osEthBondModeBroadcast', 'osEthIntf', 'osMiiLinkMonitoringPolicy'], [None]),
    "OsEthBondModeActiveBackup": MoMeta("OsEthBondModeActiveBackup", "osEthBondModeActiveBackup", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthBondModeBalancedALB": MoMeta("OsEthBondModeBalancedALB", "osEthBondModeBalancedALB", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthBondModeBalancedRR": MoMeta("OsEthBondModeBalancedRR", "osEthBondModeBalancedRR", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthBondModeBalancedTLB": MoMeta("OsEthBondModeBalancedTLB", "osEthBondModeBalancedTLB", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthBondModeBalancedXOR": MoMeta("OsEthBondModeBalancedXOR", "osEthBondModeBalancedXOR", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthBondModeBroadcast": MoMeta("OsEthBondModeBroadcast", "osEthBondModeBroadcast", "eth-bond-mode", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], ['osPrimarySlave'], [None]),
    "OsEthIntf": MoMeta("OsEthIntf", "osEthIntf", "intf-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf', 'osInstance'], [], [None]),
    "OsInstance": MoMeta("OsInstance", "osInstance", "os", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['osEthBondIntf', 'osEthIntf'], ["Get"]),
    "OsMiiLinkMonitoringPolicy": MoMeta("OsMiiLinkMonitoringPolicy", "osMiiLinkMonitoringPolicy", "link-mon-pol", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf'], [], [None]),
    "OsPrimarySlave": MoMeta("OsPrimarySlave", "osPrimarySlave", "slave-intf-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['osEthBondModeActiveBackup', 'osEthBondModeBalancedALB', 'osEthBondModeBalancedRR', 'osEthBondModeBalancedTLB', 'osEthBondModeBalancedXOR', 'osEthBondModeBroadcast'], [], [None]),
    "PciEquipSlot": MoMeta("PciEquipSlot", "pciEquipSlot", "equipped-slot-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst'], ["Get"]),
    "PciLink": MoMeta("PciLink", "pciLink", "pci-link-[pci_slot]", VersionMeta.Version402a, "InputOutput", 0x1, [], ["read-only"], ['pciSwitch'], [], [None]),
    "PciSwitch": MoMeta("PciSwitch", "pciSwitch", "pci-switch-[id]", VersionMeta.Version402a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'pciLink'], [None]),
    "PciUnit": MoMeta("PciUnit", "pciUnit", "unit-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "PfcWatchDog": MoMeta("PfcWatchDog", "pfcWatchDog", "watch-dog", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['fabricLanCloud'], ['eventInst', 'faultInst', 'pfcWatchDogFsm', 'pfcWatchDogFsmTask'], [None]),
    "PfcWatchDogFsm": MoMeta("PfcWatchDogFsm", "pfcWatchDogFsm", "fsm", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['pfcWatchDog'], ['pfcWatchDogFsmStage'], [None]),
    "PfcWatchDogFsmStage": MoMeta("PfcWatchDogFsmStage", "pfcWatchDogFsmStage", "stage-[name]", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['pfcWatchDogFsm'], [], [None]),
    "PfcWatchDogFsmTask": MoMeta("PfcWatchDogFsmTask", "pfcWatchDogFsmTask", "task-[item]", VersionMeta.Version413a, "OutputOnly", 0x1, [], [""], ['pfcWatchDog'], [], [None]),
    "PkiCertReq": MoMeta("PkiCertReq", "pkiCertReq", "certreq", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['pkiKeyRing'], [], ["Add", "Get", "Remove", "Set"]),
    "PkiEp": MoMeta("PkiEp", "pkiEp", "pki-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtKmipCertPolicy', 'pkiEpFsm', 'pkiEpFsmTask', 'pkiKeyRing', 'pkiTP'], ["Get"]),
    "PkiEpFsm": MoMeta("PkiEpFsm", "pkiEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['pkiEp'], ['pkiEpFsmStage'], [None]),
    "PkiEpFsmStage": MoMeta("PkiEpFsmStage", "pkiEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['pkiEpFsm'], [], [None]),
    "PkiEpFsmTask": MoMeta("PkiEpFsmTask", "pkiEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['pkiEp'], [], [None]),
    "PkiKeyRing": MoMeta("PkiKeyRing", "pkiKeyRing", "keyring-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['pkiEp'], ['faultInst', 'pkiCertReq'], ["Add", "Get", "Remove", "Set"]),
    "PkiTP": MoMeta("PkiTP", "pkiTP", "tp-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], ['pkiEp'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PolicyCentraleSync": MoMeta("PolicyCentraleSync", "policyCentraleSync", "centrale-sync", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['policyControlEp'], [], [None]),
    "PolicyChildClass": MoMeta("PolicyChildClass", "policyChildClass", "child-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyDestClass'], [], [None]),
    "PolicyCommunication": MoMeta("PolicyCommunication", "policyCommunication", "comm-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyConfigBackup": MoMeta("PolicyConfigBackup", "policyConfigBackup", "cfg-backup-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyConfigError": MoMeta("PolicyConfigError", "policyConfigError", "policy-error", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyPolicyScopeCont'], [], [None]),
    "PolicyContext": MoMeta("PolicyContext", "policyContext", "context-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policySourceApp'], ['policyScope'], [None]),
    "PolicyControlEp": MoMeta("PolicyControlEp", "policyControlEp", "control-ep-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'policyCentraleSync', 'policyCommunication', 'policyConfigBackup', 'policyControlEpFsm', 'policyControlEpFsmTask', 'policyDateTime', 'policyDestEp', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyIdResolvePolicy', 'policyInfraFirmware', 'policyMEp', 'policyMonitoring', 'policyPortConfig', 'policyPowerMgmt', 'policyPsu', 'policySecurity', 'policySourceApp', 'policyStorageAutoConfig'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpFsm": MoMeta("PolicyControlEpFsm", "policyControlEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyControlEp'], ['policyControlEpFsmStage'], [None]),
    "PolicyControlEpFsmStage": MoMeta("PolicyControlEpFsmStage", "policyControlEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyControlEpFsm'], [], [None]),
    "PolicyControlEpFsmTask": MoMeta("PolicyControlEpFsmTask", "policyControlEpFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyControlEp'], [], [None]),
    "PolicyControlledInstance": MoMeta("PolicyControlledInstance", "policyControlledInstance", "ctrlled-[type]-inst-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['policyCommunication', 'policyConfigBackup', 'policyDateTime', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyInfraFirmware', 'policyMEp', 'policyMonitoring', 'policyPortConfig', 'policyPowerMgmt', 'policyPsu', 'policySecurity', 'policyStorageAutoConfig'], [], [None]),
    "PolicyControlledType": MoMeta("PolicyControlledType", "policyControlledType", "ctrlled-type-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['policyCommunication', 'policyConfigBackup', 'policyDateTime', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyInfraFirmware', 'policyMEp', 'policyMonitoring', 'policyPortConfig', 'policyPowerMgmt', 'policyPsu', 'policySecurity', 'policyStorageAutoConfig'], ['eventInst', 'faultInst', 'policyControlledTypeFsm', 'policyControlledTypeFsmTask'], [None]),
    "PolicyControlledTypeFsm": MoMeta("PolicyControlledTypeFsm", "policyControlledTypeFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['policyControlledType'], ['policyControlledTypeFsmStage'], [None]),
    "PolicyControlledTypeFsmStage": MoMeta("PolicyControlledTypeFsmStage", "policyControlledTypeFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['policyControlledTypeFsm'], [], [None]),
    "PolicyControlledTypeFsmTask": MoMeta("PolicyControlledTypeFsmTask", "policyControlledTypeFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], ['policyControlledType'], [], [None]),
    "PolicyDateTime": MoMeta("PolicyDateTime", "policyDateTime", "datetime-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDestClass": MoMeta("PolicyDestClass", "policyDestClass", "dest-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyDestEp', 'policyPolicyDestClass'], ['policyChildClass'], [None]),
    "PolicyDestEp": MoMeta("PolicyDestEp", "policyDestEp", "dest-ep", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyControlEp'], ['policyDestClass'], [None]),
    "PolicyDigest": MoMeta("PolicyDigest", "policyDigest", "policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyDiscovery": MoMeta("PolicyDiscovery", "policyDiscovery", "discovery-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyDns": MoMeta("PolicyDns", "policyDns", "dns-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyElement": MoMeta("PolicyElement", "policyElement", "element-[converted_dn]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['policyLocalMap'], ['policyRefReq'], [None]),
    "PolicyEquipment": MoMeta("PolicyEquipment", "policyEquipment", "equipment-ctrl", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Get", "Set"]),
    "PolicyFault": MoMeta("PolicyFault", "policyFault", "fault-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyIdResolvePolicy": MoMeta("PolicyIdResolvePolicy", "policyIdResolvePolicy", "id-policy", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], [], ["Get", "Set"]),
    "PolicyInfraFirmware": MoMeta("PolicyInfraFirmware", "policyInfraFirmware", "fabric-fw-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyLocalMap": MoMeta("PolicyLocalMap", "policyLocalMap", "localmap", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyEp'], ['policyElement'], [None]),
    "PolicyMEp": MoMeta("PolicyMEp", "policyMEp", "mep-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMonitoring": MoMeta("PolicyMonitoring", "policyMonitoring", "monitoring-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPolicyDestClass": MoMeta("PolicyPolicyDestClass", "policyPolicyDestClass", "destclass", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyScope'], ['policyDestClass'], [None]),
    "PolicyPolicyEp": MoMeta("PolicyPolicyEp", "policyPolicyEp", "policy-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['policyLocalMap', 'policyPolicyScopeCont', 'policySystemEp'], [None]),
    "PolicyPolicyRequestor": MoMeta("PolicyPolicyRequestor", "policyPolicyRequestor", "requestor-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScope'], [], [None]),
    "PolicyPolicyScope": MoMeta("PolicyPolicyScope", "policyPolicyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScopeContext'], ['eventInst', 'faultInst', 'policyPolicyRequestor', 'policyPolicyScopeFsm', 'policyPolicyScopeFsmTask'], [None]),
    "PolicyPolicyScopeCont": MoMeta("PolicyPolicyScopeCont", "policyPolicyScopeCont", "scope-cont-[app_type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['extpolClient', 'extpolController', 'extpolProvider', 'extpolRegistry', 'policyPolicyEp'], ['eventInst', 'faultInst', 'policyConfigError', 'policyPolicyScopeContFsm', 'policyPolicyScopeContFsmTask', 'policyPolicyScopeContext'], [None]),
    "PolicyPolicyScopeContFsm": MoMeta("PolicyPolicyScopeContFsm", "policyPolicyScopeContFsm", "fsm", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyPolicyScopeCont'], ['policyPolicyScopeContFsmStage'], [None]),
    "PolicyPolicyScopeContFsmStage": MoMeta("PolicyPolicyScopeContFsmStage", "policyPolicyScopeContFsmStage", "stage-[name]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyPolicyScopeContFsm'], [], [None]),
    "PolicyPolicyScopeContFsmTask": MoMeta("PolicyPolicyScopeContFsmTask", "policyPolicyScopeContFsmTask", "task-[item]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyPolicyScopeCont'], [], [None]),
    "PolicyPolicyScopeContext": MoMeta("PolicyPolicyScopeContext", "policyPolicyScopeContext", "context-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScopeCont'], ['policyPolicyScope'], [None]),
    "PolicyPolicyScopeFsm": MoMeta("PolicyPolicyScopeFsm", "policyPolicyScopeFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyPolicyScope'], ['policyPolicyScopeFsmStage'], [None]),
    "PolicyPolicyScopeFsmStage": MoMeta("PolicyPolicyScopeFsmStage", "policyPolicyScopeFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyPolicyScopeFsm'], [], [None]),
    "PolicyPolicyScopeFsmTask": MoMeta("PolicyPolicyScopeFsmTask", "policyPolicyScopeFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['policyPolicyScope'], [], [None]),
    "PolicyPortConfig": MoMeta("PolicyPortConfig", "policyPortConfig", "portconfig-ctrl", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Get", "Set"]),
    "PolicyPowerMgmt": MoMeta("PolicyPowerMgmt", "policyPowerMgmt", "powermgmt-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPsu": MoMeta("PolicyPsu", "policyPsu", "psu-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyRefReq": MoMeta("PolicyRefReq", "policyRefReq", "refreq-[ref_converted_dn]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], ['policyElement'], [], [None]),
    "PolicyRequestor": MoMeta("PolicyRequestor", "policyRequestor", "requestor-[name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyScope'], ['eventInst', 'faultInst', 'policyRequestorFsm', 'policyRequestorFsmTask'], [None]),
    "PolicyRequestorFsm": MoMeta("PolicyRequestorFsm", "policyRequestorFsm", "fsm", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyRequestor'], ['policyRequestorFsmStage'], [None]),
    "PolicyRequestorFsmStage": MoMeta("PolicyRequestorFsmStage", "policyRequestorFsmStage", "stage-[name]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyRequestorFsm'], [], [None]),
    "PolicyRequestorFsmTask": MoMeta("PolicyRequestorFsmTask", "policyRequestorFsmTask", "task-[item]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['policyRequestor'], [], [None]),
    "PolicyScope": MoMeta("PolicyScope", "policyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyContext'], ['policyPolicyDestClass', 'policyRequestor'], [None]),
    "PolicySecurity": MoMeta("PolicySecurity", "policySecurity", "security-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicySourceApp": MoMeta("PolicySourceApp", "policySourceApp", "source-[source_dme]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['policyControlEp'], ['policyContext'], [None]),
    "PolicyStorageAutoConfig": MoMeta("PolicyStorageAutoConfig", "policyStorageAutoConfig", "storage-autoconfig-ctrl", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicySystemEp": MoMeta("PolicySystemEp", "policySystemEp", "system-policies", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['policyPolicyEp'], ['adaptorHostEthIfProfile', 'lsbootPolicy', 'nwctrlDefinition', 'powerPolicy', 'solPolicy'], [None]),
    "PortDomainEp": MoMeta("PortDomainEp", "portDomainEp", "domain-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['etherPIo', 'etherServerIntFIo', 'etherSwitchIntFIo', 'fcPIo'], [], ["Get"]),
    "PortGroup": MoMeta("PortGroup", "portGroup", "[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['equipmentIOCard', 'equipmentSharedIOModule', 'equipmentSwitchCard', 'equipmentSwitchIOCard'], ['etherPIo', 'etherServerIntFIo', 'etherServerIntFIoPc', 'etherSwitchIntFIo', 'etherSwitchIntFIoPc', 'fcPIo', 'portSubGroup'], ["Get"]),
    "PortPIoFsm": MoMeta("PortPIoFsm", "portPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['etherPIo', 'fcPIo'], ['portPIoFsmStage'], [None]),
    "PortPIoFsmStage": MoMeta("PortPIoFsmStage", "portPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['portPIoFsm'], [], [None]),
    "PortPIoFsmTask": MoMeta("PortPIoFsmTask", "portPIoFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['etherPIo', 'fcPIo'], [], [None]),
    "PortSubGroup": MoMeta("PortSubGroup", "portSubGroup", "aggr-port-[aggr_port_id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['portGroup'], ['etherPIo', 'fcPIo'], [None]),
    "PortTrustMode": MoMeta("PortTrustMode", "portTrustMode", "trust-mode", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['etherServerIntFIo', 'fabricPathEp', 'swAccessEp'], [], ["Get"]),
    "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFex', 'networkElement'], ['faultInst', 'powerProfiledPower'], ["Get", "Set"]),
    "PowerChassisMember": MoMeta("PowerChassisMember", "powerChassisMember", "ch-member-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], ['powerGroup'], ['faultInst'], ["Add", "Get", "Remove"]),
    "PowerEp": MoMeta("PowerEp", "powerEp", "power-ep", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['topSystem'], ['powerGroup', 'powerPrioWght'], ["Get"]),
    "PowerFIMember": MoMeta("PowerFIMember", "powerFIMember", "fi-member-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], ['powerGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "PowerFexMember": MoMeta("PowerFexMember", "powerFexMember", "fex-member-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], ['powerGroup'], [], ["Add", "Get", "Remove"]),
    "PowerGroup": MoMeta("PowerGroup", "powerGroup", "group-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['powerEp'], ['faultInst', 'powerChassisMember', 'powerFIMember', 'powerFexMember', 'powerRackUnitMember'], ["Add", "Get", "Remove", "Set"]),
    "PowerGroupAdditionPolicy": MoMeta("PowerGroupAdditionPolicy", "powerGroupAdditionPolicy", "group-add-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['orgOrg'], [], ["Get"]),
    "PowerGroupQual": MoMeta("PowerGroupQual", "powerGroupQual", "power-group-[group_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove"]),
    "PowerGroupStats": MoMeta("PowerGroupStats", "powerGroupStats", "stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['powerGroupStatsHist'], ["Get"]),
    "PowerGroupStatsHist": MoMeta("PowerGroupStatsHist", "powerGroupStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], ['powerGroupStats'], [], ["Get"]),
    "PowerMgmtPolicy": MoMeta("PowerMgmtPolicy", "powerMgmtPolicy", "pwr-mgmt-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['orgOrg'], [], ["Get", "Set"]),
    "PowerPlacement": MoMeta("PowerPlacement", "powerPlacement", "placement-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], [], ["Get"]),
    "PowerPolicy": MoMeta("PowerPolicy", "powerPolicy", "power-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg', 'policySystemEp'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PowerPrioWght": MoMeta("PowerPrioWght", "powerPrioWght", "weight-[prio]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['powerEp'], [], ["Get"]),
    "PowerProfiledPower": MoMeta("PowerProfiledPower", "powerProfiledPower", "prof-power", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['powerBudget'], [], ["Get"]),
    "PowerRackUnitMember": MoMeta("PowerRackUnitMember", "powerRackUnitMember", "ru-member-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], ['powerGroup'], [], ["Get"]),
    "ProcDoer": MoMeta("ProcDoer", "procDoer", "doer[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcManager": MoMeta("ProcManager", "procManager", "proc-info", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['procDoer', 'procPrt', 'procPrtCounts', 'procStimulusCounts', 'procSvc', 'procTxCounts'], ["Get"]),
    "ProcPrt": MoMeta("ProcPrt", "procPrt", "prt[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcPrtCounts": MoMeta("ProcPrtCounts", "procPrtCounts", "prt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcStimulusCounts": MoMeta("ProcStimulusCounts", "procStimulusCounts", "stim", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['procManager', 'procSvc'], [], ["Get"]),
    "ProcSvc": MoMeta("ProcSvc", "procSvc", "svc-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['procManager'], ['procStimulusCounts', 'procTxCounts'], ["Get"]),
    "ProcTxCounts": MoMeta("ProcTxCounts", "procTxCounts", "tx", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['procManager', 'procSvc'], [], ["Get"]),
    "ProcessorCacheMemStats": MoMeta("ProcessorCacheMemStats", "processorCacheMemStats", "cache-mem-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorCore": MoMeta("ProcessorCore", "processorCore", "core-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['processorUnit'], ['processorThread'], [None]),
    "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], ['processorEnvStatsHist'], ["Get"]),
    "ProcessorEnvStatsHist": MoMeta("ProcessorEnvStatsHist", "processorEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['processorEnvStats'], [], ["Get"]),
    "ProcessorErrorStats": MoMeta("ProcessorErrorStats", "processorErrorStats", "error-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], ["Get"]),
    "ProcessorExecStats": MoMeta("ProcessorExecStats", "processorExecStats", "exec-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorIOStats": MoMeta("ProcessorIOStats", "processorIOStats", "io-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorMiscStats": MoMeta("ProcessorMiscStats", "processorMiscStats", "misc-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorPCIBusStats": MoMeta("ProcessorPCIBusStats", "processorPCIBusStats", "pcibus-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorPMUStats": MoMeta("ProcessorPMUStats", "processorPMUStats", "pmu-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorQual": MoMeta("ProcessorQual", "processorQual", "cpu", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ProcessorRuntime": MoMeta("ProcessorRuntime", "processorRuntime", "cpu-rt", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBlade'], ['processorRuntimeHist'], ["Get"]),
    "ProcessorRuntimeHist": MoMeta("ProcessorRuntimeHist", "processorRuntimeHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['processorRuntime'], [], ["Get"]),
    "ProcessorSecurityStats": MoMeta("ProcessorSecurityStats", "processorSecurityStats", "security-stats", VersionMeta.Version412a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], [], [None]),
    "ProcessorThread": MoMeta("ProcessorThread", "processorThread", "thr-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['processorCore'], [], ["Get"]),
    "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['equipmentInventoryStatus', 'faultInst', 'processorCacheMemStats', 'processorCore', 'processorEnvStats', 'processorErrorStats', 'processorExecStats', 'processorIOStats', 'processorMiscStats', 'processorPCIBusStats', 'processorPMUStats', 'processorSecurityStats'], ["Get"]),
    "ProcessorUnitAssocCtx": MoMeta("ProcessorUnitAssocCtx", "processorUnitAssocCtx", "procunit-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "QosclassDefinition": MoMeta("QosclassDefinition", "qosclassDefinition", "classes", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['fabricLanCloud'], ['eventInst', 'faultInst', 'firmwareAck', 'qosclassDefinitionFsm', 'qosclassDefinitionFsmTask', 'qosclassEthBE', 'qosclassEthClassified', 'qosclassFc', 'qosclassSlowDrain'], ["Get", "Set"]),
    "QosclassDefinitionFsm": MoMeta("QosclassDefinitionFsm", "qosclassDefinitionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['qosclassDefinition'], ['qosclassDefinitionFsmStage'], [None]),
    "QosclassDefinitionFsmStage": MoMeta("QosclassDefinitionFsmStage", "qosclassDefinitionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['qosclassDefinitionFsm'], [], [None]),
    "QosclassDefinitionFsmTask": MoMeta("QosclassDefinitionFsmTask", "qosclassDefinitionFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['qosclassDefinition'], [], [None]),
    "QosclassEthBE": MoMeta("QosclassEthBE", "qosclassEthBE", "class-best-effort", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition'], [], ["Get", "Set"]),
    "QosclassEthClassified": MoMeta("QosclassEthClassified", "qosclassEthClassified", "class-[priority]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition'], [], ["Get", "Set"]),
    "QosclassFc": MoMeta("QosclassFc", "qosclassFc", "class-fc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition'], [], ["Get", "Set"]),
    "QosclassSlowDrain": MoMeta("QosclassSlowDrain", "qosclassSlowDrain", "slow-drain", VersionMeta.Version402a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos"], ['qosclassDefinition'], ['eventInst', 'faultInst', 'qosclassSlowDrainFsm', 'qosclassSlowDrainFsmTask'], [None]),
    "QosclassSlowDrainFsm": MoMeta("QosclassSlowDrainFsm", "qosclassSlowDrainFsm", "fsm", VersionMeta.Version402a, "OutputOnly", 0x1, [], [""], ['qosclassSlowDrain'], ['qosclassSlowDrainFsmStage'], [None]),
    "QosclassSlowDrainFsmStage": MoMeta("QosclassSlowDrainFsmStage", "qosclassSlowDrainFsmStage", "stage-[name]", VersionMeta.Version402a, "OutputOnly", 0x1, [], [""], ['qosclassSlowDrainFsm'], [], [None]),
    "QosclassSlowDrainFsmTask": MoMeta("QosclassSlowDrainFsmTask", "qosclassSlowDrainFsmTask", "task-[item]", VersionMeta.Version402a, "OutputOnly", 0x1, [], [""], ['qosclassSlowDrain'], [], [None]),
    "QueryresultDependency": MoMeta("QueryresultDependency", "queryresultDependency", "dependency-[ref_converted_dn]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "QueryresultUsage": MoMeta("QueryresultUsage", "queryresultUsage", "usage-[ref_converted_dn]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "SecurityUnit": MoMeta("SecurityUnit", "securityUnit", "security-unit-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['equipmentInventoryStatus'], ["Get"]),
    "SesDiskSlotEp": MoMeta("SesDiskSlotEp", "sesDiskSlotEp", "disk-slot-ep-[enc_id]-id-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['sesEnclosure'], [], ["Get"]),
    "SesEnclosure": MoMeta("SesEnclosure", "sesEnclosure", "ses-enc-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], ['sesDiskSlotEp'], ["Get"]),
    "SolConfig": MoMeta("SolConfig", "solConfig", "sol", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], ['lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "SolIf": MoMeta("SolIf", "solIf", "sol-if", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "SolPolicy": MoMeta("SolPolicy", "solPolicy", "sol-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy"], ['orgOrg', 'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "StatsCollectionPolicy": MoMeta("StatsCollectionPolicy", "statsCollectionPolicy", "coll-policy-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "operations"], ['statsHolder'], ['eventInst', 'faultInst', 'statsCollectionPolicyFsm', 'statsCollectionPolicyFsmTask'], ["Get", "Set"]),
    "StatsCollectionPolicyFsm": MoMeta("StatsCollectionPolicyFsm", "statsCollectionPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['statsCollectionPolicy'], ['statsCollectionPolicyFsmStage'], [None]),
    "StatsCollectionPolicyFsmStage": MoMeta("StatsCollectionPolicyFsmStage", "statsCollectionPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['statsCollectionPolicyFsm'], [], [None]),
    "StatsCollectionPolicyFsmTask": MoMeta("StatsCollectionPolicyFsmTask", "statsCollectionPolicyFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['statsCollectionPolicy'], [], [None]),
    "StatsHolder": MoMeta("StatsHolder", "statsHolder", "stats", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['topRoot'], ['statsCollectionPolicy'], ["Get"]),
    "StatsThr32Definition": MoMeta("StatsThr32Definition", "statsThr32Definition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Add", "Get", "Set"]),
    "StatsThr32Value": MoMeta("StatsThr32Value", "statsThr32Value", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThr64Definition": MoMeta("StatsThr64Definition", "statsThr64Definition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Add", "Get", "Set"]),
    "StatsThr64Value": MoMeta("StatsThr64Value", "statsThr64Value", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThrFloatDefinition": MoMeta("StatsThrFloatDefinition", "statsThrFloatDefinition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Get"]),
    "StatsThrFloatValue": MoMeta("StatsThrFloatValue", "statsThrFloatValue", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Get"]),
    "StatsThresholdClass": MoMeta("StatsThresholdClass", "statsThresholdClass", "[stats_class_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdPolicy'], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], ["Add", "Get", "Remove", "Set"]),
    "StatsThresholdPolicy": MoMeta("StatsThresholdPolicy", "statsThresholdPolicy", "thr-policy-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "operations"], ['fabricCabling', 'fabricDceSrv', 'fabricEthEstcCloud', 'fabricFcEstcCloud', 'fabricLanCloud', 'fabricLanMonCloud', 'fabricSanCloud', 'fabricSanMonCloud', 'orgOrg'], ['statsThresholdClass'], ["Add", "Get", "Remove", "Set"]),
    "StorageAuthKey": MoMeta("StorageAuthKey", "storageAuthKey", "key-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['storageIScsiTargetIf'], [], [None]),
    "StorageConnectionDef": MoMeta("StorageConnectionDef", "storageConnectionDef", "storage-conndef", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['vnicFcGroupDef'], ['faultInst', 'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageConnectionPolicy": MoMeta("StorageConnectionPolicy", "storageConnectionPolicy", "storage-connpolicy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['faultInst', 'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBoard', 'equipmentChassis'], ['equipmentInventoryStatus', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'lstorageControllerDef', 'mgmtController', 'storageDrive', 'storageEmbeddedStorage', 'storageEnclosure', 'storageLocalDisk', 'storageLocalDiskConfigDef', 'storageLocalDiskEp', 'storageLocalLun', 'storageMezzFlashLife', 'storageNvmeStats', 'storageNvmeStorage', 'storageOnboardDevice', 'storageOperation', 'storageRaidBattery', 'storageVirtualDrive', 'storageVirtualDriveEp'], ["Get"]),
    "StorageControllerEp": MoMeta("StorageControllerEp", "storageControllerEp", "controller-ep-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['storageLocalDisk', 'storageVirtualDrive'], [], ["Get"]),
    "StorageControllerRef": MoMeta("StorageControllerRef", "storageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosureDiskSlotEp'], [], ["Get"]),
    "StorageControllerReference": MoMeta("StorageControllerReference", "storageControllerReference", "controller-ref-[referenced_rn]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['storageMiniStorage'], [], [None]),
    "StorageDiskEnvStats": MoMeta("StorageDiskEnvStats", "storageDiskEnvStats", "disk-env-stats", VersionMeta.Version302c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageLocalDisk'], ['storageDiskEnvStatsHist'], [None]),
    "StorageDiskEnvStatsHist": MoMeta("StorageDiskEnvStatsHist", "storageDiskEnvStatsHist", "[id]", VersionMeta.Version302c, "OutputOnly", 0x1, [], ["read-only"], ['storageDiskEnvStats'], [], [None]),
    "StorageDomainEp": MoMeta("StorageDomainEp", "storageDomainEp", "storage-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['storageSystem'], [None]),
    "StorageDrive": MoMeta("StorageDrive", "storageDrive", "drive-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageEmbeddedStorage": MoMeta("StorageEmbeddedStorage", "storageEmbeddedStorage", "embedded-storage", VersionMeta.Version312b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController'], [], ["Get"]),
    "StorageEnclosure": MoMeta("StorageEnclosure", "storageEnclosure", "enc-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'storageController'], ['eventInst', 'faultInst', 'storageEnclosureDiskSlotEp', 'storageEnclosureFsm', 'storageEnclosureFsmTask', 'storageHddMotherBoardTempStats', 'storageLocalDisk'], ["Get"]),
    "StorageEnclosureCap": MoMeta("StorageEnclosureCap", "storageEnclosureCap", "physical-holder-[type]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentRackUnitCapProvider'], [], ["Get"]),
    "StorageEnclosureDiskSlotEp": MoMeta("StorageEnclosureDiskSlotEp", "storageEnclosureDiskSlotEp", "disk-slot-[id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosure'], ['faultInst', 'storageControllerRef'], ["Get"]),
    "StorageEnclosureFsm": MoMeta("StorageEnclosureFsm", "storageEnclosureFsm", "fsm", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageEnclosure'], ['storageEnclosureFsmStage'], [None]),
    "StorageEnclosureFsmStage": MoMeta("StorageEnclosureFsmStage", "storageEnclosureFsmStage", "stage-[name]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageEnclosureFsm'], [], [None]),
    "StorageEnclosureFsmTask": MoMeta("StorageEnclosureFsmTask", "storageEnclosureFsmTask", "task-[item]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageEnclosure'], [], [None]),
    "StorageEnclosureLocalDiskConfig": MoMeta("StorageEnclosureLocalDiskConfig", "storageEnclosureLocalDiskConfig", "enc-disk-config-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], [], ['storageSasPort'], [None]),
    "StorageEpUser": MoMeta("StorageEpUser", "storageEpUser", "user-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['initiatorFcInitiatorEp', 'initiatorIScsiInitiatorEp'], ['aaaCimcSession'], [None]),
    "StorageEtherIf": MoMeta("StorageEtherIf", "storageEtherIf", "ether-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['storageIScsiTargetIf'], ['ipServiceIf'], [None]),
    "StorageFcIf": MoMeta("StorageFcIf", "storageFcIf", "fc-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['storageFcTargetIf'], [], [None]),
    "StorageFcTargetEp": MoMeta("StorageFcTargetEp", "storageFcTargetEp", "fc-target-ep-[targetwwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['storageConnectionDef', 'storageConnectionPolicy'], ['storageVsanRef'], ["Add", "Get", "Remove", "Set"]),
    "StorageFcTargetIf": MoMeta("StorageFcTargetIf", "storageFcTargetIf", "fc-tgt-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], ['storageFcIf'], [None]),
    "StorageFlexFlashCard": MoMeta("StorageFlexFlashCard", "storageFlexFlashCard", "card-[slot_number]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashController'], ['faultInst', 'storageFlexFlashDrive'], ["Get"]),
    "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], ['computeBoard'], ['eventInst', 'faultInst', 'firmwareRunning', 'storageFlexFlashCard', 'storageFlexFlashControllerFsm', 'storageFlexFlashControllerFsmTask', 'storageFlexFlashVirtualDrive', 'storageLocalDiskConfigDef'], ["Get"]),
    "StorageFlexFlashControllerFsm": MoMeta("StorageFlexFlashControllerFsm", "storageFlexFlashControllerFsm", "fsm", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], ['storageFlexFlashController'], ['storageFlexFlashControllerFsmStage'], [None]),
    "StorageFlexFlashControllerFsmStage": MoMeta("StorageFlexFlashControllerFsmStage", "storageFlexFlashControllerFsmStage", "stage-[name]", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], ['storageFlexFlashControllerFsm'], [], [None]),
    "StorageFlexFlashControllerFsmTask": MoMeta("StorageFlexFlashControllerFsmTask", "storageFlexFlashControllerFsmTask", "task-[item]", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], ['storageFlexFlashController'], [], [None]),
    "StorageFlexFlashDrive": MoMeta("StorageFlexFlashDrive", "storageFlexFlashDrive", "drive-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashCard'], ['faultInst'], ["Get"]),
    "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashController'], ['faultInst'], ["Get"]),
    "StorageHddMotherBoardTempStats": MoMeta("StorageHddMotherBoardTempStats", "storageHddMotherBoardTempStats", "hdd-mobo-temp-stats", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageEnclosure'], ['storageHddMotherBoardTempStatsHist'], ["Get"]),
    "StorageHddMotherBoardTempStatsHist": MoMeta("StorageHddMotherBoardTempStatsHist", "storageHddMotherBoardTempStatsHist", "[id]", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["read-only"], ['storageHddMotherBoardTempStats'], [], ["Get"]),
    "StorageIScsiTargetIf": MoMeta("StorageIScsiTargetIf", "storageIScsiTargetIf", "iscsi-tgt-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['storageNodeEp'], ['initiatorLunEp', 'storageAuthKey', 'storageEtherIf'], [None]),
    "StorageIniGroup": MoMeta("StorageIniGroup", "storageIniGroup", "grp-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['lsServer', 'vnicSanConnPolicy'], ['faultInst', 'storageInitiator', 'vnicFcGroupDef'], ["Add", "Get", "Remove", "Set"]),
    "StorageInitiator": MoMeta("StorageInitiator", "storageInitiator", "ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageIniGroup'], ['faultInst'], ["Add", "Get", "Remove"]),
    "StorageItem": MoMeta("StorageItem", "storageItem", "stor-part-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['faultInst'], ["Get"]),
    "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "disk-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageEnclosure'], ['equipmentLocatorLed', 'eventInst', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'mgmtController', 'storageControllerEp', 'storageDiskEnvStats', 'storageLocalDiskFsm', 'storageLocalDiskFsmTask', 'storageLocalDiskPartition', 'storageOperation', 'storageSasPort', 'storageSsdHealthStats'], ["Get", "Set"]),
    "StorageLocalDiskConfigDef": MoMeta("StorageLocalDiskConfigDef", "storageLocalDiskConfigDef", "local-disk-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer', 'lstorageDasScsiLun', 'storageController', 'storageFlexFlashController'], ['lstorageSecurity', 'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskConfigPolicy": MoMeta("StorageLocalDiskConfigPolicy", "storageLocalDiskConfigPolicy", "local-disk-config-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['lstorageSecurity', 'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskEp": MoMeta("StorageLocalDiskEp", "storageLocalDiskEp", "disk-ep-[enc_id]-id-[id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageLocalDiskFsm": MoMeta("StorageLocalDiskFsm", "storageLocalDiskFsm", "fsm", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageLocalDisk'], ['storageLocalDiskFsmStage'], [None]),
    "StorageLocalDiskFsmStage": MoMeta("StorageLocalDiskFsmStage", "storageLocalDiskFsmStage", "stage-[name]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageLocalDiskFsm'], [], [None]),
    "StorageLocalDiskFsmTask": MoMeta("StorageLocalDiskFsmTask", "storageLocalDiskFsmTask", "task-[item]", VersionMeta.Version312b, "OutputOnly", 0x1, [], [""], ['storageLocalDisk'], [], [None]),
    "StorageLocalDiskPartition": MoMeta("StorageLocalDiskPartition", "storageLocalDiskPartition", "partition-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['storageLocalDisk', 'storageLocalDiskConfigDef', 'storageLocalDiskConfigPolicy'], [], ["Get"]),
    "StorageLocalDiskSlotEp": MoMeta("StorageLocalDiskSlotEp", "storageLocalDiskSlotEp", "disk-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst'], ["Get"]),
    "StorageLocalLun": MoMeta("StorageLocalLun", "storageLocalLun", "lun-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageLunDisk": MoMeta("StorageLunDisk", "storageLunDisk", "disk-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['storageVirtualDrive'], [], ["Get"]),
    "StorageLunResourceSelectionLog": MoMeta("StorageLunResourceSelectionLog", "storageLunResourceSelectionLog", "selection-log-[order]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageVirtualDriveRef'], [], [None]),
    "StorageMezzFlashLife": MoMeta("StorageMezzFlashLife", "storageMezzFlashLife", "flash-life-", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['storageController'], ['faultInst'], ["Get"]),
    "StorageMiniStorage": MoMeta("StorageMiniStorage", "storageMiniStorage", "mini-storage-[type]-[id]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['equipmentInventoryStatus', 'storageControllerReference'], ["Get"]),
    "StorageNodeEp": MoMeta("StorageNodeEp", "storageNodeEp", "node-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageIScsiTargetIf'], [None]),
    "StorageNvmeStats": MoMeta("StorageNvmeStats", "storageNvmeStats", "nvme-stats", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageController'], ['storageNvmeStatsHist'], ["Get"]),
    "StorageNvmeStatsHist": MoMeta("StorageNvmeStatsHist", "storageNvmeStatsHist", "[id]", VersionMeta.Version312b, "OutputOnly", 0x1, [], ["read-only"], ['storageNvmeStats'], [], ["Get"]),
    "StorageNvmeStorage": MoMeta("StorageNvmeStorage", "storageNvmeStorage", "nvme-storage", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController'], [], ["Get"]),
    "StorageNvmeSwitch": MoMeta("StorageNvmeSwitch", "storageNvmeSwitch", "nvme-switch-[id]", VersionMeta.Version323a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBoard'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning'], [None]),
    "StorageOnboardDevice": MoMeta("StorageOnboardDevice", "storageOnboardDevice", "onboard-device-[device_type]-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageSasExpander'], ['firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], [None]),
    "StorageOperation": MoMeta("StorageOperation", "storageOperation", "op-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['storageController', 'storageLocalDisk', 'storageRaidBattery', 'storageVirtualDrive'], [], [None]),
    "StorageQual": MoMeta("StorageQual", "storageQual", "local-storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['storageController'], ['faultInst', 'storageOperation', 'storageTransportableFlashModule'], ["Get"]),
    "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version226c, "InputOutput", 0x1, [], ["read-only"], ['computeBoard', 'equipmentChassis'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'mgmtController', 'storageOnboardDevice', 'storageSasUpLink'], [None]),
    "StorageSasLinkDescriptor": MoMeta("StorageSasLinkDescriptor", "storageSasLinkDescriptor", "sas-link-desc-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentChassisCapProvider'], [], ["Get"]),
    "StorageSasPort": MoMeta("StorageSasPort", "storageSasPort", "sas-port-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosureLocalDiskConfig', 'storageLocalDisk'], [], ["Get"]),
    "StorageSasPortDescriptor": MoMeta("StorageSasPortDescriptor", "storageSasPortDescriptor", "sas-port-desc-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], [""], ['equipmentChassisCapProvider'], [], ["Get"]),
    "StorageSasUpLink": MoMeta("StorageSasUpLink", "storageSasUpLink", "sas-uplink-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['storageSasExpander'], [], ["Get"]),
    "StorageScsiLunRef": MoMeta("StorageScsiLunRef", "storageScsiLunRef", "scsi-lun-ref-[id]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['storageVirtualDrive'], [], [None]),
    "StorageSsdHealthStats": MoMeta("StorageSsdHealthStats", "storageSsdHealthStats", "ssd-health-stats-[id]", VersionMeta.Version321d, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageLocalDisk'], ['storageSsdHealthStatsHist'], ["Get"]),
    "StorageSsdHealthStatsHist": MoMeta("StorageSsdHealthStatsHist", "storageSsdHealthStatsHist", "[id]", VersionMeta.Version321d, "OutputOnly", 0x1, [], ["read-only"], ['storageSsdHealthStats'], [], ["Get"]),
    "StorageSystem": MoMeta("StorageSystem", "storageSystem", "system", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['storageDomainEp'], ['eventInst', 'faultInst', 'initiatorRequestorEp', 'storageSystemFsm', 'storageSystemFsmTask'], [None]),
    "StorageSystemFsm": MoMeta("StorageSystemFsm", "storageSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['storageSystem'], ['storageSystemFsmStage'], [None]),
    "StorageSystemFsmStage": MoMeta("StorageSystemFsmStage", "storageSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['storageSystemFsm'], [], [None]),
    "StorageSystemFsmTask": MoMeta("StorageSystemFsmTask", "storageSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['storageSystem'], [], [None]),
    "StorageTransportableFlashModule": MoMeta("StorageTransportableFlashModule", "storageTransportableFlashModule", "flash-module", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['storageRaidBattery'], [], ["Get"]),
    "StorageVDMemberEp": MoMeta("StorageVDMemberEp", "storageVDMemberEp", "member-[id]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["read-only"], ['storageVirtualDrive'], ['faultInst'], ["Get"]),
    "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageVirtualDriveContainer'], ['faultInst', 'storageControllerEp', 'storageLunDisk', 'storageOperation', 'storageScsiLunRef', 'storageVDMemberEp'], [None]),
    "StorageVirtualDriveContainer": MoMeta("StorageVirtualDriveContainer", "storageVirtualDriveContainer", "vd-container-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis'], ['storageVirtualDrive'], ["Get"]),
    "StorageVirtualDriveEp": MoMeta("StorageVirtualDriveEp", "storageVirtualDriveEp", "vd-ep-[container_id]-id-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageVirtualDriveRef": MoMeta("StorageVirtualDriveRef", "storageVirtualDriveRef", "vdrive-ref-[lun_item_name]", VersionMeta.Version224b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['lsServer'], ['lstorageDiskGroupConfigDef', 'storageLunResourceSelectionLog'], ["Get"]),
    "StorageVsanRef": MoMeta("StorageVsanRef", "storageVsanRef", "vsan-ref", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['fabricFcUserZone', 'storageFcTargetEp'], ['faultInst'], ["Add", "Get", "Set"]),
    "SwAccessDomain": MoMeta("SwAccessDomain", "swAccessDomain", "access-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swAccessDomainFsm', 'swAccessDomainFsmTask', 'swAccessEp', 'swSubGroup'], ["Get"]),
    "SwAccessDomainFsm": MoMeta("SwAccessDomainFsm", "swAccessDomainFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swAccessDomain'], ['swAccessDomainFsmStage'], [None]),
    "SwAccessDomainFsmStage": MoMeta("SwAccessDomainFsmStage", "swAccessDomainFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swAccessDomainFsm'], [], [None]),
    "SwAccessDomainFsmTask": MoMeta("SwAccessDomainFsmTask", "swAccessDomainFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['swAccessDomain'], [], [None]),
    "SwAccessEp": MoMeta("SwAccessEp", "swAccessEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['swAccessDomain', 'swSubGroup'], ['portTrustMode', 'swUlan'], ["Get"]),
    "SwCardEnvStats": MoMeta("SwCardEnvStats", "swCardEnvStats", "cardenvstats", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['swCardEnvStatsHist'], ["Get"]),
    "SwCardEnvStatsHist": MoMeta("SwCardEnvStatsHist", "swCardEnvStatsHist", "[id]", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["read-only"], ['swCardEnvStats'], [], ["Get"]),
    "SwCmclan": MoMeta("SwCmclan", "swCmclan", "vlan-cmc[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['dcxVc'], ['fabricNetGroupRef'], [None]),
    "SwEnvStats": MoMeta("SwEnvStats", "swEnvStats", "envstats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['swEnvStatsHist'], ["Get"]),
    "SwEnvStatsHist": MoMeta("SwEnvStatsHist", "swEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['swEnvStats'], [], ["Get"]),
    "SwEthEstcEp": MoMeta("SwEthEstcEp", "swEthEstcEp", "ethestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthLanBorder', 'swSubGroup'], ['swEthTargetEp', 'swVlan'], ["Get"]),
    "SwEthEstcPc": MoMeta("SwEthEstcPc", "swEthEstcPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthLanBorder', 'swEthMon'], ['swEthTargetEp', 'swVlan'], ["Get"]),
    "SwEthLanBorder": MoMeta("SwEthLanBorder", "swEthLanBorder", "border-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swEthEstcEp', 'swEthEstcPc', 'swEthLanBorderFsm', 'swEthLanBorderFsmTask', 'swEthLanEp', 'swEthLanPc', 'swSubGroup', 'swVlan', 'swVlanGroup'], ["Get"]),
    "SwEthLanBorderFsm": MoMeta("SwEthLanBorderFsm", "swEthLanBorderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swEthLanBorder'], ['swEthLanBorderFsmStage'], [None]),
    "SwEthLanBorderFsmStage": MoMeta("SwEthLanBorderFsmStage", "swEthLanBorderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swEthLanBorderFsm'], [], [None]),
    "SwEthLanBorderFsmTask": MoMeta("SwEthLanBorderFsmTask", "swEthLanBorderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['swEthLanBorder'], [], [None]),
    "SwEthLanEp": MoMeta("SwEthLanEp", "swEthLanEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['swEthLanBorder', 'swSubGroup'], ['swVlan'], ["Get"]),
    "SwEthLanFlowMon": MoMeta("SwEthLanFlowMon", "swEthLanFlowMon", "ethlanflowmon", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['dcxVc', 'eventInst', 'faultInst', 'swEthLanFlowMonFsm', 'swEthLanFlowMonFsmTask', 'swIpRoute', 'swNetflowExporter', 'swNetflowMonSession', 'swNetflowMonitor', 'swNetflowRecordDef', 'swVirtL3Intf'], [None]),
    "SwEthLanFlowMonFsm": MoMeta("SwEthLanFlowMonFsm", "swEthLanFlowMonFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['swEthLanFlowMon'], ['swEthLanFlowMonFsmStage'], [None]),
    "SwEthLanFlowMonFsmStage": MoMeta("SwEthLanFlowMonFsmStage", "swEthLanFlowMonFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['swEthLanFlowMonFsm'], [], [None]),
    "SwEthLanFlowMonFsmTask": MoMeta("SwEthLanFlowMonFsmTask", "swEthLanFlowMonFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], ['swEthLanFlowMon'], [], [None]),
    "SwEthLanMon": MoMeta("SwEthLanMon", "swEthLanMon", "lanmon-eth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['swEthMon'], ["Get"]),
    "SwEthLanPc": MoMeta("SwEthLanPc", "swEthLanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['swEthLanBorder', 'swEthMon'], ['swVlan'], ["Get"]),
    "SwEthMon": MoMeta("SwEthMon", "swEthMon", "mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthLanMon'], ['dcxVc', 'eventInst', 'faultInst', 'swEthEstcPc', 'swEthLanPc', 'swEthMonDestEp', 'swEthMonFsm', 'swEthMonFsmTask', 'swEthMonSrcEp', 'swSubGroup', 'swVlan'], ["Get"]),
    "SwEthMonDestEp": MoMeta("SwEthMonDestEp", "swEthMonDestEp", "mon-dest-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthMon', 'swFcMon', 'swSubGroup'], [], ["Get"]),
    "SwEthMonFsm": MoMeta("SwEthMonFsm", "swEthMonFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swEthMon'], ['swEthMonFsmStage'], [None]),
    "SwEthMonFsmStage": MoMeta("SwEthMonFsmStage", "swEthMonFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swEthMonFsm'], [], [None]),
    "SwEthMonFsmTask": MoMeta("SwEthMonFsmTask", "swEthMonFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['swEthMon'], [], [None]),
    "SwEthMonSrcEp": MoMeta("SwEthMonSrcEp", "swEthMonSrcEp", "mon-src-[chassis_id]-[slot_id]-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthMon', 'swSubGroup'], [], ["Get"]),
    "SwEthTargetEp": MoMeta("SwEthTargetEp", "swEthTargetEp", "eth-target-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swEthEstcEp', 'swEthEstcPc'], ['faultInst'], ["Get"]),
    "SwEtherPort": MoMeta("SwEtherPort", "swEtherPort", "slot-[slot_id]-aggrport-[aggr_port_id]-port-[port_id]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin"], ['swPortDiscover'], [], [None]),
    "SwExtUtility": MoMeta("SwExtUtility", "swExtUtility", "ext", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swExtUtilityFsm', 'swExtUtilityFsmTask', 'swPortBreakout'], [None]),
    "SwExtUtilityFsm": MoMeta("SwExtUtilityFsm", "swExtUtilityFsm", "fsm", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], ['swExtUtility'], ['swExtUtilityFsmStage'], [None]),
    "SwExtUtilityFsmStage": MoMeta("SwExtUtilityFsmStage", "swExtUtilityFsmStage", "stage-[name]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], ['swExtUtilityFsm'], [], [None]),
    "SwExtUtilityFsmTask": MoMeta("SwExtUtilityFsmTask", "swExtUtilityFsmTask", "task-[item]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], ['swExtUtility'], [], [None]),
    "SwFabricZoneNs": MoMeta("SwFabricZoneNs", "swFabricZoneNs", "fabric-zone-ns", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], [], [None]),
    "SwFabricZoneNsOverride": MoMeta("SwFabricZoneNsOverride", "swFabricZoneNsOverride", "fabric-zone-override", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['topSysDefaults'], [], [None]),
    "SwFcEndpoint": MoMeta("SwFcEndpoint", "swFcEndpoint", "wwpn-[wwpn]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['swFcUserZone'], [], ["Get"]),
    "SwFcEstcEp": MoMeta("SwFcEstcEp", "swFcEstcEp", "fcestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcSanBorder'], [], ["Get"]),
    "SwFcMon": MoMeta("SwFcMon", "swFcMon", "mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcSanMon'], ['dcxVc', 'eventInst', 'faultInst', 'swEthMonDestEp', 'swFcMonDestEp', 'swFcMonFsm', 'swFcMonFsmTask', 'swFcMonSrcEp', 'swFcSanPc', 'swFcoeSanPc', 'swSubGroup', 'swVlan', 'swVsan'], ["Get"]),
    "SwFcMonDestEp": MoMeta("SwFcMonDestEp", "swFcMonDestEp", "mon-dest-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcMon'], [], ["Get"]),
    "SwFcMonFsm": MoMeta("SwFcMonFsm", "swFcMonFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swFcMon'], ['swFcMonFsmStage'], [None]),
    "SwFcMonFsmStage": MoMeta("SwFcMonFsmStage", "swFcMonFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swFcMonFsm'], [], [None]),
    "SwFcMonFsmTask": MoMeta("SwFcMonFsmTask", "swFcMonFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['swFcMon'], [], [None]),
    "SwFcMonSrcEp": MoMeta("SwFcMonSrcEp", "swFcMonSrcEp", "mon-src-[chassis_id]-[slot_id]-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcMon'], [], ["Get"]),
    "SwFcSanBorder": MoMeta("SwFcSanBorder", "swFcSanBorder", "border-fc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swFcEstcEp', 'swFcSanBorderFsm', 'swFcSanBorderFsmTask', 'swFcSanEp', 'swFcSanPc', 'swFcoeEstcEp', 'swFcoeSanEp', 'swFcoeSanPc', 'swSubGroup', 'swVlan', 'swVsan'], ["Get"]),
    "SwFcSanBorderFsm": MoMeta("SwFcSanBorderFsm", "swFcSanBorderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swFcSanBorder'], ['swFcSanBorderFsmStage'], [None]),
    "SwFcSanBorderFsmStage": MoMeta("SwFcSanBorderFsmStage", "swFcSanBorderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swFcSanBorderFsm'], [], [None]),
    "SwFcSanBorderFsmTask": MoMeta("SwFcSanBorderFsmTask", "swFcSanBorderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['swFcSanBorder'], [], [None]),
    "SwFcSanEp": MoMeta("SwFcSanEp", "swFcSanEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['swFcSanBorder'], [], ["Get"]),
    "SwFcSanMon": MoMeta("SwFcSanMon", "swFcSanMon", "sanmon-fc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['swFcMon'], ["Get"]),
    "SwFcSanPc": MoMeta("SwFcSanPc", "swFcSanPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcMon', 'swFcSanBorder'], [], ["Get"]),
    "SwFcServerZoneGroup": MoMeta("SwFcServerZoneGroup", "swFcServerZoneGroup", "zone-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swFcZoneSet'], ['swZoneInitiatorMember'], [None]),
    "SwFcUserZone": MoMeta("SwFcUserZone", "swFcUserZone", "zone-[id]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['swFcUserZoneGroup'], ['swFcEndpoint'], ["Get"]),
    "SwFcUserZoneGroup": MoMeta("SwFcUserZoneGroup", "swFcUserZoneGroup", "user-zone-group-[name]", VersionMeta.Version312b, "InputOutput", 0x1, [], ["read-only"], ['swFcZoneSet'], ['swFcUserZone'], ["Get"]),
    "SwFcZone": MoMeta("SwFcZone", "swFcZone", "zone-[identity]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swZoneInitiatorMember'], ['swZoneTargetMember'], [None]),
    "SwFcZoneSet": MoMeta("SwFcZoneSet", "swFcZoneSet", "zone-set-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swVsan'], ['swFcServerZoneGroup', 'swFcUserZoneGroup'], [None]),
    "SwFcoeEstcEp": MoMeta("SwFcoeEstcEp", "swFcoeEstcEp", "fcoeestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['swFcSanBorder', 'swSubGroup'], ['dcxFcoeVifEp', 'dcxVifEp', 'swVlan'], ["Get"]),
    "SwFcoeSanEp": MoMeta("SwFcoeSanEp", "swFcoeSanEp", "fcoesan-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swFcSanBorder', 'swSubGroup'], ['dcxFcoeVifEp', 'dcxVifEp', 'swVlan'], ["Add", "Get", "Remove", "Set"]),
    "SwFcoeSanPc": MoMeta("SwFcoeSanPc", "swFcoeSanPc", "fcoesan-pc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swFcMon', 'swFcSanBorder'], ['dcxFcoeVifEp', 'dcxVifEp', 'swVlan'], ["Add", "Get", "Remove", "Set"]),
    "SwIpRoute": MoMeta("SwIpRoute", "swIpRoute", "ip-route-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon'], [], [None]),
    "SwNFExporterRef": MoMeta("SwNFExporterRef", "swNFExporterRef", "nf-exporter-ref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swNetflowMonitor'], [], [None]),
    "SwNetflowExporter": MoMeta("SwNetflowExporter", "swNetflowExporter", "flowexporter-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon'], ['swVlan'], [None]),
    "SwNetflowMonSession": MoMeta("SwNetflowMonSession", "swNetflowMonSession", "flowmonsession-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon'], ['swNetflowMonitor', 'swNetflowMonitorRef'], [None]),
    "SwNetflowMonitor": MoMeta("SwNetflowMonitor", "swNetflowMonitor", "flowmonitor-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon', 'swNetflowMonSession'], ['swNFExporterRef'], [None]),
    "SwNetflowMonitorRef": MoMeta("SwNetflowMonitorRef", "swNetflowMonitorRef", "nf-monitor-ref-[name]-[direction]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['dcxVc', 'swNetflowMonSession', 'vnicProfile'], [], [None]),
    "SwNetflowRecordDef": MoMeta("SwNetflowRecordDef", "swNetflowRecordDef", "flowrecord-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon'], [], [None]),
    "SwPhys": MoMeta("SwPhys", "swPhys", "phys", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swPhysEtherEp', 'swPhysFcEp', 'swPhysFsm', 'swPhysFsmTask', 'swSubGroup'], ["Get"]),
    "SwPhysEtherEp": MoMeta("SwPhysEtherEp", "swPhysEtherEp", "phys-eth-slot-[slot_id]port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['swPhys', 'swSubGroup'], [], ["Get"]),
    "SwPhysFcEp": MoMeta("SwPhysFcEp", "swPhysFcEp", "phys-fc-slot-[slot_id]port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['swPhys', 'swSubGroup'], [], ["Get"]),
    "SwPhysFsm": MoMeta("SwPhysFsm", "swPhysFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swPhys'], ['swPhysFsmStage'], [None]),
    "SwPhysFsmStage": MoMeta("SwPhysFsmStage", "swPhysFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swPhysFsm'], [], [None]),
    "SwPhysFsmTask": MoMeta("SwPhysFsmTask", "swPhysFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], ['swPhys'], [], [None]),
    "SwPortBreakout": MoMeta("SwPortBreakout", "swPortBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin"], ['swExtUtility'], [], [None]),
    "SwPortDiscover": MoMeta("SwPortDiscover", "swPortDiscover", "discover", VersionMeta.Version321d, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swEtherPort', 'swPortDiscoverFsm', 'swPortDiscoverFsmTask'], [None]),
    "SwPortDiscoverFsm": MoMeta("SwPortDiscoverFsm", "swPortDiscoverFsm", "fsm", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['swPortDiscover'], ['swPortDiscoverFsmStage'], [None]),
    "SwPortDiscoverFsmStage": MoMeta("SwPortDiscoverFsmStage", "swPortDiscoverFsmStage", "stage-[name]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['swPortDiscoverFsm'], [], [None]),
    "SwPortDiscoverFsmTask": MoMeta("SwPortDiscoverFsmTask", "swPortDiscoverFsmTask", "task-[item]", VersionMeta.Version321d, "OutputOnly", 0x1, [], [""], ['swPortDiscover'], [], [None]),
    "SwSubGroup": MoMeta("SwSubGroup", "swSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["read-only"], ['swAccessDomain', 'swEthLanBorder', 'swEthMon', 'swFcMon', 'swFcSanBorder', 'swPhys'], ['swAccessEp', 'swEthEstcEp', 'swEthLanEp', 'swEthMonDestEp', 'swEthMonSrcEp', 'swFcoeEstcEp', 'swFcoeSanEp', 'swPhysEtherEp', 'swPhysFcEp'], [None]),
    "SwSystemStats": MoMeta("SwSystemStats", "swSystemStats", "sysstats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['faultInst', 'swSystemStatsHist'], ["Get"]),
    "SwSystemStatsHist": MoMeta("SwSystemStatsHist", "swSystemStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], ['swSystemStats'], [], ["Get"]),
    "SwUlan": MoMeta("SwUlan", "swUlan", "vlan-[purpose]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'dcxVc', 'etherServerIntFIo', 'swAccessEp', 'swUtilityDomain'], [], ["Get"]),
    "SwUtilityDomain": MoMeta("SwUtilityDomain", "swUtilityDomain", "utility-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['eventInst', 'faultInst', 'swUlan', 'swUtilityDomainFsm', 'swUtilityDomainFsmTask'], ["Get"]),
    "SwUtilityDomainFsm": MoMeta("SwUtilityDomainFsm", "swUtilityDomainFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swUtilityDomain'], ['swUtilityDomainFsmStage'], [None]),
    "SwUtilityDomainFsmStage": MoMeta("SwUtilityDomainFsmStage", "swUtilityDomainFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['swUtilityDomainFsm'], [], [None]),
    "SwUtilityDomainFsmTask": MoMeta("SwUtilityDomainFsmTask", "swUtilityDomainFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['swUtilityDomain'], [], [None]),
    "SwVIFRef": MoMeta("SwVIFRef", "swVIFRef", "vifref-[id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], ['swVlanGroup'], [], ["Get"]),
    "SwVirtL3Intf": MoMeta("SwVirtL3Intf", "swVirtL3Intf", "l3-vlan-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['swEthLanFlowMon'], [], [None]),
    "SwVlan": MoMeta("SwVlan", "swVlan", "vlan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['dcxVc', 'swEthEstcEp', 'swEthEstcPc', 'swEthLanBorder', 'swEthLanEp', 'swEthLanPc', 'swEthMon', 'swFcMon', 'swFcSanBorder', 'swFcoeEstcEp', 'swFcoeSanEp', 'swFcoeSanPc', 'swNetflowExporter', 'vnicInternalProfile', 'vnicRackServerDiscoveryProfile'], ['fabricNetflowIPv4Addr', 'faultInst'], ["Get"]),
    "SwVlanGroup": MoMeta("SwVlanGroup", "swVlanGroup", "vlan-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swEthLanBorder'], ['swVIFRef', 'swVlanRef'], [None]),
    "SwVlanPortNs": MoMeta("SwVlanPortNs", "swVlanPortNs", "vlan-port-ns", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['faultInst'], ["Get"]),
    "SwVlanPortNsOverride": MoMeta("SwVlanPortNsOverride", "swVlanPortNsOverride", "vlan-port-override", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin"], ['topSysDefaults'], [], ["Get"]),
    "SwVlanRef": MoMeta("SwVlanRef", "swVlanRef", "vlanref-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swVlanGroup'], [], [None]),
    "SwVsan": MoMeta("SwVsan", "swVsan", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['dcxFcoeVifEp', 'dcxVc', 'dcxVifEp', 'swFcMon', 'swFcSanBorder'], ['swFcZoneSet'], ["Get"]),
    "SwZoneInitiatorMember": MoMeta("SwZoneInitiatorMember", "swZoneInitiatorMember", "initiator-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swFcServerZoneGroup'], ['swFcZone'], [None]),
    "SwZoneTargetMember": MoMeta("SwZoneTargetMember", "swZoneTargetMember", "target-[wwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['swFcZone'], [], [None]),
    "SwatAction": MoMeta("SwatAction", "swatAction", "action-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['swatInjection'], ['swatCondition', 'swatTarget', 'swatTrigger'], ["Get"]),
    "SwatCondition": MoMeta("SwatCondition", "swatCondition", "cond-[var_name]-[operation]-[var_value]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['swatAction', 'swatTrigger'], [], ["Get"]),
    "SwatInjection": MoMeta("SwatInjection", "swatInjection", "inject-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['swatAction'], ["Get"]),
    "SwatResultstats": MoMeta("SwatResultstats", "swatResultstats", "", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SwatTarget": MoMeta("SwatTarget", "swatTarget", "target-[var_name]-[var_value]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['swatAction'], [], ["Get"]),
    "SwatTrigger": MoMeta("SwatTrigger", "swatTrigger", "trigger-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['swatAction', 'swatTrigger'], ['swatCondition', 'swatTrigger'], ["Get"]),
    "SyntheticDirectory": MoMeta("SyntheticDirectory", "syntheticDirectory", "dir-[ino]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['syntheticDirectory', 'topSystem'], ['syntheticDirectory', 'syntheticFile'], ["Get"]),
    "SyntheticFile": MoMeta("SyntheticFile", "syntheticFile", "file-[ino]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['syntheticDirectory'], [], ["Get"]),
    "SyntheticFileSystem": MoMeta("SyntheticFileSystem", "syntheticFileSystem", "FS-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], [], ["Get"]),
    "SyntheticFsObj": MoMeta("SyntheticFsObj", "syntheticFsObj", "file-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'syntheticFsObjFsm', 'syntheticFsObjFsmTask'], ["Get"]),
    "SyntheticFsObjFsm": MoMeta("SyntheticFsObjFsm", "syntheticFsObjFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['syntheticFsObj'], ['syntheticFsObjFsmStage'], [None]),
    "SyntheticFsObjFsmStage": MoMeta("SyntheticFsObjFsmStage", "syntheticFsObjFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['syntheticFsObjFsm'], [], [None]),
    "SyntheticFsObjFsmTask": MoMeta("SyntheticFsObjFsmTask", "syntheticFsObjFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['syntheticFsObj'], [], [None]),
    "SyntheticTime": MoMeta("SyntheticTime", "syntheticTime", "time-[ts]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SysdebugAutoCoreFileExportTarget": MoMeta("SysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTarget", "file-export", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugEp'], ['eventInst', 'faultInst', 'sysdebugAutoCoreFileExportTargetFsm', 'sysdebugAutoCoreFileExportTargetFsmTask'], ["Get", "Set"]),
    "SysdebugAutoCoreFileExportTargetFsm": MoMeta("SysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTarget'], ['sysdebugAutoCoreFileExportTargetFsmStage'], [None]),
    "SysdebugAutoCoreFileExportTargetFsmStage": MoMeta("SysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTargetFsm'], [], [None]),
    "SysdebugAutoCoreFileExportTargetFsmTask": MoMeta("SysdebugAutoCoreFileExportTargetFsmTask", "sysdebugAutoCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTarget'], [], [None]),
    "SysdebugBackupBehavior": MoMeta("SysdebugBackupBehavior", "sysdebugBackupBehavior", "backup", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugMEpLogPolicy'], [], ["Get", "Set"]),
    "SysdebugCore": MoMeta("SysdebugCore", "sysdebugCore", "file-[name]|[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCoreFileRepository'], ['eventInst', 'faultInst', 'sysdebugCoreFsm', 'sysdebugCoreFsmTask', 'sysdebugManualCoreFileExportTarget', 'sysfileMutation'], ["Get"]),
    "SysdebugCoreFileRepository": MoMeta("SysdebugCoreFileRepository", "sysdebugCoreFileRepository", "corefiles", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['topSystem'], ['sysdebugCore', 'sysfileMutation'], ["Get"]),
    "SysdebugCoreFsm": MoMeta("SysdebugCoreFsm", "sysdebugCoreFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugCore'], ['sysdebugCoreFsmStage'], [None]),
    "SysdebugCoreFsmStage": MoMeta("SysdebugCoreFsmStage", "sysdebugCoreFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugCoreFsm'], [], [None]),
    "SysdebugCoreFsmTask": MoMeta("SysdebugCoreFsmTask", "sysdebugCoreFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['sysdebugCore'], [], [None]),
    "SysdebugDiagnosticLog": MoMeta("SysdebugDiagnosticLog", "sysdebugDiagnosticLog", "diag-log-[name]-[switch_id]", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "operations"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'sysdebugDiagnosticLogRepository'], [], ["Get", "Set"]),
    "SysdebugDiagnosticLogRepository": MoMeta("SysdebugDiagnosticLogRepository", "sysdebugDiagnosticLogRepository", "diag-log-files", VersionMeta.Version321d, "InputOutput", 0x1, [], ["admin", "operations"], ['topSystem'], ['sysdebugDiagnosticLog'], [None]),
    "SysdebugEp": MoMeta("SysdebugEp", "sysdebugEp", "sysdebug", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['sysdebugAutoCoreFileExportTarget', 'sysdebugLogControlEp', 'sysdebugLogExportPolicy'], ["Get"]),
    "SysdebugLogControlDestinationFile": MoMeta("SysdebugLogControlDestinationFile", "sysdebugLogControlDestinationFile", "file", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogControlDestinationSyslog": MoMeta("SysdebugLogControlDestinationSyslog", "sysdebugLogControlDestinationSyslog", "syslog", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogControlDomain": MoMeta("SysdebugLogControlDomain", "sysdebugLogControlDomain", "domain-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlEp'], ['sysdebugLogControlDestinationFile', 'sysdebugLogControlDestinationSyslog', 'sysdebugLogControlModule'], ["Get"]),
    "SysdebugLogControlEp": MoMeta("SysdebugLogControlEp", "sysdebugLogControlEp", "logcontrol", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugEp'], ['eventInst', 'faultInst', 'sysdebugLogControlDomain', 'sysdebugLogControlEpFsm', 'sysdebugLogControlEpFsmTask'], ["Get"]),
    "SysdebugLogControlEpFsm": MoMeta("SysdebugLogControlEpFsm", "sysdebugLogControlEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEp'], ['sysdebugLogControlEpFsmStage'], [None]),
    "SysdebugLogControlEpFsmStage": MoMeta("SysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEpFsm'], [], [None]),
    "SysdebugLogControlEpFsmTask": MoMeta("SysdebugLogControlEpFsmTask", "sysdebugLogControlEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEp'], [], [None]),
    "SysdebugLogControlModule": MoMeta("SysdebugLogControlModule", "sysdebugLogControlModule", "module-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogExportPolicy": MoMeta("SysdebugLogExportPolicy", "sysdebugLogExportPolicy", "log-export-policy", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugEp'], ['eventInst', 'faultInst', 'sysdebugLogExportPolicyFsm', 'sysdebugLogExportPolicyFsmTask', 'sysdebugLogExportStatus'], ["Get", "Set"]),
    "SysdebugLogExportPolicyFsm": MoMeta("SysdebugLogExportPolicyFsm", "sysdebugLogExportPolicyFsm", "fsm", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], ['sysdebugLogExportPolicy'], ['sysdebugLogExportPolicyFsmStage'], [None]),
    "SysdebugLogExportPolicyFsmStage": MoMeta("SysdebugLogExportPolicyFsmStage", "sysdebugLogExportPolicyFsmStage", "stage-[name]", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], ['sysdebugLogExportPolicyFsm'], [], [None]),
    "SysdebugLogExportPolicyFsmTask": MoMeta("SysdebugLogExportPolicyFsmTask", "sysdebugLogExportPolicyFsmTask", "task-[item]", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], ['sysdebugLogExportPolicy'], [], [None]),
    "SysdebugLogExportStatus": MoMeta("SysdebugLogExportStatus", "sysdebugLogExportStatus", "log-export-status-[switch_id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], ['sysdebugLogExportPolicy'], ['faultInst'], ["Get"]),
    "SysdebugMEpLog": MoMeta("SysdebugMEpLog", "sysdebugMEpLog", "log-[type]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['mgmtController'], ['faultInst'], ["Get", "Set"]),
    "SysdebugMEpLogPolicy": MoMeta("SysdebugMEpLogPolicy", "sysdebugMEpLogPolicy", "log-[type]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "operations"], ['orgOrg'], ['sysdebugBackupBehavior'], ["Get"]),
    "SysdebugManualCoreFileExportTarget": MoMeta("SysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTarget", "export-to-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCore'], ['eventInst', 'faultInst', 'sysdebugManualCoreFileExportTargetFsm', 'sysdebugManualCoreFileExportTargetFsmTask'], ["Get"]),
    "SysdebugManualCoreFileExportTargetFsm": MoMeta("SysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTarget'], ['sysdebugManualCoreFileExportTargetFsmStage'], [None]),
    "SysdebugManualCoreFileExportTargetFsmStage": MoMeta("SysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTargetFsm'], [], [None]),
    "SysdebugManualCoreFileExportTargetFsmTask": MoMeta("SysdebugManualCoreFileExportTargetFsmTask", "sysdebugManualCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTarget'], [], [None]),
    "SysdebugTechSupFileRepository": MoMeta("SysdebugTechSupFileRepository", "sysdebugTechSupFileRepository", "tech-support-files", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], ['topSystem'], ['sysdebugTechSupport'], ["Get"]),
    "SysdebugTechSupport": MoMeta("SysdebugTechSupport", "sysdebugTechSupport", "tech-support-[creation_ts]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupFileRepository'], ['eventInst', 'faultInst', 'sysdebugTechSupportCmdOpt', 'sysdebugTechSupportFsm', 'sysdebugTechSupportFsmTask'], ["Add", "Get", "Set"]),
    "SysdebugTechSupportCmdOpt": MoMeta("SysdebugTechSupportCmdOpt", "sysdebugTechSupportCmdOpt", "tech-support-cmd-opt", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupport'], [], ["Add", "Get", "Set"]),
    "SysdebugTechSupportFsm": MoMeta("SysdebugTechSupportFsm", "sysdebugTechSupportFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupport'], ['sysdebugTechSupportFsmStage'], [None]),
    "SysdebugTechSupportFsmStage": MoMeta("SysdebugTechSupportFsmStage", "sysdebugTechSupportFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupportFsm'], [], [None]),
    "SysdebugTechSupportFsmTask": MoMeta("SysdebugTechSupportFsmTask", "sysdebugTechSupportFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupport'], [], [None]),
    "SysfileDigest": MoMeta("SysfileDigest", "sysfileDigest", "filedigest-[name]-[creation_ts]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "SysfileMutation": MoMeta("SysfileMutation", "sysfileMutation", "mutation", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCore', 'sysdebugCoreFileRepository'], ['eventInst', 'faultInst', 'sysfileMutationFsm', 'sysfileMutationFsmTask'], ["Add", "Get"]),
    "SysfileMutationFsm": MoMeta("SysfileMutationFsm", "sysfileMutationFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysfileMutation'], ['sysfileMutationFsmStage'], [None]),
    "SysfileMutationFsmStage": MoMeta("SysfileMutationFsmStage", "sysfileMutationFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['sysfileMutationFsm'], [], [None]),
    "SysfileMutationFsmTask": MoMeta("SysfileMutationFsmTask", "sysfileMutationFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['sysfileMutation'], [], [None]),
    "TopInfoPolicy": MoMeta("TopInfoPolicy", "topInfoPolicy", "info-policy", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], ['topSystem'], [], ["Get", "Set"]),
    "TopInfoSyncPolicy": MoMeta("TopInfoSyncPolicy", "topInfoSyncPolicy", "info-sync-policy", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], ['orgOrg'], [], ["Get"]),
    "TopMetaInf": MoMeta("TopMetaInf", "topMetaInf", "meta", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], [], ["Get"]),
    "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], ['aaaLog', 'apeManager', 'callhomeEp', 'capabilityCatalogue', 'clitestTypeTest', 'clitestTypeTest2', 'computeDefaults', 'dhcpInst', 'eventHolder', 'eventLog', 'extpolEp', 'fabricEp', 'faultHolder', 'fcpoolUniverse', 'gmetaEp', 'identMetaVerse', 'ippoolUniverse', 'iqnpoolUniverse', 'macpoolUniverse', 'morefImportRoot', 'nfsEp', 'observeObservedCont', 'orgOrg', 'policyPolicyEp', 'procManager', 'statsHolder', 'storageDomainEp', 'syntheticFileSystem', 'topMetaInf', 'topSysDefaults', 'topSystem', 'uuidpoolUniverse', 'vmEp'], ["Get"]),
    "TopSysDefaults": MoMeta("TopSysDefaults", "topSysDefaults", "sys-defaults", VersionMeta.Version142b, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['capabilityNetworkLimits', 'capabilityStorageLimits', 'capabilitySystemLimits', 'swFabricZoneNsOverride', 'swVlanPortNsOverride'], ["Get"]),
    "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['topRoot'], ['aaaAuthRealm', 'aaaLdapEp', 'aaaRadiusEp', 'aaaSessionInfoTable', 'aaaTacacsPlusEp', 'aaaUserEp', 'cloudMgmtSvc', 'commSvcEp', 'computeRackUnit', 'controllerHaController', 'controllerMgmtDbCheckPol', 'domainChassisFeatureCont', 'domainEnvironmentFeatureCont', 'domainNetworkFeatureCont', 'domainServerFeatureCont', 'domainStorageFeatureCont', 'equipmentChassis', 'equipmentFex', 'equipmentRackEnclosure', 'extmgmtIfMonPolicy', 'extvmmEp', 'featureContextEp', 'firmwareCatalogue', 'firmwareStatus', 'firmwareSystem', 'firmwareUpgradeInfo', 'fsmStatus', 'initiatorRequestorEp', 'initiatorRequestorGrpEp', 'licenseEp', 'mgmtAccessPolicy', 'mgmtBackup', 'mgmtBackupPolicyConfig', 'mgmtController', 'mgmtEntity', 'mgmtImporter', 'mgmtIntAuthPolicy', 'networkElement', 'pkiEp', 'policyControlEp', 'powerEp', 'swatInjection', 'syntheticDirectory', 'syntheticFsObj', 'sysdebugCoreFileRepository', 'sysdebugDiagnosticLogRepository', 'sysdebugEp', 'sysdebugTechSupFileRepository', 'topInfoPolicy', 'trigLocalSched', 'trigMeta', 'trigSched', 'versionEp'], ["Get", "Set"]),
    "TrigAbsWindow": MoMeta("TrigAbsWindow", "trigAbsWindow", "abs-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['trigLocalSched', 'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigClientToken": MoMeta("TrigClientToken", "trigClientToken", "clienttoken-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['trigTriggered'], [], [None]),
    "TrigLocalAbsWindow": MoMeta("TrigLocalAbsWindow", "trigLocalAbsWindow", "local-abs-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['trigLocalSched', 'trigSched'], [], ["Add", "Get", "Set"]),
    "TrigLocalSched": MoMeta("TrigLocalSched", "trigLocalSched", "local-sched-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], ['computeAdminAck', 'computeFwSyncAck', 'cpmaintAck', 'faultSuppressTask', 'firmwareAck', 'firmwareInfra', 'lsmaintAck', 'mgmtBackupPolicyConfig', 'topSystem', 'trigTest'], ['trigAbsWindow', 'trigLocalAbsWindow', 'trigRecurrWindow'], ["Add", "Get"]),
    "TrigMeta": MoMeta("TrigMeta", "trigMeta", "meta-trig-[sched_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['trigTriggered'], ["Get"]),
    "TrigRecurrWindow": MoMeta("TrigRecurrWindow", "trigRecurrWindow", "recurr-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['trigLocalSched', 'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigSched": MoMeta("TrigSched", "trigSched", "sched-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['topSystem'], ['trigAbsWindow', 'trigLocalAbsWindow', 'trigRecurrWindow'], ["Add", "Get", "Remove", "Set"]),
    "TrigTest": MoMeta("TrigTest", "trigTest", "test-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'trigLocalSched'], ["Get"]),
    "TrigTriggered": MoMeta("TrigTriggered", "trigTriggered", "trig-[tr_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], ['trigMeta'], ['trigClientToken'], ["Get"]),
    "UuidpoolAddr": MoMeta("UuidpoolAddr", "uuidpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['uuidpoolUniverse'], ['faultInst', 'uuidpoolPoolable'], ["Get"]),
    "UuidpoolBlock": MoMeta("UuidpoolBlock", "uuidpoolBlock", "block-from-[r_from]-to-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['uuidpoolPool'], [], ["Add", "Get", "Remove"]),
    "UuidpoolFormat": MoMeta("UuidpoolFormat", "uuidpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], ['uuidpoolUniverse'], [], ["Get"]),
    "UuidpoolPool": MoMeta("UuidpoolPool", "uuidpoolPool", "uuid-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['faultInst', 'uuidpoolBlock', 'uuidpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "UuidpoolPoolable": MoMeta("UuidpoolPoolable", "uuidpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['uuidpoolAddr'], [], ["Get"]),
    "UuidpoolPooled": MoMeta("UuidpoolPooled", "uuidpoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['uuidpoolPool'], [], ["Get"]),
    "UuidpoolUniverse": MoMeta("UuidpoolUniverse", "uuidpoolUniverse", "uuid", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['uuidpoolAddr', 'uuidpoolFormat'], ["Get"]),
    "VersionApplication": MoMeta("VersionApplication", "versionApplication", "application", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['versionEp'], [], [None]),
    "VersionEp": MoMeta("VersionEp", "versionEp", "version", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['versionApplication'], [None]),
    "VmComputeEp": MoMeta("VmComputeEp", "vmComputeEp", "computeEp-[uuid]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "read-only"], ['vmEp'], ['vmHba', 'vmNic'], ["Get"]),
    "VmDC": MoMeta("VmDC", "vmDC", "dc-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmProvider', 'vmDCOrg'], ['vmOrg'], ["Add", "Get", "Remove", "Set"]),
    "VmDCOrg": MoMeta("VmDCOrg", "vmDCOrg", "dc-cont-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmProvider'], ['vmDC'], ["Add", "Get", "Remove", "Set"]),
    "VmEp": MoMeta("VmEp", "vmEp", "vmm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['vmComputeEp', 'vmHv', 'vmInstance'], ["Get"]),
    "VmHba": MoMeta("VmHba", "vmHba", "hba-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['vmComputeEp', 'vmHv', 'vmInstance'], ['vmVsan'], ["Get"]),
    "VmHv": MoMeta("VmHv", "vmHv", "hv-[uuid]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "read-only"], ['vmEp'], ['vmHba', 'vmNic'], ["Get"]),
    "VmInstance": MoMeta("VmInstance", "vmInstance", "vm-[uuid]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['vmEp'], ['vmHba', 'vmNic'], ["Get"]),
    "VmLifeCyclePolicy": MoMeta("VmLifeCyclePolicy", "vmLifeCyclePolicy", "vm-lc-policy", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['eventInst', 'faultInst', 'vmLifeCyclePolicyFsm', 'vmLifeCyclePolicyFsmTask'], ["Get", "Set"]),
    "VmLifeCyclePolicyFsm": MoMeta("VmLifeCyclePolicyFsm", "vmLifeCyclePolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['vmLifeCyclePolicy'], ['vmLifeCyclePolicyFsmStage'], [None]),
    "VmLifeCyclePolicyFsmStage": MoMeta("VmLifeCyclePolicyFsmStage", "vmLifeCyclePolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['vmLifeCyclePolicyFsm'], [], [None]),
    "VmLifeCyclePolicyFsmTask": MoMeta("VmLifeCyclePolicyFsmTask", "vmLifeCyclePolicyFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], ['vmLifeCyclePolicy'], [], [None]),
    "VmNic": MoMeta("VmNic", "vmNic", "nic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], ['vmComputeEp', 'vmHv', 'vmInstance'], ['adaptorEthPortBySizeLargeStats', 'adaptorEthPortBySizeSmallStats', 'adaptorEthPortErrStats', 'adaptorEthPortMcastStats', 'adaptorEthPortOutsizedStats', 'adaptorEthPortStats', 'adaptorFcPortStats', 'adaptorVnicStats', 'fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vmVif', 'vmVlan'], ["Get"]),
    "VmOrg": MoMeta("VmOrg", "vmOrg", "org-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['vmDC'], ['vmSwitch'], ["Add", "Get", "Remove", "Set"]),
    "VmSwitch": MoMeta("VmSwitch", "vmSwitch", "switch-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['extvmmProvider', 'extvmmSwitchSet', 'vmOrg'], ['extvmmUpLinkPP', 'vmVnicProfInst'], ["Add", "Get", "Remove", "Set"]),
    "VmVif": MoMeta("VmVif", "vmVif", "sw-[ph_switch_id]vif-[vif_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin"], ['vmNic'], ['faultInst'], ["Get"]),
    "VmVlan": MoMeta("VmVlan", "vmVlan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vmNic'], [], ["Get"]),
    "VmVnicProfCl": MoMeta("VmVnicProfCl", "vmVnicProfCl", "cl-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], ['vnicProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "VmVnicProfInst": MoMeta("VmVnicProfInst", "vmVnicProfInst", "vnic-prof-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], ['vmSwitch'], ['vnicOProfileAlias', 'vnicProfileAlias'], ["Get"]),
    "VmVsan": MoMeta("VmVsan", "vmVsan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vmHba'], [], ["Get"]),
    "VnicBootIpPolicy": MoMeta("VnicBootIpPolicy", "vnicBootIpPolicy", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicBootTarget": MoMeta("VnicBootTarget", "vnicBootTarget", "boot-target", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['vnicFc'], [], ["Get"]),
    "VnicConnDef": MoMeta("VnicConnDef", "vnicConnDef", "conn-def", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], ['faultInst'], ["Add", "Get", "Set"]),
    "VnicDefBeh": MoMeta("VnicDefBeh", "vnicDefBeh", "def-beh-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], ['lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicCon": MoMeta("VnicDynamicCon", "vnicDynamicCon", "dynamic-con", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-network-policy", "ls-server"], ['lsServer'], [], ["Get", "Set"]),
    "VnicDynamicConPolicy": MoMeta("VnicDynamicConPolicy", "vnicDynamicConPolicy", "dynamic-con-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicConPolicyRef": MoMeta("VnicDynamicConPolicyRef", "vnicDynamicConPolicyRef", "con-ref-[con_policy_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicDynamicIdUniverse": MoMeta("VnicDynamicIdUniverse", "vnicDynamicIdUniverse", "dynamic-id-universe-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [], [], ["Get"]),
    "VnicDynamicProvider": MoMeta("VnicDynamicProvider", "vnicDynamicProvider", "dynamic-provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vnicProfileSet'], ['vnicDynamicProviderEp'], ["Get"]),
    "VnicDynamicProviderEp": MoMeta("VnicDynamicProviderEp", "vnicDynamicProviderEp", "ep-[switch_id]-[chassis_id]:[slot_id]:[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vnicDynamicProvider'], [], ["Get"]),
    "VnicEthConfig": MoMeta("VnicEthConfig", "vnicEthConfig", "eth-vnic", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['vnicIScsiInitAutoConfigPolicy'], ['faultInst'], [None]),
    "VnicEthLif": MoMeta("VnicEthLif", "vnicEthLif", "eth-lif-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], ["Get"]),
    "VnicEther": MoMeta("VnicEther", "vnicEther", "ether-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['lsServer', 'vnicLanConnPolicy'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetGroupRef', 'fabricNetflowMonSrcEp', 'faultInst', 'vnicDynamicConPolicyRef', 'vnicEtherIf', 'vnicFcOEIf', 'vnicLifVlan', 'vnicMacHistory', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicEtherIf": MoMeta("VnicEtherIf", "vnicEtherIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['extvmmVMNetworkDefinition', 'fabricFlowMonExporterProfile', 'vnicEther', 'vnicIpc', 'vnicLanConnTempl', 'vnicProfile'], ['fabricNetflowIPv4Addr', 'faultInst', 'vnicIPv4If'], ["Add", "Get", "Remove", "Set"]),
    "VnicFc": MoMeta("VnicFc", "vnicFc", "fc-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['lsServer', 'vnicSanConnPolicy'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetflowMonSrcEp', 'fabricSanGroupRef', 'faultInst', 'vnicBootTarget', 'vnicFcIf', 'vnicWwpnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcGroupDef": MoMeta("VnicFcGroupDef", "vnicFcGroupDef", "fc-group", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageIniGroup'], ['faultInst', 'storageConnectionDef'], ["Add", "Get", "Set"]),
    "VnicFcGroupTempl": MoMeta("VnicFcGroupTempl", "vnicFcGroupTempl", "fc-group-templ-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['faultInst'], [None]),
    "VnicFcIf": MoMeta("VnicFcIf", "vnicFcIf", "if-default", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], ['vnicFc', 'vnicSanConnTempl'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcLif": MoMeta("VnicFcLif", "vnicFcLif", "eth-lif-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], ['vnicLifVsan'], ["Get"]),
    "VnicFcNode": MoMeta("VnicFcNode", "vnicFcNode", "fc-node", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['lsServer', 'vnicSanConnPolicy'], ['faultInst', 'vnicWwnnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcOEIf": MoMeta("VnicFcOEIf", "vnicFcOEIf", "fcoe", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage"], ['vnicEther', 'vnicIpc', 'vnicLanConnTempl'], [], ["Get"]),
    "VnicIPv4Dhcp": MoMeta("VnicIPv4Dhcp", "vnicIPv4Dhcp", "ipv4-dhcp", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['adaptorHostIscsiIf', 'adaptorVlan', 'vnicIPv4If'], [], ["Add", "Get", "Remove"]),
    "VnicIPv4Dns": MoMeta("VnicIPv4Dns", "vnicIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorHostIscsiIf', 'adaptorVlan', 'vnicIPv4If', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr'], [], ["Get"]),
    "VnicIPv4If": MoMeta("VnicIPv4If", "vnicIPv4If", "ipv4", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicEtherIf', 'vnicIScsiBootVnic', 'vnicVlan'], ['fabricNetflowIPv4Addr', 'vnicIPv4Dhcp', 'vnicIPv4Dns', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr', 'vnicIPv4StaticRoute', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Add", "Get"]),
    "VnicIPv4IscsiAddr": MoMeta("VnicIPv4IscsiAddr", "vnicIPv4IscsiAddr", "ipv4iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['adaptorHostIscsiIf', 'adaptorVlan', 'vnicIPv4If', 'vnicIScsi'], ['vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4PooledIscsiAddr": MoMeta("VnicIPv4PooledIscsiAddr", "vnicIPv4PooledIscsiAddr", "ipv4-pooled-iscsiaddr", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['adaptorHostIscsiIf', 'adaptorVlan', 'vnicIPv4If'], ['faultInst', 'vnicIPv4Dns', 'vnicIpV4History'], ["Get", "Set"]),
    "VnicIPv4StaticRoute": MoMeta("VnicIPv4StaticRoute", "vnicIPv4StaticRoute", "ipv4-route-[addr]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorHostIscsiIf', 'adaptorVlan', 'vnicIPv4If'], [], ["Get"]),
    "VnicIPv6If": MoMeta("VnicIPv6If", "vnicIPv6If", "", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [], ['vnicIpV6StaticAddr'], [None]),
    "VnicIScsi": MoMeta("VnicIScsi", "vnicIScsi", "iscsi-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetflowMonSrcEp', 'faultInst', 'vnicIPv4IscsiAddr', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf', 'vnicIqnHistory', 'vnicMacHistory', 'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiAutoTargetIf": MoMeta("VnicIScsiAutoTargetIf", "vnicIScsiAutoTargetIf", "auto", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['adaptorVlan', 'vnicIScsi', 'vnicIScsiBootVnic', 'vnicVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootParams": MoMeta("VnicIScsiBootParams", "vnicIScsiBootParams", "iscsi-boot-params", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer'], ['vnicIScsiBootVnic'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootVnic": MoMeta("VnicIScsiBootVnic", "vnicIScsiBootVnic", "boot-vnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsiBootParams'], ['faultInst', 'vnicIPv4If', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiConfig": MoMeta("VnicIScsiConfig", "vnicIScsiConfig", "iscsi-vnic", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['vnicIScsiInitAutoConfigPolicy'], ['faultInst'], [None]),
    "VnicIScsiInitAutoConfigPolicy": MoMeta("VnicIScsiInitAutoConfigPolicy", "vnicIScsiInitAutoConfigPolicy", "iscsi-init-autoconf-[name]", VersionMeta.Version302c, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['vnicEthConfig', 'vnicIScsiConfig'], [None]),
    "VnicIScsiLCP": MoMeta("VnicIScsiLCP", "vnicIScsiLCP", "iscsi-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer', 'vnicLanConnPolicy'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetflowMonSrcEp', 'faultInst', 'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiNode": MoMeta("VnicIScsiNode", "vnicIScsiNode", "iscsi-node", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['lsServer', 'vnicLanConnPolicy'], ['faultInst', 'vnicIqnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiStaticTargetIf": MoMeta("VnicIScsiStaticTargetIf", "vnicIScsiStaticTargetIf", "[priority]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['adaptorVlan', 'vnicIScsi', 'vnicIScsiBootVnic', 'vnicVlan'], ['faultInst', 'vnicLun'], ["Add", "Get", "Remove", "Set"]),
    "VnicInternalProfile": MoMeta("VnicInternalProfile", "vnicInternalProfile", "vnic-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['vnicProfileSet'], ['swVlan'], ["Get"]),
    "VnicIpV4History": MoMeta("VnicIpV4History", "vnicIpV4History", "ipv4-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['vnicIPv4PooledIscsiAddr', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr'], [], [None]),
    "VnicIpV4MgmtPooledAddr": MoMeta("VnicIpV4MgmtPooledAddr", "vnicIpV4MgmtPooledAddr", "ipv4-pooled-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorHostIscsiIf', 'adaptorVlan', 'lsServer', 'mgmtVnet', 'vnicIPv4If'], ['faultInst', 'vnicIpV4History'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV4PooledAddr": MoMeta("VnicIpV4PooledAddr", "vnicIpV4PooledAddr", "ipv4-pooled-addr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorHostIscsiIf', 'adaptorVlan', 'lsServer', 'mgmtController', 'mgmtVnet', 'vnicIPv4If'], ['faultInst', 'vnicIpV4History'], ["Get"]),
    "VnicIpV4ProfDerivedAddr": MoMeta("VnicIpV4ProfDerivedAddr", "vnicIpV4ProfDerivedAddr", "ipv4-prof-addr", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], ['adaptorHostIscsiIf', 'adaptorVlan', 'mgmtController', 'vnicIPv4If'], [], ["Get"]),
    "VnicIpV4StaticAddr": MoMeta("VnicIpV4StaticAddr", "vnicIpV4StaticAddr", "ipv4-static-addr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorHostIscsiIf', 'adaptorVlan', 'lsServer', 'lsbootLanImagePath', 'mgmtController', 'mgmtVnet', 'vnicIPv4If'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6History": MoMeta("VnicIpV6History", "vnicIpV6History", "ipv6-history", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], ['vnicIpV6MgmtPooledAddr'], [], [None]),
    "VnicIpV6MgmtPooledAddr": MoMeta("VnicIpV6MgmtPooledAddr", "vnicIpV6MgmtPooledAddr", "ipv6-pooled-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtVnet'], ['faultInst', 'vnicIpV6History'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6StaticAddr": MoMeta("VnicIpV6StaticAddr", "vnicIpV6StaticAddr", "ipv6-static-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtVnet', 'vnicIPv6If'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpc": MoMeta("VnicIpc", "vnicIpc", "ipc-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetflowMonSrcEp', 'faultInst', 'vnicEtherIf', 'vnicFcOEIf', 'vnicLifVlan'], ["Get"]),
    "VnicIpcIf": MoMeta("VnicIpcIf", "vnicIpcIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicIqnHistory": MoMeta("VnicIqnHistory", "vnicIqnHistory", "iqn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['vnicIScsi', 'vnicIScsiNode'], [], [None]),
    "VnicLanConnPolicy": MoMeta("VnicLanConnPolicy", "vnicLanConnPolicy", "lan-conn-pol-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['orgOrg'], ['vnicEther', 'vnicIScsiLCP', 'vnicIScsiNode'], ["Add", "Get", "Remove"]),
    "VnicLanConnTempl": MoMeta("VnicLanConnTempl", "vnicLanConnTempl", "lan-conn-templ-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['orgOrg'], ['fabricNetGroupRef', 'fabricSanGroupRef', 'faultInst', 'vnicDynamicConPolicyRef', 'vnicEtherIf', 'vnicFcOEIf', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicLifVlan": MoMeta("VnicLifVlan", "vnicLifVlan", "vlan-[vnet]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vnicEther', 'vnicIpc'], [], ["Get"]),
    "VnicLifVsan": MoMeta("VnicLifVsan", "vnicLifVsan", "vsan-[vnet]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vnicFcLif'], [], ["Get"]),
    "VnicLun": MoMeta("VnicLun", "vnicLun", "lun", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['vnicIScsiStaticTargetIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicMacHistory": MoMeta("VnicMacHistory", "vnicMacHistory", "mac-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['vnicEther', 'vnicIScsi'], [], [None]),
    "VnicOProfileAlias": MoMeta("VnicOProfileAlias", "vnicOProfileAlias", "swid-[v_switch_name]alias-[alias]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], ['vmVnicProfInst', 'vnicProfile'], [], ["Get"]),
    "VnicProfile": MoMeta("VnicProfile", "vnicProfile", "vnic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['vnicProfileSet'], ['fabricNetGroupRef', 'fabricNetflowMonSrcEp', 'faultInst', 'swNetflowMonitorRef', 'vmVnicProfCl', 'vnicEtherIf', 'vnicOProfileAlias', 'vnicProfileAlias'], ["Add", "Get", "Remove", "Set"]),
    "VnicProfileAlias": MoMeta("VnicProfileAlias", "vnicProfileAlias", "uuid-[sw_uuid]alias-[alias]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], ['vmVnicProfInst', 'vnicProfile'], [], ["Get"]),
    "VnicProfileRef": MoMeta("VnicProfileRef", "vnicProfileRef", "vnic-profileref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "VnicProfileSet": MoMeta("VnicProfileSet", "vnicProfileSet", "profiles", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], ['eventInst', 'faultInst', 'vnicDynamicProvider', 'vnicInternalProfile', 'vnicProfile', 'vnicProfileSetFsm', 'vnicProfileSetFsmTask', 'vnicRackServerDiscoveryProfile'], ["Get"]),
    "VnicProfileSetFsm": MoMeta("VnicProfileSetFsm", "vnicProfileSetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['vnicProfileSet'], ['vnicProfileSetFsmStage'], [None]),
    "VnicProfileSetFsmStage": MoMeta("VnicProfileSetFsmStage", "vnicProfileSetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], ['vnicProfileSetFsm'], [], [None]),
    "VnicProfileSetFsmTask": MoMeta("VnicProfileSetFsmTask", "vnicProfileSetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], ['vnicProfileSet'], [], [None]),
    "VnicRackServerDiscoveryProfile": MoMeta("VnicRackServerDiscoveryProfile", "vnicRackServerDiscoveryProfile", "vnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis', 'vnicProfileSet'], ['swVlan'], [None]),
    "VnicSanConnPolicy": MoMeta("VnicSanConnPolicy", "vnicSanConnPolicy", "san-conn-pol-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['orgOrg'], ['storageIniGroup', 'vnicFc', 'vnicFcNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicSanConnTempl": MoMeta("VnicSanConnTempl", "vnicSanConnTempl", "san-conn-templ-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['fabricNetGroupRef', 'fabricSanGroupRef', 'faultInst', 'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicScsi": MoMeta("VnicScsi", "vnicScsi", "scsi-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricNetflowMonSrcEp', 'faultInst'], ["Get"]),
    "VnicScsiIf": MoMeta("VnicScsiIf", "vnicScsiIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [], [], ["Get"]),
    "VnicUsnicConPolicy": MoMeta("VnicUsnicConPolicy", "vnicUsnicConPolicy", "usnic-con-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-server"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicUsnicConPolicyRef": MoMeta("VnicUsnicConPolicyRef", "vnicUsnicConPolicyRef", "usnic-con-ref", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicVhbaBehPolicy": MoMeta("VnicVhbaBehPolicy", "vnicVhbaBehPolicy", "beh-vhba", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['orgOrg'], [], ["Get", "Set"]),
    "VnicVlan": MoMeta("VnicVlan", "vnicVlan", "vlan", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsi', 'vnicIScsiLCP'], ['vnicIPv4If', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf'], ["Add", "Get", "Set"]),
    "VnicVmqConPolicy": MoMeta("VnicVmqConPolicy", "vnicVmqConPolicy", "vmq-con-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-network", "ls-network-policy", "ls-server"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicyRef": MoMeta("VnicVmqConPolicyRef", "vnicVmqConPolicyRef", "vmq-con-ref", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicVnicBehPolicy": MoMeta("VnicVnicBehPolicy", "vnicVnicBehPolicy", "beh-vnic", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['orgOrg'], [], ["Get", "Set"]),
    "VnicWwnnHistory": MoMeta("VnicWwnnHistory", "vnicWwnnHistory", "wwnn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['vnicFcNode'], [], [None]),
    "VnicWwpnHistory": MoMeta("VnicWwpnHistory", "vnicWwpnHistory", "wwpn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], ['vnicFc'], [], [None]),
}


METHOD_CLASS_ID = frozenset([
    "AaaChangeSelfPassword",
    "AaaCheckComputeAuthToken",
    "AaaCheckComputeExtAccess",
    "AaaGetAuthTokenClient",
    "AaaGetAuthTokenInternal",
    "AaaGetKVMLaunchUrl",
    "AaaGetKVMLaunchUrlInternal",
    "AaaGetNComputeAuthTokenByDn",
    "AaaGetNComputeAuthTokenInternalByDn",
    "AaaKeepAlive",
    "AaaLogin",
    "AaaLogout",
    "AaaRefresh",
    "AaaSetupShellAccessInternal",
    "AaaTokenLogin",
    "AaaTokenRefresh",
    "ApeBootPnuOs",
    "ApeConfigureCMCLIF",
    "ApeCreateHVVnic",
    "ApeCreateSfish",
    "ApeCreateVMVnic",
    "ApeDeleteHVVnic",
    "ApeDeleteSfish",
    "ApeDeleteVMVnic",
    "ApeGetAdaptorConnectivity",
    "ApeGetApeFirmwareActiveSide",
    "ApeGetInventoryFromStorageRegistrar",
    "ApeGetIpFromSerial",
    "ApeGetMcStats",
    "ApeGetNextId",
    "ApeGetPnuOSInventory",
    "ApeGetServerFromIp",
    "ApeGetSwitchApeFru",
    "ApeInjectStimuli",
    "ApeInsertNewChassis",
    "ApeInsertNewFex",
    "ApeInsertNewRack",
    "ApeIssueAdaptorId",
    "ApeIssueChassisId",
    "ApeIssueFexId",
    "ApeIssueRackId",
    "ApeMcGet",
    "ApeMcGetAttribute",
    "ApeMcGetAttributeData",
    "ApeMcGetBiosTokens",
    "ApeMcGetFru",
    "ApeMcGetParam",
    "ApeMcGetReading",
    "ApeMcGetSdr",
    "ApeMcGetSmbios",
    "ApeMcSet",
    "ApeMcSetAttributeData",
    "ApeMcSetParam",
    "ApeMuxOffline",
    "ApeRemoveDevice",
    "ApeSetAdaptorFirmwareVersion",
    "ApeSetApeSensorReading",
    "ApeSetFlexFlashControllerFirmwareVersion",
    "ApeSetFlexFlashControllerState",
    "ApeSetFlexFlashVirtualRaidInformation",
    "ApeSetMcStats",
    "ApeSetServerLifeCycle",
    "ApeSetSwitchInventory",
    "ApeSetVmediaMounts",
    "ApeTriggerSwInv",
    "ApeUpdateApeFirmwareActiveSide",
    "ApeUpdateApeFirmwareParamTable",
    "ApeUpdateBIOSFirmwareVersion",
    "ApeUpdateServerAbsence",
    "ApeUpdateServerPresence",
    "ApeUpdateStorageCtlrFirmwareVersion",
    "ComputeGetInventory",
    "ConfigCheckCompatibility",
    "ConfigCheckConformance",
    "ConfigCheckFirmwareUpdatable",
    "ConfigConfFiltered",
    "ConfigConfMo",
    "ConfigConfMoGroup",
    "ConfigConfMos",
    "ConfigConfRename",
    "ConfigCountClass",
    "ConfigEstimateConfMos",
    "ConfigEstimateImpact",
    "ConfigFindDependencies",
    "ConfigFindDnsByClassId",
    "ConfigFindHostPackDependencies",
    "ConfigFindPackDependencies",
    "ConfigFindPermitted",
    "ConfigGetEstimateImpact",
    "ConfigGetRemotePolicies",
    "ConfigGetXmlFile",
    "ConfigGetXmlFileStr",
    "ConfigInstallAllImpact",
    "ConfigInstallChassisImpact",
    "ConfigMoChangeEvent",
    "ConfigRefreshIdentity",
    "ConfigReleaseResolveContext",
    "ConfigRenewResolveContext",
    "ConfigResolveChildren",
    "ConfigResolveChildrenSorted",
    "ConfigResolveClass",
    "ConfigResolveClassSorted",
    "ConfigResolveClasses",
    "ConfigResolveClassesSorted",
    "ConfigResolveContext",
    "ConfigResolveDn",
    "ConfigResolveDns",
    "ConfigResolveParent",
    "ConfigScope",
    "ConfigUpdateAllImpact",
    "EquipmentClone",
    "EquipmentInstantiateNNamedTemplate",
    "EquipmentInstantiateNTemplate",
    "EquipmentInstantiateTemplate",
    "EquipmentResolveTemplates",
    "EquipmentTemplatise",
    "EventRegisterEventChannel",
    "EventRegisterEventChannelResp",
    "EventSendEvent",
    "EventSendHeartbeat",
    "EventSubscribe",
    "EventUnRegisterEventChannel",
    "EventUnsubscribe",
    "FaultAckFault",
    "FaultAckFaults",
    "FaultResolveFault",
    "FsmDebugAction",
    "LoggingSyncOcns",
    "LsClone",
    "LsInstantiateNNamedTemplate",
    "LsInstantiateNTemplate",
    "LsInstantiateTemplate",
    "LsResolveTemplates",
    "LsTemplatise",
    "LstorageCreateZoningFromInv",
    "MethodResolveVessel",
    "MethodVessel",
    "MgmtResolveBackupFilenames",
    "OrgResolveElements",
    "OrgResolveLogicalParents",
    "PolicyResolveNames",
    "PolicySetCentraleStorage",
    "PoolResolveInScope",
    "StatsClearInterval",
    "StatsResolveThresholdPolicy",
    "StatsSubscribe",
    "SwatExample",
    "SwatGetstats",
    "SwatInject",
    "SyntheticFSObjInventory",
    "SyntheticFSObjInventoryB",
    "SyntheticTestTx",
    "TrigPerformTokenAction",
])


OTHER_TYPE_CLASS_ID = {
    "Method": "ucsbasetype",
    "MethodSet": "ucsbasetype",
    "AllbitsFilter": "ucsfiltertype",
    "AndFilter": "ucsfiltertype",
    "AnybitFilter": "ucsfiltertype",
    "BwFilter": "ucsfiltertype",
    "ClassId": "ucsbasetype",
    "ClassIdSet": "ucsbasetype",
    "ConfigConfig": "ucsbasetype",
    "ConfigMap": "ucsbasetype",
    "ConfigSet": "ucsbasetype",
    "Dn": "ucsbasetype",
    "DnSet": "ucsbasetype",
    "EqFilter": "ucsfiltertype",
    "FilterFilter": "ucsbasetype",
    "GeFilter": "ucsfiltertype",
    "GtFilter": "ucsfiltertype",
    "Id": "ucsbasetype",
    "IdSet": "ucsbasetype",
    "LeFilter": "ucsfiltertype",
    "LtFilter": "ucsfiltertype",
    "NeFilter": "ucsfiltertype",
    "NotFilter": "ucsfiltertype",
    "OrFilter": "ucsfiltertype",
    "Pair": "ucsbasetype",
    "WcardFilter": "ucsfiltertype",
}
