"""This module contains the general information for LsIssues ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class LsIssuesConsts:
    pass


class LsIssues(ManagedObject):
    """This is LsIssues class."""

    consts = LsIssuesConsts()
    naming_props = set([])

    mo_meta = MoMeta("LsIssues", "lsIssues", "config-issue", VersionMeta.Version221b, "InputOutput", 0x1f, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], ['faultInst'], ["Get"])

    prop_meta = {
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version221b, MoPropertyMeta.INTERNAL, 0x2, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []),
        "config_warnings": MoPropertyMeta("config_warnings", "configWarnings", "string", VersionMeta.Version222c, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|kvm-mgmt-policy-unsupported|incomplete-security-config|spdm-certificate-policy-unsupported),){0,4}(defaultValue|not-applicable|kvm-mgmt-policy-unsupported|incomplete-security-config|spdm-certificate-policy-unsupported){0,1}""", [], []),
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, 0x4, 0, 256, None, [], []),
        "iscsi_config_issues": MoPropertyMeta("iscsi_config_issues", "iscsiConfigIssues", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|static-target-mix|native-vlan|auto-target-auth|iscsi-config|missing-vlan|invalid-target-params|invalid-target-name|initiator-name|ip-addr-dhcp|init-target-passwd|auto-target-init|iscsi-initiator-ip-address|iqn-pool-name|vnic-name|no-luns|target-iscsilif-static-ip|unclassified|init-identity|target-name|no-vlan-ip|invalid-mac|iscsi-cardinality|allowed-vlan|internal-cfg-error|unresolvable-managed-target|auth-profile-same),){0,27}(defaultValue|not-applicable|static-target-mix|native-vlan|auto-target-auth|iscsi-config|missing-vlan|invalid-target-params|invalid-target-name|initiator-name|ip-addr-dhcp|init-target-passwd|auto-target-init|iscsi-initiator-ip-address|iqn-pool-name|vnic-name|no-luns|target-iscsilif-static-ip|unclassified|init-identity|target-name|no-vlan-ip|invalid-mac|iscsi-cardinality|allowed-vlan|internal-cfg-error|unresolvable-managed-target|auth-profile-same){0,1}""", [], []),
        "network_config_issues": MoPropertyMeta("network_config_issues", "networkConfigIssues", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|unsupported-dynamic-vnic-config|network-feature-capability-mismatch|switch-virtual-if-capacity|conflicting-vlan-access|unsupported-usnic-config|named-vlan-inaccessible|unsupported-multicast-policy|permit-unresolved|unsupported-vmq-config|vlan-port-capacity|pinning-invalid),){0,12}(defaultValue|not-applicable|unsupported-dynamic-vnic-config|network-feature-capability-mismatch|switch-virtual-if-capacity|conflicting-vlan-access|unsupported-usnic-config|named-vlan-inaccessible|unsupported-multicast-policy|permit-unresolved|unsupported-vmq-config|vlan-port-capacity|pinning-invalid){0,1}""", [], []),
        "prop_acl": MoPropertyMeta("prop_acl", "propAcl", "ulong", VersionMeta.Version302c, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []),
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, 0x8, 0, 256, None, [], []),
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302c, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []),
        "server_config_issues": MoPropertyMeta("server_config_issues", "serverConfigIssues", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|insufficient-power-budget|server-position-requirement|boot-configuration-unsupported|processor-type-bios-downgrade-restriction|unsupported-cimc-version-for-power-capping|template-unavailable|compute-undiscovered|power-group-requirement|imgsec-policy-invalid|soft-pinning-vlan-mismatch|embedded-controller-not-supported|power-state-change|missing-firmware-image|resource-ownership-conflict|boot-order-pxe|vmedia-policy-unsupported|on-next-boot-unsupported|hardware-inventory-mismatch-rack|insufficient-resources|mac-address-assignment|remote-service-profile|server-feature-capability-mismatch|boot-order-jbod-image-path|boot-dev-no-support|graphics-card-not-present|incompat-bios-for-sriov-vnics|processor-requirement|provsrv-policy-invalid|cimc-downgrade-restriction|unsupported-vic-slot|non-pre-emptive-fsm-running|board-controller-update-unsupported|non-interrupt-fsm-running|boot-order-san-image-path|bootip-policy-invalid|boot-policy-vmedia-invalid|server-type-bios-downgrade-restriction|second-controller-server-fw-downgrade-restriction|memory-requirement|system-uuid-assignment|domain-requirement|qualified-pool-without-binding|boot-order-bad-block-size|dual-sioc-server-fw-restriction|boot-configuration-invalid|incompatible-bios-image|remote-policy|qos-policy-invalid|processor-type-cimc-downgrade-restriction|unsupported-bios-for-tpm|graphics-card-mode-change-unsupported|compute-unavailable|physical-requirement|hostimg-policy-invalid|vmedia-mount-config-invalid|server-type-cimc-downgrade-restriction|server-feature-capability-mismatch-non-fatal|migration|wwnn-derivation-from-vhba|duplicate-address-conflict|unsupported-bios-for-vnic-cdn|boot-order-iscsi|hardware-inventory-mismatch-blade|max-value),){0,65}(defaultValue|not-applicable|insufficient-power-budget|server-position-requirement|boot-configuration-unsupported|processor-type-bios-downgrade-restriction|unsupported-cimc-version-for-power-capping|template-unavailable|compute-undiscovered|power-group-requirement|imgsec-policy-invalid|soft-pinning-vlan-mismatch|embedded-controller-not-supported|power-state-change|missing-firmware-image|resource-ownership-conflict|boot-order-pxe|vmedia-policy-unsupported|on-next-boot-unsupported|hardware-inventory-mismatch-rack|insufficient-resources|mac-address-assignment|remote-service-profile|server-feature-capability-mismatch|boot-order-jbod-image-path|boot-dev-no-support|graphics-card-not-present|incompat-bios-for-sriov-vnics|processor-requirement|provsrv-policy-invalid|cimc-downgrade-restriction|unsupported-vic-slot|non-pre-emptive-fsm-running|board-controller-update-unsupported|non-interrupt-fsm-running|boot-order-san-image-path|bootip-policy-invalid|boot-policy-vmedia-invalid|server-type-bios-downgrade-restriction|second-controller-server-fw-downgrade-restriction|memory-requirement|system-uuid-assignment|domain-requirement|qualified-pool-without-binding|boot-order-bad-block-size|dual-sioc-server-fw-restriction|boot-configuration-invalid|incompatible-bios-image|remote-policy|qos-policy-invalid|processor-type-cimc-downgrade-restriction|unsupported-bios-for-tpm|graphics-card-mode-change-unsupported|compute-unavailable|physical-requirement|hostimg-policy-invalid|vmedia-mount-config-invalid|server-type-cimc-downgrade-restriction|server-feature-capability-mismatch-non-fatal|migration|wwnn-derivation-from-vhba|duplicate-address-conflict|unsupported-bios-for-vnic-cdn|boot-order-iscsi|hardware-inventory-mismatch-blade|max-value){0,1}""", [], []),
        "server_extd_config_issues": MoPropertyMeta("server_extd_config_issues", "serverExtdConfigIssues", "string", VersionMeta.Version404a, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|fw-update-could-fail|hfp-backup-version-set|persistent-memory-end-point-mo-not-found|persistent-memory-operation-in-progess|persistent-memory-destructive-goal-config-and-data-loss|persistent-memory-policy-not-found|persistent-memory-security-key-not-matching|persistent-memory-namespace-mo-not-found|persistent-memory-not-enough-space-on-the-given-region|persistent-memory-destructive-namespace-config-and-data-loss|persistent-memory-dimms-not-present|persistent-memory-both-goal-and-security-config-modify-not-allowed|persistent-memory-region-not-found-on-given-socket|persistent-memory-not-enough-space-on-any-region|persistent-memory-force-goal-config-and-data-loss|persistent-memory-no-dimm-on-given-slot|persistent-memory-detection-server|persistent-memory-region-not-found-on-given-dimm-number|persistent-memory-operation-not-permitted|persistent-memory-force-namespace-config-and-data-loss|persistent-memory-configured-for-socket-gt-2),){0,22}(defaultValue|not-applicable|fw-update-could-fail|hfp-backup-version-set|persistent-memory-end-point-mo-not-found|persistent-memory-operation-in-progess|persistent-memory-destructive-goal-config-and-data-loss|persistent-memory-policy-not-found|persistent-memory-security-key-not-matching|persistent-memory-namespace-mo-not-found|persistent-memory-not-enough-space-on-the-given-region|persistent-memory-destructive-namespace-config-and-data-loss|persistent-memory-dimms-not-present|persistent-memory-both-goal-and-security-config-modify-not-allowed|persistent-memory-region-not-found-on-given-socket|persistent-memory-not-enough-space-on-any-region|persistent-memory-force-goal-config-and-data-loss|persistent-memory-no-dimm-on-given-slot|persistent-memory-detection-server|persistent-memory-region-not-found-on-given-dimm-number|persistent-memory-operation-not-permitted|persistent-memory-force-namespace-config-and-data-loss|persistent-memory-configured-for-socket-gt-2){0,1}""", [], []),
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version221b, MoPropertyMeta.READ_WRITE, 0x10, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []),
        "storage_config_issues": MoPropertyMeta("storage_config_issues", "storageConfigIssues", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|incomplete-drive-security-config|cimc-mgmt-not-configured|multiple-security-policies|sed-unsupported-server|jbod-disk-used-for-luns|no-deployed-key|bmc-certs-absent|flexflash-metadata|unsupported-disk-controller-config|unsupported-expand-to-available|unsupported-use-remaining-disks|unsupported-strip-size-change|zone-capacity|duplicated-lun-name|unsupported-hotspare-change|unsupported-vd-modification|invalid-disk-slot-ownership|disk-role-mismatch|missing-raid-key|orphaned-lun-ref-missing|virtual-drive-access-denied|unsupported-disk-slot-zoning|destructive-local-disk-config|storage-feature-capability-mismatch|insufficient-disks|conflicting-lun-config|unsupported-global-hotspares|drive-cache-not-supported|unsupported-chassis-disk-zoning|flexflash-controller|unsupported-controller|invalid-storage-profile-binding|lun-in-use|disk-sharing-not-supported|incompatible-disk-types|storage-path-configuration-error|disk-type-mismatch|orphaned-lun-ref-access-denied|virtual-drive-deletion-in-progress|unsupported-partial-disk-group-zoning|virtual-drive-hidden-or-transport-ready|unsupported-raid-level|incomplete-lun-config|unsupported-order|embedded-controller-not-supported|unsupported-security-operation|incompatible-number-of-local-disks|flexflash-card|unsupported-destructive-change|invalid-local-lun-disk-policy-reference|set-proper-order|unsupported-chassis-spare-controller|wwnn-assignment|unsupported-orphan-lun-modification|unsupported-lun-map-modification|unsupported-write-cache-policy|invalid-zoning-virtual-drive-state|invalid-zoning-disk-bootable|insufficient-storage-space|order-should-be-unique|virtual-drive-capacity|incompatible-raid-level|invalid-dzp-reference),){0,64}(defaultValue|not-applicable|incomplete-drive-security-config|cimc-mgmt-not-configured|multiple-security-policies|sed-unsupported-server|jbod-disk-used-for-luns|no-deployed-key|bmc-certs-absent|flexflash-metadata|unsupported-disk-controller-config|unsupported-expand-to-available|unsupported-use-remaining-disks|unsupported-strip-size-change|zone-capacity|duplicated-lun-name|unsupported-hotspare-change|unsupported-vd-modification|invalid-disk-slot-ownership|disk-role-mismatch|missing-raid-key|orphaned-lun-ref-missing|virtual-drive-access-denied|unsupported-disk-slot-zoning|destructive-local-disk-config|storage-feature-capability-mismatch|insufficient-disks|conflicting-lun-config|unsupported-global-hotspares|drive-cache-not-supported|unsupported-chassis-disk-zoning|flexflash-controller|unsupported-controller|invalid-storage-profile-binding|lun-in-use|disk-sharing-not-supported|incompatible-disk-types|storage-path-configuration-error|disk-type-mismatch|orphaned-lun-ref-access-denied|virtual-drive-deletion-in-progress|unsupported-partial-disk-group-zoning|virtual-drive-hidden-or-transport-ready|unsupported-raid-level|incomplete-lun-config|unsupported-order|embedded-controller-not-supported|unsupported-security-operation|incompatible-number-of-local-disks|flexflash-card|unsupported-destructive-change|invalid-local-lun-disk-policy-reference|set-proper-order|unsupported-chassis-spare-controller|wwnn-assignment|unsupported-orphan-lun-modification|unsupported-lun-map-modification|unsupported-write-cache-policy|invalid-zoning-virtual-drive-state|invalid-zoning-disk-bootable|insufficient-storage-space|order-should-be-unique|virtual-drive-capacity|incompatible-raid-level|invalid-dzp-reference){0,1}""", [], []),
        "vnic_config_issues": MoPropertyMeta("vnic_config_issues", "vnicConfigIssues", "string", VersionMeta.Version221b, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|unsupported-azurestackqos-geneve|adaptor-protected-eth-capability|vif-resources-overprovisioned|ungrouped-domain|unsupported-nvgre|unsupported-adaptor-for-vnic-cdn|misconfigured-net-san-group|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|unsupported-roce-netflow|unsupported-vxlan-netflow|redundancy-vnicpair-not-in-sync|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|vnic-virtualization-netflow-conflict|unsupported-vxlan-usnic|unsupported-roce-properties|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|missing-ipv4-inband-mgmt-addr|unsupported-nvgre-dynamic-vnic|duplicate-vnic-cdn-name|overlapping-vlans|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|unsupported-roce|unsupported-nvgre-netflow|unsupported-adaptor-for-vnic-oracle-rac|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unsupported-geneve-vmq-vmmq-arfs-roce-advfilters|soft-pinning-vlan-mismatch|unsupported-roce-sriov-vxlan|unsupported-nvgre-vmq|connection-placement|vnic-vcon-provisioning-change|missing-ipv6-inband-mgmt-addr|unsupported-nvgre-usnic|insufficient-roce-resources|unsupported-azurestackqos-vmmq-geneve-advfilters|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unsupported-vxlan|unsupported-roce-nvgre|unresolved-net-san-group|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|unsupported-roce-vmq|unsupported-nvgre-vxlan-vmq|redundancy-vnic-not-in-pair|dynamic-vf-vnic|wwpn-assignment|missing-ipv4-addr|unsupported-vxlan-dynamic-vnic|pinned-target-misconfig|unsupported-vmq-resources),){0,65}(defaultValue|not-applicable|unsupported-azurestackqos-geneve|adaptor-protected-eth-capability|vif-resources-overprovisioned|ungrouped-domain|unsupported-nvgre|unsupported-adaptor-for-vnic-cdn|misconfigured-net-san-group|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|unsupported-roce-netflow|unsupported-vxlan-netflow|redundancy-vnicpair-not-in-sync|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|vnic-virtualization-netflow-conflict|unsupported-vxlan-usnic|unsupported-roce-properties|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|missing-ipv4-inband-mgmt-addr|unsupported-nvgre-dynamic-vnic|duplicate-vnic-cdn-name|overlapping-vlans|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|unsupported-roce|unsupported-nvgre-netflow|unsupported-adaptor-for-vnic-oracle-rac|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unsupported-geneve-vmq-vmmq-arfs-roce-advfilters|soft-pinning-vlan-mismatch|unsupported-roce-sriov-vxlan|unsupported-nvgre-vmq|connection-placement|vnic-vcon-provisioning-change|missing-ipv6-inband-mgmt-addr|unsupported-nvgre-usnic|insufficient-roce-resources|unsupported-azurestackqos-vmmq-geneve-advfilters|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unsupported-vxlan|unsupported-roce-nvgre|unresolved-net-san-group|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|unsupported-roce-vmq|unsupported-nvgre-vxlan-vmq|redundancy-vnic-not-in-pair|dynamic-vf-vnic|wwpn-assignment|missing-ipv4-addr|unsupported-vxlan-dynamic-vnic|pinned-target-misconfig|unsupported-vmq-resources){0,1}""", [], []),
    }

    prop_map = {
        "childAction": "child_action", 
        "configWarnings": "config_warnings", 
        "dn": "dn", 
        "iscsiConfigIssues": "iscsi_config_issues", 
        "networkConfigIssues": "network_config_issues", 
        "propAcl": "prop_acl", 
        "rn": "rn", 
        "sacl": "sacl", 
        "serverConfigIssues": "server_config_issues", 
        "serverExtdConfigIssues": "server_extd_config_issues", 
        "status": "status", 
        "storageConfigIssues": "storage_config_issues", 
        "vnicConfigIssues": "vnic_config_issues", 
    }

    def __init__(self, parent_mo_or_dn, **kwargs):
        self._dirty_mask = 0
        self.child_action = None
        self.config_warnings = None
        self.iscsi_config_issues = None
        self.network_config_issues = None
        self.prop_acl = None
        self.sacl = None
        self.server_config_issues = None
        self.server_extd_config_issues = None
        self.status = None
        self.storage_config_issues = None
        self.vnic_config_issues = None

        ManagedObject.__init__(self, "LsIssues", parent_mo_or_dn, **kwargs)
