"""This module contains the general information for FaultSuppressPolicyItem ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class FaultSuppressPolicyItemConsts:
    CAUSE_CHASSIS_PROFILE_ASSIGNED = "ChassisProfile-assigned"
    CAUSE_CHASSIS_PROFILE_ASSOCIATED = "ChassisProfile-associated"
    CAUSE_CHASSIS_PROFILE_ASSOCIATING = "ChassisProfile-associating"
    CAUSE_CHASSIS_PROFILE_DEASSOCIATING = "ChassisProfile-deassociating"
    CAUSE_CHASSIS_PROFILE_UNASSIGNED = "ChassisProfile-unassigned"
    CAUSE_CHASSIS_PROFILE_UNASSOCIATED = "ChassisProfile-unassociated"
    CAUSE_A_FAILED = "a-failed"
    CAUSE_ACTIVATE_ADAPTOR_FAILED = "activate-adaptor-failed"
    CAUSE_ACTIVATE_ADAPTOR_NW_FW_LOCAL_FAILED = "activate-adaptor-nw-fw-local-failed"
    CAUSE_ACTIVATE_ADAPTOR_NW_FW_PEER_FAILED = "activate-adaptor-nw-fw-peer-failed"
    CAUSE_ACTIVATE_BIOS_FAILED = "activate-bios-failed"
    CAUSE_ACTIVATE_BRD_CTLR_FAILED = "activate-brd-ctlr-failed"
    CAUSE_ACTIVATE_CATALOG_FAILED = "activate-catalog-failed"
    CAUSE_ACTIVATE_CMC_FAILED = "activate-cmc-failed"
    CAUSE_ACTIVATE_FAILED = "activate-failed"
    CAUSE_ACTIVATE_LOCAL_DISK_FAILED = "activate-local-disk-failed"
    CAUSE_ACTIVATE_LOCAL_FAILED = "activate-local-failed"
    CAUSE_ACTIVATE_LOCALFI_FAILED = "activate-localfi-failed"
    CAUSE_ACTIVATE_PEER_FAILED = "activate-peer-failed"
    CAUSE_ACTIVATE_PSU_FAILED = "activate-psu-failed"
    CAUSE_ACTIVATE_REMOTE_FAILED = "activate-remote-failed"
    CAUSE_ACTIVATE_REMOTEFI_FAILED = "activate-remotefi-failed"
    CAUSE_ACTIVATE_SAS_EXPANDER_FAILED = "activate-sas-expander-failed"
    CAUSE_ACTIVATE_STORAGE_CTLR_FAILED = "activate-storage-ctlr-failed"
    CAUSE_ACTIVATEIBMCFW_FAILED = "activateibmcfw-failed"
    CAUSE_ACTIVATEIOM_FAILED = "activateiom-failed"
    CAUSE_ACTIVATEUCSM_FAILED = "activateucsm-failed"
    CAUSE_ACTIVATEUCSMSERVICE_PACK_FAILED = "activateucsmservice-pack-failed"
    CAUSE_ACTIVATION_FAILED = "activation-failed"
    CAUSE_ACTIVE_FAILED = "active-failed"
    CAUSE_ADAPTOR_MISMATCH = "adaptor-mismatch"
    CAUSE_ANALYZE_IMPACT_FAILED = "analyze-impact-failed"
    CAUSE_ANOTHER_CONNECTION_ALREADY_ENABLED = "another-connection-already-enabled"
    CAUSE_ANY = "any"
    CAUSE_APPLY_CATALOG_FAILED = "apply-catalog-failed"
    CAUSE_APPLY_CONFIG_FAILED = "apply-config-failed"
    CAUSE_APPLY_DEFAULT_IDENTIFIERS_FAILED = "apply-default-identifiers-failed"
    CAUSE_APPLY_FAILED = "apply-failed"
    CAUSE_APPLY_IDENTIFIERS_FAILED = "apply-identifiers-failed"
    CAUSE_APPLY_MAINT_CONFIG_FAILED = "apply-maint-config-failed"
    CAUSE_APPLY_MO_PROPS_FAILED = "apply-mo-props-failed"
    CAUSE_APPLY_PHYSICAL_FAILED = "apply-physical-failed"
    CAUSE_APPLY_POLICIES_FAILED = "apply-policies-failed"
    CAUSE_APPLY_TEMPLATE_FAILED = "apply-template-failed"
    CAUSE_ARP_TARGETS_CONFIG_ERROR = "arp-targets-config-error"
    CAUSE_ASSERT_BYPASS_WAIT_FAILED = "assert-bypass-wait-failed"
    CAUSE_ASSIGNMENT_FAILED = "assignment-failed"
    CAUSE_ASSOCIATION_FAILED = "association-failed"
    CAUSE_AUTO_FIRMWARE_UPGRADE = "auto-firmware-upgrade"
    CAUSE_B_FAILED = "b-failed"
    CAUSE_BACKPLANE_PORT_PROBLEM = "backplane-port-problem"
    CAUSE_BACKUP_LOCAL_FAILED = "backup-local-failed"
    CAUSE_BEGIN_FAILED = "begin-failed"
    CAUSE_BEGIN_INVENTORY_FAILED = "begin-inventory-failed"
    CAUSE_BIOS_IMG_UPDATE_FAILED = "bios-img-update-failed"
    CAUSE_BIOS_POST_COMPLETION_FAILED = "bios-post-completion-failed"
    CAUSE_BLADE_BOOT_PNUOS_FAILED = "blade-boot-pnuos-failed"
    CAUSE_BLADE_BOOT_WAIT_FAILED = "blade-boot-wait-failed"
    CAUSE_BLADE_POWER_OFF_FAILED = "blade-power-off-failed"
    CAUSE_BLADE_POWER_ON_FAILED = "blade-power-on-failed"
    CAUSE_BLADE_READ_SMBIOS_FAILED = "blade-read-smbios-failed"
    CAUSE_BMC_CONFIG_PNUOS_FAILED = "bmc-config-pnuos-failed"
    CAUSE_BMC_CONFIGURE_CONN_LOCAL_FAILED = "bmc-configure-conn-local-failed"
    CAUSE_BMC_CONFIGURE_CONN_PEER_FAILED = "bmc-configure-conn-peer-failed"
    CAUSE_BMC_FACTORY_RESET_FAILED = "bmc-factory-reset-failed"
    CAUSE_BMC_INVENTORY_FAILED = "bmc-inventory-failed"
    CAUSE_BMC_PRE_CONFIG_PNUOSLOCAL_FAILED = "bmc-pre-config-pnuoslocal-failed"
    CAUSE_BMC_PRE_CONFIG_PNUOSPEER_FAILED = "bmc-pre-config-pnuospeer-failed"
    CAUSE_BMC_PRECONFIG_PNUOSLOCAL_FAILED = "bmc-preconfig-pnuoslocal-failed"
    CAUSE_BMC_PRECONFIG_PNUOSPEER_FAILED = "bmc-preconfig-pnuospeer-failed"
    CAUSE_BMC_PRESENCE_FAILED = "bmc-presence-failed"
    CAUSE_BMC_SHUTDOWN_DISCOVERED_FAILED = "bmc-shutdown-discovered-failed"
    CAUSE_BMC_UNCONFIG_PNUOS_FAILED = "bmc-unconfig-pnuos-failed"
    CAUSE_BOARD_CTRL_UPGRADED = "board-ctrl-upgraded"
    CAUSE_BOOT_HOST_FAILED = "boot-host-failed"
    CAUSE_BOOT_PNUOS_FAILED = "boot-pnuos-failed"
    CAUSE_BOOT_WAIT_FAILED = "boot-wait-failed"
    CAUSE_CALCULATE_VLAN_GROUP_FOR_HOSTOSLOCAL_FAILED = "calculate-vlan-group-for-hostoslocal-failed"
    CAUSE_CALCULATE_VLAN_GROUP_FOR_HOSTOSPEER_FAILED = "calculate-vlan-group-for-hostospeer-failed"
    CAUSE_CALLHOME_CONFIG_ERROR = "callhome-config-error"
    CAUSE_CAPACITY_EXCEEDED = "capacity-exceeded"
    CAUSE_CARTRIDGE_MOVED = "cartridge-moved"
    CAUSE_CERTIFICATE_EMPTY_PARAMS = "certificate-empty-params"
    CAUSE_CERTIFICATE_UNSUPPORTED = "certificate-unsupported"
    CAUSE_CHASSIS_INTRUSION = "chassis-intrusion"
    CAUSE_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
    CAUSE_CHASSIS_PEER_ADAPTER_REBOOT_FAILED = "chassis-peer-adapter-reboot-failed"
    CAUSE_CHECK_ADAPTOR_FW40GCAP_FAILED = "check-adaptor-fw40gcap-failed"
    CAUSE_CHECK_ASSIGNED_DEFAULT_IDENTIFIERS_FOR_DUP_FAILED = "check-assigned-default-identifiers-for-dup-failed"
    CAUSE_CHECK_ASSIGNED_IDENTIFIERS_FOR_DUP_FAILED = "check-assigned-identifiers-for-dup-failed"
    CAUSE_CHECK_INVENTORY_STATUS_FAILED = "check-inventory-status-failed"
    CAUSE_CHECK_LICENSE_FAILED = "check-license-failed"
    CAUSE_CHECK_POWER_AVAILABILITY_FAILED = "check-power-availability-failed"
    CAUSE_CHECK_STATUS_FAILED = "check-status-failed"
    CAUSE_CIMC_FIRMWARE_MISMATCH = "cimc-firmware-mismatch"
    CAUSE_CIMC_PRESENCE_FAILED = "cimc-presence-failed"
    CAUSE_CIMCVLAN_CFG_LOCAL_FAILED = "cimcvlan-cfg-local-failed"
    CAUSE_CIMCVLAN_CFG_PEER_FAILED = "cimcvlan-cfg-peer-failed"
    CAUSE_CISCOOSOPEN_GATE_FAILED = "ciscoosopen-gate-failed"
    CAUSE_CLEAN_OLD_DATA_FAILED = "clean-old-data-failed"
    CAUSE_CLEAN_UPVIFS_FAILED = "clean-upvifs-failed"
    CAUSE_CLEANUP_ENTRIES_FAILED = "cleanup-entries-failed"
    CAUSE_CLEANUP_FAILED = "cleanup-failed"
    CAUSE_CLEANUP_LOCAL_FAILED = "cleanup-local-failed"
    CAUSE_CLEANUP_NIC_CONFIG_LOCAL_FAILED = "cleanup-nic-config-local-failed"
    CAUSE_CLEANUP_NIC_CONFIG_PEER_FAILED = "cleanup-nic-config-peer-failed"
    CAUSE_CLEANUP_PEER_FAILED = "cleanup-peer-failed"
    CAUSE_CLEANUP_PORT_CONFIG_LOCAL_FAILED = "cleanup-port-config-local-failed"
    CAUSE_CLEANUP_PORT_CONFIG_PEER_FAILED = "cleanup-port-config-peer-failed"
    CAUSE_CLEANUP_VNICS_LOCAL_FAILED = "cleanup-vnics-local-failed"
    CAUSE_CLEANUP_VNICS_PEER_FAILED = "cleanup-vnics-peer-failed"
    CAUSE_CLEANUPCIMC_FAILED = "cleanupcimc-failed"
    CAUSE_CLEAR_BIOS_UPDATE_FAILED = "clear-bios-update-failed"
    CAUSE_CLEAR_FAILED = "clear-failed"
    CAUSE_CLIENT_LOST_CONNECTIVITY = "client-lost-connectivity"
    CAUSE_CMC_VIF_DOWN = "cmc-vif-down"
    CAUSE_CMCVLAN_CFG_FAILED = "cmcvlan-cfg-failed"
    CAUSE_CMCVLAN_CFG_PEER_FAILED = "cmcvlan-cfg-peer-failed"
    CAUSE_COMM_SVC_CONFIG_ERROR = "comm-svc-config-error"
    CAUSE_COMMIT_STORAGE_FAILED = "commit-storage-failed"
    CAUSE_COMPLETE_FAILED = "complete-failed"
    CAUSE_COMPR_SETS_EXHAUSTED = "compr-sets-exhausted"
    CAUSE_CONDITION_CAUSE_CONFIGURATION_FAILURE = "condition-cause-configuration-failure"
    CAUSE_CONDITION_CAUSE_FAULT = "condition-cause-fault"
    CAUSE_CONDITION_CAUSE_HARDWARE_INVENTORY_MISMATCH = "condition-cause-hardware-inventory-mismatch"
    CAUSE_CONDITION_CAUSE_KERNEL_MEM_CRITICAL_THRESHOLD = "condition-cause-kernel-mem-critical-threshold"
    CAUSE_CONDITION_CAUSE_PCI_CONFIG_MISMATCH = "condition-cause-pci-config-mismatch"
    CAUSE_CONDITION_CAUSE_PERSISTENT_MEMORY_DETECTION = "condition-cause-persistent-memory-detection"
    CAUSE_CONFIG_BACKUP_OUTDATED = "config-backup-outdated"
    CAUSE_CONFIG_BIOS_FAILED = "config-bios-failed"
    CAUSE_CONFIG_CHASSIS_ADAPTER_CONNECTIVITY_FAILED = "config-chassis-adapter-connectivity-failed"
    CAUSE_CONFIG_CHASSIS_ID_FAILED = "config-chassis-id-failed"
    CAUSE_CONFIG_CIMCVMEDIA_FAILED = "config-cimcvmedia-failed"
    CAUSE_CONFIG_DISCOVERY_MODE_FAILED = "config-discovery-mode-failed"
    CAUSE_CONFIG_ERROR = "config-error"
    CAUSE_CONFIG_EXT_MGMT_GW_FAILED = "config-ext-mgmt-gw-failed"
    CAUSE_CONFIG_EXT_MGMT_RULES_FAILED = "config-ext-mgmt-rules-failed"
    CAUSE_CONFIG_FAILED = "config-failed"
    CAUSE_CONFIG_FAN_SPEED_FAILED = "config-fan-speed-failed"
    CAUSE_CONFIG_FE_LOCAL_FAILED = "config-fe-local-failed"
    CAUSE_CONFIG_FE_PEER_FAILED = "config-fe-peer-failed"
    CAUSE_CONFIG_FLEX_FLASH_FAILED = "config-flex-flash-failed"
    CAUSE_CONFIG_FLEX_FLASH_SCRUB_FAILED = "config-flex-flash-scrub-failed"
    CAUSE_CONFIG_HOST_OS_ANNOTATIONS_FAILED = "config-host-os-annotations-failed"
    CAUSE_CONFIG_KVM_MGMT_DEFAULT_SETTING_FAILED = "config-kvm-mgmt-default-setting-failed"
    CAUSE_CONFIG_MEMORY_POLICY_FAILED = "config-memory-policy-failed"
    CAUSE_CONFIG_MGMT_IP_RULES_FAILED = "config-mgmt-ip-rules-failed"
    CAUSE_CONFIG_MISMATCH = "config-mismatch"
    CAUSE_CONFIG_MISSING = "config-missing"
    CAUSE_CONFIG_NIV_MODE_FAILED = "config-niv-mode-failed"
    CAUSE_CONFIG_PROBLEM = "config-problem"
    CAUSE_CONFIG_SERVER_IDENTITY_FAILED = "config-server-identity-failed"
    CAUSE_CONFIG_SO_LFAILED = "config-so-lfailed"
    CAUSE_CONFIG_SW_AFAILED = "config-sw-afailed"
    CAUSE_CONFIG_SW_BFAILED = "config-sw-bfailed"
    CAUSE_CONFIG_SWITCH_LOCAL_FAILED = "config-switch-local-failed"
    CAUSE_CONFIG_SWITCH_PEER_FAILED = "config-switch-peer-failed"
    CAUSE_CONFIG_USER_ACCESS_FAILED = "config-user-access-failed"
    CAUSE_CONFIG_UUID_FAILED = "config-uuid-failed"
    CAUSE_CONFIGBMCPOWER_PARAMS_FAILED = "configbmcpower-params-failed"
    CAUSE_CONFIGURATION_APPLIED = "configuration-applied"
    CAUSE_CONFIGURATION_APPLYING = "configuration-applying"
    CAUSE_CONFIGURATION_ERROR = "configuration-error"
    CAUSE_CONFIGURATION_FAILED = "configuration-failed"
    CAUSE_CONFIGURATION_FAILURE = "configuration-failure"
    CAUSE_CONFIGURATION_IN_PROGRESS = "configuration-in-progress"
    CAUSE_CONFIGURATION_MISMATCH = "configuration-mismatch"
    CAUSE_CONFIGURATION_NOT_APPLIED = "configuration-not-applied"
    CAUSE_CONFIGURE_END_POINT_FAILED = "configure-end-point-failed"
    CAUSE_CONFIGURE_FAILED = "configure-failed"
    CAUSE_CONFIGURE_SW_MGMT_END_POINT_FAILED = "configure-sw-mgmt-end-point-failed"
    CAUSE_CONFIGURE_VIF_NS_FAILED = "configure-vif-ns-failed"
    CAUSE_CONNECTION_UNUSED = "connection-unused"
    CAUSE_CONNECTIVITY_PROBLEM = "connectivity-problem"
    CAUSE_COPY_ALL_IMAGES_TO_PEER_FAILED = "copy-all-images-to-peer-failed"
    CAUSE_COPY_CAT_FROM_REP_FAILED = "copy-cat-from-rep-failed"
    CAUSE_COPY_EXTERNAL_REP_TO_REMOTE_FAILED = "copy-external-rep-to-remote-failed"
    CAUSE_COPY_IMG_FROM_REP_FAILED = "copy-img-from-rep-failed"
    CAUSE_COPY_PRIMARY_FAILED = "copy-primary-failed"
    CAUSE_COPY_REMOTE_FAILED = "copy-remote-failed"
    CAUSE_COPY_SUB_FAILED = "copy-sub-failed"
    CAUSE_COPYIOMIMG_TO_SUB_FAILED = "copyiomimg-to-sub-failed"
    CAUSE_CREATE_LOCAL_FAILED = "create-local-failed"
    CAUSE_CREATE_REMOTE_FAILED = "create-remote-failed"
    CAUSE_DEASSERT_RESET_BYPASS_FAILED = "deassert-reset-bypass-failed"
    CAUSE_DECOMISSION_FAILED = "decomission-failed"
    CAUSE_DECOMMISSIONED = "decommissioned"
    CAUSE_DEFAULT_HOSTPACK_MISSING = "default-hostpack-missing"
    CAUSE_DEFAULT_HOSTPACK_MISSING_VERSIONS = "default-hostpack-missing-versions"
    CAUSE_DEFAULTAUTH_CONFIG_ERROR = "defaultauth-config-error"
    CAUSE_DELETE_ALL_MO_REFS_FAILED = "delete-all-mo-refs-failed"
    CAUSE_DELETE_CURL_DOWNLOADED_IMAGES_FAILED = "delete-curl-downloaded-images-failed"
    CAUSE_DELETE_IMAGES_REMOTE_FAILED = "delete-images-remote-failed"
    CAUSE_DELETE_LOCAL_FAILED = "delete-local-failed"
    CAUSE_DELETE_PRIMARY_FAILED = "delete-primary-failed"
    CAUSE_DELETE_REMOTE_FAILED = "delete-remote-failed"
    CAUSE_DELETE_SUB_FAILED = "delete-sub-failed"
    CAUSE_DEPLOY_FAILED = "deploy-failed"
    CAUSE_DEPRECATED = "deprecated"
    CAUSE_DEVICE_SHARED_STORAGE_IO_ERROR = "device-shared-storage-IO-error"
    CAUSE_DEVICE_SHARED_STORAGE_ERROR = "device-shared-storage-error"
    CAUSE_DISABLE_AFAILED = "disable-afailed"
    CAUSE_DISABLE_BFAILED = "disable-bfailed"
    CAUSE_DISABLE_END_POINT_FAILED = "disable-end-point-failed"
    CAUSE_DISABLE_FAILED = "disable-failed"
    CAUSE_DISABLE_SCRIPTABLEVMEDIA_FAILED = "disable-scriptablevmedia-failed"
    CAUSE_DISASSOCIATION_FAILED = "disassociation-failed"
    CAUSE_DISCOVER_CHASSIS_FAILED = "discover-chassis-failed"
    CAUSE_DISCOVER_SAS_EXPANDER_FAILED = "discover-sas-expander-failed"
    CAUSE_DISCOVERY_FAILED = "discovery-failed"
    CAUSE_DISCOVERY_IN_PROGRESS = "discovery-in-progress"
    CAUSE_DISK_ZONING_CONFIG_FAILED = "disk-zoning-config-failed"
    CAUSE_DOMAIN_CONFIG_ERROR = "domain-config-error"
    CAUSE_DOWNLOAD_IMAGES_FAILED = "download-images-failed"
    CAUSE_DOWNLOAD_LOCAL_FAILED = "download-local-failed"
    CAUSE_DUPLICATED_ASSIGNED = "duplicated-assigned"
    CAUSE_DVIF_EXHAUSTED = "dvif-exhausted"
    CAUSE_ELECTION_FAILURE = "election-failure"
    CAUSE_EMPTY_PIN_GROUP = "empty-pin-group"
    CAUSE_EMPTY_POOL = "empty-pool"
    CAUSE_ENABLE_AFAILED = "enable-afailed"
    CAUSE_ENABLE_BFAILED = "enable-bfailed"
    CAUSE_ENABLE_CHASSIS_FAILED = "enable-chassis-failed"
    CAUSE_ENABLE_FAILED = "enable-failed"
    CAUSE_ENABLE_PORT_FAILED = "enable-port-failed"
    CAUSE_END_INVENTORY_FAILED = "end-inventory-failed"
    CAUSE_EQUIPMENT_ACCESSIBILITY_PROBLEM = "equipment-accessibility-problem"
    CAUSE_EQUIPMENT_CONFIG_ERROR = "equipment-config-error"
    CAUSE_EQUIPMENT_CONFIG_NOT_MATCHING = "equipment-config-not-matching"
    CAUSE_EQUIPMENT_DEGRADED = "equipment-degraded"
    CAUSE_EQUIPMENT_DEPRECATED = "equipment-deprecated"
    CAUSE_EQUIPMENT_DISABLED = "equipment-disabled"
    CAUSE_EQUIPMENT_DISCONNECTED = "equipment-disconnected"
    CAUSE_EQUIPMENT_FAILED = "equipment-failed"
    CAUSE_EQUIPMENT_FRU_MISSING = "equipment-fru-missing"
    CAUSE_EQUIPMENT_HDDSLOT_SERVER2_OWNERSHIP_UNASSIGNED = "equipment-hddslot-server2-ownership-unassigned"
    CAUSE_EQUIPMENT_HOTSPARE_UNSUPPORTED = "equipment-hotspare-unsupported"
    CAUSE_EQUIPMENT_INACCESSIBLE = "equipment-inaccessible"
    CAUSE_EQUIPMENT_INOPERABLE = "equipment-inoperable"
    CAUSE_EQUIPMENT_INVENTORY = "equipment-inventory"
    CAUSE_EQUIPMENT_IOE_OWNERSHIP_UNASSIGNED = "equipment-ioe-ownership-unassigned"
    CAUSE_EQUIPMENT_LINK_DEGRADED = "equipment-link-degraded"
    CAUSE_EQUIPMENT_LINK_MISCONNECT = "equipment-link-misconnect"
    CAUSE_EQUIPMENT_MISSING = "equipment-missing"
    CAUSE_EQUIPMENT_NAMESPACE_NOT_MATCHING = "equipment-namespace-not-matching"
    CAUSE_EQUIPMENT_NON_OPTIMAL = "equipment-non-optimal"
    CAUSE_EQUIPMENT_OFFLINE = "equipment-offline"
    CAUSE_EQUIPMENT_OWNERSHIP_UNSUPPORTED = "equipment-ownership-unsupported"
    CAUSE_EQUIPMENT_PROBLEM = "equipment-problem"
    CAUSE_EQUIPMENT_REMOVED = "equipment-removed"
    CAUSE_EQUIPMENT_SECOND_CONTROLLER_ABSENT = "equipment-second-controller-absent"
    CAUSE_EQUIPMENT_UNACKNOWLEDGED = "equipment-unacknowledged"
    CAUSE_EQUIPMENT_UNAVAILABLE = "equipment-unavailable"
    CAUSE_EQUIPMENT_UNHEALTHY = "equipment-unhealthy"
    CAUSE_EQUIPPED_UNSUPPORTED = "equipped-unsupported"
    CAUSE_ESTIMATE_APPLY_CONFIG_FAILED = "estimate-apply-config-failed"
    CAUSE_EVALUATE_ASSOCIATION_FAILED = "evaluate-association-failed"
    CAUSE_EVALUATE_STATUS_FAILED = "evaluate-status-failed"
    CAUSE_EXECUTE_AFAILED = "execute-afailed"
    CAUSE_EXECUTE_BFAILED = "execute-bfailed"
    CAUSE_EXECUTE_FAILED = "execute-failed"
    CAUSE_EXECUTE_LOCAL_FAILED = "execute-local-failed"
    CAUSE_EXECUTE_PEER_FAILED = "execute-peer-failed"
    CAUSE_EXECUTEPMACTION_FAILED = "executepmaction-failed"
    CAUSE_EXECUTEVDACTION_FAILED = "executevdaction-failed"
    CAUSE_EXTRA_PRIMARY_VLANS = "extra-primary-vlans"
    CAUSE_EXTRA_SECONDARY_VLANS = "extra-secondary-vlans"
    CAUSE_EXTRA_SECONDARY_VLANS_PER_PRIMARY = "extra-secondary-vlans-per-primary"
    CAUSE_EXTRA_VIF = "extra-vif"
    CAUSE_FAB_EVAC_OFF_REMOTEFI_FAILED = "fab-evac-off-remotefi-failed"
    CAUSE_FAB_EVAC_ON_REMOTEFI_FAILED = "fab-evac-on-remotefi-failed"
    CAUSE_FABRIC_EVACUATED = "fabric-evacuated"
    CAUSE_FAIL_FAILED = "fail-failed"
    CAUSE_FAIL_OVER_TO_REMOTEFI_FAILED = "fail-over-to-remotefi-failed"
    CAUSE_FAN_REMOVAL = "fan-removal"
    CAUSE_FAULT = "fault"
    CAUSE_FC_PORTCHANNEL_MEMBERS_INCONSISTENT_SPEED = "fc-portchannel-members-inconsistent-speed"
    CAUSE_FC_STORAGEPORT_NPV_MODE = "fc-storageport-npv-mode"
    CAUSE_FC_ZONING_ENABLED = "fc-zoning-enabled"
    CAUSE_FCOE_STORAGEPORT_NPV_MODE = "fcoe-storageport-npv-mode"
    CAUSE_FCOE_UPLINK_PORT_CHANNEL_UNSUPPORTED_FI_SETTINGS = "fcoe-uplink-port-channel-unsupported-fi-settings"
    CAUSE_FCOE_UPLINK_UNSUPPORTED_FI_SETTINGS = "fcoe-uplink-unsupported-fi-settings"
    CAUSE_FEX_UNSUPPORTED = "fex-unsupported"
    CAUSE_FI_B_QUERIER_IP_EMPTY_OR_SAME_AS_PRIMARY = "fi-b-querier-ip-empty-or-same-as-primary"
    CAUSE_FILE_TRANSFER_FAILED = "file-transfer-failed"
    CAUSE_FINALIZE_FAILED = "finalize-failed"
    CAUSE_FIRMWARE_UPGRADE_PROBLEM = "firmware-upgrade-problem"
    CAUSE_FORMAT_FAILED = "format-failed"
    CAUSE_FRU_PROBLEM = "fru-problem"
    CAUSE_FSM_FAILED = "fsm-failed"
    CAUSE_FULL_INVENTORY_FAILED = "full-inventory-failed"
    CAUSE_GET_VERSION_FAILED = "get-version-failed"
    CAUSE_GRAPHICS_IMAGE_UPDATE_FAILED = "graphics-image-update-failed"
    CAUSE_GROUP_CAP_INSUFFICIENT = "group-cap-insufficient"
    CAUSE_GROUP_PERMIT_UNRESOLVED = "group-permit-unresolved"
    CAUSE_HA_NOT_READY = "ha-not-ready"
    CAUSE_HA_SSH_KEYS_MISMATCHED = "ha-ssh-keys-mismatched"
    CAUSE_HAG_CONNECT_FAILED = "hag-connect-failed"
    CAUSE_HAG_DISCONNECT_FAILED = "hag-disconnect-failed"
    CAUSE_HAG_HOSTOSCONNECT_FAILED = "hag-hostosconnect-failed"
    CAUSE_HAG_PNUOSCONNECT_FAILED = "hag-pnuosconnect-failed"
    CAUSE_HAG_PNUOSDISCONNECT_FAILED = "hag-pnuosdisconnect-failed"
    CAUSE_HANDLE_POOLING_FAILED = "handle-pooling-failed"
    CAUSE_HARDWARE_INVENTORY_MISMATCH = "hardware-inventory-mismatch"
    CAUSE_HARDWARE_MISMATCH = "hardware-mismatch"
    CAUSE_HBA_IMG_UPDATE_FAILED = "hba-img-update-failed"
    CAUSE_HEALTH_CRITICAL = "health-critical"
    CAUSE_HEALTH_INFO = "health-info"
    CAUSE_HEALTH_LED_AMBER = "health-led-amber"
    CAUSE_HEALTH_LED_AMBER_BLINKING = "health-led-amber-blinking"
    CAUSE_HEALTH_MAJOR = "health-major"
    CAUSE_HEALTH_MINOR = "health-minor"
    CAUSE_HEALTH_WARNING = "health-warning"
    CAUSE_HOSTOSCONFIG_FAILED = "hostosconfig-failed"
    CAUSE_HOSTOSCONNECT_FAILED = "hostosconnect-failed"
    CAUSE_HOSTOSIDENT_FAILED = "hostosident-failed"
    CAUSE_HOSTOSPOLICY_FAILED = "hostospolicy-failed"
    CAUSE_HOSTOSVALIDATE_FAILED = "hostosvalidate-failed"
    CAUSE_IDENTIFY_FAILED = "identify-failed"
    CAUSE_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
    CAUSE_IFTMC_PV_EXHAUSTED = "iftmc-pv-exhausted"
    CAUSE_IGMP_GROUP_EXHAUSTED = "igmp-group-exhausted"
    CAUSE_IMAGE_CANNOT_BOOT = "image-cannot-boot"
    CAUSE_IMAGE_CORRUPTED = "image-corrupted"
    CAUSE_IMAGE_DELETED = "image-deleted"
    CAUSE_IMAGE_UNUSABLE = "image-unusable"
    CAUSE_IN_MAINTENANCE = "in-maintenance"
    CAUSE_INACCESSIBLE_VLAN_REFERENCED = "inaccessible-vlan-referenced"
    CAUSE_INBAND_UNSUPPORTED_SERVER = "inband-unsupported-server"
    CAUSE_INCOMPATIBLE_SERVER_FIRMWARE = "incompatible-server-firmware"
    CAUSE_INCOMPATIBLE_SPEED = "incompatible-speed"
    CAUSE_INIT_IPTABLES_LOCAL_FAILED = "init-iptables-local-failed"
    CAUSE_INIT_IPTABLES_PEER_FAILED = "init-iptables-peer-failed"
    CAUSE_INOPERABLE = "inoperable"
    CAUSE_INSUFFICIENT_RESOURCES = "insufficient-resources"
    CAUSE_INSUFFICIENTLY_EQUIPPED = "insufficiently-equipped"
    CAUSE_INTERFACE_FAILED = "interface-failed"
    CAUSE_INTERFACE_MISCONFIGURED = "interface-misconfigured"
    CAUSE_INTERNAL_BACKUP_FAILED = "internal-backup-failed"
    CAUSE_INVALID_KEYRING_CERTIFICATE = "invalid-keyring-certificate"
    CAUSE_INVALID_KEYRING_MODULUS = "invalid-keyring-modulus"
    CAUSE_INVALID_PINNING = "invalid-pinning"
    CAUSE_INVALID_SERVER_GROUP = "invalid-server-group"
    CAUSE_INVALID_TARGET = "invalid-target"
    CAUSE_INVALID_TRUSTPOINT_CERT_CHAIN = "invalid-trustpoint-cert-chain"
    CAUSE_INVALID_VLAN_IN_THE_ALLOWED_VLAN_LIST = "invalid-vlan-in-the-allowed-vlan-list"
    CAUSE_INVENTORY_FAILED = "inventory-failed"
    CAUSE_KERNEL_MEM_CRITICAL_THRESHOLD = "kernel-mem-critical-threshold"
    CAUSE_KEYRING_CONFIG_ERROR = "keyring-config-error"
    CAUSE_KMIP_CERT_CONFIG_FAILED = "kmip-cert-config-failed"
    CAUSE_KMIP_FAULT = "kmip-fault"
    CAUSE_KMIP_SAVE_CERT_FAILED = "kmip-save-cert-failed"
    CAUSE_LEADERSHIP_CHANGE = "leadershipChange"
    CAUSE_LICENSE_FILE_NOT_DELETED = "license-file-not-deleted"
    CAUSE_LICENSE_FILE_UNINSTALLABLE = "license-file-uninstallable"
    CAUSE_LICENSE_GRACEPERIOD_10DAYS = "license-graceperiod-10days"
    CAUSE_LICENSE_GRACEPERIOD_119DAYS = "license-graceperiod-119days"
    CAUSE_LICENSE_GRACEPERIOD_30DAYS = "license-graceperiod-30days"
    CAUSE_LICENSE_GRACEPERIOD_60DAYS = "license-graceperiod-60days"
    CAUSE_LICENSE_GRACEPERIOD_90DAYS = "license-graceperiod-90days"
    CAUSE_LICENSE_GRACEPERIOD_ENTERED = "license-graceperiod-entered"
    CAUSE_LICENSE_GRACEPERIOD_EXPIRED = "license-graceperiod-expired"
    CAUSE_LICENSE_INSUFFICIENT = "license-insufficient"
    CAUSE_LIMIT_REACHED = "limit-reached"
    CAUSE_LINK_DOWN = "link-down"
    CAUSE_LINK_MISCONNECTED = "link-misconnected"
    CAUSE_LINK_MISSING = "link-missing"
    CAUSE_LOAD_CATALOG_FAILED = "load-catalog-failed"
    CAUSE_LOCAL_DISK_FW_UPDATE_FAILED = "local-disk-fw-update-failed"
    CAUSE_LOCAL_FAILED = "local-failed"
    CAUSE_LOCAL_INTERNAL_BACKUP_FAILED = "local-internal-backup-failed"
    CAUSE_LOCALE_CONFIG_ERROR = "locale-config-error"
    CAUSE_LOCALE_ORG_CONFIG_ERROR = "locale-org-config-error"
    CAUSE_LOG_CAPACITY = "log-capacity"
    CAUSE_LOG_TRANSFER_FAILED = "log-transfer-failed"
    CAUSE_MAINTENANCE_FAILED = "maintenance-failed"
    CAUSE_MANAGEMENT_SERVICES_FAILURE = "management-services-failure"
    CAUSE_MANAGEMENT_SERVICES_UNRESPONSIVE = "management-services-unresponsive"
    CAUSE_MARK_ADAPTER_FOR_REBOOT_FAILED = "mark-adapter-for-reboot-failed"
    CAUSE_MAX_VLAN_LIMIT_EXCEEDED = "max-vlan-limit-exceeded"
    CAUSE_MEMBERSHIP_DOWN = "membership-down"
    CAUSE_MEMORY_ERROR = "memory-error"
    CAUSE_MGMT_DB_CORRUPTION = "mgmt-db-corruption"
    CAUSE_MGMTIF_DOWN = "mgmtif-down"
    CAUSE_MISSING_PRIMARY_VLAN = "missing-primary-vlan"
    CAUSE_MOUNT_LOCAL_FAILED = "mount-local-failed"
    CAUSE_MOUNT_PEER_FAILED = "mount-peer-failed"
    CAUSE_MSWITCH_IMG_UPDATE_FAILED = "mswitch-img-update-failed"
    CAUSE_MULTICAST_MAC_EXHAUSTED = "multicast-mac-exhausted"
    CAUSE_MULTIPLE_CONNECTION_POLICIES = "multiple-connection-policies"
    CAUSE_NAMED_INBAND_VLAN_UNRESOLVED = "named-inband-vlan-unresolved"
    CAUSE_NAMED_POLICY_UNRESOLVED = "named-policy-unresolved"
    CAUSE_NAMED_VLAN_UNRESOLVED = "named-vlan-unresolved"
    CAUSE_NATIVE_VLAN_NOT_FOUND = "native-vlan-not-found"
    CAUSE_NDISC_TARGETS_CONFIG_ERROR = "ndisc-targets-config-error"
    CAUSE_NEAR_MAX_LIMIT = "near-max-limit"
    CAUSE_NETWORK_SAN_GROUP_DOES_NOT_EXIST = "network-san-group-does-not-exist"
    CAUSE_NETWORK_SAN_GROUP_MISCONFIGURED = "network-san-group-misconfigured"
    CAUSE_NEW_LINK = "new-link"
    CAUSE_NEW_VNIC_VCON_SCHEME_APPLIED = "new-vnic-vcon-scheme-applied"
    CAUSE_NIC_CONFIG_HOSTOSLOCAL_FAILED = "nic-config-hostoslocal-failed"
    CAUSE_NIC_CONFIG_HOSTOSPEER_FAILED = "nic-config-hostospeer-failed"
    CAUSE_NIC_CONFIG_LOCAL_FAILED = "nic-config-local-failed"
    CAUSE_NIC_CONFIG_PARAMS_HOSTOSLOCAL_FAILED = "nic-config-params-hostoslocal-failed"
    CAUSE_NIC_CONFIG_PARAMS_HOSTOSPEER_FAILED = "nic-config-params-hostospeer-failed"
    CAUSE_NIC_CONFIG_PEER_FAILED = "nic-config-peer-failed"
    CAUSE_NIC_CONFIG_PNUOSLOCAL_FAILED = "nic-config-pnuoslocal-failed"
    CAUSE_NIC_CONFIG_PNUOSPEER_FAILED = "nic-config-pnuospeer-failed"
    CAUSE_NIC_CONFIG_SERVICE_INFRA_LOCAL_FAILED = "nic-config-service-infra-local-failed"
    CAUSE_NIC_CONFIG_SERVICE_INFRA_PEER_FAILED = "nic-config-service-infra-peer-failed"
    CAUSE_NIC_IMG_UPDATE_FAILED = "nic-img-update-failed"
    CAUSE_NIC_INVENTORY_LOCAL_FAILED = "nic-inventory-local-failed"
    CAUSE_NIC_INVENTORY_PEER_FAILED = "nic-inventory-peer-failed"
    CAUSE_NIC_PRESENCE_LOCAL_FAILED = "nic-presence-local-failed"
    CAUSE_NIC_PRESENCE_PEER_FAILED = "nic-presence-peer-failed"
    CAUSE_NIC_UN_CONFIG_LOCAL_FAILED = "nic-un-config-local-failed"
    CAUSE_NIC_UN_CONFIG_PEER_FAILED = "nic-un-config-peer-failed"
    CAUSE_NIC_UNCONFIG_HOSTOSLOCAL_FAILED = "nic-unconfig-hostoslocal-failed"
    CAUSE_NIC_UNCONFIG_HOSTOSPEER_FAILED = "nic-unconfig-hostospeer-failed"
    CAUSE_NIC_UNCONFIG_PNUOSLOCAL_FAILED = "nic-unconfig-pnuoslocal-failed"
    CAUSE_NIC_UNCONFIG_PNUOSPEER_FAILED = "nic-unconfig-pnuospeer-failed"
    CAUSE_NIC_UNCONFIG_SERVICE_INFRA_LOCAL_FAILED = "nic-unconfig-service-infra-local-failed"
    CAUSE_NIC_UNCONFIG_SERVICE_INFRA_PEER_FAILED = "nic-unconfig-service-infra-peer-failed"
    CAUSE_NO_ACK_FROM_BIOS = "no-ack-from-bios"
    CAUSE_NO_CAP_FAIL = "no-cap-fail"
    CAUSE_NO_VLAN_OPTIMIZATION = "no-vlan-optimization"
    CAUSE_NON_EXISTENT_SCHEDULER = "non-existent-scheduler"
    CAUSE_NOT_SUPPORTED = "not-supported"
    CAUSE_OLD_CHASSIS_COMPONENT_FIRMWARE = "old-chassis-component-firmware"
    CAUSE_OLD_FIRMWARE = "old-firmware"
    CAUSE_OOB_DISK_SCRUB_FAILED = "oob-disk-scrub-failed"
    CAUSE_OOB_POLL_SAS_EXPANDER_ACTIVATE_STATUS_FAILED = "oob-poll-sas-expander-activate-status-failed"
    CAUSE_OOB_POLL_SAS_EXPANDER_BOOT_IMG_ACTIVATE_STATUS_FAILED = "oob-poll-sas-expander-boot-img-activate-status-failed"
    CAUSE_OOB_POLL_SAS_EXPANDER_UPDATE_STATUS_FAILED = "oob-poll-sas-expander-update-status-failed"
    CAUSE_OOB_SAS_EXPANDER_BOOT_IMG_ACTIVATE_FAILED = "oob-sas-expander-boot-img-activate-failed"
    CAUSE_OOB_SAS_EXPANDER_IMG_ACTIVATE_FAILED = "oob-sas-expander-img-activate-failed"
    CAUSE_OOB_SAS_EXPANDER_IMG_UPDATE_FAILED = "oob-sas-expander-img-update-failed"
    CAUSE_OOB_STORAGE_CONFIG_FAILED = "oob-storage-config-failed"
    CAUSE_OOB_STORAGE_INVENTORY_FAILED = "oob-storage-inventory-failed"
    CAUSE_OPERATION_FAILED = "operation-failed"
    CAUSE_OPERATIONAL_STATE_DOWN = "operational-state-down"
    CAUSE_PAIR_FAILED = "pair-failed"
    CAUSE_PCI_CONFIG_ISSUE = "pci-config-issue"
    CAUSE_PCI_CONFIG_MISMATCH = "pci-config-mismatch"
    CAUSE_PCI_SWITCH_IMAGE_UPDATE_FAILED = "pci-switch-image-update-failed"
    CAUSE_PEER_FAILED = "peer-failed"
    CAUSE_PERFORMANCE_PROBLEM = "performance-problem"
    CAUSE_PERSISTENT_MEMORY_DETECTION = "persistent-memory-detection"
    CAUSE_PERSISTENT_MEMORY_DIMM_FW_UPDATE_FAILED = "persistent-memory-dimm-fw-update-failed"
    CAUSE_PING_FAILED = "ping-failed"
    CAUSE_PINNING_MISCONFIG = "pinning-misconfig"
    CAUSE_PINNING_MISMATCH = "pinning-mismatch"
    CAUSE_PLD_FIRMWARE_MISMATCH = "pld-firmware-mismatch"
    CAUSE_PNUOS_BOOT_WAIT_FAILED = "pnuos-boot-wait-failed"
    CAUSE_PNUOSCATALOG_FAILED = "pnuoscatalog-failed"
    CAUSE_PNUOSCONFIG_FAILED = "pnuosconfig-failed"
    CAUSE_PNUOSCONN_STATUS_FAILED = "pnuosconn-status-failed"
    CAUSE_PNUOSCONNECTIVITY_FAILED = "pnuosconnectivity-failed"
    CAUSE_PNUOSIDENT_FAILED = "pnuosident-failed"
    CAUSE_PNUOSINVENTORY_FAILED = "pnuosinventory-failed"
    CAUSE_PNUOSLOCAL_DISK_CONFIG_FAILED = "pnuoslocal-disk-config-failed"
    CAUSE_PNUOSPERIPHERAL_COMPONENT_CONFIG_FAILED = "pnuosperipheral-component-config-failed"
    CAUSE_PNUOSPOLICY_FAILED = "pnuospolicy-failed"
    CAUSE_PNUOSPOWER_PROFILING_FAILED = "pnuospower-profiling-failed"
    CAUSE_PNUOSSCRUB_FAILED = "pnuosscrub-failed"
    CAUSE_PNUOSSELF_TEST_FAILED = "pnuosself-test-failed"
    CAUSE_PNUOSUNCONFIG_FAILED = "pnuosunconfig-failed"
    CAUSE_PNUOSUNLOAD_DRIVERS_FAILED = "pnuosunload-drivers-failed"
    CAUSE_PNUOSVALIDATE_FAILED = "pnuosvalidate-failed"
    CAUSE_POLL_ACTIVATE_FAILED = "poll-activate-failed"
    CAUSE_POLL_ACTIVATE_OF_LOCALFI_FAILED = "poll-activate-of-localfi-failed"
    CAUSE_POLL_ACTIVATE_OF_REMOTEFI_FAILED = "poll-activate-of-remotefi-failed"
    CAUSE_POLL_ACTIVATE_OFIOM_FAILED = "poll-activate-ofiom-failed"
    CAUSE_POLL_ACTIVATE_OFUCSM_FAILED = "poll-activate-ofucsm-failed"
    CAUSE_POLL_ACTIVATE_OFUCSMSERVICE_PACK_FAILED = "poll-activate-ofucsmservice-pack-failed"
    CAUSE_POLL_ACTIVATE_STATUS_FAILED = "poll-activate-status-failed"
    CAUSE_POLL_ACTIVATION_FAILED = "poll-activation-failed"
    CAUSE_POLL_ADAPTOR_ACTIVATION_FAILED = "poll-adaptor-activation-failed"
    CAUSE_POLL_BIOS_ACTIVATE_STATUS_FAILED = "poll-bios-activate-status-failed"
    CAUSE_POLL_BIOS_UPDATE_STATUS_FAILED = "poll-bios-update-status-failed"
    CAUSE_POLL_BOARD_CTRL_POWER_CYCLE_FAILED = "poll-board-ctrl-power-cycle-failed"
    CAUSE_POLL_BOARD_CTRL_UPDATE_STATUS_FAILED = "poll-board-ctrl-update-status-failed"
    CAUSE_POLL_BRD_CTLR_ACTIVATION_FAILED = "poll-brd-ctlr-activation-failed"
    CAUSE_POLL_CLEAR_BIOS_UPDATE_STATUS_FAILED = "poll-clear-bios-update-status-failed"
    CAUSE_POLL_CLEAR_STATUS_FAILED = "poll-clear-status-failed"
    CAUSE_POLL_CMC_ACTIVATION_FAILED = "poll-cmc-activation-failed"
    CAUSE_POLL_FAB_EVAC_OFF_REMOTEFI_FAILED = "poll-fab-evac-off-remotefi-failed"
    CAUSE_POLL_FAB_EVAC_ON_REMOTEFI_FAILED = "poll-fab-evac-on-remotefi-failed"
    CAUSE_POLL_FAIL_OVER_TO_REMOTEFI_FAILED = "poll-fail-over-to-remotefi-failed"
    CAUSE_POLL_INTERNAL_BACKUP_FAILED = "poll-internal-backup-failed"
    CAUSE_POLL_LOCAL_DISK_ACTIVATE_FAILED = "poll-local-disk-activate-failed"
    CAUSE_POLL_POST_DISK_ZONE_STORAGE_INVCIMC_FAILED = "poll-post-disk-zone-storage-invcimc-failed"
    CAUSE_POLL_SAS_EXPANDER_ACTIVATE_FAILED = "poll-sas-expander-activate-failed"
    CAUSE_POLL_SAS_EXPANDER_CONFIG_FAILED = "poll-sas-expander-config-failed"
    CAUSE_POLL_SECURE_BOOT_STATUS_FAILED = "poll-secure-boot-status-failed"
    CAUSE_POLL_STORAGE_CTLR_ACTIVATION_FAILED = "poll-storage-ctlr-activation-failed"
    CAUSE_POLL_UPDATE_ADAPTOR_FAILED = "poll-update-adaptor-failed"
    CAUSE_POLL_UPDATE_CMC_FAILED = "poll-update-cmc-failed"
    CAUSE_POLL_UPDATE_OFIOM_FAILED = "poll-update-ofiom-failed"
    CAUSE_POLL_UPDATE_SAS_EXPANDER_FAILED = "poll-update-sas-expander-failed"
    CAUSE_POLL_UPDATE_STATUS_FAILED = "poll-update-status-failed"
    CAUSE_POLL_UPDATE_STATUS_LOCAL_FAILED = "poll-update-status-local-failed"
    CAUSE_POLL_UPDATE_STATUS_PEER_FAILED = "poll-update-status-peer-failed"
    CAUSE_POLL_UPDATE_STORAGE_INVCIMC_FAILED = "poll-update-storage-invcimc-failed"
    CAUSE_POLL_WAIT_FOR_USER_ACK_FAILED = "poll-wait-for-user-ack-failed"
    CAUSE_PORT_FAILED = "port-failed"
    CAUSE_PORT_INVENTORY_SW_AFAILED = "port-inventory-sw-afailed"
    CAUSE_PORT_INVENTORY_SW_BFAILED = "port-inventory-sw-bfailed"
    CAUSE_PORT_MISCONFIGURE = "port-misconfigure"
    CAUSE_POST_DISK_ZONE_STORAGE_INVCIMC_FAILED = "post-disk-zone-storage-invcimc-failed"
    CAUSE_POST_DISK_ZONE_STORAGE_INVCMC_FAILED = "post-disk-zone-storage-invcmc-failed"
    CAUSE_POST_SCRUB_OOB_STORAGE_INVENTORY_FAILED = "post-scrub-oob-storage-inventory-failed"
    CAUSE_POST_SET_KEY_RING_LOCAL_FAILED = "post-set-key-ring-local-failed"
    CAUSE_POST_SET_KEY_RING_PEER_FAILED = "post-set-key-ring-peer-failed"
    CAUSE_POWER_BUDGET_UNAVAILABLE = "power-budget-unavailable"
    CAUSE_POWER_BUTTON_LOCK_CONFIG_FAILED = "power-button-lock-config-failed"
    CAUSE_POWER_CAP_FAIL = "power-cap-fail"
    CAUSE_POWER_CONSUMPTION_HIT_LIMIT = "power-consumption-hit-limit"
    CAUSE_POWER_CYCLE_BOARD_FAILED = "power-cycle-board-failed"
    CAUSE_POWER_CYCLE_FAILED = "power-cycle-failed"
    CAUSE_POWER_DEPLOY_WAIT_FAILED = "power-deploy-wait-failed"
    CAUSE_POWER_DOWN = "power-down"
    CAUSE_POWER_OFF_FAILED = "power-off-failed"
    CAUSE_POWER_OFF_RECLAIM_FAILED = "power-off-reclaim-failed"
    CAUSE_POWER_OFF_SERVERS_FAILED = "power-off-servers-failed"
    CAUSE_POWER_OFF_WAIT_FAILED = "power-off-wait-failed"
    CAUSE_POWER_ON_FAILED = "power-on-failed"
    CAUSE_POWER_ON_PRE_CONFIG_FAILED = "power-on-pre-config-failed"
    CAUSE_POWER_ON_SERVERS_FAILED = "power-on-servers-failed"
    CAUSE_POWER_ON_WAIT_FAILED = "power-on-wait-failed"
    CAUSE_POWER_PROBLEM = "power-problem"
    CAUSE_POWERED_OFF = "powered-off"
    CAUSE_PRE_SANITIZE_FAILED = "pre-sanitize-failed"
    CAUSE_PRECLEANUP_PORT_CONFIG_FAILED = "precleanup-port-config-failed"
    CAUSE_PRECONFIG_VMEDIA_LOCAL_FAILED = "preconfig-vmedia-local-failed"
    CAUSE_PRECONFIG_VMEDIA_PEER_FAILED = "preconfig-vmedia-peer-failed"
    CAUSE_PREPARE_FOR_BOOT_FAILED = "prepare-for-boot-failed"
    CAUSE_PREPARE_FOR_UPDATE_FAILED = "prepare-for-update-failed"
    CAUSE_PRIMARY_FAILED = "primary-failed"
    CAUSE_PRIMARY_VLAN_MISSING_FOR_COMMUNITY = "primary-vlan-missing-for-community"
    CAUSE_PRIMARY_VLAN_MISSING_FOR_ISOLATED = "primary-vlan-missing-for-isolated"
    CAUSE_PROFILE_CONFIG_INCORRECT = "profile-config-incorrect"
    CAUSE_PROPOGATE_EP_SETTINGS_FAILED = "propogate-ep-settings-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_LOCAL_FAILED = "propogate-ep-time-zone-settings-local-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_PEER_FAILED = "propogate-ep-time-zone-settings-peer-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_TO_ADAPTORS_LOCAL_FAILED = "propogate-ep-time-zone-settings-to-adaptors-local-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_TO_ADAPTORS_PEER_FAILED = "propogate-ep-time-zone-settings-to-adaptors-peer-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_TO_FEX_IOM_LOCAL_FAILED = "propogate-ep-time-zone-settings-to-fex-iom-local-failed"
    CAUSE_PROPOGATE_EP_TIME_ZONE_SETTINGS_TO_FEX_IOM_PEER_FAILED = "propogate-ep-time-zone-settings-to-fex-iom-peer-failed"
    CAUSE_PROVIDER_GROUP_ALREADY_EXISTS = "provider-group-already-exists"
    CAUSE_PROVIDER_GROUP_SIZE_EMPTY = "provider-group-size-empty"
    CAUSE_PROVISION_STORAGE_FAILED = "provision-storage-failed"
    CAUSE_PSU_INSUFFICIENT = "psu-insufficient"
    CAUSE_PSU_MIXED_MODE = "psu-mixed-mode"
    CAUSE_PSU_REDUNDANCY_FAIL = "psu-redundancy-fail"
    CAUSE_PVLIF_VLAN_MBR_EXHAUSTED = "pvlif-vlan-mbr-exhausted"
    CAUSE_PVSYSTEM_EXHAUSTED = "pvsystem-exhausted"
    CAUSE_READ_SM_BIOS_FAILED = "read-sm-bios-failed"
    CAUSE_READ_SMBIOS_FAILED = "read-smbios-failed"
    CAUSE_RECONFIG_BIOS_FAILED = "reconfig-bios-failed"
    CAUSE_RECONFIG_UUID_FAILED = "reconfig-uuid-failed"
    CAUSE_REFERENCED_REMOTE_VLAN_UNRESOLVABLE = "referenced-remote-vlan-unresolvable"
    CAUSE_REFERENCED_REMOTE_VSAN_UNRESOLVABLE = "referenced-remote-vsan-unresolvable"
    CAUSE_REFERENCED_VLAN_UNRESOLVABLE = "referenced-vlan-unresolvable"
    CAUSE_REFERENCED_VSAN_UNRESOLVABLE = "referenced-vsan-unresolvable"
    CAUSE_REGISTER_CLIENT_FAILED = "register-client-failed"
    CAUSE_RELEASE_ALL_FAILED = "release-all-failed"
    CAUSE_RELEASE_FAILED = "release-failed"
    CAUSE_RELEASE_MANY_FAILED = "release-many-failed"
    CAUSE_REMOTE_FAILED = "remote-failed"
    CAUSE_REMOVE_FAILED = "remove-failed"
    CAUSE_REMOVE_LOCAL_FAILED = "remove-local-failed"
    CAUSE_REMOVE_PEER_FAILED = "remove-peer-failed"
    CAUSE_REPLICATION_FAILURE = "replication-failure"
    CAUSE_REPORT_ERROR_FAILED = "report-error-failed"
    CAUSE_REPORT_FAILED = "report-failed"
    CAUSE_REPORT_FAULT_INVENTORY_FAILED = "report-fault-inventory-failed"
    CAUSE_REPORT_ORG_INVENTORY_FAILED = "report-org-inventory-failed"
    CAUSE_REPORT_PHYSICAL_INVENTORY_FAILED = "report-physical-inventory-failed"
    CAUSE_REPORT_RESULTS_FAILED = "report-results-failed"
    CAUSE_REPORT_STORAGE_INVENTORY_FAILED = "report-storage-inventory-failed"
    CAUSE_REQUEST_FAILED = "request-failed"
    CAUSE_RESCAN_IMAGES_FAILED = "rescan-images-failed"
    CAUSE_RESET_CIMC_FAILED = "reset-cimc-failed"
    CAUSE_RESET_FAILED = "reset-failed"
    CAUSE_RESET_LOCAL_FAILED = "reset-local-failed"
    CAUSE_RESET_REMOTE_FAILED = "reset-remote-failed"
    CAUSE_RESET_SAS_EXPANDER_FAILED = "reset-sas-expander-failed"
    CAUSE_RESET_SECURE_BOOT_CONFIG_FAILED = "reset-secure-boot-config-failed"
    CAUSE_RESETIBMC_FAILED = "resetibmc-failed"
    CAUSE_RESOLVE_ALL_FAILED = "resolve-all-failed"
    CAUSE_RESOLVE_BOOT_CONFIG_FAILED = "resolve-boot-config-failed"
    CAUSE_RESOLVE_DEFAULT_IDENTIFIERS_FAILED = "resolve-default-identifiers-failed"
    CAUSE_RESOLVE_DISTRIBUTABLE_FAILED = "resolve-distributable-failed"
    CAUSE_RESOLVE_DISTRIBUTABLE_NAMES_FAILED = "resolve-distributable-names-failed"
    CAUSE_RESOLVE_FAILED = "resolve-failed"
    CAUSE_RESOLVE_FROM_OPS_MGR_FAILED = "resolve-from-ops-mgr-failed"
    CAUSE_RESOLVE_FROM_POLICY_MGR_FAILED = "resolve-from-policy-mgr-failed"
    CAUSE_RESOLVE_IDENTIFIERS_FAILED = "resolve-identifiers-failed"
    CAUSE_RESOLVE_IMAGES_FAILED = "resolve-images-failed"
    CAUSE_RESOLVE_MANY_FAILED = "resolve-many-failed"
    CAUSE_RESOLVE_NETWORK_POLICIES_FAILED = "resolve-network-policies-failed"
    CAUSE_RESOLVE_NETWORK_TEMPLATES_FAILED = "resolve-network-templates-failed"
    CAUSE_RESOLVE_POLICIES_FAILED = "resolve-policies-failed"
    CAUSE_RESOLVE_SCHEDULE_FAILED = "resolve-schedule-failed"
    CAUSE_RESOLVE_STORAGE_SCHEDULE_FAILED = "resolve-storage-schedule-failed"
    CAUSE_RESTORE_VD_STATUS_FAILED = "restore-vd-status-failed"
    CAUSE_ROLE_CONFIG_ERROR = "role-config-error"
    CAUSE_RUN_TESTS_FAILED = "run-tests-failed"
    CAUSE_SANITIZE_FAILED = "sanitize-failed"
    CAUSE_SAS_EXPANDER_CONFIG_FAILED = "sas-expander-config-failed"
    CAUSE_SAS_EXPANDER_IMG_UPDATE_FAILED = "sas-expander-img-update-failed"
    CAUSE_SATELLITE_CONNECTION_ABSENT = "satellite-connection-absent"
    CAUSE_SATELLITE_CONNECTION_INIT = "satellite-connection-init"
    CAUSE_SATELLITE_MIS_CONNECTED = "satellite-mis-connected"
    CAUSE_SECONDARY_FAILED = "secondary-failed"
    CAUSE_SEND_BMC_PROFILING_DONE_FAILED = "send-bmc-profiling-done-failed"
    CAUSE_SEND_BMC_PROFILING_INIT_FAILED = "send-bmc-profiling-init-failed"
    CAUSE_SERIAL_DEBUG_CONNECT_FAILED = "serial-debug-connect-failed"
    CAUSE_SERIAL_DEBUG_DISCONNECT_FAILED = "serial-debug-disconnect-failed"
    CAUSE_SERIAL_DEBUG_PNUOSCONNECT_FAILED = "serial-debug-pnuosconnect-failed"
    CAUSE_SERIAL_DEBUG_PNUOSDISCONNECT_FAILED = "serial-debug-pnuosdisconnect-failed"
    CAUSE_SERVER_ASSIGNED = "server-assigned"
    CAUSE_SERVER_ASSOCIATED = "server-associated"
    CAUSE_SERVER_ASSOCIATING = "server-associating"
    CAUSE_SERVER_DEASSOCIATING = "server-deassociating"
    CAUSE_SERVER_ERROR = "server-error"
    CAUSE_SERVER_FAILED = "server-failed"
    CAUSE_SERVER_IDENTIFICATION_PROBLEM = "server-identification-problem"
    CAUSE_SERVER_INACCESSIBLE = "server-inaccessible"
    CAUSE_SERVER_MOVED = "server-moved"
    CAUSE_SERVER_POWER_OFF_FAILED = "server-power-off-failed"
    CAUSE_SERVER_POWER_ON_FAILED = "server-power-on-failed"
    CAUSE_SERVER_UNASSIGNED = "server-unassigned"
    CAUSE_SERVER_UNASSOCIATED = "server-unassociated"
    CAUSE_SERVERS_POWER_OFF_COMPLETION_FAILED = "servers-power-off-completion-failed"
    CAUSE_SET_EP_AFAILED = "set-ep-afailed"
    CAUSE_SET_EP_BFAILED = "set-ep-bfailed"
    CAUSE_SET_EP_LOCAL_FAILED = "set-ep-local-failed"
    CAUSE_SET_EP_PEER_FAILED = "set-ep-peer-failed"
    CAUSE_SET_KEY_RING_LOCAL_FAILED = "set-key-ring-local-failed"
    CAUSE_SET_KEY_RING_PEER_FAILED = "set-key-ring-peer-failed"
    CAUSE_SET_LOCAL_FAILED = "set-local-failed"
    CAUSE_SET_PEER_FAILED = "set-peer-failed"
    CAUSE_SET_REALM_LOCAL_FAILED = "set-realm-local-failed"
    CAUSE_SET_REALM_PEER_FAILED = "set-realm-peer-failed"
    CAUSE_SET_USER_LOCAL_FAILED = "set-user-local-failed"
    CAUSE_SET_USER_PEER_FAILED = "set-user-peer-failed"
    CAUSE_SETUP_BOOT_ENVIRONMENT_FAILED = "setup-boot-environment-failed"
    CAUSE_SETUP_VMEDIA_FAILED = "setup-vmedia-failed"
    CAUSE_SETUP_VMEDIA_LOCAL_FAILED = "setup-vmedia-local-failed"
    CAUSE_SETUP_VMEDIA_PEER_FAILED = "setup-vmedia-peer-failed"
    CAUSE_SHARED_COMPONENTS_OOB_INVENTORY_FAILED = "shared-components-oob-inventory-failed"
    CAUSE_SHARED_COMPONENTS_OOB_INVENTORY_PEER_FAILED = "shared-components-oob-inventory-peer-failed"
    CAUSE_SHAREDIOMODULE_INVENTORY_FAILED = "sharediomodule-inventory-failed"
    CAUSE_SHUTDOWN_FAILED = "shutdown-failed"
    CAUSE_SLOW_DRAIN_RECOVERY_FAILURE = "slow-drain-recovery-failure"
    CAUSE_SNMP_CONFIG_ERROR = "snmp-config-error"
    CAUSE_SNMP_USER_CONFIG_ERROR = "snmp-user-config-error"
    CAUSE_SOFT_SHUTDOWN_FAILED = "soft-shutdown-failed"
    CAUSE_SOL_REDIRECT_DISABLE_FAILED = "sol-redirect-disable-failed"
    CAUSE_SOL_REDIRECT_ENABLE_FAILED = "sol-redirect-enable-failed"
    CAUSE_SPDM_FAULT = "spdm-fault"
    CAUSE_STANDBYCMCVLAN_CFG_FAILED = "standbycmcvlan-cfg-failed"
    CAUSE_START_FAILED = "start-failed"
    CAUSE_STOPVMEDIA_LOCAL_FAILED = "stopvmedia-local-failed"
    CAUSE_STOPVMEDIA_PEER_FAILED = "stopvmedia-peer-failed"
    CAUSE_STORAGE_CTLR_IMG_UPDATE_FAILED = "storage-ctlr-img-update-failed"
    CAUSE_STORAGE_INVENTORY_FAILED = "storage-inventory-failed"
    CAUSE_SUCCESS_FAILED = "success-failed"
    CAUSE_SUPPRESS_STATUS_CHANGE = "suppress-status-change"
    CAUSE_SUSPEND_MODE_ENTERED = "suspend-mode-entered"
    CAUSE_SVNIC_NOT_PRESENT = "svnic-not-present"
    CAUSE_SW_CONFIG_HOSTOSLOCAL_FAILED = "sw-config-hostoslocal-failed"
    CAUSE_SW_CONFIG_HOSTOSPEER_FAILED = "sw-config-hostospeer-failed"
    CAUSE_SW_CONFIG_LOCAL_FAILED = "sw-config-local-failed"
    CAUSE_SW_CONFIG_PEER_FAILED = "sw-config-peer-failed"
    CAUSE_SW_CONFIG_PNUOSLOCAL_FAILED = "sw-config-pnuoslocal-failed"
    CAUSE_SW_CONFIG_PNUOSPEER_FAILED = "sw-config-pnuospeer-failed"
    CAUSE_SW_CONFIG_PORT_NIV_LOCAL_FAILED = "sw-config-port-niv-local-failed"
    CAUSE_SW_CONFIG_PORT_NIV_PEER_FAILED = "sw-config-port-niv-peer-failed"
    CAUSE_SW_CONFIG_SERVICE_INFRA_LOCAL_FAILED = "sw-config-service-infra-local-failed"
    CAUSE_SW_CONFIG_SERVICE_INFRA_PEER_FAILED = "sw-config-service-infra-peer-failed"
    CAUSE_SW_CONFIGURE_CONN_LOCAL_FAILED = "sw-configure-conn-local-failed"
    CAUSE_SW_CONFIGURE_CONN_PEER_FAILED = "sw-configure-conn-peer-failed"
    CAUSE_SW_CONFIGURE_PORT_CHANNEL_LOCAL_FAILED = "sw-configure-port-channel-local-failed"
    CAUSE_SW_CONFIGURE_PORT_CHANNEL_PEER_FAILED = "sw-configure-port-channel-peer-failed"
    CAUSE_SW_HOSTOSCONFIGURE_PORT_CHANNEL_LOCAL_FAILED = "sw-hostosconfigure-port-channel-local-failed"
    CAUSE_SW_HOSTOSCONFIGURE_PORT_CHANNEL_PEER_FAILED = "sw-hostosconfigure-port-channel-peer-failed"
    CAUSE_SW_HOSTOSMULTI_PORT_CONNECTIVITY_LOCAL_FAILED = "sw-hostosmulti-port-connectivity-local-failed"
    CAUSE_SW_HOSTOSMULTI_PORT_CONNECTIVITY_PEER_FAILED = "sw-hostosmulti-port-connectivity-peer-failed"
    CAUSE_SW_PNUOSCONNECTIVITY_LOCAL_FAILED = "sw-pnuosconnectivity-local-failed"
    CAUSE_SW_PNUOSCONNECTIVITY_PEER_FAILED = "sw-pnuosconnectivity-peer-failed"
    CAUSE_SW_PORT_DETAILS_LOCAL_FAILED = "sw-port-details-local-failed"
    CAUSE_SW_PORT_DETAILS_PEER_FAILED = "sw-port-details-peer-failed"
    CAUSE_SW_UN_CONFIG_LOCAL_FAILED = "sw-un-config-local-failed"
    CAUSE_SW_UN_CONFIG_PEER_FAILED = "sw-un-config-peer-failed"
    CAUSE_SW_UNCONFIG_HOSTOSLOCAL_FAILED = "sw-unconfig-hostoslocal-failed"
    CAUSE_SW_UNCONFIG_HOSTOSPEER_FAILED = "sw-unconfig-hostospeer-failed"
    CAUSE_SW_UNCONFIG_PNUOSLOCAL_FAILED = "sw-unconfig-pnuoslocal-failed"
    CAUSE_SW_UNCONFIG_PNUOSPEER_FAILED = "sw-unconfig-pnuospeer-failed"
    CAUSE_SW_UNCONFIG_PORT_NIV_LOCAL_FAILED = "sw-unconfig-port-niv-local-failed"
    CAUSE_SW_UNCONFIG_PORT_NIV_PEER_FAILED = "sw-unconfig-port-niv-peer-failed"
    CAUSE_SW_UNCONFIGURE_LOCAL_FAILED = "sw-unconfigure-local-failed"
    CAUSE_SW_UNCONFIGURE_PEER_FAILED = "sw-unconfigure-peer-failed"
    CAUSE_SWITCH_FAILED = "switch-failed"
    CAUSE_SYNC_BLADEAGLOCAL_FAILED = "sync-bladeaglocal-failed"
    CAUSE_SYNC_BLADEAGREMOTE_FAILED = "sync-bladeagremote-failed"
    CAUSE_SYNC_FAILED = "sync-failed"
    CAUSE_SYNC_HOSTAGENTAGLOCAL_FAILED = "sync-hostagentaglocal-failed"
    CAUSE_SYNC_HOSTAGENTAGREMOTE_FAILED = "sync-hostagentagremote-failed"
    CAUSE_SYNC_NICAGLOCAL_FAILED = "sync-nicaglocal-failed"
    CAUSE_SYNC_NICAGREMOTE_FAILED = "sync-nicagremote-failed"
    CAUSE_SYNC_PORTAGLOCAL_FAILED = "sync-portaglocal-failed"
    CAUSE_SYNC_PORTAGREMOTE_FAILED = "sync-portagremote-failed"
    CAUSE_SYNC_POWER_STATE_FAILED = "sync-power-state-failed"
    CAUSE_TEAR_DOWN_BOOT_ENVIRONMENT_FAILED = "tear-down-boot-environment-failed"
    CAUSE_TEAR_DOWNVMEDIA_LOCAL_FAILED = "tear-downvmedia-local-failed"
    CAUSE_TEAR_DOWNVMEDIA_PEER_FAILED = "tear-downvmedia-peer-failed"
    CAUSE_TEARDOWN_VMEDIA_LOCAL_FAILED = "teardown-vmedia-local-failed"
    CAUSE_TEARDOWN_VMEDIA_PEER_FAILED = "teardown-vmedia-peer-failed"
    CAUSE_TFTP_SERVER_ERROR = "tftp-server-error"
    CAUSE_THERMAL_PROBLEM = "thermal-problem"
    CAUSE_THRESHOLD_CROSSED = "threshold-crossed"
    CAUSE_TIMEZONE_FILE_NOT_EXISTS = "timezone-file-not-exists"
    CAUSE_TPM_MISMATCH = "tpm-mismatch"
    CAUSE_TPM_ON_SLAVE_BOARD = "tpm-on-slave-board"
    CAUSE_TRANSCEIVER_MISMATCH = "transceiver-mismatch"
    CAUSE_TRANSITION = "transition"
    CAUSE_UCSM_PROCESS_FAILURE = "ucsm-process-failure"
    CAUSE_UDLD_LINK_DOWN = "udld-link-down"
    CAUSE_UN_IDENTIFY_LOCAL_FAILED = "un-identify-local-failed"
    CAUSE_UN_IDENTIFY_PEER_FAILED = "un-identify-peer-failed"
    CAUSE_UNASSOCIATED = "unassociated"
    CAUSE_UNCLAIMED_DEVICE = "unclaimed-device"
    CAUSE_UNCONFIG_BIOS_FAILED = "unconfig-bios-failed"
    CAUSE_UNCONFIG_CIMCVMEDIA_FAILED = "unconfig-cimcvmedia-failed"
    CAUSE_UNCONFIG_EXT_MGMT_GW_FAILED = "unconfig-ext-mgmt-gw-failed"
    CAUSE_UNCONFIG_EXT_MGMT_RULES_FAILED = "unconfig-ext-mgmt-rules-failed"
    CAUSE_UNCONFIG_FLEX_FLASH_FAILED = "unconfig-flex-flash-failed"
    CAUSE_UNCONFIG_SERVER_IDENTITY_FAILED = "unconfig-server-identity-failed"
    CAUSE_UNCONFIG_SO_LFAILED = "unconfig-so-lfailed"
    CAUSE_UNCONFIG_UUID_FAILED = "unconfig-uuid-failed"
    CAUSE_UNCONFIG_VMEDIA_FAILED = "unconfig-vmedia-failed"
    CAUSE_UNCONFIGURATION_IN_PROGRESS = "unconfiguration-in-progress"
    CAUSE_UNDER_TEST = "under-test"
    CAUSE_UNEXPECTED_NUMBER_OF_LINKS = "unexpected-number-of-links"
    CAUSE_UNICAST_MAC_EXHAUSTED = "unicast-mac-exhausted"
    CAUSE_UNIDENTIFIABLE_FRU = "unidentifiable-fru"
    CAUSE_UNKNOWN = "unknown"
    CAUSE_UNLOCK_FIRMWARE_IMAGE_FAILED = "unlock-firmware-image-failed"
    CAUSE_UNMOUNT_LOCAL_FAILED = "unmount-local-failed"
    CAUSE_UNMOUNT_PEER_FAILED = "unmount-peer-failed"
    CAUSE_UNPACK_LOCAL_FAILED = "unpack-local-failed"
    CAUSE_UNREGISTER_FAILED = "unregister-failed"
    CAUSE_UNSECURE_ADAPTOR = "unsecure-adaptor"
    CAUSE_UNSECURED_FPGA = "unsecured-fpga"
    CAUSE_UNSUPPORTED_CIMC_FIRMWARE = "unsupported-cimc-firmware"
    CAUSE_UNSUPPORTED_CONFIG = "unsupported-config"
    CAUSE_UNSUPPORTED_CONNECTIVITY = "unsupported-connectivity"
    CAUSE_UNSUPPORTED_CONNECTIVITY_CONFIGURATION = "unsupported-connectivity-configuration"
    CAUSE_UNSUPPORTED_POLICY_CONFIG = "unsupported-policy-config"
    CAUSE_UNSUPPORTED_TRANSCEIVER = "unsupported-transceiver"
    CAUSE_UPDATE_ADAPTOR_FAILED = "update-adaptor-failed"
    CAUSE_UPDATE_ADAPTOR_NW_FW_LOCAL_FAILED = "update-adaptor-nw-fw-local-failed"
    CAUSE_UPDATE_ADAPTOR_NW_FW_PEER_FAILED = "update-adaptor-nw-fw-peer-failed"
    CAUSE_UPDATE_BIOS_REQUEST_FAILED = "update-bios-request-failed"
    CAUSE_UPDATE_BOARD_CTRL_REQUEST_FAILED = "update-board-ctrl-request-failed"
    CAUSE_UPDATE_CMC_FAILED = "update-cmc-failed"
    CAUSE_UPDATE_CONNECTIVITY_FAILED = "update-connectivity-failed"
    CAUSE_UPDATE_ETH_FLOW_MON_FAILED = "update-eth-flow-mon-failed"
    CAUSE_UPDATE_ETH_MON_FAILED = "update-eth-mon-failed"
    CAUSE_UPDATE_FAILED = "update-failed"
    CAUSE_UPDATE_FC_MON_FAILED = "update-fc-mon-failed"
    CAUSE_UPDATE_FLASH_LIFE_FAILED = "update-flash-life-failed"
    CAUSE_UPDATE_LOCAL_FAILED = "update-local-failed"
    CAUSE_UPDATE_REMOTE_FAILED = "update-remote-failed"
    CAUSE_UPDATE_REQUEST_FAILED = "update-request-failed"
    CAUSE_UPDATE_REQUEST_LOCAL_FAILED = "update-request-local-failed"
    CAUSE_UPDATE_REQUEST_PEER_FAILED = "update-request-peer-failed"
    CAUSE_UPDATE_SAS_EXPANDER_FAILED = "update-sas-expander-failed"
    CAUSE_UPDATE_SP_LOCAL_FAILED = "update-sp-local-failed"
    CAUSE_UPDATE_SP_REMOTE_FAILED = "update-sp-remote-failed"
    CAUSE_UPDATE_STORAGE_INVCIMC_FAILED = "update-storage-invcimc-failed"
    CAUSE_UPDATE_STORAGE_INVCMC_FAILED = "update-storage-invcmc-failed"
    CAUSE_UPDATE_TOKENS_FAILED = "update-tokens-failed"
    CAUSE_UPDATE_VLAN_GROUPS_FAILED = "update-vlan-groups-failed"
    CAUSE_UPDATE_ZONES_FAILED = "update-zones-failed"
    CAUSE_UPDATEIBMCFW_FAILED = "updateibmcfw-failed"
    CAUSE_UPDATEIOM_FAILED = "updateiom-failed"
    CAUSE_UPLOAD_FAILED = "upload-failed"
    CAUSE_USER_CONFIG_ERROR = "user-config-error"
    CAUSE_USER_LOCALE_CONFIG_ERROR = "user-locale-config-error"
    CAUSE_USER_ROLE_CONFIG_ERROR = "user-role-config-error"
    CAUSE_VALIDATE_CONFIGURATION_FAILED = "validate-configuration-failed"
    CAUSE_VALIDATE_LOCAL_FAILED = "validate-local-failed"
    CAUSE_VALIDATE_POLICY_OWNERSHIP_FAILED = "validate-policy-ownership-failed"
    CAUSE_VALIDATE_REMOTE_FAILED = "validate-remote-failed"
    CAUSE_VALIDATE_REMOVAL_FAILED = "validate-removal-failed"
    CAUSE_VERIFY_BREAKOUT_CONFIG_FAILED = "verify-breakout-config-failed"
    CAUSE_VERIFY_FAILED = "verify-failed"
    CAUSE_VERIFY_FC_ZONE_CONFIG_FAILED = "verify-fc-zone-config-failed"
    CAUSE_VERIFY_GUID_FAILED = "verify-guid-failed"
    CAUSE_VERIFY_LOCAL_FAILED = "verify-local-failed"
    CAUSE_VERIFY_PHYS_CONFIG_FAILED = "verify-phys-config-failed"
    CAUSE_VERIFY_REGISTRATION_FAILED = "verify-registration-failed"
    CAUSE_VERIFY_REMOTE_FAILED = "verify-remote-failed"
    CAUSE_VERIFY_USER_ZONE_CONFIG_FAILED = "verify-user-zone-config-failed"
    CAUSE_VERSION_INCOMPATIBLE = "version-incompatible"
    CAUSE_VERSION_HOLDER_CHANGE = "versionHolderChange"
    CAUSE_VHBA_NOT_SUPPORTED = "vhba-not-supported"
    CAUSE_VIF_DOWN = "vif-down"
    CAUSE_VIF_IDS_MISMATCH = "vif-ids-mismatch"
    CAUSE_VLAN_COMP_GRP_COUNT_EXCEEDS_LIMIT = "vlan-comp-grp-count-exceeds-limit"
    CAUSE_VLAN_COMPRESSION = "vlan-compression"
    CAUSE_VLAN_CONFLICT_PERMIT = "vlan-conflict-permit"
    CAUSE_VLAN_ERROR_ASSOC_PRIMARY = "vlan-error-assoc-primary"
    CAUSE_VLAN_MCAST_POLICY_MISCONFIGURED = "vlan-mcast-policy-misconfigured"
    CAUSE_VLAN_MISCONFIGURED = "vlan-misconfigured"
    CAUSE_VLAN_MISMATCH = "vlan-mismatch"
    CAUSE_VLAN_PERMIT_UNRESOLVED = "vlan-permit-unresolved"
    CAUSE_VM_NETWORK_REFERENCE_INCORRECT = "vm-network-reference-incorrect"
    CAUSE_VMEDIA_MOUNT_INACCESSIBLE = "vmedia-mount-inaccessible"
    CAUSE_VOLTAGE_PROBLEM = "voltage-problem"
    CAUSE_VSAN_EXCEED_LIMIT = "vsan-exceed-limit"
    CAUSE_VSAN_MISCONFIGURED = "vsan-misconfigured"
    CAUSE_WAIT_BEFORE_INSTALLATION_FAILED = "wait-before-installation-failed"
    CAUSE_WAIT_FAILED = "wait-failed"
    CAUSE_WAIT_FOR_ACK_FAILED = "wait-for-ack-failed"
    CAUSE_WAIT_FOR_ACTIVATION_FAILED = "wait-for-activation-failed"
    CAUSE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL_FAILED = "wait-for-adaptor-nw-fw-update-local-failed"
    CAUSE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER_FAILED = "wait-for-adaptor-nw-fw-update-peer-failed"
    CAUSE_WAIT_FOR_ASSOC_COMPLETION_FAILED = "wait-for-assoc-completion-failed"
    CAUSE_WAIT_FOR_BORDER_CONFIG_COMPLETION_LOCAL_FAILED = "wait-for-border-config-completion-local-failed"
    CAUSE_WAIT_FOR_BORDER_CONFIG_COMPLETION_PEER_FAILED = "wait-for-border-config-completion-peer-failed"
    CAUSE_WAIT_FOR_COMMIT_STORAGE_FAILED = "wait-for-commit-storage-failed"
    CAUSE_WAIT_FOR_CONN_READY_FAILED = "wait-for-conn-ready-failed"
    CAUSE_WAIT_FOR_DEBUG_FAILED = "wait-for-debug-failed"
    CAUSE_WAIT_FOR_DEPLOY_FAILED = "wait-for-deploy-failed"
    CAUSE_WAIT_FOR_MAINT_PERMISSION_FAILED = "wait-for-maint-permission-failed"
    CAUSE_WAIT_FOR_MAINT_WINDOW_FAILED = "wait-for-maint-window-failed"
    CAUSE_WAIT_FOR_POWER_OFF_FAILED = "wait-for-power-off-failed"
    CAUSE_WAIT_FOR_STORAGE_PROVISION_FAILED = "wait-for-storage-provision-failed"
    CAUSE_WAIT_FOR_USER_ACK_FAILED = "wait-for-user-ack-failed"
    CAUSE_WAIT_FORIBMCFW_UPDATE_FAILED = "wait-foribmcfw-update-failed"
    CAUSE_WAIT_ON_PHYS_FAILED = "wait-on-phys-failed"
    CAUSE_WAIT_ON_SW_CONFIG_HOST_FAILED = "wait-on-sw-config-host-failed"
    TYPE_ANY = "any"
    TYPE_CHASSIS_PROFILE = "chassis-profile"
    TYPE_CONFIGURATION = "configuration"
    TYPE_CONNECTIVITY = "connectivity"
    TYPE_ENVIRONMENTAL = "environmental"
    TYPE_EQUIPMENT = "equipment"
    TYPE_FORWARD = "forward"
    TYPE_FSM = "fsm"
    TYPE_GENERIC = "generic"
    TYPE_MANAGEMENT = "management"
    TYPE_NETWORK = "network"
    TYPE_OPERATIONAL = "operational"
    TYPE_SECURITY = "security"
    TYPE_SERVER = "server"
    TYPE_SYSDEBUG = "sysdebug"


class FaultSuppressPolicyItem(ManagedObject):
    """This is FaultSuppressPolicyItem class."""

    consts = FaultSuppressPolicyItemConsts()
    naming_props = set(['type', 'cause'])

    mo_meta = MoMeta("FaultSuppressPolicyItem", "faultSuppressPolicyItem", "item-[type]-[cause]", VersionMeta.Version211a, "InputOutput", 0xff, [], ["read-only"], ['faultSuppressPolicy'], [], [None])

    prop_meta = {
        "cause": MoPropertyMeta("cause", "cause", "string", VersionMeta.Version211a, MoPropertyMeta.NAMING, 0x2, None, None, None, ["ChassisProfile-assigned", "ChassisProfile-associated", "ChassisProfile-associating", "ChassisProfile-deassociating", "ChassisProfile-unassigned", "ChassisProfile-unassociated", "a-failed", "activate-adaptor-failed", "activate-adaptor-nw-fw-local-failed", "activate-adaptor-nw-fw-peer-failed", "activate-bios-failed", "activate-brd-ctlr-failed", "activate-catalog-failed", "activate-cmc-failed", "activate-failed", "activate-local-disk-failed", "activate-local-failed", "activate-localfi-failed", "activate-peer-failed", "activate-psu-failed", "activate-remote-failed", "activate-remotefi-failed", "activate-sas-expander-failed", "activate-storage-ctlr-failed", "activateibmcfw-failed", "activateiom-failed", "activateucsm-failed", "activateucsmservice-pack-failed", "activation-failed", "active-failed", "adaptor-mismatch", "analyze-impact-failed", "another-connection-already-enabled", "any", "apply-catalog-failed", "apply-config-failed", "apply-default-identifiers-failed", "apply-failed", "apply-identifiers-failed", "apply-maint-config-failed", "apply-mo-props-failed", "apply-physical-failed", "apply-policies-failed", "apply-template-failed", "arp-targets-config-error", "assert-bypass-wait-failed", "assignment-failed", "association-failed", "auto-firmware-upgrade", "b-failed", "backplane-port-problem", "backup-local-failed", "begin-failed", "begin-inventory-failed", "bios-img-update-failed", "bios-post-completion-failed", "blade-boot-pnuos-failed", "blade-boot-wait-failed", "blade-power-off-failed", "blade-power-on-failed", "blade-read-smbios-failed", "bmc-config-pnuos-failed", "bmc-configure-conn-local-failed", "bmc-configure-conn-peer-failed", "bmc-factory-reset-failed", "bmc-inventory-failed", "bmc-pre-config-pnuoslocal-failed", "bmc-pre-config-pnuospeer-failed", "bmc-preconfig-pnuoslocal-failed", "bmc-preconfig-pnuospeer-failed", "bmc-presence-failed", "bmc-shutdown-discovered-failed", "bmc-unconfig-pnuos-failed", "board-ctrl-upgraded", "boot-host-failed", "boot-pnuos-failed", "boot-wait-failed", "calculate-vlan-group-for-hostoslocal-failed", "calculate-vlan-group-for-hostospeer-failed", "callhome-config-error", "capacity-exceeded", "cartridge-moved", "certificate-empty-params", "certificate-unsupported", "chassis-intrusion", "chassis-limit-exceeded", "chassis-peer-adapter-reboot-failed", "check-adaptor-fw40gcap-failed", "check-assigned-default-identifiers-for-dup-failed", "check-assigned-identifiers-for-dup-failed", "check-inventory-status-failed", "check-license-failed", "check-power-availability-failed", "check-status-failed", "cimc-firmware-mismatch", "cimc-presence-failed", "cimcvlan-cfg-local-failed", "cimcvlan-cfg-peer-failed", "ciscoosopen-gate-failed", "clean-old-data-failed", "clean-upvifs-failed", "cleanup-entries-failed", "cleanup-failed", "cleanup-local-failed", "cleanup-nic-config-local-failed", "cleanup-nic-config-peer-failed", "cleanup-peer-failed", "cleanup-port-config-local-failed", "cleanup-port-config-peer-failed", "cleanup-vnics-local-failed", "cleanup-vnics-peer-failed", "cleanupcimc-failed", "clear-bios-update-failed", "clear-failed", "client-lost-connectivity", "cmc-vif-down", "cmcvlan-cfg-failed", "cmcvlan-cfg-peer-failed", "comm-svc-config-error", "commit-storage-failed", "complete-failed", "compr-sets-exhausted", "condition-cause-configuration-failure", "condition-cause-fault", "condition-cause-hardware-inventory-mismatch", "condition-cause-kernel-mem-critical-threshold", "condition-cause-pci-config-mismatch", "condition-cause-persistent-memory-detection", "config-backup-outdated", "config-bios-failed", "config-chassis-adapter-connectivity-failed", "config-chassis-id-failed", "config-cimcvmedia-failed", "config-discovery-mode-failed", "config-error", "config-ext-mgmt-gw-failed", "config-ext-mgmt-rules-failed", "config-failed", "config-fan-speed-failed", "config-fe-local-failed", "config-fe-peer-failed", "config-flex-flash-failed", "config-flex-flash-scrub-failed", "config-host-os-annotations-failed", "config-kvm-mgmt-default-setting-failed", "config-memory-policy-failed", "config-mgmt-ip-rules-failed", "config-mismatch", "config-missing", "config-niv-mode-failed", "config-problem", "config-server-identity-failed", "config-so-lfailed", "config-sw-afailed", "config-sw-bfailed", "config-switch-local-failed", "config-switch-peer-failed", "config-user-access-failed", "config-uuid-failed", "configbmcpower-params-failed", "configuration-applied", "configuration-applying", "configuration-error", "configuration-failed", "configuration-failure", "configuration-in-progress", "configuration-mismatch", "configuration-not-applied", "configure-end-point-failed", "configure-failed", "configure-sw-mgmt-end-point-failed", "configure-vif-ns-failed", "connection-unused", "connectivity-problem", "copy-all-images-to-peer-failed", "copy-cat-from-rep-failed", "copy-external-rep-to-remote-failed", "copy-img-from-rep-failed", "copy-primary-failed", "copy-remote-failed", "copy-sub-failed", "copyiomimg-to-sub-failed", "create-local-failed", "create-remote-failed", "deassert-reset-bypass-failed", "decomission-failed", "decommissioned", "default-hostpack-missing", "default-hostpack-missing-versions", "defaultauth-config-error", "delete-all-mo-refs-failed", "delete-curl-downloaded-images-failed", "delete-images-remote-failed", "delete-local-failed", "delete-primary-failed", "delete-remote-failed", "delete-sub-failed", "deploy-failed", "deprecated", "device-shared-storage-IO-error", "device-shared-storage-error", "disable-afailed", "disable-bfailed", "disable-end-point-failed", "disable-failed", "disable-scriptablevmedia-failed", "disassociation-failed", "discover-chassis-failed", "discover-sas-expander-failed", "discovery-failed", "discovery-in-progress", "disk-zoning-config-failed", "domain-config-error", "download-images-failed", "download-local-failed", "duplicated-assigned", "dvif-exhausted", "election-failure", "empty-pin-group", "empty-pool", "enable-afailed", "enable-bfailed", "enable-chassis-failed", "enable-failed", "enable-port-failed", "end-inventory-failed", "equipment-accessibility-problem", "equipment-config-error", "equipment-config-not-matching", "equipment-degraded", "equipment-deprecated", "equipment-disabled", "equipment-disconnected", "equipment-failed", "equipment-fru-missing", "equipment-hddslot-server2-ownership-unassigned", "equipment-hotspare-unsupported", "equipment-inaccessible", "equipment-inoperable", "equipment-inventory", "equipment-ioe-ownership-unassigned", "equipment-link-degraded", "equipment-link-misconnect", "equipment-missing", "equipment-namespace-not-matching", "equipment-non-optimal", "equipment-offline", "equipment-ownership-unsupported", "equipment-problem", "equipment-removed", "equipment-second-controller-absent", "equipment-unacknowledged", "equipment-unavailable", "equipment-unhealthy", "equipped-unsupported", "estimate-apply-config-failed", "evaluate-association-failed", "evaluate-status-failed", "execute-afailed", "execute-bfailed", "execute-failed", "execute-local-failed", "execute-peer-failed", "executepmaction-failed", "executevdaction-failed", "extra-primary-vlans", "extra-secondary-vlans", "extra-secondary-vlans-per-primary", "extra-vif", "fab-evac-off-remotefi-failed", "fab-evac-on-remotefi-failed", "fabric-evacuated", "fail-failed", "fail-over-to-remotefi-failed", "fan-removal", "fault", "fc-portchannel-members-inconsistent-speed", "fc-storageport-npv-mode", "fc-zoning-enabled", "fcoe-storageport-npv-mode", "fcoe-uplink-port-channel-unsupported-fi-settings", "fcoe-uplink-unsupported-fi-settings", "fex-unsupported", "fi-b-querier-ip-empty-or-same-as-primary", "file-transfer-failed", "finalize-failed", "firmware-upgrade-problem", "format-failed", "fru-problem", "fsm-failed", "full-inventory-failed", "get-version-failed", "graphics-image-update-failed", "group-cap-insufficient", "group-permit-unresolved", "ha-not-ready", "ha-ssh-keys-mismatched", "hag-connect-failed", "hag-disconnect-failed", "hag-hostosconnect-failed", "hag-pnuosconnect-failed", "hag-pnuosdisconnect-failed", "handle-pooling-failed", "hardware-inventory-mismatch", "hardware-mismatch", "hba-img-update-failed", "health-critical", "health-info", "health-led-amber", "health-led-amber-blinking", "health-major", "health-minor", "health-warning", "hostosconfig-failed", "hostosconnect-failed", "hostosident-failed", "hostospolicy-failed", "hostosvalidate-failed", "identify-failed", "identity-unestablishable", "iftmc-pv-exhausted", "igmp-group-exhausted", "image-cannot-boot", "image-corrupted", "image-deleted", "image-unusable", "in-maintenance", "inaccessible-vlan-referenced", "inband-unsupported-server", "incompatible-server-firmware", "incompatible-speed", "init-iptables-local-failed", "init-iptables-peer-failed", "inoperable", "insufficient-resources", "insufficiently-equipped", "interface-failed", "interface-misconfigured", "internal-backup-failed", "invalid-keyring-certificate", "invalid-keyring-modulus", "invalid-pinning", "invalid-server-group", "invalid-target", "invalid-trustpoint-cert-chain", "invalid-vlan-in-the-allowed-vlan-list", "inventory-failed", "kernel-mem-critical-threshold", "keyring-config-error", "kmip-cert-config-failed", "kmip-fault", "kmip-save-cert-failed", "leadershipChange", "license-file-not-deleted", "license-file-uninstallable", "license-graceperiod-10days", "license-graceperiod-119days", "license-graceperiod-30days", "license-graceperiod-60days", "license-graceperiod-90days", "license-graceperiod-entered", "license-graceperiod-expired", "license-insufficient", "limit-reached", "link-down", "link-misconnected", "link-missing", "load-catalog-failed", "local-disk-fw-update-failed", "local-failed", "local-internal-backup-failed", "locale-config-error", "locale-org-config-error", "log-capacity", "log-transfer-failed", "maintenance-failed", "management-services-failure", "management-services-unresponsive", "mark-adapter-for-reboot-failed", "max-vlan-limit-exceeded", "membership-down", "memory-error", "mgmt-db-corruption", "mgmtif-down", "missing-primary-vlan", "mount-local-failed", "mount-peer-failed", "mswitch-img-update-failed", "multicast-mac-exhausted", "multiple-connection-policies", "named-inband-vlan-unresolved", "named-policy-unresolved", "named-vlan-unresolved", "native-vlan-not-found", "ndisc-targets-config-error", "near-max-limit", "network-san-group-does-not-exist", "network-san-group-misconfigured", "new-link", "new-vnic-vcon-scheme-applied", "nic-config-hostoslocal-failed", "nic-config-hostospeer-failed", "nic-config-local-failed", "nic-config-params-hostoslocal-failed", "nic-config-params-hostospeer-failed", "nic-config-peer-failed", "nic-config-pnuoslocal-failed", "nic-config-pnuospeer-failed", "nic-config-service-infra-local-failed", "nic-config-service-infra-peer-failed", "nic-img-update-failed", "nic-inventory-local-failed", "nic-inventory-peer-failed", "nic-presence-local-failed", "nic-presence-peer-failed", "nic-un-config-local-failed", "nic-un-config-peer-failed", "nic-unconfig-hostoslocal-failed", "nic-unconfig-hostospeer-failed", "nic-unconfig-pnuoslocal-failed", "nic-unconfig-pnuospeer-failed", "nic-unconfig-service-infra-local-failed", "nic-unconfig-service-infra-peer-failed", "no-ack-from-bios", "no-cap-fail", "no-vlan-optimization", "non-existent-scheduler", "not-supported", "old-chassis-component-firmware", "old-firmware", "oob-disk-scrub-failed", "oob-poll-sas-expander-activate-status-failed", "oob-poll-sas-expander-boot-img-activate-status-failed", "oob-poll-sas-expander-update-status-failed", "oob-sas-expander-boot-img-activate-failed", "oob-sas-expander-img-activate-failed", "oob-sas-expander-img-update-failed", "oob-storage-config-failed", "oob-storage-inventory-failed", "operation-failed", "operational-state-down", "pair-failed", "pci-config-issue", "pci-config-mismatch", "pci-switch-image-update-failed", "peer-failed", "performance-problem", "persistent-memory-detection", "persistent-memory-dimm-fw-update-failed", "ping-failed", "pinning-misconfig", "pinning-mismatch", "pld-firmware-mismatch", "pnuos-boot-wait-failed", "pnuoscatalog-failed", "pnuosconfig-failed", "pnuosconn-status-failed", "pnuosconnectivity-failed", "pnuosident-failed", "pnuosinventory-failed", "pnuoslocal-disk-config-failed", "pnuosperipheral-component-config-failed", "pnuospolicy-failed", "pnuospower-profiling-failed", "pnuosscrub-failed", "pnuosself-test-failed", "pnuosunconfig-failed", "pnuosunload-drivers-failed", "pnuosvalidate-failed", "poll-activate-failed", "poll-activate-of-localfi-failed", "poll-activate-of-remotefi-failed", "poll-activate-ofiom-failed", "poll-activate-ofucsm-failed", "poll-activate-ofucsmservice-pack-failed", "poll-activate-status-failed", "poll-activation-failed", "poll-adaptor-activation-failed", "poll-bios-activate-status-failed", "poll-bios-update-status-failed", "poll-board-ctrl-power-cycle-failed", "poll-board-ctrl-update-status-failed", "poll-brd-ctlr-activation-failed", "poll-clear-bios-update-status-failed", "poll-clear-status-failed", "poll-cmc-activation-failed", "poll-fab-evac-off-remotefi-failed", "poll-fab-evac-on-remotefi-failed", "poll-fail-over-to-remotefi-failed", "poll-internal-backup-failed", "poll-local-disk-activate-failed", "poll-post-disk-zone-storage-invcimc-failed", "poll-sas-expander-activate-failed", "poll-sas-expander-config-failed", "poll-secure-boot-status-failed", "poll-storage-ctlr-activation-failed", "poll-update-adaptor-failed", "poll-update-cmc-failed", "poll-update-ofiom-failed", "poll-update-sas-expander-failed", "poll-update-status-failed", "poll-update-status-local-failed", "poll-update-status-peer-failed", "poll-update-storage-invcimc-failed", "poll-wait-for-user-ack-failed", "port-failed", "port-inventory-sw-afailed", "port-inventory-sw-bfailed", "port-misconfigure", "post-disk-zone-storage-invcimc-failed", "post-disk-zone-storage-invcmc-failed", "post-scrub-oob-storage-inventory-failed", "post-set-key-ring-local-failed", "post-set-key-ring-peer-failed", "power-budget-unavailable", "power-button-lock-config-failed", "power-cap-fail", "power-consumption-hit-limit", "power-cycle-board-failed", "power-cycle-failed", "power-deploy-wait-failed", "power-down", "power-off-failed", "power-off-reclaim-failed", "power-off-servers-failed", "power-off-wait-failed", "power-on-failed", "power-on-pre-config-failed", "power-on-servers-failed", "power-on-wait-failed", "power-problem", "powered-off", "pre-sanitize-failed", "precleanup-port-config-failed", "preconfig-vmedia-local-failed", "preconfig-vmedia-peer-failed", "prepare-for-boot-failed", "prepare-for-update-failed", "primary-failed", "primary-vlan-missing-for-community", "primary-vlan-missing-for-isolated", "profile-config-incorrect", "propogate-ep-settings-failed", "propogate-ep-time-zone-settings-local-failed", "propogate-ep-time-zone-settings-peer-failed", "propogate-ep-time-zone-settings-to-adaptors-local-failed", "propogate-ep-time-zone-settings-to-adaptors-peer-failed", "propogate-ep-time-zone-settings-to-fex-iom-local-failed", "propogate-ep-time-zone-settings-to-fex-iom-peer-failed", "provider-group-already-exists", "provider-group-size-empty", "provision-storage-failed", "psu-insufficient", "psu-mixed-mode", "psu-redundancy-fail", "pvlif-vlan-mbr-exhausted", "pvsystem-exhausted", "read-sm-bios-failed", "read-smbios-failed", "reconfig-bios-failed", "reconfig-uuid-failed", "referenced-remote-vlan-unresolvable", "referenced-remote-vsan-unresolvable", "referenced-vlan-unresolvable", "referenced-vsan-unresolvable", "register-client-failed", "release-all-failed", "release-failed", "release-many-failed", "remote-failed", "remove-failed", "remove-local-failed", "remove-peer-failed", "replication-failure", "report-error-failed", "report-failed", "report-fault-inventory-failed", "report-org-inventory-failed", "report-physical-inventory-failed", "report-results-failed", "report-storage-inventory-failed", "request-failed", "rescan-images-failed", "reset-cimc-failed", "reset-failed", "reset-local-failed", "reset-remote-failed", "reset-sas-expander-failed", "reset-secure-boot-config-failed", "resetibmc-failed", "resolve-all-failed", "resolve-boot-config-failed", "resolve-default-identifiers-failed", "resolve-distributable-failed", "resolve-distributable-names-failed", "resolve-failed", "resolve-from-ops-mgr-failed", "resolve-from-policy-mgr-failed", "resolve-identifiers-failed", "resolve-images-failed", "resolve-many-failed", "resolve-network-policies-failed", "resolve-network-templates-failed", "resolve-policies-failed", "resolve-schedule-failed", "resolve-storage-schedule-failed", "restore-vd-status-failed", "role-config-error", "run-tests-failed", "sanitize-failed", "sas-expander-config-failed", "sas-expander-img-update-failed", "satellite-connection-absent", "satellite-connection-init", "satellite-mis-connected", "secondary-failed", "send-bmc-profiling-done-failed", "send-bmc-profiling-init-failed", "serial-debug-connect-failed", "serial-debug-disconnect-failed", "serial-debug-pnuosconnect-failed", "serial-debug-pnuosdisconnect-failed", "server-assigned", "server-associated", "server-associating", "server-deassociating", "server-error", "server-failed", "server-identification-problem", "server-inaccessible", "server-moved", "server-power-off-failed", "server-power-on-failed", "server-unassigned", "server-unassociated", "servers-power-off-completion-failed", "set-ep-afailed", "set-ep-bfailed", "set-ep-local-failed", "set-ep-peer-failed", "set-key-ring-local-failed", "set-key-ring-peer-failed", "set-local-failed", "set-peer-failed", "set-realm-local-failed", "set-realm-peer-failed", "set-user-local-failed", "set-user-peer-failed", "setup-boot-environment-failed", "setup-vmedia-failed", "setup-vmedia-local-failed", "setup-vmedia-peer-failed", "shared-components-oob-inventory-failed", "shared-components-oob-inventory-peer-failed", "sharediomodule-inventory-failed", "shutdown-failed", "slow-drain-recovery-failure", "snmp-config-error", "snmp-user-config-error", "soft-shutdown-failed", "sol-redirect-disable-failed", "sol-redirect-enable-failed", "spdm-fault", "standbycmcvlan-cfg-failed", "start-failed", "stopvmedia-local-failed", "stopvmedia-peer-failed", "storage-ctlr-img-update-failed", "storage-inventory-failed", "success-failed", "suppress-status-change", "suspend-mode-entered", "svnic-not-present", "sw-config-hostoslocal-failed", "sw-config-hostospeer-failed", "sw-config-local-failed", "sw-config-peer-failed", "sw-config-pnuoslocal-failed", "sw-config-pnuospeer-failed", "sw-config-port-niv-local-failed", "sw-config-port-niv-peer-failed", "sw-config-service-infra-local-failed", "sw-config-service-infra-peer-failed", "sw-configure-conn-local-failed", "sw-configure-conn-peer-failed", "sw-configure-port-channel-local-failed", "sw-configure-port-channel-peer-failed", "sw-hostosconfigure-port-channel-local-failed", "sw-hostosconfigure-port-channel-peer-failed", "sw-hostosmulti-port-connectivity-local-failed", "sw-hostosmulti-port-connectivity-peer-failed", "sw-pnuosconnectivity-local-failed", "sw-pnuosconnectivity-peer-failed", "sw-port-details-local-failed", "sw-port-details-peer-failed", "sw-un-config-local-failed", "sw-un-config-peer-failed", "sw-unconfig-hostoslocal-failed", "sw-unconfig-hostospeer-failed", "sw-unconfig-pnuoslocal-failed", "sw-unconfig-pnuospeer-failed", "sw-unconfig-port-niv-local-failed", "sw-unconfig-port-niv-peer-failed", "sw-unconfigure-local-failed", "sw-unconfigure-peer-failed", "switch-failed", "sync-bladeaglocal-failed", "sync-bladeagremote-failed", "sync-failed", "sync-hostagentaglocal-failed", "sync-hostagentagremote-failed", "sync-nicaglocal-failed", "sync-nicagremote-failed", "sync-portaglocal-failed", "sync-portagremote-failed", "sync-power-state-failed", "tear-down-boot-environment-failed", "tear-downvmedia-local-failed", "tear-downvmedia-peer-failed", "teardown-vmedia-local-failed", "teardown-vmedia-peer-failed", "tftp-server-error", "thermal-problem", "threshold-crossed", "timezone-file-not-exists", "tpm-mismatch", "tpm-on-slave-board", "transceiver-mismatch", "transition", "ucsm-process-failure", "udld-link-down", "un-identify-local-failed", "un-identify-peer-failed", "unassociated", "unclaimed-device", "unconfig-bios-failed", "unconfig-cimcvmedia-failed", "unconfig-ext-mgmt-gw-failed", "unconfig-ext-mgmt-rules-failed", "unconfig-flex-flash-failed", "unconfig-server-identity-failed", "unconfig-so-lfailed", "unconfig-uuid-failed", "unconfig-vmedia-failed", "unconfiguration-in-progress", "under-test", "unexpected-number-of-links", "unicast-mac-exhausted", "unidentifiable-fru", "unknown", "unlock-firmware-image-failed", "unmount-local-failed", "unmount-peer-failed", "unpack-local-failed", "unregister-failed", "unsecure-adaptor", "unsecured-fpga", "unsupported-cimc-firmware", "unsupported-config", "unsupported-connectivity", "unsupported-connectivity-configuration", "unsupported-policy-config", "unsupported-transceiver", "update-adaptor-failed", "update-adaptor-nw-fw-local-failed", "update-adaptor-nw-fw-peer-failed", "update-bios-request-failed", "update-board-ctrl-request-failed", "update-cmc-failed", "update-connectivity-failed", "update-eth-flow-mon-failed", "update-eth-mon-failed", "update-failed", "update-fc-mon-failed", "update-flash-life-failed", "update-local-failed", "update-remote-failed", "update-request-failed", "update-request-local-failed", "update-request-peer-failed", "update-sas-expander-failed", "update-sp-local-failed", "update-sp-remote-failed", "update-storage-invcimc-failed", "update-storage-invcmc-failed", "update-tokens-failed", "update-vlan-groups-failed", "update-zones-failed", "updateibmcfw-failed", "updateiom-failed", "upload-failed", "user-config-error", "user-locale-config-error", "user-role-config-error", "validate-configuration-failed", "validate-local-failed", "validate-policy-ownership-failed", "validate-remote-failed", "validate-removal-failed", "verify-breakout-config-failed", "verify-failed", "verify-fc-zone-config-failed", "verify-guid-failed", "verify-local-failed", "verify-phys-config-failed", "verify-registration-failed", "verify-remote-failed", "verify-user-zone-config-failed", "version-incompatible", "versionHolderChange", "vhba-not-supported", "vif-down", "vif-ids-mismatch", "vlan-comp-grp-count-exceeds-limit", "vlan-compression", "vlan-conflict-permit", "vlan-error-assoc-primary", "vlan-mcast-policy-misconfigured", "vlan-misconfigured", "vlan-mismatch", "vlan-permit-unresolved", "vm-network-reference-incorrect", "vmedia-mount-inaccessible", "voltage-problem", "vsan-exceed-limit", "vsan-misconfigured", "wait-before-installation-failed", "wait-failed", "wait-for-ack-failed", "wait-for-activation-failed", "wait-for-adaptor-nw-fw-update-local-failed", "wait-for-adaptor-nw-fw-update-peer-failed", "wait-for-assoc-completion-failed", "wait-for-border-config-completion-local-failed", "wait-for-border-config-completion-peer-failed", "wait-for-commit-storage-failed", "wait-for-conn-ready-failed", "wait-for-debug-failed", "wait-for-deploy-failed", "wait-for-maint-permission-failed", "wait-for-maint-window-failed", "wait-for-power-off-failed", "wait-for-storage-provision-failed", "wait-for-user-ack-failed", "wait-foribmcfw-update-failed", "wait-on-phys-failed", "wait-on-sw-config-host-failed"], []),
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version211a, MoPropertyMeta.INTERNAL, 0x4, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []),
        "descr": MoPropertyMeta("descr", "descr", "string", VersionMeta.Version211a, MoPropertyMeta.READ_WRITE, 0x8, None, None, r"""[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], []),
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, 0x10, 0, 256, None, [], []),
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, 0x20, 0, 256, None, [], []),
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302c, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []),
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version211a, MoPropertyMeta.READ_WRITE, 0x40, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []),
        "type": MoPropertyMeta("type", "type", "string", VersionMeta.Version211a, MoPropertyMeta.NAMING, 0x80, None, None, None, ["any", "chassis-profile", "configuration", "connectivity", "environmental", "equipment", "forward", "fsm", "generic", "management", "network", "operational", "security", "server", "sysdebug"], []),
    }

    prop_map = {
        "cause": "cause", 
        "childAction": "child_action", 
        "descr": "descr", 
        "dn": "dn", 
        "rn": "rn", 
        "sacl": "sacl", 
        "status": "status", 
        "type": "type", 
    }

    def __init__(self, parent_mo_or_dn, type, cause, **kwargs):
        self._dirty_mask = 0
        self.type = type
        self.cause = cause
        self.child_action = None
        self.descr = None
        self.sacl = None
        self.status = None

        ManagedObject.__init__(self, "FaultSuppressPolicyItem", parent_mo_or_dn, **kwargs)
