"""This module contains the general information for FaultAffectedClass ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class FaultAffectedClassConsts:
    MO_CLASS_ID_AAA_AUTH_METHOD = "aaaAuthMethod"
    MO_CLASS_ID_AAA_AUTH_REALM = "aaaAuthRealm"
    MO_CLASS_ID_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    MO_CLASS_ID_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    MO_CLASS_ID_AAA_BANNER = "aaaBanner"
    MO_CLASS_ID_AAA_CIMC_SESSION = "aaaCimcSession"
    MO_CLASS_ID_AAA_CONFIG = "aaaConfig"
    MO_CLASS_ID_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    MO_CLASS_ID_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    MO_CLASS_ID_AAA_DEFINITION = "aaaDefinition"
    MO_CLASS_ID_AAA_DOMAIN = "aaaDomain"
    MO_CLASS_ID_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    MO_CLASS_ID_AAA_EP = "aaaEp"
    MO_CLASS_ID_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    MO_CLASS_ID_AAA_EP_FSM = "aaaEpFsm"
    MO_CLASS_ID_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    MO_CLASS_ID_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    MO_CLASS_ID_AAA_EP_LOGIN = "aaaEpLogin"
    MO_CLASS_ID_AAA_EP_USER = "aaaEpUser"
    MO_CLASS_ID_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    MO_CLASS_ID_AAA_ITEM = "aaaItem"
    MO_CLASS_ID_AAA_LDAP_EP = "aaaLdapEp"
    MO_CLASS_ID_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    MO_CLASS_ID_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    MO_CLASS_ID_AAA_LDAP_GROUP = "aaaLdapGroup"
    MO_CLASS_ID_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    MO_CLASS_ID_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    MO_CLASS_ID_AAA_LOCAL_MGMT_CMD_LOG = "aaaLocalMgmtCmdLog"
    MO_CLASS_ID_AAA_LOCALE = "aaaLocale"
    MO_CLASS_ID_AAA_LOG = "aaaLog"
    MO_CLASS_ID_AAA_LOGIN_PROFILE = "aaaLoginProfile"
    MO_CLASS_ID_AAA_MOD_LR = "aaaModLR"
    MO_CLASS_ID_AAA_ORG = "aaaOrg"
    MO_CLASS_ID_AAA_PRE_LOGIN_BANNER = "aaaPreLoginBanner"
    MO_CLASS_ID_AAA_PROVIDER = "aaaProvider"
    MO_CLASS_ID_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    MO_CLASS_ID_AAA_PROVIDER_REF = "aaaProviderRef"
    MO_CLASS_ID_AAA_PWD_PROFILE = "aaaPwdProfile"
    MO_CLASS_ID_AAA_RADIUS_EP = "aaaRadiusEp"
    MO_CLASS_ID_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    MO_CLASS_ID_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    MO_CLASS_ID_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    MO_CLASS_ID_AAA_REALM = "aaaRealm"
    MO_CLASS_ID_AAA_REALM_FSM = "aaaRealmFsm"
    MO_CLASS_ID_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    MO_CLASS_ID_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    MO_CLASS_ID_AAA_REMOTE_USER = "aaaRemoteUser"
    MO_CLASS_ID_AAA_ROLE = "aaaRole"
    MO_CLASS_ID_AAA_SESSION = "aaaSession"
    MO_CLASS_ID_AAA_SESSION_INFO = "aaaSessionInfo"
    MO_CLASS_ID_AAA_SESSION_INFO_TABLE = "aaaSessionInfoTable"
    MO_CLASS_ID_AAA_SESSION_LR = "aaaSessionLR"
    MO_CLASS_ID_AAA_SHELL_LOGIN = "aaaShellLogin"
    MO_CLASS_ID_AAA_SSH_AUTH = "aaaSshAuth"
    MO_CLASS_ID_AAA_SYSTEM_USER = "aaaSystemUser"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    MO_CLASS_ID_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    MO_CLASS_ID_AAA_USER = "aaaUser"
    MO_CLASS_ID_AAA_USER_ACTION = "aaaUserAction"
    MO_CLASS_ID_AAA_USER_DATA = "aaaUserData"
    MO_CLASS_ID_AAA_USER_EP = "aaaUserEp"
    MO_CLASS_ID_AAA_USER_EP_FSM = "aaaUserEpFsm"
    MO_CLASS_ID_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    MO_CLASS_ID_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    MO_CLASS_ID_AAA_USER_GROUP = "aaaUserGroup"
    MO_CLASS_ID_AAA_USER_LOCALE = "aaaUserLocale"
    MO_CLASS_ID_AAA_USER_LOGIN = "aaaUserLogin"
    MO_CLASS_ID_AAA_USER_ROLE = "aaaUserRole"
    MO_CLASS_ID_AAA_WEB_LOGIN = "aaaWebLogin"
    MO_CLASS_ID_ADAPTOR_AZURE_QOS_PROFILE = "adaptorAzureQosProfile"
    MO_CLASS_ID_ADAPTOR_BEH_CAP = "adaptorBehCap"
    MO_CLASS_ID_ADAPTOR_CIO_EP = "adaptorCIoEp"
    MO_CLASS_ID_ADAPTOR_CAP_DEF = "adaptorCapDef"
    MO_CLASS_ID_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    MO_CLASS_ID_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    MO_CLASS_ID_ADAPTOR_DIAG_CAP = "adaptorDiagCap"
    MO_CLASS_ID_ADAPTOR_DYNAMIC_CONFIG_CAP = "adaptorDynamicConfigCap"
    MO_CLASS_ID_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    MO_CLASS_ID_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    MO_CLASS_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    MO_CLASS_ID_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    MO_CLASS_ID_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    MO_CLASS_ID_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    MO_CLASS_ID_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    MO_CLASS_ID_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    MO_CLASS_ID_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    MO_CLASS_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    MO_CLASS_ID_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM = "adaptorExtEthIfFsm"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE = "adaptorExtEthIfFsmStage"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK = "adaptorExtEthIfFsmTask"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_PC = "adaptorExtEthIfPc"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_PC_EP = "adaptorExtEthIfPcEp"
    MO_CLASS_ID_ADAPTOR_EXT_IF = "adaptorExtIf"
    MO_CLASS_ID_ADAPTOR_EXT_IF_EP = "adaptorExtIfEp"
    MO_CLASS_ID_ADAPTOR_EXT_IF_PC = "adaptorExtIfPc"
    MO_CLASS_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    MO_CLASS_ID_ADAPTOR_EXTERNAL_EP = "adaptorExternalEp"
    MO_CLASS_ID_ADAPTOR_EXTERNAL_PC = "adaptorExternalPc"
    MO_CLASS_ID_ADAPTOR_FAMILY_TYPE_DEF = "adaptorFamilyTypeDef"
    MO_CLASS_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    MO_CLASS_ID_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    MO_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    MO_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    MO_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    MO_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    MO_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    MO_CLASS_ID_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_OEIF = "adaptorFcOEIf"
    MO_CLASS_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    MO_CLASS_ID_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_VHBA_TYPE_PROFILE = "adaptorFcVhbaTypeProfile"
    MO_CLASS_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    MO_CLASS_ID_ADAPTOR_FRU_CAP_REF = "adaptorFruCapRef"
    MO_CLASS_ID_ADAPTOR_FW_CAP_PROVIDER = "adaptorFwCapProvider"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM = "adaptorHostEthIfFsm"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE = "adaptorHostEthIfFsmStage"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK = "adaptorHostEthIfFsmTask"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM = "adaptorHostFcIfFsm"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE = "adaptorHostFcIfFsmStage"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM_TASK = "adaptorHostFcIfFsmTask"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_IF = "adaptorHostIf"
    MO_CLASS_ID_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    MO_CLASS_ID_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    MO_CLASS_ID_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    MO_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_MGMT_CAP = "adaptorHostMgmtCap"
    MO_CLASS_ID_ADAPTOR_HOST_PORT = "adaptorHostPort"
    MO_CLASS_ID_ADAPTOR_HOST_PORT_CAP = "adaptorHostPortCap"
    MO_CLASS_ID_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    MO_CLASS_ID_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    MO_CLASS_ID_ADAPTOR_HOST_SERVICE_ETH_IF = "adaptorHostServiceEthIf"
    MO_CLASS_ID_ADAPTOR_HOST_VNIC_HW_ADDR_CAP = "adaptorHostVnicHwAddrCap"
    MO_CLASS_ID_ADAPTOR_HOSTETH_HW_ADDR_CAP = "adaptorHostethHwAddrCap"
    MO_CLASS_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP = "adaptorHostfcHwAddrCap"
    MO_CLASS_ID_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    MO_CLASS_ID_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    MO_CLASS_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    MO_CLASS_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    MO_CLASS_ID_ADAPTOR_ISCSI_AUTH = "adaptorIscsiAuth"
    MO_CLASS_ID_ADAPTOR_ISCSI_PROT = "adaptorIscsiProt"
    MO_CLASS_ID_ADAPTOR_ISCSI_TARGET_IF = "adaptorIscsiTargetIf"
    MO_CLASS_ID_ADAPTOR_LAN_CAP = "adaptorLanCap"
    MO_CLASS_ID_ADAPTOR_LLDP_CAP = "adaptorLldpCap"
    MO_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    MO_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    MO_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    MO_CLASS_ID_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    MO_CLASS_ID_ADAPTOR_MGMT_CAP = "adaptorMgmtCap"
    MO_CLASS_ID_ADAPTOR_MGMT_VNIC_ETH_CONFIG = "adaptorMgmtVnicEthConfig"
    MO_CLASS_ID_ADAPTOR_NW_MGMT_CAP = "adaptorNwMgmtCap"
    MO_CLASS_ID_ADAPTOR_NW_STATS_MGMT_CAP = "adaptorNwStatsMgmtCap"
    MO_CLASS_ID_ADAPTOR_PIO_EP = "adaptorPIoEp"
    MO_CLASS_ID_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    MO_CLASS_ID_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    MO_CLASS_ID_ADAPTOR_QUAL = "adaptorQual"
    MO_CLASS_ID_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    MO_CLASS_ID_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    MO_CLASS_ID_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    MO_CLASS_ID_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    MO_CLASS_ID_ADAPTOR_SAN_CAP = "adaptorSanCap"
    MO_CLASS_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    MO_CLASS_ID_ADAPTOR_UNIT = "adaptorUnit"
    MO_CLASS_ID_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    MO_CLASS_ID_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    MO_CLASS_ID_ADAPTOR_UPLINK_HW_ADDR_CAP = "adaptorUplinkHwAddrCap"
    MO_CLASS_ID_ADAPTOR_UPLINK_PORT_STATS = "adaptorUplinkPortStats"
    MO_CLASS_ID_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    MO_CLASS_ID_ADAPTOR_VLAN = "adaptorVlan"
    MO_CLASS_ID_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    MO_CLASS_ID_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    MO_CLASS_ID_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    MO_CLASS_ID_ADAPTOR_VSAN = "adaptorVsan"
    MO_CLASS_ID_APE_ADAPTER = "apeAdapter"
    MO_CLASS_ID_APE_ADAPTER_VNIC = "apeAdapterVnic"
    MO_CLASS_ID_APE_ATTRIBUTE = "apeAttribute"
    MO_CLASS_ID_APE_BOOT_METHOD = "apeBootMethod"
    MO_CLASS_ID_APE_CONTROLLER_CHASSIS = "apeControllerChassis"
    MO_CLASS_ID_APE_CONTROLLER_EEPROM = "apeControllerEeprom"
    MO_CLASS_ID_APE_CONTROLLER_MANAGER = "apeControllerManager"
    MO_CLASS_ID_APE_DCOS_AG_MANAGER = "apeDcosAgManager"
    MO_CLASS_ID_APE_FRU = "apeFru"
    MO_CLASS_ID_APE_HOST_AGENT = "apeHostAgent"
    MO_CLASS_ID_APE_LANBOOT = "apeLANBoot"
    MO_CLASS_ID_APE_LOCAL_DISK_BOOT = "apeLocalDiskBoot"
    MO_CLASS_ID_APE_MANAGER = "apeManager"
    MO_CLASS_ID_APE_MC = "apeMc"
    MO_CLASS_ID_APE_MC_STATS = "apeMcStats"
    MO_CLASS_ID_APE_MC_TABLE = "apeMcTable"
    MO_CLASS_ID_APE_MENLO = "apeMenlo"
    MO_CLASS_ID_APE_MENLO_VNIC = "apeMenloVnic"
    MO_CLASS_ID_APE_MENLO_VNIC_STATS = "apeMenloVnicStats"
    MO_CLASS_ID_APE_NIC_AG_MANAGER = "apeNicAgManager"
    MO_CLASS_ID_APE_PALO = "apePalo"
    MO_CLASS_ID_APE_PALO_VNIC = "apePaloVnic"
    MO_CLASS_ID_APE_PALO_VNIC_STATS = "apePaloVnicStats"
    MO_CLASS_ID_APE_PARAM = "apeParam"
    MO_CLASS_ID_APE_READING = "apeReading"
    MO_CLASS_ID_APE_SANBOOT = "apeSANBoot"
    MO_CLASS_ID_APE_SDR = "apeSdr"
    MO_CLASS_ID_APE_SWITCH_FIRMWARE_INV = "apeSwitchFirmwareInv"
    MO_CLASS_ID_APE_VIRTUAL_MEDIA_BOOT = "apeVirtualMediaBoot"
    MO_CLASS_ID_APE_VNIC_STATS = "apeVnicStats"
    MO_CLASS_ID_BIOS_AREF = "biosARef"
    MO_CLASS_ID_BIOS_BOT = "biosBOT"
    MO_CLASS_ID_BIOS_BOOT_DEV = "biosBootDev"
    MO_CLASS_ID_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    MO_CLASS_ID_BIOS_FEATURE_REF = "biosFeatureRef"
    MO_CLASS_ID_BIOS_PARAMETER_REF = "biosParameterRef"
    MO_CLASS_ID_BIOS_REF = "biosRef"
    MO_CLASS_ID_BIOS_SETTING_REF = "biosSettingRef"
    MO_CLASS_ID_BIOS_SETTINGS = "biosSettings"
    MO_CLASS_ID_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    MO_CLASS_ID_BIOS_TOKEN_PARAM = "biosTokenParam"
    MO_CLASS_ID_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    MO_CLASS_ID_BIOS_UNIT = "biosUnit"
    MO_CLASS_ID_BIOS_VFEAT = "biosVFeat"
    MO_CLASS_ID_BIOS_VIDENTITY_PARAMS = "biosVIdentityParams"
    MO_CLASS_ID_BIOS_VPROFILE = "biosVProfile"
    MO_CLASS_ID_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    MO_CLASS_ID_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    MO_CLASS_ID_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    MO_CLASS_ID_BIOS_VF_ALTITUDE = "biosVfAltitude"
    MO_CLASS_ID_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    MO_CLASS_ID_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    MO_CLASS_ID_BIOS_VF_BMEDMAMITIGATION = "biosVfBMEDMAMitigation"
    MO_CLASS_ID_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    MO_CLASS_ID_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    MO_CLASS_ID_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    MO_CLASS_ID_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    MO_CLASS_ID_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    MO_CLASS_ID_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    MO_CLASS_ID_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    MO_CLASS_ID_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    MO_CLASS_ID_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    MO_CLASS_ID_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    MO_CLASS_ID_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    MO_CLASS_ID_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    MO_CLASS_ID_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    MO_CLASS_ID_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    MO_CLASS_ID_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    MO_CLASS_ID_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    MO_CLASS_ID_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    MO_CLASS_ID_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    MO_CLASS_ID_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    MO_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    MO_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    MO_CLASS_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    MO_CLASS_ID_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    MO_CLASS_ID_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    MO_CLASS_ID_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    MO_CLASS_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    MO_CLASS_ID_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    MO_CLASS_ID_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    MO_CLASS_ID_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    MO_CLASS_ID_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    MO_CLASS_ID_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    MO_CLASS_ID_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    MO_CLASS_ID_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    MO_CLASS_ID_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    MO_CLASS_ID_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    MO_CLASS_ID_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    MO_CLASS_ID_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    MO_CLASS_ID_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    MO_CLASS_ID_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    MO_CLASS_ID_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    MO_CLASS_ID_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    MO_CLASS_ID_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    MO_CLASS_ID_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    MO_CLASS_ID_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    MO_CLASS_ID_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    MO_CLASS_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    MO_CLASS_ID_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    MO_CLASS_ID_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    MO_CLASS_ID_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    MO_CLASS_ID_BIOS_VF_PANIC_AND_HIGH_WATERMARK = "biosVfPanicAndHighWatermark"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    MO_CLASS_ID_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    MO_CLASS_ID_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    MO_CLASS_ID_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    MO_CLASS_ID_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    MO_CLASS_ID_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    MO_CLASS_ID_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    MO_CLASS_ID_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    MO_CLASS_ID_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    MO_CLASS_ID_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    MO_CLASS_ID_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    MO_CLASS_ID_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    MO_CLASS_ID_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    MO_CLASS_ID_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    MO_CLASS_ID_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    MO_CLASS_ID_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    MO_CLASS_ID_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    MO_CLASS_ID_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    MO_CLASS_ID_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    MO_CLASS_ID_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    MO_CLASS_ID_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    MO_CLASS_ID_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    MO_CLASS_ID_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    MO_CLASS_ID_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    MO_CLASS_ID_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    MO_CLASS_ID_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    MO_CLASS_ID_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    MO_CLASS_ID_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    MO_CLASS_ID_BMC_SELCOUNTER = "bmcSELCounter"
    MO_CLASS_ID_CALLHOME_ANONYMOUS_REPORTING = "callhomeAnonymousReporting"
    MO_CLASS_ID_CALLHOME_DEST = "callhomeDest"
    MO_CLASS_ID_CALLHOME_EP = "callhomeEp"
    MO_CLASS_ID_CALLHOME_EP_FSM = "callhomeEpFsm"
    MO_CLASS_ID_CALLHOME_EP_FSM_STAGE = "callhomeEpFsmStage"
    MO_CLASS_ID_CALLHOME_EP_FSM_TASK = "callhomeEpFsmTask"
    MO_CLASS_ID_CALLHOME_ITEM = "callhomeItem"
    MO_CLASS_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    MO_CLASS_ID_CALLHOME_POLICY = "callhomePolicy"
    MO_CLASS_ID_CALLHOME_PROFILE = "callhomeProfile"
    MO_CLASS_ID_CALLHOME_SMTP = "callhomeSmtp"
    MO_CLASS_ID_CALLHOME_SOURCE = "callhomeSource"
    MO_CLASS_ID_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    MO_CLASS_ID_CAPABILITY_AEND_POINT_CONFIG = "capabilityAEndPointConfig"
    MO_CLASS_ID_CAPABILITY_ASOLUTION_STACK = "capabilityASolutionStack"
    MO_CLASS_ID_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    MO_CLASS_ID_CAPABILITY_CATALOGUE_FSM = "capabilityCatalogueFsm"
    MO_CLASS_ID_CAPABILITY_CATALOGUE_FSM_STAGE = "capabilityCatalogueFsmStage"
    MO_CLASS_ID_CAPABILITY_CATALOGUE_FSM_TASK = "capabilityCatalogueFsmTask"
    MO_CLASS_ID_CAPABILITY_DEF = "capabilityDef"
    MO_CLASS_ID_CAPABILITY_EP = "capabilityEp"
    MO_CLASS_ID_CAPABILITY_FEATURE_LIMITS = "capabilityFeatureLimits"
    MO_CLASS_ID_CAPABILITY_ITEM = "capabilityItem"
    MO_CLASS_ID_CAPABILITY_MGMT_EXTENSION = "capabilityMgmtExtension"
    MO_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM = "capabilityMgmtExtensionFsm"
    MO_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE = "capabilityMgmtExtensionFsmStage"
    MO_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK = "capabilityMgmtExtensionFsmTask"
    MO_CLASS_ID_CAPABILITY_NETWORK_LIMITS = "capabilityNetworkLimits"
    MO_CLASS_ID_CAPABILITY_PROVIDER = "capabilityProvider"
    MO_CLASS_ID_CAPABILITY_STORAGE_LIMITS = "capabilityStorageLimits"
    MO_CLASS_ID_CAPABILITY_SYSTEM_LIMITS = "capabilitySystemLimits"
    MO_CLASS_ID_CAPABILITY_UPDATE = "capabilityUpdate"
    MO_CLASS_ID_CAPABILITY_UPDATER = "capabilityUpdater"
    MO_CLASS_ID_CAPABILITY_UPDATER_FSM = "capabilityUpdaterFsm"
    MO_CLASS_ID_CAPABILITY_UPDATER_FSM_STAGE = "capabilityUpdaterFsmStage"
    MO_CLASS_ID_CAPABILITY_UPDATER_FSM_TASK = "capabilityUpdaterFsmTask"
    MO_CLASS_ID_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    MO_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    MO_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    MO_CLASS_ID_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    MO_CLASS_ID_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    MO_CLASS_ID_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    MO_CLASS_ID_CLITEST_TYPE_TEST = "clitestTypeTest"
    MO_CLASS_ID_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    MO_CLASS_ID_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    MO_CLASS_ID_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    MO_CLASS_ID_CLOUD_DEVICE_CONNECTOR_EP = "cloudDeviceConnectorEp"
    MO_CLASS_ID_CLOUD_MGMT_SVC = "cloudMgmtSvc"
    MO_CLASS_ID_COMM_CIMC_WEB_SERVICE = "commCimcWebService"
    MO_CLASS_ID_COMM_CIMXML = "commCimxml"
    MO_CLASS_ID_COMM_CLIENT = "commClient"
    MO_CLASS_ID_COMM_CLIENT_ITEM = "commClientItem"
    MO_CLASS_ID_COMM_DATE_TIME = "commDateTime"
    MO_CLASS_ID_COMM_DEFINITION = "commDefinition"
    MO_CLASS_ID_COMM_DNS = "commDns"
    MO_CLASS_ID_COMM_DNS_PROVIDER = "commDnsProvider"
    MO_CLASS_ID_COMM_EVT_CHANNEL = "commEvtChannel"
    MO_CLASS_ID_COMM_HTTP = "commHttp"
    MO_CLASS_ID_COMM_HTTPS = "commHttps"
    MO_CLASS_ID_COMM_ITEM = "commItem"
    MO_CLASS_ID_COMM_LOCALE = "commLocale"
    MO_CLASS_ID_COMM_NTP_PROVIDER = "commNtpProvider"
    MO_CLASS_ID_COMM_SHELL = "commShell"
    MO_CLASS_ID_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    MO_CLASS_ID_COMM_SMASH_CLP = "commSmashCLP"
    MO_CLASS_ID_COMM_SNMP = "commSnmp"
    MO_CLASS_ID_COMM_SNMP_TRAP = "commSnmpTrap"
    MO_CLASS_ID_COMM_SNMP_USER = "commSnmpUser"
    MO_CLASS_ID_COMM_SSH = "commSsh"
    MO_CLASS_ID_COMM_SVC = "commSvc"
    MO_CLASS_ID_COMM_SVC_CHANNEL = "commSvcChannel"
    MO_CLASS_ID_COMM_SVC_EP = "commSvcEp"
    MO_CLASS_ID_COMM_SVC_EP_FSM = "commSvcEpFsm"
    MO_CLASS_ID_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    MO_CLASS_ID_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    MO_CLASS_ID_COMM_SVC_LIMITS = "commSvcLimits"
    MO_CLASS_ID_COMM_SVC_POLICY = "commSvcPolicy"
    MO_CLASS_ID_COMM_SYSLOG = "commSyslog"
    MO_CLASS_ID_COMM_SYSLOG_CLIENT = "commSyslogClient"
    MO_CLASS_ID_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    MO_CLASS_ID_COMM_SYSLOG_FILE = "commSyslogFile"
    MO_CLASS_ID_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    MO_CLASS_ID_COMM_SYSLOG_SOURCE = "commSyslogSource"
    MO_CLASS_ID_COMM_TELNET = "commTelnet"
    MO_CLASS_ID_COMM_WEB = "commWeb"
    MO_CLASS_ID_COMM_WEB_CHANNEL = "commWebChannel"
    MO_CLASS_ID_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    MO_CLASS_ID_COMM_WSMAN = "commWsman"
    MO_CLASS_ID_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    MO_CLASS_ID_COMPUTE_ABOARD = "computeABoard"
    MO_CLASS_ID_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    MO_CLASS_ID_COMPUTE_ADMIN_ACK = "computeAdminAck"
    MO_CLASS_ID_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    MO_CLASS_ID_COMPUTE_BEH_CAP = "computeBehCap"
    MO_CLASS_ID_COMPUTE_BLADE = "computeBlade"
    MO_CLASS_ID_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    MO_CLASS_ID_COMPUTE_BLADE_EP = "computeBladeEp"
    MO_CLASS_ID_COMPUTE_BLADE_FSM = "computeBladeFsm"
    MO_CLASS_ID_COMPUTE_BLADE_FSM_STAGE = "computeBladeFsmStage"
    MO_CLASS_ID_COMPUTE_BLADE_FSM_TASK = "computeBladeFsmTask"
    MO_CLASS_ID_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    MO_CLASS_ID_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    MO_CLASS_ID_COMPUTE_BOARD = "computeBoard"
    MO_CLASS_ID_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    MO_CLASS_ID_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    MO_CLASS_ID_COMPUTE_CARTRIDGE = "computeCartridge"
    MO_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    MO_CLASS_ID_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    MO_CLASS_ID_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    MO_CLASS_ID_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    MO_CLASS_ID_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    MO_CLASS_ID_COMPUTE_CONSTRAINT_DEF = "computeConstraintDef"
    MO_CLASS_ID_COMPUTE_CONTAINER = "computeContainer"
    MO_CLASS_ID_COMPUTE_DEFAULTS = "computeDefaults"
    MO_CLASS_ID_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    MO_CLASS_ID_COMPUTE_EXT_BOARD = "computeExtBoard"
    MO_CLASS_ID_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    MO_CLASS_ID_COMPUTE_FAN_POLICY = "computeFanPolicy"
    MO_CLASS_ID_COMPUTE_FW_SYNC_ACK = "computeFwSyncAck"
    MO_CLASS_ID_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    MO_CLASS_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM = "computeHealthLedSensorAlarm"
    MO_CLASS_ID_COMPUTE_HOST_UTILITY_OS = "computeHostUtilityOs"
    MO_CLASS_ID_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    MO_CLASS_ID_COMPUTE_IOHUB = "computeIOHub"
    MO_CLASS_ID_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    MO_CLASS_ID_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    MO_CLASS_ID_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    MO_CLASS_ID_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    MO_CLASS_ID_COMPUTE_ITEM = "computeItem"
    MO_CLASS_ID_COMPUTE_KVM_MGMT_POLICY = "computeKvmMgmtPolicy"
    MO_CLASS_ID_COMPUTE_LOGICAL = "computeLogical"
    MO_CLASS_ID_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    MO_CLASS_ID_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    MO_CLASS_ID_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    MO_CLASS_ID_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    MO_CLASS_ID_COMPUTE_MEMORY_CONFIG_POLICY = "computeMemoryConfigPolicy"
    MO_CLASS_ID_COMPUTE_MEMORY_CONFIGURATION = "computeMemoryConfiguration"
    MO_CLASS_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF = "computeMemoryUnitConstraintDef"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    MO_CLASS_ID_COMPUTE_PARTITION = "computePartition"
    MO_CLASS_ID_COMPUTE_PCI_CAP = "computePciCap"
    MO_CLASS_ID_COMPUTE_PCI_SLOT_SCAN_DEF = "computePciSlotScanDef"
    MO_CLASS_ID_COMPUTE_PERSONALITY = "computePersonality"
    MO_CLASS_ID_COMPUTE_PHYSICAL = "computePhysical"
    MO_CLASS_ID_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    MO_CLASS_ID_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    MO_CLASS_ID_COMPUTE_PHYSICAL_FSM = "computePhysicalFsm"
    MO_CLASS_ID_COMPUTE_PHYSICAL_FSM_STAGE = "computePhysicalFsmStage"
    MO_CLASS_ID_COMPUTE_PHYSICAL_FSM_TASK = "computePhysicalFsmTask"
    MO_CLASS_ID_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    MO_CLASS_ID_COMPUTE_PLATFORM = "computePlatform"
    MO_CLASS_ID_COMPUTE_PNU_OSIMAGE = "computePnuOSImage"
    MO_CLASS_ID_COMPUTE_POOL = "computePool"
    MO_CLASS_ID_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    MO_CLASS_ID_COMPUTE_POOLABLE = "computePoolable"
    MO_CLASS_ID_COMPUTE_POOLED = "computePooled"
    MO_CLASS_ID_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    MO_CLASS_ID_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    MO_CLASS_ID_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    MO_CLASS_ID_COMPUTE_POOLED_SLOT = "computePooledSlot"
    MO_CLASS_ID_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    MO_CLASS_ID_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    MO_CLASS_ID_COMPUTE_POWER_SAVE_POLICY = "computePowerSavePolicy"
    MO_CLASS_ID_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    MO_CLASS_ID_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    MO_CLASS_ID_COMPUTE_PSU_CONTROL = "computePsuControl"
    MO_CLASS_ID_COMPUTE_PSU_DEF = "computePsuDef"
    MO_CLASS_ID_COMPUTE_PSU_POLICY = "computePsuPolicy"
    MO_CLASS_ID_COMPUTE_QUAL = "computeQual"
    MO_CLASS_ID_COMPUTE_QUAL_BASE = "computeQualBase"
    MO_CLASS_ID_COMPUTE_QUAL_ITEM = "computeQualItem"
    MO_CLASS_ID_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    MO_CLASS_ID_COMPUTE_RACK_CONN_LINK_POLICY = "computeRackConnLinkPolicy"
    MO_CLASS_ID_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    MO_CLASS_ID_COMPUTE_RACK_QUAL = "computeRackQual"
    MO_CLASS_ID_COMPUTE_RACK_UNIT = "computeRackUnit"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_FSM = "computeRackUnitFsm"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_FSM_STAGE = "computeRackUnitFsmStage"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_FSM_TASK = "computeRackUnitFsmTask"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    MO_CLASS_ID_COMPUTE_REBOOT_LOG = "computeRebootLog"
    MO_CLASS_ID_COMPUTE_RTC_BATTERY = "computeRtcBattery"
    MO_CLASS_ID_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    MO_CLASS_ID_COMPUTE_SERVER = "computeServer"
    MO_CLASS_ID_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    MO_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM = "computeServerDiscPolicyFsm"
    MO_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE = "computeServerDiscPolicyFsmStage"
    MO_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK = "computeServerDiscPolicyFsmTask"
    MO_CLASS_ID_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    MO_CLASS_ID_COMPUTE_SERVER_TYPE_CAP = "computeServerTypeCap"
    MO_CLASS_ID_COMPUTE_SERVER_UNIT = "computeServerUnit"
    MO_CLASS_ID_COMPUTE_SERVER_UNIT_FSM = "computeServerUnitFsm"
    MO_CLASS_ID_COMPUTE_SERVER_UNIT_FSM_STAGE = "computeServerUnitFsmStage"
    MO_CLASS_ID_COMPUTE_SERVER_UNIT_FSM_TASK = "computeServerUnitFsmTask"
    MO_CLASS_ID_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    MO_CLASS_ID_COMPUTE_SLOT_QUAL = "computeSlotQual"
    MO_CLASS_ID_COMPUTE_VIRTUAL = "computeVirtual"
    MO_CLASS_ID_COMPUTE_VIRTUAL_CONTAINER = "computeVirtualContainer"
    MO_CLASS_ID_CONDITION_IMMUTABLE = "conditionImmutable"
    MO_CLASS_ID_CONDITION_INFO = "conditionInfo"
    MO_CLASS_ID_CONDITION_LOG = "conditionLog"
    MO_CLASS_ID_CONDITION_LOGGABLE = "conditionLoggable"
    MO_CLASS_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    MO_CLASS_ID_CONDITION_MUTABLE = "conditionMutable"
    MO_CLASS_ID_CONDITION_POLICY = "conditionPolicy"
    MO_CLASS_ID_CONDITION_REPORTABLE = "conditionReportable"
    MO_CLASS_ID_CONFIG_IMPACT = "configImpact"
    MO_CLASS_ID_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    MO_CLASS_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    MO_CLASS_ID_CONFIG_SORTER = "configSorter"
    MO_CLASS_ID_CONTROLLER_HA_CONTROLLER = "controllerHaController"
    MO_CLASS_ID_CONTROLLER_MGMT_DB_CHECK_POL = "controllerMgmtDbCheckPol"
    MO_CLASS_ID_CONTROLLER_OPERATIONAL_VERSION_HOLDER = "controllerOperationalVersionHolder"
    MO_CLASS_ID_CONTROLLER_PREFERED_VERSION_HOLDER = "controllerPreferedVersionHolder"
    MO_CLASS_ID_COPROCESSOR_CARD = "coprocessorCard"
    MO_CLASS_ID_CPMAINT_ACK = "cpmaintAck"
    MO_CLASS_ID_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    MO_CLASS_ID_DCX_FCOE_VIF_EP = "dcxFcoeVifEp"
    MO_CLASS_ID_DCX_NS = "dcxNs"
    MO_CLASS_ID_DCX_UNIVERSE = "dcxUniverse"
    MO_CLASS_ID_DCX_VIF = "dcxVIf"
    MO_CLASS_ID_DCX_VC = "dcxVc"
    MO_CLASS_ID_DCX_VIF_EP = "dcxVifEp"
    MO_CLASS_ID_DHCP_ACQUIRED = "dhcpAcquired"
    MO_CLASS_ID_DHCP_INST = "dhcpInst"
    MO_CLASS_ID_DHCP_LEASE = "dhcpLease"
    MO_CLASS_ID_DIAG_CTRL = "diagCtrl"
    MO_CLASS_ID_DIAG_LOG_EP = "diagLogEp"
    MO_CLASS_ID_DIAG_MEMORY_TEST = "diagMemoryTest"
    MO_CLASS_ID_DIAG_RSLT = "diagRslt"
    MO_CLASS_ID_DIAG_RUN_POLICY = "diagRunPolicy"
    MO_CLASS_ID_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    MO_CLASS_ID_DIAG_SRV_CTRL = "diagSrvCtrl"
    MO_CLASS_ID_DIAG_TEST = "diagTest"
    MO_CLASS_ID_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    MO_CLASS_ID_DOMAIN_CHASSIS_FEATURE_CONT = "domainChassisFeatureCont"
    MO_CLASS_ID_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    MO_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    MO_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE_CONT = "domainEnvironmentFeatureCont"
    MO_CLASS_ID_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    MO_CLASS_ID_DOMAIN_FEATURE = "domainFeature"
    MO_CLASS_ID_DOMAIN_FEATURE_CONT = "domainFeatureCont"
    MO_CLASS_ID_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    MO_CLASS_ID_DOMAIN_NETWORK_FEATURE_CONT = "domainNetworkFeatureCont"
    MO_CLASS_ID_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    MO_CLASS_ID_DOMAIN_PARAMETER = "domainParameter"
    MO_CLASS_ID_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    MO_CLASS_ID_DOMAIN_SERVER_FEATURE_CONT = "domainServerFeatureCont"
    MO_CLASS_ID_DOMAIN_SERVER_PARAM = "domainServerParam"
    MO_CLASS_ID_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    MO_CLASS_ID_DOMAIN_STORAGE_FEATURE_CONT = "domainStorageFeatureCont"
    MO_CLASS_ID_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    MO_CLASS_ID_DPSEC_MAC = "dpsecMac"
    MO_CLASS_ID_DUPE_SCOPE = "dupeScope"
    MO_CLASS_ID_DUPE_SCOPE_RESULT = "dupeScopeResult"
    MO_CLASS_ID_EPQOS_DEFINITION = "epqosDefinition"
    MO_CLASS_ID_EPQOS_DEFINITION_DEL_TASK = "epqosDefinitionDelTask"
    MO_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM = "epqosDefinitionDelTaskFsm"
    MO_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE = "epqosDefinitionDelTaskFsmStage"
    MO_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK = "epqosDefinitionDelTaskFsmTask"
    MO_CLASS_ID_EPQOS_DEFINITION_FSM = "epqosDefinitionFsm"
    MO_CLASS_ID_EPQOS_DEFINITION_FSM_STAGE = "epqosDefinitionFsmStage"
    MO_CLASS_ID_EPQOS_DEFINITION_FSM_TASK = "epqosDefinitionFsmTask"
    MO_CLASS_ID_EPQOS_EGRESS = "epqosEgress"
    MO_CLASS_ID_EPQOS_ITEM = "epqosItem"
    MO_CLASS_ID_EQUIPMENT_ADAPTOR_CONN_DEF = "equipmentAdaptorConnDef"
    MO_CLASS_ID_EQUIPMENT_ADAPTOR_DEF = "equipmentAdaptorDef"
    MO_CLASS_ID_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    MO_CLASS_ID_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    MO_CLASS_ID_EQUIPMENT_AUTO_CONFIG_MODE = "equipmentAutoConfigMode"
    MO_CLASS_ID_EQUIPMENT_AUTOCONFIG_POLICY = "equipmentAutoconfigPolicy"
    MO_CLASS_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER = "equipmentBaseBoardCapProvider"
    MO_CLASS_ID_EQUIPMENT_BEACON_CAP_PROVIDER = "equipmentBeaconCapProvider"
    MO_CLASS_ID_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    MO_CLASS_ID_EQUIPMENT_BEACON_LED_FSM = "equipmentBeaconLedFsm"
    MO_CLASS_ID_EQUIPMENT_BEACON_LED_FSM_STAGE = "equipmentBeaconLedFsmStage"
    MO_CLASS_ID_EQUIPMENT_BEACON_LED_FSM_TASK = "equipmentBeaconLedFsmTask"
    MO_CLASS_ID_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    MO_CLASS_ID_EQUIPMENT_BINDING = "equipmentBinding"
    MO_CLASS_ID_EQUIPMENT_BIOS_DEF = "equipmentBiosDef"
    MO_CLASS_ID_EQUIPMENT_BIOS_TOKEN_OVERRIDE = "equipmentBiosTokenOverride"
    MO_CLASS_ID_EQUIPMENT_BLADE_AGLIBRARY = "equipmentBladeAGLibrary"
    MO_CLASS_ID_EQUIPMENT_BLADE_AGGREGATION_CAP_REF = "equipmentBladeAggregationCapRef"
    MO_CLASS_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER = "equipmentBladeBiosCapProvider"
    MO_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    MO_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER_TYPE_DEF = "equipmentBladeCapProviderTypeDef"
    MO_CLASS_ID_EQUIPMENT_BLADE_CONN_DEF = "equipmentBladeConnDef"
    MO_CLASS_ID_EQUIPMENT_BLADE_IOMCONN_DEF = "equipmentBladeIOMConnDef"
    MO_CLASS_ID_EQUIPMENT_BLADE_SWITCH_CONN_DEF = "equipmentBladeSwitchConnDef"
    MO_CLASS_ID_EQUIPMENT_BOARD_CONTROLLER_DEF = "equipmentBoardControllerDef"
    MO_CLASS_ID_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS = "equipmentBootDeviceConstraints"
    MO_CLASS_ID_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    MO_CLASS_ID_EQUIPMENT_CAP_MOD_SPEC = "equipmentCapModSpec"
    MO_CLASS_ID_EQUIPMENT_CARD = "equipmentCard"
    MO_CLASS_ID_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    MO_CLASS_ID_EQUIPMENT_CATALOG_CAP_PROVIDER = "equipmentCatalogCapProvider"
    MO_CLASS_ID_EQUIPMENT_CHASSIS = "equipmentChassis"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_FSM = "equipmentChassisFsm"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_FSM_STAGE = "equipmentChassisFsmStage"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_FSM_TASK = "equipmentChassisFsmTask"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_INHERIT_POLICY = "equipmentChassisInheritPolicy"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    MO_CLASS_ID_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    MO_CLASS_ID_EQUIPMENT_CISCO_OS_OPEN_GATE = "equipmentCiscoOsOpenGate"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    MO_CLASS_ID_EQUIPMENT_CONFIG_POLICY = "equipmentConfigPolicy"
    MO_CLASS_ID_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER = "equipmentCoprocessorUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER = "equipmentDbgPluginCapProvider"
    MO_CLASS_ID_EQUIPMENT_DIAG_FEATURE_SUPPORT = "equipmentDiagFeatureSupport"
    MO_CLASS_ID_EQUIPMENT_DIMM_ENTRY = "equipmentDimmEntry"
    MO_CLASS_ID_EQUIPMENT_DIMM_MAPPING = "equipmentDimmMapping"
    MO_CLASS_ID_EQUIPMENT_DISCOVERY_CAP = "equipmentDiscoveryCap"
    MO_CLASS_ID_EQUIPMENT_DOWNGRADE_CONSTRAINT = "equipmentDowngradeConstraint"
    MO_CLASS_ID_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    MO_CLASS_ID_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG = "equipmentEmbeddedControllerConfig"
    MO_CLASS_ID_EQUIPMENT_EMBEDDED_STORAGE_DEF = "equipmentEmbeddedStorageDef"
    MO_CLASS_ID_EQUIPMENT_ENV_SENSOR = "equipmentEnvSensor"
    MO_CLASS_ID_EQUIPMENT_FAN = "equipmentFan"
    MO_CLASS_ID_EQUIPMENT_FAN_AGGRESSIVE_COOLING_CAP = "equipmentFanAggressiveCoolingCap"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_DEF = "equipmentFanModuleDef"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    MO_CLASS_ID_EQUIPMENT_FAN_PRESENCE_DEF = "equipmentFanPresenceDef"
    MO_CLASS_ID_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    MO_CLASS_ID_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_FEX = "equipmentFex"
    MO_CLASS_ID_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    MO_CLASS_ID_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    MO_CLASS_ID_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    MO_CLASS_ID_EQUIPMENT_FEX_FSM = "equipmentFexFsm"
    MO_CLASS_ID_EQUIPMENT_FEX_FSM_STAGE = "equipmentFexFsmStage"
    MO_CLASS_ID_EQUIPMENT_FEX_FSM_TASK = "equipmentFexFsmTask"
    MO_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    MO_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    MO_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    MO_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    MO_CLASS_ID_EQUIPMENT_FEX_SYSTEM_STATS = "equipmentFexSystemStats"
    MO_CLASS_ID_EQUIPMENT_FEX_SYSTEM_STATS_HIST = "equipmentFexSystemStatsHist"
    MO_CLASS_ID_EQUIPMENT_FIRMWARE_CONSTRAINT = "equipmentFirmwareConstraint"
    MO_CLASS_ID_EQUIPMENT_FLASH_LIFE = "equipmentFlashLife"
    MO_CLASS_ID_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE = "equipmentFlexFlashNonRemovable"
    MO_CLASS_ID_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    MO_CLASS_ID_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    MO_CLASS_ID_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    MO_CLASS_ID_EQUIPMENT_GEM_PORT_CAP = "equipmentGemPortCap"
    MO_CLASS_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER = "equipmentGraphicsCardCapProvider"
    MO_CLASS_ID_EQUIPMENT_GRAPHICS_CARD_CAP_REF = "equipmentGraphicsCardCapRef"
    MO_CLASS_ID_EQUIPMENT_HDDFAULT_MON_DEF = "equipmentHDDFaultMonDef"
    MO_CLASS_ID_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    MO_CLASS_ID_EQUIPMENT_HOLDER = "equipmentHolder"
    MO_CLASS_ID_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    MO_CLASS_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    MO_CLASS_ID_EQUIPMENT_HOST_MGMT_CONTROLLER_CAP = "equipmentHostMgmtControllerCap"
    MO_CLASS_ID_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER = "equipmentHwCapDerivativeProvider"
    MO_CLASS_ID_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    MO_CLASS_ID_EQUIPMENT_HW_REVISION_MODIFIER = "equipmentHwRevisionModifier"
    MO_CLASS_ID_EQUIPMENT_HX_CAP = "equipmentHxCap"
    MO_CLASS_ID_EQUIPMENT_IOCARD = "equipmentIOCard"
    MO_CLASS_ID_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    MO_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM = "equipmentIOCardBaseFsm"
    MO_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM_STAGE = "equipmentIOCardBaseFsmStage"
    MO_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM_TASK = "equipmentIOCardBaseFsmTask"
    MO_CLASS_ID_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    MO_CLASS_ID_EQUIPMENT_IOCARD_FSM = "equipmentIOCardFsm"
    MO_CLASS_ID_EQUIPMENT_IOCARD_FSM_STAGE = "equipmentIOCardFsmStage"
    MO_CLASS_ID_EQUIPMENT_IOCARD_FSM_TASK = "equipmentIOCardFsmTask"
    MO_CLASS_ID_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    MO_CLASS_ID_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    MO_CLASS_ID_EQUIPMENT_IOCARD_TYPE_DEF = "equipmentIOCardTypeDef"
    MO_CLASS_ID_EQUIPMENT_IOEXPANDER = "equipmentIOExpander"
    MO_CLASS_ID_EQUIPMENT_IOEXPANDER_CAP_PROVIDER = "equipmentIOExpanderCapProvider"
    MO_CLASS_ID_EQUIPMENT_INBAND_MGMT_CAP = "equipmentInbandMgmtCap"
    MO_CLASS_ID_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    MO_CLASS_ID_EQUIPMENT_INIT_CONFIG_POLICY = "equipmentInitConfigPolicy"
    MO_CLASS_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    MO_CLASS_ID_EQUIPMENT_INVENTORY_STATUS = "equipmentInventoryStatus"
    MO_CLASS_ID_EQUIPMENT_ITEM = "equipmentItem"
    MO_CLASS_ID_EQUIPMENT_KVM_MGMT_CAP = "equipmentKvmMgmtCap"
    MO_CLASS_ID_EQUIPMENT_LED = "equipmentLed"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF = "equipmentLocalDiskControllerCapRef"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF = "equipmentLocalDiskControllerDef"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_TYPE_DEF = "equipmentLocalDiskControllerTypeDef"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM = "equipmentLocatorLedFsm"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE = "equipmentLocatorLedFsmStage"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK = "equipmentLocatorLedFsmTask"
    MO_CLASS_ID_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    MO_CLASS_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF = "equipmentMemoryUnitDiscoveryModifierDef"
    MO_CLASS_ID_EQUIPMENT_MGMT_CAP_PROVIDER = "equipmentMgmtCapProvider"
    MO_CLASS_ID_EQUIPMENT_MGMT_CONTROLLER_CAP = "equipmentMgmtControllerCap"
    MO_CLASS_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER = "equipmentMgmtExtCapProvider"
    MO_CLASS_ID_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER = "equipmentMiniStorageCapProvider"
    MO_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    MO_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_NON_COPPER_PASSIVE_CAP = "equipmentNonCopperPassiveCap"
    MO_CLASS_ID_EQUIPMENT_NVME_DEF = "equipmentNvmeDef"
    MO_CLASS_ID_EQUIPMENT_NVME_SWITCH_CONFIG = "equipmentNvmeSwitchConfig"
    MO_CLASS_ID_EQUIPMENT_ONBOARD_DEVICE_DEF = "equipmentOnboardDeviceDef"
    MO_CLASS_ID_EQUIPMENT_POST = "equipmentPOST"
    MO_CLASS_ID_EQUIPMENT_POSTCODE = "equipmentPOSTCode"
    MO_CLASS_ID_EQUIPMENT_POSTCODE_CONTAINER = "equipmentPOSTCodeContainer"
    MO_CLASS_ID_EQUIPMENT_POSTCODE_DATA = "equipmentPOSTCodeData"
    MO_CLASS_ID_EQUIPMENT_POSTCODE_REPORTER = "equipmentPOSTCodeReporter"
    MO_CLASS_ID_EQUIPMENT_POSTCODE_TEMPLATE = "equipmentPOSTCodeTemplate"
    MO_CLASS_ID_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    MO_CLASS_ID_EQUIPMENT_PCI_SLOT_ID_ENTRY = "equipmentPciSlotIdEntry"
    MO_CLASS_ID_EQUIPMENT_PCI_SLOT_ID_MAPPING = "equipmentPciSlotIdMapping"
    MO_CLASS_ID_EQUIPMENT_PCI_SLOT_SUB_OEMID_ENTRY = "equipmentPciSlotSubOEMIdEntry"
    MO_CLASS_ID_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER = "equipmentPciSwitchCapProvider"
    MO_CLASS_ID_EQUIPMENT_PCIE_SLOT_ORIENTATION = "equipmentPcieSlotOrientation"
    MO_CLASS_ID_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentPersistentMemoryUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_PERSONALITY = "equipmentPersonality"
    MO_CLASS_ID_EQUIPMENT_PFC_MMU_CAP = "equipmentPfcMmuCap"
    MO_CLASS_ID_EQUIPMENT_PHYS_DEVICES_PER_BOARD = "equipmentPhysDevicesPerBoard"
    MO_CLASS_ID_EQUIPMENT_PHYSICAL_DEF = "equipmentPhysicalDef"
    MO_CLASS_ID_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    MO_CLASS_ID_EQUIPMENT_PICTURE = "equipmentPicture"
    MO_CLASS_ID_EQUIPMENT_PNUOS_BOOT_MODE = "equipmentPnuosBootMode"
    MO_CLASS_ID_EQUIPMENT_POOL = "equipmentPool"
    MO_CLASS_ID_EQUIPMENT_POOL_POLICY_REF = "equipmentPoolPolicyRef"
    MO_CLASS_ID_EQUIPMENT_POOLABLE = "equipmentPoolable"
    MO_CLASS_ID_EQUIPMENT_POOLED = "equipmentPooled"
    MO_CLASS_ID_EQUIPMENT_POOLED_CHASSIS = "equipmentPooledChassis"
    MO_CLASS_ID_EQUIPMENT_POOLED_PHYSICAL = "equipmentPooledPhysical"
    MO_CLASS_ID_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    MO_CLASS_ID_EQUIPMENT_PORT_CAP = "equipmentPortCap"
    MO_CLASS_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF = "equipmentPortGroupAggregationDef"
    MO_CLASS_ID_EQUIPMENT_PORT_GROUP_DEF = "equipmentPortGroupDef"
    MO_CLASS_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF = "equipmentPortGroupSwComplexDef"
    MO_CLASS_ID_EQUIPMENT_PORT_SW_COMPLEX_REF = "equipmentPortSwComplexRef"
    MO_CLASS_ID_EQUIPMENT_POWER_CAP_DEF = "equipmentPowerCapDef"
    MO_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_DEF = "equipmentProcessorUnitDef"
    MO_CLASS_ID_EQUIPMENT_PSU = "equipmentPsu"
    MO_CLASS_ID_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    MO_CLASS_ID_EQUIPMENT_PSU_DEF = "equipmentPsuDef"
    MO_CLASS_ID_EQUIPMENT_PSU_FSM = "equipmentPsuFsm"
    MO_CLASS_ID_EQUIPMENT_PSU_FSM_STAGE = "equipmentPsuFsmStage"
    MO_CLASS_ID_EQUIPMENT_PSU_FSM_TASK = "equipmentPsuFsmTask"
    MO_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    MO_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    MO_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    MO_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    MO_CLASS_ID_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    MO_CLASS_ID_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    MO_CLASS_ID_EQUIPMENT_QUAL = "equipmentQual"
    MO_CLASS_ID_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    MO_CLASS_ID_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    MO_CLASS_ID_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    MO_CLASS_ID_EQUIPMENT_RACK_ENCLOSURE = "equipmentRackEnclosure"
    MO_CLASS_ID_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER = "equipmentRackEnclosureCapProvider"
    MO_CLASS_ID_EQUIPMENT_RACK_FAN_MODULE_DEF = "equipmentRackFanModuleDef"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    MO_CLASS_ID_EQUIPMENT_RAID_DEF = "equipmentRaidDef"
    MO_CLASS_ID_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    MO_CLASS_ID_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    MO_CLASS_ID_EQUIPMENT_SECURE_CONTROLLER = "equipmentSecureController"
    MO_CLASS_ID_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER = "equipmentSecurityUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_SERVER_CORRECT_UUID_BEHAVIOR = "equipmentServerCorrectUuidBehavior"
    MO_CLASS_ID_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    MO_CLASS_ID_EQUIPMENT_SERVER_PORT_CAP_PROVIDER = "equipmentServerPortCapProvider"
    MO_CLASS_ID_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_SERVICE_DEF = "equipmentServiceDef"
    MO_CLASS_ID_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    MO_CLASS_ID_EQUIPMENT_SIOC_CAP_PROVIDER = "equipmentSiocCapProvider"
    MO_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    MO_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    MO_CLASS_ID_EQUIPMENT_SLOT = "equipmentSlot"
    MO_CLASS_ID_EQUIPMENT_SLOT_ARRAY = "equipmentSlotArray"
    MO_CLASS_ID_EQUIPMENT_SLOT_ARRAY_REF = "equipmentSlotArrayRef"
    MO_CLASS_ID_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    MO_CLASS_ID_EQUIPMENT_SLOT_EP = "equipmentSlotEp"
    MO_CLASS_ID_EQUIPMENT_SPDM_CERTIFICATE_CAP = "equipmentSpdmCertificateCap"
    MO_CLASS_ID_EQUIPMENT_SPEED_COMPATIBILITY = "equipmentSpeedCompatibility"
    MO_CLASS_ID_EQUIPMENT_STATEFUL = "equipmentStateful"
    MO_CLASS_ID_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    MO_CLASS_ID_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    MO_CLASS_ID_EQUIPMENT_STORAGE_CONTROLLER_CONFIG = "equipmentStorageControllerConfig"
    MO_CLASS_ID_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF = "equipmentStorageControllerSlotDef"
    MO_CLASS_ID_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER = "equipmentStorageEncCapProvider"
    MO_CLASS_ID_EQUIPMENT_STORAGE_LIMIT_CAP = "equipmentStorageLimitCap"
    MO_CLASS_ID_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER = "equipmentStorageNvmeSwitchCapProvider"
    MO_CLASS_ID_EQUIPMENT_STORAGE_NVME_SWITCH_DEF = "equipmentStorageNvmeSwitchDef"
    MO_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER = "equipmentStorageSasExpanderCapProvider"
    MO_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF = "equipmentStorageSasExpanderCapRef"
    MO_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF = "equipmentStorageSasExpanderDef"
    MO_CLASS_ID_EQUIPMENT_SWITCH_CAP = "equipmentSwitchCap"
    MO_CLASS_ID_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    MO_CLASS_ID_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM = "equipmentSwitchIOCardFsm"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE = "equipmentSwitchIOCardFsmStage"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM_TASK = "equipmentSwitchIOCardFsmTask"
    MO_CLASS_ID_EQUIPMENT_SWITCH_TYPE_DEF = "equipmentSwitchTypeDef"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM = "equipmentSystemIOControllerFsm"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE = "equipmentSystemIOControllerFsmStage"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK = "equipmentSystemIOControllerFsmTask"
    MO_CLASS_ID_EQUIPMENT_TIER = "equipmentTier"
    MO_CLASS_ID_EQUIPMENT_TPM = "equipmentTpm"
    MO_CLASS_ID_EQUIPMENT_TPM_CAP_PROVIDER = "equipmentTpmCapProvider"
    MO_CLASS_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    MO_CLASS_ID_EQUIPMENT_UUID_FEATURE_CAP = "equipmentUuidFeatureCap"
    MO_CLASS_ID_EQUIPMENT_VERSION_CONSTRAINT = "equipmentVersionConstraint"
    MO_CLASS_ID_EQUIPMENT_XCVR = "equipmentXcvr"
    MO_CLASS_ID_ETHER_CIO_EP = "etherCIoEp"
    MO_CLASS_ID_ETHER_CONFIG = "etherConfig"
    MO_CLASS_ID_ETHER_ERR_STATS = "etherErrStats"
    MO_CLASS_ID_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    MO_CLASS_ID_ETHER_EXTERNAL_EP = "etherExternalEp"
    MO_CLASS_ID_ETHER_EXTERNAL_PC = "etherExternalPc"
    MO_CLASS_ID_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    MO_CLASS_ID_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    MO_CLASS_ID_ETHER_IF_CONFIG = "etherIfConfig"
    MO_CLASS_ID_ETHER_INT_FIO_EP = "etherIntFIoEp"
    MO_CLASS_ID_ETHER_INTERNAL_PC = "etherInternalPc"
    MO_CLASS_ID_ETHER_LOSS_STATS = "etherLossStats"
    MO_CLASS_ID_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    MO_CLASS_ID_ETHER_NI_ERR_STATS = "etherNiErrStats"
    MO_CLASS_ID_ETHER_NI_ERR_STATS_HIST = "etherNiErrStatsHist"
    MO_CLASS_ID_ETHER_NIC_IF_CONFIG = "etherNicIfConfig"
    MO_CLASS_ID_ETHER_PIO = "etherPIo"
    MO_CLASS_ID_ETHER_PIO_END_POINT = "etherPIoEndPoint"
    MO_CLASS_ID_ETHER_PIO_EP = "etherPIoEp"
    MO_CLASS_ID_ETHER_PIO_FSM = "etherPIoFsm"
    MO_CLASS_ID_ETHER_PIO_FSM_STAGE = "etherPIoFsmStage"
    MO_CLASS_ID_ETHER_PAUSE_STATS = "etherPauseStats"
    MO_CLASS_ID_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    MO_CLASS_ID_ETHER_PC = "etherPc"
    MO_CLASS_ID_ETHER_PORT_CHAN_ID_ELEM = "etherPortChanIdElem"
    MO_CLASS_ID_ETHER_PORT_CHAN_ID_UNIVERSE = "etherPortChanIdUniverse"
    MO_CLASS_ID_ETHER_RX_STATS = "etherRxStats"
    MO_CLASS_ID_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO_FSM = "etherServerIntFIoFsm"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO_FSM_STAGE = "etherServerIntFIoFsmStage"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO_FSM_TASK = "etherServerIntFIoFsmTask"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO_PC = "etherServerIntFIoPc"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO_PC_EP = "etherServerIntFIoPcEp"
    MO_CLASS_ID_ETHER_SW_IF_CONFIG = "etherSwIfConfig"
    MO_CLASS_ID_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    MO_CLASS_ID_ETHER_SWITCH_INT_FIO_PC = "etherSwitchIntFIoPc"
    MO_CLASS_ID_ETHER_SWITCH_INT_FIO_PC_EP = "etherSwitchIntFIoPcEp"
    MO_CLASS_ID_ETHER_TX_STATS = "etherTxStats"
    MO_CLASS_ID_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    MO_CLASS_ID_EVENT_EP_CTRL = "eventEpCtrl"
    MO_CLASS_ID_EVENT_HOLDER = "eventHolder"
    MO_CLASS_ID_EVENT_INST = "eventInst"
    MO_CLASS_ID_EVENT_LOG = "eventLog"
    MO_CLASS_ID_EVENT_POLICY = "eventPolicy"
    MO_CLASS_ID_EVENT_RECORD = "eventRecord"
    MO_CLASS_ID_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    MO_CLASS_ID_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    MO_CLASS_ID_EXTMGMT_IF = "extmgmtIf"
    MO_CLASS_ID_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    MO_CLASS_ID_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    MO_CLASS_ID_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    MO_CLASS_ID_EXTPOL_CLIENT = "extpolClient"
    MO_CLASS_ID_EXTPOL_CLIENT_CONT = "extpolClientCont"
    MO_CLASS_ID_EXTPOL_CONNECTOR = "extpolConnector"
    MO_CLASS_ID_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    MO_CLASS_ID_EXTPOL_CONTROLLER = "extpolController"
    MO_CLASS_ID_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    MO_CLASS_ID_EXTPOL_EP = "extpolEp"
    MO_CLASS_ID_EXTPOL_EP_FSM = "extpolEpFsm"
    MO_CLASS_ID_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    MO_CLASS_ID_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    MO_CLASS_ID_EXTPOL_PROVIDER = "extpolProvider"
    MO_CLASS_ID_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    MO_CLASS_ID_EXTPOL_PROVIDER_FSM = "extpolProviderFsm"
    MO_CLASS_ID_EXTPOL_PROVIDER_FSM_STAGE = "extpolProviderFsmStage"
    MO_CLASS_ID_EXTPOL_PROVIDER_FSM_TASK = "extpolProviderFsmTask"
    MO_CLASS_ID_EXTPOL_REGISTRY = "extpolRegistry"
    MO_CLASS_ID_EXTPOL_REGISTRY_FSM = "extpolRegistryFsm"
    MO_CLASS_ID_EXTPOL_REGISTRY_FSM_STAGE = "extpolRegistryFsmStage"
    MO_CLASS_ID_EXTPOL_REGISTRY_FSM_TASK = "extpolRegistryFsmTask"
    MO_CLASS_ID_EXTPOL_SVC = "extpolSvc"
    MO_CLASS_ID_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    MO_CLASS_ID_EXTVMM_EP = "extvmmEp"
    MO_CLASS_ID_EXTVMM_EP_FSM = "extvmmEpFsm"
    MO_CLASS_ID_EXTVMM_EP_FSM_STAGE = "extvmmEpFsmStage"
    MO_CLASS_ID_EXTVMM_EP_FSM_TASK = "extvmmEpFsmTask"
    MO_CLASS_ID_EXTVMM_FNDREFERENCE = "extvmmFNDReference"
    MO_CLASS_ID_EXTVMM_FABRIC_NETWORK = "extvmmFabricNetwork"
    MO_CLASS_ID_EXTVMM_FABRIC_NETWORK_DEFINITION = "extvmmFabricNetworkDefinition"
    MO_CLASS_ID_EXTVMM_KEY_INST = "extvmmKeyInst"
    MO_CLASS_ID_EXTVMM_KEY_RING = "extvmmKeyRing"
    MO_CLASS_ID_EXTVMM_KEY_STORE = "extvmmKeyStore"
    MO_CLASS_ID_EXTVMM_KEY_STORE_FSM = "extvmmKeyStoreFsm"
    MO_CLASS_ID_EXTVMM_KEY_STORE_FSM_STAGE = "extvmmKeyStoreFsmStage"
    MO_CLASS_ID_EXTVMM_KEY_STORE_FSM_TASK = "extvmmKeyStoreFsmTask"
    MO_CLASS_ID_EXTVMM_MASTER_EXT_KEY = "extvmmMasterExtKey"
    MO_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM = "extvmmMasterExtKeyFsm"
    MO_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM_STAGE = "extvmmMasterExtKeyFsmStage"
    MO_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM_TASK = "extvmmMasterExtKeyFsmTask"
    MO_CLASS_ID_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    MO_CLASS_ID_EXTVMM_NETWORK_SETS_FSM = "extvmmNetworkSetsFsm"
    MO_CLASS_ID_EXTVMM_NETWORK_SETS_FSM_STAGE = "extvmmNetworkSetsFsmStage"
    MO_CLASS_ID_EXTVMM_NETWORK_SETS_FSM_TASK = "extvmmNetworkSetsFsmTask"
    MO_CLASS_ID_EXTVMM_PROVIDER = "extvmmProvider"
    MO_CLASS_ID_EXTVMM_PROVIDER_FSM = "extvmmProviderFsm"
    MO_CLASS_ID_EXTVMM_PROVIDER_FSM_STAGE = "extvmmProviderFsmStage"
    MO_CLASS_ID_EXTVMM_PROVIDER_FSM_TASK = "extvmmProviderFsmTask"
    MO_CLASS_ID_EXTVMM_SWITCH_DEL_TASK = "extvmmSwitchDelTask"
    MO_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM = "extvmmSwitchDelTaskFsm"
    MO_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM_STAGE = "extvmmSwitchDelTaskFsmStage"
    MO_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM_TASK = "extvmmSwitchDelTaskFsmTask"
    MO_CLASS_ID_EXTVMM_SWITCH_SET = "extvmmSwitchSet"
    MO_CLASS_ID_EXTVMM_UP_LINK_PP = "extvmmUpLinkPP"
    MO_CLASS_ID_EXTVMM_VMNDREF = "extvmmVMNDRef"
    MO_CLASS_ID_EXTVMM_VMNETWORK = "extvmmVMNetwork"
    MO_CLASS_ID_EXTVMM_VMNETWORK_DEFINITION = "extvmmVMNetworkDefinition"
    MO_CLASS_ID_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    MO_CLASS_ID_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    MO_CLASS_ID_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    MO_CLASS_ID_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    MO_CLASS_ID_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    MO_CLASS_ID_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    MO_CLASS_ID_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    MO_CLASS_ID_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    MO_CLASS_ID_FABRIC_ANET_GROUP = "fabricANetGroup"
    MO_CLASS_ID_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    MO_CLASS_ID_FABRIC_ASAN_GROUP = "fabricASanGroup"
    MO_CLASS_ID_FABRIC_AVLAN = "fabricAVlan"
    MO_CLASS_ID_FABRIC_AVSAN = "fabricAVsan"
    MO_CLASS_ID_FABRIC_BHVLAN = "fabricBHVlan"
    MO_CLASS_ID_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    MO_CLASS_ID_FABRIC_BREAKOUT = "fabricBreakout"
    MO_CLASS_ID_FABRIC_CIO_EP = "fabricCIoEp"
    MO_CLASS_ID_FABRIC_CABLING = "fabricCabling"
    MO_CLASS_ID_FABRIC_CABLING_SW = "fabricCablingSw"
    MO_CLASS_ID_FABRIC_CARTRIDGE_PH_EP = "fabricCartridgePhEp"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM = "fabricCartridgeSlotEpFsm"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM_STAGE = "fabricCartridgeSlotEpFsmStage"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM_TASK = "fabricCartridgeSlotEpFsmTask"
    MO_CLASS_ID_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    MO_CLASS_ID_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    MO_CLASS_ID_FABRIC_CHASSIS_EP = "fabricChassisEp"
    MO_CLASS_ID_FABRIC_CLOUD = "fabricCloud"
    MO_CLASS_ID_FABRIC_COMPUTE_EP = "fabricComputeEp"
    MO_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    MO_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM = "fabricComputeMSlotEpFsm"
    MO_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM_STAGE = "fabricComputeMSlotEpFsmStage"
    MO_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM_TASK = "fabricComputeMSlotEpFsmTask"
    MO_CLASS_ID_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM = "fabricComputeSlotEpFsm"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM_STAGE = "fabricComputeSlotEpFsmStage"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM_TASK = "fabricComputeSlotEpFsmTask"
    MO_CLASS_ID_FABRIC_DCE_SRV = "fabricDceSrv"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    MO_CLASS_ID_FABRIC_DOMAIN = "fabricDomain"
    MO_CLASS_ID_FABRIC_EP = "fabricEp"
    MO_CLASS_ID_FABRIC_EP_MGR = "fabricEpMgr"
    MO_CLASS_ID_FABRIC_EP_MGR_FSM = "fabricEpMgrFsm"
    MO_CLASS_ID_FABRIC_EP_MGR_FSM_STAGE = "fabricEpMgrFsmStage"
    MO_CLASS_ID_FABRIC_EP_MGR_FSM_TASK = "fabricEpMgrFsmTask"
    MO_CLASS_ID_FABRIC_EP_VLAN = "fabricEpVlan"
    MO_CLASS_ID_FABRIC_EP_VSAN = "fabricEpVsan"
    MO_CLASS_ID_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    MO_CLASS_ID_FABRIC_ESTC_EP = "fabricEstcEp"
    MO_CLASS_ID_FABRIC_ESTC_PC = "fabricEstcPc"
    MO_CLASS_ID_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    MO_CLASS_ID_FABRIC_ETH_ESTC = "fabricEthEstc"
    MO_CLASS_ID_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    MO_CLASS_ID_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    MO_CLASS_ID_FABRIC_ETH_FLOW_MON_LAN = "fabricEthFlowMonLan"
    MO_CLASS_ID_FABRIC_ETH_FLOW_MON_SRC_REF = "fabricEthFlowMonSrcRef"
    MO_CLASS_ID_FABRIC_ETH_LAN = "fabricEthLan"
    MO_CLASS_ID_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON = "fabricEthLanFlowMon"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_COLLECTOR = "fabricEthLanFlowMonCollector"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_EXPORTER = "fabricEthLanFlowMonExporter"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_SRC_EP = "fabricEthLanFlowMonSrcEp"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MONITOR = "fabricEthLanFlowMonitor"
    MO_CLASS_ID_FABRIC_ETH_LAN_FLOW_MONITORING = "fabricEthLanFlowMonitoring"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    MO_CLASS_ID_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    MO_CLASS_ID_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    MO_CLASS_ID_FABRIC_ETH_MON = "fabricEthMon"
    MO_CLASS_ID_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    MO_CLASS_ID_FABRIC_ETH_MON_FILT_EP = "fabricEthMonFiltEp"
    MO_CLASS_ID_FABRIC_ETH_MON_FILT_REF = "fabricEthMonFiltRef"
    MO_CLASS_ID_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    MO_CLASS_ID_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    MO_CLASS_ID_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    MO_CLASS_ID_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    MO_CLASS_ID_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    MO_CLASS_ID_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    MO_CLASS_ID_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    MO_CLASS_ID_FABRIC_EXTERNAL = "fabricExternal"
    MO_CLASS_ID_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    MO_CLASS_ID_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    MO_CLASS_ID_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    MO_CLASS_ID_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    MO_CLASS_ID_FABRIC_FC_ESTC = "fabricFcEstc"
    MO_CLASS_ID_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    MO_CLASS_ID_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    MO_CLASS_ID_FABRIC_FC_MON = "fabricFcMon"
    MO_CLASS_ID_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    MO_CLASS_ID_FABRIC_FC_MON_FILT_EP = "fabricFcMonFiltEp"
    MO_CLASS_ID_FABRIC_FC_MON_FILT_REF = "fabricFcMonFiltRef"
    MO_CLASS_ID_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    MO_CLASS_ID_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    MO_CLASS_ID_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    MO_CLASS_ID_FABRIC_FC_SAN = "fabricFcSan"
    MO_CLASS_ID_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    MO_CLASS_ID_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    MO_CLASS_ID_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    MO_CLASS_ID_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    MO_CLASS_ID_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    MO_CLASS_ID_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    MO_CLASS_ID_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    MO_CLASS_ID_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    MO_CLASS_ID_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    MO_CLASS_ID_FABRIC_FLOW_MON = "fabricFlowMon"
    MO_CLASS_ID_FABRIC_FLOW_MON_COLLECTOR = "fabricFlowMonCollector"
    MO_CLASS_ID_FABRIC_FLOW_MON_DEFINITION = "fabricFlowMonDefinition"
    MO_CLASS_ID_FABRIC_FLOW_MON_EXPORTER = "fabricFlowMonExporter"
    MO_CLASS_ID_FABRIC_FLOW_MON_EXPORTER_PROFILE = "fabricFlowMonExporterProfile"
    MO_CLASS_ID_FABRIC_FLOW_MON_ITEM = "fabricFlowMonItem"
    MO_CLASS_ID_FABRIC_FLOW_MON_SRC_EP = "fabricFlowMonSrcEp"
    MO_CLASS_ID_FABRIC_FLOW_MON_SRC_REF = "fabricFlowMonSrcRef"
    MO_CLASS_ID_FABRIC_FLOW_MONITOR = "fabricFlowMonitor"
    MO_CLASS_ID_FABRIC_FLOW_MONITORING_CATEGORY = "fabricFlowMonitoringCategory"
    MO_CLASS_ID_FABRIC_IF = "fabricIf"
    MO_CLASS_ID_FABRIC_INTERNAL = "fabricInternal"
    MO_CLASS_ID_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    MO_CLASS_ID_FABRIC_INTERNAL_EP = "fabricInternalEp"
    MO_CLASS_ID_FABRIC_INTERNAL_PC = "fabricInternalPc"
    MO_CLASS_ID_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    MO_CLASS_ID_FABRIC_LAN = "fabricLan"
    MO_CLASS_ID_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    MO_CLASS_ID_FABRIC_LAN_CLOUD = "fabricLanCloud"
    MO_CLASS_ID_FABRIC_LAN_CLOUD_FSM = "fabricLanCloudFsm"
    MO_CLASS_ID_FABRIC_LAN_CLOUD_FSM_STAGE = "fabricLanCloudFsmStage"
    MO_CLASS_ID_FABRIC_LAN_CLOUD_FSM_TASK = "fabricLanCloudFsmTask"
    MO_CLASS_ID_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    MO_CLASS_ID_FABRIC_LAN_EP = "fabricLanEp"
    MO_CLASS_ID_FABRIC_LAN_FLOW_MON = "fabricLanFlowMon"
    MO_CLASS_ID_FABRIC_LAN_FLOW_MON_COLLECTOR = "fabricLanFlowMonCollector"
    MO_CLASS_ID_FABRIC_LAN_FLOW_MON_EXPORTER = "fabricLanFlowMonExporter"
    MO_CLASS_ID_FABRIC_LAN_FLOW_MON_SRC_EP = "fabricLanFlowMonSrcEp"
    MO_CLASS_ID_FABRIC_LAN_FLOW_MONITOR = "fabricLanFlowMonitor"
    MO_CLASS_ID_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    MO_CLASS_ID_FABRIC_LAN_PC = "fabricLanPc"
    MO_CLASS_ID_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    MO_CLASS_ID_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    MO_CLASS_ID_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    MO_CLASS_ID_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    MO_CLASS_ID_FABRIC_LOCALE = "fabricLocale"
    MO_CLASS_ID_FABRIC_MON = "fabricMon"
    MO_CLASS_ID_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    MO_CLASS_ID_FABRIC_MON_FILT_REF = "fabricMonFiltRef"
    MO_CLASS_ID_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    MO_CLASS_ID_FABRIC_MON_SRC_FILT_EP = "fabricMonSrcFiltEp"
    MO_CLASS_ID_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    MO_CLASS_ID_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    MO_CLASS_ID_FABRIC_NET_GROUP = "fabricNetGroup"
    MO_CLASS_ID_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    MO_CLASS_ID_FABRIC_NETFLOW_COLLECTOR = "fabricNetflowCollector"
    MO_CLASS_ID_FABRIC_NETFLOW_IPV4_ADDR = "fabricNetflowIPv4Addr"
    MO_CLASS_ID_FABRIC_NETFLOW_MON_EXPORTER = "fabricNetflowMonExporter"
    MO_CLASS_ID_FABRIC_NETFLOW_MON_EXPORTER_REF = "fabricNetflowMonExporterRef"
    MO_CLASS_ID_FABRIC_NETFLOW_MON_SESSION = "fabricNetflowMonSession"
    MO_CLASS_ID_FABRIC_NETFLOW_MON_SRC_EP = "fabricNetflowMonSrcEp"
    MO_CLASS_ID_FABRIC_NETFLOW_MON_SRC_REF = "fabricNetflowMonSrcRef"
    MO_CLASS_ID_FABRIC_NETFLOW_MONITOR = "fabricNetflowMonitor"
    MO_CLASS_ID_FABRIC_NETFLOW_MONITOR_REF = "fabricNetflowMonitorRef"
    MO_CLASS_ID_FABRIC_NETFLOW_TIMEOUT_POLICY = "fabricNetflowTimeoutPolicy"
    MO_CLASS_ID_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    MO_CLASS_ID_FABRIC_PIO_EP = "fabricPIoEp"
    MO_CLASS_ID_FABRIC_PATH = "fabricPath"
    MO_CLASS_ID_FABRIC_PATH_CONN = "fabricPathConn"
    MO_CLASS_ID_FABRIC_PATH_EP = "fabricPathEp"
    MO_CLASS_ID_FABRIC_PIN_GROUP = "fabricPinGroup"
    MO_CLASS_ID_FABRIC_PIN_TARGET = "fabricPinTarget"
    MO_CLASS_ID_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    MO_CLASS_ID_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    MO_CLASS_ID_FABRIC_RESERVED_VLAN = "fabricReservedVlan"
    MO_CLASS_ID_FABRIC_RESERVED_VLAN_FSM = "fabricReservedVlanFsm"
    MO_CLASS_ID_FABRIC_RESERVED_VLAN_FSM_STAGE = "fabricReservedVlanFsmStage"
    MO_CLASS_ID_FABRIC_RESERVED_VLAN_FSM_TASK = "fabricReservedVlanFsmTask"
    MO_CLASS_ID_FABRIC_SAN = "fabricSan"
    MO_CLASS_ID_FABRIC_SAN_CLOUD = "fabricSanCloud"
    MO_CLASS_ID_FABRIC_SAN_CLOUD_FSM = "fabricSanCloudFsm"
    MO_CLASS_ID_FABRIC_SAN_CLOUD_FSM_STAGE = "fabricSanCloudFsmStage"
    MO_CLASS_ID_FABRIC_SAN_CLOUD_FSM_TASK = "fabricSanCloudFsmTask"
    MO_CLASS_ID_FABRIC_SAN_EP = "fabricSanEp"
    MO_CLASS_ID_FABRIC_SAN_GROUP = "fabricSanGroup"
    MO_CLASS_ID_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    MO_CLASS_ID_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    MO_CLASS_ID_FABRIC_SAN_PC = "fabricSanPc"
    MO_CLASS_ID_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    MO_CLASS_ID_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    MO_CLASS_ID_FABRIC_SUB_GROUP = "fabricSubGroup"
    MO_CLASS_ID_FABRIC_SW_CH_EP = "fabricSwChEp"
    MO_CLASS_ID_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    MO_CLASS_ID_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    MO_CLASS_ID_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    MO_CLASS_ID_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    MO_CLASS_ID_FABRIC_TARGET_EP = "fabricTargetEp"
    MO_CLASS_ID_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    MO_CLASS_ID_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    MO_CLASS_ID_FABRIC_VCON = "fabricVCon"
    MO_CLASS_ID_FABRIC_VCON_PROFILE = "fabricVConProfile"
    MO_CLASS_ID_FABRIC_VLAN = "fabricVlan"
    MO_CLASS_ID_FABRIC_VLAN_EP = "fabricVlanEp"
    MO_CLASS_ID_FABRIC_VLAN_GROUP_PERMIT = "fabricVlanGroupPermit"
    MO_CLASS_ID_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    MO_CLASS_ID_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    MO_CLASS_ID_FABRIC_VLAN_REQ = "fabricVlanReq"
    MO_CLASS_ID_FABRIC_VNET_EP = "fabricVnetEp"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    MO_CLASS_ID_FABRIC_VNET_GROUP_PERMIT = "fabricVnetGroupPermit"
    MO_CLASS_ID_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    MO_CLASS_ID_FABRIC_VNET_PERMIT = "fabricVnetPermit"
    MO_CLASS_ID_FABRIC_VNET_REQ = "fabricVnetReq"
    MO_CLASS_ID_FABRIC_VSAN = "fabricVsan"
    MO_CLASS_ID_FABRIC_VSAN_EP = "fabricVsanEp"
    MO_CLASS_ID_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    MO_CLASS_ID_FABRIC_ZONE_ID_UNIVERSE = "fabricZoneIdUniverse"
    MO_CLASS_ID_FAULT_AFFECTED_CLASS = "faultAffectedClass"
    MO_CLASS_ID_FAULT_BASE_HOLDER = "faultBaseHolder"
    MO_CLASS_ID_FAULT_BASE_POLICY = "faultBasePolicy"
    MO_CLASS_ID_FAULT_HOLDER = "faultHolder"
    MO_CLASS_ID_FAULT_INST = "faultInst"
    MO_CLASS_ID_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    MO_CLASS_ID_FAULT_POLICY = "faultPolicy"
    MO_CLASS_ID_FAULT_SUPPRESS_POLICY = "faultSuppressPolicy"
    MO_CLASS_ID_FAULT_SUPPRESS_POLICY_ITEM = "faultSuppressPolicyItem"
    MO_CLASS_ID_FAULT_SUPPRESS_TASK = "faultSuppressTask"
    MO_CLASS_ID_FC_CONFIG = "fcConfig"
    MO_CLASS_ID_FC_ERR_STATS = "fcErrStats"
    MO_CLASS_ID_FC_ERR_STATS_HIST = "fcErrStatsHist"
    MO_CLASS_ID_FC_IF_CONFIG = "fcIfConfig"
    MO_CLASS_ID_FC_NIC_IF_CONFIG = "fcNicIfConfig"
    MO_CLASS_ID_FC_PIO = "fcPIo"
    MO_CLASS_ID_FC_PIO_FSM = "fcPIoFsm"
    MO_CLASS_ID_FC_PIO_FSM_STAGE = "fcPIoFsmStage"
    MO_CLASS_ID_FC_STATS = "fcStats"
    MO_CLASS_ID_FC_STATS_HIST = "fcStatsHist"
    MO_CLASS_ID_FC_SW_IF_CONFIG = "fcSwIfConfig"
    MO_CLASS_ID_FCPOOL_ADDR = "fcpoolAddr"
    MO_CLASS_ID_FCPOOL_BLOCK = "fcpoolBlock"
    MO_CLASS_ID_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    MO_CLASS_ID_FCPOOL_FORMAT = "fcpoolFormat"
    MO_CLASS_ID_FCPOOL_INITIATOR = "fcpoolInitiator"
    MO_CLASS_ID_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    MO_CLASS_ID_FCPOOL_INITIATORS = "fcpoolInitiators"
    MO_CLASS_ID_FCPOOL_OUI = "fcpoolOui"
    MO_CLASS_ID_FCPOOL_OUIS = "fcpoolOuis"
    MO_CLASS_ID_FCPOOL_OUIS_FSM = "fcpoolOuisFsm"
    MO_CLASS_ID_FCPOOL_OUIS_FSM_STAGE = "fcpoolOuisFsmStage"
    MO_CLASS_ID_FCPOOL_OUIS_FSM_TASK = "fcpoolOuisFsmTask"
    MO_CLASS_ID_FCPOOL_POOLABLE = "fcpoolPoolable"
    MO_CLASS_ID_FCPOOL_UNIVERSE = "fcpoolUniverse"
    MO_CLASS_ID_FEATURE_BASE_REF = "featureBaseRef"
    MO_CLASS_ID_FEATURE_CONTEXT_EP = "featureContextEp"
    MO_CLASS_ID_FEATURE_DEFINITION = "featureDefinition"
    MO_CLASS_ID_FEATURE_DEFINITION_INSTANCE = "featureDefinitionInstance"
    MO_CLASS_ID_FEATURE_DEFINITION_REF = "featureDefinitionRef"
    MO_CLASS_ID_FEATURE_FRU_CAP_PROVIDER_INSTANCE = "featureFruCapProviderInstance"
    MO_CLASS_ID_FEATURE_FRU_CAP_PROVIDER_REF = "featureFruCapProviderRef"
    MO_CLASS_ID_FEATURE_PROVIDER = "featureProvider"
    MO_CLASS_ID_FEATURE_PROVIDER_INSTANCE = "featureProviderInstance"
    MO_CLASS_ID_FIRMWARE_ABUNDLE_TYPE_CAP_PROVIDER = "firmwareABundleTypeCapProvider"
    MO_CLASS_ID_FIRMWARE_ACHASSIS_CONSTRAINT = "firmwareAChassisConstraint"
    MO_CLASS_ID_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    MO_CLASS_ID_FIRMWARE_ACONSTRAINT = "firmwareAConstraint"
    MO_CLASS_ID_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    MO_CLASS_ID_FIRMWARE_ACK = "firmwareAck"
    MO_CLASS_ID_FIRMWARE_ACTIVITY = "firmwareActivity"
    MO_CLASS_ID_FIRMWARE_ACTIVITY_TRIGGER = "firmwareActivityTrigger"
    MO_CLASS_ID_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    MO_CLASS_ID_FIRMWARE_BACKUP_VERSION_HOLDER = "firmwareBackupVersionHolder"
    MO_CLASS_ID_FIRMWARE_BLADE = "firmwareBlade"
    MO_CLASS_ID_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    MO_CLASS_ID_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    MO_CLASS_ID_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    MO_CLASS_ID_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    MO_CLASS_ID_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    MO_CLASS_ID_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    MO_CLASS_ID_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    MO_CLASS_ID_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    MO_CLASS_ID_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    MO_CLASS_ID_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    MO_CLASS_ID_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    MO_CLASS_ID_FIRMWARE_CHASSIS_PACK_MOD_IMPACT = "firmwareChassisPackModImpact"
    MO_CLASS_ID_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    MO_CLASS_ID_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    MO_CLASS_ID_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    MO_CLASS_ID_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    MO_CLASS_ID_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    MO_CLASS_ID_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    MO_CLASS_ID_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    MO_CLASS_ID_FIRMWARE_CONNECTION_MANAGEMENT_CHASSIS_CONSTRAINT = "firmwareConnectionManagementChassisConstraint"
    MO_CLASS_ID_FIRMWARE_CONSTRAINTS = "firmwareConstraints"
    MO_CLASS_ID_FIRMWARE_DEPENDENCY = "firmwareDependency"
    MO_CLASS_ID_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    MO_CLASS_ID_FIRMWARE_DRIVE_SECURITY_CONSTRAINT = "firmwareDriveSecurityConstraint"
    MO_CLASS_ID_FIRMWARE_DUAL_VIC_CHASSIS_CONSTRAINT = "firmwareDualVicChassisConstraint"
    MO_CLASS_ID_FIRMWARE_DUAL_VIC_SERVER_CONSTRAINT = "firmwareDualVicServerConstraint"
    MO_CLASS_ID_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    MO_CLASS_ID_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    MO_CLASS_ID_FIRMWARE_FILE_UNIT = "firmwareFileUnit"
    MO_CLASS_ID_FIRMWARE_HOST = "firmwareHost"
    MO_CLASS_ID_FIRMWARE_HOST_PACK_MOD_IMPACT = "firmwareHostPackModImpact"
    MO_CLASS_ID_FIRMWARE_IMAGE = "firmwareImage"
    MO_CLASS_ID_FIRMWARE_IMAGE_FSM = "firmwareImageFsm"
    MO_CLASS_ID_FIRMWARE_IMAGE_FSM_STAGE = "firmwareImageFsmStage"
    MO_CLASS_ID_FIRMWARE_IMAGE_FSM_TASK = "firmwareImageFsmTask"
    MO_CLASS_ID_FIRMWARE_IMAGE_LOCK = "firmwareImageLock"
    MO_CLASS_ID_FIRMWARE_INFRA = "firmwareInfra"
    MO_CLASS_ID_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    MO_CLASS_ID_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    MO_CLASS_ID_FIRMWARE_INSTALLABLE = "firmwareInstallable"
    MO_CLASS_ID_FIRMWARE_MODULE = "firmwareModule"
    MO_CLASS_ID_FIRMWARE_PCHSTORAGE_CONFIG_CONSTRAINT = "firmwarePCHStorageConfigConstraint"
    MO_CLASS_ID_FIRMWARE_PACK = "firmwarePack"
    MO_CLASS_ID_FIRMWARE_PACK_ITEM = "firmwarePackItem"
    MO_CLASS_ID_FIRMWARE_PLATFORM_BUNDLE_TYPE_CAP_PROVIDER = "firmwarePlatformBundleTypeCapProvider"
    MO_CLASS_ID_FIRMWARE_PROCESSOR_TYPE_CONSTRAINT = "firmwareProcessorTypeConstraint"
    MO_CLASS_ID_FIRMWARE_RACK = "firmwareRack"
    MO_CLASS_ID_FIRMWARE_RACK_POWER_CAP_CONSTRAINT = "firmwareRackPowerCapConstraint"
    MO_CLASS_ID_FIRMWARE_RUNNING = "firmwareRunning"
    MO_CLASS_ID_FIRMWARE_SECOND_CONTROLLER_CHASSIS_CONSTRAINT = "firmwareSecondControllerChassisConstraint"
    MO_CLASS_ID_FIRMWARE_SECOND_CONTROLLER_SERVER_CONSTRAINT = "firmwareSecondControllerServerConstraint"
    MO_CLASS_ID_FIRMWARE_SECURE_FPGA = "firmwareSecureFPGA"
    MO_CLASS_ID_FIRMWARE_SERVER_CHASSIS_CONSTRAINT = "firmwareServerChassisConstraint"
    MO_CLASS_ID_FIRMWARE_SERVER_TYPE_CONSTRAINT = "firmwareServerTypeConstraint"
    MO_CLASS_ID_FIRMWARE_SERVICE_PACK = "firmwareServicePack"
    MO_CLASS_ID_FIRMWARE_SINGLE_PATH_CHASSIS_CONSTRAINT = "firmwareSinglePathChassisConstraint"
    MO_CLASS_ID_FIRMWARE_SPEC = "firmwareSpec"
    MO_CLASS_ID_FIRMWARE_STATUS = "firmwareStatus"
    MO_CLASS_ID_FIRMWARE_SYSTEM = "firmwareSystem"
    MO_CLASS_ID_FIRMWARE_SYSTEM_COMP_CHECK_RESULT = "firmwareSystemCompCheckResult"
    MO_CLASS_ID_FIRMWARE_SYSTEM_FSM = "firmwareSystemFsm"
    MO_CLASS_ID_FIRMWARE_SYSTEM_FSM_STAGE = "firmwareSystemFsmStage"
    MO_CLASS_ID_FIRMWARE_SYSTEM_FSM_TASK = "firmwareSystemFsmTask"
    MO_CLASS_ID_FIRMWARE_TPMCONSTRAINT = "firmwareTPMConstraint"
    MO_CLASS_ID_FIRMWARE_TYPE = "firmwareType"
    MO_CLASS_ID_FIRMWARE_UCSC_INFO = "firmwareUcscInfo"
    MO_CLASS_ID_FIRMWARE_UNIT = "firmwareUnit"
    MO_CLASS_ID_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    MO_CLASS_ID_FIRMWARE_UPGRADE_CONSTRAINT = "firmwareUpgradeConstraint"
    MO_CLASS_ID_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    MO_CLASS_ID_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    MO_CLASS_ID_FIRMWARE_VIC_SLOT_CONSTRAINT = "firmwareVicSlotConstraint"
    MO_CLASS_ID_FIRMWARE_VNIC_CDN_CONSTRAINT = "firmwareVnicCdnConstraint"
    MO_CLASS_ID_FIRMWARE_WATERBAY_SIOC_SERVER_CONSTRAINT = "firmwareWaterbaySiocServerConstraint"
    MO_CLASS_ID_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    MO_CLASS_ID_FLOWCTRL_ITEM = "flowctrlItem"
    MO_CLASS_ID_FSM_FSM = "fsmFsm"
    MO_CLASS_ID_FSM_STAGE = "fsmStage"
    MO_CLASS_ID_FSM_STATUS = "fsmStatus"
    MO_CLASS_ID_FSM_TASK = "fsmTask"
    MO_CLASS_ID_GMETA_CLASS = "gmetaClass"
    MO_CLASS_ID_GMETA_EP = "gmetaEp"
    MO_CLASS_ID_GMETA_HOLDER = "gmetaHolder"
    MO_CLASS_ID_GMETA_HOLDER_FSM = "gmetaHolderFsm"
    MO_CLASS_ID_GMETA_HOLDER_FSM_STAGE = "gmetaHolderFsmStage"
    MO_CLASS_ID_GMETA_HOLDER_FSM_TASK = "gmetaHolderFsmTask"
    MO_CLASS_ID_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    MO_CLASS_ID_GMETA_POLICY_MAP_HOLDER = "gmetaPolicyMapHolder"
    MO_CLASS_ID_GMETA_PROP = "gmetaProp"
    MO_CLASS_ID_GRAPHICS_CARD = "graphicsCard"
    MO_CLASS_ID_GRAPHICS_CONTROLLER = "graphicsController"
    MO_CLASS_ID_HOSTIMG_POLICY = "hostimgPolicy"
    MO_CLASS_ID_HOSTIMG_TARGET = "hostimgTarget"
    MO_CLASS_ID_IDENT_IDENT_CTX = "identIdentCtx"
    MO_CLASS_ID_IDENT_IDENT_REQUEST = "identIdentRequest"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    MO_CLASS_ID_IDENT_META_SYSTEM = "identMetaSystem"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    MO_CLASS_ID_IDENT_META_VERSE = "identMetaVerse"
    MO_CLASS_ID_IDENT_REQUEST_EP = "identRequestEp"
    MO_CLASS_ID_IDENT_SYS_INFO = "identSysInfo"
    MO_CLASS_ID_IMGPROV_POLICY = "imgprovPolicy"
    MO_CLASS_ID_IMGPROV_TARGET = "imgprovTarget"
    MO_CLASS_ID_IMGSEC_KEY = "imgsecKey"
    MO_CLASS_ID_IMGSEC_POLICY = "imgsecPolicy"
    MO_CLASS_ID_INITIATOR_EP = "initiatorEp"
    MO_CLASS_ID_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    MO_CLASS_ID_INITIATOR_GROUP_EP = "initiatorGroupEp"
    MO_CLASS_ID_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    MO_CLASS_ID_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    MO_CLASS_ID_INITIATOR_LUN_EP = "initiatorLunEp"
    MO_CLASS_ID_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    MO_CLASS_ID_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    MO_CLASS_ID_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    MO_CLASS_ID_INITIATOR_STORE_EP = "initiatorStoreEp"
    MO_CLASS_ID_INITIATOR_UNIT_EP = "initiatorUnitEp"
    MO_CLASS_ID_IP_DNS_SUFFIX = "ipDnsSuffix"
    MO_CLASS_ID_IP_IPV4_DNS = "ipIPv4Dns"
    MO_CLASS_ID_IP_IPV4_WINS_SERVER = "ipIPv4WinsServer"
    MO_CLASS_ID_IP_IP_V4_ADDR = "ipIpV4Addr"
    MO_CLASS_ID_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    MO_CLASS_ID_IP_IP_V4_STATIC_TARGET_ADDR = "ipIpV4StaticTargetAddr"
    MO_CLASS_ID_IP_SERVICE_IF = "ipServiceIf"
    MO_CLASS_ID_IPPOOL_ADDR = "ippoolAddr"
    MO_CLASS_ID_IPPOOL_BLOCK = "ippoolBlock"
    MO_CLASS_ID_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    MO_CLASS_ID_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    MO_CLASS_ID_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    MO_CLASS_ID_IPPOOL_POOL = "ippoolPool"
    MO_CLASS_ID_IPPOOL_POOLABLE = "ippoolPoolable"
    MO_CLASS_ID_IPPOOL_POOLED = "ippoolPooled"
    MO_CLASS_ID_IPPOOL_UNIVERSE = "ippoolUniverse"
    MO_CLASS_ID_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    MO_CLASS_ID_IQNPOOL_ADDR = "iqnpoolAddr"
    MO_CLASS_ID_IQNPOOL_BLOCK = "iqnpoolBlock"
    MO_CLASS_ID_IQNPOOL_FORMAT = "iqnpoolFormat"
    MO_CLASS_ID_IQNPOOL_POOL = "iqnpoolPool"
    MO_CLASS_ID_IQNPOOL_POOLABLE = "iqnpoolPoolable"
    MO_CLASS_ID_IQNPOOL_POOLED = "iqnpoolPooled"
    MO_CLASS_ID_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    MO_CLASS_ID_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    MO_CLASS_ID_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    MO_CLASS_ID_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    MO_CLASS_ID_LICENSE_CONTENTS = "licenseContents"
    MO_CLASS_ID_LICENSE_DOWNLOADER = "licenseDownloader"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    MO_CLASS_ID_LICENSE_EP = "licenseEp"
    MO_CLASS_ID_LICENSE_FEATURE = "licenseFeature"
    MO_CLASS_ID_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    MO_CLASS_ID_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    MO_CLASS_ID_LICENSE_FILE = "licenseFile"
    MO_CLASS_ID_LICENSE_FILE_FSM = "licenseFileFsm"
    MO_CLASS_ID_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    MO_CLASS_ID_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    MO_CLASS_ID_LICENSE_INSTANCE = "licenseInstance"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    MO_CLASS_ID_LICENSE_PROP = "licenseProp"
    MO_CLASS_ID_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    MO_CLASS_ID_LICENSE_SOURCE = "licenseSource"
    MO_CLASS_ID_LICENSE_SOURCE_FILE = "licenseSourceFile"
    MO_CLASS_ID_LICENSE_TARGET = "licenseTarget"
    MO_CLASS_ID_LLDP_ACQUIRED = "lldpAcquired"
    MO_CLASS_ID_LS_AGENT_POLICY = "lsAgentPolicy"
    MO_CLASS_ID_LS_BINDING = "lsBinding"
    MO_CLASS_ID_LS_COMPUTE_BINDING = "lsComputeBinding"
    MO_CLASS_ID_LS_FC_LOCALE = "lsFcLocale"
    MO_CLASS_ID_LS_FC_ZONE = "lsFcZone"
    MO_CLASS_ID_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    MO_CLASS_ID_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    MO_CLASS_ID_LS_IDENTITY_INFO = "lsIdentityInfo"
    MO_CLASS_ID_LS_ISSUES = "lsIssues"
    MO_CLASS_ID_LS_POWER = "lsPower"
    MO_CLASS_ID_LS_REQUIREMENT = "lsRequirement"
    MO_CLASS_ID_LS_SERVER = "lsServer"
    MO_CLASS_ID_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    MO_CLASS_ID_LS_SERVER_EXTENSION = "lsServerExtension"
    MO_CLASS_ID_LS_SERVER_FSM = "lsServerFsm"
    MO_CLASS_ID_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    MO_CLASS_ID_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    MO_CLASS_ID_LS_TIER = "lsTier"
    MO_CLASS_ID_LS_UUID_HISTORY = "lsUuidHistory"
    MO_CLASS_ID_LS_VCON_ASSIGN = "lsVConAssign"
    MO_CLASS_ID_LS_VERSION_BEH = "lsVersionBeh"
    MO_CLASS_ID_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    MO_CLASS_ID_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    MO_CLASS_ID_LSBOOT_ADEF = "lsbootADef"
    MO_CLASS_ID_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    MO_CLASS_ID_LSBOOT_CATEGORY = "lsbootCategory"
    MO_CLASS_ID_LSBOOT_DEF = "lsbootDef"
    MO_CLASS_ID_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    MO_CLASS_ID_LSBOOT_EFISHELL = "lsbootEFIShell"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    MO_CLASS_ID_LSBOOT_ISCSI = "lsbootIScsi"
    MO_CLASS_ID_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    MO_CLASS_ID_LSBOOT_IMAGE = "lsbootImage"
    MO_CLASS_ID_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    MO_CLASS_ID_LSBOOT_ITEM = "lsbootItem"
    MO_CLASS_ID_LSBOOT_LAN = "lsbootLan"
    MO_CLASS_ID_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    MO_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    MO_CLASS_ID_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    MO_CLASS_ID_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    MO_CLASS_ID_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    MO_CLASS_ID_LSBOOT_NVME = "lsbootNvme"
    MO_CLASS_ID_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    MO_CLASS_ID_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    MO_CLASS_ID_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    MO_CLASS_ID_LSBOOT_POLICY = "lsbootPolicy"
    MO_CLASS_ID_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    MO_CLASS_ID_LSBOOT_SAN = "lsbootSan"
    MO_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    MO_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    MO_CLASS_ID_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    MO_CLASS_ID_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    MO_CLASS_ID_LSBOOT_STORAGE = "lsbootStorage"
    MO_CLASS_ID_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    MO_CLASS_ID_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    MO_CLASS_ID_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    MO_CLASS_ID_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    MO_CLASS_ID_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    MO_CLASS_ID_LSMAINT_ACK = "lsmaintAck"
    MO_CLASS_ID_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    MO_CLASS_ID_LSTORAGE_ASLOT = "lstorageASlot"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    MO_CLASS_ID_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    MO_CLASS_ID_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    MO_CLASS_ID_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    MO_CLASS_ID_LSTORAGE_ITEM = "lstorageItem"
    MO_CLASS_ID_LSTORAGE_LOCAL = "lstorageLocal"
    MO_CLASS_ID_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    MO_CLASS_ID_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    MO_CLASS_ID_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    MO_CLASS_ID_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    MO_CLASS_ID_LSTORAGE_LOGIN = "lstorageLogin"
    MO_CLASS_ID_LSTORAGE_LUN_SET_CONFIG = "lstorageLunSetConfig"
    MO_CLASS_ID_LSTORAGE_LUN_SET_DISK_SLOT = "lstorageLunSetDiskSlot"
    MO_CLASS_ID_LSTORAGE_PROFILE = "lstorageProfile"
    MO_CLASS_ID_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    MO_CLASS_ID_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    MO_CLASS_ID_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    MO_CLASS_ID_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    MO_CLASS_ID_LSTORAGE_REMOTE = "lstorageRemote"
    MO_CLASS_ID_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    MO_CLASS_ID_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    MO_CLASS_ID_LSTORAGE_SAS_EXPANDER_CONFIG_POLICY = "lstorageSasExpanderConfigPolicy"
    MO_CLASS_ID_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    MO_CLASS_ID_LSTORAGE_SECURITY = "lstorageSecurity"
    MO_CLASS_ID_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    MO_CLASS_ID_MACPOOL_ADDR = "macpoolAddr"
    MO_CLASS_ID_MACPOOL_BLOCK = "macpoolBlock"
    MO_CLASS_ID_MACPOOL_FORMAT = "macpoolFormat"
    MO_CLASS_ID_MACPOOL_POOL = "macpoolPool"
    MO_CLASS_ID_MACPOOL_POOLABLE = "macpoolPoolable"
    MO_CLASS_ID_MACPOOL_POOLED = "macpoolPooled"
    MO_CLASS_ID_MACPOOL_UNIVERSE = "macpoolUniverse"
    MO_CLASS_ID_MEMORY_AUNIT = "memoryAUnit"
    MO_CLASS_ID_MEMORY_ARRAY = "memoryArray"
    MO_CLASS_ID_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    MO_CLASS_ID_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    MO_CLASS_ID_MEMORY_ERROR_STATS = "memoryErrorStats"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_ANAMESPACE = "memoryPersistentMemoryANamespace"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_CONFIG_RESULT = "memoryPersistentMemoryConfigResult"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_CONFIGURATION = "memoryPersistentMemoryConfiguration"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_GOAL = "memoryPersistentMemoryGoal"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_LOCAL_SECURITY = "memoryPersistentMemoryLocalSecurity"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_LOGICAL_NAMESPACE = "memoryPersistentMemoryLogicalNamespace"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_NAMESPACE = "memoryPersistentMemoryNamespace"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_NAMESPACE_CONFIG_RESULT = "memoryPersistentMemoryNamespaceConfigResult"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_POLICY = "memoryPersistentMemoryPolicy"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_REGION = "memoryPersistentMemoryRegion"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_SECURITY = "memoryPersistentMemorySecurity"
    MO_CLASS_ID_MEMORY_PERSISTENT_MEMORY_UNIT = "memoryPersistentMemoryUnit"
    MO_CLASS_ID_MEMORY_QUAL = "memoryQual"
    MO_CLASS_ID_MEMORY_RUNTIME = "memoryRuntime"
    MO_CLASS_ID_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    MO_CLASS_ID_MEMORY_UNIT = "memoryUnit"
    MO_CLASS_ID_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    MO_CLASS_ID_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    MO_CLASS_ID_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    MO_CLASS_ID_MGMT_ABSTRACT_IF = "mgmtAbstractIf"
    MO_CLASS_ID_MGMT_ACCESS_POLICY = "mgmtAccessPolicy"
    MO_CLASS_ID_MGMT_ACCESS_POLICY_ITEM = "mgmtAccessPolicyItem"
    MO_CLASS_ID_MGMT_ACCESS_PORT = "mgmtAccessPort"
    MO_CLASS_ID_MGMT_BACKUP = "mgmtBackup"
    MO_CLASS_ID_MGMT_BACKUP_EXPORT_EXT_POLICY = "mgmtBackupExportExtPolicy"
    MO_CLASS_ID_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    MO_CLASS_ID_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    MO_CLASS_ID_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    MO_CLASS_ID_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    MO_CLASS_ID_MGMT_BACKUP_POLICY_CONFIG = "mgmtBackupPolicyConfig"
    MO_CLASS_ID_MGMT_BACKUP_POLICY_FSM = "mgmtBackupPolicyFsm"
    MO_CLASS_ID_MGMT_BACKUP_POLICY_FSM_STAGE = "mgmtBackupPolicyFsmStage"
    MO_CLASS_ID_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    MO_CLASS_ID_MGMT_CFG_EXPORT_POLICY_FSM = "mgmtCfgExportPolicyFsm"
    MO_CLASS_ID_MGMT_CFG_EXPORT_POLICY_FSM_STAGE = "mgmtCfgExportPolicyFsmStage"
    MO_CLASS_ID_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    MO_CLASS_ID_MGMT_CIMC_SECURE_BOOT = "mgmtCimcSecureBoot"
    MO_CLASS_ID_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    MO_CLASS_ID_MGMT_CONNECTION = "mgmtConnection"
    MO_CLASS_ID_MGMT_CONTROLLER = "mgmtController"
    MO_CLASS_ID_MGMT_CONTROLLER_FSM = "mgmtControllerFsm"
    MO_CLASS_ID_MGMT_CONTROLLER_FSM_STAGE = "mgmtControllerFsmStage"
    MO_CLASS_ID_MGMT_CONTROLLER_FSM_TASK = "mgmtControllerFsmTask"
    MO_CLASS_ID_MGMT_DB_STATE = "mgmtDbState"
    MO_CLASS_ID_MGMT_ENTITY = "mgmtEntity"
    MO_CLASS_ID_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    MO_CLASS_ID_MGMT_EXPORT_POLICY_FSM = "mgmtExportPolicyFsm"
    MO_CLASS_ID_MGMT_EXPORT_POLICY_FSM_STAGE = "mgmtExportPolicyFsmStage"
    MO_CLASS_ID_MGMT_EXPORT_POLICY_FSM_TASK = "mgmtExportPolicyFsmTask"
    MO_CLASS_ID_MGMT_HEALTH_ATTR = "mgmtHealthAttr"
    MO_CLASS_ID_MGMT_HEALTH_STATUS = "mgmtHealthStatus"
    MO_CLASS_ID_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    MO_CLASS_ID_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    MO_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM = "mgmtIPv6IfAddrFsm"
    MO_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM_STAGE = "mgmtIPv6IfAddrFsmStage"
    MO_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM_TASK = "mgmtIPv6IfAddrFsmTask"
    MO_CLASS_ID_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    MO_CLASS_ID_MGMT_IF = "mgmtIf"
    MO_CLASS_ID_MGMT_IF_FSM = "mgmtIfFsm"
    MO_CLASS_ID_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    MO_CLASS_ID_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    MO_CLASS_ID_MGMT_IMPORTER = "mgmtImporter"
    MO_CLASS_ID_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    MO_CLASS_ID_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    MO_CLASS_ID_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    MO_CLASS_ID_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    MO_CLASS_ID_MGMT_INT_AUTH_POLICY = "mgmtIntAuthPolicy"
    MO_CLASS_ID_MGMT_INTERFACE = "mgmtInterface"
    MO_CLASS_ID_MGMT_KMIP = "mgmtKmip"
    MO_CLASS_ID_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    MO_CLASS_ID_MGMT_KVM_CERTIFICATE = "mgmtKvmCertificate"
    MO_CLASS_ID_MGMT_LEADER_ENTITY = "mgmtLeaderEntity"
    MO_CLASS_ID_MGMT_PMON_ENTRY = "mgmtPmonEntry"
    MO_CLASS_ID_MGMT_PROF_DERIVED_INTERFACE = "mgmtProfDerivedInterface"
    MO_CLASS_ID_MGMT_SECURITY = "mgmtSecurity"
    MO_CLASS_ID_MGMT_SPDM_CERTIFICATE = "mgmtSpdmCertificate"
    MO_CLASS_ID_MGMT_SPDM_CERTIFICATE_DATA = "mgmtSpdmCertificateData"
    MO_CLASS_ID_MGMT_SPDM_CERTIFICATE_INVENTORY = "mgmtSpdmCertificateInventory"
    MO_CLASS_ID_MGMT_SPDM_CERTIFICATE_POLICY = "mgmtSpdmCertificatePolicy"
    MO_CLASS_ID_MGMT_SW_PERSONALITIES = "mgmtSwPersonalities"
    MO_CLASS_ID_MGMT_SW_PERSONALITIES_INVENTORY = "mgmtSwPersonalitiesInventory"
    MO_CLASS_ID_MGMT_SW_PERSONALITY = "mgmtSwPersonality"
    MO_CLASS_ID_MGMT_USB_NIC_MGMT_IF = "mgmtUsbNicMgmtIf"
    MO_CLASS_ID_MGMT_VNET = "mgmtVnet"
    MO_CLASS_ID_MO_ABSTRACT_CFG_KV = "moAbstractCfgKv"
    MO_CLASS_ID_MO_ABSTRACT_INV_KV = "moAbstractInvKv"
    MO_CLASS_ID_MO_ABSTRACT_KV = "moAbstractKv"
    MO_CLASS_ID_MO_INV_KV = "moInvKv"
    MO_CLASS_ID_MO_IP_ADDR_KV = "moIpAddrKv"
    MO_CLASS_ID_MO_IP_V4_ADDR_KV = "moIpV4AddrKv"
    MO_CLASS_ID_MO_IP_V6_ADDR_KV = "moIpV6AddrKv"
    MO_CLASS_ID_MO_KV = "moKv"
    MO_CLASS_ID_MO_KV_CFG_HOLDER = "moKvCfgHolder"
    MO_CLASS_ID_MO_KV_INV_HOLDER = "moKvInvHolder"
    MO_CLASS_ID_MO_TOP_PROPS = "moTopProps"
    MO_CLASS_ID_MO_VNIC_KV = "moVnicKv"
    MO_CLASS_ID_MOREF_FRU_REF = "morefFruRef"
    MO_CLASS_ID_MOREF_IMPORT_ROOT = "morefImportRoot"
    MO_CLASS_ID_MOREF_IMPORT_ROOT_FSM = "morefImportRootFsm"
    MO_CLASS_ID_MOREF_IMPORT_ROOT_FSM_STAGE = "morefImportRootFsmStage"
    MO_CLASS_ID_MOREF_IMPORT_ROOT_FSM_TASK = "morefImportRootFsmTask"
    MO_CLASS_ID_MOREF_PROP = "morefProp"
    MO_CLASS_ID_MOREF_REF = "morefRef"
    MO_CLASS_ID_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    MO_CLASS_ID_NAMING_NAMED_OBJECT = "namingNamedObject"
    MO_CLASS_ID_NETWORK_ALAN_NEIGHBOR_ENTRY = "networkALanNeighborEntry"
    MO_CLASS_ID_NETWORK_ANEIGHBOR_ENTRY = "networkANeighborEntry"
    MO_CLASS_ID_NETWORK_CIO_EP = "networkCIoEp"
    MO_CLASS_ID_NETWORK_CONN = "networkConn"
    MO_CLASS_ID_NETWORK_DOMAIN_EP = "networkDomainEp"
    MO_CLASS_ID_NETWORK_ELEMENT = "networkElement"
    MO_CLASS_ID_NETWORK_EP = "networkEp"
    MO_CLASS_ID_NETWORK_IF_EP = "networkIfEp"
    MO_CLASS_ID_NETWORK_IF_STATS = "networkIfStats"
    MO_CLASS_ID_NETWORK_LAN_NEIGHBOR_ENTRY = "networkLanNeighborEntry"
    MO_CLASS_ID_NETWORK_LAN_NEIGHBORS = "networkLanNeighbors"
    MO_CLASS_ID_NETWORK_LIMIT = "networkLimit"
    MO_CLASS_ID_NETWORK_LLDP_NEIGHBOR_ENTRY = "networkLldpNeighborEntry"
    MO_CLASS_ID_NETWORK_LLDP_NEIGHBORS = "networkLldpNeighbors"
    MO_CLASS_ID_NETWORK_OPER_LEVEL = "networkOperLevel"
    MO_CLASS_ID_NETWORK_PIO_EP = "networkPIoEp"
    MO_CLASS_ID_NETWORK_PHYS_EP = "networkPhysEp"
    MO_CLASS_ID_NETWORK_SAN_NEIGHBOR_ENTRY = "networkSanNeighborEntry"
    MO_CLASS_ID_NETWORK_SAN_NEIGHBORS = "networkSanNeighbors"
    MO_CLASS_ID_NETWORK_VNET_EP = "networkVnetEp"
    MO_CLASS_ID_NETWORKRULE_DEFINITION = "networkruleDefinition"
    MO_CLASS_ID_NETWORKRULE_ITEM = "networkruleItem"
    MO_CLASS_ID_NETWORKRULE_REQUIREMENT = "networkruleRequirement"
    MO_CLASS_ID_NFS_EP = "nfsEp"
    MO_CLASS_ID_NFS_MOUNT_DEF = "nfsMountDef"
    MO_CLASS_ID_NFS_MOUNT_DEF_FSM = "nfsMountDefFsm"
    MO_CLASS_ID_NFS_MOUNT_DEF_FSM_STAGE = "nfsMountDefFsmStage"
    MO_CLASS_ID_NFS_MOUNT_DEF_FSM_TASK = "nfsMountDefFsmTask"
    MO_CLASS_ID_NFS_MOUNT_INST = "nfsMountInst"
    MO_CLASS_ID_NFS_MOUNT_INST_FSM = "nfsMountInstFsm"
    MO_CLASS_ID_NFS_MOUNT_INST_FSM_STAGE = "nfsMountInstFsmStage"
    MO_CLASS_ID_NFS_MOUNT_INST_FSM_TASK = "nfsMountInstFsmTask"
    MO_CLASS_ID_NWCTRL_DEFINITION = "nwctrlDefinition"
    MO_CLASS_ID_OBSERVE_FILTER = "observeFilter"
    MO_CLASS_ID_OBSERVE_OBSERVED = "observeObserved"
    MO_CLASS_ID_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    MO_CLASS_ID_ORG_ORG = "orgOrg"
    MO_CLASS_ID_ORG_SOURCE_MASK = "orgSourceMask"
    MO_CLASS_ID_OS_ARPLINK_MONITORING_POLICY = "osARPLinkMonitoringPolicy"
    MO_CLASS_ID_OS_ARPTARGET = "osARPTarget"
    MO_CLASS_ID_OS_AGENT = "osAgent"
    MO_CLASS_ID_OS_ETH_BOND_INTF = "osEthBondIntf"
    MO_CLASS_ID_OS_ETH_BOND_MODE = "osEthBondMode"
    MO_CLASS_ID_OS_ETH_BOND_MODE_ACTIVE_BACKUP = "osEthBondModeActiveBackup"
    MO_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_ALB = "osEthBondModeBalancedALB"
    MO_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_RR = "osEthBondModeBalancedRR"
    MO_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_TLB = "osEthBondModeBalancedTLB"
    MO_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_XOR = "osEthBondModeBalancedXOR"
    MO_CLASS_ID_OS_ETH_BOND_MODE_BROADCAST = "osEthBondModeBroadcast"
    MO_CLASS_ID_OS_ETH_BOND_MODE_LB = "osEthBondModeLB"
    MO_CLASS_ID_OS_ETH_INTF = "osEthIntf"
    MO_CLASS_ID_OS_INSTANCE = "osInstance"
    MO_CLASS_ID_OS_INTF = "osIntf"
    MO_CLASS_ID_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    MO_CLASS_ID_OS_MII_LINK_MONITORING_POLICY = "osMiiLinkMonitoringPolicy"
    MO_CLASS_ID_OS_PRIMARY_SLAVE = "osPrimarySlave"
    MO_CLASS_ID_PCI_CARD = "pciCard"
    MO_CLASS_ID_PCI_EQUIP_SLOT = "pciEquipSlot"
    MO_CLASS_ID_PCI_LINK = "pciLink"
    MO_CLASS_ID_PCI_SWITCH = "pciSwitch"
    MO_CLASS_ID_PCI_UNIT = "pciUnit"
    MO_CLASS_ID_PFC_WATCH_DOG = "pfcWatchDog"
    MO_CLASS_ID_PFC_WATCH_DOG_FSM = "pfcWatchDogFsm"
    MO_CLASS_ID_PFC_WATCH_DOG_FSM_STAGE = "pfcWatchDogFsmStage"
    MO_CLASS_ID_PFC_WATCH_DOG_FSM_TASK = "pfcWatchDogFsmTask"
    MO_CLASS_ID_PKI_CERT_REQ = "pkiCertReq"
    MO_CLASS_ID_PKI_DEFINITION = "pkiDefinition"
    MO_CLASS_ID_PKI_EP = "pkiEp"
    MO_CLASS_ID_PKI_EP_FSM = "pkiEpFsm"
    MO_CLASS_ID_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    MO_CLASS_ID_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    MO_CLASS_ID_PKI_ITEM = "pkiItem"
    MO_CLASS_ID_PKI_KEY_RING = "pkiKeyRing"
    MO_CLASS_ID_PKI_TP = "pkiTP"
    MO_CLASS_ID_POLICY_ADEST_EP = "policyADestEp"
    MO_CLASS_ID_POLICY_BINDING = "policyBinding"
    MO_CLASS_ID_POLICY_CENTRALE_SYNC = "policyCentraleSync"
    MO_CLASS_ID_POLICY_CHILD_CLASS = "policyChildClass"
    MO_CLASS_ID_POLICY_COMMUNICATION = "policyCommunication"
    MO_CLASS_ID_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    MO_CLASS_ID_POLICY_CONFIG_ERROR = "policyConfigError"
    MO_CLASS_ID_POLICY_CONTEXT = "policyContext"
    MO_CLASS_ID_POLICY_CONTROL = "policyControl"
    MO_CLASS_ID_POLICY_CONTROL_EP = "policyControlEp"
    MO_CLASS_ID_POLICY_CONTROL_EP_FSM = "policyControlEpFsm"
    MO_CLASS_ID_POLICY_CONTROL_EP_FSM_STAGE = "policyControlEpFsmStage"
    MO_CLASS_ID_POLICY_CONTROL_EP_FSM_TASK = "policyControlEpFsmTask"
    MO_CLASS_ID_POLICY_CONTROLLED = "policyControlled"
    MO_CLASS_ID_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    MO_CLASS_ID_POLICY_CONTROLLED_TYPE = "policyControlledType"
    MO_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM = "policyControlledTypeFsm"
    MO_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM_STAGE = "policyControlledTypeFsmStage"
    MO_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM_TASK = "policyControlledTypeFsmTask"
    MO_CLASS_ID_POLICY_DATE_TIME = "policyDateTime"
    MO_CLASS_ID_POLICY_DEFINITION = "policyDefinition"
    MO_CLASS_ID_POLICY_DEST_CLASS = "policyDestClass"
    MO_CLASS_ID_POLICY_DEST_EP = "policyDestEp"
    MO_CLASS_ID_POLICY_DIGEST = "policyDigest"
    MO_CLASS_ID_POLICY_DISCOVERY = "policyDiscovery"
    MO_CLASS_ID_POLICY_DNS = "policyDns"
    MO_CLASS_ID_POLICY_ELEMENT = "policyElement"
    MO_CLASS_ID_POLICY_EQUIPMENT = "policyEquipment"
    MO_CLASS_ID_POLICY_FAULT = "policyFault"
    MO_CLASS_ID_POLICY_HOLDER = "policyHolder"
    MO_CLASS_ID_POLICY_ID_RESOLVE_POLICY = "policyIdResolvePolicy"
    MO_CLASS_ID_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    MO_CLASS_ID_POLICY_ITEM = "policyItem"
    MO_CLASS_ID_POLICY_LOCAL_MAP = "policyLocalMap"
    MO_CLASS_ID_POLICY_MEP = "policyMEp"
    MO_CLASS_ID_POLICY_MONITORING = "policyMonitoring"
    MO_CLASS_ID_POLICY_OBJECT = "policyObject"
    MO_CLASS_ID_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    MO_CLASS_ID_POLICY_POLICY_EP = "policyPolicyEp"
    MO_CLASS_ID_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    MO_CLASS_ID_POLICY_POLICY_SCOPE = "policyPolicyScope"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONT_FSM = "policyPolicyScopeContFsm"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONT_FSM_STAGE = "policyPolicyScopeContFsmStage"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONT_FSM_TASK = "policyPolicyScopeContFsmTask"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    MO_CLASS_ID_POLICY_PORT_CONFIG = "policyPortConfig"
    MO_CLASS_ID_POLICY_POWER_MGMT = "policyPowerMgmt"
    MO_CLASS_ID_POLICY_PSU = "policyPsu"
    MO_CLASS_ID_POLICY_REF_REQ = "policyRefReq"
    MO_CLASS_ID_POLICY_REQUESTOR = "policyRequestor"
    MO_CLASS_ID_POLICY_REQUESTOR_FSM = "policyRequestorFsm"
    MO_CLASS_ID_POLICY_REQUESTOR_FSM_STAGE = "policyRequestorFsmStage"
    MO_CLASS_ID_POLICY_REQUESTOR_FSM_TASK = "policyRequestorFsmTask"
    MO_CLASS_ID_POLICY_SCOPE = "policyScope"
    MO_CLASS_ID_POLICY_SECURITY = "policySecurity"
    MO_CLASS_ID_POLICY_SOURCE_APP = "policySourceApp"
    MO_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    MO_CLASS_ID_POLICY_SYSTEM_EP = "policySystemEp"
    MO_CLASS_ID_POOL_ELEMENT = "poolElement"
    MO_CLASS_ID_POOL_POOL = "poolPool"
    MO_CLASS_ID_POOL_POOL_MEMBER = "poolPoolMember"
    MO_CLASS_ID_POOL_POOLABLE = "poolPoolable"
    MO_CLASS_ID_POOL_UNIVERSE = "poolUniverse"
    MO_CLASS_ID_PORT_DOMAIN_EP = "portDomainEp"
    MO_CLASS_ID_PORT_GROUP = "portGroup"
    MO_CLASS_ID_PORT_INT_FIO = "portIntFIo"
    MO_CLASS_ID_PORT_PIO = "portPIo"
    MO_CLASS_ID_PORT_PIO_FSM = "portPIoFsm"
    MO_CLASS_ID_PORT_PIO_FSM_STAGE = "portPIoFsmStage"
    MO_CLASS_ID_PORT_PIO_FSM_TASK = "portPIoFsmTask"
    MO_CLASS_ID_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    MO_CLASS_ID_PORT_SERVER_INT_FIO = "portServerIntFIo"
    MO_CLASS_ID_PORT_SUB_GROUP = "portSubGroup"
    MO_CLASS_ID_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    MO_CLASS_ID_PORT_TRUST_MODE = "portTrustMode"
    MO_CLASS_ID_POWER_ABUDGET = "powerABudget"
    MO_CLASS_ID_POWER_AGROUP = "powerAGroup"
    MO_CLASS_ID_POWER_BUDGET = "powerBudget"
    MO_CLASS_ID_POWER_CHASSIS_MEMBER = "powerChassisMember"
    MO_CLASS_ID_POWER_EP = "powerEp"
    MO_CLASS_ID_POWER_FIMEMBER = "powerFIMember"
    MO_CLASS_ID_POWER_FEX_MEMBER = "powerFexMember"
    MO_CLASS_ID_POWER_GROUP = "powerGroup"
    MO_CLASS_ID_POWER_GROUP_ADDITION_POLICY = "powerGroupAdditionPolicy"
    MO_CLASS_ID_POWER_GROUP_MEMBER = "powerGroupMember"
    MO_CLASS_ID_POWER_GROUP_QUAL = "powerGroupQual"
    MO_CLASS_ID_POWER_GROUP_STATS = "powerGroupStats"
    MO_CLASS_ID_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    MO_CLASS_ID_POWER_MGMT_POLICY = "powerMgmtPolicy"
    MO_CLASS_ID_POWER_PLACEMENT = "powerPlacement"
    MO_CLASS_ID_POWER_POLICY = "powerPolicy"
    MO_CLASS_ID_POWER_PRIO_WGHT = "powerPrioWght"
    MO_CLASS_ID_POWER_PROFILED_POWER = "powerProfiledPower"
    MO_CLASS_ID_POWER_RACK_UNIT_MEMBER = "powerRackUnitMember"
    MO_CLASS_ID_PROC_DOER = "procDoer"
    MO_CLASS_ID_PROC_MANAGER = "procManager"
    MO_CLASS_ID_PROC_PROC_COUNTS = "procProcCounts"
    MO_CLASS_ID_PROC_PROCS = "procProcs"
    MO_CLASS_ID_PROC_PRT = "procPrt"
    MO_CLASS_ID_PROC_PRT_COUNTS = "procPrtCounts"
    MO_CLASS_ID_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    MO_CLASS_ID_PROC_SVC = "procSvc"
    MO_CLASS_ID_PROC_TX_COUNTS = "procTxCounts"
    MO_CLASS_ID_PROCESSOR_CACHE_MEM_STATS = "processorCacheMemStats"
    MO_CLASS_ID_PROCESSOR_COMPONENT = "processorComponent"
    MO_CLASS_ID_PROCESSOR_CORE = "processorCore"
    MO_CLASS_ID_PROCESSOR_ENV_STATS = "processorEnvStats"
    MO_CLASS_ID_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    MO_CLASS_ID_PROCESSOR_ERROR_STATS = "processorErrorStats"
    MO_CLASS_ID_PROCESSOR_EXEC_STATS = "processorExecStats"
    MO_CLASS_ID_PROCESSOR_IOSTATS = "processorIOStats"
    MO_CLASS_ID_PROCESSOR_MISC_STATS = "processorMiscStats"
    MO_CLASS_ID_PROCESSOR_PCIBUS_STATS = "processorPCIBusStats"
    MO_CLASS_ID_PROCESSOR_PMUSTATS = "processorPMUStats"
    MO_CLASS_ID_PROCESSOR_QUAL = "processorQual"
    MO_CLASS_ID_PROCESSOR_RUNTIME = "processorRuntime"
    MO_CLASS_ID_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    MO_CLASS_ID_PROCESSOR_SECURITY_STATS = "processorSecurityStats"
    MO_CLASS_ID_PROCESSOR_THREAD = "processorThread"
    MO_CLASS_ID_PROCESSOR_UNIT = "processorUnit"
    MO_CLASS_ID_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    MO_CLASS_ID_QOS_DEFINITION = "qosDefinition"
    MO_CLASS_ID_QOS_ITEM = "qosItem"
    MO_CLASS_ID_QOSCLASS_DEFINITION = "qosclassDefinition"
    MO_CLASS_ID_QOSCLASS_DEFINITION_FSM = "qosclassDefinitionFsm"
    MO_CLASS_ID_QOSCLASS_DEFINITION_FSM_STAGE = "qosclassDefinitionFsmStage"
    MO_CLASS_ID_QOSCLASS_DEFINITION_FSM_TASK = "qosclassDefinitionFsmTask"
    MO_CLASS_ID_QOSCLASS_ETH = "qosclassEth"
    MO_CLASS_ID_QOSCLASS_ETH_BE = "qosclassEthBE"
    MO_CLASS_ID_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    MO_CLASS_ID_QOSCLASS_FC = "qosclassFc"
    MO_CLASS_ID_QOSCLASS_ITEM = "qosclassItem"
    MO_CLASS_ID_QOSCLASS_SLOW_DRAIN = "qosclassSlowDrain"
    MO_CLASS_ID_QOSCLASS_SLOW_DRAIN_FSM = "qosclassSlowDrainFsm"
    MO_CLASS_ID_QOSCLASS_SLOW_DRAIN_FSM_STAGE = "qosclassSlowDrainFsmStage"
    MO_CLASS_ID_QOSCLASS_SLOW_DRAIN_FSM_TASK = "qosclassSlowDrainFsmTask"
    MO_CLASS_ID_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    MO_CLASS_ID_QUERYRESULT_ITEM = "queryresultItem"
    MO_CLASS_ID_QUERYRESULT_USAGE = "queryresultUsage"
    MO_CLASS_ID_RULE_DEFINITION = "ruleDefinition"
    MO_CLASS_ID_RULE_ITEM = "ruleItem"
    MO_CLASS_ID_RULE_REQUIREMENT = "ruleRequirement"
    MO_CLASS_ID_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    MO_CLASS_ID_SECURITY_UNIT = "securityUnit"
    MO_CLASS_ID_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    MO_CLASS_ID_SES_ENCLOSURE = "sesEnclosure"
    MO_CLASS_ID_SOL_CONFIG = "solConfig"
    MO_CLASS_ID_SOL_DEF = "solDef"
    MO_CLASS_ID_SOL_IF = "solIf"
    MO_CLASS_ID_SOL_POLICY = "solPolicy"
    MO_CLASS_ID_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    MO_CLASS_ID_STATS_COLLECTION_POLICY_FSM = "statsCollectionPolicyFsm"
    MO_CLASS_ID_STATS_COLLECTION_POLICY_FSM_STAGE = "statsCollectionPolicyFsmStage"
    MO_CLASS_ID_STATS_COLLECTION_POLICY_FSM_TASK = "statsCollectionPolicyFsmTask"
    MO_CLASS_ID_STATS_CURR = "statsCurr"
    MO_CLASS_ID_STATS_HIST = "statsHist"
    MO_CLASS_ID_STATS_HOLDER = "statsHolder"
    MO_CLASS_ID_STATS_ITEM = "statsItem"
    MO_CLASS_ID_STATS_THR32_DEFINITION = "statsThr32Definition"
    MO_CLASS_ID_STATS_THR32_VALUE = "statsThr32Value"
    MO_CLASS_ID_STATS_THR64_DEFINITION = "statsThr64Definition"
    MO_CLASS_ID_STATS_THR64_VALUE = "statsThr64Value"
    MO_CLASS_ID_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    MO_CLASS_ID_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    MO_CLASS_ID_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    MO_CLASS_ID_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    MO_CLASS_ID_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    MO_CLASS_ID_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    MO_CLASS_ID_STORAGE_ADEF = "storageADef"
    MO_CLASS_ID_STORAGE_ADISK_EP = "storageADiskEp"
    MO_CLASS_ID_STORAGE_ADISK_SLOT_EP = "storageADiskSlotEp"
    MO_CLASS_ID_STORAGE_ALUN = "storageALun"
    MO_CLASS_ID_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    MO_CLASS_ID_STORAGE_ASLOT = "storageASlot"
    MO_CLASS_ID_STORAGE_AUTH_KEY = "storageAuthKey"
    MO_CLASS_ID_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    MO_CLASS_ID_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    MO_CLASS_ID_STORAGE_CONTROLLER = "storageController"
    MO_CLASS_ID_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    MO_CLASS_ID_STORAGE_CONTROLLER_EP = "storageControllerEp"
    MO_CLASS_ID_STORAGE_CONTROLLER_REF = "storageControllerRef"
    MO_CLASS_ID_STORAGE_CONTROLLER_REFERENCE = "storageControllerReference"
    MO_CLASS_ID_STORAGE_DEVICE = "storageDevice"
    MO_CLASS_ID_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    MO_CLASS_ID_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    MO_CLASS_ID_STORAGE_DOMAIN_EP = "storageDomainEp"
    MO_CLASS_ID_STORAGE_DRIVE = "storageDrive"
    MO_CLASS_ID_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    MO_CLASS_ID_STORAGE_ENCLOSURE = "storageEnclosure"
    MO_CLASS_ID_STORAGE_ENCLOSURE_CAP = "storageEnclosureCap"
    MO_CLASS_ID_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    MO_CLASS_ID_STORAGE_ENCLOSURE_FSM = "storageEnclosureFsm"
    MO_CLASS_ID_STORAGE_ENCLOSURE_FSM_STAGE = "storageEnclosureFsmStage"
    MO_CLASS_ID_STORAGE_ENCLOSURE_FSM_TASK = "storageEnclosureFsmTask"
    MO_CLASS_ID_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    MO_CLASS_ID_STORAGE_EP = "storageEp"
    MO_CLASS_ID_STORAGE_EP_USER = "storageEpUser"
    MO_CLASS_ID_STORAGE_ETHER_IF = "storageEtherIf"
    MO_CLASS_ID_STORAGE_FC_IF = "storageFcIf"
    MO_CLASS_ID_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    MO_CLASS_ID_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM = "storageFlexFlashControllerFsm"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM_STAGE = "storageFlexFlashControllerFsmStage"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM_TASK = "storageFlexFlashControllerFsmTask"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    MO_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    MO_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    MO_CLASS_ID_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    MO_CLASS_ID_STORAGE_INI_GROUP = "storageIniGroup"
    MO_CLASS_ID_STORAGE_INITIATOR = "storageInitiator"
    MO_CLASS_ID_STORAGE_ITEM = "storageItem"
    MO_CLASS_ID_STORAGE_L2_IF = "storageL2If"
    MO_CLASS_ID_STORAGE_LOCAL_DISK = "storageLocalDisk"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_FSM = "storageLocalDiskFsm"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_FSM_STAGE = "storageLocalDiskFsmStage"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_FSM_TASK = "storageLocalDiskFsmTask"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_SLOT_EP = "storageLocalDiskSlotEp"
    MO_CLASS_ID_STORAGE_LOCAL_LUN = "storageLocalLun"
    MO_CLASS_ID_STORAGE_LOGICAL = "storageLogical"
    MO_CLASS_ID_STORAGE_LUN_DISK = "storageLunDisk"
    MO_CLASS_ID_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    MO_CLASS_ID_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    MO_CLASS_ID_STORAGE_MINI_STORAGE = "storageMiniStorage"
    MO_CLASS_ID_STORAGE_NODE_EP = "storageNodeEp"
    MO_CLASS_ID_STORAGE_NVME_STATS = "storageNvmeStats"
    MO_CLASS_ID_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    MO_CLASS_ID_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    MO_CLASS_ID_STORAGE_NVME_SWITCH = "storageNvmeSwitch"
    MO_CLASS_ID_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    MO_CLASS_ID_STORAGE_OPERATION = "storageOperation"
    MO_CLASS_ID_STORAGE_PHYSICAL = "storagePhysical"
    MO_CLASS_ID_STORAGE_QUAL = "storageQual"
    MO_CLASS_ID_STORAGE_RAID_BATTERY = "storageRaidBattery"
    MO_CLASS_ID_STORAGE_SAS_EXPANDER = "storageSasExpander"
    MO_CLASS_ID_STORAGE_SAS_LINK_DESCRIPTOR = "storageSasLinkDescriptor"
    MO_CLASS_ID_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    MO_CLASS_ID_STORAGE_SAS_PORT = "storageSasPort"
    MO_CLASS_ID_STORAGE_SAS_PORT_DESCRIPTOR = "storageSasPortDescriptor"
    MO_CLASS_ID_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    MO_CLASS_ID_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    MO_CLASS_ID_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    MO_CLASS_ID_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    MO_CLASS_ID_STORAGE_SYSTEM = "storageSystem"
    MO_CLASS_ID_STORAGE_SYSTEM_FSM = "storageSystemFsm"
    MO_CLASS_ID_STORAGE_SYSTEM_FSM_STAGE = "storageSystemFsmStage"
    MO_CLASS_ID_STORAGE_SYSTEM_FSM_TASK = "storageSystemFsmTask"
    MO_CLASS_ID_STORAGE_TARGET = "storageTarget"
    MO_CLASS_ID_STORAGE_TARGET_IF = "storageTargetIf"
    MO_CLASS_ID_STORAGE_TRANSPORT_IF = "storageTransportIf"
    MO_CLASS_ID_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    MO_CLASS_ID_STORAGE_UNIT = "storageUnit"
    MO_CLASS_ID_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    MO_CLASS_ID_STORAGE_VSAN_REF = "storageVsanRef"
    MO_CLASS_ID_SW_ACCESS_DOMAIN = "swAccessDomain"
    MO_CLASS_ID_SW_ACCESS_DOMAIN_FSM = "swAccessDomainFsm"
    MO_CLASS_ID_SW_ACCESS_DOMAIN_FSM_STAGE = "swAccessDomainFsmStage"
    MO_CLASS_ID_SW_ACCESS_DOMAIN_FSM_TASK = "swAccessDomainFsmTask"
    MO_CLASS_ID_SW_ACCESS_EP = "swAccessEp"
    MO_CLASS_ID_SW_BORDER_DOMAIN = "swBorderDomain"
    MO_CLASS_ID_SW_BORDER_EP = "swBorderEp"
    MO_CLASS_ID_SW_BORDER_PC = "swBorderPc"
    MO_CLASS_ID_SW_CIO_EP = "swCIoEp"
    MO_CLASS_ID_SW_CARD_ENV_STATS = "swCardEnvStats"
    MO_CLASS_ID_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    MO_CLASS_ID_SW_CMCLAN = "swCmclan"
    MO_CLASS_ID_SW_DOMAIN = "swDomain"
    MO_CLASS_ID_SW_ENV_STATS = "swEnvStats"
    MO_CLASS_ID_SW_ENV_STATS_HIST = "swEnvStatsHist"
    MO_CLASS_ID_SW_ESTC_EP = "swEstcEp"
    MO_CLASS_ID_SW_ETH_ESTC_EP = "swEthEstcEp"
    MO_CLASS_ID_SW_ETH_ESTC_PC = "swEthEstcPc"
    MO_CLASS_ID_SW_ETH_FLOW_MON_SESSION = "swEthFlowMonSession"
    MO_CLASS_ID_SW_ETH_LAN_BORDER = "swEthLanBorder"
    MO_CLASS_ID_SW_ETH_LAN_BORDER_FSM = "swEthLanBorderFsm"
    MO_CLASS_ID_SW_ETH_LAN_BORDER_FSM_STAGE = "swEthLanBorderFsmStage"
    MO_CLASS_ID_SW_ETH_LAN_BORDER_FSM_TASK = "swEthLanBorderFsmTask"
    MO_CLASS_ID_SW_ETH_LAN_EP = "swEthLanEp"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MON = "swEthLanFlowMon"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MON_EXPORTER = "swEthLanFlowMonExporter"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM = "swEthLanFlowMonFsm"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM_STAGE = "swEthLanFlowMonFsmStage"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM_TASK = "swEthLanFlowMonFsmTask"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_MONITOR = "swEthLanFlowMonitor"
    MO_CLASS_ID_SW_ETH_LAN_FLOW_RECORD_DEF = "swEthLanFlowRecordDef"
    MO_CLASS_ID_SW_ETH_LAN_MON = "swEthLanMon"
    MO_CLASS_ID_SW_ETH_LAN_PC = "swEthLanPc"
    MO_CLASS_ID_SW_ETH_MON = "swEthMon"
    MO_CLASS_ID_SW_ETH_MON_DEST_EP = "swEthMonDestEp"
    MO_CLASS_ID_SW_ETH_MON_FSM = "swEthMonFsm"
    MO_CLASS_ID_SW_ETH_MON_FSM_STAGE = "swEthMonFsmStage"
    MO_CLASS_ID_SW_ETH_MON_FSM_TASK = "swEthMonFsmTask"
    MO_CLASS_ID_SW_ETH_MON_SRC_EP = "swEthMonSrcEp"
    MO_CLASS_ID_SW_ETH_TARGET_EP = "swEthTargetEp"
    MO_CLASS_ID_SW_ETHER_PORT = "swEtherPort"
    MO_CLASS_ID_SW_EXT_UTILITY = "swExtUtility"
    MO_CLASS_ID_SW_EXT_UTILITY_FSM = "swExtUtilityFsm"
    MO_CLASS_ID_SW_EXT_UTILITY_FSM_STAGE = "swExtUtilityFsmStage"
    MO_CLASS_ID_SW_EXT_UTILITY_FSM_TASK = "swExtUtilityFsmTask"
    MO_CLASS_ID_SW_FABRIC_ZONE_NS = "swFabricZoneNs"
    MO_CLASS_ID_SW_FABRIC_ZONE_NS_OVERRIDE = "swFabricZoneNsOverride"
    MO_CLASS_ID_SW_FC_ENDPOINT = "swFcEndpoint"
    MO_CLASS_ID_SW_FC_ESTC_EP = "swFcEstcEp"
    MO_CLASS_ID_SW_FC_MON = "swFcMon"
    MO_CLASS_ID_SW_FC_MON_DEST_EP = "swFcMonDestEp"
    MO_CLASS_ID_SW_FC_MON_FSM = "swFcMonFsm"
    MO_CLASS_ID_SW_FC_MON_FSM_STAGE = "swFcMonFsmStage"
    MO_CLASS_ID_SW_FC_MON_FSM_TASK = "swFcMonFsmTask"
    MO_CLASS_ID_SW_FC_MON_SRC_EP = "swFcMonSrcEp"
    MO_CLASS_ID_SW_FC_SAN_BORDER = "swFcSanBorder"
    MO_CLASS_ID_SW_FC_SAN_BORDER_FSM = "swFcSanBorderFsm"
    MO_CLASS_ID_SW_FC_SAN_BORDER_FSM_STAGE = "swFcSanBorderFsmStage"
    MO_CLASS_ID_SW_FC_SAN_BORDER_FSM_TASK = "swFcSanBorderFsmTask"
    MO_CLASS_ID_SW_FC_SAN_EP = "swFcSanEp"
    MO_CLASS_ID_SW_FC_SAN_MON = "swFcSanMon"
    MO_CLASS_ID_SW_FC_SAN_PC = "swFcSanPc"
    MO_CLASS_ID_SW_FC_SERVER_ZONE_GROUP = "swFcServerZoneGroup"
    MO_CLASS_ID_SW_FC_USER_ZONE = "swFcUserZone"
    MO_CLASS_ID_SW_FC_USER_ZONE_GROUP = "swFcUserZoneGroup"
    MO_CLASS_ID_SW_FC_ZONE = "swFcZone"
    MO_CLASS_ID_SW_FC_ZONE_MEMBER = "swFcZoneMember"
    MO_CLASS_ID_SW_FC_ZONE_SET = "swFcZoneSet"
    MO_CLASS_ID_SW_FCOE_ESTC_EP = "swFcoeEstcEp"
    MO_CLASS_ID_SW_FCOE_SAN_EP = "swFcoeSanEp"
    MO_CLASS_ID_SW_FCOE_SAN_PC = "swFcoeSanPc"
    MO_CLASS_ID_SW_FLOW_MON_EXPORTER = "swFlowMonExporter"
    MO_CLASS_ID_SW_FLOW_MONITOR = "swFlowMonitor"
    MO_CLASS_ID_SW_FLOW_RECORD_DEF = "swFlowRecordDef"
    MO_CLASS_ID_SW_IP_ROUTE = "swIpRoute"
    MO_CLASS_ID_SW_LAN_BORDER = "swLanBorder"
    MO_CLASS_ID_SW_LAN_EP = "swLanEp"
    MO_CLASS_ID_SW_LAN_MON = "swLanMon"
    MO_CLASS_ID_SW_LAN_PC = "swLanPc"
    MO_CLASS_ID_SW_MON = "swMon"
    MO_CLASS_ID_SW_MON_DEST_EP = "swMonDestEp"
    MO_CLASS_ID_SW_MON_DOMAIN = "swMonDomain"
    MO_CLASS_ID_SW_MON_SRC_EP = "swMonSrcEp"
    MO_CLASS_ID_SW_NFEXPORTER_REF = "swNFExporterRef"
    MO_CLASS_ID_SW_NETFLOW_EXPORTER = "swNetflowExporter"
    MO_CLASS_ID_SW_NETFLOW_MON_SESSION = "swNetflowMonSession"
    MO_CLASS_ID_SW_NETFLOW_MONITOR = "swNetflowMonitor"
    MO_CLASS_ID_SW_NETFLOW_MONITOR_REF = "swNetflowMonitorRef"
    MO_CLASS_ID_SW_NETFLOW_RECORD_DEF = "swNetflowRecordDef"
    MO_CLASS_ID_SW_PIO_EP = "swPIoEp"
    MO_CLASS_ID_SW_PHYS = "swPhys"
    MO_CLASS_ID_SW_PHYS_ETHER_EP = "swPhysEtherEp"
    MO_CLASS_ID_SW_PHYS_FC_EP = "swPhysFcEp"
    MO_CLASS_ID_SW_PHYS_FSM = "swPhysFsm"
    MO_CLASS_ID_SW_PHYS_FSM_STAGE = "swPhysFsmStage"
    MO_CLASS_ID_SW_PHYS_FSM_TASK = "swPhysFsmTask"
    MO_CLASS_ID_SW_PORT_BREAKOUT = "swPortBreakout"
    MO_CLASS_ID_SW_PORT_DISCOVER = "swPortDiscover"
    MO_CLASS_ID_SW_PORT_DISCOVER_FSM = "swPortDiscoverFsm"
    MO_CLASS_ID_SW_PORT_DISCOVER_FSM_STAGE = "swPortDiscoverFsmStage"
    MO_CLASS_ID_SW_PORT_DISCOVER_FSM_TASK = "swPortDiscoverFsmTask"
    MO_CLASS_ID_SW_SAN_BORDER = "swSanBorder"
    MO_CLASS_ID_SW_SAN_EP = "swSanEp"
    MO_CLASS_ID_SW_SAN_MON = "swSanMon"
    MO_CLASS_ID_SW_SAN_PC = "swSanPc"
    MO_CLASS_ID_SW_SUB_GROUP = "swSubGroup"
    MO_CLASS_ID_SW_SYSTEM_STATS = "swSystemStats"
    MO_CLASS_ID_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    MO_CLASS_ID_SW_TARGET_EP = "swTargetEp"
    MO_CLASS_ID_SW_ULAN = "swUlan"
    MO_CLASS_ID_SW_UTILITY_DOMAIN = "swUtilityDomain"
    MO_CLASS_ID_SW_UTILITY_DOMAIN_FSM = "swUtilityDomainFsm"
    MO_CLASS_ID_SW_UTILITY_DOMAIN_FSM_STAGE = "swUtilityDomainFsmStage"
    MO_CLASS_ID_SW_UTILITY_DOMAIN_FSM_TASK = "swUtilityDomainFsmTask"
    MO_CLASS_ID_SW_VIFREF = "swVIFRef"
    MO_CLASS_ID_SW_VIRT_L3_INTF = "swVirtL3Intf"
    MO_CLASS_ID_SW_VLAN = "swVlan"
    MO_CLASS_ID_SW_VLAN_GROUP = "swVlanGroup"
    MO_CLASS_ID_SW_VLAN_PORT_NS = "swVlanPortNs"
    MO_CLASS_ID_SW_VLAN_PORT_NS_OVERRIDE = "swVlanPortNsOverride"
    MO_CLASS_ID_SW_VLAN_REF = "swVlanRef"
    MO_CLASS_ID_SW_VSAN = "swVsan"
    MO_CLASS_ID_SW_ZONE_INITIATOR_MEMBER = "swZoneInitiatorMember"
    MO_CLASS_ID_SW_ZONE_TARGET_MEMBER = "swZoneTargetMember"
    MO_CLASS_ID_SWAT_ACTION = "swatAction"
    MO_CLASS_ID_SWAT_CONDITION = "swatCondition"
    MO_CLASS_ID_SWAT_INJECTION = "swatInjection"
    MO_CLASS_ID_SWAT_RESULTSTATS = "swatResultstats"
    MO_CLASS_ID_SWAT_TARGET = "swatTarget"
    MO_CLASS_ID_SWAT_TRIGGER = "swatTrigger"
    MO_CLASS_ID_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    MO_CLASS_ID_SYNTHETIC_FILE = "syntheticFile"
    MO_CLASS_ID_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    MO_CLASS_ID_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    MO_CLASS_ID_SYNTHETIC_FS_OBJ_FSM = "syntheticFsObjFsm"
    MO_CLASS_ID_SYNTHETIC_FS_OBJ_FSM_STAGE = "syntheticFsObjFsmStage"
    MO_CLASS_ID_SYNTHETIC_FS_OBJ_FSM_TASK = "syntheticFsObjFsmTask"
    MO_CLASS_ID_SYNTHETIC_TIME = "syntheticTime"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    MO_CLASS_ID_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    MO_CLASS_ID_SYSDEBUG_CORE = "sysdebugCore"
    MO_CLASS_ID_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    MO_CLASS_ID_SYSDEBUG_CORE_FSM = "sysdebugCoreFsm"
    MO_CLASS_ID_SYSDEBUG_CORE_FSM_STAGE = "sysdebugCoreFsmStage"
    MO_CLASS_ID_SYSDEBUG_CORE_FSM_TASK = "sysdebugCoreFsmTask"
    MO_CLASS_ID_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    MO_CLASS_ID_SYSDEBUG_DIAGNOSTIC_LOG_REPOSITORY = "sysdebugDiagnosticLogRepository"
    MO_CLASS_ID_SYSDEBUG_EP = "sysdebugEp"
    MO_CLASS_ID_SYSDEBUG_EXPORTER = "sysdebugExporter"
    MO_CLASS_ID_SYSDEBUG_FILE = "sysdebugFile"
    MO_CLASS_ID_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    MO_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY = "sysdebugLogExportPolicy"
    MO_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM = "sysdebugLogExportPolicyFsm"
    MO_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM_STAGE = "sysdebugLogExportPolicyFsmStage"
    MO_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM_TASK = "sysdebugLogExportPolicyFsmTask"
    MO_CLASS_ID_SYSDEBUG_LOG_EXPORT_STATUS = "sysdebugLogExportStatus"
    MO_CLASS_ID_SYSDEBUG_MEP_LOG = "sysdebugMEpLog"
    MO_CLASS_ID_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    MO_CLASS_ID_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    MO_CLASS_ID_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    MO_CLASS_ID_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    MO_CLASS_ID_SYSFILE_DIGEST = "sysfileDigest"
    MO_CLASS_ID_SYSFILE_EP = "sysfileEp"
    MO_CLASS_ID_SYSFILE_EXPORTER = "sysfileExporter"
    MO_CLASS_ID_SYSFILE_IMPORTER = "sysfileImporter"
    MO_CLASS_ID_SYSFILE_INSTANCE = "sysfileInstance"
    MO_CLASS_ID_SYSFILE_MUTATION = "sysfileMutation"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    MO_CLASS_ID_SYSFILE_REPOSITORY = "sysfileRepository"
    MO_CLASS_ID_TOP_INFO_POLICY = "topInfoPolicy"
    MO_CLASS_ID_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    MO_CLASS_ID_TOP_META_INF = "topMetaInf"
    MO_CLASS_ID_TOP_ROOT = "topRoot"
    MO_CLASS_ID_TOP_SYS_DEFAULTS = "topSysDefaults"
    MO_CLASS_ID_TOP_SYSTEM = "topSystem"
    MO_CLASS_ID_TRIG_ABS_WINDOW = "trigAbsWindow"
    MO_CLASS_ID_TRIG_ACK = "trigAck"
    MO_CLASS_ID_TRIG_BASE_ABS_WINDOW = "trigBaseAbsWindow"
    MO_CLASS_ID_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    MO_CLASS_ID_TRIG_BASE_SCHED = "trigBaseSched"
    MO_CLASS_ID_TRIG_CLIENT_TOKEN = "trigClientToken"
    MO_CLASS_ID_TRIG_CONF_ACK = "trigConfAck"
    MO_CLASS_ID_TRIG_INST = "trigInst"
    MO_CLASS_ID_TRIG_LOCAL_ABS_WINDOW = "trigLocalAbsWindow"
    MO_CLASS_ID_TRIG_LOCAL_SCHED = "trigLocalSched"
    MO_CLASS_ID_TRIG_META = "trigMeta"
    MO_CLASS_ID_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    MO_CLASS_ID_TRIG_RES_ACK = "trigResAck"
    MO_CLASS_ID_TRIG_SCHED = "trigSched"
    MO_CLASS_ID_TRIG_SCHED_WINDOW = "trigSchedWindow"
    MO_CLASS_ID_TRIG_TEST = "trigTest"
    MO_CLASS_ID_TRIG_TOKEN = "trigToken"
    MO_CLASS_ID_TRIG_TRIGGERABLE = "trigTriggerable"
    MO_CLASS_ID_TRIG_TRIGGERED = "trigTriggered"
    MO_CLASS_ID_TRIG_WINDOW = "trigWindow"
    MO_CLASS_ID_UNSPECIFIED = "unspecified"
    MO_CLASS_ID_UUIDPOOL_ADDR = "uuidpoolAddr"
    MO_CLASS_ID_UUIDPOOL_BLOCK = "uuidpoolBlock"
    MO_CLASS_ID_UUIDPOOL_FORMAT = "uuidpoolFormat"
    MO_CLASS_ID_UUIDPOOL_POOL = "uuidpoolPool"
    MO_CLASS_ID_UUIDPOOL_POOLABLE = "uuidpoolPoolable"
    MO_CLASS_ID_UUIDPOOL_POOLED = "uuidpoolPooled"
    MO_CLASS_ID_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    MO_CLASS_ID_VERSION_APPLICATION = "versionApplication"
    MO_CLASS_ID_VERSION_EP = "versionEp"
    MO_CLASS_ID_VERSION_VERSION = "versionVersion"
    MO_CLASS_ID_VM_ADAPTOR = "vmAdaptor"
    MO_CLASS_ID_VM_CLIENT_CONTAINER = "vmClientContainer"
    MO_CLASS_ID_VM_COMPUTE_EP = "vmComputeEp"
    MO_CLASS_ID_VM_CONT = "vmCont"
    MO_CLASS_ID_VM_DC = "vmDC"
    MO_CLASS_ID_VM_DCORG = "vmDCOrg"
    MO_CLASS_ID_VM_DIR_CONT = "vmDirCont"
    MO_CLASS_ID_VM_EP = "vmEp"
    MO_CLASS_ID_VM_HBA = "vmHba"
    MO_CLASS_ID_VM_HV = "vmHv"
    MO_CLASS_ID_VM_INSTANCE = "vmInstance"
    MO_CLASS_ID_VM_LIFE_CYCLE_POLICY = "vmLifeCyclePolicy"
    MO_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM = "vmLifeCyclePolicyFsm"
    MO_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM_STAGE = "vmLifeCyclePolicyFsmStage"
    MO_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM_TASK = "vmLifeCyclePolicyFsmTask"
    MO_CLASS_ID_VM_NIC = "vmNic"
    MO_CLASS_ID_VM_ORG = "vmOrg"
    MO_CLASS_ID_VM_SWITCH = "vmSwitch"
    MO_CLASS_ID_VM_VIF = "vmVif"
    MO_CLASS_ID_VM_VIRTUAL = "vmVirtual"
    MO_CLASS_ID_VM_VLAN = "vmVlan"
    MO_CLASS_ID_VM_VNIC_PROF_CL = "vmVnicProfCl"
    MO_CLASS_ID_VM_VNIC_PROF_INST = "vmVnicProfInst"
    MO_CLASS_ID_VM_VSAN = "vmVsan"
    MO_CLASS_ID_VNIC_ABEH = "vnicABeh"
    MO_CLASS_ID_VNIC_AETHER_IF = "vnicAEtherIf"
    MO_CLASS_ID_VNIC_AFC_IF = "vnicAFcIf"
    MO_CLASS_ID_VNIC_AGROUP = "vnicAGroup"
    MO_CLASS_ID_VNIC_AIPC_IF = "vnicAIpcIf"
    MO_CLASS_ID_VNIC_ASCSI_IF = "vnicAScsiIf"
    MO_CLASS_ID_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    MO_CLASS_ID_VNIC_BOOT_TARGET = "vnicBootTarget"
    MO_CLASS_ID_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    MO_CLASS_ID_VNIC_CON_REQ = "vnicConReq"
    MO_CLASS_ID_VNIC_CONN_DEF = "vnicConnDef"
    MO_CLASS_ID_VNIC_CONNECTION = "vnicConnection"
    MO_CLASS_ID_VNIC_DEF_BEH = "vnicDefBeh"
    MO_CLASS_ID_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    MO_CLASS_ID_VNIC_DYNAMIC_ID_UNIVERSE = "vnicDynamicIdUniverse"
    MO_CLASS_ID_VNIC_DYNAMIC_PROVIDER = "vnicDynamicProvider"
    MO_CLASS_ID_VNIC_DYNAMIC_PROVIDER_EP = "vnicDynamicProviderEp"
    MO_CLASS_ID_VNIC_ETH_CONFIG = "vnicEthConfig"
    MO_CLASS_ID_VNIC_ETH_LIF = "vnicEthLif"
    MO_CLASS_ID_VNIC_ETHER = "vnicEther"
    MO_CLASS_ID_VNIC_ETHER_BASE = "vnicEtherBase"
    MO_CLASS_ID_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    MO_CLASS_ID_VNIC_ETHER_IF = "vnicEtherIf"
    MO_CLASS_ID_VNIC_FC = "vnicFc"
    MO_CLASS_ID_VNIC_FC_BASE = "vnicFcBase"
    MO_CLASS_ID_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    MO_CLASS_ID_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    MO_CLASS_ID_VNIC_FC_IF = "vnicFcIf"
    MO_CLASS_ID_VNIC_FC_LIF = "vnicFcLif"
    MO_CLASS_ID_VNIC_FC_NODE = "vnicFcNode"
    MO_CLASS_ID_VNIC_FC_OEIF = "vnicFcOEIf"
    MO_CLASS_ID_VNIC_IPIF = "vnicIPIf"
    MO_CLASS_ID_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    MO_CLASS_ID_VNIC_IPV4_DNS = "vnicIPv4Dns"
    MO_CLASS_ID_VNIC_IPV4_IF = "vnicIPv4If"
    MO_CLASS_ID_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    MO_CLASS_ID_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    MO_CLASS_ID_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    MO_CLASS_ID_VNIC_IPV6_IF = "vnicIPv6If"
    MO_CLASS_ID_VNIC_ISCSI = "vnicIScsi"
    MO_CLASS_ID_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    MO_CLASS_ID_VNIC_ISCSI_BASE = "vnicIScsiBase"
    MO_CLASS_ID_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    MO_CLASS_ID_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    MO_CLASS_ID_VNIC_ISCSI_CONFIG = "vnicIScsiConfig"
    MO_CLASS_ID_VNIC_ISCSI_INIT_AUTO_CONFIG_POLICY = "vnicIScsiInitAutoConfigPolicy"
    MO_CLASS_ID_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    MO_CLASS_ID_VNIC_ISCSI_NODE = "vnicIScsiNode"
    MO_CLASS_ID_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    MO_CLASS_ID_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    MO_CLASS_ID_VNIC_IF = "vnicIf"
    MO_CLASS_ID_VNIC_IF_ROLE = "vnicIfRole"
    MO_CLASS_ID_VNIC_INITIATOR_AUTO_CONFIG_POLICY = "vnicInitiatorAutoConfigPolicy"
    MO_CLASS_ID_VNIC_INTERNAL_PROFILE = "vnicInternalProfile"
    MO_CLASS_ID_VNIC_IP_ADDR = "vnicIpAddr"
    MO_CLASS_ID_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    MO_CLASS_ID_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    MO_CLASS_ID_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    MO_CLASS_ID_VNIC_IP_V4_HISTORY = "vnicIpV4History"
    MO_CLASS_ID_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    MO_CLASS_ID_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    MO_CLASS_ID_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    MO_CLASS_ID_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    MO_CLASS_ID_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    MO_CLASS_ID_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    MO_CLASS_ID_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    MO_CLASS_ID_VNIC_IP_V6_HISTORY = "vnicIpV6History"
    MO_CLASS_ID_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    MO_CLASS_ID_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    MO_CLASS_ID_VNIC_IPC = "vnicIpc"
    MO_CLASS_ID_VNIC_IPC_IF = "vnicIpcIf"
    MO_CLASS_ID_VNIC_IQN_HISTORY = "vnicIqnHistory"
    MO_CLASS_ID_VNIC_L2_IF = "vnicL2If"
    MO_CLASS_ID_VNIC_L2_LIF = "vnicL2Lif"
    MO_CLASS_ID_VNIC_L3_IF = "vnicL3If"
    MO_CLASS_ID_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    MO_CLASS_ID_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    MO_CLASS_ID_VNIC_LIF_VLAN = "vnicLifVlan"
    MO_CLASS_ID_VNIC_LIF_VSAN = "vnicLifVsan"
    MO_CLASS_ID_VNIC_LUN = "vnicLun"
    MO_CLASS_ID_VNIC_MAC_HISTORY = "vnicMacHistory"
    MO_CLASS_ID_VNIC_NIC_CONN = "vnicNicConn"
    MO_CLASS_ID_VNIC_OPROFILE_ALIAS = "vnicOProfileAlias"
    MO_CLASS_ID_VNIC_PROFILE = "vnicProfile"
    MO_CLASS_ID_VNIC_PROFILE_ALIAS = "vnicProfileAlias"
    MO_CLASS_ID_VNIC_PROFILE_REF = "vnicProfileRef"
    MO_CLASS_ID_VNIC_PROFILE_SET = "vnicProfileSet"
    MO_CLASS_ID_VNIC_PROFILE_SET_FSM = "vnicProfileSetFsm"
    MO_CLASS_ID_VNIC_PROFILE_SET_FSM_STAGE = "vnicProfileSetFsmStage"
    MO_CLASS_ID_VNIC_PROFILE_SET_FSM_TASK = "vnicProfileSetFsmTask"
    MO_CLASS_ID_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    MO_CLASS_ID_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    MO_CLASS_ID_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    MO_CLASS_ID_VNIC_SCSI = "vnicScsi"
    MO_CLASS_ID_VNIC_SCSI_IF = "vnicScsiIf"
    MO_CLASS_ID_VNIC_TEMPL = "vnicTempl"
    MO_CLASS_ID_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    MO_CLASS_ID_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    MO_CLASS_ID_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    MO_CLASS_ID_VNIC_VPROFILE_ALIAS = "vnicVProfileAlias"
    MO_CLASS_ID_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    MO_CLASS_ID_VNIC_VLAN = "vnicVlan"
    MO_CLASS_ID_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    MO_CLASS_ID_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    MO_CLASS_ID_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    MO_CLASS_ID_VNIC_VNIC = "vnicVnic"
    MO_CLASS_ID_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"
    MO_CLASS_ID_VNIC_WWNN_HISTORY = "vnicWwnnHistory"
    MO_CLASS_ID_VNIC_WWPN_HISTORY = "vnicWwpnHistory"


class FaultAffectedClass(ManagedObject):
    """This is FaultAffectedClass class."""

    consts = FaultAffectedClassConsts()
    naming_props = set(['moClassId'])

    mo_meta = MoMeta("FaultAffectedClass", "faultAffectedClass", "fault-[mo_class_id]", VersionMeta.Version211a, "InputOutput", 0x3f, [], ["admin", "fault"], ['faultSuppressPolicy'], [], [None])

    prop_meta = {
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version211a, MoPropertyMeta.INTERNAL, 0x2, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []),
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, 0x4, 0, 256, None, [], []),
        "mo_class_id": MoPropertyMeta("mo_class_id", "moClassId", "string", VersionMeta.Version211a, MoPropertyMeta.NAMING, 0x8, None, None, None, ["aaaAuthMethod", "aaaAuthRealm", "aaaAuthRealmFsm", "aaaAuthRealmFsmStage", "aaaBanner", "aaaCimcSession", "aaaConfig", "aaaConsoleAuth", "aaaDefaultAuth", "aaaDefinition", "aaaDomain", "aaaDomainAuth", "aaaEp", "aaaEpAuthProfile", "aaaEpFsm", "aaaEpFsmStage", "aaaEpFsmTask", "aaaEpLogin", "aaaEpUser", "aaaExtMgmtCutThruTkn", "aaaItem", "aaaLdapEp", "aaaLdapEpFsm", "aaaLdapEpFsmStage", "aaaLdapGroup", "aaaLdapGroupRule", "aaaLdapProvider", "aaaLocalMgmtCmdLog", "aaaLocale", "aaaLog", "aaaLoginProfile", "aaaModLR", "aaaOrg", "aaaPreLoginBanner", "aaaProvider", "aaaProviderGroup", "aaaProviderRef", "aaaPwdProfile", "aaaRadiusEp", "aaaRadiusEpFsm", "aaaRadiusEpFsmStage", "aaaRadiusProvider", "aaaRealm", "aaaRealmFsm", "aaaRealmFsmStage", "aaaRealmFsmTask", "aaaRemoteUser", "aaaRole", "aaaSession", "aaaSessionInfo", "aaaSessionInfoTable", "aaaSessionLR", "aaaShellLogin", "aaaSshAuth", "aaaSystemUser", "aaaTacacsPlusEp", "aaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsmStage", "aaaTacacsPlusProvider", "aaaUser", "aaaUserAction", "aaaUserData", "aaaUserEp", "aaaUserEpFsm", "aaaUserEpFsmStage", "aaaUserEpFsmTask", "aaaUserGroup", "aaaUserLocale", "aaaUserLogin", "aaaUserRole", "aaaWebLogin", "adaptorAzureQosProfile", "adaptorBehCap", "adaptorCIoEp", "adaptorCapDef", "adaptorCapQual", "adaptorCapSpec", "adaptorDiagCap", "adaptorDynamicConfigCap", "adaptorEthAdvFilterProfile", "adaptorEthArfsProfile", "adaptorEthCompQueueProfile", "adaptorEthFailoverProfile", "adaptorEthGENEVEProfile", "adaptorEthInterruptProfile", "adaptorEthInterruptScalingProfile", "adaptorEthNVGREProfile", "adaptorEthOffloadProfile", "adaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStatsHist", "adaptorEthPortErrStats", "adaptorEthPortErrStatsHist", "adaptorEthPortMcastStats", "adaptorEthPortMcastStatsHist", "adaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStatsHist", "adaptorEthPortStats", "adaptorEthPortStatsHist", "adaptorEthQueueProfile", "adaptorEthRecvQueueProfile", "adaptorEthRoCEProfile", "adaptorEthVxLANProfile", "adaptorEthWorkQueueProfile", "adaptorEtherIfStats", "adaptorEtherIfStatsHist", "adaptorExtEthIf", "adaptorExtEthIfFsm", "adaptorExtEthIfFsmStage", "adaptorExtEthIfFsmTask", "adaptorExtEthIfPc", "adaptorExtEthIfPcEp", "adaptorExtIf", "adaptorExtIfEp", "adaptorExtIfPc", "adaptorExtIpV6RssHashProfile", "adaptorExternalEp", "adaptorExternalPc", "adaptorFamilyTypeDef", "adaptorFcCdbWorkQueueProfile", "adaptorFcErrorRecoveryProfile", "adaptorFcFnicProfile", "adaptorFcIfEventStats", "adaptorFcIfEventStatsHist", "adaptorFcIfFC4Stats", "adaptorFcIfFC4StatsHist", "adaptorFcIfFrameStats", "adaptorFcIfFrameStatsHist", "adaptorFcInterruptProfile", "adaptorFcLogiProfile", "adaptorFcOEIf", "adaptorFcPortFLogiProfile", "adaptorFcPortPLogiProfile", "adaptorFcPortProfile", "adaptorFcPortStats", "adaptorFcPortStatsHist", "adaptorFcQueueProfile", "adaptorFcRecvQueueProfile", "adaptorFcVhbaTypeProfile", "adaptorFcWorkQueueProfile", "adaptorFruCapProvider", "adaptorFruCapRef", "adaptorFwCapProvider", "adaptorHostEthIf", "adaptorHostEthIfFsm", "adaptorHostEthIfFsmStage", "adaptorHostEthIfFsmTask", "adaptorHostEthIfProfile", "adaptorHostFcIf", "adaptorHostFcIfFsm", "adaptorHostFcIfFsmStage", "adaptorHostFcIfFsmTask", "adaptorHostFcIfProfile", "adaptorHostIf", "adaptorHostIfConfig", "adaptorHostIfConnDef", "adaptorHostIfProfile", "adaptorHostIscsiIf", "adaptorHostIscsiIfProfile", "adaptorHostMgmtCap", "adaptorHostPort", "adaptorHostPortCap", "adaptorHostScsiIf", "adaptorHostScsiLunRef", "adaptorHostServiceEthIf", "adaptorHostVnicHwAddrCap", "adaptorHostethHwAddrCap", "adaptorHostfcHwAddrCap", "adaptorHwAddrCap", "adaptorIScsiCap", "adaptorIpV4RssHashProfile", "adaptorIpV6RssHashProfile", "adaptorIscsiAuth", "adaptorIscsiProt", "adaptorIscsiTargetIf", "adaptorLanCap", "adaptorLldpCap", "adaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStatsHist", "adaptorMenloDcePortStats", "adaptorMenloDcePortStatsHist", "adaptorMenloEthErrorStats", "adaptorMenloEthErrorStatsHist", "adaptorMenloEthStats", "adaptorMenloEthStatsHist", "adaptorMenloFcErrorStats", "adaptorMenloFcErrorStatsHist", "adaptorMenloFcStats", "adaptorMenloFcStatsHist", "adaptorMenloHostPortStats", "adaptorMenloHostPortStatsHist", "adaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuStats", "adaptorMenloMcpuStatsHist", "adaptorMenloNetEgStats", "adaptorMenloNetEgStatsHist", "adaptorMenloNetInStats", "adaptorMenloNetInStatsHist", "adaptorMenloQErrorStats", "adaptorMenloQErrorStatsHist", "adaptorMenloQStats", "adaptorMenloQStatsHist", "adaptorMgmtCap", "adaptorMgmtVnicEthConfig", "adaptorNwMgmtCap", "adaptorNwStatsMgmtCap", "adaptorPIoEp", "adaptorProfileItem", "adaptorProtocolProfile", "adaptorQual", "adaptorQueueProfile", "adaptorRnicCapSpec", "adaptorRssHashProfile", "adaptorRssProfile", "adaptorSanCap", "adaptorTcpIpRssHashProfile", "adaptorUnit", "adaptorUnitAssocCtx", "adaptorUnitExtn", "adaptorUplinkHwAddrCap", "adaptorUplinkPortStats", "adaptorUsnicConnDef", "adaptorVlan", "adaptorVmmqConnDef", "adaptorVnicStats", "adaptorVnicStatsHist", "adaptorVsan", "apeAdapter", "apeAdapterVnic", "apeAttribute", "apeBootMethod", "apeControllerChassis", "apeControllerEeprom", "apeControllerManager", "apeDcosAgManager", "apeFru", "apeHostAgent", "apeLANBoot", "apeLocalDiskBoot", "apeManager", "apeMc", "apeMcStats", "apeMcTable", "apeMenlo", "apeMenloVnic", "apeMenloVnicStats", "apeNicAgManager", "apePalo", "apePaloVnic", "apePaloVnicStats", "apeParam", "apeReading", "apeSANBoot", "apeSdr", "apeSwitchFirmwareInv", "apeVirtualMediaBoot", "apeVnicStats", "biosARef", "biosBOT", "biosBootDev", "biosBootDevGrp", "biosFeatureRef", "biosParameterRef", "biosRef", "biosSettingRef", "biosSettings", "biosTokenFeatureGroup", "biosTokenParam", "biosTokenSettings", "biosUnit", "biosVFeat", "biosVIdentityParams", "biosVProfile", "biosVfACPI10Support", "biosVfASPMSupport", "biosVfAllUSBDevices", "biosVfAltitude", "biosVfAssertNMIOnPERR", "biosVfAssertNMIOnSERR", "biosVfBMEDMAMitigation", "biosVfBootOptionRetry", "biosVfCPUHardwarePowerManagement", "biosVfCPUPerformance", "biosVfConsistentDeviceNameControl", "biosVfConsoleRedirection", "biosVfCoreMultiProcessing", "biosVfDDR3VoltageSelection", "biosVfDRAMClockThrottling", "biosVfDirectCacheAccess", "biosVfDramRefreshRate", "biosVfEnergyPerformanceTuning", "biosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedPowerCappingSupport", "biosVfExecuteDisableBit", "biosVfFRB2Timer", "biosVfFrequencyFloorOverride", "biosVfFrontPanelLockout", "biosVfIOEMezz1OptionROM", "biosVfIOENVMe1OptionROM", "biosVfIOENVMe2OptionROM", "biosVfIOESlot1OptionROM", "biosVfIOESlot2OptionROM", "biosVfIntegratedGraphics", "biosVfIntegratedGraphicsApertureSize", "biosVfIntelEntrySASRAIDModule", "biosVfIntelHyperThreadingTech", "biosVfIntelTrustedExecutionTechnology", "biosVfIntelTurboBoostTech", "biosVfIntelVTForDirectedIO", "biosVfIntelVirtualizationTechnology", "biosVfInterleaveConfiguration", "biosVfLocalX2Apic", "biosVfLvDIMMSupport", "biosVfMaxVariableMTRRSetting", "biosVfMaximumMemoryBelow4GB", "biosVfMemoryMappedIOAbove4GB", "biosVfMirroringMode", "biosVfNUMAOptimized", "biosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerTimeout", "biosVfOnboardGraphics", "biosVfOnboardSATAController", "biosVfOnboardStorage", "biosVfOptionROMEnable", "biosVfOptionROMLoad", "biosVfOutOfBandManagement", "biosVfPCHSATAMode", "biosVfPCILOMPortsConfiguration", "biosVfPCIROMCLP", "biosVfPCISlotLinkSpeed", "biosVfPCISlotOptionROMEnable", "biosVfPOSTErrorPause", "biosVfPSTATECoordination", "biosVfPackageCStateLimit", "biosVfPanicAndHighWatermark", "biosVfProcessorC1E", "biosVfProcessorC3Report", "biosVfProcessorC6Report", "biosVfProcessorC7Report", "biosVfProcessorCMCI", "biosVfProcessorCState", "biosVfProcessorEnergyConfiguration", "biosVfProcessorPrefetchConfig", "biosVfQPILinkFrequencySelect", "biosVfQPISnoopMode", "biosVfQuietBoot", "biosVfRedirectionAfterBIOSPOST", "biosVfResumeOnACPowerLoss", "biosVfSBMezz1OptionROM", "biosVfSBNVMe1OptionROM", "biosVfSIOC1OptionROM", "biosVfSIOC2OptionROM", "biosVfScrubPolicies", "biosVfSelectMemoryRASConfiguration", "biosVfSerialPortAEnable", "biosVfSparingMode", "biosVfSriovConfig", "biosVfTPMPendingOperation", "biosVfTPMSupport", "biosVfTrustedPlatformModule", "biosVfUCSMBootModeControl", "biosVfUCSMBootOrderRuleControl", "biosVfUEFIOSUseLegacyVideo", "biosVfUSBBootConfig", "biosVfUSBConfiguration", "biosVfUSBFrontPanelAccessLock", "biosVfUSBPortConfiguration", "biosVfUSBSystemIdlePowerOptimizingSetting", "biosVfVGAPriority", "biosVfWorkloadConfiguration", "bmcSELCounter", "callhomeAnonymousReporting", "callhomeDest", "callhomeEp", "callhomeEpFsm", "callhomeEpFsmStage", "callhomeEpFsmTask", "callhomeItem", "callhomePeriodicSystemInventory", "callhomePolicy", "callhomeProfile", "callhomeSmtp", "callhomeSource", "callhomeTestAlert", "capabilityAEndPointConfig", "capabilityASolutionStack", "capabilityCatalogue", "capabilityCatalogueFsm", "capabilityCatalogueFsmStage", "capabilityCatalogueFsmTask", "capabilityDef", "capabilityEp", "capabilityFeatureLimits", "capabilityItem", "capabilityMgmtExtension", "capabilityMgmtExtensionFsm", "capabilityMgmtExtensionFsmStage", "capabilityMgmtExtensionFsmTask", "capabilityNetworkLimits", "capabilityProvider", "capabilityStorageLimits", "capabilitySystemLimits", "capabilityUpdate", "capabilityUpdater", "capabilityUpdaterFsm", "capabilityUpdaterFsmStage", "capabilityUpdaterFsmTask", "changeChangedObjectRef", "cimcvmediaActualMountEntry", "cimcvmediaActualMountList", "cimcvmediaConfigMountEntry", "cimcvmediaExtMgmtRuleEntry", "cimcvmediaItem", "cimcvmediaMountConfig", "cimcvmediaMountConfigDef", "cimcvmediaMountConfigPolicy", "cimcvmediaMountInfo", "clitestTypeTest", "clitestTypeTest2", "clitestTypeTestChild", "clitestTypeTestParent", "cloudDeviceConnectorEp", "cloudMgmtSvc", "commCimcWebService", "commCimxml", "commClient", "commClientItem", "commDateTime", "commDefinition", "commDns", "commDnsProvider", "commEvtChannel", "commHttp", "commHttps", "commItem", "commLocale", "commNtpProvider", "commShell", "commShellSvcLimits", "commSmashCLP", "commSnmp", "commSnmpTrap", "commSnmpUser", "commSsh", "commSvc", "commSvcChannel", "commSvcEp", "commSvcEpFsm", "commSvcEpFsmStage", "commSvcEpFsmTask", "commSvcLimits", "commSvcPolicy", "commSyslog", "commSyslogClient", "commSyslogConsole", "commSyslogFile", "commSyslogMonitor", "commSyslogSource", "commTelnet", "commWeb", "commWebChannel", "commWebSvcLimits", "commWsman", "commXmlClConnPolicy", "computeABoard", "computeAChassisDiscPolicy", "computeAdminAck", "computeAutoconfigPolicy", "computeBehCap", "computeBlade", "computeBladeDiscPolicy", "computeBladeEp", "computeBladeFsm", "computeBladeFsmStage", "computeBladeFsmTask", "computeBladeInheritPolicy", "computeBladePosQual", "computeBoard", "computeBoardConnector", "computeBoardController", "computeCartridge", "computeChassisConnPolicy", "computeChassisDiscPolicy", "computeChassisQual", "computeComputeDiscPolicy", "computeConfigPolicy", "computeConstraintDef", "computeContainer", "computeDefaults", "computeDiscPolicy", "computeExtBoard", "computeFactoryResetOperation", "computeFanPolicy", "computeFwSyncAck", "computeGraphicsCardPolicy", "computeHealthLedSensorAlarm", "computeHostUtilityOs", "computeHwChangeDiscPolicy", "computeIOHub", "computeIOHubEnvStats", "computeIOHubEnvStatsHist", "computeInitConfigPolicy", "computeInstanceIdQual", "computeItem", "computeKvmMgmtPolicy", "computeLogical", "computeMbPowerStats", "computeMbPowerStatsHist", "computeMbTempStats", "computeMbTempStatsHist", "computeMemoryConfigPolicy", "computeMemoryConfiguration", "computeMemoryUnitConstraintDef", "computePCIeFatalCompletionStats", "computePCIeFatalProtocolStats", "computePCIeFatalReceiveStats", "computePCIeFatalStats", "computePartition", "computePciCap", "computePciSlotScanDef", "computePersonality", "computePhysical", "computePhysicalAssocCtx", "computePhysicalExtension", "computePhysicalFsm", "computePhysicalFsmStage", "computePhysicalFsmTask", "computePhysicalQual", "computePlatform", "computePnuOSImage", "computePool", "computePoolPolicyRef", "computePoolable", "computePooled", "computePooledEnclosureComputeSlot", "computePooledPhysical", "computePooledRackUnit", "computePooledSlot", "computePoolingPolicy", "computePortDiscPolicy", "computePowerSavePolicy", "computePowerSyncDef", "computePowerSyncPolicy", "computePsuControl", "computePsuDef", "computePsuPolicy", "computeQual", "computeQualBase", "computeQualItem", "computeQualifiedPolicy", "computeRackConnLinkPolicy", "computeRackPosQual", "computeRackQual", "computeRackUnit", "computeRackUnitFsm", "computeRackUnitFsmStage", "computeRackUnitFsmTask", "computeRackUnitMbTempStats", "computeRackUnitMbTempStatsHist", "computeRebootLog", "computeRtcBattery", "computeScrubPolicy", "computeServer", "computeServerDiscPolicy", "computeServerDiscPolicyFsm", "computeServerDiscPolicyFsmStage", "computeServerDiscPolicyFsmTask", "computeServerMgmtPolicy", "computeServerTypeCap", "computeServerUnit", "computeServerUnitFsm", "computeServerUnitFsmStage", "computeServerUnitFsmTask", "computeSlotEntity", "computeSlotQual", "computeVirtual", "computeVirtualContainer", "conditionImmutable", "conditionInfo", "conditionLog", "conditionLoggable", "conditionMultiInstanceImmutable", "conditionMutable", "conditionPolicy", "conditionReportable", "configImpact", "configImpactResponse", "configManagedEpImpactResponse", "configSorter", "controllerHaController", "controllerMgmtDbCheckPol", "controllerOperationalVersionHolder", "controllerPreferedVersionHolder", "coprocessorCard", "cpmaintAck", "cpmaintMaintPolicy", "dcxFcoeVifEp", "dcxNs", "dcxUniverse", "dcxVIf", "dcxVc", "dcxVifEp", "dhcpAcquired", "dhcpInst", "dhcpLease", "diagCtrl", "diagLogEp", "diagMemoryTest", "diagRslt", "diagRunPolicy", "diagSrvCapProvider", "diagSrvCtrl", "diagTest", "domainChassisFeature", "domainChassisFeatureCont", "domainChassisParam", "domainEnvironmentFeature", "domainEnvironmentFeatureCont", "domainEnvironmentParam", "domainFeature", "domainFeatureCont", "domainNetworkFeature", "domainNetworkFeatureCont", "domainNetworkParam", "domainParameter", "domainServerFeature", "domainServerFeatureCont", "domainServerParam", "domainStorageFeature", "domainStorageFeatureCont", "domainStorageParam", "dpsecMac", "dupeScope", "dupeScopeResult", "epqosDefinition", "epqosDefinitionDelTask", "epqosDefinitionDelTaskFsm", "epqosDefinitionDelTaskFsmStage", "epqosDefinitionDelTaskFsmTask", "epqosDefinitionFsm", "epqosDefinitionFsmStage", "epqosDefinitionFsmTask", "epqosEgress", "epqosItem", "equipmentAdaptorConnDef", "equipmentAdaptorDef", "equipmentAdvancedBootOrder", "equipmentAssocCtx", "equipmentAutoConfigMode", "equipmentAutoconfigPolicy", "equipmentBaseBoardCapProvider", "equipmentBeaconCapProvider", "equipmentBeaconLed", "equipmentBeaconLedFsm", "equipmentBeaconLedFsmStage", "equipmentBeaconLedFsmTask", "equipmentBehCap", "equipmentBinding", "equipmentBiosDef", "equipmentBiosTokenOverride", "equipmentBladeAGLibrary", "equipmentBladeAggregationCapRef", "equipmentBladeBiosCapProvider", "equipmentBladeCapProvider", "equipmentBladeCapProviderTypeDef", "equipmentBladeConnDef", "equipmentBladeIOMConnDef", "equipmentBladeSwitchConnDef", "equipmentBoardControllerDef", "equipmentBootDeviceConstraints", "equipmentBreakoutCap", "equipmentCapModSpec", "equipmentCard", "equipmentCartridgeCapProvider", "equipmentCatalogCapProvider", "equipmentChassis", "equipmentChassisAssocCtx", "equipmentChassisCapProvider", "equipmentChassisFsm", "equipmentChassisFsmStage", "equipmentChassisFsmTask", "equipmentChassisInheritPolicy", "equipmentChassisIssues", "equipmentChassisPosQual", "equipmentChassisProfile", "equipmentChassisProfileAssocCtx", "equipmentChassisProfileBinding", "equipmentChassisProfileFsm", "equipmentChassisProfileFsmStage", "equipmentChassisProfileFsmTask", "equipmentChassisQual", "equipmentChassisStats", "equipmentChassisStatsHist", "equipmentCimcVmedia", "equipmentCiscoOsOpenGate", "equipmentComputeConn", "equipmentComputeConnPolicy", "equipmentComputePhysicalCapProvider", "equipmentConfigPolicy", "equipmentCoprocessorUnitCapProvider", "equipmentDbgPluginCapProvider", "equipmentDiagFeatureSupport", "equipmentDimmEntry", "equipmentDimmMapping", "equipmentDiscoveryCap", "equipmentDowngradeConstraint", "equipmentDriveSecCap", "equipmentEmbeddedControllerConfig", "equipmentEmbeddedStorageDef", "equipmentEnvSensor", "equipmentFan", "equipmentFanAggressiveCoolingCap", "equipmentFanModule", "equipmentFanModuleCapProvider", "equipmentFanModuleDef", "equipmentFanModuleStats", "equipmentFanModuleStatsHist", "equipmentFanPresenceDef", "equipmentFanStats", "equipmentFanStatsHist", "equipmentFex", "equipmentFexCapProvider", "equipmentFexEnvStats", "equipmentFexEnvStatsHist", "equipmentFexFsm", "equipmentFexFsmStage", "equipmentFexFsmTask", "equipmentFexPowerSummary", "equipmentFexPowerSummaryHist", "equipmentFexPsuInputStats", "equipmentFexPsuInputStatsHist", "equipmentFexSystemStats", "equipmentFexSystemStatsHist", "equipmentFirmwareConstraint", "equipmentFlashLife", "equipmentFlexFlashNonRemovable", "equipmentFruCapProvider", "equipmentFruVariant", "equipmentGemCapProvider", "equipmentGemPortCap", "equipmentGraphicsCardCapProvider", "equipmentGraphicsCardCapRef", "equipmentHDDFaultMonDef", "equipmentHealthLed", "equipmentHolder", "equipmentHolderCapProvider", "equipmentHostIfCapProvider", "equipmentHostMgmtControllerCap", "equipmentHwCapDerivativeProvider", "equipmentHwCapProvider", "equipmentHwRevisionModifier", "equipmentHxCap", "equipmentIOCard", "equipmentIOCardBase", "equipmentIOCardBaseFsm", "equipmentIOCardBaseFsmStage", "equipmentIOCardBaseFsmTask", "equipmentIOCardCapProvider", "equipmentIOCardFsm", "equipmentIOCardFsmStage", "equipmentIOCardFsmTask", "equipmentIOCardStats", "equipmentIOCardStatsHist", "equipmentIOCardTypeDef", "equipmentIOExpander", "equipmentIOExpanderCapProvider", "equipmentInbandMgmtCap", "equipmentIndicatorLed", "equipmentInitConfigPolicy", "equipmentIntegratedComponentCapProvider", "equipmentInventoryStatus", "equipmentItem", "equipmentKvmMgmtCap", "equipmentLed", "equipmentLocalDiskCapProvider", "equipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapRef", "equipmentLocalDiskControllerDef", "equipmentLocalDiskControllerTypeDef", "equipmentLocalDiskDef", "equipmentLocatorLed", "equipmentLocatorLedFsm", "equipmentLocatorLedFsmStage", "equipmentLocatorLedFsmTask", "equipmentManufacturingDef", "equipmentMemoryUnitCapProvider", "equipmentMemoryUnitDiscoveryModifierDef", "equipmentMgmtCapProvider", "equipmentMgmtControllerCap", "equipmentMgmtExtCapProvider", "equipmentMiniStorageCapProvider", "equipmentNetworkElementFanStats", "equipmentNetworkElementFanStatsHist", "equipmentNonCopperPassiveCap", "equipmentNvmeDef", "equipmentNvmeSwitchConfig", "equipmentOnboardDeviceDef", "equipmentPOST", "equipmentPOSTCode", "equipmentPOSTCodeContainer", "equipmentPOSTCodeData", "equipmentPOSTCodeReporter", "equipmentPOSTCodeTemplate", "equipmentPciDef", "equipmentPciSlotIdEntry", "equipmentPciSlotIdMapping", "equipmentPciSlotSubOEMIdEntry", "equipmentPciSwitchCapProvider", "equipmentPcieSlotOrientation", "equipmentPersistentMemoryUnitCapProvider", "equipmentPersonality", "equipmentPfcMmuCap", "equipmentPhysDevicesPerBoard", "equipmentPhysicalDef", "equipmentPhysicalQual", "equipmentPicture", "equipmentPnuosBootMode", "equipmentPool", "equipmentPoolPolicyRef", "equipmentPoolable", "equipmentPooled", "equipmentPooledChassis", "equipmentPooledPhysical", "equipmentPoolingPolicy", "equipmentPortCap", "equipmentPortGroupAggregationDef", "equipmentPortGroupDef", "equipmentPortGroupSwComplexDef", "equipmentPortSwComplexRef", "equipmentPowerCapDef", "equipmentProcessorUnitCapProvider", "equipmentProcessorUnitDef", "equipmentPsu", "equipmentPsuCapProvider", "equipmentPsuDef", "equipmentPsuFsm", "equipmentPsuFsmStage", "equipmentPsuFsmTask", "equipmentPsuInputStats", "equipmentPsuInputStatsHist", "equipmentPsuOutputStats", "equipmentPsuOutputStatsHist", "equipmentPsuStats", "equipmentPsuStatsHist", "equipmentQual", "equipmentQualBase", "equipmentQualItem", "equipmentQualifiedPolicy", "equipmentRackEnclosure", "equipmentRackEnclosureCapProvider", "equipmentRackFanModuleDef", "equipmentRackUnitCapProvider", "equipmentRackUnitFanStats", "equipmentRackUnitFanStatsHist", "equipmentRackUnitPsuStats", "equipmentRackUnitPsuStatsHist", "equipmentRaidDef", "equipmentRequirement", "equipmentSecureBoot", "equipmentSecureController", "equipmentSecurityUnitCapProvider", "equipmentServerCorrectUuidBehavior", "equipmentServerFeatureCap", "equipmentServerPortCapProvider", "equipmentServerUnitCapProvider", "equipmentServiceDef", "equipmentSharedIOModule", "equipmentSiocCapProvider", "equipmentSiocTempStats", "equipmentSiocTempStatsHist", "equipmentSlot", "equipmentSlotArray", "equipmentSlotArrayRef", "equipmentSlotEnclosure", "equipmentSlotEp", "equipmentSpdmCertificateCap", "equipmentSpeedCompatibility", "equipmentStateful", "equipmentStatefulBladeComp", "equipmentStatefulChComp", "equipmentStorageControllerConfig", "equipmentStorageControllerSlotDef", "equipmentStorageEncCapProvider", "equipmentStorageLimitCap", "equipmentStorageNvmeSwitchCapProvider", "equipmentStorageNvmeSwitchDef", "equipmentStorageSasExpanderCapProvider", "equipmentStorageSasExpanderCapRef", "equipmentStorageSasExpanderDef", "equipmentSwitchCap", "equipmentSwitchCapProvider", "equipmentSwitchCard", "equipmentSwitchIOCard", "equipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardFsm", "equipmentSwitchIOCardFsmStage", "equipmentSwitchIOCardFsmTask", "equipmentSwitchTypeDef", "equipmentSystemIOController", "equipmentSystemIOControllerFsm", "equipmentSystemIOControllerFsmStage", "equipmentSystemIOControllerFsmTask", "equipmentTier", "equipmentTpm", "equipmentTpmCapProvider", "equipmentUnifiedPortCapProvider", "equipmentUuidFeatureCap", "equipmentVersionConstraint", "equipmentXcvr", "etherCIoEp", "etherConfig", "etherErrStats", "etherErrStatsHist", "etherExternalEp", "etherExternalPc", "etherFcoeInterfaceStats", "etherFcoeInterfaceStatsHist", "etherIfConfig", "etherIntFIoEp", "etherInternalPc", "etherLossStats", "etherLossStatsHist", "etherNiErrStats", "etherNiErrStatsHist", "etherNicIfConfig", "etherPIo", "etherPIoEndPoint", "etherPIoEp", "etherPIoFsm", "etherPIoFsmStage", "etherPauseStats", "etherPauseStatsHist", "etherPc", "etherPortChanIdElem", "etherPortChanIdUniverse", "etherRxStats", "etherRxStatsHist", "etherServerIntFIo", "etherServerIntFIoFsm", "etherServerIntFIoFsmStage", "etherServerIntFIoFsmTask", "etherServerIntFIoPc", "etherServerIntFIoPcEp", "etherSwIfConfig", "etherSwitchIntFIo", "etherSwitchIntFIoPc", "etherSwitchIntFIoPcEp", "etherTxStats", "etherTxStatsHist", "eventEpCtrl", "eventHolder", "eventInst", "eventLog", "eventPolicy", "eventRecord", "extmgmtArpTargets", "extmgmtGatewayPing", "extmgmtIf", "extmgmtIfMonPolicy", "extmgmtMiiStatus", "extmgmtNdiscTargets", "extpolClient", "extpolClientCont", "extpolConnector", "extpolConnectorContainer", "extpolController", "extpolControllerCont", "extpolEp", "extpolEpFsm", "extpolEpFsmStage", "extpolEpFsmTask", "extpolProvider", "extpolProviderCont", "extpolProviderFsm", "extpolProviderFsmStage", "extpolProviderFsmTask", "extpolRegistry", "extpolRegistryFsm", "extpolRegistryFsmStage", "extpolRegistryFsmTask", "extpolSvc", "extpolSystemContext", "extvmmEp", "extvmmEpFsm", "extvmmEpFsmStage", "extvmmEpFsmTask", "extvmmFNDReference", "extvmmFabricNetwork", "extvmmFabricNetworkDefinition", "extvmmKeyInst", "extvmmKeyRing", "extvmmKeyStore", "extvmmKeyStoreFsm", "extvmmKeyStoreFsmStage", "extvmmKeyStoreFsmTask", "extvmmMasterExtKey", "extvmmMasterExtKeyFsm", "extvmmMasterExtKeyFsmStage", "extvmmMasterExtKeyFsmTask", "extvmmNetworkSets", "extvmmNetworkSetsFsm", "extvmmNetworkSetsFsmStage", "extvmmNetworkSetsFsmTask", "extvmmProvider", "extvmmProviderFsm", "extvmmProviderFsmStage", "extvmmProviderFsmTask", "extvmmSwitchDelTask", "extvmmSwitchDelTaskFsm", "extvmmSwitchDelTaskFsmStage", "extvmmSwitchDelTaskFsmTask", "extvmmSwitchSet", "extvmmUpLinkPP", "extvmmVMNDRef", "extvmmVMNetwork", "extvmmVMNetworkDefinition", "extvmmVMNetworkSets", "fabricADceSwSrvEp", "fabricAEthEstcEp", "fabricAEthLanEp", "fabricAFcEstcEp", "fabricAFcSanEp", "fabricAFcoeEstcEp", "fabricAFcoeSanEp", "fabricANetGroup", "fabricANetGroupRef", "fabricASanGroup", "fabricAVlan", "fabricAVsan", "fabricBHVlan", "fabricBaseNetGroup", "fabricBreakout", "fabricCIoEp", "fabricCabling", "fabricCablingSw", "fabricCartridgePhEp", "fabricCartridgeSlotEp", "fabricCartridgeSlotEpFsm", "fabricCartridgeSlotEpFsmStage", "fabricCartridgeSlotEpFsmTask", "fabricCdpLinkPolicy", "fabricChangedObjectRef", "fabricChassisEp", "fabricCloud", "fabricComputeEp", "fabricComputeMSlotEp", "fabricComputeMSlotEpFsm", "fabricComputeMSlotEpFsmStage", "fabricComputeMSlotEpFsmTask", "fabricComputePhEp", "fabricComputeSlotEp", "fabricComputeSlotEpFsm", "fabricComputeSlotEpFsmStage", "fabricComputeSlotEpFsmTask", "fabricDceSrv", "fabricDceSwSrv", "fabricDceSwSrvEp", "fabricDceSwSrvPc", "fabricDceSwSrvPcEp", "fabricDomain", "fabricEp", "fabricEpMgr", "fabricEpMgrFsm", "fabricEpMgrFsmStage", "fabricEpMgrFsmTask", "fabricEpVlan", "fabricEpVsan", "fabricEquipmentEp", "fabricEstcEp", "fabricEstcPc", "fabricEthCdpPolicy", "fabricEthEstc", "fabricEthEstcCloud", "fabricEthEstcEp", "fabricEthEstcPc", "fabricEthEstcPcEp", "fabricEthFlowMonLan", "fabricEthFlowMonSrcRef", "fabricEthLan", "fabricEthLanEp", "fabricEthLanFlowMon", "fabricEthLanFlowMonCollector", "fabricEthLanFlowMonExporter", "fabricEthLanFlowMonSrcEp", "fabricEthLanFlowMonitor", "fabricEthLanFlowMonitoring", "fabricEthLanPc", "fabricEthLanPcEp", "fabricEthLinkPolicy", "fabricEthLinkProfile", "fabricEthMon", "fabricEthMonDestEp", "fabricEthMonFiltEp", "fabricEthMonFiltRef", "fabricEthMonLan", "fabricEthMonSrcEp", "fabricEthMonSrcRef", "fabricEthTargetEp", "fabricEthUdldPolicy", "fabricEthVlanPc", "fabricEthVlanPortEp", "fabricExternal", "fabricExternalEp", "fabricExternalEstc", "fabricExternalPc", "fabricFcEndpoint", "fabricFcEstc", "fabricFcEstcCloud", "fabricFcEstcEp", "fabricFcMon", "fabricFcMonDestEp", "fabricFcMonFiltEp", "fabricFcMonFiltRef", "fabricFcMonSan", "fabricFcMonSrcEp", "fabricFcMonSrcRef", "fabricFcSan", "fabricFcSanEp", "fabricFcSanPc", "fabricFcSanPcEp", "fabricFcUserZone", "fabricFcVsanPc", "fabricFcVsanPortEp", "fabricFcZoneProfile", "fabricFcoeEstcEp", "fabricFcoeSanEp", "fabricFcoeSanPc", "fabricFcoeSanPcEp", "fabricFcoeVsanPc", "fabricFcoeVsanPortEp", "fabricFlowMon", "fabricFlowMonCollector", "fabricFlowMonDefinition", "fabricFlowMonExporter", "fabricFlowMonExporterProfile", "fabricFlowMonItem", "fabricFlowMonSrcEp", "fabricFlowMonSrcRef", "fabricFlowMonitor", "fabricFlowMonitoringCategory", "fabricIf", "fabricInternal", "fabricInternalDceSrv", "fabricInternalEp", "fabricInternalPc", "fabricLacpPolicy", "fabricLan", "fabricLanAccessMgr", "fabricLanCloud", "fabricLanCloudFsm", "fabricLanCloudFsmStage", "fabricLanCloudFsmTask", "fabricLanCloudPolicy", "fabricLanEp", "fabricLanFlowMon", "fabricLanFlowMonCollector", "fabricLanFlowMonExporter", "fabricLanFlowMonSrcEp", "fabricLanFlowMonitor", "fabricLanMonCloud", "fabricLanPc", "fabricLanPinGroup", "fabricLanPinTarget", "fabricLastAckedSlot", "fabricLinkPolicy", "fabricLocale", "fabricMon", "fabricMonDestEp", "fabricMonFiltRef", "fabricMonSrcEp", "fabricMonSrcFiltEp", "fabricMonSrcRef", "fabricMulticastPolicy", "fabricNetGroup", "fabricNetGroupRef", "fabricNetflowCollector", "fabricNetflowIPv4Addr", "fabricNetflowMonExporter", "fabricNetflowMonExporterRef", "fabricNetflowMonSession", "fabricNetflowMonSrcEp", "fabricNetflowMonSrcRef", "fabricNetflowMonitor", "fabricNetflowMonitorRef", "fabricNetflowTimeoutPolicy", "fabricOrgVlanPolicy", "fabricPIoEp", "fabricPath", "fabricPathConn", "fabricPathEp", "fabricPinGroup", "fabricPinTarget", "fabricPoolableVlan", "fabricPooledVlan", "fabricReservedVlan", "fabricReservedVlanFsm", "fabricReservedVlanFsmStage", "fabricReservedVlanFsmTask", "fabricSan", "fabricSanCloud", "fabricSanCloudFsm", "fabricSanCloudFsmStage", "fabricSanCloudFsmTask", "fabricSanEp", "fabricSanGroup", "fabricSanGroupRef", "fabricSanMonCloud", "fabricSanPc", "fabricSanPinGroup", "fabricSanPinTarget", "fabricSubGroup", "fabricSwChEp", "fabricSwChPhEp", "fabricSwSrvEp", "fabricSwSrvPc", "fabricSwSubGroup", "fabricTargetEp", "fabricUdldLinkPolicy", "fabricUdldPolicy", "fabricVCon", "fabricVConProfile", "fabricVlan", "fabricVlanEp", "fabricVlanGroupPermit", "fabricVlanGroupReq", "fabricVlanPermit", "fabricVlanReq", "fabricVnetEp", "fabricVnetEpSyncEp", "fabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmTask", "fabricVnetGroupPermit", "fabricVnetGroupReq", "fabricVnetPermit", "fabricVnetReq", "fabricVsan", "fabricVsanEp", "fabricVsanMembership", "fabricZoneIdUniverse", "faultAffectedClass", "faultBaseHolder", "faultBasePolicy", "faultHolder", "faultInst", "faultLocalTypedHolder", "faultPolicy", "faultSuppressPolicy", "faultSuppressPolicyItem", "faultSuppressTask", "fcConfig", "fcErrStats", "fcErrStatsHist", "fcIfConfig", "fcNicIfConfig", "fcPIo", "fcPIoFsm", "fcPIoFsmStage", "fcStats", "fcStatsHist", "fcSwIfConfig", "fcpoolAddr", "fcpoolBlock", "fcpoolBootTarget", "fcpoolFormat", "fcpoolInitiator", "fcpoolInitiatorEp", "fcpoolInitiators", "fcpoolOui", "fcpoolOuis", "fcpoolOuisFsm", "fcpoolOuisFsmStage", "fcpoolOuisFsmTask", "fcpoolPoolable", "fcpoolUniverse", "featureBaseRef", "featureContextEp", "featureDefinition", "featureDefinitionInstance", "featureDefinitionRef", "featureFruCapProviderInstance", "featureFruCapProviderRef", "featureProvider", "featureProviderInstance", "firmwareABundleTypeCapProvider", "firmwareAChassisConstraint", "firmwareAComponentSpec", "firmwareAConstraint", "firmwareAExcludeComponent", "firmwareAck", "firmwareActivity", "firmwareActivityTrigger", "firmwareAutoSyncPolicy", "firmwareBackupVersionHolder", "firmwareBlade", "firmwareBootDefinition", "firmwareBootUnit", "firmwareBundleInfo", "firmwareBundleInfoDigest", "firmwareBundleType", "firmwareBundleTypeCapProvider", "firmwareCapProvider", "firmwareCatalogPack", "firmwareCatalogue", "firmwareChassisComponentSpec", "firmwareChassisPack", "firmwareChassisPackModImpact", "firmwareCompItem", "firmwareCompSource", "firmwareCompTarget", "firmwareComponentSpec", "firmwareComputeHostPack", "firmwareComputeMgmtPack", "firmwareComputePack", "firmwareConnectionManagementChassisConstraint", "firmwareConstraints", "firmwareDependency", "firmwareDistImage", "firmwareDistributable", "firmwareDistributableFsm", "firmwareDistributableFsmStage", "firmwareDistributableFsmTask", "firmwareDownloader", "firmwareDownloaderFsm", "firmwareDownloaderFsmStage", "firmwareDownloaderFsmTask", "firmwareDriveSecurityConstraint", "firmwareDualVicChassisConstraint", "firmwareDualVicServerConstraint", "firmwareExcludeChassisComponent", "firmwareExcludeServerComponent", "firmwareFileUnit", "firmwareHost", "firmwareHostPackModImpact", "firmwareImage", "firmwareImageFsm", "firmwareImageFsmStage", "firmwareImageFsmTask", "firmwareImageLock", "firmwareInfra", "firmwareInfraPack", "firmwareInstallImpact", "firmwareInstallable", "firmwareModule", "firmwarePCHStorageConfigConstraint", "firmwarePack", "firmwarePackItem", "firmwarePlatformBundleTypeCapProvider", "firmwareProcessorTypeConstraint", "firmwareRack", "firmwareRackPowerCapConstraint", "firmwareRunning", "firmwareSecondControllerChassisConstraint", "firmwareSecondControllerServerConstraint", "firmwareSecureFPGA", "firmwareServerChassisConstraint", "firmwareServerTypeConstraint", "firmwareServicePack", "firmwareSinglePathChassisConstraint", "firmwareSpec", "firmwareStatus", "firmwareSystem", "firmwareSystemCompCheckResult", "firmwareSystemFsm", "firmwareSystemFsmStage", "firmwareSystemFsmTask", "firmwareTPMConstraint", "firmwareType", "firmwareUcscInfo", "firmwareUnit", "firmwareUpdatable", "firmwareUpgradeConstraint", "firmwareUpgradeDetail", "firmwareUpgradeInfo", "firmwareVicSlotConstraint", "firmwareVnicCdnConstraint", "firmwareWaterbaySiocServerConstraint", "flowctrlDefinition", "flowctrlItem", "fsmFsm", "fsmStage", "fsmStatus", "fsmTask", "gmetaClass", "gmetaEp", "gmetaHolder", "gmetaHolderFsm", "gmetaHolderFsmStage", "gmetaHolderFsmTask", "gmetaPolicyMapElement", "gmetaPolicyMapHolder", "gmetaProp", "graphicsCard", "graphicsController", "hostimgPolicy", "hostimgTarget", "identIdentCtx", "identIdentRequest", "identIdentRequestFsm", "identIdentRequestFsmStage", "identIdentRequestFsmTask", "identMetaSystem", "identMetaSystemFsm", "identMetaSystemFsmStage", "identMetaSystemFsmTask", "identMetaVerse", "identRequestEp", "identSysInfo", "imgprovPolicy", "imgprovTarget", "imgsecKey", "imgsecPolicy", "initiatorEp", "initiatorFcInitiatorEp", "initiatorGroupEp", "initiatorIScsiInitiatorEp", "initiatorInitiatorEp", "initiatorLunEp", "initiatorMemberEp", "initiatorRequestorEp", "initiatorRequestorGrpEp", "initiatorStoreEp", "initiatorUnitEp", "ipDnsSuffix", "ipIPv4Dns", "ipIPv4WinsServer", "ipIpV4Addr", "ipIpV4StaticAddr", "ipIpV4StaticTargetAddr", "ipServiceIf", "ippoolAddr", "ippoolBlock", "ippoolIpV6Addr", "ippoolIpV6Block", "ippoolIpV6Pooled", "ippoolPool", "ippoolPoolable", "ippoolPooled", "ippoolUniverse", "iqnpoolAbsBlock", "iqnpoolAddr", "iqnpoolBlock", "iqnpoolFormat", "iqnpoolPool", "iqnpoolPoolable", "iqnpoolPooled", "iqnpoolTransportBlock", "iqnpoolUniverse", "iscsiAuthProfile", "licenseCapProvider", "licenseContents", "licenseDownloader", "licenseDownloaderFsm", "licenseDownloaderFsmStage", "licenseDownloaderFsmTask", "licenseEp", "licenseFeature", "licenseFeatureCapProvider", "licenseFeatureLine", "licenseFile", "licenseFileFsm", "licenseFileFsmStage", "licenseFileFsmTask", "licenseInstance", "licenseInstanceFsm", "licenseInstanceFsmStage", "licenseInstanceFsmTask", "licenseProp", "licenseServerHostId", "licenseSource", "licenseSourceFile", "licenseTarget", "lldpAcquired", "lsAgentPolicy", "lsBinding", "lsComputeBinding", "lsFcLocale", "lsFcZone", "lsFcZoneGroup", "lsFcZoneMember", "lsIdentityInfo", "lsIssues", "lsPower", "lsRequirement", "lsServer", "lsServerAssocCtx", "lsServerExtension", "lsServerFsm", "lsServerFsmStage", "lsServerFsmTask", "lsTier", "lsUuidHistory", "lsVConAssign", "lsVersionBeh", "lsZoneInitiatorMember", "lsZoneTargetMember", "lsbootADef", "lsbootBootSecurity", "lsbootCategory", "lsbootDef", "lsbootDefaultLocalImage", "lsbootEFIShell", "lsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalLunImage", "lsbootIScsi", "lsbootIScsiImagePath", "lsbootImage", "lsbootImagePath", "lsbootItem", "lsbootLan", "lsbootLanImagePath", "lsbootLocalDiskImage", "lsbootLocalDiskImagePath", "lsbootLocalHddImage", "lsbootLocalImage", "lsbootLocalLunImagePath", "lsbootLocalMediaItem", "lsbootLocalStorage", "lsbootNvme", "lsbootNvmeDevice", "lsbootNvmeDiskSsd", "lsbootNvmePciSsd", "lsbootPolicy", "lsbootRemoteImage", "lsbootSan", "lsbootSanCatSanImage", "lsbootSanCatSanImagePath", "lsbootSanImage", "lsbootSanImagePath", "lsbootStorage", "lsbootUEFIBootParam", "lsbootUsbExternalImage", "lsbootUsbFlashStorageImage", "lsbootUsbInternalImage", "lsbootVirtualMedia", "lsmaintAck", "lsmaintMaintPolicy", "lstorageASlot", "lstorageControllerDef", "lstorageControllerModeConfig", "lstorageControllerQualifier", "lstorageControllerRef", "lstorageDasScsiLun", "lstorageDiskGroupConfig", "lstorageDiskGroupConfigDef", "lstorageDiskGroupConfigPolicy", "lstorageDiskGroupQualifier", "lstorageDiskSlot", "lstorageDiskZoningConfig", "lstorageDiskZoningConfigDef", "lstorageDiskZoningPolicy", "lstorageDriveSecurity", "lstorageItem", "lstorageLocal", "lstorageLocalConfig", "lstorageLocalDef", "lstorageLocalDiskConfigRef", "lstorageLocalDiskRef", "lstorageLogin", "lstorageLunSetConfig", "lstorageLunSetDiskSlot", "lstorageProfile", "lstorageProfileBase", "lstorageProfileBinding", "lstorageProfileBindingBase", "lstorageProfileDef", "lstorageRemote", "lstorageRemoteConfig", "lstorageRemoteDef", "lstorageSasExpanderConfigPolicy", "lstorageScsiLun", "lstorageSecurity", "lstorageVirtualDriveDef", "macpoolAddr", "macpoolBlock", "macpoolFormat", "macpoolPool", "macpoolPoolable", "macpoolPooled", "macpoolUniverse", "memoryAUnit", "memoryArray", "memoryArrayEnvStats", "memoryArrayEnvStatsHist", "memoryBufferUnit", "memoryBufferUnitEnvStats", "memoryBufferUnitEnvStatsHist", "memoryErrorStats", "memoryPersistentMemoryANamespace", "memoryPersistentMemoryConfigResult", "memoryPersistentMemoryConfiguration", "memoryPersistentMemoryGoal", "memoryPersistentMemoryLocalSecurity", "memoryPersistentMemoryLogicalNamespace", "memoryPersistentMemoryNamespace", "memoryPersistentMemoryNamespaceConfigResult", "memoryPersistentMemoryPolicy", "memoryPersistentMemoryRegion", "memoryPersistentMemorySecurity", "memoryPersistentMemoryUnit", "memoryQual", "memoryRuntime", "memoryRuntimeHist", "memoryUnit", "memoryUnitEnvStats", "memoryUnitEnvStatsHist", "mgmtASecureBoot", "mgmtAbstractIf", "mgmtAccessPolicy", "mgmtAccessPolicyItem", "mgmtAccessPort", "mgmtBackup", "mgmtBackupExportExtPolicy", "mgmtBackupFsm", "mgmtBackupFsmStage", "mgmtBackupFsmTask", "mgmtBackupPolicy", "mgmtBackupPolicyConfig", "mgmtBackupPolicyFsm", "mgmtBackupPolicyFsmStage", "mgmtCfgExportPolicy", "mgmtCfgExportPolicyFsm", "mgmtCfgExportPolicyFsmStage", "mgmtCimcInterface", "mgmtCimcSecureBoot", "mgmtCmcSecureBoot", "mgmtConnection", "mgmtController", "mgmtControllerFsm", "mgmtControllerFsmStage", "mgmtControllerFsmTask", "mgmtDbState", "mgmtEntity", "mgmtExportPolicy", "mgmtExportPolicyFsm", "mgmtExportPolicyFsmStage", "mgmtExportPolicyFsmTask", "mgmtHealthAttr", "mgmtHealthStatus", "mgmtIPv6Addr", "mgmtIPv6IfAddr", "mgmtIPv6IfAddrFsm", "mgmtIPv6IfAddrFsmStage", "mgmtIPv6IfAddrFsmTask", "mgmtIPv6IfConfig", "mgmtIf", "mgmtIfFsm", "mgmtIfFsmStage", "mgmtIfFsmTask", "mgmtImporter", "mgmtImporterFsm", "mgmtImporterFsmStage", "mgmtImporterFsmTask", "mgmtInbandProfile", "mgmtIntAuthPolicy", "mgmtInterface", "mgmtKmip", "mgmtKmipCertPolicy", "mgmtKvmCertificate", "mgmtLeaderEntity", "mgmtPmonEntry", "mgmtProfDerivedInterface", "mgmtSecurity", "mgmtSpdmCertificate", "mgmtSpdmCertificateData", "mgmtSpdmCertificateInventory", "mgmtSpdmCertificatePolicy", "mgmtSwPersonalities", "mgmtSwPersonalitiesInventory", "mgmtSwPersonality", "mgmtUsbNicMgmtIf", "mgmtVnet", "moAbstractCfgKv", "moAbstractInvKv", "moAbstractKv", "moInvKv", "moIpAddrKv", "moIpV4AddrKv", "moIpV6AddrKv", "moKv", "moKvCfgHolder", "moKvInvHolder", "moTopProps", "moVnicKv", "morefFruRef", "morefImportRoot", "morefImportRootFsm", "morefImportRootFsmStage", "morefImportRootFsmTask", "morefProp", "morefRef", "namingNamedIdentifiedObject", "namingNamedObject", "networkALanNeighborEntry", "networkANeighborEntry", "networkCIoEp", "networkConn", "networkDomainEp", "networkElement", "networkEp", "networkIfEp", "networkIfStats", "networkLanNeighborEntry", "networkLanNeighbors", "networkLimit", "networkLldpNeighborEntry", "networkLldpNeighbors", "networkOperLevel", "networkPIoEp", "networkPhysEp", "networkSanNeighborEntry", "networkSanNeighbors", "networkVnetEp", "networkruleDefinition", "networkruleItem", "networkruleRequirement", "nfsEp", "nfsMountDef", "nfsMountDefFsm", "nfsMountDefFsmStage", "nfsMountDefFsmTask", "nfsMountInst", "nfsMountInstFsm", "nfsMountInstFsmStage", "nfsMountInstFsmTask", "nwctrlDefinition", "observeFilter", "observeObserved", "observeObservedCont", "observeObservedFsm", "observeObservedFsmStage", "observeObservedFsmTask", "orgOrg", "orgSourceMask", "osARPLinkMonitoringPolicy", "osARPTarget", "osAgent", "osEthBondIntf", "osEthBondMode", "osEthBondModeActiveBackup", "osEthBondModeBalancedALB", "osEthBondModeBalancedRR", "osEthBondModeBalancedTLB", "osEthBondModeBalancedXOR", "osEthBondModeBroadcast", "osEthBondModeLB", "osEthIntf", "osInstance", "osIntf", "osLinkMonitoringPolicy", "osMiiLinkMonitoringPolicy", "osPrimarySlave", "pciCard", "pciEquipSlot", "pciLink", "pciSwitch", "pciUnit", "pfcWatchDog", "pfcWatchDogFsm", "pfcWatchDogFsmStage", "pfcWatchDogFsmTask", "pkiCertReq", "pkiDefinition", "pkiEp", "pkiEpFsm", "pkiEpFsmStage", "pkiEpFsmTask", "pkiItem", "pkiKeyRing", "pkiTP", "policyADestEp", "policyBinding", "policyCentraleSync", "policyChildClass", "policyCommunication", "policyConfigBackup", "policyConfigError", "policyContext", "policyControl", "policyControlEp", "policyControlEpFsm", "policyControlEpFsmStage", "policyControlEpFsmTask", "policyControlled", "policyControlledInstance", "policyControlledType", "policyControlledTypeFsm", "policyControlledTypeFsmStage", "policyControlledTypeFsmTask", "policyDateTime", "policyDefinition", "policyDestClass", "policyDestEp", "policyDigest", "policyDiscovery", "policyDns", "policyElement", "policyEquipment", "policyFault", "policyHolder", "policyIdResolvePolicy", "policyInfraFirmware", "policyItem", "policyLocalMap", "policyMEp", "policyMonitoring", "policyObject", "policyPolicyDestClass", "policyPolicyEp", "policyPolicyRequestor", "policyPolicyScope", "policyPolicyScopeCont", "policyPolicyScopeContFsm", "policyPolicyScopeContFsmStage", "policyPolicyScopeContFsmTask", "policyPolicyScopeContext", "policyPolicyScopeFsm", "policyPolicyScopeFsmStage", "policyPolicyScopeFsmTask", "policyPortConfig", "policyPowerMgmt", "policyPsu", "policyRefReq", "policyRequestor", "policyRequestorFsm", "policyRequestorFsmStage", "policyRequestorFsmTask", "policyScope", "policySecurity", "policySourceApp", "policyStorageAutoConfig", "policySystemEp", "poolElement", "poolPool", "poolPoolMember", "poolPoolable", "poolUniverse", "portDomainEp", "portGroup", "portIntFIo", "portPIo", "portPIoFsm", "portPIoFsmStage", "portPIoFsmTask", "portPhysSwitchIo", "portServerIntFIo", "portSubGroup", "portSwitchIntFIo", "portTrustMode", "powerABudget", "powerAGroup", "powerBudget", "powerChassisMember", "powerEp", "powerFIMember", "powerFexMember", "powerGroup", "powerGroupAdditionPolicy", "powerGroupMember", "powerGroupQual", "powerGroupStats", "powerGroupStatsHist", "powerMgmtPolicy", "powerPlacement", "powerPolicy", "powerPrioWght", "powerProfiledPower", "powerRackUnitMember", "procDoer", "procManager", "procProcCounts", "procProcs", "procPrt", "procPrtCounts", "procStimulusCounts", "procSvc", "procTxCounts", "processorCacheMemStats", "processorComponent", "processorCore", "processorEnvStats", "processorEnvStatsHist", "processorErrorStats", "processorExecStats", "processorIOStats", "processorMiscStats", "processorPCIBusStats", "processorPMUStats", "processorQual", "processorRuntime", "processorRuntimeHist", "processorSecurityStats", "processorThread", "processorUnit", "processorUnitAssocCtx", "qosDefinition", "qosItem", "qosclassDefinition", "qosclassDefinitionFsm", "qosclassDefinitionFsmStage", "qosclassDefinitionFsmTask", "qosclassEth", "qosclassEthBE", "qosclassEthClassified", "qosclassFc", "qosclassItem", "qosclassSlowDrain", "qosclassSlowDrainFsm", "qosclassSlowDrainFsmStage", "qosclassSlowDrainFsmTask", "queryresultDependency", "queryresultItem", "queryresultUsage", "ruleDefinition", "ruleItem", "ruleRequirement", "ruleSizeRequirement", "securityUnit", "sesDiskSlotEp", "sesEnclosure", "solConfig", "solDef", "solIf", "solPolicy", "statsCollectionPolicy", "statsCollectionPolicyFsm", "statsCollectionPolicyFsmStage", "statsCollectionPolicyFsmTask", "statsCurr", "statsHist", "statsHolder", "statsItem", "statsThr32Definition", "statsThr32Value", "statsThr64Definition", "statsThr64Value", "statsThrFloatDefinition", "statsThrFloatValue", "statsThresholdClass", "statsThresholdDefinition", "statsThresholdPolicy", "statsThresholdValue", "storageADef", "storageADiskEp", "storageADiskSlotEp", "storageALun", "storageALunRefBase", "storageASlot", "storageAuthKey", "storageConnectionDef", "storageConnectionPolicy", "storageController", "storageControllerBase", "storageControllerEp", "storageControllerRef", "storageControllerReference", "storageDevice", "storageDiskEnvStats", "storageDiskEnvStatsHist", "storageDomainEp", "storageDrive", "storageEmbeddedStorage", "storageEnclosure", "storageEnclosureCap", "storageEnclosureDiskSlotEp", "storageEnclosureFsm", "storageEnclosureFsmStage", "storageEnclosureFsmTask", "storageEnclosureLocalDiskConfig", "storageEp", "storageEpUser", "storageEtherIf", "storageFcIf", "storageFcTargetEp", "storageFcTargetIf", "storageFlexFlashCard", "storageFlexFlashController", "storageFlexFlashControllerFsm", "storageFlexFlashControllerFsmStage", "storageFlexFlashControllerFsmTask", "storageFlexFlashDrive", "storageFlexFlashVirtualDrive", "storageHddMotherBoardTempStats", "storageHddMotherBoardTempStatsHist", "storageIScsiTargetIf", "storageIniGroup", "storageInitiator", "storageItem", "storageL2If", "storageLocalDisk", "storageLocalDiskBase", "storageLocalDiskConfig", "storageLocalDiskConfigDef", "storageLocalDiskConfigPolicy", "storageLocalDiskEp", "storageLocalDiskFsm", "storageLocalDiskFsmStage", "storageLocalDiskFsmTask", "storageLocalDiskPartition", "storageLocalDiskSlotEp", "storageLocalLun", "storageLogical", "storageLunDisk", "storageLunResourceSelectionLog", "storageMezzFlashLife", "storageMiniStorage", "storageNodeEp", "storageNvmeStats", "storageNvmeStatsHist", "storageNvmeStorage", "storageNvmeSwitch", "storageOnboardDevice", "storageOperation", "storagePhysical", "storageQual", "storageRaidBattery", "storageSasExpander", "storageSasLinkDescriptor", "storageSasPhyLink", "storageSasPort", "storageSasPortDescriptor", "storageSasUpLink", "storageScsiLunRef", "storageSsdHealthStats", "storageSsdHealthStatsHist", "storageSystem", "storageSystemFsm", "storageSystemFsmStage", "storageSystemFsmTask", "storageTarget", "storageTargetIf", "storageTransportIf", "storageTransportableFlashModule", "storageUnit", "storageVDMemberEp", "storageVirtualDrive", "storageVirtualDriveContainer", "storageVirtualDriveEp", "storageVirtualDriveRef", "storageVsanRef", "swAccessDomain", "swAccessDomainFsm", "swAccessDomainFsmStage", "swAccessDomainFsmTask", "swAccessEp", "swBorderDomain", "swBorderEp", "swBorderPc", "swCIoEp", "swCardEnvStats", "swCardEnvStatsHist", "swCmclan", "swDomain", "swEnvStats", "swEnvStatsHist", "swEstcEp", "swEthEstcEp", "swEthEstcPc", "swEthFlowMonSession", "swEthLanBorder", "swEthLanBorderFsm", "swEthLanBorderFsmStage", "swEthLanBorderFsmTask", "swEthLanEp", "swEthLanFlowMon", "swEthLanFlowMonExporter", "swEthLanFlowMonFsm", "swEthLanFlowMonFsmStage", "swEthLanFlowMonFsmTask", "swEthLanFlowMonitor", "swEthLanFlowRecordDef", "swEthLanMon", "swEthLanPc", "swEthMon", "swEthMonDestEp", "swEthMonFsm", "swEthMonFsmStage", "swEthMonFsmTask", "swEthMonSrcEp", "swEthTargetEp", "swEtherPort", "swExtUtility", "swExtUtilityFsm", "swExtUtilityFsmStage", "swExtUtilityFsmTask", "swFabricZoneNs", "swFabricZoneNsOverride", "swFcEndpoint", "swFcEstcEp", "swFcMon", "swFcMonDestEp", "swFcMonFsm", "swFcMonFsmStage", "swFcMonFsmTask", "swFcMonSrcEp", "swFcSanBorder", "swFcSanBorderFsm", "swFcSanBorderFsmStage", "swFcSanBorderFsmTask", "swFcSanEp", "swFcSanMon", "swFcSanPc", "swFcServerZoneGroup", "swFcUserZone", "swFcUserZoneGroup", "swFcZone", "swFcZoneMember", "swFcZoneSet", "swFcoeEstcEp", "swFcoeSanEp", "swFcoeSanPc", "swFlowMonExporter", "swFlowMonitor", "swFlowRecordDef", "swIpRoute", "swLanBorder", "swLanEp", "swLanMon", "swLanPc", "swMon", "swMonDestEp", "swMonDomain", "swMonSrcEp", "swNFExporterRef", "swNetflowExporter", "swNetflowMonSession", "swNetflowMonitor", "swNetflowMonitorRef", "swNetflowRecordDef", "swPIoEp", "swPhys", "swPhysEtherEp", "swPhysFcEp", "swPhysFsm", "swPhysFsmStage", "swPhysFsmTask", "swPortBreakout", "swPortDiscover", "swPortDiscoverFsm", "swPortDiscoverFsmStage", "swPortDiscoverFsmTask", "swSanBorder", "swSanEp", "swSanMon", "swSanPc", "swSubGroup", "swSystemStats", "swSystemStatsHist", "swTargetEp", "swUlan", "swUtilityDomain", "swUtilityDomainFsm", "swUtilityDomainFsmStage", "swUtilityDomainFsmTask", "swVIFRef", "swVirtL3Intf", "swVlan", "swVlanGroup", "swVlanPortNs", "swVlanPortNsOverride", "swVlanRef", "swVsan", "swZoneInitiatorMember", "swZoneTargetMember", "swatAction", "swatCondition", "swatInjection", "swatResultstats", "swatTarget", "swatTrigger", "syntheticDirectory", "syntheticFile", "syntheticFileSystem", "syntheticFsObj", "syntheticFsObjFsm", "syntheticFsObjFsmStage", "syntheticFsObjFsmTask", "syntheticTime", "sysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmTask", "sysdebugBackupBehavior", "sysdebugCore", "sysdebugCoreFileExportTarget", "sysdebugCoreFileRepository", "sysdebugCoreFsm", "sysdebugCoreFsmStage", "sysdebugCoreFsmTask", "sysdebugDiagnosticLog", "sysdebugDiagnosticLogRepository", "sysdebugEp", "sysdebugExporter", "sysdebugFile", "sysdebugLogBehavior", "sysdebugLogControlDestinationFile", "sysdebugLogControlDestinationSyslog", "sysdebugLogControlDomain", "sysdebugLogControlEp", "sysdebugLogControlEpFsm", "sysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmTask", "sysdebugLogControlModule", "sysdebugLogExportPolicy", "sysdebugLogExportPolicyFsm", "sysdebugLogExportPolicyFsmStage", "sysdebugLogExportPolicyFsmTask", "sysdebugLogExportStatus", "sysdebugMEpLog", "sysdebugMEpLogDef", "sysdebugMEpLogPolicy", "sysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmTask", "sysdebugRepository", "sysdebugTechSupFileRepository", "sysdebugTechSupport", "sysdebugTechSupportCmdOpt", "sysdebugTechSupportFsm", "sysdebugTechSupportFsmStage", "sysdebugTechSupportFsmTask", "sysfileDigest", "sysfileEp", "sysfileExporter", "sysfileImporter", "sysfileInstance", "sysfileMutation", "sysfileMutationFsm", "sysfileMutationFsmStage", "sysfileMutationFsmTask", "sysfileRepository", "topInfoPolicy", "topInfoSyncPolicy", "topMetaInf", "topRoot", "topSysDefaults", "topSystem", "trigAbsWindow", "trigAck", "trigBaseAbsWindow", "trigBaseRecurrWindow", "trigBaseSched", "trigClientToken", "trigConfAck", "trigInst", "trigLocalAbsWindow", "trigLocalSched", "trigMeta", "trigRecurrWindow", "trigResAck", "trigSched", "trigSchedWindow", "trigTest", "trigToken", "trigTriggerable", "trigTriggered", "trigWindow", "unspecified", "uuidpoolAddr", "uuidpoolBlock", "uuidpoolFormat", "uuidpoolPool", "uuidpoolPoolable", "uuidpoolPooled", "uuidpoolUniverse", "versionApplication", "versionEp", "versionVersion", "vmAdaptor", "vmClientContainer", "vmComputeEp", "vmCont", "vmDC", "vmDCOrg", "vmDirCont", "vmEp", "vmHba", "vmHv", "vmInstance", "vmLifeCyclePolicy", "vmLifeCyclePolicyFsm", "vmLifeCyclePolicyFsmStage", "vmLifeCyclePolicyFsmTask", "vmNic", "vmOrg", "vmSwitch", "vmVif", "vmVirtual", "vmVlan", "vmVnicProfCl", "vmVnicProfInst", "vmVsan", "vnicABeh", "vnicAEtherIf", "vnicAFcIf", "vnicAGroup", "vnicAIpcIf", "vnicAScsiIf", "vnicBootIpPolicy", "vnicBootTarget", "vnicConPolicyRef", "vnicConReq", "vnicConnDef", "vnicConnection", "vnicDefBeh", "vnicDynamicCon", "vnicDynamicConPolicy", "vnicDynamicConPolicyRef", "vnicDynamicConReq", "vnicDynamicIdUniverse", "vnicDynamicProvider", "vnicDynamicProviderEp", "vnicEthConfig", "vnicEthLif", "vnicEther", "vnicEtherBase", "vnicEtherBaseIf", "vnicEtherIf", "vnicFc", "vnicFcBase", "vnicFcGroupDef", "vnicFcGroupTempl", "vnicFcIf", "vnicFcLif", "vnicFcNode", "vnicFcOEIf", "vnicIPIf", "vnicIPv4Dhcp", "vnicIPv4Dns", "vnicIPv4If", "vnicIPv4IscsiAddr", "vnicIPv4PooledIscsiAddr", "vnicIPv4StaticRoute", "vnicIPv6If", "vnicIScsi", "vnicIScsiAutoTargetIf", "vnicIScsiBase", "vnicIScsiBootParams", "vnicIScsiBootVnic", "vnicIScsiConfig", "vnicIScsiInitAutoConfigPolicy", "vnicIScsiLCP", "vnicIScsiNode", "vnicIScsiStaticTargetIf", "vnicIScsiTargetIf", "vnicIf", "vnicIfRole", "vnicInitiatorAutoConfigPolicy", "vnicInternalProfile", "vnicIpAddr", "vnicIpV4Addr", "vnicIpV4AddrConf", "vnicIpV4AddrExplConf", "vnicIpV4History", "vnicIpV4MgmtPooledAddr", "vnicIpV4PooledAddr", "vnicIpV4ProfDerivedAddr", "vnicIpV4StaticAddr", "vnicIpV6Addr", "vnicIpV6AddrConf", "vnicIpV6AddrExplConf", "vnicIpV6History", "vnicIpV6MgmtPooledAddr", "vnicIpV6StaticAddr", "vnicIpc", "vnicIpcIf", "vnicIqnHistory", "vnicL2If", "vnicL2Lif", "vnicL3If", "vnicLanConnPolicy", "vnicLanConnTempl", "vnicLifVlan", "vnicLifVsan", "vnicLun", "vnicMacHistory", "vnicNicConn", "vnicOProfileAlias", "vnicProfile", "vnicProfileAlias", "vnicProfileRef", "vnicProfileSet", "vnicProfileSetFsm", "vnicProfileSetFsmStage", "vnicProfileSetFsmTask", "vnicRackServerDiscoveryProfile", "vnicSanConnPolicy", "vnicSanConnTempl", "vnicScsi", "vnicScsiIf", "vnicTempl", "vnicUsnicConPolicy", "vnicUsnicConPolicyRef", "vnicUsnicConReq", "vnicVProfileAlias", "vnicVhbaBehPolicy", "vnicVlan", "vnicVmqConPolicy", "vnicVmqConPolicyRef", "vnicVmqConReq", "vnicVnic", "vnicVnicBehPolicy", "vnicWwnnHistory", "vnicWwpnHistory"], []),
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, 0x10, 0, 256, None, [], []),
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302c, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []),
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version211a, MoPropertyMeta.READ_WRITE, 0x20, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []),
    }

    prop_map = {
        "childAction": "child_action", 
        "dn": "dn", 
        "moClassId": "mo_class_id", 
        "rn": "rn", 
        "sacl": "sacl", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, mo_class_id, **kwargs):
        self._dirty_mask = 0
        self.mo_class_id = mo_class_id
        self.child_action = None
        self.sacl = None
        self.status = None

        ManagedObject.__init__(self, "FaultAffectedClass", parent_mo_or_dn, **kwargs)
