"""This module contains the general information for ConfigSorter ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class ConfigSorterConsts:
    DIRECTION_ASCENDING = "ascending"
    DIRECTION_DESCENDING = "descending"
    SORT_CLASS_AAA_AUTH_METHOD = "aaaAuthMethod"
    SORT_CLASS_AAA_AUTH_REALM = "aaaAuthRealm"
    SORT_CLASS_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    SORT_CLASS_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    SORT_CLASS_AAA_BANNER = "aaaBanner"
    SORT_CLASS_AAA_CIMC_SESSION = "aaaCimcSession"
    SORT_CLASS_AAA_CONFIG = "aaaConfig"
    SORT_CLASS_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    SORT_CLASS_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    SORT_CLASS_AAA_DEFINITION = "aaaDefinition"
    SORT_CLASS_AAA_DOMAIN = "aaaDomain"
    SORT_CLASS_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    SORT_CLASS_AAA_EP = "aaaEp"
    SORT_CLASS_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    SORT_CLASS_AAA_EP_FSM = "aaaEpFsm"
    SORT_CLASS_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    SORT_CLASS_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    SORT_CLASS_AAA_EP_LOGIN = "aaaEpLogin"
    SORT_CLASS_AAA_EP_USER = "aaaEpUser"
    SORT_CLASS_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    SORT_CLASS_AAA_ITEM = "aaaItem"
    SORT_CLASS_AAA_LDAP_EP = "aaaLdapEp"
    SORT_CLASS_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    SORT_CLASS_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    SORT_CLASS_AAA_LDAP_GROUP = "aaaLdapGroup"
    SORT_CLASS_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    SORT_CLASS_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    SORT_CLASS_AAA_LOCAL_MGMT_CMD_LOG = "aaaLocalMgmtCmdLog"
    SORT_CLASS_AAA_LOCALE = "aaaLocale"
    SORT_CLASS_AAA_LOG = "aaaLog"
    SORT_CLASS_AAA_LOGIN_PROFILE = "aaaLoginProfile"
    SORT_CLASS_AAA_MOD_LR = "aaaModLR"
    SORT_CLASS_AAA_ORG = "aaaOrg"
    SORT_CLASS_AAA_PRE_LOGIN_BANNER = "aaaPreLoginBanner"
    SORT_CLASS_AAA_PROVIDER = "aaaProvider"
    SORT_CLASS_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    SORT_CLASS_AAA_PROVIDER_REF = "aaaProviderRef"
    SORT_CLASS_AAA_PWD_PROFILE = "aaaPwdProfile"
    SORT_CLASS_AAA_RADIUS_EP = "aaaRadiusEp"
    SORT_CLASS_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    SORT_CLASS_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    SORT_CLASS_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    SORT_CLASS_AAA_REALM = "aaaRealm"
    SORT_CLASS_AAA_REALM_FSM = "aaaRealmFsm"
    SORT_CLASS_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    SORT_CLASS_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    SORT_CLASS_AAA_REMOTE_USER = "aaaRemoteUser"
    SORT_CLASS_AAA_ROLE = "aaaRole"
    SORT_CLASS_AAA_SESSION = "aaaSession"
    SORT_CLASS_AAA_SESSION_INFO = "aaaSessionInfo"
    SORT_CLASS_AAA_SESSION_INFO_TABLE = "aaaSessionInfoTable"
    SORT_CLASS_AAA_SESSION_LR = "aaaSessionLR"
    SORT_CLASS_AAA_SHELL_LOGIN = "aaaShellLogin"
    SORT_CLASS_AAA_SSH_AUTH = "aaaSshAuth"
    SORT_CLASS_AAA_SYSTEM_USER = "aaaSystemUser"
    SORT_CLASS_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    SORT_CLASS_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    SORT_CLASS_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    SORT_CLASS_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    SORT_CLASS_AAA_USER = "aaaUser"
    SORT_CLASS_AAA_USER_ACTION = "aaaUserAction"
    SORT_CLASS_AAA_USER_DATA = "aaaUserData"
    SORT_CLASS_AAA_USER_EP = "aaaUserEp"
    SORT_CLASS_AAA_USER_EP_FSM = "aaaUserEpFsm"
    SORT_CLASS_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    SORT_CLASS_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    SORT_CLASS_AAA_USER_GROUP = "aaaUserGroup"
    SORT_CLASS_AAA_USER_LOCALE = "aaaUserLocale"
    SORT_CLASS_AAA_USER_LOGIN = "aaaUserLogin"
    SORT_CLASS_AAA_USER_ROLE = "aaaUserRole"
    SORT_CLASS_AAA_WEB_LOGIN = "aaaWebLogin"
    SORT_CLASS_ADAPTOR_AZURE_QOS_PROFILE = "adaptorAzureQosProfile"
    SORT_CLASS_ADAPTOR_BEH_CAP = "adaptorBehCap"
    SORT_CLASS_ADAPTOR_CIO_EP = "adaptorCIoEp"
    SORT_CLASS_ADAPTOR_CAP_DEF = "adaptorCapDef"
    SORT_CLASS_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    SORT_CLASS_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    SORT_CLASS_ADAPTOR_DIAG_CAP = "adaptorDiagCap"
    SORT_CLASS_ADAPTOR_DYNAMIC_CONFIG_CAP = "adaptorDynamicConfigCap"
    SORT_CLASS_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    SORT_CLASS_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    SORT_CLASS_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    SORT_CLASS_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    SORT_CLASS_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    SORT_CLASS_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    SORT_CLASS_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    SORT_CLASS_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    SORT_CLASS_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    SORT_CLASS_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    SORT_CLASS_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    SORT_CLASS_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    SORT_CLASS_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_FSM = "adaptorExtEthIfFsm"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_FSM_STAGE = "adaptorExtEthIfFsmStage"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_FSM_TASK = "adaptorExtEthIfFsmTask"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_PC = "adaptorExtEthIfPc"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_PC_EP = "adaptorExtEthIfPcEp"
    SORT_CLASS_ADAPTOR_EXT_IF = "adaptorExtIf"
    SORT_CLASS_ADAPTOR_EXT_IF_EP = "adaptorExtIfEp"
    SORT_CLASS_ADAPTOR_EXT_IF_PC = "adaptorExtIfPc"
    SORT_CLASS_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    SORT_CLASS_ADAPTOR_EXTERNAL_EP = "adaptorExternalEp"
    SORT_CLASS_ADAPTOR_EXTERNAL_PC = "adaptorExternalPc"
    SORT_CLASS_ADAPTOR_FAMILY_TYPE_DEF = "adaptorFamilyTypeDef"
    SORT_CLASS_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    SORT_CLASS_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    SORT_CLASS_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    SORT_CLASS_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    SORT_CLASS_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    SORT_CLASS_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    SORT_CLASS_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    SORT_CLASS_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    SORT_CLASS_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    SORT_CLASS_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    SORT_CLASS_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    SORT_CLASS_ADAPTOR_FC_OEIF = "adaptorFcOEIf"
    SORT_CLASS_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    SORT_CLASS_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    SORT_CLASS_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    SORT_CLASS_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    SORT_CLASS_ADAPTOR_FC_VHBA_TYPE_PROFILE = "adaptorFcVhbaTypeProfile"
    SORT_CLASS_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    SORT_CLASS_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    SORT_CLASS_ADAPTOR_FRU_CAP_REF = "adaptorFruCapRef"
    SORT_CLASS_ADAPTOR_FW_CAP_PROVIDER = "adaptorFwCapProvider"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_FSM = "adaptorHostEthIfFsm"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_FSM_STAGE = "adaptorHostEthIfFsmStage"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_FSM_TASK = "adaptorHostEthIfFsmTask"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    SORT_CLASS_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_FSM = "adaptorHostFcIfFsm"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_FSM_STAGE = "adaptorHostFcIfFsmStage"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_FSM_TASK = "adaptorHostFcIfFsmTask"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    SORT_CLASS_ADAPTOR_HOST_IF = "adaptorHostIf"
    SORT_CLASS_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    SORT_CLASS_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    SORT_CLASS_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    SORT_CLASS_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    SORT_CLASS_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    SORT_CLASS_ADAPTOR_HOST_MGMT_CAP = "adaptorHostMgmtCap"
    SORT_CLASS_ADAPTOR_HOST_PORT = "adaptorHostPort"
    SORT_CLASS_ADAPTOR_HOST_PORT_CAP = "adaptorHostPortCap"
    SORT_CLASS_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    SORT_CLASS_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    SORT_CLASS_ADAPTOR_HOST_SERVICE_ETH_IF = "adaptorHostServiceEthIf"
    SORT_CLASS_ADAPTOR_HOST_VNIC_HW_ADDR_CAP = "adaptorHostVnicHwAddrCap"
    SORT_CLASS_ADAPTOR_HOSTETH_HW_ADDR_CAP = "adaptorHostethHwAddrCap"
    SORT_CLASS_ADAPTOR_HOSTFC_HW_ADDR_CAP = "adaptorHostfcHwAddrCap"
    SORT_CLASS_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    SORT_CLASS_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    SORT_CLASS_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    SORT_CLASS_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    SORT_CLASS_ADAPTOR_ISCSI_AUTH = "adaptorIscsiAuth"
    SORT_CLASS_ADAPTOR_ISCSI_PROT = "adaptorIscsiProt"
    SORT_CLASS_ADAPTOR_ISCSI_TARGET_IF = "adaptorIscsiTargetIf"
    SORT_CLASS_ADAPTOR_LAN_CAP = "adaptorLanCap"
    SORT_CLASS_ADAPTOR_LLDP_CAP = "adaptorLldpCap"
    SORT_CLASS_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    SORT_CLASS_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    SORT_CLASS_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    SORT_CLASS_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    SORT_CLASS_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    SORT_CLASS_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    SORT_CLASS_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    SORT_CLASS_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    SORT_CLASS_ADAPTOR_MGMT_CAP = "adaptorMgmtCap"
    SORT_CLASS_ADAPTOR_MGMT_VNIC_ETH_CONFIG = "adaptorMgmtVnicEthConfig"
    SORT_CLASS_ADAPTOR_NW_MGMT_CAP = "adaptorNwMgmtCap"
    SORT_CLASS_ADAPTOR_NW_STATS_MGMT_CAP = "adaptorNwStatsMgmtCap"
    SORT_CLASS_ADAPTOR_PIO_EP = "adaptorPIoEp"
    SORT_CLASS_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    SORT_CLASS_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    SORT_CLASS_ADAPTOR_QUAL = "adaptorQual"
    SORT_CLASS_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    SORT_CLASS_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    SORT_CLASS_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    SORT_CLASS_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    SORT_CLASS_ADAPTOR_SAN_CAP = "adaptorSanCap"
    SORT_CLASS_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    SORT_CLASS_ADAPTOR_UNIT = "adaptorUnit"
    SORT_CLASS_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    SORT_CLASS_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    SORT_CLASS_ADAPTOR_UPLINK_HW_ADDR_CAP = "adaptorUplinkHwAddrCap"
    SORT_CLASS_ADAPTOR_UPLINK_PORT_STATS = "adaptorUplinkPortStats"
    SORT_CLASS_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    SORT_CLASS_ADAPTOR_VLAN = "adaptorVlan"
    SORT_CLASS_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    SORT_CLASS_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    SORT_CLASS_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    SORT_CLASS_ADAPTOR_VSAN = "adaptorVsan"
    SORT_CLASS_APE_ADAPTER = "apeAdapter"
    SORT_CLASS_APE_ADAPTER_VNIC = "apeAdapterVnic"
    SORT_CLASS_APE_ATTRIBUTE = "apeAttribute"
    SORT_CLASS_APE_BOOT_METHOD = "apeBootMethod"
    SORT_CLASS_APE_CONTROLLER_CHASSIS = "apeControllerChassis"
    SORT_CLASS_APE_CONTROLLER_EEPROM = "apeControllerEeprom"
    SORT_CLASS_APE_CONTROLLER_MANAGER = "apeControllerManager"
    SORT_CLASS_APE_DCOS_AG_MANAGER = "apeDcosAgManager"
    SORT_CLASS_APE_FRU = "apeFru"
    SORT_CLASS_APE_HOST_AGENT = "apeHostAgent"
    SORT_CLASS_APE_LANBOOT = "apeLANBoot"
    SORT_CLASS_APE_LOCAL_DISK_BOOT = "apeLocalDiskBoot"
    SORT_CLASS_APE_MANAGER = "apeManager"
    SORT_CLASS_APE_MC = "apeMc"
    SORT_CLASS_APE_MC_STATS = "apeMcStats"
    SORT_CLASS_APE_MC_TABLE = "apeMcTable"
    SORT_CLASS_APE_MENLO = "apeMenlo"
    SORT_CLASS_APE_MENLO_VNIC = "apeMenloVnic"
    SORT_CLASS_APE_MENLO_VNIC_STATS = "apeMenloVnicStats"
    SORT_CLASS_APE_NIC_AG_MANAGER = "apeNicAgManager"
    SORT_CLASS_APE_PALO = "apePalo"
    SORT_CLASS_APE_PALO_VNIC = "apePaloVnic"
    SORT_CLASS_APE_PALO_VNIC_STATS = "apePaloVnicStats"
    SORT_CLASS_APE_PARAM = "apeParam"
    SORT_CLASS_APE_READING = "apeReading"
    SORT_CLASS_APE_SANBOOT = "apeSANBoot"
    SORT_CLASS_APE_SDR = "apeSdr"
    SORT_CLASS_APE_SWITCH_FIRMWARE_INV = "apeSwitchFirmwareInv"
    SORT_CLASS_APE_VIRTUAL_MEDIA_BOOT = "apeVirtualMediaBoot"
    SORT_CLASS_APE_VNIC_STATS = "apeVnicStats"
    SORT_CLASS_BIOS_AREF = "biosARef"
    SORT_CLASS_BIOS_BOT = "biosBOT"
    SORT_CLASS_BIOS_BOOT_DEV = "biosBootDev"
    SORT_CLASS_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    SORT_CLASS_BIOS_FEATURE_REF = "biosFeatureRef"
    SORT_CLASS_BIOS_PARAMETER_REF = "biosParameterRef"
    SORT_CLASS_BIOS_REF = "biosRef"
    SORT_CLASS_BIOS_SETTING_REF = "biosSettingRef"
    SORT_CLASS_BIOS_SETTINGS = "biosSettings"
    SORT_CLASS_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    SORT_CLASS_BIOS_TOKEN_PARAM = "biosTokenParam"
    SORT_CLASS_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    SORT_CLASS_BIOS_UNIT = "biosUnit"
    SORT_CLASS_BIOS_VFEAT = "biosVFeat"
    SORT_CLASS_BIOS_VIDENTITY_PARAMS = "biosVIdentityParams"
    SORT_CLASS_BIOS_VPROFILE = "biosVProfile"
    SORT_CLASS_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    SORT_CLASS_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    SORT_CLASS_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    SORT_CLASS_BIOS_VF_ALTITUDE = "biosVfAltitude"
    SORT_CLASS_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    SORT_CLASS_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    SORT_CLASS_BIOS_VF_BMEDMAMITIGATION = "biosVfBMEDMAMitigation"
    SORT_CLASS_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    SORT_CLASS_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    SORT_CLASS_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    SORT_CLASS_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    SORT_CLASS_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    SORT_CLASS_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    SORT_CLASS_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    SORT_CLASS_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    SORT_CLASS_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    SORT_CLASS_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    SORT_CLASS_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    SORT_CLASS_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    SORT_CLASS_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    SORT_CLASS_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    SORT_CLASS_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    SORT_CLASS_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    SORT_CLASS_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    SORT_CLASS_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    SORT_CLASS_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    SORT_CLASS_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    SORT_CLASS_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    SORT_CLASS_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    SORT_CLASS_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    SORT_CLASS_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    SORT_CLASS_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    SORT_CLASS_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    SORT_CLASS_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    SORT_CLASS_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    SORT_CLASS_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    SORT_CLASS_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    SORT_CLASS_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    SORT_CLASS_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    SORT_CLASS_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    SORT_CLASS_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    SORT_CLASS_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    SORT_CLASS_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    SORT_CLASS_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    SORT_CLASS_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    SORT_CLASS_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    SORT_CLASS_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    SORT_CLASS_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    SORT_CLASS_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    SORT_CLASS_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    SORT_CLASS_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    SORT_CLASS_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    SORT_CLASS_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    SORT_CLASS_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    SORT_CLASS_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    SORT_CLASS_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    SORT_CLASS_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    SORT_CLASS_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    SORT_CLASS_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    SORT_CLASS_BIOS_VF_PANIC_AND_HIGH_WATERMARK = "biosVfPanicAndHighWatermark"
    SORT_CLASS_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    SORT_CLASS_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    SORT_CLASS_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    SORT_CLASS_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    SORT_CLASS_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    SORT_CLASS_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    SORT_CLASS_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    SORT_CLASS_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    SORT_CLASS_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    SORT_CLASS_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    SORT_CLASS_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    SORT_CLASS_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    SORT_CLASS_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    SORT_CLASS_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    SORT_CLASS_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    SORT_CLASS_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    SORT_CLASS_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    SORT_CLASS_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    SORT_CLASS_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    SORT_CLASS_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    SORT_CLASS_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    SORT_CLASS_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    SORT_CLASS_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    SORT_CLASS_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    SORT_CLASS_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    SORT_CLASS_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    SORT_CLASS_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    SORT_CLASS_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    SORT_CLASS_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    SORT_CLASS_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    SORT_CLASS_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    SORT_CLASS_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    SORT_CLASS_BMC_SELCOUNTER = "bmcSELCounter"
    SORT_CLASS_CALLHOME_ANONYMOUS_REPORTING = "callhomeAnonymousReporting"
    SORT_CLASS_CALLHOME_DEST = "callhomeDest"
    SORT_CLASS_CALLHOME_EP = "callhomeEp"
    SORT_CLASS_CALLHOME_EP_FSM = "callhomeEpFsm"
    SORT_CLASS_CALLHOME_EP_FSM_STAGE = "callhomeEpFsmStage"
    SORT_CLASS_CALLHOME_EP_FSM_TASK = "callhomeEpFsmTask"
    SORT_CLASS_CALLHOME_ITEM = "callhomeItem"
    SORT_CLASS_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    SORT_CLASS_CALLHOME_POLICY = "callhomePolicy"
    SORT_CLASS_CALLHOME_PROFILE = "callhomeProfile"
    SORT_CLASS_CALLHOME_SMTP = "callhomeSmtp"
    SORT_CLASS_CALLHOME_SOURCE = "callhomeSource"
    SORT_CLASS_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    SORT_CLASS_CAPABILITY_AEND_POINT_CONFIG = "capabilityAEndPointConfig"
    SORT_CLASS_CAPABILITY_ASOLUTION_STACK = "capabilityASolutionStack"
    SORT_CLASS_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    SORT_CLASS_CAPABILITY_CATALOGUE_FSM = "capabilityCatalogueFsm"
    SORT_CLASS_CAPABILITY_CATALOGUE_FSM_STAGE = "capabilityCatalogueFsmStage"
    SORT_CLASS_CAPABILITY_CATALOGUE_FSM_TASK = "capabilityCatalogueFsmTask"
    SORT_CLASS_CAPABILITY_DEF = "capabilityDef"
    SORT_CLASS_CAPABILITY_EP = "capabilityEp"
    SORT_CLASS_CAPABILITY_FEATURE_LIMITS = "capabilityFeatureLimits"
    SORT_CLASS_CAPABILITY_ITEM = "capabilityItem"
    SORT_CLASS_CAPABILITY_MGMT_EXTENSION = "capabilityMgmtExtension"
    SORT_CLASS_CAPABILITY_MGMT_EXTENSION_FSM = "capabilityMgmtExtensionFsm"
    SORT_CLASS_CAPABILITY_MGMT_EXTENSION_FSM_STAGE = "capabilityMgmtExtensionFsmStage"
    SORT_CLASS_CAPABILITY_MGMT_EXTENSION_FSM_TASK = "capabilityMgmtExtensionFsmTask"
    SORT_CLASS_CAPABILITY_NETWORK_LIMITS = "capabilityNetworkLimits"
    SORT_CLASS_CAPABILITY_PROVIDER = "capabilityProvider"
    SORT_CLASS_CAPABILITY_STORAGE_LIMITS = "capabilityStorageLimits"
    SORT_CLASS_CAPABILITY_SYSTEM_LIMITS = "capabilitySystemLimits"
    SORT_CLASS_CAPABILITY_UPDATE = "capabilityUpdate"
    SORT_CLASS_CAPABILITY_UPDATER = "capabilityUpdater"
    SORT_CLASS_CAPABILITY_UPDATER_FSM = "capabilityUpdaterFsm"
    SORT_CLASS_CAPABILITY_UPDATER_FSM_STAGE = "capabilityUpdaterFsmStage"
    SORT_CLASS_CAPABILITY_UPDATER_FSM_TASK = "capabilityUpdaterFsmTask"
    SORT_CLASS_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    SORT_CLASS_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    SORT_CLASS_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    SORT_CLASS_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    SORT_CLASS_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    SORT_CLASS_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    SORT_CLASS_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    SORT_CLASS_CLITEST_TYPE_TEST = "clitestTypeTest"
    SORT_CLASS_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    SORT_CLASS_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    SORT_CLASS_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    SORT_CLASS_CLOUD_DEVICE_CONNECTOR_EP = "cloudDeviceConnectorEp"
    SORT_CLASS_CLOUD_MGMT_SVC = "cloudMgmtSvc"
    SORT_CLASS_COMM_CIMC_WEB_SERVICE = "commCimcWebService"
    SORT_CLASS_COMM_CIMXML = "commCimxml"
    SORT_CLASS_COMM_CLIENT = "commClient"
    SORT_CLASS_COMM_CLIENT_ITEM = "commClientItem"
    SORT_CLASS_COMM_DATE_TIME = "commDateTime"
    SORT_CLASS_COMM_DEFINITION = "commDefinition"
    SORT_CLASS_COMM_DNS = "commDns"
    SORT_CLASS_COMM_DNS_PROVIDER = "commDnsProvider"
    SORT_CLASS_COMM_EVT_CHANNEL = "commEvtChannel"
    SORT_CLASS_COMM_HTTP = "commHttp"
    SORT_CLASS_COMM_HTTPS = "commHttps"
    SORT_CLASS_COMM_ITEM = "commItem"
    SORT_CLASS_COMM_LOCALE = "commLocale"
    SORT_CLASS_COMM_NTP_PROVIDER = "commNtpProvider"
    SORT_CLASS_COMM_SHELL = "commShell"
    SORT_CLASS_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    SORT_CLASS_COMM_SMASH_CLP = "commSmashCLP"
    SORT_CLASS_COMM_SNMP = "commSnmp"
    SORT_CLASS_COMM_SNMP_TRAP = "commSnmpTrap"
    SORT_CLASS_COMM_SNMP_USER = "commSnmpUser"
    SORT_CLASS_COMM_SSH = "commSsh"
    SORT_CLASS_COMM_SVC = "commSvc"
    SORT_CLASS_COMM_SVC_CHANNEL = "commSvcChannel"
    SORT_CLASS_COMM_SVC_EP = "commSvcEp"
    SORT_CLASS_COMM_SVC_EP_FSM = "commSvcEpFsm"
    SORT_CLASS_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    SORT_CLASS_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    SORT_CLASS_COMM_SVC_LIMITS = "commSvcLimits"
    SORT_CLASS_COMM_SVC_POLICY = "commSvcPolicy"
    SORT_CLASS_COMM_SYSLOG = "commSyslog"
    SORT_CLASS_COMM_SYSLOG_CLIENT = "commSyslogClient"
    SORT_CLASS_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    SORT_CLASS_COMM_SYSLOG_FILE = "commSyslogFile"
    SORT_CLASS_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    SORT_CLASS_COMM_SYSLOG_SOURCE = "commSyslogSource"
    SORT_CLASS_COMM_TELNET = "commTelnet"
    SORT_CLASS_COMM_WEB = "commWeb"
    SORT_CLASS_COMM_WEB_CHANNEL = "commWebChannel"
    SORT_CLASS_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    SORT_CLASS_COMM_WSMAN = "commWsman"
    SORT_CLASS_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    SORT_CLASS_COMPUTE_ABOARD = "computeABoard"
    SORT_CLASS_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    SORT_CLASS_COMPUTE_ADMIN_ACK = "computeAdminAck"
    SORT_CLASS_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    SORT_CLASS_COMPUTE_BEH_CAP = "computeBehCap"
    SORT_CLASS_COMPUTE_BLADE = "computeBlade"
    SORT_CLASS_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    SORT_CLASS_COMPUTE_BLADE_EP = "computeBladeEp"
    SORT_CLASS_COMPUTE_BLADE_FSM = "computeBladeFsm"
    SORT_CLASS_COMPUTE_BLADE_FSM_STAGE = "computeBladeFsmStage"
    SORT_CLASS_COMPUTE_BLADE_FSM_TASK = "computeBladeFsmTask"
    SORT_CLASS_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    SORT_CLASS_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    SORT_CLASS_COMPUTE_BOARD = "computeBoard"
    SORT_CLASS_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    SORT_CLASS_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    SORT_CLASS_COMPUTE_CARTRIDGE = "computeCartridge"
    SORT_CLASS_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    SORT_CLASS_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    SORT_CLASS_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    SORT_CLASS_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    SORT_CLASS_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    SORT_CLASS_COMPUTE_CONSTRAINT_DEF = "computeConstraintDef"
    SORT_CLASS_COMPUTE_CONTAINER = "computeContainer"
    SORT_CLASS_COMPUTE_DEFAULTS = "computeDefaults"
    SORT_CLASS_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    SORT_CLASS_COMPUTE_EXT_BOARD = "computeExtBoard"
    SORT_CLASS_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    SORT_CLASS_COMPUTE_FAN_POLICY = "computeFanPolicy"
    SORT_CLASS_COMPUTE_FW_SYNC_ACK = "computeFwSyncAck"
    SORT_CLASS_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    SORT_CLASS_COMPUTE_HEALTH_LED_SENSOR_ALARM = "computeHealthLedSensorAlarm"
    SORT_CLASS_COMPUTE_HOST_UTILITY_OS = "computeHostUtilityOs"
    SORT_CLASS_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    SORT_CLASS_COMPUTE_IOHUB = "computeIOHub"
    SORT_CLASS_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    SORT_CLASS_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    SORT_CLASS_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    SORT_CLASS_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    SORT_CLASS_COMPUTE_ITEM = "computeItem"
    SORT_CLASS_COMPUTE_KVM_MGMT_POLICY = "computeKvmMgmtPolicy"
    SORT_CLASS_COMPUTE_LOGICAL = "computeLogical"
    SORT_CLASS_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    SORT_CLASS_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    SORT_CLASS_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    SORT_CLASS_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    SORT_CLASS_COMPUTE_MEMORY_CONFIG_POLICY = "computeMemoryConfigPolicy"
    SORT_CLASS_COMPUTE_MEMORY_CONFIGURATION = "computeMemoryConfiguration"
    SORT_CLASS_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF = "computeMemoryUnitConstraintDef"
    SORT_CLASS_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    SORT_CLASS_COMPUTE_PARTITION = "computePartition"
    SORT_CLASS_COMPUTE_PCI_CAP = "computePciCap"
    SORT_CLASS_COMPUTE_PCI_SLOT_SCAN_DEF = "computePciSlotScanDef"
    SORT_CLASS_COMPUTE_PERSONALITY = "computePersonality"
    SORT_CLASS_COMPUTE_PHYSICAL = "computePhysical"
    SORT_CLASS_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    SORT_CLASS_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    SORT_CLASS_COMPUTE_PHYSICAL_FSM = "computePhysicalFsm"
    SORT_CLASS_COMPUTE_PHYSICAL_FSM_STAGE = "computePhysicalFsmStage"
    SORT_CLASS_COMPUTE_PHYSICAL_FSM_TASK = "computePhysicalFsmTask"
    SORT_CLASS_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    SORT_CLASS_COMPUTE_PLATFORM = "computePlatform"
    SORT_CLASS_COMPUTE_PNU_OSIMAGE = "computePnuOSImage"
    SORT_CLASS_COMPUTE_POOL = "computePool"
    SORT_CLASS_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    SORT_CLASS_COMPUTE_POOLABLE = "computePoolable"
    SORT_CLASS_COMPUTE_POOLED = "computePooled"
    SORT_CLASS_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    SORT_CLASS_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    SORT_CLASS_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    SORT_CLASS_COMPUTE_POOLED_SLOT = "computePooledSlot"
    SORT_CLASS_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    SORT_CLASS_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    SORT_CLASS_COMPUTE_POWER_SAVE_POLICY = "computePowerSavePolicy"
    SORT_CLASS_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    SORT_CLASS_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    SORT_CLASS_COMPUTE_PSU_CONTROL = "computePsuControl"
    SORT_CLASS_COMPUTE_PSU_DEF = "computePsuDef"
    SORT_CLASS_COMPUTE_PSU_POLICY = "computePsuPolicy"
    SORT_CLASS_COMPUTE_QUAL = "computeQual"
    SORT_CLASS_COMPUTE_QUAL_BASE = "computeQualBase"
    SORT_CLASS_COMPUTE_QUAL_ITEM = "computeQualItem"
    SORT_CLASS_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    SORT_CLASS_COMPUTE_RACK_CONN_LINK_POLICY = "computeRackConnLinkPolicy"
    SORT_CLASS_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    SORT_CLASS_COMPUTE_RACK_QUAL = "computeRackQual"
    SORT_CLASS_COMPUTE_RACK_UNIT = "computeRackUnit"
    SORT_CLASS_COMPUTE_RACK_UNIT_FSM = "computeRackUnitFsm"
    SORT_CLASS_COMPUTE_RACK_UNIT_FSM_STAGE = "computeRackUnitFsmStage"
    SORT_CLASS_COMPUTE_RACK_UNIT_FSM_TASK = "computeRackUnitFsmTask"
    SORT_CLASS_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    SORT_CLASS_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    SORT_CLASS_COMPUTE_REBOOT_LOG = "computeRebootLog"
    SORT_CLASS_COMPUTE_RTC_BATTERY = "computeRtcBattery"
    SORT_CLASS_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    SORT_CLASS_COMPUTE_SERVER = "computeServer"
    SORT_CLASS_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    SORT_CLASS_COMPUTE_SERVER_DISC_POLICY_FSM = "computeServerDiscPolicyFsm"
    SORT_CLASS_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE = "computeServerDiscPolicyFsmStage"
    SORT_CLASS_COMPUTE_SERVER_DISC_POLICY_FSM_TASK = "computeServerDiscPolicyFsmTask"
    SORT_CLASS_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    SORT_CLASS_COMPUTE_SERVER_TYPE_CAP = "computeServerTypeCap"
    SORT_CLASS_COMPUTE_SERVER_UNIT = "computeServerUnit"
    SORT_CLASS_COMPUTE_SERVER_UNIT_FSM = "computeServerUnitFsm"
    SORT_CLASS_COMPUTE_SERVER_UNIT_FSM_STAGE = "computeServerUnitFsmStage"
    SORT_CLASS_COMPUTE_SERVER_UNIT_FSM_TASK = "computeServerUnitFsmTask"
    SORT_CLASS_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    SORT_CLASS_COMPUTE_SLOT_QUAL = "computeSlotQual"
    SORT_CLASS_COMPUTE_VIRTUAL = "computeVirtual"
    SORT_CLASS_COMPUTE_VIRTUAL_CONTAINER = "computeVirtualContainer"
    SORT_CLASS_CONDITION_IMMUTABLE = "conditionImmutable"
    SORT_CLASS_CONDITION_INFO = "conditionInfo"
    SORT_CLASS_CONDITION_LOG = "conditionLog"
    SORT_CLASS_CONDITION_LOGGABLE = "conditionLoggable"
    SORT_CLASS_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    SORT_CLASS_CONDITION_MUTABLE = "conditionMutable"
    SORT_CLASS_CONDITION_POLICY = "conditionPolicy"
    SORT_CLASS_CONDITION_REPORTABLE = "conditionReportable"
    SORT_CLASS_CONFIG_IMPACT = "configImpact"
    SORT_CLASS_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    SORT_CLASS_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    SORT_CLASS_CONFIG_SORTER = "configSorter"
    SORT_CLASS_CONTROLLER_HA_CONTROLLER = "controllerHaController"
    SORT_CLASS_CONTROLLER_MGMT_DB_CHECK_POL = "controllerMgmtDbCheckPol"
    SORT_CLASS_CONTROLLER_OPERATIONAL_VERSION_HOLDER = "controllerOperationalVersionHolder"
    SORT_CLASS_CONTROLLER_PREFERED_VERSION_HOLDER = "controllerPreferedVersionHolder"
    SORT_CLASS_COPROCESSOR_CARD = "coprocessorCard"
    SORT_CLASS_CPMAINT_ACK = "cpmaintAck"
    SORT_CLASS_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    SORT_CLASS_DCX_FCOE_VIF_EP = "dcxFcoeVifEp"
    SORT_CLASS_DCX_NS = "dcxNs"
    SORT_CLASS_DCX_UNIVERSE = "dcxUniverse"
    SORT_CLASS_DCX_VIF = "dcxVIf"
    SORT_CLASS_DCX_VC = "dcxVc"
    SORT_CLASS_DCX_VIF_EP = "dcxVifEp"
    SORT_CLASS_DHCP_ACQUIRED = "dhcpAcquired"
    SORT_CLASS_DHCP_INST = "dhcpInst"
    SORT_CLASS_DHCP_LEASE = "dhcpLease"
    SORT_CLASS_DIAG_CTRL = "diagCtrl"
    SORT_CLASS_DIAG_LOG_EP = "diagLogEp"
    SORT_CLASS_DIAG_MEMORY_TEST = "diagMemoryTest"
    SORT_CLASS_DIAG_RSLT = "diagRslt"
    SORT_CLASS_DIAG_RUN_POLICY = "diagRunPolicy"
    SORT_CLASS_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    SORT_CLASS_DIAG_SRV_CTRL = "diagSrvCtrl"
    SORT_CLASS_DIAG_TEST = "diagTest"
    SORT_CLASS_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    SORT_CLASS_DOMAIN_CHASSIS_FEATURE_CONT = "domainChassisFeatureCont"
    SORT_CLASS_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    SORT_CLASS_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    SORT_CLASS_DOMAIN_ENVIRONMENT_FEATURE_CONT = "domainEnvironmentFeatureCont"
    SORT_CLASS_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    SORT_CLASS_DOMAIN_FEATURE = "domainFeature"
    SORT_CLASS_DOMAIN_FEATURE_CONT = "domainFeatureCont"
    SORT_CLASS_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    SORT_CLASS_DOMAIN_NETWORK_FEATURE_CONT = "domainNetworkFeatureCont"
    SORT_CLASS_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    SORT_CLASS_DOMAIN_PARAMETER = "domainParameter"
    SORT_CLASS_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    SORT_CLASS_DOMAIN_SERVER_FEATURE_CONT = "domainServerFeatureCont"
    SORT_CLASS_DOMAIN_SERVER_PARAM = "domainServerParam"
    SORT_CLASS_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    SORT_CLASS_DOMAIN_STORAGE_FEATURE_CONT = "domainStorageFeatureCont"
    SORT_CLASS_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    SORT_CLASS_DPSEC_MAC = "dpsecMac"
    SORT_CLASS_DUPE_SCOPE = "dupeScope"
    SORT_CLASS_DUPE_SCOPE_RESULT = "dupeScopeResult"
    SORT_CLASS_EPQOS_DEFINITION = "epqosDefinition"
    SORT_CLASS_EPQOS_DEFINITION_DEL_TASK = "epqosDefinitionDelTask"
    SORT_CLASS_EPQOS_DEFINITION_DEL_TASK_FSM = "epqosDefinitionDelTaskFsm"
    SORT_CLASS_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE = "epqosDefinitionDelTaskFsmStage"
    SORT_CLASS_EPQOS_DEFINITION_DEL_TASK_FSM_TASK = "epqosDefinitionDelTaskFsmTask"
    SORT_CLASS_EPQOS_DEFINITION_FSM = "epqosDefinitionFsm"
    SORT_CLASS_EPQOS_DEFINITION_FSM_STAGE = "epqosDefinitionFsmStage"
    SORT_CLASS_EPQOS_DEFINITION_FSM_TASK = "epqosDefinitionFsmTask"
    SORT_CLASS_EPQOS_EGRESS = "epqosEgress"
    SORT_CLASS_EPQOS_ITEM = "epqosItem"
    SORT_CLASS_EQUIPMENT_ADAPTOR_CONN_DEF = "equipmentAdaptorConnDef"
    SORT_CLASS_EQUIPMENT_ADAPTOR_DEF = "equipmentAdaptorDef"
    SORT_CLASS_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    SORT_CLASS_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    SORT_CLASS_EQUIPMENT_AUTO_CONFIG_MODE = "equipmentAutoConfigMode"
    SORT_CLASS_EQUIPMENT_AUTOCONFIG_POLICY = "equipmentAutoconfigPolicy"
    SORT_CLASS_EQUIPMENT_BASE_BOARD_CAP_PROVIDER = "equipmentBaseBoardCapProvider"
    SORT_CLASS_EQUIPMENT_BEACON_CAP_PROVIDER = "equipmentBeaconCapProvider"
    SORT_CLASS_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    SORT_CLASS_EQUIPMENT_BEACON_LED_FSM = "equipmentBeaconLedFsm"
    SORT_CLASS_EQUIPMENT_BEACON_LED_FSM_STAGE = "equipmentBeaconLedFsmStage"
    SORT_CLASS_EQUIPMENT_BEACON_LED_FSM_TASK = "equipmentBeaconLedFsmTask"
    SORT_CLASS_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    SORT_CLASS_EQUIPMENT_BINDING = "equipmentBinding"
    SORT_CLASS_EQUIPMENT_BIOS_DEF = "equipmentBiosDef"
    SORT_CLASS_EQUIPMENT_BIOS_TOKEN_OVERRIDE = "equipmentBiosTokenOverride"
    SORT_CLASS_EQUIPMENT_BLADE_AGLIBRARY = "equipmentBladeAGLibrary"
    SORT_CLASS_EQUIPMENT_BLADE_AGGREGATION_CAP_REF = "equipmentBladeAggregationCapRef"
    SORT_CLASS_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER = "equipmentBladeBiosCapProvider"
    SORT_CLASS_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    SORT_CLASS_EQUIPMENT_BLADE_CAP_PROVIDER_TYPE_DEF = "equipmentBladeCapProviderTypeDef"
    SORT_CLASS_EQUIPMENT_BLADE_CONN_DEF = "equipmentBladeConnDef"
    SORT_CLASS_EQUIPMENT_BLADE_IOMCONN_DEF = "equipmentBladeIOMConnDef"
    SORT_CLASS_EQUIPMENT_BLADE_SWITCH_CONN_DEF = "equipmentBladeSwitchConnDef"
    SORT_CLASS_EQUIPMENT_BOARD_CONTROLLER_DEF = "equipmentBoardControllerDef"
    SORT_CLASS_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS = "equipmentBootDeviceConstraints"
    SORT_CLASS_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    SORT_CLASS_EQUIPMENT_CAP_MOD_SPEC = "equipmentCapModSpec"
    SORT_CLASS_EQUIPMENT_CARD = "equipmentCard"
    SORT_CLASS_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    SORT_CLASS_EQUIPMENT_CATALOG_CAP_PROVIDER = "equipmentCatalogCapProvider"
    SORT_CLASS_EQUIPMENT_CHASSIS = "equipmentChassis"
    SORT_CLASS_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    SORT_CLASS_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    SORT_CLASS_EQUIPMENT_CHASSIS_FSM = "equipmentChassisFsm"
    SORT_CLASS_EQUIPMENT_CHASSIS_FSM_STAGE = "equipmentChassisFsmStage"
    SORT_CLASS_EQUIPMENT_CHASSIS_FSM_TASK = "equipmentChassisFsmTask"
    SORT_CLASS_EQUIPMENT_CHASSIS_INHERIT_POLICY = "equipmentChassisInheritPolicy"
    SORT_CLASS_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    SORT_CLASS_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    SORT_CLASS_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    SORT_CLASS_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    SORT_CLASS_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    SORT_CLASS_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    SORT_CLASS_EQUIPMENT_CISCO_OS_OPEN_GATE = "equipmentCiscoOsOpenGate"
    SORT_CLASS_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    SORT_CLASS_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    SORT_CLASS_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    SORT_CLASS_EQUIPMENT_CONFIG_POLICY = "equipmentConfigPolicy"
    SORT_CLASS_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER = "equipmentCoprocessorUnitCapProvider"
    SORT_CLASS_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER = "equipmentDbgPluginCapProvider"
    SORT_CLASS_EQUIPMENT_DIAG_FEATURE_SUPPORT = "equipmentDiagFeatureSupport"
    SORT_CLASS_EQUIPMENT_DIMM_ENTRY = "equipmentDimmEntry"
    SORT_CLASS_EQUIPMENT_DIMM_MAPPING = "equipmentDimmMapping"
    SORT_CLASS_EQUIPMENT_DISCOVERY_CAP = "equipmentDiscoveryCap"
    SORT_CLASS_EQUIPMENT_DOWNGRADE_CONSTRAINT = "equipmentDowngradeConstraint"
    SORT_CLASS_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    SORT_CLASS_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG = "equipmentEmbeddedControllerConfig"
    SORT_CLASS_EQUIPMENT_EMBEDDED_STORAGE_DEF = "equipmentEmbeddedStorageDef"
    SORT_CLASS_EQUIPMENT_ENV_SENSOR = "equipmentEnvSensor"
    SORT_CLASS_EQUIPMENT_FAN = "equipmentFan"
    SORT_CLASS_EQUIPMENT_FAN_AGGRESSIVE_COOLING_CAP = "equipmentFanAggressiveCoolingCap"
    SORT_CLASS_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_DEF = "equipmentFanModuleDef"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    SORT_CLASS_EQUIPMENT_FAN_PRESENCE_DEF = "equipmentFanPresenceDef"
    SORT_CLASS_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    SORT_CLASS_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    SORT_CLASS_EQUIPMENT_FEX = "equipmentFex"
    SORT_CLASS_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    SORT_CLASS_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    SORT_CLASS_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    SORT_CLASS_EQUIPMENT_FEX_FSM = "equipmentFexFsm"
    SORT_CLASS_EQUIPMENT_FEX_FSM_STAGE = "equipmentFexFsmStage"
    SORT_CLASS_EQUIPMENT_FEX_FSM_TASK = "equipmentFexFsmTask"
    SORT_CLASS_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    SORT_CLASS_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    SORT_CLASS_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    SORT_CLASS_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    SORT_CLASS_EQUIPMENT_FEX_SYSTEM_STATS = "equipmentFexSystemStats"
    SORT_CLASS_EQUIPMENT_FEX_SYSTEM_STATS_HIST = "equipmentFexSystemStatsHist"
    SORT_CLASS_EQUIPMENT_FIRMWARE_CONSTRAINT = "equipmentFirmwareConstraint"
    SORT_CLASS_EQUIPMENT_FLASH_LIFE = "equipmentFlashLife"
    SORT_CLASS_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE = "equipmentFlexFlashNonRemovable"
    SORT_CLASS_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    SORT_CLASS_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    SORT_CLASS_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    SORT_CLASS_EQUIPMENT_GEM_PORT_CAP = "equipmentGemPortCap"
    SORT_CLASS_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER = "equipmentGraphicsCardCapProvider"
    SORT_CLASS_EQUIPMENT_GRAPHICS_CARD_CAP_REF = "equipmentGraphicsCardCapRef"
    SORT_CLASS_EQUIPMENT_HDDFAULT_MON_DEF = "equipmentHDDFaultMonDef"
    SORT_CLASS_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    SORT_CLASS_EQUIPMENT_HOLDER = "equipmentHolder"
    SORT_CLASS_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    SORT_CLASS_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    SORT_CLASS_EQUIPMENT_HOST_MGMT_CONTROLLER_CAP = "equipmentHostMgmtControllerCap"
    SORT_CLASS_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER = "equipmentHwCapDerivativeProvider"
    SORT_CLASS_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    SORT_CLASS_EQUIPMENT_HW_REVISION_MODIFIER = "equipmentHwRevisionModifier"
    SORT_CLASS_EQUIPMENT_HX_CAP = "equipmentHxCap"
    SORT_CLASS_EQUIPMENT_IOCARD = "equipmentIOCard"
    SORT_CLASS_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    SORT_CLASS_EQUIPMENT_IOCARD_BASE_FSM = "equipmentIOCardBaseFsm"
    SORT_CLASS_EQUIPMENT_IOCARD_BASE_FSM_STAGE = "equipmentIOCardBaseFsmStage"
    SORT_CLASS_EQUIPMENT_IOCARD_BASE_FSM_TASK = "equipmentIOCardBaseFsmTask"
    SORT_CLASS_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    SORT_CLASS_EQUIPMENT_IOCARD_FSM = "equipmentIOCardFsm"
    SORT_CLASS_EQUIPMENT_IOCARD_FSM_STAGE = "equipmentIOCardFsmStage"
    SORT_CLASS_EQUIPMENT_IOCARD_FSM_TASK = "equipmentIOCardFsmTask"
    SORT_CLASS_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    SORT_CLASS_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    SORT_CLASS_EQUIPMENT_IOCARD_TYPE_DEF = "equipmentIOCardTypeDef"
    SORT_CLASS_EQUIPMENT_IOEXPANDER = "equipmentIOExpander"
    SORT_CLASS_EQUIPMENT_IOEXPANDER_CAP_PROVIDER = "equipmentIOExpanderCapProvider"
    SORT_CLASS_EQUIPMENT_INBAND_MGMT_CAP = "equipmentInbandMgmtCap"
    SORT_CLASS_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    SORT_CLASS_EQUIPMENT_INIT_CONFIG_POLICY = "equipmentInitConfigPolicy"
    SORT_CLASS_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    SORT_CLASS_EQUIPMENT_INVENTORY_STATUS = "equipmentInventoryStatus"
    SORT_CLASS_EQUIPMENT_ITEM = "equipmentItem"
    SORT_CLASS_EQUIPMENT_KVM_MGMT_CAP = "equipmentKvmMgmtCap"
    SORT_CLASS_EQUIPMENT_LED = "equipmentLed"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF = "equipmentLocalDiskControllerCapRef"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF = "equipmentLocalDiskControllerDef"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CONTROLLER_TYPE_DEF = "equipmentLocalDiskControllerTypeDef"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED_FSM = "equipmentLocatorLedFsm"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED_FSM_STAGE = "equipmentLocatorLedFsmStage"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED_FSM_TASK = "equipmentLocatorLedFsmTask"
    SORT_CLASS_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    SORT_CLASS_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    SORT_CLASS_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF = "equipmentMemoryUnitDiscoveryModifierDef"
    SORT_CLASS_EQUIPMENT_MGMT_CAP_PROVIDER = "equipmentMgmtCapProvider"
    SORT_CLASS_EQUIPMENT_MGMT_CONTROLLER_CAP = "equipmentMgmtControllerCap"
    SORT_CLASS_EQUIPMENT_MGMT_EXT_CAP_PROVIDER = "equipmentMgmtExtCapProvider"
    SORT_CLASS_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER = "equipmentMiniStorageCapProvider"
    SORT_CLASS_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    SORT_CLASS_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    SORT_CLASS_EQUIPMENT_NON_COPPER_PASSIVE_CAP = "equipmentNonCopperPassiveCap"
    SORT_CLASS_EQUIPMENT_NVME_DEF = "equipmentNvmeDef"
    SORT_CLASS_EQUIPMENT_NVME_SWITCH_CONFIG = "equipmentNvmeSwitchConfig"
    SORT_CLASS_EQUIPMENT_ONBOARD_DEVICE_DEF = "equipmentOnboardDeviceDef"
    SORT_CLASS_EQUIPMENT_POST = "equipmentPOST"
    SORT_CLASS_EQUIPMENT_POSTCODE = "equipmentPOSTCode"
    SORT_CLASS_EQUIPMENT_POSTCODE_CONTAINER = "equipmentPOSTCodeContainer"
    SORT_CLASS_EQUIPMENT_POSTCODE_DATA = "equipmentPOSTCodeData"
    SORT_CLASS_EQUIPMENT_POSTCODE_REPORTER = "equipmentPOSTCodeReporter"
    SORT_CLASS_EQUIPMENT_POSTCODE_TEMPLATE = "equipmentPOSTCodeTemplate"
    SORT_CLASS_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    SORT_CLASS_EQUIPMENT_PCI_SLOT_ID_ENTRY = "equipmentPciSlotIdEntry"
    SORT_CLASS_EQUIPMENT_PCI_SLOT_ID_MAPPING = "equipmentPciSlotIdMapping"
    SORT_CLASS_EQUIPMENT_PCI_SLOT_SUB_OEMID_ENTRY = "equipmentPciSlotSubOEMIdEntry"
    SORT_CLASS_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER = "equipmentPciSwitchCapProvider"
    SORT_CLASS_EQUIPMENT_PCIE_SLOT_ORIENTATION = "equipmentPcieSlotOrientation"
    SORT_CLASS_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentPersistentMemoryUnitCapProvider"
    SORT_CLASS_EQUIPMENT_PERSONALITY = "equipmentPersonality"
    SORT_CLASS_EQUIPMENT_PFC_MMU_CAP = "equipmentPfcMmuCap"
    SORT_CLASS_EQUIPMENT_PHYS_DEVICES_PER_BOARD = "equipmentPhysDevicesPerBoard"
    SORT_CLASS_EQUIPMENT_PHYSICAL_DEF = "equipmentPhysicalDef"
    SORT_CLASS_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    SORT_CLASS_EQUIPMENT_PICTURE = "equipmentPicture"
    SORT_CLASS_EQUIPMENT_PNUOS_BOOT_MODE = "equipmentPnuosBootMode"
    SORT_CLASS_EQUIPMENT_POOL = "equipmentPool"
    SORT_CLASS_EQUIPMENT_POOL_POLICY_REF = "equipmentPoolPolicyRef"
    SORT_CLASS_EQUIPMENT_POOLABLE = "equipmentPoolable"
    SORT_CLASS_EQUIPMENT_POOLED = "equipmentPooled"
    SORT_CLASS_EQUIPMENT_POOLED_CHASSIS = "equipmentPooledChassis"
    SORT_CLASS_EQUIPMENT_POOLED_PHYSICAL = "equipmentPooledPhysical"
    SORT_CLASS_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    SORT_CLASS_EQUIPMENT_PORT_CAP = "equipmentPortCap"
    SORT_CLASS_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF = "equipmentPortGroupAggregationDef"
    SORT_CLASS_EQUIPMENT_PORT_GROUP_DEF = "equipmentPortGroupDef"
    SORT_CLASS_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF = "equipmentPortGroupSwComplexDef"
    SORT_CLASS_EQUIPMENT_PORT_SW_COMPLEX_REF = "equipmentPortSwComplexRef"
    SORT_CLASS_EQUIPMENT_POWER_CAP_DEF = "equipmentPowerCapDef"
    SORT_CLASS_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    SORT_CLASS_EQUIPMENT_PROCESSOR_UNIT_DEF = "equipmentProcessorUnitDef"
    SORT_CLASS_EQUIPMENT_PSU = "equipmentPsu"
    SORT_CLASS_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    SORT_CLASS_EQUIPMENT_PSU_DEF = "equipmentPsuDef"
    SORT_CLASS_EQUIPMENT_PSU_FSM = "equipmentPsuFsm"
    SORT_CLASS_EQUIPMENT_PSU_FSM_STAGE = "equipmentPsuFsmStage"
    SORT_CLASS_EQUIPMENT_PSU_FSM_TASK = "equipmentPsuFsmTask"
    SORT_CLASS_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    SORT_CLASS_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    SORT_CLASS_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    SORT_CLASS_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    SORT_CLASS_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    SORT_CLASS_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    SORT_CLASS_EQUIPMENT_QUAL = "equipmentQual"
    SORT_CLASS_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    SORT_CLASS_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    SORT_CLASS_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    SORT_CLASS_EQUIPMENT_RACK_ENCLOSURE = "equipmentRackEnclosure"
    SORT_CLASS_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER = "equipmentRackEnclosureCapProvider"
    SORT_CLASS_EQUIPMENT_RACK_FAN_MODULE_DEF = "equipmentRackFanModuleDef"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    SORT_CLASS_EQUIPMENT_RAID_DEF = "equipmentRaidDef"
    SORT_CLASS_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    SORT_CLASS_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    SORT_CLASS_EQUIPMENT_SECURE_CONTROLLER = "equipmentSecureController"
    SORT_CLASS_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER = "equipmentSecurityUnitCapProvider"
    SORT_CLASS_EQUIPMENT_SERVER_CORRECT_UUID_BEHAVIOR = "equipmentServerCorrectUuidBehavior"
    SORT_CLASS_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    SORT_CLASS_EQUIPMENT_SERVER_PORT_CAP_PROVIDER = "equipmentServerPortCapProvider"
    SORT_CLASS_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    SORT_CLASS_EQUIPMENT_SERVICE_DEF = "equipmentServiceDef"
    SORT_CLASS_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    SORT_CLASS_EQUIPMENT_SIOC_CAP_PROVIDER = "equipmentSiocCapProvider"
    SORT_CLASS_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    SORT_CLASS_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    SORT_CLASS_EQUIPMENT_SLOT = "equipmentSlot"
    SORT_CLASS_EQUIPMENT_SLOT_ARRAY = "equipmentSlotArray"
    SORT_CLASS_EQUIPMENT_SLOT_ARRAY_REF = "equipmentSlotArrayRef"
    SORT_CLASS_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    SORT_CLASS_EQUIPMENT_SLOT_EP = "equipmentSlotEp"
    SORT_CLASS_EQUIPMENT_SPDM_CERTIFICATE_CAP = "equipmentSpdmCertificateCap"
    SORT_CLASS_EQUIPMENT_SPEED_COMPATIBILITY = "equipmentSpeedCompatibility"
    SORT_CLASS_EQUIPMENT_STATEFUL = "equipmentStateful"
    SORT_CLASS_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    SORT_CLASS_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    SORT_CLASS_EQUIPMENT_STORAGE_CONTROLLER_CONFIG = "equipmentStorageControllerConfig"
    SORT_CLASS_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF = "equipmentStorageControllerSlotDef"
    SORT_CLASS_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER = "equipmentStorageEncCapProvider"
    SORT_CLASS_EQUIPMENT_STORAGE_LIMIT_CAP = "equipmentStorageLimitCap"
    SORT_CLASS_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER = "equipmentStorageNvmeSwitchCapProvider"
    SORT_CLASS_EQUIPMENT_STORAGE_NVME_SWITCH_DEF = "equipmentStorageNvmeSwitchDef"
    SORT_CLASS_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER = "equipmentStorageSasExpanderCapProvider"
    SORT_CLASS_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF = "equipmentStorageSasExpanderCapRef"
    SORT_CLASS_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF = "equipmentStorageSasExpanderDef"
    SORT_CLASS_EQUIPMENT_SWITCH_CAP = "equipmentSwitchCap"
    SORT_CLASS_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    SORT_CLASS_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD_FSM = "equipmentSwitchIOCardFsm"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE = "equipmentSwitchIOCardFsmStage"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD_FSM_TASK = "equipmentSwitchIOCardFsmTask"
    SORT_CLASS_EQUIPMENT_SWITCH_TYPE_DEF = "equipmentSwitchTypeDef"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM = "equipmentSystemIOControllerFsm"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE = "equipmentSystemIOControllerFsmStage"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK = "equipmentSystemIOControllerFsmTask"
    SORT_CLASS_EQUIPMENT_TIER = "equipmentTier"
    SORT_CLASS_EQUIPMENT_TPM = "equipmentTpm"
    SORT_CLASS_EQUIPMENT_TPM_CAP_PROVIDER = "equipmentTpmCapProvider"
    SORT_CLASS_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    SORT_CLASS_EQUIPMENT_UUID_FEATURE_CAP = "equipmentUuidFeatureCap"
    SORT_CLASS_EQUIPMENT_VERSION_CONSTRAINT = "equipmentVersionConstraint"
    SORT_CLASS_EQUIPMENT_XCVR = "equipmentXcvr"
    SORT_CLASS_ETHER_CIO_EP = "etherCIoEp"
    SORT_CLASS_ETHER_CONFIG = "etherConfig"
    SORT_CLASS_ETHER_ERR_STATS = "etherErrStats"
    SORT_CLASS_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    SORT_CLASS_ETHER_EXTERNAL_EP = "etherExternalEp"
    SORT_CLASS_ETHER_EXTERNAL_PC = "etherExternalPc"
    SORT_CLASS_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    SORT_CLASS_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    SORT_CLASS_ETHER_IF_CONFIG = "etherIfConfig"
    SORT_CLASS_ETHER_INT_FIO_EP = "etherIntFIoEp"
    SORT_CLASS_ETHER_INTERNAL_PC = "etherInternalPc"
    SORT_CLASS_ETHER_LOSS_STATS = "etherLossStats"
    SORT_CLASS_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    SORT_CLASS_ETHER_NI_ERR_STATS = "etherNiErrStats"
    SORT_CLASS_ETHER_NI_ERR_STATS_HIST = "etherNiErrStatsHist"
    SORT_CLASS_ETHER_NIC_IF_CONFIG = "etherNicIfConfig"
    SORT_CLASS_ETHER_PIO = "etherPIo"
    SORT_CLASS_ETHER_PIO_END_POINT = "etherPIoEndPoint"
    SORT_CLASS_ETHER_PIO_EP = "etherPIoEp"
    SORT_CLASS_ETHER_PIO_FSM = "etherPIoFsm"
    SORT_CLASS_ETHER_PIO_FSM_STAGE = "etherPIoFsmStage"
    SORT_CLASS_ETHER_PAUSE_STATS = "etherPauseStats"
    SORT_CLASS_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    SORT_CLASS_ETHER_PC = "etherPc"
    SORT_CLASS_ETHER_PORT_CHAN_ID_ELEM = "etherPortChanIdElem"
    SORT_CLASS_ETHER_PORT_CHAN_ID_UNIVERSE = "etherPortChanIdUniverse"
    SORT_CLASS_ETHER_RX_STATS = "etherRxStats"
    SORT_CLASS_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    SORT_CLASS_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    SORT_CLASS_ETHER_SERVER_INT_FIO_FSM = "etherServerIntFIoFsm"
    SORT_CLASS_ETHER_SERVER_INT_FIO_FSM_STAGE = "etherServerIntFIoFsmStage"
    SORT_CLASS_ETHER_SERVER_INT_FIO_FSM_TASK = "etherServerIntFIoFsmTask"
    SORT_CLASS_ETHER_SERVER_INT_FIO_PC = "etherServerIntFIoPc"
    SORT_CLASS_ETHER_SERVER_INT_FIO_PC_EP = "etherServerIntFIoPcEp"
    SORT_CLASS_ETHER_SW_IF_CONFIG = "etherSwIfConfig"
    SORT_CLASS_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    SORT_CLASS_ETHER_SWITCH_INT_FIO_PC = "etherSwitchIntFIoPc"
    SORT_CLASS_ETHER_SWITCH_INT_FIO_PC_EP = "etherSwitchIntFIoPcEp"
    SORT_CLASS_ETHER_TX_STATS = "etherTxStats"
    SORT_CLASS_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    SORT_CLASS_EVENT_EP_CTRL = "eventEpCtrl"
    SORT_CLASS_EVENT_HOLDER = "eventHolder"
    SORT_CLASS_EVENT_INST = "eventInst"
    SORT_CLASS_EVENT_LOG = "eventLog"
    SORT_CLASS_EVENT_POLICY = "eventPolicy"
    SORT_CLASS_EVENT_RECORD = "eventRecord"
    SORT_CLASS_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    SORT_CLASS_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    SORT_CLASS_EXTMGMT_IF = "extmgmtIf"
    SORT_CLASS_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    SORT_CLASS_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    SORT_CLASS_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    SORT_CLASS_EXTPOL_CLIENT = "extpolClient"
    SORT_CLASS_EXTPOL_CLIENT_CONT = "extpolClientCont"
    SORT_CLASS_EXTPOL_CONNECTOR = "extpolConnector"
    SORT_CLASS_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    SORT_CLASS_EXTPOL_CONTROLLER = "extpolController"
    SORT_CLASS_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    SORT_CLASS_EXTPOL_EP = "extpolEp"
    SORT_CLASS_EXTPOL_EP_FSM = "extpolEpFsm"
    SORT_CLASS_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    SORT_CLASS_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    SORT_CLASS_EXTPOL_PROVIDER = "extpolProvider"
    SORT_CLASS_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    SORT_CLASS_EXTPOL_PROVIDER_FSM = "extpolProviderFsm"
    SORT_CLASS_EXTPOL_PROVIDER_FSM_STAGE = "extpolProviderFsmStage"
    SORT_CLASS_EXTPOL_PROVIDER_FSM_TASK = "extpolProviderFsmTask"
    SORT_CLASS_EXTPOL_REGISTRY = "extpolRegistry"
    SORT_CLASS_EXTPOL_REGISTRY_FSM = "extpolRegistryFsm"
    SORT_CLASS_EXTPOL_REGISTRY_FSM_STAGE = "extpolRegistryFsmStage"
    SORT_CLASS_EXTPOL_REGISTRY_FSM_TASK = "extpolRegistryFsmTask"
    SORT_CLASS_EXTPOL_SVC = "extpolSvc"
    SORT_CLASS_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    SORT_CLASS_EXTVMM_EP = "extvmmEp"
    SORT_CLASS_EXTVMM_EP_FSM = "extvmmEpFsm"
    SORT_CLASS_EXTVMM_EP_FSM_STAGE = "extvmmEpFsmStage"
    SORT_CLASS_EXTVMM_EP_FSM_TASK = "extvmmEpFsmTask"
    SORT_CLASS_EXTVMM_FNDREFERENCE = "extvmmFNDReference"
    SORT_CLASS_EXTVMM_FABRIC_NETWORK = "extvmmFabricNetwork"
    SORT_CLASS_EXTVMM_FABRIC_NETWORK_DEFINITION = "extvmmFabricNetworkDefinition"
    SORT_CLASS_EXTVMM_KEY_INST = "extvmmKeyInst"
    SORT_CLASS_EXTVMM_KEY_RING = "extvmmKeyRing"
    SORT_CLASS_EXTVMM_KEY_STORE = "extvmmKeyStore"
    SORT_CLASS_EXTVMM_KEY_STORE_FSM = "extvmmKeyStoreFsm"
    SORT_CLASS_EXTVMM_KEY_STORE_FSM_STAGE = "extvmmKeyStoreFsmStage"
    SORT_CLASS_EXTVMM_KEY_STORE_FSM_TASK = "extvmmKeyStoreFsmTask"
    SORT_CLASS_EXTVMM_MASTER_EXT_KEY = "extvmmMasterExtKey"
    SORT_CLASS_EXTVMM_MASTER_EXT_KEY_FSM = "extvmmMasterExtKeyFsm"
    SORT_CLASS_EXTVMM_MASTER_EXT_KEY_FSM_STAGE = "extvmmMasterExtKeyFsmStage"
    SORT_CLASS_EXTVMM_MASTER_EXT_KEY_FSM_TASK = "extvmmMasterExtKeyFsmTask"
    SORT_CLASS_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    SORT_CLASS_EXTVMM_NETWORK_SETS_FSM = "extvmmNetworkSetsFsm"
    SORT_CLASS_EXTVMM_NETWORK_SETS_FSM_STAGE = "extvmmNetworkSetsFsmStage"
    SORT_CLASS_EXTVMM_NETWORK_SETS_FSM_TASK = "extvmmNetworkSetsFsmTask"
    SORT_CLASS_EXTVMM_PROVIDER = "extvmmProvider"
    SORT_CLASS_EXTVMM_PROVIDER_FSM = "extvmmProviderFsm"
    SORT_CLASS_EXTVMM_PROVIDER_FSM_STAGE = "extvmmProviderFsmStage"
    SORT_CLASS_EXTVMM_PROVIDER_FSM_TASK = "extvmmProviderFsmTask"
    SORT_CLASS_EXTVMM_SWITCH_DEL_TASK = "extvmmSwitchDelTask"
    SORT_CLASS_EXTVMM_SWITCH_DEL_TASK_FSM = "extvmmSwitchDelTaskFsm"
    SORT_CLASS_EXTVMM_SWITCH_DEL_TASK_FSM_STAGE = "extvmmSwitchDelTaskFsmStage"
    SORT_CLASS_EXTVMM_SWITCH_DEL_TASK_FSM_TASK = "extvmmSwitchDelTaskFsmTask"
    SORT_CLASS_EXTVMM_SWITCH_SET = "extvmmSwitchSet"
    SORT_CLASS_EXTVMM_UP_LINK_PP = "extvmmUpLinkPP"
    SORT_CLASS_EXTVMM_VMNDREF = "extvmmVMNDRef"
    SORT_CLASS_EXTVMM_VMNETWORK = "extvmmVMNetwork"
    SORT_CLASS_EXTVMM_VMNETWORK_DEFINITION = "extvmmVMNetworkDefinition"
    SORT_CLASS_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    SORT_CLASS_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    SORT_CLASS_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    SORT_CLASS_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    SORT_CLASS_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    SORT_CLASS_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    SORT_CLASS_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    SORT_CLASS_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    SORT_CLASS_FABRIC_ANET_GROUP = "fabricANetGroup"
    SORT_CLASS_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    SORT_CLASS_FABRIC_ASAN_GROUP = "fabricASanGroup"
    SORT_CLASS_FABRIC_AVLAN = "fabricAVlan"
    SORT_CLASS_FABRIC_AVSAN = "fabricAVsan"
    SORT_CLASS_FABRIC_BHVLAN = "fabricBHVlan"
    SORT_CLASS_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    SORT_CLASS_FABRIC_BREAKOUT = "fabricBreakout"
    SORT_CLASS_FABRIC_CIO_EP = "fabricCIoEp"
    SORT_CLASS_FABRIC_CABLING = "fabricCabling"
    SORT_CLASS_FABRIC_CABLING_SW = "fabricCablingSw"
    SORT_CLASS_FABRIC_CARTRIDGE_PH_EP = "fabricCartridgePhEp"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP_FSM = "fabricCartridgeSlotEpFsm"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP_FSM_STAGE = "fabricCartridgeSlotEpFsmStage"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP_FSM_TASK = "fabricCartridgeSlotEpFsmTask"
    SORT_CLASS_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    SORT_CLASS_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    SORT_CLASS_FABRIC_CHASSIS_EP = "fabricChassisEp"
    SORT_CLASS_FABRIC_CLOUD = "fabricCloud"
    SORT_CLASS_FABRIC_COMPUTE_EP = "fabricComputeEp"
    SORT_CLASS_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    SORT_CLASS_FABRIC_COMPUTE_MSLOT_EP_FSM = "fabricComputeMSlotEpFsm"
    SORT_CLASS_FABRIC_COMPUTE_MSLOT_EP_FSM_STAGE = "fabricComputeMSlotEpFsmStage"
    SORT_CLASS_FABRIC_COMPUTE_MSLOT_EP_FSM_TASK = "fabricComputeMSlotEpFsmTask"
    SORT_CLASS_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP_FSM = "fabricComputeSlotEpFsm"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP_FSM_STAGE = "fabricComputeSlotEpFsmStage"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP_FSM_TASK = "fabricComputeSlotEpFsmTask"
    SORT_CLASS_FABRIC_DCE_SRV = "fabricDceSrv"
    SORT_CLASS_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    SORT_CLASS_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    SORT_CLASS_FABRIC_DOMAIN = "fabricDomain"
    SORT_CLASS_FABRIC_EP = "fabricEp"
    SORT_CLASS_FABRIC_EP_MGR = "fabricEpMgr"
    SORT_CLASS_FABRIC_EP_MGR_FSM = "fabricEpMgrFsm"
    SORT_CLASS_FABRIC_EP_MGR_FSM_STAGE = "fabricEpMgrFsmStage"
    SORT_CLASS_FABRIC_EP_MGR_FSM_TASK = "fabricEpMgrFsmTask"
    SORT_CLASS_FABRIC_EP_VLAN = "fabricEpVlan"
    SORT_CLASS_FABRIC_EP_VSAN = "fabricEpVsan"
    SORT_CLASS_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    SORT_CLASS_FABRIC_ESTC_EP = "fabricEstcEp"
    SORT_CLASS_FABRIC_ESTC_PC = "fabricEstcPc"
    SORT_CLASS_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    SORT_CLASS_FABRIC_ETH_ESTC = "fabricEthEstc"
    SORT_CLASS_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    SORT_CLASS_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    SORT_CLASS_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    SORT_CLASS_FABRIC_ETH_FLOW_MON_LAN = "fabricEthFlowMonLan"
    SORT_CLASS_FABRIC_ETH_FLOW_MON_SRC_REF = "fabricEthFlowMonSrcRef"
    SORT_CLASS_FABRIC_ETH_LAN = "fabricEthLan"
    SORT_CLASS_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MON = "fabricEthLanFlowMon"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MON_COLLECTOR = "fabricEthLanFlowMonCollector"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MON_EXPORTER = "fabricEthLanFlowMonExporter"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MON_SRC_EP = "fabricEthLanFlowMonSrcEp"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MONITOR = "fabricEthLanFlowMonitor"
    SORT_CLASS_FABRIC_ETH_LAN_FLOW_MONITORING = "fabricEthLanFlowMonitoring"
    SORT_CLASS_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    SORT_CLASS_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    SORT_CLASS_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    SORT_CLASS_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    SORT_CLASS_FABRIC_ETH_MON = "fabricEthMon"
    SORT_CLASS_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    SORT_CLASS_FABRIC_ETH_MON_FILT_EP = "fabricEthMonFiltEp"
    SORT_CLASS_FABRIC_ETH_MON_FILT_REF = "fabricEthMonFiltRef"
    SORT_CLASS_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    SORT_CLASS_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    SORT_CLASS_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    SORT_CLASS_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    SORT_CLASS_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    SORT_CLASS_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    SORT_CLASS_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    SORT_CLASS_FABRIC_EXTERNAL = "fabricExternal"
    SORT_CLASS_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    SORT_CLASS_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    SORT_CLASS_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    SORT_CLASS_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    SORT_CLASS_FABRIC_FC_ESTC = "fabricFcEstc"
    SORT_CLASS_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    SORT_CLASS_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    SORT_CLASS_FABRIC_FC_MON = "fabricFcMon"
    SORT_CLASS_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    SORT_CLASS_FABRIC_FC_MON_FILT_EP = "fabricFcMonFiltEp"
    SORT_CLASS_FABRIC_FC_MON_FILT_REF = "fabricFcMonFiltRef"
    SORT_CLASS_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    SORT_CLASS_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    SORT_CLASS_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    SORT_CLASS_FABRIC_FC_SAN = "fabricFcSan"
    SORT_CLASS_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    SORT_CLASS_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    SORT_CLASS_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    SORT_CLASS_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    SORT_CLASS_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    SORT_CLASS_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    SORT_CLASS_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    SORT_CLASS_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    SORT_CLASS_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    SORT_CLASS_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    SORT_CLASS_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    SORT_CLASS_FABRIC_FLOW_MON = "fabricFlowMon"
    SORT_CLASS_FABRIC_FLOW_MON_COLLECTOR = "fabricFlowMonCollector"
    SORT_CLASS_FABRIC_FLOW_MON_DEFINITION = "fabricFlowMonDefinition"
    SORT_CLASS_FABRIC_FLOW_MON_EXPORTER = "fabricFlowMonExporter"
    SORT_CLASS_FABRIC_FLOW_MON_EXPORTER_PROFILE = "fabricFlowMonExporterProfile"
    SORT_CLASS_FABRIC_FLOW_MON_ITEM = "fabricFlowMonItem"
    SORT_CLASS_FABRIC_FLOW_MON_SRC_EP = "fabricFlowMonSrcEp"
    SORT_CLASS_FABRIC_FLOW_MON_SRC_REF = "fabricFlowMonSrcRef"
    SORT_CLASS_FABRIC_FLOW_MONITOR = "fabricFlowMonitor"
    SORT_CLASS_FABRIC_FLOW_MONITORING_CATEGORY = "fabricFlowMonitoringCategory"
    SORT_CLASS_FABRIC_IF = "fabricIf"
    SORT_CLASS_FABRIC_INTERNAL = "fabricInternal"
    SORT_CLASS_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    SORT_CLASS_FABRIC_INTERNAL_EP = "fabricInternalEp"
    SORT_CLASS_FABRIC_INTERNAL_PC = "fabricInternalPc"
    SORT_CLASS_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    SORT_CLASS_FABRIC_LAN = "fabricLan"
    SORT_CLASS_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    SORT_CLASS_FABRIC_LAN_CLOUD = "fabricLanCloud"
    SORT_CLASS_FABRIC_LAN_CLOUD_FSM = "fabricLanCloudFsm"
    SORT_CLASS_FABRIC_LAN_CLOUD_FSM_STAGE = "fabricLanCloudFsmStage"
    SORT_CLASS_FABRIC_LAN_CLOUD_FSM_TASK = "fabricLanCloudFsmTask"
    SORT_CLASS_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    SORT_CLASS_FABRIC_LAN_EP = "fabricLanEp"
    SORT_CLASS_FABRIC_LAN_FLOW_MON = "fabricLanFlowMon"
    SORT_CLASS_FABRIC_LAN_FLOW_MON_COLLECTOR = "fabricLanFlowMonCollector"
    SORT_CLASS_FABRIC_LAN_FLOW_MON_EXPORTER = "fabricLanFlowMonExporter"
    SORT_CLASS_FABRIC_LAN_FLOW_MON_SRC_EP = "fabricLanFlowMonSrcEp"
    SORT_CLASS_FABRIC_LAN_FLOW_MONITOR = "fabricLanFlowMonitor"
    SORT_CLASS_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    SORT_CLASS_FABRIC_LAN_PC = "fabricLanPc"
    SORT_CLASS_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    SORT_CLASS_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    SORT_CLASS_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    SORT_CLASS_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    SORT_CLASS_FABRIC_LOCALE = "fabricLocale"
    SORT_CLASS_FABRIC_MON = "fabricMon"
    SORT_CLASS_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    SORT_CLASS_FABRIC_MON_FILT_REF = "fabricMonFiltRef"
    SORT_CLASS_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    SORT_CLASS_FABRIC_MON_SRC_FILT_EP = "fabricMonSrcFiltEp"
    SORT_CLASS_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    SORT_CLASS_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    SORT_CLASS_FABRIC_NET_GROUP = "fabricNetGroup"
    SORT_CLASS_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    SORT_CLASS_FABRIC_NETFLOW_COLLECTOR = "fabricNetflowCollector"
    SORT_CLASS_FABRIC_NETFLOW_IPV4_ADDR = "fabricNetflowIPv4Addr"
    SORT_CLASS_FABRIC_NETFLOW_MON_EXPORTER = "fabricNetflowMonExporter"
    SORT_CLASS_FABRIC_NETFLOW_MON_EXPORTER_REF = "fabricNetflowMonExporterRef"
    SORT_CLASS_FABRIC_NETFLOW_MON_SESSION = "fabricNetflowMonSession"
    SORT_CLASS_FABRIC_NETFLOW_MON_SRC_EP = "fabricNetflowMonSrcEp"
    SORT_CLASS_FABRIC_NETFLOW_MON_SRC_REF = "fabricNetflowMonSrcRef"
    SORT_CLASS_FABRIC_NETFLOW_MONITOR = "fabricNetflowMonitor"
    SORT_CLASS_FABRIC_NETFLOW_MONITOR_REF = "fabricNetflowMonitorRef"
    SORT_CLASS_FABRIC_NETFLOW_TIMEOUT_POLICY = "fabricNetflowTimeoutPolicy"
    SORT_CLASS_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    SORT_CLASS_FABRIC_PIO_EP = "fabricPIoEp"
    SORT_CLASS_FABRIC_PATH = "fabricPath"
    SORT_CLASS_FABRIC_PATH_CONN = "fabricPathConn"
    SORT_CLASS_FABRIC_PATH_EP = "fabricPathEp"
    SORT_CLASS_FABRIC_PIN_GROUP = "fabricPinGroup"
    SORT_CLASS_FABRIC_PIN_TARGET = "fabricPinTarget"
    SORT_CLASS_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    SORT_CLASS_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    SORT_CLASS_FABRIC_RESERVED_VLAN = "fabricReservedVlan"
    SORT_CLASS_FABRIC_RESERVED_VLAN_FSM = "fabricReservedVlanFsm"
    SORT_CLASS_FABRIC_RESERVED_VLAN_FSM_STAGE = "fabricReservedVlanFsmStage"
    SORT_CLASS_FABRIC_RESERVED_VLAN_FSM_TASK = "fabricReservedVlanFsmTask"
    SORT_CLASS_FABRIC_SAN = "fabricSan"
    SORT_CLASS_FABRIC_SAN_CLOUD = "fabricSanCloud"
    SORT_CLASS_FABRIC_SAN_CLOUD_FSM = "fabricSanCloudFsm"
    SORT_CLASS_FABRIC_SAN_CLOUD_FSM_STAGE = "fabricSanCloudFsmStage"
    SORT_CLASS_FABRIC_SAN_CLOUD_FSM_TASK = "fabricSanCloudFsmTask"
    SORT_CLASS_FABRIC_SAN_EP = "fabricSanEp"
    SORT_CLASS_FABRIC_SAN_GROUP = "fabricSanGroup"
    SORT_CLASS_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    SORT_CLASS_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    SORT_CLASS_FABRIC_SAN_PC = "fabricSanPc"
    SORT_CLASS_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    SORT_CLASS_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    SORT_CLASS_FABRIC_SUB_GROUP = "fabricSubGroup"
    SORT_CLASS_FABRIC_SW_CH_EP = "fabricSwChEp"
    SORT_CLASS_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    SORT_CLASS_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    SORT_CLASS_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    SORT_CLASS_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    SORT_CLASS_FABRIC_TARGET_EP = "fabricTargetEp"
    SORT_CLASS_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    SORT_CLASS_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    SORT_CLASS_FABRIC_VCON = "fabricVCon"
    SORT_CLASS_FABRIC_VCON_PROFILE = "fabricVConProfile"
    SORT_CLASS_FABRIC_VLAN = "fabricVlan"
    SORT_CLASS_FABRIC_VLAN_EP = "fabricVlanEp"
    SORT_CLASS_FABRIC_VLAN_GROUP_PERMIT = "fabricVlanGroupPermit"
    SORT_CLASS_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    SORT_CLASS_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    SORT_CLASS_FABRIC_VLAN_REQ = "fabricVlanReq"
    SORT_CLASS_FABRIC_VNET_EP = "fabricVnetEp"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    SORT_CLASS_FABRIC_VNET_GROUP_PERMIT = "fabricVnetGroupPermit"
    SORT_CLASS_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    SORT_CLASS_FABRIC_VNET_PERMIT = "fabricVnetPermit"
    SORT_CLASS_FABRIC_VNET_REQ = "fabricVnetReq"
    SORT_CLASS_FABRIC_VSAN = "fabricVsan"
    SORT_CLASS_FABRIC_VSAN_EP = "fabricVsanEp"
    SORT_CLASS_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    SORT_CLASS_FABRIC_ZONE_ID_UNIVERSE = "fabricZoneIdUniverse"
    SORT_CLASS_FAULT_AFFECTED_CLASS = "faultAffectedClass"
    SORT_CLASS_FAULT_BASE_HOLDER = "faultBaseHolder"
    SORT_CLASS_FAULT_BASE_POLICY = "faultBasePolicy"
    SORT_CLASS_FAULT_HOLDER = "faultHolder"
    SORT_CLASS_FAULT_INST = "faultInst"
    SORT_CLASS_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    SORT_CLASS_FAULT_POLICY = "faultPolicy"
    SORT_CLASS_FAULT_SUPPRESS_POLICY = "faultSuppressPolicy"
    SORT_CLASS_FAULT_SUPPRESS_POLICY_ITEM = "faultSuppressPolicyItem"
    SORT_CLASS_FAULT_SUPPRESS_TASK = "faultSuppressTask"
    SORT_CLASS_FC_CONFIG = "fcConfig"
    SORT_CLASS_FC_ERR_STATS = "fcErrStats"
    SORT_CLASS_FC_ERR_STATS_HIST = "fcErrStatsHist"
    SORT_CLASS_FC_IF_CONFIG = "fcIfConfig"
    SORT_CLASS_FC_NIC_IF_CONFIG = "fcNicIfConfig"
    SORT_CLASS_FC_PIO = "fcPIo"
    SORT_CLASS_FC_PIO_FSM = "fcPIoFsm"
    SORT_CLASS_FC_PIO_FSM_STAGE = "fcPIoFsmStage"
    SORT_CLASS_FC_STATS = "fcStats"
    SORT_CLASS_FC_STATS_HIST = "fcStatsHist"
    SORT_CLASS_FC_SW_IF_CONFIG = "fcSwIfConfig"
    SORT_CLASS_FCPOOL_ADDR = "fcpoolAddr"
    SORT_CLASS_FCPOOL_BLOCK = "fcpoolBlock"
    SORT_CLASS_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    SORT_CLASS_FCPOOL_FORMAT = "fcpoolFormat"
    SORT_CLASS_FCPOOL_INITIATOR = "fcpoolInitiator"
    SORT_CLASS_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    SORT_CLASS_FCPOOL_INITIATORS = "fcpoolInitiators"
    SORT_CLASS_FCPOOL_OUI = "fcpoolOui"
    SORT_CLASS_FCPOOL_OUIS = "fcpoolOuis"
    SORT_CLASS_FCPOOL_OUIS_FSM = "fcpoolOuisFsm"
    SORT_CLASS_FCPOOL_OUIS_FSM_STAGE = "fcpoolOuisFsmStage"
    SORT_CLASS_FCPOOL_OUIS_FSM_TASK = "fcpoolOuisFsmTask"
    SORT_CLASS_FCPOOL_POOLABLE = "fcpoolPoolable"
    SORT_CLASS_FCPOOL_UNIVERSE = "fcpoolUniverse"
    SORT_CLASS_FEATURE_BASE_REF = "featureBaseRef"
    SORT_CLASS_FEATURE_CONTEXT_EP = "featureContextEp"
    SORT_CLASS_FEATURE_DEFINITION = "featureDefinition"
    SORT_CLASS_FEATURE_DEFINITION_INSTANCE = "featureDefinitionInstance"
    SORT_CLASS_FEATURE_DEFINITION_REF = "featureDefinitionRef"
    SORT_CLASS_FEATURE_FRU_CAP_PROVIDER_INSTANCE = "featureFruCapProviderInstance"
    SORT_CLASS_FEATURE_FRU_CAP_PROVIDER_REF = "featureFruCapProviderRef"
    SORT_CLASS_FEATURE_PROVIDER = "featureProvider"
    SORT_CLASS_FEATURE_PROVIDER_INSTANCE = "featureProviderInstance"
    SORT_CLASS_FIRMWARE_ABUNDLE_TYPE_CAP_PROVIDER = "firmwareABundleTypeCapProvider"
    SORT_CLASS_FIRMWARE_ACHASSIS_CONSTRAINT = "firmwareAChassisConstraint"
    SORT_CLASS_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    SORT_CLASS_FIRMWARE_ACONSTRAINT = "firmwareAConstraint"
    SORT_CLASS_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    SORT_CLASS_FIRMWARE_ACK = "firmwareAck"
    SORT_CLASS_FIRMWARE_ACTIVITY = "firmwareActivity"
    SORT_CLASS_FIRMWARE_ACTIVITY_TRIGGER = "firmwareActivityTrigger"
    SORT_CLASS_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    SORT_CLASS_FIRMWARE_BACKUP_VERSION_HOLDER = "firmwareBackupVersionHolder"
    SORT_CLASS_FIRMWARE_BLADE = "firmwareBlade"
    SORT_CLASS_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    SORT_CLASS_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    SORT_CLASS_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    SORT_CLASS_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    SORT_CLASS_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    SORT_CLASS_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    SORT_CLASS_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    SORT_CLASS_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    SORT_CLASS_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    SORT_CLASS_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    SORT_CLASS_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    SORT_CLASS_FIRMWARE_CHASSIS_PACK_MOD_IMPACT = "firmwareChassisPackModImpact"
    SORT_CLASS_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    SORT_CLASS_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    SORT_CLASS_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    SORT_CLASS_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    SORT_CLASS_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    SORT_CLASS_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    SORT_CLASS_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    SORT_CLASS_FIRMWARE_CONNECTION_MANAGEMENT_CHASSIS_CONSTRAINT = "firmwareConnectionManagementChassisConstraint"
    SORT_CLASS_FIRMWARE_CONSTRAINTS = "firmwareConstraints"
    SORT_CLASS_FIRMWARE_DEPENDENCY = "firmwareDependency"
    SORT_CLASS_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    SORT_CLASS_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    SORT_CLASS_FIRMWARE_DRIVE_SECURITY_CONSTRAINT = "firmwareDriveSecurityConstraint"
    SORT_CLASS_FIRMWARE_DUAL_VIC_CHASSIS_CONSTRAINT = "firmwareDualVicChassisConstraint"
    SORT_CLASS_FIRMWARE_DUAL_VIC_SERVER_CONSTRAINT = "firmwareDualVicServerConstraint"
    SORT_CLASS_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    SORT_CLASS_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    SORT_CLASS_FIRMWARE_FILE_UNIT = "firmwareFileUnit"
    SORT_CLASS_FIRMWARE_HOST = "firmwareHost"
    SORT_CLASS_FIRMWARE_HOST_PACK_MOD_IMPACT = "firmwareHostPackModImpact"
    SORT_CLASS_FIRMWARE_IMAGE = "firmwareImage"
    SORT_CLASS_FIRMWARE_IMAGE_FSM = "firmwareImageFsm"
    SORT_CLASS_FIRMWARE_IMAGE_FSM_STAGE = "firmwareImageFsmStage"
    SORT_CLASS_FIRMWARE_IMAGE_FSM_TASK = "firmwareImageFsmTask"
    SORT_CLASS_FIRMWARE_IMAGE_LOCK = "firmwareImageLock"
    SORT_CLASS_FIRMWARE_INFRA = "firmwareInfra"
    SORT_CLASS_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    SORT_CLASS_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    SORT_CLASS_FIRMWARE_INSTALLABLE = "firmwareInstallable"
    SORT_CLASS_FIRMWARE_MODULE = "firmwareModule"
    SORT_CLASS_FIRMWARE_PCHSTORAGE_CONFIG_CONSTRAINT = "firmwarePCHStorageConfigConstraint"
    SORT_CLASS_FIRMWARE_PACK = "firmwarePack"
    SORT_CLASS_FIRMWARE_PACK_ITEM = "firmwarePackItem"
    SORT_CLASS_FIRMWARE_PLATFORM_BUNDLE_TYPE_CAP_PROVIDER = "firmwarePlatformBundleTypeCapProvider"
    SORT_CLASS_FIRMWARE_PROCESSOR_TYPE_CONSTRAINT = "firmwareProcessorTypeConstraint"
    SORT_CLASS_FIRMWARE_RACK = "firmwareRack"
    SORT_CLASS_FIRMWARE_RACK_POWER_CAP_CONSTRAINT = "firmwareRackPowerCapConstraint"
    SORT_CLASS_FIRMWARE_RUNNING = "firmwareRunning"
    SORT_CLASS_FIRMWARE_SECOND_CONTROLLER_CHASSIS_CONSTRAINT = "firmwareSecondControllerChassisConstraint"
    SORT_CLASS_FIRMWARE_SECOND_CONTROLLER_SERVER_CONSTRAINT = "firmwareSecondControllerServerConstraint"
    SORT_CLASS_FIRMWARE_SECURE_FPGA = "firmwareSecureFPGA"
    SORT_CLASS_FIRMWARE_SERVER_CHASSIS_CONSTRAINT = "firmwareServerChassisConstraint"
    SORT_CLASS_FIRMWARE_SERVER_TYPE_CONSTRAINT = "firmwareServerTypeConstraint"
    SORT_CLASS_FIRMWARE_SERVICE_PACK = "firmwareServicePack"
    SORT_CLASS_FIRMWARE_SINGLE_PATH_CHASSIS_CONSTRAINT = "firmwareSinglePathChassisConstraint"
    SORT_CLASS_FIRMWARE_SPEC = "firmwareSpec"
    SORT_CLASS_FIRMWARE_STATUS = "firmwareStatus"
    SORT_CLASS_FIRMWARE_SYSTEM = "firmwareSystem"
    SORT_CLASS_FIRMWARE_SYSTEM_COMP_CHECK_RESULT = "firmwareSystemCompCheckResult"
    SORT_CLASS_FIRMWARE_SYSTEM_FSM = "firmwareSystemFsm"
    SORT_CLASS_FIRMWARE_SYSTEM_FSM_STAGE = "firmwareSystemFsmStage"
    SORT_CLASS_FIRMWARE_SYSTEM_FSM_TASK = "firmwareSystemFsmTask"
    SORT_CLASS_FIRMWARE_TPMCONSTRAINT = "firmwareTPMConstraint"
    SORT_CLASS_FIRMWARE_TYPE = "firmwareType"
    SORT_CLASS_FIRMWARE_UCSC_INFO = "firmwareUcscInfo"
    SORT_CLASS_FIRMWARE_UNIT = "firmwareUnit"
    SORT_CLASS_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    SORT_CLASS_FIRMWARE_UPGRADE_CONSTRAINT = "firmwareUpgradeConstraint"
    SORT_CLASS_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    SORT_CLASS_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    SORT_CLASS_FIRMWARE_VIC_SLOT_CONSTRAINT = "firmwareVicSlotConstraint"
    SORT_CLASS_FIRMWARE_VNIC_CDN_CONSTRAINT = "firmwareVnicCdnConstraint"
    SORT_CLASS_FIRMWARE_WATERBAY_SIOC_SERVER_CONSTRAINT = "firmwareWaterbaySiocServerConstraint"
    SORT_CLASS_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    SORT_CLASS_FLOWCTRL_ITEM = "flowctrlItem"
    SORT_CLASS_FSM_FSM = "fsmFsm"
    SORT_CLASS_FSM_STAGE = "fsmStage"
    SORT_CLASS_FSM_STATUS = "fsmStatus"
    SORT_CLASS_FSM_TASK = "fsmTask"
    SORT_CLASS_GMETA_CLASS = "gmetaClass"
    SORT_CLASS_GMETA_EP = "gmetaEp"
    SORT_CLASS_GMETA_HOLDER = "gmetaHolder"
    SORT_CLASS_GMETA_HOLDER_FSM = "gmetaHolderFsm"
    SORT_CLASS_GMETA_HOLDER_FSM_STAGE = "gmetaHolderFsmStage"
    SORT_CLASS_GMETA_HOLDER_FSM_TASK = "gmetaHolderFsmTask"
    SORT_CLASS_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    SORT_CLASS_GMETA_POLICY_MAP_HOLDER = "gmetaPolicyMapHolder"
    SORT_CLASS_GMETA_PROP = "gmetaProp"
    SORT_CLASS_GRAPHICS_CARD = "graphicsCard"
    SORT_CLASS_GRAPHICS_CONTROLLER = "graphicsController"
    SORT_CLASS_HOSTIMG_POLICY = "hostimgPolicy"
    SORT_CLASS_HOSTIMG_TARGET = "hostimgTarget"
    SORT_CLASS_IDENT_IDENT_CTX = "identIdentCtx"
    SORT_CLASS_IDENT_IDENT_REQUEST = "identIdentRequest"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    SORT_CLASS_IDENT_META_SYSTEM = "identMetaSystem"
    SORT_CLASS_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    SORT_CLASS_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    SORT_CLASS_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    SORT_CLASS_IDENT_META_VERSE = "identMetaVerse"
    SORT_CLASS_IDENT_REQUEST_EP = "identRequestEp"
    SORT_CLASS_IDENT_SYS_INFO = "identSysInfo"
    SORT_CLASS_IMGPROV_POLICY = "imgprovPolicy"
    SORT_CLASS_IMGPROV_TARGET = "imgprovTarget"
    SORT_CLASS_IMGSEC_KEY = "imgsecKey"
    SORT_CLASS_IMGSEC_POLICY = "imgsecPolicy"
    SORT_CLASS_INITIATOR_EP = "initiatorEp"
    SORT_CLASS_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    SORT_CLASS_INITIATOR_GROUP_EP = "initiatorGroupEp"
    SORT_CLASS_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    SORT_CLASS_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    SORT_CLASS_INITIATOR_LUN_EP = "initiatorLunEp"
    SORT_CLASS_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    SORT_CLASS_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    SORT_CLASS_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    SORT_CLASS_INITIATOR_STORE_EP = "initiatorStoreEp"
    SORT_CLASS_INITIATOR_UNIT_EP = "initiatorUnitEp"
    SORT_CLASS_IP_DNS_SUFFIX = "ipDnsSuffix"
    SORT_CLASS_IP_IPV4_DNS = "ipIPv4Dns"
    SORT_CLASS_IP_IPV4_WINS_SERVER = "ipIPv4WinsServer"
    SORT_CLASS_IP_IP_V4_ADDR = "ipIpV4Addr"
    SORT_CLASS_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    SORT_CLASS_IP_IP_V4_STATIC_TARGET_ADDR = "ipIpV4StaticTargetAddr"
    SORT_CLASS_IP_SERVICE_IF = "ipServiceIf"
    SORT_CLASS_IPPOOL_ADDR = "ippoolAddr"
    SORT_CLASS_IPPOOL_BLOCK = "ippoolBlock"
    SORT_CLASS_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    SORT_CLASS_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    SORT_CLASS_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    SORT_CLASS_IPPOOL_POOL = "ippoolPool"
    SORT_CLASS_IPPOOL_POOLABLE = "ippoolPoolable"
    SORT_CLASS_IPPOOL_POOLED = "ippoolPooled"
    SORT_CLASS_IPPOOL_UNIVERSE = "ippoolUniverse"
    SORT_CLASS_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    SORT_CLASS_IQNPOOL_ADDR = "iqnpoolAddr"
    SORT_CLASS_IQNPOOL_BLOCK = "iqnpoolBlock"
    SORT_CLASS_IQNPOOL_FORMAT = "iqnpoolFormat"
    SORT_CLASS_IQNPOOL_POOL = "iqnpoolPool"
    SORT_CLASS_IQNPOOL_POOLABLE = "iqnpoolPoolable"
    SORT_CLASS_IQNPOOL_POOLED = "iqnpoolPooled"
    SORT_CLASS_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    SORT_CLASS_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    SORT_CLASS_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    SORT_CLASS_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    SORT_CLASS_LICENSE_CONTENTS = "licenseContents"
    SORT_CLASS_LICENSE_DOWNLOADER = "licenseDownloader"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    SORT_CLASS_LICENSE_EP = "licenseEp"
    SORT_CLASS_LICENSE_FEATURE = "licenseFeature"
    SORT_CLASS_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    SORT_CLASS_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    SORT_CLASS_LICENSE_FILE = "licenseFile"
    SORT_CLASS_LICENSE_FILE_FSM = "licenseFileFsm"
    SORT_CLASS_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    SORT_CLASS_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    SORT_CLASS_LICENSE_INSTANCE = "licenseInstance"
    SORT_CLASS_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    SORT_CLASS_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    SORT_CLASS_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    SORT_CLASS_LICENSE_PROP = "licenseProp"
    SORT_CLASS_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    SORT_CLASS_LICENSE_SOURCE = "licenseSource"
    SORT_CLASS_LICENSE_SOURCE_FILE = "licenseSourceFile"
    SORT_CLASS_LICENSE_TARGET = "licenseTarget"
    SORT_CLASS_LLDP_ACQUIRED = "lldpAcquired"
    SORT_CLASS_LS_AGENT_POLICY = "lsAgentPolicy"
    SORT_CLASS_LS_BINDING = "lsBinding"
    SORT_CLASS_LS_COMPUTE_BINDING = "lsComputeBinding"
    SORT_CLASS_LS_FC_LOCALE = "lsFcLocale"
    SORT_CLASS_LS_FC_ZONE = "lsFcZone"
    SORT_CLASS_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    SORT_CLASS_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    SORT_CLASS_LS_IDENTITY_INFO = "lsIdentityInfo"
    SORT_CLASS_LS_ISSUES = "lsIssues"
    SORT_CLASS_LS_POWER = "lsPower"
    SORT_CLASS_LS_REQUIREMENT = "lsRequirement"
    SORT_CLASS_LS_SERVER = "lsServer"
    SORT_CLASS_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    SORT_CLASS_LS_SERVER_EXTENSION = "lsServerExtension"
    SORT_CLASS_LS_SERVER_FSM = "lsServerFsm"
    SORT_CLASS_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    SORT_CLASS_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    SORT_CLASS_LS_TIER = "lsTier"
    SORT_CLASS_LS_UUID_HISTORY = "lsUuidHistory"
    SORT_CLASS_LS_VCON_ASSIGN = "lsVConAssign"
    SORT_CLASS_LS_VERSION_BEH = "lsVersionBeh"
    SORT_CLASS_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    SORT_CLASS_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    SORT_CLASS_LSBOOT_ADEF = "lsbootADef"
    SORT_CLASS_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    SORT_CLASS_LSBOOT_CATEGORY = "lsbootCategory"
    SORT_CLASS_LSBOOT_DEF = "lsbootDef"
    SORT_CLASS_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    SORT_CLASS_LSBOOT_EFISHELL = "lsbootEFIShell"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    SORT_CLASS_LSBOOT_ISCSI = "lsbootIScsi"
    SORT_CLASS_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    SORT_CLASS_LSBOOT_IMAGE = "lsbootImage"
    SORT_CLASS_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    SORT_CLASS_LSBOOT_ITEM = "lsbootItem"
    SORT_CLASS_LSBOOT_LAN = "lsbootLan"
    SORT_CLASS_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    SORT_CLASS_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    SORT_CLASS_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    SORT_CLASS_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    SORT_CLASS_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    SORT_CLASS_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    SORT_CLASS_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    SORT_CLASS_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    SORT_CLASS_LSBOOT_NVME = "lsbootNvme"
    SORT_CLASS_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    SORT_CLASS_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    SORT_CLASS_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    SORT_CLASS_LSBOOT_POLICY = "lsbootPolicy"
    SORT_CLASS_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    SORT_CLASS_LSBOOT_SAN = "lsbootSan"
    SORT_CLASS_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    SORT_CLASS_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    SORT_CLASS_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    SORT_CLASS_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    SORT_CLASS_LSBOOT_STORAGE = "lsbootStorage"
    SORT_CLASS_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    SORT_CLASS_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    SORT_CLASS_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    SORT_CLASS_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    SORT_CLASS_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    SORT_CLASS_LSMAINT_ACK = "lsmaintAck"
    SORT_CLASS_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    SORT_CLASS_LSTORAGE_ASLOT = "lstorageASlot"
    SORT_CLASS_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    SORT_CLASS_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    SORT_CLASS_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    SORT_CLASS_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    SORT_CLASS_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    SORT_CLASS_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    SORT_CLASS_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    SORT_CLASS_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    SORT_CLASS_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    SORT_CLASS_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    SORT_CLASS_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    SORT_CLASS_LSTORAGE_ITEM = "lstorageItem"
    SORT_CLASS_LSTORAGE_LOCAL = "lstorageLocal"
    SORT_CLASS_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    SORT_CLASS_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    SORT_CLASS_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    SORT_CLASS_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    SORT_CLASS_LSTORAGE_LOGIN = "lstorageLogin"
    SORT_CLASS_LSTORAGE_LUN_SET_CONFIG = "lstorageLunSetConfig"
    SORT_CLASS_LSTORAGE_LUN_SET_DISK_SLOT = "lstorageLunSetDiskSlot"
    SORT_CLASS_LSTORAGE_PROFILE = "lstorageProfile"
    SORT_CLASS_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    SORT_CLASS_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    SORT_CLASS_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    SORT_CLASS_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    SORT_CLASS_LSTORAGE_REMOTE = "lstorageRemote"
    SORT_CLASS_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    SORT_CLASS_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    SORT_CLASS_LSTORAGE_SAS_EXPANDER_CONFIG_POLICY = "lstorageSasExpanderConfigPolicy"
    SORT_CLASS_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    SORT_CLASS_LSTORAGE_SECURITY = "lstorageSecurity"
    SORT_CLASS_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    SORT_CLASS_MACPOOL_ADDR = "macpoolAddr"
    SORT_CLASS_MACPOOL_BLOCK = "macpoolBlock"
    SORT_CLASS_MACPOOL_FORMAT = "macpoolFormat"
    SORT_CLASS_MACPOOL_POOL = "macpoolPool"
    SORT_CLASS_MACPOOL_POOLABLE = "macpoolPoolable"
    SORT_CLASS_MACPOOL_POOLED = "macpoolPooled"
    SORT_CLASS_MACPOOL_UNIVERSE = "macpoolUniverse"
    SORT_CLASS_MEMORY_AUNIT = "memoryAUnit"
    SORT_CLASS_MEMORY_ARRAY = "memoryArray"
    SORT_CLASS_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    SORT_CLASS_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    SORT_CLASS_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    SORT_CLASS_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    SORT_CLASS_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    SORT_CLASS_MEMORY_ERROR_STATS = "memoryErrorStats"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_ANAMESPACE = "memoryPersistentMemoryANamespace"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_CONFIG_RESULT = "memoryPersistentMemoryConfigResult"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_CONFIGURATION = "memoryPersistentMemoryConfiguration"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_GOAL = "memoryPersistentMemoryGoal"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_LOCAL_SECURITY = "memoryPersistentMemoryLocalSecurity"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_LOGICAL_NAMESPACE = "memoryPersistentMemoryLogicalNamespace"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_NAMESPACE = "memoryPersistentMemoryNamespace"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_NAMESPACE_CONFIG_RESULT = "memoryPersistentMemoryNamespaceConfigResult"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_POLICY = "memoryPersistentMemoryPolicy"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_REGION = "memoryPersistentMemoryRegion"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_SECURITY = "memoryPersistentMemorySecurity"
    SORT_CLASS_MEMORY_PERSISTENT_MEMORY_UNIT = "memoryPersistentMemoryUnit"
    SORT_CLASS_MEMORY_QUAL = "memoryQual"
    SORT_CLASS_MEMORY_RUNTIME = "memoryRuntime"
    SORT_CLASS_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    SORT_CLASS_MEMORY_UNIT = "memoryUnit"
    SORT_CLASS_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    SORT_CLASS_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    SORT_CLASS_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    SORT_CLASS_MGMT_ABSTRACT_IF = "mgmtAbstractIf"
    SORT_CLASS_MGMT_ACCESS_POLICY = "mgmtAccessPolicy"
    SORT_CLASS_MGMT_ACCESS_POLICY_ITEM = "mgmtAccessPolicyItem"
    SORT_CLASS_MGMT_ACCESS_PORT = "mgmtAccessPort"
    SORT_CLASS_MGMT_BACKUP = "mgmtBackup"
    SORT_CLASS_MGMT_BACKUP_EXPORT_EXT_POLICY = "mgmtBackupExportExtPolicy"
    SORT_CLASS_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    SORT_CLASS_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    SORT_CLASS_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    SORT_CLASS_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    SORT_CLASS_MGMT_BACKUP_POLICY_CONFIG = "mgmtBackupPolicyConfig"
    SORT_CLASS_MGMT_BACKUP_POLICY_FSM = "mgmtBackupPolicyFsm"
    SORT_CLASS_MGMT_BACKUP_POLICY_FSM_STAGE = "mgmtBackupPolicyFsmStage"
    SORT_CLASS_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    SORT_CLASS_MGMT_CFG_EXPORT_POLICY_FSM = "mgmtCfgExportPolicyFsm"
    SORT_CLASS_MGMT_CFG_EXPORT_POLICY_FSM_STAGE = "mgmtCfgExportPolicyFsmStage"
    SORT_CLASS_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    SORT_CLASS_MGMT_CIMC_SECURE_BOOT = "mgmtCimcSecureBoot"
    SORT_CLASS_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    SORT_CLASS_MGMT_CONNECTION = "mgmtConnection"
    SORT_CLASS_MGMT_CONTROLLER = "mgmtController"
    SORT_CLASS_MGMT_CONTROLLER_FSM = "mgmtControllerFsm"
    SORT_CLASS_MGMT_CONTROLLER_FSM_STAGE = "mgmtControllerFsmStage"
    SORT_CLASS_MGMT_CONTROLLER_FSM_TASK = "mgmtControllerFsmTask"
    SORT_CLASS_MGMT_DB_STATE = "mgmtDbState"
    SORT_CLASS_MGMT_ENTITY = "mgmtEntity"
    SORT_CLASS_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    SORT_CLASS_MGMT_EXPORT_POLICY_FSM = "mgmtExportPolicyFsm"
    SORT_CLASS_MGMT_EXPORT_POLICY_FSM_STAGE = "mgmtExportPolicyFsmStage"
    SORT_CLASS_MGMT_EXPORT_POLICY_FSM_TASK = "mgmtExportPolicyFsmTask"
    SORT_CLASS_MGMT_HEALTH_ATTR = "mgmtHealthAttr"
    SORT_CLASS_MGMT_HEALTH_STATUS = "mgmtHealthStatus"
    SORT_CLASS_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    SORT_CLASS_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    SORT_CLASS_MGMT_IPV6_IF_ADDR_FSM = "mgmtIPv6IfAddrFsm"
    SORT_CLASS_MGMT_IPV6_IF_ADDR_FSM_STAGE = "mgmtIPv6IfAddrFsmStage"
    SORT_CLASS_MGMT_IPV6_IF_ADDR_FSM_TASK = "mgmtIPv6IfAddrFsmTask"
    SORT_CLASS_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    SORT_CLASS_MGMT_IF = "mgmtIf"
    SORT_CLASS_MGMT_IF_FSM = "mgmtIfFsm"
    SORT_CLASS_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    SORT_CLASS_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    SORT_CLASS_MGMT_IMPORTER = "mgmtImporter"
    SORT_CLASS_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    SORT_CLASS_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    SORT_CLASS_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    SORT_CLASS_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    SORT_CLASS_MGMT_INT_AUTH_POLICY = "mgmtIntAuthPolicy"
    SORT_CLASS_MGMT_INTERFACE = "mgmtInterface"
    SORT_CLASS_MGMT_KMIP = "mgmtKmip"
    SORT_CLASS_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    SORT_CLASS_MGMT_KVM_CERTIFICATE = "mgmtKvmCertificate"
    SORT_CLASS_MGMT_LEADER_ENTITY = "mgmtLeaderEntity"
    SORT_CLASS_MGMT_PMON_ENTRY = "mgmtPmonEntry"
    SORT_CLASS_MGMT_PROF_DERIVED_INTERFACE = "mgmtProfDerivedInterface"
    SORT_CLASS_MGMT_SECURITY = "mgmtSecurity"
    SORT_CLASS_MGMT_SPDM_CERTIFICATE = "mgmtSpdmCertificate"
    SORT_CLASS_MGMT_SPDM_CERTIFICATE_DATA = "mgmtSpdmCertificateData"
    SORT_CLASS_MGMT_SPDM_CERTIFICATE_INVENTORY = "mgmtSpdmCertificateInventory"
    SORT_CLASS_MGMT_SPDM_CERTIFICATE_POLICY = "mgmtSpdmCertificatePolicy"
    SORT_CLASS_MGMT_SW_PERSONALITIES = "mgmtSwPersonalities"
    SORT_CLASS_MGMT_SW_PERSONALITIES_INVENTORY = "mgmtSwPersonalitiesInventory"
    SORT_CLASS_MGMT_SW_PERSONALITY = "mgmtSwPersonality"
    SORT_CLASS_MGMT_USB_NIC_MGMT_IF = "mgmtUsbNicMgmtIf"
    SORT_CLASS_MGMT_VNET = "mgmtVnet"
    SORT_CLASS_MO_ABSTRACT_CFG_KV = "moAbstractCfgKv"
    SORT_CLASS_MO_ABSTRACT_INV_KV = "moAbstractInvKv"
    SORT_CLASS_MO_ABSTRACT_KV = "moAbstractKv"
    SORT_CLASS_MO_INV_KV = "moInvKv"
    SORT_CLASS_MO_IP_ADDR_KV = "moIpAddrKv"
    SORT_CLASS_MO_IP_V4_ADDR_KV = "moIpV4AddrKv"
    SORT_CLASS_MO_IP_V6_ADDR_KV = "moIpV6AddrKv"
    SORT_CLASS_MO_KV = "moKv"
    SORT_CLASS_MO_KV_CFG_HOLDER = "moKvCfgHolder"
    SORT_CLASS_MO_KV_INV_HOLDER = "moKvInvHolder"
    SORT_CLASS_MO_TOP_PROPS = "moTopProps"
    SORT_CLASS_MO_VNIC_KV = "moVnicKv"
    SORT_CLASS_MOREF_FRU_REF = "morefFruRef"
    SORT_CLASS_MOREF_IMPORT_ROOT = "morefImportRoot"
    SORT_CLASS_MOREF_IMPORT_ROOT_FSM = "morefImportRootFsm"
    SORT_CLASS_MOREF_IMPORT_ROOT_FSM_STAGE = "morefImportRootFsmStage"
    SORT_CLASS_MOREF_IMPORT_ROOT_FSM_TASK = "morefImportRootFsmTask"
    SORT_CLASS_MOREF_PROP = "morefProp"
    SORT_CLASS_MOREF_REF = "morefRef"
    SORT_CLASS_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    SORT_CLASS_NAMING_NAMED_OBJECT = "namingNamedObject"
    SORT_CLASS_NETWORK_ALAN_NEIGHBOR_ENTRY = "networkALanNeighborEntry"
    SORT_CLASS_NETWORK_ANEIGHBOR_ENTRY = "networkANeighborEntry"
    SORT_CLASS_NETWORK_CIO_EP = "networkCIoEp"
    SORT_CLASS_NETWORK_CONN = "networkConn"
    SORT_CLASS_NETWORK_DOMAIN_EP = "networkDomainEp"
    SORT_CLASS_NETWORK_ELEMENT = "networkElement"
    SORT_CLASS_NETWORK_EP = "networkEp"
    SORT_CLASS_NETWORK_IF_EP = "networkIfEp"
    SORT_CLASS_NETWORK_IF_STATS = "networkIfStats"
    SORT_CLASS_NETWORK_LAN_NEIGHBOR_ENTRY = "networkLanNeighborEntry"
    SORT_CLASS_NETWORK_LAN_NEIGHBORS = "networkLanNeighbors"
    SORT_CLASS_NETWORK_LIMIT = "networkLimit"
    SORT_CLASS_NETWORK_LLDP_NEIGHBOR_ENTRY = "networkLldpNeighborEntry"
    SORT_CLASS_NETWORK_LLDP_NEIGHBORS = "networkLldpNeighbors"
    SORT_CLASS_NETWORK_OPER_LEVEL = "networkOperLevel"
    SORT_CLASS_NETWORK_PIO_EP = "networkPIoEp"
    SORT_CLASS_NETWORK_PHYS_EP = "networkPhysEp"
    SORT_CLASS_NETWORK_SAN_NEIGHBOR_ENTRY = "networkSanNeighborEntry"
    SORT_CLASS_NETWORK_SAN_NEIGHBORS = "networkSanNeighbors"
    SORT_CLASS_NETWORK_VNET_EP = "networkVnetEp"
    SORT_CLASS_NETWORKRULE_DEFINITION = "networkruleDefinition"
    SORT_CLASS_NETWORKRULE_ITEM = "networkruleItem"
    SORT_CLASS_NETWORKRULE_REQUIREMENT = "networkruleRequirement"
    SORT_CLASS_NFS_EP = "nfsEp"
    SORT_CLASS_NFS_MOUNT_DEF = "nfsMountDef"
    SORT_CLASS_NFS_MOUNT_DEF_FSM = "nfsMountDefFsm"
    SORT_CLASS_NFS_MOUNT_DEF_FSM_STAGE = "nfsMountDefFsmStage"
    SORT_CLASS_NFS_MOUNT_DEF_FSM_TASK = "nfsMountDefFsmTask"
    SORT_CLASS_NFS_MOUNT_INST = "nfsMountInst"
    SORT_CLASS_NFS_MOUNT_INST_FSM = "nfsMountInstFsm"
    SORT_CLASS_NFS_MOUNT_INST_FSM_STAGE = "nfsMountInstFsmStage"
    SORT_CLASS_NFS_MOUNT_INST_FSM_TASK = "nfsMountInstFsmTask"
    SORT_CLASS_NWCTRL_DEFINITION = "nwctrlDefinition"
    SORT_CLASS_OBSERVE_FILTER = "observeFilter"
    SORT_CLASS_OBSERVE_OBSERVED = "observeObserved"
    SORT_CLASS_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    SORT_CLASS_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    SORT_CLASS_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    SORT_CLASS_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    SORT_CLASS_ORG_ORG = "orgOrg"
    SORT_CLASS_ORG_SOURCE_MASK = "orgSourceMask"
    SORT_CLASS_OS_ARPLINK_MONITORING_POLICY = "osARPLinkMonitoringPolicy"
    SORT_CLASS_OS_ARPTARGET = "osARPTarget"
    SORT_CLASS_OS_AGENT = "osAgent"
    SORT_CLASS_OS_ETH_BOND_INTF = "osEthBondIntf"
    SORT_CLASS_OS_ETH_BOND_MODE = "osEthBondMode"
    SORT_CLASS_OS_ETH_BOND_MODE_ACTIVE_BACKUP = "osEthBondModeActiveBackup"
    SORT_CLASS_OS_ETH_BOND_MODE_BALANCED_ALB = "osEthBondModeBalancedALB"
    SORT_CLASS_OS_ETH_BOND_MODE_BALANCED_RR = "osEthBondModeBalancedRR"
    SORT_CLASS_OS_ETH_BOND_MODE_BALANCED_TLB = "osEthBondModeBalancedTLB"
    SORT_CLASS_OS_ETH_BOND_MODE_BALANCED_XOR = "osEthBondModeBalancedXOR"
    SORT_CLASS_OS_ETH_BOND_MODE_BROADCAST = "osEthBondModeBroadcast"
    SORT_CLASS_OS_ETH_BOND_MODE_LB = "osEthBondModeLB"
    SORT_CLASS_OS_ETH_INTF = "osEthIntf"
    SORT_CLASS_OS_INSTANCE = "osInstance"
    SORT_CLASS_OS_INTF = "osIntf"
    SORT_CLASS_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    SORT_CLASS_OS_MII_LINK_MONITORING_POLICY = "osMiiLinkMonitoringPolicy"
    SORT_CLASS_OS_PRIMARY_SLAVE = "osPrimarySlave"
    SORT_CLASS_PCI_CARD = "pciCard"
    SORT_CLASS_PCI_EQUIP_SLOT = "pciEquipSlot"
    SORT_CLASS_PCI_LINK = "pciLink"
    SORT_CLASS_PCI_SWITCH = "pciSwitch"
    SORT_CLASS_PCI_UNIT = "pciUnit"
    SORT_CLASS_PFC_WATCH_DOG = "pfcWatchDog"
    SORT_CLASS_PFC_WATCH_DOG_FSM = "pfcWatchDogFsm"
    SORT_CLASS_PFC_WATCH_DOG_FSM_STAGE = "pfcWatchDogFsmStage"
    SORT_CLASS_PFC_WATCH_DOG_FSM_TASK = "pfcWatchDogFsmTask"
    SORT_CLASS_PKI_CERT_REQ = "pkiCertReq"
    SORT_CLASS_PKI_DEFINITION = "pkiDefinition"
    SORT_CLASS_PKI_EP = "pkiEp"
    SORT_CLASS_PKI_EP_FSM = "pkiEpFsm"
    SORT_CLASS_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    SORT_CLASS_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    SORT_CLASS_PKI_ITEM = "pkiItem"
    SORT_CLASS_PKI_KEY_RING = "pkiKeyRing"
    SORT_CLASS_PKI_TP = "pkiTP"
    SORT_CLASS_POLICY_ADEST_EP = "policyADestEp"
    SORT_CLASS_POLICY_BINDING = "policyBinding"
    SORT_CLASS_POLICY_CENTRALE_SYNC = "policyCentraleSync"
    SORT_CLASS_POLICY_CHILD_CLASS = "policyChildClass"
    SORT_CLASS_POLICY_COMMUNICATION = "policyCommunication"
    SORT_CLASS_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    SORT_CLASS_POLICY_CONFIG_ERROR = "policyConfigError"
    SORT_CLASS_POLICY_CONTEXT = "policyContext"
    SORT_CLASS_POLICY_CONTROL = "policyControl"
    SORT_CLASS_POLICY_CONTROL_EP = "policyControlEp"
    SORT_CLASS_POLICY_CONTROL_EP_FSM = "policyControlEpFsm"
    SORT_CLASS_POLICY_CONTROL_EP_FSM_STAGE = "policyControlEpFsmStage"
    SORT_CLASS_POLICY_CONTROL_EP_FSM_TASK = "policyControlEpFsmTask"
    SORT_CLASS_POLICY_CONTROLLED = "policyControlled"
    SORT_CLASS_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    SORT_CLASS_POLICY_CONTROLLED_TYPE = "policyControlledType"
    SORT_CLASS_POLICY_CONTROLLED_TYPE_FSM = "policyControlledTypeFsm"
    SORT_CLASS_POLICY_CONTROLLED_TYPE_FSM_STAGE = "policyControlledTypeFsmStage"
    SORT_CLASS_POLICY_CONTROLLED_TYPE_FSM_TASK = "policyControlledTypeFsmTask"
    SORT_CLASS_POLICY_DATE_TIME = "policyDateTime"
    SORT_CLASS_POLICY_DEFINITION = "policyDefinition"
    SORT_CLASS_POLICY_DEST_CLASS = "policyDestClass"
    SORT_CLASS_POLICY_DEST_EP = "policyDestEp"
    SORT_CLASS_POLICY_DIGEST = "policyDigest"
    SORT_CLASS_POLICY_DISCOVERY = "policyDiscovery"
    SORT_CLASS_POLICY_DNS = "policyDns"
    SORT_CLASS_POLICY_ELEMENT = "policyElement"
    SORT_CLASS_POLICY_EQUIPMENT = "policyEquipment"
    SORT_CLASS_POLICY_FAULT = "policyFault"
    SORT_CLASS_POLICY_HOLDER = "policyHolder"
    SORT_CLASS_POLICY_ID_RESOLVE_POLICY = "policyIdResolvePolicy"
    SORT_CLASS_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    SORT_CLASS_POLICY_ITEM = "policyItem"
    SORT_CLASS_POLICY_LOCAL_MAP = "policyLocalMap"
    SORT_CLASS_POLICY_MEP = "policyMEp"
    SORT_CLASS_POLICY_MONITORING = "policyMonitoring"
    SORT_CLASS_POLICY_OBJECT = "policyObject"
    SORT_CLASS_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    SORT_CLASS_POLICY_POLICY_EP = "policyPolicyEp"
    SORT_CLASS_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    SORT_CLASS_POLICY_POLICY_SCOPE = "policyPolicyScope"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONT_FSM = "policyPolicyScopeContFsm"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONT_FSM_STAGE = "policyPolicyScopeContFsmStage"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONT_FSM_TASK = "policyPolicyScopeContFsmTask"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    SORT_CLASS_POLICY_PORT_CONFIG = "policyPortConfig"
    SORT_CLASS_POLICY_POWER_MGMT = "policyPowerMgmt"
    SORT_CLASS_POLICY_PSU = "policyPsu"
    SORT_CLASS_POLICY_REF_REQ = "policyRefReq"
    SORT_CLASS_POLICY_REQUESTOR = "policyRequestor"
    SORT_CLASS_POLICY_REQUESTOR_FSM = "policyRequestorFsm"
    SORT_CLASS_POLICY_REQUESTOR_FSM_STAGE = "policyRequestorFsmStage"
    SORT_CLASS_POLICY_REQUESTOR_FSM_TASK = "policyRequestorFsmTask"
    SORT_CLASS_POLICY_SCOPE = "policyScope"
    SORT_CLASS_POLICY_SECURITY = "policySecurity"
    SORT_CLASS_POLICY_SOURCE_APP = "policySourceApp"
    SORT_CLASS_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    SORT_CLASS_POLICY_SYSTEM_EP = "policySystemEp"
    SORT_CLASS_POOL_ELEMENT = "poolElement"
    SORT_CLASS_POOL_POOL = "poolPool"
    SORT_CLASS_POOL_POOL_MEMBER = "poolPoolMember"
    SORT_CLASS_POOL_POOLABLE = "poolPoolable"
    SORT_CLASS_POOL_UNIVERSE = "poolUniverse"
    SORT_CLASS_PORT_DOMAIN_EP = "portDomainEp"
    SORT_CLASS_PORT_GROUP = "portGroup"
    SORT_CLASS_PORT_INT_FIO = "portIntFIo"
    SORT_CLASS_PORT_PIO = "portPIo"
    SORT_CLASS_PORT_PIO_FSM = "portPIoFsm"
    SORT_CLASS_PORT_PIO_FSM_STAGE = "portPIoFsmStage"
    SORT_CLASS_PORT_PIO_FSM_TASK = "portPIoFsmTask"
    SORT_CLASS_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    SORT_CLASS_PORT_SERVER_INT_FIO = "portServerIntFIo"
    SORT_CLASS_PORT_SUB_GROUP = "portSubGroup"
    SORT_CLASS_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    SORT_CLASS_PORT_TRUST_MODE = "portTrustMode"
    SORT_CLASS_POWER_ABUDGET = "powerABudget"
    SORT_CLASS_POWER_AGROUP = "powerAGroup"
    SORT_CLASS_POWER_BUDGET = "powerBudget"
    SORT_CLASS_POWER_CHASSIS_MEMBER = "powerChassisMember"
    SORT_CLASS_POWER_EP = "powerEp"
    SORT_CLASS_POWER_FIMEMBER = "powerFIMember"
    SORT_CLASS_POWER_FEX_MEMBER = "powerFexMember"
    SORT_CLASS_POWER_GROUP = "powerGroup"
    SORT_CLASS_POWER_GROUP_ADDITION_POLICY = "powerGroupAdditionPolicy"
    SORT_CLASS_POWER_GROUP_MEMBER = "powerGroupMember"
    SORT_CLASS_POWER_GROUP_QUAL = "powerGroupQual"
    SORT_CLASS_POWER_GROUP_STATS = "powerGroupStats"
    SORT_CLASS_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    SORT_CLASS_POWER_MGMT_POLICY = "powerMgmtPolicy"
    SORT_CLASS_POWER_PLACEMENT = "powerPlacement"
    SORT_CLASS_POWER_POLICY = "powerPolicy"
    SORT_CLASS_POWER_PRIO_WGHT = "powerPrioWght"
    SORT_CLASS_POWER_PROFILED_POWER = "powerProfiledPower"
    SORT_CLASS_POWER_RACK_UNIT_MEMBER = "powerRackUnitMember"
    SORT_CLASS_PROC_DOER = "procDoer"
    SORT_CLASS_PROC_MANAGER = "procManager"
    SORT_CLASS_PROC_PROC_COUNTS = "procProcCounts"
    SORT_CLASS_PROC_PROCS = "procProcs"
    SORT_CLASS_PROC_PRT = "procPrt"
    SORT_CLASS_PROC_PRT_COUNTS = "procPrtCounts"
    SORT_CLASS_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    SORT_CLASS_PROC_SVC = "procSvc"
    SORT_CLASS_PROC_TX_COUNTS = "procTxCounts"
    SORT_CLASS_PROCESSOR_CACHE_MEM_STATS = "processorCacheMemStats"
    SORT_CLASS_PROCESSOR_COMPONENT = "processorComponent"
    SORT_CLASS_PROCESSOR_CORE = "processorCore"
    SORT_CLASS_PROCESSOR_ENV_STATS = "processorEnvStats"
    SORT_CLASS_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    SORT_CLASS_PROCESSOR_ERROR_STATS = "processorErrorStats"
    SORT_CLASS_PROCESSOR_EXEC_STATS = "processorExecStats"
    SORT_CLASS_PROCESSOR_IOSTATS = "processorIOStats"
    SORT_CLASS_PROCESSOR_MISC_STATS = "processorMiscStats"
    SORT_CLASS_PROCESSOR_PCIBUS_STATS = "processorPCIBusStats"
    SORT_CLASS_PROCESSOR_PMUSTATS = "processorPMUStats"
    SORT_CLASS_PROCESSOR_QUAL = "processorQual"
    SORT_CLASS_PROCESSOR_RUNTIME = "processorRuntime"
    SORT_CLASS_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    SORT_CLASS_PROCESSOR_SECURITY_STATS = "processorSecurityStats"
    SORT_CLASS_PROCESSOR_THREAD = "processorThread"
    SORT_CLASS_PROCESSOR_UNIT = "processorUnit"
    SORT_CLASS_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    SORT_CLASS_QOS_DEFINITION = "qosDefinition"
    SORT_CLASS_QOS_ITEM = "qosItem"
    SORT_CLASS_QOSCLASS_DEFINITION = "qosclassDefinition"
    SORT_CLASS_QOSCLASS_DEFINITION_FSM = "qosclassDefinitionFsm"
    SORT_CLASS_QOSCLASS_DEFINITION_FSM_STAGE = "qosclassDefinitionFsmStage"
    SORT_CLASS_QOSCLASS_DEFINITION_FSM_TASK = "qosclassDefinitionFsmTask"
    SORT_CLASS_QOSCLASS_ETH = "qosclassEth"
    SORT_CLASS_QOSCLASS_ETH_BE = "qosclassEthBE"
    SORT_CLASS_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    SORT_CLASS_QOSCLASS_FC = "qosclassFc"
    SORT_CLASS_QOSCLASS_ITEM = "qosclassItem"
    SORT_CLASS_QOSCLASS_SLOW_DRAIN = "qosclassSlowDrain"
    SORT_CLASS_QOSCLASS_SLOW_DRAIN_FSM = "qosclassSlowDrainFsm"
    SORT_CLASS_QOSCLASS_SLOW_DRAIN_FSM_STAGE = "qosclassSlowDrainFsmStage"
    SORT_CLASS_QOSCLASS_SLOW_DRAIN_FSM_TASK = "qosclassSlowDrainFsmTask"
    SORT_CLASS_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    SORT_CLASS_QUERYRESULT_ITEM = "queryresultItem"
    SORT_CLASS_QUERYRESULT_USAGE = "queryresultUsage"
    SORT_CLASS_RULE_DEFINITION = "ruleDefinition"
    SORT_CLASS_RULE_ITEM = "ruleItem"
    SORT_CLASS_RULE_REQUIREMENT = "ruleRequirement"
    SORT_CLASS_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    SORT_CLASS_SECURITY_UNIT = "securityUnit"
    SORT_CLASS_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    SORT_CLASS_SES_ENCLOSURE = "sesEnclosure"
    SORT_CLASS_SOL_CONFIG = "solConfig"
    SORT_CLASS_SOL_DEF = "solDef"
    SORT_CLASS_SOL_IF = "solIf"
    SORT_CLASS_SOL_POLICY = "solPolicy"
    SORT_CLASS_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    SORT_CLASS_STATS_COLLECTION_POLICY_FSM = "statsCollectionPolicyFsm"
    SORT_CLASS_STATS_COLLECTION_POLICY_FSM_STAGE = "statsCollectionPolicyFsmStage"
    SORT_CLASS_STATS_COLLECTION_POLICY_FSM_TASK = "statsCollectionPolicyFsmTask"
    SORT_CLASS_STATS_CURR = "statsCurr"
    SORT_CLASS_STATS_HIST = "statsHist"
    SORT_CLASS_STATS_HOLDER = "statsHolder"
    SORT_CLASS_STATS_ITEM = "statsItem"
    SORT_CLASS_STATS_THR32_DEFINITION = "statsThr32Definition"
    SORT_CLASS_STATS_THR32_VALUE = "statsThr32Value"
    SORT_CLASS_STATS_THR64_DEFINITION = "statsThr64Definition"
    SORT_CLASS_STATS_THR64_VALUE = "statsThr64Value"
    SORT_CLASS_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    SORT_CLASS_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    SORT_CLASS_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    SORT_CLASS_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    SORT_CLASS_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    SORT_CLASS_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    SORT_CLASS_STORAGE_ADEF = "storageADef"
    SORT_CLASS_STORAGE_ADISK_EP = "storageADiskEp"
    SORT_CLASS_STORAGE_ADISK_SLOT_EP = "storageADiskSlotEp"
    SORT_CLASS_STORAGE_ALUN = "storageALun"
    SORT_CLASS_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    SORT_CLASS_STORAGE_ASLOT = "storageASlot"
    SORT_CLASS_STORAGE_AUTH_KEY = "storageAuthKey"
    SORT_CLASS_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    SORT_CLASS_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    SORT_CLASS_STORAGE_CONTROLLER = "storageController"
    SORT_CLASS_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    SORT_CLASS_STORAGE_CONTROLLER_EP = "storageControllerEp"
    SORT_CLASS_STORAGE_CONTROLLER_REF = "storageControllerRef"
    SORT_CLASS_STORAGE_CONTROLLER_REFERENCE = "storageControllerReference"
    SORT_CLASS_STORAGE_DEVICE = "storageDevice"
    SORT_CLASS_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    SORT_CLASS_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    SORT_CLASS_STORAGE_DOMAIN_EP = "storageDomainEp"
    SORT_CLASS_STORAGE_DRIVE = "storageDrive"
    SORT_CLASS_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    SORT_CLASS_STORAGE_ENCLOSURE = "storageEnclosure"
    SORT_CLASS_STORAGE_ENCLOSURE_CAP = "storageEnclosureCap"
    SORT_CLASS_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    SORT_CLASS_STORAGE_ENCLOSURE_FSM = "storageEnclosureFsm"
    SORT_CLASS_STORAGE_ENCLOSURE_FSM_STAGE = "storageEnclosureFsmStage"
    SORT_CLASS_STORAGE_ENCLOSURE_FSM_TASK = "storageEnclosureFsmTask"
    SORT_CLASS_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    SORT_CLASS_STORAGE_EP = "storageEp"
    SORT_CLASS_STORAGE_EP_USER = "storageEpUser"
    SORT_CLASS_STORAGE_ETHER_IF = "storageEtherIf"
    SORT_CLASS_STORAGE_FC_IF = "storageFcIf"
    SORT_CLASS_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    SORT_CLASS_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    SORT_CLASS_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER_FSM = "storageFlexFlashControllerFsm"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER_FSM_STAGE = "storageFlexFlashControllerFsmStage"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER_FSM_TASK = "storageFlexFlashControllerFsmTask"
    SORT_CLASS_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    SORT_CLASS_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    SORT_CLASS_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    SORT_CLASS_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    SORT_CLASS_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    SORT_CLASS_STORAGE_INI_GROUP = "storageIniGroup"
    SORT_CLASS_STORAGE_INITIATOR = "storageInitiator"
    SORT_CLASS_STORAGE_ITEM = "storageItem"
    SORT_CLASS_STORAGE_L2_IF = "storageL2If"
    SORT_CLASS_STORAGE_LOCAL_DISK = "storageLocalDisk"
    SORT_CLASS_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    SORT_CLASS_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    SORT_CLASS_STORAGE_LOCAL_DISK_FSM = "storageLocalDiskFsm"
    SORT_CLASS_STORAGE_LOCAL_DISK_FSM_STAGE = "storageLocalDiskFsmStage"
    SORT_CLASS_STORAGE_LOCAL_DISK_FSM_TASK = "storageLocalDiskFsmTask"
    SORT_CLASS_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    SORT_CLASS_STORAGE_LOCAL_DISK_SLOT_EP = "storageLocalDiskSlotEp"
    SORT_CLASS_STORAGE_LOCAL_LUN = "storageLocalLun"
    SORT_CLASS_STORAGE_LOGICAL = "storageLogical"
    SORT_CLASS_STORAGE_LUN_DISK = "storageLunDisk"
    SORT_CLASS_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    SORT_CLASS_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    SORT_CLASS_STORAGE_MINI_STORAGE = "storageMiniStorage"
    SORT_CLASS_STORAGE_NODE_EP = "storageNodeEp"
    SORT_CLASS_STORAGE_NVME_STATS = "storageNvmeStats"
    SORT_CLASS_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    SORT_CLASS_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    SORT_CLASS_STORAGE_NVME_SWITCH = "storageNvmeSwitch"
    SORT_CLASS_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    SORT_CLASS_STORAGE_OPERATION = "storageOperation"
    SORT_CLASS_STORAGE_PHYSICAL = "storagePhysical"
    SORT_CLASS_STORAGE_QUAL = "storageQual"
    SORT_CLASS_STORAGE_RAID_BATTERY = "storageRaidBattery"
    SORT_CLASS_STORAGE_SAS_EXPANDER = "storageSasExpander"
    SORT_CLASS_STORAGE_SAS_LINK_DESCRIPTOR = "storageSasLinkDescriptor"
    SORT_CLASS_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    SORT_CLASS_STORAGE_SAS_PORT = "storageSasPort"
    SORT_CLASS_STORAGE_SAS_PORT_DESCRIPTOR = "storageSasPortDescriptor"
    SORT_CLASS_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    SORT_CLASS_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    SORT_CLASS_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    SORT_CLASS_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    SORT_CLASS_STORAGE_SYSTEM = "storageSystem"
    SORT_CLASS_STORAGE_SYSTEM_FSM = "storageSystemFsm"
    SORT_CLASS_STORAGE_SYSTEM_FSM_STAGE = "storageSystemFsmStage"
    SORT_CLASS_STORAGE_SYSTEM_FSM_TASK = "storageSystemFsmTask"
    SORT_CLASS_STORAGE_TARGET = "storageTarget"
    SORT_CLASS_STORAGE_TARGET_IF = "storageTargetIf"
    SORT_CLASS_STORAGE_TRANSPORT_IF = "storageTransportIf"
    SORT_CLASS_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    SORT_CLASS_STORAGE_UNIT = "storageUnit"
    SORT_CLASS_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    SORT_CLASS_STORAGE_VSAN_REF = "storageVsanRef"
    SORT_CLASS_SW_ACCESS_DOMAIN = "swAccessDomain"
    SORT_CLASS_SW_ACCESS_DOMAIN_FSM = "swAccessDomainFsm"
    SORT_CLASS_SW_ACCESS_DOMAIN_FSM_STAGE = "swAccessDomainFsmStage"
    SORT_CLASS_SW_ACCESS_DOMAIN_FSM_TASK = "swAccessDomainFsmTask"
    SORT_CLASS_SW_ACCESS_EP = "swAccessEp"
    SORT_CLASS_SW_BORDER_DOMAIN = "swBorderDomain"
    SORT_CLASS_SW_BORDER_EP = "swBorderEp"
    SORT_CLASS_SW_BORDER_PC = "swBorderPc"
    SORT_CLASS_SW_CIO_EP = "swCIoEp"
    SORT_CLASS_SW_CARD_ENV_STATS = "swCardEnvStats"
    SORT_CLASS_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    SORT_CLASS_SW_CMCLAN = "swCmclan"
    SORT_CLASS_SW_DOMAIN = "swDomain"
    SORT_CLASS_SW_ENV_STATS = "swEnvStats"
    SORT_CLASS_SW_ENV_STATS_HIST = "swEnvStatsHist"
    SORT_CLASS_SW_ESTC_EP = "swEstcEp"
    SORT_CLASS_SW_ETH_ESTC_EP = "swEthEstcEp"
    SORT_CLASS_SW_ETH_ESTC_PC = "swEthEstcPc"
    SORT_CLASS_SW_ETH_FLOW_MON_SESSION = "swEthFlowMonSession"
    SORT_CLASS_SW_ETH_LAN_BORDER = "swEthLanBorder"
    SORT_CLASS_SW_ETH_LAN_BORDER_FSM = "swEthLanBorderFsm"
    SORT_CLASS_SW_ETH_LAN_BORDER_FSM_STAGE = "swEthLanBorderFsmStage"
    SORT_CLASS_SW_ETH_LAN_BORDER_FSM_TASK = "swEthLanBorderFsmTask"
    SORT_CLASS_SW_ETH_LAN_EP = "swEthLanEp"
    SORT_CLASS_SW_ETH_LAN_FLOW_MON = "swEthLanFlowMon"
    SORT_CLASS_SW_ETH_LAN_FLOW_MON_EXPORTER = "swEthLanFlowMonExporter"
    SORT_CLASS_SW_ETH_LAN_FLOW_MON_FSM = "swEthLanFlowMonFsm"
    SORT_CLASS_SW_ETH_LAN_FLOW_MON_FSM_STAGE = "swEthLanFlowMonFsmStage"
    SORT_CLASS_SW_ETH_LAN_FLOW_MON_FSM_TASK = "swEthLanFlowMonFsmTask"
    SORT_CLASS_SW_ETH_LAN_FLOW_MONITOR = "swEthLanFlowMonitor"
    SORT_CLASS_SW_ETH_LAN_FLOW_RECORD_DEF = "swEthLanFlowRecordDef"
    SORT_CLASS_SW_ETH_LAN_MON = "swEthLanMon"
    SORT_CLASS_SW_ETH_LAN_PC = "swEthLanPc"
    SORT_CLASS_SW_ETH_MON = "swEthMon"
    SORT_CLASS_SW_ETH_MON_DEST_EP = "swEthMonDestEp"
    SORT_CLASS_SW_ETH_MON_FSM = "swEthMonFsm"
    SORT_CLASS_SW_ETH_MON_FSM_STAGE = "swEthMonFsmStage"
    SORT_CLASS_SW_ETH_MON_FSM_TASK = "swEthMonFsmTask"
    SORT_CLASS_SW_ETH_MON_SRC_EP = "swEthMonSrcEp"
    SORT_CLASS_SW_ETH_TARGET_EP = "swEthTargetEp"
    SORT_CLASS_SW_ETHER_PORT = "swEtherPort"
    SORT_CLASS_SW_EXT_UTILITY = "swExtUtility"
    SORT_CLASS_SW_EXT_UTILITY_FSM = "swExtUtilityFsm"
    SORT_CLASS_SW_EXT_UTILITY_FSM_STAGE = "swExtUtilityFsmStage"
    SORT_CLASS_SW_EXT_UTILITY_FSM_TASK = "swExtUtilityFsmTask"
    SORT_CLASS_SW_FABRIC_ZONE_NS = "swFabricZoneNs"
    SORT_CLASS_SW_FABRIC_ZONE_NS_OVERRIDE = "swFabricZoneNsOverride"
    SORT_CLASS_SW_FC_ENDPOINT = "swFcEndpoint"
    SORT_CLASS_SW_FC_ESTC_EP = "swFcEstcEp"
    SORT_CLASS_SW_FC_MON = "swFcMon"
    SORT_CLASS_SW_FC_MON_DEST_EP = "swFcMonDestEp"
    SORT_CLASS_SW_FC_MON_FSM = "swFcMonFsm"
    SORT_CLASS_SW_FC_MON_FSM_STAGE = "swFcMonFsmStage"
    SORT_CLASS_SW_FC_MON_FSM_TASK = "swFcMonFsmTask"
    SORT_CLASS_SW_FC_MON_SRC_EP = "swFcMonSrcEp"
    SORT_CLASS_SW_FC_SAN_BORDER = "swFcSanBorder"
    SORT_CLASS_SW_FC_SAN_BORDER_FSM = "swFcSanBorderFsm"
    SORT_CLASS_SW_FC_SAN_BORDER_FSM_STAGE = "swFcSanBorderFsmStage"
    SORT_CLASS_SW_FC_SAN_BORDER_FSM_TASK = "swFcSanBorderFsmTask"
    SORT_CLASS_SW_FC_SAN_EP = "swFcSanEp"
    SORT_CLASS_SW_FC_SAN_MON = "swFcSanMon"
    SORT_CLASS_SW_FC_SAN_PC = "swFcSanPc"
    SORT_CLASS_SW_FC_SERVER_ZONE_GROUP = "swFcServerZoneGroup"
    SORT_CLASS_SW_FC_USER_ZONE = "swFcUserZone"
    SORT_CLASS_SW_FC_USER_ZONE_GROUP = "swFcUserZoneGroup"
    SORT_CLASS_SW_FC_ZONE = "swFcZone"
    SORT_CLASS_SW_FC_ZONE_MEMBER = "swFcZoneMember"
    SORT_CLASS_SW_FC_ZONE_SET = "swFcZoneSet"
    SORT_CLASS_SW_FCOE_ESTC_EP = "swFcoeEstcEp"
    SORT_CLASS_SW_FCOE_SAN_EP = "swFcoeSanEp"
    SORT_CLASS_SW_FCOE_SAN_PC = "swFcoeSanPc"
    SORT_CLASS_SW_FLOW_MON_EXPORTER = "swFlowMonExporter"
    SORT_CLASS_SW_FLOW_MONITOR = "swFlowMonitor"
    SORT_CLASS_SW_FLOW_RECORD_DEF = "swFlowRecordDef"
    SORT_CLASS_SW_IP_ROUTE = "swIpRoute"
    SORT_CLASS_SW_LAN_BORDER = "swLanBorder"
    SORT_CLASS_SW_LAN_EP = "swLanEp"
    SORT_CLASS_SW_LAN_MON = "swLanMon"
    SORT_CLASS_SW_LAN_PC = "swLanPc"
    SORT_CLASS_SW_MON = "swMon"
    SORT_CLASS_SW_MON_DEST_EP = "swMonDestEp"
    SORT_CLASS_SW_MON_DOMAIN = "swMonDomain"
    SORT_CLASS_SW_MON_SRC_EP = "swMonSrcEp"
    SORT_CLASS_SW_NFEXPORTER_REF = "swNFExporterRef"
    SORT_CLASS_SW_NETFLOW_EXPORTER = "swNetflowExporter"
    SORT_CLASS_SW_NETFLOW_MON_SESSION = "swNetflowMonSession"
    SORT_CLASS_SW_NETFLOW_MONITOR = "swNetflowMonitor"
    SORT_CLASS_SW_NETFLOW_MONITOR_REF = "swNetflowMonitorRef"
    SORT_CLASS_SW_NETFLOW_RECORD_DEF = "swNetflowRecordDef"
    SORT_CLASS_SW_PIO_EP = "swPIoEp"
    SORT_CLASS_SW_PHYS = "swPhys"
    SORT_CLASS_SW_PHYS_ETHER_EP = "swPhysEtherEp"
    SORT_CLASS_SW_PHYS_FC_EP = "swPhysFcEp"
    SORT_CLASS_SW_PHYS_FSM = "swPhysFsm"
    SORT_CLASS_SW_PHYS_FSM_STAGE = "swPhysFsmStage"
    SORT_CLASS_SW_PHYS_FSM_TASK = "swPhysFsmTask"
    SORT_CLASS_SW_PORT_BREAKOUT = "swPortBreakout"
    SORT_CLASS_SW_PORT_DISCOVER = "swPortDiscover"
    SORT_CLASS_SW_PORT_DISCOVER_FSM = "swPortDiscoverFsm"
    SORT_CLASS_SW_PORT_DISCOVER_FSM_STAGE = "swPortDiscoverFsmStage"
    SORT_CLASS_SW_PORT_DISCOVER_FSM_TASK = "swPortDiscoverFsmTask"
    SORT_CLASS_SW_SAN_BORDER = "swSanBorder"
    SORT_CLASS_SW_SAN_EP = "swSanEp"
    SORT_CLASS_SW_SAN_MON = "swSanMon"
    SORT_CLASS_SW_SAN_PC = "swSanPc"
    SORT_CLASS_SW_SUB_GROUP = "swSubGroup"
    SORT_CLASS_SW_SYSTEM_STATS = "swSystemStats"
    SORT_CLASS_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    SORT_CLASS_SW_TARGET_EP = "swTargetEp"
    SORT_CLASS_SW_ULAN = "swUlan"
    SORT_CLASS_SW_UTILITY_DOMAIN = "swUtilityDomain"
    SORT_CLASS_SW_UTILITY_DOMAIN_FSM = "swUtilityDomainFsm"
    SORT_CLASS_SW_UTILITY_DOMAIN_FSM_STAGE = "swUtilityDomainFsmStage"
    SORT_CLASS_SW_UTILITY_DOMAIN_FSM_TASK = "swUtilityDomainFsmTask"
    SORT_CLASS_SW_VIFREF = "swVIFRef"
    SORT_CLASS_SW_VIRT_L3_INTF = "swVirtL3Intf"
    SORT_CLASS_SW_VLAN = "swVlan"
    SORT_CLASS_SW_VLAN_GROUP = "swVlanGroup"
    SORT_CLASS_SW_VLAN_PORT_NS = "swVlanPortNs"
    SORT_CLASS_SW_VLAN_PORT_NS_OVERRIDE = "swVlanPortNsOverride"
    SORT_CLASS_SW_VLAN_REF = "swVlanRef"
    SORT_CLASS_SW_VSAN = "swVsan"
    SORT_CLASS_SW_ZONE_INITIATOR_MEMBER = "swZoneInitiatorMember"
    SORT_CLASS_SW_ZONE_TARGET_MEMBER = "swZoneTargetMember"
    SORT_CLASS_SWAT_ACTION = "swatAction"
    SORT_CLASS_SWAT_CONDITION = "swatCondition"
    SORT_CLASS_SWAT_INJECTION = "swatInjection"
    SORT_CLASS_SWAT_RESULTSTATS = "swatResultstats"
    SORT_CLASS_SWAT_TARGET = "swatTarget"
    SORT_CLASS_SWAT_TRIGGER = "swatTrigger"
    SORT_CLASS_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    SORT_CLASS_SYNTHETIC_FILE = "syntheticFile"
    SORT_CLASS_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    SORT_CLASS_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    SORT_CLASS_SYNTHETIC_FS_OBJ_FSM = "syntheticFsObjFsm"
    SORT_CLASS_SYNTHETIC_FS_OBJ_FSM_STAGE = "syntheticFsObjFsmStage"
    SORT_CLASS_SYNTHETIC_FS_OBJ_FSM_TASK = "syntheticFsObjFsmTask"
    SORT_CLASS_SYNTHETIC_TIME = "syntheticTime"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    SORT_CLASS_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    SORT_CLASS_SYSDEBUG_CORE = "sysdebugCore"
    SORT_CLASS_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    SORT_CLASS_SYSDEBUG_CORE_FSM = "sysdebugCoreFsm"
    SORT_CLASS_SYSDEBUG_CORE_FSM_STAGE = "sysdebugCoreFsmStage"
    SORT_CLASS_SYSDEBUG_CORE_FSM_TASK = "sysdebugCoreFsmTask"
    SORT_CLASS_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    SORT_CLASS_SYSDEBUG_DIAGNOSTIC_LOG_REPOSITORY = "sysdebugDiagnosticLogRepository"
    SORT_CLASS_SYSDEBUG_EP = "sysdebugEp"
    SORT_CLASS_SYSDEBUG_EXPORTER = "sysdebugExporter"
    SORT_CLASS_SYSDEBUG_FILE = "sysdebugFile"
    SORT_CLASS_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    SORT_CLASS_SYSDEBUG_LOG_EXPORT_POLICY = "sysdebugLogExportPolicy"
    SORT_CLASS_SYSDEBUG_LOG_EXPORT_POLICY_FSM = "sysdebugLogExportPolicyFsm"
    SORT_CLASS_SYSDEBUG_LOG_EXPORT_POLICY_FSM_STAGE = "sysdebugLogExportPolicyFsmStage"
    SORT_CLASS_SYSDEBUG_LOG_EXPORT_POLICY_FSM_TASK = "sysdebugLogExportPolicyFsmTask"
    SORT_CLASS_SYSDEBUG_LOG_EXPORT_STATUS = "sysdebugLogExportStatus"
    SORT_CLASS_SYSDEBUG_MEP_LOG = "sysdebugMEpLog"
    SORT_CLASS_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    SORT_CLASS_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    SORT_CLASS_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    SORT_CLASS_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    SORT_CLASS_SYSFILE_DIGEST = "sysfileDigest"
    SORT_CLASS_SYSFILE_EP = "sysfileEp"
    SORT_CLASS_SYSFILE_EXPORTER = "sysfileExporter"
    SORT_CLASS_SYSFILE_IMPORTER = "sysfileImporter"
    SORT_CLASS_SYSFILE_INSTANCE = "sysfileInstance"
    SORT_CLASS_SYSFILE_MUTATION = "sysfileMutation"
    SORT_CLASS_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    SORT_CLASS_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    SORT_CLASS_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    SORT_CLASS_SYSFILE_REPOSITORY = "sysfileRepository"
    SORT_CLASS_TOP_INFO_POLICY = "topInfoPolicy"
    SORT_CLASS_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    SORT_CLASS_TOP_META_INF = "topMetaInf"
    SORT_CLASS_TOP_ROOT = "topRoot"
    SORT_CLASS_TOP_SYS_DEFAULTS = "topSysDefaults"
    SORT_CLASS_TOP_SYSTEM = "topSystem"
    SORT_CLASS_TRIG_ABS_WINDOW = "trigAbsWindow"
    SORT_CLASS_TRIG_ACK = "trigAck"
    SORT_CLASS_TRIG_BASE_ABS_WINDOW = "trigBaseAbsWindow"
    SORT_CLASS_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    SORT_CLASS_TRIG_BASE_SCHED = "trigBaseSched"
    SORT_CLASS_TRIG_CLIENT_TOKEN = "trigClientToken"
    SORT_CLASS_TRIG_CONF_ACK = "trigConfAck"
    SORT_CLASS_TRIG_INST = "trigInst"
    SORT_CLASS_TRIG_LOCAL_ABS_WINDOW = "trigLocalAbsWindow"
    SORT_CLASS_TRIG_LOCAL_SCHED = "trigLocalSched"
    SORT_CLASS_TRIG_META = "trigMeta"
    SORT_CLASS_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    SORT_CLASS_TRIG_RES_ACK = "trigResAck"
    SORT_CLASS_TRIG_SCHED = "trigSched"
    SORT_CLASS_TRIG_SCHED_WINDOW = "trigSchedWindow"
    SORT_CLASS_TRIG_TEST = "trigTest"
    SORT_CLASS_TRIG_TOKEN = "trigToken"
    SORT_CLASS_TRIG_TRIGGERABLE = "trigTriggerable"
    SORT_CLASS_TRIG_TRIGGERED = "trigTriggered"
    SORT_CLASS_TRIG_WINDOW = "trigWindow"
    SORT_CLASS_UNSPECIFIED = "unspecified"
    SORT_CLASS_UUIDPOOL_ADDR = "uuidpoolAddr"
    SORT_CLASS_UUIDPOOL_BLOCK = "uuidpoolBlock"
    SORT_CLASS_UUIDPOOL_FORMAT = "uuidpoolFormat"
    SORT_CLASS_UUIDPOOL_POOL = "uuidpoolPool"
    SORT_CLASS_UUIDPOOL_POOLABLE = "uuidpoolPoolable"
    SORT_CLASS_UUIDPOOL_POOLED = "uuidpoolPooled"
    SORT_CLASS_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    SORT_CLASS_VERSION_APPLICATION = "versionApplication"
    SORT_CLASS_VERSION_EP = "versionEp"
    SORT_CLASS_VERSION_VERSION = "versionVersion"
    SORT_CLASS_VM_ADAPTOR = "vmAdaptor"
    SORT_CLASS_VM_CLIENT_CONTAINER = "vmClientContainer"
    SORT_CLASS_VM_COMPUTE_EP = "vmComputeEp"
    SORT_CLASS_VM_CONT = "vmCont"
    SORT_CLASS_VM_DC = "vmDC"
    SORT_CLASS_VM_DCORG = "vmDCOrg"
    SORT_CLASS_VM_DIR_CONT = "vmDirCont"
    SORT_CLASS_VM_EP = "vmEp"
    SORT_CLASS_VM_HBA = "vmHba"
    SORT_CLASS_VM_HV = "vmHv"
    SORT_CLASS_VM_INSTANCE = "vmInstance"
    SORT_CLASS_VM_LIFE_CYCLE_POLICY = "vmLifeCyclePolicy"
    SORT_CLASS_VM_LIFE_CYCLE_POLICY_FSM = "vmLifeCyclePolicyFsm"
    SORT_CLASS_VM_LIFE_CYCLE_POLICY_FSM_STAGE = "vmLifeCyclePolicyFsmStage"
    SORT_CLASS_VM_LIFE_CYCLE_POLICY_FSM_TASK = "vmLifeCyclePolicyFsmTask"
    SORT_CLASS_VM_NIC = "vmNic"
    SORT_CLASS_VM_ORG = "vmOrg"
    SORT_CLASS_VM_SWITCH = "vmSwitch"
    SORT_CLASS_VM_VIF = "vmVif"
    SORT_CLASS_VM_VIRTUAL = "vmVirtual"
    SORT_CLASS_VM_VLAN = "vmVlan"
    SORT_CLASS_VM_VNIC_PROF_CL = "vmVnicProfCl"
    SORT_CLASS_VM_VNIC_PROF_INST = "vmVnicProfInst"
    SORT_CLASS_VM_VSAN = "vmVsan"
    SORT_CLASS_VNIC_ABEH = "vnicABeh"
    SORT_CLASS_VNIC_AETHER_IF = "vnicAEtherIf"
    SORT_CLASS_VNIC_AFC_IF = "vnicAFcIf"
    SORT_CLASS_VNIC_AGROUP = "vnicAGroup"
    SORT_CLASS_VNIC_AIPC_IF = "vnicAIpcIf"
    SORT_CLASS_VNIC_ASCSI_IF = "vnicAScsiIf"
    SORT_CLASS_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    SORT_CLASS_VNIC_BOOT_TARGET = "vnicBootTarget"
    SORT_CLASS_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    SORT_CLASS_VNIC_CON_REQ = "vnicConReq"
    SORT_CLASS_VNIC_CONN_DEF = "vnicConnDef"
    SORT_CLASS_VNIC_CONNECTION = "vnicConnection"
    SORT_CLASS_VNIC_DEF_BEH = "vnicDefBeh"
    SORT_CLASS_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    SORT_CLASS_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    SORT_CLASS_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    SORT_CLASS_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    SORT_CLASS_VNIC_DYNAMIC_ID_UNIVERSE = "vnicDynamicIdUniverse"
    SORT_CLASS_VNIC_DYNAMIC_PROVIDER = "vnicDynamicProvider"
    SORT_CLASS_VNIC_DYNAMIC_PROVIDER_EP = "vnicDynamicProviderEp"
    SORT_CLASS_VNIC_ETH_CONFIG = "vnicEthConfig"
    SORT_CLASS_VNIC_ETH_LIF = "vnicEthLif"
    SORT_CLASS_VNIC_ETHER = "vnicEther"
    SORT_CLASS_VNIC_ETHER_BASE = "vnicEtherBase"
    SORT_CLASS_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    SORT_CLASS_VNIC_ETHER_IF = "vnicEtherIf"
    SORT_CLASS_VNIC_FC = "vnicFc"
    SORT_CLASS_VNIC_FC_BASE = "vnicFcBase"
    SORT_CLASS_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    SORT_CLASS_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    SORT_CLASS_VNIC_FC_IF = "vnicFcIf"
    SORT_CLASS_VNIC_FC_LIF = "vnicFcLif"
    SORT_CLASS_VNIC_FC_NODE = "vnicFcNode"
    SORT_CLASS_VNIC_FC_OEIF = "vnicFcOEIf"
    SORT_CLASS_VNIC_IPIF = "vnicIPIf"
    SORT_CLASS_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    SORT_CLASS_VNIC_IPV4_DNS = "vnicIPv4Dns"
    SORT_CLASS_VNIC_IPV4_IF = "vnicIPv4If"
    SORT_CLASS_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    SORT_CLASS_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    SORT_CLASS_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    SORT_CLASS_VNIC_IPV6_IF = "vnicIPv6If"
    SORT_CLASS_VNIC_ISCSI = "vnicIScsi"
    SORT_CLASS_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    SORT_CLASS_VNIC_ISCSI_BASE = "vnicIScsiBase"
    SORT_CLASS_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    SORT_CLASS_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    SORT_CLASS_VNIC_ISCSI_CONFIG = "vnicIScsiConfig"
    SORT_CLASS_VNIC_ISCSI_INIT_AUTO_CONFIG_POLICY = "vnicIScsiInitAutoConfigPolicy"
    SORT_CLASS_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    SORT_CLASS_VNIC_ISCSI_NODE = "vnicIScsiNode"
    SORT_CLASS_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    SORT_CLASS_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    SORT_CLASS_VNIC_IF = "vnicIf"
    SORT_CLASS_VNIC_IF_ROLE = "vnicIfRole"
    SORT_CLASS_VNIC_INITIATOR_AUTO_CONFIG_POLICY = "vnicInitiatorAutoConfigPolicy"
    SORT_CLASS_VNIC_INTERNAL_PROFILE = "vnicInternalProfile"
    SORT_CLASS_VNIC_IP_ADDR = "vnicIpAddr"
    SORT_CLASS_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    SORT_CLASS_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    SORT_CLASS_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    SORT_CLASS_VNIC_IP_V4_HISTORY = "vnicIpV4History"
    SORT_CLASS_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    SORT_CLASS_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    SORT_CLASS_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    SORT_CLASS_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    SORT_CLASS_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    SORT_CLASS_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    SORT_CLASS_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    SORT_CLASS_VNIC_IP_V6_HISTORY = "vnicIpV6History"
    SORT_CLASS_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    SORT_CLASS_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    SORT_CLASS_VNIC_IPC = "vnicIpc"
    SORT_CLASS_VNIC_IPC_IF = "vnicIpcIf"
    SORT_CLASS_VNIC_IQN_HISTORY = "vnicIqnHistory"
    SORT_CLASS_VNIC_L2_IF = "vnicL2If"
    SORT_CLASS_VNIC_L2_LIF = "vnicL2Lif"
    SORT_CLASS_VNIC_L3_IF = "vnicL3If"
    SORT_CLASS_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    SORT_CLASS_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    SORT_CLASS_VNIC_LIF_VLAN = "vnicLifVlan"
    SORT_CLASS_VNIC_LIF_VSAN = "vnicLifVsan"
    SORT_CLASS_VNIC_LUN = "vnicLun"
    SORT_CLASS_VNIC_MAC_HISTORY = "vnicMacHistory"
    SORT_CLASS_VNIC_NIC_CONN = "vnicNicConn"
    SORT_CLASS_VNIC_OPROFILE_ALIAS = "vnicOProfileAlias"
    SORT_CLASS_VNIC_PROFILE = "vnicProfile"
    SORT_CLASS_VNIC_PROFILE_ALIAS = "vnicProfileAlias"
    SORT_CLASS_VNIC_PROFILE_REF = "vnicProfileRef"
    SORT_CLASS_VNIC_PROFILE_SET = "vnicProfileSet"
    SORT_CLASS_VNIC_PROFILE_SET_FSM = "vnicProfileSetFsm"
    SORT_CLASS_VNIC_PROFILE_SET_FSM_STAGE = "vnicProfileSetFsmStage"
    SORT_CLASS_VNIC_PROFILE_SET_FSM_TASK = "vnicProfileSetFsmTask"
    SORT_CLASS_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    SORT_CLASS_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    SORT_CLASS_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    SORT_CLASS_VNIC_SCSI = "vnicScsi"
    SORT_CLASS_VNIC_SCSI_IF = "vnicScsiIf"
    SORT_CLASS_VNIC_TEMPL = "vnicTempl"
    SORT_CLASS_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    SORT_CLASS_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    SORT_CLASS_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    SORT_CLASS_VNIC_VPROFILE_ALIAS = "vnicVProfileAlias"
    SORT_CLASS_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    SORT_CLASS_VNIC_VLAN = "vnicVlan"
    SORT_CLASS_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    SORT_CLASS_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    SORT_CLASS_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    SORT_CLASS_VNIC_VNIC = "vnicVnic"
    SORT_CLASS_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"
    SORT_CLASS_VNIC_WWNN_HISTORY = "vnicWwnnHistory"
    SORT_CLASS_VNIC_WWPN_HISTORY = "vnicWwpnHistory"
    SORT_PROP_AAA_AUTH_METHOD_DESCR = "aaa_AuthMethod_descr"
    SORT_PROP_AAA_AUTH_METHOD_NAME = "aaa_AuthMethod_name"
    SORT_PROP_AAA_AUTH_METHOD_OPER_PROVIDER_GROUP = "aaa_AuthMethod_operProviderGroup"
    SORT_PROP_AAA_AUTH_METHOD_OPER_REALM = "aaa_AuthMethod_operRealm"
    SORT_PROP_AAA_AUTH_METHOD_PROVIDER_GROUP = "aaa_AuthMethod_providerGroup"
    SORT_PROP_AAA_AUTH_METHOD_REALM = "aaa_AuthMethod_realm"
    SORT_PROP_AAA_AUTH_METHOD_USE2_FACTOR = "aaa_AuthMethod_use2Factor"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealmFsmStage_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_AuthRealmFsmStage_lastUpdateTime"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_NAME = "aaa_AuthRealmFsmStage_name"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_ORDER = "aaa_AuthRealmFsmStage_order"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_RETRY = "aaa_AuthRealmFsmStage_retry"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_STAGE_STATUS = "aaa_AuthRealmFsmStage_stageStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_COMPLETION_TIME = "aaa_AuthRealmFsm_completionTime"
    SORT_PROP_AAA_AUTH_REALM_FSM_CURRENT_FSM = "aaa_AuthRealmFsm_currentFsm"
    SORT_PROP_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealmFsm_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_FSM_STATUS = "aaa_AuthRealmFsm_fsmStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_INSTANCE_ID = "aaa_AuthRealmFsm_instanceId"
    SORT_PROP_AAA_AUTH_REALM_FSM_PROGRESS = "aaa_AuthRealmFsm_progress"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_ERR_CODE = "aaa_AuthRealmFsm_rmtErrCode"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_ERR_DESCR = "aaa_AuthRealmFsm_rmtErrDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_RSLT = "aaa_AuthRealmFsm_rmtRslt"
    SORT_PROP_AAA_AUTH_REALM_CON_LOGIN = "aaa_AuthRealm_conLogin"
    SORT_PROP_AAA_AUTH_REALM_DEF_LOGIN = "aaa_AuthRealm_defLogin"
    SORT_PROP_AAA_AUTH_REALM_DEF_ROLE_POLICY = "aaa_AuthRealm_defRolePolicy"
    SORT_PROP_AAA_AUTH_REALM_DESCR = "aaa_AuthRealm_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealm_fsmDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_PREV = "aaa_AuthRealm_fsmPrev"
    SORT_PROP_AAA_AUTH_REALM_FSM_PROGR = "aaa_AuthRealm_fsmProgr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_ERR_CODE = "aaa_AuthRealm_fsmRmtInvErrCode"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_AuthRealm_fsmRmtInvErrDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_RSLT = "aaa_AuthRealm_fsmRmtInvRslt"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealm_fsmStageDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAMP = "aaa_AuthRealm_fsmStamp"
    SORT_PROP_AAA_AUTH_REALM_FSM_STATUS = "aaa_AuthRealm_fsmStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_TRY = "aaa_AuthRealm_fsmTry"
    SORT_PROP_AAA_AUTH_REALM_INT_ID = "aaa_AuthRealm_intId"
    SORT_PROP_AAA_AUTH_REALM_NAME = "aaa_AuthRealm_name"
    SORT_PROP_AAA_AUTH_REALM_POLICY_LEVEL = "aaa_AuthRealm_policyLevel"
    SORT_PROP_AAA_AUTH_REALM_POLICY_OWNER = "aaa_AuthRealm_policyOwner"
    SORT_PROP_AAA_BANNER_DESCR = "aaa_Banner_descr"
    SORT_PROP_AAA_BANNER_INT_ID = "aaa_Banner_intId"
    SORT_PROP_AAA_BANNER_MESSAGE = "aaa_Banner_message"
    SORT_PROP_AAA_BANNER_NAME = "aaa_Banner_name"
    SORT_PROP_AAA_BANNER_POLICY_LEVEL = "aaa_Banner_policyLevel"
    SORT_PROP_AAA_BANNER_POLICY_OWNER = "aaa_Banner_policyOwner"
    SORT_PROP_AAA_CIMC_SESSION_ADMIN_STATE = "aaa_CimcSession_adminState"
    SORT_PROP_AAA_CIMC_SESSION_CIMC_ADDR = "aaa_CimcSession_cimcAddr"
    SORT_PROP_AAA_CIMC_SESSION_ID = "aaa_CimcSession_id"
    SORT_PROP_AAA_CIMC_SESSION_INT_DEL = "aaa_CimcSession_intDel"
    SORT_PROP_AAA_CIMC_SESSION_IS_DELETE = "aaa_CimcSession_isDelete"
    SORT_PROP_AAA_CIMC_SESSION_LAST_UPDATED_TIME = "aaa_CimcSession_lastUpdatedTime"
    SORT_PROP_AAA_CIMC_SESSION_LOGIN_TIME = "aaa_CimcSession_loginTime"
    SORT_PROP_AAA_CIMC_SESSION_LS_DN = "aaa_CimcSession_lsDn"
    SORT_PROP_AAA_CIMC_SESSION_PID = "aaa_CimcSession_pid"
    SORT_PROP_AAA_CIMC_SESSION_PN_DN = "aaa_CimcSession_pnDn"
    SORT_PROP_AAA_CIMC_SESSION_PRIV = "aaa_CimcSession_priv"
    SORT_PROP_AAA_CIMC_SESSION_SOURCE_ADDR = "aaa_CimcSession_sourceAddr"
    SORT_PROP_AAA_CIMC_SESSION_TYPE = "aaa_CimcSession_type"
    SORT_PROP_AAA_CIMC_SESSION_USER = "aaa_CimcSession_user"
    SORT_PROP_AAA_CONFIG_DESCR = "aaa_Config_descr"
    SORT_PROP_AAA_CONFIG_NAME = "aaa_Config_name"
    SORT_PROP_AAA_CONFIG_OPER_PROVIDER_GROUP = "aaa_Config_operProviderGroup"
    SORT_PROP_AAA_CONFIG_OPER_REALM = "aaa_Config_operRealm"
    SORT_PROP_AAA_CONFIG_PROVIDER_GROUP = "aaa_Config_providerGroup"
    SORT_PROP_AAA_CONFIG_REALM = "aaa_Config_realm"
    SORT_PROP_AAA_CONFIG_USE2_FACTOR = "aaa_Config_use2Factor"
    SORT_PROP_AAA_CONSOLE_AUTH_DESCR = "aaa_ConsoleAuth_descr"
    SORT_PROP_AAA_CONSOLE_AUTH_NAME = "aaa_ConsoleAuth_name"
    SORT_PROP_AAA_CONSOLE_AUTH_OPER_PROVIDER_GROUP = "aaa_ConsoleAuth_operProviderGroup"
    SORT_PROP_AAA_CONSOLE_AUTH_OPER_REALM = "aaa_ConsoleAuth_operRealm"
    SORT_PROP_AAA_CONSOLE_AUTH_PROVIDER_GROUP = "aaa_ConsoleAuth_providerGroup"
    SORT_PROP_AAA_CONSOLE_AUTH_REALM = "aaa_ConsoleAuth_realm"
    SORT_PROP_AAA_CONSOLE_AUTH_USE2_FACTOR = "aaa_ConsoleAuth_use2Factor"
    SORT_PROP_AAA_DEFAULT_AUTH_CONFIG_STATE = "aaa_DefaultAuth_configState"
    SORT_PROP_AAA_DEFAULT_AUTH_CONFIG_STATUS_MESSAGE = "aaa_DefaultAuth_configStatusMessage"
    SORT_PROP_AAA_DEFAULT_AUTH_DESCR = "aaa_DefaultAuth_descr"
    SORT_PROP_AAA_DEFAULT_AUTH_NAME = "aaa_DefaultAuth_name"
    SORT_PROP_AAA_DEFAULT_AUTH_OPER_PROVIDER_GROUP = "aaa_DefaultAuth_operProviderGroup"
    SORT_PROP_AAA_DEFAULT_AUTH_OPER_REALM = "aaa_DefaultAuth_operRealm"
    SORT_PROP_AAA_DEFAULT_AUTH_PROVIDER_GROUP = "aaa_DefaultAuth_providerGroup"
    SORT_PROP_AAA_DEFAULT_AUTH_REALM = "aaa_DefaultAuth_realm"
    SORT_PROP_AAA_DEFAULT_AUTH_REFRESH_PERIOD = "aaa_DefaultAuth_refreshPeriod"
    SORT_PROP_AAA_DEFAULT_AUTH_SESSION_TIMEOUT = "aaa_DefaultAuth_sessionTimeout"
    SORT_PROP_AAA_DEFAULT_AUTH_USE2_FACTOR = "aaa_DefaultAuth_use2Factor"
    SORT_PROP_AAA_DEFINITION_DESCR = "aaa_Definition_descr"
    SORT_PROP_AAA_DEFINITION_INT_ID = "aaa_Definition_intId"
    SORT_PROP_AAA_DEFINITION_NAME = "aaa_Definition_name"
    SORT_PROP_AAA_DEFINITION_POLICY_LEVEL = "aaa_Definition_policyLevel"
    SORT_PROP_AAA_DEFINITION_POLICY_OWNER = "aaa_Definition_policyOwner"
    SORT_PROP_AAA_DOMAIN_AUTH_DESCR = "aaa_DomainAuth_descr"
    SORT_PROP_AAA_DOMAIN_AUTH_NAME = "aaa_DomainAuth_name"
    SORT_PROP_AAA_DOMAIN_AUTH_OPER_PROVIDER_GROUP = "aaa_DomainAuth_operProviderGroup"
    SORT_PROP_AAA_DOMAIN_AUTH_OPER_REALM = "aaa_DomainAuth_operRealm"
    SORT_PROP_AAA_DOMAIN_AUTH_PROVIDER_GROUP = "aaa_DomainAuth_providerGroup"
    SORT_PROP_AAA_DOMAIN_AUTH_REALM = "aaa_DomainAuth_realm"
    SORT_PROP_AAA_DOMAIN_AUTH_USE2_FACTOR = "aaa_DomainAuth_use2Factor"
    SORT_PROP_AAA_DOMAIN_CONFIG_STATE = "aaa_Domain_configState"
    SORT_PROP_AAA_DOMAIN_CONFIG_STATUS_MESSAGE = "aaa_Domain_configStatusMessage"
    SORT_PROP_AAA_DOMAIN_DESCR = "aaa_Domain_descr"
    SORT_PROP_AAA_DOMAIN_NAME = "aaa_Domain_name"
    SORT_PROP_AAA_DOMAIN_REFRESH_PERIOD = "aaa_Domain_refreshPeriod"
    SORT_PROP_AAA_DOMAIN_SESSION_TIMEOUT = "aaa_Domain_sessionTimeout"
    SORT_PROP_AAA_EP_AUTH_PROFILE_DESCR = "aaa_EpAuthProfile_descr"
    SORT_PROP_AAA_EP_AUTH_PROFILE_INT_ID = "aaa_EpAuthProfile_intId"
    SORT_PROP_AAA_EP_AUTH_PROFILE_IPMI_OVER_LAN = "aaa_EpAuthProfile_ipmiOverLan"
    SORT_PROP_AAA_EP_AUTH_PROFILE_NAME = "aaa_EpAuthProfile_name"
    SORT_PROP_AAA_EP_AUTH_PROFILE_POLICY_LEVEL = "aaa_EpAuthProfile_policyLevel"
    SORT_PROP_AAA_EP_AUTH_PROFILE_POLICY_OWNER = "aaa_EpAuthProfile_policyOwner"
    SORT_PROP_AAA_EP_FSM_STAGE_DESCR = "aaa_EpFsmStage_descr"
    SORT_PROP_AAA_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_EpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_EP_FSM_STAGE_NAME = "aaa_EpFsmStage_name"
    SORT_PROP_AAA_EP_FSM_STAGE_ORDER = "aaa_EpFsmStage_order"
    SORT_PROP_AAA_EP_FSM_STAGE_RETRY = "aaa_EpFsmStage_retry"
    SORT_PROP_AAA_EP_FSM_STAGE_STAGE_STATUS = "aaa_EpFsmStage_stageStatus"
    SORT_PROP_AAA_EP_FSM_TASK_COMPLETION = "aaa_EpFsmTask_completion"
    SORT_PROP_AAA_EP_FSM_TASK_FLAGS = "aaa_EpFsmTask_flags"
    SORT_PROP_AAA_EP_FSM_TASK_ITEM = "aaa_EpFsmTask_item"
    SORT_PROP_AAA_EP_FSM_TASK_SEQ_ID = "aaa_EpFsmTask_seqId"
    SORT_PROP_AAA_EP_FSM_COMPLETION_TIME = "aaa_EpFsm_completionTime"
    SORT_PROP_AAA_EP_FSM_CURRENT_FSM = "aaa_EpFsm_currentFsm"
    SORT_PROP_AAA_EP_FSM_DESCR = "aaa_EpFsm_descr"
    SORT_PROP_AAA_EP_FSM_FSM_STATUS = "aaa_EpFsm_fsmStatus"
    SORT_PROP_AAA_EP_FSM_INSTANCE_ID = "aaa_EpFsm_instanceId"
    SORT_PROP_AAA_EP_FSM_PROGRESS = "aaa_EpFsm_progress"
    SORT_PROP_AAA_EP_FSM_RMT_ERR_CODE = "aaa_EpFsm_rmtErrCode"
    SORT_PROP_AAA_EP_FSM_RMT_ERR_DESCR = "aaa_EpFsm_rmtErrDescr"
    SORT_PROP_AAA_EP_FSM_RMT_RSLT = "aaa_EpFsm_rmtRslt"
    SORT_PROP_AAA_EP_LOGIN_DESCR = "aaa_EpLogin_descr"
    SORT_PROP_AAA_EP_LOGIN_ID = "aaa_EpLogin_id"
    SORT_PROP_AAA_EP_LOGIN_INT_ID = "aaa_EpLogin_intId"
    SORT_PROP_AAA_EP_LOGIN_LOCAL_HOST = "aaa_EpLogin_localHost"
    SORT_PROP_AAA_EP_LOGIN_NAME = "aaa_EpLogin_name"
    SORT_PROP_AAA_EP_LOGIN_POLICY_LEVEL = "aaa_EpLogin_policyLevel"
    SORT_PROP_AAA_EP_LOGIN_POLICY_OWNER = "aaa_EpLogin_policyOwner"
    SORT_PROP_AAA_EP_LOGIN_REMOTE_HOST = "aaa_EpLogin_remoteHost"
    SORT_PROP_AAA_EP_LOGIN_SESSION = "aaa_EpLogin_session"
    SORT_PROP_AAA_EP_LOGIN_SWITCH_ID = "aaa_EpLogin_switchId"
    SORT_PROP_AAA_EP_USER_CONFIG_STATE = "aaa_EpUser_configState"
    SORT_PROP_AAA_EP_USER_CONFIG_STATUS_MESSAGE = "aaa_EpUser_configStatusMessage"
    SORT_PROP_AAA_EP_USER_DESCR = "aaa_EpUser_descr"
    SORT_PROP_AAA_EP_USER_IS_PWD_ENC = "aaa_EpUser_isPwdEnc"
    SORT_PROP_AAA_EP_USER_NAME = "aaa_EpUser_name"
    SORT_PROP_AAA_EP_USER_PRIV = "aaa_EpUser_priv"
    SORT_PROP_AAA_EP_USER_PWD = "aaa_EpUser_pwd"
    SORT_PROP_AAA_EP_USER_PWD_SET = "aaa_EpUser_pwdSet"
    SORT_PROP_AAA_EP_DESCR = "aaa_Ep_descr"
    SORT_PROP_AAA_EP_FSM_DESCR = "aaa_Ep_fsmDescr"
    SORT_PROP_AAA_EP_FSM_PREV = "aaa_Ep_fsmPrev"
    SORT_PROP_AAA_EP_FSM_PROGR = "aaa_Ep_fsmProgr"
    SORT_PROP_AAA_EP_FSM_RMT_INV_ERR_CODE = "aaa_Ep_fsmRmtInvErrCode"
    SORT_PROP_AAA_EP_FSM_RMT_INV_ERR_DESCR = "aaa_Ep_fsmRmtInvErrDescr"
    SORT_PROP_AAA_EP_FSM_RMT_INV_RSLT = "aaa_Ep_fsmRmtInvRslt"
    SORT_PROP_AAA_EP_FSM_STAGE_DESCR = "aaa_Ep_fsmStageDescr"
    SORT_PROP_AAA_EP_FSM_STAMP = "aaa_Ep_fsmStamp"
    SORT_PROP_AAA_EP_FSM_STATUS = "aaa_Ep_fsmStatus"
    SORT_PROP_AAA_EP_FSM_TRY = "aaa_Ep_fsmTry"
    SORT_PROP_AAA_EP_INT_ID = "aaa_Ep_intId"
    SORT_PROP_AAA_EP_NAME = "aaa_Ep_name"
    SORT_PROP_AAA_EP_POLICY_LEVEL = "aaa_Ep_policyLevel"
    SORT_PROP_AAA_EP_POLICY_OWNER = "aaa_Ep_policyOwner"
    SORT_PROP_AAA_EP_RETRIES = "aaa_Ep_retries"
    SORT_PROP_AAA_EP_TIMEOUT = "aaa_Ep_timeout"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_AUTH_DOMAIN = "aaa_ExtMgmtCutThruTkn_authDomain"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_AUTH_USER = "aaa_ExtMgmtCutThruTkn_authUser"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_CREATION_TIME = "aaa_ExtMgmtCutThruTkn_creationTime"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_DESCR = "aaa_ExtMgmtCutThruTkn_descr"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_INT_ID = "aaa_ExtMgmtCutThruTkn_intId"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_LOCALES = "aaa_ExtMgmtCutThruTkn_locales"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_NAME = "aaa_ExtMgmtCutThruTkn_name"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_PN_DN = "aaa_ExtMgmtCutThruTkn_pnDn"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_LEVEL = "aaa_ExtMgmtCutThruTkn_policyLevel"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_OWNER = "aaa_ExtMgmtCutThruTkn_policyOwner"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_PRIV = "aaa_ExtMgmtCutThruTkn_priv"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_REMOTE = "aaa_ExtMgmtCutThruTkn_remote"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_TOKEN = "aaa_ExtMgmtCutThruTkn_token"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_TYPE = "aaa_ExtMgmtCutThruTkn_type"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_USER = "aaa_ExtMgmtCutThruTkn_user"
    SORT_PROP_AAA_ITEM_DESCR = "aaa_Item_descr"
    SORT_PROP_AAA_ITEM_NAME = "aaa_Item_name"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEpFsmStage_descr"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_LdapEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_NAME = "aaa_LdapEpFsmStage_name"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_ORDER = "aaa_LdapEpFsmStage_order"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_RETRY = "aaa_LdapEpFsmStage_retry"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_STAGE_STATUS = "aaa_LdapEpFsmStage_stageStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_COMPLETION_TIME = "aaa_LdapEpFsm_completionTime"
    SORT_PROP_AAA_LDAP_EP_FSM_CURRENT_FSM = "aaa_LdapEpFsm_currentFsm"
    SORT_PROP_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEpFsm_descr"
    SORT_PROP_AAA_LDAP_EP_FSM_FSM_STATUS = "aaa_LdapEpFsm_fsmStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_INSTANCE_ID = "aaa_LdapEpFsm_instanceId"
    SORT_PROP_AAA_LDAP_EP_FSM_PROGRESS = "aaa_LdapEpFsm_progress"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_ERR_CODE = "aaa_LdapEpFsm_rmtErrCode"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_ERR_DESCR = "aaa_LdapEpFsm_rmtErrDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_RSLT = "aaa_LdapEpFsm_rmtRslt"
    SORT_PROP_AAA_LDAP_EP_ATTRIBUTE = "aaa_LdapEp_attribute"
    SORT_PROP_AAA_LDAP_EP_BASEDN = "aaa_LdapEp_basedn"
    SORT_PROP_AAA_LDAP_EP_DESCR = "aaa_LdapEp_descr"
    SORT_PROP_AAA_LDAP_EP_FILTER = "aaa_LdapEp_filter"
    SORT_PROP_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEp_fsmDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_PREV = "aaa_LdapEp_fsmPrev"
    SORT_PROP_AAA_LDAP_EP_FSM_PROGR = "aaa_LdapEp_fsmProgr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_ERR_CODE = "aaa_LdapEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_ERR_DESCR = "aaa_LdapEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_RSLT = "aaa_LdapEp_fsmRmtInvRslt"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEp_fsmStageDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_STAMP = "aaa_LdapEp_fsmStamp"
    SORT_PROP_AAA_LDAP_EP_FSM_STATUS = "aaa_LdapEp_fsmStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_TRY = "aaa_LdapEp_fsmTry"
    SORT_PROP_AAA_LDAP_EP_INT_ID = "aaa_LdapEp_intId"
    SORT_PROP_AAA_LDAP_EP_NAME = "aaa_LdapEp_name"
    SORT_PROP_AAA_LDAP_EP_POLICY_LEVEL = "aaa_LdapEp_policyLevel"
    SORT_PROP_AAA_LDAP_EP_POLICY_OWNER = "aaa_LdapEp_policyOwner"
    SORT_PROP_AAA_LDAP_EP_RETRIES = "aaa_LdapEp_retries"
    SORT_PROP_AAA_LDAP_EP_TIMEOUT = "aaa_LdapEp_timeout"
    SORT_PROP_AAA_LDAP_GROUP_RULE_AUTHORIZATION = "aaa_LdapGroupRule_authorization"
    SORT_PROP_AAA_LDAP_GROUP_RULE_DESCR = "aaa_LdapGroupRule_descr"
    SORT_PROP_AAA_LDAP_GROUP_RULE_NAME = "aaa_LdapGroupRule_name"
    SORT_PROP_AAA_LDAP_GROUP_RULE_TARGET_ATTR = "aaa_LdapGroupRule_targetAttr"
    SORT_PROP_AAA_LDAP_GROUP_RULE_TRAVERSAL = "aaa_LdapGroupRule_traversal"
    SORT_PROP_AAA_LDAP_GROUP_RULE_USE_PRIMARY_GROUP = "aaa_LdapGroupRule_usePrimaryGroup"
    SORT_PROP_AAA_LDAP_GROUP_DESCR = "aaa_LdapGroup_descr"
    SORT_PROP_AAA_LDAP_GROUP_NAME = "aaa_LdapGroup_name"
    SORT_PROP_AAA_LDAP_PROVIDER_ATTRIBUTE = "aaa_LdapProvider_attribute"
    SORT_PROP_AAA_LDAP_PROVIDER_BASEDN = "aaa_LdapProvider_basedn"
    SORT_PROP_AAA_LDAP_PROVIDER_DESCR = "aaa_LdapProvider_descr"
    SORT_PROP_AAA_LDAP_PROVIDER_ENABLE_SSL = "aaa_LdapProvider_enableSSL"
    SORT_PROP_AAA_LDAP_PROVIDER_ENC_KEY = "aaa_LdapProvider_encKey"
    SORT_PROP_AAA_LDAP_PROVIDER_FILTER = "aaa_LdapProvider_filter"
    SORT_PROP_AAA_LDAP_PROVIDER_KEY = "aaa_LdapProvider_key"
    SORT_PROP_AAA_LDAP_PROVIDER_KEY_SET = "aaa_LdapProvider_keySet"
    SORT_PROP_AAA_LDAP_PROVIDER_NAME = "aaa_LdapProvider_name"
    SORT_PROP_AAA_LDAP_PROVIDER_ORDER = "aaa_LdapProvider_order"
    SORT_PROP_AAA_LDAP_PROVIDER_PORT = "aaa_LdapProvider_port"
    SORT_PROP_AAA_LDAP_PROVIDER_RETRIES = "aaa_LdapProvider_retries"
    SORT_PROP_AAA_LDAP_PROVIDER_ROOTDN = "aaa_LdapProvider_rootdn"
    SORT_PROP_AAA_LDAP_PROVIDER_TIMEOUT = "aaa_LdapProvider_timeout"
    SORT_PROP_AAA_LDAP_PROVIDER_VENDOR = "aaa_LdapProvider_vendor"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_CMDLINE = "aaa_LocalMgmtCmdLog_cmdline"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_DATE = "aaa_LocalMgmtCmdLog_date"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_HOST = "aaa_LocalMgmtCmdLog_host"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_SWITCH_ID = "aaa_LocalMgmtCmdLog_switchId"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_TERM = "aaa_LocalMgmtCmdLog_term"
    SORT_PROP_AAA_LOCAL_MGMT_CMD_LOG_USER = "aaa_LocalMgmtCmdLog_user"
    SORT_PROP_AAA_LOCALE_CONFIG_STATE = "aaa_Locale_configState"
    SORT_PROP_AAA_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_Locale_configStatusMessage"
    SORT_PROP_AAA_LOCALE_DESCR = "aaa_Locale_descr"
    SORT_PROP_AAA_LOCALE_INT_ID = "aaa_Locale_intId"
    SORT_PROP_AAA_LOCALE_NAME = "aaa_Locale_name"
    SORT_PROP_AAA_LOCALE_POLICY_LEVEL = "aaa_Locale_policyLevel"
    SORT_PROP_AAA_LOCALE_POLICY_OWNER = "aaa_Locale_policyOwner"
    SORT_PROP_AAA_LOG_MAX_SIZE = "aaa_Log_maxSize"
    SORT_PROP_AAA_LOG_PURGE_WINDOW = "aaa_Log_purgeWindow"
    SORT_PROP_AAA_LOG_SIZE = "aaa_Log_size"
    SORT_PROP_AAA_LOGIN_PROFILE_ADMIN_STATE = "aaa_LoginProfile_adminState"
    SORT_PROP_AAA_LOGIN_PROFILE_ATTEMPTED_WITHIN = "aaa_LoginProfile_attemptedWithin"
    SORT_PROP_AAA_LOGIN_PROFILE_BLOCK_LOGIN = "aaa_LoginProfile_blockLogin"
    SORT_PROP_AAA_LOGIN_PROFILE_DESCR = "aaa_LoginProfile_descr"
    SORT_PROP_AAA_LOGIN_PROFILE_FAILED_ATTEMPTS = "aaa_LoginProfile_failedAttempts"
    SORT_PROP_AAA_LOGIN_PROFILE_INT_ID = "aaa_LoginProfile_intId"
    SORT_PROP_AAA_LOGIN_PROFILE_NAME = "aaa_LoginProfile_name"
    SORT_PROP_AAA_LOGIN_PROFILE_POLICY_LEVEL = "aaa_LoginProfile_policyLevel"
    SORT_PROP_AAA_LOGIN_PROFILE_POLICY_OWNER = "aaa_LoginProfile_policyOwner"
    SORT_PROP_AAA_MOD_LR_AFFECTED = "aaa_ModLR_affected"
    SORT_PROP_AAA_MOD_LR_CAUSE = "aaa_ModLR_cause"
    SORT_PROP_AAA_MOD_LR_CHANGE_SET = "aaa_ModLR_changeSet"
    SORT_PROP_AAA_MOD_LR_CODE = "aaa_ModLR_code"
    SORT_PROP_AAA_MOD_LR_CREATED = "aaa_ModLR_created"
    SORT_PROP_AAA_MOD_LR_DESCR = "aaa_ModLR_descr"
    SORT_PROP_AAA_MOD_LR_ID = "aaa_ModLR_id"
    SORT_PROP_AAA_MOD_LR_IND = "aaa_ModLR_ind"
    SORT_PROP_AAA_MOD_LR_SESSION_ID = "aaa_ModLR_sessionId"
    SORT_PROP_AAA_MOD_LR_SEVERITY = "aaa_ModLR_severity"
    SORT_PROP_AAA_MOD_LR_TRIG = "aaa_ModLR_trig"
    SORT_PROP_AAA_MOD_LR_TX_ID = "aaa_ModLR_txId"
    SORT_PROP_AAA_MOD_LR_USER = "aaa_ModLR_user"
    SORT_PROP_AAA_ORG_CONFIG_STATE = "aaa_Org_configState"
    SORT_PROP_AAA_ORG_CONFIG_STATUS_MESSAGE = "aaa_Org_configStatusMessage"
    SORT_PROP_AAA_ORG_DESCR = "aaa_Org_descr"
    SORT_PROP_AAA_ORG_NAME = "aaa_Org_name"
    SORT_PROP_AAA_ORG_ORG_DN = "aaa_Org_orgDn"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_DESCR = "aaa_PreLoginBanner_descr"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_INT_ID = "aaa_PreLoginBanner_intId"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_MESSAGE = "aaa_PreLoginBanner_message"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_NAME = "aaa_PreLoginBanner_name"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_POLICY_LEVEL = "aaa_PreLoginBanner_policyLevel"
    SORT_PROP_AAA_PRE_LOGIN_BANNER_POLICY_OWNER = "aaa_PreLoginBanner_policyOwner"
    SORT_PROP_AAA_PROVIDER_GROUP_CONFIG_STATE = "aaa_ProviderGroup_configState"
    SORT_PROP_AAA_PROVIDER_GROUP_DESCR = "aaa_ProviderGroup_descr"
    SORT_PROP_AAA_PROVIDER_GROUP_NAME = "aaa_ProviderGroup_name"
    SORT_PROP_AAA_PROVIDER_GROUP_SIZE = "aaa_ProviderGroup_size"
    SORT_PROP_AAA_PROVIDER_REF_DESCR = "aaa_ProviderRef_descr"
    SORT_PROP_AAA_PROVIDER_REF_NAME = "aaa_ProviderRef_name"
    SORT_PROP_AAA_PROVIDER_REF_ORDER = "aaa_ProviderRef_order"
    SORT_PROP_AAA_PROVIDER_DESCR = "aaa_Provider_descr"
    SORT_PROP_AAA_PROVIDER_ENC_KEY = "aaa_Provider_encKey"
    SORT_PROP_AAA_PROVIDER_KEY = "aaa_Provider_key"
    SORT_PROP_AAA_PROVIDER_KEY_SET = "aaa_Provider_keySet"
    SORT_PROP_AAA_PROVIDER_NAME = "aaa_Provider_name"
    SORT_PROP_AAA_PROVIDER_ORDER = "aaa_Provider_order"
    SORT_PROP_AAA_PROVIDER_RETRIES = "aaa_Provider_retries"
    SORT_PROP_AAA_PROVIDER_TIMEOUT = "aaa_Provider_timeout"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_COUNT = "aaa_PwdProfile_changeCount"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_DURING_INTERVAL = "aaa_PwdProfile_changeDuringInterval"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_INTERVAL = "aaa_PwdProfile_changeInterval"
    SORT_PROP_AAA_PWD_PROFILE_DESCR = "aaa_PwdProfile_descr"
    SORT_PROP_AAA_PWD_PROFILE_ENABLE_PWDEXPIRY = "aaa_PwdProfile_enablePWDExpiry"
    SORT_PROP_AAA_PWD_PROFILE_EXPIRATION_PERIOD = "aaa_PwdProfile_expirationPeriod"
    SORT_PROP_AAA_PWD_PROFILE_EXPIRATION_WARN_TIME = "aaa_PwdProfile_expirationWarnTime"
    SORT_PROP_AAA_PWD_PROFILE_HISTORY_COUNT = "aaa_PwdProfile_historyCount"
    SORT_PROP_AAA_PWD_PROFILE_INT_ID = "aaa_PwdProfile_intId"
    SORT_PROP_AAA_PWD_PROFILE_MIN_PASSPHRASE_LEN = "aaa_PwdProfile_minPassphraseLen"
    SORT_PROP_AAA_PWD_PROFILE_NAME = "aaa_PwdProfile_name"
    SORT_PROP_AAA_PWD_PROFILE_NO_CHANGE_INTERVAL = "aaa_PwdProfile_noChangeInterval"
    SORT_PROP_AAA_PWD_PROFILE_POLICY_LEVEL = "aaa_PwdProfile_policyLevel"
    SORT_PROP_AAA_PWD_PROFILE_POLICY_OWNER = "aaa_PwdProfile_policyOwner"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEpFsmStage_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RadiusEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_NAME = "aaa_RadiusEpFsmStage_name"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_ORDER = "aaa_RadiusEpFsmStage_order"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_RETRY = "aaa_RadiusEpFsmStage_retry"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_RadiusEpFsmStage_stageStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_COMPLETION_TIME = "aaa_RadiusEpFsm_completionTime"
    SORT_PROP_AAA_RADIUS_EP_FSM_CURRENT_FSM = "aaa_RadiusEpFsm_currentFsm"
    SORT_PROP_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEpFsm_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_FSM_STATUS = "aaa_RadiusEpFsm_fsmStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_INSTANCE_ID = "aaa_RadiusEpFsm_instanceId"
    SORT_PROP_AAA_RADIUS_EP_FSM_PROGRESS = "aaa_RadiusEpFsm_progress"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_ERR_CODE = "aaa_RadiusEpFsm_rmtErrCode"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_ERR_DESCR = "aaa_RadiusEpFsm_rmtErrDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_RSLT = "aaa_RadiusEpFsm_rmtRslt"
    SORT_PROP_AAA_RADIUS_EP_DESCR = "aaa_RadiusEp_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEp_fsmDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_PREV = "aaa_RadiusEp_fsmPrev"
    SORT_PROP_AAA_RADIUS_EP_FSM_PROGR = "aaa_RadiusEp_fsmProgr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_RadiusEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_RadiusEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_RSLT = "aaa_RadiusEp_fsmRmtInvRslt"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEp_fsmStageDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAMP = "aaa_RadiusEp_fsmStamp"
    SORT_PROP_AAA_RADIUS_EP_FSM_STATUS = "aaa_RadiusEp_fsmStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_TRY = "aaa_RadiusEp_fsmTry"
    SORT_PROP_AAA_RADIUS_EP_INT_ID = "aaa_RadiusEp_intId"
    SORT_PROP_AAA_RADIUS_EP_NAME = "aaa_RadiusEp_name"
    SORT_PROP_AAA_RADIUS_EP_POLICY_LEVEL = "aaa_RadiusEp_policyLevel"
    SORT_PROP_AAA_RADIUS_EP_POLICY_OWNER = "aaa_RadiusEp_policyOwner"
    SORT_PROP_AAA_RADIUS_EP_RETRIES = "aaa_RadiusEp_retries"
    SORT_PROP_AAA_RADIUS_EP_TIMEOUT = "aaa_RadiusEp_timeout"
    SORT_PROP_AAA_RADIUS_PROVIDER_AUTH_PORT = "aaa_RadiusProvider_authPort"
    SORT_PROP_AAA_RADIUS_PROVIDER_DESCR = "aaa_RadiusProvider_descr"
    SORT_PROP_AAA_RADIUS_PROVIDER_ENC_KEY = "aaa_RadiusProvider_encKey"
    SORT_PROP_AAA_RADIUS_PROVIDER_KEY = "aaa_RadiusProvider_key"
    SORT_PROP_AAA_RADIUS_PROVIDER_KEY_SET = "aaa_RadiusProvider_keySet"
    SORT_PROP_AAA_RADIUS_PROVIDER_NAME = "aaa_RadiusProvider_name"
    SORT_PROP_AAA_RADIUS_PROVIDER_ORDER = "aaa_RadiusProvider_order"
    SORT_PROP_AAA_RADIUS_PROVIDER_RETRIES = "aaa_RadiusProvider_retries"
    SORT_PROP_AAA_RADIUS_PROVIDER_SERVICE = "aaa_RadiusProvider_service"
    SORT_PROP_AAA_RADIUS_PROVIDER_TIMEOUT = "aaa_RadiusProvider_timeout"
    SORT_PROP_AAA_REALM_FSM_STAGE_DESCR = "aaa_RealmFsmStage_descr"
    SORT_PROP_AAA_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RealmFsmStage_lastUpdateTime"
    SORT_PROP_AAA_REALM_FSM_STAGE_NAME = "aaa_RealmFsmStage_name"
    SORT_PROP_AAA_REALM_FSM_STAGE_ORDER = "aaa_RealmFsmStage_order"
    SORT_PROP_AAA_REALM_FSM_STAGE_RETRY = "aaa_RealmFsmStage_retry"
    SORT_PROP_AAA_REALM_FSM_STAGE_STAGE_STATUS = "aaa_RealmFsmStage_stageStatus"
    SORT_PROP_AAA_REALM_FSM_TASK_COMPLETION = "aaa_RealmFsmTask_completion"
    SORT_PROP_AAA_REALM_FSM_TASK_FLAGS = "aaa_RealmFsmTask_flags"
    SORT_PROP_AAA_REALM_FSM_TASK_ITEM = "aaa_RealmFsmTask_item"
    SORT_PROP_AAA_REALM_FSM_TASK_SEQ_ID = "aaa_RealmFsmTask_seqId"
    SORT_PROP_AAA_REALM_FSM_COMPLETION_TIME = "aaa_RealmFsm_completionTime"
    SORT_PROP_AAA_REALM_FSM_CURRENT_FSM = "aaa_RealmFsm_currentFsm"
    SORT_PROP_AAA_REALM_FSM_DESCR = "aaa_RealmFsm_descr"
    SORT_PROP_AAA_REALM_FSM_FSM_STATUS = "aaa_RealmFsm_fsmStatus"
    SORT_PROP_AAA_REALM_FSM_INSTANCE_ID = "aaa_RealmFsm_instanceId"
    SORT_PROP_AAA_REALM_FSM_PROGRESS = "aaa_RealmFsm_progress"
    SORT_PROP_AAA_REALM_FSM_RMT_ERR_CODE = "aaa_RealmFsm_rmtErrCode"
    SORT_PROP_AAA_REALM_FSM_RMT_ERR_DESCR = "aaa_RealmFsm_rmtErrDescr"
    SORT_PROP_AAA_REALM_FSM_RMT_RSLT = "aaa_RealmFsm_rmtRslt"
    SORT_PROP_AAA_REALM_DESCR = "aaa_Realm_descr"
    SORT_PROP_AAA_REALM_FSM_DESCR = "aaa_Realm_fsmDescr"
    SORT_PROP_AAA_REALM_FSM_PREV = "aaa_Realm_fsmPrev"
    SORT_PROP_AAA_REALM_FSM_PROGR = "aaa_Realm_fsmProgr"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_ERR_CODE = "aaa_Realm_fsmRmtInvErrCode"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_Realm_fsmRmtInvErrDescr"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_RSLT = "aaa_Realm_fsmRmtInvRslt"
    SORT_PROP_AAA_REALM_FSM_STAGE_DESCR = "aaa_Realm_fsmStageDescr"
    SORT_PROP_AAA_REALM_FSM_STAMP = "aaa_Realm_fsmStamp"
    SORT_PROP_AAA_REALM_FSM_STATUS = "aaa_Realm_fsmStatus"
    SORT_PROP_AAA_REALM_FSM_TRY = "aaa_Realm_fsmTry"
    SORT_PROP_AAA_REALM_INT_ID = "aaa_Realm_intId"
    SORT_PROP_AAA_REALM_NAME = "aaa_Realm_name"
    SORT_PROP_AAA_REALM_POLICY_LEVEL = "aaa_Realm_policyLevel"
    SORT_PROP_AAA_REALM_POLICY_OWNER = "aaa_Realm_policyOwner"
    SORT_PROP_AAA_REMOTE_USER_CONFIG_STATE = "aaa_RemoteUser_configState"
    SORT_PROP_AAA_REMOTE_USER_CONFIG_STATUS_MESSAGE = "aaa_RemoteUser_configStatusMessage"
    SORT_PROP_AAA_REMOTE_USER_DESCR = "aaa_RemoteUser_descr"
    SORT_PROP_AAA_REMOTE_USER_NAME = "aaa_RemoteUser_name"
    SORT_PROP_AAA_REMOTE_USER_PWD = "aaa_RemoteUser_pwd"
    SORT_PROP_AAA_REMOTE_USER_PWD_SET = "aaa_RemoteUser_pwdSet"
    SORT_PROP_AAA_ROLE_CONFIG_STATE = "aaa_Role_configState"
    SORT_PROP_AAA_ROLE_CONFIG_STATUS_MESSAGE = "aaa_Role_configStatusMessage"
    SORT_PROP_AAA_ROLE_DESCR = "aaa_Role_descr"
    SORT_PROP_AAA_ROLE_INT_ID = "aaa_Role_intId"
    SORT_PROP_AAA_ROLE_NAME = "aaa_Role_name"
    SORT_PROP_AAA_ROLE_POLICY_LEVEL = "aaa_Role_policyLevel"
    SORT_PROP_AAA_ROLE_POLICY_OWNER = "aaa_Role_policyOwner"
    SORT_PROP_AAA_ROLE_PRIV = "aaa_Role_priv"
    SORT_PROP_AAA_SESSION_INFO_ADDRESS = "aaa_SessionInfo_address"
    SORT_PROP_AAA_SESSION_INFO_DEST_IP = "aaa_SessionInfo_destIp"
    SORT_PROP_AAA_SESSION_INFO_ETIME = "aaa_SessionInfo_etime"
    SORT_PROP_AAA_SESSION_INFO_ID = "aaa_SessionInfo_id"
    SORT_PROP_AAA_SESSION_INFO_PRIV = "aaa_SessionInfo_priv"
    SORT_PROP_AAA_SESSION_INFO_TYPE = "aaa_SessionInfo_type"
    SORT_PROP_AAA_SESSION_INFO_USER = "aaa_SessionInfo_user"
    SORT_PROP_AAA_SESSION_INFO_USER_TYPE = "aaa_SessionInfo_userType"
    SORT_PROP_AAA_SESSION_LR_AFFECTED = "aaa_SessionLR_affected"
    SORT_PROP_AAA_SESSION_LR_CAUSE = "aaa_SessionLR_cause"
    SORT_PROP_AAA_SESSION_LR_CHANGE_SET = "aaa_SessionLR_changeSet"
    SORT_PROP_AAA_SESSION_LR_CODE = "aaa_SessionLR_code"
    SORT_PROP_AAA_SESSION_LR_CREATED = "aaa_SessionLR_created"
    SORT_PROP_AAA_SESSION_LR_DESCR = "aaa_SessionLR_descr"
    SORT_PROP_AAA_SESSION_LR_ID = "aaa_SessionLR_id"
    SORT_PROP_AAA_SESSION_LR_IND = "aaa_SessionLR_ind"
    SORT_PROP_AAA_SESSION_LR_SESSION_ID = "aaa_SessionLR_sessionId"
    SORT_PROP_AAA_SESSION_LR_SEVERITY = "aaa_SessionLR_severity"
    SORT_PROP_AAA_SESSION_LR_TRIG = "aaa_SessionLR_trig"
    SORT_PROP_AAA_SESSION_LR_TX_ID = "aaa_SessionLR_txId"
    SORT_PROP_AAA_SESSION_LR_USER = "aaa_SessionLR_user"
    SORT_PROP_AAA_SESSION_HOST = "aaa_Session_host"
    SORT_PROP_AAA_SESSION_ID = "aaa_Session_id"
    SORT_PROP_AAA_SESSION_INT_DEL = "aaa_Session_intDel"
    SORT_PROP_AAA_SESSION_LOGIN_TIME = "aaa_Session_loginTime"
    SORT_PROP_AAA_SESSION_PID = "aaa_Session_pid"
    SORT_PROP_AAA_SESSION_REFRESH_PERIOD = "aaa_Session_refreshPeriod"
    SORT_PROP_AAA_SESSION_SESSION_TIMEOUT = "aaa_Session_sessionTimeout"
    SORT_PROP_AAA_SESSION_SWITCH_ID = "aaa_Session_switchId"
    SORT_PROP_AAA_SESSION_TERM = "aaa_Session_term"
    SORT_PROP_AAA_SESSION_UI = "aaa_Session_ui"
    SORT_PROP_AAA_SESSION_USER = "aaa_Session_user"
    SORT_PROP_AAA_SHELL_LOGIN_DESCR = "aaa_ShellLogin_descr"
    SORT_PROP_AAA_SHELL_LOGIN_ID = "aaa_ShellLogin_id"
    SORT_PROP_AAA_SHELL_LOGIN_INT_ID = "aaa_ShellLogin_intId"
    SORT_PROP_AAA_SHELL_LOGIN_LOCAL_HOST = "aaa_ShellLogin_localHost"
    SORT_PROP_AAA_SHELL_LOGIN_NAME = "aaa_ShellLogin_name"
    SORT_PROP_AAA_SHELL_LOGIN_POLICY_LEVEL = "aaa_ShellLogin_policyLevel"
    SORT_PROP_AAA_SHELL_LOGIN_POLICY_OWNER = "aaa_ShellLogin_policyOwner"
    SORT_PROP_AAA_SHELL_LOGIN_REMOTE_HOST = "aaa_ShellLogin_remoteHost"
    SORT_PROP_AAA_SHELL_LOGIN_SESSION = "aaa_ShellLogin_session"
    SORT_PROP_AAA_SHELL_LOGIN_SWITCH_ID = "aaa_ShellLogin_switchId"
    SORT_PROP_AAA_SSH_AUTH_DATA = "aaa_SshAuth_data"
    SORT_PROP_AAA_SSH_AUTH_OLD_STR_TYPE = "aaa_SshAuth_oldStrType"
    SORT_PROP_AAA_SSH_AUTH_STR_TYPE = "aaa_SshAuth_strType"
    SORT_PROP_AAA_SYSTEM_USER_CONFIG_STATE = "aaa_SystemUser_configState"
    SORT_PROP_AAA_SYSTEM_USER_CONFIG_STATUS_MESSAGE = "aaa_SystemUser_configStatusMessage"
    SORT_PROP_AAA_SYSTEM_USER_DESCR = "aaa_SystemUser_descr"
    SORT_PROP_AAA_SYSTEM_USER_NAME = "aaa_SystemUser_name"
    SORT_PROP_AAA_SYSTEM_USER_PWD = "aaa_SystemUser_pwd"
    SORT_PROP_AAA_SYSTEM_USER_PWD_SET = "aaa_SystemUser_pwdSet"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEpFsmStage_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_TacacsPlusEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_NAME = "aaa_TacacsPlusEpFsmStage_name"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_ORDER = "aaa_TacacsPlusEpFsmStage_order"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_RETRY = "aaa_TacacsPlusEpFsmStage_retry"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_TacacsPlusEpFsmStage_stageStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_COMPLETION_TIME = "aaa_TacacsPlusEpFsm_completionTime"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_CURRENT_FSM = "aaa_TacacsPlusEpFsm_currentFsm"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEpFsm_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_FSM_STATUS = "aaa_TacacsPlusEpFsm_fsmStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_INSTANCE_ID = "aaa_TacacsPlusEpFsm_instanceId"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PROGRESS = "aaa_TacacsPlusEpFsm_progress"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_CODE = "aaa_TacacsPlusEpFsm_rmtErrCode"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_DESCR = "aaa_TacacsPlusEpFsm_rmtErrDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_RSLT = "aaa_TacacsPlusEpFsm_rmtRslt"
    SORT_PROP_AAA_TACACS_PLUS_EP_DESCR = "aaa_TacacsPlusEp_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEp_fsmDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PREV = "aaa_TacacsPlusEp_fsmPrev"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PROGR = "aaa_TacacsPlusEp_fsmProgr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_TacacsPlusEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_TacacsPlusEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_RSLT = "aaa_TacacsPlusEp_fsmRmtInvRslt"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEp_fsmStageDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAMP = "aaa_TacacsPlusEp_fsmStamp"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STATUS = "aaa_TacacsPlusEp_fsmStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_TRY = "aaa_TacacsPlusEp_fsmTry"
    SORT_PROP_AAA_TACACS_PLUS_EP_INT_ID = "aaa_TacacsPlusEp_intId"
    SORT_PROP_AAA_TACACS_PLUS_EP_NAME = "aaa_TacacsPlusEp_name"
    SORT_PROP_AAA_TACACS_PLUS_EP_POLICY_LEVEL = "aaa_TacacsPlusEp_policyLevel"
    SORT_PROP_AAA_TACACS_PLUS_EP_POLICY_OWNER = "aaa_TacacsPlusEp_policyOwner"
    SORT_PROP_AAA_TACACS_PLUS_EP_RETRIES = "aaa_TacacsPlusEp_retries"
    SORT_PROP_AAA_TACACS_PLUS_EP_TIMEOUT = "aaa_TacacsPlusEp_timeout"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_DESCR = "aaa_TacacsPlusProvider_descr"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_ENC_KEY = "aaa_TacacsPlusProvider_encKey"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_KEY = "aaa_TacacsPlusProvider_key"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_KEY_SET = "aaa_TacacsPlusProvider_keySet"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_NAME = "aaa_TacacsPlusProvider_name"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_ORDER = "aaa_TacacsPlusProvider_order"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_PORT = "aaa_TacacsPlusProvider_port"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_RETRIES = "aaa_TacacsPlusProvider_retries"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_TIMEOUT = "aaa_TacacsPlusProvider_timeout"
    SORT_PROP_AAA_USER_ACTION_AFFECTED = "aaa_UserAction_affected"
    SORT_PROP_AAA_USER_ACTION_CAUSE = "aaa_UserAction_cause"
    SORT_PROP_AAA_USER_ACTION_CHANGE_SET = "aaa_UserAction_changeSet"
    SORT_PROP_AAA_USER_ACTION_CODE = "aaa_UserAction_code"
    SORT_PROP_AAA_USER_ACTION_CREATED = "aaa_UserAction_created"
    SORT_PROP_AAA_USER_ACTION_DESCR = "aaa_UserAction_descr"
    SORT_PROP_AAA_USER_ACTION_ID = "aaa_UserAction_id"
    SORT_PROP_AAA_USER_ACTION_IND = "aaa_UserAction_ind"
    SORT_PROP_AAA_USER_ACTION_SESSION_ID = "aaa_UserAction_sessionId"
    SORT_PROP_AAA_USER_ACTION_SEVERITY = "aaa_UserAction_severity"
    SORT_PROP_AAA_USER_ACTION_TRIG = "aaa_UserAction_trig"
    SORT_PROP_AAA_USER_ACTION_TX_ID = "aaa_UserAction_txId"
    SORT_PROP_AAA_USER_ACTION_USER = "aaa_UserAction_user"
    SORT_PROP_AAA_USER_DATA_DESCR = "aaa_UserData_descr"
    SORT_PROP_AAA_USER_DATA_INT_ID = "aaa_UserData_intId"
    SORT_PROP_AAA_USER_DATA_NAME = "aaa_UserData_name"
    SORT_PROP_AAA_USER_DATA_POLICY_LEVEL = "aaa_UserData_policyLevel"
    SORT_PROP_AAA_USER_DATA_POLICY_OWNER = "aaa_UserData_policyOwner"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGE_COUNT = "aaa_UserData_pwdChangeCount"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGE_INTERVAL_BEGIN = "aaa_UserData_pwdChangeIntervalBegin"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGED_DATE = "aaa_UserData_pwdChangedDate"
    SORT_PROP_AAA_USER_DATA_PWD_HISTORY = "aaa_UserData_pwdHistory"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEpFsmStage_descr"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_UserEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_NAME = "aaa_UserEpFsmStage_name"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_ORDER = "aaa_UserEpFsmStage_order"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_RETRY = "aaa_UserEpFsmStage_retry"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_STAGE_STATUS = "aaa_UserEpFsmStage_stageStatus"
    SORT_PROP_AAA_USER_EP_FSM_TASK_COMPLETION = "aaa_UserEpFsmTask_completion"
    SORT_PROP_AAA_USER_EP_FSM_TASK_FLAGS = "aaa_UserEpFsmTask_flags"
    SORT_PROP_AAA_USER_EP_FSM_TASK_ITEM = "aaa_UserEpFsmTask_item"
    SORT_PROP_AAA_USER_EP_FSM_TASK_SEQ_ID = "aaa_UserEpFsmTask_seqId"
    SORT_PROP_AAA_USER_EP_FSM_COMPLETION_TIME = "aaa_UserEpFsm_completionTime"
    SORT_PROP_AAA_USER_EP_FSM_CURRENT_FSM = "aaa_UserEpFsm_currentFsm"
    SORT_PROP_AAA_USER_EP_FSM_DESCR = "aaa_UserEpFsm_descr"
    SORT_PROP_AAA_USER_EP_FSM_FSM_STATUS = "aaa_UserEpFsm_fsmStatus"
    SORT_PROP_AAA_USER_EP_FSM_INSTANCE_ID = "aaa_UserEpFsm_instanceId"
    SORT_PROP_AAA_USER_EP_FSM_PROGRESS = "aaa_UserEpFsm_progress"
    SORT_PROP_AAA_USER_EP_FSM_RMT_ERR_CODE = "aaa_UserEpFsm_rmtErrCode"
    SORT_PROP_AAA_USER_EP_FSM_RMT_ERR_DESCR = "aaa_UserEpFsm_rmtErrDescr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_RSLT = "aaa_UserEpFsm_rmtRslt"
    SORT_PROP_AAA_USER_EP_DESCR = "aaa_UserEp_descr"
    SORT_PROP_AAA_USER_EP_FSM_DESCR = "aaa_UserEp_fsmDescr"
    SORT_PROP_AAA_USER_EP_FSM_PREV = "aaa_UserEp_fsmPrev"
    SORT_PROP_AAA_USER_EP_FSM_PROGR = "aaa_UserEp_fsmProgr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_ERR_CODE = "aaa_UserEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_ERR_DESCR = "aaa_UserEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_RSLT = "aaa_UserEp_fsmRmtInvRslt"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEp_fsmStageDescr"
    SORT_PROP_AAA_USER_EP_FSM_STAMP = "aaa_UserEp_fsmStamp"
    SORT_PROP_AAA_USER_EP_FSM_STATUS = "aaa_UserEp_fsmStatus"
    SORT_PROP_AAA_USER_EP_FSM_TRY = "aaa_UserEp_fsmTry"
    SORT_PROP_AAA_USER_EP_INT_ID = "aaa_UserEp_intId"
    SORT_PROP_AAA_USER_EP_NAME = "aaa_UserEp_name"
    SORT_PROP_AAA_USER_EP_POLICY_LEVEL = "aaa_UserEp_policyLevel"
    SORT_PROP_AAA_USER_EP_POLICY_OWNER = "aaa_UserEp_policyOwner"
    SORT_PROP_AAA_USER_EP_PWD_STRENGTH_CHECK = "aaa_UserEp_pwdStrengthCheck"
    SORT_PROP_AAA_USER_GROUP_DESCR = "aaa_UserGroup_descr"
    SORT_PROP_AAA_USER_GROUP_NAME = "aaa_UserGroup_name"
    SORT_PROP_AAA_USER_LOCALE_CONFIG_STATE = "aaa_UserLocale_configState"
    SORT_PROP_AAA_USER_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_UserLocale_configStatusMessage"
    SORT_PROP_AAA_USER_LOCALE_DESCR = "aaa_UserLocale_descr"
    SORT_PROP_AAA_USER_LOCALE_NAME = "aaa_UserLocale_name"
    SORT_PROP_AAA_USER_LOGIN_DESCR = "aaa_UserLogin_descr"
    SORT_PROP_AAA_USER_LOGIN_ID = "aaa_UserLogin_id"
    SORT_PROP_AAA_USER_LOGIN_INT_ID = "aaa_UserLogin_intId"
    SORT_PROP_AAA_USER_LOGIN_LOCAL_HOST = "aaa_UserLogin_localHost"
    SORT_PROP_AAA_USER_LOGIN_NAME = "aaa_UserLogin_name"
    SORT_PROP_AAA_USER_LOGIN_POLICY_LEVEL = "aaa_UserLogin_policyLevel"
    SORT_PROP_AAA_USER_LOGIN_POLICY_OWNER = "aaa_UserLogin_policyOwner"
    SORT_PROP_AAA_USER_LOGIN_REMOTE_HOST = "aaa_UserLogin_remoteHost"
    SORT_PROP_AAA_USER_LOGIN_SESSION = "aaa_UserLogin_session"
    SORT_PROP_AAA_USER_LOGIN_SWITCH_ID = "aaa_UserLogin_switchId"
    SORT_PROP_AAA_USER_ROLE_CONFIG_STATE = "aaa_UserRole_configState"
    SORT_PROP_AAA_USER_ROLE_CONFIG_STATUS_MESSAGE = "aaa_UserRole_configStatusMessage"
    SORT_PROP_AAA_USER_ROLE_DESCR = "aaa_UserRole_descr"
    SORT_PROP_AAA_USER_ROLE_NAME = "aaa_UserRole_name"
    SORT_PROP_AAA_USER_ACCOUNT_STATUS = "aaa_User_accountStatus"
    SORT_PROP_AAA_USER_CLEAR_PWD_HISTORY = "aaa_User_clearPwdHistory"
    SORT_PROP_AAA_USER_CONFIG_STATE = "aaa_User_configState"
    SORT_PROP_AAA_USER_CONFIG_STATUS_MESSAGE = "aaa_User_configStatusMessage"
    SORT_PROP_AAA_USER_DESCR = "aaa_User_descr"
    SORT_PROP_AAA_USER_EMAIL = "aaa_User_email"
    SORT_PROP_AAA_USER_ENC_PWD = "aaa_User_encPwd"
    SORT_PROP_AAA_USER_ENC_PWD_SET = "aaa_User_encPwdSet"
    SORT_PROP_AAA_USER_EXPIRATION = "aaa_User_expiration"
    SORT_PROP_AAA_USER_EXPIRES = "aaa_User_expires"
    SORT_PROP_AAA_USER_FIRST_NAME = "aaa_User_firstName"
    SORT_PROP_AAA_USER_LAST_NAME = "aaa_User_lastName"
    SORT_PROP_AAA_USER_NAME = "aaa_User_name"
    SORT_PROP_AAA_USER_PASSWDEXPIRATION = "aaa_User_passwdexpiration"
    SORT_PROP_AAA_USER_PASSWDEXPIRYSTATUS = "aaa_User_passwdexpirystatus"
    SORT_PROP_AAA_USER_PHONE = "aaa_User_phone"
    SORT_PROP_AAA_USER_PRIV = "aaa_User_priv"
    SORT_PROP_AAA_USER_PWD = "aaa_User_pwd"
    SORT_PROP_AAA_USER_PWD_SET = "aaa_User_pwdSet"
    SORT_PROP_AAA_WEB_LOGIN_DESCR = "aaa_WebLogin_descr"
    SORT_PROP_AAA_WEB_LOGIN_ID = "aaa_WebLogin_id"
    SORT_PROP_AAA_WEB_LOGIN_INT_ID = "aaa_WebLogin_intId"
    SORT_PROP_AAA_WEB_LOGIN_LOCAL_HOST = "aaa_WebLogin_localHost"
    SORT_PROP_AAA_WEB_LOGIN_NAME = "aaa_WebLogin_name"
    SORT_PROP_AAA_WEB_LOGIN_POLICY_LEVEL = "aaa_WebLogin_policyLevel"
    SORT_PROP_AAA_WEB_LOGIN_POLICY_OWNER = "aaa_WebLogin_policyOwner"
    SORT_PROP_AAA_WEB_LOGIN_REMOTE_HOST = "aaa_WebLogin_remoteHost"
    SORT_PROP_AAA_WEB_LOGIN_SESSION = "aaa_WebLogin_session"
    SORT_PROP_AAA_WEB_LOGIN_SWITCH_ID = "aaa_WebLogin_switchId"
    SORT_PROP_ADAPTOR_AZURE_QOS_PROFILE_ADP_AZURE_QOS = "adaptor_AzureQosProfile_adpAzureQos"
    SORT_PROP_ADAPTOR_CIO_EP_EP_DN = "adaptor_CIoEp_epDn"
    SORT_PROP_ADAPTOR_CIO_EP_IF_ROLE = "adaptor_CIoEp_ifRole"
    SORT_PROP_ADAPTOR_CIO_EP_IF_TYPE = "adaptor_CIoEp_ifType"
    SORT_PROP_ADAPTOR_CIO_EP_LOCALE = "adaptor_CIoEp_locale"
    SORT_PROP_ADAPTOR_CIO_EP_NAME = "adaptor_CIoEp_name"
    SORT_PROP_ADAPTOR_CIO_EP_PEER_DN = "adaptor_CIoEp_peerDn"
    SORT_PROP_ADAPTOR_CIO_EP_PORT_ID = "adaptor_CIoEp_portId"
    SORT_PROP_ADAPTOR_CIO_EP_SWITCH_ID = "adaptor_CIoEp_switchId"
    SORT_PROP_ADAPTOR_CIO_EP_TRANSPORT = "adaptor_CIoEp_transport"
    SORT_PROP_ADAPTOR_CIO_EP_TYPE = "adaptor_CIoEp_type"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_HI = "adaptor_CapDef_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_LO = "adaptor_CapDef_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_OPR = "adaptor_CapDef_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_DEF_MAXIMUM = "adaptor_CapDef_maximum"
    SORT_PROP_ADAPTOR_CAP_DEF_NF_VERSION_LO = "adaptor_CapDef_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_DEF_TYPE = "adaptor_CapDef_type"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_HI = "adaptor_CapQual_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_LO = "adaptor_CapQual_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_OPR = "adaptor_CapQual_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_QUAL_MAXIMUM = "adaptor_CapQual_maximum"
    SORT_PROP_ADAPTOR_CAP_QUAL_MODEL = "adaptor_CapQual_model"
    SORT_PROP_ADAPTOR_CAP_QUAL_NF_VERSION_LO = "adaptor_CapQual_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_QUAL_TYPE = "adaptor_CapQual_type"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_HI = "adaptor_CapSpec_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_LO = "adaptor_CapSpec_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_OPR = "adaptor_CapSpec_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_SPEC_MAXIMUM = "adaptor_CapSpec_maximum"
    SORT_PROP_ADAPTOR_CAP_SPEC_NF_VERSION_LO = "adaptor_CapSpec_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_SPEC_TYPE = "adaptor_CapSpec_type"
    SORT_PROP_ADAPTOR_DIAG_CAP_ENABLE_LLDP_TRANSMIT = "adaptor_DiagCap_enableLldpTransmit"
    SORT_PROP_ADAPTOR_DYNAMIC_CONFIG_CAP_DYNAMIC_PARAMS = "adaptor_DynamicConfigCap_dynamicParams"
    SORT_PROP_ADAPTOR_DYNAMIC_CONFIG_CAP_FW_VERSION_HI = "adaptor_DynamicConfigCap_fwVersionHi"
    SORT_PROP_ADAPTOR_DYNAMIC_CONFIG_CAP_FW_VERSION_LO = "adaptor_DynamicConfigCap_fwVersionLo"
    SORT_PROP_ADAPTOR_DYNAMIC_CONFIG_CAP_FW_VERSION_OPER = "adaptor_DynamicConfigCap_fwVersionOper"
    SORT_PROP_ADAPTOR_ETH_ADV_FILTER_PROFILE_ADMIN_STATE = "adaptor_EthAdvFilterProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_ARFS_PROFILE_ACCELARATED_RFS = "adaptor_EthArfsProfile_accelaratedRFS"
    SORT_PROP_ADAPTOR_ETH_COMP_QUEUE_PROFILE_COUNT = "adaptor_EthCompQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_COMP_QUEUE_PROFILE_RING_SIZE = "adaptor_EthCompQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_FAILOVER_PROFILE_TIMEOUT = "adaptor_EthFailoverProfile_timeout"
    SORT_PROP_ADAPTOR_ETH_GENEVEPROFILE_OFFLOAD = "adaptor_EthGENEVEProfile_Offload"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TIME = "adaptor_EthInterruptProfile_coalescingTime"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TYPE = "adaptor_EthInterruptProfile_coalescingType"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COUNT = "adaptor_EthInterruptProfile_count"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_MODE = "adaptor_EthInterruptProfile_mode"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE_ADMIN_STATE = "adaptor_EthInterruptScalingProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_NVGREPROFILE_ADMIN_STATE = "adaptor_EthNVGREProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_LARGE_RECEIVE = "adaptor_EthOffloadProfile_largeReceive"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_RX_CHECKSUM = "adaptor_EthOffloadProfile_tcpRxChecksum"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_SEGMENT = "adaptor_EthOffloadProfile_tcpSegment"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_TX_CHECKSUM = "adaptor_EthOffloadProfile_tcpTxChecksum"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_ID = "adaptor_EthPortBySizeLargeStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeLargeStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeLargeStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeLargeStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_INTERVALS = "adaptor_EthPortBySizeLargeStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStats_lessThan2048"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan2048Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStats_lessThan4096"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan4096Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStats_lessThan8192"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan8192Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStats_lessThan9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_SUSPECT = "adaptor_EthPortBySizeLargeStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_THRESHOLDED = "adaptor_EthPortBySizeLargeStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeLargeStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_UPDATE = "adaptor_EthPortBySizeLargeStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64 = "adaptor_EthPortBySizeSmallStatsHist_equals64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_equals64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_ID = "adaptor_EthPortBySizeSmallStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128 = "adaptor_EthPortBySizeSmallStatsHist_lessThan128"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan128Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256 = "adaptor_EthPortBySizeSmallStatsHist_lessThan256"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan256Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512 = "adaptor_EthPortBySizeSmallStatsHist_lessThan512"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan512Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64 = "adaptor_EthPortBySizeSmallStatsHist_lessThan64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeSmallStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeSmallStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeSmallStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64 = "adaptor_EthPortBySizeSmallStats_equals64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStats_equals64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_equals64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_equals64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_equals64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_INTERVALS = "adaptor_EthPortBySizeSmallStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStats_lessThan1024"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan1024Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128 = "adaptor_EthPortBySizeSmallStats_lessThan128"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan128Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256 = "adaptor_EthPortBySizeSmallStats_lessThan256"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan256Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512 = "adaptor_EthPortBySizeSmallStats_lessThan512"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan512Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64 = "adaptor_EthPortBySizeSmallStats_lessThan64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_SUSPECT = "adaptor_EthPortBySizeSmallStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_THRESHOLDED = "adaptor_EthPortBySizeSmallStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeSmallStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_UPDATE = "adaptor_EthPortBySizeSmallStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS = "adaptor_EthPortErrStatsHist_badCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStatsHist_badLengthPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badLengthPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_ID = "adaptor_EthPortErrStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStatsHist_macDiscardedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MOST_RECENT = "adaptor_EthPortErrStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_SUSPECT = "adaptor_EthPortErrStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_THRESHOLDED = "adaptor_EthPortErrStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortErrStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS = "adaptor_EthPortErrStats_badCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStats_badCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStats_badLengthPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStats_badLengthPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badLengthPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badLengthPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badLengthPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_INTERVALS = "adaptor_EthPortErrStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStats_macDiscardedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStats_macDiscardedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_SUSPECT = "adaptor_EthPortErrStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_THRESHOLDED = "adaptor_EthPortErrStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_TIME_COLLECTED = "adaptor_EthPortErrStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortErrStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_UPDATE = "adaptor_EthPortErrStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS = "adaptor_EthPortMcastStatsHist_broadcastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_broadcastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_ID = "adaptor_EthPortMcastStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MOST_RECENT = "adaptor_EthPortMcastStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS = "adaptor_EthPortMcastStatsHist_multicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_multicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_SUSPECT = "adaptor_EthPortMcastStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_THRESHOLDED = "adaptor_EthPortMcastStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortMcastStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS = "adaptor_EthPortMcastStatsHist_unicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_unicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS = "adaptor_EthPortMcastStats_broadcastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_broadcastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_INTERVALS = "adaptor_EthPortMcastStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS = "adaptor_EthPortMcastStats_multicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_multicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_multicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_multicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_multicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_SUSPECT = "adaptor_EthPortMcastStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_THRESHOLDED = "adaptor_EthPortMcastStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_TIME_COLLECTED = "adaptor_EthPortMcastStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortMcastStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS = "adaptor_EthPortMcastStats_unicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_unicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_unicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_unicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_unicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UPDATE = "adaptor_EthPortMcastStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_ID = "adaptor_EthPortOutsizedStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_MOST_RECENT = "adaptor_EthPortOutsizedStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_SUSPECT = "adaptor_EthPortOutsizedStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_THRESHOLDED = "adaptor_EthPortOutsizedStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortOutsizedStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_INTERVALS = "adaptor_EthPortOutsizedStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStats_oversizedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_SUSPECT = "adaptor_EthPortOutsizedStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_THRESHOLDED = "adaptor_EthPortOutsizedStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TIME_COLLECTED = "adaptor_EthPortOutsizedStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortOutsizedStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UPDATE = "adaptor_EthPortOutsizedStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS = "adaptor_EthPortStatsHist_goodPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA = "adaptor_EthPortStatsHist_goodPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_goodPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_goodPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_goodPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_ID = "adaptor_EthPortStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_MOST_RECENT = "adaptor_EthPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS = "adaptor_EthPortStatsHist_pausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_pausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStatsHist_perPriorityPausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_perPriorityPausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS = "adaptor_EthPortStatsHist_pppPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA = "adaptor_EthPortStatsHist_pppPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pppPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pppPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pppPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_SUSPECT = "adaptor_EthPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_THRESHOLDED = "adaptor_EthPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS = "adaptor_EthPortStatsHist_totalPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA = "adaptor_EthPortStatsHist_totalPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS = "adaptor_EthPortStatsHist_vlanPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA = "adaptor_EthPortStatsHist_vlanPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_vlanPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_vlanPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_vlanPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS = "adaptor_EthPortStats_goodPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA = "adaptor_EthPortStats_goodPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStats_goodPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStats_goodPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStats_goodPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_INTERVALS = "adaptor_EthPortStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS = "adaptor_EthPortStats_pausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_pausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStats_perPriorityPausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_perPriorityPausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_perPriorityPausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS = "adaptor_EthPortStats_pppPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA = "adaptor_EthPortStats_pppPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pppPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pppPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pppPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_SUSPECT = "adaptor_EthPortStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_THRESHOLDED = "adaptor_EthPortStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TIME_COLLECTED = "adaptor_EthPortStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS = "adaptor_EthPortStats_totalPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA = "adaptor_EthPortStats_totalPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStats_totalPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStats_totalPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStats_totalPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_UPDATE = "adaptor_EthPortStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS = "adaptor_EthPortStats_vlanPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA = "adaptor_EthPortStats_vlanPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStats_vlanPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStats_vlanPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStats_vlanPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_QUEUE_PROFILE_COUNT = "adaptor_EthQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_QUEUE_PROFILE_RING_SIZE = "adaptor_EthQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_RECV_QUEUE_PROFILE_COUNT = "adaptor_EthRecvQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_EthRecvQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_ADMIN_STATE = "adaptor_EthRoCEProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_COS = "adaptor_EthRoCEProfile_cos"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_MEMORY_REGIONS = "adaptor_EthRoCEProfile_memoryRegions"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_PRIO = "adaptor_EthRoCEProfile_prio"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_QUEUE_PAIRS = "adaptor_EthRoCEProfile_queuePairs"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_RESOURCE_GROUPS = "adaptor_EthRoCEProfile_resourceGroups"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_V1 = "adaptor_EthRoCEProfile_v1"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_V2 = "adaptor_EthRoCEProfile_v2"
    SORT_PROP_ADAPTOR_ETH_VX_LANPROFILE_ADMIN_STATE = "adaptor_EthVxLANProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_WORK_QUEUE_PROFILE_COUNT = "adaptor_EthWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_EthWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_ID = "adaptor_EtherIfStatsHist_id"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_MOST_RECENT = "adaptor_EtherIfStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES = "adaptor_EtherIfStatsHist_rxBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA = "adaptor_EtherIfStatsHist_rxBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_rxBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_rxBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_rxBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED = "adaptor_EtherIfStatsHist_rxDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_rxDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_rxDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_rxDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_rxDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS = "adaptor_EtherIfStatsHist_rxErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_rxErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS = "adaptor_EtherIfStatsHist_rxPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_rxPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_SUSPECT = "adaptor_EtherIfStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_THRESHOLDED = "adaptor_EtherIfStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TIME_COLLECTED = "adaptor_EtherIfStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES = "adaptor_EtherIfStatsHist_txBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA = "adaptor_EtherIfStatsHist_txBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_txBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_txBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_txBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED = "adaptor_EtherIfStatsHist_txDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_txDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_txDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_txDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_txDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS = "adaptor_EtherIfStatsHist_txErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_txErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_txErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_txErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_txErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS = "adaptor_EtherIfStatsHist_txPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_txPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_txPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_txPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_txPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_INTERVALS = "adaptor_EtherIfStats_intervals"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES = "adaptor_EtherIfStats_rxBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA = "adaptor_EtherIfStats_rxBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_rxBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_rxBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_rxBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED = "adaptor_EtherIfStats_rxDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA = "adaptor_EtherIfStats_rxDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_rxDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_rxDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_rxDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS = "adaptor_EtherIfStats_rxErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA = "adaptor_EtherIfStats_rxErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_rxErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_rxErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_rxErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS = "adaptor_EtherIfStats_rxPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA = "adaptor_EtherIfStats_rxPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_rxPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_rxPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_rxPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_SUSPECT = "adaptor_EtherIfStats_suspect"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_THRESHOLDED = "adaptor_EtherIfStats_thresholded"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TIME_COLLECTED = "adaptor_EtherIfStats_timeCollected"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES = "adaptor_EtherIfStats_txBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA = "adaptor_EtherIfStats_txBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_txBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_txBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_txBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED = "adaptor_EtherIfStats_txDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA = "adaptor_EtherIfStats_txDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_txDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_txDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_txDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS = "adaptor_EtherIfStats_txErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA = "adaptor_EtherIfStats_txErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_txErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_txErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_txErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS = "adaptor_EtherIfStats_txPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA = "adaptor_EtherIfStats_txPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_txPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_txPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_txPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_UPDATE = "adaptor_EtherIfStats_update"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_DESCR = "adaptor_ExtEthIfFsmStage_descr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_ExtEthIfFsmStage_lastUpdateTime"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_NAME = "adaptor_ExtEthIfFsmStage_name"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_ORDER = "adaptor_ExtEthIfFsmStage_order"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_RETRY = "adaptor_ExtEthIfFsmStage_retry"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_STAGE_STATUS = "adaptor_ExtEthIfFsmStage_stageStatus"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_TASK_COMPLETION = "adaptor_ExtEthIfFsmTask_completion"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_TASK_FLAGS = "adaptor_ExtEthIfFsmTask_flags"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_TASK_ITEM = "adaptor_ExtEthIfFsmTask_item"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_TASK_SEQ_ID = "adaptor_ExtEthIfFsmTask_seqId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_COMPLETION_TIME = "adaptor_ExtEthIfFsm_completionTime"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_CURRENT_FSM = "adaptor_ExtEthIfFsm_currentFsm"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_DESCR = "adaptor_ExtEthIfFsm_descr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_FSM_STATUS = "adaptor_ExtEthIfFsm_fsmStatus"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_INSTANCE_ID = "adaptor_ExtEthIfFsm_instanceId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_PROGRESS = "adaptor_ExtEthIfFsm_progress"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_ERR_CODE = "adaptor_ExtEthIfFsm_rmtErrCode"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_ERR_DESCR = "adaptor_ExtEthIfFsm_rmtErrDescr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_RSLT = "adaptor_ExtEthIfFsm_rmtRslt"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_AGGR_PORT_ID = "adaptor_ExtEthIfPcEp_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_CHASSIS_ID = "adaptor_ExtEthIfPcEp_chassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_EP_DN = "adaptor_ExtEthIfPcEp_epDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_IF_ROLE = "adaptor_ExtEthIfPcEp_ifRole"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_IF_TYPE = "adaptor_ExtEthIfPcEp_ifType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_LOCALE = "adaptor_ExtEthIfPcEp_locale"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_MEMBERSHIP = "adaptor_ExtEthIfPcEp_membership"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_NAME = "adaptor_ExtEthIfPcEp_name"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_AGGR_PORT_ID = "adaptor_ExtEthIfPcEp_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_CHASSIS_ID = "adaptor_ExtEthIfPcEp_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_DN = "adaptor_ExtEthIfPcEp_peerDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_PORT_ID = "adaptor_ExtEthIfPcEp_peerPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_SLOT_ID = "adaptor_ExtEthIfPcEp_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_PORT_ID = "adaptor_ExtEthIfPcEp_portId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_SLOT_ID = "adaptor_ExtEthIfPcEp_slotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_SWITCH_ID = "adaptor_ExtEthIfPcEp_switchId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_TRANSPORT = "adaptor_ExtEthIfPcEp_transport"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_TYPE = "adaptor_ExtEthIfPcEp_type"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_EP_DN = "adaptor_ExtEthIfPc_epDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_FLT_AGGR = "adaptor_ExtEthIfPc_fltAggr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_IF_ROLE = "adaptor_ExtEthIfPc_ifRole"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_IF_TYPE = "adaptor_ExtEthIfPc_ifType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_LOCALE = "adaptor_ExtEthIfPc_locale"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_MAC = "adaptor_ExtEthIfPc_mac"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_NAME = "adaptor_ExtEthIfPc_name"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_OPER_SPEED = "adaptor_ExtEthIfPc_operSpeed"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_OPER_STATE = "adaptor_ExtEthIfPc_operState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_PEER_DN = "adaptor_ExtEthIfPc_peerDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_PORT_ID = "adaptor_ExtEthIfPc_portId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_STATE_QUAL = "adaptor_ExtEthIfPc_stateQual"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_SWITCH_ID = "adaptor_ExtEthIfPc_switchId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_TRANSPORT = "adaptor_ExtEthIfPc_transport"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PC_TYPE = "adaptor_ExtEthIfPc_type"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ADAPTER_ID = "adaptor_ExtEthIf_adapterId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ADMIN_STATE = "adaptor_ExtEthIf_adminState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_AGGR_PORT_ID = "adaptor_ExtEthIf_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_CHASSIS_ID = "adaptor_ExtEthIf_chassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_DISCOVERY = "adaptor_ExtEthIf_discovery"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_EP_DN = "adaptor_ExtEthIf_epDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_DESCR = "adaptor_ExtEthIf_fsmDescr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_PREV = "adaptor_ExtEthIf_fsmPrev"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_PROGR = "adaptor_ExtEthIf_fsmProgr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_ERR_CODE = "adaptor_ExtEthIf_fsmRmtInvErrCode"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_ExtEthIf_fsmRmtInvErrDescr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_RSLT = "adaptor_ExtEthIf_fsmRmtInvRslt"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAGE_DESCR = "adaptor_ExtEthIf_fsmStageDescr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STAMP = "adaptor_ExtEthIf_fsmStamp"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_STATUS = "adaptor_ExtEthIf_fsmStatus"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_FSM_TRY = "adaptor_ExtEthIf_fsmTry"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ID = "adaptor_ExtEthIf_id"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_IF_ROLE = "adaptor_ExtEthIf_ifRole"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_IF_TYPE = "adaptor_ExtEthIf_ifType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LINK_STATE = "adaptor_ExtEthIf_linkState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LLDP_MAC = "adaptor_ExtEthIf_lldpMac"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LOCALE = "adaptor_ExtEthIf_locale"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_MAC = "adaptor_ExtEthIf_mac"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_MAC_ADDR_TYPE = "adaptor_ExtEthIf_macAddrType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_NAME = "adaptor_ExtEthIf_name"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPER_STATE = "adaptor_ExtEthIf_operState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPER_STATE_DESC = "adaptor_ExtEthIf_operStateDesc"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_AGGR_PORT_ID = "adaptor_ExtEthIf_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_CHASSIS_ID = "adaptor_ExtEthIf_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_DN = "adaptor_ExtEthIf_peerDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_PORT_ID = "adaptor_ExtEthIf_peerPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_SLOT_ID = "adaptor_ExtEthIf_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PHYS_EP_DN = "adaptor_ExtEthIf_physEpDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PORT_ID = "adaptor_ExtEthIf_portId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PURPOSE = "adaptor_ExtEthIf_purpose"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SIDE = "adaptor_ExtEthIf_side"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SLOT_ID = "adaptor_ExtEthIf_slotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SWITCH_ID = "adaptor_ExtEthIf_switchId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_TRANSPORT = "adaptor_ExtEthIf_transport"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_TYPE = "adaptor_ExtEthIf_type"
    SORT_PROP_ADAPTOR_EXT_IF_EP_AGGR_PORT_ID = "adaptor_ExtIfEp_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_CHASSIS_ID = "adaptor_ExtIfEp_chassisId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_EP_DN = "adaptor_ExtIfEp_epDn"
    SORT_PROP_ADAPTOR_EXT_IF_EP_IF_ROLE = "adaptor_ExtIfEp_ifRole"
    SORT_PROP_ADAPTOR_EXT_IF_EP_IF_TYPE = "adaptor_ExtIfEp_ifType"
    SORT_PROP_ADAPTOR_EXT_IF_EP_LOCALE = "adaptor_ExtIfEp_locale"
    SORT_PROP_ADAPTOR_EXT_IF_EP_NAME = "adaptor_ExtIfEp_name"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PEER_AGGR_PORT_ID = "adaptor_ExtIfEp_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PEER_CHASSIS_ID = "adaptor_ExtIfEp_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PEER_DN = "adaptor_ExtIfEp_peerDn"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PEER_PORT_ID = "adaptor_ExtIfEp_peerPortId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PEER_SLOT_ID = "adaptor_ExtIfEp_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_PORT_ID = "adaptor_ExtIfEp_portId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_SLOT_ID = "adaptor_ExtIfEp_slotId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_SWITCH_ID = "adaptor_ExtIfEp_switchId"
    SORT_PROP_ADAPTOR_EXT_IF_EP_TRANSPORT = "adaptor_ExtIfEp_transport"
    SORT_PROP_ADAPTOR_EXT_IF_EP_TYPE = "adaptor_ExtIfEp_type"
    SORT_PROP_ADAPTOR_EXT_IF_PC_EP_DN = "adaptor_ExtIfPc_epDn"
    SORT_PROP_ADAPTOR_EXT_IF_PC_FLT_AGGR = "adaptor_ExtIfPc_fltAggr"
    SORT_PROP_ADAPTOR_EXT_IF_PC_IF_ROLE = "adaptor_ExtIfPc_ifRole"
    SORT_PROP_ADAPTOR_EXT_IF_PC_IF_TYPE = "adaptor_ExtIfPc_ifType"
    SORT_PROP_ADAPTOR_EXT_IF_PC_LOCALE = "adaptor_ExtIfPc_locale"
    SORT_PROP_ADAPTOR_EXT_IF_PC_NAME = "adaptor_ExtIfPc_name"
    SORT_PROP_ADAPTOR_EXT_IF_PC_OPER_SPEED = "adaptor_ExtIfPc_operSpeed"
    SORT_PROP_ADAPTOR_EXT_IF_PC_OPER_STATE = "adaptor_ExtIfPc_operState"
    SORT_PROP_ADAPTOR_EXT_IF_PC_PEER_DN = "adaptor_ExtIfPc_peerDn"
    SORT_PROP_ADAPTOR_EXT_IF_PC_PORT_ID = "adaptor_ExtIfPc_portId"
    SORT_PROP_ADAPTOR_EXT_IF_PC_STATE_QUAL = "adaptor_ExtIfPc_stateQual"
    SORT_PROP_ADAPTOR_EXT_IF_PC_SWITCH_ID = "adaptor_ExtIfPc_switchId"
    SORT_PROP_ADAPTOR_EXT_IF_PC_TRANSPORT = "adaptor_ExtIfPc_transport"
    SORT_PROP_ADAPTOR_EXT_IF_PC_TYPE = "adaptor_ExtIfPc_type"
    SORT_PROP_ADAPTOR_EXT_IF_ADAPTER_ID = "adaptor_ExtIf_adapterId"
    SORT_PROP_ADAPTOR_EXT_IF_ADMIN_STATE = "adaptor_ExtIf_adminState"
    SORT_PROP_ADAPTOR_EXT_IF_AGGR_PORT_ID = "adaptor_ExtIf_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_CHASSIS_ID = "adaptor_ExtIf_chassisId"
    SORT_PROP_ADAPTOR_EXT_IF_DISCOVERY = "adaptor_ExtIf_discovery"
    SORT_PROP_ADAPTOR_EXT_IF_EP_DN = "adaptor_ExtIf_epDn"
    SORT_PROP_ADAPTOR_EXT_IF_ID = "adaptor_ExtIf_id"
    SORT_PROP_ADAPTOR_EXT_IF_IF_ROLE = "adaptor_ExtIf_ifRole"
    SORT_PROP_ADAPTOR_EXT_IF_IF_TYPE = "adaptor_ExtIf_ifType"
    SORT_PROP_ADAPTOR_EXT_IF_LINK_STATE = "adaptor_ExtIf_linkState"
    SORT_PROP_ADAPTOR_EXT_IF_LLDP_MAC = "adaptor_ExtIf_lldpMac"
    SORT_PROP_ADAPTOR_EXT_IF_LOCALE = "adaptor_ExtIf_locale"
    SORT_PROP_ADAPTOR_EXT_IF_MAC = "adaptor_ExtIf_mac"
    SORT_PROP_ADAPTOR_EXT_IF_NAME = "adaptor_ExtIf_name"
    SORT_PROP_ADAPTOR_EXT_IF_OPER_STATE = "adaptor_ExtIf_operState"
    SORT_PROP_ADAPTOR_EXT_IF_OPER_STATE_DESC = "adaptor_ExtIf_operStateDesc"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_AGGR_PORT_ID = "adaptor_ExtIf_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_CHASSIS_ID = "adaptor_ExtIf_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_DN = "adaptor_ExtIf_peerDn"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_PORT_ID = "adaptor_ExtIf_peerPortId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_SLOT_ID = "adaptor_ExtIf_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_IF_PHYS_EP_DN = "adaptor_ExtIf_physEpDn"
    SORT_PROP_ADAPTOR_EXT_IF_PORT_ID = "adaptor_ExtIf_portId"
    SORT_PROP_ADAPTOR_EXT_IF_PURPOSE = "adaptor_ExtIf_purpose"
    SORT_PROP_ADAPTOR_EXT_IF_SIDE = "adaptor_ExtIf_side"
    SORT_PROP_ADAPTOR_EXT_IF_SLOT_ID = "adaptor_ExtIf_slotId"
    SORT_PROP_ADAPTOR_EXT_IF_SWITCH_ID = "adaptor_ExtIf_switchId"
    SORT_PROP_ADAPTOR_EXT_IF_TRANSPORT = "adaptor_ExtIf_transport"
    SORT_PROP_ADAPTOR_EXT_IF_TYPE = "adaptor_ExtIf_type"
    SORT_PROP_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_ExtIpV6RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_ExtIpV6RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_AGGR_PORT_ID = "adaptor_ExternalEp_aggrPortId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_CHASSIS_ID = "adaptor_ExternalEp_chassisId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_EP_DN = "adaptor_ExternalEp_epDn"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_IF_ROLE = "adaptor_ExternalEp_ifRole"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_IF_TYPE = "adaptor_ExternalEp_ifType"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_LOCALE = "adaptor_ExternalEp_locale"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_NAME = "adaptor_ExternalEp_name"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PEER_AGGR_PORT_ID = "adaptor_ExternalEp_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PEER_CHASSIS_ID = "adaptor_ExternalEp_peerChassisId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PEER_DN = "adaptor_ExternalEp_peerDn"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PEER_PORT_ID = "adaptor_ExternalEp_peerPortId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PEER_SLOT_ID = "adaptor_ExternalEp_peerSlotId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_PORT_ID = "adaptor_ExternalEp_portId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_SLOT_ID = "adaptor_ExternalEp_slotId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_SWITCH_ID = "adaptor_ExternalEp_switchId"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_TRANSPORT = "adaptor_ExternalEp_transport"
    SORT_PROP_ADAPTOR_EXTERNAL_EP_TYPE = "adaptor_ExternalEp_type"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_EP_DN = "adaptor_ExternalPc_epDn"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_IF_ROLE = "adaptor_ExternalPc_ifRole"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_IF_TYPE = "adaptor_ExternalPc_ifType"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_LOCALE = "adaptor_ExternalPc_locale"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_NAME = "adaptor_ExternalPc_name"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_OPER_STATE = "adaptor_ExternalPc_operState"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_PEER_DN = "adaptor_ExternalPc_peerDn"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_PORT_ID = "adaptor_ExternalPc_portId"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_STATE_QUAL = "adaptor_ExternalPc_stateQual"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_SWITCH_ID = "adaptor_ExternalPc_switchId"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_TRANSPORT = "adaptor_ExternalPc_transport"
    SORT_PROP_ADAPTOR_EXTERNAL_PC_TYPE = "adaptor_ExternalPc_type"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_IS_MULTI_PORT = "adaptor_FamilyTypeDef_isMultiPort"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_IS_PASSTHROUGH = "adaptor_FamilyTypeDef_isPassthrough"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_IS_RETIMER_REQUIRED = "adaptor_FamilyTypeDef_isRetimerRequired"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_NUM_DCE_PORTS = "adaptor_FamilyTypeDef_numDcePorts"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_PORT_FAMILY = "adaptor_FamilyTypeDef_portFamily"
    SORT_PROP_ADAPTOR_FAMILY_TYPE_DEF_TYPE = "adaptor_FamilyTypeDef_type"
    SORT_PROP_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcCdbWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcCdbWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_ERROR_DETECT_TIMEOUT = "adaptor_FcErrorRecoveryProfile_errorDetectTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_FCP_ERROR_RECOVERY = "adaptor_FcErrorRecoveryProfile_fcpErrorRecovery"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_LINK_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_linkDownTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_IO_RETRY_COUNT = "adaptor_FcErrorRecoveryProfile_portDownIoRetryCount"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_portDownTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_RESOURCE_ALLOCATION_TIMEOUT = "adaptor_FcErrorRecoveryProfile_resourceAllocationTimeout"
    SORT_PROP_ADAPTOR_FC_FNIC_PROFILE_IO_RETRY_TIMEOUT = "adaptor_FcFnicProfile_ioRetryTimeout"
    SORT_PROP_ADAPTOR_FC_FNIC_PROFILE_LUN_QUEUE_DEPTH = "adaptor_FcFnicProfile_lunQueueDepth"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_ID = "adaptor_FcIfEventStatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT = "adaptor_FcIfEventStatsHist_invalidCRCCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStatsHist_invalidCRCCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT = "adaptor_FcIfEventStatsHist_linkFailureCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStatsHist_linkFailureCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT = "adaptor_FcIfEventStatsHist_lipCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lipCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lipCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lipCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lipCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStatsHist_lossOfSignalCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSignalCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStatsHist_lossOfSyncCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSyncCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_MOST_RECENT = "adaptor_FcIfEventStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT = "adaptor_FcIfEventStatsHist_nOSCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA = "adaptor_FcIfEventStatsHist_nOSCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_nOSCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_nOSCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_nOSCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStatsHist_secondsSinceLastReset"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStatsHist_seqProtocolErrCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SUSPECT = "adaptor_FcIfEventStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_THRESHOLDED = "adaptor_FcIfEventStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfEventStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INTERVALS = "adaptor_FcIfEventStats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT = "adaptor_FcIfEventStats_invalidCRCCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStats_invalidCRCCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_invalidCRCCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_invalidCRCCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_invalidCRCCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT = "adaptor_FcIfEventStats_linkFailureCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStats_linkFailureCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_linkFailureCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_linkFailureCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_linkFailureCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT = "adaptor_FcIfEventStats_lipCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA = "adaptor_FcIfEventStats_lipCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lipCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lipCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lipCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStats_lossOfSignalCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSignalCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSignalCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStats_lossOfSyncCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSyncCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSyncCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT = "adaptor_FcIfEventStats_nOSCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA = "adaptor_FcIfEventStats_nOSCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_nOSCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_nOSCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_nOSCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStats_secondsSinceLastReset"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStats_secondsSinceLastResetDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStats_seqProtocolErrCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStats_seqProtocolErrCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SUSPECT = "adaptor_FcIfEventStats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_THRESHOLDED = "adaptor_FcIfEventStats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_TIME_COLLECTED = "adaptor_FcIfEventStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_UPDATE = "adaptor_FcIfEventStats_update"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS = "adaptor_FcIfFC4StatsHist_controlRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_controlRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_ID = "adaptor_FcIfFC4StatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_inputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_inputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_inputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_inputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_MOST_RECENT = "adaptor_FcIfFC4StatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_outputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_outputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_outputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_outputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_SUSPECT = "adaptor_FcIfFC4StatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_THRESHOLDED = "adaptor_FcIfFC4StatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFC4StatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS = "adaptor_FcIfFC4Stats_controlRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_controlRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_controlRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_controlRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_controlRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES = "adaptor_FcIfFC4Stats_inputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_inputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_inputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS = "adaptor_FcIfFC4Stats_inputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_inputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_inputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_inputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_inputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INTERVALS = "adaptor_FcIfFC4Stats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES = "adaptor_FcIfFC4Stats_outputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_outputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_outputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS = "adaptor_FcIfFC4Stats_outputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_outputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_outputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_outputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_outputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_SUSPECT = "adaptor_FcIfFC4Stats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_THRESHOLDED = "adaptor_FcIfFC4Stats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_TIME_COLLECTED = "adaptor_FcIfFC4Stats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_UPDATE = "adaptor_FcIfFC4Stats_update"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES = "adaptor_FcIfFrameStatsHist_dumpedFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_dumpedFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES = "adaptor_FcIfFrameStatsHist_errorFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_errorFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_errorFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ID = "adaptor_FcIfFrameStatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_MOST_RECENT = "adaptor_FcIfFrameStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES = "adaptor_FcIfFrameStatsHist_rxFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_SUSPECT = "adaptor_FcIfFrameStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_THRESHOLDED = "adaptor_FcIfFrameStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFrameStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES = "adaptor_FcIfFrameStatsHist_txFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES = "adaptor_FcIfFrameStats_dumpedFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStats_dumpedFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_dumpedFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_dumpedFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_dumpedFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES = "adaptor_FcIfFrameStats_errorFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStats_errorFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_errorFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_errorFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_errorFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_INTERVALS = "adaptor_FcIfFrameStats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES = "adaptor_FcIfFrameStats_rxFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA = "adaptor_FcIfFrameStats_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_SUSPECT = "adaptor_FcIfFrameStats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_THRESHOLDED = "adaptor_FcIfFrameStats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TIME_COLLECTED = "adaptor_FcIfFrameStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES = "adaptor_FcIfFrameStats_txFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA = "adaptor_FcIfFrameStats_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_UPDATE = "adaptor_FcIfFrameStats_update"
    SORT_PROP_ADAPTOR_FC_INTERRUPT_PROFILE_MODE = "adaptor_FcInterruptProfile_mode"
    SORT_PROP_ADAPTOR_FC_LOGI_PROFILE_RETRIES = "adaptor_FcLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_LOGI_PROFILE_TIMEOUT = "adaptor_FcLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_OEIF_EP_DN = "adaptor_FcOEIf_epDn"
    SORT_PROP_ADAPTOR_FC_OEIF_FCOE_VLAN = "adaptor_FcOEIf_fcoeVlan"
    SORT_PROP_ADAPTOR_FC_OEIF_ID = "adaptor_FcOEIf_id"
    SORT_PROP_ADAPTOR_FC_OEIF_IF_ROLE = "adaptor_FcOEIf_ifRole"
    SORT_PROP_ADAPTOR_FC_OEIF_IF_TYPE = "adaptor_FcOEIf_ifType"
    SORT_PROP_ADAPTOR_FC_OEIF_LC = "adaptor_FcOEIf_lc"
    SORT_PROP_ADAPTOR_FC_OEIF_LOCALE = "adaptor_FcOEIf_locale"
    SORT_PROP_ADAPTOR_FC_OEIF_MAC = "adaptor_FcOEIf_mac"
    SORT_PROP_ADAPTOR_FC_OEIF_NAME = "adaptor_FcOEIf_name"
    SORT_PROP_ADAPTOR_FC_OEIF_OPER_STATE = "adaptor_FcOEIf_operState"
    SORT_PROP_ADAPTOR_FC_OEIF_PEER_DN = "adaptor_FcOEIf_peerDn"
    SORT_PROP_ADAPTOR_FC_OEIF_POLICY_OWNER = "adaptor_FcOEIf_policyOwner"
    SORT_PROP_ADAPTOR_FC_OEIF_SWITCH_ID = "adaptor_FcOEIf_switchId"
    SORT_PROP_ADAPTOR_FC_OEIF_TRANSPORT = "adaptor_FcOEIf_transport"
    SORT_PROP_ADAPTOR_FC_OEIF_TYPE = "adaptor_FcOEIf_type"
    SORT_PROP_ADAPTOR_FC_OEIF_ZONING_STATE = "adaptor_FcOEIf_zoningState"
    SORT_PROP_ADAPTOR_FC_PORT_FLOGI_PROFILE_RETRIES = "adaptor_FcPortFLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_PORT_FLOGI_PROFILE_TIMEOUT = "adaptor_FcPortFLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_PORT_PLOGI_PROFILE_RETRIES = "adaptor_FcPortPLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_PORT_PLOGI_PROFILE_TIMEOUT = "adaptor_FcPortPLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_PORT_PROFILE_IO_THROTTLE_COUNT = "adaptor_FcPortProfile_ioThrottleCount"
    SORT_PROP_ADAPTOR_FC_PORT_PROFILE_LUNS_PER_TARGET = "adaptor_FcPortProfile_lunsPerTarget"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_ID = "adaptor_FcPortStatsHist_id"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_MOST_RECENT = "adaptor_FcPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES = "adaptor_FcPortStatsHist_rxBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES = "adaptor_FcPortStatsHist_rxFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_SUSPECT = "adaptor_FcPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_THRESHOLDED = "adaptor_FcPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_FcPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES = "adaptor_FcPortStatsHist_txBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_txBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES = "adaptor_FcPortStatsHist_txFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcPortStatsHist_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_INTERVALS = "adaptor_FcPortStats_intervals"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES = "adaptor_FcPortStats_rxBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_rxBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES = "adaptor_FcPortStats_rxFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA = "adaptor_FcPortStats_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_SUSPECT = "adaptor_FcPortStats_suspect"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_THRESHOLDED = "adaptor_FcPortStats_thresholded"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TIME_COLLECTED = "adaptor_FcPortStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES = "adaptor_FcPortStats_txBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_txBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES = "adaptor_FcPortStats_txFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA = "adaptor_FcPortStats_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_UPDATE = "adaptor_FcPortStats_update"
    SORT_PROP_ADAPTOR_FC_QUEUE_PROFILE_COUNT = "adaptor_FcQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_QUEUE_PROFILE_RING_SIZE = "adaptor_FcQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_RECV_QUEUE_PROFILE_COUNT = "adaptor_FcRecvQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_FcRecvQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_VHBA_TYPE_PROFILE_MODE = "adaptor_FcVhbaTypeProfile_mode"
    SORT_PROP_ADAPTOR_FC_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_DELETED = "adaptor_FruCapProvider_deleted"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_DEPRECATED = "adaptor_FruCapProvider_deprecated"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "adaptor_FruCapProvider_elementLoadFailures"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_ELEMENTS_LOADED = "adaptor_FruCapProvider_elementsLoaded"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_FORM = "adaptor_FruCapProvider_form"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_GENCOUNT = "adaptor_FruCapProvider_gencount"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_LOAD_ERRORS = "adaptor_FruCapProvider_loadErrors"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_LOAD_WARNINGS = "adaptor_FruCapProvider_loadWarnings"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "adaptor_FruCapProvider_mgmtPlaneVer"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_MODEL = "adaptor_FruCapProvider_model"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "adaptor_FruCapProvider_promCardType"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_REVISION = "adaptor_FruCapProvider_revision"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_VENDOR = "adaptor_FruCapProvider_vendor"
    SORT_PROP_ADAPTOR_FRU_CAP_REF_IS_SUPPORTED = "adaptor_FruCapRef_isSupported"
    SORT_PROP_ADAPTOR_FRU_CAP_REF_MODEL = "adaptor_FruCapRef_model"
    SORT_PROP_ADAPTOR_FRU_CAP_REF_REVISION = "adaptor_FruCapRef_revision"
    SORT_PROP_ADAPTOR_FRU_CAP_REF_VENDOR = "adaptor_FruCapRef_vendor"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_DELETED = "adaptor_FwCapProvider_deleted"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_DEPRECATED = "adaptor_FwCapProvider_deprecated"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "adaptor_FwCapProvider_elementLoadFailures"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_ELEMENTS_LOADED = "adaptor_FwCapProvider_elementsLoaded"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_GENCOUNT = "adaptor_FwCapProvider_gencount"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_LOAD_ERRORS = "adaptor_FwCapProvider_loadErrors"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_LOAD_WARNINGS = "adaptor_FwCapProvider_loadWarnings"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_MGMT_PLANE_VER = "adaptor_FwCapProvider_mgmtPlaneVer"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_MODEL = "adaptor_FwCapProvider_model"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_VENDOR = "adaptor_FwCapProvider_vendor"
    SORT_PROP_ADAPTOR_FW_CAP_PROVIDER_VERSION = "adaptor_FwCapProvider_version"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_DESCR = "adaptor_HostEthIfFsmStage_descr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_HostEthIfFsmStage_lastUpdateTime"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_NAME = "adaptor_HostEthIfFsmStage_name"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_ORDER = "adaptor_HostEthIfFsmStage_order"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_RETRY = "adaptor_HostEthIfFsmStage_retry"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_STAGE_STATUS = "adaptor_HostEthIfFsmStage_stageStatus"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_TASK_COMPLETION = "adaptor_HostEthIfFsmTask_completion"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_TASK_FLAGS = "adaptor_HostEthIfFsmTask_flags"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_TASK_ITEM = "adaptor_HostEthIfFsmTask_item"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_TASK_SEQ_ID = "adaptor_HostEthIfFsmTask_seqId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_COMPLETION_TIME = "adaptor_HostEthIfFsm_completionTime"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_CURRENT_FSM = "adaptor_HostEthIfFsm_currentFsm"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_DESCR = "adaptor_HostEthIfFsm_descr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_FSM_STATUS = "adaptor_HostEthIfFsm_fsmStatus"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_INSTANCE_ID = "adaptor_HostEthIfFsm_instanceId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_PROGRESS = "adaptor_HostEthIfFsm_progress"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_ERR_CODE = "adaptor_HostEthIfFsm_rmtErrCode"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_ERR_DESCR = "adaptor_HostEthIfFsm_rmtErrDescr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_RSLT = "adaptor_HostEthIfFsm_rmtRslt"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_DESCR = "adaptor_HostEthIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_INT_ID = "adaptor_HostEthIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_NAME = "adaptor_HostEthIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_LEVEL = "adaptor_HostEthIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_OWNER = "adaptor_HostEthIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POOLED_RESOURCES = "adaptor_HostEthIfProfile_pooledResources"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ADMIN_STATE = "adaptor_HostEthIf_adminState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_BOOT_DEV = "adaptor_HostEthIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_CDN_NAME = "adaptor_HostEthIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_CHASSIS_ID = "adaptor_HostEthIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_DISCOVERY = "adaptor_HostEthIf_discovery"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_EP_DN = "adaptor_HostEthIf_epDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_DESCR = "adaptor_HostEthIf_fsmDescr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_PREV = "adaptor_HostEthIf_fsmPrev"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_PROGR = "adaptor_HostEthIf_fsmProgr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_ERR_CODE = "adaptor_HostEthIf_fsmRmtInvErrCode"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_HostEthIf_fsmRmtInvErrDescr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_RSLT = "adaptor_HostEthIf_fsmRmtInvRslt"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAGE_DESCR = "adaptor_HostEthIf_fsmStageDescr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STAMP = "adaptor_HostEthIf_fsmStamp"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_STATUS = "adaptor_HostEthIf_fsmStatus"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_FSM_TRY = "adaptor_HostEthIf_fsmTry"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_HOST_PORT = "adaptor_HostEthIf_hostPort"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ID = "adaptor_HostEthIf_id"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_IF_ROLE = "adaptor_HostEthIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_IF_TYPE = "adaptor_HostEthIf_ifType"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LC = "adaptor_HostEthIf_lc"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LINK_STATE = "adaptor_HostEthIf_linkState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LOCALE = "adaptor_HostEthIf_locale"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MAC = "adaptor_HostEthIf_mac"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MODEL = "adaptor_HostEthIf_model"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MTU = "adaptor_HostEthIf_mtu"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_NAME = "adaptor_HostEthIf_name"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPER_QUALIFIER_REASON = "adaptor_HostEthIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPER_STATE = "adaptor_HostEthIf_operState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERABILITY = "adaptor_HostEthIf_operability"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ORDER = "adaptor_HostEthIf_order"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ORIGINAL_MAC = "adaptor_HostEthIf_originalMac"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_ADDR = "adaptor_HostEthIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_FUNC = "adaptor_HostEthIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_SLOT = "adaptor_HostEthIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_CHASSIS_ID = "adaptor_HostEthIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_DN = "adaptor_HostEthIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_PORT_ID = "adaptor_HostEthIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_SLOT_ID = "adaptor_HostEthIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PERF = "adaptor_HostEthIf_perf"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PF_DN = "adaptor_HostEthIf_pfDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PORT_ID = "adaptor_HostEthIf_portId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_POWER = "adaptor_HostEthIf_power"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PRESENCE = "adaptor_HostEthIf_presence"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PURPOSE = "adaptor_HostEthIf_purpose"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_REVISION = "adaptor_HostEthIf_revision"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SERIAL = "adaptor_HostEthIf_serial"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SIDE = "adaptor_HostEthIf_side"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SLOT_ID = "adaptor_HostEthIf_slotId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SWITCH_ID = "adaptor_HostEthIf_switchId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_THERMAL = "adaptor_HostEthIf_thermal"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_TRANSPORT = "adaptor_HostEthIf_transport"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_TYPE = "adaptor_HostEthIf_type"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VENDOR = "adaptor_HostEthIf_vendor"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VIRTUALIZATION_PREFERENCE = "adaptor_HostEthIf_virtualizationPreference"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VNIC_DN = "adaptor_HostEthIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VOLTAGE = "adaptor_HostEthIf_voltage"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_DESCR = "adaptor_HostFcIfFsmStage_descr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_HostFcIfFsmStage_lastUpdateTime"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_NAME = "adaptor_HostFcIfFsmStage_name"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_ORDER = "adaptor_HostFcIfFsmStage_order"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_RETRY = "adaptor_HostFcIfFsmStage_retry"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_STAGE_STATUS = "adaptor_HostFcIfFsmStage_stageStatus"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_TASK_COMPLETION = "adaptor_HostFcIfFsmTask_completion"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_TASK_FLAGS = "adaptor_HostFcIfFsmTask_flags"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_TASK_ITEM = "adaptor_HostFcIfFsmTask_item"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_TASK_SEQ_ID = "adaptor_HostFcIfFsmTask_seqId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_COMPLETION_TIME = "adaptor_HostFcIfFsm_completionTime"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_CURRENT_FSM = "adaptor_HostFcIfFsm_currentFsm"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_DESCR = "adaptor_HostFcIfFsm_descr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_FSM_STATUS = "adaptor_HostFcIfFsm_fsmStatus"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_INSTANCE_ID = "adaptor_HostFcIfFsm_instanceId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_PROGRESS = "adaptor_HostFcIfFsm_progress"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_ERR_CODE = "adaptor_HostFcIfFsm_rmtErrCode"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_ERR_DESCR = "adaptor_HostFcIfFsm_rmtErrDescr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_RSLT = "adaptor_HostFcIfFsm_rmtRslt"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_DESCR = "adaptor_HostFcIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_INT_ID = "adaptor_HostFcIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_NAME = "adaptor_HostFcIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_LEVEL = "adaptor_HostFcIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_OWNER = "adaptor_HostFcIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ADMIN_STATE = "adaptor_HostFcIf_adminState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_BOOT_DEV = "adaptor_HostFcIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_FC_IF_CDN_NAME = "adaptor_HostFcIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_FC_IF_CHASSIS_ID = "adaptor_HostFcIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_DISCOVERY = "adaptor_HostFcIf_discovery"
    SORT_PROP_ADAPTOR_HOST_FC_IF_EP_DN = "adaptor_HostFcIf_epDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_DESCR = "adaptor_HostFcIf_fsmDescr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_PREV = "adaptor_HostFcIf_fsmPrev"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_PROGR = "adaptor_HostFcIf_fsmProgr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_ERR_CODE = "adaptor_HostFcIf_fsmRmtInvErrCode"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_HostFcIf_fsmRmtInvErrDescr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_RSLT = "adaptor_HostFcIf_fsmRmtInvRslt"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAGE_DESCR = "adaptor_HostFcIf_fsmStageDescr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STAMP = "adaptor_HostFcIf_fsmStamp"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_STATUS = "adaptor_HostFcIf_fsmStatus"
    SORT_PROP_ADAPTOR_HOST_FC_IF_FSM_TRY = "adaptor_HostFcIf_fsmTry"
    SORT_PROP_ADAPTOR_HOST_FC_IF_HOST_PORT = "adaptor_HostFcIf_hostPort"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ID = "adaptor_HostFcIf_id"
    SORT_PROP_ADAPTOR_HOST_FC_IF_IF_ROLE = "adaptor_HostFcIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_FC_IF_IF_TYPE = "adaptor_HostFcIf_ifType"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LC = "adaptor_HostFcIf_lc"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LINK_STATE = "adaptor_HostFcIf_linkState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LOCALE = "adaptor_HostFcIf_locale"
    SORT_PROP_ADAPTOR_HOST_FC_IF_MAX_DATA_FIELD_SIZE = "adaptor_HostFcIf_maxDataFieldSize"
    SORT_PROP_ADAPTOR_HOST_FC_IF_MODEL = "adaptor_HostFcIf_model"
    SORT_PROP_ADAPTOR_HOST_FC_IF_NAME = "adaptor_HostFcIf_name"
    SORT_PROP_ADAPTOR_HOST_FC_IF_NODE_WWN = "adaptor_HostFcIf_nodeWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPER_QUALIFIER_REASON = "adaptor_HostFcIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPER_STATE = "adaptor_HostFcIf_operState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERABILITY = "adaptor_HostFcIf_operability"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORDER = "adaptor_HostFcIf_order"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORIGINAL_NODE_WWN = "adaptor_HostFcIf_originalNodeWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORIGINAL_WWN = "adaptor_HostFcIf_originalWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_ADDR = "adaptor_HostFcIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_FUNC = "adaptor_HostFcIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_SLOT = "adaptor_HostFcIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_CHASSIS_ID = "adaptor_HostFcIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_DN = "adaptor_HostFcIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_PORT_ID = "adaptor_HostFcIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_SLOT_ID = "adaptor_HostFcIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PERF = "adaptor_HostFcIf_perf"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PERS_BIND = "adaptor_HostFcIf_persBind"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PORT_ID = "adaptor_HostFcIf_portId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_POWER = "adaptor_HostFcIf_power"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PRESENCE = "adaptor_HostFcIf_presence"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PURPOSE = "adaptor_HostFcIf_purpose"
    SORT_PROP_ADAPTOR_HOST_FC_IF_REVISION = "adaptor_HostFcIf_revision"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SERIAL = "adaptor_HostFcIf_serial"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SIDE = "adaptor_HostFcIf_side"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SLOT_ID = "adaptor_HostFcIf_slotId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SWITCH_ID = "adaptor_HostFcIf_switchId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_THERMAL = "adaptor_HostFcIf_thermal"
    SORT_PROP_ADAPTOR_HOST_FC_IF_TRANSPORT = "adaptor_HostFcIf_transport"
    SORT_PROP_ADAPTOR_HOST_FC_IF_TYPE = "adaptor_HostFcIf_type"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VENDOR = "adaptor_HostFcIf_vendor"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VNIC_DN = "adaptor_HostFcIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VOLTAGE = "adaptor_HostFcIf_voltage"
    SORT_PROP_ADAPTOR_HOST_FC_IF_WWN = "adaptor_HostFcIf_wwn"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_ADMIN_STATE = "adaptor_HostIfConfig_adminState"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_ID = "adaptor_HostIfConfig_id"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_NAME = "adaptor_HostIfConfig_name"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_TRANSPORT = "adaptor_HostIfConfig_transport"
    SORT_PROP_ADAPTOR_HOST_IF_CONN_DEF_CON_POLICY_NAME = "adaptor_HostIfConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_DESCR = "adaptor_HostIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_INT_ID = "adaptor_HostIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_NAME = "adaptor_HostIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_POLICY_OWNER = "adaptor_HostIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_IF_ADMIN_STATE = "adaptor_HostIf_adminState"
    SORT_PROP_ADAPTOR_HOST_IF_BOOT_DEV = "adaptor_HostIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_IF_CDN_NAME = "adaptor_HostIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_IF_CHASSIS_ID = "adaptor_HostIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_IF_DISCOVERY = "adaptor_HostIf_discovery"
    SORT_PROP_ADAPTOR_HOST_IF_EP_DN = "adaptor_HostIf_epDn"
    SORT_PROP_ADAPTOR_HOST_IF_ID = "adaptor_HostIf_id"
    SORT_PROP_ADAPTOR_HOST_IF_IF_ROLE = "adaptor_HostIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_IF_IF_TYPE = "adaptor_HostIf_ifType"
    SORT_PROP_ADAPTOR_HOST_IF_LC = "adaptor_HostIf_lc"
    SORT_PROP_ADAPTOR_HOST_IF_LINK_STATE = "adaptor_HostIf_linkState"
    SORT_PROP_ADAPTOR_HOST_IF_LOCALE = "adaptor_HostIf_locale"
    SORT_PROP_ADAPTOR_HOST_IF_MODEL = "adaptor_HostIf_model"
    SORT_PROP_ADAPTOR_HOST_IF_NAME = "adaptor_HostIf_name"
    SORT_PROP_ADAPTOR_HOST_IF_OPER_QUALIFIER_REASON = "adaptor_HostIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_IF_OPER_STATE = "adaptor_HostIf_operState"
    SORT_PROP_ADAPTOR_HOST_IF_OPERABILITY = "adaptor_HostIf_operability"
    SORT_PROP_ADAPTOR_HOST_IF_ORDER = "adaptor_HostIf_order"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_ADDR = "adaptor_HostIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_FUNC = "adaptor_HostIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_SLOT = "adaptor_HostIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_CHASSIS_ID = "adaptor_HostIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_DN = "adaptor_HostIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_PORT_ID = "adaptor_HostIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_SLOT_ID = "adaptor_HostIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_IF_PERF = "adaptor_HostIf_perf"
    SORT_PROP_ADAPTOR_HOST_IF_PORT_ID = "adaptor_HostIf_portId"
    SORT_PROP_ADAPTOR_HOST_IF_POWER = "adaptor_HostIf_power"
    SORT_PROP_ADAPTOR_HOST_IF_PRESENCE = "adaptor_HostIf_presence"
    SORT_PROP_ADAPTOR_HOST_IF_PURPOSE = "adaptor_HostIf_purpose"
    SORT_PROP_ADAPTOR_HOST_IF_REVISION = "adaptor_HostIf_revision"
    SORT_PROP_ADAPTOR_HOST_IF_SERIAL = "adaptor_HostIf_serial"
    SORT_PROP_ADAPTOR_HOST_IF_SIDE = "adaptor_HostIf_side"
    SORT_PROP_ADAPTOR_HOST_IF_SLOT_ID = "adaptor_HostIf_slotId"
    SORT_PROP_ADAPTOR_HOST_IF_SWITCH_ID = "adaptor_HostIf_switchId"
    SORT_PROP_ADAPTOR_HOST_IF_THERMAL = "adaptor_HostIf_thermal"
    SORT_PROP_ADAPTOR_HOST_IF_TRANSPORT = "adaptor_HostIf_transport"
    SORT_PROP_ADAPTOR_HOST_IF_TYPE = "adaptor_HostIf_type"
    SORT_PROP_ADAPTOR_HOST_IF_VENDOR = "adaptor_HostIf_vendor"
    SORT_PROP_ADAPTOR_HOST_IF_VNIC_DN = "adaptor_HostIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_IF_VOLTAGE = "adaptor_HostIf_voltage"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_DESCR = "adaptor_HostIscsiIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_INT_ID = "adaptor_HostIscsiIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_NAME = "adaptor_HostIscsiIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIscsiIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_OWNER = "adaptor_HostIscsiIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ADMIN_STATE = "adaptor_HostIscsiIf_adminState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_BOOT_DEV = "adaptor_HostIscsiIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_CDN_NAME = "adaptor_HostIscsiIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_CHASSIS_ID = "adaptor_HostIscsiIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_DISCOVERY = "adaptor_HostIscsiIf_discovery"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_EP_DN = "adaptor_HostIscsiIf_epDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ETH_EP_DN = "adaptor_HostIscsiIf_ethEpDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_HOST_VISIBLE = "adaptor_HostIscsiIf_hostVisible"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ID = "adaptor_HostIscsiIf_id"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_IF_ROLE = "adaptor_HostIscsiIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_IF_TYPE = "adaptor_HostIscsiIf_ifType"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_INITIATOR_NAME = "adaptor_HostIscsiIf_initiatorName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LC = "adaptor_HostIscsiIf_lc"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LINK_STATE = "adaptor_HostIscsiIf_linkState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LOCALE = "adaptor_HostIscsiIf_locale"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_MAC = "adaptor_HostIscsiIf_mac"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_MODEL = "adaptor_HostIscsiIf_model"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_NAME = "adaptor_HostIscsiIf_name"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPER_QUALIFIER_REASON = "adaptor_HostIscsiIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPER_STATE = "adaptor_HostIscsiIf_operState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERABILITY = "adaptor_HostIscsiIf_operability"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ORDER = "adaptor_HostIscsiIf_order"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ORIGINAL_MAC = "adaptor_HostIscsiIf_originalMac"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_ADDR = "adaptor_HostIscsiIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_FUNC = "adaptor_HostIscsiIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_SLOT = "adaptor_HostIscsiIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_CHASSIS_ID = "adaptor_HostIscsiIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_DN = "adaptor_HostIscsiIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_PORT_ID = "adaptor_HostIscsiIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_SLOT_ID = "adaptor_HostIscsiIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PERF = "adaptor_HostIscsiIf_perf"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PORT_ID = "adaptor_HostIscsiIf_portId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_POWER = "adaptor_HostIscsiIf_power"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PRESENCE = "adaptor_HostIscsiIf_presence"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PURPOSE = "adaptor_HostIscsiIf_purpose"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_REVISION = "adaptor_HostIscsiIf_revision"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SERIAL = "adaptor_HostIscsiIf_serial"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SIDE = "adaptor_HostIscsiIf_side"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SLOT_ID = "adaptor_HostIscsiIf_slotId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SWITCH_ID = "adaptor_HostIscsiIf_switchId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_THERMAL = "adaptor_HostIscsiIf_thermal"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_TRANSPORT = "adaptor_HostIscsiIf_transport"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_TYPE = "adaptor_HostIscsiIf_type"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VENDOR = "adaptor_HostIscsiIf_vendor"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VNIC_DN = "adaptor_HostIscsiIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VNIC_NAME = "adaptor_HostIscsiIf_vnicName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VOLTAGE = "adaptor_HostIscsiIf_voltage"
    SORT_PROP_ADAPTOR_HOST_MGMT_CAP_MODE = "adaptor_HostMgmtCap_mode"
    SORT_PROP_ADAPTOR_HOST_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_HostMgmtCap_operPowerRequirement"
    SORT_PROP_ADAPTOR_HOST_MGMT_CAP_PREBOOT = "adaptor_HostMgmtCap_preboot"
    SORT_PROP_ADAPTOR_HOST_MGMT_CAP_PRESENCE = "adaptor_HostMgmtCap_presence"
    SORT_PROP_ADAPTOR_HOST_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_HostMgmtCap_rebootActionOnDestructive"
    SORT_PROP_ADAPTOR_HOST_PORT_CAP_HOST_PORT_ID = "adaptor_HostPortCap_hostPortId"
    SORT_PROP_ADAPTOR_HOST_PORT_CAP_MAX_PORTS = "adaptor_HostPortCap_maxPorts"
    SORT_PROP_ADAPTOR_HOST_PORT_HOST_PORT_ID = "adaptor_HostPort_hostPortId"
    SORT_PROP_ADAPTOR_HOST_PORT_ID = "adaptor_HostPort_id"
    SORT_PROP_ADAPTOR_HOST_PORT_LOCATION_DN = "adaptor_HostPort_locationDn"
    SORT_PROP_ADAPTOR_HOST_PORT_MODEL = "adaptor_HostPort_model"
    SORT_PROP_ADAPTOR_HOST_PORT_OPER_QUALIFIER_REASON = "adaptor_HostPort_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_PORT_OPER_STATE = "adaptor_HostPort_operState"
    SORT_PROP_ADAPTOR_HOST_PORT_OPERABILITY = "adaptor_HostPort_operability"
    SORT_PROP_ADAPTOR_HOST_PORT_PERF = "adaptor_HostPort_perf"
    SORT_PROP_ADAPTOR_HOST_PORT_POWER = "adaptor_HostPort_power"
    SORT_PROP_ADAPTOR_HOST_PORT_PRESENCE = "adaptor_HostPort_presence"
    SORT_PROP_ADAPTOR_HOST_PORT_REVISION = "adaptor_HostPort_revision"
    SORT_PROP_ADAPTOR_HOST_PORT_SERIAL = "adaptor_HostPort_serial"
    SORT_PROP_ADAPTOR_HOST_PORT_THERMAL = "adaptor_HostPort_thermal"
    SORT_PROP_ADAPTOR_HOST_PORT_VENDOR = "adaptor_HostPort_vendor"
    SORT_PROP_ADAPTOR_HOST_PORT_VOLTAGE = "adaptor_HostPort_voltage"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ADMIN_STATE = "adaptor_HostScsiIf_adminState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_BOOT_DEV = "adaptor_HostScsiIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_CDN_NAME = "adaptor_HostScsiIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_CHASSIS_ID = "adaptor_HostScsiIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_DISCOVERY = "adaptor_HostScsiIf_discovery"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_EP_DN = "adaptor_HostScsiIf_epDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ID = "adaptor_HostScsiIf_id"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_IF_ROLE = "adaptor_HostScsiIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_IF_TYPE = "adaptor_HostScsiIf_ifType"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LC = "adaptor_HostScsiIf_lc"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LINK_STATE = "adaptor_HostScsiIf_linkState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LOCALE = "adaptor_HostScsiIf_locale"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_MODEL = "adaptor_HostScsiIf_model"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_NAME = "adaptor_HostScsiIf_name"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPER_QUALIFIER_REASON = "adaptor_HostScsiIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPER_STATE = "adaptor_HostScsiIf_operState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPERABILITY = "adaptor_HostScsiIf_operability"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ORDER = "adaptor_HostScsiIf_order"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_ADDR = "adaptor_HostScsiIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_FUNC = "adaptor_HostScsiIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_SLOT = "adaptor_HostScsiIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_CHASSIS_ID = "adaptor_HostScsiIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_DN = "adaptor_HostScsiIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_PORT_ID = "adaptor_HostScsiIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_SLOT_ID = "adaptor_HostScsiIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PERF = "adaptor_HostScsiIf_perf"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PORT_ID = "adaptor_HostScsiIf_portId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_POWER = "adaptor_HostScsiIf_power"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PRESENCE = "adaptor_HostScsiIf_presence"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PURPOSE = "adaptor_HostScsiIf_purpose"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_REVISION = "adaptor_HostScsiIf_revision"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SERIAL = "adaptor_HostScsiIf_serial"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SIDE = "adaptor_HostScsiIf_side"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SLOT_ID = "adaptor_HostScsiIf_slotId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SWITCH_ID = "adaptor_HostScsiIf_switchId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_THERMAL = "adaptor_HostScsiIf_thermal"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_TRANSPORT = "adaptor_HostScsiIf_transport"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_TYPE = "adaptor_HostScsiIf_type"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VENDOR = "adaptor_HostScsiIf_vendor"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VNIC_DN = "adaptor_HostScsiIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VOLTAGE = "adaptor_HostScsiIf_voltage"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_BOOT_DEV = "adaptor_HostScsiLunRef_bootDev"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_DN = "adaptor_HostScsiLunRef_lunDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_ID = "adaptor_HostScsiLunRef_lunId"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_NAME = "adaptor_HostScsiLunRef_lunName"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_ORDER = "adaptor_HostScsiLunRef_lunOrder"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_OPER_LUN_ID = "adaptor_HostScsiLunRef_operLunId"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_OPER_LUN_ORDER = "adaptor_HostScsiLunRef_operLunOrder"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_ADMIN_STATE = "adaptor_HostServiceEthIf_adminState"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_BOOT_DEV = "adaptor_HostServiceEthIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_CDN_NAME = "adaptor_HostServiceEthIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_CHASSIS_ID = "adaptor_HostServiceEthIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_DISCOVERY = "adaptor_HostServiceEthIf_discovery"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_EP_DN = "adaptor_HostServiceEthIf_epDn"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_ID = "adaptor_HostServiceEthIf_id"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_IF_ROLE = "adaptor_HostServiceEthIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_IF_TYPE = "adaptor_HostServiceEthIf_ifType"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_LC = "adaptor_HostServiceEthIf_lc"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_LINK_STATE = "adaptor_HostServiceEthIf_linkState"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_LOCALE = "adaptor_HostServiceEthIf_locale"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_MAC = "adaptor_HostServiceEthIf_mac"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_MODEL = "adaptor_HostServiceEthIf_model"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_MTU = "adaptor_HostServiceEthIf_mtu"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_NAME = "adaptor_HostServiceEthIf_name"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_OPER_QUALIFIER_REASON = "adaptor_HostServiceEthIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_OPER_STATE = "adaptor_HostServiceEthIf_operState"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_OPERABILITY = "adaptor_HostServiceEthIf_operability"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_ORDER = "adaptor_HostServiceEthIf_order"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_ORIGINAL_MAC = "adaptor_HostServiceEthIf_originalMac"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_ADDR = "adaptor_HostServiceEthIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_FUNC = "adaptor_HostServiceEthIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_SLOT = "adaptor_HostServiceEthIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_CHASSIS_ID = "adaptor_HostServiceEthIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_DN = "adaptor_HostServiceEthIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_PORT_ID = "adaptor_HostServiceEthIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_SLOT_ID = "adaptor_HostServiceEthIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PERF = "adaptor_HostServiceEthIf_perf"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PORT_ID = "adaptor_HostServiceEthIf_portId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_POWER = "adaptor_HostServiceEthIf_power"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PRESENCE = "adaptor_HostServiceEthIf_presence"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_PURPOSE = "adaptor_HostServiceEthIf_purpose"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_REVISION = "adaptor_HostServiceEthIf_revision"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_SERIAL = "adaptor_HostServiceEthIf_serial"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_SIDE = "adaptor_HostServiceEthIf_side"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_SLOT_ID = "adaptor_HostServiceEthIf_slotId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_SWITCH_ID = "adaptor_HostServiceEthIf_switchId"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_THERMAL = "adaptor_HostServiceEthIf_thermal"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_TRANSPORT = "adaptor_HostServiceEthIf_transport"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_TYPE = "adaptor_HostServiceEthIf_type"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_VENDOR = "adaptor_HostServiceEthIf_vendor"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_VNIC_DN = "adaptor_HostServiceEthIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_SERVICE_ETH_IF_VOLTAGE = "adaptor_HostServiceEthIf_voltage"
    SORT_PROP_ADAPTOR_HOST_VNIC_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HostVnicHwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_HOST_VNIC_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HostVnicHwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_HOST_VNIC_HW_ADDR_CAP_MAC_OFFSET_VNIC_FROM = "adaptor_HostVnicHwAddrCap_macOffsetVnicFrom"
    SORT_PROP_ADAPTOR_HOST_VNIC_HW_ADDR_CAP_MAC_OFFSET_VNIC_TO = "adaptor_HostVnicHwAddrCap_macOffsetVnicTo"
    SORT_PROP_ADAPTOR_HOSTETH_HW_ADDR_CAP_LEGACY_MAC_OFFSET1 = "adaptor_HostethHwAddrCap_legacyMacOffset1"
    SORT_PROP_ADAPTOR_HOSTETH_HW_ADDR_CAP_LEGACY_MAC_OFFSET2 = "adaptor_HostethHwAddrCap_legacyMacOffset2"
    SORT_PROP_ADAPTOR_HOSTETH_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HostethHwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_HOSTETH_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HostethHwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HostfcHwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HostfcHwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWN_REVERSE_MASK_A = "adaptor_HostfcHwAddrCap_wwnReverseMaskA"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWN_REVERSE_MASK_B = "adaptor_HostfcHwAddrCap_wwnReverseMaskB"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWNN_REVERSE_MASK_A = "adaptor_HostfcHwAddrCap_wwnnReverseMaskA"
    SORT_PROP_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWNN_REVERSE_MASK_B = "adaptor_HostfcHwAddrCap_wwnnReverseMaskB"
    SORT_PROP_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_ISCSI_CAP_BOOT_ORDER_TYPE = "adaptor_IScsiCap_bootOrderType"
    SORT_PROP_ADAPTOR_ISCSI_CAP_MAC_OFFSET1 = "adaptor_IScsiCap_macOffset1"
    SORT_PROP_ADAPTOR_ISCSI_CAP_MAC_OFFSET2 = "adaptor_IScsiCap_macOffset2"
    SORT_PROP_ADAPTOR_ISCSI_CAP_OFFLOAD_SUPPORT = "adaptor_IScsiCap_offloadSupport"
    SORT_PROP_ADAPTOR_ISCSI_CAP_OFFLOAD_TYPE = "adaptor_IScsiCap_offloadType"
    SORT_PROP_ADAPTOR_ISCSI_CAP_VLAN_FOR_BOOT = "adaptor_IScsiCap_vlanForBoot"
    SORT_PROP_ADAPTOR_IP_V4_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV4RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_IP_V4_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV4RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV6RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV6RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_ISCSI_AUTH_PASSWORD = "adaptor_IscsiAuth_password"
    SORT_PROP_ADAPTOR_ISCSI_AUTH_USER_ID = "adaptor_IscsiAuth_userId"
    SORT_PROP_ADAPTOR_ISCSI_PROT_CONNECTION_TIME_OUT = "adaptor_IscsiProt_connectionTimeOut"
    SORT_PROP_ADAPTOR_ISCSI_PROT_DHCP_TIME_OUT = "adaptor_IscsiProt_dhcpTimeOut"
    SORT_PROP_ADAPTOR_ISCSI_PROT_INITIATOR_NAME = "adaptor_IscsiProt_initiatorName"
    SORT_PROP_ADAPTOR_ISCSI_PROT_LUN_BUSY_RETRY_COUNT = "adaptor_IscsiProt_lunBusyRetryCount"
    SORT_PROP_ADAPTOR_ISCSI_PROT_TCP_TIME_STAMP = "adaptor_IscsiProt_tcpTimeStamp"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_DHCP_VENDOR_ID = "adaptor_IscsiTargetIf_dhcpVendorId"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_IP_ADDRESS = "adaptor_IscsiTargetIf_ipAddress"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_LUN = "adaptor_IscsiTargetIf_lun"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_NAME = "adaptor_IscsiTargetIf_name"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_PORT_NUMBER = "adaptor_IscsiTargetIf_portNumber"
    SORT_PROP_ADAPTOR_ISCSI_TARGET_IF_PRIORITY = "adaptor_IscsiTargetIf_priority"
    SORT_PROP_ADAPTOR_LAN_CAP_DEFAULT_VLAN = "adaptor_LanCap_defaultVlan"
    SORT_PROP_ADAPTOR_LINK_STATE_HOLDER_LINK_STATE = "adaptor_LinkStateHolder_linkState"
    SORT_PROP_ADAPTOR_LLDP_CAP_SUPPORT = "adaptor_LldpCap_support"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_ID = "adaptor_MenloBaseErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloBaseErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloBaseErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloBaseErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloBaseErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_INTERVALS = "adaptor_MenloBaseErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_SUSPECT = "adaptor_MenloBaseErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_THRESHOLDED = "adaptor_MenloBaseErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloBaseErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UPDATE = "adaptor_MenloBaseErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_ID = "adaptor_MenloDcePortStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloDcePortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_SUSPECT = "adaptor_MenloDcePortStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloDcePortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloDcePortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_INTERVALS = "adaptor_MenloDcePortStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloDcePortStats_menloPortIndex"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloDcePortStats_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloDcePortStats_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_SUSPECT = "adaptor_MenloDcePortStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_THRESHOLDED = "adaptor_MenloDcePortStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TIME_COLLECTED = "adaptor_MenloDcePortStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloDcePortStats_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloDcePortStats_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_UPDATE = "adaptor_MenloDcePortStats_update"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL = "adaptor_MenloEthErrorStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloEthErrorStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_ID = "adaptor_MenloEthErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloEthErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloEthErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloEthErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloEthErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloEthErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL = "adaptor_MenloEthErrorStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA = "adaptor_MenloEthErrorStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_INTERVALS = "adaptor_MenloEthErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthErrorStats_menloEthIndex"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS = "adaptor_MenloEthErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloEthErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_SUSPECT = "adaptor_MenloEthErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_THRESHOLDED = "adaptor_MenloEthErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloEthErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UPDATE = "adaptor_MenloEthErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN = "adaptor_MenloEthStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT = "adaptor_MenloEthStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloEthStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_ID = "adaptor_MenloEthStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_MOST_RECENT = "adaptor_MenloEthStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_SUSPECT = "adaptor_MenloEthStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_THRESHOLDED = "adaptor_MenloEthStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloEthStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN = "adaptor_MenloEthStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloEthStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT = "adaptor_MenloEthStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA = "adaptor_MenloEthStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_INTERVALS = "adaptor_MenloEthStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthStats_menloEthIndex"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_SUSPECT = "adaptor_MenloEthStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_THRESHOLDED = "adaptor_MenloEthStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TIME_COLLECTED = "adaptor_MenloEthStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN = "adaptor_MenloEthStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_UPDATE = "adaptor_MenloEthStats_update"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_ID = "adaptor_MenloFcErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloFcErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloFcErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloFcErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloFcErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloFcErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_INTERVALS = "adaptor_MenloFcErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_MENLO_FC_INDEX = "adaptor_MenloFcErrorStats_menloFcIndex"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS = "adaptor_MenloFcErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloFcErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_SUSPECT = "adaptor_MenloFcErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_THRESHOLDED = "adaptor_MenloFcErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloFcErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UPDATE = "adaptor_MenloFcErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL = "adaptor_MenloFcStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloFcStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN = "adaptor_MenloFcStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT = "adaptor_MenloFcStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloFcStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_ID = "adaptor_MenloFcStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_MOST_RECENT = "adaptor_MenloFcStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_SUSPECT = "adaptor_MenloFcStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_THRESHOLDED = "adaptor_MenloFcStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloFcStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL = "adaptor_MenloFcStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA = "adaptor_MenloFcStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN = "adaptor_MenloFcStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloFcStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT = "adaptor_MenloFcStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA = "adaptor_MenloFcStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_INTERVALS = "adaptor_MenloFcStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_MENLO_FC_INDEX = "adaptor_MenloFcStats_menloFcIndex"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_SUSPECT = "adaptor_MenloFcStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_THRESHOLDED = "adaptor_MenloFcStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TIME_COLLECTED = "adaptor_MenloFcStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN = "adaptor_MenloFcStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_UPDATE = "adaptor_MenloFcStats_update"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_ID = "adaptor_MenloHostPortStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloHostPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_SUSPECT = "adaptor_MenloHostPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloHostPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloHostPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_INTERVALS = "adaptor_MenloHostPortStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloHostPortStats_menloPortIndex"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloHostPortStats_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloHostPortStats_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_SUSPECT = "adaptor_MenloHostPortStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_THRESHOLDED = "adaptor_MenloHostPortStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TIME_COLLECTED = "adaptor_MenloHostPortStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloHostPortStats_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloHostPortStats_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_UPDATE = "adaptor_MenloHostPortStats_update"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_ID = "adaptor_MenloMcpuErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloMcpuErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloMcpuErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloMcpuErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_INTERVALS = "adaptor_MenloMcpuErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuErrorStats_menloMcpuIndex"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS = "adaptor_MenloMcpuErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloMcpuErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_SUSPECT = "adaptor_MenloMcpuErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_THRESHOLDED = "adaptor_MenloMcpuErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloMcpuErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UPDATE = "adaptor_MenloMcpuErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL = "adaptor_MenloMcpuStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloMcpuStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN = "adaptor_MenloMcpuStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT = "adaptor_MenloMcpuStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloMcpuStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_ID = "adaptor_MenloMcpuStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_SUSPECT = "adaptor_MenloMcpuStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL = "adaptor_MenloMcpuStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA = "adaptor_MenloMcpuStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN = "adaptor_MenloMcpuStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT = "adaptor_MenloMcpuStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA = "adaptor_MenloMcpuStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_INTERVALS = "adaptor_MenloMcpuStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuStats_menloMcpuIndex"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_SUSPECT = "adaptor_MenloMcpuStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_THRESHOLDED = "adaptor_MenloMcpuStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TIME_COLLECTED = "adaptor_MenloMcpuStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_UPDATE = "adaptor_MenloMcpuStats_update"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD = "adaptor_MenloNetEgStatsHist_dropCmd"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA = "adaptor_MenloNetEgStatsHist_dropCmdDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropCmdDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStatsHist_dropLifMapNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND = "adaptor_MenloNetEgStatsHist_dropSrcBind"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStatsHist_dropSrcBindDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_ID = "adaptor_MenloNetEgStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP = "adaptor_MenloNetEgStatsHist_learnReqDrop"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStatsHist_learnReqDropDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_MOST_RECENT = "adaptor_MenloNetEgStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_SUSPECT = "adaptor_MenloNetEgStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_THRESHOLDED = "adaptor_MenloNetEgStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetEgStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD = "adaptor_MenloNetEgStats_dropCmd"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA = "adaptor_MenloNetEgStats_dropCmdDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStats_dropCmdDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStats_dropCmdDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStats_dropCmdDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStats_dropLifCfgInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStats_dropLifCfgInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStats_dropLifMapNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStats_dropLifMapNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND = "adaptor_MenloNetEgStats_dropSrcBind"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStats_dropSrcBindDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStats_dropSrcBindDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStats_dropSrcBindDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStats_dropSrcBindDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_INTERVALS = "adaptor_MenloNetEgStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP = "adaptor_MenloNetEgStats_learnReqDrop"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStats_learnReqDropDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStats_learnReqDropDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStats_learnReqDropDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStats_learnReqDropDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_MENLO_NET_INDEX = "adaptor_MenloNetEgStats_menloNetIndex"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_SUSPECT = "adaptor_MenloNetEgStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_THRESHOLDED = "adaptor_MenloNetEgStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_TIME_COLLECTED = "adaptor_MenloNetEgStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_UPDATE = "adaptor_MenloNetEgStats_update"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStatsHist_dropFcLifInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST = "adaptor_MenloNetInStatsHist_dropFcMulticast"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStatsHist_dropFcMulticastDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF = "adaptor_MenloNetInStatsHist_dropNullPif"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStatsHist_dropNullPifDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropNullPifDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStatsHist_fwdLookupNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_ID = "adaptor_MenloNetInStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_MOST_RECENT = "adaptor_MenloNetInStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_SUSPECT = "adaptor_MenloNetInStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_THRESHOLDED = "adaptor_MenloNetInStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetInStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStats_dropFcLifInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStats_dropFcLifInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST = "adaptor_MenloNetInStats_dropFcMulticast"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStats_dropFcMulticastDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStats_dropFcMulticastDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStats_dropFcMulticastDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStats_dropFcMulticastDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF = "adaptor_MenloNetInStats_dropNullPif"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStats_dropNullPifDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStats_dropNullPifDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStats_dropNullPifDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStats_dropNullPifDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStats_fwdLookupNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStats_fwdLookupNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_INTERVALS = "adaptor_MenloNetInStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_MENLO_NET_INDEX = "adaptor_MenloNetInStats_menloNetIndex"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_SUSPECT = "adaptor_MenloNetInStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_THRESHOLDED = "adaptor_MenloNetInStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_TIME_COLLECTED = "adaptor_MenloNetInStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_UPDATE = "adaptor_MenloNetInStats_update"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_ID = "adaptor_MenloQErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloQErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloQErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloQErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_SUSPECT = "adaptor_MenloQErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloQErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloQErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_INTERVALS = "adaptor_MenloQErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQErrorStats_menloQueueComponent"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_INDEX = "adaptor_MenloQErrorStats_menloQueueIndex"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS = "adaptor_MenloQErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloQErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS = "adaptor_MenloQErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_SUSPECT = "adaptor_MenloQErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_THRESHOLDED = "adaptor_MenloQErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_TIME_COLLECTED = "adaptor_MenloQErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UPDATE = "adaptor_MenloQErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0 = "adaptor_MenloQStatsHist_dropOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_dropOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1 = "adaptor_MenloQStatsHist_dropOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_dropOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_ID = "adaptor_MenloQStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_MOST_RECENT = "adaptor_MenloQStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_SUSPECT = "adaptor_MenloQStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_THRESHOLDED = "adaptor_MenloQStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TIME_COLLECTED = "adaptor_MenloQStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStatsHist_truncateOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStatsHist_truncateOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0 = "adaptor_MenloQStats_dropOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStats_dropOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1 = "adaptor_MenloQStats_dropOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStats_dropOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_INTERVALS = "adaptor_MenloQStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQStats_menloQueueComponent"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_INDEX = "adaptor_MenloQStats_menloQueueIndex"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_SUSPECT = "adaptor_MenloQStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_THRESHOLDED = "adaptor_MenloQStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TIME_COLLECTED = "adaptor_MenloQStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStats_truncateOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStats_truncateOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStats_truncateOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStats_truncateOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_UPDATE = "adaptor_MenloQStats_update"
    SORT_PROP_ADAPTOR_MGMT_CAP_MODE = "adaptor_MgmtCap_mode"
    SORT_PROP_ADAPTOR_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_MgmtCap_operPowerRequirement"
    SORT_PROP_ADAPTOR_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_MgmtCap_rebootActionOnDestructive"
    SORT_PROP_ADAPTOR_MGMT_VNIC_ETH_CONFIG_HOST_PORT_ID = "adaptor_MgmtVnicEthConfig_hostPortId"
    SORT_PROP_ADAPTOR_MGMT_VNIC_ETH_CONFIG_MAC_OFFSET = "adaptor_MgmtVnicEthConfig_macOffset"
    SORT_PROP_ADAPTOR_MGMT_VNIC_ETH_CONFIG_PCI_SLOT = "adaptor_MgmtVnicEthConfig_pciSlot"
    SORT_PROP_ADAPTOR_NW_MGMT_CAP_API = "adaptor_NwMgmtCap_api"
    SORT_PROP_ADAPTOR_NW_MGMT_CAP_MGMT_TRANSPORT = "adaptor_NwMgmtCap_mgmtTransport"
    SORT_PROP_ADAPTOR_NW_MGMT_CAP_MODE = "adaptor_NwMgmtCap_mode"
    SORT_PROP_ADAPTOR_NW_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_NwMgmtCap_operPowerRequirement"
    SORT_PROP_ADAPTOR_NW_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_NwMgmtCap_rebootActionOnDestructive"
    SORT_PROP_ADAPTOR_NW_STATS_MGMT_CAP_ENABLE_NW_STATS_COLLECTION = "adaptor_NwStatsMgmtCap_enableNwStatsCollection"
    SORT_PROP_ADAPTOR_NW_STATS_MGMT_CAP_MODE = "adaptor_NwStatsMgmtCap_mode"
    SORT_PROP_ADAPTOR_NW_STATS_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_NwStatsMgmtCap_operPowerRequirement"
    SORT_PROP_ADAPTOR_NW_STATS_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_NwStatsMgmtCap_rebootActionOnDestructive"
    SORT_PROP_ADAPTOR_PIO_EP_AGGR_PORT_ID = "adaptor_PIoEp_aggrPortId"
    SORT_PROP_ADAPTOR_PIO_EP_CHASSIS_ID = "adaptor_PIoEp_chassisId"
    SORT_PROP_ADAPTOR_PIO_EP_EP_DN = "adaptor_PIoEp_epDn"
    SORT_PROP_ADAPTOR_PIO_EP_IF_ROLE = "adaptor_PIoEp_ifRole"
    SORT_PROP_ADAPTOR_PIO_EP_IF_TYPE = "adaptor_PIoEp_ifType"
    SORT_PROP_ADAPTOR_PIO_EP_LOCALE = "adaptor_PIoEp_locale"
    SORT_PROP_ADAPTOR_PIO_EP_NAME = "adaptor_PIoEp_name"
    SORT_PROP_ADAPTOR_PIO_EP_PEER_AGGR_PORT_ID = "adaptor_PIoEp_peerAggrPortId"
    SORT_PROP_ADAPTOR_PIO_EP_PEER_CHASSIS_ID = "adaptor_PIoEp_peerChassisId"
    SORT_PROP_ADAPTOR_PIO_EP_PEER_DN = "adaptor_PIoEp_peerDn"
    SORT_PROP_ADAPTOR_PIO_EP_PEER_PORT_ID = "adaptor_PIoEp_peerPortId"
    SORT_PROP_ADAPTOR_PIO_EP_PEER_SLOT_ID = "adaptor_PIoEp_peerSlotId"
    SORT_PROP_ADAPTOR_PIO_EP_PORT_ID = "adaptor_PIoEp_portId"
    SORT_PROP_ADAPTOR_PIO_EP_SLOT_ID = "adaptor_PIoEp_slotId"
    SORT_PROP_ADAPTOR_PIO_EP_SWITCH_ID = "adaptor_PIoEp_switchId"
    SORT_PROP_ADAPTOR_PIO_EP_TRANSPORT = "adaptor_PIoEp_transport"
    SORT_PROP_ADAPTOR_PIO_EP_TYPE = "adaptor_PIoEp_type"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_BOOT_TO_TARGET = "adaptor_ProtocolProfile_bootToTarget"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_CONNECTION_TIME_OUT = "adaptor_ProtocolProfile_connectionTimeOut"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_DHCP_TIME_OUT = "adaptor_ProtocolProfile_dhcpTimeOut"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_HBA_MODE = "adaptor_ProtocolProfile_hbaMode"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_LUN_BUSY_RETRY_COUNT = "adaptor_ProtocolProfile_lunBusyRetryCount"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_TCP_TIME_STAMP = "adaptor_ProtocolProfile_tcpTimeStamp"
    SORT_PROP_ADAPTOR_QUEUE_PROFILE_COUNT = "adaptor_QueueProfile_count"
    SORT_PROP_ADAPTOR_QUEUE_PROFILE_RING_SIZE = "adaptor_QueueProfile_ringSize"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_HI = "adaptor_RnicCapSpec_fwVersionHi"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_LO = "adaptor_RnicCapSpec_fwVersionLo"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_OPR = "adaptor_RnicCapSpec_fwVersionOpr"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM = "adaptor_RnicCapSpec_maximum"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM_MR = "adaptor_RnicCapSpec_maximumMR"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM_QP = "adaptor_RnicCapSpec_maximumQP"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_NF_VERSION_LO = "adaptor_RnicCapSpec_nfVersionLo"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_TYPE = "adaptor_RnicCapSpec_type"
    SORT_PROP_ADAPTOR_RSS_PROFILE_RECEIVE_SIDE_SCALING = "adaptor_RssProfile_receiveSideScaling"
    SORT_PROP_ADAPTOR_SAN_CAP_HOST_NVRAM = "adaptor_SanCap_hostNvram"
    SORT_PROP_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_IP_HASH = "adaptor_TcpIpRssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_TCP_HASH = "adaptor_TcpIpRssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_FRU_CAP_DN = "adaptor_UnitAssocCtx_fruCapDn"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_ID = "adaptor_UnitAssocCtx_id"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_PCI_ADDR = "adaptor_UnitAssocCtx_pciAddr"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ADAPTOR_ID = "adaptor_UnitExtn_adaptorId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ASSET_TAG = "adaptor_UnitExtn_assetTag"
    SORT_PROP_ADAPTOR_UNIT_EXTN_BLADE_ID = "adaptor_UnitExtn_bladeId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_CHASSIS_ID = "adaptor_UnitExtn_chassisId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ID = "adaptor_UnitExtn_id"
    SORT_PROP_ADAPTOR_UNIT_EXTN_LOCATION_DN = "adaptor_UnitExtn_locationDn"
    SORT_PROP_ADAPTOR_UNIT_EXTN_MODEL = "adaptor_UnitExtn_model"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPER_QUALIFIER_REASON = "adaptor_UnitExtn_operQualifierReason"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPER_STATE = "adaptor_UnitExtn_operState"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPERABILITY = "adaptor_UnitExtn_operability"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PART_NUMBER = "adaptor_UnitExtn_partNumber"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PERF = "adaptor_UnitExtn_perf"
    SORT_PROP_ADAPTOR_UNIT_EXTN_POWER = "adaptor_UnitExtn_power"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PRESENCE = "adaptor_UnitExtn_presence"
    SORT_PROP_ADAPTOR_UNIT_EXTN_REVISION = "adaptor_UnitExtn_revision"
    SORT_PROP_ADAPTOR_UNIT_EXTN_SERIAL = "adaptor_UnitExtn_serial"
    SORT_PROP_ADAPTOR_UNIT_EXTN_THERMAL = "adaptor_UnitExtn_thermal"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VENDOR = "adaptor_UnitExtn_vendor"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VID = "adaptor_UnitExtn_vid"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VOLTAGE = "adaptor_UnitExtn_voltage"
    SORT_PROP_ADAPTOR_UNIT_ADMIN_POWER_STATE = "adaptor_Unit_adminPowerState"
    SORT_PROP_ADAPTOR_UNIT_ASSET_TAG = "adaptor_Unit_assetTag"
    SORT_PROP_ADAPTOR_UNIT_BASE_MAC = "adaptor_Unit_baseMac"
    SORT_PROP_ADAPTOR_UNIT_BLADE_ID = "adaptor_Unit_bladeId"
    SORT_PROP_ADAPTOR_UNIT_CARTRIDGE_ID = "adaptor_Unit_cartridgeId"
    SORT_PROP_ADAPTOR_UNIT_CHASSIS_ID = "adaptor_Unit_chassisId"
    SORT_PROP_ADAPTOR_UNIT_CONN_PATH = "adaptor_Unit_connPath"
    SORT_PROP_ADAPTOR_UNIT_CONN_STATUS = "adaptor_Unit_connStatus"
    SORT_PROP_ADAPTOR_UNIT_DISCOVERY_STATUS = "adaptor_Unit_discoveryStatus"
    SORT_PROP_ADAPTOR_UNIT_ID = "adaptor_Unit_id"
    SORT_PROP_ADAPTOR_UNIT_INTEGRATED = "adaptor_Unit_integrated"
    SORT_PROP_ADAPTOR_UNIT_LOCATION_DN = "adaptor_Unit_locationDn"
    SORT_PROP_ADAPTOR_UNIT_MANAGING_INST = "adaptor_Unit_managingInst"
    SORT_PROP_ADAPTOR_UNIT_MFG_TIME = "adaptor_Unit_mfgTime"
    SORT_PROP_ADAPTOR_UNIT_MODEL = "adaptor_Unit_model"
    SORT_PROP_ADAPTOR_UNIT_MULTI_PORT_CONNECTION_STATUS = "adaptor_Unit_multiPortConnectionStatus"
    SORT_PROP_ADAPTOR_UNIT_OPER_QUALIFIER_REASON = "adaptor_Unit_operQualifierReason"
    SORT_PROP_ADAPTOR_UNIT_OPER_STATE = "adaptor_Unit_operState"
    SORT_PROP_ADAPTOR_UNIT_OPERABILITY = "adaptor_Unit_operability"
    SORT_PROP_ADAPTOR_UNIT_PART_NUMBER = "adaptor_Unit_partNumber"
    SORT_PROP_ADAPTOR_UNIT_PCI_ADDR = "adaptor_Unit_pciAddr"
    SORT_PROP_ADAPTOR_UNIT_PCI_SLOT = "adaptor_Unit_pciSlot"
    SORT_PROP_ADAPTOR_UNIT_PERF = "adaptor_Unit_perf"
    SORT_PROP_ADAPTOR_UNIT_POWER = "adaptor_Unit_power"
    SORT_PROP_ADAPTOR_UNIT_PRESENCE = "adaptor_Unit_presence"
    SORT_PROP_ADAPTOR_UNIT_REACHABILITY = "adaptor_Unit_reachability"
    SORT_PROP_ADAPTOR_UNIT_REVISION = "adaptor_Unit_revision"
    SORT_PROP_ADAPTOR_UNIT_SERIAL = "adaptor_Unit_serial"
    SORT_PROP_ADAPTOR_UNIT_THERMAL = "adaptor_Unit_thermal"
    SORT_PROP_ADAPTOR_UNIT_VENDOR = "adaptor_Unit_vendor"
    SORT_PROP_ADAPTOR_UNIT_VID = "adaptor_Unit_vid"
    SORT_PROP_ADAPTOR_UNIT_VISIBILITY = "adaptor_Unit_visibility"
    SORT_PROP_ADAPTOR_UNIT_VOLTAGE = "adaptor_Unit_voltage"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_LLDP_MAC_OFFSET1 = "adaptor_UplinkHwAddrCap_lldpMacOffset1"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_LLDP_MAC_OFFSET2 = "adaptor_UplinkHwAddrCap_lldpMacOffset2"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_UplinkHwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_UplinkHwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB00 = "adaptor_UplinkHwAddrCap_macOffsetSub00"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB01 = "adaptor_UplinkHwAddrCap_macOffsetSub01"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB02 = "adaptor_UplinkHwAddrCap_macOffsetSub02"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB03 = "adaptor_UplinkHwAddrCap_macOffsetSub03"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB10 = "adaptor_UplinkHwAddrCap_macOffsetSub10"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB11 = "adaptor_UplinkHwAddrCap_macOffsetSub11"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB12 = "adaptor_UplinkHwAddrCap_macOffsetSub12"
    SORT_PROP_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB13 = "adaptor_UplinkHwAddrCap_macOffsetSub13"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_CRC = "adaptor_UplinkPortStats_crc"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_FRAME_TX = "adaptor_UplinkPortStats_frameTx"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_IN_RANGE = "adaptor_UplinkPortStats_inRange"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_PORT_ID = "adaptor_UplinkPortStats_portId"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_TOO_LONG = "adaptor_UplinkPortStats_tooLong"
    SORT_PROP_ADAPTOR_UPLINK_PORT_STATS_TOO_SHORT = "adaptor_UplinkPortStats_tooShort"
    SORT_PROP_ADAPTOR_USNIC_CONN_DEF_CON_POLICY_NAME = "adaptor_UsnicConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_USNIC_CONN_DEF_USNIC_COUNT = "adaptor_UsnicConnDef_usnicCount"
    SORT_PROP_ADAPTOR_VLAN_ASSOC_PRIMARY_VLAN_STATE = "adaptor_Vlan_assocPrimaryVlanState"
    SORT_PROP_ADAPTOR_VLAN_ASSOC_PRIMARY_VLAN_SWITCH_ID = "adaptor_Vlan_assocPrimaryVlanSwitchId"
    SORT_PROP_ADAPTOR_VLAN_EP_DN = "adaptor_Vlan_epDn"
    SORT_PROP_ADAPTOR_VLAN_ID = "adaptor_Vlan_id"
    SORT_PROP_ADAPTOR_VLAN_IF_ROLE = "adaptor_Vlan_ifRole"
    SORT_PROP_ADAPTOR_VLAN_IF_TYPE = "adaptor_Vlan_ifType"
    SORT_PROP_ADAPTOR_VLAN_LC = "adaptor_Vlan_lc"
    SORT_PROP_ADAPTOR_VLAN_LOCALE = "adaptor_Vlan_locale"
    SORT_PROP_ADAPTOR_VLAN_NAME = "adaptor_Vlan_name"
    SORT_PROP_ADAPTOR_VLAN_OPER_STATE = "adaptor_Vlan_operState"
    SORT_PROP_ADAPTOR_VLAN_OVERLAP_STATE_FOR_A = "adaptor_Vlan_overlapStateForA"
    SORT_PROP_ADAPTOR_VLAN_OVERLAP_STATE_FOR_B = "adaptor_Vlan_overlapStateForB"
    SORT_PROP_ADAPTOR_VLAN_PEER_DN = "adaptor_Vlan_peerDn"
    SORT_PROP_ADAPTOR_VLAN_POLICY_OWNER = "adaptor_Vlan_policyOwner"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_DN = "adaptor_Vlan_pubNwDn"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_ID = "adaptor_Vlan_pubNwId"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_NAME = "adaptor_Vlan_pubNwName"
    SORT_PROP_ADAPTOR_VLAN_SHARING = "adaptor_Vlan_sharing"
    SORT_PROP_ADAPTOR_VLAN_SWITCH_ID = "adaptor_Vlan_switchId"
    SORT_PROP_ADAPTOR_VLAN_TRANSPORT = "adaptor_Vlan_transport"
    SORT_PROP_ADAPTOR_VLAN_TYPE = "adaptor_Vlan_type"
    SORT_PROP_ADAPTOR_VLAN_VLAN_TYPE = "adaptor_Vlan_vlanType"
    SORT_PROP_ADAPTOR_VMMQ_CONN_DEF_VMMQ_SUB_VNIC_COUNT = "adaptor_VmmqConnDef_VmmqSubVnicCount"
    SORT_PROP_ADAPTOR_VMMQ_CONN_DEF_CON_POLICY_NAME = "adaptor_VmmqConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX = "adaptor_VnicStatsHist_bytesRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA = "adaptor_VnicStatsHist_bytesRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_AVG = "adaptor_VnicStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MAX = "adaptor_VnicStatsHist_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MIN = "adaptor_VnicStatsHist_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX = "adaptor_VnicStatsHist_bytesTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA = "adaptor_VnicStatsHist_bytesTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_AVG = "adaptor_VnicStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MAX = "adaptor_VnicStatsHist_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MIN = "adaptor_VnicStatsHist_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX = "adaptor_VnicStatsHist_droppedRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA = "adaptor_VnicStatsHist_droppedRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_AVG = "adaptor_VnicStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MAX = "adaptor_VnicStatsHist_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MIN = "adaptor_VnicStatsHist_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX = "adaptor_VnicStatsHist_droppedTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA = "adaptor_VnicStatsHist_droppedTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_AVG = "adaptor_VnicStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MAX = "adaptor_VnicStatsHist_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MIN = "adaptor_VnicStatsHist_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX = "adaptor_VnicStatsHist_errorsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA = "adaptor_VnicStatsHist_errorsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_AVG = "adaptor_VnicStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MAX = "adaptor_VnicStatsHist_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MIN = "adaptor_VnicStatsHist_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX = "adaptor_VnicStatsHist_errorsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA = "adaptor_VnicStatsHist_errorsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_AVG = "adaptor_VnicStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MAX = "adaptor_VnicStatsHist_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MIN = "adaptor_VnicStatsHist_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ID = "adaptor_VnicStatsHist_id"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_MOST_RECENT = "adaptor_VnicStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX = "adaptor_VnicStatsHist_packetsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA = "adaptor_VnicStatsHist_packetsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_AVG = "adaptor_VnicStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MAX = "adaptor_VnicStatsHist_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MIN = "adaptor_VnicStatsHist_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX = "adaptor_VnicStatsHist_packetsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA = "adaptor_VnicStatsHist_packetsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_AVG = "adaptor_VnicStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MAX = "adaptor_VnicStatsHist_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MIN = "adaptor_VnicStatsHist_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_SUSPECT = "adaptor_VnicStatsHist_suspect"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_THRESHOLDED = "adaptor_VnicStatsHist_thresholded"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_TIME_COLLECTED = "adaptor_VnicStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX = "adaptor_VnicStats_bytesRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA = "adaptor_VnicStats_bytesRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_AVG = "adaptor_VnicStats_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MAX = "adaptor_VnicStats_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MIN = "adaptor_VnicStats_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX = "adaptor_VnicStats_bytesTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA = "adaptor_VnicStats_bytesTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_AVG = "adaptor_VnicStats_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MAX = "adaptor_VnicStats_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MIN = "adaptor_VnicStats_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX = "adaptor_VnicStats_droppedRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA = "adaptor_VnicStats_droppedRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_AVG = "adaptor_VnicStats_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MAX = "adaptor_VnicStats_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MIN = "adaptor_VnicStats_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX = "adaptor_VnicStats_droppedTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA = "adaptor_VnicStats_droppedTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_AVG = "adaptor_VnicStats_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MAX = "adaptor_VnicStats_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MIN = "adaptor_VnicStats_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX = "adaptor_VnicStats_errorsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA = "adaptor_VnicStats_errorsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_AVG = "adaptor_VnicStats_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MAX = "adaptor_VnicStats_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MIN = "adaptor_VnicStats_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX = "adaptor_VnicStats_errorsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA = "adaptor_VnicStats_errorsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_AVG = "adaptor_VnicStats_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MAX = "adaptor_VnicStats_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MIN = "adaptor_VnicStats_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_INTERVALS = "adaptor_VnicStats_intervals"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX = "adaptor_VnicStats_packetsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA = "adaptor_VnicStats_packetsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_AVG = "adaptor_VnicStats_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MAX = "adaptor_VnicStats_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MIN = "adaptor_VnicStats_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX = "adaptor_VnicStats_packetsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA = "adaptor_VnicStats_packetsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_AVG = "adaptor_VnicStats_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MAX = "adaptor_VnicStats_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MIN = "adaptor_VnicStats_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_SUSPECT = "adaptor_VnicStats_suspect"
    SORT_PROP_ADAPTOR_VNIC_STATS_THRESHOLDED = "adaptor_VnicStats_thresholded"
    SORT_PROP_ADAPTOR_VNIC_STATS_TIME_COLLECTED = "adaptor_VnicStats_timeCollected"
    SORT_PROP_ADAPTOR_VNIC_STATS_UPDATE = "adaptor_VnicStats_update"
    SORT_PROP_ADAPTOR_VSAN_EP_DN = "adaptor_Vsan_epDn"
    SORT_PROP_ADAPTOR_VSAN_FCOE_VLAN = "adaptor_Vsan_fcoeVlan"
    SORT_PROP_ADAPTOR_VSAN_ID = "adaptor_Vsan_id"
    SORT_PROP_ADAPTOR_VSAN_IF_ROLE = "adaptor_Vsan_ifRole"
    SORT_PROP_ADAPTOR_VSAN_IF_TYPE = "adaptor_Vsan_ifType"
    SORT_PROP_ADAPTOR_VSAN_LC = "adaptor_Vsan_lc"
    SORT_PROP_ADAPTOR_VSAN_LOCALE = "adaptor_Vsan_locale"
    SORT_PROP_ADAPTOR_VSAN_NAME = "adaptor_Vsan_name"
    SORT_PROP_ADAPTOR_VSAN_OPER_STATE = "adaptor_Vsan_operState"
    SORT_PROP_ADAPTOR_VSAN_PEER_DN = "adaptor_Vsan_peerDn"
    SORT_PROP_ADAPTOR_VSAN_POLICY_OWNER = "adaptor_Vsan_policyOwner"
    SORT_PROP_ADAPTOR_VSAN_SWITCH_ID = "adaptor_Vsan_switchId"
    SORT_PROP_ADAPTOR_VSAN_TRANSPORT = "adaptor_Vsan_transport"
    SORT_PROP_ADAPTOR_VSAN_TYPE = "adaptor_Vsan_type"
    SORT_PROP_ADAPTOR_VSAN_ZONING_STATE = "adaptor_Vsan_zoningState"
    SORT_PROP_APE_ADAPTER_VNIC_COOKIE = "ape_AdapterVnic_cookie"
    SORT_PROP_APE_ADAPTER_VNIC_COS = "ape_AdapterVnic_cos"
    SORT_PROP_APE_ADAPTER_VNIC_MAC = "ape_AdapterVnic_mac"
    SORT_PROP_APE_ADAPTER_VNIC_NAME = "ape_AdapterVnic_name"
    SORT_PROP_APE_ADAPTER_VNIC_NIC_DN = "ape_AdapterVnic_nicDn"
    SORT_PROP_APE_ADAPTER_VNIC_STATE = "ape_AdapterVnic_state"
    SORT_PROP_APE_ADAPTER_VNIC_TYPE = "ape_AdapterVnic_type"
    SORT_PROP_APE_ADAPTER_VNIC_UPLINK_PORT_ID = "ape_AdapterVnic_uplinkPortId"
    SORT_PROP_APE_ADAPTER_VNIC_VIF_ID = "ape_AdapterVnic_vifId"
    SORT_PROP_APE_ADAPTER_VNIC_VIF_TYPE = "ape_AdapterVnic_vifType"
    SORT_PROP_APE_ADAPTER_VNIC_VLAN_ID = "ape_AdapterVnic_vlanId"
    SORT_PROP_APE_ADAPTER_VNIC_VNTAG = "ape_AdapterVnic_vntag"
    SORT_PROP_APE_ADAPTER_VNIC_WWNN = "ape_AdapterVnic_wwnn"
    SORT_PROP_APE_ADAPTER_DESCRIPTION = "ape_Adapter_description"
    SORT_PROP_APE_ADAPTER_FRU_ID = "ape_Adapter_fruId"
    SORT_PROP_APE_ADAPTER_HW_VERSION = "ape_Adapter_hwVersion"
    SORT_PROP_APE_ADAPTER_MAC1 = "ape_Adapter_mac1"
    SORT_PROP_APE_ADAPTER_MAC2 = "ape_Adapter_mac2"
    SORT_PROP_APE_ADAPTER_NAME = "ape_Adapter_name"
    SORT_PROP_APE_ADAPTER_SERIAL = "ape_Adapter_serial"
    SORT_PROP_APE_ADAPTER_START_EVENT = "ape_Adapter_startEvent"
    SORT_PROP_APE_ADAPTER_SW_BACKUP_VERSION = "ape_Adapter_swBackupVersion"
    SORT_PROP_APE_ADAPTER_SW_STARTUP_VERSION = "ape_Adapter_swStartupVersion"
    SORT_PROP_APE_ADAPTER_SW_VERSION = "ape_Adapter_swVersion"
    SORT_PROP_APE_ADAPTER_TYPE = "ape_Adapter_type"
    SORT_PROP_APE_ATTRIBUTE_ID = "ape_Attribute_id"
    SORT_PROP_APE_ATTRIBUTE_IP = "ape_Attribute_ip"
    SORT_PROP_APE_ATTRIBUTE_VALUE = "ape_Attribute_value"
    SORT_PROP_APE_BOOT_METHOD_HOSTNAME = "ape_BootMethod_hostname"
    SORT_PROP_APE_BOOT_METHOD_IS_HOST_AGENT_PRESENT = "ape_BootMethod_isHostAgentPresent"
    SORT_PROP_APE_BOOT_METHOD_KERNEL_NAME = "ape_BootMethod_kernelName"
    SORT_PROP_APE_BOOT_METHOD_KERNEL_RELEASE = "ape_BootMethod_kernelRelease"
    SORT_PROP_APE_BOOT_METHOD_KERNEL_VERSION = "ape_BootMethod_kernelVersion"
    SORT_PROP_APE_BOOT_METHOD_NAME = "ape_BootMethod_name"
    SORT_PROP_APE_BOOT_METHOD_TYPE = "ape_BootMethod_type"
    SORT_PROP_APE_CONTROLLER_CHASSIS_INDEX = "ape_ControllerChassis_index"
    SORT_PROP_APE_CONTROLLER_EEPROM_DATABASE_VERSION = "ape_ControllerEeprom_databaseVersion"
    SORT_PROP_APE_CONTROLLER_EEPROM_HEARTBEAT_REQUEST = "ape_ControllerEeprom_heartbeatRequest"
    SORT_PROP_APE_CONTROLLER_EEPROM_HEARTBEAT_RESPONSE = "ape_ControllerEeprom_heartbeatResponse"
    SORT_PROP_APE_CONTROLLER_EEPROM_SIDE = "ape_ControllerEeprom_side"
    SORT_PROP_APE_FRU_BOARD_FRU = "ape_Fru_boardFru"
    SORT_PROP_APE_FRU_BOARD_MANUFACTURER = "ape_Fru_boardManufacturer"
    SORT_PROP_APE_FRU_BOARD_MFG_TIME = "ape_Fru_boardMfgTime"
    SORT_PROP_APE_FRU_BOARD_PART_NO = "ape_Fru_boardPartNo"
    SORT_PROP_APE_FRU_BOARD_PRODUCT_NAME = "ape_Fru_boardProductName"
    SORT_PROP_APE_FRU_BOARD_SERIAL_NO = "ape_Fru_boardSerialNo"
    SORT_PROP_APE_FRU_BOARD_VID = "ape_Fru_boardVid"
    SORT_PROP_APE_FRU_CHASSIS_PART_NO = "ape_Fru_chassisPartNo"
    SORT_PROP_APE_FRU_CHASSIS_SERIAL_NO = "ape_Fru_chassisSerialNo"
    SORT_PROP_APE_FRU_CONTROL_PLANE_MAC1 = "ape_Fru_controlPlaneMac1"
    SORT_PROP_APE_FRU_CONTROL_PLANE_MAC2 = "ape_Fru_controlPlaneMac2"
    SORT_PROP_APE_FRU_DATA_PLANE_MAC1 = "ape_Fru_dataPlaneMac1"
    SORT_PROP_APE_FRU_DATA_PLANE_MAC2 = "ape_Fru_dataPlaneMac2"
    SORT_PROP_APE_FRU_DATA_PLANE_WWN1 = "ape_Fru_dataPlaneWwn1"
    SORT_PROP_APE_FRU_DATA_PLANE_WWN2 = "ape_Fru_dataPlaneWwn2"
    SORT_PROP_APE_FRU_ENTITY_TYPE = "ape_Fru_entityType"
    SORT_PROP_APE_FRU_ID = "ape_Fru_id"
    SORT_PROP_APE_FRU_INSTANCE = "ape_Fru_instance"
    SORT_PROP_APE_FRU_PRODUCT_ASSET_TAG = "ape_Fru_productAssetTag"
    SORT_PROP_APE_FRU_PRODUCT_FRU = "ape_Fru_productFru"
    SORT_PROP_APE_FRU_PRODUCT_MANUFACTURER = "ape_Fru_productManufacturer"
    SORT_PROP_APE_FRU_PRODUCT_NAME = "ape_Fru_productName"
    SORT_PROP_APE_FRU_PRODUCT_PART_NO = "ape_Fru_productPartNo"
    SORT_PROP_APE_FRU_PRODUCT_SERIAL_NO = "ape_Fru_productSerialNo"
    SORT_PROP_APE_FRU_PRODUCT_VERSION_NO = "ape_Fru_productVersionNo"
    SORT_PROP_APE_FRU_TYPE = "ape_Fru_type"
    SORT_PROP_APE_HOST_AGENT_CHASSIS_ID = "ape_HostAgent_chassisId"
    SORT_PROP_APE_HOST_AGENT_SERVER_ID = "ape_HostAgent_serverId"
    SORT_PROP_APE_HOST_AGENT_SLOT_ID = "ape_HostAgent_slotId"
    SORT_PROP_APE_HOST_AGENT_STATE = "ape_HostAgent_state"
    SORT_PROP_APE_LANBOOT_HOSTNAME = "ape_LANBoot_hostname"
    SORT_PROP_APE_LANBOOT_IS_HOST_AGENT_PRESENT = "ape_LANBoot_isHostAgentPresent"
    SORT_PROP_APE_LANBOOT_KERNEL_NAME = "ape_LANBoot_kernelName"
    SORT_PROP_APE_LANBOOT_KERNEL_RELEASE = "ape_LANBoot_kernelRelease"
    SORT_PROP_APE_LANBOOT_KERNEL_VERSION = "ape_LANBoot_kernelVersion"
    SORT_PROP_APE_LANBOOT_NAME = "ape_LANBoot_name"
    SORT_PROP_APE_LANBOOT_TYPE = "ape_LANBoot_type"
    SORT_PROP_APE_LANBOOT_VNIC_NAME = "ape_LANBoot_vnicName"
    SORT_PROP_APE_LOCAL_DISK_BOOT_CHASSIS_ID = "ape_LocalDiskBoot_chassisId"
    SORT_PROP_APE_LOCAL_DISK_BOOT_HOSTNAME = "ape_LocalDiskBoot_hostname"
    SORT_PROP_APE_LOCAL_DISK_BOOT_IS_HOST_AGENT_PRESENT = "ape_LocalDiskBoot_isHostAgentPresent"
    SORT_PROP_APE_LOCAL_DISK_BOOT_KERNEL_NAME = "ape_LocalDiskBoot_kernelName"
    SORT_PROP_APE_LOCAL_DISK_BOOT_KERNEL_RELEASE = "ape_LocalDiskBoot_kernelRelease"
    SORT_PROP_APE_LOCAL_DISK_BOOT_KERNEL_VERSION = "ape_LocalDiskBoot_kernelVersion"
    SORT_PROP_APE_LOCAL_DISK_BOOT_NAME = "ape_LocalDiskBoot_name"
    SORT_PROP_APE_LOCAL_DISK_BOOT_SLOT_ID = "ape_LocalDiskBoot_slotId"
    SORT_PROP_APE_LOCAL_DISK_BOOT_TARGET_LUN = "ape_LocalDiskBoot_targetLun"
    SORT_PROP_APE_LOCAL_DISK_BOOT_TYPE = "ape_LocalDiskBoot_type"
    SORT_PROP_APE_MANAGER_STATS_UPDATE_ID = "ape_Manager_statsUpdateId"
    SORT_PROP_APE_MC_STATS_CUSTOM_FACTOR = "ape_McStats_customFactor"
    SORT_PROP_APE_MC_STATS_CUSTOM_POLICY = "ape_McStats_customPolicy"
    SORT_PROP_APE_MC_STATS_DEFAULT_FACTOR = "ape_McStats_defaultFactor"
    SORT_PROP_APE_MC_STATS_DEFAULT_POLICY = "ape_McStats_defaultPolicy"
    SORT_PROP_APE_MC_STATS_NAME = "ape_McStats_name"
    SORT_PROP_APE_MC_STATS_PARENT_ID = "ape_McStats_parentId"
    SORT_PROP_APE_MC_STATS_PARENT_NAME = "ape_McStats_parentName"
    SORT_PROP_APE_MC_STATS_RAND_RANGE_END = "ape_McStats_randRangeEnd"
    SORT_PROP_APE_MC_STATS_RAND_RANGE_START = "ape_McStats_randRangeStart"
    SORT_PROP_APE_MC_STATS_VALUE = "ape_McStats_value"
    SORT_PROP_APE_MC_TABLE_ID = "ape_McTable_id"
    SORT_PROP_APE_MC_TABLE_NAME = "ape_McTable_name"
    SORT_PROP_APE_MC_IP = "ape_Mc_ip"
    SORT_PROP_APE_MC_TYPE = "ape_Mc_type"
    SORT_PROP_APE_MC_UPDATE_TYPE = "ape_Mc_updateType"
    SORT_PROP_APE_MENLO_VNIC_STATS_BYTES_EG = "ape_MenloVnicStats_bytes_eg"
    SORT_PROP_APE_MENLO_VNIC_STATS_BYTES_IN = "ape_MenloVnicStats_bytes_in"
    SORT_PROP_APE_MENLO_VNIC_STATS_DROPPED_PKTS_EG = "ape_MenloVnicStats_dropped_pkts_eg"
    SORT_PROP_APE_MENLO_VNIC_STATS_DROPPED_PKTS_IN = "ape_MenloVnicStats_dropped_pkts_in"
    SORT_PROP_APE_MENLO_VNIC_STATS_ERRORS_EG = "ape_MenloVnicStats_errors_eg"
    SORT_PROP_APE_MENLO_VNIC_STATS_ERRORS_IN = "ape_MenloVnicStats_errors_in"
    SORT_PROP_APE_MENLO_VNIC_STATS_PKTS_EG = "ape_MenloVnicStats_pkts_eg"
    SORT_PROP_APE_MENLO_VNIC_STATS_PKTS_IN = "ape_MenloVnicStats_pkts_in"
    SORT_PROP_APE_MENLO_VNIC_COOKIE = "ape_MenloVnic_cookie"
    SORT_PROP_APE_MENLO_VNIC_COS = "ape_MenloVnic_cos"
    SORT_PROP_APE_MENLO_VNIC_MAC = "ape_MenloVnic_mac"
    SORT_PROP_APE_MENLO_VNIC_NAME = "ape_MenloVnic_name"
    SORT_PROP_APE_MENLO_VNIC_NIC_DN = "ape_MenloVnic_nicDn"
    SORT_PROP_APE_MENLO_VNIC_PIF_ID = "ape_MenloVnic_pifId"
    SORT_PROP_APE_MENLO_VNIC_STATE = "ape_MenloVnic_state"
    SORT_PROP_APE_MENLO_VNIC_TYPE = "ape_MenloVnic_type"
    SORT_PROP_APE_MENLO_VNIC_UPLINK_PORT_ID = "ape_MenloVnic_uplinkPortId"
    SORT_PROP_APE_MENLO_VNIC_VIF_ID = "ape_MenloVnic_vifId"
    SORT_PROP_APE_MENLO_VNIC_VIF_TYPE = "ape_MenloVnic_vifType"
    SORT_PROP_APE_MENLO_VNIC_VLAN_ID = "ape_MenloVnic_vlanId"
    SORT_PROP_APE_MENLO_VNIC_VNTAG = "ape_MenloVnic_vntag"
    SORT_PROP_APE_MENLO_VNIC_WWNN = "ape_MenloVnic_wwnn"
    SORT_PROP_APE_MENLO_VNIC_WWPN = "ape_MenloVnic_wwpn"
    SORT_PROP_APE_MENLO_DESCRIPTION = "ape_Menlo_description"
    SORT_PROP_APE_MENLO_FRU_ID = "ape_Menlo_fruId"
    SORT_PROP_APE_MENLO_FW_UPDATE_TIMEOUT = "ape_Menlo_fwUpdateTimeout"
    SORT_PROP_APE_MENLO_HW_VERSION = "ape_Menlo_hwVersion"
    SORT_PROP_APE_MENLO_MAC1 = "ape_Menlo_mac1"
    SORT_PROP_APE_MENLO_MAC2 = "ape_Menlo_mac2"
    SORT_PROP_APE_MENLO_NAME = "ape_Menlo_name"
    SORT_PROP_APE_MENLO_OPERATION_TIMEOUT = "ape_Menlo_operationTimeout"
    SORT_PROP_APE_MENLO_SERIAL = "ape_Menlo_serial"
    SORT_PROP_APE_MENLO_START_EVENT = "ape_Menlo_startEvent"
    SORT_PROP_APE_MENLO_SW_BACKUP_VERSION = "ape_Menlo_swBackupVersion"
    SORT_PROP_APE_MENLO_SW_STARTUP_VERSION = "ape_Menlo_swStartupVersion"
    SORT_PROP_APE_MENLO_SW_VERSION = "ape_Menlo_swVersion"
    SORT_PROP_APE_MENLO_TYPE = "ape_Menlo_type"
    SORT_PROP_APE_MENLO_UPLINK_PORT_TYPE = "ape_Menlo_uplinkPortType"
    SORT_PROP_APE_PALO_VNIC_STATS_BYTES_EG = "ape_PaloVnicStats_bytes_eg"
    SORT_PROP_APE_PALO_VNIC_STATS_BYTES_IN = "ape_PaloVnicStats_bytes_in"
    SORT_PROP_APE_PALO_VNIC_STATS_DROPPED_PKTS_EG = "ape_PaloVnicStats_dropped_pkts_eg"
    SORT_PROP_APE_PALO_VNIC_STATS_DROPPED_PKTS_IN = "ape_PaloVnicStats_dropped_pkts_in"
    SORT_PROP_APE_PALO_VNIC_STATS_ERRORS_EG = "ape_PaloVnicStats_errors_eg"
    SORT_PROP_APE_PALO_VNIC_STATS_ERRORS_IN = "ape_PaloVnicStats_errors_in"
    SORT_PROP_APE_PALO_VNIC_STATS_PKTS_EG = "ape_PaloVnicStats_pkts_eg"
    SORT_PROP_APE_PALO_VNIC_STATS_PKTS_IN = "ape_PaloVnicStats_pkts_in"
    SORT_PROP_APE_PALO_VNIC_COOKIE = "ape_PaloVnic_cookie"
    SORT_PROP_APE_PALO_VNIC_COS = "ape_PaloVnic_cos"
    SORT_PROP_APE_PALO_VNIC_FAILOVER = "ape_PaloVnic_failover"
    SORT_PROP_APE_PALO_VNIC_MAC = "ape_PaloVnic_mac"
    SORT_PROP_APE_PALO_VNIC_MTU = "ape_PaloVnic_mtu"
    SORT_PROP_APE_PALO_VNIC_NAME = "ape_PaloVnic_name"
    SORT_PROP_APE_PALO_VNIC_NIC_DN = "ape_PaloVnic_nicDn"
    SORT_PROP_APE_PALO_VNIC_PASS_THRU = "ape_PaloVnic_passThru"
    SORT_PROP_APE_PALO_VNIC_STATE = "ape_PaloVnic_state"
    SORT_PROP_APE_PALO_VNIC_STDBY_VIF_ID = "ape_PaloVnic_stdbyVifId"
    SORT_PROP_APE_PALO_VNIC_TYPE = "ape_PaloVnic_type"
    SORT_PROP_APE_PALO_VNIC_UPLINK_PORT_ID = "ape_PaloVnic_uplinkPortId"
    SORT_PROP_APE_PALO_VNIC_VIF_ID = "ape_PaloVnic_vifId"
    SORT_PROP_APE_PALO_VNIC_VIF_TYPE = "ape_PaloVnic_vifType"
    SORT_PROP_APE_PALO_VNIC_VLAN_ID = "ape_PaloVnic_vlanId"
    SORT_PROP_APE_PALO_VNIC_VM_WARE = "ape_PaloVnic_vmWare"
    SORT_PROP_APE_PALO_VNIC_VNTAG = "ape_PaloVnic_vntag"
    SORT_PROP_APE_PALO_VNIC_WWNN = "ape_PaloVnic_wwnn"
    SORT_PROP_APE_PALO_DESCRIPTION = "ape_Palo_description"
    SORT_PROP_APE_PALO_FRU_ID = "ape_Palo_fruId"
    SORT_PROP_APE_PALO_HW_VERSION = "ape_Palo_hwVersion"
    SORT_PROP_APE_PALO_MAC1 = "ape_Palo_mac1"
    SORT_PROP_APE_PALO_MAC2 = "ape_Palo_mac2"
    SORT_PROP_APE_PALO_NAME = "ape_Palo_name"
    SORT_PROP_APE_PALO_SERIAL = "ape_Palo_serial"
    SORT_PROP_APE_PALO_START_EVENT = "ape_Palo_startEvent"
    SORT_PROP_APE_PALO_SW_BACKUP_VERSION = "ape_Palo_swBackupVersion"
    SORT_PROP_APE_PALO_SW_STARTUP_VERSION = "ape_Palo_swStartupVersion"
    SORT_PROP_APE_PALO_SW_VERSION = "ape_Palo_swVersion"
    SORT_PROP_APE_PALO_TYPE = "ape_Palo_type"
    SORT_PROP_APE_PARAM_KEY = "ape_Param_key"
    SORT_PROP_APE_PARAM_VALUE = "ape_Param_value"
    SORT_PROP_APE_READING_ID = "ape_Reading_id"
    SORT_PROP_APE_READING_IS_ANALOG = "ape_Reading_is_analog"
    SORT_PROP_APE_READING_SENSOR_TYPE = "ape_Reading_sensorType"
    SORT_PROP_APE_READING_STATE = "ape_Reading_state"
    SORT_PROP_APE_READING_THRESHOLD_LC = "ape_Reading_thresholdLc"
    SORT_PROP_APE_READING_THRESHOLD_LNC = "ape_Reading_thresholdLnc"
    SORT_PROP_APE_READING_THRESHOLD_LNR = "ape_Reading_thresholdLnr"
    SORT_PROP_APE_READING_THRESHOLD_UC = "ape_Reading_thresholdUc"
    SORT_PROP_APE_READING_THRESHOLD_UNC = "ape_Reading_thresholdUnc"
    SORT_PROP_APE_READING_THRESHOLD_UNR = "ape_Reading_thresholdUnr"
    SORT_PROP_APE_READING_VALUE = "ape_Reading_value"
    SORT_PROP_APE_SANBOOT_HOSTNAME = "ape_SANBoot_hostname"
    SORT_PROP_APE_SANBOOT_IS_HOST_AGENT_PRESENT = "ape_SANBoot_isHostAgentPresent"
    SORT_PROP_APE_SANBOOT_KERNEL_NAME = "ape_SANBoot_kernelName"
    SORT_PROP_APE_SANBOOT_KERNEL_RELEASE = "ape_SANBoot_kernelRelease"
    SORT_PROP_APE_SANBOOT_KERNEL_VERSION = "ape_SANBoot_kernelVersion"
    SORT_PROP_APE_SANBOOT_NAME = "ape_SANBoot_name"
    SORT_PROP_APE_SANBOOT_TARGET_LUN = "ape_SANBoot_targetLun"
    SORT_PROP_APE_SANBOOT_TARGET_WWN = "ape_SANBoot_targetWWN"
    SORT_PROP_APE_SANBOOT_TYPE = "ape_SANBoot_type"
    SORT_PROP_APE_SDR_ENTITY_TYPE = "ape_Sdr_entityType"
    SORT_PROP_APE_SDR_EVENT_READING_TYPE = "ape_Sdr_eventReadingType"
    SORT_PROP_APE_SDR_ID = "ape_Sdr_id"
    SORT_PROP_APE_SDR_INSTANCE = "ape_Sdr_instance"
    SORT_PROP_APE_SDR_NAME = "ape_Sdr_name"
    SORT_PROP_APE_SDR_SDR_TYPE = "ape_Sdr_sdr_type"
    SORT_PROP_APE_SDR_SENSOR_ID = "ape_Sdr_sensorId"
    SORT_PROP_APE_SDR_SENSOR_TYPE = "ape_Sdr_sensor_type"
    SORT_PROP_APE_SDR_UNITS = "ape_Sdr_units"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_BIOS_VERSION = "ape_SwitchFirmwareInv_biosVersion"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_FABRIC = "ape_SwitchFirmwareInv_fabric"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_KS_STARTUP_VERSION = "ape_SwitchFirmwareInv_ksStartupVersion"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_KS_VERSION = "ape_SwitchFirmwareInv_ksVersion"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_NAME = "ape_SwitchFirmwareInv_name"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_SYS_STARTUP_VERSION = "ape_SwitchFirmwareInv_sysStartupVersion"
    SORT_PROP_APE_SWITCH_FIRMWARE_INV_SYS_VERSION = "ape_SwitchFirmwareInv_sysVersion"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_CHASSIS_ID = "ape_VirtualMediaBoot_chassisId"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_HOSTNAME = "ape_VirtualMediaBoot_hostname"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_IS_HOST_AGENT_PRESENT = "ape_VirtualMediaBoot_isHostAgentPresent"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_KERNEL_NAME = "ape_VirtualMediaBoot_kernelName"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_KERNEL_RELEASE = "ape_VirtualMediaBoot_kernelRelease"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_KERNEL_VERSION = "ape_VirtualMediaBoot_kernelVersion"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_NAME = "ape_VirtualMediaBoot_name"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_SLOT_ID = "ape_VirtualMediaBoot_slotId"
    SORT_PROP_APE_VIRTUAL_MEDIA_BOOT_TYPE = "ape_VirtualMediaBoot_type"
    SORT_PROP_APE_VNIC_STATS_BYTES_EG = "ape_VnicStats_bytes_eg"
    SORT_PROP_APE_VNIC_STATS_BYTES_IN = "ape_VnicStats_bytes_in"
    SORT_PROP_APE_VNIC_STATS_DROPPED_PKTS_EG = "ape_VnicStats_dropped_pkts_eg"
    SORT_PROP_APE_VNIC_STATS_DROPPED_PKTS_IN = "ape_VnicStats_dropped_pkts_in"
    SORT_PROP_APE_VNIC_STATS_ERRORS_EG = "ape_VnicStats_errors_eg"
    SORT_PROP_APE_VNIC_STATS_ERRORS_IN = "ape_VnicStats_errors_in"
    SORT_PROP_APE_VNIC_STATS_PKTS_EG = "ape_VnicStats_pkts_eg"
    SORT_PROP_APE_VNIC_STATS_PKTS_IN = "ape_VnicStats_pkts_in"
    SORT_PROP_BIOS_AREF_IS_SUPPORTED = "bios_ARef_isSupported"
    SORT_PROP_BIOS_AREF_NAME = "bios_ARef_name"
    SORT_PROP_BIOS_BOT_LAST_UPDATE = "bios_BOT_lastUpdate"
    SORT_PROP_BIOS_BOOT_DEV_GRP_DESCR = "bios_BootDevGrp_descr"
    SORT_PROP_BIOS_BOOT_DEV_GRP_DEVICE_NAME = "bios_BootDevGrp_deviceName"
    SORT_PROP_BIOS_BOOT_DEV_GRP_ERR_VAL = "bios_BootDevGrp_errVal"
    SORT_PROP_BIOS_BOOT_DEV_GRP_ORDER = "bios_BootDevGrp_order"
    SORT_PROP_BIOS_BOOT_DEV_GRP_TYPE = "bios_BootDevGrp_type"
    SORT_PROP_BIOS_BOOT_DEV_DESCR = "bios_BootDev_descr"
    SORT_PROP_BIOS_BOOT_DEV_DEVICE_NAME = "bios_BootDev_deviceName"
    SORT_PROP_BIOS_BOOT_DEV_ERR_VALUE = "bios_BootDev_errValue"
    SORT_PROP_BIOS_BOOT_DEV_ORDER = "bios_BootDev_order"
    SORT_PROP_BIOS_FEATURE_REF_FTR_MO_CLASS_NAME = "bios_FeatureRef_ftrMoClassName"
    SORT_PROP_BIOS_FEATURE_REF_IS_SUPPORTED = "bios_FeatureRef_isSupported"
    SORT_PROP_BIOS_FEATURE_REF_NAME = "bios_FeatureRef_name"
    SORT_PROP_BIOS_PARAMETER_REF_IS_SUPPORTED = "bios_ParameterRef_isSupported"
    SORT_PROP_BIOS_PARAMETER_REF_NAME = "bios_ParameterRef_name"
    SORT_PROP_BIOS_PARAMETER_REF_PROPERTY_NAME = "bios_ParameterRef_propertyName"
    SORT_PROP_BIOS_REF_FORCE_OVERRIDE_ON_LOAD = "bios_Ref_forceOverrideOnLoad"
    SORT_PROP_BIOS_REF_IS_SUPPORTED = "bios_Ref_isSupported"
    SORT_PROP_BIOS_SETTING_REF_CONSTANT_NAME = "bios_SettingRef_constantName"
    SORT_PROP_BIOS_SETTING_REF_IS_DEFAULT = "bios_SettingRef_isDefault"
    SORT_PROP_BIOS_SETTING_REF_IS_SUPPORTED = "bios_SettingRef_isSupported"
    SORT_PROP_BIOS_SETTING_REF_NAME = "bios_SettingRef_name"
    SORT_PROP_BIOS_SETTINGS_PROP_ACL = "bios_Settings_propAcl"
    SORT_PROP_BIOS_TOKEN_FEATURE_GROUP_NAME = "bios_TokenFeatureGroup_name"
    SORT_PROP_BIOS_TOKEN_FEATURE_GROUP_SUPPORTED_BY_DEFAULT = "bios_TokenFeatureGroup_supportedByDefault"
    SORT_PROP_BIOS_TOKEN_PARAM_TYPE = "bios_TokenParam_Type"
    SORT_PROP_BIOS_TOKEN_PARAM_LEGACY_PROP_ID = "bios_TokenParam_legacyPropId"
    SORT_PROP_BIOS_TOKEN_PARAM_PARAM_NAME = "bios_TokenParam_paramName"
    SORT_PROP_BIOS_TOKEN_PARAM_TARGET_TOKEN_NAME = "bios_TokenParam_targetTokenName"
    SORT_PROP_BIOS_TOKEN_PARAM_UI_GROUP_NAME = "bios_TokenParam_uiGroupName"
    SORT_PROP_BIOS_TOKEN_SETTINGS_MAXIMUM = "bios_TokenSettings_Maximum"
    SORT_PROP_BIOS_TOKEN_SETTINGS_MINIMUM = "bios_TokenSettings_Minimum"
    SORT_PROP_BIOS_TOKEN_SETTINGS_STEP = "bios_TokenSettings_Step"
    SORT_PROP_BIOS_TOKEN_SETTINGS_UNIT = "bios_TokenSettings_Unit"
    SORT_PROP_BIOS_TOKEN_SETTINGS_BIOS_RET_SETTING_NAME = "bios_TokenSettings_biosRetSettingName"
    SORT_PROP_BIOS_TOKEN_SETTINGS_IS_ASSIGNED = "bios_TokenSettings_isAssigned"
    SORT_PROP_BIOS_TOKEN_SETTINGS_LEGACY_PROP_VAL = "bios_TokenSettings_legacyPropVal"
    SORT_PROP_BIOS_TOKEN_SETTINGS_SETTINGS_MO_RN = "bios_TokenSettings_settingsMoRn"
    SORT_PROP_BIOS_TOKEN_SETTINGS_TARGET_TOKEN_VALUE = "bios_TokenSettings_targetTokenValue"
    SORT_PROP_BIOS_UNIT_INIT_SEQ = "bios_Unit_initSeq"
    SORT_PROP_BIOS_UNIT_INIT_TS = "bios_Unit_initTs"
    SORT_PROP_BIOS_UNIT_MODEL = "bios_Unit_model"
    SORT_PROP_BIOS_UNIT_REVISION = "bios_Unit_revision"
    SORT_PROP_BIOS_UNIT_SERIAL = "bios_Unit_serial"
    SORT_PROP_BIOS_UNIT_VENDOR = "bios_Unit_vendor"
    SORT_PROP_BIOS_VFEAT_PROP_ACL = "bios_VFeat_propAcl"
    SORT_PROP_BIOS_VFEAT_SUPPORTED_BY_DEFAULT = "bios_VFeat_supportedByDefault"
    SORT_PROP_BIOS_VIDENTITY_PARAMS_LS_SERVER_NAME = "bios_VIdentityParams_lsServerName"
    SORT_PROP_BIOS_VIDENTITY_PARAMS_LS_SERVER_TMPL_NAME = "bios_VIdentityParams_lsServerTmplName"
    SORT_PROP_BIOS_VIDENTITY_PARAMS_SYS_NAME = "bios_VIdentityParams_sysName"
    SORT_PROP_BIOS_VPROFILE_DESCR = "bios_VProfile_descr"
    SORT_PROP_BIOS_VPROFILE_INT_ID = "bios_VProfile_intId"
    SORT_PROP_BIOS_VPROFILE_NAME = "bios_VProfile_name"
    SORT_PROP_BIOS_VPROFILE_POLICY_LEVEL = "bios_VProfile_policyLevel"
    SORT_PROP_BIOS_VPROFILE_POLICY_OWNER = "bios_VProfile_policyOwner"
    SORT_PROP_BIOS_VPROFILE_REBOOT_ON_UPDATE = "bios_VProfile_rebootOnUpdate"
    SORT_PROP_BIOS_VF_ACPI10_SUPPORT_PROP_ACL = "bios_VfACPI10Support_propAcl"
    SORT_PROP_BIOS_VF_ACPI10_SUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfACPI10Support_supportedByDefault"
    SORT_PROP_BIOS_VF_ACPI10_SUPPORT_VP_ACPI10_SUPPORT = "bios_VfACPI10Support_vpACPI10Support"
    SORT_PROP_BIOS_VF_ASPMSUPPORT_PROP_ACL = "bios_VfASPMSupport_propAcl"
    SORT_PROP_BIOS_VF_ASPMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfASPMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_ASPMSUPPORT_VP_ASPMSUPPORT = "bios_VfASPMSupport_vpASPMSupport"
    SORT_PROP_BIOS_VF_ALL_USBDEVICES_PROP_ACL = "bios_VfAllUSBDevices_propAcl"
    SORT_PROP_BIOS_VF_ALL_USBDEVICES_SUPPORTED_BY_DEFAULT = "bios_VfAllUSBDevices_supportedByDefault"
    SORT_PROP_BIOS_VF_ALL_USBDEVICES_VP_ALL_USBDEVICES = "bios_VfAllUSBDevices_vpAllUSBDevices"
    SORT_PROP_BIOS_VF_ALTITUDE_PROP_ACL = "bios_VfAltitude_propAcl"
    SORT_PROP_BIOS_VF_ALTITUDE_SUPPORTED_BY_DEFAULT = "bios_VfAltitude_supportedByDefault"
    SORT_PROP_BIOS_VF_ALTITUDE_VP_ALTITUDE = "bios_VfAltitude_vpAltitude"
    SORT_PROP_BIOS_VF_ASSERT_NMION_PERR_PROP_ACL = "bios_VfAssertNMIOnPERR_propAcl"
    SORT_PROP_BIOS_VF_ASSERT_NMION_PERR_SUPPORTED_BY_DEFAULT = "bios_VfAssertNMIOnPERR_supportedByDefault"
    SORT_PROP_BIOS_VF_ASSERT_NMION_PERR_VP_ASSERT_NMION_PERR = "bios_VfAssertNMIOnPERR_vpAssertNMIOnPERR"
    SORT_PROP_BIOS_VF_ASSERT_NMION_SERR_PROP_ACL = "bios_VfAssertNMIOnSERR_propAcl"
    SORT_PROP_BIOS_VF_ASSERT_NMION_SERR_SUPPORTED_BY_DEFAULT = "bios_VfAssertNMIOnSERR_supportedByDefault"
    SORT_PROP_BIOS_VF_ASSERT_NMION_SERR_VP_ASSERT_NMION_SERR = "bios_VfAssertNMIOnSERR_vpAssertNMIOnSERR"
    SORT_PROP_BIOS_VF_BMEDMAMITIGATION_PROP_ACL = "bios_VfBMEDMAMitigation_propAcl"
    SORT_PROP_BIOS_VF_BMEDMAMITIGATION_SUPPORTED_BY_DEFAULT = "bios_VfBMEDMAMitigation_supportedByDefault"
    SORT_PROP_BIOS_VF_BMEDMAMITIGATION_VP_BMEDMAMITIGATION = "bios_VfBMEDMAMitigation_vpBMEDMAMitigation"
    SORT_PROP_BIOS_VF_BOOT_OPTION_RETRY_PROP_ACL = "bios_VfBootOptionRetry_propAcl"
    SORT_PROP_BIOS_VF_BOOT_OPTION_RETRY_SUPPORTED_BY_DEFAULT = "bios_VfBootOptionRetry_supportedByDefault"
    SORT_PROP_BIOS_VF_BOOT_OPTION_RETRY_VP_BOOT_OPTION_RETRY = "bios_VfBootOptionRetry_vpBootOptionRetry"
    SORT_PROP_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT_PROP_ACL = "bios_VfCPUHardwarePowerManagement_propAcl"
    SORT_PROP_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT_SUPPORTED_BY_DEFAULT = "bios_VfCPUHardwarePowerManagement_supportedByDefault"
    SORT_PROP_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT_VP_CPUHARDWARE_POWER_MANAGEMENT = "bios_VfCPUHardwarePowerManagement_vpCPUHardwarePowerManagement"
    SORT_PROP_BIOS_VF_CPUPERFORMANCE_PROP_ACL = "bios_VfCPUPerformance_propAcl"
    SORT_PROP_BIOS_VF_CPUPERFORMANCE_SUPPORTED_BY_DEFAULT = "bios_VfCPUPerformance_supportedByDefault"
    SORT_PROP_BIOS_VF_CPUPERFORMANCE_VP_CPUPERFORMANCE = "bios_VfCPUPerformance_vpCPUPerformance"
    SORT_PROP_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL_PROP_ACL = "bios_VfConsistentDeviceNameControl_propAcl"
    SORT_PROP_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfConsistentDeviceNameControl_supportedByDefault"
    SORT_PROP_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL_VP_CDNCONTROL = "bios_VfConsistentDeviceNameControl_vpCDNControl"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_PROP_ACL = "bios_VfConsoleRedirection_propAcl"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_SUPPORTED_BY_DEFAULT = "bios_VfConsoleRedirection_supportedByDefault"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_BAUD_RATE = "bios_VfConsoleRedirection_vpBaudRate"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_CONSOLE_REDIRECTION = "bios_VfConsoleRedirection_vpConsoleRedirection"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_FLOW_CONTROL = "bios_VfConsoleRedirection_vpFlowControl"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_LEGACY_OSREDIRECTION = "bios_VfConsoleRedirection_vpLegacyOSRedirection"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_PUTTY_KEY_PAD = "bios_VfConsoleRedirection_vpPuttyKeyPad"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_TERMINAL_TYPE = "bios_VfConsoleRedirection_vpTerminalType"
    SORT_PROP_BIOS_VF_CORE_MULTI_PROCESSING_PROP_ACL = "bios_VfCoreMultiProcessing_propAcl"
    SORT_PROP_BIOS_VF_CORE_MULTI_PROCESSING_SUPPORTED_BY_DEFAULT = "bios_VfCoreMultiProcessing_supportedByDefault"
    SORT_PROP_BIOS_VF_CORE_MULTI_PROCESSING_VP_CORE_MULTI_PROCESSING = "bios_VfCoreMultiProcessing_vpCoreMultiProcessing"
    SORT_PROP_BIOS_VF_DDR3_VOLTAGE_SELECTION_PROP_ACL = "bios_VfDDR3VoltageSelection_propAcl"
    SORT_PROP_BIOS_VF_DDR3_VOLTAGE_SELECTION_SUPPORTED_BY_DEFAULT = "bios_VfDDR3VoltageSelection_supportedByDefault"
    SORT_PROP_BIOS_VF_DDR3_VOLTAGE_SELECTION_VP_DDR3_VOLTAGE_SELECTION = "bios_VfDDR3VoltageSelection_vpDDR3VoltageSelection"
    SORT_PROP_BIOS_VF_DRAMCLOCK_THROTTLING_PROP_ACL = "bios_VfDRAMClockThrottling_propAcl"
    SORT_PROP_BIOS_VF_DRAMCLOCK_THROTTLING_SUPPORTED_BY_DEFAULT = "bios_VfDRAMClockThrottling_supportedByDefault"
    SORT_PROP_BIOS_VF_DRAMCLOCK_THROTTLING_VP_DRAMCLOCK_THROTTLING = "bios_VfDRAMClockThrottling_vpDRAMClockThrottling"
    SORT_PROP_BIOS_VF_DIRECT_CACHE_ACCESS_PROP_ACL = "bios_VfDirectCacheAccess_propAcl"
    SORT_PROP_BIOS_VF_DIRECT_CACHE_ACCESS_SUPPORTED_BY_DEFAULT = "bios_VfDirectCacheAccess_supportedByDefault"
    SORT_PROP_BIOS_VF_DIRECT_CACHE_ACCESS_VP_DIRECT_CACHE_ACCESS = "bios_VfDirectCacheAccess_vpDirectCacheAccess"
    SORT_PROP_BIOS_VF_DRAM_REFRESH_RATE_PROP_ACL = "bios_VfDramRefreshRate_propAcl"
    SORT_PROP_BIOS_VF_DRAM_REFRESH_RATE_SUPPORTED_BY_DEFAULT = "bios_VfDramRefreshRate_supportedByDefault"
    SORT_PROP_BIOS_VF_DRAM_REFRESH_RATE_VP_DRAM_REFRESH_RATE = "bios_VfDramRefreshRate_vpDramRefreshRate"
    SORT_PROP_BIOS_VF_ENERGY_PERFORMANCE_TUNING_PROP_ACL = "bios_VfEnergyPerformanceTuning_propAcl"
    SORT_PROP_BIOS_VF_ENERGY_PERFORMANCE_TUNING_SUPPORTED_BY_DEFAULT = "bios_VfEnergyPerformanceTuning_supportedByDefault"
    SORT_PROP_BIOS_VF_ENERGY_PERFORMANCE_TUNING_VP_PWR_PERF_TUNING = "bios_VfEnergyPerformanceTuning_vpPwrPerfTuning"
    SORT_PROP_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_PROP_ACL = "bios_VfEnhancedIntelSpeedStepTech_propAcl"
    SORT_PROP_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_SUPPORTED_BY_DEFAULT = "bios_VfEnhancedIntelSpeedStepTech_supportedByDefault"
    SORT_PROP_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_VP_ENHANCED_INTEL_SPEED_STEP_TECH = "bios_VfEnhancedIntelSpeedStepTech_vpEnhancedIntelSpeedStepTech"
    SORT_PROP_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT_PROP_ACL = "bios_VfEnhancedPowerCappingSupport_propAcl"
    SORT_PROP_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfEnhancedPowerCappingSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT_VP_ENHANCED_POWER_CAPPING = "bios_VfEnhancedPowerCappingSupport_vpEnhancedPowerCapping"
    SORT_PROP_BIOS_VF_EXECUTE_DISABLE_BIT_PROP_ACL = "bios_VfExecuteDisableBit_propAcl"
    SORT_PROP_BIOS_VF_EXECUTE_DISABLE_BIT_SUPPORTED_BY_DEFAULT = "bios_VfExecuteDisableBit_supportedByDefault"
    SORT_PROP_BIOS_VF_EXECUTE_DISABLE_BIT_VP_EXECUTE_DISABLE_BIT = "bios_VfExecuteDisableBit_vpExecuteDisableBit"
    SORT_PROP_BIOS_VF_FRB2_TIMER_PROP_ACL = "bios_VfFRB2Timer_propAcl"
    SORT_PROP_BIOS_VF_FRB2_TIMER_SUPPORTED_BY_DEFAULT = "bios_VfFRB2Timer_supportedByDefault"
    SORT_PROP_BIOS_VF_FRB2_TIMER_VP_FRB2_TIMER = "bios_VfFRB2Timer_vpFRB2Timer"
    SORT_PROP_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE_PROP_ACL = "bios_VfFrequencyFloorOverride_propAcl"
    SORT_PROP_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE_SUPPORTED_BY_DEFAULT = "bios_VfFrequencyFloorOverride_supportedByDefault"
    SORT_PROP_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE_VP_FREQUENCY_FLOOR_OVERRIDE = "bios_VfFrequencyFloorOverride_vpFrequencyFloorOverride"
    SORT_PROP_BIOS_VF_FRONT_PANEL_LOCKOUT_PROP_ACL = "bios_VfFrontPanelLockout_propAcl"
    SORT_PROP_BIOS_VF_FRONT_PANEL_LOCKOUT_SUPPORTED_BY_DEFAULT = "bios_VfFrontPanelLockout_supportedByDefault"
    SORT_PROP_BIOS_VF_FRONT_PANEL_LOCKOUT_VP_FRONT_PANEL_LOCKOUT = "bios_VfFrontPanelLockout_vpFrontPanelLockout"
    SORT_PROP_BIOS_VF_IOEMEZZ1_OPTION_ROM_PROP_ACL = "bios_VfIOEMezz1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_IOEMEZZ1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOEMezz1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOEMEZZ1_OPTION_ROM_VP_IOEMEZZ1_OPTION_ROM = "bios_VfIOEMezz1OptionROM_vpIOEMezz1OptionROM"
    SORT_PROP_BIOS_VF_IOENVME1_OPTION_ROM_PROP_ACL = "bios_VfIOENVMe1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_IOENVME1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOENVMe1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOENVME1_OPTION_ROM_VP_IOENVME1_OPTION_ROM = "bios_VfIOENVMe1OptionROM_vpIOENVMe1OptionROM"
    SORT_PROP_BIOS_VF_IOENVME2_OPTION_ROM_PROP_ACL = "bios_VfIOENVMe2OptionROM_propAcl"
    SORT_PROP_BIOS_VF_IOENVME2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOENVMe2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOENVME2_OPTION_ROM_VP_IOENVME2_OPTION_ROM = "bios_VfIOENVMe2OptionROM_vpIOENVMe2OptionROM"
    SORT_PROP_BIOS_VF_IOESLOT1_OPTION_ROM_PROP_ACL = "bios_VfIOESlot1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_IOESLOT1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOESlot1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOESLOT1_OPTION_ROM_VP_IOESLOT1_OPTION_ROM = "bios_VfIOESlot1OptionROM_vpIOESlot1OptionROM"
    SORT_PROP_BIOS_VF_IOESLOT2_OPTION_ROM_PROP_ACL = "bios_VfIOESlot2OptionROM_propAcl"
    SORT_PROP_BIOS_VF_IOESLOT2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOESlot2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOESLOT2_OPTION_ROM_VP_IOESLOT2_OPTION_ROM = "bios_VfIOESlot2OptionROM_vpIOESlot2OptionROM"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE_PROP_ACL = "bios_VfIntegratedGraphicsApertureSize_propAcl"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE_SUPPORTED_BY_DEFAULT = "bios_VfIntegratedGraphicsApertureSize_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE_VP_INTEGRATED_GRAPHICS_APERTURE_SIZE = "bios_VfIntegratedGraphicsApertureSize_vpIntegratedGraphicsApertureSize"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_PROP_ACL = "bios_VfIntegratedGraphics_propAcl"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_SUPPORTED_BY_DEFAULT = "bios_VfIntegratedGraphics_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_VP_INTEGRATED_GRAPHICS = "bios_VfIntegratedGraphics_vpIntegratedGraphics"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_PROP_ACL = "bios_VfIntelEntrySASRAIDModule_propAcl"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_SUPPORTED_BY_DEFAULT = "bios_VfIntelEntrySASRAIDModule_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAID = "bios_VfIntelEntrySASRAIDModule_vpSASRAID"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAIDMODULE = "bios_VfIntelEntrySASRAIDModule_vpSASRAIDModule"
    SORT_PROP_BIOS_VF_INTEL_HYPER_THREADING_TECH_PROP_ACL = "bios_VfIntelHyperThreadingTech_propAcl"
    SORT_PROP_BIOS_VF_INTEL_HYPER_THREADING_TECH_SUPPORTED_BY_DEFAULT = "bios_VfIntelHyperThreadingTech_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_HYPER_THREADING_TECH_VP_INTEL_HYPER_THREADING_TECH = "bios_VfIntelHyperThreadingTech_vpIntelHyperThreadingTech"
    SORT_PROP_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_PROP_ACL = "bios_VfIntelTrustedExecutionTechnology_propAcl"
    SORT_PROP_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_SUPPORTED_BY_DEFAULT = "bios_VfIntelTrustedExecutionTechnology_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_VP_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_SUPPORT = "bios_VfIntelTrustedExecutionTechnology_vpIntelTrustedExecutionTechnologySupport"
    SORT_PROP_BIOS_VF_INTEL_TURBO_BOOST_TECH_PROP_ACL = "bios_VfIntelTurboBoostTech_propAcl"
    SORT_PROP_BIOS_VF_INTEL_TURBO_BOOST_TECH_SUPPORTED_BY_DEFAULT = "bios_VfIntelTurboBoostTech_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_TURBO_BOOST_TECH_VP_INTEL_TURBO_BOOST_TECH = "bios_VfIntelTurboBoostTech_vpIntelTurboBoostTech"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_PROP_ACL = "bios_VfIntelVTForDirectedIO_propAcl"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_SUPPORTED_BY_DEFAULT = "bios_VfIntelVTForDirectedIO_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDATSSUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDATSSupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDCOHERENCY_SUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDCoherencySupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDINTERRUPT_REMAPPING = "bios_VfIntelVTForDirectedIO_vpIntelVTDInterruptRemapping"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDPASS_THROUGH_DMASUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDPassThroughDMASupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTFOR_DIRECTED_IO = "bios_VfIntelVTForDirectedIO_vpIntelVTForDirectedIO"
    SORT_PROP_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_PROP_ACL = "bios_VfIntelVirtualizationTechnology_propAcl"
    SORT_PROP_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_SUPPORTED_BY_DEFAULT = "bios_VfIntelVirtualizationTechnology_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_VP_INTEL_VIRTUALIZATION_TECHNOLOGY = "bios_VfIntelVirtualizationTechnology_vpIntelVirtualizationTechnology"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_PROP_ACL = "bios_VfInterleaveConfiguration_propAcl"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfInterleaveConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_CHANNEL_INTERLEAVING = "bios_VfInterleaveConfiguration_vpChannelInterleaving"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_MEMORY_INTERLEAVING = "bios_VfInterleaveConfiguration_vpMemoryInterleaving"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_RANK_INTERLEAVING = "bios_VfInterleaveConfiguration_vpRankInterleaving"
    SORT_PROP_BIOS_VF_LOCAL_X2_APIC_PROP_ACL = "bios_VfLocalX2Apic_propAcl"
    SORT_PROP_BIOS_VF_LOCAL_X2_APIC_SUPPORTED_BY_DEFAULT = "bios_VfLocalX2Apic_supportedByDefault"
    SORT_PROP_BIOS_VF_LOCAL_X2_APIC_VP_LOCAL_X2_APIC = "bios_VfLocalX2Apic_vpLocalX2Apic"
    SORT_PROP_BIOS_VF_LV_DIMMSUPPORT_PROP_ACL = "bios_VfLvDIMMSupport_propAcl"
    SORT_PROP_BIOS_VF_LV_DIMMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfLvDIMMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_LV_DIMMSUPPORT_VP_LV_DDRMODE = "bios_VfLvDIMMSupport_vpLvDDRMode"
    SORT_PROP_BIOS_VF_MAX_VARIABLE_MTRRSETTING_PROP_ACL = "bios_VfMaxVariableMTRRSetting_propAcl"
    SORT_PROP_BIOS_VF_MAX_VARIABLE_MTRRSETTING_SUPPORTED_BY_DEFAULT = "bios_VfMaxVariableMTRRSetting_supportedByDefault"
    SORT_PROP_BIOS_VF_MAX_VARIABLE_MTRRSETTING_VP_PROCESSOR_MTRR = "bios_VfMaxVariableMTRRSetting_vpProcessorMtrr"
    SORT_PROP_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_PROP_ACL = "bios_VfMaximumMemoryBelow4GB_propAcl"
    SORT_PROP_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_SUPPORTED_BY_DEFAULT = "bios_VfMaximumMemoryBelow4GB_supportedByDefault"
    SORT_PROP_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_VP_MAXIMUM_MEMORY_BELOW4_GB = "bios_VfMaximumMemoryBelow4GB_vpMaximumMemoryBelow4GB"
    SORT_PROP_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_PROP_ACL = "bios_VfMemoryMappedIOAbove4GB_propAcl"
    SORT_PROP_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_SUPPORTED_BY_DEFAULT = "bios_VfMemoryMappedIOAbove4GB_supportedByDefault"
    SORT_PROP_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_VP_MEMORY_MAPPED_IOABOVE4_GB = "bios_VfMemoryMappedIOAbove4GB_vpMemoryMappedIOAbove4GB"
    SORT_PROP_BIOS_VF_MIRRORING_MODE_PROP_ACL = "bios_VfMirroringMode_propAcl"
    SORT_PROP_BIOS_VF_MIRRORING_MODE_SUPPORTED_BY_DEFAULT = "bios_VfMirroringMode_supportedByDefault"
    SORT_PROP_BIOS_VF_MIRRORING_MODE_VP_MIRRORING_MODE = "bios_VfMirroringMode_vpMirroringMode"
    SORT_PROP_BIOS_VF_NUMAOPTIMIZED_PROP_ACL = "bios_VfNUMAOptimized_propAcl"
    SORT_PROP_BIOS_VF_NUMAOPTIMIZED_SUPPORTED_BY_DEFAULT = "bios_VfNUMAOptimized_supportedByDefault"
    SORT_PROP_BIOS_VF_NUMAOPTIMIZED_VP_NUMAOPTIMIZED = "bios_VfNUMAOptimized_vpNUMAOptimized"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_PROP_ACL = "bios_VfOSBootWatchdogTimerPolicy_propAcl"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimerPolicy_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_VP_OSBOOT_WATCHDOG_TIMER_POLICY = "bios_VfOSBootWatchdogTimerPolicy_vpOSBootWatchdogTimerPolicy"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_PROP_ACL = "bios_VfOSBootWatchdogTimerTimeout_propAcl"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimerTimeout_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_VP_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "bios_VfOSBootWatchdogTimerTimeout_vpOSBootWatchdogTimerTimeout"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_PROP_ACL = "bios_VfOSBootWatchdogTimer_propAcl"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimer_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_VP_OSBOOT_WATCHDOG_TIMER = "bios_VfOSBootWatchdogTimer_vpOSBootWatchdogTimer"
    SORT_PROP_BIOS_VF_ONBOARD_GRAPHICS_PROP_ACL = "bios_VfOnboardGraphics_propAcl"
    SORT_PROP_BIOS_VF_ONBOARD_GRAPHICS_SUPPORTED_BY_DEFAULT = "bios_VfOnboardGraphics_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_GRAPHICS_VP_ONBOARD_GRAPHICS = "bios_VfOnboardGraphics_vpOnboardGraphics"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_PROP_ACL = "bios_VfOnboardSATAController_propAcl"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_SUPPORTED_BY_DEFAULT = "bios_VfOnboardSATAController_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_VP_ONBOARD_SATACONTROLLER = "bios_VfOnboardSATAController_vpOnboardSATAController"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_VP_SATAMODE = "bios_VfOnboardSATAController_vpSATAMode"
    SORT_PROP_BIOS_VF_ONBOARD_STORAGE_PROP_ACL = "bios_VfOnboardStorage_propAcl"
    SORT_PROP_BIOS_VF_ONBOARD_STORAGE_SUPPORTED_BY_DEFAULT = "bios_VfOnboardStorage_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_STORAGE_VP_ONBOARD_SCUSTORAGE_SUPPORT = "bios_VfOnboardStorage_vpOnboardSCUStorageSupport"
    SORT_PROP_BIOS_VF_OPTION_ROMENABLE_PROP_ACL = "bios_VfOptionROMEnable_propAcl"
    SORT_PROP_BIOS_VF_OPTION_ROMENABLE_SUPPORTED_BY_DEFAULT = "bios_VfOptionROMEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_OPTION_ROMENABLE_VP_STATE = "bios_VfOptionROMEnable_vpState"
    SORT_PROP_BIOS_VF_OPTION_ROMLOAD_PROP_ACL = "bios_VfOptionROMLoad_propAcl"
    SORT_PROP_BIOS_VF_OPTION_ROMLOAD_SUPPORTED_BY_DEFAULT = "bios_VfOptionROMLoad_supportedByDefault"
    SORT_PROP_BIOS_VF_OPTION_ROMLOAD_VP_LOAD = "bios_VfOptionROMLoad_vpLoad"
    SORT_PROP_BIOS_VF_OUT_OF_BAND_MANAGEMENT_PROP_ACL = "bios_VfOutOfBandManagement_propAcl"
    SORT_PROP_BIOS_VF_OUT_OF_BAND_MANAGEMENT_SUPPORTED_BY_DEFAULT = "bios_VfOutOfBandManagement_supportedByDefault"
    SORT_PROP_BIOS_VF_OUT_OF_BAND_MANAGEMENT_VP_COM_SPCR_ENABLE = "bios_VfOutOfBandManagement_vpComSpcrEnable"
    SORT_PROP_BIOS_VF_PCHSATAMODE_PROP_ACL = "bios_VfPCHSATAMode_propAcl"
    SORT_PROP_BIOS_VF_PCHSATAMODE_SUPPORTED_BY_DEFAULT = "bios_VfPCHSATAMode_supportedByDefault"
    SORT_PROP_BIOS_VF_PCHSATAMODE_VP_SATAMODE = "bios_VfPCHSATAMode_vpSATAMode"
    SORT_PROP_BIOS_VF_PCILOMPORTS_CONFIGURATION_PROP_ACL = "bios_VfPCILOMPortsConfiguration_propAcl"
    SORT_PROP_BIOS_VF_PCILOMPORTS_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfPCILOMPortsConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_PCILOMPORTS_CONFIGURATION_VP_PCIE10_GLOM2_LINK = "bios_VfPCILOMPortsConfiguration_vpPCIe10GLOM2Link"
    SORT_PROP_BIOS_VF_PCIROMCLP_PROP_ACL = "bios_VfPCIROMCLP_propAcl"
    SORT_PROP_BIOS_VF_PCIROMCLP_SUPPORTED_BY_DEFAULT = "bios_VfPCIROMCLP_supportedByDefault"
    SORT_PROP_BIOS_VF_PCIROMCLP_VP_PCIROMCLP = "bios_VfPCIROMCLP_vpPCIROMCLP"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_PROP_ACL = "bios_VfPCISlotLinkSpeed_propAcl"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_SUPPORTED_BY_DEFAULT = "bios_VfPCISlotLinkSpeed_supportedByDefault"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT10_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot10LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT1_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot1LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT2_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot2LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT3_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot3LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT4_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot4LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT5_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot5LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT6_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot6LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT7_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot7LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT8_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot8LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT9_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot9LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_PROP_ACL = "bios_VfPCISlotOptionROMEnable_propAcl"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_SUPPORTED_BY_DEFAULT = "bios_VfPCISlotOptionROMEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_HBAOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotHBAOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_MLOMOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotMLOMOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_N1_OPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotN1OptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_N2_OPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotN2OptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_SASOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotSASOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT10_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot10State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT1_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot1State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT2_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot2State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT3_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot3State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT4_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot4State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT5_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot5State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT6_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot6State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT7_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot7State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT8_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot8State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT9_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot9State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT_MEZZ_STATE = "bios_VfPCISlotOptionROMEnable_vpSlotMezzState"
    SORT_PROP_BIOS_VF_POSTERROR_PAUSE_PROP_ACL = "bios_VfPOSTErrorPause_propAcl"
    SORT_PROP_BIOS_VF_POSTERROR_PAUSE_SUPPORTED_BY_DEFAULT = "bios_VfPOSTErrorPause_supportedByDefault"
    SORT_PROP_BIOS_VF_POSTERROR_PAUSE_VP_POSTERROR_PAUSE = "bios_VfPOSTErrorPause_vpPOSTErrorPause"
    SORT_PROP_BIOS_VF_PSTATECOORDINATION_PROP_ACL = "bios_VfPSTATECoordination_propAcl"
    SORT_PROP_BIOS_VF_PSTATECOORDINATION_SUPPORTED_BY_DEFAULT = "bios_VfPSTATECoordination_supportedByDefault"
    SORT_PROP_BIOS_VF_PSTATECOORDINATION_VP_PSTATECOORDINATION = "bios_VfPSTATECoordination_vpPSTATECoordination"
    SORT_PROP_BIOS_VF_PACKAGE_CSTATE_LIMIT_PROP_ACL = "bios_VfPackageCStateLimit_propAcl"
    SORT_PROP_BIOS_VF_PACKAGE_CSTATE_LIMIT_SUPPORTED_BY_DEFAULT = "bios_VfPackageCStateLimit_supportedByDefault"
    SORT_PROP_BIOS_VF_PACKAGE_CSTATE_LIMIT_VP_PACKAGE_CSTATE_LIMIT = "bios_VfPackageCStateLimit_vpPackageCStateLimit"
    SORT_PROP_BIOS_VF_PANIC_AND_HIGH_WATERMARK_PROP_ACL = "bios_VfPanicAndHighWatermark_propAcl"
    SORT_PROP_BIOS_VF_PANIC_AND_HIGH_WATERMARK_SUPPORTED_BY_DEFAULT = "bios_VfPanicAndHighWatermark_supportedByDefault"
    SORT_PROP_BIOS_VF_PANIC_AND_HIGH_WATERMARK_VP_PANIC_AND_HIGH_WATERMARK = "bios_VfPanicAndHighWatermark_vpPanicAndHighWatermark"
    SORT_PROP_BIOS_VF_PROCESSOR_C1_E_PROP_ACL = "bios_VfProcessorC1E_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_C1_E_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC1E_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C1_E_VP_PROCESSOR_C1_E = "bios_VfProcessorC1E_vpProcessorC1E"
    SORT_PROP_BIOS_VF_PROCESSOR_C3_REPORT_PROP_ACL = "bios_VfProcessorC3Report_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_C3_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC3Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C3_REPORT_VP_PROCESSOR_C3_REPORT = "bios_VfProcessorC3Report_vpProcessorC3Report"
    SORT_PROP_BIOS_VF_PROCESSOR_C6_REPORT_PROP_ACL = "bios_VfProcessorC6Report_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_C6_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC6Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C6_REPORT_VP_PROCESSOR_C6_REPORT = "bios_VfProcessorC6Report_vpProcessorC6Report"
    SORT_PROP_BIOS_VF_PROCESSOR_C7_REPORT_PROP_ACL = "bios_VfProcessorC7Report_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_C7_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC7Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C7_REPORT_VP_PROCESSOR_C7_REPORT = "bios_VfProcessorC7Report_vpProcessorC7Report"
    SORT_PROP_BIOS_VF_PROCESSOR_CMCI_PROP_ACL = "bios_VfProcessorCMCI_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_CMCI_SUPPORTED_BY_DEFAULT = "bios_VfProcessorCMCI_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_CMCI_VP_PROCESSOR_CMCI = "bios_VfProcessorCMCI_vpProcessorCMCI"
    SORT_PROP_BIOS_VF_PROCESSOR_CSTATE_PROP_ACL = "bios_VfProcessorCState_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_CSTATE_SUPPORTED_BY_DEFAULT = "bios_VfProcessorCState_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_CSTATE_VP_PROCESSOR_CSTATE = "bios_VfProcessorCState_vpProcessorCState"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_PROP_ACL = "bios_VfProcessorEnergyConfiguration_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfProcessorEnergyConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_VP_ENERGY_PERFORMANCE = "bios_VfProcessorEnergyConfiguration_vpEnergyPerformance"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_VP_POWER_TECHNOLOGY = "bios_VfProcessorEnergyConfiguration_vpPowerTechnology"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_PROP_ACL = "bios_VfProcessorPrefetchConfig_propAcl"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfProcessorPrefetchConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_ADJACENT_CACHE_LINE_PREFETCHER = "bios_VfProcessorPrefetchConfig_vpAdjacentCacheLinePrefetcher"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_DCUIPPREFETCHER = "bios_VfProcessorPrefetchConfig_vpDCUIPPrefetcher"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_DCUSTREAMER_PREFETCH = "bios_VfProcessorPrefetchConfig_vpDCUStreamerPrefetch"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_HARDWARE_PREFETCHER = "bios_VfProcessorPrefetchConfig_vpHardwarePrefetcher"
    SORT_PROP_BIOS_VF_QPILINK_FREQUENCY_SELECT_PROP_ACL = "bios_VfQPILinkFrequencySelect_propAcl"
    SORT_PROP_BIOS_VF_QPILINK_FREQUENCY_SELECT_SUPPORTED_BY_DEFAULT = "bios_VfQPILinkFrequencySelect_supportedByDefault"
    SORT_PROP_BIOS_VF_QPILINK_FREQUENCY_SELECT_VP_QPILINK_FREQUENCY_SELECT = "bios_VfQPILinkFrequencySelect_vpQPILinkFrequencySelect"
    SORT_PROP_BIOS_VF_QPISNOOP_MODE_PROP_ACL = "bios_VfQPISnoopMode_propAcl"
    SORT_PROP_BIOS_VF_QPISNOOP_MODE_SUPPORTED_BY_DEFAULT = "bios_VfQPISnoopMode_supportedByDefault"
    SORT_PROP_BIOS_VF_QPISNOOP_MODE_VP_QPISNOOP_MODE = "bios_VfQPISnoopMode_vpQPISnoopMode"
    SORT_PROP_BIOS_VF_QUIET_BOOT_PROP_ACL = "bios_VfQuietBoot_propAcl"
    SORT_PROP_BIOS_VF_QUIET_BOOT_SUPPORTED_BY_DEFAULT = "bios_VfQuietBoot_supportedByDefault"
    SORT_PROP_BIOS_VF_QUIET_BOOT_VP_QUIET_BOOT = "bios_VfQuietBoot_vpQuietBoot"
    SORT_PROP_BIOS_VF_REDIRECTION_AFTER_BIOSPOST_PROP_ACL = "bios_VfRedirectionAfterBIOSPOST_propAcl"
    SORT_PROP_BIOS_VF_REDIRECTION_AFTER_BIOSPOST_SUPPORTED_BY_DEFAULT = "bios_VfRedirectionAfterBIOSPOST_supportedByDefault"
    SORT_PROP_BIOS_VF_REDIRECTION_AFTER_BIOSPOST_VP_REDIRECTION_AFTER_POST = "bios_VfRedirectionAfterBIOSPOST_vpRedirectionAfterPOST"
    SORT_PROP_BIOS_VF_RESUME_ON_ACPOWER_LOSS_PROP_ACL = "bios_VfResumeOnACPowerLoss_propAcl"
    SORT_PROP_BIOS_VF_RESUME_ON_ACPOWER_LOSS_SUPPORTED_BY_DEFAULT = "bios_VfResumeOnACPowerLoss_supportedByDefault"
    SORT_PROP_BIOS_VF_RESUME_ON_ACPOWER_LOSS_VP_RESUME_ON_ACPOWER_LOSS = "bios_VfResumeOnACPowerLoss_vpResumeOnACPowerLoss"
    SORT_PROP_BIOS_VF_SBMEZZ1_OPTION_ROM_PROP_ACL = "bios_VfSBMezz1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_SBMEZZ1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSBMezz1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SBMEZZ1_OPTION_ROM_VP_SBMEZZ1_OPTION_ROM = "bios_VfSBMezz1OptionROM_vpSBMezz1OptionROM"
    SORT_PROP_BIOS_VF_SBNVME1_OPTION_ROM_PROP_ACL = "bios_VfSBNVMe1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_SBNVME1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSBNVMe1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SBNVME1_OPTION_ROM_VP_SBNVME1_OPTION_ROM = "bios_VfSBNVMe1OptionROM_vpSBNVMe1OptionROM"
    SORT_PROP_BIOS_VF_SIOC1_OPTION_ROM_PROP_ACL = "bios_VfSIOC1OptionROM_propAcl"
    SORT_PROP_BIOS_VF_SIOC1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSIOC1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SIOC1_OPTION_ROM_VP_SIOC1_OPTION_ROM = "bios_VfSIOC1OptionROM_vpSIOC1OptionROM"
    SORT_PROP_BIOS_VF_SIOC2_OPTION_ROM_PROP_ACL = "bios_VfSIOC2OptionROM_propAcl"
    SORT_PROP_BIOS_VF_SIOC2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSIOC2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SIOC2_OPTION_ROM_VP_SIOC2_OPTION_ROM = "bios_VfSIOC2OptionROM_vpSIOC2OptionROM"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_PROP_ACL = "bios_VfScrubPolicies_propAcl"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_SUPPORTED_BY_DEFAULT = "bios_VfScrubPolicies_supportedByDefault"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_VP_DEMAND_SCRUB = "bios_VfScrubPolicies_vpDemandScrub"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_VP_PATROL_SCRUB = "bios_VfScrubPolicies_vpPatrolScrub"
    SORT_PROP_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_PROP_ACL = "bios_VfSelectMemoryRASConfiguration_propAcl"
    SORT_PROP_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfSelectMemoryRASConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_VP_SELECT_MEMORY_RASCONFIGURATION = "bios_VfSelectMemoryRASConfiguration_vpSelectMemoryRASConfiguration"
    SORT_PROP_BIOS_VF_SERIAL_PORT_AENABLE_PROP_ACL = "bios_VfSerialPortAEnable_propAcl"
    SORT_PROP_BIOS_VF_SERIAL_PORT_AENABLE_SUPPORTED_BY_DEFAULT = "bios_VfSerialPortAEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_SERIAL_PORT_AENABLE_VP_SERIAL_PORT_AENABLE = "bios_VfSerialPortAEnable_vpSerialPortAEnable"
    SORT_PROP_BIOS_VF_SPARING_MODE_PROP_ACL = "bios_VfSparingMode_propAcl"
    SORT_PROP_BIOS_VF_SPARING_MODE_SUPPORTED_BY_DEFAULT = "bios_VfSparingMode_supportedByDefault"
    SORT_PROP_BIOS_VF_SPARING_MODE_VP_SPARING_MODE = "bios_VfSparingMode_vpSparingMode"
    SORT_PROP_BIOS_VF_SRIOV_CONFIG_PROP_ACL = "bios_VfSriovConfig_propAcl"
    SORT_PROP_BIOS_VF_SRIOV_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfSriovConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_SRIOV_CONFIG_VP_SRIOV = "bios_VfSriovConfig_vpSriov"
    SORT_PROP_BIOS_VF_TPMPENDING_OPERATION_PROP_ACL = "bios_VfTPMPendingOperation_propAcl"
    SORT_PROP_BIOS_VF_TPMPENDING_OPERATION_SUPPORTED_BY_DEFAULT = "bios_VfTPMPendingOperation_supportedByDefault"
    SORT_PROP_BIOS_VF_TPMPENDING_OPERATION_VP_TPMPENDING_OPERATION = "bios_VfTPMPendingOperation_vpTPMPendingOperation"
    SORT_PROP_BIOS_VF_TPMSUPPORT_PROP_ACL = "bios_VfTPMSupport_propAcl"
    SORT_PROP_BIOS_VF_TPMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfTPMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_TPMSUPPORT_VP_TPMSUPPORT = "bios_VfTPMSupport_vpTPMSupport"
    SORT_PROP_BIOS_VF_TRUSTED_PLATFORM_MODULE_PROP_ACL = "bios_VfTrustedPlatformModule_propAcl"
    SORT_PROP_BIOS_VF_TRUSTED_PLATFORM_MODULE_SUPPORTED_BY_DEFAULT = "bios_VfTrustedPlatformModule_supportedByDefault"
    SORT_PROP_BIOS_VF_TRUSTED_PLATFORM_MODULE_VP_TRUSTED_PLATFORM_MODULE_SUPPORT = "bios_VfTrustedPlatformModule_vpTrustedPlatformModuleSupport"
    SORT_PROP_BIOS_VF_UCSMBOOT_MODE_CONTROL_PROP_ACL = "bios_VfUCSMBootModeControl_propAcl"
    SORT_PROP_BIOS_VF_UCSMBOOT_MODE_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfUCSMBootModeControl_supportedByDefault"
    SORT_PROP_BIOS_VF_UCSMBOOT_MODE_CONTROL_VP_UEFIBOOT_MODE = "bios_VfUCSMBootModeControl_vpUEFIBootMode"
    SORT_PROP_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_PROP_ACL = "bios_VfUCSMBootOrderRuleControl_propAcl"
    SORT_PROP_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfUCSMBootOrderRuleControl_supportedByDefault"
    SORT_PROP_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_VP_UCSMBOOT_ORDER_RULE = "bios_VfUCSMBootOrderRuleControl_vpUCSMBootOrderRule"
    SORT_PROP_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_PROP_ACL = "bios_VfUEFIOSUseLegacyVideo_propAcl"
    SORT_PROP_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_SUPPORTED_BY_DEFAULT = "bios_VfUEFIOSUseLegacyVideo_supportedByDefault"
    SORT_PROP_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_VP_UEFIOSUSE_LEGACY_VIDEO = "bios_VfUEFIOSUseLegacyVideo_vpUEFIOSUseLegacyVideo"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_PROP_ACL = "bios_VfUSBBootConfig_propAcl"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfUSBBootConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_VP_LEGACY_USBSUPPORT = "bios_VfUSBBootConfig_vpLegacyUSBSupport"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_VP_MAKE_DEVICE_NON_BOOTABLE = "bios_VfUSBBootConfig_vpMakeDeviceNonBootable"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_PROP_ACL = "bios_VfUSBConfiguration_propAcl"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfUSBConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_VP_LEGACY_USBSUPPORT = "bios_VfUSBConfiguration_vpLegacyUSBSupport"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_VP_XHCIMODE = "bios_VfUSBConfiguration_vpXHCIMode"
    SORT_PROP_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_PROP_ACL = "bios_VfUSBFrontPanelAccessLock_propAcl"
    SORT_PROP_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_SUPPORTED_BY_DEFAULT = "bios_VfUSBFrontPanelAccessLock_supportedByDefault"
    SORT_PROP_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_VP_USBFRONT_PANEL_LOCK = "bios_VfUSBFrontPanelAccessLock_vpUSBFrontPanelLock"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_PROP_ACL = "bios_VfUSBPortConfiguration_propAcl"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfUSBPortConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_PORT6064_EMULATION = "bios_VfUSBPortConfiguration_vpPort6064Emulation"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_FRONT = "bios_VfUSBPortConfiguration_vpUSBPortFront"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_INTERNAL = "bios_VfUSBPortConfiguration_vpUSBPortInternal"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_KVM = "bios_VfUSBPortConfiguration_vpUSBPortKVM"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_REAR = "bios_VfUSBPortConfiguration_vpUSBPortRear"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_SDCARD = "bios_VfUSBPortConfiguration_vpUSBPortSDCard"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_VMEDIA = "bios_VfUSBPortConfiguration_vpUSBPortVMedia"
    SORT_PROP_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_PROP_ACL = "bios_VfUSBSystemIdlePowerOptimizingSetting_propAcl"
    SORT_PROP_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_SUPPORTED_BY_DEFAULT = "bios_VfUSBSystemIdlePowerOptimizingSetting_supportedByDefault"
    SORT_PROP_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_VP_USBIDLE_POWER_OPTIMIZING = "bios_VfUSBSystemIdlePowerOptimizingSetting_vpUSBIdlePowerOptimizing"
    SORT_PROP_BIOS_VF_VGAPRIORITY_PROP_ACL = "bios_VfVGAPriority_propAcl"
    SORT_PROP_BIOS_VF_VGAPRIORITY_SUPPORTED_BY_DEFAULT = "bios_VfVGAPriority_supportedByDefault"
    SORT_PROP_BIOS_VF_VGAPRIORITY_VP_VGAPRIORITY = "bios_VfVGAPriority_vpVGAPriority"
    SORT_PROP_BIOS_VF_WORKLOAD_CONFIGURATION_PROP_ACL = "bios_VfWorkloadConfiguration_propAcl"
    SORT_PROP_BIOS_VF_WORKLOAD_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfWorkloadConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_WORKLOAD_CONFIGURATION_VP_WORKLOAD_CONFIGURATION = "bios_VfWorkloadConfiguration_vpWorkloadConfiguration"
    SORT_PROP_BMC_SELCOUNTER_BITMASK = "bmc_SELCounter_bitmask"
    SORT_PROP_BMC_SELCOUNTER_COLL_INTERVAL = "bmc_SELCounter_collInterval"
    SORT_PROP_BMC_SELCOUNTER_CONT_CLASS_ID = "bmc_SELCounter_contClassId"
    SORT_PROP_BMC_SELCOUNTER_CONT_INST_ID = "bmc_SELCounter_contInstId"
    SORT_PROP_BMC_SELCOUNTER_CONT_INST_ID_PROP_ID = "bmc_SELCounter_contInstIdPropId"
    SORT_PROP_BMC_SELCOUNTER_EQPT_CLASS_ID = "bmc_SELCounter_eqptClassId"
    SORT_PROP_BMC_SELCOUNTER_EQPT_INST_ID = "bmc_SELCounter_eqptInstId"
    SORT_PROP_BMC_SELCOUNTER_EQPT_INST_ID_PROP_ID = "bmc_SELCounter_eqptInstIdPropId"
    SORT_PROP_BMC_SELCOUNTER_GLOBAL_ID = "bmc_SELCounter_globalId"
    SORT_PROP_BMC_SELCOUNTER_LOCAL_ID = "bmc_SELCounter_localId"
    SORT_PROP_BMC_SELCOUNTER_PC_GLOBAL_ID = "bmc_SELCounter_pcGlobalId"
    SORT_PROP_BMC_SELCOUNTER_PC_LOCAL_ID = "bmc_SELCounter_pcLocalId"
    SORT_PROP_BMC_SELCOUNTER_STATS_CLASS_ID = "bmc_SELCounter_statsClassId"
    SORT_PROP_BMC_SELCOUNTER_STATS_PROP_ID = "bmc_SELCounter_statsPropId"
    SORT_PROP_BMC_SELCOUNTER_THRESHOLD = "bmc_SELCounter_threshold"
    SORT_PROP_BMC_SELCOUNTER_VALUE = "bmc_SELCounter_value"
    SORT_PROP_CALLHOME_ANONYMOUS_REPORTING_ADMIN_STATE = "callhome_AnonymousReporting_adminState"
    SORT_PROP_CALLHOME_ANONYMOUS_REPORTING_COUNT = "callhome_AnonymousReporting_count"
    SORT_PROP_CALLHOME_ANONYMOUS_REPORTING_SLEEP_INTERVAL = "callhome_AnonymousReporting_sleepInterval"
    SORT_PROP_CALLHOME_ANONYMOUS_REPORTING_USER_ACKNOWLEDGED = "callhome_AnonymousReporting_userAcknowledged"
    SORT_PROP_CALLHOME_DEST_EMAIL = "callhome_Dest_email"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_DESCR = "callhome_EpFsmStage_descr"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_LAST_UPDATE_TIME = "callhome_EpFsmStage_lastUpdateTime"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_NAME = "callhome_EpFsmStage_name"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_ORDER = "callhome_EpFsmStage_order"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_RETRY = "callhome_EpFsmStage_retry"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_STAGE_STATUS = "callhome_EpFsmStage_stageStatus"
    SORT_PROP_CALLHOME_EP_FSM_TASK_COMPLETION = "callhome_EpFsmTask_completion"
    SORT_PROP_CALLHOME_EP_FSM_TASK_FLAGS = "callhome_EpFsmTask_flags"
    SORT_PROP_CALLHOME_EP_FSM_TASK_ITEM = "callhome_EpFsmTask_item"
    SORT_PROP_CALLHOME_EP_FSM_TASK_SEQ_ID = "callhome_EpFsmTask_seqId"
    SORT_PROP_CALLHOME_EP_FSM_COMPLETION_TIME = "callhome_EpFsm_completionTime"
    SORT_PROP_CALLHOME_EP_FSM_CURRENT_FSM = "callhome_EpFsm_currentFsm"
    SORT_PROP_CALLHOME_EP_FSM_DESCR = "callhome_EpFsm_descr"
    SORT_PROP_CALLHOME_EP_FSM_FSM_STATUS = "callhome_EpFsm_fsmStatus"
    SORT_PROP_CALLHOME_EP_FSM_INSTANCE_ID = "callhome_EpFsm_instanceId"
    SORT_PROP_CALLHOME_EP_FSM_PROGRESS = "callhome_EpFsm_progress"
    SORT_PROP_CALLHOME_EP_FSM_RMT_ERR_CODE = "callhome_EpFsm_rmtErrCode"
    SORT_PROP_CALLHOME_EP_FSM_RMT_ERR_DESCR = "callhome_EpFsm_rmtErrDescr"
    SORT_PROP_CALLHOME_EP_FSM_RMT_RSLT = "callhome_EpFsm_rmtRslt"
    SORT_PROP_CALLHOME_EP_ADMIN_STATE = "callhome_Ep_adminState"
    SORT_PROP_CALLHOME_EP_ALERT_THROTTLING_ADMIN_STATE = "callhome_Ep_alertThrottlingAdminState"
    SORT_PROP_CALLHOME_EP_CONFIG_STATE = "callhome_Ep_configState"
    SORT_PROP_CALLHOME_EP_DESCR = "callhome_Ep_descr"
    SORT_PROP_CALLHOME_EP_FSM_DESCR = "callhome_Ep_fsmDescr"
    SORT_PROP_CALLHOME_EP_FSM_PREV = "callhome_Ep_fsmPrev"
    SORT_PROP_CALLHOME_EP_FSM_PROGR = "callhome_Ep_fsmProgr"
    SORT_PROP_CALLHOME_EP_FSM_RMT_INV_ERR_CODE = "callhome_Ep_fsmRmtInvErrCode"
    SORT_PROP_CALLHOME_EP_FSM_RMT_INV_ERR_DESCR = "callhome_Ep_fsmRmtInvErrDescr"
    SORT_PROP_CALLHOME_EP_FSM_RMT_INV_RSLT = "callhome_Ep_fsmRmtInvRslt"
    SORT_PROP_CALLHOME_EP_FSM_STAGE_DESCR = "callhome_Ep_fsmStageDescr"
    SORT_PROP_CALLHOME_EP_FSM_STAMP = "callhome_Ep_fsmStamp"
    SORT_PROP_CALLHOME_EP_FSM_STATUS = "callhome_Ep_fsmStatus"
    SORT_PROP_CALLHOME_EP_FSM_TRY = "callhome_Ep_fsmTry"
    SORT_PROP_CALLHOME_EP_INT_ID = "callhome_Ep_intId"
    SORT_PROP_CALLHOME_EP_NAME = "callhome_Ep_name"
    SORT_PROP_CALLHOME_EP_POLICY_LEVEL = "callhome_Ep_policyLevel"
    SORT_PROP_CALLHOME_EP_POLICY_OWNER = "callhome_Ep_policyOwner"
    SORT_PROP_CALLHOME_ITEM_DESCR = "callhome_Item_descr"
    SORT_PROP_CALLHOME_ITEM_NAME = "callhome_Item_name"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_ADMIN_STATE = "callhome_PeriodicSystemInventory_adminState"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_INTERVAL_DAYS = "callhome_PeriodicSystemInventory_intervalDays"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_LAST_DEADLINE = "callhome_PeriodicSystemInventory_lastDeadline"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MAXIMUM_RETRY_COUNT = "callhome_PeriodicSystemInventory_maximumRetryCount"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MINIMUM_SEND_NOW_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_minimumSendNowIntervalSeconds"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_NEXT_DEADLINE = "callhome_PeriodicSystemInventory_nextDeadline"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_POLL_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_pollIntervalSeconds"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_COUNT = "callhome_PeriodicSystemInventory_retryCount"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_DELAY_MINUTES = "callhome_PeriodicSystemInventory_retryDelayMinutes"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_SEND_NOW = "callhome_PeriodicSystemInventory_sendNow"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_HOUR = "callhome_PeriodicSystemInventory_timeOfDayHour"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_MINUTE = "callhome_PeriodicSystemInventory_timeOfDayMinute"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_ATTEMPT = "callhome_PeriodicSystemInventory_timeOfLastAttempt"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_SUCCESS = "callhome_PeriodicSystemInventory_timeOfLastSuccess"
    SORT_PROP_CALLHOME_POLICY_ADMIN_STATE = "callhome_Policy_adminState"
    SORT_PROP_CALLHOME_POLICY_CAUSE = "callhome_Policy_cause"
    SORT_PROP_CALLHOME_POLICY_DESCR = "callhome_Policy_descr"
    SORT_PROP_CALLHOME_POLICY_NAME = "callhome_Policy_name"
    SORT_PROP_CALLHOME_PROFILE_ALERT_GROUPS = "callhome_Profile_alertGroups"
    SORT_PROP_CALLHOME_PROFILE_DESCR = "callhome_Profile_descr"
    SORT_PROP_CALLHOME_PROFILE_FORMAT = "callhome_Profile_format"
    SORT_PROP_CALLHOME_PROFILE_LEVEL = "callhome_Profile_level"
    SORT_PROP_CALLHOME_PROFILE_MAX_SIZE = "callhome_Profile_maxSize"
    SORT_PROP_CALLHOME_PROFILE_NAME = "callhome_Profile_name"
    SORT_PROP_CALLHOME_SMTP_HOST = "callhome_Smtp_host"
    SORT_PROP_CALLHOME_SMTP_PORT = "callhome_Smtp_port"
    SORT_PROP_CALLHOME_SOURCE_ADDR = "callhome_Source_addr"
    SORT_PROP_CALLHOME_SOURCE_CONTACT = "callhome_Source_contact"
    SORT_PROP_CALLHOME_SOURCE_CONTRACT = "callhome_Source_contract"
    SORT_PROP_CALLHOME_SOURCE_CUSTOMER = "callhome_Source_customer"
    SORT_PROP_CALLHOME_SOURCE_EMAIL = "callhome_Source_email"
    SORT_PROP_CALLHOME_SOURCE_FROM = "callhome_Source_from"
    SORT_PROP_CALLHOME_SOURCE_PHONE = "callhome_Source_phone"
    SORT_PROP_CALLHOME_SOURCE_REPLY_TO = "callhome_Source_replyTo"
    SORT_PROP_CALLHOME_SOURCE_SITE = "callhome_Source_site"
    SORT_PROP_CALLHOME_SOURCE_URGENCY = "callhome_Source_urgency"
    SORT_PROP_CALLHOME_TEST_ALERT_DESCRIPTION = "callhome_TestAlert_description"
    SORT_PROP_CALLHOME_TEST_ALERT_GROUP = "callhome_TestAlert_group"
    SORT_PROP_CALLHOME_TEST_ALERT_LEVEL = "callhome_TestAlert_level"
    SORT_PROP_CALLHOME_TEST_ALERT_MESSAGE_SUBTYPE = "callhome_TestAlert_messageSubtype"
    SORT_PROP_CALLHOME_TEST_ALERT_MESSAGE_TYPE = "callhome_TestAlert_messageType"
    SORT_PROP_CALLHOME_TEST_ALERT_SEND_NOW = "callhome_TestAlert_sendNow"
    SORT_PROP_CAPABILITY_AEND_POINT_CONFIG_TYPE = "capability_AEndPointConfig_type"
    SORT_PROP_CAPABILITY_ASOLUTION_STACK_MGMT_PLANE_VER = "capability_ASolutionStack_mgmtPlaneVer"
    SORT_PROP_CAPABILITY_ASOLUTION_STACK_TYPE = "capability_ASolutionStack_type"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_DESCR = "capability_CatalogueFsmStage_descr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_LAST_UPDATE_TIME = "capability_CatalogueFsmStage_lastUpdateTime"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_NAME = "capability_CatalogueFsmStage_name"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_ORDER = "capability_CatalogueFsmStage_order"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_RETRY = "capability_CatalogueFsmStage_retry"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_STAGE_STATUS = "capability_CatalogueFsmStage_stageStatus"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_TASK_COMPLETION = "capability_CatalogueFsmTask_completion"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_TASK_FLAGS = "capability_CatalogueFsmTask_flags"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_TASK_ITEM = "capability_CatalogueFsmTask_item"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_TASK_SEQ_ID = "capability_CatalogueFsmTask_seqId"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_COMPLETION_TIME = "capability_CatalogueFsm_completionTime"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_CURRENT_FSM = "capability_CatalogueFsm_currentFsm"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_DESCR = "capability_CatalogueFsm_descr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_FSM_STATUS = "capability_CatalogueFsm_fsmStatus"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_INSTANCE_ID = "capability_CatalogueFsm_instanceId"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_PROGRESS = "capability_CatalogueFsm_progress"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_ERR_CODE = "capability_CatalogueFsm_rmtErrCode"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_ERR_DESCR = "capability_CatalogueFsm_rmtErrDescr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_RSLT = "capability_CatalogueFsm_rmtRslt"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_STATS_FILE_PARSE_FAILURES = "capability_CatalogueLoadStats_fileParseFailures"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_STATS_FILES_PARSED = "capability_CatalogueLoadStats_filesParsed"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_STATS_PROVIDER_LOAD_FAILURES = "capability_CatalogueLoadStats_providerLoadFailures"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_STATS_PROVIDERS_LOADED = "capability_CatalogueLoadStats_providersLoaded"
    SORT_PROP_CAPABILITY_CATALOGUE_FILE_PARSE_FAILURES = "capability_Catalogue_fileParseFailures"
    SORT_PROP_CAPABILITY_CATALOGUE_FILES_PARSED = "capability_Catalogue_filesParsed"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_DESCR = "capability_Catalogue_fsmDescr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_PREV = "capability_Catalogue_fsmPrev"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_PROGR = "capability_Catalogue_fsmProgr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_INV_ERR_CODE = "capability_Catalogue_fsmRmtInvErrCode"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_INV_ERR_DESCR = "capability_Catalogue_fsmRmtInvErrDescr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_RMT_INV_RSLT = "capability_Catalogue_fsmRmtInvRslt"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAGE_DESCR = "capability_Catalogue_fsmStageDescr"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STAMP = "capability_Catalogue_fsmStamp"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_STATUS = "capability_Catalogue_fsmStatus"
    SORT_PROP_CAPABILITY_CATALOGUE_FSM_TRY = "capability_Catalogue_fsmTry"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_ERRORS = "capability_Catalogue_loadErrors"
    SORT_PROP_CAPABILITY_CATALOGUE_LOAD_WARNINGS = "capability_Catalogue_loadWarnings"
    SORT_PROP_CAPABILITY_CATALOGUE_PROVIDER_LOAD_FAILURES = "capability_Catalogue_providerLoadFailures"
    SORT_PROP_CAPABILITY_CATALOGUE_PROVIDERS_LOADED = "capability_Catalogue_providersLoaded"
    SORT_PROP_CAPABILITY_CATALOGUE_VERSION = "capability_Catalogue_version"
    SORT_PROP_CAPABILITY_DEF_DESCR = "capability_Def_descr"
    SORT_PROP_CAPABILITY_DEF_INT_ID = "capability_Def_intId"
    SORT_PROP_CAPABILITY_DEF_NAME = "capability_Def_name"
    SORT_PROP_CAPABILITY_DEF_POLICY_LEVEL = "capability_Def_policyLevel"
    SORT_PROP_CAPABILITY_DEF_POLICY_OWNER = "capability_Def_policyOwner"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_DESCR = "capability_FeatureLimits_descr"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_FEATURE_STATUS = "capability_FeatureLimits_featureStatus"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_LIMIT = "capability_FeatureLimits_limit"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_MIN_UCSMVERSION = "capability_FeatureLimits_minUCSMVersion"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_NAME = "capability_FeatureLimits_name"
    SORT_PROP_CAPABILITY_FEATURE_LIMITS_PLATFORM = "capability_FeatureLimits_platform"
    SORT_PROP_CAPABILITY_LOAD_STATS_LOAD_ERRORS = "capability_LoadStats_loadErrors"
    SORT_PROP_CAPABILITY_LOAD_STATS_LOAD_WARNINGS = "capability_LoadStats_loadWarnings"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_DESCR = "capability_MgmtExtensionFsmStage_descr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_LAST_UPDATE_TIME = "capability_MgmtExtensionFsmStage_lastUpdateTime"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_NAME = "capability_MgmtExtensionFsmStage_name"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_ORDER = "capability_MgmtExtensionFsmStage_order"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_RETRY = "capability_MgmtExtensionFsmStage_retry"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_STAGE_STATUS = "capability_MgmtExtensionFsmStage_stageStatus"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_TASK_COMPLETION = "capability_MgmtExtensionFsmTask_completion"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_TASK_FLAGS = "capability_MgmtExtensionFsmTask_flags"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_TASK_ITEM = "capability_MgmtExtensionFsmTask_item"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_TASK_SEQ_ID = "capability_MgmtExtensionFsmTask_seqId"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_COMPLETION_TIME = "capability_MgmtExtensionFsm_completionTime"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_CURRENT_FSM = "capability_MgmtExtensionFsm_currentFsm"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_DESCR = "capability_MgmtExtensionFsm_descr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_FSM_STATUS = "capability_MgmtExtensionFsm_fsmStatus"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_INSTANCE_ID = "capability_MgmtExtensionFsm_instanceId"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_PROGRESS = "capability_MgmtExtensionFsm_progress"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_ERR_CODE = "capability_MgmtExtensionFsm_rmtErrCode"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_ERR_DESCR = "capability_MgmtExtensionFsm_rmtErrDescr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_RSLT = "capability_MgmtExtensionFsm_rmtRslt"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_DESCR = "capability_MgmtExtension_fsmDescr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_PREV = "capability_MgmtExtension_fsmPrev"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_PROGR = "capability_MgmtExtension_fsmProgr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_ERR_CODE = "capability_MgmtExtension_fsmRmtInvErrCode"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_ERR_DESCR = "capability_MgmtExtension_fsmRmtInvErrDescr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_RSLT = "capability_MgmtExtension_fsmRmtInvRslt"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_DESCR = "capability_MgmtExtension_fsmStageDescr"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STAMP = "capability_MgmtExtension_fsmStamp"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_STATUS = "capability_MgmtExtension_fsmStatus"
    SORT_PROP_CAPABILITY_MGMT_EXTENSION_FSM_TRY = "capability_MgmtExtension_fsmTry"
    SORT_PROP_CAPABILITY_PROVIDER_LOAD_STATS_ELEMENT_LOAD_FAILURES = "capability_ProviderLoadStats_elementLoadFailures"
    SORT_PROP_CAPABILITY_PROVIDER_LOAD_STATS_ELEMENTS_LOADED = "capability_ProviderLoadStats_elementsLoaded"
    SORT_PROP_CAPABILITY_PROVIDER_DELETED = "capability_Provider_deleted"
    SORT_PROP_CAPABILITY_PROVIDER_DEPRECATED = "capability_Provider_deprecated"
    SORT_PROP_CAPABILITY_PROVIDER_ELEMENT_LOAD_FAILURES = "capability_Provider_elementLoadFailures"
    SORT_PROP_CAPABILITY_PROVIDER_ELEMENTS_LOADED = "capability_Provider_elementsLoaded"
    SORT_PROP_CAPABILITY_PROVIDER_GENCOUNT = "capability_Provider_gencount"
    SORT_PROP_CAPABILITY_PROVIDER_LOAD_ERRORS = "capability_Provider_loadErrors"
    SORT_PROP_CAPABILITY_PROVIDER_LOAD_WARNINGS = "capability_Provider_loadWarnings"
    SORT_PROP_CAPABILITY_PROVIDER_MGMT_PLANE_VER = "capability_Provider_mgmtPlaneVer"
    SORT_PROP_CAPABILITY_PROVIDER_MODEL = "capability_Provider_model"
    SORT_PROP_CAPABILITY_PROVIDER_VENDOR = "capability_Provider_vendor"
    SORT_PROP_CAPABILITY_UPDATE_IMAGE_NAME = "capability_Update_imageName"
    SORT_PROP_CAPABILITY_UPDATE_UPDATE_TS = "capability_Update_updateTs"
    SORT_PROP_CAPABILITY_UPDATE_VERSION = "capability_Update_version"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_DESCR = "capability_UpdaterFsmStage_descr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_LAST_UPDATE_TIME = "capability_UpdaterFsmStage_lastUpdateTime"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_NAME = "capability_UpdaterFsmStage_name"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_ORDER = "capability_UpdaterFsmStage_order"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_RETRY = "capability_UpdaterFsmStage_retry"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_STAGE_STATUS = "capability_UpdaterFsmStage_stageStatus"
    SORT_PROP_CAPABILITY_UPDATER_FSM_TASK_COMPLETION = "capability_UpdaterFsmTask_completion"
    SORT_PROP_CAPABILITY_UPDATER_FSM_TASK_FLAGS = "capability_UpdaterFsmTask_flags"
    SORT_PROP_CAPABILITY_UPDATER_FSM_TASK_ITEM = "capability_UpdaterFsmTask_item"
    SORT_PROP_CAPABILITY_UPDATER_FSM_TASK_SEQ_ID = "capability_UpdaterFsmTask_seqId"
    SORT_PROP_CAPABILITY_UPDATER_FSM_COMPLETION_TIME = "capability_UpdaterFsm_completionTime"
    SORT_PROP_CAPABILITY_UPDATER_FSM_CURRENT_FSM = "capability_UpdaterFsm_currentFsm"
    SORT_PROP_CAPABILITY_UPDATER_FSM_DESCR = "capability_UpdaterFsm_descr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_FSM_STATUS = "capability_UpdaterFsm_fsmStatus"
    SORT_PROP_CAPABILITY_UPDATER_FSM_INSTANCE_ID = "capability_UpdaterFsm_instanceId"
    SORT_PROP_CAPABILITY_UPDATER_FSM_PROGRESS = "capability_UpdaterFsm_progress"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_ERR_CODE = "capability_UpdaterFsm_rmtErrCode"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_ERR_DESCR = "capability_UpdaterFsm_rmtErrDescr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_RSLT = "capability_UpdaterFsm_rmtRslt"
    SORT_PROP_CAPABILITY_UPDATER_ADMIN_STATE = "capability_Updater_adminState"
    SORT_PROP_CAPABILITY_UPDATER_FILE_NAME = "capability_Updater_fileName"
    SORT_PROP_CAPABILITY_UPDATER_FSM_DESCR = "capability_Updater_fsmDescr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_PREV = "capability_Updater_fsmPrev"
    SORT_PROP_CAPABILITY_UPDATER_FSM_PROGR = "capability_Updater_fsmProgr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_INV_ERR_CODE = "capability_Updater_fsmRmtInvErrCode"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_INV_ERR_DESCR = "capability_Updater_fsmRmtInvErrDescr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_RMT_INV_RSLT = "capability_Updater_fsmRmtInvRslt"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAGE_DESCR = "capability_Updater_fsmStageDescr"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STAMP = "capability_Updater_fsmStamp"
    SORT_PROP_CAPABILITY_UPDATER_FSM_STATUS = "capability_Updater_fsmStatus"
    SORT_PROP_CAPABILITY_UPDATER_FSM_TRY = "capability_Updater_fsmTry"
    SORT_PROP_CAPABILITY_UPDATER_IMAGE_NAME = "capability_Updater_imageName"
    SORT_PROP_CAPABILITY_UPDATER_OPER_STATE = "capability_Updater_operState"
    SORT_PROP_CAPABILITY_UPDATER_PROTOCOL = "capability_Updater_protocol"
    SORT_PROP_CAPABILITY_UPDATER_PWD = "capability_Updater_pwd"
    SORT_PROP_CAPABILITY_UPDATER_REMOTE_PATH = "capability_Updater_remotePath"
    SORT_PROP_CAPABILITY_UPDATER_SERVER = "capability_Updater_server"
    SORT_PROP_CAPABILITY_UPDATER_USER = "capability_Updater_user"
    SORT_PROP_CAPABILITY_UPDATER_VERSION = "capability_Updater_version"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_CENTRALE_MO_DN = "change_ChangedObjectRef_centraleMoDn"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_CHANGED_MO_CLASS_ID = "change_ChangedObjectRef_changedMoClassId"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_GUID = "change_ChangedObjectRef_guid"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_ID = "change_ChangedObjectRef_id"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_OLD_CENTRALE_MO_DN = "change_ChangedObjectRef_oldCentraleMoDn"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_REF_OBJ_STATUS = "change_ChangedObjectRef_refObjStatus"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_UCSM_MO_DN = "change_ChangedObjectRef_ucsmMoDn"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_AUTH_OPTION = "cimcvmedia_ActualMountEntry_authOption"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_DEVICE_TYPE = "cimcvmedia_ActualMountEntry_deviceType"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_ENC_PWD = "cimcvmedia_ActualMountEntry_encPwd"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_ERROR_TYPE = "cimcvmedia_ActualMountEntry_errorType"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_FILE_NAME = "cimcvmedia_ActualMountEntry_imageFileName"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_NAME_VARIABLE = "cimcvmedia_ActualMountEntry_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_PATH = "cimcvmedia_ActualMountEntry_imagePath"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_MAPPING_NAME = "cimcvmedia_ActualMountEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ActualMountEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_OPER_MOUNT_STATUS = "cimcvmedia_ActualMountEntry_operMountStatus"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_PASSWORD = "cimcvmedia_ActualMountEntry_password"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_PWD_SET = "cimcvmedia_ActualMountEntry_pwdSet"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMAP_ON_EJECT = "cimcvmedia_ActualMountEntry_remapOnEject"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_HOST = "cimcvmedia_ActualMountEntry_remoteHost"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_IP_ADDRESS = "cimcvmedia_ActualMountEntry_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_PORT = "cimcvmedia_ActualMountEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_USER_ID = "cimcvmedia_ActualMountEntry_userId"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_VIRTUAL_DISK_ID = "cimcvmedia_ActualMountEntry_virtualDiskId"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_WRITABLE = "cimcvmedia_ActualMountEntry_writable"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_AUTH_OPTION = "cimcvmedia_ConfigMountEntry_authOption"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_DESCRIPTION = "cimcvmedia_ConfigMountEntry_description"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_DEVICE_TYPE = "cimcvmedia_ConfigMountEntry_deviceType"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_ENC_PWD = "cimcvmedia_ConfigMountEntry_encPwd"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_FILE_NAME = "cimcvmedia_ConfigMountEntry_imageFileName"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_NAME_VARIABLE = "cimcvmedia_ConfigMountEntry_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_PATH = "cimcvmedia_ConfigMountEntry_imagePath"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_MAPPING_NAME = "cimcvmedia_ConfigMountEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ConfigMountEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_PASSWORD = "cimcvmedia_ConfigMountEntry_password"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_PWD_SET = "cimcvmedia_ConfigMountEntry_pwdSet"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMAP_ON_EJECT = "cimcvmedia_ConfigMountEntry_remapOnEject"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_HOST = "cimcvmedia_ConfigMountEntry_remoteHost"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_IP_ADDRESS = "cimcvmedia_ConfigMountEntry_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_PORT = "cimcvmedia_ConfigMountEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_USER_ID = "cimcvmedia_ConfigMountEntry_userId"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_WRITABLE = "cimcvmedia_ConfigMountEntry_writable"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_EXT_MGMT_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_extMgmtIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MAPPING_NAME = "cimcvmedia_ExtMgmtRuleEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MGMT_IF_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_mgmtIfIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ExtMgmtRuleEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_REMOTE_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_remoteIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_REMOTE_PORT = "cimcvmedia_ExtMgmtRuleEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_DESCR = "cimcvmedia_MountConfigDef_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_INT_ID = "cimcvmedia_MountConfigDef_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_NAME = "cimcvmedia_MountConfigDef_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_POLICY_LEVEL = "cimcvmedia_MountConfigDef_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_POLICY_OWNER = "cimcvmedia_MountConfigDef_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfigDef_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_DESCR = "cimcvmedia_MountConfigPolicy_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_INT_ID = "cimcvmedia_MountConfigPolicy_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_NAME = "cimcvmedia_MountConfigPolicy_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_POLICY_LEVEL = "cimcvmedia_MountConfigPolicy_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_POLICY_OWNER = "cimcvmedia_MountConfigPolicy_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfigPolicy_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DESCR = "cimcvmedia_MountConfig_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_INT_ID = "cimcvmedia_MountConfig_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_NAME = "cimcvmedia_MountConfig_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_LEVEL = "cimcvmedia_MountConfig_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_OWNER = "cimcvmedia_MountConfig_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfig_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_AUTH_OPTION = "cimcvmedia_MountInfo_authOption"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_DEVICE_TYPE = "cimcvmedia_MountInfo_deviceType"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_ENC_PWD = "cimcvmedia_MountInfo_encPwd"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_FILE_NAME = "cimcvmedia_MountInfo_imageFileName"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_NAME_VARIABLE = "cimcvmedia_MountInfo_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_PATH = "cimcvmedia_MountInfo_imagePath"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_MAPPING_NAME = "cimcvmedia_MountInfo_mappingName"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_MOUNT_PROTOCOL = "cimcvmedia_MountInfo_mountProtocol"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_PASSWORD = "cimcvmedia_MountInfo_password"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_PWD_SET = "cimcvmedia_MountInfo_pwdSet"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMAP_ON_EJECT = "cimcvmedia_MountInfo_remapOnEject"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_HOST = "cimcvmedia_MountInfo_remoteHost"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_IP_ADDRESS = "cimcvmedia_MountInfo_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_PORT = "cimcvmedia_MountInfo_remotePort"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_USER_ID = "cimcvmedia_MountInfo_userId"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_WRITABLE = "cimcvmedia_MountInfo_writable"
    SORT_PROP_CLITEST_TYPE_TEST2_A_PARTIAL_ENUM = "clitest_TypeTest2_aPartialEnum"
    SORT_PROP_CLITEST_TYPE_TEST2_ABITMASK = "clitest_TypeTest2_abitmask"
    SORT_PROP_CLITEST_TYPE_TEST2_ACHARBUF = "clitest_TypeTest2_acharbuf"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_DIR = "clitest_TypeTest2_fileDir"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_HOST = "clitest_TypeTest2_fileHost"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_NAME = "clitest_TypeTest2_fileName"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PASSWD = "clitest_TypeTest2_filePasswd"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PATH = "clitest_TypeTest2_filePath"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PORT = "clitest_TypeTest2_filePort"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PROTO = "clitest_TypeTest2_fileProto"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_USER = "clitest_TypeTest2_fileUser"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_ASTRING = "clitest_TypeTestChild_astring"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_DESCR = "clitest_TypeTestChild_descr"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_INT_ID = "clitest_TypeTestChild_intId"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_NAME = "clitest_TypeTestChild_name"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_POLICY_LEVEL = "clitest_TypeTestChild_policyLevel"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_POLICY_OWNER = "clitest_TypeTestChild_policyOwner"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_ASTRING = "clitest_TypeTestParent_astring"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_DESCR = "clitest_TypeTestParent_descr"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_INT_ID = "clitest_TypeTestParent_intId"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_NAME = "clitest_TypeTestParent_name"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_POLICY_LEVEL = "clitest_TypeTestParent_policyLevel"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_POLICY_OWNER = "clitest_TypeTestParent_policyOwner"
    SORT_PROP_CLITEST_TYPE_TEST_ACHAR = "clitest_TypeTest_achar"
    SORT_PROP_CLITEST_TYPE_TEST_ADATE = "clitest_TypeTest_adate"
    SORT_PROP_CLITEST_TYPE_TEST_ADATETIME = "clitest_TypeTest_adatetime"
    SORT_PROP_CLITEST_TYPE_TEST_AFLOAT = "clitest_TypeTest_afloat"
    SORT_PROP_CLITEST_TYPE_TEST_AMAC = "clitest_TypeTest_amac"
    SORT_PROP_CLITEST_TYPE_TEST_ANENUM = "clitest_TypeTest_anenum"
    SORT_PROP_CLITEST_TYPE_TEST_ANIPV4 = "clitest_TypeTest_anipv4"
    SORT_PROP_CLITEST_TYPE_TEST_ANIPV6 = "clitest_TypeTest_anipv6"
    SORT_PROP_CLITEST_TYPE_TEST_ANSBYTE = "clitest_TypeTest_ansbyte"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT16 = "clitest_TypeTest_ansint16"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT32 = "clitest_TypeTest_ansint32"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT64 = "clitest_TypeTest_ansint64"
    SORT_PROP_CLITEST_TYPE_TEST_APASSWORD = "clitest_TypeTest_apassword"
    SORT_PROP_CLITEST_TYPE_TEST_ARANGE = "clitest_TypeTest_arange"
    SORT_PROP_CLITEST_TYPE_TEST_ARCSTRING = "clitest_TypeTest_arcstring"
    SORT_PROP_CLITEST_TYPE_TEST_ARXSTRING = "clitest_TypeTest_arxstring"
    SORT_PROP_CLITEST_TYPE_TEST_ASTRING = "clitest_TypeTest_astring"
    SORT_PROP_CLITEST_TYPE_TEST_ATIME = "clitest_TypeTest_atime"
    SORT_PROP_CLITEST_TYPE_TEST_AUBYTE = "clitest_TypeTest_aubyte"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT16 = "clitest_TypeTest_auint16"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT32 = "clitest_TypeTest_auint32"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT64 = "clitest_TypeTest_auint64"
    SORT_PROP_CLITEST_TYPE_TEST_AWWN = "clitest_TypeTest_awwn"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_CLAIM_STATE = "cloud_DeviceConnectorEp_claimState"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_DESCR = "cloud_DeviceConnectorEp_descr"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_DESCRIPTION = "cloud_DeviceConnectorEp_description"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_INT_ID = "cloud_DeviceConnectorEp_intId"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_NAME = "cloud_DeviceConnectorEp_name"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_POLICY_LEVEL = "cloud_DeviceConnectorEp_policyLevel"
    SORT_PROP_CLOUD_DEVICE_CONNECTOR_EP_POLICY_OWNER = "cloud_DeviceConnectorEp_policyOwner"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_ADMIN_STATE = "comm_CimcWebService_adminState"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_DESCR = "comm_CimcWebService_descr"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_INT_ID = "comm_CimcWebService_intId"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_NAME = "comm_CimcWebService_name"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_OPER_PORT = "comm_CimcWebService_operPort"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_POLICY_LEVEL = "comm_CimcWebService_policyLevel"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_POLICY_OWNER = "comm_CimcWebService_policyOwner"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_PORT = "comm_CimcWebService_port"
    SORT_PROP_COMM_CIMC_WEB_SERVICE_PROTO = "comm_CimcWebService_proto"
    SORT_PROP_COMM_CIMXML_ADMIN_STATE = "comm_Cimxml_adminState"
    SORT_PROP_COMM_CIMXML_DESCR = "comm_Cimxml_descr"
    SORT_PROP_COMM_CIMXML_INT_ID = "comm_Cimxml_intId"
    SORT_PROP_COMM_CIMXML_NAME = "comm_Cimxml_name"
    SORT_PROP_COMM_CIMXML_OPER_PORT = "comm_Cimxml_operPort"
    SORT_PROP_COMM_CIMXML_POLICY_LEVEL = "comm_Cimxml_policyLevel"
    SORT_PROP_COMM_CIMXML_POLICY_OWNER = "comm_Cimxml_policyOwner"
    SORT_PROP_COMM_CIMXML_PORT = "comm_Cimxml_port"
    SORT_PROP_COMM_CIMXML_PROTO = "comm_Cimxml_proto"
    SORT_PROP_COMM_CLIENT_ITEM_ADMIN_STATE = "comm_ClientItem_adminState"
    SORT_PROP_COMM_CLIENT_ITEM_DESCR = "comm_ClientItem_descr"
    SORT_PROP_COMM_CLIENT_ITEM_HOSTNAME = "comm_ClientItem_hostname"
    SORT_PROP_COMM_CLIENT_ITEM_NAME = "comm_ClientItem_name"
    SORT_PROP_COMM_CLIENT_ADMIN_STATE = "comm_Client_adminState"
    SORT_PROP_COMM_CLIENT_DESCR = "comm_Client_descr"
    SORT_PROP_COMM_CLIENT_HOSTNAME = "comm_Client_hostname"
    SORT_PROP_COMM_CLIENT_INT_ID = "comm_Client_intId"
    SORT_PROP_COMM_CLIENT_NAME = "comm_Client_name"
    SORT_PROP_COMM_CLIENT_POLICY_LEVEL = "comm_Client_policyLevel"
    SORT_PROP_COMM_CLIENT_POLICY_OWNER = "comm_Client_policyOwner"
    SORT_PROP_COMM_DATE_TIME_ADMIN_STATE = "comm_DateTime_adminState"
    SORT_PROP_COMM_DATE_TIME_CONFIG_STATE = "comm_DateTime_configState"
    SORT_PROP_COMM_DATE_TIME_DATE = "comm_DateTime_date"
    SORT_PROP_COMM_DATE_TIME_DESCR = "comm_DateTime_descr"
    SORT_PROP_COMM_DATE_TIME_INT_ID = "comm_DateTime_intId"
    SORT_PROP_COMM_DATE_TIME_NAME = "comm_DateTime_name"
    SORT_PROP_COMM_DATE_TIME_OPER_PORT = "comm_DateTime_operPort"
    SORT_PROP_COMM_DATE_TIME_OPER_TIMEZONE = "comm_DateTime_operTimezone"
    SORT_PROP_COMM_DATE_TIME_POLICY_LEVEL = "comm_DateTime_policyLevel"
    SORT_PROP_COMM_DATE_TIME_POLICY_OWNER = "comm_DateTime_policyOwner"
    SORT_PROP_COMM_DATE_TIME_PORT = "comm_DateTime_port"
    SORT_PROP_COMM_DATE_TIME_PROTO = "comm_DateTime_proto"
    SORT_PROP_COMM_DATE_TIME_TIMEZONE = "comm_DateTime_timezone"
    SORT_PROP_COMM_DEFINITION_DESCR = "comm_Definition_descr"
    SORT_PROP_COMM_DEFINITION_INT_ID = "comm_Definition_intId"
    SORT_PROP_COMM_DEFINITION_NAME = "comm_Definition_name"
    SORT_PROP_COMM_DEFINITION_POLICY_LEVEL = "comm_Definition_policyLevel"
    SORT_PROP_COMM_DEFINITION_POLICY_OWNER = "comm_Definition_policyOwner"
    SORT_PROP_COMM_DNS_PROVIDER_ADMIN_STATE = "comm_DnsProvider_adminState"
    SORT_PROP_COMM_DNS_PROVIDER_DESCR = "comm_DnsProvider_descr"
    SORT_PROP_COMM_DNS_PROVIDER_HOSTNAME = "comm_DnsProvider_hostname"
    SORT_PROP_COMM_DNS_PROVIDER_NAME = "comm_DnsProvider_name"
    SORT_PROP_COMM_DNS_ADMIN_STATE = "comm_Dns_adminState"
    SORT_PROP_COMM_DNS_DESCR = "comm_Dns_descr"
    SORT_PROP_COMM_DNS_DOMAIN = "comm_Dns_domain"
    SORT_PROP_COMM_DNS_INT_ID = "comm_Dns_intId"
    SORT_PROP_COMM_DNS_NAME = "comm_Dns_name"
    SORT_PROP_COMM_DNS_OPER_PORT = "comm_Dns_operPort"
    SORT_PROP_COMM_DNS_POLICY_LEVEL = "comm_Dns_policyLevel"
    SORT_PROP_COMM_DNS_POLICY_OWNER = "comm_Dns_policyOwner"
    SORT_PROP_COMM_DNS_PORT = "comm_Dns_port"
    SORT_PROP_COMM_DNS_PROTO = "comm_Dns_proto"
    SORT_PROP_COMM_EVT_CHANNEL_CHANNEL_STATE = "comm_EvtChannel_channelState"
    SORT_PROP_COMM_EVT_CHANNEL_DESCR = "comm_EvtChannel_descr"
    SORT_PROP_COMM_EVT_CHANNEL_INT_ID = "comm_EvtChannel_intId"
    SORT_PROP_COMM_EVT_CHANNEL_NAME = "comm_EvtChannel_name"
    SORT_PROP_COMM_EVT_CHANNEL_POLICY_LEVEL = "comm_EvtChannel_policyLevel"
    SORT_PROP_COMM_EVT_CHANNEL_POLICY_OWNER = "comm_EvtChannel_policyOwner"
    SORT_PROP_COMM_HTTP_ADMIN_STATE = "comm_Http_adminState"
    SORT_PROP_COMM_HTTP_DESCR = "comm_Http_descr"
    SORT_PROP_COMM_HTTP_INT_ID = "comm_Http_intId"
    SORT_PROP_COMM_HTTP_NAME = "comm_Http_name"
    SORT_PROP_COMM_HTTP_OPER_PORT = "comm_Http_operPort"
    SORT_PROP_COMM_HTTP_POLICY_LEVEL = "comm_Http_policyLevel"
    SORT_PROP_COMM_HTTP_POLICY_OWNER = "comm_Http_policyOwner"
    SORT_PROP_COMM_HTTP_PORT = "comm_Http_port"
    SORT_PROP_COMM_HTTP_PROTO = "comm_Http_proto"
    SORT_PROP_COMM_HTTP_REDIRECT_STATE = "comm_Http_redirectState"
    SORT_PROP_COMM_HTTP_REQUEST_TIMEOUT = "comm_Http_requestTimeout"
    SORT_PROP_COMM_HTTPS_ADMIN_STATE = "comm_Https_adminState"
    SORT_PROP_COMM_HTTPS_ALLOWED_SSLPROTOCOLS = "comm_Https_allowedSSLProtocols"
    SORT_PROP_COMM_HTTPS_CIPHER_SUITE = "comm_Https_cipherSuite"
    SORT_PROP_COMM_HTTPS_CIPHER_SUITE_MODE = "comm_Https_cipherSuiteMode"
    SORT_PROP_COMM_HTTPS_DESCR = "comm_Https_descr"
    SORT_PROP_COMM_HTTPS_INT_ID = "comm_Https_intId"
    SORT_PROP_COMM_HTTPS_KEY_RING = "comm_Https_keyRing"
    SORT_PROP_COMM_HTTPS_NAME = "comm_Https_name"
    SORT_PROP_COMM_HTTPS_OPER_PORT = "comm_Https_operPort"
    SORT_PROP_COMM_HTTPS_POLICY_LEVEL = "comm_Https_policyLevel"
    SORT_PROP_COMM_HTTPS_POLICY_OWNER = "comm_Https_policyOwner"
    SORT_PROP_COMM_HTTPS_PORT = "comm_Https_port"
    SORT_PROP_COMM_HTTPS_PROTO = "comm_Https_proto"
    SORT_PROP_COMM_ITEM_DESCR = "comm_Item_descr"
    SORT_PROP_COMM_ITEM_NAME = "comm_Item_name"
    SORT_PROP_COMM_LOCALE_DESCR = "comm_Locale_descr"
    SORT_PROP_COMM_LOCALE_NAME = "comm_Locale_name"
    SORT_PROP_COMM_NTP_PROVIDER_ADMIN_STATE = "comm_NtpProvider_adminState"
    SORT_PROP_COMM_NTP_PROVIDER_DESCR = "comm_NtpProvider_descr"
    SORT_PROP_COMM_NTP_PROVIDER_HOSTNAME = "comm_NtpProvider_hostname"
    SORT_PROP_COMM_NTP_PROVIDER_NAME = "comm_NtpProvider_name"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_DESCR = "comm_ShellSvcLimits_descr"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_INT_ID = "comm_ShellSvcLimits_intId"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_NAME = "comm_ShellSvcLimits_name"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_POLICY_LEVEL = "comm_ShellSvcLimits_policyLevel"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_POLICY_OWNER = "comm_ShellSvcLimits_policyOwner"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_SESSIONS_PER_USER = "comm_ShellSvcLimits_sessionsPerUser"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_TOTAL_SESSIONS = "comm_ShellSvcLimits_totalSessions"
    SORT_PROP_COMM_SHELL_ADMIN_STATE = "comm_Shell_adminState"
    SORT_PROP_COMM_SHELL_DESCR = "comm_Shell_descr"
    SORT_PROP_COMM_SHELL_INT_ID = "comm_Shell_intId"
    SORT_PROP_COMM_SHELL_NAME = "comm_Shell_name"
    SORT_PROP_COMM_SHELL_OPER_PORT = "comm_Shell_operPort"
    SORT_PROP_COMM_SHELL_POLICY_LEVEL = "comm_Shell_policyLevel"
    SORT_PROP_COMM_SHELL_POLICY_OWNER = "comm_Shell_policyOwner"
    SORT_PROP_COMM_SHELL_PORT = "comm_Shell_port"
    SORT_PROP_COMM_SHELL_PROTO = "comm_Shell_proto"
    SORT_PROP_COMM_SMASH_CLP_ADMIN_STATE = "comm_SmashCLP_adminState"
    SORT_PROP_COMM_SMASH_CLP_DESCR = "comm_SmashCLP_descr"
    SORT_PROP_COMM_SMASH_CLP_INT_ID = "comm_SmashCLP_intId"
    SORT_PROP_COMM_SMASH_CLP_NAME = "comm_SmashCLP_name"
    SORT_PROP_COMM_SMASH_CLP_OPER_PORT = "comm_SmashCLP_operPort"
    SORT_PROP_COMM_SMASH_CLP_POLICY_LEVEL = "comm_SmashCLP_policyLevel"
    SORT_PROP_COMM_SMASH_CLP_POLICY_OWNER = "comm_SmashCLP_policyOwner"
    SORT_PROP_COMM_SMASH_CLP_PORT = "comm_SmashCLP_port"
    SORT_PROP_COMM_SMASH_CLP_PROTO = "comm_SmashCLP_proto"
    SORT_PROP_COMM_SNMP_TRAP_COMMUNITY = "comm_SnmpTrap_community"
    SORT_PROP_COMM_SNMP_TRAP_HOSTNAME = "comm_SnmpTrap_hostname"
    SORT_PROP_COMM_SNMP_TRAP_NOTIFICATION_TYPE = "comm_SnmpTrap_notificationType"
    SORT_PROP_COMM_SNMP_TRAP_PORT = "comm_SnmpTrap_port"
    SORT_PROP_COMM_SNMP_TRAP_V3_PRIVILEGE = "comm_SnmpTrap_v3Privilege"
    SORT_PROP_COMM_SNMP_TRAP_VERSION = "comm_SnmpTrap_version"
    SORT_PROP_COMM_SNMP_USER_AUTH = "comm_SnmpUser_auth"
    SORT_PROP_COMM_SNMP_USER_CONFIG_STATE = "comm_SnmpUser_configState"
    SORT_PROP_COMM_SNMP_USER_CONFIG_STATUS_MESSAGE = "comm_SnmpUser_configStatusMessage"
    SORT_PROP_COMM_SNMP_USER_DESCR = "comm_SnmpUser_descr"
    SORT_PROP_COMM_SNMP_USER_NAME = "comm_SnmpUser_name"
    SORT_PROP_COMM_SNMP_USER_PRIV_PWD_SET = "comm_SnmpUser_privPwdSet"
    SORT_PROP_COMM_SNMP_USER_PRIVPWD = "comm_SnmpUser_privpwd"
    SORT_PROP_COMM_SNMP_USER_PWD = "comm_SnmpUser_pwd"
    SORT_PROP_COMM_SNMP_USER_PWD_SET = "comm_SnmpUser_pwdSet"
    SORT_PROP_COMM_SNMP_USER_USE_AES = "comm_SnmpUser_useAes"
    SORT_PROP_COMM_SNMP_ADMIN_STATE = "comm_Snmp_adminState"
    SORT_PROP_COMM_SNMP_COMMUNITY = "comm_Snmp_community"
    SORT_PROP_COMM_SNMP_CONFIG_STATE = "comm_Snmp_configState"
    SORT_PROP_COMM_SNMP_DESCR = "comm_Snmp_descr"
    SORT_PROP_COMM_SNMP_INT_ID = "comm_Snmp_intId"
    SORT_PROP_COMM_SNMP_IS_SET_SNMP_SECURE = "comm_Snmp_isSetSnmpSecure"
    SORT_PROP_COMM_SNMP_NAME = "comm_Snmp_name"
    SORT_PROP_COMM_SNMP_OPER_PORT = "comm_Snmp_operPort"
    SORT_PROP_COMM_SNMP_POLICY_LEVEL = "comm_Snmp_policyLevel"
    SORT_PROP_COMM_SNMP_POLICY_OWNER = "comm_Snmp_policyOwner"
    SORT_PROP_COMM_SNMP_PORT = "comm_Snmp_port"
    SORT_PROP_COMM_SNMP_PROTO = "comm_Snmp_proto"
    SORT_PROP_COMM_SNMP_PROTOCOL = "comm_Snmp_protocol"
    SORT_PROP_COMM_SNMP_SNMP_OPER_STATE = "comm_Snmp_snmpOperState"
    SORT_PROP_COMM_SNMP_SYS_CONTACT = "comm_Snmp_sysContact"
    SORT_PROP_COMM_SNMP_SYS_LOCATION = "comm_Snmp_sysLocation"
    SORT_PROP_COMM_SSH_ADMIN_STATE = "comm_Ssh_adminState"
    SORT_PROP_COMM_SSH_DESCR = "comm_Ssh_descr"
    SORT_PROP_COMM_SSH_INT_ID = "comm_Ssh_intId"
    SORT_PROP_COMM_SSH_NAME = "comm_Ssh_name"
    SORT_PROP_COMM_SSH_OPER_PORT = "comm_Ssh_operPort"
    SORT_PROP_COMM_SSH_POLICY_LEVEL = "comm_Ssh_policyLevel"
    SORT_PROP_COMM_SSH_POLICY_OWNER = "comm_Ssh_policyOwner"
    SORT_PROP_COMM_SSH_PORT = "comm_Ssh_port"
    SORT_PROP_COMM_SSH_PROTO = "comm_Ssh_proto"
    SORT_PROP_COMM_SVC_CHANNEL_CHANNEL_STATE = "comm_SvcChannel_channelState"
    SORT_PROP_COMM_SVC_CHANNEL_DESCR = "comm_SvcChannel_descr"
    SORT_PROP_COMM_SVC_CHANNEL_INT_ID = "comm_SvcChannel_intId"
    SORT_PROP_COMM_SVC_CHANNEL_NAME = "comm_SvcChannel_name"
    SORT_PROP_COMM_SVC_CHANNEL_POLICY_LEVEL = "comm_SvcChannel_policyLevel"
    SORT_PROP_COMM_SVC_CHANNEL_POLICY_OWNER = "comm_SvcChannel_policyOwner"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEpFsmStage_descr"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_LAST_UPDATE_TIME = "comm_SvcEpFsmStage_lastUpdateTime"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_NAME = "comm_SvcEpFsmStage_name"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_ORDER = "comm_SvcEpFsmStage_order"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_RETRY = "comm_SvcEpFsmStage_retry"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_STAGE_STATUS = "comm_SvcEpFsmStage_stageStatus"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_COMPLETION = "comm_SvcEpFsmTask_completion"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_FLAGS = "comm_SvcEpFsmTask_flags"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_ITEM = "comm_SvcEpFsmTask_item"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_SEQ_ID = "comm_SvcEpFsmTask_seqId"
    SORT_PROP_COMM_SVC_EP_FSM_COMPLETION_TIME = "comm_SvcEpFsm_completionTime"
    SORT_PROP_COMM_SVC_EP_FSM_CURRENT_FSM = "comm_SvcEpFsm_currentFsm"
    SORT_PROP_COMM_SVC_EP_FSM_DESCR = "comm_SvcEpFsm_descr"
    SORT_PROP_COMM_SVC_EP_FSM_FSM_STATUS = "comm_SvcEpFsm_fsmStatus"
    SORT_PROP_COMM_SVC_EP_FSM_INSTANCE_ID = "comm_SvcEpFsm_instanceId"
    SORT_PROP_COMM_SVC_EP_FSM_PROGRESS = "comm_SvcEpFsm_progress"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_ERR_CODE = "comm_SvcEpFsm_rmtErrCode"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_ERR_DESCR = "comm_SvcEpFsm_rmtErrDescr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_RSLT = "comm_SvcEpFsm_rmtRslt"
    SORT_PROP_COMM_SVC_EP_CONFIG_STATE = "comm_SvcEp_configState"
    SORT_PROP_COMM_SVC_EP_CONFIG_STATUS_MESSAGE = "comm_SvcEp_configStatusMessage"
    SORT_PROP_COMM_SVC_EP_DESCR = "comm_SvcEp_descr"
    SORT_PROP_COMM_SVC_EP_FSM_DESCR = "comm_SvcEp_fsmDescr"
    SORT_PROP_COMM_SVC_EP_FSM_FLAGS = "comm_SvcEp_fsmFlags"
    SORT_PROP_COMM_SVC_EP_FSM_PREV = "comm_SvcEp_fsmPrev"
    SORT_PROP_COMM_SVC_EP_FSM_PROGR = "comm_SvcEp_fsmProgr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_ERR_CODE = "comm_SvcEp_fsmRmtInvErrCode"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_ERR_DESCR = "comm_SvcEp_fsmRmtInvErrDescr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_RSLT = "comm_SvcEp_fsmRmtInvRslt"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEp_fsmStageDescr"
    SORT_PROP_COMM_SVC_EP_FSM_STAMP = "comm_SvcEp_fsmStamp"
    SORT_PROP_COMM_SVC_EP_FSM_STATUS = "comm_SvcEp_fsmStatus"
    SORT_PROP_COMM_SVC_EP_FSM_TRY = "comm_SvcEp_fsmTry"
    SORT_PROP_COMM_SVC_EP_INT_ID = "comm_SvcEp_intId"
    SORT_PROP_COMM_SVC_EP_NAME = "comm_SvcEp_name"
    SORT_PROP_COMM_SVC_EP_POLICY_LEVEL = "comm_SvcEp_policyLevel"
    SORT_PROP_COMM_SVC_EP_POLICY_OWNER = "comm_SvcEp_policyOwner"
    SORT_PROP_COMM_SVC_LIMITS_DESCR = "comm_SvcLimits_descr"
    SORT_PROP_COMM_SVC_LIMITS_INT_ID = "comm_SvcLimits_intId"
    SORT_PROP_COMM_SVC_LIMITS_NAME = "comm_SvcLimits_name"
    SORT_PROP_COMM_SVC_LIMITS_POLICY_LEVEL = "comm_SvcLimits_policyLevel"
    SORT_PROP_COMM_SVC_LIMITS_POLICY_OWNER = "comm_SvcLimits_policyOwner"
    SORT_PROP_COMM_SVC_LIMITS_SESSIONS_PER_USER = "comm_SvcLimits_sessionsPerUser"
    SORT_PROP_COMM_SVC_LIMITS_TOTAL_SESSIONS = "comm_SvcLimits_totalSessions"
    SORT_PROP_COMM_SVC_POLICY_DESCR = "comm_SvcPolicy_descr"
    SORT_PROP_COMM_SVC_POLICY_INT_ID = "comm_SvcPolicy_intId"
    SORT_PROP_COMM_SVC_POLICY_NAME = "comm_SvcPolicy_name"
    SORT_PROP_COMM_SVC_POLICY_POLICY_LEVEL = "comm_SvcPolicy_policyLevel"
    SORT_PROP_COMM_SVC_POLICY_POLICY_OWNER = "comm_SvcPolicy_policyOwner"
    SORT_PROP_COMM_SVC_ADMIN_STATE = "comm_Svc_adminState"
    SORT_PROP_COMM_SVC_DESCR = "comm_Svc_descr"
    SORT_PROP_COMM_SVC_INT_ID = "comm_Svc_intId"
    SORT_PROP_COMM_SVC_NAME = "comm_Svc_name"
    SORT_PROP_COMM_SVC_OPER_PORT = "comm_Svc_operPort"
    SORT_PROP_COMM_SVC_POLICY_LEVEL = "comm_Svc_policyLevel"
    SORT_PROP_COMM_SVC_POLICY_OWNER = "comm_Svc_policyOwner"
    SORT_PROP_COMM_SVC_PORT = "comm_Svc_port"
    SORT_PROP_COMM_SVC_PROTO = "comm_Svc_proto"
    SORT_PROP_COMM_SYSLOG_CLIENT_ADMIN_STATE = "comm_SyslogClient_adminState"
    SORT_PROP_COMM_SYSLOG_CLIENT_FORWARDING_FACILITY = "comm_SyslogClient_forwardingFacility"
    SORT_PROP_COMM_SYSLOG_CLIENT_HOSTNAME = "comm_SyslogClient_hostname"
    SORT_PROP_COMM_SYSLOG_CLIENT_NAME = "comm_SyslogClient_name"
    SORT_PROP_COMM_SYSLOG_CLIENT_SEVERITY = "comm_SyslogClient_severity"
    SORT_PROP_COMM_SYSLOG_CONSOLE_ADMIN_STATE = "comm_SyslogConsole_adminState"
    SORT_PROP_COMM_SYSLOG_CONSOLE_DESCR = "comm_SyslogConsole_descr"
    SORT_PROP_COMM_SYSLOG_CONSOLE_NAME = "comm_SyslogConsole_name"
    SORT_PROP_COMM_SYSLOG_CONSOLE_SEVERITY = "comm_SyslogConsole_severity"
    SORT_PROP_COMM_SYSLOG_FILE_ADMIN_STATE = "comm_SyslogFile_adminState"
    SORT_PROP_COMM_SYSLOG_FILE_DESCR = "comm_SyslogFile_descr"
    SORT_PROP_COMM_SYSLOG_FILE_NAME = "comm_SyslogFile_name"
    SORT_PROP_COMM_SYSLOG_FILE_SEVERITY = "comm_SyslogFile_severity"
    SORT_PROP_COMM_SYSLOG_FILE_SIZE = "comm_SyslogFile_size"
    SORT_PROP_COMM_SYSLOG_MONITOR_ADMIN_STATE = "comm_SyslogMonitor_adminState"
    SORT_PROP_COMM_SYSLOG_MONITOR_DESCR = "comm_SyslogMonitor_descr"
    SORT_PROP_COMM_SYSLOG_MONITOR_NAME = "comm_SyslogMonitor_name"
    SORT_PROP_COMM_SYSLOG_MONITOR_SEVERITY = "comm_SyslogMonitor_severity"
    SORT_PROP_COMM_SYSLOG_SOURCE_AUDITS = "comm_SyslogSource_audits"
    SORT_PROP_COMM_SYSLOG_SOURCE_DESCR = "comm_SyslogSource_descr"
    SORT_PROP_COMM_SYSLOG_SOURCE_EVENTS = "comm_SyslogSource_events"
    SORT_PROP_COMM_SYSLOG_SOURCE_FAULTS = "comm_SyslogSource_faults"
    SORT_PROP_COMM_SYSLOG_SOURCE_NAME = "comm_SyslogSource_name"
    SORT_PROP_COMM_SYSLOG_ADMIN_STATE = "comm_Syslog_adminState"
    SORT_PROP_COMM_SYSLOG_DESCR = "comm_Syslog_descr"
    SORT_PROP_COMM_SYSLOG_INT_ID = "comm_Syslog_intId"
    SORT_PROP_COMM_SYSLOG_NAME = "comm_Syslog_name"
    SORT_PROP_COMM_SYSLOG_OPER_PORT = "comm_Syslog_operPort"
    SORT_PROP_COMM_SYSLOG_POLICY_LEVEL = "comm_Syslog_policyLevel"
    SORT_PROP_COMM_SYSLOG_POLICY_OWNER = "comm_Syslog_policyOwner"
    SORT_PROP_COMM_SYSLOG_PORT = "comm_Syslog_port"
    SORT_PROP_COMM_SYSLOG_PROTO = "comm_Syslog_proto"
    SORT_PROP_COMM_SYSLOG_SEVERITY = "comm_Syslog_severity"
    SORT_PROP_COMM_TELNET_ADMIN_STATE = "comm_Telnet_adminState"
    SORT_PROP_COMM_TELNET_DESCR = "comm_Telnet_descr"
    SORT_PROP_COMM_TELNET_INT_ID = "comm_Telnet_intId"
    SORT_PROP_COMM_TELNET_NAME = "comm_Telnet_name"
    SORT_PROP_COMM_TELNET_OPER_PORT = "comm_Telnet_operPort"
    SORT_PROP_COMM_TELNET_POLICY_LEVEL = "comm_Telnet_policyLevel"
    SORT_PROP_COMM_TELNET_POLICY_OWNER = "comm_Telnet_policyOwner"
    SORT_PROP_COMM_TELNET_PORT = "comm_Telnet_port"
    SORT_PROP_COMM_TELNET_PROTO = "comm_Telnet_proto"
    SORT_PROP_COMM_WEB_CHANNEL_CHANNEL_STATE = "comm_WebChannel_channelState"
    SORT_PROP_COMM_WEB_CHANNEL_DESCR = "comm_WebChannel_descr"
    SORT_PROP_COMM_WEB_CHANNEL_INT_ID = "comm_WebChannel_intId"
    SORT_PROP_COMM_WEB_CHANNEL_NAME = "comm_WebChannel_name"
    SORT_PROP_COMM_WEB_CHANNEL_POLICY_LEVEL = "comm_WebChannel_policyLevel"
    SORT_PROP_COMM_WEB_CHANNEL_POLICY_OWNER = "comm_WebChannel_policyOwner"
    SORT_PROP_COMM_WEB_SVC_LIMITS_DESCR = "comm_WebSvcLimits_descr"
    SORT_PROP_COMM_WEB_SVC_LIMITS_INT_ID = "comm_WebSvcLimits_intId"
    SORT_PROP_COMM_WEB_SVC_LIMITS_MAX_EVENT_INTERVAL = "comm_WebSvcLimits_maxEventInterval"
    SORT_PROP_COMM_WEB_SVC_LIMITS_NAME = "comm_WebSvcLimits_name"
    SORT_PROP_COMM_WEB_SVC_LIMITS_POLICY_LEVEL = "comm_WebSvcLimits_policyLevel"
    SORT_PROP_COMM_WEB_SVC_LIMITS_POLICY_OWNER = "comm_WebSvcLimits_policyOwner"
    SORT_PROP_COMM_WEB_SVC_LIMITS_SESSIONS_PER_USER = "comm_WebSvcLimits_sessionsPerUser"
    SORT_PROP_COMM_WEB_SVC_LIMITS_TOTAL_SESSIONS = "comm_WebSvcLimits_totalSessions"
    SORT_PROP_COMM_WEB_ADMIN_STATE = "comm_Web_adminState"
    SORT_PROP_COMM_WEB_DESCR = "comm_Web_descr"
    SORT_PROP_COMM_WEB_INT_ID = "comm_Web_intId"
    SORT_PROP_COMM_WEB_NAME = "comm_Web_name"
    SORT_PROP_COMM_WEB_OPER_PORT = "comm_Web_operPort"
    SORT_PROP_COMM_WEB_POLICY_LEVEL = "comm_Web_policyLevel"
    SORT_PROP_COMM_WEB_POLICY_OWNER = "comm_Web_policyOwner"
    SORT_PROP_COMM_WEB_PORT = "comm_Web_port"
    SORT_PROP_COMM_WEB_PROTO = "comm_Web_proto"
    SORT_PROP_COMM_WSMAN_ADMIN_STATE = "comm_Wsman_adminState"
    SORT_PROP_COMM_WSMAN_DESCR = "comm_Wsman_descr"
    SORT_PROP_COMM_WSMAN_INT_ID = "comm_Wsman_intId"
    SORT_PROP_COMM_WSMAN_NAME = "comm_Wsman_name"
    SORT_PROP_COMM_WSMAN_OPER_PORT = "comm_Wsman_operPort"
    SORT_PROP_COMM_WSMAN_POLICY_LEVEL = "comm_Wsman_policyLevel"
    SORT_PROP_COMM_WSMAN_POLICY_OWNER = "comm_Wsman_policyOwner"
    SORT_PROP_COMM_WSMAN_PORT = "comm_Wsman_port"
    SORT_PROP_COMM_WSMAN_PROTO = "comm_Wsman_proto"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_ADMIN_STATE = "comm_XmlClConnPolicy_adminState"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_CLIENT_TYPE = "comm_XmlClConnPolicy_clientType"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_DESCR = "comm_XmlClConnPolicy_descr"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_INT_ID = "comm_XmlClConnPolicy_intId"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_NAME = "comm_XmlClConnPolicy_name"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_OPER_PORT = "comm_XmlClConnPolicy_operPort"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_POLICY_LEVEL = "comm_XmlClConnPolicy_policyLevel"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_POLICY_OWNER = "comm_XmlClConnPolicy_policyOwner"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_PORT = "comm_XmlClConnPolicy_port"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_PROTO = "comm_XmlClConnPolicy_proto"
    SORT_PROP_COMPUTE_ABOARD_CMOS_VOLTAGE = "compute_ABoard_cmosVoltage"
    SORT_PROP_COMPUTE_ABOARD_FAULT_QUALIFIER = "compute_ABoard_faultQualifier"
    SORT_PROP_COMPUTE_ABOARD_ID = "compute_ABoard_id"
    SORT_PROP_COMPUTE_ABOARD_LOCATION_DN = "compute_ABoard_locationDn"
    SORT_PROP_COMPUTE_ABOARD_MODEL = "compute_ABoard_model"
    SORT_PROP_COMPUTE_ABOARD_OPER_POWER = "compute_ABoard_operPower"
    SORT_PROP_COMPUTE_ABOARD_OPER_QUALIFIER_REASON = "compute_ABoard_operQualifierReason"
    SORT_PROP_COMPUTE_ABOARD_OPER_STATE = "compute_ABoard_operState"
    SORT_PROP_COMPUTE_ABOARD_OPERABILITY = "compute_ABoard_operability"
    SORT_PROP_COMPUTE_ABOARD_PERF = "compute_ABoard_perf"
    SORT_PROP_COMPUTE_ABOARD_POWER = "compute_ABoard_power"
    SORT_PROP_COMPUTE_ABOARD_POWER_USAGE = "compute_ABoard_powerUsage"
    SORT_PROP_COMPUTE_ABOARD_PRESENCE = "compute_ABoard_presence"
    SORT_PROP_COMPUTE_ABOARD_REVISION = "compute_ABoard_revision"
    SORT_PROP_COMPUTE_ABOARD_SERIAL = "compute_ABoard_serial"
    SORT_PROP_COMPUTE_ABOARD_THERMAL = "compute_ABoard_thermal"
    SORT_PROP_COMPUTE_ABOARD_VENDOR = "compute_ABoard_vendor"
    SORT_PROP_COMPUTE_ABOARD_VOLTAGE = "compute_ABoard_voltage"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_ACTION = "compute_AChassisDiscPolicy_action"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_BACKPLANE_SPEED_PREF = "compute_AChassisDiscPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_DESCR = "compute_AChassisDiscPolicy_descr"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_INT_ID = "compute_AChassisDiscPolicy_intId"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_AChassisDiscPolicy_linkAggregationPref"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_NAME = "compute_AChassisDiscPolicy_name"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_AChassisDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_OWNER = "compute_AChassisDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_QUALIFIER = "compute_AChassisDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_ADMIN_ACK_ACKED = "compute_AdminAck_acked"
    SORT_PROP_COMPUTE_ADMIN_ACK_ACKED_BY = "compute_AdminAck_ackedBy"
    SORT_PROP_COMPUTE_ADMIN_ACK_ADMIN_STATE = "compute_AdminAck_adminState"
    SORT_PROP_COMPUTE_ADMIN_ACK_AUTO_DELETE = "compute_AdminAck_autoDelete"
    SORT_PROP_COMPUTE_ADMIN_ACK_CHANGE_BY = "compute_AdminAck_changeBy"
    SORT_PROP_COMPUTE_ADMIN_ACK_CHANGE_DETAILS = "compute_AdminAck_changeDetails"
    SORT_PROP_COMPUTE_ADMIN_ACK_CHANGES = "compute_AdminAck_changes"
    SORT_PROP_COMPUTE_ADMIN_ACK_DESCR = "compute_AdminAck_descr"
    SORT_PROP_COMPUTE_ADMIN_ACK_DISR = "compute_AdminAck_disr"
    SORT_PROP_COMPUTE_ADMIN_ACK_EXTD_CHANGE_DETAILS = "compute_AdminAck_extdChangeDetails"
    SORT_PROP_COMPUTE_ADMIN_ACK_IGNORE_CAP = "compute_AdminAck_ignoreCap"
    SORT_PROP_COMPUTE_ADMIN_ACK_INT_ID = "compute_AdminAck_intId"
    SORT_PROP_COMPUTE_ADMIN_ACK_MODIFIED = "compute_AdminAck_modified"
    SORT_PROP_COMPUTE_ADMIN_ACK_NAME = "compute_AdminAck_name"
    SORT_PROP_COMPUTE_ADMIN_ACK_OPER_SCHEDULER = "compute_AdminAck_operScheduler"
    SORT_PROP_COMPUTE_ADMIN_ACK_OPER_STATE = "compute_AdminAck_operState"
    SORT_PROP_COMPUTE_ADMIN_ACK_POLICY_LEVEL = "compute_AdminAck_policyLevel"
    SORT_PROP_COMPUTE_ADMIN_ACK_POLICY_OWNER = "compute_AdminAck_policyOwner"
    SORT_PROP_COMPUTE_ADMIN_ACK_PREV_OPER_STATE = "compute_AdminAck_prevOperState"
    SORT_PROP_COMPUTE_ADMIN_ACK_SCHEDULER = "compute_AdminAck_scheduler"
    SORT_PROP_COMPUTE_ADMIN_ACK_TRIGGER_CONFIG_STATE = "compute_AdminAck_triggerConfigState"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_DESCR = "compute_AutoconfigPolicy_descr"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_DST_DN = "compute_AutoconfigPolicy_dstDn"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_INT_ID = "compute_AutoconfigPolicy_intId"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_NAME = "compute_AutoconfigPolicy_name"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_OPER_QUALIFIER = "compute_AutoconfigPolicy_operQualifier"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_POLICY_LEVEL = "compute_AutoconfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_POLICY_OWNER = "compute_AutoconfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_QUALIFIER = "compute_AutoconfigPolicy_qualifier"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_SRC_TEMPL_NAME = "compute_AutoconfigPolicy_srcTemplName"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_ACTION = "compute_BladeDiscPolicy_action"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_DESCR = "compute_BladeDiscPolicy_descr"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_INT_ID = "compute_BladeDiscPolicy_intId"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_NAME = "compute_BladeDiscPolicy_name"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_POLICY_LEVEL = "compute_BladeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_POLICY_OWNER = "compute_BladeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_QUALIFIER = "compute_BladeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_BladeDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_BLADE_EP_ADMIN_STATE = "compute_BladeEp_adminState"
    SORT_PROP_COMPUTE_BLADE_EP_CHASSIS_ID = "compute_BladeEp_chassisId"
    SORT_PROP_COMPUTE_BLADE_EP_EP_DN = "compute_BladeEp_epDn"
    SORT_PROP_COMPUTE_BLADE_EP_ID = "compute_BladeEp_id"
    SORT_PROP_COMPUTE_BLADE_EP_OPER_QUALIFIER_REASON = "compute_BladeEp_operQualifierReason"
    SORT_PROP_COMPUTE_BLADE_EP_OPER_STATE = "compute_BladeEp_operState"
    SORT_PROP_COMPUTE_BLADE_EP_PEER_PRESENCE = "compute_BladeEp_peerPresence"
    SORT_PROP_COMPUTE_BLADE_EP_PRESENCE = "compute_BladeEp_presence"
    SORT_PROP_COMPUTE_BLADE_EP_SLOT_ID = "compute_BladeEp_slotId"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_DESCR = "compute_BladeFsmStage_descr"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_LAST_UPDATE_TIME = "compute_BladeFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_NAME = "compute_BladeFsmStage_name"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_ORDER = "compute_BladeFsmStage_order"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_RETRY = "compute_BladeFsmStage_retry"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_STAGE_STATUS = "compute_BladeFsmStage_stageStatus"
    SORT_PROP_COMPUTE_BLADE_FSM_TASK_COMPLETION = "compute_BladeFsmTask_completion"
    SORT_PROP_COMPUTE_BLADE_FSM_TASK_FLAGS = "compute_BladeFsmTask_flags"
    SORT_PROP_COMPUTE_BLADE_FSM_TASK_ITEM = "compute_BladeFsmTask_item"
    SORT_PROP_COMPUTE_BLADE_FSM_TASK_SEQ_ID = "compute_BladeFsmTask_seqId"
    SORT_PROP_COMPUTE_BLADE_FSM_COMPLETION_TIME = "compute_BladeFsm_completionTime"
    SORT_PROP_COMPUTE_BLADE_FSM_CURRENT_FSM = "compute_BladeFsm_currentFsm"
    SORT_PROP_COMPUTE_BLADE_FSM_DESCR = "compute_BladeFsm_descr"
    SORT_PROP_COMPUTE_BLADE_FSM_FSM_STATUS = "compute_BladeFsm_fsmStatus"
    SORT_PROP_COMPUTE_BLADE_FSM_INSTANCE_ID = "compute_BladeFsm_instanceId"
    SORT_PROP_COMPUTE_BLADE_FSM_PROGRESS = "compute_BladeFsm_progress"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_ERR_CODE = "compute_BladeFsm_rmtErrCode"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_ERR_DESCR = "compute_BladeFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_RSLT = "compute_BladeFsm_rmtRslt"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_DESCR = "compute_BladeInheritPolicy_descr"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_DST_DN = "compute_BladeInheritPolicy_dstDn"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_INT_ID = "compute_BladeInheritPolicy_intId"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_NAME = "compute_BladeInheritPolicy_name"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_OPER_QUALIFIER = "compute_BladeInheritPolicy_operQualifier"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_POLICY_LEVEL = "compute_BladeInheritPolicy_policyLevel"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_POLICY_OWNER = "compute_BladeInheritPolicy_policyOwner"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_QUALIFIER = "compute_BladeInheritPolicy_qualifier"
    SORT_PROP_COMPUTE_BLADE_POS_QUAL_MAX_ID = "compute_BladePosQual_maxId"
    SORT_PROP_COMPUTE_BLADE_POS_QUAL_MIN_ID = "compute_BladePosQual_minId"
    SORT_PROP_COMPUTE_BLADE_ADMIN_POWER = "compute_Blade_adminPower"
    SORT_PROP_COMPUTE_BLADE_ADMIN_STATE = "compute_Blade_adminState"
    SORT_PROP_COMPUTE_BLADE_ASSET_TAG = "compute_Blade_assetTag"
    SORT_PROP_COMPUTE_BLADE_ASSIGNED_TO_DN = "compute_Blade_assignedToDn"
    SORT_PROP_COMPUTE_BLADE_ASSOCIATION = "compute_Blade_association"
    SORT_PROP_COMPUTE_BLADE_AVAILABILITY = "compute_Blade_availability"
    SORT_PROP_COMPUTE_BLADE_AVAILABLE_MEMORY = "compute_Blade_availableMemory"
    SORT_PROP_COMPUTE_BLADE_CHASSIS_ID = "compute_Blade_chassisId"
    SORT_PROP_COMPUTE_BLADE_CHECK_POINT = "compute_Blade_checkPoint"
    SORT_PROP_COMPUTE_BLADE_CONN_PATH = "compute_Blade_connPath"
    SORT_PROP_COMPUTE_BLADE_CONN_STATUS = "compute_Blade_connStatus"
    SORT_PROP_COMPUTE_BLADE_DESCR = "compute_Blade_descr"
    SORT_PROP_COMPUTE_BLADE_DISCOVERY = "compute_Blade_discovery"
    SORT_PROP_COMPUTE_BLADE_DISCOVERY_STATUS = "compute_Blade_discoveryStatus"
    SORT_PROP_COMPUTE_BLADE_FLT_AGGR = "compute_Blade_fltAggr"
    SORT_PROP_COMPUTE_BLADE_FSM_DESCR = "compute_Blade_fsmDescr"
    SORT_PROP_COMPUTE_BLADE_FSM_FLAGS = "compute_Blade_fsmFlags"
    SORT_PROP_COMPUTE_BLADE_FSM_PREV = "compute_Blade_fsmPrev"
    SORT_PROP_COMPUTE_BLADE_FSM_PROGR = "compute_Blade_fsmProgr"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_INV_ERR_CODE = "compute_Blade_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_INV_ERR_DESCR = "compute_Blade_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_BLADE_FSM_RMT_INV_RSLT = "compute_Blade_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_BLADE_FSM_STAGE_DESCR = "compute_Blade_fsmStageDescr"
    SORT_PROP_COMPUTE_BLADE_FSM_STAMP = "compute_Blade_fsmStamp"
    SORT_PROP_COMPUTE_BLADE_FSM_STATUS = "compute_Blade_fsmStatus"
    SORT_PROP_COMPUTE_BLADE_FSM_TRY = "compute_Blade_fsmTry"
    SORT_PROP_COMPUTE_BLADE_INT_ID = "compute_Blade_intId"
    SORT_PROP_COMPUTE_BLADE_KMIP_FAULT = "compute_Blade_kmipFault"
    SORT_PROP_COMPUTE_BLADE_KMIP_FAULT_DESCRIPTION = "compute_Blade_kmipFaultDescription"
    SORT_PROP_COMPUTE_BLADE_LC = "compute_Blade_lc"
    SORT_PROP_COMPUTE_BLADE_LC_TS = "compute_Blade_lcTs"
    SORT_PROP_COMPUTE_BLADE_LOCAL_ID = "compute_Blade_localId"
    SORT_PROP_COMPUTE_BLADE_LOW_VOLTAGE_MEMORY = "compute_Blade_lowVoltageMemory"
    SORT_PROP_COMPUTE_BLADE_MANAGING_INST = "compute_Blade_managingInst"
    SORT_PROP_COMPUTE_BLADE_MEMORY_SPEED = "compute_Blade_memorySpeed"
    SORT_PROP_COMPUTE_BLADE_MFG_TIME = "compute_Blade_mfgTime"
    SORT_PROP_COMPUTE_BLADE_MODEL = "compute_Blade_model"
    SORT_PROP_COMPUTE_BLADE_NAME = "compute_Blade_name"
    SORT_PROP_COMPUTE_BLADE_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_Blade_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_BLADE_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_Blade_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_ADAPTORS = "compute_Blade_numOfAdaptors"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CORES = "compute_Blade_numOfCores"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CORES_ENABLED = "compute_Blade_numOfCoresEnabled"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CPUS = "compute_Blade_numOfCpus"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_ETH_HOST_IFS = "compute_Blade_numOfEthHostIfs"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_FC_HOST_IFS = "compute_Blade_numOfFcHostIfs"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_THREADS = "compute_Blade_numOfThreads"
    SORT_PROP_COMPUTE_BLADE_OPER_POWER = "compute_Blade_operPower"
    SORT_PROP_COMPUTE_BLADE_OPER_PWR_TRANS_SRC = "compute_Blade_operPwrTransSrc"
    SORT_PROP_COMPUTE_BLADE_OPER_QUALIFIER = "compute_Blade_operQualifier"
    SORT_PROP_COMPUTE_BLADE_OPER_QUALIFIER_REASON = "compute_Blade_operQualifierReason"
    SORT_PROP_COMPUTE_BLADE_OPER_STATE = "compute_Blade_operState"
    SORT_PROP_COMPUTE_BLADE_OPERABILITY = "compute_Blade_operability"
    SORT_PROP_COMPUTE_BLADE_ORIGINAL_UUID = "compute_Blade_originalUuid"
    SORT_PROP_COMPUTE_BLADE_PART_NUMBER = "compute_Blade_partNumber"
    SORT_PROP_COMPUTE_BLADE_POLICY_LEVEL = "compute_Blade_policyLevel"
    SORT_PROP_COMPUTE_BLADE_POLICY_OWNER = "compute_Blade_policyOwner"
    SORT_PROP_COMPUTE_BLADE_PRESENCE = "compute_Blade_presence"
    SORT_PROP_COMPUTE_BLADE_REVISION = "compute_Blade_revision"
    SORT_PROP_COMPUTE_BLADE_SCALED_MODE = "compute_Blade_scaledMode"
    SORT_PROP_COMPUTE_BLADE_SERIAL = "compute_Blade_serial"
    SORT_PROP_COMPUTE_BLADE_SERVER_ID = "compute_Blade_serverId"
    SORT_PROP_COMPUTE_BLADE_SLOT_ID = "compute_Blade_slotId"
    SORT_PROP_COMPUTE_BLADE_STORAGE_OPER_QUALIFIER = "compute_Blade_storageOperQualifier"
    SORT_PROP_COMPUTE_BLADE_TOTAL_MEMORY = "compute_Blade_totalMemory"
    SORT_PROP_COMPUTE_BLADE_USR_LBL = "compute_Blade_usrLbl"
    SORT_PROP_COMPUTE_BLADE_UUID = "compute_Blade_uuid"
    SORT_PROP_COMPUTE_BLADE_VENDOR = "compute_Blade_vendor"
    SORT_PROP_COMPUTE_BLADE_VID = "compute_Blade_vid"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_BOARD_CONNECTOR_TYPE = "compute_BoardConnector_boardConnectorType"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_MASTER_SLOT_ID = "compute_BoardConnector_masterSlotId"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_SLAVE_SLOT_ID = "compute_BoardConnector_slaveSlotId"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_ID = "compute_BoardController_id"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_LOCATION_DN = "compute_BoardController_locationDn"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_MODEL = "compute_BoardController_model"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPER_QUALIFIER_REASON = "compute_BoardController_operQualifierReason"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPER_STATE = "compute_BoardController_operState"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPERABILITY = "compute_BoardController_operability"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_PERF = "compute_BoardController_perf"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_POWER = "compute_BoardController_power"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_PRESENCE = "compute_BoardController_presence"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_REVISION = "compute_BoardController_revision"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_SERIAL = "compute_BoardController_serial"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_THERMAL = "compute_BoardController_thermal"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_VENDOR = "compute_BoardController_vendor"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_VOLTAGE = "compute_BoardController_voltage"
    SORT_PROP_COMPUTE_BOARD_CMOS_VOLTAGE = "compute_Board_cmosVoltage"
    SORT_PROP_COMPUTE_BOARD_CPU_TYPE_DESCRIPTION = "compute_Board_cpuTypeDescription"
    SORT_PROP_COMPUTE_BOARD_FAULT_QUALIFIER = "compute_Board_faultQualifier"
    SORT_PROP_COMPUTE_BOARD_GENERATION = "compute_Board_generation"
    SORT_PROP_COMPUTE_BOARD_ID = "compute_Board_id"
    SORT_PROP_COMPUTE_BOARD_LOCATION_DN = "compute_Board_locationDn"
    SORT_PROP_COMPUTE_BOARD_MODEL = "compute_Board_model"
    SORT_PROP_COMPUTE_BOARD_OPER_POWER = "compute_Board_operPower"
    SORT_PROP_COMPUTE_BOARD_OPER_QUALIFIER_REASON = "compute_Board_operQualifierReason"
    SORT_PROP_COMPUTE_BOARD_OPER_STATE = "compute_Board_operState"
    SORT_PROP_COMPUTE_BOARD_OPERABILITY = "compute_Board_operability"
    SORT_PROP_COMPUTE_BOARD_PERF = "compute_Board_perf"
    SORT_PROP_COMPUTE_BOARD_POWER = "compute_Board_power"
    SORT_PROP_COMPUTE_BOARD_POWER_USAGE = "compute_Board_powerUsage"
    SORT_PROP_COMPUTE_BOARD_PRESENCE = "compute_Board_presence"
    SORT_PROP_COMPUTE_BOARD_REVISION = "compute_Board_revision"
    SORT_PROP_COMPUTE_BOARD_SERIAL = "compute_Board_serial"
    SORT_PROP_COMPUTE_BOARD_THERMAL = "compute_Board_thermal"
    SORT_PROP_COMPUTE_BOARD_VENDOR = "compute_Board_vendor"
    SORT_PROP_COMPUTE_BOARD_VOLTAGE = "compute_Board_voltage"
    SORT_PROP_COMPUTE_CARTRIDGE_CHASSIS_ID = "compute_Cartridge_chassisId"
    SORT_PROP_COMPUTE_CARTRIDGE_DISCOVERY = "compute_Cartridge_discovery"
    SORT_PROP_COMPUTE_CARTRIDGE_FLT_AGGR = "compute_Cartridge_fltAggr"
    SORT_PROP_COMPUTE_CARTRIDGE_ID = "compute_Cartridge_id"
    SORT_PROP_COMPUTE_CARTRIDGE_LC = "compute_Cartridge_lc"
    SORT_PROP_COMPUTE_CARTRIDGE_LC_TS = "compute_Cartridge_lcTs"
    SORT_PROP_COMPUTE_CARTRIDGE_MODEL = "compute_Cartridge_model"
    SORT_PROP_COMPUTE_CARTRIDGE_OPER_QUALIFIER_REASON = "compute_Cartridge_operQualifierReason"
    SORT_PROP_COMPUTE_CARTRIDGE_OPER_STATE = "compute_Cartridge_operState"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERABILITY = "compute_Cartridge_operability"
    SORT_PROP_COMPUTE_CARTRIDGE_PERF = "compute_Cartridge_perf"
    SORT_PROP_COMPUTE_CARTRIDGE_POWER = "compute_Cartridge_power"
    SORT_PROP_COMPUTE_CARTRIDGE_PRESENCE = "compute_Cartridge_presence"
    SORT_PROP_COMPUTE_CARTRIDGE_REVISION = "compute_Cartridge_revision"
    SORT_PROP_COMPUTE_CARTRIDGE_SERIAL = "compute_Cartridge_serial"
    SORT_PROP_COMPUTE_CARTRIDGE_SLOT_ID = "compute_Cartridge_slotId"
    SORT_PROP_COMPUTE_CARTRIDGE_THERMAL = "compute_Cartridge_thermal"
    SORT_PROP_COMPUTE_CARTRIDGE_VENDOR = "compute_Cartridge_vendor"
    SORT_PROP_COMPUTE_CARTRIDGE_VOLTAGE = "compute_Cartridge_voltage"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_ADMIN_STATE = "compute_ChassisConnPolicy_adminState"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_BACKPLANE_SPEED_PREF = "compute_ChassisConnPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_CHASSIS_ID = "compute_ChassisConnPolicy_chassisId"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_DESCR = "compute_ChassisConnPolicy_descr"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_INT_ID = "compute_ChassisConnPolicy_intId"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_NAME = "compute_ChassisConnPolicy_name"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_POLICY_LEVEL = "compute_ChassisConnPolicy_policyLevel"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_POLICY_OWNER = "compute_ChassisConnPolicy_policyOwner"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_QUALIFIER = "compute_ChassisConnPolicy_qualifier"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_SWITCH_ID = "compute_ChassisConnPolicy_switchId"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_ACTION = "compute_ChassisDiscPolicy_action"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_BACKPLANE_SPEED_PREF = "compute_ChassisDiscPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_DESCR = "compute_ChassisDiscPolicy_descr"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_INT_ID = "compute_ChassisDiscPolicy_intId"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_ChassisDiscPolicy_linkAggregationPref"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_MULTICAST_HW_HASH = "compute_ChassisDiscPolicy_multicastHwHash"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_NAME = "compute_ChassisDiscPolicy_name"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_ChassisDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_POLICY_OWNER = "compute_ChassisDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_QUALIFIER = "compute_ChassisDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_REBALANCE = "compute_ChassisDiscPolicy_rebalance"
    SORT_PROP_COMPUTE_CHASSIS_QUAL_MAX_ID = "compute_ChassisQual_maxId"
    SORT_PROP_COMPUTE_CHASSIS_QUAL_MIN_ID = "compute_ChassisQual_minId"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_ACTION = "compute_ComputeDiscPolicy_action"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_DESCR = "compute_ComputeDiscPolicy_descr"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_INT_ID = "compute_ComputeDiscPolicy_intId"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_NAME = "compute_ComputeDiscPolicy_name"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_ComputeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_ComputeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_QUALIFIER = "compute_ComputeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ComputeDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_CONFIG_POLICY_DESCR = "compute_ConfigPolicy_descr"
    SORT_PROP_COMPUTE_CONFIG_POLICY_INT_ID = "compute_ConfigPolicy_intId"
    SORT_PROP_COMPUTE_CONFIG_POLICY_NAME = "compute_ConfigPolicy_name"
    SORT_PROP_COMPUTE_CONFIG_POLICY_POLICY_LEVEL = "compute_ConfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_CONFIG_POLICY_POLICY_OWNER = "compute_ConfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_CONFIG_POLICY_QUALIFIER = "compute_ConfigPolicy_qualifier"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_CONSTRAINT_TYPE = "compute_ConstraintDef_constraintType"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_DESCR = "compute_ConstraintDef_descr"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_HW_MODEL = "compute_ConstraintDef_hwModel"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_HW_REVISION = "compute_ConstraintDef_hwRevision"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_HW_VENDOR = "compute_ConstraintDef_hwVendor"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_INT_ID = "compute_ConstraintDef_intId"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_NAME = "compute_ConstraintDef_name"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_POLICY_LEVEL = "compute_ConstraintDef_policyLevel"
    SORT_PROP_COMPUTE_CONSTRAINT_DEF_POLICY_OWNER = "compute_ConstraintDef_policyOwner"
    SORT_PROP_COMPUTE_CONTAINER_DESCR = "compute_Container_descr"
    SORT_PROP_COMPUTE_CONTAINER_INT_ID = "compute_Container_intId"
    SORT_PROP_COMPUTE_CONTAINER_NAME = "compute_Container_name"
    SORT_PROP_COMPUTE_CONTAINER_POLICY_LEVEL = "compute_Container_policyLevel"
    SORT_PROP_COMPUTE_CONTAINER_POLICY_OWNER = "compute_Container_policyOwner"
    SORT_PROP_COMPUTE_CONTAINER_UUID = "compute_Container_uuid"
    SORT_PROP_COMPUTE_DISC_POLICY_DESCR = "compute_DiscPolicy_descr"
    SORT_PROP_COMPUTE_DISC_POLICY_INT_ID = "compute_DiscPolicy_intId"
    SORT_PROP_COMPUTE_DISC_POLICY_NAME = "compute_DiscPolicy_name"
    SORT_PROP_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_DiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_DiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_DISC_POLICY_QUALIFIER = "compute_DiscPolicy_qualifier"
    SORT_PROP_COMPUTE_EXT_BOARD_BOARD_AGGREGATION_ROLE = "compute_ExtBoard_boardAggregationRole"
    SORT_PROP_COMPUTE_EXT_BOARD_CHASSIS_ID = "compute_ExtBoard_chassisId"
    SORT_PROP_COMPUTE_EXT_BOARD_CMOS_VOLTAGE = "compute_ExtBoard_cmosVoltage"
    SORT_PROP_COMPUTE_EXT_BOARD_CONN_PATH = "compute_ExtBoard_connPath"
    SORT_PROP_COMPUTE_EXT_BOARD_CONN_STATUS = "compute_ExtBoard_connStatus"
    SORT_PROP_COMPUTE_EXT_BOARD_DISCOVERY_STATUS = "compute_ExtBoard_discoveryStatus"
    SORT_PROP_COMPUTE_EXT_BOARD_FAULT_QUALIFIER = "compute_ExtBoard_faultQualifier"
    SORT_PROP_COMPUTE_EXT_BOARD_ID = "compute_ExtBoard_id"
    SORT_PROP_COMPUTE_EXT_BOARD_LOCATION_DN = "compute_ExtBoard_locationDn"
    SORT_PROP_COMPUTE_EXT_BOARD_MANAGING_INST = "compute_ExtBoard_managingInst"
    SORT_PROP_COMPUTE_EXT_BOARD_MODEL = "compute_ExtBoard_model"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_POWER = "compute_ExtBoard_operPower"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_QUALIFIER_REASON = "compute_ExtBoard_operQualifierReason"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_STATE = "compute_ExtBoard_operState"
    SORT_PROP_COMPUTE_EXT_BOARD_OPERABILITY = "compute_ExtBoard_operability"
    SORT_PROP_COMPUTE_EXT_BOARD_PERF = "compute_ExtBoard_perf"
    SORT_PROP_COMPUTE_EXT_BOARD_POWER = "compute_ExtBoard_power"
    SORT_PROP_COMPUTE_EXT_BOARD_POWER_USAGE = "compute_ExtBoard_powerUsage"
    SORT_PROP_COMPUTE_EXT_BOARD_PRESENCE = "compute_ExtBoard_presence"
    SORT_PROP_COMPUTE_EXT_BOARD_REVISION = "compute_ExtBoard_revision"
    SORT_PROP_COMPUTE_EXT_BOARD_SERIAL = "compute_ExtBoard_serial"
    SORT_PROP_COMPUTE_EXT_BOARD_SLOT_ID = "compute_ExtBoard_slotId"
    SORT_PROP_COMPUTE_EXT_BOARD_THERMAL = "compute_ExtBoard_thermal"
    SORT_PROP_COMPUTE_EXT_BOARD_VENDOR = "compute_ExtBoard_vendor"
    SORT_PROP_COMPUTE_EXT_BOARD_VOLTAGE = "compute_ExtBoard_voltage"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_CREATE_INITIAL_VOLUMES = "compute_FactoryResetOperation_createInitialVolumes"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_FLEX_STORAGE_SCRUB = "compute_FactoryResetOperation_flexStorageScrub"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_OPER_STATUS = "compute_FactoryResetOperation_operStatus"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_PERSISTENT_MEMORY_SCRUB = "compute_FactoryResetOperation_persistentMemoryScrub"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_RESET_TRIGGER = "compute_FactoryResetOperation_resetTrigger"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_STORAGE_SCRUB = "compute_FactoryResetOperation_storageScrub"
    SORT_PROP_COMPUTE_FAN_POLICY_DESCR = "compute_FanPolicy_descr"
    SORT_PROP_COMPUTE_FAN_POLICY_INT_ID = "compute_FanPolicy_intId"
    SORT_PROP_COMPUTE_FAN_POLICY_NAME = "compute_FanPolicy_name"
    SORT_PROP_COMPUTE_FAN_POLICY_POLICY_LEVEL = "compute_FanPolicy_policyLevel"
    SORT_PROP_COMPUTE_FAN_POLICY_POLICY_OWNER = "compute_FanPolicy_policyOwner"
    SORT_PROP_COMPUTE_FAN_POLICY_SPEED = "compute_FanPolicy_speed"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_ACKED = "compute_FwSyncAck_acked"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_ACKED_BY = "compute_FwSyncAck_ackedBy"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_ADMIN_STATE = "compute_FwSyncAck_adminState"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_AUTO_DELETE = "compute_FwSyncAck_autoDelete"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_CHANGE_BY = "compute_FwSyncAck_changeBy"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_CHANGE_DETAILS = "compute_FwSyncAck_changeDetails"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_CHANGES = "compute_FwSyncAck_changes"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_DESCR = "compute_FwSyncAck_descr"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_DISR = "compute_FwSyncAck_disr"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_EXTD_CHANGE_DETAILS = "compute_FwSyncAck_extdChangeDetails"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_IGNORE_CAP = "compute_FwSyncAck_ignoreCap"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_INT_ID = "compute_FwSyncAck_intId"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_MODIFIED = "compute_FwSyncAck_modified"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_NAME = "compute_FwSyncAck_name"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_OPER_SCHEDULER = "compute_FwSyncAck_operScheduler"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_OPER_STATE = "compute_FwSyncAck_operState"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_POLICY_LEVEL = "compute_FwSyncAck_policyLevel"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_POLICY_OWNER = "compute_FwSyncAck_policyOwner"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_PREV_OPER_STATE = "compute_FwSyncAck_prevOperState"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_SCHEDULER = "compute_FwSyncAck_scheduler"
    SORT_PROP_COMPUTE_FW_SYNC_ACK_TRIGGER_CONFIG_STATE = "compute_FwSyncAck_triggerConfigState"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_DESCR = "compute_GraphicsCardPolicy_descr"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_GRAPHICS_CARD_MODE = "compute_GraphicsCardPolicy_graphicsCardMode"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_INT_ID = "compute_GraphicsCardPolicy_intId"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_NAME = "compute_GraphicsCardPolicy_name"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_POLICY_LEVEL = "compute_GraphicsCardPolicy_policyLevel"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_POLICY_OWNER = "compute_GraphicsCardPolicy_policyOwner"
    SORT_PROP_COMPUTE_HEALTH_LED_SENSOR_ALARM_ALARM_DESC = "compute_HealthLedSensorAlarm_alarmDesc"
    SORT_PROP_COMPUTE_HEALTH_LED_SENSOR_ALARM_ALARM_SEVERITY = "compute_HealthLedSensorAlarm_alarmSeverity"
    SORT_PROP_COMPUTE_HEALTH_LED_SENSOR_ALARM_SENSOR_ID = "compute_HealthLedSensorAlarm_sensorId"
    SORT_PROP_COMPUTE_HEALTH_LED_SENSOR_ALARM_SENSOR_NAME = "compute_HealthLedSensorAlarm_sensorName"
    SORT_PROP_COMPUTE_HOST_UTILITY_OS_COMMUNICATION_TYPE = "compute_HostUtilityOs_communicationType"
    SORT_PROP_COMPUTE_HOST_UTILITY_OS_UTIL_OSNAME = "compute_HostUtilityOs_utilOSName"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_ACTION = "compute_HwChangeDiscPolicy_action"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_DESCR = "compute_HwChangeDiscPolicy_descr"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_INT_ID = "compute_HwChangeDiscPolicy_intId"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_NAME = "compute_HwChangeDiscPolicy_name"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_POLICY_LEVEL = "compute_HwChangeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_POLICY_OWNER = "compute_HwChangeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_QUALIFIER = "compute_HwChangeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_ID = "compute_IOHubEnvStatsHist_id"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_MOST_RECENT = "compute_IOHubEnvStatsHist_mostRecent"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_SUSPECT = "compute_IOHubEnvStatsHist_suspect"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE = "compute_IOHubEnvStatsHist_temperature"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_AVG = "compute_IOHubEnvStatsHist_temperatureAvg"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MAX = "compute_IOHubEnvStatsHist_temperatureMax"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MIN = "compute_IOHubEnvStatsHist_temperatureMin"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_THRESHOLDED = "compute_IOHubEnvStatsHist_thresholded"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TIME_COLLECTED = "compute_IOHubEnvStatsHist_timeCollected"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_INTERVALS = "compute_IOHubEnvStats_intervals"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_SUSPECT = "compute_IOHubEnvStats_suspect"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE = "compute_IOHubEnvStats_temperature"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_AVG = "compute_IOHubEnvStats_temperatureAvg"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MAX = "compute_IOHubEnvStats_temperatureMax"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MIN = "compute_IOHubEnvStats_temperatureMin"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_THRESHOLDED = "compute_IOHubEnvStats_thresholded"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TIME_COLLECTED = "compute_IOHubEnvStats_timeCollected"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_UPDATE = "compute_IOHubEnvStats_update"
    SORT_PROP_COMPUTE_IOHUB_ID = "compute_IOHub_id"
    SORT_PROP_COMPUTE_IOHUB_LOCATION_DN = "compute_IOHub_locationDn"
    SORT_PROP_COMPUTE_IOHUB_MODEL = "compute_IOHub_model"
    SORT_PROP_COMPUTE_IOHUB_OPER_QUALIFIER_REASON = "compute_IOHub_operQualifierReason"
    SORT_PROP_COMPUTE_IOHUB_OPER_STATE = "compute_IOHub_operState"
    SORT_PROP_COMPUTE_IOHUB_OPERABILITY = "compute_IOHub_operability"
    SORT_PROP_COMPUTE_IOHUB_PERF = "compute_IOHub_perf"
    SORT_PROP_COMPUTE_IOHUB_POWER = "compute_IOHub_power"
    SORT_PROP_COMPUTE_IOHUB_PRESENCE = "compute_IOHub_presence"
    SORT_PROP_COMPUTE_IOHUB_REVISION = "compute_IOHub_revision"
    SORT_PROP_COMPUTE_IOHUB_SERIAL = "compute_IOHub_serial"
    SORT_PROP_COMPUTE_IOHUB_THERMAL = "compute_IOHub_thermal"
    SORT_PROP_COMPUTE_IOHUB_VENDOR = "compute_IOHub_vendor"
    SORT_PROP_COMPUTE_IOHUB_VOLTAGE = "compute_IOHub_voltage"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_DESCR = "compute_InitConfigPolicy_descr"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_DST_DN = "compute_InitConfigPolicy_dstDn"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_INT_ID = "compute_InitConfigPolicy_intId"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_NAME = "compute_InitConfigPolicy_name"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_POLICY_LEVEL = "compute_InitConfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_POLICY_OWNER = "compute_InitConfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_QUALIFIER = "compute_InitConfigPolicy_qualifier"
    SORT_PROP_COMPUTE_INSTANCE_ID_QUAL_MAX_ID = "compute_InstanceIdQual_maxId"
    SORT_PROP_COMPUTE_INSTANCE_ID_QUAL_MIN_ID = "compute_InstanceIdQual_minId"
    SORT_PROP_COMPUTE_ITEM_ADMIN_STATE = "compute_Item_adminState"
    SORT_PROP_COMPUTE_ITEM_ASSIGNED_TO_DN = "compute_Item_assignedToDn"
    SORT_PROP_COMPUTE_ITEM_ASSOCIATION = "compute_Item_association"
    SORT_PROP_COMPUTE_ITEM_AVAILABILITY = "compute_Item_availability"
    SORT_PROP_COMPUTE_ITEM_DESCR = "compute_Item_descr"
    SORT_PROP_COMPUTE_ITEM_DISCOVERY = "compute_Item_discovery"
    SORT_PROP_COMPUTE_ITEM_INT_ID = "compute_Item_intId"
    SORT_PROP_COMPUTE_ITEM_NAME = "compute_Item_name"
    SORT_PROP_COMPUTE_ITEM_OPER_STATE = "compute_Item_operState"
    SORT_PROP_COMPUTE_ITEM_POLICY_LEVEL = "compute_Item_policyLevel"
    SORT_PROP_COMPUTE_ITEM_POLICY_OWNER = "compute_Item_policyOwner"
    SORT_PROP_COMPUTE_ITEM_UUID = "compute_Item_uuid"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_DESCR = "compute_KvmMgmtPolicy_descr"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_INT_ID = "compute_KvmMgmtPolicy_intId"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_KVM_PORT = "compute_KvmMgmtPolicy_kvmPort"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_NAME = "compute_KvmMgmtPolicy_name"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_POLICY_LEVEL = "compute_KvmMgmtPolicy_policyLevel"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_POLICY_OWNER = "compute_KvmMgmtPolicy_policyOwner"
    SORT_PROP_COMPUTE_KVM_MGMT_POLICY_VMEDIA_ENCRYPTION = "compute_KvmMgmtPolicy_vmediaEncryption"
    SORT_PROP_COMPUTE_LOGICAL_DESCR = "compute_Logical_descr"
    SORT_PROP_COMPUTE_LOGICAL_INT_ID = "compute_Logical_intId"
    SORT_PROP_COMPUTE_LOGICAL_NAME = "compute_Logical_name"
    SORT_PROP_COMPUTE_LOGICAL_PN_DN = "compute_Logical_pnDn"
    SORT_PROP_COMPUTE_LOGICAL_POLICY_LEVEL = "compute_Logical_policyLevel"
    SORT_PROP_COMPUTE_LOGICAL_POLICY_OWNER = "compute_Logical_policyOwner"
    SORT_PROP_COMPUTE_LOGICAL_UUID = "compute_Logical_uuid"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER = "compute_MbPowerStatsHist_consumedPower"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_AVG = "compute_MbPowerStatsHist_consumedPowerAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MAX = "compute_MbPowerStatsHist_consumedPowerMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MIN = "compute_MbPowerStatsHist_consumedPowerMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_ID = "compute_MbPowerStatsHist_id"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT = "compute_MbPowerStatsHist_inputCurrent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_AVG = "compute_MbPowerStatsHist_inputCurrentAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MAX = "compute_MbPowerStatsHist_inputCurrentMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MIN = "compute_MbPowerStatsHist_inputCurrentMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE = "compute_MbPowerStatsHist_inputVoltage"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_AVG = "compute_MbPowerStatsHist_inputVoltageAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MAX = "compute_MbPowerStatsHist_inputVoltageMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MIN = "compute_MbPowerStatsHist_inputVoltageMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_MOST_RECENT = "compute_MbPowerStatsHist_mostRecent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_SUSPECT = "compute_MbPowerStatsHist_suspect"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_THRESHOLDED = "compute_MbPowerStatsHist_thresholded"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_TIME_COLLECTED = "compute_MbPowerStatsHist_timeCollected"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER = "compute_MbPowerStats_consumedPower"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_AVG = "compute_MbPowerStats_consumedPowerAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MAX = "compute_MbPowerStats_consumedPowerMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MIN = "compute_MbPowerStats_consumedPowerMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT = "compute_MbPowerStats_inputCurrent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_AVG = "compute_MbPowerStats_inputCurrentAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MAX = "compute_MbPowerStats_inputCurrentMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MIN = "compute_MbPowerStats_inputCurrentMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE = "compute_MbPowerStats_inputVoltage"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_AVG = "compute_MbPowerStats_inputVoltageAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MAX = "compute_MbPowerStats_inputVoltageMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MIN = "compute_MbPowerStats_inputVoltageMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INTERVALS = "compute_MbPowerStats_intervals"
    SORT_PROP_COMPUTE_MB_POWER_STATS_SUSPECT = "compute_MbPowerStats_suspect"
    SORT_PROP_COMPUTE_MB_POWER_STATS_THRESHOLDED = "compute_MbPowerStats_thresholded"
    SORT_PROP_COMPUTE_MB_POWER_STATS_TIME_COLLECTED = "compute_MbPowerStats_timeCollected"
    SORT_PROP_COMPUTE_MB_POWER_STATS_UPDATE = "compute_MbPowerStats_update"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO = "compute_MbTempStatsHist_fmTempSenIo"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_AVG = "compute_MbTempStatsHist_fmTempSenIoAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MAX = "compute_MbTempStatsHist_fmTempSenIoMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MIN = "compute_MbTempStatsHist_fmTempSenIoMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR = "compute_MbTempStatsHist_fmTempSenRear"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStatsHist_fmTempSenRearAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_L = "compute_MbTempStatsHist_fmTempSenRearL"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStatsHist_fmTempSenRearLAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStatsHist_fmTempSenRearLMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStatsHist_fmTempSenRearLMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStatsHist_fmTempSenRearMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStatsHist_fmTempSenRearMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_R = "compute_MbTempStatsHist_fmTempSenRearR"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStatsHist_fmTempSenRearRAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStatsHist_fmTempSenRearRMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStatsHist_fmTempSenRearRMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_ID = "compute_MbTempStatsHist_id"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_MbTempStatsHist_mostRecent"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_SUSPECT = "compute_MbTempStatsHist_suspect"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_MbTempStatsHist_thresholded"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_MbTempStatsHist_timeCollected"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO = "compute_MbTempStats_fmTempSenIo"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_AVG = "compute_MbTempStats_fmTempSenIoAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MAX = "compute_MbTempStats_fmTempSenIoMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MIN = "compute_MbTempStats_fmTempSenIoMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR = "compute_MbTempStats_fmTempSenRear"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStats_fmTempSenRearAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_L = "compute_MbTempStats_fmTempSenRearL"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStats_fmTempSenRearLAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStats_fmTempSenRearLMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStats_fmTempSenRearLMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStats_fmTempSenRearMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStats_fmTempSenRearMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_R = "compute_MbTempStats_fmTempSenRearR"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStats_fmTempSenRearRAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStats_fmTempSenRearRMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStats_fmTempSenRearRMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_INTERVALS = "compute_MbTempStats_intervals"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_SUSPECT = "compute_MbTempStats_suspect"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_THRESHOLDED = "compute_MbTempStats_thresholded"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_TIME_COLLECTED = "compute_MbTempStats_timeCollected"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_UPDATE = "compute_MbTempStats_update"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_BLACK_LISTING = "compute_MemoryConfigPolicy_blackListing"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_DESCR = "compute_MemoryConfigPolicy_descr"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_INT_ID = "compute_MemoryConfigPolicy_intId"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_NAME = "compute_MemoryConfigPolicy_name"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_POLICY_LEVEL = "compute_MemoryConfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_MEMORY_CONFIG_POLICY_POLICY_OWNER = "compute_MemoryConfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_MEMORY_CONFIGURATION_ADMIN_MEMORY_STATE = "compute_MemoryConfiguration_adminMemoryState"
    SORT_PROP_COMPUTE_MEMORY_CONFIGURATION_BLACK_LISTING = "compute_MemoryConfiguration_blackListing"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_DESCR = "compute_MemoryUnitConstraintDef_descr"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_INT_ID = "compute_MemoryUnitConstraintDef_intId"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_NAME = "compute_MemoryUnitConstraintDef_name"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_POLICY_LEVEL = "compute_MemoryUnitConstraintDef_policyLevel"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_POLICY_OWNER = "compute_MemoryUnitConstraintDef_policyOwner"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_REVISION_MODIFIER = "compute_MemoryUnitConstraintDef_revisionModifier"
    SORT_PROP_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_TYPE = "compute_MemoryUnitConstraintDef_type"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS = "compute_PCIeFatalCompletionStats_AbortErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_AbortErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_AbortErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_AbortErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_AbortErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_AbortErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_AbortErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_AbortErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_AbortErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_AbortErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_AbortErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS = "compute_PCIeFatalCompletionStats_TimeoutErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_TimeoutErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_TimeoutErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_TimeoutErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_TimeoutErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_TimeoutErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_TimeoutErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_TimeoutErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_INTERVALS = "compute_PCIeFatalCompletionStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_SUSPECT = "compute_PCIeFatalCompletionStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_THRESHOLDED = "compute_PCIeFatalCompletionStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIME_COLLECTED = "compute_PCIeFatalCompletionStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS = "compute_PCIeFatalCompletionStats_unexpectedErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_unexpectedErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_unexpectedErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_unexpectedErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_unexpectedErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_unexpectedErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_unexpectedErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_unexpectedErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UPDATE = "compute_PCIeFatalCompletionStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS = "compute_PCIeFatalProtocolStats_dllpErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS15_MIN = "compute_PCIeFatalProtocolStats_dllpErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS15_MIN_H = "compute_PCIeFatalProtocolStats_dllpErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_DAY = "compute_PCIeFatalProtocolStats_dllpErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_DAY_H = "compute_PCIeFatalProtocolStats_dllpErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_HOUR = "compute_PCIeFatalProtocolStats_dllpErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_HOUR_H = "compute_PCIeFatalProtocolStats_dllpErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_WEEK = "compute_PCIeFatalProtocolStats_dllpErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_WEEK_H = "compute_PCIeFatalProtocolStats_dllpErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS2_WEEKS = "compute_PCIeFatalProtocolStats_dllpErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS2_WEEKS_H = "compute_PCIeFatalProtocolStats_dllpErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS = "compute_PCIeFatalProtocolStats_flowControlErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS15_MIN = "compute_PCIeFatalProtocolStats_flowControlErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS15_MIN_H = "compute_PCIeFatalProtocolStats_flowControlErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_DAY = "compute_PCIeFatalProtocolStats_flowControlErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_DAY_H = "compute_PCIeFatalProtocolStats_flowControlErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_HOUR = "compute_PCIeFatalProtocolStats_flowControlErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_HOUR_H = "compute_PCIeFatalProtocolStats_flowControlErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_WEEK = "compute_PCIeFatalProtocolStats_flowControlErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_WEEK_H = "compute_PCIeFatalProtocolStats_flowControlErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS2_WEEKS = "compute_PCIeFatalProtocolStats_flowControlErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS2_WEEKS_H = "compute_PCIeFatalProtocolStats_flowControlErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_INTERVALS = "compute_PCIeFatalProtocolStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_SUSPECT = "compute_PCIeFatalProtocolStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_THRESHOLDED = "compute_PCIeFatalProtocolStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_TIME_COLLECTED = "compute_PCIeFatalProtocolStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_UPDATE = "compute_PCIeFatalProtocolStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS = "compute_PCIeFatalReceiveStats_bufferOverflowErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_bufferOverflowErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_bufferOverflowErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_errFatalErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_errFatalErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_errFatalErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_errFatalErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_errFatalErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_errFatalErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_errFatalErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_errFatalErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_errFatalErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_errFatalErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errNonFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_errNonFatalErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_errNonFatalErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_INTERVALS = "compute_PCIeFatalReceiveStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_SUSPECT = "compute_PCIeFatalReceiveStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_THRESHOLDED = "compute_PCIeFatalReceiveStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_TIME_COLLECTED = "compute_PCIeFatalReceiveStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UPDATE = "compute_PCIeFatalReceiveStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS = "compute_PCIeFatalStats_acsViolationErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS15_MIN = "compute_PCIeFatalStats_acsViolationErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS15_MIN_H = "compute_PCIeFatalStats_acsViolationErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_DAY = "compute_PCIeFatalStats_acsViolationErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_DAY_H = "compute_PCIeFatalStats_acsViolationErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_HOUR = "compute_PCIeFatalStats_acsViolationErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_HOUR_H = "compute_PCIeFatalStats_acsViolationErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_WEEK = "compute_PCIeFatalStats_acsViolationErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_WEEK_H = "compute_PCIeFatalStats_acsViolationErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS2_WEEKS = "compute_PCIeFatalStats_acsViolationErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS2_WEEKS_H = "compute_PCIeFatalStats_acsViolationErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_INTERVALS = "compute_PCIeFatalStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS = "compute_PCIeFatalStats_malformedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS15_MIN = "compute_PCIeFatalStats_malformedTLPErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS15_MIN_H = "compute_PCIeFatalStats_malformedTLPErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_DAY = "compute_PCIeFatalStats_malformedTLPErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_DAY_H = "compute_PCIeFatalStats_malformedTLPErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_HOUR = "compute_PCIeFatalStats_malformedTLPErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_HOUR_H = "compute_PCIeFatalStats_malformedTLPErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_WEEK = "compute_PCIeFatalStats_malformedTLPErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_WEEK_H = "compute_PCIeFatalStats_malformedTLPErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS2_WEEKS = "compute_PCIeFatalStats_malformedTLPErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS2_WEEKS_H = "compute_PCIeFatalStats_malformedTLPErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS = "compute_PCIeFatalStats_poisonedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS15_MIN = "compute_PCIeFatalStats_poisonedTLPErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS15_MIN_H = "compute_PCIeFatalStats_poisonedTLPErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_DAY = "compute_PCIeFatalStats_poisonedTLPErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_DAY_H = "compute_PCIeFatalStats_poisonedTLPErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_HOUR = "compute_PCIeFatalStats_poisonedTLPErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_HOUR_H = "compute_PCIeFatalStats_poisonedTLPErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_WEEK = "compute_PCIeFatalStats_poisonedTLPErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_WEEK_H = "compute_PCIeFatalStats_poisonedTLPErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS2_WEEKS = "compute_PCIeFatalStats_poisonedTLPErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS2_WEEKS_H = "compute_PCIeFatalStats_poisonedTLPErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS = "compute_PCIeFatalStats_surpriseLinkDownErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS15_MIN = "compute_PCIeFatalStats_surpriseLinkDownErrors15Min"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS15_MIN_H = "compute_PCIeFatalStats_surpriseLinkDownErrors15MinH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_DAY = "compute_PCIeFatalStats_surpriseLinkDownErrors1Day"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_DAY_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1DayH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_HOUR = "compute_PCIeFatalStats_surpriseLinkDownErrors1Hour"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_HOUR_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1HourH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_WEEK = "compute_PCIeFatalStats_surpriseLinkDownErrors1Week"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_WEEK_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1WeekH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS2_WEEKS = "compute_PCIeFatalStats_surpriseLinkDownErrors2Weeks"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS2_WEEKS_H = "compute_PCIeFatalStats_surpriseLinkDownErrors2WeeksH"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SUSPECT = "compute_PCIeFatalStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_THRESHOLDED = "compute_PCIeFatalStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_TIME_COLLECTED = "compute_PCIeFatalStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_UPDATE = "compute_PCIeFatalStats_update"
    SORT_PROP_COMPUTE_PARTITION_DESCR = "compute_Partition_descr"
    SORT_PROP_COMPUTE_PARTITION_INT_ID = "compute_Partition_intId"
    SORT_PROP_COMPUTE_PARTITION_LS_DN = "compute_Partition_lsDn"
    SORT_PROP_COMPUTE_PARTITION_NAME = "compute_Partition_name"
    SORT_PROP_COMPUTE_PARTITION_PN_DN = "compute_Partition_pnDn"
    SORT_PROP_COMPUTE_PARTITION_POLICY_LEVEL = "compute_Partition_policyLevel"
    SORT_PROP_COMPUTE_PARTITION_POLICY_OWNER = "compute_Partition_policyOwner"
    SORT_PROP_COMPUTE_PARTITION_UUID = "compute_Partition_uuid"
    SORT_PROP_COMPUTE_PCI_CAP_MAX_BUS_ID_PER_SLOT = "compute_PciCap_maxBusIdPerSlot"
    SORT_PROP_COMPUTE_PCI_CAP_NUM_OF_PHYS_SLOTS = "compute_PciCap_numOfPhysSlots"
    SORT_PROP_COMPUTE_PCI_CAP_ORDER = "compute_PciCap_order"
    SORT_PROP_COMPUTE_PCI_CAP_STARTS_WITH = "compute_PciCap_startsWith"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_DESCR = "compute_PciSlotScanDef_descr"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_INT_ID = "compute_PciSlotScanDef_intId"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_NAME = "compute_PciSlotScanDef_name"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_POLICY_LEVEL = "compute_PciSlotScanDef_policyLevel"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_POLICY_OWNER = "compute_PciSlotScanDef_policyOwner"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_SCAN_ORDER = "compute_PciSlotScanDef_scanOrder"
    SORT_PROP_COMPUTE_PCI_SLOT_SCAN_DEF_SLOT_ID = "compute_PciSlotScanDef_slotId"
    SORT_PROP_COMPUTE_PERSONALITY_ADDITIONAL_INFO = "compute_Personality_additionalInfo"
    SORT_PROP_COMPUTE_PERSONALITY_ID = "compute_Personality_id"
    SORT_PROP_COMPUTE_PERSONALITY_NAME = "compute_Personality_name"
    SORT_PROP_COMPUTE_PHYSICAL_ASSOC_CTX_FRU_CAP_DN = "compute_PhysicalAssocCtx_fruCapDn"
    SORT_PROP_COMPUTE_PHYSICAL_EXTENSION_HW_INVENTORY_STATUS = "compute_PhysicalExtension_hwInventoryStatus"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_DESCR = "compute_PhysicalFsmStage_descr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_LAST_UPDATE_TIME = "compute_PhysicalFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_NAME = "compute_PhysicalFsmStage_name"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_ORDER = "compute_PhysicalFsmStage_order"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_RETRY = "compute_PhysicalFsmStage_retry"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_STAGE_STATUS = "compute_PhysicalFsmStage_stageStatus"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_TASK_COMPLETION = "compute_PhysicalFsmTask_completion"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_TASK_FLAGS = "compute_PhysicalFsmTask_flags"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_TASK_ITEM = "compute_PhysicalFsmTask_item"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_TASK_SEQ_ID = "compute_PhysicalFsmTask_seqId"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_COMPLETION_TIME = "compute_PhysicalFsm_completionTime"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_CURRENT_FSM = "compute_PhysicalFsm_currentFsm"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_DESCR = "compute_PhysicalFsm_descr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_FSM_STATUS = "compute_PhysicalFsm_fsmStatus"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_INSTANCE_ID = "compute_PhysicalFsm_instanceId"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_PROGRESS = "compute_PhysicalFsm_progress"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_ERR_CODE = "compute_PhysicalFsm_rmtErrCode"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_ERR_DESCR = "compute_PhysicalFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_RSLT = "compute_PhysicalFsm_rmtRslt"
    SORT_PROP_COMPUTE_PHYSICAL_QUAL_MODEL = "compute_PhysicalQual_model"
    SORT_PROP_COMPUTE_PHYSICAL_QUAL_PROP_ACL = "compute_PhysicalQual_propAcl"
    SORT_PROP_COMPUTE_PHYSICAL_ADMIN_POWER = "compute_Physical_adminPower"
    SORT_PROP_COMPUTE_PHYSICAL_ADMIN_STATE = "compute_Physical_adminState"
    SORT_PROP_COMPUTE_PHYSICAL_ASSET_TAG = "compute_Physical_assetTag"
    SORT_PROP_COMPUTE_PHYSICAL_ASSIGNED_TO_DN = "compute_Physical_assignedToDn"
    SORT_PROP_COMPUTE_PHYSICAL_ASSOCIATION = "compute_Physical_association"
    SORT_PROP_COMPUTE_PHYSICAL_AVAILABILITY = "compute_Physical_availability"
    SORT_PROP_COMPUTE_PHYSICAL_AVAILABLE_MEMORY = "compute_Physical_availableMemory"
    SORT_PROP_COMPUTE_PHYSICAL_CHECK_POINT = "compute_Physical_checkPoint"
    SORT_PROP_COMPUTE_PHYSICAL_CONN_PATH = "compute_Physical_connPath"
    SORT_PROP_COMPUTE_PHYSICAL_CONN_STATUS = "compute_Physical_connStatus"
    SORT_PROP_COMPUTE_PHYSICAL_DESCR = "compute_Physical_descr"
    SORT_PROP_COMPUTE_PHYSICAL_DISCOVERY = "compute_Physical_discovery"
    SORT_PROP_COMPUTE_PHYSICAL_DISCOVERY_STATUS = "compute_Physical_discoveryStatus"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_DESCR = "compute_Physical_fsmDescr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_FLAGS = "compute_Physical_fsmFlags"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_PREV = "compute_Physical_fsmPrev"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_PROGR = "compute_Physical_fsmProgr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_INV_ERR_CODE = "compute_Physical_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_INV_ERR_DESCR = "compute_Physical_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_RMT_INV_RSLT = "compute_Physical_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAGE_DESCR = "compute_Physical_fsmStageDescr"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STAMP = "compute_Physical_fsmStamp"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_STATUS = "compute_Physical_fsmStatus"
    SORT_PROP_COMPUTE_PHYSICAL_FSM_TRY = "compute_Physical_fsmTry"
    SORT_PROP_COMPUTE_PHYSICAL_INT_ID = "compute_Physical_intId"
    SORT_PROP_COMPUTE_PHYSICAL_KMIP_FAULT = "compute_Physical_kmipFault"
    SORT_PROP_COMPUTE_PHYSICAL_KMIP_FAULT_DESCRIPTION = "compute_Physical_kmipFaultDescription"
    SORT_PROP_COMPUTE_PHYSICAL_LC = "compute_Physical_lc"
    SORT_PROP_COMPUTE_PHYSICAL_LC_TS = "compute_Physical_lcTs"
    SORT_PROP_COMPUTE_PHYSICAL_LOCAL_ID = "compute_Physical_localId"
    SORT_PROP_COMPUTE_PHYSICAL_LOW_VOLTAGE_MEMORY = "compute_Physical_lowVoltageMemory"
    SORT_PROP_COMPUTE_PHYSICAL_MANAGING_INST = "compute_Physical_managingInst"
    SORT_PROP_COMPUTE_PHYSICAL_MEMORY_SPEED = "compute_Physical_memorySpeed"
    SORT_PROP_COMPUTE_PHYSICAL_MFG_TIME = "compute_Physical_mfgTime"
    SORT_PROP_COMPUTE_PHYSICAL_MODEL = "compute_Physical_model"
    SORT_PROP_COMPUTE_PHYSICAL_NAME = "compute_Physical_name"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_Physical_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_Physical_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_ADAPTORS = "compute_Physical_numOfAdaptors"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CORES = "compute_Physical_numOfCores"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CORES_ENABLED = "compute_Physical_numOfCoresEnabled"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CPUS = "compute_Physical_numOfCpus"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_ETH_HOST_IFS = "compute_Physical_numOfEthHostIfs"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_FC_HOST_IFS = "compute_Physical_numOfFcHostIfs"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_THREADS = "compute_Physical_numOfThreads"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_POWER = "compute_Physical_operPower"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_PWR_TRANS_SRC = "compute_Physical_operPwrTransSrc"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_QUALIFIER = "compute_Physical_operQualifier"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_QUALIFIER_REASON = "compute_Physical_operQualifierReason"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_STATE = "compute_Physical_operState"
    SORT_PROP_COMPUTE_PHYSICAL_OPERABILITY = "compute_Physical_operability"
    SORT_PROP_COMPUTE_PHYSICAL_ORIGINAL_UUID = "compute_Physical_originalUuid"
    SORT_PROP_COMPUTE_PHYSICAL_PART_NUMBER = "compute_Physical_partNumber"
    SORT_PROP_COMPUTE_PHYSICAL_POLICY_LEVEL = "compute_Physical_policyLevel"
    SORT_PROP_COMPUTE_PHYSICAL_POLICY_OWNER = "compute_Physical_policyOwner"
    SORT_PROP_COMPUTE_PHYSICAL_PRESENCE = "compute_Physical_presence"
    SORT_PROP_COMPUTE_PHYSICAL_REVISION = "compute_Physical_revision"
    SORT_PROP_COMPUTE_PHYSICAL_SERIAL = "compute_Physical_serial"
    SORT_PROP_COMPUTE_PHYSICAL_SERVER_ID = "compute_Physical_serverId"
    SORT_PROP_COMPUTE_PHYSICAL_STORAGE_OPER_QUALIFIER = "compute_Physical_storageOperQualifier"
    SORT_PROP_COMPUTE_PHYSICAL_TOTAL_MEMORY = "compute_Physical_totalMemory"
    SORT_PROP_COMPUTE_PHYSICAL_USR_LBL = "compute_Physical_usrLbl"
    SORT_PROP_COMPUTE_PHYSICAL_UUID = "compute_Physical_uuid"
    SORT_PROP_COMPUTE_PHYSICAL_VENDOR = "compute_Physical_vendor"
    SORT_PROP_COMPUTE_PHYSICAL_VID = "compute_Physical_vid"
    SORT_PROP_COMPUTE_PLATFORM_MODEL = "compute_Platform_model"
    SORT_PROP_COMPUTE_PLATFORM_PRODUCT_NAME = "compute_Platform_productName"
    SORT_PROP_COMPUTE_PLATFORM_PROP_ACL = "compute_Platform_propAcl"
    SORT_PROP_COMPUTE_PLATFORM_REVISION = "compute_Platform_revision"
    SORT_PROP_COMPUTE_PLATFORM_VENDOR = "compute_Platform_vendor"
    SORT_PROP_COMPUTE_PNU_OSIMAGE_IMG_LOC = "compute_PnuOSImage_imgLoc"
    SORT_PROP_COMPUTE_PNU_OSIMAGE_IMG_NAME = "compute_PnuOSImage_imgName"
    SORT_PROP_COMPUTE_POOL_POLICY_REF_ID = "compute_PoolPolicyRef_id"
    SORT_PROP_COMPUTE_POOL_POLICY_REF_POLICY_DN = "compute_PoolPolicyRef_policyDn"
    SORT_PROP_COMPUTE_POOL_ASSIGNED = "compute_Pool_assigned"
    SORT_PROP_COMPUTE_POOL_ASSIGNMENT_ORDER = "compute_Pool_assignmentOrder"
    SORT_PROP_COMPUTE_POOL_DESCR = "compute_Pool_descr"
    SORT_PROP_COMPUTE_POOL_INT_ID = "compute_Pool_intId"
    SORT_PROP_COMPUTE_POOL_NAME = "compute_Pool_name"
    SORT_PROP_COMPUTE_POOL_POLICY_LEVEL = "compute_Pool_policyLevel"
    SORT_PROP_COMPUTE_POOL_POLICY_OWNER = "compute_Pool_policyOwner"
    SORT_PROP_COMPUTE_POOL_SIZE = "compute_Pool_size"
    SORT_PROP_COMPUTE_POOLABLE_ID = "compute_Poolable_id"
    SORT_PROP_COMPUTE_POOLABLE_POOL_DN = "compute_Poolable_poolDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_ASSIGNED = "compute_PooledEnclosureComputeSlot_assigned"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_ASSIGNED_TO_DN = "compute_PooledEnclosureComputeSlot_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_CHASSIS_ID = "compute_PooledEnclosureComputeSlot_chassisId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_OWNER = "compute_PooledEnclosureComputeSlot_owner"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_POOLABLE_DN = "compute_PooledEnclosureComputeSlot_poolableDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_PREV_ASSIGNED_TO_DN = "compute_PooledEnclosureComputeSlot_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_SERVER_INSTANCE_ID = "compute_PooledEnclosureComputeSlot_serverInstanceId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_SLOT_ID = "compute_PooledEnclosureComputeSlot_slotId"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_ASSIGNED = "compute_PooledPhysical_assigned"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_ASSIGNED_TO_DN = "compute_PooledPhysical_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_OWNER = "compute_PooledPhysical_owner"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_POOLABLE_DN = "compute_PooledPhysical_poolableDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_PREV_ASSIGNED_TO_DN = "compute_PooledPhysical_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ASSIGNED = "compute_PooledRackUnit_assigned"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ASSIGNED_TO_DN = "compute_PooledRackUnit_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ID = "compute_PooledRackUnit_id"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_OWNER = "compute_PooledRackUnit_owner"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_POOLABLE_DN = "compute_PooledRackUnit_poolableDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_PREV_ASSIGNED_TO_DN = "compute_PooledRackUnit_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_ASSIGNED = "compute_PooledSlot_assigned"
    SORT_PROP_COMPUTE_POOLED_SLOT_ASSIGNED_TO_DN = "compute_PooledSlot_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_CHASSIS_ID = "compute_PooledSlot_chassisId"
    SORT_PROP_COMPUTE_POOLED_SLOT_OWNER = "compute_PooledSlot_owner"
    SORT_PROP_COMPUTE_POOLED_SLOT_POOLABLE_DN = "compute_PooledSlot_poolableDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_PREV_ASSIGNED_TO_DN = "compute_PooledSlot_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_SLOT_ID = "compute_PooledSlot_slotId"
    SORT_PROP_COMPUTE_POOLED_ASSIGNED = "compute_Pooled_assigned"
    SORT_PROP_COMPUTE_POOLED_ASSIGNED_TO_DN = "compute_Pooled_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_OWNER = "compute_Pooled_owner"
    SORT_PROP_COMPUTE_POOLED_POOLABLE_DN = "compute_Pooled_poolableDn"
    SORT_PROP_COMPUTE_POOLED_PREV_ASSIGNED_TO_DN = "compute_Pooled_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLING_POLICY_DESCR = "compute_PoolingPolicy_descr"
    SORT_PROP_COMPUTE_POOLING_POLICY_INT_ID = "compute_PoolingPolicy_intId"
    SORT_PROP_COMPUTE_POOLING_POLICY_NAME = "compute_PoolingPolicy_name"
    SORT_PROP_COMPUTE_POOLING_POLICY_POLICY_LEVEL = "compute_PoolingPolicy_policyLevel"
    SORT_PROP_COMPUTE_POOLING_POLICY_POLICY_OWNER = "compute_PoolingPolicy_policyOwner"
    SORT_PROP_COMPUTE_POOLING_POLICY_POOL_DN = "compute_PoolingPolicy_poolDn"
    SORT_PROP_COMPUTE_POOLING_POLICY_QUALIFIER = "compute_PoolingPolicy_qualifier"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_DESCR = "compute_PortDiscPolicy_descr"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_ETH_BREAKOUT_AUTO_DISCOVERY = "compute_PortDiscPolicy_ethBreakoutAutoDiscovery"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_ETH_SVR_AUTO_DISCOVERY = "compute_PortDiscPolicy_ethSvrAutoDiscovery"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_INT_ID = "compute_PortDiscPolicy_intId"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_NAME = "compute_PortDiscPolicy_name"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_POLICY_LEVEL = "compute_PortDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_POLICY_OWNER = "compute_PortDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_QUALIFIER = "compute_PortDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_DESCR = "compute_PowerSavePolicy_descr"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_INT_ID = "compute_PowerSavePolicy_intId"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_MODE = "compute_PowerSavePolicy_mode"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_NAME = "compute_PowerSavePolicy_name"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_POLICY_LEVEL = "compute_PowerSavePolicy_policyLevel"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_POLICY_OWNER = "compute_PowerSavePolicy_policyOwner"
    SORT_PROP_COMPUTE_POWER_SAVE_POLICY_REDUNDANCY = "compute_PowerSavePolicy_redundancy"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_DESCR = "compute_PowerSyncDef_descr"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_INT_ID = "compute_PowerSyncDef_intId"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_NAME = "compute_PowerSyncDef_name"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_POLICY_LEVEL = "compute_PowerSyncDef_policyLevel"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_POLICY_OWNER = "compute_PowerSyncDef_policyOwner"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_SYNC_OPTION = "compute_PowerSyncDef_syncOption"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_DESCR = "compute_PowerSyncPolicy_descr"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_INT_ID = "compute_PowerSyncPolicy_intId"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_NAME = "compute_PowerSyncPolicy_name"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_POLICY_LEVEL = "compute_PowerSyncPolicy_policyLevel"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_POLICY_OWNER = "compute_PowerSyncPolicy_policyOwner"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_SYNC_OPTION = "compute_PowerSyncPolicy_syncOption"
    SORT_PROP_COMPUTE_PSU_CONTROL_CLUSTER_STATE = "compute_PsuControl_clusterState"
    SORT_PROP_COMPUTE_PSU_CONTROL_DESCR = "compute_PsuControl_descr"
    SORT_PROP_COMPUTE_PSU_CONTROL_INPUT_POWER_STATE = "compute_PsuControl_inputPowerState"
    SORT_PROP_COMPUTE_PSU_CONTROL_INT_ID = "compute_PsuControl_intId"
    SORT_PROP_COMPUTE_PSU_CONTROL_MODE = "compute_PsuControl_mode"
    SORT_PROP_COMPUTE_PSU_CONTROL_NAME = "compute_PsuControl_name"
    SORT_PROP_COMPUTE_PSU_CONTROL_OPER_QUALIFIER = "compute_PsuControl_operQualifier"
    SORT_PROP_COMPUTE_PSU_CONTROL_OPER_STATE = "compute_PsuControl_operState"
    SORT_PROP_COMPUTE_PSU_CONTROL_OUTPUT_POWER_STATE = "compute_PsuControl_outputPowerState"
    SORT_PROP_COMPUTE_PSU_CONTROL_POLICY_LEVEL = "compute_PsuControl_policyLevel"
    SORT_PROP_COMPUTE_PSU_CONTROL_POLICY_OWNER = "compute_PsuControl_policyOwner"
    SORT_PROP_COMPUTE_PSU_CONTROL_REDUNDANCY = "compute_PsuControl_redundancy"
    SORT_PROP_COMPUTE_PSU_DEF_DESCR = "compute_PsuDef_descr"
    SORT_PROP_COMPUTE_PSU_DEF_INT_ID = "compute_PsuDef_intId"
    SORT_PROP_COMPUTE_PSU_DEF_MODE = "compute_PsuDef_mode"
    SORT_PROP_COMPUTE_PSU_DEF_NAME = "compute_PsuDef_name"
    SORT_PROP_COMPUTE_PSU_DEF_POLICY_LEVEL = "compute_PsuDef_policyLevel"
    SORT_PROP_COMPUTE_PSU_DEF_POLICY_OWNER = "compute_PsuDef_policyOwner"
    SORT_PROP_COMPUTE_PSU_DEF_REDUNDANCY = "compute_PsuDef_redundancy"
    SORT_PROP_COMPUTE_PSU_POLICY_DESCR = "compute_PsuPolicy_descr"
    SORT_PROP_COMPUTE_PSU_POLICY_INT_ID = "compute_PsuPolicy_intId"
    SORT_PROP_COMPUTE_PSU_POLICY_MODE = "compute_PsuPolicy_mode"
    SORT_PROP_COMPUTE_PSU_POLICY_NAME = "compute_PsuPolicy_name"
    SORT_PROP_COMPUTE_PSU_POLICY_POLICY_LEVEL = "compute_PsuPolicy_policyLevel"
    SORT_PROP_COMPUTE_PSU_POLICY_POLICY_OWNER = "compute_PsuPolicy_policyOwner"
    SORT_PROP_COMPUTE_PSU_POLICY_REDUNDANCY = "compute_PsuPolicy_redundancy"
    SORT_PROP_COMPUTE_QUAL_BASE_DESCR = "compute_QualBase_descr"
    SORT_PROP_COMPUTE_QUAL_BASE_INT_ID = "compute_QualBase_intId"
    SORT_PROP_COMPUTE_QUAL_BASE_NAME = "compute_QualBase_name"
    SORT_PROP_COMPUTE_QUAL_BASE_POLICY_LEVEL = "compute_QualBase_policyLevel"
    SORT_PROP_COMPUTE_QUAL_BASE_POLICY_OWNER = "compute_QualBase_policyOwner"
    SORT_PROP_COMPUTE_QUAL_DESCR = "compute_Qual_descr"
    SORT_PROP_COMPUTE_QUAL_INT_ID = "compute_Qual_intId"
    SORT_PROP_COMPUTE_QUAL_NAME = "compute_Qual_name"
    SORT_PROP_COMPUTE_QUAL_POLICY_LEVEL = "compute_Qual_policyLevel"
    SORT_PROP_COMPUTE_QUAL_POLICY_OWNER = "compute_Qual_policyOwner"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_DESCR = "compute_QualifiedPolicy_descr"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_INT_ID = "compute_QualifiedPolicy_intId"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_NAME = "compute_QualifiedPolicy_name"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_POLICY_LEVEL = "compute_QualifiedPolicy_policyLevel"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_POLICY_OWNER = "compute_QualifiedPolicy_policyOwner"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_QUALIFIER = "compute_QualifiedPolicy_qualifier"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_DESCR = "compute_RackConnLinkPolicy_descr"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_INT_ID = "compute_RackConnLinkPolicy_intId"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_LINK_GROUPING = "compute_RackConnLinkPolicy_linkGrouping"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_NAME = "compute_RackConnLinkPolicy_name"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_POLICY_LEVEL = "compute_RackConnLinkPolicy_policyLevel"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_POLICY_OWNER = "compute_RackConnLinkPolicy_policyOwner"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_QUALIFIER = "compute_RackConnLinkPolicy_qualifier"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_RACK_ID = "compute_RackConnLinkPolicy_rackId"
    SORT_PROP_COMPUTE_RACK_CONN_LINK_POLICY_SWITCH_ID = "compute_RackConnLinkPolicy_switchId"
    SORT_PROP_COMPUTE_RACK_POS_QUAL_MAX_ID = "compute_RackPosQual_maxId"
    SORT_PROP_COMPUTE_RACK_POS_QUAL_MIN_ID = "compute_RackPosQual_minId"
    SORT_PROP_COMPUTE_RACK_QUAL_MAX_ID = "compute_RackQual_maxId"
    SORT_PROP_COMPUTE_RACK_QUAL_MIN_ID = "compute_RackQual_minId"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_DESCR = "compute_RackUnitFsmStage_descr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_LAST_UPDATE_TIME = "compute_RackUnitFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_NAME = "compute_RackUnitFsmStage_name"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_ORDER = "compute_RackUnitFsmStage_order"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_RETRY = "compute_RackUnitFsmStage_retry"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_STAGE_STATUS = "compute_RackUnitFsmStage_stageStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_TASK_COMPLETION = "compute_RackUnitFsmTask_completion"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_TASK_FLAGS = "compute_RackUnitFsmTask_flags"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_TASK_ITEM = "compute_RackUnitFsmTask_item"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_TASK_SEQ_ID = "compute_RackUnitFsmTask_seqId"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_COMPLETION_TIME = "compute_RackUnitFsm_completionTime"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_CURRENT_FSM = "compute_RackUnitFsm_currentFsm"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_DESCR = "compute_RackUnitFsm_descr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_FSM_STATUS = "compute_RackUnitFsm_fsmStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_INSTANCE_ID = "compute_RackUnitFsm_instanceId"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_PROGRESS = "compute_RackUnitFsm_progress"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_ERR_CODE = "compute_RackUnitFsm_rmtErrCode"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_ERR_DESCR = "compute_RackUnitFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_RSLT = "compute_RackUnitFsm_rmtRslt"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP = "compute_RackUnitMbTempStatsHist_ambientTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ambientTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ambientTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ambientTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP = "compute_RackUnitMbTempStatsHist_frontTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_frontTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_frontTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_frontTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_ID = "compute_RackUnitMbTempStatsHist_id"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP = "compute_RackUnitMbTempStatsHist_ioh1Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh1TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh1TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh1TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP = "compute_RackUnitMbTempStatsHist_ioh2Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh2TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh2TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh2TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_RackUnitMbTempStatsHist_mostRecent"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP = "compute_RackUnitMbTempStatsHist_rearTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_AVG = "compute_RackUnitMbTempStatsHist_rearTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MAX = "compute_RackUnitMbTempStatsHist_rearTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MIN = "compute_RackUnitMbTempStatsHist_rearTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_SUSPECT = "compute_RackUnitMbTempStatsHist_suspect"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_RackUnitMbTempStatsHist_thresholded"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_RackUnitMbTempStatsHist_timeCollected"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP = "compute_RackUnitMbTempStats_ambientTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStats_ambientTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStats_ambientTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStats_ambientTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP = "compute_RackUnitMbTempStats_frontTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_AVG = "compute_RackUnitMbTempStats_frontTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MAX = "compute_RackUnitMbTempStats_frontTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MIN = "compute_RackUnitMbTempStats_frontTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_INTERVALS = "compute_RackUnitMbTempStats_intervals"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP = "compute_RackUnitMbTempStats_ioh1Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_AVG = "compute_RackUnitMbTempStats_ioh1TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MAX = "compute_RackUnitMbTempStats_ioh1TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MIN = "compute_RackUnitMbTempStats_ioh1TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP = "compute_RackUnitMbTempStats_ioh2Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_AVG = "compute_RackUnitMbTempStats_ioh2TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MAX = "compute_RackUnitMbTempStats_ioh2TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MIN = "compute_RackUnitMbTempStats_ioh2TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP = "compute_RackUnitMbTempStats_rearTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_AVG = "compute_RackUnitMbTempStats_rearTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MAX = "compute_RackUnitMbTempStats_rearTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MIN = "compute_RackUnitMbTempStats_rearTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_SUSPECT = "compute_RackUnitMbTempStats_suspect"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_THRESHOLDED = "compute_RackUnitMbTempStats_thresholded"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_TIME_COLLECTED = "compute_RackUnitMbTempStats_timeCollected"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_UPDATE = "compute_RackUnitMbTempStats_update"
    SORT_PROP_COMPUTE_RACK_UNIT_ADMIN_POWER = "compute_RackUnit_adminPower"
    SORT_PROP_COMPUTE_RACK_UNIT_ADMIN_STATE = "compute_RackUnit_adminState"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSET_TAG = "compute_RackUnit_assetTag"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSIGNED_TO_DN = "compute_RackUnit_assignedToDn"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSOCIATION = "compute_RackUnit_association"
    SORT_PROP_COMPUTE_RACK_UNIT_AVAILABILITY = "compute_RackUnit_availability"
    SORT_PROP_COMPUTE_RACK_UNIT_AVAILABLE_MEMORY = "compute_RackUnit_availableMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_CHECK_POINT = "compute_RackUnit_checkPoint"
    SORT_PROP_COMPUTE_RACK_UNIT_CONN_PATH = "compute_RackUnit_connPath"
    SORT_PROP_COMPUTE_RACK_UNIT_CONN_STATUS = "compute_RackUnit_connStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_DESCR = "compute_RackUnit_descr"
    SORT_PROP_COMPUTE_RACK_UNIT_DISCOVERY = "compute_RackUnit_discovery"
    SORT_PROP_COMPUTE_RACK_UNIT_DISCOVERY_STATUS = "compute_RackUnit_discoveryStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_ENCLOSURE_ID = "compute_RackUnit_enclosureId"
    SORT_PROP_COMPUTE_RACK_UNIT_FAN_SPEED_CONFIG_STATUS = "compute_RackUnit_fanSpeedConfigStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_FAN_SPEED_POLICY_FAULT = "compute_RackUnit_fanSpeedPolicyFault"
    SORT_PROP_COMPUTE_RACK_UNIT_FLT_AGGR = "compute_RackUnit_fltAggr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_DESCR = "compute_RackUnit_fsmDescr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_FLAGS = "compute_RackUnit_fsmFlags"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_PREV = "compute_RackUnit_fsmPrev"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_PROGR = "compute_RackUnit_fsmProgr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_INV_ERR_CODE = "compute_RackUnit_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_INV_ERR_DESCR = "compute_RackUnit_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_RMT_INV_RSLT = "compute_RackUnit_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAGE_DESCR = "compute_RackUnit_fsmStageDescr"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STAMP = "compute_RackUnit_fsmStamp"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_STATUS = "compute_RackUnit_fsmStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_FSM_TRY = "compute_RackUnit_fsmTry"
    SORT_PROP_COMPUTE_RACK_UNIT_ID = "compute_RackUnit_id"
    SORT_PROP_COMPUTE_RACK_UNIT_INT_ID = "compute_RackUnit_intId"
    SORT_PROP_COMPUTE_RACK_UNIT_KMIP_FAULT = "compute_RackUnit_kmipFault"
    SORT_PROP_COMPUTE_RACK_UNIT_KMIP_FAULT_DESCRIPTION = "compute_RackUnit_kmipFaultDescription"
    SORT_PROP_COMPUTE_RACK_UNIT_LC = "compute_RackUnit_lc"
    SORT_PROP_COMPUTE_RACK_UNIT_LC_TS = "compute_RackUnit_lcTs"
    SORT_PROP_COMPUTE_RACK_UNIT_LOCAL_ID = "compute_RackUnit_localId"
    SORT_PROP_COMPUTE_RACK_UNIT_LOW_VOLTAGE_MEMORY = "compute_RackUnit_lowVoltageMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_MANAGING_INST = "compute_RackUnit_managingInst"
    SORT_PROP_COMPUTE_RACK_UNIT_MEMORY_SPEED = "compute_RackUnit_memorySpeed"
    SORT_PROP_COMPUTE_RACK_UNIT_MFG_TIME = "compute_RackUnit_mfgTime"
    SORT_PROP_COMPUTE_RACK_UNIT_MODEL = "compute_RackUnit_model"
    SORT_PROP_COMPUTE_RACK_UNIT_NAME = "compute_RackUnit_name"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_RackUnit_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_RackUnit_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_ADAPTORS = "compute_RackUnit_numOfAdaptors"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CORES = "compute_RackUnit_numOfCores"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CORES_ENABLED = "compute_RackUnit_numOfCoresEnabled"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CPUS = "compute_RackUnit_numOfCpus"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_ETH_HOST_IFS = "compute_RackUnit_numOfEthHostIfs"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_FC_HOST_IFS = "compute_RackUnit_numOfFcHostIfs"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_THREADS = "compute_RackUnit_numOfThreads"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_POWER = "compute_RackUnit_operPower"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_PWR_TRANS_SRC = "compute_RackUnit_operPwrTransSrc"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_QUALIFIER = "compute_RackUnit_operQualifier"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_QUALIFIER_REASON = "compute_RackUnit_operQualifierReason"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_STATE = "compute_RackUnit_operState"
    SORT_PROP_COMPUTE_RACK_UNIT_OPERABILITY = "compute_RackUnit_operability"
    SORT_PROP_COMPUTE_RACK_UNIT_ORIGINAL_UUID = "compute_RackUnit_originalUuid"
    SORT_PROP_COMPUTE_RACK_UNIT_PART_NUMBER = "compute_RackUnit_partNumber"
    SORT_PROP_COMPUTE_RACK_UNIT_PHYSICAL_SECURITY = "compute_RackUnit_physicalSecurity"
    SORT_PROP_COMPUTE_RACK_UNIT_POLICY_LEVEL = "compute_RackUnit_policyLevel"
    SORT_PROP_COMPUTE_RACK_UNIT_POLICY_OWNER = "compute_RackUnit_policyOwner"
    SORT_PROP_COMPUTE_RACK_UNIT_PRESENCE = "compute_RackUnit_presence"
    SORT_PROP_COMPUTE_RACK_UNIT_REVISION = "compute_RackUnit_revision"
    SORT_PROP_COMPUTE_RACK_UNIT_SERIAL = "compute_RackUnit_serial"
    SORT_PROP_COMPUTE_RACK_UNIT_SERVER_ID = "compute_RackUnit_serverId"
    SORT_PROP_COMPUTE_RACK_UNIT_SLOT_ID = "compute_RackUnit_slotId"
    SORT_PROP_COMPUTE_RACK_UNIT_STORAGE_OPER_QUALIFIER = "compute_RackUnit_storageOperQualifier"
    SORT_PROP_COMPUTE_RACK_UNIT_TOTAL_MEMORY = "compute_RackUnit_totalMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_USR_LBL = "compute_RackUnit_usrLbl"
    SORT_PROP_COMPUTE_RACK_UNIT_UUID = "compute_RackUnit_uuid"
    SORT_PROP_COMPUTE_RACK_UNIT_VENDOR = "compute_RackUnit_vendor"
    SORT_PROP_COMPUTE_RACK_UNIT_VERSION_HOLDER = "compute_RackUnit_versionHolder"
    SORT_PROP_COMPUTE_RACK_UNIT_VETH_STATUS = "compute_RackUnit_vethStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_VID = "compute_RackUnit_vid"
    SORT_PROP_COMPUTE_REBOOT_LOG_COUNT = "compute_RebootLog_count"
    SORT_PROP_COMPUTE_REBOOT_LOG_ID = "compute_RebootLog_id"
    SORT_PROP_COMPUTE_REBOOT_LOG_PWR_CHANGE_SRC = "compute_RebootLog_pwrChangeSrc"
    SORT_PROP_COMPUTE_REBOOT_LOG_TIME_STAMP = "compute_RebootLog_timeStamp"
    SORT_PROP_COMPUTE_RTC_BATTERY_ID = "compute_RtcBattery_id"
    SORT_PROP_COMPUTE_RTC_BATTERY_LOCATION_DN = "compute_RtcBattery_locationDn"
    SORT_PROP_COMPUTE_RTC_BATTERY_MODEL = "compute_RtcBattery_model"
    SORT_PROP_COMPUTE_RTC_BATTERY_OPER_QUALIFIER_REASON = "compute_RtcBattery_operQualifierReason"
    SORT_PROP_COMPUTE_RTC_BATTERY_OPER_STATE = "compute_RtcBattery_operState"
    SORT_PROP_COMPUTE_RTC_BATTERY_OPERABILITY = "compute_RtcBattery_operability"
    SORT_PROP_COMPUTE_RTC_BATTERY_PERF = "compute_RtcBattery_perf"
    SORT_PROP_COMPUTE_RTC_BATTERY_POWER = "compute_RtcBattery_power"
    SORT_PROP_COMPUTE_RTC_BATTERY_PRESENCE = "compute_RtcBattery_presence"
    SORT_PROP_COMPUTE_RTC_BATTERY_REVISION = "compute_RtcBattery_revision"
    SORT_PROP_COMPUTE_RTC_BATTERY_SERIAL = "compute_RtcBattery_serial"
    SORT_PROP_COMPUTE_RTC_BATTERY_THERMAL = "compute_RtcBattery_thermal"
    SORT_PROP_COMPUTE_RTC_BATTERY_VENDOR = "compute_RtcBattery_vendor"
    SORT_PROP_COMPUTE_RTC_BATTERY_VOLTAGE = "compute_RtcBattery_voltage"
    SORT_PROP_COMPUTE_SCRUB_POLICY_BIOS_SETTINGS_SCRUB = "compute_ScrubPolicy_biosSettingsScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_DESCR = "compute_ScrubPolicy_descr"
    SORT_PROP_COMPUTE_SCRUB_POLICY_DISK_SCRUB = "compute_ScrubPolicy_diskScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_FLEX_FLASH_SCRUB = "compute_ScrubPolicy_flexFlashScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_INT_ID = "compute_ScrubPolicy_intId"
    SORT_PROP_COMPUTE_SCRUB_POLICY_NAME = "compute_ScrubPolicy_name"
    SORT_PROP_COMPUTE_SCRUB_POLICY_PERSISTENT_MEMORY_SCRUB = "compute_ScrubPolicy_persistentMemoryScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_POLICY_LEVEL = "compute_ScrubPolicy_policyLevel"
    SORT_PROP_COMPUTE_SCRUB_POLICY_POLICY_OWNER = "compute_ScrubPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_DESCR = "compute_ServerDiscPolicyFsmStage_descr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_LAST_UPDATE_TIME = "compute_ServerDiscPolicyFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_NAME = "compute_ServerDiscPolicyFsmStage_name"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_ORDER = "compute_ServerDiscPolicyFsmStage_order"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_RETRY = "compute_ServerDiscPolicyFsmStage_retry"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_STAGE_STATUS = "compute_ServerDiscPolicyFsmStage_stageStatus"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_COMPLETION = "compute_ServerDiscPolicyFsmTask_completion"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_FLAGS = "compute_ServerDiscPolicyFsmTask_flags"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_ITEM = "compute_ServerDiscPolicyFsmTask_item"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_SEQ_ID = "compute_ServerDiscPolicyFsmTask_seqId"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_COMPLETION_TIME = "compute_ServerDiscPolicyFsm_completionTime"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_CURRENT_FSM = "compute_ServerDiscPolicyFsm_currentFsm"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_DESCR = "compute_ServerDiscPolicyFsm_descr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_FSM_STATUS = "compute_ServerDiscPolicyFsm_fsmStatus"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_INSTANCE_ID = "compute_ServerDiscPolicyFsm_instanceId"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_PROGRESS = "compute_ServerDiscPolicyFsm_progress"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_ERR_CODE = "compute_ServerDiscPolicyFsm_rmtErrCode"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_ERR_DESCR = "compute_ServerDiscPolicyFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_RSLT = "compute_ServerDiscPolicyFsm_rmtRslt"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_ACTION = "compute_ServerDiscPolicy_action"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_DESCR = "compute_ServerDiscPolicy_descr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_DESCR = "compute_ServerDiscPolicy_fsmDescr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_PREV = "compute_ServerDiscPolicy_fsmPrev"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_PROGR = "compute_ServerDiscPolicy_fsmProgr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_ERR_CODE = "compute_ServerDiscPolicy_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_ERR_DESCR = "compute_ServerDiscPolicy_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_RSLT = "compute_ServerDiscPolicy_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_DESCR = "compute_ServerDiscPolicy_fsmStageDescr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STAMP = "compute_ServerDiscPolicy_fsmStamp"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_STATUS = "compute_ServerDiscPolicy_fsmStatus"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_FSM_TRY = "compute_ServerDiscPolicy_fsmTry"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_INT_ID = "compute_ServerDiscPolicy_intId"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_NAME = "compute_ServerDiscPolicy_name"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_POLICY_LEVEL = "compute_ServerDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_POLICY_OWNER = "compute_ServerDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_QUALIFIER = "compute_ServerDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ServerDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_ACTION = "compute_ServerMgmtPolicy_action"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_DESCR = "compute_ServerMgmtPolicy_descr"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_INT_ID = "compute_ServerMgmtPolicy_intId"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_LINK_GROUPING = "compute_ServerMgmtPolicy_linkGrouping"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_NAME = "compute_ServerMgmtPolicy_name"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_POLICY_LEVEL = "compute_ServerMgmtPolicy_policyLevel"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_POLICY_OWNER = "compute_ServerMgmtPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_QUALIFIER = "compute_ServerMgmtPolicy_qualifier"
    SORT_PROP_COMPUTE_SERVER_TYPE_CAP_TYPE = "compute_ServerTypeCap_type"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_DESCR = "compute_ServerUnitFsmStage_descr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_LAST_UPDATE_TIME = "compute_ServerUnitFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_NAME = "compute_ServerUnitFsmStage_name"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_ORDER = "compute_ServerUnitFsmStage_order"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_RETRY = "compute_ServerUnitFsmStage_retry"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_STAGE_STATUS = "compute_ServerUnitFsmStage_stageStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_TASK_COMPLETION = "compute_ServerUnitFsmTask_completion"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_TASK_FLAGS = "compute_ServerUnitFsmTask_flags"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_TASK_ITEM = "compute_ServerUnitFsmTask_item"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_TASK_SEQ_ID = "compute_ServerUnitFsmTask_seqId"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_COMPLETION_TIME = "compute_ServerUnitFsm_completionTime"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_CURRENT_FSM = "compute_ServerUnitFsm_currentFsm"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_DESCR = "compute_ServerUnitFsm_descr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_FSM_STATUS = "compute_ServerUnitFsm_fsmStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_INSTANCE_ID = "compute_ServerUnitFsm_instanceId"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_PROGRESS = "compute_ServerUnitFsm_progress"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_ERR_CODE = "compute_ServerUnitFsm_rmtErrCode"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_ERR_DESCR = "compute_ServerUnitFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_RSLT = "compute_ServerUnitFsm_rmtRslt"
    SORT_PROP_COMPUTE_SERVER_UNIT_ADMIN_POWER = "compute_ServerUnit_adminPower"
    SORT_PROP_COMPUTE_SERVER_UNIT_ADMIN_STATE = "compute_ServerUnit_adminState"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSET_TAG = "compute_ServerUnit_assetTag"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSIGNED_TO_DN = "compute_ServerUnit_assignedToDn"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSOCIATION = "compute_ServerUnit_association"
    SORT_PROP_COMPUTE_SERVER_UNIT_AVAILABILITY = "compute_ServerUnit_availability"
    SORT_PROP_COMPUTE_SERVER_UNIT_AVAILABLE_MEMORY = "compute_ServerUnit_availableMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_CHASSIS_ID = "compute_ServerUnit_chassisId"
    SORT_PROP_COMPUTE_SERVER_UNIT_CHECK_POINT = "compute_ServerUnit_checkPoint"
    SORT_PROP_COMPUTE_SERVER_UNIT_CONN_PATH = "compute_ServerUnit_connPath"
    SORT_PROP_COMPUTE_SERVER_UNIT_CONN_STATUS = "compute_ServerUnit_connStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_DESCR = "compute_ServerUnit_descr"
    SORT_PROP_COMPUTE_SERVER_UNIT_DISCOVERY = "compute_ServerUnit_discovery"
    SORT_PROP_COMPUTE_SERVER_UNIT_DISCOVERY_STATUS = "compute_ServerUnit_discoveryStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_FLT_AGGR = "compute_ServerUnit_fltAggr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_DESCR = "compute_ServerUnit_fsmDescr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_FLAGS = "compute_ServerUnit_fsmFlags"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_PREV = "compute_ServerUnit_fsmPrev"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_PROGR = "compute_ServerUnit_fsmProgr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_INV_ERR_CODE = "compute_ServerUnit_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_INV_ERR_DESCR = "compute_ServerUnit_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_RMT_INV_RSLT = "compute_ServerUnit_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAGE_DESCR = "compute_ServerUnit_fsmStageDescr"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STAMP = "compute_ServerUnit_fsmStamp"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_STATUS = "compute_ServerUnit_fsmStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_FSM_TRY = "compute_ServerUnit_fsmTry"
    SORT_PROP_COMPUTE_SERVER_UNIT_INT_ID = "compute_ServerUnit_intId"
    SORT_PROP_COMPUTE_SERVER_UNIT_KMIP_FAULT = "compute_ServerUnit_kmipFault"
    SORT_PROP_COMPUTE_SERVER_UNIT_KMIP_FAULT_DESCRIPTION = "compute_ServerUnit_kmipFaultDescription"
    SORT_PROP_COMPUTE_SERVER_UNIT_LC = "compute_ServerUnit_lc"
    SORT_PROP_COMPUTE_SERVER_UNIT_LC_TS = "compute_ServerUnit_lcTs"
    SORT_PROP_COMPUTE_SERVER_UNIT_LOCAL_ID = "compute_ServerUnit_localId"
    SORT_PROP_COMPUTE_SERVER_UNIT_LOW_VOLTAGE_MEMORY = "compute_ServerUnit_lowVoltageMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_MANAGING_INST = "compute_ServerUnit_managingInst"
    SORT_PROP_COMPUTE_SERVER_UNIT_MEMORY_SPEED = "compute_ServerUnit_memorySpeed"
    SORT_PROP_COMPUTE_SERVER_UNIT_MFG_TIME = "compute_ServerUnit_mfgTime"
    SORT_PROP_COMPUTE_SERVER_UNIT_MODEL = "compute_ServerUnit_model"
    SORT_PROP_COMPUTE_SERVER_UNIT_NAME = "compute_ServerUnit_name"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_ServerUnit_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_ServerUnit_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_ADAPTORS = "compute_ServerUnit_numOfAdaptors"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CORES = "compute_ServerUnit_numOfCores"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CORES_ENABLED = "compute_ServerUnit_numOfCoresEnabled"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CPUS = "compute_ServerUnit_numOfCpus"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_ETH_HOST_IFS = "compute_ServerUnit_numOfEthHostIfs"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_FC_HOST_IFS = "compute_ServerUnit_numOfFcHostIfs"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_THREADS = "compute_ServerUnit_numOfThreads"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_POWER = "compute_ServerUnit_operPower"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_PWR_TRANS_SRC = "compute_ServerUnit_operPwrTransSrc"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_QUALIFIER = "compute_ServerUnit_operQualifier"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_QUALIFIER_REASON = "compute_ServerUnit_operQualifierReason"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_STATE = "compute_ServerUnit_operState"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPERABILITY = "compute_ServerUnit_operability"
    SORT_PROP_COMPUTE_SERVER_UNIT_ORIGINAL_UUID = "compute_ServerUnit_originalUuid"
    SORT_PROP_COMPUTE_SERVER_UNIT_PART_NUMBER = "compute_ServerUnit_partNumber"
    SORT_PROP_COMPUTE_SERVER_UNIT_POLICY_LEVEL = "compute_ServerUnit_policyLevel"
    SORT_PROP_COMPUTE_SERVER_UNIT_POLICY_OWNER = "compute_ServerUnit_policyOwner"
    SORT_PROP_COMPUTE_SERVER_UNIT_PRESENCE = "compute_ServerUnit_presence"
    SORT_PROP_COMPUTE_SERVER_UNIT_REVISION = "compute_ServerUnit_revision"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERIAL = "compute_ServerUnit_serial"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERVER_ID = "compute_ServerUnit_serverId"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERVER_INSTANCE_ID = "compute_ServerUnit_serverInstanceId"
    SORT_PROP_COMPUTE_SERVER_UNIT_SLOT_ID = "compute_ServerUnit_slotId"
    SORT_PROP_COMPUTE_SERVER_UNIT_STORAGE_OPER_QUALIFIER = "compute_ServerUnit_storageOperQualifier"
    SORT_PROP_COMPUTE_SERVER_UNIT_TOTAL_MEMORY = "compute_ServerUnit_totalMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_USR_LBL = "compute_ServerUnit_usrLbl"
    SORT_PROP_COMPUTE_SERVER_UNIT_UUID = "compute_ServerUnit_uuid"
    SORT_PROP_COMPUTE_SERVER_UNIT_VENDOR = "compute_ServerUnit_vendor"
    SORT_PROP_COMPUTE_SERVER_UNIT_VID = "compute_ServerUnit_vid"
    SORT_PROP_COMPUTE_SERVER_ASSIGN_STATE = "compute_Server_assignState"
    SORT_PROP_COMPUTE_SERVER_ASSOC_STATE = "compute_Server_assocState"
    SORT_PROP_COMPUTE_SERVER_DESCR = "compute_Server_descr"
    SORT_PROP_COMPUTE_SERVER_INT_ID = "compute_Server_intId"
    SORT_PROP_COMPUTE_SERVER_NAME = "compute_Server_name"
    SORT_PROP_COMPUTE_SERVER_PN_DN = "compute_Server_pnDn"
    SORT_PROP_COMPUTE_SERVER_POLICY_LEVEL = "compute_Server_policyLevel"
    SORT_PROP_COMPUTE_SERVER_POLICY_OWNER = "compute_Server_policyOwner"
    SORT_PROP_COMPUTE_SERVER_UUID = "compute_Server_uuid"
    SORT_PROP_COMPUTE_SLOT_ENTITY_ID = "compute_SlotEntity_id"
    SORT_PROP_COMPUTE_SLOT_ENTITY_MODEL = "compute_SlotEntity_model"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPER_QUALIFIER_REASON = "compute_SlotEntity_operQualifierReason"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPER_STATE = "compute_SlotEntity_operState"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPERABILITY = "compute_SlotEntity_operability"
    SORT_PROP_COMPUTE_SLOT_ENTITY_PERF = "compute_SlotEntity_perf"
    SORT_PROP_COMPUTE_SLOT_ENTITY_POWER = "compute_SlotEntity_power"
    SORT_PROP_COMPUTE_SLOT_ENTITY_PRESENCE = "compute_SlotEntity_presence"
    SORT_PROP_COMPUTE_SLOT_ENTITY_REVISION = "compute_SlotEntity_revision"
    SORT_PROP_COMPUTE_SLOT_ENTITY_SERIAL = "compute_SlotEntity_serial"
    SORT_PROP_COMPUTE_SLOT_ENTITY_THERMAL = "compute_SlotEntity_thermal"
    SORT_PROP_COMPUTE_SLOT_ENTITY_VENDOR = "compute_SlotEntity_vendor"
    SORT_PROP_COMPUTE_SLOT_ENTITY_VOLTAGE = "compute_SlotEntity_voltage"
    SORT_PROP_COMPUTE_SLOT_QUAL_MAX_ID = "compute_SlotQual_maxId"
    SORT_PROP_COMPUTE_SLOT_QUAL_MIN_ID = "compute_SlotQual_minId"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_DESCR = "compute_VirtualContainer_descr"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_INT_ID = "compute_VirtualContainer_intId"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_LS_DN = "compute_VirtualContainer_lsDn"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_NAME = "compute_VirtualContainer_name"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_PN_DN = "compute_VirtualContainer_pnDn"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_POLICY_LEVEL = "compute_VirtualContainer_policyLevel"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_POLICY_OWNER = "compute_VirtualContainer_policyOwner"
    SORT_PROP_COMPUTE_VIRTUAL_CONTAINER_UUID = "compute_VirtualContainer_uuid"
    SORT_PROP_COMPUTE_VIRTUAL_DESCR = "compute_Virtual_descr"
    SORT_PROP_COMPUTE_VIRTUAL_INT_ID = "compute_Virtual_intId"
    SORT_PROP_COMPUTE_VIRTUAL_LS_DN = "compute_Virtual_lsDn"
    SORT_PROP_COMPUTE_VIRTUAL_NAME = "compute_Virtual_name"
    SORT_PROP_COMPUTE_VIRTUAL_PN_DN = "compute_Virtual_pnDn"
    SORT_PROP_COMPUTE_VIRTUAL_POLICY_LEVEL = "compute_Virtual_policyLevel"
    SORT_PROP_COMPUTE_VIRTUAL_POLICY_OWNER = "compute_Virtual_policyOwner"
    SORT_PROP_COMPUTE_VIRTUAL_UUID = "compute_Virtual_uuid"
    SORT_PROP_CONDITION_IMMUTABLE_CAUSE = "condition_Immutable_cause"
    SORT_PROP_CONDITION_IMMUTABLE_CHANGE_SET = "condition_Immutable_changeSet"
    SORT_PROP_CONDITION_IMMUTABLE_CODE = "condition_Immutable_code"
    SORT_PROP_CONDITION_IMMUTABLE_CREATED = "condition_Immutable_created"
    SORT_PROP_CONDITION_IMMUTABLE_DESCR = "condition_Immutable_descr"
    SORT_PROP_CONDITION_IMMUTABLE_ID = "condition_Immutable_id"
    SORT_PROP_CONDITION_IMMUTABLE_RULE = "condition_Immutable_rule"
    SORT_PROP_CONDITION_IMMUTABLE_SEVERITY = "condition_Immutable_severity"
    SORT_PROP_CONDITION_IMMUTABLE_TAGS = "condition_Immutable_tags"
    SORT_PROP_CONDITION_IMMUTABLE_TYPE = "condition_Immutable_type"
    SORT_PROP_CONDITION_INFO_CAUSE = "condition_Info_cause"
    SORT_PROP_CONDITION_INFO_CHANGE_SET = "condition_Info_changeSet"
    SORT_PROP_CONDITION_INFO_CODE = "condition_Info_code"
    SORT_PROP_CONDITION_INFO_CREATED = "condition_Info_created"
    SORT_PROP_CONDITION_INFO_DESCR = "condition_Info_descr"
    SORT_PROP_CONDITION_INFO_SEVERITY = "condition_Info_severity"
    SORT_PROP_CONDITION_LOG_MAX_SIZE = "condition_Log_maxSize"
    SORT_PROP_CONDITION_LOG_PURGE_WINDOW = "condition_Log_purgeWindow"
    SORT_PROP_CONDITION_LOG_SIZE = "condition_Log_size"
    SORT_PROP_CONDITION_LOGGABLE_AFFECTED = "condition_Loggable_affected"
    SORT_PROP_CONDITION_LOGGABLE_CAUSE = "condition_Loggable_cause"
    SORT_PROP_CONDITION_LOGGABLE_CHANGE_SET = "condition_Loggable_changeSet"
    SORT_PROP_CONDITION_LOGGABLE_CODE = "condition_Loggable_code"
    SORT_PROP_CONDITION_LOGGABLE_CREATED = "condition_Loggable_created"
    SORT_PROP_CONDITION_LOGGABLE_DESCR = "condition_Loggable_descr"
    SORT_PROP_CONDITION_LOGGABLE_ID = "condition_Loggable_id"
    SORT_PROP_CONDITION_LOGGABLE_IND = "condition_Loggable_ind"
    SORT_PROP_CONDITION_LOGGABLE_SESSION_ID = "condition_Loggable_sessionId"
    SORT_PROP_CONDITION_LOGGABLE_SEVERITY = "condition_Loggable_severity"
    SORT_PROP_CONDITION_LOGGABLE_TRIG = "condition_Loggable_trig"
    SORT_PROP_CONDITION_LOGGABLE_TX_ID = "condition_Loggable_txId"
    SORT_PROP_CONDITION_LOGGABLE_USER = "condition_Loggable_user"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CAUSE = "condition_MultiInstanceImmutable_cause"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CHANGE_SET = "condition_MultiInstanceImmutable_changeSet"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CODE = "condition_MultiInstanceImmutable_code"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CREATED = "condition_MultiInstanceImmutable_created"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_DESCR = "condition_MultiInstanceImmutable_descr"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_ID = "condition_MultiInstanceImmutable_id"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_RULE = "condition_MultiInstanceImmutable_rule"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_SEVERITY = "condition_MultiInstanceImmutable_severity"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_TAGS = "condition_MultiInstanceImmutable_tags"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_TYPE = "condition_MultiInstanceImmutable_type"
    SORT_PROP_CONDITION_MUTABLE_CAUSE = "condition_Mutable_cause"
    SORT_PROP_CONDITION_MUTABLE_CHANGE_SET = "condition_Mutable_changeSet"
    SORT_PROP_CONDITION_MUTABLE_CODE = "condition_Mutable_code"
    SORT_PROP_CONDITION_MUTABLE_CREATED = "condition_Mutable_created"
    SORT_PROP_CONDITION_MUTABLE_DESCR = "condition_Mutable_descr"
    SORT_PROP_CONDITION_MUTABLE_HIGHEST_SEVERITY = "condition_Mutable_highestSeverity"
    SORT_PROP_CONDITION_MUTABLE_ID = "condition_Mutable_id"
    SORT_PROP_CONDITION_MUTABLE_LAST_TRANSITION = "condition_Mutable_lastTransition"
    SORT_PROP_CONDITION_MUTABLE_ORIG_SEVERITY = "condition_Mutable_origSeverity"
    SORT_PROP_CONDITION_MUTABLE_PREV_SEVERITY = "condition_Mutable_prevSeverity"
    SORT_PROP_CONDITION_MUTABLE_RULE = "condition_Mutable_rule"
    SORT_PROP_CONDITION_MUTABLE_SEVERITY = "condition_Mutable_severity"
    SORT_PROP_CONDITION_MUTABLE_TAGS = "condition_Mutable_tags"
    SORT_PROP_CONDITION_MUTABLE_TYPE = "condition_Mutable_type"
    SORT_PROP_CONDITION_POLICY_DESCR = "condition_Policy_descr"
    SORT_PROP_CONDITION_POLICY_INT_ID = "condition_Policy_intId"
    SORT_PROP_CONDITION_POLICY_NAME = "condition_Policy_name"
    SORT_PROP_CONDITION_POLICY_PINNING_EXPIRATION_INTERVAL = "condition_Policy_pinningExpirationInterval"
    SORT_PROP_CONDITION_POLICY_POLICY_LEVEL = "condition_Policy_policyLevel"
    SORT_PROP_CONDITION_POLICY_POLICY_OWNER = "condition_Policy_policyOwner"
    SORT_PROP_CONDITION_POLICY_RETENTION_INTERVAL = "condition_Policy_retentionInterval"
    SORT_PROP_CONDITION_POLICY_SIZE_LIMIT = "condition_Policy_sizeLimit"
    SORT_PROP_CONDITION_REPORTABLE_CAUSE = "condition_Reportable_cause"
    SORT_PROP_CONDITION_REPORTABLE_CHANGE_SET = "condition_Reportable_changeSet"
    SORT_PROP_CONDITION_REPORTABLE_CODE = "condition_Reportable_code"
    SORT_PROP_CONDITION_REPORTABLE_CREATED = "condition_Reportable_created"
    SORT_PROP_CONDITION_REPORTABLE_DESCR = "condition_Reportable_descr"
    SORT_PROP_CONDITION_REPORTABLE_ID = "condition_Reportable_id"
    SORT_PROP_CONDITION_REPORTABLE_RULE = "condition_Reportable_rule"
    SORT_PROP_CONDITION_REPORTABLE_SEVERITY = "condition_Reportable_severity"
    SORT_PROP_CONDITION_REPORTABLE_TAGS = "condition_Reportable_tags"
    SORT_PROP_CONDITION_REPORTABLE_TYPE = "condition_Reportable_type"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ImpactResponse_appConnectorId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ImpactResponse_impactAnalyzerId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ImpactResponse_sourceConnectorId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_STATE = "config_ImpactResponse_state"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_CHASSIS = "config_Impact_affectedChassis"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_OBJ = "config_Impact_affectedObj"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_SERVER = "config_Impact_affectedServer"
    SORT_PROP_CONFIG_IMPACT_CHANGES = "config_Impact_changes"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_ISSUES = "config_Impact_chassisConfigIssues"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_QUALIFIER = "config_Impact_chassisConfigQualifier"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_STATE = "config_Impact_chassisConfigState"
    SORT_PROP_CONFIG_IMPACT_CONFIG_ISSUES = "config_Impact_configIssues"
    SORT_PROP_CONFIG_IMPACT_CONFIG_QUALIFIER = "config_Impact_configQualifier"
    SORT_PROP_CONFIG_IMPACT_CONFIG_STATE = "config_Impact_configState"
    SORT_PROP_CONFIG_IMPACT_DEPLOYMENT_MODE = "config_Impact_deploymentMode"
    SORT_PROP_CONFIG_IMPACT_NAME = "config_Impact_name"
    SORT_PROP_CONFIG_IMPACT_REBOOT_REQUIRED = "config_Impact_rebootRequired"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_AFFECTED_CHASSIS_CNT = "config_ManagedEpImpactResponse_affectedChassisCnt"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_AFFECTED_SERVERS = "config_ManagedEpImpactResponse_affectedServers"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ManagedEpImpactResponse_appConnectorId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_EP_NAME = "config_ManagedEpImpactResponse_epName"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ManagedEpImpactResponse_impactAnalyzerId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_REBOOT_REQUIRED = "config_ManagedEpImpactResponse_rebootRequired"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ManagedEpImpactResponse_sourceConnectorId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_STATE = "config_ManagedEpImpactResponse_state"
    SORT_PROP_CONFIG_SORTER_DIRECTION = "config_Sorter_direction"
    SORT_PROP_CONFIG_SORTER_SORT_CLASS = "config_Sorter_sortClass"
    SORT_PROP_CONFIG_SORTER_SORT_PROP = "config_Sorter_sortProp"
    SORT_PROP_CONTROLLER_HA_CONTROLLER_TRIG_ELECTION_FLAG = "controller_HaController_trigElectionFlag"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_HEALTH_CHECK_INTERVAL = "controller_MgmtDbCheckPol_healthCheckInterval"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_INTERNAL_BACKUP_INTERVAL = "controller_MgmtDbCheckPol_internalBackupInterval"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_LAST_INTEGRITY_CHECK_TIME = "controller_MgmtDbCheckPol_lastIntegrityCheckTime"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_LAST_INTERNAL_BACKUP_TIME = "controller_MgmtDbCheckPol_lastInternalBackupTime"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_RESET_CORRUPT_COUNT = "controller_MgmtDbCheckPol_resetCorruptCount"
    SORT_PROP_CONTROLLER_MGMT_DB_CHECK_POL_TRIGGER_HEALTH_CHECK = "controller_MgmtDbCheckPol_triggerHealthCheck"
    SORT_PROP_CONTROLLER_OPERATIONAL_VERSION_HOLDER_SERIAL = "controller_OperationalVersionHolder_serial"
    SORT_PROP_CONTROLLER_PREFERED_VERSION_HOLDER_IN_USE = "controller_PreferedVersionHolder_inUse"
    SORT_PROP_CONTROLLER_PREFERED_VERSION_HOLDER_SERIAL = "controller_PreferedVersionHolder_serial"
    SORT_PROP_COPROCESSOR_CARD_DEVICE_ID = "coprocessor_Card_deviceId"
    SORT_PROP_COPROCESSOR_CARD_ID = "coprocessor_Card_id"
    SORT_PROP_COPROCESSOR_CARD_LC = "coprocessor_Card_lc"
    SORT_PROP_COPROCESSOR_CARD_LOCATION_DN = "coprocessor_Card_locationDn"
    SORT_PROP_COPROCESSOR_CARD_MODEL = "coprocessor_Card_model"
    SORT_PROP_COPROCESSOR_CARD_OPER_QUALIFIER_REASON = "coprocessor_Card_operQualifierReason"
    SORT_PROP_COPROCESSOR_CARD_OPER_STATE = "coprocessor_Card_operState"
    SORT_PROP_COPROCESSOR_CARD_OPERABILITY = "coprocessor_Card_operability"
    SORT_PROP_COPROCESSOR_CARD_PCI_ADDR = "coprocessor_Card_pciAddr"
    SORT_PROP_COPROCESSOR_CARD_PCI_SLOT = "coprocessor_Card_pciSlot"
    SORT_PROP_COPROCESSOR_CARD_PERF = "coprocessor_Card_perf"
    SORT_PROP_COPROCESSOR_CARD_POWER = "coprocessor_Card_power"
    SORT_PROP_COPROCESSOR_CARD_PRESENCE = "coprocessor_Card_presence"
    SORT_PROP_COPROCESSOR_CARD_REVISION = "coprocessor_Card_revision"
    SORT_PROP_COPROCESSOR_CARD_SERIAL = "coprocessor_Card_serial"
    SORT_PROP_COPROCESSOR_CARD_SUB_DEVICE_ID = "coprocessor_Card_subDeviceId"
    SORT_PROP_COPROCESSOR_CARD_SUB_VENDOR_ID = "coprocessor_Card_subVendorId"
    SORT_PROP_COPROCESSOR_CARD_THERMAL = "coprocessor_Card_thermal"
    SORT_PROP_COPROCESSOR_CARD_VENDOR = "coprocessor_Card_vendor"
    SORT_PROP_COPROCESSOR_CARD_VENDOR_ID = "coprocessor_Card_vendorId"
    SORT_PROP_COPROCESSOR_CARD_VOLTAGE = "coprocessor_Card_voltage"
    SORT_PROP_CPMAINT_ACK_ACKED = "cpmaint_Ack_acked"
    SORT_PROP_CPMAINT_ACK_ACKED_BY = "cpmaint_Ack_ackedBy"
    SORT_PROP_CPMAINT_ACK_ADMIN_STATE = "cpmaint_Ack_adminState"
    SORT_PROP_CPMAINT_ACK_AUTO_DELETE = "cpmaint_Ack_autoDelete"
    SORT_PROP_CPMAINT_ACK_CHANGE_BY = "cpmaint_Ack_changeBy"
    SORT_PROP_CPMAINT_ACK_CHANGE_DETAILS = "cpmaint_Ack_changeDetails"
    SORT_PROP_CPMAINT_ACK_CHANGE_MODE = "cpmaint_Ack_changeMode"
    SORT_PROP_CPMAINT_ACK_CHANGES = "cpmaint_Ack_changes"
    SORT_PROP_CPMAINT_ACK_CONFIG_ISSUES = "cpmaint_Ack_configIssues"
    SORT_PROP_CPMAINT_ACK_DEPLOYMENT_MODE = "cpmaint_Ack_deploymentMode"
    SORT_PROP_CPMAINT_ACK_DESCR = "cpmaint_Ack_descr"
    SORT_PROP_CPMAINT_ACK_DISR = "cpmaint_Ack_disr"
    SORT_PROP_CPMAINT_ACK_EXTD_CHANGE_DETAILS = "cpmaint_Ack_extdChangeDetails"
    SORT_PROP_CPMAINT_ACK_IGNORE_CAP = "cpmaint_Ack_ignoreCap"
    SORT_PROP_CPMAINT_ACK_INT_ID = "cpmaint_Ack_intId"
    SORT_PROP_CPMAINT_ACK_MODIFIED = "cpmaint_Ack_modified"
    SORT_PROP_CPMAINT_ACK_NAME = "cpmaint_Ack_name"
    SORT_PROP_CPMAINT_ACK_OLD_CHASSIS_DN = "cpmaint_Ack_oldChassisDn"
    SORT_PROP_CPMAINT_ACK_OPER_SCHEDULER = "cpmaint_Ack_operScheduler"
    SORT_PROP_CPMAINT_ACK_OPER_STATE = "cpmaint_Ack_operState"
    SORT_PROP_CPMAINT_ACK_POLICY_LEVEL = "cpmaint_Ack_policyLevel"
    SORT_PROP_CPMAINT_ACK_POLICY_OWNER = "cpmaint_Ack_policyOwner"
    SORT_PROP_CPMAINT_ACK_PREV_OPER_STATE = "cpmaint_Ack_prevOperState"
    SORT_PROP_CPMAINT_ACK_PROP_ACL = "cpmaint_Ack_propAcl"
    SORT_PROP_CPMAINT_ACK_SCHEDULER = "cpmaint_Ack_scheduler"
    SORT_PROP_CPMAINT_ACK_TRIGGER_CONFIG_STATE = "cpmaint_Ack_triggerConfigState"
    SORT_PROP_CPMAINT_MAINT_POLICY_DESCR = "cpmaint_MaintPolicy_descr"
    SORT_PROP_CPMAINT_MAINT_POLICY_INT_ID = "cpmaint_MaintPolicy_intId"
    SORT_PROP_CPMAINT_MAINT_POLICY_NAME = "cpmaint_MaintPolicy_name"
    SORT_PROP_CPMAINT_MAINT_POLICY_OPER_SCHED_NAME = "cpmaint_MaintPolicy_operSchedName"
    SORT_PROP_CPMAINT_MAINT_POLICY_POLICY_LEVEL = "cpmaint_MaintPolicy_policyLevel"
    SORT_PROP_CPMAINT_MAINT_POLICY_POLICY_OWNER = "cpmaint_MaintPolicy_policyOwner"
    SORT_PROP_CPMAINT_MAINT_POLICY_SCHED_NAME = "cpmaint_MaintPolicy_schedName"
    SORT_PROP_CPMAINT_MAINT_POLICY_TRIGGER_CONFIG = "cpmaint_MaintPolicy_triggerConfig"
    SORT_PROP_CPMAINT_MAINT_POLICY_UPTIME_DISR = "cpmaint_MaintPolicy_uptimeDisr"
    SORT_PROP_DCX_FCOE_VIF_EP_ID = "dcx_FcoeVifEp_id"
    SORT_PROP_DCX_NS_ALLOC_STATUS = "dcx_Ns_allocStatus"
    SORT_PROP_DCX_NS_SIDE = "dcx_Ns_side"
    SORT_PROP_DCX_NS_SIZE = "dcx_Ns_size"
    SORT_PROP_DCX_NS_SWITCH_ID = "dcx_Ns_switchId"
    SORT_PROP_DCX_NS_USED = "dcx_Ns_used"
    SORT_PROP_DCX_PATH_PROTECTION_PROT_PEER_ID = "dcx_PathProtection_protPeerId"
    SORT_PROP_DCX_PATH_PROTECTION_PROT_ROLE = "dcx_PathProtection_protRole"
    SORT_PROP_DCX_STATEFUL_END_POINT_ADMIN_STATE = "dcx_StatefulEndPoint_adminState"
    SORT_PROP_DCX_VIF_ADMIN_STATE = "dcx_VIf_adminState"
    SORT_PROP_DCX_VIF_COOKIE = "dcx_VIf_cookie"
    SORT_PROP_DCX_VIF_EP_DN = "dcx_VIf_epDn"
    SORT_PROP_DCX_VIF_ID = "dcx_VIf_id"
    SORT_PROP_DCX_VIF_IF_ROLE = "dcx_VIf_ifRole"
    SORT_PROP_DCX_VIF_IF_TYPE = "dcx_VIf_ifType"
    SORT_PROP_DCX_VIF_INST_TYPE = "dcx_VIf_instType"
    SORT_PROP_DCX_VIF_LC = "dcx_VIf_lc"
    SORT_PROP_DCX_VIF_LINK_STATE = "dcx_VIf_linkState"
    SORT_PROP_DCX_VIF_LOCALE = "dcx_VIf_locale"
    SORT_PROP_DCX_VIF_NAME = "dcx_VIf_name"
    SORT_PROP_DCX_VIF_OPER_STATE = "dcx_VIf_operState"
    SORT_PROP_DCX_VIF_PEER_DN = "dcx_VIf_peerDn"
    SORT_PROP_DCX_VIF_PROT_PEER_ID = "dcx_VIf_protPeerId"
    SORT_PROP_DCX_VIF_PROT_ROLE = "dcx_VIf_protRole"
    SORT_PROP_DCX_VIF_PROT_STATE = "dcx_VIf_protState"
    SORT_PROP_DCX_VIF_QOS_CONTROL = "dcx_VIf_qosControl"
    SORT_PROP_DCX_VIF_STATE = "dcx_VIf_state"
    SORT_PROP_DCX_VIF_SWITCH_ID = "dcx_VIf_switchId"
    SORT_PROP_DCX_VIF_TAG = "dcx_VIf_tag"
    SORT_PROP_DCX_VIF_TRANSPORT = "dcx_VIf_transport"
    SORT_PROP_DCX_VIF_TYPE = "dcx_VIf_type"
    SORT_PROP_DCX_VC_ADMIN_STATE = "dcx_Vc_adminState"
    SORT_PROP_DCX_VC_BORDER_AGGR_PORT_ID = "dcx_Vc_borderAggrPortId"
    SORT_PROP_DCX_VC_BORDER_PORT_ID = "dcx_Vc_borderPortId"
    SORT_PROP_DCX_VC_BORDER_SLOT_ID = "dcx_Vc_borderSlotId"
    SORT_PROP_DCX_VC_BORDER_VFC_ID = "dcx_Vc_borderVfcId"
    SORT_PROP_DCX_VC_CDP = "dcx_Vc_cdp"
    SORT_PROP_DCX_VC_COOKIE = "dcx_Vc_cookie"
    SORT_PROP_DCX_VC_COS = "dcx_Vc_cos"
    SORT_PROP_DCX_VC_DERIVED_FROM_ID = "dcx_Vc_derivedFromId"
    SORT_PROP_DCX_VC_ENCAP = "dcx_Vc_encap"
    SORT_PROP_DCX_VC_FCOE_ID = "dcx_Vc_fcoeId"
    SORT_PROP_DCX_VC_FORGE_MAC = "dcx_Vc_forgeMac"
    SORT_PROP_DCX_VC_ID = "dcx_Vc_id"
    SORT_PROP_DCX_VC_INST_TYPE = "dcx_Vc_instType"
    SORT_PROP_DCX_VC_LC = "dcx_Vc_lc"
    SORT_PROP_DCX_VC_LINK_STATE = "dcx_Vc_linkState"
    SORT_PROP_DCX_VC_LLDP = "dcx_Vc_lldp"
    SORT_PROP_DCX_VC_LOCALE = "dcx_Vc_locale"
    SORT_PROP_DCX_VC_MAC_REGISTER_MODE = "dcx_Vc_macRegisterMode"
    SORT_PROP_DCX_VC_MON_TRAF_DIR = "dcx_Vc_monTrafDir"
    SORT_PROP_DCX_VC_NAME = "dcx_Vc_name"
    SORT_PROP_DCX_VC_OPER_BORDER_AGGR_PORT_ID = "dcx_Vc_operBorderAggrPortId"
    SORT_PROP_DCX_VC_OPER_BORDER_PORT_ID = "dcx_Vc_operBorderPortId"
    SORT_PROP_DCX_VC_OPER_BORDER_SLOT_ID = "dcx_Vc_operBorderSlotId"
    SORT_PROP_DCX_VC_OPER_STATE = "dcx_Vc_operState"
    SORT_PROP_DCX_VC_PEER_ID = "dcx_Vc_peerId"
    SORT_PROP_DCX_VC_PROT_STATE = "dcx_Vc_protState"
    SORT_PROP_DCX_VC_QOS_POLICY_DN = "dcx_Vc_qosPolicyDn"
    SORT_PROP_DCX_VC_QOS_POLICY_ID = "dcx_Vc_qosPolicyId"
    SORT_PROP_DCX_VC_ROLE = "dcx_Vc_role"
    SORT_PROP_DCX_VC_STATE = "dcx_Vc_state"
    SORT_PROP_DCX_VC_STATE_QUAL = "dcx_Vc_stateQual"
    SORT_PROP_DCX_VC_SWITCH_ID = "dcx_Vc_switchId"
    SORT_PROP_DCX_VC_TAG = "dcx_Vc_tag"
    SORT_PROP_DCX_VC_TRANSPORT = "dcx_Vc_transport"
    SORT_PROP_DCX_VC_TYPE = "dcx_Vc_type"
    SORT_PROP_DCX_VC_UPLINK_FAIL_ACTION = "dcx_Vc_uplinkFailAction"
    SORT_PROP_DCX_VC_VNIC = "dcx_Vc_vnic"
    SORT_PROP_DCX_VIF_EP_ID = "dcx_VifEp_id"
    SORT_PROP_DHCP_ACQUIRED_ACQTS = "dhcp_Acquired_acqts"
    SORT_PROP_DHCP_ACQUIRED_COOKIE = "dhcp_Acquired_cookie"
    SORT_PROP_DHCP_ACQUIRED_ENDS = "dhcp_Acquired_ends"
    SORT_PROP_DHCP_ACQUIRED_IP = "dhcp_Acquired_ip"
    SORT_PROP_DHCP_ACQUIRED_MAC = "dhcp_Acquired_mac"
    SORT_PROP_DHCP_ACQUIRED_SYS_ID = "dhcp_Acquired_sysId"
    SORT_PROP_DHCP_LEASE_CLI_ID = "dhcp_Lease_cliId"
    SORT_PROP_DHCP_LEASE_COOKIE = "dhcp_Lease_cookie"
    SORT_PROP_DHCP_LEASE_ENDS = "dhcp_Lease_ends"
    SORT_PROP_DHCP_LEASE_HOSTNAME = "dhcp_Lease_hostname"
    SORT_PROP_DHCP_LEASE_INTF = "dhcp_Lease_intf"
    SORT_PROP_DHCP_LEASE_IP = "dhcp_Lease_ip"
    SORT_PROP_DHCP_LEASE_MAC = "dhcp_Lease_mac"
    SORT_PROP_DHCP_LEASE_STARTS = "dhcp_Lease_starts"
    SORT_PROP_DIAG_CTRL_ADMIN_STATE = "diag_Ctrl_adminState"
    SORT_PROP_DIAG_CTRL_END_TS = "diag_Ctrl_endTs"
    SORT_PROP_DIAG_CTRL_END_TS_M = "diag_Ctrl_endTsM"
    SORT_PROP_DIAG_CTRL_ERROR_DESCR = "diag_Ctrl_errorDescr"
    SORT_PROP_DIAG_CTRL_OPER_QUALIFIER = "diag_Ctrl_operQualifier"
    SORT_PROP_DIAG_CTRL_OPER_STATE = "diag_Ctrl_operState"
    SORT_PROP_DIAG_CTRL_START_TS = "diag_Ctrl_startTs"
    SORT_PROP_DIAG_CTRL_START_TS_M = "diag_Ctrl_startTsM"
    SORT_PROP_DIAG_LOG_EP_LOG_DN = "diag_LogEp_logDn"
    SORT_PROP_DIAG_LOG_EP_SWITCH_ID = "diag_LogEp_switchId"
    SORT_PROP_DIAG_MEMORY_TEST_CPU_FILTER = "diag_MemoryTest_cpuFilter"
    SORT_PROP_DIAG_MEMORY_TEST_ID = "diag_MemoryTest_id"
    SORT_PROP_DIAG_MEMORY_TEST_LOOP_COUNT = "diag_MemoryTest_loopCount"
    SORT_PROP_DIAG_MEMORY_TEST_MEM_CHUNK_SIZE = "diag_MemoryTest_memChunkSize"
    SORT_PROP_DIAG_MEMORY_TEST_MEM_SIZE = "diag_MemoryTest_memSize"
    SORT_PROP_DIAG_MEMORY_TEST_ORDER = "diag_MemoryTest_order"
    SORT_PROP_DIAG_MEMORY_TEST_PATTERN = "diag_MemoryTest_pattern"
    SORT_PROP_DIAG_MEMORY_TEST_TYPE = "diag_MemoryTest_type"
    SORT_PROP_DIAG_RSLT_DESCR = "diag_Rslt_descr"
    SORT_PROP_DIAG_RSLT_END_TS = "diag_Rslt_endTs"
    SORT_PROP_DIAG_RSLT_EST_PROG_WEIGHT = "diag_Rslt_estProgWeight"
    SORT_PROP_DIAG_RSLT_ID = "diag_Rslt_id"
    SORT_PROP_DIAG_RSLT_PROGRESS = "diag_Rslt_progress"
    SORT_PROP_DIAG_RSLT_RESULT = "diag_Rslt_result"
    SORT_PROP_DIAG_RSLT_RSLT_STATUS = "diag_Rslt_rsltStatus"
    SORT_PROP_DIAG_RSLT_START_TS = "diag_Rslt_startTs"
    SORT_PROP_DIAG_RSLT_TEST_DN = "diag_Rslt_testDn"
    SORT_PROP_DIAG_RSLT_TEST_TYPE = "diag_Rslt_testType"
    SORT_PROP_DIAG_RUN_POLICY_DESCR = "diag_RunPolicy_descr"
    SORT_PROP_DIAG_RUN_POLICY_FAILURE_ACTION = "diag_RunPolicy_failureAction"
    SORT_PROP_DIAG_RUN_POLICY_INT_ID = "diag_RunPolicy_intId"
    SORT_PROP_DIAG_RUN_POLICY_NAME = "diag_RunPolicy_name"
    SORT_PROP_DIAG_RUN_POLICY_POLICY_LEVEL = "diag_RunPolicy_policyLevel"
    SORT_PROP_DIAG_RUN_POLICY_POLICY_OWNER = "diag_RunPolicy_policyOwner"
    SORT_PROP_DIAG_RUN_POLICY_SUCCESS_ACTION = "diag_RunPolicy_successAction"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_DELETED = "diag_SrvCapProvider_deleted"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_DEPRECATED = "diag_SrvCapProvider_deprecated"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "diag_SrvCapProvider_elementLoadFailures"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_ELEMENTS_LOADED = "diag_SrvCapProvider_elementsLoaded"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_GENCOUNT = "diag_SrvCapProvider_gencount"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_LOAD_ERRORS = "diag_SrvCapProvider_loadErrors"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_LOAD_WARNINGS = "diag_SrvCapProvider_loadWarnings"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_MGMT_PLANE_VER = "diag_SrvCapProvider_mgmtPlaneVer"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_MODEL = "diag_SrvCapProvider_model"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_PROM_CARD_TYPE = "diag_SrvCapProvider_promCardType"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_REVISION = "diag_SrvCapProvider_revision"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_VENDOR = "diag_SrvCapProvider_vendor"
    SORT_PROP_DIAG_SRV_CTRL_ADMIN_STATE = "diag_SrvCtrl_adminState"
    SORT_PROP_DIAG_SRV_CTRL_END_TS = "diag_SrvCtrl_endTs"
    SORT_PROP_DIAG_SRV_CTRL_END_TS_M = "diag_SrvCtrl_endTsM"
    SORT_PROP_DIAG_SRV_CTRL_ERROR_DESCR = "diag_SrvCtrl_errorDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPER_QUALIFIER = "diag_SrvCtrl_operQualifier"
    SORT_PROP_DIAG_SRV_CTRL_OPER_STATE = "diag_SrvCtrl_operState"
    SORT_PROP_DIAG_SRV_CTRL_OVERALL_PROGRESS = "diag_SrvCtrl_overallProgress"
    SORT_PROP_DIAG_SRV_CTRL_RUN_POLICY_NAME = "diag_SrvCtrl_runPolicyName"
    SORT_PROP_DIAG_SRV_CTRL_START_TS = "diag_SrvCtrl_startTs"
    SORT_PROP_DIAG_SRV_CTRL_START_TS_M = "diag_SrvCtrl_startTsM"
    SORT_PROP_DIAG_TEST_ID = "diag_Test_id"
    SORT_PROP_DIAG_TEST_ORDER = "diag_Test_order"
    SORT_PROP_DIAG_TEST_TYPE = "diag_Test_type"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_FUNCTIONAL_STATE = "domain_ChassisFeature_functionalState"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_NAME = "domain_ChassisFeature_name"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_TYPE = "domain_ChassisFeature_type"
    SORT_PROP_DOMAIN_CHASSIS_PARAM_NAME = "domain_ChassisParam_name"
    SORT_PROP_DOMAIN_CHASSIS_PARAM_VALUE = "domain_ChassisParam_value"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_FUNCTIONAL_STATE = "domain_EnvironmentFeature_functionalState"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_NAME = "domain_EnvironmentFeature_name"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_TYPE = "domain_EnvironmentFeature_type"
    SORT_PROP_DOMAIN_ENVIRONMENT_PARAM_NAME = "domain_EnvironmentParam_name"
    SORT_PROP_DOMAIN_ENVIRONMENT_PARAM_VALUE = "domain_EnvironmentParam_value"
    SORT_PROP_DOMAIN_FEATURE_FUNCTIONAL_STATE = "domain_Feature_functionalState"
    SORT_PROP_DOMAIN_FEATURE_NAME = "domain_Feature_name"
    SORT_PROP_DOMAIN_FEATURE_TYPE = "domain_Feature_type"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_FUNCTIONAL_STATE = "domain_NetworkFeature_functionalState"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_NAME = "domain_NetworkFeature_name"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_TYPE = "domain_NetworkFeature_type"
    SORT_PROP_DOMAIN_NETWORK_PARAM_NAME = "domain_NetworkParam_name"
    SORT_PROP_DOMAIN_NETWORK_PARAM_VALUE = "domain_NetworkParam_value"
    SORT_PROP_DOMAIN_PARAMETER_NAME = "domain_Parameter_name"
    SORT_PROP_DOMAIN_PARAMETER_VALUE = "domain_Parameter_value"
    SORT_PROP_DOMAIN_SERVER_FEATURE_FUNCTIONAL_STATE = "domain_ServerFeature_functionalState"
    SORT_PROP_DOMAIN_SERVER_FEATURE_NAME = "domain_ServerFeature_name"
    SORT_PROP_DOMAIN_SERVER_FEATURE_TYPE = "domain_ServerFeature_type"
    SORT_PROP_DOMAIN_SERVER_PARAM_NAME = "domain_ServerParam_name"
    SORT_PROP_DOMAIN_SERVER_PARAM_VALUE = "domain_ServerParam_value"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_FUNCTIONAL_STATE = "domain_StorageFeature_functionalState"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_NAME = "domain_StorageFeature_name"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_TYPE = "domain_StorageFeature_type"
    SORT_PROP_DOMAIN_STORAGE_PARAM_NAME = "domain_StorageParam_name"
    SORT_PROP_DOMAIN_STORAGE_PARAM_VALUE = "domain_StorageParam_value"
    SORT_PROP_DPSEC_MAC_DESCR = "dpsec_Mac_descr"
    SORT_PROP_DPSEC_MAC_FORGE = "dpsec_Mac_forge"
    SORT_PROP_DPSEC_MAC_INT_ID = "dpsec_Mac_intId"
    SORT_PROP_DPSEC_MAC_NAME = "dpsec_Mac_name"
    SORT_PROP_DPSEC_MAC_POLICY_LEVEL = "dpsec_Mac_policyLevel"
    SORT_PROP_DPSEC_MAC_POLICY_OWNER = "dpsec_Mac_policyOwner"
    SORT_PROP_DPSEC_MAC_PROP_ACL = "dpsec_Mac_propAcl"
    SORT_PROP_DUPE_SCOPE_RESULT_MESSAGE = "dupe_ScopeResult_message"
    SORT_PROP_DUPE_SCOPE_RESULT_SCOPE_STATUS = "dupe_ScopeResult_scopeStatus"
    SORT_PROP_DUPE_SCOPE_RESULT_UPDATE_TIME = "dupe_ScopeResult_updateTime"
    SORT_PROP_DUPE_SCOPE_CLIENT_MO_DN = "dupe_Scope_clientMoDn"
    SORT_PROP_DUPE_SCOPE_ID = "dupe_Scope_id"
    SORT_PROP_DUPE_SCOPE_IS_SYSTEM = "dupe_Scope_isSystem"
    SORT_PROP_DUPE_SCOPE_MO_CLASS_ID = "dupe_Scope_moClassId"
    SORT_PROP_DUPE_SCOPE_OPER_CODE = "dupe_Scope_operCode"
    SORT_PROP_DUPE_SCOPE_SECONDARY_KEY = "dupe_Scope_secondaryKey"
    SORT_PROP_DUPE_SCOPE_SOURCE_MO_DN = "dupe_Scope_sourceMoDn"
    SORT_PROP_EPQOS_CONF_COS = "epqos_Conf_cos"
    SORT_PROP_EPQOS_CONF_QOS_POLICY_DN = "epqos_Conf_qosPolicyDn"
    SORT_PROP_EPQOS_CONF_QOS_POLICY_ID = "epqos_Conf_qosPolicyId"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_DESCR = "epqos_DefinitionDelTaskFsmStage_descr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_LAST_UPDATE_TIME = "epqos_DefinitionDelTaskFsmStage_lastUpdateTime"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_NAME = "epqos_DefinitionDelTaskFsmStage_name"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_ORDER = "epqos_DefinitionDelTaskFsmStage_order"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_RETRY = "epqos_DefinitionDelTaskFsmStage_retry"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_STAGE_STATUS = "epqos_DefinitionDelTaskFsmStage_stageStatus"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_COMPLETION = "epqos_DefinitionDelTaskFsmTask_completion"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_FLAGS = "epqos_DefinitionDelTaskFsmTask_flags"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_ITEM = "epqos_DefinitionDelTaskFsmTask_item"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_SEQ_ID = "epqos_DefinitionDelTaskFsmTask_seqId"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_COMPLETION_TIME = "epqos_DefinitionDelTaskFsm_completionTime"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_CURRENT_FSM = "epqos_DefinitionDelTaskFsm_currentFsm"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_DESCR = "epqos_DefinitionDelTaskFsm_descr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_FSM_STATUS = "epqos_DefinitionDelTaskFsm_fsmStatus"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_INSTANCE_ID = "epqos_DefinitionDelTaskFsm_instanceId"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_PROGRESS = "epqos_DefinitionDelTaskFsm_progress"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_ERR_CODE = "epqos_DefinitionDelTaskFsm_rmtErrCode"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_ERR_DESCR = "epqos_DefinitionDelTaskFsm_rmtErrDescr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_RSLT = "epqos_DefinitionDelTaskFsm_rmtRslt"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_DEF_DN = "epqos_DefinitionDelTask_defDn"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_DEF_INT_ID = "epqos_DefinitionDelTask_defIntId"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_DESCR = "epqos_DefinitionDelTask_descr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_DESCR = "epqos_DefinitionDelTask_fsmDescr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_PREV = "epqos_DefinitionDelTask_fsmPrev"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_PROGR = "epqos_DefinitionDelTask_fsmProgr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_ERR_CODE = "epqos_DefinitionDelTask_fsmRmtInvErrCode"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_ERR_DESCR = "epqos_DefinitionDelTask_fsmRmtInvErrDescr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_RSLT = "epqos_DefinitionDelTask_fsmRmtInvRslt"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_DESCR = "epqos_DefinitionDelTask_fsmStageDescr"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STAMP = "epqos_DefinitionDelTask_fsmStamp"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_STATUS = "epqos_DefinitionDelTask_fsmStatus"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_FSM_TRY = "epqos_DefinitionDelTask_fsmTry"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_INT_ID = "epqos_DefinitionDelTask_intId"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_NAME = "epqos_DefinitionDelTask_name"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_POLICY_LEVEL = "epqos_DefinitionDelTask_policyLevel"
    SORT_PROP_EPQOS_DEFINITION_DEL_TASK_POLICY_OWNER = "epqos_DefinitionDelTask_policyOwner"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_DESCR = "epqos_DefinitionFsmStage_descr"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_LAST_UPDATE_TIME = "epqos_DefinitionFsmStage_lastUpdateTime"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_NAME = "epqos_DefinitionFsmStage_name"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_ORDER = "epqos_DefinitionFsmStage_order"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_RETRY = "epqos_DefinitionFsmStage_retry"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_STAGE_STATUS = "epqos_DefinitionFsmStage_stageStatus"
    SORT_PROP_EPQOS_DEFINITION_FSM_TASK_COMPLETION = "epqos_DefinitionFsmTask_completion"
    SORT_PROP_EPQOS_DEFINITION_FSM_TASK_FLAGS = "epqos_DefinitionFsmTask_flags"
    SORT_PROP_EPQOS_DEFINITION_FSM_TASK_ITEM = "epqos_DefinitionFsmTask_item"
    SORT_PROP_EPQOS_DEFINITION_FSM_TASK_SEQ_ID = "epqos_DefinitionFsmTask_seqId"
    SORT_PROP_EPQOS_DEFINITION_FSM_COMPLETION_TIME = "epqos_DefinitionFsm_completionTime"
    SORT_PROP_EPQOS_DEFINITION_FSM_CURRENT_FSM = "epqos_DefinitionFsm_currentFsm"
    SORT_PROP_EPQOS_DEFINITION_FSM_DESCR = "epqos_DefinitionFsm_descr"
    SORT_PROP_EPQOS_DEFINITION_FSM_FSM_STATUS = "epqos_DefinitionFsm_fsmStatus"
    SORT_PROP_EPQOS_DEFINITION_FSM_INSTANCE_ID = "epqos_DefinitionFsm_instanceId"
    SORT_PROP_EPQOS_DEFINITION_FSM_PROGRESS = "epqos_DefinitionFsm_progress"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_ERR_CODE = "epqos_DefinitionFsm_rmtErrCode"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_ERR_DESCR = "epqos_DefinitionFsm_rmtErrDescr"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_RSLT = "epqos_DefinitionFsm_rmtRslt"
    SORT_PROP_EPQOS_DEFINITION_DESCR = "epqos_Definition_descr"
    SORT_PROP_EPQOS_DEFINITION_FSM_DESCR = "epqos_Definition_fsmDescr"
    SORT_PROP_EPQOS_DEFINITION_FSM_PREV = "epqos_Definition_fsmPrev"
    SORT_PROP_EPQOS_DEFINITION_FSM_PROGR = "epqos_Definition_fsmProgr"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_INV_ERR_CODE = "epqos_Definition_fsmRmtInvErrCode"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_INV_ERR_DESCR = "epqos_Definition_fsmRmtInvErrDescr"
    SORT_PROP_EPQOS_DEFINITION_FSM_RMT_INV_RSLT = "epqos_Definition_fsmRmtInvRslt"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAGE_DESCR = "epqos_Definition_fsmStageDescr"
    SORT_PROP_EPQOS_DEFINITION_FSM_STAMP = "epqos_Definition_fsmStamp"
    SORT_PROP_EPQOS_DEFINITION_FSM_STATUS = "epqos_Definition_fsmStatus"
    SORT_PROP_EPQOS_DEFINITION_FSM_TRY = "epqos_Definition_fsmTry"
    SORT_PROP_EPQOS_DEFINITION_INT_ID = "epqos_Definition_intId"
    SORT_PROP_EPQOS_DEFINITION_NAME = "epqos_Definition_name"
    SORT_PROP_EPQOS_DEFINITION_POLICY_LEVEL = "epqos_Definition_policyLevel"
    SORT_PROP_EPQOS_DEFINITION_POLICY_OWNER = "epqos_Definition_policyOwner"
    SORT_PROP_EPQOS_EGRESS_BURST = "epqos_Egress_burst"
    SORT_PROP_EPQOS_EGRESS_HOST_CONTROL = "epqos_Egress_hostControl"
    SORT_PROP_EPQOS_EGRESS_NAME = "epqos_Egress_name"
    SORT_PROP_EPQOS_EGRESS_OPER_PRIO = "epqos_Egress_operPrio"
    SORT_PROP_EPQOS_EGRESS_PRIO = "epqos_Egress_prio"
    SORT_PROP_EPQOS_EGRESS_RATE = "epqos_Egress_rate"
    SORT_PROP_EPQOS_ITEM_NAME = "epqos_Item_name"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_ADAPTOR_EP = "equipment_AdaptorConnDef_adaptorEp"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_DESCR = "equipment_AdaptorConnDef_descr"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_INT_ID = "equipment_AdaptorConnDef_intId"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_IOM_EP = "equipment_AdaptorConnDef_iomEp"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_NAME = "equipment_AdaptorConnDef_name"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_POLICY_LEVEL = "equipment_AdaptorConnDef_policyLevel"
    SORT_PROP_EQUIPMENT_ADAPTOR_CONN_DEF_POLICY_OWNER = "equipment_AdaptorConnDef_policyOwner"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_DESCR = "equipment_AdaptorDef_descr"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_ETHERNET_PORT_SPEED = "equipment_AdaptorDef_ethernetPortSpeed"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_FIBRE_CHANNEL_PORT_SPEED = "equipment_AdaptorDef_fibreChannelPortSpeed"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_FORCE_UPDATE_VERSION = "equipment_AdaptorDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_INT_ID = "equipment_AdaptorDef_intId"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_NAME = "equipment_AdaptorDef_name"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_POLICY_LEVEL = "equipment_AdaptorDef_policyLevel"
    SORT_PROP_EQUIPMENT_ADAPTOR_DEF_POLICY_OWNER = "equipment_AdaptorDef_policyOwner"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_DESCR = "equipment_AdvancedBootOrder_descr"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_INT_ID = "equipment_AdvancedBootOrder_intId"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_IS_SUPPORTED = "equipment_AdvancedBootOrder_isSupported"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_BIOS_VERSION = "equipment_AdvancedBootOrder_minBiosVersion"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_CIMC_VERSION = "equipment_AdvancedBootOrder_minCimcVersion"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_NAME = "equipment_AdvancedBootOrder_name"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_POLICY_LEVEL = "equipment_AdvancedBootOrder_policyLevel"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_POLICY_OWNER = "equipment_AdvancedBootOrder_policyOwner"
    SORT_PROP_EQUIPMENT_ASSOC_CTX_FRU_CAP_DN = "equipment_AssocCtx_fruCapDn"
    SORT_PROP_EQUIPMENT_AUTO_CONFIG_MODE_MIN_CIMC_VERSION = "equipment_AutoConfigMode_minCimcVersion"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_DESCR = "equipment_AutoconfigPolicy_descr"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_DST_DN = "equipment_AutoconfigPolicy_dstDn"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_INT_ID = "equipment_AutoconfigPolicy_intId"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_NAME = "equipment_AutoconfigPolicy_name"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_OPER_QUALIFIER = "equipment_AutoconfigPolicy_operQualifier"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_POLICY_LEVEL = "equipment_AutoconfigPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_POLICY_OWNER = "equipment_AutoconfigPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_QUALIFIER = "equipment_AutoconfigPolicy_qualifier"
    SORT_PROP_EQUIPMENT_AUTOCONFIG_POLICY_SRC_TEMPL_NAME = "equipment_AutoconfigPolicy_srcTemplName"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_DELETED = "equipment_BaseBoardCapProvider_deleted"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_DEPRECATED = "equipment_BaseBoardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BaseBoardCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BaseBoardCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_GENCOUNT = "equipment_BaseBoardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_BaseBoardCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BaseBoardCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BaseBoardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_MODEL = "equipment_BaseBoardCapProvider_model"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BaseBoardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_REVISION = "equipment_BaseBoardCapProvider_revision"
    SORT_PROP_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_VENDOR = "equipment_BaseBoardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_DESCR = "equipment_BeaconCapProvider_descr"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_INT_ID = "equipment_BeaconCapProvider_intId"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_NAME = "equipment_BeaconCapProvider_name"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_POLICY_LEVEL = "equipment_BeaconCapProvider_policyLevel"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_POLICY_OWNER = "equipment_BeaconCapProvider_policyOwner"
    SORT_PROP_EQUIPMENT_BEACON_CAP_PROVIDER_PORT_MODE_BEACON = "equipment_BeaconCapProvider_portModeBeacon"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_DESCR = "equipment_BeaconLedFsmStage_descr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_LAST_UPDATE_TIME = "equipment_BeaconLedFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_NAME = "equipment_BeaconLedFsmStage_name"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_ORDER = "equipment_BeaconLedFsmStage_order"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_RETRY = "equipment_BeaconLedFsmStage_retry"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_STAGE_STATUS = "equipment_BeaconLedFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_TASK_COMPLETION = "equipment_BeaconLedFsmTask_completion"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_TASK_FLAGS = "equipment_BeaconLedFsmTask_flags"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_TASK_ITEM = "equipment_BeaconLedFsmTask_item"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_TASK_SEQ_ID = "equipment_BeaconLedFsmTask_seqId"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_COMPLETION_TIME = "equipment_BeaconLedFsm_completionTime"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_CURRENT_FSM = "equipment_BeaconLedFsm_currentFsm"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_DESCR = "equipment_BeaconLedFsm_descr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_FSM_STATUS = "equipment_BeaconLedFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_INSTANCE_ID = "equipment_BeaconLedFsm_instanceId"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_PROGRESS = "equipment_BeaconLedFsm_progress"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_ERR_CODE = "equipment_BeaconLedFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_ERR_DESCR = "equipment_BeaconLedFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_RSLT = "equipment_BeaconLedFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_BEACON_LED_ADMIN_STATE = "equipment_BeaconLed_adminState"
    SORT_PROP_EQUIPMENT_BEACON_LED_COLOR = "equipment_BeaconLed_color"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_DESCR = "equipment_BeaconLed_fsmDescr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_PREV = "equipment_BeaconLed_fsmPrev"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_PROGR = "equipment_BeaconLed_fsmProgr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_INV_ERR_CODE = "equipment_BeaconLed_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_INV_ERR_DESCR = "equipment_BeaconLed_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_RMT_INV_RSLT = "equipment_BeaconLed_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAGE_DESCR = "equipment_BeaconLed_fsmStageDescr"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STAMP = "equipment_BeaconLed_fsmStamp"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_STATUS = "equipment_BeaconLed_fsmStatus"
    SORT_PROP_EQUIPMENT_BEACON_LED_FSM_TRY = "equipment_BeaconLed_fsmTry"
    SORT_PROP_EQUIPMENT_BEACON_LED_ID = "equipment_BeaconLed_id"
    SORT_PROP_EQUIPMENT_BEACON_LED_NAME = "equipment_BeaconLed_name"
    SORT_PROP_EQUIPMENT_BEACON_LED_OPER_STATE = "equipment_BeaconLed_operState"
    SORT_PROP_EQUIPMENT_BINDING_ASSIGNED_TO_DN = "equipment_Binding_assignedToDn"
    SORT_PROP_EQUIPMENT_BINDING_CHASSIS_DN = "equipment_Binding_chassisDn"
    SORT_PROP_EQUIPMENT_BINDING_ISSUES = "equipment_Binding_issues"
    SORT_PROP_EQUIPMENT_BINDING_NAME = "equipment_Binding_name"
    SORT_PROP_EQUIPMENT_BINDING_OPER_STATE = "equipment_Binding_operState"
    SORT_PROP_EQUIPMENT_BINDING_PROP_ACL = "equipment_Binding_propAcl"
    SORT_PROP_EQUIPMENT_BINDING_RESTRICT_MIGRATION = "equipment_Binding_restrictMigration"
    SORT_PROP_EQUIPMENT_BIOS_DEF_DESCR = "equipment_BiosDef_descr"
    SORT_PROP_EQUIPMENT_BIOS_DEF_INT_ID = "equipment_BiosDef_intId"
    SORT_PROP_EQUIPMENT_BIOS_DEF_NAME = "equipment_BiosDef_name"
    SORT_PROP_EQUIPMENT_BIOS_DEF_POLICY_LEVEL = "equipment_BiosDef_policyLevel"
    SORT_PROP_EQUIPMENT_BIOS_DEF_POLICY_OWNER = "equipment_BiosDef_policyOwner"
    SORT_PROP_EQUIPMENT_BIOS_DEF_RESET_ON = "equipment_BiosDef_resetOn"
    SORT_PROP_EQUIPMENT_BIOS_DEF_SECURE_BIOS = "equipment_BiosDef_secureBios"
    SORT_PROP_EQUIPMENT_BIOS_DEF_STORAGE_METHOD = "equipment_BiosDef_storageMethod"
    SORT_PROP_EQUIPMENT_BIOS_DEF_TPM_CONFIG_SUPPORT = "equipment_BiosDef_tpmConfigSupport"
    SORT_PROP_EQUIPMENT_BIOS_DEF_UPDATE_METHOD = "equipment_BiosDef_updateMethod"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_BIOS_TOKEN_ID = "equipment_BiosTokenOverride_biosTokenId"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_BIOS_TOKEN_NAME = "equipment_BiosTokenOverride_biosTokenName"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_BIOS_TOKEN_VALUE = "equipment_BiosTokenOverride_biosTokenValue"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_DESCR = "equipment_BiosTokenOverride_descr"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_INT_ID = "equipment_BiosTokenOverride_intId"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_NAME = "equipment_BiosTokenOverride_name"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_POLICY_LEVEL = "equipment_BiosTokenOverride_policyLevel"
    SORT_PROP_EQUIPMENT_BIOS_TOKEN_OVERRIDE_POLICY_OWNER = "equipment_BiosTokenOverride_policyOwner"
    SORT_PROP_EQUIPMENT_BLADE_AGLIBRARY_DESCR = "equipment_BladeAGLibrary_descr"
    SORT_PROP_EQUIPMENT_BLADE_AGLIBRARY_INT_ID = "equipment_BladeAGLibrary_intId"
    SORT_PROP_EQUIPMENT_BLADE_AGLIBRARY_NAME = "equipment_BladeAGLibrary_name"
    SORT_PROP_EQUIPMENT_BLADE_AGLIBRARY_POLICY_LEVEL = "equipment_BladeAGLibrary_policyLevel"
    SORT_PROP_EQUIPMENT_BLADE_AGLIBRARY_POLICY_OWNER = "equipment_BladeAGLibrary_policyOwner"
    SORT_PROP_EQUIPMENT_BLADE_AGGREGATION_CAP_REF_IS_SUPPORTED = "equipment_BladeAggregationCapRef_isSupported"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_DELETED = "equipment_BladeBiosCapProvider_deleted"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_DEPRECATED = "equipment_BladeBiosCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BladeBiosCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BladeBiosCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_GENCOUNT = "equipment_BladeBiosCapProvider_gencount"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_GENERATION = "equipment_BladeBiosCapProvider_generation"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_LOAD_ERRORS = "equipment_BladeBiosCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BladeBiosCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BladeBiosCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_MODEL = "equipment_BladeBiosCapProvider_model"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_PRODUCT_NAME = "equipment_BladeBiosCapProvider_productName"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BladeBiosCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_REVISION = "equipment_BladeBiosCapProvider_revision"
    SORT_PROP_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_VENDOR = "equipment_BladeBiosCapProvider_vendor"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_TYPE_DEF_NUM_ADAPTER_SLOTS = "equipment_BladeCapProviderTypeDef_numAdapterSlots"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_TYPE_DEF_NUM_SLOTS = "equipment_BladeCapProviderTypeDef_numSlots"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_DELETED = "equipment_BladeCapProvider_deleted"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_DEPRECATED = "equipment_BladeCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BladeCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BladeCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_GENCOUNT = "equipment_BladeCapProvider_gencount"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_GENERATION = "equipment_BladeCapProvider_generation"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_LOAD_ERRORS = "equipment_BladeCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BladeCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BladeCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_MODEL = "equipment_BladeCapProvider_model"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BladeCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_REVISION = "equipment_BladeCapProvider_revision"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_VENDOR = "equipment_BladeCapProvider_vendor"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_FAMILY = "equipment_BladeConnDef_adaptorFamily"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_SLOT_NUMBER = "equipment_BladeConnDef_adaptorSlotNumber"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_SLOT_SPAN = "equipment_BladeConnDef_adaptorSlotSpan"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_TYPE = "equipment_BladeConnDef_adaptorType"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_DESCR = "equipment_BladeConnDef_descr"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_INT_ID = "equipment_BladeConnDef_intId"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_NAME = "equipment_BladeConnDef_name"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_PARENT_ADAPTOR_SLOT_NUM = "equipment_BladeConnDef_parentAdaptorSlotNum"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_POLICY_LEVEL = "equipment_BladeConnDef_policyLevel"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_POLICY_OWNER = "equipment_BladeConnDef_policyOwner"
    SORT_PROP_EQUIPMENT_BLADE_CONN_DEF_SWITCH_PORT_MUX_OFFSET = "equipment_BladeConnDef_switchPortMuxOffset"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_DESCR = "equipment_BladeIOMConnDef_descr"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_INT_ID = "equipment_BladeIOMConnDef_intId"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_IOCARD_TYPE = "equipment_BladeIOMConnDef_iocardType"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_NAME = "equipment_BladeIOMConnDef_name"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_POLICY_LEVEL = "equipment_BladeIOMConnDef_policyLevel"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_POLICY_OWNER = "equipment_BladeIOMConnDef_policyOwner"
    SORT_PROP_EQUIPMENT_BLADE_IOMCONN_DEF_PORT_BANDWIDTH = "equipment_BladeIOMConnDef_portBandwidth"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_DESCR = "equipment_BladeSwitchConnDef_descr"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_INT_ID = "equipment_BladeSwitchConnDef_intId"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_NAME = "equipment_BladeSwitchConnDef_name"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_POLICY_LEVEL = "equipment_BladeSwitchConnDef_policyLevel"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_POLICY_OWNER = "equipment_BladeSwitchConnDef_policyOwner"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_PORT_BANDWIDTH = "equipment_BladeSwitchConnDef_portBandwidth"
    SORT_PROP_EQUIPMENT_BLADE_SWITCH_CONN_DEF_SWITCH_TYPE = "equipment_BladeSwitchConnDef_switchType"
    SORT_PROP_EQUIPMENT_BOARD_CONTROLLER_DEF_DESCR = "equipment_BoardControllerDef_descr"
    SORT_PROP_EQUIPMENT_BOARD_CONTROLLER_DEF_INT_ID = "equipment_BoardControllerDef_intId"
    SORT_PROP_EQUIPMENT_BOARD_CONTROLLER_DEF_NAME = "equipment_BoardControllerDef_name"
    SORT_PROP_EQUIPMENT_BOARD_CONTROLLER_DEF_POLICY_LEVEL = "equipment_BoardControllerDef_policyLevel"
    SORT_PROP_EQUIPMENT_BOARD_CONTROLLER_DEF_POLICY_OWNER = "equipment_BoardControllerDef_policyOwner"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_BOOT_DEV_TYPE = "equipment_BootDeviceConstraints_bootDevType"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_DESCR = "equipment_BootDeviceConstraints_descr"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_INT_ID = "equipment_BootDeviceConstraints_intId"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_IS_SUPPORTED = "equipment_BootDeviceConstraints_isSupported"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_NAME = "equipment_BootDeviceConstraints_name"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_POLICY_LEVEL = "equipment_BootDeviceConstraints_policyLevel"
    SORT_PROP_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS_POLICY_OWNER = "equipment_BootDeviceConstraints_policyOwner"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_DESCR = "equipment_BreakoutCap_descr"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_EXT_PHY_PORT_BITMASK = "equipment_BreakoutCap_extPhyPortBitmask"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_INT_ID = "equipment_BreakoutCap_intId"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_NAME = "equipment_BreakoutCap_name"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_PHY_PORT_BITMASK = "equipment_BreakoutCap_phyPortBitmask"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_POLICY_LEVEL = "equipment_BreakoutCap_policyLevel"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_POLICY_OWNER = "equipment_BreakoutCap_policyOwner"
    SORT_PROP_EQUIPMENT_CAP_MOD_SPEC_PATH = "equipment_CapModSpec_path"
    SORT_PROP_EQUIPMENT_CARD_ID = "equipment_Card_id"
    SORT_PROP_EQUIPMENT_CARD_MODEL = "equipment_Card_model"
    SORT_PROP_EQUIPMENT_CARD_OPER_QUALIFIER_REASON = "equipment_Card_operQualifierReason"
    SORT_PROP_EQUIPMENT_CARD_OPER_STATE = "equipment_Card_operState"
    SORT_PROP_EQUIPMENT_CARD_OPERABILITY = "equipment_Card_operability"
    SORT_PROP_EQUIPMENT_CARD_PERF = "equipment_Card_perf"
    SORT_PROP_EQUIPMENT_CARD_POWER = "equipment_Card_power"
    SORT_PROP_EQUIPMENT_CARD_PRESENCE = "equipment_Card_presence"
    SORT_PROP_EQUIPMENT_CARD_REVISION = "equipment_Card_revision"
    SORT_PROP_EQUIPMENT_CARD_SERIAL = "equipment_Card_serial"
    SORT_PROP_EQUIPMENT_CARD_THERMAL = "equipment_Card_thermal"
    SORT_PROP_EQUIPMENT_CARD_VENDOR = "equipment_Card_vendor"
    SORT_PROP_EQUIPMENT_CARD_VOLTAGE = "equipment_Card_voltage"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_DELETED = "equipment_CartridgeCapProvider_deleted"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_DEPRECATED = "equipment_CartridgeCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_CartridgeCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_CartridgeCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_GENCOUNT = "equipment_CartridgeCapProvider_gencount"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_LOAD_ERRORS = "equipment_CartridgeCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_CartridgeCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_CartridgeCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_MODEL = "equipment_CartridgeCapProvider_model"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_CartridgeCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_REVISION = "equipment_CartridgeCapProvider_revision"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_VENDOR = "equipment_CartridgeCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_DELETED = "equipment_CatalogCapProvider_deleted"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_DEPRECATED = "equipment_CatalogCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_CatalogCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_CatalogCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_GENCOUNT = "equipment_CatalogCapProvider_gencount"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_LOAD_ERRORS = "equipment_CatalogCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_LOAD_WARNINGS = "equipment_CatalogCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_CatalogCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_MODEL = "equipment_CatalogCapProvider_model"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_CatalogCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_REVISION = "equipment_CatalogCapProvider_revision"
    SORT_PROP_EQUIPMENT_CATALOG_CAP_PROVIDER_VENDOR = "equipment_CatalogCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSOC_CTX_FRU_CAP_DN = "equipment_ChassisAssocCtx_fruCapDn"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_DELETED = "equipment_ChassisCapProvider_deleted"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_DEPRECATED = "equipment_ChassisCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ChassisCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ChassisCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_GENCOUNT = "equipment_ChassisCapProvider_gencount"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_LOAD_ERRORS = "equipment_ChassisCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ChassisCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ChassisCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_MODEL = "equipment_ChassisCapProvider_model"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ChassisCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_REVISION = "equipment_ChassisCapProvider_revision"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_VENDOR = "equipment_ChassisCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CHASSIS_COMPONENT_CHASSIS_ID = "equipment_ChassisComponent_chassisId"
    SORT_PROP_EQUIPMENT_CHASSIS_COMPONENT_SLOT_ID = "equipment_ChassisComponent_slotId"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_DESCR = "equipment_ChassisFsmStage_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_LAST_UPDATE_TIME = "equipment_ChassisFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_NAME = "equipment_ChassisFsmStage_name"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_ORDER = "equipment_ChassisFsmStage_order"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_RETRY = "equipment_ChassisFsmStage_retry"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_STAGE_STATUS = "equipment_ChassisFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_TASK_COMPLETION = "equipment_ChassisFsmTask_completion"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_TASK_FLAGS = "equipment_ChassisFsmTask_flags"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_TASK_ITEM = "equipment_ChassisFsmTask_item"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_TASK_SEQ_ID = "equipment_ChassisFsmTask_seqId"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_COMPLETION_TIME = "equipment_ChassisFsm_completionTime"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_CURRENT_FSM = "equipment_ChassisFsm_currentFsm"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_DESCR = "equipment_ChassisFsm_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_FSM_STATUS = "equipment_ChassisFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_INSTANCE_ID = "equipment_ChassisFsm_instanceId"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_PROGRESS = "equipment_ChassisFsm_progress"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_ERR_CODE = "equipment_ChassisFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_ERR_DESCR = "equipment_ChassisFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_RSLT = "equipment_ChassisFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_DESCR = "equipment_ChassisInheritPolicy_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_DST_DN = "equipment_ChassisInheritPolicy_dstDn"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_INT_ID = "equipment_ChassisInheritPolicy_intId"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_NAME = "equipment_ChassisInheritPolicy_name"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_OPER_QUALIFIER = "equipment_ChassisInheritPolicy_operQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_POLICY_LEVEL = "equipment_ChassisInheritPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_POLICY_OWNER = "equipment_ChassisInheritPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_CHASSIS_INHERIT_POLICY_QUALIFIER = "equipment_ChassisInheritPolicy_qualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_CHASSIS_CONFIG_ISSUES = "equipment_ChassisIssues_chassisConfigIssues"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_CONFIG_WARNINGS = "equipment_ChassisIssues_configWarnings"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_PROP_ACL = "equipment_ChassisIssues_propAcl"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_STORAGE_CONFIG_ISSUES = "equipment_ChassisIssues_storageConfigIssues"
    SORT_PROP_EQUIPMENT_CHASSIS_POS_QUAL_MAX_ID = "equipment_ChassisPosQual_maxId"
    SORT_PROP_EQUIPMENT_CHASSIS_POS_QUAL_MIN_ID = "equipment_ChassisPosQual_minId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX_PROP_ACL = "equipment_ChassisProfileAssocCtx_propAcl"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_ASSIGNED_TO_DN = "equipment_ChassisProfileBinding_assignedToDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_CHASSIS_DN = "equipment_ChassisProfileBinding_chassisDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_ISSUES = "equipment_ChassisProfileBinding_issues"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_NAME = "equipment_ChassisProfileBinding_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_OPER_STATE = "equipment_ChassisProfileBinding_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_RESTRICT_MIGRATION = "equipment_ChassisProfileBinding_restrictMigration"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_DESCR = "equipment_ChassisProfileFsmStage_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_LAST_UPDATE_TIME = "equipment_ChassisProfileFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_NAME = "equipment_ChassisProfileFsmStage_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_ORDER = "equipment_ChassisProfileFsmStage_order"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_RETRY = "equipment_ChassisProfileFsmStage_retry"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_STAGE_STATUS = "equipment_ChassisProfileFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_COMPLETION = "equipment_ChassisProfileFsmTask_completion"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_FLAGS = "equipment_ChassisProfileFsmTask_flags"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_ITEM = "equipment_ChassisProfileFsmTask_item"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_SEQ_ID = "equipment_ChassisProfileFsmTask_seqId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_COMPLETION_TIME = "equipment_ChassisProfileFsm_completionTime"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_CURRENT_FSM = "equipment_ChassisProfileFsm_currentFsm"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_DESCR = "equipment_ChassisProfileFsm_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_FSM_STATUS = "equipment_ChassisProfileFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_INSTANCE_ID = "equipment_ChassisProfileFsm_instanceId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PROGRESS = "equipment_ChassisProfileFsm_progress"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_ERR_CODE = "equipment_ChassisProfileFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_ERR_DESCR = "equipment_ChassisProfileFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_RSLT = "equipment_ChassisProfileFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_ASSIGN_STATE = "equipment_ChassisProfile_assignState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_ASSOC_STATE = "equipment_ChassisProfile_assocState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CHASSIS_DN = "equipment_ChassisProfile_chassisDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CHASSIS_FW_POLICY_NAME = "equipment_ChassisProfile_chassisFwPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_COMPUTE_CONN_POLICY_NAME = "equipment_ChassisProfile_computeConnPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CONFIG_QUALIFIER = "equipment_ChassisProfile_configQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CONFIG_STATE = "equipment_ChassisProfile_configState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DESCR = "equipment_ChassisProfile_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DISK_ZONING_POLICY_NAME = "equipment_ChassisProfile_diskZoningPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_DESCR = "equipment_ChassisProfile_fsmDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_FLAGS = "equipment_ChassisProfile_fsmFlags"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PREV = "equipment_ChassisProfile_fsmPrev"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PROGR = "equipment_ChassisProfile_fsmProgr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_ERR_CODE = "equipment_ChassisProfile_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_ERR_DESCR = "equipment_ChassisProfile_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_RSLT = "equipment_ChassisProfile_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_DESCR = "equipment_ChassisProfile_fsmStageDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAMP = "equipment_ChassisProfile_fsmStamp"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STATUS = "equipment_ChassisProfile_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TRY = "equipment_ChassisProfile_fsmTry"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_INT_ID = "equipment_ChassisProfile_intId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_MAINT_POLICY_NAME = "equipment_ChassisProfile_maintPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_NAME = "equipment_ChassisProfile_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_CHASSIS_FW_POLICY_NAME = "equipment_ChassisProfile_operChassisFwPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_COMPUTE_CONN_POLICY_NAME = "equipment_ChassisProfile_operComputeConnPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_DISK_ZONING_POLICY_NAME = "equipment_ChassisProfile_operDiskZoningPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_MAINT_POLICY_NAME = "equipment_ChassisProfile_operMaintPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_SAS_EXPANDER_CONFIG_POLICY_NAME = "equipment_ChassisProfile_operSasExpanderConfigPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_SRC_TEMPL_NAME = "equipment_ChassisProfile_operSrcTemplName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_STATE = "equipment_ChassisProfile_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OWNER = "equipment_ChassisProfile_owner"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_POLICY_LEVEL = "equipment_ChassisProfile_policyLevel"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_POLICY_OWNER = "equipment_ChassisProfile_policyOwner"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_PROP_ACL = "equipment_ChassisProfile_propAcl"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_RESOLVE_REMOTE = "equipment_ChassisProfile_resolveRemote"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_SAS_EXPANDER_CONFIG_POLICY_NAME = "equipment_ChassisProfile_sasExpanderConfigPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_SRC_TEMPL_NAME = "equipment_ChassisProfile_srcTemplName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_TYPE = "equipment_ChassisProfile_type"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_USR_LBL = "equipment_ChassisProfile_usrLbl"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_UUID = "equipment_ChassisProfile_uuid"
    SORT_PROP_EQUIPMENT_CHASSIS_QUAL_MAX_ID = "equipment_ChassisQual_maxId"
    SORT_PROP_EQUIPMENT_CHASSIS_QUAL_MIN_ID = "equipment_ChassisQual_minId"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_CHASSIS_I2_CERRORS = "equipment_ChassisStatsHist_ChassisI2CErrors"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_CHASSIS_I2_CERRORS_AVG = "equipment_ChassisStatsHist_ChassisI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_CHASSIS_I2_CERRORS_MAX = "equipment_ChassisStatsHist_ChassisI2CErrorsMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_CHASSIS_I2_CERRORS_MIN = "equipment_ChassisStatsHist_ChassisI2CErrorsMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_ID = "equipment_ChassisStatsHist_id"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER = "equipment_ChassisStatsHist_inputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_AVG = "equipment_ChassisStatsHist_inputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MAX = "equipment_ChassisStatsHist_inputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MIN = "equipment_ChassisStatsHist_inputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_MOST_RECENT = "equipment_ChassisStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER = "equipment_ChassisStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_AVG = "equipment_ChassisStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MAX = "equipment_ChassisStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MIN = "equipment_ChassisStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_SUSPECT = "equipment_ChassisStatsHist_suspect"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_THRESHOLDED = "equipment_ChassisStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_TIME_COLLECTED = "equipment_ChassisStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS = "equipment_ChassisStats_ChassisI2CErrors"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_AVG = "equipment_ChassisStats_ChassisI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_MAX = "equipment_ChassisStats_ChassisI2CErrorsMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_MIN = "equipment_ChassisStats_ChassisI2CErrorsMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER = "equipment_ChassisStats_inputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_AVG = "equipment_ChassisStats_inputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MAX = "equipment_ChassisStats_inputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MIN = "equipment_ChassisStats_inputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INTERVALS = "equipment_ChassisStats_intervals"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER = "equipment_ChassisStats_outputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_AVG = "equipment_ChassisStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MAX = "equipment_ChassisStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MIN = "equipment_ChassisStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_SUSPECT = "equipment_ChassisStats_suspect"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_THRESHOLDED = "equipment_ChassisStats_thresholded"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_TIME_COLLECTED = "equipment_ChassisStats_timeCollected"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_UPDATE = "equipment_ChassisStats_update"
    SORT_PROP_EQUIPMENT_CHASSIS_ACK_PROGRESS_INDICATOR = "equipment_Chassis_ackProgressIndicator"
    SORT_PROP_EQUIPMENT_CHASSIS_ADMIN_STATE = "equipment_Chassis_adminState"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSET_TAG = "equipment_Chassis_assetTag"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSIGNED_TO_DN = "equipment_Chassis_assignedToDn"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSOCIATION = "equipment_Chassis_association"
    SORT_PROP_EQUIPMENT_CHASSIS_AVAILABILITY = "equipment_Chassis_availability"
    SORT_PROP_EQUIPMENT_CHASSIS_CONFIG_STATE = "equipment_Chassis_configState"
    SORT_PROP_EQUIPMENT_CHASSIS_CONN_PATH = "equipment_Chassis_connPath"
    SORT_PROP_EQUIPMENT_CHASSIS_CONN_STATUS = "equipment_Chassis_connStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_DISCOVERY = "equipment_Chassis_discovery"
    SORT_PROP_EQUIPMENT_CHASSIS_DISCOVERY_STATUS = "equipment_Chassis_discoveryStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_FABRIC_EP_DN = "equipment_Chassis_fabricEpDn"
    SORT_PROP_EQUIPMENT_CHASSIS_FAN_SPEED_CONFIG_STATE = "equipment_Chassis_fanSpeedConfigState"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_DESCR = "equipment_Chassis_fsmDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_FLAGS = "equipment_Chassis_fsmFlags"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_PREV = "equipment_Chassis_fsmPrev"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_PROGR = "equipment_Chassis_fsmProgr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_INV_ERR_CODE = "equipment_Chassis_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_INV_ERR_DESCR = "equipment_Chassis_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_RMT_INV_RSLT = "equipment_Chassis_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAGE_DESCR = "equipment_Chassis_fsmStageDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STAMP = "equipment_Chassis_fsmStamp"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_STATUS = "equipment_Chassis_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_FSM_TRY = "equipment_Chassis_fsmTry"
    SORT_PROP_EQUIPMENT_CHASSIS_ID = "equipment_Chassis_id"
    SORT_PROP_EQUIPMENT_CHASSIS_LC_TS = "equipment_Chassis_lcTs"
    SORT_PROP_EQUIPMENT_CHASSIS_LIC_GP = "equipment_Chassis_licGP"
    SORT_PROP_EQUIPMENT_CHASSIS_LIC_STATE = "equipment_Chassis_licState"
    SORT_PROP_EQUIPMENT_CHASSIS_MANAGING_INST = "equipment_Chassis_managingInst"
    SORT_PROP_EQUIPMENT_CHASSIS_MFG_TIME = "equipment_Chassis_mfgTime"
    SORT_PROP_EQUIPMENT_CHASSIS_MODEL = "equipment_Chassis_model"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_QUALIFIER = "equipment_Chassis_operQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_QUALIFIER_REASON = "equipment_Chassis_operQualifierReason"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_STATE = "equipment_Chassis_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERABILITY = "equipment_Chassis_operability"
    SORT_PROP_EQUIPMENT_CHASSIS_PART_NUMBER = "equipment_Chassis_partNumber"
    SORT_PROP_EQUIPMENT_CHASSIS_POWER = "equipment_Chassis_power"
    SORT_PROP_EQUIPMENT_CHASSIS_PRESENCE = "equipment_Chassis_presence"
    SORT_PROP_EQUIPMENT_CHASSIS_REVISION = "equipment_Chassis_revision"
    SORT_PROP_EQUIPMENT_CHASSIS_SEEPROM_OPER_STATE = "equipment_Chassis_seepromOperState"
    SORT_PROP_EQUIPMENT_CHASSIS_SERIAL = "equipment_Chassis_serial"
    SORT_PROP_EQUIPMENT_CHASSIS_SERVICE_STATE = "equipment_Chassis_serviceState"
    SORT_PROP_EQUIPMENT_CHASSIS_THERMAL = "equipment_Chassis_thermal"
    SORT_PROP_EQUIPMENT_CHASSIS_THERMAL_STATE_QUALIFIER = "equipment_Chassis_thermalStateQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_USR_LBL = "equipment_Chassis_usrLbl"
    SORT_PROP_EQUIPMENT_CHASSIS_VENDOR = "equipment_Chassis_vendor"
    SORT_PROP_EQUIPMENT_CHASSIS_VERSION_HOLDER = "equipment_Chassis_versionHolder"
    SORT_PROP_EQUIPMENT_CHASSIS_VID = "equipment_Chassis_vid"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_DESCR = "equipment_CimcVmedia_descr"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_INT_ID = "equipment_CimcVmedia_intId"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_IS_SUPPORTED = "equipment_CimcVmedia_isSupported"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_MIN_BIOS_VERSION = "equipment_CimcVmedia_minBiosVersion"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_MIN_CIMC_VERSION = "equipment_CimcVmedia_minCimcVersion"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_NAME = "equipment_CimcVmedia_name"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_POLICY_LEVEL = "equipment_CimcVmedia_policyLevel"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_POLICY_OWNER = "equipment_CimcVmedia_policyOwner"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_DESCR = "equipment_CiscoOsOpenGate_descr"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_INT_ID = "equipment_CiscoOsOpenGate_intId"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_IS_SUPPORTED = "equipment_CiscoOsOpenGate_isSupported"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_MIN_CIMC_VERSION = "equipment_CiscoOsOpenGate_minCimcVersion"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_NAME = "equipment_CiscoOsOpenGate_name"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_POLICY_LEVEL = "equipment_CiscoOsOpenGate_policyLevel"
    SORT_PROP_EQUIPMENT_CISCO_OS_OPEN_GATE_POLICY_OWNER = "equipment_CiscoOsOpenGate_policyOwner"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_DESCR = "equipment_ComputeConnPolicy_descr"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_INT_ID = "equipment_ComputeConnPolicy_intId"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_NAME = "equipment_ComputeConnPolicy_name"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_POLICY_LEVEL = "equipment_ComputeConnPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_POLICY_OWNER = "equipment_ComputeConnPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_SERVER_SIOC_CONNECTIVITY = "equipment_ComputeConnPolicy_serverSiocConnectivity"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_SERVER_SIOC_CONNECTIVITY = "equipment_ComputeConn_serverSiocConnectivity"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_DELETED = "equipment_ComputePhysicalCapProvider_deleted"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_DEPRECATED = "equipment_ComputePhysicalCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ComputePhysicalCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ComputePhysicalCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_GENCOUNT = "equipment_ComputePhysicalCapProvider_gencount"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_GENERATION = "equipment_ComputePhysicalCapProvider_generation"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_LOAD_ERRORS = "equipment_ComputePhysicalCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ComputePhysicalCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ComputePhysicalCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_MODEL = "equipment_ComputePhysicalCapProvider_model"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ComputePhysicalCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_REVISION = "equipment_ComputePhysicalCapProvider_revision"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_VENDOR = "equipment_ComputePhysicalCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_DESCR = "equipment_ConfigPolicy_descr"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_INT_ID = "equipment_ConfigPolicy_intId"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_NAME = "equipment_ConfigPolicy_name"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_POLICY_LEVEL = "equipment_ConfigPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_POLICY_OWNER = "equipment_ConfigPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_CONFIG_POLICY_QUALIFIER = "equipment_ConfigPolicy_qualifier"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_CONN_PATH = "equipment_Connectivity_connPath"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_CONN_STATUS = "equipment_Connectivity_connStatus"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_DISCOVERY_STATUS = "equipment_Connectivity_discoveryStatus"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_MANAGING_INST = "equipment_Connectivity_managingInst"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_DELETED = "equipment_CoprocessorUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_CoprocessorUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_CoprocessorUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_CoprocessorUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_CoprocessorUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_CoprocessorUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_CoprocessorUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_CoprocessorUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_MODEL = "equipment_CoprocessorUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_CoprocessorUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_REVISION = "equipment_CoprocessorUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_COPROCESSOR_UNIT_CAP_PROVIDER_VENDOR = "equipment_CoprocessorUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_DELETED = "equipment_DbgPluginCapProvider_deleted"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_DEPRECATED = "equipment_DbgPluginCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_DbgPluginCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_DbgPluginCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_GENCOUNT = "equipment_DbgPluginCapProvider_gencount"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_LOAD_ERRORS = "equipment_DbgPluginCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_LOAD_WARNINGS = "equipment_DbgPluginCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_DbgPluginCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_MODEL = "equipment_DbgPluginCapProvider_model"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_DbgPluginCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_REVISION = "equipment_DbgPluginCapProvider_revision"
    SORT_PROP_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_VENDOR = "equipment_DbgPluginCapProvider_vendor"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_DESCR = "equipment_DiagFeatureSupport_descr"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_INT_ID = "equipment_DiagFeatureSupport_intId"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_IS_SUPPORTED = "equipment_DiagFeatureSupport_isSupported"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_NAME = "equipment_DiagFeatureSupport_name"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_POLICY_LEVEL = "equipment_DiagFeatureSupport_policyLevel"
    SORT_PROP_EQUIPMENT_DIAG_FEATURE_SUPPORT_POLICY_OWNER = "equipment_DiagFeatureSupport_policyOwner"
    SORT_PROP_EQUIPMENT_DIMM_ENTRY_ID = "equipment_DimmEntry_id"
    SORT_PROP_EQUIPMENT_DIMM_ENTRY_SMBIOSNAME = "equipment_DimmEntry_smbiosname"
    SORT_PROP_EQUIPMENT_DIMM_MAPPING_DESCR = "equipment_DimmMapping_descr"
    SORT_PROP_EQUIPMENT_DIMM_MAPPING_INT_ID = "equipment_DimmMapping_intId"
    SORT_PROP_EQUIPMENT_DIMM_MAPPING_NAME = "equipment_DimmMapping_name"
    SORT_PROP_EQUIPMENT_DIMM_MAPPING_POLICY_LEVEL = "equipment_DimmMapping_policyLevel"
    SORT_PROP_EQUIPMENT_DIMM_MAPPING_POLICY_OWNER = "equipment_DimmMapping_policyOwner"
    SORT_PROP_EQUIPMENT_DISCOVERY_CAP_OPER_POWER_REQUIREMENT = "equipment_DiscoveryCap_operPowerRequirement"
    SORT_PROP_EQUIPMENT_DOWNGRADE_CONSTRAINT_MIN_VER = "equipment_DowngradeConstraint_minVer"
    SORT_PROP_EQUIPMENT_DRIVE_SEC_CAP_IS_SUPPORTED = "equipment_DriveSecCap_isSupported"
    SORT_PROP_EQUIPMENT_DRIVE_SEC_CAP_MIN_VERSION = "equipment_DriveSecCap_minVersion"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_AHCI_SETTING = "equipment_EmbeddedControllerConfig_ahciSetting"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_DESCR = "equipment_EmbeddedControllerConfig_descr"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_INT_ID = "equipment_EmbeddedControllerConfig_intId"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_MODE_CONFIG_TOKEN = "equipment_EmbeddedControllerConfig_modeConfigToken"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_NAME = "equipment_EmbeddedControllerConfig_name"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_POLICY_LEVEL = "equipment_EmbeddedControllerConfig_policyLevel"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_POLICY_OWNER = "equipment_EmbeddedControllerConfig_policyOwner"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_SW_RAID_SETTING = "equipment_EmbeddedControllerConfig_swRaidSetting"
    SORT_PROP_EQUIPMENT_EMBEDDED_CONTROLLER_CONFIG_TOKEN_FEAT_GROUP = "equipment_EmbeddedControllerConfig_tokenFeatGroup"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_BLOCK_SIZE = "equipment_EmbeddedStorageDef_blockSize"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_CONNECTION_PROTOCOL = "equipment_EmbeddedStorageDef_connectionProtocol"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_DESCR = "equipment_EmbeddedStorageDef_descr"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_DEVICE_TYPE = "equipment_EmbeddedStorageDef_deviceType"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_INT_ID = "equipment_EmbeddedStorageDef_intId"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_NAME = "equipment_EmbeddedStorageDef_name"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_NUMBER_OF_BLOCKS = "equipment_EmbeddedStorageDef_numberOfBlocks"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_POLICY_LEVEL = "equipment_EmbeddedStorageDef_policyLevel"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_POLICY_OWNER = "equipment_EmbeddedStorageDef_policyOwner"
    SORT_PROP_EQUIPMENT_EMBEDDED_STORAGE_DEF_SIZE = "equipment_EmbeddedStorageDef_size"
    SORT_PROP_EQUIPMENT_ENV_SENSOR_NAME = "equipment_EnvSensor_name"
    SORT_PROP_EQUIPMENT_ENV_SENSOR_TYPE = "equipment_EnvSensor_type"
    SORT_PROP_EQUIPMENT_ENV_SENSOR_VALUE = "equipment_EnvSensor_value"
    SORT_PROP_EQUIPMENT_FAN_AGGRESSIVE_COOLING_CAP_IS_SUPPORTED = "equipment_FanAggressiveCoolingCap_isSupported"
    SORT_PROP_EQUIPMENT_FAN_AGGRESSIVE_COOLING_CAP_MIN_CIMC_VERSION = "equipment_FanAggressiveCoolingCap_minCimcVersion"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_DELETED = "equipment_FanModuleCapProvider_deleted"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_DEPRECATED = "equipment_FanModuleCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FanModuleCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FanModuleCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_GENCOUNT = "equipment_FanModuleCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_LOAD_ERRORS = "equipment_FanModuleCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FanModuleCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FanModuleCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MODEL = "equipment_FanModuleCapProvider_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FanModuleCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_REVISION = "equipment_FanModuleCapProvider_revision"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_VENDOR = "equipment_FanModuleCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_DESCR = "equipment_FanModuleDef_descr"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_FAN_CAPACITY = "equipment_FanModuleDef_fanCapacity"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_INT_ID = "equipment_FanModuleDef_intId"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_NAME = "equipment_FanModuleDef_name"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_POLICY_LEVEL = "equipment_FanModuleDef_policyLevel"
    SORT_PROP_EQUIPMENT_FAN_MODULE_DEF_POLICY_OWNER = "equipment_FanModuleDef_policyOwner"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_FAN_MODULE_I2_CERRORS = "equipment_FanModuleStatsHist_FanModuleI2CErrors"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_FAN_MODULE_I2_CERRORS_AVG = "equipment_FanModuleStatsHist_FanModuleI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_FAN_MODULE_I2_CERRORS_MAX = "equipment_FanModuleStatsHist_FanModuleI2CErrorsMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_FAN_MODULE_I2_CERRORS_MIN = "equipment_FanModuleStatsHist_FanModuleI2CErrorsMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP = "equipment_FanModuleStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_FanModuleStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_FanModuleStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_FanModuleStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_ID = "equipment_FanModuleStatsHist_id"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_MOST_RECENT = "equipment_FanModuleStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_SUSPECT = "equipment_FanModuleStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_THRESHOLDED = "equipment_FanModuleStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_TIME_COLLECTED = "equipment_FanModuleStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS = "equipment_FanModuleStats_FanModuleI2CErrors"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_AVG = "equipment_FanModuleStats_FanModuleI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_MAX = "equipment_FanModuleStats_FanModuleI2CErrorsMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_MIN = "equipment_FanModuleStats_FanModuleI2CErrorsMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP = "equipment_FanModuleStats_ambientTemp"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_AVG = "equipment_FanModuleStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MAX = "equipment_FanModuleStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MIN = "equipment_FanModuleStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_INTERVALS = "equipment_FanModuleStats_intervals"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_SUSPECT = "equipment_FanModuleStats_suspect"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_THRESHOLDED = "equipment_FanModuleStats_thresholded"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_TIME_COLLECTED = "equipment_FanModuleStats_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_UPDATE = "equipment_FanModuleStats_update"
    SORT_PROP_EQUIPMENT_FAN_MODULE_ASSET_TAG = "equipment_FanModule_assetTag"
    SORT_PROP_EQUIPMENT_FAN_MODULE_ID = "equipment_FanModule_id"
    SORT_PROP_EQUIPMENT_FAN_MODULE_MFG_TIME = "equipment_FanModule_mfgTime"
    SORT_PROP_EQUIPMENT_FAN_MODULE_MODEL = "equipment_FanModule_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPER_QUALIFIER_REASON = "equipment_FanModule_operQualifierReason"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPER_STATE = "equipment_FanModule_operState"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPERABILITY = "equipment_FanModule_operability"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PART_NUMBER = "equipment_FanModule_partNumber"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PERF = "equipment_FanModule_perf"
    SORT_PROP_EQUIPMENT_FAN_MODULE_POWER = "equipment_FanModule_power"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PRESENCE = "equipment_FanModule_presence"
    SORT_PROP_EQUIPMENT_FAN_MODULE_REVISION = "equipment_FanModule_revision"
    SORT_PROP_EQUIPMENT_FAN_MODULE_SERIAL = "equipment_FanModule_serial"
    SORT_PROP_EQUIPMENT_FAN_MODULE_THERMAL = "equipment_FanModule_thermal"
    SORT_PROP_EQUIPMENT_FAN_MODULE_TRAY = "equipment_FanModule_tray"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VENDOR = "equipment_FanModule_vendor"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VID = "equipment_FanModule_vid"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VOLTAGE = "equipment_FanModule_voltage"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_DESCR = "equipment_FanPresenceDef_descr"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_FAN_MODULE_NUMBER = "equipment_FanPresenceDef_fanModuleNumber"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_INT_ID = "equipment_FanPresenceDef_intId"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_NAME = "equipment_FanPresenceDef_name"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_POLICY_LEVEL = "equipment_FanPresenceDef_policyLevel"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_POLICY_OWNER = "equipment_FanPresenceDef_policyOwner"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE_DEF_PRESENCE = "equipment_FanPresenceDef_presence"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_ID = "equipment_FanStatsHist_id"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_FanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED = "equipment_FanStatsHist_speed"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_FanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_FanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_FanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SUSPECT = "equipment_FanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_FanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_FanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_STATS_INTERVALS = "equipment_FanStats_intervals"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED = "equipment_FanStats_speed"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_AVG = "equipment_FanStats_speedAvg"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_MAX = "equipment_FanStats_speedMax"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_MIN = "equipment_FanStats_speedMin"
    SORT_PROP_EQUIPMENT_FAN_STATS_SUSPECT = "equipment_FanStats_suspect"
    SORT_PROP_EQUIPMENT_FAN_STATS_THRESHOLDED = "equipment_FanStats_thresholded"
    SORT_PROP_EQUIPMENT_FAN_STATS_TIME_COLLECTED = "equipment_FanStats_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_STATS_UPDATE = "equipment_FanStats_update"
    SORT_PROP_EQUIPMENT_FAN_FAN_SPEED_POLICY_ADMIN_STATE = "equipment_Fan_fanSpeedPolicyAdminState"
    SORT_PROP_EQUIPMENT_FAN_FAN_SPEED_POLICY_OPER_STATE = "equipment_Fan_fanSpeedPolicyOperState"
    SORT_PROP_EQUIPMENT_FAN_ID = "equipment_Fan_id"
    SORT_PROP_EQUIPMENT_FAN_INT_TYPE = "equipment_Fan_intType"
    SORT_PROP_EQUIPMENT_FAN_MODEL = "equipment_Fan_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE = "equipment_Fan_module"
    SORT_PROP_EQUIPMENT_FAN_OPER_QUALIFIER_REASON = "equipment_Fan_operQualifierReason"
    SORT_PROP_EQUIPMENT_FAN_OPER_STATE = "equipment_Fan_operState"
    SORT_PROP_EQUIPMENT_FAN_OPERABILITY = "equipment_Fan_operability"
    SORT_PROP_EQUIPMENT_FAN_PERF = "equipment_Fan_perf"
    SORT_PROP_EQUIPMENT_FAN_POWER = "equipment_Fan_power"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE = "equipment_Fan_presence"
    SORT_PROP_EQUIPMENT_FAN_REVISION = "equipment_Fan_revision"
    SORT_PROP_EQUIPMENT_FAN_SERIAL = "equipment_Fan_serial"
    SORT_PROP_EQUIPMENT_FAN_THERMAL = "equipment_Fan_thermal"
    SORT_PROP_EQUIPMENT_FAN_TRAY = "equipment_Fan_tray"
    SORT_PROP_EQUIPMENT_FAN_VENDOR = "equipment_Fan_vendor"
    SORT_PROP_EQUIPMENT_FAN_VOLTAGE = "equipment_Fan_voltage"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_DELETED = "equipment_FexCapProvider_deleted"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_DEPRECATED = "equipment_FexCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FexCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FexCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_GENCOUNT = "equipment_FexCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_LOAD_ERRORS = "equipment_FexCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FexCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FexCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_MODEL = "equipment_FexCapProvider_model"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FexCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_REVISION = "equipment_FexCapProvider_revision"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_ROLE = "equipment_FexCapProvider_role"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_VENDOR = "equipment_FexCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1 = "equipment_FexEnvStatsHist_die1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_AVG = "equipment_FexEnvStatsHist_die1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MAX = "equipment_FexEnvStatsHist_die1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MIN = "equipment_FexEnvStatsHist_die1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_ID = "equipment_FexEnvStatsHist_id"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET = "equipment_FexEnvStatsHist_inlet"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1 = "equipment_FexEnvStatsHist_inlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_AVG = "equipment_FexEnvStatsHist_inlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MAX = "equipment_FexEnvStatsHist_inlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MIN = "equipment_FexEnvStatsHist_inlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_AVG = "equipment_FexEnvStatsHist_inletAvg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MAX = "equipment_FexEnvStatsHist_inletMax"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MIN = "equipment_FexEnvStatsHist_inletMin"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_MOST_RECENT = "equipment_FexEnvStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1 = "equipment_FexEnvStatsHist_outlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_AVG = "equipment_FexEnvStatsHist_outlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MAX = "equipment_FexEnvStatsHist_outlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MIN = "equipment_FexEnvStatsHist_outlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2 = "equipment_FexEnvStatsHist_outlet2"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_AVG = "equipment_FexEnvStatsHist_outlet2Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MAX = "equipment_FexEnvStatsHist_outlet2Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MIN = "equipment_FexEnvStatsHist_outlet2Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_SUSPECT = "equipment_FexEnvStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_THRESHOLDED = "equipment_FexEnvStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_TIME_COLLECTED = "equipment_FexEnvStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1 = "equipment_FexEnvStats_die1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_AVG = "equipment_FexEnvStats_die1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_MAX = "equipment_FexEnvStats_die1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_MIN = "equipment_FexEnvStats_die1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET = "equipment_FexEnvStats_inlet"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1 = "equipment_FexEnvStats_inlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_AVG = "equipment_FexEnvStats_inlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_MAX = "equipment_FexEnvStats_inlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_MIN = "equipment_FexEnvStats_inlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_AVG = "equipment_FexEnvStats_inletAvg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_MAX = "equipment_FexEnvStats_inletMax"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_MIN = "equipment_FexEnvStats_inletMin"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INPUT_STATUS = "equipment_FexEnvStats_inputStatus"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INTERVALS = "equipment_FexEnvStats_intervals"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1 = "equipment_FexEnvStats_outlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_AVG = "equipment_FexEnvStats_outlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MAX = "equipment_FexEnvStats_outlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MIN = "equipment_FexEnvStats_outlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2 = "equipment_FexEnvStats_outlet2"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_AVG = "equipment_FexEnvStats_outlet2Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MAX = "equipment_FexEnvStats_outlet2Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MIN = "equipment_FexEnvStats_outlet2Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_SUSPECT = "equipment_FexEnvStats_suspect"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_THRESHOLDED = "equipment_FexEnvStats_thresholded"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_TIME_COLLECTED = "equipment_FexEnvStats_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_UPDATE = "equipment_FexEnvStats_update"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_DESCR = "equipment_FexFsmStage_descr"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_LAST_UPDATE_TIME = "equipment_FexFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_NAME = "equipment_FexFsmStage_name"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_ORDER = "equipment_FexFsmStage_order"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_RETRY = "equipment_FexFsmStage_retry"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_STAGE_STATUS = "equipment_FexFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_FEX_FSM_TASK_COMPLETION = "equipment_FexFsmTask_completion"
    SORT_PROP_EQUIPMENT_FEX_FSM_TASK_FLAGS = "equipment_FexFsmTask_flags"
    SORT_PROP_EQUIPMENT_FEX_FSM_TASK_ITEM = "equipment_FexFsmTask_item"
    SORT_PROP_EQUIPMENT_FEX_FSM_TASK_SEQ_ID = "equipment_FexFsmTask_seqId"
    SORT_PROP_EQUIPMENT_FEX_FSM_COMPLETION_TIME = "equipment_FexFsm_completionTime"
    SORT_PROP_EQUIPMENT_FEX_FSM_CURRENT_FSM = "equipment_FexFsm_currentFsm"
    SORT_PROP_EQUIPMENT_FEX_FSM_DESCR = "equipment_FexFsm_descr"
    SORT_PROP_EQUIPMENT_FEX_FSM_FSM_STATUS = "equipment_FexFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_FEX_FSM_INSTANCE_ID = "equipment_FexFsm_instanceId"
    SORT_PROP_EQUIPMENT_FEX_FSM_PROGRESS = "equipment_FexFsm_progress"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_ERR_CODE = "equipment_FexFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_ERR_DESCR = "equipment_FexFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_RSLT = "equipment_FexFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER = "equipment_FexPowerSummaryHist_ModulePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_AVG = "equipment_FexPowerSummaryHist_ModulePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MAX = "equipment_FexPowerSummaryHist_ModulePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MIN = "equipment_FexPowerSummaryHist_ModulePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER = "equipment_FexPowerSummaryHist_availablePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_AVG = "equipment_FexPowerSummaryHist_availablePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MAX = "equipment_FexPowerSummaryHist_availablePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MIN = "equipment_FexPowerSummaryHist_availablePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_ID = "equipment_FexPowerSummaryHist_id"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MOST_RECENT = "equipment_FexPowerSummaryHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER = "equipment_FexPowerSummaryHist_reservedPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_AVG = "equipment_FexPowerSummaryHist_reservedPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MAX = "equipment_FexPowerSummaryHist_reservedPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MIN = "equipment_FexPowerSummaryHist_reservedPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_SUSPECT = "equipment_FexPowerSummaryHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_THRESHOLDED = "equipment_FexPowerSummaryHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TIME_COLLECTED = "equipment_FexPowerSummaryHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER = "equipment_FexPowerSummaryHist_totalPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_AVG = "equipment_FexPowerSummaryHist_totalPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MAX = "equipment_FexPowerSummaryHist_totalPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MIN = "equipment_FexPowerSummaryHist_totalPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER = "equipment_FexPowerSummary_ModulePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_AVG = "equipment_FexPowerSummary_ModulePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MAX = "equipment_FexPowerSummary_ModulePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MIN = "equipment_FexPowerSummary_ModulePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER = "equipment_FexPowerSummary_availablePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_AVG = "equipment_FexPowerSummary_availablePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MAX = "equipment_FexPowerSummary_availablePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MIN = "equipment_FexPowerSummary_availablePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_INTERVALS = "equipment_FexPowerSummary_intervals"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER = "equipment_FexPowerSummary_reservedPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_AVG = "equipment_FexPowerSummary_reservedPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MAX = "equipment_FexPowerSummary_reservedPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MIN = "equipment_FexPowerSummary_reservedPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_SUSPECT = "equipment_FexPowerSummary_suspect"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_THRESHOLDED = "equipment_FexPowerSummary_thresholded"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TIME_COLLECTED = "equipment_FexPowerSummary_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER = "equipment_FexPowerSummary_totalPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_AVG = "equipment_FexPowerSummary_totalPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MAX = "equipment_FexPowerSummary_totalPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MIN = "equipment_FexPowerSummary_totalPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_UPDATE = "equipment_FexPowerSummary_update"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT = "equipment_FexPsuInputStatsHist_current"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_FexPsuInputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_FexPsuInputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_FexPsuInputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_ID = "equipment_FexPsuInputStatsHist_id"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_FexPsuInputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER = "equipment_FexPsuInputStatsHist_power"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_FexPsuInputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_FexPsuInputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_FexPsuInputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_FexPsuInputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_FexPsuInputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_FexPsuInputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_FexPsuInputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_FexPsuInputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_FexPsuInputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_FexPsuInputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT = "equipment_FexPsuInputStats_current"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_AVG = "equipment_FexPsuInputStats_currentAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MAX = "equipment_FexPsuInputStats_currentMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MIN = "equipment_FexPsuInputStats_currentMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_INPUT_STATUS = "equipment_FexPsuInputStats_inputStatus"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_INTERVALS = "equipment_FexPsuInputStats_intervals"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER = "equipment_FexPsuInputStats_power"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_AVG = "equipment_FexPsuInputStats_powerAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MAX = "equipment_FexPsuInputStats_powerMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MIN = "equipment_FexPsuInputStats_powerMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_SUSPECT = "equipment_FexPsuInputStats_suspect"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_THRESHOLDED = "equipment_FexPsuInputStats_thresholded"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_FexPsuInputStats_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_UPDATE = "equipment_FexPsuInputStats_update"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE = "equipment_FexPsuInputStats_voltage"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_FexPsuInputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_FexPsuInputStats_voltageMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_FexPsuInputStats_voltageMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_ID = "equipment_FexSystemStatsHist_id"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_FREE = "equipment_FexSystemStatsHist_kernelMemFree"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_FREE_AVG = "equipment_FexSystemStatsHist_kernelMemFreeAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_FREE_MAX = "equipment_FexSystemStatsHist_kernelMemFreeMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_FREE_MIN = "equipment_FexSystemStatsHist_kernelMemFreeMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_TOTAL = "equipment_FexSystemStatsHist_kernelMemTotal"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_TOTAL_AVG = "equipment_FexSystemStatsHist_kernelMemTotalAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_TOTAL_MAX = "equipment_FexSystemStatsHist_kernelMemTotalMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_KERNEL_MEM_TOTAL_MIN = "equipment_FexSystemStatsHist_kernelMemTotalMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_LOAD = "equipment_FexSystemStatsHist_load"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_LOAD_AVG = "equipment_FexSystemStatsHist_loadAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_LOAD_MAX = "equipment_FexSystemStatsHist_loadMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_LOAD_MIN = "equipment_FexSystemStatsHist_loadMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_AVAILABLE = "equipment_FexSystemStatsHist_memAvailable"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_AVAILABLE_AVG = "equipment_FexSystemStatsHist_memAvailableAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_AVAILABLE_MAX = "equipment_FexSystemStatsHist_memAvailableMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_AVAILABLE_MIN = "equipment_FexSystemStatsHist_memAvailableMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_CACHED = "equipment_FexSystemStatsHist_memCached"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_CACHED_AVG = "equipment_FexSystemStatsHist_memCachedAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_CACHED_MAX = "equipment_FexSystemStatsHist_memCachedMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MEM_CACHED_MIN = "equipment_FexSystemStatsHist_memCachedMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_MOST_RECENT = "equipment_FexSystemStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_SUSPECT = "equipment_FexSystemStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_THRESHOLDED = "equipment_FexSystemStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_HIST_TIME_COLLECTED = "equipment_FexSystemStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_INTERVALS = "equipment_FexSystemStats_intervals"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_FREE = "equipment_FexSystemStats_kernelMemFree"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_FREE_AVG = "equipment_FexSystemStats_kernelMemFreeAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_FREE_MAX = "equipment_FexSystemStats_kernelMemFreeMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_FREE_MIN = "equipment_FexSystemStats_kernelMemFreeMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_TOTAL = "equipment_FexSystemStats_kernelMemTotal"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_TOTAL_AVG = "equipment_FexSystemStats_kernelMemTotalAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_TOTAL_MAX = "equipment_FexSystemStats_kernelMemTotalMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_KERNEL_MEM_TOTAL_MIN = "equipment_FexSystemStats_kernelMemTotalMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_LOAD = "equipment_FexSystemStats_load"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_LOAD_AVG = "equipment_FexSystemStats_loadAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_LOAD_MAX = "equipment_FexSystemStats_loadMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_LOAD_MIN = "equipment_FexSystemStats_loadMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_AVAILABLE = "equipment_FexSystemStats_memAvailable"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_AVAILABLE_AVG = "equipment_FexSystemStats_memAvailableAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_AVAILABLE_MAX = "equipment_FexSystemStats_memAvailableMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_AVAILABLE_MIN = "equipment_FexSystemStats_memAvailableMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_CACHED = "equipment_FexSystemStats_memCached"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_CACHED_AVG = "equipment_FexSystemStats_memCachedAvg"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_CACHED_MAX = "equipment_FexSystemStats_memCachedMax"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_MEM_CACHED_MIN = "equipment_FexSystemStats_memCachedMin"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_SUSPECT = "equipment_FexSystemStats_suspect"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_THRESHOLDED = "equipment_FexSystemStats_thresholded"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_TIME_COLLECTED = "equipment_FexSystemStats_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_SYSTEM_STATS_UPDATE = "equipment_FexSystemStats_update"
    SORT_PROP_EQUIPMENT_FEX_ADMIN_POWER_STATE = "equipment_Fex_adminPowerState"
    SORT_PROP_EQUIPMENT_FEX_ADMIN_STATE = "equipment_Fex_adminState"
    SORT_PROP_EQUIPMENT_FEX_CONFIG_STATE = "equipment_Fex_configState"
    SORT_PROP_EQUIPMENT_FEX_FSM_DESCR = "equipment_Fex_fsmDescr"
    SORT_PROP_EQUIPMENT_FEX_FSM_PREV = "equipment_Fex_fsmPrev"
    SORT_PROP_EQUIPMENT_FEX_FSM_PROGR = "equipment_Fex_fsmProgr"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_INV_ERR_CODE = "equipment_Fex_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_INV_ERR_DESCR = "equipment_Fex_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_FEX_FSM_RMT_INV_RSLT = "equipment_Fex_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAGE_DESCR = "equipment_Fex_fsmStageDescr"
    SORT_PROP_EQUIPMENT_FEX_FSM_STAMP = "equipment_Fex_fsmStamp"
    SORT_PROP_EQUIPMENT_FEX_FSM_STATUS = "equipment_Fex_fsmStatus"
    SORT_PROP_EQUIPMENT_FEX_FSM_TRY = "equipment_Fex_fsmTry"
    SORT_PROP_EQUIPMENT_FEX_ID = "equipment_Fex_id"
    SORT_PROP_EQUIPMENT_FEX_LIC_GP = "equipment_Fex_licGP"
    SORT_PROP_EQUIPMENT_FEX_LIC_STATE = "equipment_Fex_licState"
    SORT_PROP_EQUIPMENT_FEX_MODEL = "equipment_Fex_model"
    SORT_PROP_EQUIPMENT_FEX_OPER_QUALIFIER = "equipment_Fex_operQualifier"
    SORT_PROP_EQUIPMENT_FEX_OPER_QUALIFIER_REASON = "equipment_Fex_operQualifierReason"
    SORT_PROP_EQUIPMENT_FEX_OPER_STATE = "equipment_Fex_operState"
    SORT_PROP_EQUIPMENT_FEX_OPERABILITY = "equipment_Fex_operability"
    SORT_PROP_EQUIPMENT_FEX_POWER = "equipment_Fex_power"
    SORT_PROP_EQUIPMENT_FEX_PRESENCE = "equipment_Fex_presence"
    SORT_PROP_EQUIPMENT_FEX_REVISION = "equipment_Fex_revision"
    SORT_PROP_EQUIPMENT_FEX_SERIAL = "equipment_Fex_serial"
    SORT_PROP_EQUIPMENT_FEX_SWITCH_ID = "equipment_Fex_switchId"
    SORT_PROP_EQUIPMENT_FEX_THERMAL = "equipment_Fex_thermal"
    SORT_PROP_EQUIPMENT_FEX_USR_LBL = "equipment_Fex_usrLbl"
    SORT_PROP_EQUIPMENT_FEX_VENDOR = "equipment_Fex_vendor"
    SORT_PROP_EQUIPMENT_FEX_VOLTAGE = "equipment_Fex_voltage"
    SORT_PROP_EQUIPMENT_FIRMWARE_CONSTRAINT_MIN_VER1 = "equipment_FirmwareConstraint_minVer1"
    SORT_PROP_EQUIPMENT_FIRMWARE_CONSTRAINT_MIN_VER2 = "equipment_FirmwareConstraint_minVer2"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_CARD_PARAM_TYPE = "equipment_FlashLife_cardParamType"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_DESCR = "equipment_FlashLife_descr"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_INT_ID = "equipment_FlashLife_intId"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_NAME = "equipment_FlashLife_name"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_POLICY_LEVEL = "equipment_FlashLife_policyLevel"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_POLICY_OWNER = "equipment_FlashLife_policyOwner"
    SORT_PROP_EQUIPMENT_FLASH_LIFE_SUPORT_TYPE = "equipment_FlashLife_suportType"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_DESCR = "equipment_FlexFlashNonRemovable_descr"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_INT_ID = "equipment_FlexFlashNonRemovable_intId"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_IS_SUPPORTED = "equipment_FlexFlashNonRemovable_isSupported"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_MIN_CIMC_VERSION = "equipment_FlexFlashNonRemovable_minCimcVersion"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_NAME = "equipment_FlexFlashNonRemovable_name"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_POLICY_LEVEL = "equipment_FlexFlashNonRemovable_policyLevel"
    SORT_PROP_EQUIPMENT_FLEX_FLASH_NON_REMOVABLE_POLICY_OWNER = "equipment_FlexFlashNonRemovable_policyOwner"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_DELETED = "equipment_FruCapProvider_deleted"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_DEPRECATED = "equipment_FruCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FruCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FruCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_GENCOUNT = "equipment_FruCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_LOAD_ERRORS = "equipment_FruCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FruCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FruCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_MODEL = "equipment_FruCapProvider_model"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FruCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_REVISION = "equipment_FruCapProvider_revision"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_VENDOR = "equipment_FruCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_DESCRIPTION = "equipment_FruVariant_description"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_PID = "equipment_FruVariant_pid"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_TYPE = "equipment_FruVariant_type"
    SORT_PROP_EQUIPMENT_FRUID_INFO_ASSET_TAG = "equipment_FruidInfo_assetTag"
    SORT_PROP_EQUIPMENT_FRUID_INFO_PART_NUMBER = "equipment_FruidInfo_partNumber"
    SORT_PROP_EQUIPMENT_FRUID_INFO_VID = "equipment_FruidInfo_vid"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_DELETED = "equipment_GemCapProvider_deleted"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_DEPRECATED = "equipment_GemCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_GemCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_GemCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_GENCOUNT = "equipment_GemCapProvider_gencount"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_LOAD_ERRORS = "equipment_GemCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_LOAD_WARNINGS = "equipment_GemCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_GemCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_MODEL = "equipment_GemCapProvider_model"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_GemCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_REVISION = "equipment_GemCapProvider_revision"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_VENDOR = "equipment_GemCapProvider_vendor"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_DESCR = "equipment_GemPortCap_descr"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_INT_ID = "equipment_GemPortCap_intId"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_MAX_FC_SPEED = "equipment_GemPortCap_maxFcSpeed"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_NAME = "equipment_GemPortCap_name"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_POLICY_LEVEL = "equipment_GemPortCap_policyLevel"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_POLICY_OWNER = "equipment_GemPortCap_policyOwner"
    SORT_PROP_EQUIPMENT_GEM_PORT_CAP_PORT_NUMBER = "equipment_GemPortCap_portNumber"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_DELETED = "equipment_GraphicsCardCapProvider_deleted"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_DEPRECATED = "equipment_GraphicsCardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_GraphicsCardCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_GraphicsCardCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_GENCOUNT = "equipment_GraphicsCardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_GraphicsCardCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_GraphicsCardCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_GraphicsCardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_MODE_CHANGE_SUPPORTED = "equipment_GraphicsCardCapProvider_modeChangeSupported"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_MODEL = "equipment_GraphicsCardCapProvider_model"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_NUM_GPU = "equipment_GraphicsCardCapProvider_numGpu"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_GraphicsCardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_REVISION = "equipment_GraphicsCardCapProvider_revision"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_STEPPING = "equipment_GraphicsCardCapProvider_stepping"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_VENDOR = "equipment_GraphicsCardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_REF_IS_SUPPORTED = "equipment_GraphicsCardCapRef_isSupported"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_REF_MODEL = "equipment_GraphicsCardCapRef_model"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_REF_REVISION = "equipment_GraphicsCardCapRef_revision"
    SORT_PROP_EQUIPMENT_GRAPHICS_CARD_CAP_REF_VENDOR = "equipment_GraphicsCardCapRef_vendor"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_CONTROLLER_FW_VERSION = "equipment_HDDFaultMonDef_ControllerFwVersion"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_CONTROLLER_MODEL = "equipment_HDDFaultMonDef_ControllerModel"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_HDDMON_SUPPORT = "equipment_HDDFaultMonDef_HDDMonSupport"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_DESCR = "equipment_HDDFaultMonDef_descr"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_INT_ID = "equipment_HDDFaultMonDef_intId"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_NAME = "equipment_HDDFaultMonDef_name"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_POLICY_LEVEL = "equipment_HDDFaultMonDef_policyLevel"
    SORT_PROP_EQUIPMENT_HDDFAULT_MON_DEF_POLICY_OWNER = "equipment_HDDFaultMonDef_policyOwner"
    SORT_PROP_EQUIPMENT_HEALTH_LED_COLOR = "equipment_HealthLed_color"
    SORT_PROP_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE = "equipment_HealthLed_healthLedState"
    SORT_PROP_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE_QUALIFIER = "equipment_HealthLed_healthLedStateQualifier"
    SORT_PROP_EQUIPMENT_HEALTH_LED_ID = "equipment_HealthLed_id"
    SORT_PROP_EQUIPMENT_HEALTH_LED_NAME = "equipment_HealthLed_name"
    SORT_PROP_EQUIPMENT_HEALTH_LED_OPER_STATE = "equipment_HealthLed_operState"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_DELETED = "equipment_HolderCapProvider_deleted"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_DEPRECATED = "equipment_HolderCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HolderCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HolderCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_GENCOUNT = "equipment_HolderCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_LOAD_ERRORS = "equipment_HolderCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HolderCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HolderCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_MODEL = "equipment_HolderCapProvider_model"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HolderCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_REVISION = "equipment_HolderCapProvider_revision"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_VENDOR = "equipment_HolderCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HOLDER_ID = "equipment_Holder_id"
    SORT_PROP_EQUIPMENT_HOLDER_MODEL = "equipment_Holder_model"
    SORT_PROP_EQUIPMENT_HOLDER_OPER_QUALIFIER_REASON = "equipment_Holder_operQualifierReason"
    SORT_PROP_EQUIPMENT_HOLDER_OPERABILITY = "equipment_Holder_operability"
    SORT_PROP_EQUIPMENT_HOLDER_PRESENCE = "equipment_Holder_presence"
    SORT_PROP_EQUIPMENT_HOLDER_REVISION = "equipment_Holder_revision"
    SORT_PROP_EQUIPMENT_HOLDER_SERIAL = "equipment_Holder_serial"
    SORT_PROP_EQUIPMENT_HOLDER_VENDOR = "equipment_Holder_vendor"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_DELETED = "equipment_HostIfCapProvider_deleted"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_DEPRECATED = "equipment_HostIfCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HostIfCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HostIfCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_GENCOUNT = "equipment_HostIfCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_LOAD_ERRORS = "equipment_HostIfCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HostIfCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HostIfCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_MODEL = "equipment_HostIfCapProvider_model"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HostIfCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_REVISION = "equipment_HostIfCapProvider_revision"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_VENDOR = "equipment_HostIfCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HOST_MGMT_CONTROLLER_CAP_COMM_METHOD = "equipment_HostMgmtControllerCap_commMethod"
    SORT_PROP_EQUIPMENT_HOST_MGMT_CONTROLLER_CAP_COMM_TYPE = "equipment_HostMgmtControllerCap_commType"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_DELETED = "equipment_HwCapDerivativeProvider_deleted"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_DEPRECATED = "equipment_HwCapDerivativeProvider_deprecated"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HwCapDerivativeProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_ELEMENTS_LOADED = "equipment_HwCapDerivativeProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_GENCOUNT = "equipment_HwCapDerivativeProvider_gencount"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_LOAD_ERRORS = "equipment_HwCapDerivativeProvider_loadErrors"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_LOAD_WARNINGS = "equipment_HwCapDerivativeProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_MGMT_PLANE_VER = "equipment_HwCapDerivativeProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_MODEL = "equipment_HwCapDerivativeProvider_model"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_REVISION = "equipment_HwCapDerivativeProvider_revision"
    SORT_PROP_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER_VENDOR = "equipment_HwCapDerivativeProvider_vendor"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_DELETED = "equipment_HwCapProvider_deleted"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_DEPRECATED = "equipment_HwCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HwCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HwCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_GENCOUNT = "equipment_HwCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_LOAD_ERRORS = "equipment_HwCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HwCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HwCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_MODEL = "equipment_HwCapProvider_model"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_REVISION = "equipment_HwCapProvider_revision"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_VENDOR = "equipment_HwCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HW_REVISION_MODIFIER_HW_TYPE = "equipment_HwRevisionModifier_hwType"
    SORT_PROP_EQUIPMENT_HW_REVISION_MODIFIER_REVISION = "equipment_HwRevisionModifier_revision"
    SORT_PROP_EQUIPMENT_HX_CAP_IS_SED_SUPPORTED = "equipment_HxCap_isSedSupported"
    SORT_PROP_EQUIPMENT_HX_CAP_IS_USB_NIC_SUPPORTED = "equipment_HxCap_isUsbNicSupported"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_DESCR = "equipment_IOCardBaseFsmStage_descr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_LAST_UPDATE_TIME = "equipment_IOCardBaseFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_NAME = "equipment_IOCardBaseFsmStage_name"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_ORDER = "equipment_IOCardBaseFsmStage_order"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_RETRY = "equipment_IOCardBaseFsmStage_retry"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_STAGE_STATUS = "equipment_IOCardBaseFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_TASK_COMPLETION = "equipment_IOCardBaseFsmTask_completion"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_TASK_FLAGS = "equipment_IOCardBaseFsmTask_flags"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_TASK_ITEM = "equipment_IOCardBaseFsmTask_item"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_TASK_SEQ_ID = "equipment_IOCardBaseFsmTask_seqId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_COMPLETION_TIME = "equipment_IOCardBaseFsm_completionTime"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_CURRENT_FSM = "equipment_IOCardBaseFsm_currentFsm"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_DESCR = "equipment_IOCardBaseFsm_descr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_FSM_STATUS = "equipment_IOCardBaseFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_INSTANCE_ID = "equipment_IOCardBaseFsm_instanceId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_PROGRESS = "equipment_IOCardBaseFsm_progress"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_ERR_CODE = "equipment_IOCardBaseFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_ERR_DESCR = "equipment_IOCardBaseFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_RSLT = "equipment_IOCardBaseFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_PEER_POWER_STATE = "equipment_IOCardBase_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_POWER_STATE = "equipment_IOCardBase_adminPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_STATE = "equipment_IOCardBase_adminState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_BASE_ADDR = "equipment_IOCardBase_baseAddr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_CHASSIS_ID = "equipment_IOCardBase_chassisId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_CONFIG_STATE = "equipment_IOCardBase_configState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_DISCOVERY = "equipment_IOCardBase_discovery"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FE_OFFLINE_TS = "equipment_IOCardBase_feOfflineTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FE_READY_TS = "equipment_IOCardBase_feReadyTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FLT_AGGR = "equipment_IOCardBase_fltAggr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_DESCR = "equipment_IOCardBase_fsmDescr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_FLAGS = "equipment_IOCardBase_fsmFlags"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_PREV = "equipment_IOCardBase_fsmPrev"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_PROGR = "equipment_IOCardBase_fsmProgr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_INV_ERR_CODE = "equipment_IOCardBase_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_INV_ERR_DESCR = "equipment_IOCardBase_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_RMT_INV_RSLT = "equipment_IOCardBase_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAGE_DESCR = "equipment_IOCardBase_fsmStageDescr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STAMP = "equipment_IOCardBase_fsmStamp"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_STATUS = "equipment_IOCardBase_fsmStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FSM_TRY = "equipment_IOCardBase_fsmTry"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ID = "equipment_IOCardBase_id"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_LC_NAME = "equipment_IOCardBase_lcName"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_LC_TS = "equipment_IOCardBase_lcTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_MODEL = "equipment_IOCardBase_model"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_EVAC_STATE = "equipment_IOCardBase_operEvacState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_QUALIFIER = "equipment_IOCardBase_operQualifier"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_QUALIFIER_REASON = "equipment_IOCardBase_operQualifierReason"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_STATE = "equipment_IOCardBase_operState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPERABILITY = "equipment_IOCardBase_operability"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PEER_COMM_STATUS = "equipment_IOCardBase_peerCommStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PEER_DN = "equipment_IOCardBase_peerDn"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PERF = "equipment_IOCardBase_perf"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_POWER = "equipment_IOCardBase_power"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PRESENCE = "equipment_IOCardBase_presence"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PROCESSOR_THERMAL_STATE = "equipment_IOCardBase_processorThermalState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_REVISION = "equipment_IOCardBase_revision"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SERIAL = "equipment_IOCardBase_serial"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SIDE = "equipment_IOCardBase_side"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SWITCH_ID = "equipment_IOCardBase_switchId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_THERMAL = "equipment_IOCardBase_thermal"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_UPGRADE_STATUS = "equipment_IOCardBase_upgradeStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_USR_LBL = "equipment_IOCardBase_usrLbl"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_VENDOR = "equipment_IOCardBase_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_VOLTAGE = "equipment_IOCardBase_voltage"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_DELETED = "equipment_IOCardCapProvider_deleted"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_DEPRECATED = "equipment_IOCardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_IOCardCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_IOCardCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_GENCOUNT = "equipment_IOCardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_IOCardCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_IOCardCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IOCardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_MODEL = "equipment_IOCardCapProvider_model"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IOCardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_REVISION = "equipment_IOCardCapProvider_revision"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_VENDOR = "equipment_IOCardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_DESCR = "equipment_IOCardFsmStage_descr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_LAST_UPDATE_TIME = "equipment_IOCardFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_NAME = "equipment_IOCardFsmStage_name"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_ORDER = "equipment_IOCardFsmStage_order"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_RETRY = "equipment_IOCardFsmStage_retry"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_STAGE_STATUS = "equipment_IOCardFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_TASK_COMPLETION = "equipment_IOCardFsmTask_completion"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_TASK_FLAGS = "equipment_IOCardFsmTask_flags"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_TASK_ITEM = "equipment_IOCardFsmTask_item"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_TASK_SEQ_ID = "equipment_IOCardFsmTask_seqId"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_COMPLETION_TIME = "equipment_IOCardFsm_completionTime"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_CURRENT_FSM = "equipment_IOCardFsm_currentFsm"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_DESCR = "equipment_IOCardFsm_descr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_FSM_STATUS = "equipment_IOCardFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_INSTANCE_ID = "equipment_IOCardFsm_instanceId"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_PROGRESS = "equipment_IOCardFsm_progress"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_ERR_CODE = "equipment_IOCardFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_ERR_DESCR = "equipment_IOCardFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_RSLT = "equipment_IOCardFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_IOM_I2_CERRORS = "equipment_IOCardStatsHist_IomI2CErrors"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_IOM_I2_CERRORS_AVG = "equipment_IOCardStatsHist_IomI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_IOM_I2_CERRORS_MAX = "equipment_IOCardStatsHist_IomI2CErrorsMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_IOM_I2_CERRORS_MIN = "equipment_IOCardStatsHist_IomI2CErrorsMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP = "equipment_IOCardStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_IOCardStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_IOCardStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_IOCardStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_DIMM_TEMP = "equipment_IOCardStatsHist_dimmTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_DIMM_TEMP_AVG = "equipment_IOCardStatsHist_dimmTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_DIMM_TEMP_MAX = "equipment_IOCardStatsHist_dimmTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_DIMM_TEMP_MIN = "equipment_IOCardStatsHist_dimmTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_ID = "equipment_IOCardStatsHist_id"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_MOST_RECENT = "equipment_IOCardStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_PROC_TEMP = "equipment_IOCardStatsHist_procTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_PROC_TEMP_AVG = "equipment_IOCardStatsHist_procTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_PROC_TEMP_MAX = "equipment_IOCardStatsHist_procTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_PROC_TEMP_MIN = "equipment_IOCardStatsHist_procTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_SUSPECT = "equipment_IOCardStatsHist_suspect"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP = "equipment_IOCardStatsHist_temp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_AVG = "equipment_IOCardStatsHist_tempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MAX = "equipment_IOCardStatsHist_tempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MIN = "equipment_IOCardStatsHist_tempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_THRESHOLDED = "equipment_IOCardStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TIME_COLLECTED = "equipment_IOCardStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS = "equipment_IOCardStats_IomI2CErrors"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_AVG = "equipment_IOCardStats_IomI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_MAX = "equipment_IOCardStats_IomI2CErrorsMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_MIN = "equipment_IOCardStats_IomI2CErrorsMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP = "equipment_IOCardStats_ambientTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_AVG = "equipment_IOCardStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MAX = "equipment_IOCardStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MIN = "equipment_IOCardStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_DIMM_TEMP = "equipment_IOCardStats_dimmTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_DIMM_TEMP_AVG = "equipment_IOCardStats_dimmTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_DIMM_TEMP_MAX = "equipment_IOCardStats_dimmTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_DIMM_TEMP_MIN = "equipment_IOCardStats_dimmTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_INTERVALS = "equipment_IOCardStats_intervals"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_PROC_TEMP = "equipment_IOCardStats_procTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_PROC_TEMP_AVG = "equipment_IOCardStats_procTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_PROC_TEMP_MAX = "equipment_IOCardStats_procTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_PROC_TEMP_MIN = "equipment_IOCardStats_procTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_SUSPECT = "equipment_IOCardStats_suspect"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP = "equipment_IOCardStats_temp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_AVG = "equipment_IOCardStats_tempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_MAX = "equipment_IOCardStats_tempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_MIN = "equipment_IOCardStats_tempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_THRESHOLDED = "equipment_IOCardStats_thresholded"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TIME_COLLECTED = "equipment_IOCardStats_timeCollected"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_UPDATE = "equipment_IOCardStats_update"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_DESCR = "equipment_IOCardTypeDef_descr"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_INT_ID = "equipment_IOCardTypeDef_intId"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_NAME = "equipment_IOCardTypeDef_name"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_POLICY_LEVEL = "equipment_IOCardTypeDef_policyLevel"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_POLICY_OWNER = "equipment_IOCardTypeDef_policyOwner"
    SORT_PROP_EQUIPMENT_IOCARD_TYPE_DEF_TYPE = "equipment_IOCardTypeDef_type"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_PEER_POWER_STATE = "equipment_IOCard_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_POWER_STATE = "equipment_IOCard_adminPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_STATE = "equipment_IOCard_adminState"
    SORT_PROP_EQUIPMENT_IOCARD_ASSET_TAG = "equipment_IOCard_assetTag"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADDR = "equipment_IOCard_baseAddr"
    SORT_PROP_EQUIPMENT_IOCARD_CHASSIS_ID = "equipment_IOCard_chassisId"
    SORT_PROP_EQUIPMENT_IOCARD_CONFIG_STATE = "equipment_IOCard_configState"
    SORT_PROP_EQUIPMENT_IOCARD_DISCOVERY = "equipment_IOCard_discovery"
    SORT_PROP_EQUIPMENT_IOCARD_FE_OFFLINE_TS = "equipment_IOCard_feOfflineTs"
    SORT_PROP_EQUIPMENT_IOCARD_FE_READY_TS = "equipment_IOCard_feReadyTs"
    SORT_PROP_EQUIPMENT_IOCARD_FLT_AGGR = "equipment_IOCard_fltAggr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_DESCR = "equipment_IOCard_fsmDescr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_FLAGS = "equipment_IOCard_fsmFlags"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_PREV = "equipment_IOCard_fsmPrev"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_PROGR = "equipment_IOCard_fsmProgr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_INV_ERR_CODE = "equipment_IOCard_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_INV_ERR_DESCR = "equipment_IOCard_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_RMT_INV_RSLT = "equipment_IOCard_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAGE_DESCR = "equipment_IOCard_fsmStageDescr"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STAMP = "equipment_IOCard_fsmStamp"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_STATUS = "equipment_IOCard_fsmStatus"
    SORT_PROP_EQUIPMENT_IOCARD_FSM_TRY = "equipment_IOCard_fsmTry"
    SORT_PROP_EQUIPMENT_IOCARD_ID = "equipment_IOCard_id"
    SORT_PROP_EQUIPMENT_IOCARD_LC_NAME = "equipment_IOCard_lcName"
    SORT_PROP_EQUIPMENT_IOCARD_LC_TS = "equipment_IOCard_lcTs"
    SORT_PROP_EQUIPMENT_IOCARD_MFG_TIME = "equipment_IOCard_mfgTime"
    SORT_PROP_EQUIPMENT_IOCARD_MODEL = "equipment_IOCard_model"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_EVAC_STATE = "equipment_IOCard_operEvacState"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_QUALIFIER = "equipment_IOCard_operQualifier"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_QUALIFIER_REASON = "equipment_IOCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_STATE = "equipment_IOCard_operState"
    SORT_PROP_EQUIPMENT_IOCARD_OPERABILITY = "equipment_IOCard_operability"
    SORT_PROP_EQUIPMENT_IOCARD_PART_NUMBER = "equipment_IOCard_partNumber"
    SORT_PROP_EQUIPMENT_IOCARD_PEER_COMM_STATUS = "equipment_IOCard_peerCommStatus"
    SORT_PROP_EQUIPMENT_IOCARD_PEER_DN = "equipment_IOCard_peerDn"
    SORT_PROP_EQUIPMENT_IOCARD_PERF = "equipment_IOCard_perf"
    SORT_PROP_EQUIPMENT_IOCARD_POWER = "equipment_IOCard_power"
    SORT_PROP_EQUIPMENT_IOCARD_PRESENCE = "equipment_IOCard_presence"
    SORT_PROP_EQUIPMENT_IOCARD_PROCESSOR_THERMAL_STATE = "equipment_IOCard_processorThermalState"
    SORT_PROP_EQUIPMENT_IOCARD_REVISION = "equipment_IOCard_revision"
    SORT_PROP_EQUIPMENT_IOCARD_SERIAL = "equipment_IOCard_serial"
    SORT_PROP_EQUIPMENT_IOCARD_SIDE = "equipment_IOCard_side"
    SORT_PROP_EQUIPMENT_IOCARD_SLOW_DRAIN_ADMIN_STATE = "equipment_IOCard_slowDrainAdminState"
    SORT_PROP_EQUIPMENT_IOCARD_SLOW_DRAIN_CORRECTION = "equipment_IOCard_slowDrainCorrection"
    SORT_PROP_EQUIPMENT_IOCARD_SWITCH_ID = "equipment_IOCard_switchId"
    SORT_PROP_EQUIPMENT_IOCARD_THERMAL = "equipment_IOCard_thermal"
    SORT_PROP_EQUIPMENT_IOCARD_UPGRADE_STATUS = "equipment_IOCard_upgradeStatus"
    SORT_PROP_EQUIPMENT_IOCARD_USR_LBL = "equipment_IOCard_usrLbl"
    SORT_PROP_EQUIPMENT_IOCARD_VENDOR = "equipment_IOCard_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_VID = "equipment_IOCard_vid"
    SORT_PROP_EQUIPMENT_IOCARD_VOLTAGE = "equipment_IOCard_voltage"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_DELETED = "equipment_IOExpanderCapProvider_deleted"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_DEPRECATED = "equipment_IOExpanderCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_IOExpanderCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_IOExpanderCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_GENCOUNT = "equipment_IOExpanderCapProvider_gencount"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_LOAD_ERRORS = "equipment_IOExpanderCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_IOExpanderCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IOExpanderCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_MODEL = "equipment_IOExpanderCapProvider_model"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IOExpanderCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_REVISION = "equipment_IOExpanderCapProvider_revision"
    SORT_PROP_EQUIPMENT_IOEXPANDER_CAP_PROVIDER_VENDOR = "equipment_IOExpanderCapProvider_vendor"
    SORT_PROP_EQUIPMENT_IOEXPANDER_ASSET_TAG = "equipment_IOExpander_assetTag"
    SORT_PROP_EQUIPMENT_IOEXPANDER_ID = "equipment_IOExpander_id"
    SORT_PROP_EQUIPMENT_IOEXPANDER_LOCATION_DN = "equipment_IOExpander_locationDn"
    SORT_PROP_EQUIPMENT_IOEXPANDER_MODEL = "equipment_IOExpander_model"
    SORT_PROP_EQUIPMENT_IOEXPANDER_OPER_QUALIFIER_REASON = "equipment_IOExpander_operQualifierReason"
    SORT_PROP_EQUIPMENT_IOEXPANDER_OPER_STATE = "equipment_IOExpander_operState"
    SORT_PROP_EQUIPMENT_IOEXPANDER_OPERABILITY = "equipment_IOExpander_operability"
    SORT_PROP_EQUIPMENT_IOEXPANDER_PART_NUMBER = "equipment_IOExpander_partNumber"
    SORT_PROP_EQUIPMENT_IOEXPANDER_PERF = "equipment_IOExpander_perf"
    SORT_PROP_EQUIPMENT_IOEXPANDER_POWER = "equipment_IOExpander_power"
    SORT_PROP_EQUIPMENT_IOEXPANDER_PRESENCE = "equipment_IOExpander_presence"
    SORT_PROP_EQUIPMENT_IOEXPANDER_REVISION = "equipment_IOExpander_revision"
    SORT_PROP_EQUIPMENT_IOEXPANDER_SERIAL = "equipment_IOExpander_serial"
    SORT_PROP_EQUIPMENT_IOEXPANDER_THERMAL = "equipment_IOExpander_thermal"
    SORT_PROP_EQUIPMENT_IOEXPANDER_VENDOR = "equipment_IOExpander_vendor"
    SORT_PROP_EQUIPMENT_IOEXPANDER_VID = "equipment_IOExpander_vid"
    SORT_PROP_EQUIPMENT_IOEXPANDER_VOLTAGE = "equipment_IOExpander_voltage"
    SORT_PROP_EQUIPMENT_INBAND_MGMT_CAP_IS_SUPPORTED = "equipment_InbandMgmtCap_isSupported"
    SORT_PROP_EQUIPMENT_INBAND_MGMT_CAP_MIN_CIMC_VERSION = "equipment_InbandMgmtCap_minCimcVersion"
    SORT_PROP_EQUIPMENT_INBAND_MGMT_CAP_MIN_CMC_VERSION = "equipment_InbandMgmtCap_minCmcVersion"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_COLOR = "equipment_IndicatorLed_color"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_ID = "equipment_IndicatorLed_id"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_NAME = "equipment_IndicatorLed_name"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_OPER_STATE = "equipment_IndicatorLed_operState"
    SORT_PROP_EQUIPMENT_INFO_MODEL = "equipment_Info_model"
    SORT_PROP_EQUIPMENT_INFO_REVISION = "equipment_Info_revision"
    SORT_PROP_EQUIPMENT_INFO_SERIAL = "equipment_Info_serial"
    SORT_PROP_EQUIPMENT_INFO_VENDOR = "equipment_Info_vendor"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_DESCR = "equipment_InitConfigPolicy_descr"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_DST_DN = "equipment_InitConfigPolicy_dstDn"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_INT_ID = "equipment_InitConfigPolicy_intId"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_NAME = "equipment_InitConfigPolicy_name"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_POLICY_LEVEL = "equipment_InitConfigPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_POLICY_OWNER = "equipment_InitConfigPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_INIT_CONFIG_POLICY_QUALIFIER = "equipment_InitConfigPolicy_qualifier"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_DELETED = "equipment_IntegratedComponentCapProvider_deleted"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_DEPRECATED = "equipment_IntegratedComponentCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_IntegratedComponentCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_IntegratedComponentCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_GENCOUNT = "equipment_IntegratedComponentCapProvider_gencount"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_LOAD_ERRORS = "equipment_IntegratedComponentCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_IntegratedComponentCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IntegratedComponentCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MODEL = "equipment_IntegratedComponentCapProvider_model"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IntegratedComponentCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_REVISION = "equipment_IntegratedComponentCapProvider_revision"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_VENDOR = "equipment_IntegratedComponentCapProvider_vendor"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_CLEANUP_PARENT_ON_DISCOVERY = "equipment_InventoryStatus_cleanupParentOnDiscovery"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_HW_INVENTORY_STATUS = "equipment_InventoryStatus_hwInventoryStatus"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_ID = "equipment_InventoryStatus_id"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_MODEL = "equipment_InventoryStatus_model"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_REVISION = "equipment_InventoryStatus_revision"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_SERIAL = "equipment_InventoryStatus_serial"
    SORT_PROP_EQUIPMENT_INVENTORY_STATUS_VENDOR = "equipment_InventoryStatus_vendor"
    SORT_PROP_EQUIPMENT_ITEM_IF_ID = "equipment_ItemIf_id"
    SORT_PROP_EQUIPMENT_ITEM_ID = "equipment_Item_id"
    SORT_PROP_EQUIPMENT_ITEM_MODEL = "equipment_Item_model"
    SORT_PROP_EQUIPMENT_ITEM_REVISION = "equipment_Item_revision"
    SORT_PROP_EQUIPMENT_ITEM_SERIAL = "equipment_Item_serial"
    SORT_PROP_EQUIPMENT_ITEM_VENDOR = "equipment_Item_vendor"
    SORT_PROP_EQUIPMENT_KVM_MGMT_CAP_IS_SUPPORTED = "equipment_KvmMgmtCap_isSupported"
    SORT_PROP_EQUIPMENT_KVM_MGMT_CAP_MIN_CIMC_VERSION = "equipment_KvmMgmtCap_minCimcVersion"
    SORT_PROP_EQUIPMENT_KVM_MGMT_CAP_MIN_KVM_CERT_SUPPORTED_CIMC_VER = "equipment_KvmMgmtCap_minKvmCertSupportedCimcVer"
    SORT_PROP_EQUIPMENT_KVM_MGMT_CAP_MIN_WEB_UISUPPORTED_CIMC_VER = "equipment_KvmMgmtCap_minWebUISupportedCimcVer"
    SORT_PROP_EQUIPMENT_LED_COLOR = "equipment_Led_color"
    SORT_PROP_EQUIPMENT_LED_ID = "equipment_Led_id"
    SORT_PROP_EQUIPMENT_LED_NAME = "equipment_Led_name"
    SORT_PROP_EQUIPMENT_LED_OPER_STATE = "equipment_Led_operState"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_DELETED = "equipment_LocalDiskCapProvider_deleted"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_LocalDiskCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_LocalDiskCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskCapProvider_gencount"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_LOAD_ERRORS = "equipment_LocalDiskCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_LOAD_WARNINGS = "equipment_LocalDiskCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MODEL = "equipment_LocalDiskCapProvider_model"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_REVISION = "equipment_LocalDiskCapProvider_revision"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_VENDOR = "equipment_LocalDiskCapProvider_vendor"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_CARD_TYPE = "equipment_LocalDiskControllerCapProvider_cardType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_CONTAINMENT_METHOD = "equipment_LocalDiskControllerCapProvider_containmentMethod"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_CONTROLLER_MODE = "equipment_LocalDiskControllerCapProvider_controllerMode"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_CONTROLLER_TYPE = "equipment_LocalDiskControllerCapProvider_controllerType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_DELETED = "equipment_LocalDiskControllerCapProvider_deleted"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskControllerCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_LocalDiskControllerCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_LocalDiskControllerCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_FORM = "equipment_LocalDiskControllerCapProvider_form"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskControllerCapProvider_gencount"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_INTERNALPORTS = "equipment_LocalDiskControllerCapProvider_internalports"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_LOAD_ERRORS = "equipment_LocalDiskControllerCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_LocalDiskControllerCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskControllerCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MODEL = "equipment_LocalDiskControllerCapProvider_model"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_NUM_CONTROLLERS = "equipment_LocalDiskControllerCapProvider_numControllers"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_ON_BOARD_MEMORY_SIZE = "equipment_LocalDiskControllerCapProvider_onBoardMemorySize"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskControllerCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_REVISION = "equipment_LocalDiskControllerCapProvider_revision"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_VENDOR = "equipment_LocalDiskControllerCapProvider_vendor"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_IS_SUPPORTED = "equipment_LocalDiskControllerCapRef_isSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_MODEL = "equipment_LocalDiskControllerCapRef_model"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_REVISION = "equipment_LocalDiskControllerCapRef_revision"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_VENDOR = "equipment_LocalDiskControllerCapRef_vendor"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_AUTO_CONFIG_MODE_SUPPORTED = "equipment_LocalDiskControllerDef_autoConfigModeSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_CONFIG_PARM_MOD_SUPPORTED = "equipment_LocalDiskControllerDef_configParmModSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_CONTROLLER_DEF_TYPE = "equipment_LocalDiskControllerDef_controllerDefType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_CONTROLLER_SUB_TYPE = "equipment_LocalDiskControllerDef_controllerSubType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_DESCR = "equipment_LocalDiskControllerDef_descr"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_DISK_SHARING_SUPPORTED = "equipment_LocalDiskControllerDef_diskSharingSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_FORCE_UPDATE_VERSION = "equipment_LocalDiskControllerDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_HOT_PLUG_SUPPORTED = "equipment_LocalDiskControllerDef_hotPlugSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_INT_ID = "equipment_LocalDiskControllerDef_intId"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_JBOD_SHARING_SUPPORTED = "equipment_LocalDiskControllerDef_jbodSharingSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_NAME = "equipment_LocalDiskControllerDef_name"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_ON_BOARD_MEMORY_CHECK_NEEDED = "equipment_LocalDiskControllerDef_onBoardMemoryCheckNeeded"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_OOB_CONTROLLER_CLASS_IDENTIFIER = "equipment_LocalDiskControllerDef_oobControllerClassIdentifier"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_OOB_INTERFACE_SUPPORTED = "equipment_LocalDiskControllerDef_oobInterfaceSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_POLICY_LEVEL = "equipment_LocalDiskControllerDef_policyLevel"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_POLICY_OWNER = "equipment_LocalDiskControllerDef_policyOwner"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_TFM_SUPPORTED = "equipment_LocalDiskControllerDef_tfmSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_ZONING_SUPPORTED = "equipment_LocalDiskControllerDef_zoningSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_TYPE_DEF_IS_FLASH_LIFE_LEFT_SUPPORTED = "equipment_LocalDiskControllerTypeDef_isFlashLifeLeftSupported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_BLOCK_SIZE = "equipment_LocalDiskDef_blockSize"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_CACHE_SIZE = "equipment_LocalDiskDef_cacheSize"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_CAPACITY = "equipment_LocalDiskDef_capacity"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_DESCR = "equipment_LocalDiskDef_descr"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_FORCE_UPDATE_VERSION = "equipment_LocalDiskDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_INT_ID = "equipment_LocalDiskDef_intId"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_LINK_SPEED = "equipment_LocalDiskDef_linkSpeed"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_ME4308_SUPPORTED = "equipment_LocalDiskDef_me4308Supported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_NAME = "equipment_LocalDiskDef_name"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_NUMBER_OF_BLOCKS = "equipment_LocalDiskDef_numberOfBlocks"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_POLICY_LEVEL = "equipment_LocalDiskDef_policyLevel"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_POLICY_OWNER = "equipment_LocalDiskDef_policyOwner"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_ROTATIONAL_SPEED = "equipment_LocalDiskDef_rotationalSpeed"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SEEK_AVERAGE_READ_WRITE = "equipment_LocalDiskDef_seekAverageReadWrite"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SEEK_TRACK_TO_TRACK_READ_WRITE = "equipment_LocalDiskDef_seekTrackToTrackReadWrite"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SELF_ENCRYPTING_DRIVE = "equipment_LocalDiskDef_selfEncryptingDrive"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_TECHNOLOGY = "equipment_LocalDiskDef_technology"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_DESCR = "equipment_LocatorLedFsmStage_descr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_LAST_UPDATE_TIME = "equipment_LocatorLedFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_NAME = "equipment_LocatorLedFsmStage_name"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_ORDER = "equipment_LocatorLedFsmStage_order"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_RETRY = "equipment_LocatorLedFsmStage_retry"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_STAGE_STATUS = "equipment_LocatorLedFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_TASK_COMPLETION = "equipment_LocatorLedFsmTask_completion"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_TASK_FLAGS = "equipment_LocatorLedFsmTask_flags"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_TASK_ITEM = "equipment_LocatorLedFsmTask_item"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_TASK_SEQ_ID = "equipment_LocatorLedFsmTask_seqId"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_COMPLETION_TIME = "equipment_LocatorLedFsm_completionTime"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_CURRENT_FSM = "equipment_LocatorLedFsm_currentFsm"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_DESCR = "equipment_LocatorLedFsm_descr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_FSM_STATUS = "equipment_LocatorLedFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_INSTANCE_ID = "equipment_LocatorLedFsm_instanceId"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_PROGRESS = "equipment_LocatorLedFsm_progress"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_ERR_CODE = "equipment_LocatorLedFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_ERR_DESCR = "equipment_LocatorLedFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_RSLT = "equipment_LocatorLedFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_ADMIN_STATE = "equipment_LocatorLed_adminState"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_BOARD_TYPE = "equipment_LocatorLed_boardType"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_COLOR = "equipment_LocatorLed_color"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_DESCR = "equipment_LocatorLed_fsmDescr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_PREV = "equipment_LocatorLed_fsmPrev"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_PROGR = "equipment_LocatorLed_fsmProgr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_ERR_CODE = "equipment_LocatorLed_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_ERR_DESCR = "equipment_LocatorLed_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_RSLT = "equipment_LocatorLed_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAGE_DESCR = "equipment_LocatorLed_fsmStageDescr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STAMP = "equipment_LocatorLed_fsmStamp"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_STATUS = "equipment_LocatorLed_fsmStatus"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_FSM_TRY = "equipment_LocatorLed_fsmTry"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_ID = "equipment_LocatorLed_id"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_NAME = "equipment_LocatorLed_name"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPER_STATE = "equipment_LocatorLed_operState"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_CAPTION = "equipment_ManufacturingDef_caption"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_CLEI = "equipment_ManufacturingDef_clei"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_DESCR = "equipment_ManufacturingDef_descr"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_DESCRIPTION = "equipment_ManufacturingDef_description"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_FRU_MAJOR_TYPE = "equipment_ManufacturingDef_fruMajorType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_FRU_MINOR_TYPE = "equipment_ManufacturingDef_fruMinorType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_INT_ID = "equipment_ManufacturingDef_intId"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_IS_SEC_FW_UPDATE = "equipment_ManufacturingDef_isSecFwUpdate"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_NAME = "equipment_ManufacturingDef_name"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_OEM_NAME = "equipment_ManufacturingDef_oemName"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_OEM_PART_NUMBER = "equipment_ManufacturingDef_oemPartNumber"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_PART_NUMBER = "equipment_ManufacturingDef_partNumber"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_PID = "equipment_ManufacturingDef_pid"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_POLICY_LEVEL = "equipment_ManufacturingDef_policyLevel"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_POLICY_OWNER = "equipment_ManufacturingDef_policyOwner"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_SERIES = "equipment_ManufacturingDef_series"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_SKU = "equipment_ManufacturingDef_sku"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_VENDOR_EQUIPMENT_TYPE = "equipment_ManufacturingDef_vendorEquipmentType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_VID = "equipment_ManufacturingDef_vid"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_DELETED = "equipment_MemoryUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_MemoryUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MemoryUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MemoryUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_MemoryUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MemoryUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MemoryUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MemoryUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MODEL = "equipment_MemoryUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MemoryUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_REVISION = "equipment_MemoryUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_VENDOR = "equipment_MemoryUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_ACTION = "equipment_MemoryUnitDiscoveryModifierDef_action"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_CONSTRAINT_TYPE = "equipment_MemoryUnitDiscoveryModifierDef_constraintType"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_DESCR = "equipment_MemoryUnitDiscoveryModifierDef_descr"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_INT_ID = "equipment_MemoryUnitDiscoveryModifierDef_intId"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_NAME = "equipment_MemoryUnitDiscoveryModifierDef_name"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_POLICY_LEVEL = "equipment_MemoryUnitDiscoveryModifierDef_policyLevel"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_POLICY_OWNER = "equipment_MemoryUnitDiscoveryModifierDef_policyOwner"
    SORT_PROP_EQUIPMENT_MFG_INFO_MFG_TIME = "equipment_MfgInfo_mfgTime"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_DELETED = "equipment_MgmtCapProvider_deleted"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_DEPRECATED = "equipment_MgmtCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MgmtCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MgmtCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_GENCOUNT = "equipment_MgmtCapProvider_gencount"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MgmtCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MgmtCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MgmtCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_MODEL = "equipment_MgmtCapProvider_model"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MgmtCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_REVISION = "equipment_MgmtCapProvider_revision"
    SORT_PROP_EQUIPMENT_MGMT_CAP_PROVIDER_VENDOR = "equipment_MgmtCapProvider_vendor"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_DELETED = "equipment_MgmtExtCapProvider_deleted"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_DEPRECATED = "equipment_MgmtExtCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MgmtExtCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MgmtExtCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_GENCOUNT = "equipment_MgmtExtCapProvider_gencount"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MgmtExtCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MgmtExtCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MgmtExtCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_MODEL = "equipment_MgmtExtCapProvider_model"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MgmtExtCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_REVISION = "equipment_MgmtExtCapProvider_revision"
    SORT_PROP_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_VENDOR = "equipment_MgmtExtCapProvider_vendor"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_CARD_TYPE = "equipment_MiniStorageCapProvider_cardType"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_DELETED = "equipment_MiniStorageCapProvider_deleted"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_DEPRECATED = "equipment_MiniStorageCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MiniStorageCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MiniStorageCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_GENCOUNT = "equipment_MiniStorageCapProvider_gencount"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_LOAD_ERRORS = "equipment_MiniStorageCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MiniStorageCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MiniStorageCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_MODEL = "equipment_MiniStorageCapProvider_model"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MiniStorageCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_REVISION = "equipment_MiniStorageCapProvider_revision"
    SORT_PROP_EQUIPMENT_MINI_STORAGE_CAP_PROVIDER_VENDOR = "equipment_MiniStorageCapProvider_vendor"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStatsHist_drivePercentage"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStatsHist_drivePercentageAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStatsHist_drivePercentageMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStatsHist_drivePercentageMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_ID = "equipment_NetworkElementFanStatsHist_id"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_NetworkElementFanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED = "equipment_NetworkElementFanStatsHist_speed"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_NetworkElementFanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_NetworkElementFanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_NetworkElementFanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SUSPECT = "equipment_NetworkElementFanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_NetworkElementFanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_NetworkElementFanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_AIRFLOW_DIRECTION = "equipment_NetworkElementFanStats_airflowDirection"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStats_drivePercentage"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStats_drivePercentageAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStats_drivePercentageMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStats_drivePercentageMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_INTERVALS = "equipment_NetworkElementFanStats_intervals"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED = "equipment_NetworkElementFanStats_speed"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_AVG = "equipment_NetworkElementFanStats_speedAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MAX = "equipment_NetworkElementFanStats_speedMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MIN = "equipment_NetworkElementFanStats_speedMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SUSPECT = "equipment_NetworkElementFanStats_suspect"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_THRESHOLDED = "equipment_NetworkElementFanStats_thresholded"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_TIME_COLLECTED = "equipment_NetworkElementFanStats_timeCollected"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_UPDATE = "equipment_NetworkElementFanStats_update"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_DESCR = "equipment_NonCopperPassiveCap_descr"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_INT_ID = "equipment_NonCopperPassiveCap_intId"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_NAME = "equipment_NonCopperPassiveCap_name"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_PHY_PORT_BITMASK = "equipment_NonCopperPassiveCap_phyPortBitmask"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_POLICY_LEVEL = "equipment_NonCopperPassiveCap_policyLevel"
    SORT_PROP_EQUIPMENT_NON_COPPER_PASSIVE_CAP_POLICY_OWNER = "equipment_NonCopperPassiveCap_policyOwner"
    SORT_PROP_EQUIPMENT_NVME_DEF_DESCR = "equipment_NvmeDef_descr"
    SORT_PROP_EQUIPMENT_NVME_DEF_FRONT_DISK_SLOTS = "equipment_NvmeDef_frontDiskSlots"
    SORT_PROP_EQUIPMENT_NVME_DEF_INT_ID = "equipment_NvmeDef_intId"
    SORT_PROP_EQUIPMENT_NVME_DEF_M_SWITCH_DRIVE_INDEX = "equipment_NvmeDef_mSwitchDriveIndex"
    SORT_PROP_EQUIPMENT_NVME_DEF_M_SWITCH_SAS_MIXING_SUPPORTED = "equipment_NvmeDef_mSwitchSasMixingSupported"
    SORT_PROP_EQUIPMENT_NVME_DEF_MAX_NUMBER_OF_MSWITCH = "equipment_NvmeDef_maxNumberOfMSwitch"
    SORT_PROP_EQUIPMENT_NVME_DEF_NAME = "equipment_NvmeDef_name"
    SORT_PROP_EQUIPMENT_NVME_DEF_PCI_SLOTS = "equipment_NvmeDef_pciSlots"
    SORT_PROP_EQUIPMENT_NVME_DEF_POLICY_LEVEL = "equipment_NvmeDef_policyLevel"
    SORT_PROP_EQUIPMENT_NVME_DEF_POLICY_OWNER = "equipment_NvmeDef_policyOwner"
    SORT_PROP_EQUIPMENT_NVME_DEF_REAR_DISK_SLOTS = "equipment_NvmeDef_rearDiskSlots"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_DESCR = "equipment_NvmeSwitchConfig_descr"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_INT_ID = "equipment_NvmeSwitchConfig_intId"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_MAX_DRIVE_PER_CAGE = "equipment_NvmeSwitchConfig_maxDrivePerCage"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_NAME = "equipment_NvmeSwitchConfig_name"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_POLICY_LEVEL = "equipment_NvmeSwitchConfig_policyLevel"
    SORT_PROP_EQUIPMENT_NVME_SWITCH_CONFIG_POLICY_OWNER = "equipment_NvmeSwitchConfig_policyOwner"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_DESCR = "equipment_OnboardDeviceDef_descr"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_DEVICE = "equipment_OnboardDeviceDef_device"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_INT_ID = "equipment_OnboardDeviceDef_intId"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_NAME = "equipment_OnboardDeviceDef_name"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_POLICY_LEVEL = "equipment_OnboardDeviceDef_policyLevel"
    SORT_PROP_EQUIPMENT_ONBOARD_DEVICE_DEF_POLICY_OWNER = "equipment_OnboardDeviceDef_policyOwner"
    SORT_PROP_EQUIPMENT_POSTCODE_CONTAINER_BASE_CONTAINER = "equipment_POSTCodeContainer_baseContainer"
    SORT_PROP_EQUIPMENT_POSTCODE_CONTAINER_NAME = "equipment_POSTCodeContainer_name"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_CODE = "equipment_POSTCodeData_code"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_DESCR = "equipment_POSTCodeData_descr"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_GLOBAL_ID = "equipment_POSTCodeData_globalId"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_LOCAL_ID = "equipment_POSTCodeData_localId"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_METHOD = "equipment_POSTCodeData_method"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_NAME = "equipment_POSTCodeData_name"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_RECOVERABLE = "equipment_POSTCodeData_recoverable"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_RECOVERY_ACTION = "equipment_POSTCodeData_recoveryAction"
    SORT_PROP_EQUIPMENT_POSTCODE_DATA_SEVERITY = "equipment_POSTCodeData_severity"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_BASE_CONTAINER = "equipment_POSTCodeReporter_baseContainer"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_MODEL = "equipment_POSTCodeReporter_model"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_NAME = "equipment_POSTCodeReporter_name"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_REVISION = "equipment_POSTCodeReporter_revision"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_SERIAL = "equipment_POSTCodeReporter_serial"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_TYPE = "equipment_POSTCodeReporter_type"
    SORT_PROP_EQUIPMENT_POSTCODE_REPORTER_VENDOR = "equipment_POSTCodeReporter_vendor"
    SORT_PROP_EQUIPMENT_POSTCODE_TEMPLATE_BASE_CONTAINER = "equipment_POSTCodeTemplate_baseContainer"
    SORT_PROP_EQUIPMENT_POSTCODE_TEMPLATE_NAME = "equipment_POSTCodeTemplate_name"
    SORT_PROP_EQUIPMENT_POSTCODE_CODE = "equipment_POSTCode_code"
    SORT_PROP_EQUIPMENT_POSTCODE_DESCR = "equipment_POSTCode_descr"
    SORT_PROP_EQUIPMENT_POSTCODE_GLOBAL_ID = "equipment_POSTCode_globalId"
    SORT_PROP_EQUIPMENT_POSTCODE_LOCAL_ID = "equipment_POSTCode_localId"
    SORT_PROP_EQUIPMENT_POSTCODE_METHOD = "equipment_POSTCode_method"
    SORT_PROP_EQUIPMENT_POSTCODE_NAME = "equipment_POSTCode_name"
    SORT_PROP_EQUIPMENT_POSTCODE_RECOVERABLE = "equipment_POSTCode_recoverable"
    SORT_PROP_EQUIPMENT_POSTCODE_RECOVERY_ACTION = "equipment_POSTCode_recoveryAction"
    SORT_PROP_EQUIPMENT_POSTCODE_SEVERITY = "equipment_POSTCode_severity"
    SORT_PROP_EQUIPMENT_POST_CODE = "equipment_POST_code"
    SORT_PROP_EQUIPMENT_POST_CREATED = "equipment_POST_created"
    SORT_PROP_EQUIPMENT_POST_DESCR = "equipment_POST_descr"
    SORT_PROP_EQUIPMENT_POST_GLOBAL_ID = "equipment_POST_globalId"
    SORT_PROP_EQUIPMENT_POST_LOCAL_ID = "equipment_POST_localId"
    SORT_PROP_EQUIPMENT_POST_METHOD = "equipment_POST_method"
    SORT_PROP_EQUIPMENT_POST_NAME = "equipment_POST_name"
    SORT_PROP_EQUIPMENT_POST_RECOVERABLE = "equipment_POST_recoverable"
    SORT_PROP_EQUIPMENT_POST_RECOVERY_ACTION = "equipment_POST_recoveryAction"
    SORT_PROP_EQUIPMENT_POST_SEVERITY = "equipment_POST_severity"
    SORT_PROP_EQUIPMENT_POST_TYPE = "equipment_POST_type"
    SORT_PROP_EQUIPMENT_POST_VALUE = "equipment_POST_value"
    SORT_PROP_EQUIPMENT_PCI_DEF_DESCR = "equipment_PciDef_descr"
    SORT_PROP_EQUIPMENT_PCI_DEF_DEVICE = "equipment_PciDef_device"
    SORT_PROP_EQUIPMENT_PCI_DEF_DEVICE_TYPE = "equipment_PciDef_deviceType"
    SORT_PROP_EQUIPMENT_PCI_DEF_INT_ID = "equipment_PciDef_intId"
    SORT_PROP_EQUIPMENT_PCI_DEF_NAME = "equipment_PciDef_name"
    SORT_PROP_EQUIPMENT_PCI_DEF_POLICY_LEVEL = "equipment_PciDef_policyLevel"
    SORT_PROP_EQUIPMENT_PCI_DEF_POLICY_OWNER = "equipment_PciDef_policyOwner"
    SORT_PROP_EQUIPMENT_PCI_DEF_SUBDEVICE = "equipment_PciDef_subdevice"
    SORT_PROP_EQUIPMENT_PCI_DEF_SUBVENDOR = "equipment_PciDef_subvendor"
    SORT_PROP_EQUIPMENT_PCI_DEF_VENDOR = "equipment_PciDef_vendor"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_ENTRY_ID = "equipment_PciSlotIdEntry_id"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_ENTRY_NAME = "equipment_PciSlotIdEntry_name"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_MAPPING_DESCR = "equipment_PciSlotIdMapping_descr"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_MAPPING_INT_ID = "equipment_PciSlotIdMapping_intId"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_MAPPING_NAME = "equipment_PciSlotIdMapping_name"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_MAPPING_POLICY_LEVEL = "equipment_PciSlotIdMapping_policyLevel"
    SORT_PROP_EQUIPMENT_PCI_SLOT_ID_MAPPING_POLICY_OWNER = "equipment_PciSlotIdMapping_policyOwner"
    SORT_PROP_EQUIPMENT_PCI_SLOT_SUB_OEMID_ENTRY_NAME = "equipment_PciSlotSubOEMIdEntry_name"
    SORT_PROP_EQUIPMENT_PCI_SLOT_SUB_OEMID_ENTRY_SUB_OEM_ID = "equipment_PciSlotSubOEMIdEntry_subOemId"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_DELETED = "equipment_PciSwitchCapProvider_deleted"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_DEPRECATED = "equipment_PciSwitchCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_PciSwitchCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_PciSwitchCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_GENCOUNT = "equipment_PciSwitchCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_LOAD_ERRORS = "equipment_PciSwitchCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_LOAD_WARNINGS = "equipment_PciSwitchCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_PciSwitchCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_MODEL = "equipment_PciSwitchCapProvider_model"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_PciSwitchCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_REVISION = "equipment_PciSwitchCapProvider_revision"
    SORT_PROP_EQUIPMENT_PCI_SWITCH_CAP_PROVIDER_VENDOR = "equipment_PciSwitchCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PCIE_SLOT_ORIENTATION_ORIENTATION = "equipment_PcieSlotOrientation_orientation"
    SORT_PROP_EQUIPMENT_PCIE_SLOT_ORIENTATION_SLOT_NUMBER = "equipment_PcieSlotOrientation_slotNumber"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_DELETED = "equipment_PersistentMemoryUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_PersistentMemoryUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_PersistentMemoryUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_PersistentMemoryUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_PersistentMemoryUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_PersistentMemoryUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_PersistentMemoryUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_PersistentMemoryUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_MODEL = "equipment_PersistentMemoryUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_PersistentMemoryUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_REVISION = "equipment_PersistentMemoryUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_PERSISTENT_MEMORY_UNIT_CAP_PROVIDER_VENDOR = "equipment_PersistentMemoryUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PERSONALITY_IS_SUPPORTED = "equipment_Personality_isSupported"
    SORT_PROP_EQUIPMENT_PERSONALITY_MIN_CIMC_VERSION = "equipment_Personality_minCimcVersion"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_DESCR = "equipment_PfcMmuCap_descr"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_FCOE = "equipment_PfcMmuCap_fcoe"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_FCOE_JUMBO_NODROP = "equipment_PfcMmuCap_fcoeJumboNodrop"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_FCOE_NORMAL_NODROP = "equipment_PfcMmuCap_fcoeNormalNodrop"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_INT_ID = "equipment_PfcMmuCap_intId"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_JUMBO_BREAKOUT_PORT = "equipment_PfcMmuCap_jumboBreakoutPort"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_NAME = "equipment_PfcMmuCap_name"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_POLICY_LEVEL = "equipment_PfcMmuCap_policyLevel"
    SORT_PROP_EQUIPMENT_PFC_MMU_CAP_POLICY_OWNER = "equipment_PfcMmuCap_policyOwner"
    SORT_PROP_EQUIPMENT_PHYS_DEVICES_PER_BOARD_NUM_OF_CPU = "equipment_PhysDevicesPerBoard_numOfCpu"
    SORT_PROP_EQUIPMENT_PHYS_DEVICES_PER_BOARD_NUM_OF_DIMM = "equipment_PhysDevicesPerBoard_numOfDimm"
    SORT_PROP_EQUIPMENT_PHYS_DEVICES_PER_BOARD_NUM_OF_LOCAL_DISK = "equipment_PhysDevicesPerBoard_numOfLocalDisk"
    SORT_PROP_EQUIPMENT_PHYS_DEVICES_PER_BOARD_NUM_OF_STORAGE_CONTROLLER = "equipment_PhysDevicesPerBoard_numOfStorageController"
    SORT_PROP_EQUIPMENT_PHYS_DEVICES_PER_BOARD_NUM_OFADAPTOR = "equipment_PhysDevicesPerBoard_numOfadaptor"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_DEPTH = "equipment_PhysicalDef_depth"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_DESCR = "equipment_PhysicalDef_descr"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_HEIGHT = "equipment_PhysicalDef_height"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_INT_ID = "equipment_PhysicalDef_intId"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_MAXIMUM_POWER = "equipment_PhysicalDef_maximumPower"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_MAXIMUM_TEMPERATURE = "equipment_PhysicalDef_maximumTemperature"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_MINIMUM_POWER = "equipment_PhysicalDef_minimumPower"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_MINIMUM_TEMPERATURE = "equipment_PhysicalDef_minimumTemperature"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_NAME = "equipment_PhysicalDef_name"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_NOMINAL_POWER = "equipment_PhysicalDef_nominalPower"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_NOMINAL_TEMPERATURE = "equipment_PhysicalDef_nominalTemperature"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_OPERATING_VOLTAGES = "equipment_PhysicalDef_operatingVoltages"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_POLICY_LEVEL = "equipment_PhysicalDef_policyLevel"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_POLICY_OWNER = "equipment_PhysicalDef_policyOwner"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_WEIGHT = "equipment_PhysicalDef_weight"
    SORT_PROP_EQUIPMENT_PHYSICAL_DEF_WIDTH = "equipment_PhysicalDef_width"
    SORT_PROP_EQUIPMENT_PHYSICAL_QUAL_MODEL = "equipment_PhysicalQual_model"
    SORT_PROP_EQUIPMENT_PHYSICAL_QUAL_PROP_ACL = "equipment_PhysicalQual_propAcl"
    SORT_PROP_EQUIPMENT_PICTURE_FILE_NAME = "equipment_Picture_fileName"
    SORT_PROP_EQUIPMENT_PICTURE_TYPE = "equipment_Picture_type"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_BOOT_MODE = "equipment_PnuosBootMode_bootMode"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_DESCR = "equipment_PnuosBootMode_descr"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_INT_ID = "equipment_PnuosBootMode_intId"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_MIN_BIOS_VERSION = "equipment_PnuosBootMode_minBiosVersion"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_NAME = "equipment_PnuosBootMode_name"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_POLICY_LEVEL = "equipment_PnuosBootMode_policyLevel"
    SORT_PROP_EQUIPMENT_PNUOS_BOOT_MODE_POLICY_OWNER = "equipment_PnuosBootMode_policyOwner"
    SORT_PROP_EQUIPMENT_POOL_POLICY_REF_ID = "equipment_PoolPolicyRef_id"
    SORT_PROP_EQUIPMENT_POOL_POLICY_REF_POLICY_DN = "equipment_PoolPolicyRef_policyDn"
    SORT_PROP_EQUIPMENT_POOL_ASSIGNED = "equipment_Pool_assigned"
    SORT_PROP_EQUIPMENT_POOL_ASSIGNMENT_ORDER = "equipment_Pool_assignmentOrder"
    SORT_PROP_EQUIPMENT_POOL_DESCR = "equipment_Pool_descr"
    SORT_PROP_EQUIPMENT_POOL_INT_ID = "equipment_Pool_intId"
    SORT_PROP_EQUIPMENT_POOL_NAME = "equipment_Pool_name"
    SORT_PROP_EQUIPMENT_POOL_POLICY_LEVEL = "equipment_Pool_policyLevel"
    SORT_PROP_EQUIPMENT_POOL_POLICY_OWNER = "equipment_Pool_policyOwner"
    SORT_PROP_EQUIPMENT_POOL_SIZE = "equipment_Pool_size"
    SORT_PROP_EQUIPMENT_POOLABLE_ID = "equipment_Poolable_id"
    SORT_PROP_EQUIPMENT_POOLABLE_POOL_DN = "equipment_Poolable_poolDn"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_ASSIGNED = "equipment_PooledChassis_assigned"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_ASSIGNED_TO_DN = "equipment_PooledChassis_assignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_CHASSIS_ID = "equipment_PooledChassis_chassisId"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_OWNER = "equipment_PooledChassis_owner"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_POOLABLE_DN = "equipment_PooledChassis_poolableDn"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_PREV_ASSIGNED_TO_DN = "equipment_PooledChassis_prevAssignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_CHASSIS_SLOT_ID = "equipment_PooledChassis_slotId"
    SORT_PROP_EQUIPMENT_POOLED_PHYSICAL_ASSIGNED = "equipment_PooledPhysical_assigned"
    SORT_PROP_EQUIPMENT_POOLED_PHYSICAL_ASSIGNED_TO_DN = "equipment_PooledPhysical_assignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_PHYSICAL_OWNER = "equipment_PooledPhysical_owner"
    SORT_PROP_EQUIPMENT_POOLED_PHYSICAL_POOLABLE_DN = "equipment_PooledPhysical_poolableDn"
    SORT_PROP_EQUIPMENT_POOLED_PHYSICAL_PREV_ASSIGNED_TO_DN = "equipment_PooledPhysical_prevAssignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_ASSIGNED = "equipment_Pooled_assigned"
    SORT_PROP_EQUIPMENT_POOLED_ASSIGNED_TO_DN = "equipment_Pooled_assignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_OWNER = "equipment_Pooled_owner"
    SORT_PROP_EQUIPMENT_POOLED_POOLABLE_DN = "equipment_Pooled_poolableDn"
    SORT_PROP_EQUIPMENT_POOLED_PREV_ASSIGNED_TO_DN = "equipment_Pooled_prevAssignedToDn"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_DESCR = "equipment_PoolingPolicy_descr"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_INT_ID = "equipment_PoolingPolicy_intId"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_NAME = "equipment_PoolingPolicy_name"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POLICY_LEVEL = "equipment_PoolingPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POLICY_OWNER = "equipment_PoolingPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POOL_DN = "equipment_PoolingPolicy_poolDn"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_QUALIFIER = "equipment_PoolingPolicy_qualifier"
    SORT_PROP_EQUIPMENT_PORT_CAP_BREAKOUT_PORT_SPEED_GB = "equipment_PortCap_breakoutPortSpeedGb"
    SORT_PROP_EQUIPMENT_PORT_CAP_COUNT_BREAKOUT_PORTS = "equipment_PortCap_countBreakoutPorts"
    SORT_PROP_EQUIPMENT_PORT_CAP_DESCR = "equipment_PortCap_descr"
    SORT_PROP_EQUIPMENT_PORT_CAP_END_PORT_ID = "equipment_PortCap_endPortId"
    SORT_PROP_EQUIPMENT_PORT_CAP_INT_ID = "equipment_PortCap_intId"
    SORT_PROP_EQUIPMENT_PORT_CAP_NAME = "equipment_PortCap_name"
    SORT_PROP_EQUIPMENT_PORT_CAP_POLICY_LEVEL = "equipment_PortCap_policyLevel"
    SORT_PROP_EQUIPMENT_PORT_CAP_POLICY_OWNER = "equipment_PortCap_policyOwner"
    SORT_PROP_EQUIPMENT_PORT_CAP_PORT_ATTRIBUTE = "equipment_PortCap_portAttribute"
    SORT_PROP_EQUIPMENT_PORT_CAP_PORT_SPEED_GB = "equipment_PortCap_portSpeedGb"
    SORT_PROP_EQUIPMENT_PORT_CAP_START_PORT_ID = "equipment_PortCap_startPortId"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_AGGREGATION_CAP = "equipment_PortGroupAggregationDef_aggregationCap"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_DESCR = "equipment_PortGroupAggregationDef_descr"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_HW40_GPCPORT_GROUP_CAP = "equipment_PortGroupAggregationDef_hw40GPCPortGroupCap"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_HW40_GPORT_GROUP_CAP = "equipment_PortGroupAggregationDef_hw40GPortGroupCap"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_INT_ID = "equipment_PortGroupAggregationDef_intId"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_NAME = "equipment_PortGroupAggregationDef_name"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_POLICY_LEVEL = "equipment_PortGroupAggregationDef_policyLevel"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_POLICY_OWNER = "equipment_PortGroupAggregationDef_policyOwner"
    SORT_PROP_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_TYPE = "equipment_PortGroupAggregationDef_type"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_DESCR = "equipment_PortGroupDef_descr"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_INT_ID = "equipment_PortGroupDef_intId"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_NAME = "equipment_PortGroupDef_name"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_NUMBER_OF_PORTS = "equipment_PortGroupDef_numberOfPorts"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_POLICY_LEVEL = "equipment_PortGroupDef_policyLevel"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_POLICY_OWNER = "equipment_PortGroupDef_policyOwner"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_START_PORT_ID = "equipment_PortGroupDef_startPortId"
    SORT_PROP_EQUIPMENT_PORT_GROUP_DEF_TYPE = "equipment_PortGroupDef_type"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_ASIC = "equipment_PortGroupSwComplexDef_asic"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_DESCR = "equipment_PortGroupSwComplexDef_descr"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_INT_ID = "equipment_PortGroupSwComplexDef_intId"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_NAME = "equipment_PortGroupSwComplexDef_name"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_POLICY_LEVEL = "equipment_PortGroupSwComplexDef_policyLevel"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_POLICY_OWNER = "equipment_PortGroupSwComplexDef_policyOwner"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_PORT_CAPACITY = "equipment_PortGroupSwComplexDef_portCapacity"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_SW_COMPLEX_CAPACITY = "equipment_PortGroupSwComplexDef_swComplexCapacity"
    SORT_PROP_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_VIF_CAPACITY = "equipment_PortGroupSwComplexDef_vifCapacity"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_DESCR = "equipment_PortSwComplexRef_descr"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_INT_ID = "equipment_PortSwComplexRef_intId"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_MAX_PORT_ID = "equipment_PortSwComplexRef_maxPortId"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_MIN_PORT_ID = "equipment_PortSwComplexRef_minPortId"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_NAME = "equipment_PortSwComplexRef_name"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_POLICY_LEVEL = "equipment_PortSwComplexRef_policyLevel"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_POLICY_OWNER = "equipment_PortSwComplexRef_policyOwner"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_SLOT_ID = "equipment_PortSwComplexRef_slotId"
    SORT_PROP_EQUIPMENT_PORT_SW_COMPLEX_REF_SW_COMPLEX_ID = "equipment_PortSwComplexRef_swComplexId"
    SORT_PROP_EQUIPMENT_POWER_CAP_DEF_IS_POWER_DEPLOYMENT_NEEDED = "equipment_PowerCapDef_isPowerDeploymentNeeded"
    SORT_PROP_EQUIPMENT_POWER_CAP_DEF_MIN_BIOS_VERSION = "equipment_PowerCapDef_minBiosVersion"
    SORT_PROP_EQUIPMENT_POWER_CAP_DEF_MIN_CIMC_VERSION = "equipment_PowerCapDef_minCimcVersion"
    SORT_PROP_EQUIPMENT_POWER_CAP_DEF_MIN_CMC_VERSION = "equipment_PowerCapDef_minCmcVersion"
    SORT_PROP_EQUIPMENT_POWER_CAP_DEF_PROFILE_METHOD = "equipment_PowerCapDef_profileMethod"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_DELETED = "equipment_ProcessorUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_ProcessorUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ProcessorUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ProcessorUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_ProcessorUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_ProcessorUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ProcessorUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ProcessorUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MODEL = "equipment_ProcessorUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ProcessorUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_REVISION = "equipment_ProcessorUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_VENDOR = "equipment_ProcessorUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_ADDRESS_WIDTH = "equipment_ProcessorUnitDef_addressWidth"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_DATA_WIDTH = "equipment_ProcessorUnitDef_dataWidth"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_DESCR = "equipment_ProcessorUnitDef_descr"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_INT_ID = "equipment_ProcessorUnitDef_intId"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_MAX_SPEED = "equipment_ProcessorUnitDef_maxSpeed"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_MEMORY_CAPACITY = "equipment_ProcessorUnitDef_memoryCapacity"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_NAME = "equipment_ProcessorUnitDef_name"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_POLICY_LEVEL = "equipment_ProcessorUnitDef_policyLevel"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_DEF_POLICY_OWNER = "equipment_ProcessorUnitDef_policyOwner"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_DELETED = "equipment_PsuCapProvider_deleted"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_DEPRECATED = "equipment_PsuCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_PsuCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_PsuCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_GENCOUNT = "equipment_PsuCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_LOAD_ERRORS = "equipment_PsuCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_LOAD_WARNINGS = "equipment_PsuCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_PsuCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_MODEL = "equipment_PsuCapProvider_model"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_PsuCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_REVISION = "equipment_PsuCapProvider_revision"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_VENDOR = "equipment_PsuCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PSU_DEF_PSU_TYPE = "equipment_PsuDef_PsuType"
    SORT_PROP_EQUIPMENT_PSU_DEF_DESCR = "equipment_PsuDef_descr"
    SORT_PROP_EQUIPMENT_PSU_DEF_INT_ID = "equipment_PsuDef_intId"
    SORT_PROP_EQUIPMENT_PSU_DEF_NAME = "equipment_PsuDef_name"
    SORT_PROP_EQUIPMENT_PSU_DEF_POLICY_LEVEL = "equipment_PsuDef_policyLevel"
    SORT_PROP_EQUIPMENT_PSU_DEF_POLICY_OWNER = "equipment_PsuDef_policyOwner"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_DESCR = "equipment_PsuFsmStage_descr"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_LAST_UPDATE_TIME = "equipment_PsuFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_NAME = "equipment_PsuFsmStage_name"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_ORDER = "equipment_PsuFsmStage_order"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_RETRY = "equipment_PsuFsmStage_retry"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_STAGE_STATUS = "equipment_PsuFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_PSU_FSM_TASK_COMPLETION = "equipment_PsuFsmTask_completion"
    SORT_PROP_EQUIPMENT_PSU_FSM_TASK_FLAGS = "equipment_PsuFsmTask_flags"
    SORT_PROP_EQUIPMENT_PSU_FSM_TASK_ITEM = "equipment_PsuFsmTask_item"
    SORT_PROP_EQUIPMENT_PSU_FSM_TASK_SEQ_ID = "equipment_PsuFsmTask_seqId"
    SORT_PROP_EQUIPMENT_PSU_FSM_COMPLETION_TIME = "equipment_PsuFsm_completionTime"
    SORT_PROP_EQUIPMENT_PSU_FSM_CURRENT_FSM = "equipment_PsuFsm_currentFsm"
    SORT_PROP_EQUIPMENT_PSU_FSM_DESCR = "equipment_PsuFsm_descr"
    SORT_PROP_EQUIPMENT_PSU_FSM_FSM_STATUS = "equipment_PsuFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_PSU_FSM_INSTANCE_ID = "equipment_PsuFsm_instanceId"
    SORT_PROP_EQUIPMENT_PSU_FSM_PROGRESS = "equipment_PsuFsm_progress"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_ERR_CODE = "equipment_PsuFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_ERR_DESCR = "equipment_PsuFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_RSLT = "equipment_PsuFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT = "equipment_PsuInputStatsHist_current"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuInputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuInputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuInputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_ID = "equipment_PsuInputStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_PsuInputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER = "equipment_PsuInputStatsHist_power"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_PsuInputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_PsuInputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_PsuInputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_PsuInputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_PsuInputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuInputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_PsuInputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuInputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuInputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuInputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT = "equipment_PsuInputStats_current"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_AVG = "equipment_PsuInputStats_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MAX = "equipment_PsuInputStats_currentMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MIN = "equipment_PsuInputStats_currentMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_INPUT_STATUS = "equipment_PsuInputStats_inputStatus"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_INTERVALS = "equipment_PsuInputStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER = "equipment_PsuInputStats_power"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_AVG = "equipment_PsuInputStats_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_MAX = "equipment_PsuInputStats_powerMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_MIN = "equipment_PsuInputStats_powerMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_SUSPECT = "equipment_PsuInputStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_THRESHOLDED = "equipment_PsuInputStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_PsuInputStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_UPDATE = "equipment_PsuInputStats_update"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE = "equipment_PsuInputStats_voltage"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_PsuInputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_PsuInputStats_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_PsuInputStats_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT = "equipment_PsuOutputStatsHist_current"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuOutputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuOutputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuOutputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_ID = "equipment_PsuOutputStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_MOST_RECENT = "equipment_PsuOutputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER = "equipment_PsuOutputStatsHist_power"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_AVG = "equipment_PsuOutputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MAX = "equipment_PsuOutputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MIN = "equipment_PsuOutputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_SUSPECT = "equipment_PsuOutputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_THRESHOLDED = "equipment_PsuOutputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuOutputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE = "equipment_PsuOutputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuOutputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuOutputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuOutputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT = "equipment_PsuOutputStats_current"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_AVG = "equipment_PsuOutputStats_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MAX = "equipment_PsuOutputStats_currentMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MIN = "equipment_PsuOutputStats_currentMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_INTERVALS = "equipment_PsuOutputStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_OUTPUT_STATUS = "equipment_PsuOutputStats_outputStatus"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER = "equipment_PsuOutputStats_power"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_AVG = "equipment_PsuOutputStats_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MAX = "equipment_PsuOutputStats_powerMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MIN = "equipment_PsuOutputStats_powerMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_SUSPECT = "equipment_PsuOutputStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_THRESHOLDED = "equipment_PsuOutputStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_TIME_COLLECTED = "equipment_PsuOutputStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_UPDATE = "equipment_PsuOutputStats_update"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE = "equipment_PsuOutputStats_voltage"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_AVG = "equipment_PsuOutputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MAX = "equipment_PsuOutputStats_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MIN = "equipment_PsuOutputStats_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_PSU_I2_CERRORS = "equipment_PsuStatsHist_PsuI2CErrors"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_PSU_I2_CERRORS_AVG = "equipment_PsuStatsHist_PsuI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_PSU_I2_CERRORS_MAX = "equipment_PsuStatsHist_PsuI2CErrorsMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_PSU_I2_CERRORS_MIN = "equipment_PsuStatsHist_PsuI2CErrorsMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_PsuStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_PsuStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_PsuStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_PsuStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_ID = "equipment_PsuStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V = "equipment_PsuStatsHist_input210v"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_AVG = "equipment_PsuStatsHist_input210vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MAX = "equipment_PsuStatsHist_input210vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MIN = "equipment_PsuStatsHist_input210vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT_POWER = "equipment_PsuStatsHist_inputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT_POWER_AVG = "equipment_PsuStatsHist_inputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT_POWER_MAX = "equipment_PsuStatsHist_inputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT_POWER_MIN = "equipment_PsuStatsHist_inputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_MOST_RECENT = "equipment_PsuStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V = "equipment_PsuStatsHist_output12v"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_AVG = "equipment_PsuStatsHist_output12vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MAX = "equipment_PsuStatsHist_output12vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MIN = "equipment_PsuStatsHist_output12vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3 = "equipment_PsuStatsHist_output3v3"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_AVG = "equipment_PsuStatsHist_output3v3Avg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MAX = "equipment_PsuStatsHist_output3v3Max"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MIN = "equipment_PsuStatsHist_output3v3Min"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_PsuStatsHist_outputCurrent"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_PsuStatsHist_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_PsuStatsHist_outputCurrentMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_PsuStatsHist_outputCurrentMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_PsuStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_PsuStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_PsuStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_PsuStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_SUSPECT = "equipment_PsuStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_THRESHOLDED = "equipment_PsuStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_PsuStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS = "equipment_PsuStats_PsuI2CErrors"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_AVG = "equipment_PsuStats_PsuI2CErrorsAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_MAX = "equipment_PsuStats_PsuI2CErrorsMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_MIN = "equipment_PsuStats_PsuI2CErrorsMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP = "equipment_PsuStats_ambientTemp"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_PsuStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_PsuStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_PsuStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V = "equipment_PsuStats_input210v"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_AVG = "equipment_PsuStats_input210vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_MAX = "equipment_PsuStats_input210vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_MIN = "equipment_PsuStats_input210vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT_POWER = "equipment_PsuStats_inputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT_POWER_AVG = "equipment_PsuStats_inputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT_POWER_MAX = "equipment_PsuStats_inputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT_POWER_MIN = "equipment_PsuStats_inputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_INTERVALS = "equipment_PsuStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V = "equipment_PsuStats_output12v"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_AVG = "equipment_PsuStats_output12vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_MAX = "equipment_PsuStats_output12vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_MIN = "equipment_PsuStats_output12vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3 = "equipment_PsuStats_output3v3"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_AVG = "equipment_PsuStats_output3v3Avg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_MAX = "equipment_PsuStats_output3v3Max"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_MIN = "equipment_PsuStats_output3v3Min"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT = "equipment_PsuStats_outputCurrent"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_PsuStats_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_PsuStats_outputCurrentMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_PsuStats_outputCurrentMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER = "equipment_PsuStats_outputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_PsuStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_PsuStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_PsuStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_TEMP1 = "equipment_PsuStats_psuTemp1"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_TEMP2 = "equipment_PsuStats_psuTemp2"
    SORT_PROP_EQUIPMENT_PSU_STATS_SUSPECT = "equipment_PsuStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_STATS_THRESHOLDED = "equipment_PsuStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_STATS_TIME_COLLECTED = "equipment_PsuStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_STATS_UPDATE = "equipment_PsuStats_update"
    SORT_PROP_EQUIPMENT_PSU_TYPE = "equipment_Psu_Type"
    SORT_PROP_EQUIPMENT_PSU_ASSET_TAG = "equipment_Psu_assetTag"
    SORT_PROP_EQUIPMENT_PSU_FSM_DESCR = "equipment_Psu_fsmDescr"
    SORT_PROP_EQUIPMENT_PSU_FSM_FLAGS = "equipment_Psu_fsmFlags"
    SORT_PROP_EQUIPMENT_PSU_FSM_PREV = "equipment_Psu_fsmPrev"
    SORT_PROP_EQUIPMENT_PSU_FSM_PROGR = "equipment_Psu_fsmProgr"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_INV_ERR_CODE = "equipment_Psu_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_INV_ERR_DESCR = "equipment_Psu_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_PSU_FSM_RMT_INV_RSLT = "equipment_Psu_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAGE_DESCR = "equipment_Psu_fsmStageDescr"
    SORT_PROP_EQUIPMENT_PSU_FSM_STAMP = "equipment_Psu_fsmStamp"
    SORT_PROP_EQUIPMENT_PSU_FSM_STATUS = "equipment_Psu_fsmStatus"
    SORT_PROP_EQUIPMENT_PSU_FSM_TRY = "equipment_Psu_fsmTry"
    SORT_PROP_EQUIPMENT_PSU_ID = "equipment_Psu_id"
    SORT_PROP_EQUIPMENT_PSU_MODEL = "equipment_Psu_model"
    SORT_PROP_EQUIPMENT_PSU_OPER_QUALIFIER_REASON = "equipment_Psu_operQualifierReason"
    SORT_PROP_EQUIPMENT_PSU_OPER_STATE = "equipment_Psu_operState"
    SORT_PROP_EQUIPMENT_PSU_OPERABILITY = "equipment_Psu_operability"
    SORT_PROP_EQUIPMENT_PSU_PART_NUMBER = "equipment_Psu_partNumber"
    SORT_PROP_EQUIPMENT_PSU_PERF = "equipment_Psu_perf"
    SORT_PROP_EQUIPMENT_PSU_POWER = "equipment_Psu_power"
    SORT_PROP_EQUIPMENT_PSU_POWER_STATE_QUALIFIER = "equipment_Psu_powerStateQualifier"
    SORT_PROP_EQUIPMENT_PSU_PRESENCE = "equipment_Psu_presence"
    SORT_PROP_EQUIPMENT_PSU_PSU_FIRMWARE_VERSION = "equipment_Psu_psuFirmwareVersion"
    SORT_PROP_EQUIPMENT_PSU_PSU_INPUT_SRC = "equipment_Psu_psuInputSrc"
    SORT_PROP_EQUIPMENT_PSU_PSU_TYPE = "equipment_Psu_psuType"
    SORT_PROP_EQUIPMENT_PSU_PSU_WATTAGE = "equipment_Psu_psuWattage"
    SORT_PROP_EQUIPMENT_PSU_REVISION = "equipment_Psu_revision"
    SORT_PROP_EQUIPMENT_PSU_SERIAL = "equipment_Psu_serial"
    SORT_PROP_EQUIPMENT_PSU_THERMAL = "equipment_Psu_thermal"
    SORT_PROP_EQUIPMENT_PSU_VENDOR = "equipment_Psu_vendor"
    SORT_PROP_EQUIPMENT_PSU_VID = "equipment_Psu_vid"
    SORT_PROP_EQUIPMENT_PSU_VOLTAGE = "equipment_Psu_voltage"
    SORT_PROP_EQUIPMENT_QUAL_BASE_DESCR = "equipment_QualBase_descr"
    SORT_PROP_EQUIPMENT_QUAL_BASE_INT_ID = "equipment_QualBase_intId"
    SORT_PROP_EQUIPMENT_QUAL_BASE_NAME = "equipment_QualBase_name"
    SORT_PROP_EQUIPMENT_QUAL_BASE_POLICY_LEVEL = "equipment_QualBase_policyLevel"
    SORT_PROP_EQUIPMENT_QUAL_BASE_POLICY_OWNER = "equipment_QualBase_policyOwner"
    SORT_PROP_EQUIPMENT_QUAL_DESCR = "equipment_Qual_descr"
    SORT_PROP_EQUIPMENT_QUAL_INT_ID = "equipment_Qual_intId"
    SORT_PROP_EQUIPMENT_QUAL_NAME = "equipment_Qual_name"
    SORT_PROP_EQUIPMENT_QUAL_POLICY_LEVEL = "equipment_Qual_policyLevel"
    SORT_PROP_EQUIPMENT_QUAL_POLICY_OWNER = "equipment_Qual_policyOwner"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_DESCR = "equipment_QualifiedPolicy_descr"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_INT_ID = "equipment_QualifiedPolicy_intId"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_NAME = "equipment_QualifiedPolicy_name"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_POLICY_LEVEL = "equipment_QualifiedPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_POLICY_OWNER = "equipment_QualifiedPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_QUALIFIER = "equipment_QualifiedPolicy_qualifier"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_DELETED = "equipment_RackEnclosureCapProvider_deleted"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_DEPRECATED = "equipment_RackEnclosureCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_RackEnclosureCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_RackEnclosureCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_GENCOUNT = "equipment_RackEnclosureCapProvider_gencount"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_LOAD_ERRORS = "equipment_RackEnclosureCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_RackEnclosureCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_RackEnclosureCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_MODEL = "equipment_RackEnclosureCapProvider_model"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_RackEnclosureCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_REVISION = "equipment_RackEnclosureCapProvider_revision"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_CAP_PROVIDER_VENDOR = "equipment_RackEnclosureCapProvider_vendor"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_ASSET_TAG = "equipment_RackEnclosure_assetTag"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_ID = "equipment_RackEnclosure_id"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_MFG_TIME = "equipment_RackEnclosure_mfgTime"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_MODEL = "equipment_RackEnclosure_model"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_OPER_QUALIFIER_REASON = "equipment_RackEnclosure_operQualifierReason"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_OPERABILITY = "equipment_RackEnclosure_operability"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_PART_NUMBER = "equipment_RackEnclosure_partNumber"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_PRESENCE = "equipment_RackEnclosure_presence"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_REVISION = "equipment_RackEnclosure_revision"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_SERIAL = "equipment_RackEnclosure_serial"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_VENDOR = "equipment_RackEnclosure_vendor"
    SORT_PROP_EQUIPMENT_RACK_ENCLOSURE_VID = "equipment_RackEnclosure_vid"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_DESCR = "equipment_RackFanModuleDef_descr"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_FAN_CAPACITY = "equipment_RackFanModuleDef_fanCapacity"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_INT_ID = "equipment_RackFanModuleDef_intId"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_NAME = "equipment_RackFanModuleDef_name"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_POLICY_LEVEL = "equipment_RackFanModuleDef_policyLevel"
    SORT_PROP_EQUIPMENT_RACK_FAN_MODULE_DEF_POLICY_OWNER = "equipment_RackFanModuleDef_policyOwner"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_DELETED = "equipment_RackUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_RackUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_RackUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_RackUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_FORM = "equipment_RackUnitCapProvider_form"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_RackUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_GENERATION = "equipment_RackUnitCapProvider_generation"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_RackUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_RackUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MAX_LOCAL_DISKS = "equipment_RackUnitCapProvider_maxLocalDisks"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_RackUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MODEL = "equipment_RackUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_RackUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_REVISION = "equipment_RackUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_VENDOR = "equipment_RackUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_ID = "equipment_RackUnitFanStatsHist_id"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_MOST_RECENT = "equipment_RackUnitFanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED = "equipment_RackUnitFanStatsHist_speed"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_AVG = "equipment_RackUnitFanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MAX = "equipment_RackUnitFanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MIN = "equipment_RackUnitFanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SUSPECT = "equipment_RackUnitFanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_THRESHOLDED = "equipment_RackUnitFanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitFanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_INTERVALS = "equipment_RackUnitFanStats_intervals"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED = "equipment_RackUnitFanStats_speed"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_AVG = "equipment_RackUnitFanStats_speedAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MAX = "equipment_RackUnitFanStats_speedMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MIN = "equipment_RackUnitFanStats_speedMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SUSPECT = "equipment_RackUnitFanStats_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_THRESHOLDED = "equipment_RackUnitFanStats_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_TIME_COLLECTED = "equipment_RackUnitFanStats_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_UPDATE = "equipment_RackUnitFanStats_update"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_RackUnitPsuStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_ID = "equipment_RackUnitPsuStatsHist_id"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER = "equipment_RackUnitPsuStatsHist_inputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_inputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_inputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_inputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_inputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_inputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_inputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_inputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_MOST_RECENT = "equipment_RackUnitPsuStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_RackUnitPsuStatsHist_outputCurrent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStatsHist_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStatsHist_outputCurrentMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStatsHist_outputCurrentMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_RackUnitPsuStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_outputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_outputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_outputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_outputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_SUSPECT = "equipment_RackUnitPsuStatsHist_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_THRESHOLDED = "equipment_RackUnitPsuStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitPsuStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP = "equipment_RackUnitPsuStats_ambientTemp"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER = "equipment_RackUnitPsuStats_inputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_AVG = "equipment_RackUnitPsuStats_inputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MAX = "equipment_RackUnitPsuStats_inputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MIN = "equipment_RackUnitPsuStats_inputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE = "equipment_RackUnitPsuStats_inputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_inputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_inputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_inputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INTERVALS = "equipment_RackUnitPsuStats_intervals"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT = "equipment_RackUnitPsuStats_outputCurrent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStats_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStats_outputCurrentMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStats_outputCurrentMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER = "equipment_RackUnitPsuStats_outputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStats_outputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_outputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_outputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_outputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_SUSPECT = "equipment_RackUnitPsuStats_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_THRESHOLDED = "equipment_RackUnitPsuStats_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_TIME_COLLECTED = "equipment_RackUnitPsuStats_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_UPDATE = "equipment_RackUnitPsuStats_update"
    SORT_PROP_EQUIPMENT_RAID_DEF_DESCR = "equipment_RaidDef_descr"
    SORT_PROP_EQUIPMENT_RAID_DEF_INT_ID = "equipment_RaidDef_intId"
    SORT_PROP_EQUIPMENT_RAID_DEF_LEVEL = "equipment_RaidDef_level"
    SORT_PROP_EQUIPMENT_RAID_DEF_NAME = "equipment_RaidDef_name"
    SORT_PROP_EQUIPMENT_RAID_DEF_POLICY_LEVEL = "equipment_RaidDef_policyLevel"
    SORT_PROP_EQUIPMENT_RAID_DEF_POLICY_OWNER = "equipment_RaidDef_policyOwner"
    SORT_PROP_EQUIPMENT_REQUIREMENT_ASSIGNED_TO_DN = "equipment_Requirement_assignedToDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_CHASSIS_DN = "equipment_Requirement_chassisDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_CHASSIS_POOL_DN = "equipment_Requirement_chassisPoolDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_ISSUES = "equipment_Requirement_issues"
    SORT_PROP_EQUIPMENT_REQUIREMENT_NAME = "equipment_Requirement_name"
    SORT_PROP_EQUIPMENT_REQUIREMENT_OPER_NAME = "equipment_Requirement_operName"
    SORT_PROP_EQUIPMENT_REQUIREMENT_OPER_STATE = "equipment_Requirement_operState"
    SORT_PROP_EQUIPMENT_REQUIREMENT_QUALIFIER = "equipment_Requirement_qualifier"
    SORT_PROP_EQUIPMENT_REQUIREMENT_RESTRICT_MIGRATION = "equipment_Requirement_restrictMigration"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_DESCR = "equipment_SecureBoot_descr"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_INT_ID = "equipment_SecureBoot_intId"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_MIN_BIOS_VERSION = "equipment_SecureBoot_minBiosVersion"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_MIN_CIMC_VERSION = "equipment_SecureBoot_minCimcVersion"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_NAME = "equipment_SecureBoot_name"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_POLICY_LEVEL = "equipment_SecureBoot_policyLevel"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_POLICY_OWNER = "equipment_SecureBoot_policyOwner"
    SORT_PROP_EQUIPMENT_SECURE_CONTROLLER_ID = "equipment_SecureController_id"
    SORT_PROP_EQUIPMENT_SECURE_CONTROLLER_MODEL = "equipment_SecureController_model"
    SORT_PROP_EQUIPMENT_SECURE_CONTROLLER_REVISION = "equipment_SecureController_revision"
    SORT_PROP_EQUIPMENT_SECURE_CONTROLLER_SERIAL = "equipment_SecureController_serial"
    SORT_PROP_EQUIPMENT_SECURE_CONTROLLER_VENDOR = "equipment_SecureController_vendor"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_DELETED = "equipment_SecurityUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_SecurityUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_SecurityUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_SecurityUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_SecurityUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_SecurityUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_SecurityUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SecurityUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_MODEL = "equipment_SecurityUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SecurityUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_REVISION = "equipment_SecurityUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER_VENDOR = "equipment_SecurityUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_ADAPTOR_MODEL = "equipment_ServerFeatureCap_adaptorModel"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_CMOS_RESET_SUPPORTED = "equipment_ServerFeatureCap_cmosResetSupported"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_MAX_VIRTUAL_DRIVES_PER_SERVER = "equipment_ServerFeatureCap_maxVirtualDrivesPerServer"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_MAX_VIRTUAL_ETH_IF_PER_SERVER = "equipment_ServerFeatureCap_maxVirtualEthIfPerServer"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_NUMBER_OF_SERVER_UNITS = "equipment_ServerFeatureCap_numberOfServerUnits"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_STORAGE_JBOD_MODE_SUPPORTED = "equipment_ServerFeatureCap_storageJbodModeSupported"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_DESCR = "equipment_ServerPortCapProvider_descr"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_END_PORT_ID = "equipment_ServerPortCapProvider_endPortId"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_INT_ID = "equipment_ServerPortCapProvider_intId"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_NAME = "equipment_ServerPortCapProvider_name"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_POLICY_LEVEL = "equipment_ServerPortCapProvider_policyLevel"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_POLICY_OWNER = "equipment_ServerPortCapProvider_policyOwner"
    SORT_PROP_EQUIPMENT_SERVER_PORT_CAP_PROVIDER_START_PORT_ID = "equipment_ServerPortCapProvider_startPortId"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_DELETED = "equipment_ServerUnitCapProvider_deleted"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_ServerUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ServerUnitCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ServerUnitCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_ServerUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_ServerUnitCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ServerUnitCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MAX_LOCAL_DISKS = "equipment_ServerUnitCapProvider_maxLocalDisks"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ServerUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MODEL = "equipment_ServerUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ServerUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_REVISION = "equipment_ServerUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_VENDOR = "equipment_ServerUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_CAN_BE_FRUED = "equipment_ServiceDef_canBeFRUed"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_DESCR = "equipment_ServiceDef_descr"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_INT_ID = "equipment_ServiceDef_intId"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_NAME = "equipment_ServiceDef_name"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_POLICY_LEVEL = "equipment_ServiceDef_policyLevel"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_POLICY_OWNER = "equipment_ServiceDef_policyOwner"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_REMOVAL_CONDITIONS = "equipment_ServiceDef_removalConditions"
    SORT_PROP_EQUIPMENT_SERVICE_DEF_SERVICE_PHILOSOPHY = "equipment_ServiceDef_servicePhilosophy"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ADMIN_POWER_STATE = "equipment_SharedIOModule_adminPowerState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ASSET_TAG = "equipment_SharedIOModule_assetTag"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_BASE_ADDR = "equipment_SharedIOModule_baseAddr"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CHASSIS_ID = "equipment_SharedIOModule_chassisId"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CHECK_POINT = "equipment_SharedIOModule_checkPoint"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CONFIG_STATE = "equipment_SharedIOModule_configState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_DISCOVERY = "equipment_SharedIOModule_discovery"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FE_OFFLINE_TS = "equipment_SharedIOModule_feOfflineTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FE_READY_TS = "equipment_SharedIOModule_feReadyTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FLT_AGGR = "equipment_SharedIOModule_fltAggr"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ID = "equipment_SharedIOModule_id"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_LC_NAME = "equipment_SharedIOModule_lcName"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_LC_TS = "equipment_SharedIOModule_lcTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MAC_OF_SHARED_IOMA = "equipment_SharedIOModule_macOfSharedIOMA"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MAC_OF_SHARED_IOMB = "equipment_SharedIOModule_macOfSharedIOMB"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MANAGING_INSTANCE = "equipment_SharedIOModule_managingInstance"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MFG_TIME = "equipment_SharedIOModule_mfgTime"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MODEL = "equipment_SharedIOModule_model"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_QUALIFIER = "equipment_SharedIOModule_operQualifier"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_QUALIFIER_REASON = "equipment_SharedIOModule_operQualifierReason"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_STATE = "equipment_SharedIOModule_operState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPERABILITY = "equipment_SharedIOModule_operability"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PART_NUMBER = "equipment_SharedIOModule_partNumber"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PEER_DN = "equipment_SharedIOModule_peerDn"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PERF = "equipment_SharedIOModule_perf"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_POWER = "equipment_SharedIOModule_power"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PRESENCE = "equipment_SharedIOModule_presence"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_REACHABILITY = "equipment_SharedIOModule_reachability"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_REVISION = "equipment_SharedIOModule_revision"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_SERIAL = "equipment_SharedIOModule_serial"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_THERMAL = "equipment_SharedIOModule_thermal"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_UPGRADE_STATUS = "equipment_SharedIOModule_upgradeStatus"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_USR_LBL = "equipment_SharedIOModule_usrLbl"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VENDOR = "equipment_SharedIOModule_vendor"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VID = "equipment_SharedIOModule_vid"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VOLTAGE = "equipment_SharedIOModule_voltage"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_DELETED = "equipment_SiocCapProvider_deleted"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_DEPRECATED = "equipment_SiocCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_SiocCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_SiocCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_GENCOUNT = "equipment_SiocCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_LOAD_ERRORS = "equipment_SiocCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_LOAD_WARNINGS = "equipment_SiocCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SiocCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_MODEL = "equipment_SiocCapProvider_model"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SiocCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_REVISION = "equipment_SiocCapProvider_revision"
    SORT_PROP_EQUIPMENT_SIOC_CAP_PROVIDER_VENDOR = "equipment_SiocCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP = "equipment_SiocTempStatsHist_cmcTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_AVG = "equipment_SiocTempStatsHist_cmcTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_MAX = "equipment_SiocTempStatsHist_cmcTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_MIN = "equipment_SiocTempStatsHist_cmcTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP = "equipment_SiocTempStatsHist_frontTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_AVG = "equipment_SiocTempStatsHist_frontTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_MAX = "equipment_SiocTempStatsHist_frontTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_MIN = "equipment_SiocTempStatsHist_frontTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_ID = "equipment_SiocTempStatsHist_id"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP = "equipment_SiocTempStatsHist_midTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_AVG = "equipment_SiocTempStatsHist_midTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_MAX = "equipment_SiocTempStatsHist_midTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_MIN = "equipment_SiocTempStatsHist_midTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MOST_RECENT = "equipment_SiocTempStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP = "equipment_SiocTempStatsHist_rearTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_AVG = "equipment_SiocTempStatsHist_rearTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_MAX = "equipment_SiocTempStatsHist_rearTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_MIN = "equipment_SiocTempStatsHist_rearTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_SUSPECT = "equipment_SiocTempStatsHist_suspect"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_THRESHOLDED = "equipment_SiocTempStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_TIME_COLLECTED = "equipment_SiocTempStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP = "equipment_SiocTempStatsHist_vicTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_AVG = "equipment_SiocTempStatsHist_vicTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_MAX = "equipment_SiocTempStatsHist_vicTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_MIN = "equipment_SiocTempStatsHist_vicTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP = "equipment_SiocTempStats_cmcTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_AVG = "equipment_SiocTempStats_cmcTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_MAX = "equipment_SiocTempStats_cmcTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_MIN = "equipment_SiocTempStats_cmcTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP = "equipment_SiocTempStats_frontTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_AVG = "equipment_SiocTempStats_frontTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_MAX = "equipment_SiocTempStats_frontTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_MIN = "equipment_SiocTempStats_frontTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_INTERVALS = "equipment_SiocTempStats_intervals"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP = "equipment_SiocTempStats_midTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_AVG = "equipment_SiocTempStats_midTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_MAX = "equipment_SiocTempStats_midTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_MIN = "equipment_SiocTempStats_midTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP = "equipment_SiocTempStats_rearTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_AVG = "equipment_SiocTempStats_rearTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_MAX = "equipment_SiocTempStats_rearTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_MIN = "equipment_SiocTempStats_rearTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_SUSPECT = "equipment_SiocTempStats_suspect"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_THRESHOLDED = "equipment_SiocTempStats_thresholded"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_TIME_COLLECTED = "equipment_SiocTempStats_timeCollected"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_UPDATE = "equipment_SiocTempStats_update"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP = "equipment_SiocTempStats_vicTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_AVG = "equipment_SiocTempStats_vicTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_MAX = "equipment_SiocTempStats_vicTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_MIN = "equipment_SiocTempStats_vicTempMin"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_DESCR = "equipment_SlotArrayRef_descr"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_INT_ID = "equipment_SlotArrayRef_intId"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_NAME = "equipment_SlotArrayRef_name"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_NUMBER_OF_SLOTS_SPANNED = "equipment_SlotArrayRef_numberOfSlotsSpanned"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_POLICY_LEVEL = "equipment_SlotArrayRef_policyLevel"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_POLICY_OWNER = "equipment_SlotArrayRef_policyOwner"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_SLOT_SPAN_ORIENTATION = "equipment_SlotArrayRef_slotSpanOrientation"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_REF_TARGET_DN = "equipment_SlotArrayRef_targetDn"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_DESCR = "equipment_SlotArray_descr"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_DEVICE_SLOT_OFFSET = "equipment_SlotArray_deviceSlotOffset"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_FIRST_INDEX = "equipment_SlotArray_firstIndex"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_HEIGHT = "equipment_SlotArray_height"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_HORIZONTAL_START_OFFSET = "equipment_SlotArray_horizontalStartOffset"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_INLINE_GROUP_SEPARATION = "equipment_SlotArray_inlineGroupSeparation"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_INLINE_GROUP_SIZE = "equipment_SlotArray_inlineGroupSize"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_INLINE_OFFSET = "equipment_SlotArray_inlineOffset"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_INT_ID = "equipment_SlotArray_intId"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_LOCATION = "equipment_SlotArray_location"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_NAME = "equipment_SlotArray_name"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_NUMBER_OF_ONBOARD_DISKS = "equipment_SlotArray_numberOfOnboardDisks"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_NUMBER_OF_SLOTS = "equipment_SlotArray_numberOfSlots"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_ONBOARD_DISK_BASE_PORT_NO = "equipment_SlotArray_onboardDiskBasePortNo"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_ONBOARD_DISK_FIRST_INDEX = "equipment_SlotArray_onboardDiskFirstIndex"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_ORIENTATION = "equipment_SlotArray_orientation"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_POLICY_LEVEL = "equipment_SlotArray_policyLevel"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_POLICY_OWNER = "equipment_SlotArray_policyOwner"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_SELECTOR = "equipment_SlotArray_selector"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_SLOTS_PER_LINE = "equipment_SlotArray_slotsPerLine"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_STORAGE_BIOS_MODE = "equipment_SlotArray_storageBiosMode"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_SUB_OEM_ID = "equipment_SlotArray_subOemId"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_GROUP_SEPARATION = "equipment_SlotArray_transverseGroupSeparation"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_GROUP_SIZE = "equipment_SlotArray_transverseGroupSize"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_OFFSET = "equipment_SlotArray_transverseOffset"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_VERTICAL_START_OFFSET = "equipment_SlotArray_verticalStartOffset"
    SORT_PROP_EQUIPMENT_SLOT_ARRAY_WIDTH = "equipment_SlotArray_width"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_ID = "equipment_SlotEnclosure_id"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_MODEL = "equipment_SlotEnclosure_model"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_OPER_QUALIFIER_REASON = "equipment_SlotEnclosure_operQualifierReason"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_OPERABILITY = "equipment_SlotEnclosure_operability"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_PRESENCE = "equipment_SlotEnclosure_presence"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_REVISION = "equipment_SlotEnclosure_revision"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_SERIAL = "equipment_SlotEnclosure_serial"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_VENDOR = "equipment_SlotEnclosure_vendor"
    SORT_PROP_EQUIPMENT_SLOT_EP_ENCLOSURE_ID = "equipment_SlotEp_enclosureId"
    SORT_PROP_EQUIPMENT_SLOT_EP_FLT_AGGR = "equipment_SlotEp_fltAggr"
    SORT_PROP_EQUIPMENT_SLOT_EP_ID = "equipment_SlotEp_id"
    SORT_PROP_EQUIPMENT_SLOT_EP_MODEL = "equipment_SlotEp_model"
    SORT_PROP_EQUIPMENT_SLOT_EP_OPER_QUALIFIER_REASON = "equipment_SlotEp_operQualifierReason"
    SORT_PROP_EQUIPMENT_SLOT_EP_OPERABILITY = "equipment_SlotEp_operability"
    SORT_PROP_EQUIPMENT_SLOT_EP_PRESENCE = "equipment_SlotEp_presence"
    SORT_PROP_EQUIPMENT_SLOT_EP_REF_DN = "equipment_SlotEp_refDn"
    SORT_PROP_EQUIPMENT_SLOT_EP_REVISION = "equipment_SlotEp_revision"
    SORT_PROP_EQUIPMENT_SLOT_EP_SERIAL = "equipment_SlotEp_serial"
    SORT_PROP_EQUIPMENT_SLOT_EP_TYPE = "equipment_SlotEp_type"
    SORT_PROP_EQUIPMENT_SLOT_EP_VENDOR = "equipment_SlotEp_vendor"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_ID = "equipment_Slot_enclosureId"
    SORT_PROP_EQUIPMENT_SLOT_ID = "equipment_Slot_id"
    SORT_PROP_EQUIPMENT_SLOT_MODEL = "equipment_Slot_model"
    SORT_PROP_EQUIPMENT_SLOT_OPER_QUALIFIER_REASON = "equipment_Slot_operQualifierReason"
    SORT_PROP_EQUIPMENT_SLOT_OPERABILITY = "equipment_Slot_operability"
    SORT_PROP_EQUIPMENT_SLOT_PRESENCE = "equipment_Slot_presence"
    SORT_PROP_EQUIPMENT_SLOT_REVISION = "equipment_Slot_revision"
    SORT_PROP_EQUIPMENT_SLOT_SERIAL = "equipment_Slot_serial"
    SORT_PROP_EQUIPMENT_SLOT_TYPE = "equipment_Slot_type"
    SORT_PROP_EQUIPMENT_SLOT_VENDOR = "equipment_Slot_vendor"
    SORT_PROP_EQUIPMENT_SPDM_CERTIFICATE_CAP_IS_SUPPORTED = "equipment_SpdmCertificateCap_isSupported"
    SORT_PROP_EQUIPMENT_SPDM_CERTIFICATE_CAP_MIN_CIMC_VERSION = "equipment_SpdmCertificateCap_minCimcVersion"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_DESCR = "equipment_SpeedCompatibility_descr"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_INT_ID = "equipment_SpeedCompatibility_intId"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_NAME = "equipment_SpeedCompatibility_name"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_POLICY_LEVEL = "equipment_SpeedCompatibility_policyLevel"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_POLICY_OWNER = "equipment_SpeedCompatibility_policyOwner"
    SORT_PROP_EQUIPMENT_SPEED_COMPATIBILITY_SPEED_INFO = "equipment_SpeedCompatibility_speedInfo"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulBladeCompIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_STATE = "equipment_StatefulBladeCompIf_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPERABILITY = "equipment_StatefulBladeCompIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PERF = "equipment_StatefulBladeCompIf_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_POWER = "equipment_StatefulBladeCompIf_power"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PRESENCE = "equipment_StatefulBladeCompIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_THERMAL = "equipment_StatefulBladeCompIf_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_VOLTAGE = "equipment_StatefulBladeCompIf_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_ID = "equipment_StatefulBladeComp_id"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_LOCATION_DN = "equipment_StatefulBladeComp_locationDn"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_MODEL = "equipment_StatefulBladeComp_model"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulBladeComp_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_STATE = "equipment_StatefulBladeComp_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPERABILITY = "equipment_StatefulBladeComp_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_PERF = "equipment_StatefulBladeComp_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_POWER = "equipment_StatefulBladeComp_power"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_PRESENCE = "equipment_StatefulBladeComp_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_REVISION = "equipment_StatefulBladeComp_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_SERIAL = "equipment_StatefulBladeComp_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_THERMAL = "equipment_StatefulBladeComp_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_VENDOR = "equipment_StatefulBladeComp_vendor"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_VOLTAGE = "equipment_StatefulBladeComp_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulChCompIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_STATE = "equipment_StatefulChCompIf_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPERABILITY = "equipment_StatefulChCompIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_PERF = "equipment_StatefulChCompIf_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_POWER = "equipment_StatefulChCompIf_power"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_PRESENCE = "equipment_StatefulChCompIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_THERMAL = "equipment_StatefulChCompIf_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_VOLTAGE = "equipment_StatefulChCompIf_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_ID = "equipment_StatefulChComp_id"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_MODEL = "equipment_StatefulChComp_model"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulChComp_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPER_STATE = "equipment_StatefulChComp_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPERABILITY = "equipment_StatefulChComp_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_PERF = "equipment_StatefulChComp_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_POWER = "equipment_StatefulChComp_power"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_PRESENCE = "equipment_StatefulChComp_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_REVISION = "equipment_StatefulChComp_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_SERIAL = "equipment_StatefulChComp_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_THERMAL = "equipment_StatefulChComp_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_VENDOR = "equipment_StatefulChComp_vendor"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_VOLTAGE = "equipment_StatefulChComp_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_OPER_QUALIFIER_REASON = "equipment_StatefulIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_OPERABILITY = "equipment_StatefulIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_PRESENCE = "equipment_StatefulIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_ID = "equipment_Stateful_id"
    SORT_PROP_EQUIPMENT_STATEFUL_MODEL = "equipment_Stateful_model"
    SORT_PROP_EQUIPMENT_STATEFUL_OPER_QUALIFIER_REASON = "equipment_Stateful_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_OPERABILITY = "equipment_Stateful_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_PRESENCE = "equipment_Stateful_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_REVISION = "equipment_Stateful_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_SERIAL = "equipment_Stateful_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_VENDOR = "equipment_Stateful_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_DESCR = "equipment_StorageControllerConfig_descr"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_DEVICE = "equipment_StorageControllerConfig_device"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_INT_ID = "equipment_StorageControllerConfig_intId"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_MIN_VERSION = "equipment_StorageControllerConfig_minVersion"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_NAME = "equipment_StorageControllerConfig_name"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_PNUOS_SUPPORTED = "equipment_StorageControllerConfig_pnuosSupported"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_POLICY_LEVEL = "equipment_StorageControllerConfig_policyLevel"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_POLICY_OWNER = "equipment_StorageControllerConfig_policyOwner"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_STORAGE_BIOS_MODE = "equipment_StorageControllerConfig_storageBiosMode"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_STORAGEPID = "equipment_StorageControllerConfig_storagepid"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_SUB_OEM_ID = "equipment_StorageControllerConfig_subOemId"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_SUBDEVICE = "equipment_StorageControllerConfig_subdevice"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_SUBVENDOR = "equipment_StorageControllerConfig_subvendor"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_CONFIG_VENDOR = "equipment_StorageControllerConfig_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF_NUM_SLOTS = "equipment_StorageControllerSlotDef_numSlots"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF_ORDER = "equipment_StorageControllerSlotDef_order"
    SORT_PROP_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF_SLOT_NUM = "equipment_StorageControllerSlotDef_slotNum"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_DELETED = "equipment_StorageEncCapProvider_deleted"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_DEPRECATED = "equipment_StorageEncCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_StorageEncCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_StorageEncCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_GENCOUNT = "equipment_StorageEncCapProvider_gencount"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_LOAD_ERRORS = "equipment_StorageEncCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_LOAD_WARNINGS = "equipment_StorageEncCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_StorageEncCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_MODEL = "equipment_StorageEncCapProvider_model"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_StorageEncCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_REVISION = "equipment_StorageEncCapProvider_revision"
    SORT_PROP_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER_VENDOR = "equipment_StorageEncCapProvider_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_LIMIT_CAP_MAX_LUNS = "equipment_StorageLimitCap_maxLuns"
    SORT_PROP_EQUIPMENT_STORAGE_LIMIT_CAP_MAX_LUNS_PER_DG = "equipment_StorageLimitCap_maxLunsPerDG"
    SORT_PROP_EQUIPMENT_STORAGE_LIMIT_CAP_ME4308_SUPPORTED = "equipment_StorageLimitCap_me4308Supported"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_DELETED = "equipment_StorageNvmeSwitchCapProvider_deleted"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_DEPRECATED = "equipment_StorageNvmeSwitchCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_StorageNvmeSwitchCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_StorageNvmeSwitchCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_GENCOUNT = "equipment_StorageNvmeSwitchCapProvider_gencount"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_LOAD_ERRORS = "equipment_StorageNvmeSwitchCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_LOAD_WARNINGS = "equipment_StorageNvmeSwitchCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_StorageNvmeSwitchCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_MODEL = "equipment_StorageNvmeSwitchCapProvider_model"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_StorageNvmeSwitchCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_REVISION = "equipment_StorageNvmeSwitchCapProvider_revision"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_CAP_PROVIDER_VENDOR = "equipment_StorageNvmeSwitchCapProvider_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_DESCR = "equipment_StorageNvmeSwitchDef_descr"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_FORCE_UPDATE_VERSION = "equipment_StorageNvmeSwitchDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_INT_ID = "equipment_StorageNvmeSwitchDef_intId"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_NAME = "equipment_StorageNvmeSwitchDef_name"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_OOB_INTERFACE_SUPPORTED = "equipment_StorageNvmeSwitchDef_oobInterfaceSupported"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_POLICY_LEVEL = "equipment_StorageNvmeSwitchDef_policyLevel"
    SORT_PROP_EQUIPMENT_STORAGE_NVME_SWITCH_DEF_POLICY_OWNER = "equipment_StorageNvmeSwitchDef_policyOwner"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_DELETED = "equipment_StorageSasExpanderCapProvider_deleted"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_DEPRECATED = "equipment_StorageSasExpanderCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_StorageSasExpanderCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_StorageSasExpanderCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_GENCOUNT = "equipment_StorageSasExpanderCapProvider_gencount"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_LOAD_ERRORS = "equipment_StorageSasExpanderCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_StorageSasExpanderCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_StorageSasExpanderCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_MODEL = "equipment_StorageSasExpanderCapProvider_model"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_StorageSasExpanderCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_REVISION = "equipment_StorageSasExpanderCapProvider_revision"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER_VENDOR = "equipment_StorageSasExpanderCapProvider_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF_MIN_BOOT_FW_CIMC_VERSION = "equipment_StorageSasExpanderCapRef_minBootFwCimcVersion"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF_MIN_CIMC_VERSION = "equipment_StorageSasExpanderCapRef_minCimcVersion"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF_MODEL = "equipment_StorageSasExpanderCapRef_model"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF_REVISION = "equipment_StorageSasExpanderCapRef_revision"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF_VENDOR = "equipment_StorageSasExpanderCapRef_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_DESCR = "equipment_StorageSasExpanderDef_descr"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_FORCE_UPDATE_VERSION = "equipment_StorageSasExpanderDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_INT_ID = "equipment_StorageSasExpanderDef_intId"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_NAME = "equipment_StorageSasExpanderDef_name"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_OOB_INTERFACE_SUPPORTED = "equipment_StorageSasExpanderDef_oobInterfaceSupported"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_POLICY_LEVEL = "equipment_StorageSasExpanderDef_policyLevel"
    SORT_PROP_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF_POLICY_OWNER = "equipment_StorageSasExpanderDef_policyOwner"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_DELETED = "equipment_SwitchCapProvider_deleted"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_DEPRECATED = "equipment_SwitchCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_SwitchCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_SwitchCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_EXPECTED_MEMORY = "equipment_SwitchCapProvider_expectedMemory"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_GENCOUNT = "equipment_SwitchCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_LOAD_ERRORS = "equipment_SwitchCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_LOAD_WARNINGS = "equipment_SwitchCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SwitchCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_MODEL = "equipment_SwitchCapProvider_model"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SwitchCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_REVISION = "equipment_SwitchCapProvider_revision"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_VENDOR = "equipment_SwitchCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_DESCR = "equipment_SwitchCap_descr"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_DYNAMIC_VIFS_SUPPORTED = "equipment_SwitchCap_dynamicVifsSupported"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_FAN_MODULES_SUPPORTED = "equipment_SwitchCap_fanModulesSupported"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_INT_ID = "equipment_SwitchCap_intId"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_LOCATOR_BEACON_SUPPORTED = "equipment_SwitchCap_locatorBeaconSupported"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_ACTIVE_SPAN_SESSION_COUNT = "equipment_SwitchCap_maxActiveSpanSessionCount"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_ETH1G_PORT = "equipment_SwitchCap_maxEth1gPort"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_ETH1G_SLOT = "equipment_SwitchCap_maxEth1gSlot"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_ETH_PC_MEMBERS = "equipment_SwitchCap_maxEthPcMembers"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_ETH_PCS = "equipment_SwitchCap_maxEthPcs"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_FC_PCS = "equipment_SwitchCap_maxFcPcs"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_FCOE_PC_MEMBERS = "equipment_SwitchCap_maxFcoePcMembers"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_PORT_ID = "equipment_SwitchCap_maxPortId"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_SLOT = "equipment_SwitchCap_maxSlot"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MAX_UPLINK_PORTS = "equipment_SwitchCap_maxUplinkPorts"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MGMT_DAUGHTER_CARD_SLOT_ID = "equipment_SwitchCap_mgmtDaughterCardSlotId"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_MIN_ACTIVE_FAN = "equipment_SwitchCap_minActiveFan"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_NAME = "equipment_SwitchCap_name"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_POLICY_LEVEL = "equipment_SwitchCap_policyLevel"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_POLICY_OWNER = "equipment_SwitchCap_policyOwner"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_SERENO_NETFLOW_SUPPORTED = "equipment_SwitchCap_serenoNetflowSupported"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_VP_COMPRESSION_SUPPORTED = "equipment_SwitchCap_vpCompressionSupported"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_DESCR = "equipment_SwitchCard_descr"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_FLT_AGGR = "equipment_SwitchCard_fltAggr"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_ID = "equipment_SwitchCard_id"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_MODEL = "equipment_SwitchCard_model"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_NUM_PORTS = "equipment_SwitchCard_numPorts"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPER_QUALIFIER_REASON = "equipment_SwitchCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPER_STATE = "equipment_SwitchCard_operState"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPERABILITY = "equipment_SwitchCard_operability"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_PERF = "equipment_SwitchCard_perf"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_POWER = "equipment_SwitchCard_power"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_PRESENCE = "equipment_SwitchCard_presence"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_REVISION = "equipment_SwitchCard_revision"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_SERIAL = "equipment_SwitchCard_serial"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_STATE = "equipment_SwitchCard_state"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_THERMAL = "equipment_SwitchCard_thermal"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_TS = "equipment_SwitchCard_ts"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_VENDOR = "equipment_SwitchCard_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_VOLTAGE = "equipment_SwitchCard_voltage"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_DELETED = "equipment_SwitchIOCardCapProvider_deleted"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_DEPRECATED = "equipment_SwitchIOCardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_SwitchIOCardCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_SwitchIOCardCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_EXPECTED_MEMORY = "equipment_SwitchIOCardCapProvider_expectedMemory"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_GENCOUNT = "equipment_SwitchIOCardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_SwitchIOCardCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_SwitchIOCardCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SwitchIOCardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_MODEL = "equipment_SwitchIOCardCapProvider_model"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SwitchIOCardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_REVISION = "equipment_SwitchIOCardCapProvider_revision"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_VENDOR = "equipment_SwitchIOCardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_DESCR = "equipment_SwitchIOCardFsmStage_descr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_LAST_UPDATE_TIME = "equipment_SwitchIOCardFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_NAME = "equipment_SwitchIOCardFsmStage_name"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_ORDER = "equipment_SwitchIOCardFsmStage_order"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_RETRY = "equipment_SwitchIOCardFsmStage_retry"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_STAGE_STATUS = "equipment_SwitchIOCardFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_TASK_COMPLETION = "equipment_SwitchIOCardFsmTask_completion"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_TASK_FLAGS = "equipment_SwitchIOCardFsmTask_flags"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_TASK_ITEM = "equipment_SwitchIOCardFsmTask_item"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_TASK_SEQ_ID = "equipment_SwitchIOCardFsmTask_seqId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_COMPLETION_TIME = "equipment_SwitchIOCardFsm_completionTime"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_CURRENT_FSM = "equipment_SwitchIOCardFsm_currentFsm"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_DESCR = "equipment_SwitchIOCardFsm_descr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_FSM_STATUS = "equipment_SwitchIOCardFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_INSTANCE_ID = "equipment_SwitchIOCardFsm_instanceId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_PROGRESS = "equipment_SwitchIOCardFsm_progress"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_ERR_CODE = "equipment_SwitchIOCardFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_ERR_DESCR = "equipment_SwitchIOCardFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_RSLT = "equipment_SwitchIOCardFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_PEER_POWER_STATE = "equipment_SwitchIOCard_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_POWER_STATE = "equipment_SwitchIOCard_adminPowerState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_STATE = "equipment_SwitchIOCard_adminState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ASSET_TAG = "equipment_SwitchIOCard_assetTag"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_BASE_ADDR = "equipment_SwitchIOCard_baseAddr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CHASSIS_ID = "equipment_SwitchIOCard_chassisId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CONFIG_STATE = "equipment_SwitchIOCard_configState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_DISCOVERY = "equipment_SwitchIOCard_discovery"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FE_OFFLINE_TS = "equipment_SwitchIOCard_feOfflineTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FE_READY_TS = "equipment_SwitchIOCard_feReadyTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FLT_AGGR = "equipment_SwitchIOCard_fltAggr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_DESCR = "equipment_SwitchIOCard_fsmDescr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_FLAGS = "equipment_SwitchIOCard_fsmFlags"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_PREV = "equipment_SwitchIOCard_fsmPrev"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_PROGR = "equipment_SwitchIOCard_fsmProgr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_INV_ERR_CODE = "equipment_SwitchIOCard_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_INV_ERR_DESCR = "equipment_SwitchIOCard_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_RMT_INV_RSLT = "equipment_SwitchIOCard_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE_DESCR = "equipment_SwitchIOCard_fsmStageDescr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STAMP = "equipment_SwitchIOCard_fsmStamp"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_STATUS = "equipment_SwitchIOCard_fsmStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FSM_TRY = "equipment_SwitchIOCard_fsmTry"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ID = "equipment_SwitchIOCard_id"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_LC_NAME = "equipment_SwitchIOCard_lcName"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_LC_TS = "equipment_SwitchIOCard_lcTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_MFG_TIME = "equipment_SwitchIOCard_mfgTime"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_MODEL = "equipment_SwitchIOCard_model"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_EVAC_STATE = "equipment_SwitchIOCard_operEvacState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_QUALIFIER = "equipment_SwitchIOCard_operQualifier"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_QUALIFIER_REASON = "equipment_SwitchIOCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_STATE = "equipment_SwitchIOCard_operState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPERABILITY = "equipment_SwitchIOCard_operability"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PART_NUMBER = "equipment_SwitchIOCard_partNumber"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PEER_COMM_STATUS = "equipment_SwitchIOCard_peerCommStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PEER_DN = "equipment_SwitchIOCard_peerDn"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PERF = "equipment_SwitchIOCard_perf"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_POWER = "equipment_SwitchIOCard_power"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PRESENCE = "equipment_SwitchIOCard_presence"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PROCESSOR_THERMAL_STATE = "equipment_SwitchIOCard_processorThermalState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_REVISION = "equipment_SwitchIOCard_revision"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SERIAL = "equipment_SwitchIOCard_serial"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SIDE = "equipment_SwitchIOCard_side"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SWITCH_ID = "equipment_SwitchIOCard_switchId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_THERMAL = "equipment_SwitchIOCard_thermal"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_UPGRADE_STATUS = "equipment_SwitchIOCard_upgradeStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_USR_LBL = "equipment_SwitchIOCard_usrLbl"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_VENDOR = "equipment_SwitchIOCard_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_VID = "equipment_SwitchIOCard_vid"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_VOLTAGE = "equipment_SwitchIOCard_voltage"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_DESCR = "equipment_SwitchTypeDef_descr"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_INT_ID = "equipment_SwitchTypeDef_intId"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_NAME = "equipment_SwitchTypeDef_name"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_POLICY_LEVEL = "equipment_SwitchTypeDef_policyLevel"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_POLICY_OWNER = "equipment_SwitchTypeDef_policyOwner"
    SORT_PROP_EQUIPMENT_SWITCH_TYPE_DEF_TYPE = "equipment_SwitchTypeDef_type"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_DESCR = "equipment_SystemIOControllerFsmStage_descr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_LAST_UPDATE_TIME = "equipment_SystemIOControllerFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_NAME = "equipment_SystemIOControllerFsmStage_name"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_ORDER = "equipment_SystemIOControllerFsmStage_order"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_RETRY = "equipment_SystemIOControllerFsmStage_retry"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_STAGE_STATUS = "equipment_SystemIOControllerFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK_COMPLETION = "equipment_SystemIOControllerFsmTask_completion"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK_FLAGS = "equipment_SystemIOControllerFsmTask_flags"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK_ITEM = "equipment_SystemIOControllerFsmTask_item"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK_SEQ_ID = "equipment_SystemIOControllerFsmTask_seqId"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_COMPLETION_TIME = "equipment_SystemIOControllerFsm_completionTime"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_CURRENT_FSM = "equipment_SystemIOControllerFsm_currentFsm"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_DESCR = "equipment_SystemIOControllerFsm_descr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_FSM_STATUS = "equipment_SystemIOControllerFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_INSTANCE_ID = "equipment_SystemIOControllerFsm_instanceId"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_PROGRESS = "equipment_SystemIOControllerFsm_progress"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_ERR_CODE = "equipment_SystemIOControllerFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_ERR_DESCR = "equipment_SystemIOControllerFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_RSLT = "equipment_SystemIOControllerFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ADMIN_POWER_STATE = "equipment_SystemIOController_adminPowerState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ADMIN_STATE = "equipment_SystemIOController_adminState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ASSET_TAG = "equipment_SystemIOController_assetTag"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CHASSIS_ID = "equipment_SystemIOController_chassisId"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CHECK_POINT = "equipment_SystemIOController_checkPoint"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONFIG_STATE = "equipment_SystemIOController_configState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONN_PATH = "equipment_SystemIOController_connPath"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONN_STATUS = "equipment_SystemIOController_connStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_DISCOVERY = "equipment_SystemIOController_discovery"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FLT_AGGR = "equipment_SystemIOController_fltAggr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_DESCR = "equipment_SystemIOController_fsmDescr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_PREV = "equipment_SystemIOController_fsmPrev"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_PROGR = "equipment_SystemIOController_fsmProgr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_INV_ERR_CODE = "equipment_SystemIOController_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_INV_ERR_DESCR = "equipment_SystemIOController_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_RMT_INV_RSLT = "equipment_SystemIOController_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE_DESCR = "equipment_SystemIOController_fsmStageDescr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAMP = "equipment_SystemIOController_fsmStamp"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STATUS = "equipment_SystemIOController_fsmStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TRY = "equipment_SystemIOController_fsmTry"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ID = "equipment_SystemIOController_id"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_LC_NAME = "equipment_SystemIOController_lcName"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_LC_TS = "equipment_SystemIOController_lcTs"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MANAGING_INSTANCE = "equipment_SystemIOController_managingInstance"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MFG_TIME = "equipment_SystemIOController_mfgTime"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MODEL = "equipment_SystemIOController_model"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_QUALIFIER = "equipment_SystemIOController_operQualifier"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_QUALIFIER_REASON = "equipment_SystemIOController_operQualifierReason"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_STATE = "equipment_SystemIOController_operState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERABILITY = "equipment_SystemIOController_operability"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PART_NUMBER = "equipment_SystemIOController_partNumber"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PERF = "equipment_SystemIOController_perf"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_POWER = "equipment_SystemIOController_power"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PRESENCE = "equipment_SystemIOController_presence"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_RE_INSERT = "equipment_SystemIOController_reInsert"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_REACHABILITY = "equipment_SystemIOController_reachability"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_REVISION = "equipment_SystemIOController_revision"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ROLE = "equipment_SystemIOController_role"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_SERIAL = "equipment_SystemIOController_serial"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_THERMAL = "equipment_SystemIOController_thermal"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_USR_LBL = "equipment_SystemIOController_usrLbl"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VENDOR = "equipment_SystemIOController_vendor"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VID = "equipment_SystemIOController_vid"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VOLTAGE = "equipment_SystemIOController_voltage"
    SORT_PROP_EQUIPMENT_TIER_APPLY = "equipment_Tier_apply"
    SORT_PROP_EQUIPMENT_TIER_DESCR = "equipment_Tier_descr"
    SORT_PROP_EQUIPMENT_TIER_INT_ID = "equipment_Tier_intId"
    SORT_PROP_EQUIPMENT_TIER_NAME = "equipment_Tier_name"
    SORT_PROP_EQUIPMENT_TIER_POLICY_LEVEL = "equipment_Tier_policyLevel"
    SORT_PROP_EQUIPMENT_TIER_POLICY_OWNER = "equipment_Tier_policyOwner"
    SORT_PROP_EQUIPMENT_TIER_SRC_TEMPL_NAME = "equipment_Tier_srcTemplName"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_DELETED = "equipment_TpmCapProvider_deleted"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_DEPRECATED = "equipment_TpmCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_TpmCapProvider_elementLoadFailures"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_TpmCapProvider_elementsLoaded"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_GENCOUNT = "equipment_TpmCapProvider_gencount"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_LOAD_ERRORS = "equipment_TpmCapProvider_loadErrors"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_LOAD_WARNINGS = "equipment_TpmCapProvider_loadWarnings"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_TpmCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_MODEL = "equipment_TpmCapProvider_model"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_TpmCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_REVISION = "equipment_TpmCapProvider_revision"
    SORT_PROP_EQUIPMENT_TPM_CAP_PROVIDER_VENDOR = "equipment_TpmCapProvider_vendor"
    SORT_PROP_EQUIPMENT_TPM_ACTIVE_STATUS = "equipment_Tpm_activeStatus"
    SORT_PROP_EQUIPMENT_TPM_ADMIN_ACTION = "equipment_Tpm_adminAction"
    SORT_PROP_EQUIPMENT_TPM_CONFIG_STATE = "equipment_Tpm_configState"
    SORT_PROP_EQUIPMENT_TPM_ENABLED_STATUS = "equipment_Tpm_enabledStatus"
    SORT_PROP_EQUIPMENT_TPM_ID = "equipment_Tpm_id"
    SORT_PROP_EQUIPMENT_TPM_MODEL = "equipment_Tpm_model"
    SORT_PROP_EQUIPMENT_TPM_OWNERSHIP = "equipment_Tpm_ownership"
    SORT_PROP_EQUIPMENT_TPM_PASSWORD_STATE = "equipment_Tpm_passwordState"
    SORT_PROP_EQUIPMENT_TPM_PRESENCE = "equipment_Tpm_presence"
    SORT_PROP_EQUIPMENT_TPM_REVISION = "equipment_Tpm_revision"
    SORT_PROP_EQUIPMENT_TPM_SERIAL = "equipment_Tpm_serial"
    SORT_PROP_EQUIPMENT_TPM_TPM_REVISION = "equipment_Tpm_tpmRevision"
    SORT_PROP_EQUIPMENT_TPM_TYPE = "equipment_Tpm_type"
    SORT_PROP_EQUIPMENT_TPM_VENDOR = "equipment_Tpm_vendor"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_DESCR = "equipment_UnifiedPortCapProvider_descr"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_END_PORT_ID = "equipment_UnifiedPortCapProvider_endPortId"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_FC_SPEED_CAP = "equipment_UnifiedPortCapProvider_fcSpeedCap"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_INT_ID = "equipment_UnifiedPortCapProvider_intId"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_NAME = "equipment_UnifiedPortCapProvider_name"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_POLICY_LEVEL = "equipment_UnifiedPortCapProvider_policyLevel"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_POLICY_OWNER = "equipment_UnifiedPortCapProvider_policyOwner"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_START_PORT_ID = "equipment_UnifiedPortCapProvider_startPortId"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_SUPPORTED_ALGORITHM = "equipment_UnifiedPortCapProvider_supportedAlgorithm"
    SORT_PROP_EQUIPMENT_UUID_FEATURE_CAP_UUID_SUPPORT_MODE = "equipment_UuidFeatureCap_uuidSupportMode"
    SORT_PROP_EQUIPMENT_VERSION_CONSTRAINT_MIN_VER1 = "equipment_VersionConstraint_minVer1"
    SORT_PROP_EQUIPMENT_XCVR_ID = "equipment_Xcvr_id"
    SORT_PROP_EQUIPMENT_XCVR_MODEL = "equipment_Xcvr_model"
    SORT_PROP_EQUIPMENT_XCVR_REVISION = "equipment_Xcvr_revision"
    SORT_PROP_EQUIPMENT_XCVR_SERIAL = "equipment_Xcvr_serial"
    SORT_PROP_EQUIPMENT_XCVR_TS = "equipment_Xcvr_ts"
    SORT_PROP_EQUIPMENT_XCVR_TYPE = "equipment_Xcvr_type"
    SORT_PROP_EQUIPMENT_XCVR_VENDOR = "equipment_Xcvr_vendor"
    SORT_PROP_ETHER_CIO_EP_EP_DN = "ether_CIoEp_epDn"
    SORT_PROP_ETHER_CIO_EP_IF_ROLE = "ether_CIoEp_ifRole"
    SORT_PROP_ETHER_CIO_EP_IF_TYPE = "ether_CIoEp_ifType"
    SORT_PROP_ETHER_CIO_EP_LOCALE = "ether_CIoEp_locale"
    SORT_PROP_ETHER_CIO_EP_NAME = "ether_CIoEp_name"
    SORT_PROP_ETHER_CIO_EP_PEER_DN = "ether_CIoEp_peerDn"
    SORT_PROP_ETHER_CIO_EP_PORT_ID = "ether_CIoEp_portId"
    SORT_PROP_ETHER_CIO_EP_SWITCH_ID = "ether_CIoEp_switchId"
    SORT_PROP_ETHER_CIO_EP_TRANSPORT = "ether_CIoEp_transport"
    SORT_PROP_ETHER_CIO_EP_TYPE = "ether_CIoEp_type"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN = "ether_ErrStatsHist_align"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA = "ether_ErrStatsHist_alignDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_AVG = "ether_ErrStatsHist_alignDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MAX = "ether_ErrStatsHist_alignDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MIN = "ether_ErrStatsHist_alignDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX = "ether_ErrStatsHist_deferredTx"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA = "ether_ErrStatsHist_deferredTxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_AVG = "ether_ErrStatsHist_deferredTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MAX = "ether_ErrStatsHist_deferredTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MIN = "ether_ErrStatsHist_deferredTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS = "ether_ErrStatsHist_fcs"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA = "ether_ErrStatsHist_fcsDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_AVG = "ether_ErrStatsHist_fcsDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_MAX = "ether_ErrStatsHist_fcsDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_MIN = "ether_ErrStatsHist_fcsDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_ID = "ether_ErrStatsHist_id"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX = "ether_ErrStatsHist_intMacRx"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA = "ether_ErrStatsHist_intMacRxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_AVG = "ether_ErrStatsHist_intMacRxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MAX = "ether_ErrStatsHist_intMacRxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MIN = "ether_ErrStatsHist_intMacRxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX = "ether_ErrStatsHist_intMacTx"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA = "ether_ErrStatsHist_intMacTxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_AVG = "ether_ErrStatsHist_intMacTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MAX = "ether_ErrStatsHist_intMacTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MIN = "ether_ErrStatsHist_intMacTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_MOST_RECENT = "ether_ErrStatsHist_mostRecent"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD = "ether_ErrStatsHist_outDiscard"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA = "ether_ErrStatsHist_outDiscardDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_AVG = "ether_ErrStatsHist_outDiscardDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MAX = "ether_ErrStatsHist_outDiscardDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MIN = "ether_ErrStatsHist_outDiscardDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV = "ether_ErrStatsHist_rcv"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA = "ether_ErrStatsHist_rcvDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_AVG = "ether_ErrStatsHist_rcvDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_MAX = "ether_ErrStatsHist_rcvDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_MIN = "ether_ErrStatsHist_rcvDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_SUSPECT = "ether_ErrStatsHist_suspect"
    SORT_PROP_ETHER_ERR_STATS_HIST_THRESHOLDED = "ether_ErrStatsHist_thresholded"
    SORT_PROP_ETHER_ERR_STATS_HIST_TIME_COLLECTED = "ether_ErrStatsHist_timeCollected"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE = "ether_ErrStatsHist_underSize"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA = "ether_ErrStatsHist_underSizeDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_AVG = "ether_ErrStatsHist_underSizeDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MAX = "ether_ErrStatsHist_underSizeDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MIN = "ether_ErrStatsHist_underSizeDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT = "ether_ErrStatsHist_xmit"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA = "ether_ErrStatsHist_xmitDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_AVG = "ether_ErrStatsHist_xmitDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_MAX = "ether_ErrStatsHist_xmitDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_MIN = "ether_ErrStatsHist_xmitDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_ALIGN = "ether_ErrStats_align"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA = "ether_ErrStats_alignDelta"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_AVG = "ether_ErrStats_alignDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_MAX = "ether_ErrStats_alignDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_MIN = "ether_ErrStats_alignDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX = "ether_ErrStats_deferredTx"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA = "ether_ErrStats_deferredTxDelta"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_AVG = "ether_ErrStats_deferredTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MAX = "ether_ErrStats_deferredTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MIN = "ether_ErrStats_deferredTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_FCS = "ether_ErrStats_fcs"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA = "ether_ErrStats_fcsDelta"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_AVG = "ether_ErrStats_fcsDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_MAX = "ether_ErrStats_fcsDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_MIN = "ether_ErrStats_fcsDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX = "ether_ErrStats_intMacRx"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA = "ether_ErrStats_intMacRxDelta"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_AVG = "ether_ErrStats_intMacRxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MAX = "ether_ErrStats_intMacRxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MIN = "ether_ErrStats_intMacRxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX = "ether_ErrStats_intMacTx"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA = "ether_ErrStats_intMacTxDelta"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_AVG = "ether_ErrStats_intMacTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MAX = "ether_ErrStats_intMacTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MIN = "ether_ErrStats_intMacTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INTERVALS = "ether_ErrStats_intervals"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD = "ether_ErrStats_outDiscard"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA = "ether_ErrStats_outDiscardDelta"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_AVG = "ether_ErrStats_outDiscardDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MAX = "ether_ErrStats_outDiscardDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MIN = "ether_ErrStats_outDiscardDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_RCV = "ether_ErrStats_rcv"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA = "ether_ErrStats_rcvDelta"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_AVG = "ether_ErrStats_rcvDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_MAX = "ether_ErrStats_rcvDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_MIN = "ether_ErrStats_rcvDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_SUSPECT = "ether_ErrStats_suspect"
    SORT_PROP_ETHER_ERR_STATS_THRESHOLDED = "ether_ErrStats_thresholded"
    SORT_PROP_ETHER_ERR_STATS_TIME_COLLECTED = "ether_ErrStats_timeCollected"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE = "ether_ErrStats_underSize"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA = "ether_ErrStats_underSizeDelta"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_AVG = "ether_ErrStats_underSizeDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MAX = "ether_ErrStats_underSizeDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MIN = "ether_ErrStats_underSizeDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_UPDATE = "ether_ErrStats_update"
    SORT_PROP_ETHER_ERR_STATS_XMIT = "ether_ErrStats_xmit"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA = "ether_ErrStats_xmitDelta"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_AVG = "ether_ErrStats_xmitDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_MAX = "ether_ErrStats_xmitDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_MIN = "ether_ErrStats_xmitDeltaMin"
    SORT_PROP_ETHER_EXTERNAL_EP_ADMIN_STATE = "ether_ExternalEp_adminState"
    SORT_PROP_ETHER_EXTERNAL_EP_AGGR_PORT_ID = "ether_ExternalEp_aggrPortId"
    SORT_PROP_ETHER_EXTERNAL_EP_CHASSIS_ID = "ether_ExternalEp_chassisId"
    SORT_PROP_ETHER_EXTERNAL_EP_EP_DN = "ether_ExternalEp_epDn"
    SORT_PROP_ETHER_EXTERNAL_EP_IF_ROLE = "ether_ExternalEp_ifRole"
    SORT_PROP_ETHER_EXTERNAL_EP_IF_TYPE = "ether_ExternalEp_ifType"
    SORT_PROP_ETHER_EXTERNAL_EP_LOCALE = "ether_ExternalEp_locale"
    SORT_PROP_ETHER_EXTERNAL_EP_NAME = "ether_ExternalEp_name"
    SORT_PROP_ETHER_EXTERNAL_EP_PEER_AGGR_PORT_ID = "ether_ExternalEp_peerAggrPortId"
    SORT_PROP_ETHER_EXTERNAL_EP_PEER_CHASSIS_ID = "ether_ExternalEp_peerChassisId"
    SORT_PROP_ETHER_EXTERNAL_EP_PEER_DN = "ether_ExternalEp_peerDn"
    SORT_PROP_ETHER_EXTERNAL_EP_PEER_PORT_ID = "ether_ExternalEp_peerPortId"
    SORT_PROP_ETHER_EXTERNAL_EP_PEER_SLOT_ID = "ether_ExternalEp_peerSlotId"
    SORT_PROP_ETHER_EXTERNAL_EP_PORT_ID = "ether_ExternalEp_portId"
    SORT_PROP_ETHER_EXTERNAL_EP_SLOT_ID = "ether_ExternalEp_slotId"
    SORT_PROP_ETHER_EXTERNAL_EP_SWITCH_ID = "ether_ExternalEp_switchId"
    SORT_PROP_ETHER_EXTERNAL_EP_TRANSPORT = "ether_ExternalEp_transport"
    SORT_PROP_ETHER_EXTERNAL_EP_TYPE = "ether_ExternalEp_type"
    SORT_PROP_ETHER_EXTERNAL_PC_ADMIN_STATE = "ether_ExternalPc_adminState"
    SORT_PROP_ETHER_EXTERNAL_PC_EP_DN = "ether_ExternalPc_epDn"
    SORT_PROP_ETHER_EXTERNAL_PC_FLT_AGGR = "ether_ExternalPc_fltAggr"
    SORT_PROP_ETHER_EXTERNAL_PC_IF_ROLE = "ether_ExternalPc_ifRole"
    SORT_PROP_ETHER_EXTERNAL_PC_IF_TYPE = "ether_ExternalPc_ifType"
    SORT_PROP_ETHER_EXTERNAL_PC_LOCALE = "ether_ExternalPc_locale"
    SORT_PROP_ETHER_EXTERNAL_PC_NAME = "ether_ExternalPc_name"
    SORT_PROP_ETHER_EXTERNAL_PC_OPER_STATE = "ether_ExternalPc_operState"
    SORT_PROP_ETHER_EXTERNAL_PC_PEER_DN = "ether_ExternalPc_peerDn"
    SORT_PROP_ETHER_EXTERNAL_PC_PORT_ID = "ether_ExternalPc_portId"
    SORT_PROP_ETHER_EXTERNAL_PC_STATE_QUAL = "ether_ExternalPc_stateQual"
    SORT_PROP_ETHER_EXTERNAL_PC_SWITCH_ID = "ether_ExternalPc_switchId"
    SORT_PROP_ETHER_EXTERNAL_PC_TRANSPORT = "ether_ExternalPc_transport"
    SORT_PROP_ETHER_EXTERNAL_PC_TYPE = "ether_ExternalPc_type"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX = "ether_FcoeInterfaceStatsHist_bytesRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA = "ether_FcoeInterfaceStatsHist_bytesRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX = "ether_FcoeInterfaceStatsHist_bytesTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA = "ether_FcoeInterfaceStatsHist_bytesTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX = "ether_FcoeInterfaceStatsHist_droppedRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA = "ether_FcoeInterfaceStatsHist_droppedRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX = "ether_FcoeInterfaceStatsHist_droppedTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA = "ether_FcoeInterfaceStatsHist_droppedTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX = "ether_FcoeInterfaceStatsHist_errorsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA = "ether_FcoeInterfaceStatsHist_errorsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX = "ether_FcoeInterfaceStatsHist_errorsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA = "ether_FcoeInterfaceStatsHist_errorsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ID = "ether_FcoeInterfaceStatsHist_id"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_MOST_RECENT = "ether_FcoeInterfaceStatsHist_mostRecent"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX = "ether_FcoeInterfaceStatsHist_packetsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA = "ether_FcoeInterfaceStatsHist_packetsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX = "ether_FcoeInterfaceStatsHist_packetsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA = "ether_FcoeInterfaceStatsHist_packetsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_SUSPECT = "ether_FcoeInterfaceStatsHist_suspect"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_THRESHOLDED = "ether_FcoeInterfaceStatsHist_thresholded"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_TIME_COLLECTED = "ether_FcoeInterfaceStatsHist_timeCollected"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX = "ether_FcoeInterfaceStats_bytesRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA = "ether_FcoeInterfaceStats_bytesRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX = "ether_FcoeInterfaceStats_bytesTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA = "ether_FcoeInterfaceStats_bytesTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX = "ether_FcoeInterfaceStats_droppedRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA = "ether_FcoeInterfaceStats_droppedRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX = "ether_FcoeInterfaceStats_droppedTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA = "ether_FcoeInterfaceStats_droppedTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX = "ether_FcoeInterfaceStats_errorsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA = "ether_FcoeInterfaceStats_errorsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX = "ether_FcoeInterfaceStats_errorsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA = "ether_FcoeInterfaceStats_errorsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_INTERVALS = "ether_FcoeInterfaceStats_intervals"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX = "ether_FcoeInterfaceStats_packetsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA = "ether_FcoeInterfaceStats_packetsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX = "ether_FcoeInterfaceStats_packetsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA = "ether_FcoeInterfaceStats_packetsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_SUSPECT = "ether_FcoeInterfaceStats_suspect"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_THRESHOLDED = "ether_FcoeInterfaceStats_thresholded"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_TIME_COLLECTED = "ether_FcoeInterfaceStats_timeCollected"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_UPDATE = "ether_FcoeInterfaceStats_update"
    SORT_PROP_ETHER_INT_FIO_EP_ADMIN_STATE = "ether_IntFIoEp_adminState"
    SORT_PROP_ETHER_INT_FIO_EP_AGGR_PORT_ID = "ether_IntFIoEp_aggrPortId"
    SORT_PROP_ETHER_INT_FIO_EP_CHASSIS_ID = "ether_IntFIoEp_chassisId"
    SORT_PROP_ETHER_INT_FIO_EP_EP_DN = "ether_IntFIoEp_epDn"
    SORT_PROP_ETHER_INT_FIO_EP_IF_ROLE = "ether_IntFIoEp_ifRole"
    SORT_PROP_ETHER_INT_FIO_EP_IF_TYPE = "ether_IntFIoEp_ifType"
    SORT_PROP_ETHER_INT_FIO_EP_LOCALE = "ether_IntFIoEp_locale"
    SORT_PROP_ETHER_INT_FIO_EP_NAME = "ether_IntFIoEp_name"
    SORT_PROP_ETHER_INT_FIO_EP_PEER_AGGR_PORT_ID = "ether_IntFIoEp_peerAggrPortId"
    SORT_PROP_ETHER_INT_FIO_EP_PEER_CHASSIS_ID = "ether_IntFIoEp_peerChassisId"
    SORT_PROP_ETHER_INT_FIO_EP_PEER_DN = "ether_IntFIoEp_peerDn"
    SORT_PROP_ETHER_INT_FIO_EP_PEER_PORT_ID = "ether_IntFIoEp_peerPortId"
    SORT_PROP_ETHER_INT_FIO_EP_PEER_SLOT_ID = "ether_IntFIoEp_peerSlotId"
    SORT_PROP_ETHER_INT_FIO_EP_PORT_ID = "ether_IntFIoEp_portId"
    SORT_PROP_ETHER_INT_FIO_EP_SLOT_ID = "ether_IntFIoEp_slotId"
    SORT_PROP_ETHER_INT_FIO_EP_SWITCH_ID = "ether_IntFIoEp_switchId"
    SORT_PROP_ETHER_INT_FIO_EP_TRANSPORT = "ether_IntFIoEp_transport"
    SORT_PROP_ETHER_INT_FIO_EP_TYPE = "ether_IntFIoEp_type"
    SORT_PROP_ETHER_INTERNAL_PC_EP_DN = "ether_InternalPc_epDn"
    SORT_PROP_ETHER_INTERNAL_PC_FLT_AGGR = "ether_InternalPc_fltAggr"
    SORT_PROP_ETHER_INTERNAL_PC_IF_ROLE = "ether_InternalPc_ifRole"
    SORT_PROP_ETHER_INTERNAL_PC_IF_TYPE = "ether_InternalPc_ifType"
    SORT_PROP_ETHER_INTERNAL_PC_LOCALE = "ether_InternalPc_locale"
    SORT_PROP_ETHER_INTERNAL_PC_NAME = "ether_InternalPc_name"
    SORT_PROP_ETHER_INTERNAL_PC_OPER_STATE = "ether_InternalPc_operState"
    SORT_PROP_ETHER_INTERNAL_PC_PEER_DN = "ether_InternalPc_peerDn"
    SORT_PROP_ETHER_INTERNAL_PC_PORT_ID = "ether_InternalPc_portId"
    SORT_PROP_ETHER_INTERNAL_PC_STATE_QUAL = "ether_InternalPc_stateQual"
    SORT_PROP_ETHER_INTERNAL_PC_SWITCH_ID = "ether_InternalPc_switchId"
    SORT_PROP_ETHER_INTERNAL_PC_TRANSPORT = "ether_InternalPc_transport"
    SORT_PROP_ETHER_INTERNAL_PC_TYPE = "ether_InternalPc_type"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST = "ether_LossStatsHist_SQETest"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA = "ether_LossStatsHist_SQETestDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_AVG = "ether_LossStatsHist_SQETestDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MAX = "ether_LossStatsHist_SQETestDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MIN = "ether_LossStatsHist_SQETestDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE = "ether_LossStatsHist_carrierSense"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA = "ether_LossStatsHist_carrierSenseDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_AVG = "ether_LossStatsHist_carrierSenseDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MAX = "ether_LossStatsHist_carrierSenseDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MIN = "ether_LossStatsHist_carrierSenseDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION = "ether_LossStatsHist_excessCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA = "ether_LossStatsHist_excessCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_AVG = "ether_LossStatsHist_excessCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MAX = "ether_LossStatsHist_excessCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MIN = "ether_LossStatsHist_excessCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS = "ether_LossStatsHist_giants"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA = "ether_LossStatsHist_giantsDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_AVG = "ether_LossStatsHist_giantsDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MAX = "ether_LossStatsHist_giantsDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MIN = "ether_LossStatsHist_giantsDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_ID = "ether_LossStatsHist_id"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION = "ether_LossStatsHist_lateCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA = "ether_LossStatsHist_lateCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_AVG = "ether_LossStatsHist_lateCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MAX = "ether_LossStatsHist_lateCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MIN = "ether_LossStatsHist_lateCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MOST_RECENT = "ether_LossStatsHist_mostRecent"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION = "ether_LossStatsHist_multiCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA = "ether_LossStatsHist_multiCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_AVG = "ether_LossStatsHist_multiCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MAX = "ether_LossStatsHist_multiCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MIN = "ether_LossStatsHist_multiCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION = "ether_LossStatsHist_singleCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA = "ether_LossStatsHist_singleCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_AVG = "ether_LossStatsHist_singleCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MAX = "ether_LossStatsHist_singleCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MIN = "ether_LossStatsHist_singleCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SUSPECT = "ether_LossStatsHist_suspect"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL = "ether_LossStatsHist_symbol"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA = "ether_LossStatsHist_symbolDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_AVG = "ether_LossStatsHist_symbolDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MAX = "ether_LossStatsHist_symbolDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MIN = "ether_LossStatsHist_symbolDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_THRESHOLDED = "ether_LossStatsHist_thresholded"
    SORT_PROP_ETHER_LOSS_STATS_HIST_TIME_COLLECTED = "ether_LossStatsHist_timeCollected"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST = "ether_LossStats_SQETest"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA = "ether_LossStats_SQETestDelta"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_AVG = "ether_LossStats_SQETestDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_MAX = "ether_LossStats_SQETestDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_MIN = "ether_LossStats_SQETestDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE = "ether_LossStats_carrierSense"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA = "ether_LossStats_carrierSenseDelta"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_AVG = "ether_LossStats_carrierSenseDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MAX = "ether_LossStats_carrierSenseDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MIN = "ether_LossStats_carrierSenseDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION = "ether_LossStats_excessCollision"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA = "ether_LossStats_excessCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_AVG = "ether_LossStats_excessCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MAX = "ether_LossStats_excessCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MIN = "ether_LossStats_excessCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS = "ether_LossStats_giants"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA = "ether_LossStats_giantsDelta"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_AVG = "ether_LossStats_giantsDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_MAX = "ether_LossStats_giantsDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_MIN = "ether_LossStats_giantsDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_INTERVALS = "ether_LossStats_intervals"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION = "ether_LossStats_lateCollision"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA = "ether_LossStats_lateCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_AVG = "ether_LossStats_lateCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MAX = "ether_LossStats_lateCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MIN = "ether_LossStats_lateCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION = "ether_LossStats_multiCollision"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA = "ether_LossStats_multiCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_AVG = "ether_LossStats_multiCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MAX = "ether_LossStats_multiCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MIN = "ether_LossStats_multiCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION = "ether_LossStats_singleCollision"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA = "ether_LossStats_singleCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_AVG = "ether_LossStats_singleCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MAX = "ether_LossStats_singleCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MIN = "ether_LossStats_singleCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_SUSPECT = "ether_LossStats_suspect"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL = "ether_LossStats_symbol"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA = "ether_LossStats_symbolDelta"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_AVG = "ether_LossStats_symbolDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_MAX = "ether_LossStats_symbolDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_MIN = "ether_LossStats_symbolDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_THRESHOLDED = "ether_LossStats_thresholded"
    SORT_PROP_ETHER_LOSS_STATS_TIME_COLLECTED = "ether_LossStats_timeCollected"
    SORT_PROP_ETHER_LOSS_STATS_UPDATE = "ether_LossStats_update"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_CRC = "ether_NiErrStatsHist_crc"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_CRC_DELTA = "ether_NiErrStatsHist_crcDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_CRC_DELTA_AVG = "ether_NiErrStatsHist_crcDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_CRC_DELTA_MAX = "ether_NiErrStatsHist_crcDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_CRC_DELTA_MIN = "ether_NiErrStatsHist_crcDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_FRAME_TX = "ether_NiErrStatsHist_frameTx"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_FRAME_TX_DELTA = "ether_NiErrStatsHist_frameTxDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_FRAME_TX_DELTA_AVG = "ether_NiErrStatsHist_frameTxDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_FRAME_TX_DELTA_MAX = "ether_NiErrStatsHist_frameTxDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_FRAME_TX_DELTA_MIN = "ether_NiErrStatsHist_frameTxDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_ID = "ether_NiErrStatsHist_id"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_IN_RANGE = "ether_NiErrStatsHist_inRange"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_IN_RANGE_DELTA = "ether_NiErrStatsHist_inRangeDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_IN_RANGE_DELTA_AVG = "ether_NiErrStatsHist_inRangeDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_IN_RANGE_DELTA_MAX = "ether_NiErrStatsHist_inRangeDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_IN_RANGE_DELTA_MIN = "ether_NiErrStatsHist_inRangeDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_MOST_RECENT = "ether_NiErrStatsHist_mostRecent"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_SUSPECT = "ether_NiErrStatsHist_suspect"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_THRESHOLDED = "ether_NiErrStatsHist_thresholded"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TIME_COLLECTED = "ether_NiErrStatsHist_timeCollected"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_LONG = "ether_NiErrStatsHist_tooLong"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_LONG_DELTA = "ether_NiErrStatsHist_tooLongDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_LONG_DELTA_AVG = "ether_NiErrStatsHist_tooLongDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_LONG_DELTA_MAX = "ether_NiErrStatsHist_tooLongDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_LONG_DELTA_MIN = "ether_NiErrStatsHist_tooLongDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_SHORT = "ether_NiErrStatsHist_tooShort"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_SHORT_DELTA = "ether_NiErrStatsHist_tooShortDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_SHORT_DELTA_AVG = "ether_NiErrStatsHist_tooShortDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_SHORT_DELTA_MAX = "ether_NiErrStatsHist_tooShortDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_HIST_TOO_SHORT_DELTA_MIN = "ether_NiErrStatsHist_tooShortDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_CRC = "ether_NiErrStats_crc"
    SORT_PROP_ETHER_NI_ERR_STATS_CRC_DELTA = "ether_NiErrStats_crcDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_CRC_DELTA_AVG = "ether_NiErrStats_crcDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_CRC_DELTA_MAX = "ether_NiErrStats_crcDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_CRC_DELTA_MIN = "ether_NiErrStats_crcDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_FRAME_TX = "ether_NiErrStats_frameTx"
    SORT_PROP_ETHER_NI_ERR_STATS_FRAME_TX_DELTA = "ether_NiErrStats_frameTxDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_FRAME_TX_DELTA_AVG = "ether_NiErrStats_frameTxDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_FRAME_TX_DELTA_MAX = "ether_NiErrStats_frameTxDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_FRAME_TX_DELTA_MIN = "ether_NiErrStats_frameTxDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_IN_RANGE = "ether_NiErrStats_inRange"
    SORT_PROP_ETHER_NI_ERR_STATS_IN_RANGE_DELTA = "ether_NiErrStats_inRangeDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_IN_RANGE_DELTA_AVG = "ether_NiErrStats_inRangeDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_IN_RANGE_DELTA_MAX = "ether_NiErrStats_inRangeDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_IN_RANGE_DELTA_MIN = "ether_NiErrStats_inRangeDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_INTERVALS = "ether_NiErrStats_intervals"
    SORT_PROP_ETHER_NI_ERR_STATS_SUSPECT = "ether_NiErrStats_suspect"
    SORT_PROP_ETHER_NI_ERR_STATS_THRESHOLDED = "ether_NiErrStats_thresholded"
    SORT_PROP_ETHER_NI_ERR_STATS_TIME_COLLECTED = "ether_NiErrStats_timeCollected"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_LONG = "ether_NiErrStats_tooLong"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_LONG_DELTA = "ether_NiErrStats_tooLongDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_LONG_DELTA_AVG = "ether_NiErrStats_tooLongDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_LONG_DELTA_MAX = "ether_NiErrStats_tooLongDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_LONG_DELTA_MIN = "ether_NiErrStats_tooLongDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_SHORT = "ether_NiErrStats_tooShort"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_SHORT_DELTA = "ether_NiErrStats_tooShortDelta"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_SHORT_DELTA_AVG = "ether_NiErrStats_tooShortDeltaAvg"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_SHORT_DELTA_MAX = "ether_NiErrStats_tooShortDeltaMax"
    SORT_PROP_ETHER_NI_ERR_STATS_TOO_SHORT_DELTA_MIN = "ether_NiErrStats_tooShortDeltaMin"
    SORT_PROP_ETHER_NI_ERR_STATS_UPDATE = "ether_NiErrStats_update"
    SORT_PROP_ETHER_PIO_END_POINT_END_POINT_DN = "ether_PIoEndPoint_EndPointDn"
    SORT_PROP_ETHER_PIO_END_POINT_EP_CLOUD_TYPE = "ether_PIoEndPoint_epCloudType"
    SORT_PROP_ETHER_PIO_END_POINT_USR_LBL = "ether_PIoEndPoint_usrLbl"
    SORT_PROP_ETHER_PIO_EP_AGGR_PORT_ID = "ether_PIoEp_aggrPortId"
    SORT_PROP_ETHER_PIO_EP_CHASSIS_ID = "ether_PIoEp_chassisId"
    SORT_PROP_ETHER_PIO_EP_EP_DN = "ether_PIoEp_epDn"
    SORT_PROP_ETHER_PIO_EP_IF_ROLE = "ether_PIoEp_ifRole"
    SORT_PROP_ETHER_PIO_EP_IF_TYPE = "ether_PIoEp_ifType"
    SORT_PROP_ETHER_PIO_EP_LOCALE = "ether_PIoEp_locale"
    SORT_PROP_ETHER_PIO_EP_NAME = "ether_PIoEp_name"
    SORT_PROP_ETHER_PIO_EP_PEER_AGGR_PORT_ID = "ether_PIoEp_peerAggrPortId"
    SORT_PROP_ETHER_PIO_EP_PEER_CHASSIS_ID = "ether_PIoEp_peerChassisId"
    SORT_PROP_ETHER_PIO_EP_PEER_DN = "ether_PIoEp_peerDn"
    SORT_PROP_ETHER_PIO_EP_PEER_PORT_ID = "ether_PIoEp_peerPortId"
    SORT_PROP_ETHER_PIO_EP_PEER_SLOT_ID = "ether_PIoEp_peerSlotId"
    SORT_PROP_ETHER_PIO_EP_PORT_ID = "ether_PIoEp_portId"
    SORT_PROP_ETHER_PIO_EP_SLOT_ID = "ether_PIoEp_slotId"
    SORT_PROP_ETHER_PIO_EP_SWITCH_ID = "ether_PIoEp_switchId"
    SORT_PROP_ETHER_PIO_EP_TRANSPORT = "ether_PIoEp_transport"
    SORT_PROP_ETHER_PIO_EP_TYPE = "ether_PIoEp_type"
    SORT_PROP_ETHER_PIO_FSM_STAGE_DESCR = "ether_PIoFsmStage_descr"
    SORT_PROP_ETHER_PIO_FSM_STAGE_LAST_UPDATE_TIME = "ether_PIoFsmStage_lastUpdateTime"
    SORT_PROP_ETHER_PIO_FSM_STAGE_NAME = "ether_PIoFsmStage_name"
    SORT_PROP_ETHER_PIO_FSM_STAGE_ORDER = "ether_PIoFsmStage_order"
    SORT_PROP_ETHER_PIO_FSM_STAGE_RETRY = "ether_PIoFsmStage_retry"
    SORT_PROP_ETHER_PIO_FSM_STAGE_STAGE_STATUS = "ether_PIoFsmStage_stageStatus"
    SORT_PROP_ETHER_PIO_FSM_COMPLETION_TIME = "ether_PIoFsm_completionTime"
    SORT_PROP_ETHER_PIO_FSM_CURRENT_FSM = "ether_PIoFsm_currentFsm"
    SORT_PROP_ETHER_PIO_FSM_DESCR = "ether_PIoFsm_descr"
    SORT_PROP_ETHER_PIO_FSM_FSM_STATUS = "ether_PIoFsm_fsmStatus"
    SORT_PROP_ETHER_PIO_FSM_INSTANCE_ID = "ether_PIoFsm_instanceId"
    SORT_PROP_ETHER_PIO_FSM_PROGRESS = "ether_PIoFsm_progress"
    SORT_PROP_ETHER_PIO_FSM_RMT_ERR_CODE = "ether_PIoFsm_rmtErrCode"
    SORT_PROP_ETHER_PIO_FSM_RMT_ERR_DESCR = "ether_PIoFsm_rmtErrDescr"
    SORT_PROP_ETHER_PIO_FSM_RMT_RSLT = "ether_PIoFsm_rmtRslt"
    SORT_PROP_ETHER_PIO_ADMIN_STATE = "ether_PIo_adminState"
    SORT_PROP_ETHER_PIO_ADMIN_TRANSPORT = "ether_PIo_adminTransport"
    SORT_PROP_ETHER_PIO_AGGR_PORT_ID = "ether_PIo_aggrPortId"
    SORT_PROP_ETHER_PIO_CHASSIS_ID = "ether_PIo_chassisId"
    SORT_PROP_ETHER_PIO_ENCAP = "ether_PIo_encap"
    SORT_PROP_ETHER_PIO_EP_DN = "ether_PIo_epDn"
    SORT_PROP_ETHER_PIO_FSM_DESCR = "ether_PIo_fsmDescr"
    SORT_PROP_ETHER_PIO_FSM_PREV = "ether_PIo_fsmPrev"
    SORT_PROP_ETHER_PIO_FSM_PROGR = "ether_PIo_fsmProgr"
    SORT_PROP_ETHER_PIO_FSM_RMT_INV_ERR_CODE = "ether_PIo_fsmRmtInvErrCode"
    SORT_PROP_ETHER_PIO_FSM_RMT_INV_ERR_DESCR = "ether_PIo_fsmRmtInvErrDescr"
    SORT_PROP_ETHER_PIO_FSM_RMT_INV_RSLT = "ether_PIo_fsmRmtInvRslt"
    SORT_PROP_ETHER_PIO_FSM_STAGE_DESCR = "ether_PIo_fsmStageDescr"
    SORT_PROP_ETHER_PIO_FSM_STAMP = "ether_PIo_fsmStamp"
    SORT_PROP_ETHER_PIO_FSM_STATUS = "ether_PIo_fsmStatus"
    SORT_PROP_ETHER_PIO_FSM_TRY = "ether_PIo_fsmTry"
    SORT_PROP_ETHER_PIO_IF_ROLE = "ether_PIo_ifRole"
    SORT_PROP_ETHER_PIO_IF_TYPE = "ether_PIo_ifType"
    SORT_PROP_ETHER_PIO_IS_BREAKOUT_XCVR = "ether_PIo_isBreakoutXcvr"
    SORT_PROP_ETHER_PIO_IS_PORT_CHANNEL_MEMBER = "ether_PIo_isPortChannelMember"
    SORT_PROP_ETHER_PIO_LC = "ether_PIo_lc"
    SORT_PROP_ETHER_PIO_LIC_GP = "ether_PIo_licGP"
    SORT_PROP_ETHER_PIO_LIC_STATE = "ether_PIo_licState"
    SORT_PROP_ETHER_PIO_LOCALE = "ether_PIo_locale"
    SORT_PROP_ETHER_PIO_MAC = "ether_PIo_mac"
    SORT_PROP_ETHER_PIO_MODE = "ether_PIo_mode"
    SORT_PROP_ETHER_PIO_MODEL = "ether_PIo_model"
    SORT_PROP_ETHER_PIO_NAME = "ether_PIo_name"
    SORT_PROP_ETHER_PIO_NON_CR4 = "ether_PIo_nonCR4"
    SORT_PROP_ETHER_PIO_OPER_SPEED = "ether_PIo_operSpeed"
    SORT_PROP_ETHER_PIO_OPER_STATE = "ether_PIo_operState"
    SORT_PROP_ETHER_PIO_PEER_AGGR_PORT_ID = "ether_PIo_peerAggrPortId"
    SORT_PROP_ETHER_PIO_PEER_CHASSIS_ID = "ether_PIo_peerChassisId"
    SORT_PROP_ETHER_PIO_PEER_DN = "ether_PIo_peerDn"
    SORT_PROP_ETHER_PIO_PEER_PORT_ID = "ether_PIo_peerPortId"
    SORT_PROP_ETHER_PIO_PEER_SLOT_ID = "ether_PIo_peerSlotId"
    SORT_PROP_ETHER_PIO_PORT_CAPABILITY = "ether_PIo_portCapability"
    SORT_PROP_ETHER_PIO_PORT_ID = "ether_PIo_portId"
    SORT_PROP_ETHER_PIO_REVISION = "ether_PIo_revision"
    SORT_PROP_ETHER_PIO_SERIAL = "ether_PIo_serial"
    SORT_PROP_ETHER_PIO_SLOT_ID = "ether_PIo_slotId"
    SORT_PROP_ETHER_PIO_STATE_QUAL = "ether_PIo_stateQual"
    SORT_PROP_ETHER_PIO_SWITCH_ID = "ether_PIo_switchId"
    SORT_PROP_ETHER_PIO_TRANSPORT = "ether_PIo_transport"
    SORT_PROP_ETHER_PIO_TS = "ether_PIo_ts"
    SORT_PROP_ETHER_PIO_TYPE = "ether_PIo_type"
    SORT_PROP_ETHER_PIO_UNIFIED_PORT = "ether_PIo_unifiedPort"
    SORT_PROP_ETHER_PIO_USR_LBL = "ether_PIo_usrLbl"
    SORT_PROP_ETHER_PIO_VENDOR = "ether_PIo_vendor"
    SORT_PROP_ETHER_PIO_XCVR_TYPE = "ether_PIo_xcvrType"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_ID = "ether_PauseStatsHist_id"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_MOST_RECENT = "ether_PauseStatsHist_mostRecent"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE = "ether_PauseStatsHist_recvPause"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA = "ether_PauseStatsHist_recvPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_AVG = "ether_PauseStatsHist_recvPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MAX = "ether_PauseStatsHist_recvPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MIN = "ether_PauseStatsHist_recvPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS = "ether_PauseStatsHist_resets"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA = "ether_PauseStatsHist_resetsDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_AVG = "ether_PauseStatsHist_resetsDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MAX = "ether_PauseStatsHist_resetsDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MIN = "ether_PauseStatsHist_resetsDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_SUSPECT = "ether_PauseStatsHist_suspect"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_THRESHOLDED = "ether_PauseStatsHist_thresholded"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_TIME_COLLECTED = "ether_PauseStatsHist_timeCollected"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE = "ether_PauseStatsHist_xmitPause"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA = "ether_PauseStatsHist_xmitPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_AVG = "ether_PauseStatsHist_xmitPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MAX = "ether_PauseStatsHist_xmitPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MIN = "ether_PauseStatsHist_xmitPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_INTERVALS = "ether_PauseStats_intervals"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE = "ether_PauseStats_recvPause"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA = "ether_PauseStats_recvPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_AVG = "ether_PauseStats_recvPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MAX = "ether_PauseStats_recvPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MIN = "ether_PauseStats_recvPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS = "ether_PauseStats_resets"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA = "ether_PauseStats_resetsDelta"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_AVG = "ether_PauseStats_resetsDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_MAX = "ether_PauseStats_resetsDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_MIN = "ether_PauseStats_resetsDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_SUSPECT = "ether_PauseStats_suspect"
    SORT_PROP_ETHER_PAUSE_STATS_THRESHOLDED = "ether_PauseStats_thresholded"
    SORT_PROP_ETHER_PAUSE_STATS_TIME_COLLECTED = "ether_PauseStats_timeCollected"
    SORT_PROP_ETHER_PAUSE_STATS_UPDATE = "ether_PauseStats_update"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE = "ether_PauseStats_xmitPause"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA = "ether_PauseStats_xmitPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_AVG = "ether_PauseStats_xmitPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MAX = "ether_PauseStats_xmitPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MIN = "ether_PauseStats_xmitPauseDeltaMin"
    SORT_PROP_ETHER_PC_EP_DN = "ether_Pc_epDn"
    SORT_PROP_ETHER_PC_IF_ROLE = "ether_Pc_ifRole"
    SORT_PROP_ETHER_PC_IF_TYPE = "ether_Pc_ifType"
    SORT_PROP_ETHER_PC_LOCALE = "ether_Pc_locale"
    SORT_PROP_ETHER_PC_NAME = "ether_Pc_name"
    SORT_PROP_ETHER_PC_OPER_STATE = "ether_Pc_operState"
    SORT_PROP_ETHER_PC_PEER_DN = "ether_Pc_peerDn"
    SORT_PROP_ETHER_PC_PORT_ID = "ether_Pc_portId"
    SORT_PROP_ETHER_PC_STATE_QUAL = "ether_Pc_stateQual"
    SORT_PROP_ETHER_PC_SWITCH_ID = "ether_Pc_switchId"
    SORT_PROP_ETHER_PC_TRANSPORT = "ether_Pc_transport"
    SORT_PROP_ETHER_PC_TYPE = "ether_Pc_type"
    SORT_PROP_ETHER_PORT_CHAN_ID_ELEM_ASSIGNED_TO_DN = "ether_PortChanIdElem_assignedToDn"
    SORT_PROP_ETHER_PORT_CHAN_ID_ELEM_ID = "ether_PortChanIdElem_id"
    SORT_PROP_ETHER_PORT_CHAN_ID_ELEM_PREV_ASSIGNED_TO_DN = "ether_PortChanIdElem_prevAssignedToDn"
    SORT_PROP_ETHER_PORT_CHAN_ID_ELEM_RESERVED = "ether_PortChanIdElem_reserved"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS = "ether_RxStatsHist_broadcastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_RxStatsHist_broadcastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_ID = "ether_RxStatsHist_id"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS = "ether_RxStatsHist_jumboPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_RxStatsHist_jumboPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_RxStatsHist_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_RxStatsHist_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_RxStatsHist_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_MOST_RECENT = "ether_RxStatsHist_mostRecent"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS = "ether_RxStatsHist_multicastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_RxStatsHist_multicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_SUSPECT = "ether_RxStatsHist_suspect"
    SORT_PROP_ETHER_RX_STATS_HIST_THRESHOLDED = "ether_RxStatsHist_thresholded"
    SORT_PROP_ETHER_RX_STATS_HIST_TIME_COLLECTED = "ether_RxStatsHist_timeCollected"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES = "ether_RxStatsHist_totalBytes"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_RxStatsHist_totalBytesDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_RxStatsHist_totalBytesDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_RxStatsHist_totalBytesDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_RxStatsHist_totalBytesDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS = "ether_RxStatsHist_totalPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_RxStatsHist_totalPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_RxStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_RxStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_RxStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS = "ether_RxStatsHist_unicastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_RxStatsHist_unicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS = "ether_RxStats_broadcastPackets"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA = "ether_RxStats_broadcastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStats_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStats_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_INTERVALS = "ether_RxStats_intervals"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS = "ether_RxStats_jumboPackets"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA = "ether_RxStats_jumboPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_RxStats_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_RxStats_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_RxStats_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS = "ether_RxStats_multicastPackets"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA = "ether_RxStats_multicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStats_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStats_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStats_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_SUSPECT = "ether_RxStats_suspect"
    SORT_PROP_ETHER_RX_STATS_THRESHOLDED = "ether_RxStats_thresholded"
    SORT_PROP_ETHER_RX_STATS_TIME_COLLECTED = "ether_RxStats_timeCollected"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES = "ether_RxStats_totalBytes"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA = "ether_RxStats_totalBytesDelta"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_RxStats_totalBytesDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_RxStats_totalBytesDeltaMax"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_RxStats_totalBytesDeltaMin"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS = "ether_RxStats_totalPackets"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA = "ether_RxStats_totalPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_RxStats_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_RxStats_totalPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_RxStats_totalPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS = "ether_RxStats_unicastPackets"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA = "ether_RxStats_unicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_RxStats_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_RxStats_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_RxStats_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_UPDATE = "ether_RxStats_update"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_DESCR = "ether_ServerIntFIoFsmStage_descr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_LAST_UPDATE_TIME = "ether_ServerIntFIoFsmStage_lastUpdateTime"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_NAME = "ether_ServerIntFIoFsmStage_name"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_ORDER = "ether_ServerIntFIoFsmStage_order"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_RETRY = "ether_ServerIntFIoFsmStage_retry"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_STAGE_STATUS = "ether_ServerIntFIoFsmStage_stageStatus"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_TASK_COMPLETION = "ether_ServerIntFIoFsmTask_completion"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_TASK_FLAGS = "ether_ServerIntFIoFsmTask_flags"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_TASK_ITEM = "ether_ServerIntFIoFsmTask_item"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_TASK_SEQ_ID = "ether_ServerIntFIoFsmTask_seqId"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_COMPLETION_TIME = "ether_ServerIntFIoFsm_completionTime"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_CURRENT_FSM = "ether_ServerIntFIoFsm_currentFsm"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_DESCR = "ether_ServerIntFIoFsm_descr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_FSM_STATUS = "ether_ServerIntFIoFsm_fsmStatus"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_INSTANCE_ID = "ether_ServerIntFIoFsm_instanceId"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_PROGRESS = "ether_ServerIntFIoFsm_progress"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_ERR_CODE = "ether_ServerIntFIoFsm_rmtErrCode"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_ERR_DESCR = "ether_ServerIntFIoFsm_rmtErrDescr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_RSLT = "ether_ServerIntFIoFsm_rmtRslt"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_ADMIN_STATE = "ether_ServerIntFIoPcEp_adminState"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_AGGR_PORT_ID = "ether_ServerIntFIoPcEp_aggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_CHASSIS_ID = "ether_ServerIntFIoPcEp_chassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_EP_DN = "ether_ServerIntFIoPcEp_epDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_IF_ROLE = "ether_ServerIntFIoPcEp_ifRole"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_IF_TYPE = "ether_ServerIntFIoPcEp_ifType"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_LOCALE = "ether_ServerIntFIoPcEp_locale"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_MEMBERSHIP = "ether_ServerIntFIoPcEp_membership"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_NAME = "ether_ServerIntFIoPcEp_name"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PEER_AGGR_PORT_ID = "ether_ServerIntFIoPcEp_peerAggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PEER_CHASSIS_ID = "ether_ServerIntFIoPcEp_peerChassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PEER_DN = "ether_ServerIntFIoPcEp_peerDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PEER_PORT_ID = "ether_ServerIntFIoPcEp_peerPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PEER_SLOT_ID = "ether_ServerIntFIoPcEp_peerSlotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_PORT_ID = "ether_ServerIntFIoPcEp_portId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_SLOT_ID = "ether_ServerIntFIoPcEp_slotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_SWITCH_ID = "ether_ServerIntFIoPcEp_switchId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_TRANSPORT = "ether_ServerIntFIoPcEp_transport"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_TYPE = "ether_ServerIntFIoPcEp_type"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_CHASSIS_ID = "ether_ServerIntFIoPc_chassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_EP_DN = "ether_ServerIntFIoPc_epDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_FLT_AGGR = "ether_ServerIntFIoPc_fltAggr"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_IF_ROLE = "ether_ServerIntFIoPc_ifRole"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_IF_TYPE = "ether_ServerIntFIoPc_ifType"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_LOCALE = "ether_ServerIntFIoPc_locale"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_NAME = "ether_ServerIntFIoPc_name"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_OPER_SPEED = "ether_ServerIntFIoPc_operSpeed"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_OPER_STATE = "ether_ServerIntFIoPc_operState"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_PEER_DN = "ether_ServerIntFIoPc_peerDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_PORT_ID = "ether_ServerIntFIoPc_portId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_STATE_QUAL = "ether_ServerIntFIoPc_stateQual"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_SWITCH_ID = "ether_ServerIntFIoPc_switchId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_TRANSPORT = "ether_ServerIntFIoPc_transport"
    SORT_PROP_ETHER_SERVER_INT_FIO_PC_TYPE = "ether_ServerIntFIoPc_type"
    SORT_PROP_ETHER_SERVER_INT_FIO_ADMIN_SPEED = "ether_ServerIntFIo_adminSpeed"
    SORT_PROP_ETHER_SERVER_INT_FIO_ADMIN_STATE = "ether_ServerIntFIo_adminState"
    SORT_PROP_ETHER_SERVER_INT_FIO_AGGR_PORT_ID = "ether_ServerIntFIo_aggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_CHASSIS_ID = "ether_ServerIntFIo_chassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_CONNECTED_ADAPTOR_TYPE = "ether_ServerIntFIo_connectedAdaptorType"
    SORT_PROP_ETHER_SERVER_INT_FIO_ENCAP = "ether_ServerIntFIo_encap"
    SORT_PROP_ETHER_SERVER_INT_FIO_EP_DN = "ether_ServerIntFIo_epDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_DESCR = "ether_ServerIntFIo_fsmDescr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_PREV = "ether_ServerIntFIo_fsmPrev"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_PROGR = "ether_ServerIntFIo_fsmProgr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_INV_ERR_CODE = "ether_ServerIntFIo_fsmRmtInvErrCode"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_INV_ERR_DESCR = "ether_ServerIntFIo_fsmRmtInvErrDescr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_RMT_INV_RSLT = "ether_ServerIntFIo_fsmRmtInvRslt"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAGE_DESCR = "ether_ServerIntFIo_fsmStageDescr"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STAMP = "ether_ServerIntFIo_fsmStamp"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_STATUS = "ether_ServerIntFIo_fsmStatus"
    SORT_PROP_ETHER_SERVER_INT_FIO_FSM_TRY = "ether_ServerIntFIo_fsmTry"
    SORT_PROP_ETHER_SERVER_INT_FIO_IF_ROLE = "ether_ServerIntFIo_ifRole"
    SORT_PROP_ETHER_SERVER_INT_FIO_IF_TYPE = "ether_ServerIntFIo_ifType"
    SORT_PROP_ETHER_SERVER_INT_FIO_LOCALE = "ether_ServerIntFIo_locale"
    SORT_PROP_ETHER_SERVER_INT_FIO_MAC = "ether_ServerIntFIo_mac"
    SORT_PROP_ETHER_SERVER_INT_FIO_MAC_ADDR = "ether_ServerIntFIo_macAddr"
    SORT_PROP_ETHER_SERVER_INT_FIO_MODE = "ether_ServerIntFIo_mode"
    SORT_PROP_ETHER_SERVER_INT_FIO_MODEL = "ether_ServerIntFIo_model"
    SORT_PROP_ETHER_SERVER_INT_FIO_NAME = "ether_ServerIntFIo_name"
    SORT_PROP_ETHER_SERVER_INT_FIO_NS_SIZE = "ether_ServerIntFIo_nsSize"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_AGGR_PORT_ID = "ether_ServerIntFIo_operBorderAggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_PORT_ID = "ether_ServerIntFIo_operBorderPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_SLOT_ID = "ether_ServerIntFIo_operBorderSlotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_STATE = "ether_ServerIntFIo_operState"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_AGGR_PORT_ID = "ether_ServerIntFIo_peerAggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_CHASSIS_ID = "ether_ServerIntFIo_peerChassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_DN = "ether_ServerIntFIo_peerDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_ENCAP = "ether_ServerIntFIo_peerEncap"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_PORT_ID = "ether_ServerIntFIo_peerPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_SLOT_ID = "ether_ServerIntFIo_peerSlotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PORT_ID = "ether_ServerIntFIo_portId"
    SORT_PROP_ETHER_SERVER_INT_FIO_REVISION = "ether_ServerIntFIo_revision"
    SORT_PROP_ETHER_SERVER_INT_FIO_SERIAL = "ether_ServerIntFIo_serial"
    SORT_PROP_ETHER_SERVER_INT_FIO_SLOT_ID = "ether_ServerIntFIo_slotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_STATE_QUAL = "ether_ServerIntFIo_stateQual"
    SORT_PROP_ETHER_SERVER_INT_FIO_SWITCH_ID = "ether_ServerIntFIo_switchId"
    SORT_PROP_ETHER_SERVER_INT_FIO_TRANSPORT = "ether_ServerIntFIo_transport"
    SORT_PROP_ETHER_SERVER_INT_FIO_TS = "ether_ServerIntFIo_ts"
    SORT_PROP_ETHER_SERVER_INT_FIO_TYPE = "ether_ServerIntFIo_type"
    SORT_PROP_ETHER_SERVER_INT_FIO_USER_RECOVERY_OPERATION = "ether_ServerIntFIo_userRecoveryOperation"
    SORT_PROP_ETHER_SERVER_INT_FIO_VENDOR = "ether_ServerIntFIo_vendor"
    SORT_PROP_ETHER_SERVER_INT_FIO_XCVR_TYPE = "ether_ServerIntFIo_xcvrType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_ACK_STATE = "ether_SwitchIntFIoPcEp_ackState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_ADMIN_STATE = "ether_SwitchIntFIoPcEp_adminState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_AGGR_PORT_ID = "ether_SwitchIntFIoPcEp_aggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_CHASSIS_ID = "ether_SwitchIntFIoPcEp_chassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_EP_DN = "ether_SwitchIntFIoPcEp_epDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_IF_ROLE = "ether_SwitchIntFIoPcEp_ifRole"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_IF_TYPE = "ether_SwitchIntFIoPcEp_ifType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_LOCALE = "ether_SwitchIntFIoPcEp_locale"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_MEMBERSHIP = "ether_SwitchIntFIoPcEp_membership"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_NAME = "ether_SwitchIntFIoPcEp_name"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PEER_AGGR_PORT_ID = "ether_SwitchIntFIoPcEp_peerAggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PEER_CHASSIS_ID = "ether_SwitchIntFIoPcEp_peerChassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PEER_DN = "ether_SwitchIntFIoPcEp_peerDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PEER_PORT_ID = "ether_SwitchIntFIoPcEp_peerPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PEER_SLOT_ID = "ether_SwitchIntFIoPcEp_peerSlotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_PORT_ID = "ether_SwitchIntFIoPcEp_portId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_SLOT_ID = "ether_SwitchIntFIoPcEp_slotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_STATUS_CHANGE_TS = "ether_SwitchIntFIoPcEp_statusChangeTs"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_SWITCH_ID = "ether_SwitchIntFIoPcEp_switchId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_TRANSPORT = "ether_SwitchIntFIoPcEp_transport"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_TYPE = "ether_SwitchIntFIoPcEp_type"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_ADMIN_STATE = "ether_SwitchIntFIoPc_adminState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_CHASSIS_ID = "ether_SwitchIntFIoPc_chassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_EP_DN = "ether_SwitchIntFIoPc_epDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_FLT_AGGR = "ether_SwitchIntFIoPc_fltAggr"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_IF_ROLE = "ether_SwitchIntFIoPc_ifRole"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_IF_TYPE = "ether_SwitchIntFIoPc_ifType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_LOCALE = "ether_SwitchIntFIoPc_locale"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_MULTICAST_HW_HASH = "ether_SwitchIntFIoPc_multicastHwHash"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_NAME = "ether_SwitchIntFIoPc_name"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_OPER_SPEED = "ether_SwitchIntFIoPc_operSpeed"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_OPER_STATE = "ether_SwitchIntFIoPc_operState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_PEER_DN = "ether_SwitchIntFIoPc_peerDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_PORT_ID = "ether_SwitchIntFIoPc_portId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_STATE_QUAL = "ether_SwitchIntFIoPc_stateQual"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_SWITCH_ID = "ether_SwitchIntFIoPc_switchId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_TRANSPORT = "ether_SwitchIntFIoPc_transport"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PC_TYPE = "ether_SwitchIntFIoPc_type"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ACK = "ether_SwitchIntFIo_ack"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ADMIN_STATE = "ether_SwitchIntFIo_adminState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_AGGR_PORT_ID = "ether_SwitchIntFIo_aggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_CHASSIS_ID = "ether_SwitchIntFIo_chassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_DEL_FE_TS = "ether_SwitchIntFIo_delFeTs"
    SORT_PROP_ETHER_SWITCH_INT_FIO_DISCOVERY = "ether_SwitchIntFIo_discovery"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ENCAP = "ether_SwitchIntFIo_encap"
    SORT_PROP_ETHER_SWITCH_INT_FIO_EP_DN = "ether_SwitchIntFIo_epDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_IF_ROLE = "ether_SwitchIntFIo_ifRole"
    SORT_PROP_ETHER_SWITCH_INT_FIO_IF_TYPE = "ether_SwitchIntFIo_ifType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_LOCALE = "ether_SwitchIntFIo_locale"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MAC_ADDR = "ether_SwitchIntFIo_macAddr"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MODE = "ether_SwitchIntFIo_mode"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MODEL = "ether_SwitchIntFIo_model"
    SORT_PROP_ETHER_SWITCH_INT_FIO_NAME = "ether_SwitchIntFIo_name"
    SORT_PROP_ETHER_SWITCH_INT_FIO_NEW_FE_TS = "ether_SwitchIntFIo_newFeTs"
    SORT_PROP_ETHER_SWITCH_INT_FIO_OPER_STATE = "ether_SwitchIntFIo_operState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_AGGR_PORT_ID = "ether_SwitchIntFIo_peerAggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_CHASSIS_ID = "ether_SwitchIntFIo_peerChassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_DN = "ether_SwitchIntFIo_peerDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_PORT_ID = "ether_SwitchIntFIo_peerPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_SLOT_ID = "ether_SwitchIntFIo_peerSlotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PORT_ID = "ether_SwitchIntFIo_portId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_REVISION = "ether_SwitchIntFIo_revision"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SERIAL = "ether_SwitchIntFIo_serial"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SLOT_ID = "ether_SwitchIntFIo_slotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_STATE_QUAL = "ether_SwitchIntFIo_stateQual"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SWITCH_ID = "ether_SwitchIntFIo_switchId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TRANSPORT = "ether_SwitchIntFIo_transport"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TS = "ether_SwitchIntFIo_ts"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TYPE = "ether_SwitchIntFIo_type"
    SORT_PROP_ETHER_SWITCH_INT_FIO_UPLINK_ID = "ether_SwitchIntFIo_uplinkId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_VENDOR = "ether_SwitchIntFIo_vendor"
    SORT_PROP_ETHER_SWITCH_INT_FIO_XCVR_TYPE = "ether_SwitchIntFIo_xcvrType"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS = "ether_TxStatsHist_broadcastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_TxStatsHist_broadcastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_ID = "ether_TxStatsHist_id"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS = "ether_TxStatsHist_jumboPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_TxStatsHist_jumboPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_TxStatsHist_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_TxStatsHist_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_TxStatsHist_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_MOST_RECENT = "ether_TxStatsHist_mostRecent"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS = "ether_TxStatsHist_multicastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_TxStatsHist_multicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_SUSPECT = "ether_TxStatsHist_suspect"
    SORT_PROP_ETHER_TX_STATS_HIST_THRESHOLDED = "ether_TxStatsHist_thresholded"
    SORT_PROP_ETHER_TX_STATS_HIST_TIME_COLLECTED = "ether_TxStatsHist_timeCollected"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES = "ether_TxStatsHist_totalBytes"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_TxStatsHist_totalBytesDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_TxStatsHist_totalBytesDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_TxStatsHist_totalBytesDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_TxStatsHist_totalBytesDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS = "ether_TxStatsHist_totalPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_TxStatsHist_totalPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_TxStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_TxStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_TxStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS = "ether_TxStatsHist_unicastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_TxStatsHist_unicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS = "ether_TxStats_broadcastPackets"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA = "ether_TxStats_broadcastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStats_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStats_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_INTERVALS = "ether_TxStats_intervals"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS = "ether_TxStats_jumboPackets"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA = "ether_TxStats_jumboPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_TxStats_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_TxStats_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_TxStats_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS = "ether_TxStats_multicastPackets"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA = "ether_TxStats_multicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStats_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStats_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStats_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_SUSPECT = "ether_TxStats_suspect"
    SORT_PROP_ETHER_TX_STATS_THRESHOLDED = "ether_TxStats_thresholded"
    SORT_PROP_ETHER_TX_STATS_TIME_COLLECTED = "ether_TxStats_timeCollected"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES = "ether_TxStats_totalBytes"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA = "ether_TxStats_totalBytesDelta"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_TxStats_totalBytesDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_TxStats_totalBytesDeltaMax"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_TxStats_totalBytesDeltaMin"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS = "ether_TxStats_totalPackets"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA = "ether_TxStats_totalPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_TxStats_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_TxStats_totalPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_TxStats_totalPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS = "ether_TxStats_unicastPackets"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA = "ether_TxStats_unicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_TxStats_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_TxStats_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_TxStats_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_UPDATE = "ether_TxStats_update"
    SORT_PROP_EVENT_EP_CTRL_LEVEL = "event_EpCtrl_level"
    SORT_PROP_EVENT_EP_CTRL_REVERT_TIMEOUT = "event_EpCtrl_revertTimeout"
    SORT_PROP_EVENT_HOLDER_NAME = "event_Holder_name"
    SORT_PROP_EVENT_INST_CAUSE = "event_Inst_cause"
    SORT_PROP_EVENT_INST_CHANGE_SET = "event_Inst_changeSet"
    SORT_PROP_EVENT_INST_CODE = "event_Inst_code"
    SORT_PROP_EVENT_INST_CREATED = "event_Inst_created"
    SORT_PROP_EVENT_INST_DESCR = "event_Inst_descr"
    SORT_PROP_EVENT_INST_ID = "event_Inst_id"
    SORT_PROP_EVENT_INST_RULE = "event_Inst_rule"
    SORT_PROP_EVENT_INST_SEVERITY = "event_Inst_severity"
    SORT_PROP_EVENT_INST_TAGS = "event_Inst_tags"
    SORT_PROP_EVENT_INST_TYPE = "event_Inst_type"
    SORT_PROP_EVENT_LOG_MAX_SIZE = "event_Log_maxSize"
    SORT_PROP_EVENT_LOG_PURGE_WINDOW = "event_Log_purgeWindow"
    SORT_PROP_EVENT_LOG_SIZE = "event_Log_size"
    SORT_PROP_EVENT_POLICY_DESCR = "event_Policy_descr"
    SORT_PROP_EVENT_POLICY_INT_ID = "event_Policy_intId"
    SORT_PROP_EVENT_POLICY_NAME = "event_Policy_name"
    SORT_PROP_EVENT_POLICY_PINNING_EXPIRATION_INTERVAL = "event_Policy_pinningExpirationInterval"
    SORT_PROP_EVENT_POLICY_POLICY_LEVEL = "event_Policy_policyLevel"
    SORT_PROP_EVENT_POLICY_POLICY_OWNER = "event_Policy_policyOwner"
    SOR