from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="RespondToNewPasswordRequiredChallengeRequest")


@attr.s(auto_attribs=True)
class RespondToNewPasswordRequiredChallengeRequest:
    """
    Attributes:
        user_id (str):
        session (str):
        new_password (str):
    """

    user_id: str
    session: str
    new_password: str
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        user_id = self.user_id
        session = self.session
        new_password = self.new_password

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "userId": user_id,
                "session": session,
                "newPassword": new_password,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        user_id = d.pop("userId")

        session = d.pop("session")

        new_password = d.pop("newPassword")

        respond_to_new_password_required_challenge_request = cls(
            user_id=user_id,
            session=session,
            new_password=new_password,
        )

        respond_to_new_password_required_challenge_request.additional_properties = d
        return respond_to_new_password_required_challenge_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
