import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

import attr
from dateutil.parser import isoparse

from ..models.interval_event_filter_event_types_item import IntervalEventFilterEventTypesItem
from ..models.interval_event_filter_interval import IntervalEventFilterInterval
from ..models.interval_event_filter_severities_item import IntervalEventFilterSeveritiesItem
from ..models.interval_event_filter_types_item import IntervalEventFilterTypesItem
from ..types import UNSET, Unset

T = TypeVar("T", bound="IntervalEventFilter")


@attr.s(auto_attribs=True)
class IntervalEventFilter:
    """
    Attributes:
        interval (IntervalEventFilterInterval):
        timezone_offset_minutes (int):
        agent_ids (Union[Unset, List[str]]):
        device_ids (Union[Unset, List[str]]):
        names (Union[Unset, List[str]]):
        types (Union[Unset, List[IntervalEventFilterTypesItem]]):
        tags (Union[Unset, Any]):
        not_names (Union[Unset, List[str]]):
        id (Union[Unset, str]):
        viewed (Union[Unset, bool]):
        keyword (Union[Unset, str]):
        message (Union[Unset, str]):
        start (Union[Unset, datetime.datetime]):
        end (Union[Unset, datetime.datetime]):
        event_types (Union[Unset, List[IntervalEventFilterEventTypesItem]]):
        notification_enabled (Union[Unset, bool]):
        user_ids (Union[Unset, List[str]]):
        annotation_template_ids (Union[Unset, List[str]]):
        disable_null_matches (Union[Unset, bool]):
        severities (Union[Unset, List[IntervalEventFilterSeveritiesItem]]):
    """

    interval: IntervalEventFilterInterval
    timezone_offset_minutes: int
    agent_ids: Union[Unset, List[str]] = UNSET
    device_ids: Union[Unset, List[str]] = UNSET
    names: Union[Unset, List[str]] = UNSET
    types: Union[Unset, List[IntervalEventFilterTypesItem]] = UNSET
    tags: Union[Unset, Any] = UNSET
    not_names: Union[Unset, List[str]] = UNSET
    id: Union[Unset, str] = UNSET
    viewed: Union[Unset, bool] = UNSET
    keyword: Union[Unset, str] = UNSET
    message: Union[Unset, str] = UNSET
    start: Union[Unset, datetime.datetime] = UNSET
    end: Union[Unset, datetime.datetime] = UNSET
    event_types: Union[Unset, List[IntervalEventFilterEventTypesItem]] = UNSET
    notification_enabled: Union[Unset, bool] = UNSET
    user_ids: Union[Unset, List[str]] = UNSET
    annotation_template_ids: Union[Unset, List[str]] = UNSET
    disable_null_matches: Union[Unset, bool] = UNSET
    severities: Union[Unset, List[IntervalEventFilterSeveritiesItem]] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        interval = self.interval.value

        timezone_offset_minutes = self.timezone_offset_minutes
        agent_ids: Union[Unset, List[str]] = UNSET
        if not isinstance(self.agent_ids, Unset):
            agent_ids = self.agent_ids

        device_ids: Union[Unset, List[str]] = UNSET
        if not isinstance(self.device_ids, Unset):
            device_ids = self.device_ids

        names: Union[Unset, List[str]] = UNSET
        if not isinstance(self.names, Unset):
            names = self.names

        types: Union[Unset, List[str]] = UNSET
        if not isinstance(self.types, Unset):
            types = []
            for types_item_data in self.types:
                types_item = types_item_data.value

                types.append(types_item)

        tags = self.tags
        not_names: Union[Unset, List[str]] = UNSET
        if not isinstance(self.not_names, Unset):
            not_names = self.not_names

        id = self.id
        viewed = self.viewed
        keyword = self.keyword
        message = self.message
        start: Union[Unset, str] = UNSET
        if not isinstance(self.start, Unset):
            start = self.start.isoformat()

        end: Union[Unset, str] = UNSET
        if not isinstance(self.end, Unset):
            end = self.end.isoformat()

        event_types: Union[Unset, List[str]] = UNSET
        if not isinstance(self.event_types, Unset):
            event_types = []
            for event_types_item_data in self.event_types:
                event_types_item = event_types_item_data.value

                event_types.append(event_types_item)

        notification_enabled = self.notification_enabled
        user_ids: Union[Unset, List[str]] = UNSET
        if not isinstance(self.user_ids, Unset):
            user_ids = self.user_ids

        annotation_template_ids: Union[Unset, List[str]] = UNSET
        if not isinstance(self.annotation_template_ids, Unset):
            annotation_template_ids = self.annotation_template_ids

        disable_null_matches = self.disable_null_matches
        severities: Union[Unset, List[str]] = UNSET
        if not isinstance(self.severities, Unset):
            severities = []
            for severities_item_data in self.severities:
                severities_item = severities_item_data.value

                severities.append(severities_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "interval": interval,
                "timezoneOffsetMinutes": timezone_offset_minutes,
            }
        )
        if agent_ids is not UNSET:
            field_dict["agentIds"] = agent_ids
        if device_ids is not UNSET:
            field_dict["deviceIds"] = device_ids
        if names is not UNSET:
            field_dict["names"] = names
        if types is not UNSET:
            field_dict["types"] = types
        if tags is not UNSET:
            field_dict["tags"] = tags
        if not_names is not UNSET:
            field_dict["notNames"] = not_names
        if id is not UNSET:
            field_dict["id"] = id
        if viewed is not UNSET:
            field_dict["viewed"] = viewed
        if keyword is not UNSET:
            field_dict["keyword"] = keyword
        if message is not UNSET:
            field_dict["message"] = message
        if start is not UNSET:
            field_dict["start"] = start
        if end is not UNSET:
            field_dict["end"] = end
        if event_types is not UNSET:
            field_dict["eventTypes"] = event_types
        if notification_enabled is not UNSET:
            field_dict["notificationEnabled"] = notification_enabled
        if user_ids is not UNSET:
            field_dict["userIds"] = user_ids
        if annotation_template_ids is not UNSET:
            field_dict["annotationTemplateIds"] = annotation_template_ids
        if disable_null_matches is not UNSET:
            field_dict["disableNullMatches"] = disable_null_matches
        if severities is not UNSET:
            field_dict["severities"] = severities

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        interval = IntervalEventFilterInterval(d.pop("interval"))

        timezone_offset_minutes = d.pop("timezoneOffsetMinutes")

        agent_ids = cast(List[str], d.pop("agentIds", UNSET))

        device_ids = cast(List[str], d.pop("deviceIds", UNSET))

        names = cast(List[str], d.pop("names", UNSET))

        types = []
        _types = d.pop("types", UNSET)
        for types_item_data in _types or []:
            types_item = IntervalEventFilterTypesItem(types_item_data)

            types.append(types_item)

        tags = d.pop("tags", UNSET)

        not_names = cast(List[str], d.pop("notNames", UNSET))

        id = d.pop("id", UNSET)

        viewed = d.pop("viewed", UNSET)

        keyword = d.pop("keyword", UNSET)

        message = d.pop("message", UNSET)

        _start = d.pop("start", UNSET)
        start: Union[Unset, datetime.datetime]
        if isinstance(_start, Unset):
            start = UNSET
        else:
            start = isoparse(_start)

        _end = d.pop("end", UNSET)
        end: Union[Unset, datetime.datetime]
        if isinstance(_end, Unset):
            end = UNSET
        else:
            end = isoparse(_end)

        event_types = []
        _event_types = d.pop("eventTypes", UNSET)
        for event_types_item_data in _event_types or []:
            event_types_item = IntervalEventFilterEventTypesItem(event_types_item_data)

            event_types.append(event_types_item)

        notification_enabled = d.pop("notificationEnabled", UNSET)

        user_ids = cast(List[str], d.pop("userIds", UNSET))

        annotation_template_ids = cast(List[str], d.pop("annotationTemplateIds", UNSET))

        disable_null_matches = d.pop("disableNullMatches", UNSET)

        severities = []
        _severities = d.pop("severities", UNSET)
        for severities_item_data in _severities or []:
            severities_item = IntervalEventFilterSeveritiesItem(severities_item_data)

            severities.append(severities_item)

        interval_event_filter = cls(
            interval=interval,
            timezone_offset_minutes=timezone_offset_minutes,
            agent_ids=agent_ids,
            device_ids=device_ids,
            names=names,
            types=types,
            tags=tags,
            not_names=not_names,
            id=id,
            viewed=viewed,
            keyword=keyword,
            message=message,
            start=start,
            end=end,
            event_types=event_types,
            notification_enabled=notification_enabled,
            user_ids=user_ids,
            annotation_template_ids=annotation_template_ids,
            disable_null_matches=disable_null_matches,
            severities=severities,
        )

        interval_event_filter.additional_properties = d
        return interval_event_filter

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
