from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="GeoJsonIcon")


@attr.s(auto_attribs=True)
class GeoJsonIcon:
    """
    Attributes:
        icon_id (str):
        url (str):
    """

    icon_id: str
    url: str
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        icon_id = self.icon_id
        url = self.url

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "iconId": icon_id,
                "url": url,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        icon_id = d.pop("iconId")

        url = d.pop("url")

        geo_json_icon = cls(
            icon_id=icon_id,
            url=url,
        )

        geo_json_icon.additional_properties = d
        return geo_json_icon

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
